<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/

// +----------------------------------------------------------------------+

// | PHP version 4/5                                                      |

// +----------------------------------------------------------------------+

// | Copyright (c) 2004-2010 ARMIA INC                                    |

// +----------------------------------------------------------------------+

// | This source file is a part of iScripts VistaCart                     |

// +----------------------------------------------------------------------+

// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |

// +----------------------------------------------------------------------+

class HomelayoutController extends AppController

{

    var $name = "Homelayout";

    var $helpers = array('Html', 'Form','Javascript'); 

	var $uses = array('Homelayout','Report');   

	

    function index()
    {
        $this->__validateLoginStatus();		
        $cnfg 				=	Configure::read('Neutrino');
        $style				=	$cnfg["style"];
        $this->set('style', "admin/".$style);

		$layouttbl=$this->Report->getTableName("homelayouts");

		$layouttbl=trim(str_replace('`','',$layouttbl));		

		$middle_sec		=	$this->Homelayout->getLayout('middle');
              
                //print '<pre />';print_r($middle_sec);
		$right_sec		=	$this->Homelayout->getLayout('right');

                $unlisted_rec           =	$this->Homelayout->getLayout('');
                
		$featured_status=   $this->Homelayout->getStatus('featured');

		$toprated_status=   $this->Homelayout->getStatus('toprated');

		$onsale_status  =   $this->Homelayout->getStatus('onsale');

		$latest_status  =   $this->Homelayout->getStatus('latest');

		$this->set('featured',$featured_status);

		$this->set('toprated',$toprated_status);

		$this->set('onsale',$onsale_status);

		$this->set('latest',$latest_status);

		$this->set('middle_sec',$middle_sec);

		$this->set('right_sec',$right_sec);

                $this->set('unlisted_rec',$unlisted_rec);
                
		$this->set('tblindex',$layouttbl);
                
		$this->layout = 'adm';

    } 

	

   function beforeFilter()

    {

        //$this->__validateLoginStatus();

    }

	function beforeRender()

    {

        if (isset($this->Setting) && !empty($this->Setting->table))  

        {  

             $this->Setting->load();  

        } 

		global $sitefolder; 

		global $meta_description;

		global $meta_keywords;

		global $page_title;

		$cnfg 				=	Configure::read('Neutrino');

		$sitefolder			=	$cnfg["sitebasefolder"];

		$meta_description	=	$cnfg["meta_description"];

		$meta_keywords		=	$cnfg["meta_keywords"];

		$page_title			=	$cnfg["page_title"];

		global $style; 

		$style				=	$cnfg["style"];

		$this->set('style', $style);

		$this->set('meta_description', $meta_description);

		$this->set('meta_keywords', $meta_keywords);

		$this->pageTitle = $page_title	; 

		$this->set('cnfg',$cnfg);

    }

    function __validateLoginStatus()
    {

            if($this->Session->check('Admin') == false)

            {

                 $this->redirect(array('controller' => 'admins', 'action' => 'login')); 

                 $this->Session->setFlash(__('The URL you\'ve followed requires you login.'));

            }

    }  	

	

	//Ajax Function

	function updatestatus($arg,$newstatus)

	{

	    $this->layout = null; 

		$this->__validateLoginStatus();

		$admsess	=	$this->Session->read('Admin');

		if($admsess["homepage"] <> 1){

			$this->redirect(array('controller' => 'admins', 'action' => 'index')); 

			exit();

		}			

	    $this->Homelayout->updateBlockStatus($arg,strtolower($newstatus));		

	}

	

	//Ajax Function

	function enableall($middle='',$right='')

	{

	    $this->layout = null; 

		$this->__validateLoginStatus();

		$admsess	=	$this->Session->read('Admin');

		if($admsess["homepage"] <> 1){

			$this->redirect(array('controller' => 'admins', 'action' => 'index')); 

			exit();

		}			

		

	   $mdl_cnts='';$rght_cnts='';

	   if(isset($middle) && $middle!='')  $middle=explode(",",$middle);

	   if(isset($right) && $right!='') $right=explode(",",$right);

	   if(isset($middle[0])) {

		   foreach($middle as $val)

		   {

			 if(trim($val)<>'')

			 $middle_contents[]=$val;

		   }	

	   }

	   if(isset($right[0])) {	   

		   foreach($right as $val)

		   {

			 if($val<>'')

			 $right_contents[]=$val;

		   }	 

	   }

	   if(isset($middle_contents))$mdl_cnts=implode(",",$middle_contents); 

	   if(isset($right_contents))$rght_cnts=implode(",",$right_contents);

       $this->Homelayout->updateLayout($mdl_cnts,$rght_cnts);		

	}

        function savepreferences(){
            $msg = NULL;
            $layoutValArr = array();
            $layoutvalues = (isset($_POST['layout_vals'])) ? $_POST['layout_vals'] : '';
            if(!empty($layoutvalues)){
                $layoutValArr = explode("||",$layoutvalues);  // L#featured||L#toprated||C#latest||C#onsale||
                
                foreach($layoutValArr as $item){
                    if(!empty($item)){
                        $itemArr = array();
                        $itemArr= explode("#",$item);
                        
                        $itemArr[0]; // Pane
                        $itemArr[1]; // Product Type
                        $itemArr[2]; // Order

                        $prodType = $status = $section = $order =  NULL;
                        $prodType = $itemArr[1];
                        $order = $itemArr[2];
                        switch($itemArr[0]){
                            case 'L':
                                $section = 'middle';
                                $status = 'Y';
                                break;
                            case 'C':
                                $section = 'right';
                                $status = 'Y';
                                break;
                            case 'U':
                                $section = '';
                                $status = 'N';
                                break;

                        }
                        $this->Homelayout->updateBlockItem($prodType,$status,$section,$order);
                    } // End If
                } // End Foreach
                
              $msg = 'saved';

            } // End If

            echo $msg;

            Configure::write('debug', 0);
            $this->layout = null;
            exit();
        }

}

?>