/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.utilities;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class ImageUtility {
    public static BufferedImage read(InputStream in) throws IOException {
        BufferedImage image = null;
        image = ImageIO.read(in);
        if (image == null) {
            throw new IOException("Read fails");
        }
        return image;
    }

    public static BufferedImage read(byte[] bytes) {
        try {
            return ImageUtility.read(new ByteArrayInputStream(bytes));
        }
        catch (IOException e) {
            e.getStackTrace();
            return null;
        }
    }

    public static void write(BufferedImage image, float quality, OutputStream out) throws IOException {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersBySuffix("jpeg");
        if (!writers.hasNext()) {
            throw new IllegalStateException("No writers found");
        }
        ImageWriter writer = writers.next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(out);
        writer.setOutput(ios);
        ImageWriteParam param = writer.getDefaultWriteParam();
        if (quality >= 0.0f) {
            param.setCompressionMode(2);
            param.setCompressionQuality(quality);
        }
        writer.write(null, new IIOImage(image, null, null), param);
        ios.close();
        writer.dispose();
    }

    public static byte[] toByteArray(BufferedImage image, float quality) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (quality == -1.0f) {
                ImageIO.write((RenderedImage)image, "jpeg", out);
            } else {
                ImageUtility.write(image, quality, out);
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static BufferedImage compress(BufferedImage image, float quality) {
        return ImageUtility.read(ImageUtility.toByteArray(image, quality));
    }

    static {
        ImageIO.setUseCache(false);
    }
}

