/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.server.rmi;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import jrdesktop.server.Config;

public class MultihomeRMIClientSocketFactory
implements RMIClientSocketFactory,
Serializable {
    private static final long serialVersionUID = 7033753601964541325L;
    private final RMIClientSocketFactory factory;
    private String[] hosts;

    public MultihomeRMIClientSocketFactory(RMIClientSocketFactory wrapped, String[] hosts) {
        this.hosts = hosts;
        this.factory = wrapped;
    }

    public Socket createSocket(String hostString, int port) throws IOException {
        SocketChannel channel;
        if (this.hosts.length < 2) {
            Config.server_address = hostString;
            return this.factory().createSocket(hostString, port);
        }
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        Selector selector = Selector.open();
        for (String host : this.hosts) {
            channel = SocketChannel.open();
            channel.configureBlocking(false);
            channel.register(selector, 8);
            InetSocketAddress addr = new InetSocketAddress(host, port);
            channel.connect(addr);
        }
        SocketChannel connectedChannel = null;
        block3: while (true) {
            if (selector.keys().isEmpty()) {
                throw new IOException("Connection failed for " + hostString + ": " + exceptions);
            }
            selector.select();
            Set<SelectionKey> keys = selector.selectedKeys();
            if (keys.isEmpty()) {
                throw new IOException("Selection keys unexpectedly empty for " + hostString + "[exceptions: " + exceptions + "]");
            }
            Iterator<SelectionKey> i$ = keys.iterator();
            while (true) {
                if (!i$.hasNext()) continue block3;
                SelectionKey key = i$.next();
                channel = (SocketChannel)key.channel();
                key.cancel();
                try {
                    channel.configureBlocking(true);
                    channel.finishConnect();
                    connectedChannel = channel;
                    break block3;
                }
                catch (IOException e) {
                    exceptions.add(e);
                    continue;
                }
                break;
            }
            break;
        }
        assert (connectedChannel != null);
        for (SelectionKey key : selector.keys()) {
            SelectableChannel channel2 = key.channel();
            if (channel2 == connectedChannel) continue;
            channel2.close();
        }
        Socket socket = connectedChannel.socket();
        if (this.factory == null && RMISocketFactory.getSocketFactory() == null) {
            Config.server_address = socket.getInetAddress().getHostAddress();
            return socket;
        }
        Config.server_address = hostString = socket.getInetAddress().getHostAddress();
        socket.close();
        return this.factory().createSocket(hostString, port);
    }

    private RMIClientSocketFactory factory() {
        if (this.factory != null) {
            return this.factory;
        }
        RMISocketFactory f = RMISocketFactory.getSocketFactory();
        if (f != null) {
            return f;
        }
        return RMISocketFactory.getDefaultSocketFactory();
    }

    public boolean equals(Object x) {
        if (x.getClass() != this.getClass()) {
            return false;
        }
        MultihomeRMIClientSocketFactory f = (MultihomeRMIClientSocketFactory)x;
        return this.factory == null ? f.factory == null : this.factory.equals(f.factory);
    }

    public int hashCode() {
        int h = this.getClass().hashCode();
        if (this.factory != null) {
            h += this.factory.hashCode();
        }
        return h;
    }
}

