<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2010 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts VistaCart                     |
// +----------------------------------------------------------------------+
// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |
?>
<?php echo $html->css('tooltip.css'); ?>
<?php echo $javascript->link('admin/jquery.js'); ?>
<?php echo $javascript->link('hint.js'); ?> 
<?php echo $javascript->link('tooltip.js'); ?>
<?php echo $javascript->link('admin/tooltip_image.js'); ?>

<script language="JavaScript" type="text/JavaScript">
function clickSearch(){
    document.frmUsers.submit();
}
function updateVariantStock(variant_detail_id){   
    var stock; 
    /* Current web page pagination number */
    var page_number = '';
    var page_number_det = '';
    var curr_url;
    var arrUrl      =  new Array();
    var arrPageNum  =  new Array();
    
    curr_url        = window.location.href;   
    if(curr_url != ""){
        arrUrl          = curr_url.split("/");
        
        if(arrUrl[8] != "" && arrUrl[8] != undefined){
            page_number_det = arrUrl[8];

            if(page_number_det != ""){
                arrPageNum      = page_number_det.split(":");
                page_number     = arrPageNum[1];
            }
        }
    }
    
    stock       = $('#stock'+variant_detail_id).val(); 
    url_portion = "<?php echo $sitebase.$sitefolder; ?>/Products/";
    window.location = url_portion+"updateProductVariantStock/"+variant_detail_id+"/"+stock+"/"+page_number;    
}
</script>
<style type="text/css">
#tooltip{
    text-align: center;
    color: #fff;
    background: #111;
    position: absolute;
    z-index: 100;
    padding: 15px;
}
#tooltip:after{/* triangle decoration */
    width: 0;
    height: 0;
    border-left: 10px solid transparent;
    border-right: 10px solid transparent;
    border-top: 10px solid #111;
    content: '';
    position: absolute;
    left: 50%;
    bottom: -10px;
    margin-left: -10px;
}

#tooltip.top:after{
    border-top-color: transparent;
    border-bottom: 10px solid #111;
    top: -20px;
    bottom: auto;
}
#tooltip.left:after{
    left: 10px;
    margin: 0;
}
#tooltip.right:after{
    right: 10px;
    left: auto;
    margin: 0;
}
.subhead{
    font-weight: bold;
    /*color:#00749a;*/
    color:#27ade6;
}
#screenshot{
    position:absolute;
    border:1px solid #ccc;
    background:#333;
    padding:5px;
    display:none;
    color:#fff;
}
</style>
<script type="text/javascript">
$(function(){
    var targets = $( '[rel~=tooltip]' ),
        target  = false,
        tooltip = false,
        title   = false;
 
    targets.bind( 'mouseenter', function()
    {
        target  = $( this );
        tip     = target.attr( 'title' );
        tooltip = $( '<div id="tooltip"></div>' );
 
        if( !tip || tip == '' )
            return false;
 
        target.removeAttr( 'title' );
        tooltip.css( 'opacity', 0 )
               .html( tip )
               .appendTo( 'body' );
 
        var init_tooltip = function()
        {
            if( $( window ).width() < tooltip.outerWidth() * 1.5 )
                tooltip.css( 'max-width', $( window ).width() / 2 );
            else
                tooltip.css( 'max-width', 340 );
 
            var pos_left = target.offset().left + ( target.outerWidth() / 2 ) - ( tooltip.outerWidth() / 2 ),
                pos_top  = target.offset().top - tooltip.outerHeight() - 20;
 
            if( pos_left < 0 )
            {
                pos_left = target.offset().left + target.outerWidth() / 2 - 20;
                tooltip.addClass( 'left' );
            }
            else
                tooltip.removeClass( 'left' );
 
            if( pos_left + tooltip.outerWidth() > $( window ).width() )
            {
                pos_left = target.offset().left - tooltip.outerWidth() + target.outerWidth() / 2 + 20;
                tooltip.addClass( 'right' );
            }
            else
                tooltip.removeClass( 'right' );
 
            if( pos_top < 0 )
            {
                var pos_top  = target.offset().top + target.outerHeight();
                tooltip.addClass( 'top' );
            }
            else
                tooltip.removeClass( 'top' );
 
            tooltip.css( { left: pos_left, top: pos_top } )
                   .animate( { top: '+=10', opacity: 1 }, 50 );
        };
 
        init_tooltip();
        $( window ).resize( init_tooltip );
 
        var remove_tooltip = function()
        {
            tooltip.animate( { top: '-=10', opacity: 0 }, 50, function()
            {
                $( this ).remove();
            });
 
            target.attr( 'title', tip );
        };
 
        target.bind( 'mouseleave', remove_tooltip );
        tooltip.bind( 'click', remove_tooltip );
    });
});
</script>

<section class="wrapper site-min-height">
        <?php if($session->check('Message.flash')){ ?>
        <div id="okbox"><?php $session->flash(); ?></div>
        <div class="clear">&nbsp;</div>
        <?php } ?> 
      <div class="col-lg-12">
        <section class="panel panel-custome">
            <div class="panel-heading" style="background-color:#27ade6; color:#fff;"> Product Inventory</div>
            <div class="panel-body">            
          <div class="form-group">   
            <form action="<?php echo $sitebase.$sitefolder.'/'.$this->params["controller"]."/".$this->params["action"]; ?>" method="get" name="frmUsers">
                <div class="col-lg-2">
                <div class="input-group m-bot15">
                    <select name="cmbSearchType"  class="form-control">
                    <option value="name" <?php if($cmbSearchType == "name" || $cmbSearchType == ""){ echo("selected"); } ?>>Variant Name</option>
                    <option value="sku" <?php if($cmbSearchType == "sku"){ echo("selected"); } ?>>SKU</option>
                    </select>                    
                </div>
            </div>
            <div class="col-lg-4">
                <div class="input-group m-bot15">
                    <input type="text" name="txtSearch" value="<?php  echo(htmlentities($txtSearch)); ?>" class="form-control" placeholder="Enter the details" autocomplete="off" required="">                                        
                    <span class="input-group-btn">
                        <button type="submit" class="btn btn-info">Search</button>                        
                    </span>                      
                </div>                
            </div>
            <div class="col-lg-1">
                <?php echo $html->link('<i class="icon-compass"></i> Clear','/Products/inventory',array('class' => 'btn btn-info','escape'=>false)); ?>
            </div>
            <div class="col-lg-5">
                
            </div>
            </form>
        </div> 
          
        <div class="table-responsive">            
            <table class="table table-striped table-custome table-bordered table-hover">                
              <thead class="alert-info">
                <tr>
                  <th width="5%">#</th>
                  <th width="25%"><?php echo $paginator->sort('Product Variant', 'variant_name'); ?></th>
                  <th width="20%"><?php echo $paginator->sort('SKU', 'inv_sku'); ?></th> 
                  <th width="20%"><?php echo $paginator->sort('Quantity', 'stock'); ?></th> 
                  <th width="20%">Update Quantity</th>    
                </tr>
              </thead>
              <tbody>
                <?php
                if(!empty($passedarg) && !isset($passedarg["page"]))								
                    $cnt=1;
                else if(!empty($passedarg) && $passedarg["page"]==1)
                    $cnt=1;
                else
                    $cnt=((($passedarg["page"]-1)*($passedarg["limit"]))+1);
                
                if(!empty($product)){
                    foreach ($product as $product){ 
                ?>               
                <tr>
                  <td><?php echo $cnt++;?></td>
                  <td>
                      <?php
                        if(trim($product['Products']['pname']) <> ""){
                            echo Sanitize::html($product['Products']['pname'])."<br/>";
                        }
                        $arrVariantName = array();
                        if(trim($product['productvariantdetails']['variant_value_id1']) <> ""){                            
                            $arrVariantName[] = trim($product['productvariantdetails']['variant_value_id1']);
                        }
                        if(trim($product['productvariantdetails']['variant_value_id2']) <> ""){                            
                            $arrVariantName[] = trim($product['productvariantdetails']['variant_value_id2']);
                        }
                        if(trim($product['productvariantdetails']['variant_value_id3']) <> ""){                            
                            $arrVariantName[] = trim($product['productvariantdetails']['variant_value_id3']);
                        }
                        if(is_array($arrVariantName) && count($arrVariantName)>0){
                            echo implode(" / ",$arrVariantName);
                        }
                        ?>
                  </td>
                  <td><?php echo Sanitize::html($product['productvariantdetails']['inv_sku']); ?></td>
                  <td><?php echo Sanitize::html($product['productvariantdetails']['stock']); ?></td>
                  <td>
                      <div class="form-group col-sm-3">  
                        <input type="text" name="stock<?php echo trim($product['productvariantdetails']['variant_detail_id']); ?>" id="stock<?php echo trim($product['productvariantdetails']['variant_detail_id']); ?>" class="form-control" value="<?php echo trim($product['productvariantdetails']['stock']); ?>" style="width:50px;" placeholder="Stock" autocomplete="off" />  
                      </div>
                      <div class="form-group col-sm-3">
                          <input type="button" value="Save" onclick="updateVariantStock('<?php echo $product['productvariantdetails']['variant_detail_id']; ?>');" class="btn btn-shadow btn-info btn-lg" style="height: 34px;box-shadow:none;font-size: 14px;padding-top:5px;" />
                      </div>
<!--                      <a href="" class="btn btn-shadow btn-info btn-lg">Save</a>-->
                  </td>
                </tr>
                <?php                 
                    }
                    ?>
                    <tr>
                        <td colspan="7" align="center">
                        <?php 
                        if($cmbSearchType <> '' &&  $txtSearch <> ''){
                            $paginator->options(array('url'=>array_merge(array('cmbSearchType'=>$cmbSearchType,'txtSearch'=>$txtSearch),$this->passedArgs)));                             
                        } 
                        echo $paginator->numbers(); ?>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $paginator->counter(); 
                        ?>	   
                        </td>
                    </tr>	
                    <?php 
                }else{
                ?>
                <tr>
                    <td colspan="7" align="center">Sorry no product variant(s) found!</td>
                </tr>
                <?php 
                }
                ?>                
              </tbody>
            </table>            
          </div>
        </div>
      </div>
    </section>
        
        