INSERT INTO `cms_groups` (`id`, `group_name`, `position`, `published`, `user_privilege`) VALUES
(1, 'General', 1, 1, 'all'),
(3, 'Configuration', 5, 1, 's'),
(9, 'Setup', 2, 1, 'all'),
(10, 'Contents', 2, 1, 'all');


INSERT INTO `dummy` (`num`) VALUES(0);
INSERT INTO `dummy` (`num`) VALUES(1);
INSERT INTO `dummy` (`num`) VALUES(2);
INSERT INTO `dummy` (`num`) VALUES(3);

INSERT INTO `cms_sections` (`id`, `group_id`, `section_name`, `section_alias`, `table_name`, `section_config`, `visibilty`, `display_order`, `user_privilege`) VALUES
(6, 1, 'Plans', 'plans', 'tbl_ProductServices', '{"customAction":"true","controller":"products","method":"listplans","module":"admin"}\r\n', '1', 8, 'all'),
(1, 3, 'Manage Groups', 'groups', 'cms_groups', '{\r\n"keyColumn":"id",\r\n"orderBy":{"id":"ASC"},\r\n"publishColumn":"published",\r\n"listColumns":["group_name","user_privilege"],\r\n"showColumns":["id","group_name","position","user_privilege"],\r\n"detailColumns":["id","group_name","position","user_privilege"],\r\n"detailHeaderColumns":["group_name"],\r\n"columns":{\r\n    "id":{"name":"ID","sortable":"true","editoptions":{"type":"hidden"}},\r\n    "group_name":{"name":"Group Name","sortable":"true","searchable":"searchable","editoptions":{"type":"textbox","label":"Group Name","class":"textbox"}},\r\n    "position":{"name":"Display Order","sortable":"true","editoptions":{"type":"textbox","label":"Display Order","class":"textbox"}},\r\n    "user_privilege":{"name":"Privilege","sortable":"true","searchable":"searchable","editoptions":{"type":"select","source":{"all":"All","s":"Superadmin"},"source_type":"array","label":"Privilege","class":"select","enumvalues":{"all":"All","s":"Superadmin"}}}\r\n    },\r\n"opertations":["add","edit","delete","view","publish"]\r\n}', '1', 2, 'all'),
(2, 3, 'Manage Sections', 'sections', 'cms_sections', '{\r\n"keyColumn":"id",\r\n"orderBy":{"id":"ASC"},\r\n"listColumns":["group_id","section_name","section_alias","visibilty","display_order"],\r\n"showColumns":["id","group_id","section_name","section_alias","table_name","section_config","visibilty","display_order"],\r\n"detailColumns":["id","group_id","section_name","section_alias","table_name","section_config","visibilty","display_order"],\r\n"detailHeaderColumns":["section_name"],\r\n"columns":{\r\n    "id":{"name":"ID","sortable":"true","editoptions":{"type":"hidden"}},\r\n    "group_id":{"name":"Group ID","sortable":"true","searchable":"searchable","editoptions":{"validations":["required"],"type":"select","source":"Cms::getAllGroups","source_type":"function","label":"Group Name","class":"select"},"external":"true","externalOptions":{"externalTable":"cms_groups","externalColumn":"id","externalShowColumn":"group_name"}},\r\n    "section_name":{"name":"Section Name","sortable":"true","searchable":"searchable","editoptions":{"validations":["required"],"type":"textbox","label":"Section Name","class":"textbox"}},\r\n    "section_alias":{"name":"Section Alias","sortable":"true","searchable":"searchable","editoptions":{"validations":["required"],"type":"textbox","label":"Section Alias","class":"textbox"}},\r\n    "table_name":{"name":"Table Name","editoptions":{"validations":["required"],"type":"textbox","label":"Table Name","class":"textbox"}},\r\n    "section_config":{"name":"Section Config","editoptions":{"validations":["required"],"type":"textarea","label":"Section Config","class":"textarea"}},\r\n    "visibilty":{"name":"Make Visible","sortable":"true","searchable":"searchable","editoptions":{"type":"checkbox","label":"Make Visible","class":"inline","default":"yes","enumvalues":{"1":"Visible","0":"Invisible"}}},\r\n    "display_order":{"name":"Display Order","sortable":"true","searchable":"searchable","editoptions":{"type":"textbox","label":"Display Order","class":"textbox"}}\r\n    },\r\n"opertations":["add","edit","delete","view","publish"]\r\n}', '1', 3, 'all'),
(3, 3, 'Manage Settings', 'manage_settings', 'tbl_cms_settings', '{\r\n"keyColumn":"id",\r\n"listColumns":["cms_set_name","cms_set_value"],\r\n"showColumns":["cms_set_name","cms_set_value"],\r\n"detailColumns":["id","cms_set_name","cms_set_value"],\r\n"detailHeaderColumns":["cms_set_name"],\r\n"columns":{\r\n    "id":{"name":"ID","sortable":"true","editoptions":{"type":"hidden"}},\r\n    "cms_set_name":{"name":"Name","sortable":"true","searchable":"searchable","editoptions":{"type":"disabled","label":"Name"}},\r\n    "cms_set_value":{"name":"Value","sortable":"true","searchable":"searchable","editoptions":{"type":"textbox","label":"Value","class":"textbox"}}\r\n},\r\n"opertations":["edit","view"]\r\n}', '1', 1, 'all'),
(17, 10, 'Admin Help', 'adminHelp', 'tbl_Help', '{\r\n    "keyColumn": "nId",\r\n"detailHeaderColumns":["vTitle"],\r\n    "orderBy": {\r\n        "vTitle": "ASC"\r\n    },\r\n    "where": "tbl_Help.eType=''Admin''",\r\n    "listColumns": [\r\n        "vTitle",\r\n        "eStatus"\r\n    ],\r\n    "showColumns": [\r\n        "nId",\r\n        "vTitle",\r\n        "tDescription",\r\n        "eType",\r\n        "eStatus"\r\n    ],\r\n    "detailColumns": [\r\n        "nId",\r\n        "vTitle",\r\n        "tDescription",\r\n        "eStatus",\r\n        "eType"\r\n    ],\r\n    "columns": {\r\n        "nId": {\r\n            "name": "ID"\r\n        },\r\n        "vTitle": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "tDescription": {\r\n            "name": "Description",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "htmlEditor",\r\n                "label": "Description"\r\n            }\r\n        },\r\n        "eType": {\r\n            "name": "Help Category",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "Admin": "Admin",\r\n                    "User": "User"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Category",\r\n                "enumvalues": {\r\n                    "Admin": "Admin",\r\n                    "User": "User"\r\n                }\r\n            }\r\n        },\r\n        "eStatus": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "Active": "Active",\r\n                    "Disabled": "Disabled"\r\n                },\r\n                "label": "Status",\r\n                "enumvalues": {\r\n                    "Active": "Active",\r\n                    "Disabled": "Disabled"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "edit",\r\n        "delete",\r\n        "view"\r\n    ]\r\n}', '1', 10, 'all'),
(7, 9, 'Settings', 'settings', ' tbl_Settings', '{"customAction":"true","controller":"module","method":"settingsdisplay","module":"admin"}\r\n', '1', 1, 'all'),
(8, 1, 'Users', 'user', 'tbl_User', '{\r\n    "keyColumn": "nUId",\r\n    "detailHeaderColumns": [\r\n        "vFirstName",\r\n        "vLastName"\r\n    ],\r\n    "detailHeaderColumnPrefix": "User: ",\r\n    "orderBy": {\r\n        "vFirstName": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "vFirstName",\r\n        "vLastName",\r\n        "vEmail",\r\n        "nStatus",\r\n        "plans"\r\n    ],\r\n    "detailColumns": [\r\n        "nUId",\r\n        "vFirstName",\r\n        "vLastName",\r\n        "vEmail",\r\n        "vInvoiceEmail",\r\n        "vAddress",\r\n        "vCity",\r\n        "vState",\r\n        "vCountry",\r\n        "vZipcode",\r\n        "vPhoneNumber",\r\n        "vFax",\r\n        "nStatus",\r\n        "plans"\r\n    ],\r\n    "showColumns": [\r\n        "nUId",\r\n        "vFirstName",\r\n        "vLastName",\r\n        "vEmail",\r\n        "vInvoiceEmail",\r\n        "vAddress",\r\n        "vCity",\r\n        "vState",\r\n        "vCountry",\r\n        "vZipcode",\r\n        "vPhoneNumber",\r\n        "vFax",\r\n        "nStatus"\r\n    ],\r\n    "columns": {\r\n        "nUId": {\r\n            "name": "ID"\r\n        },\r\n        "vFirstName": {\r\n            "name": "First Name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "First Name",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vLastName": {\r\n            "name": "Last Name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Last Name",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vEmail": {\r\n            "name": "Contact Email",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Contact Email",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vInvoiceEmail": {\r\n            "name": "Invoice Email",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Invoice Email",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vAddress": {\r\n            "name": "Address",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Address",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vCity": {\r\n            "name": "City",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "City",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vState": {\r\n            "name": "State",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "State",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vCountry": {\r\n            "name": "Country",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Country",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vZipcode": {\r\n            "name": "Zip Code",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Zip Code",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vPhoneNumber": {\r\n            "name": "Phone",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Phone",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vFax": {\r\n            "name": "Fax",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Fax",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "nStatus": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "2": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "2": "Inactive"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::changeUserStatus",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "2": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "1": "green",\r\n                    "2": "red"\r\n                }\r\n            }\r\n        },\r\n        "plans": {\r\n            "name": "Plans",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getCmsUserPlanDetails"\r\n        }\r\n    },\r\n    "customOperations": {\r\n        "login": {\r\n            "options": {\r\n                "target": "newtab",\r\n                "name": "Login",\r\n                "linkSource": "Admin::getuserLogInUrl"\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "add",\r\n        "delete"\r\n    ]\r\n}', '1', 7, 'all'),
(9, 1, 'Dashboard', 'dashboard', 'tbl_ProductLookup', '{\r\n    "dashboardPanel": "true",\r\n    "graphPanel": "true",\r\n    "graphpanelRow": "2",\r\n    "graphPanel1": {\r\n        "columns": "2",\r\n        "graph1": {\r\n            "type": "MSColumn3D",\r\n            "caption":"Total Domain Registrations",\r\n            "xAxisName":"Last 7 Days",\r\n             "yAxisName":"Domain Registaration Count",\r\n            "width":"480",\r\n             "height":"300",\r\n             "dataSetsCount":"2",\r\n             "dataSets":{"dataset1":{"name":"","color":"#D3AC4F","fetchValue":"Admin::getRegistredDomainCount"}}\r\n\r\n        },\r\n        "graph2": {\r\n            "type": "MSLine",\r\n             "caption":"Total Users",\r\n             "xAxisName":"Last 7 Days",\r\n             "yAxisName":"User Count",\r\n            "width":"480",\r\n             "height":"300",\r\n               "dataSetsCount":"1",\r\n              "dataSets":{"dataset1":{"name":"","color":"#D3AC4F","fetchValue":"Admin::getUsersCount"}}\r\n\r\n        }\r\n    },\r\n    "graphPanel2": {\r\n        "columns": "2",\r\n        "graph1": {\r\n            "type": "MSColumn3D",\r\n             "caption":"Total Stores Created",\r\n             "xAxisName":"Last 7 Days",\r\n             "yAxisName":"Store Count",\r\n            "width":"480",\r\n             "height":"300",\r\n               "dataSetsCount":"1",\r\n              "dataSets":{"dataset1":{"name":"","color":"#D3AC4F","fetchValue":"Admin::getStoresCount"}}\r\n        },\r\n        "graph2": {\r\n            "type": "MSColumn3D",\r\n             "caption":"Free Trials By Month",\r\n             "xAxisName":"Last 7 Days",\r\n             "yAxisName":"Free Trails Count",\r\n            "width":"480",\r\n             "height":"300",\r\n               "dataSetsCount":"1",\r\n              "dataSets":{"dataset1":{"name":"","color":"#D3AC4F","fetchValue":"Admin::getFreeTrialsCount"}}\r\n\r\n        }\r\n    }\r\n}', '1', 0, 'all'),
(10, 1, 'Invoices', 'invoice', 'tbl_Invoice', '{\r\n  "includeJsFiles": [\r\n    "dateformats.js"\r\n    ],\r\n    "keyColumn": "nInvId",\r\n    "orderBy": {\r\n        "dGeneratedDate": "DESC"\r\n    },\r\n    "detailHeaderColumns": ["vInvNo"],\r\n    "detailHeaderColumnPrefix": "Invoice: ",\r\n    "listColumns": [\r\n        "vInvNo",\r\n        "vSubscriptionType",\r\n        "nUId",\r\n        "dGeneratedDate",\r\n        "dDueDate",\r\n        "dPayment",\r\n        "pStatus",\r\n        "nTotal"\r\n    ],\r\n    "detailColumns": [\r\n        "nInvId",\r\n        "vInvNo",\r\n        "vSubscriptionType",\r\n        "vTxnId",\r\n        "nUId",\r\n        "dGeneratedDate",\r\n        "dDueDate",\r\n        "dPayment",\r\n        "pStatus",\r\n        "nTotal"\r\n    ],\r\n    "columns": {\r\n        "nInvId": {\r\n            "name": "ID"\r\n        },\r\n        "vInvNo": {\r\n            "name": "Invoice Number",\r\n            "sortable": "true",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getCmsInvoiceDetails"\r\n        },\r\n        "pStatus": {\r\n            "name": "Payment Status",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getPaymentStatus"\r\n        },\r\n\r\n        "vSubscriptionType": {\r\n            "name": "Subscription",\r\n            "searchable": "searchable",\r\n            "sortable": "true"\r\n        },\r\n        "vTxnId": {\r\n            "name": "Transaction ID"\r\n        },\r\n        "nUId": {\r\n            "name": "User",\r\n            "sortable": "true",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getUsernameFromInvoice"\r\n        },\r\n        "dGeneratedDate": {\r\n            "name": "Generated On",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "dbFormat": "timestamp",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n        "dDueDate": {\r\n            "name": "Due On",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "dbFormat": "timestamp",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n        "dPayment": {\r\n            "name": "Paid On",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getInvoicePaidDateForCMS"\r\n        },\r\n        "nTotal": {\r\n            "name": "Total Amount",\r\n            "searchable": "searchable",\r\n            "sortable": "true"\r\n            }\r\n    },\r\n    "opertations": [\r\n        "view"\r\n    ],\r\n    "report": {\r\n        "reportTitle": "Invoices",\r\n        "columns": [\r\n            "vInvNo",\r\n            "vSubscriptionType",\r\n            "vTxnId",\r\n            "nUId",\r\n            "dGeneratedDate",\r\n            "dDueDate",\r\n            "dPayment",\r\n            "pStatus",\r\n            "nTotal"\r\n        ],\r\n        "dateColumn": "dGeneratedDate"\r\n    }\r\n}', '1', 3, 'all'),
(40, 9, 'Screenshots', 'screenshots', 'tbl_DemoScreenshots', '{\r\n    "keyColumn": "nScreenId",\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "nScreenId": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "eType",       \r\n        "vScreenImageId",\r\n        "vActive"       \r\n    ],\r\n    "showColumns": [\r\n        "nScreenId",\r\n        "eType",        \r\n        "vScreenImageId",\r\n        "vActive"       \r\n    ],\r\n    "detailColumns": [\r\n        "nScreenId",\r\n        "eType",       \r\n        "vScreenImageId",\r\n        "vActive"        \r\n    ],\r\n    "columns": {\r\n        "eType": {\r\n            "name": "Screen Type",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "source": {\r\n                    "User": "User Panel Screen",\r\n                    "Admin": "Admin Panel Screen"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Screen Type",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "User": "User Panel Screen",\r\n                    "Admin": "Admin Panel Screen"\r\n                }\r\n            }\r\n        },               \r\n        "vScreenImageId": {\r\n            "name": "Screen Image",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Screen Image",\r\n                "class": "file",\r\n                "hint": "User Panel Screen : Ideal Width & Height - 400px X 231px <br> Admin Panel Screen : Ideal Width & Height - 400px X 231px"\r\n            },\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getCmsScreenImage"\r\n        },        \r\n        "vActive": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "checkbox",\r\n                "label": "Enable Screen",\r\n                "default": "yes",\r\n                "enumvalues": {\r\n                    "0": "Inactive",\r\n                    "1": "Active"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::changeScreenStatus",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "1": "green",\r\n                    "0": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "edit",\r\n        "delete",\r\n        "publish"\r\n    ]\r\n}', '1', 7, 'all'),
(12, 1, 'Feedback', 'feedback', 'tbl_contacts', '{\r\n    "keyColumn": "id",\r\n    "orderBy": {\r\n        "cdate": "ASC"\r\n    },\r\n    "detailHeaderColumns": ["cname"],\r\n    "detailHeaderColumnPrefix": "Feedback: ",\r\n    "listColumns": [\r\n        "cname",\r\n        "cemail",\r\n        "cdescr",\r\n        "cdate"\r\n    ],\r\n    "detailColumns": [\r\n        "id",\r\n        "cname",\r\n        "cemail",\r\n        "cdescr",\r\n        "cdate"\r\n    ],\r\n    "columns": {\r\n    "id":{"name":"ID"},\r\n        "cname": {\r\n            "name": "Customer",\r\n            "searchable": "searchable",\r\n            "sortable": "true"\r\n        },\r\n        "cemail": {\r\n            "name": "Email",\r\n            "searchable": "searchable",\r\n            "sortable": "true"\r\n        },\r\n        "cdescr": {\r\n            "name": "Feedbacks",\r\n            "sortable": "true"\r\n        },\r\n        "cdate": {\r\n            "name": "Date",\r\n            "sortable": "true",\r\n            "dbFormat":"datetime",\r\n            "displayFormat":"m/d/Y"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "delete"\r\n    ]\r\n}', '1', 6, 'all'),
(13, 9, 'Server Info', 'serverinfo', 'tbl_ServerInfo', '{\r\n    "keyColumn": "nserver_id",\r\n    "orderBy": {\r\n        "vserver_name": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "vserver_name",\r\n        "vmakethisserver_default",\r\n        "whm_port",\r\n        "cpanel_port"\r\n    ],\r\n    "showColumns": [\r\n        "nserver_id",\r\n        "vserver_name",\r\n        "whmuser",\r\n        "whmpass",\r\n        "whmip",\r\n        "vserver_hosting_plan",\r\n        "vserver_configfilename",\r\n        "vserver_configfilepath",\r\n\r\n        "whm_port",\r\n        "cpanel_port",\r\n\r\n        "vmakethisserver_default"\r\n    ],\r\n    "detailColumns": [\r\n        "nserver_id",\r\n        "vserver_name",\r\n        "whmuser",\r\n        "whmpass",\r\n        "whmip",\r\n        "vserver_hosting_plan",\r\n        "vserver_configfilename",\r\n        "vserver_configfilepath",\r\n\r\n        "whm_port",\r\n        "cpanel_port",\r\n\r\n        "vmakethisserver_default"\r\n    ],\r\n    "detailHeaderColumns": [\r\n        "vserver_name"\r\n    ],\r\n    "detailHeaderColumnPrefix": "Server Info: ",\r\n    "columns": {\r\n        "nserver_id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vserver_name": {\r\n            "name": "Server",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Server Name",\r\n                "class": "textbox",\r\n                "hint": "Enter your Host name eg: yoursitename.com"\r\n            }\r\n        },\r\n        "whmuser": {\r\n            "name": "WHM User",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "WHM User",\r\n                "class": "textbox",\r\n                 "hint": "Enter the WHM user name"\r\n            }\r\n        },\r\n        "whmpass": {\r\n            "name": "WHM Password",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "password",\r\n                "label": "WHM Password",\r\n"noEncryption" : "true",\r\n                "source":"Admincomponents::cipherPassword",           \r\n                "source_type":"function",\r\n                "class": "textbox",\r\n                 "hint": "Enter the WHM password"\r\n            }\r\n        },\r\n        "whmip": {\r\n            "name": "WHM IP",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "WHM IP",\r\n                "class": "textbox",\r\n                 "hint": "Enter WHM IP"\r\n            }\r\n        },\r\n        "vserver_hosting_plan": {\r\n            "name": "Server Package Name",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Server Package Name",\r\n                "class": "textbox",\r\n                 "hint": "Enter the server package name/ hosting package name"\r\n            }\r\n        },\r\n        "vserver_configfilename": {\r\n            "name": "Product Pack Location",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Product Pack Location",\r\n                "source":"Admincomponents::getDefaultPackLocation",\r\n                "source_type":"function",\r\n                "class": "textbox",\r\n                 "hint": "Enter the product pack locaton eg: /home/yourWHMusername/public_html/project/products/"\r\n            }\r\n        },\r\n        "vserver_configfilepath": {\r\n            "name": "Setup Landing Location",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Setup Landing Location",\r\n"source":"Admincomponents::getDefaultLandingLocation",\r\n                "source_type":"function",\r\n                "class": "textbox",\r\n                 "hint": "Enter the setup landing location eg: /public_html/"\r\n            }\r\n        },\r\n\r\n\r\n         "whm_port": {\r\n            "name": "WHM Port",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "WHM Port",\r\n                "class": "textbox",\r\n                 "hint": "Enter the WHM Port eg: 2086 / 2087(secure)"\r\n            }\r\n        },\r\n         "cpanel_port": {\r\n            "name": "CPanel Port",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "CPanel Port",\r\n                "class": "textbox",\r\n                 "hint": "Enter the CPanel Port eg : 2082 / 2083(secure)"\r\n            }\r\n        },\r\n\r\n\r\n\r\n\r\n        "vmakethisserver_default": {\r\n            "name": "Default Server",\r\n            "editoptions": {\r\n                "type": "checkbox",\r\n                "label": "Make Default Server",\r\n                "class": "inline",\r\n                 "hint": "Check this to enable this as default server",\r\n                "default": "NO",\r\n                "enumvalues": {\r\n                    "1": "YES",\r\n                    "0": "NO"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::getServerDefaultUrl",\r\n                "enumvalues": {\r\n                    "1": "YES",\r\n                    "0": "NO"\r\n                },\r\n                "buttonColors": {\r\n                    "1": "green",\r\n                    "0": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "customActions": {\r\n        "afterEditRecord": "Admincomponents::updateDomainStatus",\r\n        "afterAddRecord": "Admincomponents::updateDomainStatus"\r\n    },\r\n    "opertations": [\r\n        "add",\r\n      "edit",\r\n"delete"\r\n\r\n    ]\r\n}', '1', 5, 'all'),
(14, 1, 'Plan Features', 'product_service_features', 'tbl_ServiceFeatures', '{\r\n"keyColumn": "nFeatureId",\r\n"orderBy": {\r\n    "nFeatureId": "DESC"\r\n},\r\n"detailHeaderColumns": ["tFeatureName"],\r\n"detailHeaderColumnPrefix": "Plan Feature: ",\r\n"listColumns": [\r\n    "tFeatureName",\r\n    "tValue",\r\n    "eStatus"\r\n],\r\n"showColumns": [\r\n    "nFeatureId",\r\n    "tFeatureName",\r\n    "tValue",\r\n    "eStatus"\r\n],\r\n"detailColumns": [\r\n    "nFeatureId",\r\n    "tFeatureName",\r\n    "tValue",\r\n    "eStatus"\r\n],\r\n"columns": {\r\n    "nFeatureId": {\r\n        "name": "ID",\r\n        "editoptions": {\r\n            "type": "hidden"\r\n        }\r\n    },\r\n    "tFeatureName": {\r\n        "name": "Name",\r\n        "sortable": "true",\r\n        "editoptions": {\r\n            "validations": [\r\n                    "required"\r\n                ],\r\n            "type": "textbox",\r\n            "label": "Name"\r\n        }\r\n    },\r\n    "tValue": {\r\n        "name": "Value",\r\n        "sortable": "true",\r\n        "editoptions": {\r\n            "validations": [\r\n                    "required"\r\n                ],\r\n            "type": "textbox",\r\n            "label": "Value"\r\n        }\r\n    },\r\n    "eStatus": {\r\n        "name": "Status",\r\n        "editoptions": {\r\n            "validations": [\r\n                    "required"\r\n                ],\r\n            "type": "select",\r\n            "source": {\r\n            "Active": "Active",\r\n            "Disabled": "Inactive"\r\n            },\r\n            "source_type": "array",\r\n            "label": "Status",\r\n            "class": "select",\r\n            "enumvalues": {\r\n                "Active": "Active",\r\n                "Disabled": "Inactive"\r\n            }\r\n        },\r\n        "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::changeServiceFeatureStatus",\r\n                "enumvalues": {\r\n                    "Active": "Active",\r\n                    "Disabled": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "Active": "green",\r\n                    "Disabled": "red"\r\n                }\r\n            }\r\n\r\n    }\r\n},\r\n"opertations": [\r\n    "view",\r\n    "edit",\r\n    "add"\r\n    ]\r\n}', '0', 0, 'all'),
(16, 10, 'User Help ', 'userHelp', 'tbl_Help', '{\r\n    "keyColumn": "nId",\r\n"detailHeaderColumns":["vTitle"],\r\n    "orderBy": {\r\n        "vTitle": "ASC"\r\n    },\r\n    "where": "tbl_Help.eType=''User''",\r\n    "listColumns": [\r\n        "vTitle",\r\n        "eStatus"\r\n    ],\r\n    "showColumns": [\r\n        "nId",\r\n        "vTitle",\r\n        "tDescription",\r\n        "eType",\r\n        "eStatus"\r\n    ],\r\n    "detailColumns": [\r\n        "nId",\r\n        "vTitle",\r\n        "tDescription",\r\n        "eStatus",\r\n        "eType"\r\n    ],\r\n    "columns": {\r\n        "nId": {\r\n            "name": "ID"\r\n        },\r\n        "vTitle": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "tDescription": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "htmlEditor",\r\n                "label": "Description"\r\n            }\r\n        },\r\n        "eType": {\r\n            "name": "Help Category",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "Admin": "Admin",\r\n                    "User": "User"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Category",\r\n                "enumvalues": {\r\n                    "Admin": "Admin",\r\n                    "User": "User"\r\n                }\r\n            }\r\n        },\r\n        "eStatus": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "Active": "Active",\r\n                    "Disabled": "Disabled"\r\n                },\r\n                "label": "Status",\r\n                "enumvalues": {\r\n                    "Active": "Active",\r\n                    "Disabled": "Disabled"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "edit",\r\n        "delete",\r\n        "view"\r\n    ]\r\n}', '1', 9, 'all'),
(15, 1, 'Domains', 'domains', 'tbl_ProductLookup', '{\r\n    "keyColumn": "nPLId",\r\n    "dataSource": "external",\r\n    "dataSourceFunction": "Admincomponents::fetchDomaindata",\r\n    "dataSourceCountFunction": "Admincomponents::fetchDomaindataCount",\r\n    "detailHeaderColumns": [\r\n        "vDomain"\r\n    ],\r\n    "detailHeaderColumnPrefix": "Domain: ",\r\n    "listColumns": [\r\n        "vDomain",\r\n        "nUId",\r\n        "dDateStop",\r\n        "account_operations"\r\n    ],\r\n    "detailColumns": [\r\n        "nPLId",\r\n        "vDomain",\r\n        "nUId",\r\n       "dDateStop",\r\n        "account_operations"\r\n    ],\r\n    "columns": {\r\n        "nPLId": {\r\n            "name": "ID"\r\n        },\r\n        "vDomain": {\r\n            "name": "Domain",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getStoreHostWithAdminNav"\r\n        },\r\n        "nUId": {\r\n            "name": "User",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getUsername"\r\n        },\r\n        "dDateStop": {\r\n            "name": "Plan Expiry Date",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getPlanExpiryCms"\r\n        },\r\n         "account_operations": {\r\n            "name": "Account",\r\n"disableDetailedView":"false",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getAccountSuspendLink"\r\n            }\r\n    },\r\n    "opertations": [\r\n        "view"\r\n    ],\r\n    "includeJsFiles":["cmshelper.js"]\r\n\r\n}', '1', 5, 'all'),
(18, 1, 'Service History', 'orders', 'tbl_Invoice ', '{"customAction":"true","controller":"service","method":"index","module":"admin"}', '1', 2, 'all'),
(19, 10, 'Email Template', 'emailtemplates', 'tbl_Cms', '{\n    "keyColumn": "cms_id",\n    "orderBy": {\n        "cms_id": "ASC"\n    },\n    "where": "tbl_Cms.cms_type=''email_settings''",\n    "listColumns": [\n        "cms_name",\n        "cms_status"\n    ],\n    "showColumns": [\n        "cms_id",\n        "cms_name",\n        "cms_title",\n        "cms_desc",\n        "cms_status"\n    ],\n    "detailColumns": [\n        "cms_id",\n        "cms_name",\n        "cms_title",\n        "cms_desc",\n        "cms_status"\n    ],\n    "detailHeaderColumns": [\n        "cms_title"\n    ],\n    "columns": {\n        "cms_id": {\n            "name": "ID",\n            "sortable": "true",\n            "editoptions": {\n                "type": "hidden"\n            }\n        },\n        "cms_name": {\n            "name": "Name",\n            "sortable": "true",\n            "editoptions": {\n                "type": "hidden"\n            }\n        },\n        "cms_title": {\n            "name": "Title",\n            "sortable": "true",\n            "editoptions": {\n                "validations": [\n                    "required"\n                ],\n                "type": "textbox",\n                "label": "Title",\n                "class": "textbox"\n            }\n        },\n        "cms_desc": {\n            "name": "Content",\n            "sortable": "true",\n            "editoptions": {\n                "validations": [\n                    "required"\n                ],\n                "type": "htmlEditor",\n                "label": "Content",\n                "class": "textarea"\n            }\n        },\n        "cms_status": {\n            "name": "Status",\n            "editoptions": {\n                "type": "select",\n                "source": {\n                    "0": "Inactive",\n                    "1": "Active"\n                },\n                "source_type": "array",\n                "label": "Status",\n                "class": "select",\n                "enumvalues": {\n                    "0": "Inactive",\n                    "1": "Active"\n                }\n            }\n        }\n    },\n    "opertations": [\n        "edit"\n    ]\n}', '1', 5, 'all'),
(20, 9, 'Banner Management', 'bannerManagement', 'tbl_Banners', '{\r\n    "keyColumn": "nBannerId",\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "nBannerId": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "eType",\r\n        "vBannerUrl",\r\n        "vBannerText",\r\n        "vBannerImageId",\r\n        "vActive",\r\n        "showcount",\r\n        "clickcount",\r\n        "displayOrder"\r\n    ],\r\n    "showColumns": [\r\n        "nBannerId",\r\n        "eType",\r\n        "vBannerText",\r\n        "vBannerUrl",\r\n        "vBannerImageId",\r\n        "vActive",\r\n        "showcount",\r\n        "clickcount",\r\n        "displayOrder"\r\n    ],\r\n    "detailColumns": [\r\n        "nBannerId",\r\n        "eType",\r\n        "vBannerUrl",\r\n        "vBannerText",\r\n        "vBannerImageId",\r\n        "vActive",\r\n        "showcount",\r\n        "clickcount",\r\n        "displayOrder"\r\n    ],\r\n    "columns": {\r\n        "eType": {\r\n            "name": "Banner Type",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "source": {\r\n                    "Home Page Sliding Banner": "Home Page Sliding Banner",\r\n                    "Footer": "Footer"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Banner Type",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "Home Page Sliding Banner": "Home Page Sliding Banner",\r\n                    "Footer": "Footer"\r\n                }\r\n            }\r\n        },\r\n        "vBannerUrl": {\r\n            "name": "Banner Url",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Banner Url"\r\n            }\r\n        },\r\n        "vBannerText": {\r\n            "name": "Banner Text",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Banner Text"\r\n            }\r\n        },\r\n        "vBannerImageId": {\r\n            "name": "Banner Image",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],             \r\n                "type": "file",\r\n                "label": "Banner Image",\r\n                "class": "file",\r\n                "hint": "Home Page Sliding Banner should be with : Width & Height - 1250px X 400px <br> Footer should be with: Width & Height - 468px X 60px"\r\n            },\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getCmsBannerImage"\r\n        },\r\n        "showcount": {\r\n            "name": "Impressions",\r\n            "sortable": "true"\r\n        },\r\n        "clickcount": {\r\n            "name": "Click  Count",\r\n            "sortable": "true"\r\n        },\r\n        "displayOrder": {\r\n            "name": "Display  Order",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Display Order"\r\n            }\r\n        },\r\n        "vActive": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "checkbox",\r\n                "label": "Enable Banner",\r\n                "default": "yes",\r\n                "enumvalues": {\r\n                    "0": "Inactive",\r\n                    "1": "Active"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::changeBannerStatus",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "1": "green",\r\n                    "0": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "edit",\r\n        "delete",\r\n        "publish"\r\n    ]\r\n}', '1', 3, 'all'),
(21, 10, 'Email Scheduler', 'emailscheduler', 'tbl_EmailTemplatesMails', '{\r\n    "keyColumn": "nETMId",\r\n    "detailHeaderColumns": [\r\n        "vMailName"\r\n    ],\r\n    "detailHeaderColumnPrefix": "Email Scheduler: ",\r\n    "orderBy": {\r\n        "nETMId": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vMailName",\r\n        "nETID",\r\n        "tScheduleTime",\r\n        "eStatus",\r\n        "nMailMode"\r\n    ],\r\n    "detailColumns": [\r\n        "nETMId",\r\n        "vMailName",\r\n        "nETID",\r\n        "tScheduleTime",\r\n        "eStatus",\r\n        "nMailMode"\r\n    ],\r\n    "showColumns": [\r\n        "nETMId",\r\n        "vMailName",\r\n        "nETID",\r\n        "tScheduleTime",\r\n        "eStatus",\r\n        "nMailMode"\r\n    ],\r\n    "columns": {\r\n        "nETMId": {\r\n            "name": "ID",\r\n            "sortable": "true"\r\n        },\r\n        "vMailName": {\r\n            "name": "Mail Name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Mail Name",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "nETID": {\r\n            "name": "Email Template Name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": "Streamsendlogic::getemailTemplateList",\r\n                "source_type": "function",\r\n                "label": "Email Template Name",\r\n                "class": "select"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_EmailTemplates",\r\n                "externalColumn": "nETID",\r\n                "externalShowColumn": "vemailTemplateName"\r\n            }\r\n        },\r\n        "tScheduleTime": {\r\n            "name": "Schedule Time",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "datepicker",\r\n                "label": "Schedule Time",\r\n                "class": "datepicker",\n                "dbFormat": "datetime",\n                "displayFormat": "m/d/Y"\r\n            },\n                "dbFormat": "datetime",\n                "displayFormat": "m/d/Y"\r\n        },\r\n        "eStatus": {\r\n            "name": "Status",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "hidden",\r\n                "class": "hidden",\r\n                "value": "Active"\r\n                \r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::changeEmailSchedulerStatus",\r\n                "enumvalues": {\r\n                    "Active": "Active",\r\n                    "Deactive": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "Active": "green",\r\n                    "Deactive": "red"\r\n                }\r\n            }\r\n        },\r\n        "nMailMode": {\r\n            "name": "Mail Mode",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden",\r\n                "class": "hidden",\r\n                "value": "Streamsend"\r\n            }\r\n        }\r\n    },\r\n    "customActions": {\r\n        "afterAddRecord": "Streamsendlogic::setScheduleMail",\r\n        "afterEditRecord": "Streamsendlogic::setScheduleMailEdit"\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "add",\r\n        "delete"\r\n    ]\r\n}', '1', 2, 'all'),
(22, 1, 'Billing', 'billing', 'tbl_User', '{\r\n    "keyColumn": "nUId",\r\n    "orderBy": { "vFirstName": "ASC"},\r\n    "listColumns": ["vName","vEmail","vInvoiceEmail","vPlan","vStatus"],\r\n    "detailColumns": ["nUId","vName","vEmail","vInvoiceEmail","vPlan","vStatus"],\r\n    "columns": {\r\n        "nUId": {},\r\n        "vName": { "name": "Name","customColumn": "true","customaction": "User::getNameById"},\r\n        "vEmail": {"name": "Email","searchable": "searchable","sortable": "true"},\r\n        "vInvoiceEmail": {"name": "Invoice Email","searchable": "searchable","sortable": "true"},\r\n        "vPlan": {"name": "Plans","customColumn": "true","customaction": "Admincomponents::getUserPlansForCmsListing"},\r\n        "vStatus": {"name": "User Status","customColumn": "true","customaction": "User::getUserStatusById"}\r\n    },\r\n    "opertations": ["view"]\r\n}', '0', 4, 'all'),
(23, 1, 'User Plans', 'user_plans', 'tbl_ProductServices', '{"customAction":"true","controller":"products","method":"listuserplans","module":"admin"}', '0', 0, 'all'),
(24, 9, 'Paid Templates', 'paid_templates', 'tbl_PaidTemplates', '{\r\n    "keyColumn": "nTemplateId",\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "vTemplateName": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "vTemplateName",\r\n        "vTemplateZipId",\r\n        "vHomeScreenshotId",\r\n        "vInnerScreenshot1Id",\r\n        "vInnerScreenshot2Id",\r\n        "nCost",\r\n        "vActive"\r\n    ],\r\n    "showColumns": [\r\n        "nTemplateId",\r\n        "vTemplateName",\r\n        "vDescription",\r\n        "vTemplateZipId",\r\n        "vHomeScreenshotId",\r\n        "vInnerScreenshot1Id",\r\n        "vInnerScreenshot2Id",\r\n        "nCost",\r\n        "vActive"\r\n    ],\r\n    "detailColumns": [\r\n        "nTemplateId",\r\n        "vTemplateName",\r\n        "vDescription",\r\n        "vTemplateZipId",\r\n        "vHomeScreenshotId",\r\n        "vInnerScreenshot1Id",\r\n        "vInnerScreenshot2Id",\r\n        "nCost",\r\n        "vActive"\r\n    ],\r\n    "columns": {\r\n        "vTemplateName": {\r\n            "name": "Template Name",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Template Name"\r\n            }\r\n        },\r\n        "vDescription": {\r\n            "name": "Description",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Description"\r\n            }\r\n        },\r\n        "vTemplateZipId": {\r\n            "name": "Template Zip",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::downloadTemplateZip",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Template Zip",\r\n                "class": "file",\r\n                "hint": "Upload type : .zip file with folders img/TemplateName/ with images and css/ with TemplateName.css file"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n         "vHomeScreenshotId": {\r\n            "name": "Home Page Screenshot",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Home Page Screenshot",\r\n                "class": "file",\r\n                "hint": "Ideal size 295x235"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n         "vInnerScreenshot1Id": {\r\n            "name": "Inner Page Screenshot 1",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Inner Page Screenshot1",\r\n                "class": "file",\r\n                "hint": "Ideal size 295x235"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n         "vInnerScreenshot2Id": {\r\n            "name": "Inner Page Screenshot 2",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Inner Page Screenshot 2",\r\n                "class": "file",\r\n                "hint": "Ideal size 295x235"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "nCost": {\r\n            "name": "Price",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Price",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n                \r\n            }\r\n            \r\n        },\r\n        "vActive": {\r\n            "name": "Publish",\r\n            "editoptions": {\r\n                "type": "checkbox",\r\n                "label": "Enable Template",\r\n                "default": "yes",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "edit",\r\n        "delete",\r\n        "publish"\r\n    ]\r\n}', '1', 5, 'all'),
(25, 9, 'Themes', 'themes', 'tbl_themes', '{\r\n    "keyColumn": "theme_id",\r\n    "orderBy": {\r\n        "theme_id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "theme_title",\r\n        "theme_name",\r\n        "theme_status",\r\n        "theme_thumbnail"\r\n    ],\r\n    "showColumns": [\r\n        "theme_id",\r\n        "theme_title",\r\n        "theme_name",\r\n        "theme_status"\r\n    ],\r\n    "detailColumns": [\r\n        "theme_id",\r\n        "theme_title",\r\n        "theme_name",\r\n        "theme_status",\r\n        "theme_thumbnail"\r\n    ],\r\n    "columns": {\r\n        "theme_id": {},\r\n        "theme_title": {\r\n            "name": "Theme Title",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "disabled",\r\n                "label": "Theme Title"\r\n            }\r\n        },\r\n        "theme_name": {\r\n            "name": "Theme Name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "disabled",\r\n                "label": "Theme Name"\r\n            }\r\n            \r\n        },\r\n        "theme_status": {\r\n            "name": "Theme Status",\r\n            "editoptions": {\r\n                "type": "checkbox",\r\n                "label": "Enable Theme",\r\n                "enumvalues": {\r\n                    "0": "Inactive",\r\n                    "1": "Active"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::changeThemeStatus",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "1": "green",\r\n                    "0": "red"\r\n                }\r\n            }\r\n        },\r\n        "theme_thumbnail": {\r\n            "name": "Thumbnail",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::showthumbnail"\r\n        }\r\n    },\r\n    "customActions": {\r\n        "afterEditRecord": "Admincomponents::statusUpdate"\r\n    },\r\n    "opertations": [\r\n        "edit"\r\n    ]\r\n}', '1', 6, 'all'),
(26, 1, 'Settlements', 'settlements', 'tbl_BillingSettlement', '{\r\n    "keyColumn": "nId",\r\n    "orderBy": {\r\n        "dCreatedOn": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "nUId",\r\n        "nRequestedAmount",\r\n        "tUserComments",\r\n        "dCreatedOn",\r\n        "eStatus"\r\n    ],\r\n    "showColumns": [\r\n        "nId",\r\n        "nSettledAmount",\r\n        "tAdminComments",\r\n        "eStatus"\r\n    ],\r\n    "detailColumns": [\r\n        "nId",\r\n        "nUId",\r\n        "nRequestedAmount",\r\n        "tUserComments",\r\n        "nSettledAmount",\r\n        "tAdminComments",\r\n        "dCreatedOn",\r\n        "eStatus"\r\n    ],\r\n    "columns": {\r\n        "nId": {\r\n            "name": "Settlement Id",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "nUId": {\r\n            "name": "User",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_User",\r\n                "externalColumn": "nUId",\r\n                "externalShowColumn": "vUsername"\r\n            }\r\n        },\r\n        "nRequestedAmount": {\r\n            "name": "Requested Amount"\r\n        },\r\n        "tUserComments": {\r\n            "name": "Comments"\r\n        },\r\n        "dCreatedOn": {\r\n            "name": "Sent On",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n        "eStatus": {\r\n            "name": "Status",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "source_type": "array",\r\n                "source": {\r\n                    "Pending": "Pending",\r\n                    "Approved": "Approved",\r\n                    "Rejected": "Rejected"\r\n                },\r\n                "type": "select",\r\n                "label": "Status",\r\n                "class": "select"\r\n            }\r\n        },\r\n        "nSettledAmount": {\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Settled Amount",\r\n                "class": "textbox"\r\n            },\r\n            "name": "Settled Amount"\r\n        },\r\n        "tAdminComments": {\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textarea",\r\n                "label": "Comments",\r\n                "class": "textarea"\r\n            },\r\n            "name": "Admin Comments"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit"\r\n    ],\r\n    "report": {\r\n        "reportTitle": "Settlements",\r\n        "columns": [\r\n            "nUId",\r\n            "nRequestedAmount",\r\n            "tUserComments",\r\n            "nSettledAmount",\r\n            "tAdminComments",\r\n            "dCreatedOn",\r\n            "eStatus"\r\n        ],\r\n        "dateColumn": "dCreatedOn"\r\n    }\r\n}', '0', 4, 'all'),
(27, 9, 'Support', 'support', 'tbl_BillingSettlement', '{"customAction":"true","controller":"index","method":"gotosupport","module":"admin"}', '1', 8, 'all'),
(28, 1, 'Service Details', 'service_details', 'tbl_ProductServices', '{"customAction":"true","controller":"service","method":"servicedetails","module":"admin"}', '0', 6, 'all'),
(29, 1, 'User', 'domain_user_tag', 'tbl_User', '{\r\n    "keyColumn": "nUId",\r\n    "orderBy": {\r\n        "vFirstName": "ASC"\r\n    },\r\n    "reference": {\r\n        "referenceTable": "tbl_ProductLookup",\r\n        "referenceColumn": "nUId",\r\n        "referenceTableForiegnKey": "nUId"\r\n    },\r\n    "listColumns": [\r\n        "vFirstName",\r\n        "vLastName",\r\n        "vEmail"\r\n    ],\r\n    "detailColumns": [\r\n        "nUId",\r\n        "vFirstName",\r\n        "vLastName",\r\n        "vEmail"\r\n    ],\r\n    "showColumns": [\r\n        "nUId",\r\n        "vFirstName",\r\n        "vLastName",\r\n        "vEmail"\r\n    ],\r\n    "columns": {\r\n        "nUId": {\r\n            "name": "ID"\r\n        },\r\n        "vFirstName": {\r\n            "name": "First name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "First Name",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vLastName": {\r\n            "name": "Last name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Last Name",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vEmail": {\r\n            "name": "Email",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Email",\r\n                "class": "textbox"\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view"\r\n    ]\r\n}', '0', 0, 'all'),
(30, 1, 'Invoice Details', 'invoice_details', 'tbl_Invoice', '{"customAction":"true","controller":"service","method":"invoicedetails","module":"admin"}', '0', 0, 'all'),
(31, 10, 'Contents', 'static_content', 'tbl_Cms', '{\r\n"keyColumn": "cms_id",\r\n    "orderBy": {\r\n        "cms_id": "ASC"\r\n    },\r\n"where":"tbl_Cms.cms_type=''cms''",\r\n\r\n    "listColumns": [\r\n        "cms_name",\r\n        "cms_title",\r\n        "cms_status"\r\n    ],\r\n    "showColumns": [\r\n        "cms_id",\r\n        "cms_name",\r\n        "cms_title",\r\n        "cms_desc",\r\n        "cms_status"\r\n    ],\r\n    "detailColumns": [\r\n        "cms_id",\r\n        "cms_name",\r\n        "cms_title",\r\n        "cms_desc",\r\n        "cms_status"\r\n    ],\r\n    "detailHeaderColumns": [\r\n        "cms_title"\r\n    ],\r\n    "detailHeaderColumnPrefix": "Content: ",\r\n    "columns": {\r\n        "cms_id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "cms_name": {\r\n            "name": "Page Name",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "cms_title": {\r\n            "name": "Display Title",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "cms_desc": {\r\n            "name": "Content",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "htmlEditor",\r\n                "label": "Content",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "cms_status": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::changeContentStatus",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "1": "green",\r\n                    "0": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "edit",\r\n        "view"\r\n    ]\r\n}', '1', 2, 'all'),
(33, 1, 'Coupons', 'coupons', ' tbl_Coupon', '{\r\n    "keyColumn": "nCouponId",\r\n    "orderBy": {\r\n        "dCreatedOn": "DESC"\r\n    },\r\n    "detailHeaderColumns": ["vCouponCode"],\r\n    "detailHeaderColumnPrefix": "Coupon: ",\r\n    "listColumns": [\r\n        "vCouponCode",\r\n        "vPricingMode",\r\n        "nCouponValue",\r\n        "dExpireOn",\r\n        "nCouponCount",\r\n        "nCouponUsed"\r\n    ],\r\n    "showColumns": [\r\n        "nCouponId",\r\n        "vCouponCode",\r\n        "nCouponCount",\r\n        "vPricingMode",\r\n        "nCouponValue",\r\n        "dCreatedOn",\r\n        "dExpireOn",\r\n        "vCouponDescription"\r\n    ],\r\n    "detailColumns": [\r\n        "nCouponId",\r\n        "vCouponCode",\r\n        "vCouponDescription",\r\n        "vPricingMode",\r\n        "nCouponValue",\r\n        "dCreatedOn",\r\n        "dExpireOn",\r\n        "nCouponCount",\r\n        "nCouponUsed"\r\n    ],\r\n    "columns": {\r\n        "nCouponId": {\r\n            "name": "ID",\r\n            "editoptions":{"type":"hidden"}\r\n        },\r\n        "nCouponUsed": {\r\n            "name": "Number Of Coupons Used"\r\n        },\r\n        "vCouponCode": {\r\n            "name": "Coupon Code",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions":{\n                "validations":["required"],\n                "type":"textbox",\n                "label":"Coupon Code",\n                "class":"textbox"\n            }\r\n        },\r\n        "nCouponCount": {\r\n            "name": "Number Of Coupons",\r\n            "sortable": "true",\r\n            "editoptions":{\n                  "validations":["required"],\n                  "type":"textbox",\n                  "label":"Number of Coupons",\n                  "class":"textbox"\n            }\r\n        },\r\n        "dCreatedOn": {\r\n            "name": "Created Date",\r\n            "editoptions":{\n                "validations":["required"],\n                "type":"datepicker",\n                "label":"Created Date",\n                "class":"textbox",\n            "dbFormat":"date",\n            "displayFormat":"m/d/Y"\n            },\n            "dbFormat":"date",\n            "displayFormat":"m/d/Y"\r\n        },\r\n        "dExpireOn": {\r\n            "name": "Expiry Date",\r\n            "sortable": "true",\r\n            "editoptions":{\n                "validations":["required"],\n                "type":"datepicker",\n                "label":"Expiry Date",\n                "class":"textbox",\n            "dbFormat":"date",\n            "displayFormat":"m/d/Y"\n            },\n            "dbFormat":"date",\n            "displayFormat":"m/d/Y"\r\n        },\r\n        "vPricingMode": {\r\n            "name": "Pricing Mode",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions":{\r\n                "validations":["required"],\r\n                "type":"select",\r\n                "label":"Pricing Mode",\r\n                "class":"select",\r\n                "source":{"percentage":"Percentage","rate":"Rate"},\r\n                "source_type":"array",\r\n                "enumvalues":{"percentage":"Percentage","rate":"Rate"}\r\n            }\r\n        },\r\n        "nCouponValue": {\r\n            "name": "Coupon Value",\r\n            "sortable": "true",\r\n            "editoptions":{\n                "validations":["required"],\n                "type":"textbox",\n                "label":"Coupon Value",\n                "class":"textbox"\n            }\r\n        },\r\n        "vCouponDescription": {\r\n            "name": "Description",\r\n            "sortable": "true",\r\n            "editoptions":{"type":"textbox","label":"Description","class":"textbox"}\r\n        }\r\n\r\n    },\r\n    "opertations": [\r\n        "add","edit","delete","view"\r\n    ],\r\n    "report": {\r\n        "reportTitle": "Coupons",\r\n        "columns": [\r\n            "vCouponCode",\r\n            "vPricingMode",\r\n            "nCouponValue",\r\n            "dCreatedOn",\r\n            "dExpireOn",\r\n            "nCouponCount",\r\n            "nCouponUsed",\r\n            "vCouponDescription"\r\n        ],\r\n        "dateColumn": "dCreatedOn"\r\n    }\r\n}', '1', 9, 'all'),
(34, 10, 'Email Content', 'email_content', 'tbl_Cms', '{\r\n"keyColumn": "cms_id",\r\n    "orderBy": {\r\n        "cms_id": "ASC"\r\n    },\r\n"where":"tbl_Cms.cms_type=''email''",\r\n\r\n    "listColumns": [\r\n        "cms_name",\r\n        "cms_title",\r\n        "cms_status"\r\n    ],\r\n    "showColumns": [\r\n        "cms_id",\r\n        "cms_name",\r\n        "cms_title",\r\n        "cms_desc",\r\n        "cms_status"\r\n    ],\r\n    "detailColumns": [\r\n        "cms_id",\r\n        "cms_name",\r\n        "cms_title",\r\n        "cms_desc",\r\n        "cms_status"\r\n    ],\r\n    "detailHeaderColumns": [\r\n        "cms_title"\r\n    ],\r\n    "columns": {\r\n        "cms_id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "cms_name": {\r\n            "name": "Name",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "cms_title": {\r\n            "name": "Subject",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Subject",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "cms_desc": {\r\n            "name": "Content",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "htmlEditor",\r\n                "label": "Content",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "cms_status": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "edit",\r\n        "view"      \r\n    ]\r\n}', '1', 6, 'all'),
(35, 1, 'Settlement Request', 'settlement_request', 'tbl_BillingSettlement', '{\r\n    "keyColumn": "nId",\r\n    "orderBy": {\r\n        "dCreatedOn": "DESC"\r\n    },\r\n    "detailHeaderColumns": ["nUId"],\r\n    "detailHeaderColumnPrefix": "Request From: ",\r\n    "listColumns": [\r\n        "nUId",\r\n        "nRequestedAmount",\r\n        "tUserComments",\r\n        "eStatus",\r\n		"dCreatedOn"\r\n    ],\r\n    "detailColumns": [\r\n        "nId",\r\n        "nUId",\r\n        "nRequestedAmount",\r\n        "tUserComments",\r\n        "eStatus",\r\n		"dCreatedOn"\r\n    ],\r\n    "columns": {\r\n    "nId":{"name":"ID"},\r\n        "nUId": {\r\n            "name": "Customer",\r\n            "sortable": "true",\r\n			"customColumn": "true",\r\n			"customaction": "Admincomponents::getUsernameOfSettledRequest"\r\n        },\r\n        "nRequestedAmount": {\r\n            "name": "Request Amount",\r\n            "searchable": "searchable",\r\n            "sortable": "true"\r\n        },\r\n        "tUserComments": {\r\n            "name": "Comment",\r\n            "sortable": "true"\r\n        },\r\n        "eStatus": {\r\n            "name": "Status",\r\n            "sortable": "true"\r\n        },\r\n		"dCreatedOn": {\r\n            "name": "Requested On",\r\n            "sortable": "true",\r\n			"dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "delete"\r\n    ]\r\n}', '1', 9, 'all'),
(39, 10, 'Meta Tags', 'meta_tags', 'fw_metadata', '{\r\n "keyColumn": "id",\r\n "detailHeaderColumnPrefix": "Meta Tag : ",\r\n    "detailHeaderColumns": [\r\n        "url"\r\n    ],\r\n    "orderBy": {\r\n        "id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "url",\r\n        "title",\r\n        "keyword"\r\n    ],\r\n    "showColumns": [\r\n        "id",\r\n        "url",\r\n        "title",\r\n        "keyword",\r\n        "description"\r\n    ],\r\n    "detailColumns": [\r\n        "id",\r\n        "url",\r\n        "title",\r\n        "keyword",\r\n        "description"\r\n    ],\r\n    "columns": {\r\n        "id": {\r\n            "name": "ID",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "title": {\r\n            "name": "Meta Title",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Meta Title",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "keyword": {\r\n            "name": "Meta Keywords",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Meta Keywords",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "description": {\r\n            "name": "Meta Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Meta Description",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "url": {\r\n            "name": "Page Url",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "label": "Page Url",\r\n                "type": "textbox",\r\n                "class": "textbox",\r\n                "hint":"<b>Url combinations can be : </b><br/><b style=''color:red''> /abc/</b> [exact location abc after your domain name] eg : www.domainname.com/abc/ ,<br/> <b style=''color:red''>/abc/* </b> [any combination after location abc after your domain name] eg : www.domainname.com/abc/test1,<br/> <b style=''color:red''>* </b>[default value] ",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '1', 2, 'all'),
(37, 10, 'Newsletter Template', 'newsletter_template', 'tbl_EmailTemplates', '{\r\n"keyColumn": "nETId",\r\n"detailHeaderColumns":["vemailTemplateName"],\r\n"detailHeaderColumnPrefix": "Newsletter Template: ",\r\n    "orderBy": {\r\n        "nETId": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vemailTemplateName",\r\n        "estatus"\r\n    ],\r\n    "detailColumns": [\r\n        "nETId",\r\n        "vemailTemplateName",\r\n        "temailTemplate",\r\n        "estatus"\r\n    ],\r\n    "showColumns": [\r\n        "nETId",\r\n        "vemailTemplateName",\r\n        "temailTemplate",\r\n        "estatus"\r\n    ],\r\n    "columns": {\r\n        "nETId": {\r\n            "name": "ID",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vemailTemplateName": {\r\n            "name": "Template Name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Template Name",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "temailTemplate": {\r\n            "name": "Template",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "htmlEditor",\r\n                "label": "Template",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "estatus": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "validations": [\r\n                        "required"\r\n                    ],\r\n                "type": "select",\r\n                "source": {\r\n                    "Active": "Active",\r\n                    "Inactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "Active": "Active",\r\n                    "Inactive": "Inactive"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                    "type": "button",\r\n                    "customaction": "Admin::changeNewsletterScheduleStatus",\r\n                    "enumvalues": {\r\n                        "Active": "Active",\r\n                        "Inactive": "Inactive"\r\n                    },\r\n                    "buttonColors": {\r\n                        "Active": "green",\r\n                        "Inactive": "red"\r\n                    }\r\n                }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "add",\r\n        "delete"\r\n    ]\r\n}', '1', 3, 'all'),
(38, 1, 'godaddycertify', 'godaddycertify', 'test', '{"customAction":"true","controller":"module","method":"godaddycertify","module":"admin"}\r\n', '0', 1, 'all'),
(41, 1, 'Domain Renewal Log', 'domain_renewal_log', 'tbl_DomainRenewalLog', '{\r\n    "keyColumn": "id",\r\n     "orderBy": {\r\n                "createdOn": "DESC"\r\n                },\r\n    "detailHeaderColumns": ["vDomain"],\r\n    "detailHeaderColumnPrefix": "Domain Renewal Log for : ",\r\n\r\n    "listColumns": [\r\n        "vDomain",\r\n                    "nUId",\r\n                    "comments",\r\n                    "expireOn",\r\n                    "createdOn",\r\n                    "lastModified",\r\n                    "actionRenew"\r\n    ],\r\n    "detailColumns": [\r\n        "vDomain",\r\n                    "nUId",\r\n                    "comments",\r\n                    "expireOn",\r\n                    "createdOn",\r\n                    "lastModified",\r\n                    "actionRenew"\r\n    ],\r\n    "columns": {\r\n   "vDomain":{\r\n                "name":"Domain",\r\n                "sortable": "true",\r\n                "searchable": "searchable"\r\n                },\r\n       "nUId": {\r\n                "name": "Customer",\r\n                "sortable": "true",\r\n                "customColumn": "true",\r\n                "customaction": "Admincomponents::getUsernameOfSettledRequest",\r\n                "sortable": "true",\r\n                "searchable": "searchable"\r\n            },\r\n       "comments": {\r\n            "name": "Status",\r\n            "sortable": "true",\r\n            "searchable": "searchable"\r\n        },\r\n "expireOn": {\r\n            "name": "Domain Expiry Date",\r\n            "sortable": "true",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y",\r\n            "sortable": "true",\r\n            "searchable": "searchable"\r\n        },\r\n         "createdOn": {\r\n            "name": "Log Created On",\r\n            "sortable": "true",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y",\r\n            "sortable": "true",\r\n            "searchable": "searchable"\r\n        },\r\n       "lastModified": {\r\n            "name": "Log Modified On",\r\n            "sortable": "true",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y",\r\n            "sortable": "true",\r\n            "searchable": "searchable"\r\n        },\r\n            "actionRenew": {\r\n            "name": "Action",\r\n            "disableDetailedView":"false",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getDomainRenewalLink"\r\n            }\r\n    },\r\n    "opertations": [\r\n        "view"\r\n    ],\r\n    "includeJsFiles":["cmshelper.js"]\r\n}', '1', 10, 'all'),
(42, 1, 'Sold Template History', 'sold_templates', 'tbl_PaidTemplatePurchase', '{\r\n  "includeJsFiles": [\r\n    "dateformats.js"\r\n    ],\r\n    "keyColumn": "id",\r\n    "orderBy": {\r\n        "paidOn": "DESC"\r\n    },\r\n    "listColumns": [\r\n\r\n        "nTemplateId",\r\n        "nUId",\r\n        "nPLId",\r\n        "amount",\r\n        "paymentMethod",\r\n        "transactionId",\r\n        "comments",\r\n        "paidOn"\r\n    ],\r\n    "showColumns": [\r\n\r\n        "nTemplateId",\r\n        "nUId",\r\n        "nPLId",\r\n        "amount",\r\n        "paymentMethod",\r\n        "transactionId",\r\n        "comments",\r\n        "paidOn"\r\n    ],\r\n    "detailHeaderContent": "Sold Template",\r\n    "detailColumns": [\r\n\r\n        "nTemplateId",\r\n        "nUId",\r\n        "nPLId",\r\n        "amount",\r\n        "paymentMethod",\r\n        "transactionId",\r\n        "comments",        \r\n        "paidOn"\r\n    ],\r\n    "columns": {\r\n        "nTemplateId": {\r\n            "name": "Template Name",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "external": "true",\r\n            "externalOptions": {\r\n            "externalTable": "tbl_PaidTemplates",\r\n            "externalColumn": "nTemplateId",\r\n            "externalShowColumn": "vTemplateName"}\r\n        },\r\n        "nUId": {\r\n            "name": "User",\r\n            "sortable": "true",\r\n            "customColumn": "true",\r\n	    "customaction": "Admincomponents::getUsernameOfSoldTemplateCMS"\r\n        },\r\n        "nPLId": {\r\n            "name": "Store",\r\n            "sortable": "true",\r\n            "customColumn": "true",\r\n	    "customaction": "Admincomponents::getStoreHostForSoldTemplatePurchaseCms"\r\n        },\r\n        "amount": {\r\n            "name": "Amount",\r\n            "sortable": "true",\r\n            "searchable": "true"\r\n            },\r\n        "paymentMethod": {\r\n            "name": "Payment Method",\r\n            "sortable": "true",\r\n            "searchable": "true"\r\n        },\r\n         "transactionId": {\r\n            "name": "Transaction Id",\r\n            "sortable": "true",\r\n            "searchable": "true"\r\n        },\r\n        "comments": {\r\n            "name": "Status",\r\n            "sortable": "true",\r\n            "searchable": "true"\r\n        },\r\n        "paidOn": {\r\n            "name": "Purchase Date",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n           "dbFormat": "timestamp",\r\n            "displayFormat": "m/d/Y"\r\n        }\r\n\r\n\r\n\r\n    },"opertations": [\r\n        "view"]\r\n\r\n}', '1', 10, 'all');

INSERT INTO `cms_users` (`id`, `type`, `username`, `password`, `status`) VALUES
(1, 'sadmin', 'sadmin', 'c5edac1b8c1d58bad90a246d8f08f53b ', 'active'),
(2, 'admin', 'admin', '21232f297a57a5a743894a0e4a801fc3 ', 'active');


INSERT INTO `sptbl_companies` (`nCompId`, `vCompName`, `vCompAddress1`, `vCompAddress2`, `vCompCity`, `vCompState`, `nCompZip`, `vCompCountry`, `vCompPhone`, `vCompFax`, `vCompMail`, `vCompContact`, `vDelStatus`, `vChatWelcomeMessage`, `vChatIcon`, `vChatOperatorRating`) VALUES
(1, 'iScripts goStores', 'localhost', NULL, 'city', NULL, '11111', 'UnitedStates', NULL, NULL, 'company1@yoursite.com', '', '0', 'Welcome', '1', '0');



INSERT INTO `sptbl_css` (`nCSSId`, `vCSSName`, `vCSSURL`, `dDate`) VALUES
(1, 'Copper Penny', 'styles/CopperPenny/style.css', '2012-10-08 10:50:03'),
(2, 'Aqua Blue', 'styles/AquaBlue/style.css', '2012-10-08 10:50:03'),
(3, 'African Violet', 'styles/AfricanViolet/style.css', '2012-10-08 10:50:03'),
(4, 'Coffee Brown', 'styles/CoffeeBrown/style.css', '2012-10-08 10:50:03'),
(5, 'Escastic Blue', 'styles/EscasticBlue/style.css', '2012-10-08 10:50:03'),
(6, 'Feminine Pink', 'styles/FemininePink/style.css', '2012-10-08 10:50:03'),
(7, 'Pale Green', 'styles/PaleGreen/style.css', '2012-10-08 10:50:03'),
(8, 'Pantone Skin', 'styles/PantoneSkin/style.css', '2012-10-08 10:50:03'),
(9, 'Parrot Green', 'styles/ParrotGreen/style.css', '2012-10-08 10:50:03'),
(10, 'Tan Brick', 'styles/TanBrick/style.css', '2012-10-08 10:50:03');


INSERT INTO `sptbl_depts` (`nDeptId`, `nCompId`, `vDeptDesc`, `nDeptParent`, `vDeptMail`, `vDeptCode`, `nResponseTime`) VALUES
(1, 1, 'Support', 0, 'dept@yoursite.com', 'D01', 0);


INSERT INTO `sptbl_fields` (`nFieldId`, `vFieldName`, `vFieldDesc`) VALUES
(1, 'vRefNo', 'TEXT_REF_NO'),
(2, 'vTitle', 'TEXT_TITLE'),
(3, 'dPostDate', 'TEXT_POST_DATE'),
(4, 'vStatus', 'TEXT_STATUS'),
(5, 'vUserName', 'TEXT_USER_NAME'),
(6, 'vPriority', 'TEXT_PRIORITY'),
(7, 'vStaffLogin', 'TEXT_STAFF'),
(8, 'nLockStatus', 'TEXT_LOCK_STATUS');


INSERT INTO `sptbl_lang` (`vLangCode`, `VLangDesc`) VALUES
('en', 'English'),
('de', 'German'),
('fr', 'French'),
('es', 'Spanish');


INSERT INTO `sptbl_lookup` (`nLookUpId`, `vLookUpName`, `vLookUpValue`) VALUES
(1, 'MailAdmin', 'admin@iscripts.com'),
(2, 'MailTechnical', 'admin@iscripts.com'),
(3, 'MailEscalation', 'admin@iscripts.com'),
(4, 'MailFromName', 'Administrator'),
(5, 'MailFromMail', 'admin@iscripts.com'),
(6, 'MailReplyName', 'Administrator'),
(7, 'MailReplyMail', 'admin@iscripts.com'),
(8, 'SiteURL', 'http://localhost/gostores/project/support/'),
(9, 'HelpDeskURL', 'http://localhost/gostores/project/support/'),
(10, 'LangChoice', '1'),
(11, 'DefaultLang', 'en'),
(12, 'Post2PostGap', '0'),
(13, 'AutoLock', '1'),
(14, 'VerifyTemplate', '1'),
(15, 'VerifyKB', '1'),
(16, 'EmailURL', 'http://localhost/gostores/project/support/'),
(37, 'MaxfileSize', '2097150'),
(38, 'HelpdeskTitle', 'iScripts goStores'),
(39, 'Logourl', 'custom/logoo.gif'),
(40, 'Emailfooter', '<table  width=''100%''><tr><td bgcolor=''red''>&nbsp;</td></tr></table>'),
(41, 'Emailheader', '<table width=''100%''><tr><td bgcolor=''green''>&nbsp; </td></tr></table>'),
(42, 'vLicenceKey', '123'),
(87, 'ExtraStatus', 'InProcess'),
(90, 'ExtraStatus', 'New'),
(88, 'Attachments', 'bmp|image/bmp'),
(89, 'Attachments', 'jpg|image/jpeg'),
(96, 'Attachments', 'mid|audio/mid'),
(97, 'Attachments', 'mp3|audio/mp3'),
(98, 'Attachments', 'wma|audio/x-ms-wma'),
(92, 'Attachments', 'gif|image/gif'),
(93, 'RunLevel', '0'),
(94, 'logactivity', '0'),
(95, 'LoginURL', 'http://localhost/gostores/project/support/'),
(99, 'EmailPiping', '1'),
(100, 'MaxPostsPerPage', '30'),
(101, 'OldestMessageFirst', '1'),
(102, 'UserAuthenticate', '1'),
(103, 'PostTicketBeforeLogin', '1'),
(104, 'spamfiltertype', 'OFF'),
(105, 'MessageRule', '0'),
(106, 'SMTPSettings', '0'),
(107, 'SMTPServer', ''),
(108, 'SMTPPort', ''),
(109, 'Attachments', 'txt|text/plain'),
(110, 'Attachments', 'zip|application/x-zip'),
(111, 'Attachments', 'html|text/html'),
(112, 'Attachments', 'htm|text/html'),
(113, 'Attachments', 'doc|application/msword'),
(114, 'Attachments', 'crt|application/x-x509-ca-cert'),
(115, 'Attachments', 'key|key|application/octet-stream'),
(116, 'Attachments', 'csv|text/plain'),
(117, 'Attachments', 'csv|application/octet-stream'),
(118, 'LiveChat', '1'),
(119, 'AD_AUTHENTICATION', 'N'),
(120, 'AD_USER', ''),
(121, 'AD_PASS', ''),
(122, 'AD_DOMAIN', ''),
(123, 'AD_HOST', ''),
(124, 'AD_USER_DIR', 'CN=USER'),
(125, 'NewTicketAutoReturnMail', '1'),
(126, 'Theme', '1'),
(127, 'Version', '4.2');


INSERT INTO `sptbl_priorities` (`nPriorityId`, `nPriorityValue`, `vPriorityDesc`, `vTicketColor`, `vPrioritie_icon`) VALUES
(1, 3, 'High', '#FFFFFF', ''),
(2, 2, 'Medium', '#FFFFFF', ''),
(8, 1, 'Normal', '#00FF00', ''),
(3, 4, 'Urgent', '#56dfdf', ''),
(9, 0, 'Low', '#e8dc54', '');


INSERT INTO `sptbl_spam_categories` (`category_id`, `probability`, `word_count`) VALUES
('spam', 0.887777777778, 799),
('notspam', 0.112222222222, 101);


INSERT INTO `sptbl_staffdept` (`nStaffId`, `nDeptId`) VALUES
(2, 1),
(1, 1);


INSERT INTO `sptbl_stafffields` (`nStaffId`, `nFieldId`) VALUES
(1, 1),
(1, 2),
(1, 3),
(1, 4),
(2, 1),
(2, 2),
(2, 3),
(2, 4);



INSERT INTO `sptbl_staffs` (`nStaffId`, `vStaffname`, `vLogin`, `vPassword`, `vOnline`, `vMail`, `vYIM`, `vSMSMail`, `vMobileNo`, `nCSSId`, `nRefreshRate`, `nNotifyAssign`, `nNotifyPvtMsg`, `nNotifyKB`, `nNotifyArrival`, `vType`, `vDelStatus`, `tSignature`, `nWatcher`, `vStaffImg`) VALUES
(1, 'Administrator', 'admin', '21232f297a57a5a743894a0e4a801fc3', '0', 'admin@iscripts.com', 'adminsms@yoursite.com', 'adminaol@yoursite.com', '23453453', 1, 1, 1, 1, 0, 1, 'A', '0', 'Thank You\r\nAdministrator\r\nSupportdesk\r\n', 0, NULL),
(2, 'staff', 'staff', '1253208465b1efa876f982d8a9e73eef', '0', 'staff@yoursite.com', 'staffsms@yoursite.com', 'staffaol@yoursite.com', '23453453', 1, 1, 1, 1, 0, 1, 'S', '0', 'Thank You\r\nStaff\r\nSupportdesk\r\n', 0, NULL);


INSERT INTO `goStores_Cms` (`cms_id`, `cms_name`, `cms_ref_title`, `cms_type`, `cms_title`, `cms_desc`, `cms_shortdesc`, `cms_status`) VALUES
	(2, 'aboutus', '', 'cms', 'About Us', '', '', 1),
	(3, 'USER_REGISTRATION', '', 'email', 'User Registration', '<p>Hi {USERNAME},</p> <p>Your {SITE_NAME} account setup completed. Please find your details below</p> <p>Login&#160; Address: {USEREMAIL}</p> <p>Password : {USERPASSWORD}</p> <p>&#160;</p> <p>Thanks</p> <p>{SITE_NAME} Team</p>', '', 1),
	(5, 'LOGIN_CREDENTIALS_CHANGE', '', 'email', 'Changed Login Credentials {SITE_NAME}', '<p>\r\n	Dear {MEMBER_NAME},</p>\r\n<br />\r\n<br />\r\n<table border="0" cellpadding="4" cellspacing="1" width="100%">\r\n	<tbody>\r\n		<tr bgcolor="#ffffff">\r\n			<td align="left" colspan="2">\r\n				Welcome to {SITE_NAME}.<br />\r\n				<b><u>Your changed account details as follows :</u></b></td>\r\n		</tr>\r\n		<tr bgcolor="#ffffff">\r\n			<td align="left" width="14%">\r\n				User Name</td>\r\n			<td width="86%">\r\n				{USER_NAME}</td>\r\n		</tr>\r\n		<tr bgcolor="#ffffff">\r\n			<td align="left">\r\n				Password</td>\r\n			<td>\r\n				{PASSWORD}</td>\r\n		</tr>\r\n		<tr bgcolor="#ffffff">\r\n			<td align="left" colspan="2">\r\n				<b><u>Click the following link to login to your account :</u></b></td>\r\n		</tr>\r\n		<tr bgcolor="#ffffff">\r\n			<td align="left" colspan="2">\r\n				{LOGIN_LINK}</td>\r\n		</tr>\r\n		<tr bgcolor="#ffffff">\r\n			<td align="left" colspan="2">\r\n				Thank You,</td>\r\n		</tr>\r\n		<tr bgcolor="#ffffff">\r\n			<td align="left" colspan="2">\r\n				{SITE_URL}</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', '', 1),
	(6, 'forgotpassword', '', 'email', 'Changed Login Credentials {SITE_NAME}', '<p>\r\n	Dear {MEMBER_NAME},</p>\r\n<br />\r\n<br />\r\n<table border=\\"0\\" cellpadding=\\"4\\" cellspacing=\\"1\\" width=\\"100%\\">\r\n	<tbody>\r\n		<tr bgcolor=\\"#ffffff\\">\r\n			<td align=\\"left\\" colspan=\\"2\\">\r\n				Welcome to {SITE_NAME}.<br />\r\n				<b><u>Your changed account details as follows :</u></b></td>\r\n		</tr>\r\n		<tr bgcolor=\\"#ffffff\\">\r\n			<td align=\\"left\\" width=\\"14%\\">\r\n				User Name</td>\r\n			<td width=\\"86%\\">\r\n				{USER_NAME}</td>\r\n		</tr>\r\n		<tr bgcolor=\\"#ffffff\\">\r\n			<td align=\\"left\\">\r\n				Password</td>\r\n			<td>\r\n				{PASSWORD}</td>\r\n		</tr>\r\n		<tr bgcolor=\\"#ffffff\\">\r\n			<td align=\\"left\\" colspan=\\"2\\">\r\n				<b><u>Click the following link to login to your account :</u></b></td>\r\n		</tr>\r\n		<tr bgcolor=\\"#ffffff\\">\r\n			<td align=\\"left\\" colspan=\\"2\\">\r\n				{ACTIVATION_LINK}</td>\r\n		</tr>\r\n		<tr bgcolor=\\"#ffffff\\">\r\n			<td align=\\"left\\" colspan=\\"2\\">\r\n				Thank You,</td>\r\n		</tr>\r\n		<tr bgcolor=\\"#ffffff\\">\r\n			<td align=\\"left\\" colspan=\\"2\\">\r\n				{SITE_URL}</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', '', 1),
	(8, 'contactus', '', 'cms', 'Contact Us', '\r\n', '', 1),
	(10, 'forgotpasswordemail', '', 'email', 'Forgot Password', '<p>Hi {USERNAME},</p> <p>We have received  your password reset request.</p><p>{PASSWORDLINK}</p>  <p>Thanks</p>  <p>{SITE_NAME} Team</p>', '', 1),
	(14, 'invoice', '', 'email', 'Purchase Details {SITE_NAME}', '<p>Dear {MEMBER_NAME},<br> 	<br> 	Thank you for the interest shown in {COMPANY_NAME}.<br> 	The following is the invoice details, not receipt in regard to the purchase with {COMPANY_NAME}.</p>', '', 1),
	(13, 'disclaimernotice', '', 'cms', 'Disclaimer Notice', '', '', 1),
	(15, 'free_trial_expiry_notification', '', 'email', 'Your {SITE_NAME} {PRODUCT_NAME} Free Trial will expire on {EXPIRY_DATE}', '<p>\r\n	Dear {MEMBER_NAME},<br />\r\n	<br />\r\n	Your {SITE_NAME} {PRODUCT_NAME} Free Trial will expire on {EXPIRY_DATE}.<br />\r\n	Hurry up! login to your account and upgrade the service to avail the site in {SITE_NAME} environment.</p>\r\n<p>\r\n	{SITE_NAME} Team</p>', '', 1),
	(16, 'free_trial_expired_notification', '', 'email', 'Your {SITE_NAME} {PRODUCT_NAME} Free Trial  expired', '<p>\r\n	Dear {MEMBER_NAME},<br />\r\n	<br />\r\n	Your {SITE_NAME} {PRODUCT_NAME} Free Trial has expired on {EXPIRY_DATE}.<br />\r\n	Hurry up! login to your account and upgrade the service immediately to avail the site in {SITE_NAME} environment.</p>\r\n<p>\r\n	{SITE_NAME} Team</p>', '', 1),
	(19, 'email_template', '', 'email_settings', 'Email Template', '<table width="600" cellspacing="0" cellpadding="0" border="0" style="border:1px solid #ccc;background-color:#fdfdfd">      <tbody>         <tr>             <td height="5" colspan="3">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table width="100%" cellspacing="0" cellpadding="0" border="0">                     <tbody>                         <tr>                             <td height="56"><table width="100%" cellspacing="0" cellpadding="0" border="0">                                     <tbody>                                         <tr>                                             <td width="2%" height="80">&#160;</td>                                             <td width="37%"><img height="40" src="{SITE_LOGO}" alt=""></td>                                             <td width="61%"><p style="font-family:Arial,Helvetica,sans-serif;font-size:12px;color:#cccccc;text-align:right;padding:0 15px 0 0">{DATE}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table width="100%" cellspacing="0" cellpadding="0" border="0">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%">{MAIL_CONTENT}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                                                             </tbody>                                 </table></td>                         </tr>                                             </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td height="10" colspan="3">&#160;</td>         </tr>     </tbody> </table>', '', 1),
	(20, 'bill_notification', '', 'email', 'Your {SITE_NAME} {PRODUCT_NAME} Service bill is due for payment on {PAYMENT_DATE}', '<p>\r\n	Dear {MEMBER_NAME},<br />\r\n	<br />\r\n	Your {SITE_NAME} {PRODUCT_NAME} Service bill is due for payment of {AMOUNT} on {PAYMENT_DATE}. Auto payment will be made in regard to the billing information you provided. Please make the changes if any, by logging in to your account prior to the payment date.<br />\r\n	Thank you for the interest shown in {COMPANY_NAME}.</p>\r\n<p>\r\n	{SITE_NAME} Team</p>', '', 1),
	(23, 'features', '', 'cms', 'Features', '<h3></h3><h5><span style="font-size: medium;"><span style="font-family: Arial, serif; color: rgb(102, 102, 102); line-height: 100%;">Your store will be equipped with similar features to Volusion.com and Shopify.com.</span></span></h5><h5><span style="font-size: medium;"><span style="font-family: Arial, serif; color: rgb(102, 102, 102); line-height: 100%;">Edit this page to let visitors know why they should use your site to build an online store. Sample:</span></span><font color="#666666"><font face="Arial, serif"><br></font></font></h5><br> 	<p></p><ul> 	<li><p style="margin-top: 0.05cm; margin-bottom: 0.05cm;"><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">No 	programming required. We believe you shouldnâ€™t have to know coding 	or pay a lot for a website to get your online business started.</font></font></span></p></li><li><p style="margin-top: 0.05cm; margin-bottom: 0.05cm;"><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Integrated 	help desk system for supporting store owners</font></font></span></p></li>    <li><p style="margin-top: 0.05cm; margin-bottom: 0.05cm;"><span style="font-size: small;">                 <font face="Arial, serif" color="#666666">Multiple payment gateways</font>             </span></p></li>     </ul>    <h3><font color="#666666">                 <font face="Arial, serif">                     <b>                         <br>                     </b>                 </font>             </font>             <font color="#666666" face="Arial, serif">Store Features</font></h3><br>                    <ul>         <li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">SEO 	friendly shopping cart. Give users an easy-to-remember URL and rank 	above your competition in search engines.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Multiple 	photo options per product to improve the conversion rate.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Automatic 	photo resizing, eliminating the need to use other photo editing 	programs.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	custom form fields for products and categories.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	digital products like eBooks, pictures, videos, software, and 	templates in addition to physical products.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Optional 	affiliate program to increase your new customers without breaking 	the bank.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	promo codes for tracking the effectiveness of marketing campaigns.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	an efficient and simple Return Merchandize Authorization process 	(RMA) to turn refunds and returns into a positive experience for 	your clients.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	bulk import of products and images.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	export users, orders, products and other reports into .csv format.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	multiple administrator logins with different privileges for staff.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Built-in 	content management system for static pages like Terms, About Us, and 	Refund Policy. Edit the website without knowing html.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	unlimited products, categories, and subcategories.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Includes 	multiple themes to fit the type of store you want to create. You can 	select a theme with a click and change the appearance of the entire 	online store.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	payment gateways like Paypal, Google Checkout, World Pay, Your Pay 	and Authorize.net.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	offline credit card payments so that you can process payments using 	your existing POS.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	order notification and package slip through fax.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	UPS, USPS, FEDEX, Canada Post and Australia Post Shipping Methods 	for real-time shipping calculations. For simple shipping it supports 	multiple flat rate shipping.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Administrator 	can change the home page layout by drag and drop in a browser. You 	can configure the site without any html or FTP.<br></font></font></span><span style="font-size: small;"><font color="#666666"><font face="Arial, serif"><br></font></font></span><span style="font-size: small;"><font color="#666666"><font face="Arial, serif"><br><br></font></font></span></li></ul>', '', 1),
	(26, 'account_cancellation_notification', '', 'email', 'Your {SITE_NAME} Account : {ACCOUNT} has been cancelled', '<p>Dear {MEMBER_NAME},<br> 	<br> 	Your {SITE_NAME} &#160;Account :{ACCOUNT} has been cancelled.<br><br>Thank you for doing business with us! .</p> <p>{SITE_NAME} Team</p>', '', 1),
	(25, 'failed_invoce_alert', '', 'email', 'Failed Invoice Alert {SITE_NAME}', 'Hi {USER},<br><br>The payment for your invoice no. {INVOICENO} dated {INVOICEDATE} could not be captured. Please contact {ADMIN_CONTACT_EMAIL} to keep your service active. Thank you for using {SITE_NAME}  services.<br><br><p>Thanks</p>  <p>{SITE_NAME} Team</p>', '', 1);

INSERT INTO `goStores_cms_settings` (`id`, `cms_set_name`, `cms_set_value`, `created_on`) VALUES
(1, 'admin_logo', 'project/styles/themes/theme1/images/gostores_logo.jpg', '2012-11-16 19:01:30'),
(2, 'admin_copyright', 'Powered by <a href="http://iscripts.com/gostores/" target="_blank" class="cms_list_operation">iScripts GoStores</a>. A premium product from <a href="http://iscripts.com/" target="_blank" class="cms_list_operation">iScripts.com</a>', '2012-12-18 16:21:13'),
(4, 'admin_page_count', '8', '2012-10-03 16:33:33'),
(5, 'site_logo', 'Admincomponents::bindSiteLogoCms', '2012-12-19 20:24:53');

INSERT INTO `goStores_Help` (`nId`, `vTitle`, `tDescription`, `eType`, `eStatus`) VALUES
(6, 'Features', 'Features\r\n	Previous  Next\r\nFew features of this site are listed below\r\n\r\n\r\n    Automated Recurring Billing\r\n\r\n    Simple Web-Based Interface\r\n\r\n    Automated Scheduled Invoicing\r\n\r\n    Access to Billing Records\r\n\r\n    Integrated Help Desk\r\n\r\n    Integrated Store Builder\r\n\r\n    Hosting Support', 'User', 'Active'),
(5, 'Introduction', 'GoStores gives you an instant online store with a new domain name or a subdomain name or to your existing domain as you opt.', 'User', 'Active'),
(7, 'Registration', 'The registration section contains minimal user details. Please enter your Login name, Password, and Email. All the fields marked with a red star are mandatory. Your Log in Name must contain (a-z, A-Z) and digits (0-9). Now your account is activated and you can login to your site immediately. Make sure to completely fill out your profile under the ''Edit Profile'' link.\r\n', 'User', 'Active'),
(8, 'Introduction', 'GoStores gives you an instant online store with a new domain name or a subdomain name or to your existing domain as you opt.', 'Admin', 'Active'),
(9, 'Settings', '<table width="576" cellspacing="0" cellpadding="3" border="1" style="border-collapse: collapse; border: none">\r\n    <tbody><tr>\r\n    <td width="15" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">01</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">ENOM Reseller User Name:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Reseller account user name with ENOM.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">02</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">ENOM Reseller Password:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Reseller account password.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">03</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">ENOM User IP:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">IP allowed for the Reseller account with ENOM.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">04</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">ENOM Mode:&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Test/Live mode of ENOM Reseller account.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">05</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Administrator Name:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Name of the administrator of the site.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">06</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Administrator Signature:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Signature of the administrator of the site.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">07</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Administrator Password:&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Password of the administrator of the site.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">08</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Adminstrator Mail:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Mail address of the administrator of the site.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">09</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Company Name:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Name of the company.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">10</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Name of the Site:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Name of the Site.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">11</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Invoice From:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Invoice from details, which are used with invoices.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">12</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Site URL:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">URL of the site, it gets displayed automatically.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">13</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Sub Domain Hosting URL:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Domain name where you allow your customers to \r\n    create </span></font><font color="#010101"></font></div>\r\n    <div align="left"><br>\r\n    </div>\r\n    <font color="#010101">\r\n    </font><div align="left"><font color="#010101"></font><font face="Arial" color="#010101"><span style="font-size:10pt">their store as a subdomain.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">14</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Subdomain Sever CPanel</span></font><font color="#010101"></font></div>\r\n    <div align="left"><br>\r\n    </div>\r\n    <font color="#010101">\r\n    </font><div align="left"><font color="#010101"></font><font face="Arial" color="#010101"><span style="font-size:10pt"> User Name:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">CPANEL Username of the above Subdomain Sever</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">15</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Subdomain Sever CPanel</span></font><font color="#010101"></font></div>\r\n    <div align="left"><br>\r\n    </div>\r\n    <font color="#010101">\r\n    </font><div align="left"><font color="#010101"></font><font face="Arial" color="#010101"><span style="font-size:10pt"> Password:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">CPANEL Password of the above Subdomain Sever</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">16</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Subdomain Sever CPanel</span></font><font color="#010101"></font></div>\r\n    <div align="left"><br>\r\n    </div>\r\n    <font color="#010101">\r\n    </font><div align="left"><font color="#010101"></font><font face="Arial" color="#010101"><span style="font-size:10pt"> Skin</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">CPANEL Skin of the above Subdomain Sever</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">17</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Control Panel Type </span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">The type of the Control Panel of the server, where \r\n    your</span></font><font color="#010101"></font></div>\r\n    <div align="left"><br>\r\n    </div>\r\n    <font color="#010101">\r\n    </font><div align="left"><font color="#010101"></font><font face="Arial" color="#010101"><span style="font-size:10pt"> site is hosted.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">18</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Control Panel Scripts Path:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Path to the folder where the Control Panel Scripts \r\n    resides. It needs to be entered only when the Control \r\n    Panel is of "CPANEL" type.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">19</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Site URL of Secure Server:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">URL of the secure version of this site. By default it will \r\n    take ''Site URL'' as ''Secure Server URL'' and you can \r\n    change this.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">20</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Support creating cart in a</span></font><font color="#010101"></font></div>\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt"> subdomain : &nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Option to support create store as subdomain</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">21</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Support creating cart in an </span></font><font color="#010101"></font></div>\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">existing domain:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Option to support create store with an existing domain \r\n    name.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">22</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Support creating cart in a new \r\n    domain&nbsp; :</span></font><font color="#010101"></font></div>\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">&nbsp;&nbsp;&nbsp;&nbsp;</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Option to support create store by registering a new \r\n    domain name.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">23</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Enable PayPal:&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Decide wheather to enable paypal or not.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">24</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Paypal Email Address:&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Paypal Login ID.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">25</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Paypal Identity Token:&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Identity Token issued from Paypal.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">26</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Payment Gateway:&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Decide which payment gateway needed.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">27</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Authorize.net Login Id:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Your Login ID with the authorize.net payment \r\n    gateway.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">28</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Authorize.net Password:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Authorize.net account''s password.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">29</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Authorize.net Transaction Key:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Your transaction key with the Authorize.net account.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">30</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Authorize.net Merchant Email:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Your email address with the Authorize.net account.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">31</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Site Logo:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Logo of your site, it will be better if you upload a \r\n    transparent background logo.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">32</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Center HTML Part of User</span></font><font color="#010101"></font></div>\r\n    <div align="left"><br>\r\n    </div>\r\n    <font color="#010101">\r\n    </font><div align="left"><font color="#010101"></font><font face="Arial" color="#010101"><span style="font-size:10pt"> Side of the Site </span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Content for the home page of your website.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">33</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Enable About Us </span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Option to show or hide about us page in your site.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">34</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">About Us Page</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Content For the about us page.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">35</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Price of Domain Registration Plan:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Price for domain registration</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="39" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">36</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="39" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Price of Domain Renewal Plan:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="39" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Cost for renewing a domain in the site.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">37</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Name Server 1 - 4:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Name servers, if you enable hosting service. If you \r\n    enable hosting service, there name servers will get \r\n    added to all domains that are registered, transfered \r\n    and renewed in the site.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">38</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Administrator Password Settings:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Gives the option to change the password of \r\n    administrator of the site.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left">&nbsp;<font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left">&nbsp;<font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left">&nbsp;<font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="36" style="border: solid #010101 1px;">\r\n    <div align="left">&nbsp;<font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="36" style="border: solid #010101 1px;">\r\n    <div align="left">&nbsp;<font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="36" style="border: solid #010101 1px;">\r\n    <div align="left">&nbsp;<font color="#010101"></font></div>\r\n    </td></tr></tbody></table>', 'Admin', 'Active');



INSERT INTO `goStores_PlanPackages` (`nPPId`, `nPlanId`, `vDescription`, `nPlanAmount`, `dCreatedOn`, `nStatus`, `nDeleteStatus`) VALUES
(1, 1, 'Free Trial for Product', 50, '2012-09-06 17:29:34', 0, 0),
(2, 2, 'Discount Pack', 30, '2012-09-11 16:05:12', 1, 0);


INSERT INTO `goStores_ProductPermission` (`nId`, `nPId`, `vPermissions`) VALUES
(1, 1, 'app/webroot/img/,app/webroot/img/products/,app/webroot/img/csv/,app/tmp/,app/tmp/logs/,app/tmp/sessions/,app/tmp/cache/,app/tmp/cache/models/,app/tmp/cache/views/,app/tmp/cache/persistent/,app/webroot/files/,app/webroot/files/File,app/webroot/files/Flash,app/webroot/files/Image,app/webroot/files/Media,app/webroot/files/Graph,app/config/database.php,app/webroot/config.php,app/webroot/img/SiteLogo.gif,app/webroot/img/SiteLogo_disp.gif,app/webroot/blog/wp-content/,app/webroot/blog/wp-config.php,app/controllers/components/pple.xml,app/webroot/configxml.xml,');


INSERT INTO `goStores_Products` (`nPId`, `vPName`, `vProductCaption`, `vProductPack`, `vProductlogoSmall`, `vProductlogo`, `vProductDescription`, `vProductScreens`, `dLastUpdated`, `nPRId`, `nStatus`) VALUES
(1, 'VistaCart', 'Online shopping Cart', 'vistacart.zip', 'Socialware_small_disp.gif', 'Socialware_main_disp.gif', 'Social Networking Sites', 'Socialware_small_disp.gif', '2012-12-11 20:06:13', 4, 1);


INSERT INTO `goStores_ServiceCategories` (`nSCatId`, `vCategory`, `vDescription`, `vInputType`, `vOrderofDisplay`, `dCreatedOn`, `nStatus`) VALUES
(1, 'Domain Registration', 'Domain Registration', 'C', NULL, '2012-09-14', 1),
(2, 'License Plans', 'License Plans', 'C', NULL, '2012-09-14', 1),
(3, 'Professional Installation Service', 'Professional Installation Service', 'C', NULL, '2012-09-14', 1),
(4, 'Support Options', 'Support Options', 'C', NULL, '2012-09-14', 1),
(5, 'Copyright Removal License', 'Copyright Removal License', 'C', NULL, '2012-09-14', 0),
(6, 'Product Purchase', 'Product Purchase', 'C', NULL, '2012-09-14', 1),
(7, 'Graphic Design Service', 'Graphic Design Service', 'R', NULL, '2012-09-14', 1),
(8, 'Support Upgrade', 'Support Upgrade', 'C', NULL, '2012-09-14', 1),
(9, 'Product Upgrade', 'Product Upgrade', 'C', NULL, '2012-09-14', 1),
(10, 'Free Product Upgrade', 'Free Product Upgrade', 'C', NULL, '2012-09-14', 1),
(12, 'Product Upgrade1', 'hh\\''g', 'C', NULL, '2012-09-18', 1);



INSERT INTO `goStores_Settings` (`settingfield`, `settinglabel`, `value`, `groupLabel`, `type`, `fieldOrder`, `helpText`) VALUES
('siteName', 'Site Name', '', 'General', '', 0, 'Name your site. This name is the website title. This will be visible to users within the browser tab. Try to use keywords describing your site to help visitors understand your page quickly.'),
('siteTitle', 'Site Title', '', 'General', '', 0, 'The contents of this field will appear in several places including the title of the website.'),
('secureURL', 'Secure URL', '', 'General', '', 0, 'This is for SSL certificates only. This information is provided by your hosting company.'),
('adminEmail', 'Admin Email', '', 'General', '', 0, 'This is the email where all site notifications, alerts and approvals will be sent.'),
('siteLogo', 'Site Logo', '', '', '', 0, 'This is where you can change the logo of the site. Click �Browse� to upload a file saved on your computer.'),
('enablesiteBanner', 'Enablesite Banner', 'N', 'General', '', 0, ''),
('siteBanner', 'Site Banner', '', 'General', '', 0, ''),
('metaKeywords', 'Meta Keywords', '', 'General', 'textarea', 0, 'Meta Keywords, or tags, are additional copy included in your website''s HTML.<br>(1)keep your list of keywords or keyword phrases down to 10 - 15 unique words or phrases;<br> (2) separate the words or phrases using a comma (you do not need to leave a space between words separated by commas); <br>(3) do not repeat words or phrases; <br>(4) put your most important word or phrases at the beginning of your list.'),
('metaDescription', 'Meta Description', '', 'General', 'textarea', 0, 'The meta description is a meta tag that is used to describe the current Web page. It provides a short summary of the page so that readers can decide whether the page is what they are looking for or looks interesting.'),
('enableGoogleAdsense', 'Enable Google Adsense', 'N', 'General', 'checkbox', 0, 'Enable this if you have a Google AdSense account. '),
('googleAdsense', 'Google Adsense', '', 'General', 'textarea', 0, 'If you have an AdSense account, enter your code here for analytics purposes.'),
('enablepaypal', 'Enable Paypal', 'N', 'Payment', 'checkbox', 0, ''),
('enablepaypalsandbox', 'Paypal Test Mode', 'N', 'Payment', 'checkbox', 0, ''),
('paypalidentitytoken', 'Paypal Identity Token', '', 'Payment', '', 0, ''),
('paypalemail', 'Paypal Email', '', 'Payment', '', 0, ''),
('paypal_api_username', 'Paypal username', '', 'Payment', '', 0, ''),
('paypal_api_password', 'Paypal Password', '', 'Payment', '', 0, ''),
('paypal_api_signature', 'Paypal Signature', '', 'Payment', '', 0, ''),
('paypal_application_app_id', 'Paypal Application ID', '', 'Payment', '', 0, ''),
('authorize_enable', 'Enable Authorize.Net ', 'N', 'Payment', '', 0, 'Note : Authorize.Net will support only US dollars.'),
('authorize_loginid', 'Authorize.Net Login Id', '', 'Payment', '', 0, ''),
('authorize_transkey', 'Authorize.Net Transaction Key', '', 'Payment', '', 0, ''),
('nFeatured_Amount', 'Featured Amount', '', 'General', '', 0, ''),
('authorize_email', 'Authorize.Net Email', '', 'Payment', '', 0, ''),
('authorize_test_mode', 'Authorize.Net Test Mode', 'N', 'Payment', 'checkbox', 0, ''),
('admin_currency', 'Currency', 'USD', 'General', '', 0, ''),
('currency_symbol', 'Currency Symbol', '$', 'General', '', 0, 'Currency symbol for transaction'),
('enable_multicurrency', 'Enable Multicurrency', 'N', 'General', 'checkbox', 0, ''),
('banner_link', 'Banner Link', '', 'General', '', 0, ''),
('googleAnalytics', 'Google Analytics', '', 'General', 'textarea', 0, 'Add Google Analytics code here if you wish to track your site activities'),
('godaddy_id', 'GoDaddy API Login ID', '', 'Domain Registrar', '', 0, ''),
('link', 'Click link to certify your Godaddy account', '', 'Domain Registrar', 'link', 0, ''),
('godaddy_password', 'GoDaddy API Password ', '', 'Domain Registrar', '', 0, ''),
('godaddy_testmode', 'GoDaddy Test Mode', 'N', 'Domain Registrar', 'checkbox', 0, ''),
('enable_fb', 'Enable Facebook', 'N', 'Social Settings', 'checkbox', 0, 'Would you like your site linked to Facebook?'),
('facebookUrl', 'Facebook Link', '', 'Social Settings', '', 0, ''),
('enable_twitter', 'Enable Twitter', 'N', 'Social Settings', 'checkbox', 0, 'Would you like your site linked to Twitter?'),
('twitterUrl', 'Twitter Link', '', 'Social Settings', '', 0, ''),
('enable_ln', 'Enable LinkedIn', 'N', 'Social Settings', 'checkbox', 0, ''),
('linkedInUrl', 'LinkedIn Link', '', 'Social Settings', '', 0, ''),
('yourpay_pemfile', 'YourPay PEM file', '', 'Payment', '', 0, ''),
('twoco_testmode', 'Twocheckout Test Mode', 'N', 'Payment', 'checkbox', 0, ''),
('twoco_vendorId', 'Twocheckout Vendor Id', '', 'Payment', '', 0, ''),
('paypalpro_testmode', 'Paypalpro Test Mode', 'N', 'Payment', 'checkbox', 0, ''),
('twoco_enable', 'Enable Twocheckout', 'N', 'Payment', 'checkbox', 0, ''),
('paypalpro_password', 'Paypalpro Password', '', 'Payment', '', 0, ''),
('paypalpro_enable', 'Enable Paypalpro', 'N', 'Payment', 'checkbox', 0, ''),
('paypalpro_username', 'Paypalpro User Name', '', 'Payment', '', 0, ''),
('paypalpro_signature', 'Paypalpro Signature', '', 'Payment', '', 0, ''),
('payflow_password', 'Paypalflow Password', '', 'Payment', '', 0, ''),
('paypalexpress_testmode', 'Paypal Express Test Mode', 'N', 'Payment', 'checkbox', 0, ''),
('paypalexpress_signature', 'Paypal Express Signature', '', 'Payment', '', 0, ''),
('paypalexpress_password', 'Paypal Express Password', '', 'Payment', '', 0, ''),
('paypalexpress_username', 'PayPal Express Username', '', 'Payment', '', 0, ''),
('paypalexpress_enable', 'Enable Paypal Express', 'N', 'Payment', 'checkbox', 0, ''),
('paypaladvanced_password', 'Paypal Advanced Password', '', 'Payment', '', 0, ''),
('paypaladvanced_username', 'Paypal Advanced Username', '', 'Payment', '', 0, ''),
('paypalflowlink_enable', 'Enable Paypal Flow link', 'N', 'Payment', 'checkbox', 0, ''),
('paypalflowlink_partnerid', 'Payflow Link Partner ID', '', 'Payment', '', 0, ''),
('paypalflowlink_vendorid', 'Payflow Link Vendor ID', '', 'Payment', '', 0, ''),
('paypalflowlink_testmode', 'Payflow Link Test Mode', 'N', 'Payment', 'checkbox', 0, ''),
('ogone_enable', 'Enable Ogone', 'N', 'Payment', 'checkbox', 0, ''),
('ogone_partnerid', 'Ogone PSPID', '', 'Payment', '', 0, ''),
('ogone_vendorid', 'Ogone Passphrase', '', 'Payment', '', 0, ''),
('ogone_testmode', 'Ogone Test Mode', 'N', 'Payment', 'checkbox', 0, ''),
('moneybookers_enable', 'Enable Moneybookers', 'N', 'Payment', 'checkbox', 0, ''),
('moneybookers_emailid', 'Money Booker Email Id ', '', 'Payment', '', 0, ''),
('moneybookers_testmode', 'Money Bookers Test Mode', 'N', 'Payment', 'checkbox', 0, ''),
('braintree_enable', 'Enable Braintree', 'N', 'Payment', 'checkbox', 0, ''),
('braintree_merchantId', 'Braintree Merchant ID', '', 'Payment', '', 0, ''),
('braintree_publickey', 'Braintree Public Key', '', 'Payment', '', 0, ''),
('braintree_privatekey', 'Braintree Private Key', '', 'Payment', '', 0, ''),
('braintree_testmode', 'Braintree Test Mode', 'N', 'Payment', 'checkbox', 0, ''),
('paypaladvanced_vendorid', 'Paypal Advanced Vendor ID', '', 'Payment', '', 0, ''),
('paypaladvanced_enable', 'Enable Paypal Advanced', 'N', 'Payment', 'checkbox', 0, ''),
('streamsend_enable', 'Enable Streamsend', 'N', 'General', 'checkbox', 0, 'Enable this if you want to bulk email your customers'),
('streamsend_loginid', 'Streamsend Login ID', '', 'General', '', 0, 'LoginId of http://streamsend.com/ account '),
('streamsend_key', 'Streamsend Key', '', 'General', '', 0, 'Key generated from http://streamsend.com/ account'),
('streamsend_listid', 'Streamsend List ID', '', 'General', '', 0, 'List Id from http://streamsend.com/'),
('paypaladvanced_partnerid', 'Paypal Advanced Partner ID', '', 'Payment', '', 0, ''),
('paypaladvanced_testmode', 'Paypal Advanced Test Mode', 'N', 'Payment', 'checkbox', 0, ''),
('company_name', 'Company Name', '', 'General', '', 0, 'Enter your company name'),
('company_address', 'Company Address', '', 'General', 'textarea', 0, ''),
('company_website', 'Company Website', '', 'General', '', 0, 'Enter your company website'),
('company_email', 'Company Email', '', 'General', '', 0, 'Enter your company email'),
('company_phone', 'Company Phone', '', 'General', '', 0, 'Enter your company phone'),
('enable_googlecheckout', 'Enable Google Checkout', 'N', 'Payment', '', 0, ''),
('gcheck_merchant_id', 'Google Checkout Merchant id', '', 'Payment', '', 0, ''),
('gcheck_merchant_key', 'Google Checkout Merchant key', '', 'Payment', '', 0, ''),
('gcheck_server_type', 'Google Checkout Server Type', '', 'Payment', '', 0, ''),
('gcheck_currency', 'Google Checkout Currency', '', 'Payment', '', 0, ''),
('gcheck_btn_checkout', 'Google Checkout Button Type', '', 'Payment', '', 0, ''),
('yourpay_enable', 'Enable Yourpay', 'N', 'Payment', '', 0, ''),
('yourpay_storeid', 'Yourpay Store ID', '', 'Payment', '', 0, ''),
('yourpay_demo', 'Yourpay Demo', 'N', 'Payment', '', 0, ''),
('enom_password', 'Enom Password', '', 'Domain Registrar', '', 0, ''),
('enom_testmode', 'Enom Testmode', 'N', 'Domain Registrar', 'checkbox', 0, ''),
('enom_user', 'Enom User', '', 'Domain Registrar', '', 4, ''),
('domain_registrar', 'Domain Registrar', '', 'Domain Registrar', '', 6, 'Domain'),
('quickbook_appname', 'Quickbook Application Name', '', 'Payment', '', 0, ''),
('quickbook_key', 'Quickbook Key', '', 'Payment', '', 0, ''),
('quickbook_enable', 'Enable Quickbooke', 'N', 'Payment', '', 0, ''),
('quickbook_testmode', 'Quickbook Test Mode', 'N', 'Payment', '', 0, ''),
('name_server_1', 'Name Server 1', '', 'Name Servers', '', 1, ''),
('name_server_2', 'Name Server 2', '', 'Name Servers', '', 2, ''),
('name_server_3', 'Name Server 3', '', 'Name Servers', '', 3, ''),
('name_server_4', 'Name Server 4', '', 'Name Servers', '', 4, ''),
('paypalflow_enable', 'Enable Payflow', 'N', 'Payment', 'checkbox', 0, ''),
('paypalflow_partnerid', 'Payflow Partner ID', '', 'Payment', '', 0, ''),
('paypalflow_vendorid', 'Payflow Vendorid', '', 'Payment', '', 0, ''),
('payflowlink_password', 'Payflowlink Password', '', 'Payment', '', 0, ''),
('paypalflow_testmode', 'Payflow Test Mode', 'N', 'Payment', 'checkbox', 0, ''),
('site_email', 'Site Email', '', 'General', '', 0, ''),
('site_phone', 'Site Phone', '', 'General', '', 0, ''),
('company_phone_internat', 'Company Phone(International)', '', 'General', '', 0, 'Enter your company phone'),
('whm_host', 'WHM Host', NULL, 'Hosting', '', 0, ''),
('whm_user', 'WHM Username', NULL, 'Hosting', '', 0, ''),
('whm_pass', 'WHM Password', NULL, 'Hosting', '', 0, ''),
('whm_package', 'WHM Package', NULL, 'Hosting', '', 0, ''),
('whm_ip', 'WHM IP', NULL, 'Hosting', '', 0, ''),
('whm_product_pack_location', '', NULL, '', '', 0, ''),
('whm_landing_location', '', NULL, '', '', 0, ''),
('priceDomiainRegistration', 'Price of Domain Registration Plan', '', 'Domain Registrar', '', 0, ''),
('licenseKey', 'License Key', '', 'General', '', 0, 'Your license key is emailed to you after purchase. The license key should be entered here to verify and activate the software.'),
('recaptcha_enable', 'Enable Recaptcha', 'N', 'General', '', 0, 'You can enable / disable recaptcha in site.'),
('recaptcha_public_key', 'Recaptcha Public Key', '', 'General', '', 0, 'Enter Recaptcha Public Key'),
('recaptcha_private_key', 'Recaptcha Private Key', '', 'General', '', 0, 'Enter Recaptcha Private Key');


INSERT INTO `goStores_themes` (`theme_id`, `theme_title`, `theme_name`, `theme_status`, `theme_thumbnail`) VALUES
(1, 'Clean Grey', 'theme1', 1, '<img style="width:60px; height:60px; " src="http://localhost/gostores/project/styles/themes/theme1/preview.jpg">'),
(2, 'Aqua Blue', 'theme2', 0, ' <img style="width:60px; height:60px; " src="http://localhost/gostores/project/styles/themes/theme2/preview.jpg">'),
(3, 'Elegent Red', 'theme3', 0, '<img style="width:60px; height:60px; " src="http://localhost/gostores/project/styles/themes/theme3/preview.jpg">'),
(4, 'Emerald Green', 'theme4', 0, '<img style="width:60px; height:60px; " src="http://localhost/gostores/project/styles/themes/theme4/preview.jpg">'),
(5, 'Lifestyle', 'theme5', 0, '<img style="width:60px; height:60px; " src="http://localhost/gostores/project/styles/themes/theme5/preview.jpg">');

INSERT INTO `goStores_tld` (`id`, `registrar`, `tld`, `register_fee`, `renewal_fee`, `transfer_fee`, `tocidreg`, `tocidren`, `tocidtra`) VALUES
(11, 'ENOM', 'biz', 10.00, 10.00, 10.00, '', '', ''),
(12, 'ENOM', 'com', 10.00, 10.00, 10.00, '', '', ''),
(13, 'ENOM', 'info', 10.00, 10.00, 10.00, '', '', ''),
(14, 'ENOM', 'mobi', 10.00, 10.00, 10.00, '', '', ''),
(15, 'ENOM', 'name', 10.00, 10.00, 10.00, '', '', ''),
(16, 'ENOM', 'net', 10.00, 10.00, 10.00, '', '', ''),
(17, 'ENOM', 'org', 10.00, 10.00, 10.00, '', '', ''),
(20, 'ENOM', 'ca', 10.00, 10.00, 10.00, '', '', '');


INSERT INTO `goStores_Vista_admins` (`id`, `admin_name`, `admin_pword`, `settings`, `custom`, `category`, `products`, `feedback`, `users`, `orders`, `refund`, `promocodes`, `websitecontent`, `reports`, `homepage`, `help`, `adminusers`, `newsletter`, `newsletterusers`, `sentnewsletters`, `giftcards`, `giftcardusers`, `email`, `blog_pword`) VALUES
(1, 'admin', '21232f297a57a5a743894a0e4a801fc3', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '', 'admin');

INSERT INTO `goStores_Vista_categories` (`id`, `cname`, `parent_id`, `custom_combination`) VALUES (1, 'Root', 0, '');

INSERT INTO `goStores_Vista_cmspages` (`id`, `title`, `content`, `type`, `status`) VALUES
(1, 'Order confirm mail', '<p>&nbsp;</p>\r\n<p>Dear [User_Name],</p>\r\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Your order has been successfully placed at [SITE_NAME]. The order details is follows.</p>\r\n<p>[ORDER_DETAILS]</p>\r\n<p>Thanks,</p>\r\n<p>Administrator , [SITE_NAME]</p>', 'email', 'Y'),
(2, 'Registration intimation mail to admin', '<h3 style="color: Red;">&nbsp;</h3>\r\n<h3 style="color: Red;">Hi Admin,</h3>\r\n<h3 style="color: Red;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; A new user&nbsp; [User_Name]&nbsp; is registered with [SITE_NAME].</h3>\r\n<h3 style="color: Red;">&nbsp;</h3>\r\n<h3 style="color: Red;">Thanks,</h3>\r\n<h3 style="color: Red;">Staff. [SITE_NAME]</h3>', 'email', 'Y'),
(3, 'AboutUS', '<h2>Who We Are</h2>\r\n<p class="style1">Hello, and welcome to Online Toys.</p>\r\n<p class="style1">Online Toys is owned and operated by our  family owned company - American Online Commerce Pty. Ltd. We are a purely internet based toy store which means we  specialise in the sale of toys only through the World Wide Web. We are  an independent toy retailer and we are located at Los Angeles. Our web site www.etoys.com officially  opened for business October 2010 with the ultimate aim of one day  becoming America''s best known, and loved, online toy store.</p>\r\n<p class="style1">We despatch orders US-wide and to several  international destinations. We allow customer pickups, customer  enquiries via phone or email, and in many cases we can ship orders same  day. Our warehouse allows us to hold stock while our web site tracks  stock in real-time so we can despatch orders quickly and efficiently at  all times.</p>\r\n<p class="style2">Our goals are to:</p>\r\n<table width="100%" cellspacing="5" cellpadding="0" border="0">\r\n    <tbody>\r\n        <tr>\r\n            <td>\r\n            <ul>\r\n                <li class="style1">Provide our customers with a great selection of toys,</li>\r\n                <li class="style1">Offer the toys at the lowest possible price,</li>\r\n                <li class="style1">Provide a friendly, fast, and reliable service at all times,</li>\r\n                <li class="style1">Give our customers total piece-of-mind should anything go wrong,</li>\r\n                <li class="style1">And make our store as easy as possible to use and navigate.</li>\r\n            </ul>\r\n            </td>\r\n        </tr>\r\n    </tbody>\r\n</table>', 'content', 'Y'),
(4, 'Forgot password mail', '<p>Hi [User_Name],</p>\r\n<p>&nbsp; Your Password on [SITE_NAME] has been reset. </p>\r\n<p>Your new password is&nbsp; :&nbsp; [PASSWORD]</p>\r\n<p>&nbsp;</p>\r\n<p>Thanks,</p>\r\n<p>Administrator&nbsp; [SITE_NAME]</p>', 'email', 'Y'),
(5, 'Registration confirm mail', '<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p><em><span style="font-size: larger;">Hi Dear [User_Name],<br />\r\n</span></em></p>\r\n<p><em><span style="font-size: larger;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Your Registration with&nbsp; [SITE_NAME] is completed......<br />\r\n</span></em></p>\r\n<p><em><span style="font-size: larger;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Your User Name is&nbsp; : [User_Name]</span></em> </p>\r\n<p>&nbsp;&nbsp;<em><span style="font-size: larger;">&nbsp;&nbsp;&nbsp; Your Password is&nbsp;&nbsp;&nbsp;&nbsp; :&nbsp; [PASSWORD]</span></em></p>\r\n<p><em><span style="font-size: larger;">&nbsp; [LOGIN_URL]<br />\r\n</span></em></p>\r\n<p><em><span style="font-size: larger;">Thanks and Regards,<br />\r\n</span></em></p>\r\n<p><em><span style="font-size: larger;">Administrator [SITE_NAME]<br />\r\n</span></em></p>', 'email', 'Y'),
(6, 'Order status change mail', '<p>Dear [User_Name],</p>\r\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Your order&nbsp; status has been changed at [SITE_NAME]. The order details is follows.</p>\r\n<p>[ORDER_DETAILS]</p>\r\n<p>Thanks,</p>\r\n<p>Administrator , [SITE_NAME]</p>', 'email', 'Y'),
(7, 'FAQ', '<p><b>Frequently Asked Questions</b>&nbsp;</p>\r\n<p><strong>Q:&nbsp;</strong> &nbsp;&nbsp;&nbsp; My toy has arrived broken. What do I do?<br />\r\n<strong>A: </strong>&nbsp;&nbsp;&nbsp; If you suspect that the toy you ordered from us is damaged, please do not accept delivery. Ask the driver/postman that it be returned to sender by crossing out your delivery address and writing, in big letters, &quot;RTS&quot; (Return To Sender). Notify us of what''s happened and we will take care of the rest by having a replacement toy sent out to you once the damaged toy is received by us.<br />\r\n<br />\r\nIf, on the other hand, you accepted delivery and discovered your toy to be broken much later, don''t stress. The first thing to do is to notify us about the problem, we will provide you with a special number called a Return Merchandise Authority (RMA) number and further instructions. Repack the damaged toy, in its original packaging, together with the original receipt (if you have one) and everything else that came with it and return it back to us using the ''Reply Paid'' address we give you. A replacement toy will be sent to you once the damaged toy is received by us.<br />\r\n<br />\r\n<strong>Q:&nbsp;</strong> &nbsp;&nbsp;&nbsp; How does the Customer Reward Points programme work?<br />\r\n<strong>A: </strong>&nbsp;&nbsp;&nbsp; In a nutshell, you will receive 10 points for every $1 you spend. Toys labelled &quot;BONUS&quot; will reward you with more points (sometimes twice more). You can accumulate your points (and save for something big) or you can use them upon subsequent visits. The choice is yours. To convert points back into dollars, you will need 250 points to make up $1. Please click here for further information and click on the &quot;Terms &amp; Conditions&quot; tab above to read our Terms &amp; Conditions.<br />\r\n<br />\r\n<br />\r\n<strong>Q:&nbsp;</strong> &nbsp;&nbsp;&nbsp; I bought the wrong toy. What do I do?<br />\r\nA: &nbsp;&nbsp;&nbsp; It is important that when selecting the toy you want that you do so carefully. We understand that many toys look the same, some of them have very similar names, while others do exactly the same things, however, we cannot be held responsible if you make a wrong selection or change your mind.<br />\r\n<br />\r\nIf you are unsure about anything, we are here to help. Please use our Live Help service, email, or call us by telephone and ask us questions that will help you make the right choice. <br />\r\n<br />\r\n<strong>Q:&nbsp;</strong> &nbsp;&nbsp;&nbsp; Can I pay by cheque?<br />\r\n<strong>A: &nbsp;</strong>&nbsp;&nbsp; Yes you can. In addition to credit cards, we also accept bank cheques, personal cheques, and money orders. But please keep in mind that no orders will be despatched until cheque payments have been cleared by the bank. Cheques normally take around 3 working days to clear.<br />\r\n<br />\r\n<strong>Q:&nbsp;</strong> &nbsp;&nbsp;&nbsp; I''ve selected a gift-tag, why cant I include a message?<br />\r\n<strong>A: </strong>&nbsp;&nbsp;&nbsp; Gift-tags generally are not very big which means after including the recipients and senders names there generally isn''t much room for anything else. However, our Greeting Cards do have the option to include messages if required.<br />\r\n<br />\r\n<strong>Q:&nbsp;</strong> &nbsp;&nbsp;&nbsp; Do you sell/trade on eBay?<br />\r\n<strong>A: &nbsp;</strong>&nbsp;&nbsp; No, we don''t.</p>', 'content', 'Y'),
(8, 'Terms', '<p class="style1">By continuing to browse, shop, purchase, and view  content on the Online Toys US web site, you , any person, body,  company, or institution acting on your behalf, the customer or visitor  is deemed to fully and unconditionally agree to these Terms &amp;  Conditions. You are bound by these Terms and Conditions so long as you  continue to shop, buy, or browse this web site. This web site is  governed and protected by the state judicial laws of Victoria and  Federal Laws of US .</p>\r\n<p><strong class="style2">Copyright</strong></p>\r\n<p class="style1">All content/material found on our web site is owned by  Online Toys US and is protected by United States, and international  copyright laws. Such content/material includes, but is not limited to,  text, images, logos, buttons, software code, audio, and video. Where  content is supplied by external provides, including manufacturers,  wholesalers, and distributors, such content is deemed to be owned by the  said organisations and are likewise protected by copyright laws. No  content/material may be used, in any way, without the written permission  of Online Toys US , its parent company, or original copyright  owners.</p>\r\n<p class="style1">You are prohibited from transmitting, broadcasting,  editing, adapting, or making use of any intellectual property,  trademarks, or logos owned and found on the Online Toys&nbsp;US  web  site without the expressed permission of Online Toys United Statesor its  parent company.</p>\r\n<p class="style1">As a result of browsing the Online Toys US  web  site where content is downloaded, printed, or viewed, such content is  permissible for private, non-commercial use for the sole purpose of  evaluating goods, making a purchase of goods, or promoting the sale of  goods to others.</p>\r\n<p><strong class="style2">Security</strong></p>\r\n<p class="style1">The integrity and security of information between you  and our web site cannot be assured or guaranteed to the full extent.  Likewise, we cannot and will not accept responsibility for the safe  keeping, transmitting, and the overall security of information sent to  and from our web site/server(s). The customer, visitor, or any other  person should take steps to ensure they are protected by relevant  third-party software including, but not limited to, firewall software,  anti-virus software, and other security protection software at all  times. Failure to do so may result in adverse and undesirable effects to  your computer as well as the potential loss and/or theft of sensitive  information. Whilst efforts are made to reduce such risk on our  server(s), the customer, visitor, or any other person acknowledges that  any information sent to or from our web site, is done so at their own  risk.</p>\r\n<p><strong class="style2">Access and Restrictions</strong></p>\r\n<p class="style1">From time to time, access to our web site may be denied for any one or all of the following reasons:</p>\r\n<p class="style1">a)	Maintenance and/or repair,<br />\r\nb)	Upgrades and enhancements,<br />\r\nc)	Server downtime/failure,<br />\r\nd)	Systems downtime/failure,<br />\r\ne)	Software corruption/failure.</p>\r\n<p class="style1">Online Toys US  may, at its own discretion,  prevent a customer, visitor, or any other person from gaining access to  our web site through any means/technologies available at it&rsquo;s disposal.  Any person identified as a potential security threat or anyone who has  attempted to claim/purchase goods in a fraudulent or dishonest manner  will immediately have their IP blocked. Where State or Federal laws are  broken or a crime is committed towards the store, Online Toys US may also report  such matters to the appropriate law enforcing bodies,  Government agencies, and/or Federal bureaus.</p>\r\n<p><strong class="style2">Payment</strong></p>\r\n<p class="style1">Payment for goods purchased is not final until funds  have been cleared. This means that no goods or services will be provided  until monies have been cleared by the relevant financial institutions,  processed and approved by all parties concerned,  all financial entities  are satisfied  that fraud, deceptive, or misleading conduct had not  been carried out, and the full purchase amount had been credited to the  online Toys US bank account.</p>\r\n<p><strong class="style2">Store Sale/Promotions</strong></p>\r\n<p class="style1">Online Toys US will offer, from time to time,  either exclusively or to the general public at large, products at  reduced prices (otherwise commonly known as a ''Sale''). Customers who  place orders for sale items will be deemed to have read, and agree to,  all the terms and conditions, placed by Online Toys US , for that  particular sale. Such terms and conditions will be placed behind  promotional banners or made available through text links throughout the  store.</p>', 'content', 'Y'),
(12, 'Order payment received mail', '<p>Dear [User_Name],</p>\r\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Your order&nbsp; payment has been received at [SITE_NAME]. The order details is follows.</p>\r\n<p>[ORDER_DETAILS]</p>\r\n<p>Thanks,</p>\r\n<p>Administrator , [SITE_NAME]</p>', 'email', 'Y'),
(9, 'Admin order confirm mail', '<p>&nbsp;</p>\r\n<p>Dear Administrator,</p>\r\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; An Order has been successfully placed at [SITE_NAME]. The order details is follows.</p>\r\n<p>[ORDER_DETAILS]</p>', 'email', 'Y'),
(10, 'Testimonials', 'Add Testimonials Here...............................', 'content', 'N'),
(11, 'Community', 'Add Community details Here...............................', 'content', 'N');



INSERT INTO `goStores_Vista_countries` (`country_id`, `country_name`, `country_iso_code_2`) VALUES
(1, 'Afghanistan', 'AF'),
(2, 'Albania', 'AL'),
(3, 'Algeria', 'DZ'),
(4, 'American Samoa', 'AS'),
(5, 'Andorra', 'AD'),
(6, 'Angola', 'AO'),
(7, 'Anguilla', 'AI'),
(8, 'Antarctica', 'AQ'),
(9, 'Antigua and Barbuda', 'AG'),
(10, 'Argentina', 'AR'),
(11, 'Armenia', 'AM'),
(12, 'Aruba', 'AW'),
(13, 'Australia', 'AU'),
(14, 'Austria', 'AT'),
(15, 'Azerbaijan', 'AZ'),
(16, 'Bahamas', 'BS'),
(17, 'Bahrain', 'BH'),
(18, 'Bangladesh', 'BD'),
(19, 'Barbados', 'BB'),
(20, 'Belarus', 'BY'),
(21, 'Belgium', 'BE'),
(22, 'Belize', 'BZ'),
(23, 'Benin', 'BJ'),
(24, 'Bermuda', 'BM'),
(25, 'Bhutan', 'BT'),
(26, 'Bolivia', 'BO'),
(27, 'Bosnia and Herzegowina', 'BA'),
(28, 'Botswana', 'BW'),
(29, 'Bouvet Island', 'BV'),
(30, 'Brazil', 'BR'),
(31, 'British Indian Ocean Territory', 'IO'),
(32, 'Brunei Darussalam', 'BN'),
(33, 'Bulgaria', 'BG'),
(34, 'Burkina Faso', 'BF'),
(35, 'Burundi', 'BI'),
(36, 'Cambodia', 'KH'),
(37, 'Cameroon', 'CM'),
(38, 'Canada', 'CA'),
(39, 'Cape Verde', 'CV'),
(40, 'Cayman Islands', 'KY'),
(41, 'Central African Republic', 'CF'),
(42, 'Chad', 'TD'),
(43, 'Chile', 'CL'),
(44, 'China', 'CN'),
(45, 'Christmas Island', 'CX'),
(46, 'Cocos (Keeling) Islands', 'CC'),
(47, 'Colombia', 'CO'),
(48, 'Comoros', 'KM'),
(49, 'Congo', 'CG'),
(50, 'Cook Islands', 'CK'),
(51, 'Costa Rica', 'CR'),
(52, 'Cote D''Ivoire', 'CI'),
(53, 'Croatia', 'HR'),
(54, 'Cuba', 'CU'),
(55, 'Cyprus', 'CY'),
(56, 'Czech Republic', 'CZ'),
(57, 'Denmark', 'DK'),
(58, 'Djibouti', 'DJ'),
(59, 'Dominica', 'DM'),
(60, 'Dominican Republic', 'DO'),
(61, 'East Timor', 'TP'),
(62, 'Ecuador', 'EC'),
(63, 'Egypt', 'EG'),
(64, 'El Salvador', 'SV'),
(65, 'Equatorial Guinea', 'GQ'),
(66, 'Eritrea', 'ER'),
(67, 'Estonia', 'EE'),
(68, 'Ethiopia', 'ET'),
(69, 'Falkland Islands (Malvinas)', 'FK'),
(70, 'Faroe Islands', 'FO'),
(71, 'Fiji', 'FJ'),
(72, 'Finland', 'FI'),
(73, 'France', 'FR'),
(74, 'France, Metropolitan', 'FX'),
(75, 'French Guiana', 'GF'),
(76, 'French Polynesia', 'PF'),
(77, 'French Southern Territories', 'TF'),
(78, 'Gabon', 'GA'),
(79, 'Gambia', 'GM'),
(80, 'Georgia', 'GE'),
(81, 'Germany', 'DE'),
(82, 'Ghana', 'GH'),
(83, 'Gibraltar', 'GI'),
(84, 'Greece', 'GR'),
(85, 'Greenland', 'GL'),
(86, 'Grenada', 'GD'),
(87, 'Guadeloupe', 'GP'),
(88, 'Guam', 'GU'),
(89, 'Guatemala', 'GT'),
(90, 'Guinea', 'GN'),
(91, 'Guinea-bissau', 'GW'),
(92, 'Guyana', 'GY'),
(93, 'Haiti', 'HT'),
(94, 'Heard and Mc Donald Islands', 'HM'),
(95, 'Honduras', 'HN'),
(96, 'Hong Kong', 'HK'),
(97, 'Hungary', 'HU'),
(98, 'Iceland', 'IS'),
(99, 'India', 'IN'),
(100, 'Indonesia', 'ID'),
(101, 'Iran (Islamic Republic of)', 'IR'),
(102, 'Iraq', 'IQ'),
(103, 'Ireland', 'IE'),
(104, 'Israel', 'IL'),
(105, 'Italy', 'IT'),
(106, 'Jamaica', 'JM'),
(107, 'Japan', 'JP'),
(108, 'Jordan', 'JO'),
(109, 'Kazakhstan', 'KZ'),
(110, 'Kenya', 'KE'),
(111, 'Kiribati', 'KI'),
(112, 'Korea, Democratic People''s Republic of', 'KP'),
(113, 'Korea, Republic of', 'KR'),
(114, 'Kuwait', 'KW'),
(115, 'Kyrgyzstan', 'KG'),
(116, 'Lao People''s Democratic Republic', 'LA'),
(117, 'Latvia', 'LV'),
(118, 'Lebanon', 'LB'),
(119, 'Lesotho', 'LS'),
(120, 'Liberia', 'LR'),
(121, 'Libyan Arab Jamahiriya', 'LY'),
(122, 'Liechtenstein', 'LI'),
(123, 'Lithuania', 'LT'),
(124, 'Luxembourg', 'LU'),
(125, 'Macau', 'MO'),
(126, 'Macedonia, The Former Yugoslav Republic of', 'MK'),
(127, 'Madagascar', 'MG'),
(128, 'Malawi', 'MW'),
(129, 'Malaysia', 'MY'),
(130, 'Maldives', 'MV'),
(131, 'Mali', 'ML'),
(132, 'Malta', 'MT'),
(133, 'Marshall Islands', 'MH'),
(134, 'Martinique', 'MQ'),
(135, 'Mauritania', 'MR'),
(136, 'Mauritius', 'MU'),
(137, 'Mayotte', 'YT'),
(138, 'Mexico', 'MX'),
(139, 'Micronesia, Federated States of', 'FM'),
(140, 'Moldova, Republic of', 'MD'),
(141, 'Monaco', 'MC'),
(142, 'Mongolia', 'MN'),
(143, 'Montserrat', 'MS'),
(144, 'Morocco', 'MA'),
(145, 'Mozambique', 'MZ'),
(146, 'Myanmar', 'MM'),
(147, 'Namibia', 'NA'),
(148, 'Nauru', 'NR'),
(149, 'Nepal', 'NP'),
(150, 'Netherlands', 'NL'),
(151, 'Netherlands Antilles', 'AN'),
(152, 'New Caledonia', 'NC'),
(153, 'New Zealand', 'NZ'),
(154, 'Nicaragua', 'NI'),
(155, 'Niger', 'NE'),
(156, 'Nigeria', 'NG'),
(157, 'Niue', 'NU'),
(158, 'Norfolk Island', 'NF'),
(159, 'Northern Mariana Islands', 'MP'),
(160, 'Norway', 'NO'),
(161, 'Oman', 'OM'),
(162, 'Pakistan', 'PK'),
(163, 'Palau', 'PW'),
(164, 'Panama', 'PA'),
(165, 'Papua New Guinea', 'PG'),
(166, 'Paraguay', 'PY'),
(167, 'Peru', 'PE'),
(168, 'Philippines', 'PH'),
(169, 'Pitcairn', 'PN'),
(170, 'Poland', 'PL'),
(171, 'Portugal', 'PT'),
(172, 'Puerto Rico', 'PR'),
(173, 'Qatar', 'QA'),
(174, 'Reunion', 'RE'),
(175, 'Romania', 'RO'),
(176, 'Russian Federation', 'RU'),
(177, 'Rwanda', 'RW'),
(178, 'Saint Kitts and Nevis', 'KN'),
(179, 'Saint Lucia', 'LC'),
(180, 'Saint Vincent and the Grenadines', 'VC'),
(181, 'Samoa', 'WS'),
(182, 'San Marino', 'SM'),
(183, 'Sao Tome and Principe', 'ST'),
(184, 'Saudi Arabia', 'SA'),
(185, 'Senegal', 'SN'),
(186, 'Seychelles', 'SC'),
(187, 'Sierra Leone', 'SL'),
(188, 'Singapore', 'SG'),
(189, 'Slovakia (Slovak Republic)', 'SK'),
(190, 'Slovenia', 'SI'),
(191, 'Solomon Islands', 'SB'),
(192, 'Somalia', 'SO'),
(193, 'South Africa', 'ZA'),
(194, 'South Georgia and the South Sandwich Islands', 'GS'),
(195, 'Spain', 'ES'),
(196, 'Sri Lanka', 'LK'),
(197, 'St. Helena', 'SH'),
(198, 'St. Pierre and Miquelon', 'PM'),
(199, 'Sudan', 'SD'),
(200, 'Suriname', 'SR'),
(201, 'Svalbard and Jan Mayen Islands', 'SJ'),
(202, 'Swaziland', 'SZ'),
(203, 'Sweden', 'SE'),
(204, 'Switzerland', 'CH'),
(205, 'Syrian Arab Republic', 'SY'),
(206, 'Taiwan', 'TW'),
(207, 'Tajikistan', 'TJ'),
(208, 'Tanzania, United Republic of', 'TZ'),
(209, 'Thailand', 'TH'),
(210, 'Togo', 'TG'),
(211, 'Tokelau', 'TK'),
(212, 'Tonga', 'TO'),
(213, 'Trinidad and Tobago', 'TT'),
(214, 'Tunisia', 'TN'),
(215, 'Turkey', 'TR'),
(216, 'Turkmenistan', 'TM'),
(217, 'Turks and Caicos Islands', 'TC'),
(218, 'Tuvalu', 'TV'),
(219, 'Uganda', 'UG'),
(220, 'Ukraine', 'UA'),
(221, 'United Arab Emirates', 'AE'),
(222, 'United Kingdom', 'GB'),
(223, 'United States', 'US'),
(224, 'United States Minor Outlying Islands', 'UM'),
(225, 'Uruguay', 'UY'),
(226, 'Uzbekistan', 'UZ'),
(227, 'Vanuatu', 'VU'),
(228, 'Vatican City State (Holy See)', 'VA'),
(229, 'Venezuela', 'VE'),
(230, 'Viet Nam', 'VN'),
(231, 'Virgin Islands (British)', 'VG'),
(232, 'Virgin Islands (U.S.)', 'VI'),
(233, 'Wallis and Futuna Islands', 'WF'),
(234, 'Western Sahara', 'EH'),
(235, 'Yemen', 'YE'),
(236, 'Yugoslavia', 'YU'),
(237, 'Zaire', 'ZR'),
(238, 'Zambia', 'ZM'),
(239, 'Zimbabwe', 'ZW');


INSERT INTO `goStores_Vista_currencies` VALUES (1, 'USD', 'USD - U.S. Dollars', '$');
INSERT INTO `goStores_Vista_currencies` VALUES (2, 'AUD', 'AUD - Australian Dollars', '$');
INSERT INTO `goStores_Vista_currencies` VALUES (3, 'GBP', 'GBP - British Pounds', '£');
INSERT INTO `goStores_Vista_currencies` VALUES (4, 'CAD', 'CAD - Canadian Dollars', '$');
INSERT INTO `goStores_Vista_currencies` VALUES (5, 'CZK', 'CZK - Czech Koruna', 'Kc');
INSERT INTO `goStores_Vista_currencies` VALUES (6, 'DKK', 'DKK - Danish Kroner', 'kr');
INSERT INTO `goStores_Vista_currencies` VALUES (7, 'EUR', 'EUR - Euros', '€');
INSERT INTO `goStores_Vista_currencies` VALUES (8, 'HKD', 'HKD - Hong Kong Dollars', 'HK$');
INSERT INTO `goStores_Vista_currencies` VALUES (9, 'HUF', 'HUF - Hungarian Forint', 'Ft');
INSERT INTO `goStores_Vista_currencies` VALUES (10, 'ILS', 'ILS - Israeli New Shekels', '?');
INSERT INTO `goStores_Vista_currencies` VALUES (11, 'JPY', 'JPY - Japanese Yen', '¥');
INSERT INTO `goStores_Vista_currencies` VALUES (12, 'MXN', 'MXN - Mexican Pesos', '$');
INSERT INTO `goStores_Vista_currencies` VALUES (13, 'NZD', 'NZD - New Zealand Dollars', '$');
INSERT INTO `goStores_Vista_currencies` VALUES (14, 'NOK', 'NOK - Norwegian Kroner', 'kr');
INSERT INTO `goStores_Vista_currencies` VALUES (15, 'PLN', 'PLN - Polish Zlotych', 'zl');
INSERT INTO `goStores_Vista_currencies` VALUES (16, 'SGD', 'SGD - Singapore Dollars', '$');
INSERT INTO `goStores_Vista_currencies` VALUES (17, 'SEK', 'SEK - Swedish Kronor', 'kr');
INSERT INTO `goStores_Vista_currencies` VALUES (18, 'CHF', 'CHF - Swiss Francs', 'CHF');


INSERT INTO `goStores_Vista_helps` (`id`, `title`, `content`, `type`, `order`) VALUES
(1, 'Home Page', '<ul>\r\n    <li><span class="rvts10">The List of categories will be displayed on the left side with the option to navigate to subcategories and the related products.</span></li>\r\n    <li>A list of featured products and their thumbnails are displayed with a &lsquo;view more&rsquo; button for the combined products. The &lsquo;Add to cart&rsquo; button is for products without combinations</li>\r\n    <li>If the user logged in is a whole sale user then the whole sale price of the products will be shown otherwise the retail price will be shown.</li>\r\n    <li>A list of 5 new products and 5 top rated items appear on the right side of the page with a link to the details page.</li>\r\n    <li>A user can search for any product by entering the keyword in the &lsquo;search box&rsquo; provided in the top right of the page. Enter the keyword, and then select &lsquo;Search&rsquo; and you will see a search results page. From there, make your selection.\r\n    <meta content="text/html; charset=utf-8" http-equiv="CONTENT-TYPE" />\r\n    <meta content="OpenOffice.org 3.1  (Win32)" name="GENERATOR" /><style type="text/css">\r\n	<!--\r\n		@page { margin: 0.79in }\r\n		P { margin-bottom: 0.08in }\r\n	-->\r\n	</style></li>\r\n</ul>\r\n<p><br />\r\n&nbsp;</p>', 'U', 0),
(2, 'Log in', '<ul>\r\n    <li>\r\n    <meta content="text/html; charset=utf-8" http-equiv="CONTENT-TYPE" />\r\n    <meta content="OpenOffice.org 3.1  (Win32)" name="GENERATOR" /><style type="text/css">\r\n	<!--\r\n		@page { margin: 0.79in }\r\n		P { margin-bottom: 0.08in }\r\n	--></style>A user can log in to the website using the log in link at the top of every page.</li>\r\n    <li>The user will then be asked to enter their user name and password.</li>\r\n    <li>The user can subscribe for Newsletters if needed.</li>\r\n    <li>The user will be registered as a Retail user by default.</li>\r\n    <li>When finished, the user will select the &lsquo;Log In&rsquo; button to enter the website.</li>\r\n</ul>', 'U', 0),
(3, 'Sign Up', '<ul>\r\n    <li>\r\n    <meta http-equiv="CONTENT-TYPE" content="text/html;\r\n    charset=utf-8">\r\n    <meta name="GENERATOR" content="OpenOffice.org 3.1\r\n    (Win32)">The user can sign up with the store by selecting the &lsquo;Sign Up&rsquo; link at the top of every page.          </meta>\r\n    </meta>\r\n    </li>\r\n    <li>In the sign up page, the user must enter their user name, password, re enter the password, and add an email address.</li>\r\n    <li>The user name must be unique and all fields are mandatory. Passwords are stored in the database in an encrypted format.</li>\r\n</ul>', 'U', 0),
(4, 'Forgot password', '<ul>\r\n    <li><span class="rvts10">The login&nbsp; page will have a link to forgot password  page.</span></li>\r\n    <li><span class="rvts10">A user can reset his/her password from the forgot  password page.</span></li>\r\n    <li>If the user provides a valid user name and email address, the store will reset the password and then email the new password to the user.</li>\r\n</ul>\r\n<p>&nbsp;</p>', 'U', 0),
(5, 'My Account', '<ul style="list-style-position: outside; text-indent: 0px; margin-left: 24px">\r\n    <li class="rvps2"><span class="rvts11">A&nbsp; My Account page link will be shown on the&nbsp; the top of every page for a logged in User.</span></li>\r\n    <li class="rvps2"><span class="rvts11">The My Account page will have links to&nbsp; </span><span class="rvts13">My Profile</span><span class="rvts11">,</span><a class="rvts13" href="file:///C:/Documents%20and%20Settings/Administrator/My%20Documents/Downloads/changes/fwvistacartedits/vistacartuserhelp/vistacartuserhelp/files/CartPage.html">My Cart</a><span class="rvts11">,</span><span class="rvts13"> My Orders</span><span class="rvts11">, My Shipping Address and My Billing Address pages.</span><span class="rvts11"><br />\r\n    </span>&nbsp;</li>\r\n</ul>\r\n<p class="rvps2" style="text-align: left"><strong><span class="rvts12">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></strong><span class="rvts12"><u><strong>My Profile</strong></u><br />\r\n</span></p>\r\n<ul style="list-style-position: outside; text-indent: 0px; margin-left: 24px">\r\n    <li><span class="rvts11">In this page,the user can edit&nbsp; his email address/password .</span></li>\r\n    <li><span class="rvts11">A user can view the items that has been added to the cart.</span></li>\r\n    <li><span class="rvts11">The user can remove any added item or update the quantity of a particular item.</span></li>\r\n    <li><span class="rvts11">The user can enter promo codes to get a discount.</span></li>\r\n    <li><span class="rvts11">The&nbsp; cart can contain either Digital or Non Digital products at a time.</span></li>\r\n    <li><span class="rvts11">The user can continue adding products to the cart by clicking on the Continue Shopping button.</span></li>\r\n    <li><span class="rvts11">The user can checkout by clicking on the checkout button.</span><span class="rvts11"><br />\r\n    </span></li>\r\n</ul>\r\n<p><strong><span class="rvts12">&nbsp;&nbsp;</span></strong><span class="rvts12">&nbsp;&nbsp;&nbsp;&nbsp;<strong> </strong><u><strong>My Orders</strong></u><br />\r\n</span></p>\r\n<ul style="list-style-position: outside; text-indent: 0px; margin-left: 24px">\r\n    <li><span class="rvts11">In this page, the user can view all their orders.</span><span class="rvts11"><br />\r\n    </span></li>\r\n</ul>\r\n<p class="rvps2"><strong><span class="rvts12">&nbsp;&nbsp;&nbsp;&nbsp; &nbsp; </span></strong><u><strong><span class="rvts12">My Billing Address</span></strong></u><span class="rvts12"><br />\r\n</span></p>\r\n<ul style="list-style-position: outside; text-indent: 0px; margin-left: 24px">\r\n    <li><span class="rvts11">In this page,the user can add/edit the Billing address Information . </span><u><strong><span class="rvts12"><br />\r\n    </span></strong></u></li>\r\n</ul>\r\n<p class="rvps2"><strong><span class="rvts12">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></strong><u><strong><span class="rvts12">My Shipping Address</span></strong></u><span class="rvts12"><br />\r\n</span></p>\r\n<ul style="list-style-position: outside; text-indent: 0px; margin-left: 24px">\r\n    <li><span class="rvts11">In this page,the user can add/edit the Shipping address Information . </span></li>\r\n</ul>\r\n<p class="rvps2"><strong><span class="rvts12">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></strong><u><strong><span class="rvts12">My Refund Request</span></strong></u></p>\r\n<ul style="list-style-position: outside; text-indent: 0px; margin-left: 24px">\r\n    <li><span class="rvts11">In this page,the user can&nbsp;make request for&nbsp;refund for the products that he/she has purchased&nbsp;&nbsp;. </span></li>\r\n</ul>\r\n<p class="rvps2"><strong><span class="rvts12">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></strong><u><strong><span class="rvts12">My Giftcards</span></strong></u><span class="rvts12"><br />\r\n</span></p>\r\n<ul style="list-style-position: outside; text-indent: 0px; margin-left: 24px">\r\n    <li><span class="rvts11">In this page,the user can&nbsp;view the giftcards and the&nbsp;balance amount of&nbsp;each giftcard that he/she has purchased&nbsp;. </span></li>\r\n</ul>\r\n<p class="rvps2"><strong><span class="rvts12">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></strong><u><strong><span class="rvts12">My Giftcard Usage</span></strong></u></p>\r\n<ul style="list-style-position: outside; text-indent: 0px; margin-left: 24px">\r\n    <li><span class="rvts11">In this page,the user can view the list of giftcards&nbsp; that he has used for&nbsp;the product purchases from the website along with the amount used for each purchase.</span>&nbsp;</li>\r\n</ul>\r\n<p><strong>&nbsp;&nbsp;&nbsp;&nbsp; <u>Unsubscribe Newsletter</u></strong><span class="rvts12"><br />\r\n</span></p>\r\n<ul style="list-style-position: outside; text-indent: 0px; margin-left: 24px">\r\n    <li><span class="rvts11">This link allows the user to subscribe/unsubscribe newsletter.</span>&nbsp;</li>\r\n</ul>\r\n<p>&nbsp;</p>\r\n<p class="rvps2"><span class="rvts12"><br />\r\n</span></p>', 'U', 0),
(6, 'Product Details Page', '<ul style="list-style-position: outside; text-indent: 0px; margin-left: 24px">\r\n    <li class="rvps2"><span class="rvts10">The details of each product such as the name and description are displayed here.</span></li>\r\n    <li class="rvps2"><span class="rvts10">The images of the product appear in an image slider with a &lsquo;next&rsquo; and &lsquo;previous&rsquo; button to help navigate.</span></li>\r\n    <li class="rvps2"><span class="rvts10">The current rating and price of the product are shown under the &lsquo;Product Image Slider&rsquo;.</span></li>\r\n    <li class="rvps2">If the logged in user is a wholesale user then both wholesale and retail price of products will be shown.</li>\r\n    <li class="rvps2"><span class="rvts10">The product is rated by selecting the stars, so viewers can determine what the best selection will be.</span></li>\r\n    <li class="rvps2"><span class="rvts10">Various combinations of the product appear when the user selects the desired option from the select box. The image, SKU number, and price appear here with an &lsquo;Add to Cart&rsquo; button. <br />\r\n    </span></li>\r\n    <li class="rvps2"><span class="rvts10">Any user can view/post feedback on a product by selecting the &lsquo;post&rsquo; and &lsquo;view&rsquo; feedback links on the bottom. To post, the customer must purchase the same product at least once.<br />\r\n    </span></li>\r\n</ul>\r\n<p>&nbsp;</p>', 'U', 0),
(7, 'Cart Page', '<ul style="text-indent: 0px; margin-left: 24px; list-style-position: outside;">\r\n    <li class="rvps2"><span class="rvts10">A user can view the items that are added to the cart.<br />\r\n    </span></li>\r\n    <li class="rvps2"><span class="rvts10">The user can remove any added  item or update the quantity of a particular item.</span></li>\r\n    <li class="rvps2"><span class="rvts10">If you have a promo code, you can enter it here.</span></li>\r\n    <li class="rvps2"><span class="rvts10">The cart can contain all physical products or all downloadable products here.</span></li>\r\n    <li class="rvps2"><span class="rvts10">The user can continue adding  products to the cart by clicking on the Continue Shopping button.</span></li>\r\n    <li class="rvps2"><span class="rvts10">Select the &lsquo;Check out&rsquo; button when you are finished adding products.</span></li>\r\n</ul>', 'U', 0),
(8, 'Checkout', '<p style="margin-left: 40px;"><span class="rvts10">When you select the &lsquo;Check out from Carts Page&rsquo;, if you aren&rsquo;t logged in, the system will allow you to do so if you register to the store, or purchase as a guest. </span><span class="rvts10"><br />\r\n</span></p>\r\n<ul style="text-indent: 0px; margin-left: 24px; list-style-position: outside;">\r\n    <li class="rvps2"><span class="rvts10">When you select the &lsquo;Check out&rsquo; button on the carts page, the user will then have two options. You can log in by registering to the store, or purchase the product as a guest. <br />\r\n    </span></li>\r\n    <li class="rvps2"><span class="rvts10">When you select the &lsquo;Check out as a guest&rsquo; button a link will automatically create your log in credentials as a &lsquo;guest user&rsquo;. From here, you have full access to the store. <br />\r\n    </span></li>\r\n    <li><span class="rvts10">The guest user must enter the correct shipping and billing information. Just select the &lsquo;Billing email address&rsquo; text box.&nbsp; The new log in details of the guest user are then sent to that email address.</span></li>\r\n</ul>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>', 'U', 0),
(9, 'Billing/ Shipping Address', '<p>\r\n<meta http-equiv="CONTENT-TYPE" content="text/html; charset=utf-8">\r\n<meta name="GENERATOR" content="OpenOffice.org 3.1  (Win32)"><style type="text/css">\r\n	<!--\r\n		@page { margin: 0.79in }\r\n		P { margin-bottom: 0.08in }\r\n	-->\r\n	</style></meta>\r\n</meta>\r\n</p>\r\n<p style="margin-bottom: 0in; margin-left: 40px;">During the check out process, the system will ask for the user&rsquo;s billing &amp; shipping address for non digital products and billing address for digital products. If the user has already entered these addresses, then the&nbsp;user can edit them here. For a non digital product, the user can select a shipping option. After they select the &lsquo;Save Addresses&rsquo; button, the store will lead the user to the shipping address page and show the rate available.&nbsp;</p>', 'U', 0),
(10, 'Payment Selection', '<p style="margin-left: 40px;">The store will show a &lsquo;Payment Selection&rsquo; page that shows all of the payment options available. Please enter the payment information as directed. The store will send you an email with all the details.</p>', 'U', 0),
(11, 'Search For a product', '<ul>\r\n    <li>The store supports category and keyword searches.</li>\r\n    <li>For category searches- the user can navigate through the category. When they select a leaf level category, the website will show all products under that category.</li>\r\n    <li>For keyword searches- the user has to enter the item in the search text box at the top of the home page. When they select the &lsquo;Search&rsquo; button, the user will get their search results. </li>\r\n</ul>', 'U', 0),
(12, 'View your orders', '<p style="margin-left: 40px;">In order to see the orders placed by a customer, they can select &lsquo;My account page&rsquo;-&gt; My Orders links. This page will list all the orders. To view other details, the customer has to select the &lsquo;order number&rsquo;. From the order details page, the customer can change the order status to &lsquo;Order Accepted&rsquo;.</p>', 'U', 0),
(13, 'Settings', '<p>\r\n<meta content="text/html; charset=utf-8" http-equiv="CONTENT-TYPE">\r\n<meta content="OpenOffice.org 3.1  (Win32)" name="GENERATOR"><style type="text/css">\r\n	<!--\r\n		@page { margin: 0.79in }\r\n		P { margin-bottom: 0.08in }\r\n	-->\r\n	</style>      </meta>\r\n</meta>\r\n</p>\r\n<p style="margin-bottom: 0in; ">In this page, the administrator can manage the website configurations. It consists of 4 Submenus:</p>\r\n<p style="margin-bottom: 0in;"><u><strong>General</strong></u></p>\r\n<p style="margin-bottom: 0in; ">In the General Settings Page, the administrator can change the Name, email, logo, template, page title, Meta tag description, URL store location, and the number of images per products.<br />\r\nThe administrator can enable/disable the Gift Coupons (Promo code), rating on products by customers, feedback posts on products, and send orders to administrator via fax.<br />\r\nThey can also give a time limit to customers for downloading the digital products they purchase from the store.&nbsp;</p>\r\n<p style="margin-bottom: 0in; "><strong><u>Shipping</u></strong></p>\r\n<p style="margin-bottom: 0in; ">The store supports five flat rate shipping and shipping API&rsquo;S: UPS, USPS, FEDEX, Canada Post, and Australia Post. Use flat rate shipping if you don&rsquo;t want to calculate the real time shipping costs using the shipping API&rsquo;s. For flat rate shipping, admin can set the shipping charge for the first item and a separate charge for any additional items. The administrator can enable/disable all the shipping methods if they want.They can also give the shipping service name.In shipping tab,the administrator must enter the shipping orirgin postal code and country.</p>\r\n<p style="margin-bottom: 0in;">&nbsp;<strong><u>Payment</u></strong></p>\r\n<p style="margin-bottom: 0in; ">\r\n<meta content="text/html; charset=utf-8" http-equiv="CONTENT-TYPE">\r\n<meta content="OpenOffice.org 3.1  (Win32)" name="GENERATOR"><style type="text/css">\r\n	<!--\r\n		@page { margin: 0.79in }\r\n		P { margin-bottom: 0.08in }\r\n		A:link { so-language: zxx }\r\n	-->\r\n	</style>      </meta>\r\n</meta>\r\n</p>\r\n<p style="margin-bottom: 0in; ">In the payment Page, the administrator can enable/disable the payment gateways.&nbsp; They can also select the currency for all transactions. The store supports offline credit card payment, and payment gateways like: PayPal, Authorize.net, Your Pay, World Pay, Blue Pay and Google Checkout.<br />\r\n&nbsp;If offline payment is selected the credit card information is not verified online, so please verify and charge using POS before shipping. This offline payment is a good solution for physical retail stores. If you enable an offline credit card payment, the site will not receive any payment transactions from your customers; it will send the credit card information in an email to the site administrator. <br />\r\nIt is necessary to enable at least one payment method&nbsp; for your site.</p>\r\n<p style="margin-bottom: 0in; "><strong><u>Tax</u></strong></p>\r\n<p style="margin-bottom: 0in; ">In the tax settings  page, the administrator can manage the tax settings in the website. This  page has two tabs: General, and Tax Rates</p>\r\n<p style="margin-bottom: 0in; ">In the General  settings tab- the administrator can opt for no tax to all customers, a  fixed tax rate, or tax based on any country/state. The administrator can  also choose the base to categorize the taxes as subtotal or subtotal +  shipping. The administrator can use taxable address as a billing address  or shipping address.</p>\r\n<p style="margin-bottom: 0in;">If the administrator opts fixed tax rates, they can create a tax name.&nbsp;</p>\r\n<p style="margin-bottom: 0in; ">If the administrator wants a specific tax based on a state and/or country, the tax rate tab is enabled.</p>\r\n<p style="margin-bottom: 0in; ">In this tab, the  administrator can add/edit/delete any/tax rates for states or countries.  In most jurisdictions you collect taxes for states with nexus, based on  the shipping address. For example: if you have a store in the state of  California, you have to collect taxes from all customers in California.  Please obtain legal advice for your local tax laws.</p>\r\n<p style="margin-bottom: 0in; ">&nbsp;</p>', 'A', 1),
(17, 'Import Product & Images', '<p>\r\n<meta content="text/html; charset=utf-8" http-equiv="CONTENT-TYPE" />\r\n<meta content="OpenOffice.org 3.1  (Win32)" name="GENERATOR" /><style type="text/css">\r\n	<!--\r\n		@page { margin: 0.79in }\r\n		P { margin-bottom: 0.08in }\r\n	-->\r\n	</style></p>\r\n<p style="margin-bottom: 0in; margin-left: 40px">The shopping cart allows you to import products in bulk using .csv file (comma separated values) and .zip format(s).</p>\r\n<p style="margin-bottom: 0in; margin-left: 40px">To import products- you must upload the csv file to the site using the sample csv format provided and match the data fields. When you select the &lsquo;save&rsquo; button all of your products will import into the website</p>\r\n<p style="margin-bottom: 0in; margin-left: 40px">To import product images- you must&nbsp;create a zip files with&nbsp;the images you want to upload for a particular product.The name of the zip file should be same as that of the product name.</p>\r\n<p style="margin-bottom: 0in; margin-left: 40px">&nbsp;</p>', 'A', 7),
(14, 'Custom Variables', '<p>\r\n<meta http-equiv="CONTENT-TYPE" content="text/html; charset=utf-8">\r\n<title></title>\r\n<meta name="GENERATOR" content="OpenOffice.org 3.1  (Win32)"><style type="text/css">\r\n	<!--\r\n		@page { margin: 0.79in }\r\n		P { margin-bottom: 0.08in }\r\n	-->\r\n	</style>     </meta>\r\n</meta>\r\n</p>\r\n<p style="margin-bottom: 0in; margin-left: 40px;">In the custom fields and values tab, the administrator can manage all product variables and their values. For example: if your site sells clothes, you may have a shirt in your product list. The shirt can have different variants like size (XL,XXL,etc) color (blue, red), and fabric (cotton, polyester).</p>\r\n<p style="margin-bottom: 0in; margin-left: 40px;">For the site you can add The Size, Color, and Fabric as custom fields. The XL,XXL, Blue, Red, and Cotton, Polyester, are the custom field values.</p>\r\n<p style="margin-bottom: 0in; margin-left: 40px;">&nbsp;</p>', 'A', 4),
(15, 'Categories', '<p>\r\n<meta http-equiv="CONTENT-TYPE" content="text/html; charset=utf-8">\r\n<title></title>\r\n<meta name="GENERATOR" content="OpenOffice.org 3.1  (Win32)"><style type="text/css">\r\n	<!--\r\n		@page { margin: 0.79in }\r\n		P { margin-bottom: 0.08in }\r\n	-->\r\n	</style> </meta>\r\n</meta>\r\n</p>\r\n<p style="margin-bottom: 0in; margin-left: 40px;">The store allows you to create any number of levels of categories on your site. You can add products to leaf level categories only. When adding categories you can assign custom fields and values only applicable to that category.</p>\r\n<p style="margin-bottom: 0in; margin-left: 40px;">&nbsp;</p>', 'A', 5),
(16, 'Products', '<p style="margin-left: 200px;">\r\n<meta content="text/html; charset=utf-8" http-equiv="CONTENT-TYPE" />\r\n<title></title>\r\n<meta content="OpenOffice.org 3.1  (Win32)" name="GENERATOR" /><style type="text/css">\r\n	<!--\r\n		@page { margin: 0.79in }\r\n		P { margin-bottom: 0.08in }\r\n	-->\r\n	</style></p>\r\n<p>\r\n<p style="margin-bottom: 0in; margin-left: 40px;">In the products tab, you can add/edit/delete products.</p>\r\n<p style="margin-bottom: 0in; margin-left: 40px;">To add a product- you must first select a category, enter the product name, description, price, weight, and then select physical or downloadable, set feature/not feature, browse images, select the SKU number, additional amount, and re order level for each custom value combination.</p>\r\n<p style="margin-bottom: 0in; margin-left: 40px;">For custom value combinations- you can upload the product image</p>\r\n<p style="margin-bottom: 0in; margin-left: 40px;">Examples: if you upload a t-shirt, it might be red,XL, cotton, Blue, XXL, cotton, and red XXL, cotton. Each one will have a different image, stock, re order number, and batch number. Some combinations might have an additional price. That can also be managed here.</p>\r\n<p style="margin-bottom: 0in; margin-left: 40px;">&nbsp;</p>\r\n</p>', 'A', 6),
(18, 'Feedback', '<p>\r\n<meta content="text/html; charset=utf-8" http-equiv="CONTENT-TYPE" />\r\n<title></title>\r\n<meta content="OpenOffice.org 3.1  (Win32)" name="GENERATOR" /><style type="text/css">\r\n	<!--\r\n		@page { margin: 0.79in }\r\n		P { margin-bottom: 0.08in }\r\n	-->\r\n	</style>\r\n<p style="margin-bottom: 0in; margin-left: 40px;">In the feedback page, the administrator can view customer feedback about the website and the products. Only customers who purchased a product at least once are allowed to give feedback on that product.</p>\r\n<p style="margin-bottom: 0in;">&nbsp;</p>\r\n</p>', 'A', 8),
(19, 'Users', '<p>\r\n<meta content="text/html; charset=utf-8" http-equiv="CONTENT-TYPE" />\r\n<meta content="OpenOffice.org 3.1  (Win32)" name="GENERATOR" /><style type="text/css">\r\n	<!--\r\n		@page { margin: 0.79in }\r\n		P { margin-bottom: 0.08in }\r\n	-->\r\n	</style></p>\r\n<p style="margin-bottom: 0in; margin-left: 40px">In the user page, the administrator can view, edit, and delete customers registered with the site.</p>\r\n<p style="margin-bottom: 0in; margin-left: 40px">&nbsp;</p>\r\n<p>&nbsp;</p>', 'A', 9),
(20, 'Orders', '<p>\r\n<meta http-equiv="CONTENT-TYPE" content="text/html; charset=utf-8">\r\n<title></title>\r\n<meta name="GENERATOR" content="OpenOffice.org 3.1  (Win32)"><style type="text/css">\r\n	<!--\r\n		@page { margin: 0.79in }\r\n		P { margin-bottom: 0.08in }\r\n	-->\r\n	</style> </meta>\r\n</meta>\r\n</p>\r\n<p style="margin-bottom: 0in; margin-left: 40px;">In the orders page, the administrator can view the details of the orders. They can change the order status and add comments for internal use.</p>\r\n<p style="margin-bottom: 0in; margin-left: 40px;">&nbsp;</p>', 'A', 15),
(21, 'Website Contents', '<p>\r\n<meta content="text/html; charset=utf-8" http-equiv="CONTENT-TYPE">\r\n<title></title>\r\n<meta content="OpenOffice.org 3.1  (Win32)" name="GENERATOR"><style type="text/css">\r\n	<!--\r\n		@page { margin: 0.79in }\r\n		P { margin-bottom: 0.08in }\r\n	-->\r\n	</style>   </meta>\r\n</meta>\r\n</p>\r\n<p style="margin-bottom: 0in; margin-left: 40px;">In the website content page, the administrator can edit content for the About Us section, the FAQ section, and the Terms and Conditions pages. </p>\r\n<p style="margin-bottom: 0in; margin-left: 40px;">&nbsp;</p>', 'A', 2),
(22, 'Email Templates', '<p>\r\n<meta content="text/html; charset=utf-8" http-equiv="CONTENT-TYPE" />\r\n<title></title>\r\n<meta content="OpenOffice.org 3.1  (Win32)" name="GENERATOR" /><style type="text/css">\r\n	<!--\r\n		@page { margin: 0.79in }\r\n		P { margin-bottom: 0.08in }\r\n	-->\r\n	</style>\r\n<p style="margin-bottom: 0in; margin-left: 40px;">In the email templates page, the administrator can view and edit the email templates for emails to send from the website.</p>\r\n<p style="margin-bottom: 0in; margin-left: 40px;">&nbsp;</p>\r\n</p>', 'A', 3),
(24, 'Promo Codes', '<p>\r\n<meta content="text/html; charset=utf-8" http-equiv="CONTENT-TYPE">\r\n<title></title>\r\n<meta content="OpenOffice.org 3.1  (Win32)" name="GENERATOR"><style type="text/css">\r\n	<!--\r\n		@page { margin: 0.79in }\r\n		P { margin-bottom: 0.08in }\r\n	-->\r\n	</style>   </meta>\r\n</meta>\r\n</p>\r\n<p style="margin-bottom: 0in; margin-left: 40px;">In the promo codes tab, the administrators can add/edit/delete promo codes.</p>\r\n<p style="margin-bottom: 0in; margin-left: 40px;">For the promo codes, the administrator inputs a promo code, discount type as a fixed amount or rate, discount value, start and end dates, the minimum amount required, and the description of the promo code.</p>\r\n<p style="margin-bottom: 0in; margin-left: 40px;">&nbsp;</p>', 'A', 10),
(25, 'Reports', '<p style="margin-left: 40px">Product reports, sales reports,user activity reports, user reports, and promo code reports are the reports generated in the store. All of the reports can be be exported in. CSV and .XLS file formats.</p>\r\n<p><b><u>\r\n<p style="margin-left: 40px"><span id="1285830993889S" style="display: none">&nbsp;</span>Product Report</p>\r\n</u></b></p>\r\n<p style="margin-left: 40px">In the products report, the website will show the Product name,Stock available, and the Total revenue.</p>\r\n<p><b><u>\r\n<p style="margin-left: 40px">Sales Report</p>\r\n</u></b></p>\r\n<p style="margin-left: 40px">In the sales report,the website will show the Order number,sales date, purchased user, Order status, promo code used to purchase, discount given and the total price.</p>\r\n<p><b><u>\r\n<p style="margin-left: 40px">User Report</p>\r\n</u></b></p>\r\n<p style="margin-left: 40px">In user reports , the website will show the details like username, Name of the customer,Email address, registration date in the website, address and other customer details.</p>\r\n<p><b><u>\r\n<p style="margin-left: 40px">User Activity Report</p>\r\n</u></b></p>\r\n<p style="margin-left: 40px">In user activity reports , the website will show the details like Order date,Order status,Shipping address,Billing address,Total of all the purchases made by a particular customer.</p>\r\n<p><b><u>\r\n<p style="margin-left: 40px">Promo Code Report</p>\r\n</u></b></p>\r\n<p style="margin-left: 40px">In promo code report, the system will show the details of the promo codes used by the customers.This details include code, Order number,Order date,Order status and discount value.</p>', 'A', 16),
(26, 'Newsletter Subscribers', '<p style="margin-left: 40px">In this page, the user can view the list of the users subscribed for Newsletters,add new newsletter users,activiate or deactivate the users for newsletter subscription.</p>', 'A', 14),
(27, 'Newsletters', '<p style="margin-left: 40px">In this page, the administrator can add/edit Newsletters,Send newsletter to retail users or wholesale users or both.</p>', 'A', 13),
(28, 'Giftcards', '<p style="margin-left: 40px">In this page administrator can add/edit giftcards.These gift cards will be displayed along with the products for purchase&nbsp;on user side.</p>', 'A', 11),
(29, 'Giftcard Users', '<p style="margin-left: 40px">In this page,the administrator can view the list of users who has used giftcards for purchases.It shows details such as Card name,Used card code,date,Amount used.</p>', 'A', 12);



INSERT INTO `goStores_Vista_homelayouts` (`id`, `prod_type`, `section`, `status`, `ordering`) VALUES
(1, 'featured', 'middle', 'Y', 1),
(2, 'latest', 'right', 'Y', 2),
(3, 'toprated', 'right', 'Y', 1),
(4, 'onsale', 'right', 'Y', 3);


INSERT INTO `goStores_Vista_order_statuses` (`id`, `name`) VALUES
(1, 'Item Ordered'),
(2, 'Item Shipped'),
(3, 'Item Accepted By Customer'),
(4, 'Order Pending');



INSERT INTO `goStores_Vista_refundoptions` (`id`, `title`) VALUES
(1, 'Refund'),
(2, 'Repair'),
(3, 'Replacement');


INSERT INTO `goStores_Vista_refundreasons` (`id`, `title`) VALUES
(1, 'Can not make it work'),
(2, 'Damaged during shipping'),
(3, 'Dead on arrival'),
(4, 'Manufacturer defect'),
(5, 'Out of Warranty'),
(6, 'Wrong item ordered'),
(7, 'Wrong description online'),
(8, 'Wrong item delivered');


INSERT INTO `goStores_Vista_refundstatuses` (`id`, `title`) VALUES
(1, 'Waiting for review'),
(2, 'Reviewed'),
(3, 'Rejected'),
(4, 'Closed'),
(5, 'Approved');


INSERT INTO `goStores_Vista_settings` (`fieldname`, `value`) VALUES
('admin_email', ''),
('site_name', ''),
('payment_method', ''),
('paypal_email', ''),
('paypal_idtoken', ''),
('paypal_testmode', 'Y'),
('authorize_loginid', ''),
('authorize_transactionkey', ''),
('authorize_email', ''),
('authorize_password', ''),
('authorize_testmode', 'Y'),
('shipping_origin_country', ''),
('shipping_origin_zip', ''),
('sitebasefolder', ''),
('smtpHostNames', ''),
('smtpUserName', ''),
('smtpPassword', ''),
('meta_description', ''),
('meta_keywords', ''),
('shipping_require', 'Y'),
('currency', ''),
('style', 'Garments'),
('page_title', ''),
('no_tax_home', 'Y'),
('home_state', ''),
('tax_foreign', ''),
('digitalproduct_download_limit', ''),
('shipping_require_usps', 'Y'),
('shipping_require_fedex', 'Y'),
('shipping_require_canada', 'Y'),
('shipping_require_australia', 'N'),
('USPS_Username', ''),
('fedexaccno', ''),
('fedexmeterno', ''),
('canadamerchantid', ''),
('enable_twitter', 'N'),
('worldpay_inst_Id', ''),
('worldpay_email', ''),
('worldpay_transact_method', ''),
('google_merchantId', ''),
('google_merchantkey', ''),
('google_testmode', ''),
('yourpay_testmod', ''),
('yourpay_storeid', ''),
('yourpay_certificate_file', ''),
('allow_rating', 'Y'),
('allow_product_feedback', 'Y'),
('flat_shipping_first', ''),
('flat_shipping_additional', ''),
('tax_option', ''),
('fixedtax_name', ''),
('fixedtax_rate', ''),
('taxable_address', ''),
('taxto', ''),
('product_images', ''),
('flat_ship_name', ''),
('secflat_shipping_first', ''),
('secflat_shipping_additional', ''),
('secflat_ship_name', ''),
('thirdflat_shipping_first', ''),
('thirdflat_shipping_additional', ''),
('thirdflat_ship_name', ''),
('forthflat_shipping_first', ''),
('forthflat_shipping_additional', ''),
('forthflat_ship_name', ''),
('fflat_shipping_require', 'Y'),
('sflat_shipping_require', 'Y'),
('tflat_shipping_require', 'Y'),
('foflat_shipping_require', 'Y'),
('allow_giftcoupon', 'Y'),
('allow_fax', 'N'),
('fax_email', ''),
('fax_number', ''),
('guestnumber', ''),
('offline_creditpay', 'N'),
('allow_rma', 'Y'),
('allow_giftcard', 'Y'),
('offline_creditpay', 'N'),
('allow_rma', 'Y'),
('fedexshipaccno', ''),
('fedexbillaccno', ''),
('fedexdutyaccno', ''),
('fedexkey', ''),
('fedexpaswd', ''),
('items_perpage', ''),
('allow_fedexlabel', 'Y'),
('shipping_origin_state', ''),
('bp_account', ''),
('bp_secret', ''),
('bp_testmode', 'Y'),
(' vLicenceKey', ''),
('vLicenceKey', ''),
('enable_googleanalytics', 'Y'),
('googleanalytic_id', ''),
('admin_blog_settings', 'Y'),
('enable_paypal_express', 'Y'),
('paypal_express_password', ''),
('twocheckout_testmode', 'Y'),
('twoco_vendorId', ''),
('paypal_express_username', ''),
('paypal_express_signature', ''),
('moneybookers_emailId', ''),
('paypalpro_username', ''),
('paypal_express_testmode', 'Y'),
('paypalpro_password', ''),
('paypalpro_signature', ''),
('paypalpro_testmode', 'Y'),
('pay_paypalpro', ''),
('paypalflow_partnerid', ''),
('paypalflow_vendorid', ''),
('paypalflow_password', ''),
('paypalflow_testmode', 'Y'),
('paypallink_partnerid', ''),
('paypallink_vendorid', ''),
('paypallink_testmode', 'Y'),
('user_credit', ''),
('worldpay_merchantcode', ''),
('worldpay_password', ''),
('worldpay_testmode', ''),
('enable_facebook', 'N'),
('facebook_url', ''),
('twitter_url', ''),
('ogone_PSPID', ''),
('ogone_passphrase', ''),
('ogone_testmode', 'Y'),
('shipping_origin_phone', ''),
('shipping_origin_street', ''),
('shipping_origin_city', ''),
('streamsendLoginID', ''),
('streamsendKey', ''),
('streamsendListID', ''),
('streamsendEnable', 'Y'),
('paypal_advancedPWD', ''),
('paypal_advancedUSER', ''),
('paypal_advancedVENDOR', ''),
('paypal_advancedPARTNER', ''),
('paypal_advancedtestmode', 'Y'),
('allow_uspslabel', 'N'),
('braintree_merchantId', ''),
('braintree_publicKey', ''),
('braintree_privateKey', ''),
('braintree_testmode', 'Y');

INSERT INTO `goStores_Vista_settings` VALUES ('paypal_bn_code', '');

INSERT INTO `goStores_Vista_settings` VALUES ('paypaladvanced_bn_code', '');

INSERT INTO `goStores_Vista_settings` VALUES ('paypalpro_bn_code', '');


INSERT INTO `goStores_Vista_statecodes` (`id`, `code`, `name`, `country_id`) VALUES
(1, 'AK', 'Alaska', '223'),
(2, 'AL', 'Alabama', '223'),
(3, 'AR', 'Arkansas', '223'),
(4, 'AS', 'American Samoa', '223'),
(5, 'AZ', 'Arizona', '223'),
(6, 'CA', 'California', '223'),
(7, 'CO', 'Colorado', '223'),
(8, 'CT', 'Connecticut', '223'),
(9, 'DC', 'D.C.', '223'),
(10, 'DE', 'Delaware', '223'),
(11, 'FL', 'Florida', '223'),
(12, 'FM', 'Micronesia', '223'),
(13, 'GA', 'Georgia', '223'),
(14, 'GU', 'Guam', '223'),
(15, 'HI', 'Hawaii', '223'),
(16, 'IA', 'Iowa', '223'),
(17, 'ID', 'Idaho', '223'),
(18, 'IL', 'Illinois', '223'),
(19, 'IN', 'Indiana', '223'),
(20, 'KS', 'Kansas', '223'),
(21, 'KY', 'Kentucky', '223'),
(22, 'LA', 'Louisiana', '223'),
(23, 'MA', 'Massachusetts', '223'),
(24, 'MD', 'Maryland', '223'),
(25, 'ME', 'Maine', '223'),
(26, 'MH', 'Marshall Islands', '223'),
(27, 'MI', 'Michigan', '223'),
(28, 'MN', 'Minnesota', '223'),
(29, 'MO', 'Missouri', '223'),
(30, 'MP', 'Marianas', '223'),
(31, 'MS', 'Mississippi', '223'),
(32, 'MT', 'Montana', '223'),
(33, 'NC', 'North Carolina', '223'),
(34, 'ND', 'North Dakota', '223'),
(35, 'NE', 'Nebraska', '223'),
(36, 'NH', 'New Hampshire', '223'),
(37, 'NJ', 'New Jersey', '223'),
(38, 'NM', 'New Mexico', '223'),
(39, 'NV', 'Nevada', '223'),
(40, 'NY', 'New York', '223'),
(41, 'OH', 'Ohio', '223'),
(42, 'OK', 'Oklahoma', '223'),
(43, 'OR', 'Oregon', '223'),
(44, 'PA', 'Pennsylvania', '223'),
(45, 'PR', 'Puerto Rico', '223'),
(46, 'PW', 'Palau', '223'),
(47, 'RI', 'Rhode Island', '223'),
(48, 'SC', 'South Carolina', '223'),
(49, 'SD', 'South Dakota', '223'),
(50, 'TN', 'Tennessee', '223'),
(51, 'TX', 'Texas', '223'),
(52, 'UT', 'Utah', '223'),
(53, 'VA', 'Virginia', '223'),
(54, 'VI', 'Virgin Islands', '223'),
(55, 'VT', 'Vermont', '223'),
(56, 'WA', 'Washington', '223'),
(57, 'WI', 'Wisconsin', '223'),
(58, 'WV', 'West Virginia', '223'),
(59, 'WY', 'Wyoming', '223'),
(60, 'AA', 'Military Americas', '223'),
(61, 'AE', 'Military Europe)ME)Canada', '223'),
(62, 'AP', 'Military Pacific', '223');



INSERT INTO `goStores_Vista_states` (`id`, `code`, `name`, `country_id`, `tax_rate`, `tax_name`) VALUES
(1, 'AK', 'Alaska', 'US', 2.00, 'Test tax'),
(2, 'AL', 'Alabama', 'US', 2.00, 'Test tax'),
(3, 'AR', 'Arkansas', 'US', 2.00, 'Test tax'),
(4, 'AS', 'American Samoa', 'US', 2.00, 'Test tax'),
(5, 'AZ', 'Arizona', 'US', 2.00, 'Test tax'),
(6, 'CA', 'California', 'US', 2.00, 'Test tax'),
(7, 'CO', 'Colorado', 'US', 2.00, 'Test tax'),
(8, 'CT', 'Connecticut', 'US', 2.00, 'Test tax'),
(9, 'DC', 'D.C.', 'US', 2.00, 'Test tax'),
(10, 'DE', 'Delaware', 'US', 2.00, 'Test tax'),
(11, 'FL', 'Florida', 'US', 2.00, 'Test tax'),
(12, 'FM', 'Micronesia', 'US', 2.00, 'Test tax'),
(13, 'GA', 'Georgia', 'US', 2.00, 'Test tax'),
(14, 'GU', 'Guam', 'US', 2.00, 'Test tax'),
(15, 'HI', 'Hawaii', 'US', 2.00, 'Test tax'),
(16, 'IA', 'Iowa', 'US', 2.00, 'Test tax'),
(17, 'ID', 'Idaho', 'US', 2.00, 'Test tax'),
(18, 'IL', 'Illinois', 'US', 2.00, 'Test tax'),
(19, 'IN', 'Indiana', 'US', 2.00, 'Test tax'),
(20, 'KS', 'Kansas', 'US', 2.00, 'Test tax'),
(21, 'KY', 'Kentucky', 'US', 2.00, 'Test tax'),
(22, 'LA', 'Louisiana', 'US', 2.00, 'Test tax'),
(23, 'MA', 'Massachetts', 'US', 2.00, 'Test tax'),
(24, 'MD', 'Maryland', 'US', 2.00, 'Test tax'),
(25, 'ME', 'Maine', 'US', 2.00, 'Test tax'),
(26, 'MH', 'Marshall Islands', 'US', 2.00, 'Test tax'),
(27, 'MI', 'Michigan', 'US', 2.00, 'Test tax'),
(28, 'MN', 'Minnesota', 'US', 2.00, 'Test tax'),
(29, 'MO', 'Missouri', 'US', 2.00, 'Test tax'),
(30, 'MP', 'Marianas', 'US', 2.00, 'Test tax'),
(31, 'MS', 'Mississippi', 'US', 2.00, 'Test tax'),
(32, 'MT', 'Montana', 'US', 2.00, 'Test tax'),
(33, 'NC', 'North Carolina', 'US', 2.00, 'Test tax'),
(34, 'ND', 'North Dakota', 'US', 2.00, 'Test tax'),
(35, 'NE', 'Nebraska', 'US', 2.00, 'Test tax'),
(36, 'NH', 'New Hampshire', 'US', 2.00, 'Test tax'),
(37, 'NJ', 'New Jersey', 'US', 2.00, 'Test tax'),
(38, 'NM', 'New Mexico', 'US', 2.00, 'Test tax'),
(39, 'NV', 'Nevada', 'US', 2.00, 'Test tax'),
(40, 'NY', 'New York', 'US', 2.00, 'Test tax'),
(41, 'OH', 'Ohio', 'US', 2.00, 'Test tax'),
(42, 'OK', 'Oklahoma', 'US', 2.00, 'Test tax'),
(43, 'OR', 'Oregon', 'US', 2.00, 'Test tax'),
(44, 'PA', 'Pennsylvania', 'US', 2.00, 'Test tax'),
(45, 'PR', 'Puerto Rico', 'US', 2.00, 'Test tax'),
(46, 'PW', 'Palau', 'US', 2.00, 'Test tax'),
(47, 'RI', 'Rhode Island', 'US', 2.00, 'Test tax'),
(48, 'SC', 'South Carolina', 'US', 2.00, 'Test tax'),
(49, 'SD', 'South Dakota', 'US', 2.00, 'Test tax'),
(50, 'TN', 'Tennessee', 'US', 2.00, 'Test tax'),
(51, 'TX', 'Texas', 'US', 2.00, 'Test tax'),
(52, 'UT', 'Utah', 'US', 2.00, 'Test tax'),
(53, 'VA', 'Virginia', 'US', 2.00, 'Test tax'),
(54, 'VI', 'Virgin Islands', 'US', 2.00, 'Test tax'),
(55, 'VT', 'Vermont', 'US', 2.00, 'Test tax'),
(56, 'WA', 'Washington', 'US', 2.00, 'Test tax'),
(57, 'WI', 'Wisconsin', 'US', 2.00, 'Test tax'),
(58, 'WV', 'West Virginia', 'US', 2.00, 'Test tax'),
(59, 'WY', 'Wyoming', 'US', 2.00, 'Test tax'),
(60, 'AA', 'Military Americas', 'US', 2.00, 'Test tax'),
(61, 'AE', 'Military Europe)ME)Canada', 'US', 2.00, 'Test tax'),
(62, 'AP', 'Military Pacific', 'US', 2.00, 'Test tax');

INSERT INTO `goStores_Vista_wp_add_custom_link` (`custom_link_id`, `id`, `title`, `parent_id`, `href`) VALUES
(2, 'Site Home', 'Back To Main Store', 0, 'http://localhost/vistacart/admins');
INSERT INTO `goStores_Vista_wp_comments` (`comment_ID`, `comment_post_ID`, `comment_author`, `comment_author_email`, `comment_author_url`, `comment_author_IP`, `comment_date`, `comment_date_gmt`, `comment_content`, `comment_karma`, `comment_approved`, `comment_agent`, `comment_type`, `comment_parent`, `user_id`) VALUES
(1, 1, 'Mr WordPress', '', 'http://wordpress.org/', '', '2012-11-08 06:27:09', '2012-11-08 06:27:09', 'Hi, this is a comment.<br />To delete a comment, just log in and view the post&#039;s comments. There you will have the option to edit or delete them.', 0, '1', '', '', 0, 0);
INSERT INTO `goStores_Vista_wp_links` (`link_id`, `link_url`, `link_name`, `link_image`, `link_target`, `link_description`, `link_visible`, `link_owner`, `link_rating`, `link_updated`, `link_rel`, `link_notes`, `link_rss`) VALUES
(1, 'http://codex.wordpress.org/', 'Documentation', '', '', '', 'Y', 1, 0, '0000-00-00 00:00:00', '', '', ''),
(2, 'http://wordpress.org/news/', 'WordPress Blog', '', '', '', 'Y', 1, 0, '0000-00-00 00:00:00', '', '', 'http://wordpress.org/news/feed/'),
(3, 'http://wordpress.org/extend/ideas/', 'Suggest Ideas', '', '', '', 'Y', 1, 0, '0000-00-00 00:00:00', '', '', ''),
(4, 'http://wordpress.org/support/', 'Support Forum', '', '', '', 'Y', 1, 0, '0000-00-00 00:00:00', '', '', ''),
(5, 'http://wordpress.org/extend/plugins/', 'Plugins', '', '', '', 'Y', 1, 0, '0000-00-00 00:00:00', '', '', ''),
(6, 'http://wordpress.org/extend/themes/', 'Themes', '', '', '', 'Y', 1, 0, '0000-00-00 00:00:00', '', '', ''),
(7, 'http://planet.wordpress.org/', 'WordPress Planet', '', '', '', 'Y', 1, 0, '0000-00-00 00:00:00', '', '', '');
INSERT INTO `goStores_Vista_wp_options` (`option_id`, `blog_id`, `option_name`, `option_value`, `autoload`) VALUES
(305, 0, '_site_transient_timeout_theme_roots', '1354610849', 'yes'),
(306, 0, '_site_transient_theme_roots', 'a:2:{s:12:"twentyeleven";s:7:"/themes";s:9:"twentyten";s:7:"/themes";}', 'yes'),
(3, 0, 'siteurl', 'http://localhost/vistacart/app/webroot/blog', 'yes'),
(4, 0, 'blogname', 'Store Blog', 'yes'),
(5, 0, 'blogdescription', 'Just another WordPress site', 'yes'),
(6, 0, 'users_can_register', '0', 'yes'),
(7, 0, 'admin_email', 'jamessmith121212@gmail.com', 'yes'),
(8, 0, 'start_of_week', '1', 'yes'),
(9, 0, 'use_balanceTags', '0', 'yes'),
(10, 0, 'use_smilies', '1', 'yes'),
(11, 0, 'require_name_email', '1', 'yes'),
(12, 0, 'comments_notify', '1', 'yes'),
(13, 0, 'posts_per_rss', '10', 'yes'),
(14, 0, 'rss_use_excerpt', '0', 'yes'),
(15, 0, 'mailserver_url', 'mail.example.com', 'yes'),
(16, 0, 'mailserver_login', 'login@example.com', 'yes'),
(17, 0, 'mailserver_pass', 'password', 'yes'),
(18, 0, 'mailserver_port', '110', 'yes'),
(19, 0, 'default_category', '1', 'yes'),
(20, 0, 'default_comment_status', 'open', 'yes'),
(21, 0, 'default_ping_status', 'open', 'yes'),
(22, 0, 'default_pingback_flag', '1', 'yes'),
(23, 0, 'default_post_edit_rows', '20', 'yes'),
(24, 0, 'posts_per_page', '10', 'yes'),
(25, 0, 'date_format', 'F j, Y', 'yes'),
(26, 0, 'time_format', 'g:i a', 'yes'),
(27, 0, 'links_updated_date_format', 'F j, Y g:i a', 'yes'),
(28, 0, 'links_recently_updated_prepend', '<em>', 'yes'),
(29, 0, 'links_recently_updated_append', '</em>', 'yes'),
(30, 0, 'links_recently_updated_time', '120', 'yes'),
(31, 0, 'comment_moderation', '0', 'yes'),
(32, 0, 'moderation_notify', '1', 'yes'),
(33, 0, 'permalink_structure', '', 'yes'),
(34, 0, 'gzipcompression', '0', 'yes'),
(35, 0, 'hack_file', '0', 'yes'),
(36, 0, 'blog_charset', 'UTF-8', 'yes'),
(37, 0, 'moderation_keys', '', 'no'),
(38, 0, 'active_plugins', 'a:1:{i:0;s:58:"add_custom_link_to_wordpress_admin_bar/add_custom_link.php";}', 'yes'),
(39, 0, 'home', 'http://localhost/vistacart/app/webroot/blog', 'yes'),
(40, 0, 'category_base', '', 'yes'),
(41, 0, 'ping_sites', 'http://rpc.pingomatic.com/', 'yes'),
(42, 0, 'advanced_edit', '0', 'yes'),
(43, 0, 'comment_max_links', '2', 'yes'),
(44, 0, 'gmt_offset', '0', 'yes'),
(45, 0, 'default_email_category', '1', 'yes'),
(46, 0, 'recently_edited', '', 'no'),
(47, 0, 'template', 'twentyeleven', 'yes'),
(48, 0, 'stylesheet', 'twentyeleven', 'yes'),
(49, 0, 'comment_whitelist', '1', 'yes'),
(50, 0, 'blacklist_keys', '', 'no'),
(51, 0, 'comment_registration', '0', 'yes'),
(52, 0, 'rss_language', 'en', 'yes'),
(53, 0, 'html_type', 'text/html', 'yes'),
(54, 0, 'use_trackback', '0', 'yes'),
(55, 0, 'default_role', 'subscriber', 'yes'),
(56, 0, 'db_version', '38590', 'yes'),
(57, 0, 'uploads_use_yearmonth_folders', '1', 'yes'),
(58, 0, 'upload_path', '', 'yes'),
(59, 0, 'blog_public', '1', 'yes'),
(60, 0, 'default_link_category', '2', 'yes'),
(61, 0, 'show_on_front', 'posts', 'yes'),
(62, 0, 'tag_base', '', 'yes'),
(63, 0, 'show_avatars', '1', 'yes'),
(64, 0, 'avatar_rating', 'G', 'yes'),
(65, 0, 'upload_url_path', '', 'yes'),
(66, 0, 'thumbnail_size_w', '150', 'yes'),
(67, 0, 'thumbnail_size_h', '150', 'yes'),
(68, 0, 'thumbnail_crop', '1', 'yes'),
(69, 0, 'medium_size_w', '300', 'yes'),
(70, 0, 'medium_size_h', '300', 'yes'),
(71, 0, 'avatar_default', 'mystery', 'yes'),
(72, 0, 'enable_app', '0', 'yes'),
(73, 0, 'enable_xmlrpc', '0', 'yes'),
(74, 0, 'large_size_w', '1024', 'yes'),
(75, 0, 'large_size_h', '1024', 'yes'),
(76, 0, 'image_default_link_type', 'file', 'yes'),
(77, 0, 'image_default_size', '', 'yes'),
(78, 0, 'image_default_align', '', 'yes'),
(79, 0, 'close_comments_for_old_posts', '0', 'yes'),
(80, 0, 'close_comments_days_old', '14', 'yes'),
(81, 0, 'thread_comments', '1', 'yes'),
(82, 0, 'thread_comments_depth', '5', 'yes'),
(83, 0, 'page_comments', '0', 'yes'),
(84, 0, 'comments_per_page', '50', 'yes'),
(85, 0, 'default_comments_page', 'newest', 'yes'),
(86, 0, 'comment_order', 'asc', 'yes'),
(87, 0, 'sticky_posts', 'a:0:{}', 'yes'),
(88, 0, 'widget_categories', 'a:2:{i:2;a:4:{s:5:"title";s:0:"";s:5:"count";i:0;s:12:"hierarchical";i:0;s:8:"dropdown";i:0;}s:12:"_multiwidget";i:1;}', 'yes'),
(89, 0, 'widget_text', 'a:0:{}', 'yes'),
(90, 0, 'widget_rss', 'a:0:{}', 'yes'),
(91, 0, 'timezone_string', '', 'yes'),
(92, 0, 'embed_autourls', '1', 'yes'),
(93, 0, 'embed_size_w', '', 'yes'),
(94, 0, 'embed_size_h', '600', 'yes'),
(95, 0, 'page_for_posts', '0', 'yes'),
(96, 0, 'page_on_front', '0', 'yes'),
(97, 0, 'default_post_format', '0', 'yes'),
(98, 0, 'initial_db_version', '19470', 'yes'),
(99, 0, 'wp_user_roles', 'a:5:{s:13:"administrator";a:2:{s:4:"name";s:13:"Administrator";s:12:"capabilities";a:62:{s:13:"switch_themes";b:1;s:11:"edit_themes";b:1;s:16:"activate_plugins";b:1;s:12:"edit_plugins";b:1;s:10:"edit_users";b:1;s:10:"edit_files";b:1;s:14:"manage_options";b:1;s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:6:"import";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:8:"level_10";b:1;s:7:"level_9";b:1;s:7:"level_8";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:12:"delete_users";b:1;s:12:"create_users";b:1;s:17:"unfiltered_upload";b:1;s:14:"edit_dashboard";b:1;s:14:"update_plugins";b:1;s:14:"delete_plugins";b:1;s:15:"install_plugins";b:1;s:13:"update_themes";b:1;s:14:"install_themes";b:1;s:11:"update_core";b:1;s:10:"list_users";b:1;s:12:"remove_users";b:1;s:9:"add_users";b:1;s:13:"promote_users";b:1;s:18:"edit_theme_options";b:1;s:13:"delete_themes";b:1;s:6:"export";b:1;}}s:6:"editor";a:2:{s:4:"name";s:6:"Editor";s:12:"capabilities";a:34:{s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;}}s:6:"author";a:2:{s:4:"name";s:6:"Author";s:12:"capabilities";a:10:{s:12:"upload_files";b:1;s:10:"edit_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:4:"read";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;s:22:"delete_published_posts";b:1;}}s:11:"contributor";a:2:{s:4:"name";s:11:"Contributor";s:12:"capabilities";a:5:{s:10:"edit_posts";b:1;s:4:"read";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;}}s:10:"subscriber";a:2:{s:4:"name";s:10:"Subscriber";s:12:"capabilities";a:2:{s:4:"read";b:1;s:7:"level_0";b:1;}}}', 'yes'),
(100, 0, 'widget_search', 'a:2:{i:2;a:1:{s:5:"title";s:0:"";}s:12:"_multiwidget";i:1;}', 'yes'),
(101, 0, 'widget_recent-posts', 'a:2:{i:2;a:2:{s:5:"title";s:0:"";s:6:"number";i:5;}s:12:"_multiwidget";i:1;}', 'yes'),
(102, 0, 'widget_recent-comments', 'a:2:{i:2;a:2:{s:5:"title";s:0:"";s:6:"number";i:5;}s:12:"_multiwidget";i:1;}', 'yes'),
(103, 0, 'widget_archives', 'a:2:{i:2;a:3:{s:5:"title";s:0:"";s:5:"count";i:0;s:8:"dropdown";i:0;}s:12:"_multiwidget";i:1;}', 'yes'),
(104, 0, 'widget_meta', 'a:2:{i:2;a:1:{s:5:"title";s:0:"";}s:12:"_multiwidget";i:1;}', 'yes'),
(105, 0, 'sidebars_widgets', 'a:7:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:6:{i:0;s:8:"search-2";i:1;s:14:"recent-posts-2";i:2;s:17:"recent-comments-2";i:3;s:10:"archives-2";i:4;s:12:"categories-2";i:5;s:6:"meta-2";}s:9:"sidebar-2";a:0:{}s:9:"sidebar-3";a:0:{}s:9:"sidebar-4";a:0:{}s:9:"sidebar-5";a:0:{}s:13:"array_version";i:3;}', 'yes'),
(106, 0, '_transient_random_seed', '6684b7bf8957b600926ba5f4a6eda295', 'yes'),
(107, 0, 'logged_in_salt', '/ru9|`kW|eo{3K*c_F/1%RN)L?=3hPhQ+lT5fu)D3fY8fsb]&R,vE(u9]{qRz@CX', 'yes'),
(108, 0, 'cron', 'a:3:{i:1354645632;a:3:{s:16:"wp_version_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:17:"wp_update_plugins";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:16:"wp_update_themes";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1354688840;a:1:{s:19:"wp_scheduled_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}s:7:"version";i:2;}', 'yes'),
(110, 0, '_site_transient_update_core', 'O:8:"stdClass":3:{s:7:"updates";a:1:{i:0;O:8:"stdClass":9:{s:8:"response";s:7:"upgrade";s:8:"download";s:40:"http://wordpress.org/wordpress-3.4.2.zip";s:6:"locale";s:5:"en_US";s:8:"packages";O:8:"stdClass":4:{s:4:"full";s:40:"http://wordpress.org/wordpress-3.4.2.zip";s:10:"no_content";s:51:"http://wordpress.org/wordpress-3.4.2-no-content.zip";s:11:"new_bundled";s:52:"http://wordpress.org/wordpress-3.4.2-new-bundled.zip";s:7:"partial";b:0;}s:7:"current";s:5:"3.4.2";s:11:"php_version";s:5:"5.2.4";s:13:"mysql_version";s:3:"5.0";s:11:"new_bundled";s:3:"3.2";s:15:"partial_version";s:0:"";}}s:12:"last_checked";i:1490072462;s:15:"version_checked";s:5:"4.7.3";}', 'yes'),
(111, 0, 'auth_salt', 'R&AB_|X65}%;Zt;T<U) F<F:D80bLGH*tMYn)5RJ%o`+IsYJ&Yo{/f[fb/sx_aB-', 'yes'),
(112, 0, '_site_transient_update_plugins', 'O:8:"stdClass":3:{s:12:"last_checked";i:1490072462;s:7:"checked";a:2:{s:58:"add_custom_link_to_wordpress_admin_bar/add_custom_link.php";s:3:"1.0";s:9:"hello.php";s:3:"1.6";}s:8:"response";a:0:{}}', 'yes'),
(113, 0, '_site_transient_update_themes', 'O:8:"stdClass":3:{s:12:"last_checked";i:1354603650;s:7:"checked";a:2:{s:12:"twentyeleven";s:3:"1.3";s:9:"twentyten";s:3:"1.3";}s:8:"response";a:2:{s:12:"twentyeleven";a:3:{s:11:"new_version";s:3:"1.4";s:3:"url";s:47:"http://wordpress.org/extend/themes/twentyeleven";s:7:"package";s:64:"http://wordpress.org/extend/themes/download/twentyeleven.1.4.zip";}s:9:"twentyten";a:3:{s:11:"new_version";s:3:"1.4";s:3:"url";s:44:"http://wordpress.org/extend/themes/twentyten";s:7:"package";s:61:"http://wordpress.org/extend/themes/download/twentyten.1.4.zip";}}}', 'yes'),
(205, 0, '_site_transient_timeout_browser_4035d4b4450759cca24a82ef888cec49', '1353684437', 'yes'),
(206, 0, '_site_transient_browser_4035d4b4450759cca24a82ef888cec49', 'a:9:{s:8:"platform";s:7:"Windows";s:4:"name";s:7:"Firefox";s:7:"version";s:4:"16.0";s:10:"update_url";s:23:"http://www.firefox.com/";s:7:"img_src";s:50:"http://s.wordpress.org/images/browsers/firefox.png";s:11:"img_src_ssl";s:49:"https://wordpress.org/images/browsers/firefox.png";s:15:"current_version";s:2:"12";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'),
(116, 0, 'dashboard_widget_options', 'a:4:{s:25:"dashboard_recent_comments";a:1:{s:5:"items";i:5;}s:24:"dashboard_incoming_links";a:5:{s:4:"home";s:43:"http://localhost/vistacart/app/webroot/blog";s:4:"link";s:119:"http://blogsearch.google.com/blogsearch?scoring=d&partner=wordpress&q=link:http://localhost/vistacart/app/webroot/blog/";s:3:"url";s:152:"http://blogsearch.google.com/blogsearch_feeds?scoring=d&ie=utf-8&num=10&output=rss&partner=wordpress&q=link:http://localhost/vistacart/app/webroot/blog/";s:5:"items";i:10;s:9:"show_date";b:0;}s:17:"dashboard_primary";a:7:{s:4:"link";s:26:"http://wordpress.org/news/";s:3:"url";s:31:"http://wordpress.org/news/feed/";s:5:"title";s:14:"WordPress Blog";s:5:"items";i:2;s:12:"show_summary";i:1;s:11:"show_author";i:0;s:9:"show_date";i:1;}s:19:"dashboard_secondary";a:7:{s:4:"link";s:28:"http://planet.wordpress.org/";s:3:"url";s:33:"http://planet.wordpress.org/feed/";s:5:"title";s:20:"Other WordPress News";s:5:"items";i:5;s:12:"show_summary";i:0;s:11:"show_author";i:0;s:9:"show_date";i:0;}}', 'yes'),
(117, 0, 'nonce_salt', 'E8+~Ih h%m]x*cg->}r}Tqw_VoFvEDo=&Y?X[VD(-1ofNux@-=jQ6HS_^j;,w,G0', 'yes'),
(118, 0, 'current_theme', 'Twenty Eleven', 'yes'),
(120, 0, 'can_compress_scripts', '1', 'yes'),
(295, 0, '_transient_timeout_feed_mod_1a5f760f2e2b48827d4974a60857e7c2', '1354553574', 'no'),
(296, 0, '_transient_feed_mod_1a5f760f2e2b48827d4974a60857e7c2', '1354510374', 'no'),
(299, 0, '_transient_timeout_dash_de3249c4736ad3bd2cd29147c4a0d43e', '1354553575', 'no'),
(300, 0, '_transient_dash_de3249c4736ad3bd2cd29147c4a0d43e', '<h4>Most Popular</h4>\n<h5><a href=''http://wordpress.org/extend/plugins/wordpress-importer/''>WordPress Importer</a></h5>&nbsp;<span>(<a href=''plugin-install.php?tab=plugin-information&amp;plugin=wordpress-importer&amp;_wpnonce=578c256b88&amp;TB_iframe=true&amp;width=600&amp;height=800'' class=''thickbox'' title=''WordPress Importer''>Install</a>)</span>\n<p>Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.</p>\n<h4>Newest Plugins</h4>\n<h5><a href=''http://wordpress.org/extend/plugins/shortcurl/''>ELI&#039;s cURL Shortcode Parser</a></h5>&nbsp;<span>(<a href=''plugin-install.php?tab=plugin-information&amp;plugin=shortcurl&amp;_wpnonce=a4cf6ec81e&amp;TB_iframe=true&amp;width=600&amp;height=800'' class=''thickbox'' title=''ELI&#039;s cURL Shortcode Parser''>Install</a>)</span>\n<p>This plugin executes wp_remote_get with parameters you pass through a shortcode to display a parsed bit of HTML from another site in your page or post</p>\n<h4>Recently Updated</h4>\n<h5><a href=''http://wordpress.org/extend/plugins/cockpit/''>Cockpit</a></h5>&nbsp;<span>(<a href=''plugin-install.php?tab=plugin-information&amp;plugin=cockpit&amp;_wpnonce=5a4cbd6236&amp;TB_iframe=true&amp;width=600&amp;height=800'' class=''thickbox'' title=''Cockpit''>Install</a>)</span>\n<p>Track your WordPress site&#039;s traffic, and automatically posts to Twitter when you publish a post or page.</p>\n', 'no'),
(289, 0, '_transient_timeout_feed_57bc725ad6568758915363af670fd8bc', '1354553573', 'no'),
(290, 0, '_transient_feed_57bc725ad6568758915363af670fd8bc', 'a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n	\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:72:"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:33:"WordPress Plugins � View: Newest";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:47:"http://wordpress.org/extend/plugins/browse/new/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:33:"WordPress Plugins � View: Newest";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"en-US";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 03 Dec 2012 04:22:45 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:25:"http://bbpress.org/?v=1.1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"item";a:15:{i:0;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:15:"Post PDF Export";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:63:"http://wordpress.org/extend/plugins/post-pdf-export/#post-46411";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 30 Nov 2012 16:00:28 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"46411@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:72:"PDF plugin that gives instant post download( PDF format ) functionality.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:15:"Cristopher Dino";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:22:"AdSense Privacy Policy";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:70:"http://wordpress.org/extend/plugins/adsense-privacy-policy/#post-45778";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 15 Nov 2012 12:09:11 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"45778@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:22:"AdSense Privacy Policy";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:9:"hotvanrod";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:27:"ELI''s cURL Shortcode Parser";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:57:"http://wordpress.org/extend/plugins/shortcurl/#post-46475";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 02 Dec 2012 11:05:57 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"46475@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:150:"This plugin executes wp_remote_get with parameters you pass through a shortcode to display a parsed bit of HTML from another site in your page or post";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:3:"Eli";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"Princess Bride";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:62:"http://wordpress.org/extend/plugins/princess-bride/#post-46413";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 30 Nov 2012 16:51:17 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"46413@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:150:"How do you take one of the funniest films in history and make it even more memorable? With a Wordpress plugin that displays the films best quotes in y";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"jwinton";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:12:"GAS Injector";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:60:"http://wordpress.org/extend/plugins/gas-injector/#post-46459";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 01 Dec 2012 21:40:26 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"46459@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:103:"GAS Injector for Wordpress will help you add Google Analytics on Steroids (GAS) to your WordPress blog.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"hoyce";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:23:"Business Contact Widget";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:71:"http://wordpress.org/extend/plugins/business-contact-widget/#post-46476";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 02 Dec 2012 14:11:46 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"46476@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:132:"This plugin creates a widget which easily displays, without becoming cluttered, all the contact details of the company/organisation.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:16:"StressFree Sites";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:24:"WooCommerce BTC Currency";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:72:"http://wordpress.org/extend/plugins/woocommerce-btc-currency/#post-46490";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 02 Dec 2012 19:07:53 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"46490@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:36:"Adds Bitcoin currency in WooCommerce";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:15:"Claudio Sanches";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"Better Avatars";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:62:"http://wordpress.org/extend/plugins/better-avatars/#post-46485";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 02 Dec 2012 18:42:27 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"46485@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:76:"Replace empty Gravatars with profile images from Facebook, Twitter, or Gmail";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:9:"Pat Hawks";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:8:"Isotopes";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:56:"http://wordpress.org/extend/plugins/isotopes/#post-46415";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 30 Nov 2012 19:24:27 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"46415@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:71:"This plugin give you a template tag that uses isotope js functionality.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"johnstonphilip";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:19:"Security Ninja Lite";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://wordpress.org/extend/plugins/security-ninja-lite/#post-46483";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 02 Dec 2012 16:53:23 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"46483@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:98:"Check your site for security vulnerabilities with one click and get info on many security aspects.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"WebFactory";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:10;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:21:"WooCommerce MultiBank";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:70:"http://wordpress.org/extend/plugins/woocommerce-multi-bank/#post-45606";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 11 Nov 2012 23:05:19 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"45606@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:146:"Accept up to 5 different banks accounts to show to your customer. This is a simple gateway for who want to sell with many different bank accounts.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"andrecarrano";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:11;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:27:"CreativeSignal Testimonials";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:74:"http://wordpress.org/extend/plugins/creativesignal-testimonial/#post-46314";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 28 Nov 2012 15:37:13 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"46314@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:78:"CreativeSignal Testimonial allows you to present testimonials on your website.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"creativesignal";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:12;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:23:"WooCommerce - Amazon UK";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:86:"http://wordpress.org/extend/plugins/woocommerce-gateway-amazon-payments-uk/#post-45865";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 18 Nov 2012 08:17:49 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"45865@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:137:"It is a WooCommerce payment gateway extension for Amazon Payments UK. Works with Amazon Checkout standard. Developed as Wordpress plugin.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:16:"AgileSolutionspk";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:13;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:18:"eewee twitter card";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:66:"http://wordpress.org/extend/plugins/eewee-twitter-card/#post-46458";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 01 Dec 2012 18:09:24 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"46458@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:81:"Use the system &#34;twitter card&#34; proposed by twitter wordrpess on your site.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"eewee";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:14;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:15:"eewee pinterest";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:63:"http://wordpress.org/extend/plugins/eewee-pinterest/#post-46457";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 01 Dec 2012 18:08:41 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"46457@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:149:"Use the wordpress administration to place your Pinterest widget on an area (header, footer) and / or use a shortcode to display the widget Pinterest.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"eewee";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:4:"href";s:48:"http://wordpress.org/extend/plugins/rss/view/new";s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";a:12:{s:3:"via";s:11:"1.1 ARM-005";s:10:"connection";s:5:"close";s:16:"proxy-connection";s:5:"close";s:7:"expires";s:29:"Mon, 03 Dec 2012 04:57:45 GMT";s:4:"date";s:29:"Mon, 03 Dec 2012 04:52:52 GMT";s:12:"content-type";s:23:"text/xml; charset=UTF-8";s:6:"server";s:5:"nginx";s:4:"vary";s:15:"Accept-Encoding";s:13:"cache-control";s:0:"";s:6:"pragma";s:0:"";s:13:"last-modified";s:31:"Mon, 03 Dec 2012 04:22:45 +0000";s:4:"x-nc";s:11:"HIT luv 138";}s:5:"build";s:14:"20090627192103";}', 'no'),
(291, 0, '_transient_timeout_feed_mod_57bc725ad6568758915363af670fd8bc', '1354553573', 'no'),
(292, 0, '_transient_feed_mod_57bc725ad6568758915363af670fd8bc', '1354510373', 'no'),
(273, 0, '_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca', '1354553570', 'no');
INSERT INTO `goStores_Vista_wp_options` (`option_id`, `blog_id`, `option_name`, `option_value`, `autoload`) VALUES
(274, 0, '_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca', 'a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n\n\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:50:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:3:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"WordPress News";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:25:"http://wordpress.org/news";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:14:"WordPress News";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:13:"lastBuildDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 29 Nov 2012 19:55:12 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"en-US";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:37:"http://wordpress.org/?v=3.5-RC2-22975";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"item";a:10:{i:0;a:6:{s:4:"data";s:45:"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:33:"WordPress 3.5 Release Candidate 2";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:68:"http://wordpress.org/news/2012/11/wordpress-3-5-release-candidate-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:77:"http://wordpress.org/news/2012/11/wordpress-3-5-release-candidate-2/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 29 Nov 2012 19:55:12 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:11:"Development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"Testing";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"http://wordpress.org/news/?p=2494";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:339:"The second release candidate for WordPress 3.5 is now available for download and testing. We&#8217;re still working on about a dozen remaining issues, but we hope to deliver WordPress 3.5 to your hands as early as next week. If you&#8217;d like to know what to test, visit the About page ( ? About in the toolbar) and check out [...]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"Andrew Nacin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:1509:"<p>The second release candidate for WordPress 3.5 is now available for download and testing.</p>\n<p>We&#8217;re still working on about a dozen remaining issues, but we hope to deliver WordPress 3.5 to your hands as early as next week. If you&#8217;d like to know what to test, visit the About page (<strong><img alt="" src="http://wordpress.org/wp-content/themes/twentyten/images/wordpress.png" /> ? About</strong> in the toolbar) and check out the list of features! As usual, this is still development software and we suggest you do not install this on a live site unless you are adventurous.</p>\n<p><strong>Think you&#8217;ve found a bug?</strong> Please post to the <a href="http://wordpress.org/support/forum/alphabeta/">Alpha/Beta area in the support forums</a>.</p>\n<p><strong>Developers,</strong> please continue to test your plugins and themes, so that if there is a compatibility issue, we can figure it out before the final release. You can find our <a href="http://core.trac.wordpress.org/report/6">list of known issues here</a>.</p>\n<p>To test WordPress 3.5, try the <a href="http://wordpress.org/extend/plugins/wordpress-beta-tester/">WordPress Beta Tester</a> plugin (you&#8217;ll want &#8220;bleeding edge nightlies&#8221;). Or you can <a href="http://wordpress.org/wordpress-3.5-RC2.zip">download the release candidate here (zip)</a>.</p>\n<p><em>&#8211;<br />\n</em><em>We are getting close<br />\n</em><em>Should have asked for haiku help<br />\n</em><em>Please test RC2</em></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:73:"http://wordpress.org/news/2012/11/wordpress-3-5-release-candidate-2/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:45:"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:31:"WordPress 3.5 Release Candidate";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:66:"http://wordpress.org/news/2012/11/wordpress-3-5-release-candidate/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:75:"http://wordpress.org/news/2012/11/wordpress-3-5-release-candidate/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 22 Nov 2012 13:35:09 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:11:"Development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"Testing";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"http://wordpress.org/news/?p=2479";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:341:"The first release candidate for WordPress 3.5 is now available. We hope to ship WordPress 3.5 in two weeks. But to do that, we need your help! If you haven&#8217;t tested 3.5 yet, there&#8217;s no time like the present. (The oft-repeated warning: Please, not on a live site, unless you&#8217;re adventurous.) Think you&#8217;ve found a [...]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"Andrew Nacin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:1545:"<p>The first release candidate for WordPress 3.5 is now available.</p>\n<p>We hope to ship WordPress 3.5 in <em>two weeks</em>. But to do that, we need your help! If you haven&#8217;t tested 3.5 yet, there&#8217;s no time like the present. (The oft-repeated warning: Please, not on a live site, unless you&#8217;re adventurous.)</p>\n<p><strong>Think you&#8217;ve found a bug?</strong> Please post to the <a href="http://wordpress.org/support/forum/alphabeta/">Alpha/Beta area in the support forums</a>. If any known issues come up, you�ll be able to <a href="http://core.trac.wordpress.org/report/6">find them here</a>. <strong>Developers,</strong> please test your plugins and themes, so that if there is a compatibility issue, we can figure it out before the final release.</p>\n<p>To test WordPress 3.5, try the <a href="http://wordpress.org/extend/plugins/wordpress-beta-tester/">WordPress Beta Tester</a> plugin (you&#8217;ll want &#8220;bleeding edge nightlies&#8221;). Or you can <a href="http://wordpress.org/wordpress-3.5-RC1.zip">download the release candidate here (zip)</a>.</p>\n<p>If you&#8217;d like to know what to <del>break</del> test, visit the About page (<strong><img style="vertical-align: text-top" alt="" src="http://wordpress.org/wp-content/themes/twentyten/images/wordpress.png" /> ? About</strong> in the toolbar) and check out the list of features! Trust me, you want to try out media.</p>\n<p><em>Release candidate</em><br />\n<em>Three point five in two weeks time</em><br />\n<em>Please test all the things</em></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:71:"http://wordpress.org/news/2012/11/wordpress-3-5-release-candidate/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:48:"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:20:"WordPress 3.5 Beta 3";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:55:"http://wordpress.org/news/2012/11/wordpress-3-5-beta-3/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:64:"http://wordpress.org/news/2012/11/wordpress-3-5-beta-3/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 13 Nov 2012 04:26:23 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:3:{i:0;a:5:{s:4:"data";s:11:"Development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:7:"Testing";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"http://wordpress.org/news/?p=2467";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:341:"The third beta release of WordPress 3.5 is now available for download and testing. Hey, developers! We expect to WordPress 3.5 to be ready in just a few short weeks. Please, please test your plugins and themes against beta 3. Media management has been rewritten, and we&#8217;ve taken great pains to ensure most plugins will work the [...]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"Andrew Nacin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:2677:"<p>The third beta release of WordPress 3.5 is now available for download and testing.</p>\n<p><strong>Hey, developers!</strong> We expect to WordPress 3.5 to be ready in just a few short weeks. <em>Please, please</em> test your plugins and themes against beta 3. Media management has been rewritten, and we&#8217;ve taken great pains to ensure most plugins will work the same as before, but we&#8217;re not perfect. We would like to hear about any incompatibilities we&#8217;ve caused so we can work with you to address them <em>before</em> release, rather than after. I think you&#8217;ll agree it&#8217;s much better that way. <img src=''http://wordpress.org/news/wp-includes/images/smilies/icon_smile.gif'' alt='':-)'' class=''wp-smiley'' /> </p>\n<p>To test WordPress 3.5, try the <a href="http://wordpress.org/extend/plugins/wordpress-beta-tester/">WordPress Beta Tester</a> plugin (you�ll want �bleeding edge nightlies�). Or you can <a href="http://wordpress.org/wordpress-3.5-beta3.zip">download the beta here</a> (zip). For more on 3.5, <a title="WordPress 3.5 Beta 1" href="http://wordpress.org/news/2012/09/wordpress-3-5-beta-1/">check out the extensive Beta 1 blog post</a>, which covers what�s new in version 3.5 and how you can help. We made <a href="http://core.trac.wordpress.org/log/trunk?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=22557&amp;stop_rev=22224&amp;limit=400">more than 300 changes</a> since <a href="http://wordpress.org/news/2012/10/wordpress-3-5-beta-2/">beta 2</a>. <span style="line-height: 13px">At this point, the Add Media dialog is complete, and we&#8217;re now just working on fixing up inserting images into the editor. We&#8217;ve also u</span>pdated to jQuery UI 1.9.1, SimplePie 1.3.1, and TinyMCE 3.5.7.</p>\n<p>The usual warnings apply: We can see the light at the end of the tunnel, but this is software still in development, so we don�t recommend that you run it on a production site. Set up a test site to play with the new version.</p>\n<p>As always, if you think you�ve found a bug, you can post to the <a href="http://wordpress.org/support/forum/alphabeta">Alpha/Beta area</a> in the support forums. Or, if you�re comfortable writing a reproducible bug report, <a href="http://core.trac.wordpress.org/">file one on the WordPress Trac</a>. There, you can also find <a href="http://core.trac.wordpress.org/report/5">a list of known bugs</a> and <a href="http://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=3.5">everything we�ve fixed</a> so far.</p>\n<p><em>Beta three is out</em><br />\n<em>Soon, a release candidate</em><br />\n<em>Three point five is near</em></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:60:"http://wordpress.org/news/2012/11/wordpress-3-5-beta-3/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:45:"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:20:"WordPress 3.5 Beta 2";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:55:"http://wordpress.org/news/2012/10/wordpress-3-5-beta-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:64:"http://wordpress.org/news/2012/10/wordpress-3-5-beta-2/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 13 Oct 2012 00:02:08 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"Testing";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"http://wordpress.org/news/?p=2458";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:342:"Two weeks after the first beta, WordPress 3.5 Beta 2 is now available for download and testing. This is software still in development, so we don�t recommend that you run it on a production site. Set up a test site to play with the new version. To test WordPress 3.5, try the WordPress Beta Tester plugin (you�ll want �bleeding [...]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"Andrew Nacin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:1856:"<p>Two weeks after the first beta, WordPress 3.5 Beta 2 is now available for download and testing.</p>\n<p>This is software still in development, so we don�t recommend that you run it on a production site. Set up a test site to play with the new version. To test WordPress 3.5, try the <a href="http://wordpress.org/extend/plugins/wordpress-beta-tester/">WordPress Beta Tester</a> plugin (you�ll want �bleeding edge nightlies�). Or you can <a href="http://wordpress.org/wordpress-3.5-beta2.zip">download the beta here</a> (zip).</p>\n<p>For more, <a title="WordPress 3.5 Beta 1" href="http://wordpress.org/news/2012/09/wordpress-3-5-beta-1/"><strong>check out the extensive Beta 1 blog post</strong></a>, which covers what&#8217;s new in version 3.5 and how you can help. What&#8217;s new since beta 1? I&#8217;m glad you asked:</p>\n<ul>\n<li>New workflow for working with image galleries, including drag-and-drop reordering and quick caption editing.</li>\n<li>New image editing API. (<a title="Ticket 6821" href="http://core.trac.wordpress.org/ticket/6821">#6821</a>)</li>\n<li><del>New user interface for setting static front pages for the Reading Settings screen. (<a title="Ticket 16379" href="http://core.trac.wordpress.org/ticket/16379">#16379</a>)</del></li>\n</ul>\n<p>As always, if you think you�ve found a bug, you can post to the <a href="http://wordpress.org/support/forum/alphabeta">Alpha/Beta area</a> in the support forums. Or, if you�re comfortable writing a reproducible bug report, <a href="http://core.trac.wordpress.org/">file one on the WordPress Trac</a>. There, you can also find <a href="http://core.trac.wordpress.org/report/5">a list of known bugs</a> and <a href="http://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=3.5">everything we�ve fixed</a> so far. Happy testing!</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:60:"http://wordpress.org/news/2012/10/wordpress-3-5-beta-2/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:45:"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:35:"WordPress 3.5 Beta 1 (and a bonus!)";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:55:"http://wordpress.org/news/2012/09/wordpress-3-5-beta-1/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:64:"http://wordpress.org/news/2012/09/wordpress-3-5-beta-1/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 27 Sep 2012 22:37:49 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"Testing";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"http://wordpress.org/news/?p=2443";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:376:"I&#8217;m excited to announce the availability of WordPress 3.5 Beta 1. This is software still in development and we really don�t recommend that you run it on a production site � set up a test site just to play with the new version. To test WordPress 3.5, try the WordPress Beta Tester plugin (you�ll want �bleeding edge nightlies�). Or you can download [...]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"Andrew Nacin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:6696:"<p>I&#8217;m excited to announce the availability of WordPress 3.5 Beta 1.</p>\n<p>This is software still in development and <strong>we <em>really</em> don�t recommend that you run it on a production site</strong> � set up a test site just to play with the new version. To test WordPress 3.5, try the <a href="http://wordpress.org/extend/plugins/wordpress-beta-tester/">WordPress Beta Tester</a> plugin (you�ll want �bleeding edge nightlies�). Or you can <a href="http://wordpress.org/wordpress-3.5-beta-1.zip">download the beta here</a> (zip).</p>\n<p>In just three short months, we&#8217;ve already made a few hundred changes to improve your WordPress experience. The biggest thing we&#8217;ve been working on is overhauling the media experience from the ground up. We&#8217;ve made it all fair game: How you upload photos, arrange galleries, insert images into posts, and more. It&#8217;s still rough around the edges and some pieces are missing � which means now is the <em>perfect</em> time to test it out, report issues, and help shape our headline feature.</p>\n<p>As always, if you think you�ve found a bug, you can post to the <a href="http://wordpress.org/support/forum/alphabeta">Alpha/Beta area</a> in the support forums. Or, if you�re comfortable writing a reproducible bug report, <a href="http://core.trac.wordpress.org/">file one on the WordPress Trac</a>. There, you can also find <a href="http://core.trac.wordpress.org/report/5">a list of known bugs</a> and <a href="http://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=3.5">everything we&#8217;ve fixed</a> so far.</p>\n<p>Here&#8217;s some more of what&#8217;s new:</p>\n<ul>\n<li><strong>Appearance: </strong>A simplified welcome screen. A new color picker. And the all-HiDPI (retina) dashboard.</li>\n<li><strong>Accessibility:</strong> Keyboard navigation and screen reader support have both been improved.</li>\n<li><strong>Plugins: </strong>You can browse and install plugins you&#8217;ve marked as favorites on WordPress.org, directly from your dashboard.</li>\n<li><strong>Mobile: </strong>It&#8217;ll be easier to link up your WordPress install with <a href="http://wordpress.org/extend/mobile/">our mobile apps</a>, as XML-RPC is now enabled by default.</li>\n<li><strong>Links: </strong>We&#8217;ve hidden the Link Manager for new installs. (Don&#8217;t worry, <a href="http://wordpress.org/extend/plugins/link-manager/">there&#8217;s a plugin for that</a>.)</li>\n</ul>\n<p><strong>Developers: </strong>We love you. We do. And one of the things we strive to do with every release is be compatible with all existing plugins and themes. To make sure we don&#8217;t break anything, we need your help. <strong>Please, please test your plugins and themes against 3.5.</strong> If something isn&#8217;t quite right, please let us know. (Chances are, it wasn&#8217;t intentional.) And despite all of the changes to media, we&#8217;re still aiming to be backwards compatible with plugins that make changes to the existing media library. It&#8217;s a tall task, and it means we need your help.</p>\n<p>Here&#8217;s some more things we think developers will enjoy (and should test their plugins and themes against):</p>\n<ul>\n<li><strong>External libraries updated:</strong> TinyMCE  <del>3.5.6</del> 3.5.7. SimplePie <del>1.3</del> 1.3.1. jQuery <del>1.8.2</del> 1.8.3. jQuery UI <del>1.9 (and it&#8217;s not even released yet)</del> 1.9.2. We&#8217;ve also added Backbone 0.9.2 and Underscore <del>1.3.3</del> 1.4.2, and you can use protocol-relative links when enqueueing scripts and styles. (<a href="http://core.trac.wordpress.org/ticket/16560">#16560</a>)</li>\n<li><strong>WP Query:</strong> You can now ask to receive posts in the order specified by <code>post__in</code>. (<a href="http://core.trac.wordpress.org/ticket/13729">#13729</a>)</li>\n<li><strong>XML-RPC:</strong> New user management, profile editing, and post revision methods. We&#8217;ve also removed AtomPub. (<a href="http://core.trac.wordpress.org/ticket/18428">#18428</a>, <a href="http://core.trac.wordpress.org/ticket/21397">#21397</a>, <a href="http://core.trac.wordpress.org/ticket/21866">#21866</a>)</li>\n<li><strong>Multisite: </strong>switch_to_blog() is now used in more places, is faster, and more reliable. Also: You can now use multisite in a subdirectory, and uploaded files no longer go through ms-files (for new installs). (<a href="http://core.trac.wordpress.org/ticket/21434">#21434</a>, <a href="http://core.trac.wordpress.org/ticket/19796">#19796</a>, <a href="http://core.trac.wordpress.org/ticket/19235">#19235</a>)</li>\n<li><strong>TinyMCE: </strong>We&#8217;ve added an experimental API for &#8220;views&#8221; which you can use to offer previews and interaction of elements from the visual editor. (<a href="http://core.trac.wordpress.org/ticket/21812">#21812</a>)</li>\n<li><strong>Posts API: </strong>Major performance improvements when working with hierarchies of pages and post ancestors. Also, you can now &#8220;turn on&#8221; native custom columns for taxonomies on edit post screens. (<a href="http://core.trac.wordpress.org/ticket/11399">#11399</a>, <a href="http://core.trac.wordpress.org/ticket/21309">#21309</a>, <a href="http://core.trac.wordpress.org/ticket/21240">#21240</a>)</li>\n<li><strong>Comments API:</strong> Search for comments of a particular status, or with a meta query (same as with WP_Query). (<a href="http://core.trac.wordpress.org/ticket/21101">#21101</a>, <a href="http://core.trac.wordpress.org/ticket/21003">#21003</a>)</li>\n<li><strong>oEmbed: </strong>We&#8217;ve added support for a few oEmbed providers, and we now handle SSL links. (<a href="http://core.trac.wordpress.org/ticket/15734">#15734</a>, <a href="http://core.trac.wordpress.org/ticket/21635">#21635</a>, <a href="http://core.trac.wordpress.org/ticket/16996">#16996</a>, <a href="http://core.trac.wordpress.org/ticket/20102">#20102</a>)</li>\n</ul>\n<p>We&#8217;re looking forward to your feedback. If you break it (find a bug), please report it, and if you�re a developer, try to help us fix it. We&#8217;ve already had more than 200 contributors to version 3.5 � come join us!</p>\n<h3>And as promised, a bonus:</h3>\n<p>We&#8217;re planning a December 5 release for WordPress 3.5. But, we have a special offering for you, today. The newest default theme for WordPress, <strong>Twenty</strong><strong> Twelve</strong>, is now <a href="http://wordpress.org/extend/themes/twentytwelve">available for download</a> from the WordPress themes directory. It&#8217;s a gorgeous and fully responsive theme, and it works with WordPress 3.4.2. Take it for a spin!</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:60:"http://wordpress.org/news/2012/09/wordpress-3-5-beta-1/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:45:"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:48:"WordPress 3.4.2 Maintenance and Security Release";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:50:"http://wordpress.org/news/2012/09/wordpress-3-4-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:59:"http://wordpress.org/news/2012/09/wordpress-3-4-2/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 06 Sep 2012 20:07:21 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:8:"Security";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"http://wordpress.org/news/?p=2426";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:355:"WordPress 3.4.2, now available for download, is a maintenance and security release for all previous versions. After nearly 15 million downloads since 3.4 was released not three months ago, we&#8217;ve identified and fixed a number of nagging bugs, including: Fix some issues with older browsers in the administration area. Fix an issue where a theme [...]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"Andrew Nacin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:1443:"<p>WordPress 3.4.2, now available for download, is a maintenance and security release for all previous versions.</p>\n<p>After nearly 15 million downloads since 3.4 was released not three months ago, we&#8217;ve <a href="http://core.trac.wordpress.org/query?status=closed&amp;resolution=fixed&amp;milestone=3.4.2&amp;group=resolution&amp;order=severity&amp;desc=1">identified and fixed a number of nagging bugs</a>, including:</p>\n<ul>\n<li>Fix some issues with older browsers in the administration area.</li>\n<li>Fix an issue where a theme may not preview correctly, or its screenshot may not be displayed.</li>\n<li>Improve plugin compatibility with the visual editor.</li>\n<li>Address pagination problems with some category permalink structures.</li>\n<li>Avoid errors with both oEmbed providers and trackbacks.</li>\n<li>Prevent improperly sized header images from being uploaded.</li>\n</ul>\n<p>Version 3.4.2 also fixes a few security issues and contains some security hardening. The vulnerabilities included potential privilege escalation and a bug that affects multisite installs with untrusted users. These issues were discovered and fixed by the WordPress security team.</p>\n<p><a href="http://wordpress.org/download/"><strong>Download 3.4.2</strong></a><strong> now or visit Dashboard ? Updates in your site admin to update now.</strong></p>\n<p><em>Fixes for some bugs<br />\nBack to work on 3.5<br />\nIt&#8217;s time to update</em></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:55:"http://wordpress.org/news/2012/09/wordpress-3-4-2/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:60:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:23:"Event Organizers Unite!";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:57:"http://wordpress.org/news/2012/07/event-organizers-unite/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:66:"http://wordpress.org/news/2012/07/event-organizers-unite/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 13 Jul 2012 08:18:15 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:7:{i:0;a:5:{s:4:"data";s:9:"Community";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:6:"Events";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:7:"classes";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:12:"contributors";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:10:"hackathons";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:7:"meetups";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:6;a:5:{s:4:"data";s:9:"WordCamps";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"http://wordpress.org/news/?p=2412";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:388:"I&#8217;m happy to announce the formation of a new official contributor group within the WordPress project for the organizers of in-person events that promote WordPress. Though there are hundreds of people around the globe organizing WordCamps, WordPress meetups, hackathons, free classes and the like, since their &#8220;projects&#8221; were all happening locally there was never a [...]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"Jane Wells";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:3709:"<p>I&#8217;m happy to announce the formation of a new official contributor group within the WordPress project for the organizers of in-person events that promote WordPress. Though there are hundreds of people around the globe organizing WordCamps, WordPress meetups, hackathons, free classes and the like, since their &#8220;projects&#8221; were all happening locally there was never a central hub of activity for these folks. Despite the many informal connections between community organizers, we weren&#8217;t taking advantage of the huge existing knowledge base as new organizers stepped up to the plate.</p>\n<p>With the creation of <a href="http://make.wordpress.org/events/">this new contributor group</a>, we finally have a way to organize and recognize these kinds of contributions, a clear avenue for feedback and input when it comes to policies around official events, and the opportunity to create even more connections between community organizers through mentorship programs and group projects. I&#8217;m especially excited about the creation of this group because until now the role of community organizer, while one of the most important, has not gotten the same recognition as higher-profile contribution methods such as forum support or core code contribution. That is something I hope this group will change, and the local organizers can be recognized for the community leaders they are.*</p>\n<p>If you are the organizer of a local WordCamp, WordPress meetup, etc., head over to <a href="http://make.wordpress.org/events/">http://make.wordpress.org/events/</a> and introduce yourself so we can include you in the fun!</p>\n<p>Speaking of meetups, an update on <a href="http://wordpress.org/news/2012/01/year-of-the-meetup/">my last post about meetups</a> is long overdue. With around 500 meetup organizers (and/or potential organizers) responding to my last survey, it took much longer than anticipated to review all the responses. We&#8217;re working now with meetup.com to issue invitations to join a centralized WordPress Meetup account, so if you filled out the form earlier this year, you should be hearing from them soon. The first wave of existing meetup account transfers (for those who opted in) should happen in the next two weeks, with additional waves every 3 months thereafter (and new groups will be able to be created along the way).</p>\n<p>The <a href="http://wordpress.org/news/2012/05/calling-all-contributors-community-summit-2012/">contributor summit</a> that is being planned for the end of October also generated hundreds of responses/nominations, so that review process is still happening, but we should be announcing some basic plans and issuing invitations soon.</p>\n<p>And finally, it would be impossible to talk about in-person WordPress events without mentioning the upcoming annual <a href="http://2012.sf.wordcamp.org">WordCamp in San Francisco</a>. As the event that represents the worldwide project as a whole, it&#8217;s the perfect time to evaluate where we stand as a project and as a community, to help determine where we go next. If you&#8217;re a WordPress user, developer, or in any way a part of our vast and interconnected ecosystem, please take a moment to fill in the <a href="http://wpsurvey.polldaddy.com/s/wp-2012">2nd annual WordPress survey</a>. It&#8217;s just a couple of questions, and your input would be greatly appreciated. The results of the survey will be announced at <a href="http://2012.sf.wordcamp.org">WSCF</a>, and a report issued shortly thereafter.</p>\n<p>Thanks!</p>\n<p>*<em> I am also of the firm belief that academic and arts activities should earn varsity letters just like sports teams do &#8212; go mathletes! </em></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:62:"http://wordpress.org/news/2012/07/event-organizers-unite/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:45:"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:48:"WordPress 3.4.1 Maintenance and Security Release";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:50:"http://wordpress.org/news/2012/06/wordpress-3-4-1/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:59:"http://wordpress.org/news/2012/06/wordpress-3-4-1/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 27 Jun 2012 19:57:46 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:8:"Security";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"http://wordpress.org/news/?p=2383";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:379:"WordPress 3.4.1 is now available for download. WordPress 3.4 has been a very smooth release, and copies are flying off the shelf &#8212; 3 million downloads in two weeks! This maintenance release addresses 18 bugs with version 3.4, including: Fixes an issue where a theme&#8217;s page templates were sometimes not detected. Addresses problems with some category permalink [...]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"Andrew Nacin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:1585:"<p>WordPress 3.4.1 is now available for download. WordPress 3.4 has been a very smooth release, and copies are flying off the shelf &#8212; 3 million downloads in two weeks! This maintenance release addresses <a href="http://core.trac.wordpress.org/query?status=closed&amp;resolution=fixed&amp;milestone=3.4.1&amp;group=resolution&amp;order=severity&amp;desc=1">18 bugs</a> with version 3.4, including:</p>\n<ul>\n<li>Fixes an issue where a theme&#8217;s page templates were sometimes not detected.</li>\n<li>Addresses problems with some category permalink structures.</li>\n<li>Better handling for plugins or themes loading JavaScript incorrectly.</li>\n<li>Adds early support for uploading images on iOS 6 devices.</li>\n<li>Allows for a technique commonly used by plugins to detect a network-wide activation.</li>\n<li>Better compatibility with servers running certain versions of PHP (5.2.4, 5.4) or with uncommon setups (safe mode, open_basedir), which had caused warnings or in some cases prevented emails from being sent.</li>\n</ul>\n<p>Version 3.4.1 also fixes a few security issues and contains some security hardening. The vulnerabilities included potential information disclosure as well as an bug that affects multisite installs with untrusted users. These issues were discovered and fixed by the WordPress security team.</p>\n<p><strong><a href="http://wordpress.org/download/">Download 3.4.1</a> now or visit Dashboard ? Updates in your site admin to update now.</strong></p>\n<p><em>Green was a bit green<br />\nWe have hardened it up some<br />\nUpdate WordPress now</em></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:55:"http://wordpress.org/news/2012/06/wordpress-3-4-1/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:25:"WordPress 3.4 �Green�";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:40:"http://wordpress.org/news/2012/06/green/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:49:"http://wordpress.org/news/2012/06/green/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 13 Jun 2012 18:42:40 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"http://wordpress.org/news/?p=2334";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:386:"WordPress 3.4 is here and out the door. We&#8217;ve dubbed this release &#8220;Green&#8221; in honor of guitarist Grant Green whose soulful simplicity has kept many of us company during this release. This release includes significant improvements to theme customization, custom headers, Twitter embeds, and image captions &#8212; here&#8217;s a short clip with the highlights: For [...]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Matt Mullenweg";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:15280:"<p>WordPress 3.4 is <a href="http://wordpress.org/download/">here and out the door</a>. We&#8217;ve dubbed this release &#8220;Green&#8221; in honor of guitarist <a href="http://en.wikipedia.org/wiki/Grant_Green">Grant Green</a> whose soulful simplicity has kept many of us company during this release.</p>\n<p>This release includes significant improvements to theme customization, custom headers, Twitter embeds, and image captions &#8212; here&#8217;s a short clip with the highlights:</p>\n<div id="v-Gg0EFixV-1" class="video-player"><embed id="v-Gg0EFixV-1-video" src="http://s0.videopress.com/player.swf?v=1.03&amp;guid=Gg0EFixV&amp;isDynamicSeeking=true" type="application/x-shockwave-flash" width="692" height="388" title="Introducing WordPress 3.4 &quot;Green&quot;" wmode="direct" seamlesstabbing="true" allowfullscreen="true" allowscriptaccess="always" overstretch="true"></embed></div>\n<h3>For Users</h3>\n<p>The biggest change in 3.4 is the <strong>theme customizer</strong> which allows you to play around with various looks and settings for your current theme or one you&#8217;re thinking about switching to without publishing those changes to the whole world. For themes that support it, you can change colors, backgrounds, and of course custom image headers. We have more planned for the customizer down the road.</p>\n<p>Throughout the rest of the admin you&#8217;ll notice tweaks to make your everyday life easier. For example, if you have lots of themes we&#8217;ve made it quicker to browse them all at once without paging. We&#8217;ve made it possible to use images from your media library to populate custom headers, and for you to choose the height and width of your header images.</p>\n<p>We&#8217;ve expanded our embed support to include tweets: just put a Twitter permalink on its own line in the post editor and we&#8217;ll turn it into a beautiful embedded Tweet. And finally, image captions have been improved to allow HTML, like links, in them.</p>\n<h3>For Developers</h3>\n<p>There are hundreds of under-the-hood improvements in this release, notably in the XML-RPC, themes, and custom header APIs, and significant performance improvements in WP_Query and the translation system. <a href="http://codex.wordpress.org/Version_3.4">The Codex has a pretty good summary of the developer features</a>, and you can always <a href="http://core.trac.wordpress.org/milestone/3.4">dive into Trac directly</a>.</p>\n<p>We&#8217;ve also <a href="http://wpdevel.wordpress.com/2012/06/07/wordpress-3-4-field-guide-for-developers/">put together a busy developer&#8217;s field guide to the new APIs in 3.4</a>.</p>\n<h3>It takes a village</h3>\n<p>Here are some of the fine folks who were involved in bringing 3.4 to the world:</p>\n<p><a href="http://profiles.wordpress.org/082net">082net</a>, <a href="http://profiles.wordpress.org/aaroncampbell">Aaron D. Campbell</a>, <a href="http://profiles.wordpress.org/kawauso">Adam Harley</a>, <a href="http://profiles.wordpress.org/ajacommerce">AJ Acevedo</a>, <a href="http://profiles.wordpress.org/akshayagarwal">akshayagarwal</a>, <a href="http://profiles.wordpress.org/xknown">Alex Concha</a>, <a href="http://profiles.wordpress.org/alexkingorg">Alex King</a>, <a href="http://profiles.wordpress.org/viper007bond">Alex Mills (Viper007Bond)</a>, <a href="http://profiles.wordpress.org/ampt">ampt</a>, <a href="http://profiles.wordpress.org/sabreuse">Amy Hendrix</a>, <a href="http://profiles.wordpress.org/andrea_r">Andrea Rennick</a>, <a href="http://profiles.wordpress.org/nacin">Andrew Nacin</a>, <a href="http://profiles.wordpress.org/azaozz">Andrew Ozz</a>, <a href="http://profiles.wordpress.org/andrewryno">Andrew Ryno</a>, <a href="http://profiles.wordpress.org/andy">Andy Skelton</a>, <a href="http://profiles.wordpress.org/arieputranto">Arie Putranto</a>, <a href="http://profiles.wordpress.org/filosofo">Austin Matzko</a>, <a href="http://profiles.wordpress.org/barry">Barry</a>, <a href="http://profiles.wordpress.org/benchapman">BenChapman</a>, <a href="http://profiles.wordpress.org/husobj">Ben Huson</a>, <a href="http://profiles.wordpress.org/benbalter">Benjamin J. Balter</a>, <a href="http://profiles.wordpress.org/billerickson">Bill Erickson</a>, <a href="http://profiles.wordpress.org/bananastalktome">Billy (bananastalktome)</a>, <a href="http://profiles.wordpress.org/boonebgorges">Boone Gorges</a>, <a href="http://profiles.wordpress.org/camiloclc">camiloclc</a>, <a href="http://profiles.wordpress.org/casben79">casben79</a>, <a href="http://profiles.wordpress.org/caspie">Caspie</a>, <a href="http://profiles.wordpress.org/ceefour">ceefour</a>, <a href="http://profiles.wordpress.org/cheald">cheald</a>, <a href="http://profiles.wordpress.org/chellycat">chellycat</a>, <a href="http://profiles.wordpress.org/chexee">Chelsea Otakan</a>, <a href="http://profiles.wordpress.org/chipbennett">Chip Bennett</a>, <a href="http://profiles.wordpress.org/c3mdigital">Chris Olbekson</a>, <a href="http://profiles.wordpress.org/coenjacobs">Coen Jacobs</a>, <a href="http://profiles.wordpress.org/scribu">Cristi Burc&#259;</a>, <a href="http://profiles.wordpress.org/cyapow">Cyapow</a>, <a href="http://profiles.wordpress.org/djcp">Dan Collis-Puro</a>, <a href="http://profiles.wordpress.org/danielbachhuber">Daniel Bachhuber</a>, <a href="http://profiles.wordpress.org/convissor">Daniel Convissor</a>, <a href="http://profiles.wordpress.org/redsweater">Daniel Jalkut (Red Sweater)</a>, <a href="http://profiles.wordpress.org/daniloercoli">daniloercoli</a>, <a href="http://profiles.wordpress.org/koopersmith">Daryl Koopersmith</a>, <a href="http://profiles.wordpress.org/dgwyer">David Gwyer</a>, <a href="http://profiles.wordpress.org/deltafactory">deltafactory</a>, <a href="http://profiles.wordpress.org/demetris">demetris</a>, <a href="http://profiles.wordpress.org/dd32">Dion Hulse</a>, <a href="http://profiles.wordpress.org/dllh">dllh</a>, <a href="http://profiles.wordpress.org/ocean90">Dominik Schilling</a>, <a href="http://profiles.wordpress.org/dougwrites">Doug Provencio</a>, <a href="http://profiles.wordpress.org/drewapicture">Drew Jaynes (DrewAPicture)</a>, <a href="http://profiles.wordpress.org/ebababi">ebababi</a>, <a href="http://profiles.wordpress.org/edward-mindreantre">edward-mindreantre</a>, <a href="http://profiles.wordpress.org/emhr">emhr</a>, <a href="http://profiles.wordpress.org/empireoflight">Empireoflight</a>, <a href="http://profiles.wordpress.org/ericlewis">Eric Andrew Lewis</a>, <a href="http://profiles.wordpress.org/ericmann">Eric Mann</a>, <a href="http://profiles.wordpress.org/ejdanderson">Evan Anderson</a>, <a href="http://profiles.wordpress.org/evansolomon">Evan Solomon</a>, <a href="http://profiles.wordpress.org/fredwu">Fred Wu</a>, <a href="http://profiles.wordpress.org/ounziw">Fumito Mizuno</a>, <a href="http://profiles.wordpress.org/garyc40">Gary Cao</a>, <a href="http://profiles.wordpress.org/garyj">Gary Jones</a>, <a href="http://profiles.wordpress.org/gautamgupta">Gautam</a>, <a href="http://profiles.wordpress.org/soulseekah">Gennady Kovshenin</a>, <a href="http://profiles.wordpress.org/mamaduka">George Mamadashvili</a>, <a href="http://profiles.wordpress.org/georgestephanis">George Stephanis</a>, <a href="http://profiles.wordpress.org/webord">Gustavo Bordoni</a>, <a href="http://profiles.wordpress.org/hearvox">hearvox</a>, <a href="http://profiles.wordpress.org/helenyhou">Helen Hou-Sandi</a>, <a href="http://profiles.wordpress.org/hugobaeta">Hugo Baeta</a>, <a href="http://profiles.wordpress.org/iandstewart">Ian Stewart</a>, <a href="http://profiles.wordpress.org/insertvisionhere">insertvisionhere</a>, <a href="http://profiles.wordpress.org/ipstenu">Ipstenu</a>, <a href="http://profiles.wordpress.org/master-jake">Jacob Chappell</a>, <a href="http://profiles.wordpress.org/jane">Jane Wells</a>, <a href="http://profiles.wordpress.org/japh">Japh</a>, <a href="http://profiles.wordpress.org/jaquers">jaquers</a>, <a href="http://profiles.wordpress.org/jarretc">JarretC</a>, <a href="http://profiles.wordpress.org/jeremyclarke">jeremyclarke</a>, <a href="http://profiles.wordpress.org/jeremyfelt">Jeremy Felt</a>, <a href="http://profiles.wordpress.org/jayjdk">Jesper Johansen (Jayjdk)</a>, <a href="http://profiles.wordpress.org/jiehanzheng">Jiehan Zheng</a>, <a href="http://profiles.wordpress.org/intoxstudio">Joachim Jensen (Intox Studio)</a>, <a href="http://profiles.wordpress.org/jkudish">Joachim Kudish (jkudish)</a>, <a href="http://profiles.wordpress.org/johnbillion">John Blackbourn (johnbillion)</a>, <a href="http://profiles.wordpress.org/aldenta">John Ford</a>, <a href="http://profiles.wordpress.org/johnjamesjacoby">John James Jacoby</a>, <a href="http://profiles.wordpress.org/duck_">Jon Cave</a>, <a href="http://profiles.wordpress.org/joostdevalk">Joost de Valk</a>, <a href="http://profiles.wordpress.org/koke">Jorge Bernal</a>, <a href="http://profiles.wordpress.org/josephscott">Joseph Scott</a>, <a href="http://profiles.wordpress.org/devesine">Justin</a>, <a href="http://profiles.wordpress.org/justindgivens">Justin Givens</a>, <a href="http://profiles.wordpress.org/trepmal">Kailey Lampert (trepmal)</a>, <a href="http://profiles.wordpress.org/kenan3008">Kenan Dervisevic</a>, <a href="http://profiles.wordpress.org/kovshenin">Konstantin Kovshenin</a>, <a href="http://profiles.wordpress.org/kobenland">Konstantin Obenland</a>, <a href="http://profiles.wordpress.org/klagraff">Kristopher Lagraff</a>, <a href="http://profiles.wordpress.org/kurtpayne">Kurt Payne</a>, <a href="http://profiles.wordpress.org/lancewillett">Lance Willett</a>, <a href="http://profiles.wordpress.org/lardjo">Lardjo</a>, <a href="http://profiles.wordpress.org/leewillis77">Lee Willis (leewillis77)</a>, <a href="http://profiles.wordpress.org/linuxologos">linuxologos</a>, <a href="http://profiles.wordpress.org/latz">Lutz Schroer</a>, <a href="http://profiles.wordpress.org/settle">Mantas Malcius</a>, <a href="http://profiles.wordpress.org/netweblogic">Marcus</a>, <a href="http://profiles.wordpress.org/markjaquith">Mark Jaquith</a>, <a href="http://profiles.wordpress.org/markoheijnen">Marko Heijnen</a>, <a href="http://profiles.wordpress.org/markauk">Mark Rowatt Anderson</a>, <a href="http://profiles.wordpress.org/matveb">Matias Ventura</a>, <a href="http://profiles.wordpress.org/sivel">Matt Martz</a>, <a href="http://profiles.wordpress.org/mattonomics">mattonomics</a>, <a href="http://profiles.wordpress.org/iammattthomas">Matt Thomas</a>, <a href="http://profiles.wordpress.org/mattwiebe">Matt Wiebe</a>, <a href="http://profiles.wordpress.org/mattyrob">MattyRob</a>, <a href="http://profiles.wordpress.org/maxcutler">Max Cutler</a>, <a href="http://profiles.wordpress.org/merty">Mert Yazicioglu</a>, <a href="http://profiles.wordpress.org/mgolawala">mgolawala</a>, <a href="http://profiles.wordpress.org/mdawaffe">Michael Adams (mdawaffe)</a>, <a href="http://profiles.wordpress.org/tw2113">Michael Beckwith</a>, <a href="http://profiles.wordpress.org/mfields">Michael Fields</a>, <a href="http://profiles.wordpress.org/mikeschinkel">Mike Schinkel</a>, <a href="http://profiles.wordpress.org/dh-shredder">Mike Schroder</a>, <a href="http://profiles.wordpress.org/toppa">Mike Toppa</a>, <a href="http://profiles.wordpress.org/dimadin">Milan Dinic</a>, <a href="http://profiles.wordpress.org/mitchoyoshitaka">mitcho (Michael Yoshitaka Erlewine)</a>, <a href="http://profiles.wordpress.org/batmoo">Mohammad Jangda</a>, <a href="http://profiles.wordpress.org/mrtorrent">mrtorrent</a>, <a href="http://profiles.wordpress.org/namely">Name.ly</a>, <a href="http://profiles.wordpress.org/Nao">Naoko McCracken</a>, <a href="http://profiles.wordpress.org/alex-ye">Nashwan Doaqan</a>, <a href="http://profiles.wordpress.org/niallkennedy">Niall Kennedy</a>, <a href="http://profiles.wordpress.org/nikolayyordanov">Nikolay Yordanov</a>, <a href="http://profiles.wordpress.org/norocketsurgeon">norocketsurgeon</a>, <a href="http://profiles.wordpress.org/npetetin">npetetin</a>, <a href="http://profiles.wordpress.org/nunomorgadinho">Nuno Morgadinho</a>, <a href="http://profiles.wordpress.org/ocollet">Olivier Collet</a>, <a href="http://profiles.wordpress.org/pbiron">Paul Biron</a>, <a href="http://profiles.wordpress.org/pavelevap">pavelevap</a>, <a href="http://profiles.wordpress.org/petemall">Pete Mall</a>, <a href="http://profiles.wordpress.org/westi">Peter Westwood</a>, <a href="http://profiles.wordpress.org/pishmishy">pishmishy</a>, <a href="http://profiles.wordpress.org/nprasath002">Prasath Nadarajah</a>, <a href="http://profiles.wordpress.org/prettyboymp">prettyboymp</a>, <a href="http://profiles.wordpress.org/ptahdunbar">Ptah Dunbar</a>, <a href="http://profiles.wordpress.org/pw201">pw201</a>, <a href="http://profiles.wordpress.org/ramiy">Rami Yushuvaev</a>, <a href="http://profiles.wordpress.org/rarst">Rarst</a>, <a href="http://profiles.wordpress.org/arena">RENAUT</a>, <a href="http://profiles.wordpress.org/greuben">Reuben Gunday</a>, <a href="http://profiles.wordpress.org/roscius">Roscius</a>, <a href="http://profiles.wordpress.org/rosshanney">Ross Hanney</a>, <a href="http://profiles.wordpress.org/russellwwest">russellwwest</a>, <a href="http://profiles.wordpress.org/ryan">Ryan Boren</a>, <a href="http://profiles.wordpress.org/ryanduff">Ryan Duff</a>, <a href="http://profiles.wordpress.org/rmccue">Ryan McCue</a>, <a href="http://profiles.wordpress.org/zeo">Safirul Alredha</a>, <a href="http://profiles.wordpress.org/solarissmoke">Samir Shah</a>, <a href="http://profiles.wordpress.org/otto42">Samuel &#8220;Otto&#8221; Wood</a>, <a href="http://profiles.wordpress.org/tenpura">Seisuke Kuraishi</a>, <a href="http://profiles.wordpress.org/sergeybiryukov">Sergey Biryukov</a>, <a href="http://profiles.wordpress.org/simonwheatley">Simon Wheatley</a>, <a href="http://profiles.wordpress.org/sirzooro">sirzooro</a>, <a href="http://profiles.wordpress.org/sksmatt">sksmatt</a>, <a href="http://profiles.wordpress.org/sushkov">Stas Su&#537;kov</a>, <a href="http://profiles.wordpress.org/stephdau">Stephane Daury (stephdau)</a>, <a href="http://profiles.wordpress.org/tamlyn">tamlyn</a>, <a href="http://profiles.wordpress.org/griffinjt">Thomas Griffin</a>, <a href="http://profiles.wordpress.org/tott">Thorsten Ott</a>, <a href="http://profiles.wordpress.org/tobiasbg">TobiasBg</a>, <a href="http://profiles.wordpress.org/tomauger">Tom Auger</a>, <a href="http://profiles.wordpress.org/skithund">Toni Viemero</a>, <a href="http://profiles.wordpress.org/transom">transom</a>, <a href="http://profiles.wordpress.org/sorich87">Ulrich Sossou</a>, <a href="http://profiles.wordpress.org/utkarsh">Utkarsh Kukreti</a>, <a href="http://profiles.wordpress.org/wojtekszkutnik">Wojtek Szkutnik</a>, <a href="http://profiles.wordpress.org/wonderslug">wonderslug</a>, <a href="http://profiles.wordpress.org/xibe">Xavier Borderie</a>, <a href="http://profiles.wordpress.org/yoavf">Yoav Farhi</a>, <a href="http://profiles.wordpress.org/thezman84">Zach &#8220;The Z Man&#8221; Abernathy</a>, <a href="http://profiles.wordpress.org/tollmanz">Zack Tollman</a>, <a href="http://profiles.wordpress.org/vanillalounge">Ze Fontainhas</a>, and <a href="http://profiles.wordpress.org/zx2c4">zx2c4</a>.</p>\n<p>See you next time!</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:45:"http://wordpress.org/news/2012/06/green/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:45:"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:33:"WordPress 3.4 Release Candidate 3";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:68:"http://wordpress.org/news/2012/06/wordpress-3-4-release-candidate-3/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:77:"http://wordpress.org/news/2012/06/wordpress-3-4-release-candidate-3/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 12 Jun 2012 00:30:14 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:11:"Development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"Testing";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"http://wordpress.org/news/?p=2326";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:325:"The third release candidate for WordPress 3.4 is now available. Since RC2, we&#8217;ve fixed a few lingering issues with the new live preview feature, as well as with custom headers and backgrounds. There are no remaining issues, and we plan to release 3.4 in the coming days. But if you think you&#8217;ve found a bug, [...]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"Andrew Nacin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:1376:"<p>The third release candidate for WordPress 3.4 is now available. Since RC2, we&#8217;ve fixed a few lingering issues with the new live preview feature, as well as with custom headers and backgrounds.</p>\n<p>There are no remaining issues, and we plan to release 3.4 in the coming days. But if you think you&#8217;ve found a bug, you can post to the <a href="http://wordpress.org/support/forum/alphabeta">Alpha/Beta area</a> in the support forums, or file a bug report on <a href="http://core.trac.wordpress.org/">WordPress Trac</a>.</p>\n<p>To test WordPress 3.4, try the <a href="http://wordpress.org/extend/plugins/wordpress-beta-tester/">WordPress Beta Tester</a> plugin (you�ll want &#8220;bleeding edge nightlies&#8221;). Or you can <a href="http://wordpress.org/wordpress-3.4-RC3.zip">download the release candidate here</a> (zip). Be sure to visit <strong><img style="vertical-align: text-top" src="http://wordpress.org/wp-content/themes/twentyten/images/wordpress.png" alt="" /> ? About</strong> for an updated list of features and under-the-hood changes. As a reminder: We�ve published some resources on the <a href="http://wpdevel.wordpress.com/2012/06/07/wordpress-3-4-field-guide-for-developers/">development blog</a> to help plugin and theme developers prepare.</p>\n<p><em>The new live preview<br />\nNearing perfection, and yet?<br />\nNot yet. RC3</em></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:73:"http://wordpress.org/news/2012/06/wordpress-3-4-release-candidate-3/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:4:"href";s:31:"http://wordpress.org/news/feed/";s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:44:"http://purl.org/rss/1.0/modules/syndication/";a:2:{s:12:"updatePeriod";a:1:{i:0;a:5:{s:4:"data";s:6:"hourly";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:15:"updateFrequency";a:1:{i:0;a:5:{s:4:"data";s:1:"1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";a:10:{s:3:"via";s:11:"1.1 ARM-005";s:10:"connection";s:5:"close";s:16:"proxy-connection";s:5:"close";s:4:"date";s:29:"Mon, 03 Dec 2012 04:52:48 GMT";s:12:"content-type";s:23:"text/xml; charset=UTF-8";s:6:"server";s:5:"nginx";s:4:"vary";s:15:"Accept-Encoding";s:10:"x-pingback";s:36:"http://wordpress.org/news/xmlrpc.php";s:13:"last-modified";s:29:"Thu, 29 Nov 2012 19:55:12 GMT";s:4:"x-nc";s:11:"HIT luv 138";}s:5:"build";s:14:"20090627192103";}', 'no');
INSERT INTO `goStores_Vista_wp_options` (`option_id`, `blog_id`, `option_name`, `option_value`, `autoload`) VALUES
(269, 0, '_transient_timeout_feed_mod_df8dd1af63fcd3e9ca55161c4fe30db8', '1354553568', 'no'),
(270, 0, '_transient_feed_mod_df8dd1af63fcd3e9ca55161c4fe30db8', '1354510368', 'no'),
(271, 0, '_transient_timeout_dash_20494a3d90a6669585674ed0eb8dcd8f', '1354553568', 'no'),
(272, 0, '_transient_dash_20494a3d90a6669585674ed0eb8dcd8f', '<p>This dashboard widget queries <a href="http://blogsearch.google.com/">Google Blog Search</a> so that when another blog links to your site it will show up here. It has found no incoming links&hellip; yet. It&#8217;s okay &#8212; there is no rush.</p>\n', 'no'),
(267, 0, '_transient_timeout_feed_df8dd1af63fcd3e9ca55161c4fe30db8', '1354553568', 'no'),
(268, 0, '_transient_feed_df8dd1af63fcd3e9ca55161c4fe30db8', 'a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:4:"\n  \n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:33:"\n    \n    \n    \n    \n    \n    \n  ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:3:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:70:"link:http://localhost/vistacart/app/webroot/blog/ - Google Blog Search";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:107:"http://www.google.com/search?ie=utf-8&q=link:http://localhost/vistacart/app/webroot/blog/&tbm=blg&tbs=sbd:1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:101:"Your search - <b>link:http://localhost/vistacart/app/webroot/blog/</b> - did not match any documents.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://a9.com/-/spec/opensearch/1.1/";a:3:{s:12:"totalResults";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:10:"startIndex";a:1:{i:0;a:5:{s:4:"data";s:1:"1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:12:"itemsPerPage";a:1:{i:0;a:5:{s:4:"data";s:2:"10";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";a:12:{s:3:"via";s:11:"1.1 ARM-005";s:10:"connection";s:5:"close";s:16:"proxy-connection";s:5:"close";s:7:"expires";s:2:"-1";s:4:"date";s:29:"Mon, 03 Dec 2012 04:52:48 GMT";s:12:"content-type";s:28:"text/xml; charset=ISO-8859-1";s:6:"server";s:3:"gws";s:13:"cache-control";s:18:"private, max-age=0";s:10:"set-cookie";a:2:{i:0;s:143:"PREF=ID=cf471c019e8997bc:FF=0:TM=1354510368:LM=1354510368:S=BcGmBpqBQ1hSB7a7; expires=Wed, 03-Dec-2014 04:52:48 GMT; path=/; domain=.google.com";i:1;s:212:"NID=66=Wdjswy8VQjXzgOSj_xN2JuBvib1iy3SOXon6i17A-jIEB5ndZDZngtqp5l3tA9W0veTMQw5vGxMSJVh5leZcEK5OgvJH4NFJYzm69cty064ci78BO85IoYSdf_2ormbv; expires=Tue, 04-Jun-2013 04:52:48 GMT; path=/; domain=.google.com; HttpOnly";}s:3:"p3p";s:122:"CP="This is not a P3P policy! See http://www.google.com/support/accounts/bin/answer.py?hl=en&answer=151657 for more info."";s:16:"x-xss-protection";s:13:"1; mode=block";s:15:"x-frame-options";s:10:"SAMEORIGIN";}s:5:"build";s:14:"20090627192103";}', 'no'),
(281, 0, '_transient_timeout_feed_mod_867bd5c64f85878d03a060509cd2f92c', '1354553571', 'no'),
(282, 0, '_transient_feed_mod_867bd5c64f85878d03a060509cd2f92c', '1354510371', 'no'),
(283, 0, '_transient_timeout_dash_aa95765b5cc111c56d5993d476b1c2f0', '1354553571', 'no'),
(284, 0, '_transient_dash_aa95765b5cc111c56d5993d476b1c2f0', '<div class="rss-widget"><ul><li><a class=''rsswidget'' href=''http://wordpress.tv/2012/12/02/the-power-of-wordpress-roles-and-capabilities/'' title='' [&hellip;]''>WordPress.tv: Erick Hitter:  The Power of WordPress Roles and Capabilities</a></li><li><a class=''rsswidget'' href=''http://lorelle.wordpress.com/2012/12/02/check-out-the-new-media-manager-in-wordpress/'' title=''WordPress.com users were greeted with a new Media Manager over the weekend. This is the new media uploader coming in WordPress 3.5 when it releases December 5, 2012. For most of us, this is a long-awaited, dream come true. The clunky WordPress Image Uploader is gone, replaced with one more visual and easy-to-use. The announcement [&hellip;]''>Lorelle on WP: Check Out the New Media Manager in WordPress</a></li><li><a class=''rsswidget'' href=''http://wordpress.tv/2012/12/02/dan-pastori-plugin-development-practices/'' title='' [&hellip;]''>WordPress.tv: Dan Pastori: Plugin Development Practices</a></li><li><a class=''rsswidget'' href=''http://wordpress.tv/2012/12/02/ruth-maude-moving-from-wordpress-com-to-wordpress-org/'' title='' [&hellip;]''>WordPress.tv: Ruth Maude: Moving from WordPress.com to WordPress.org</a></li><li><a class=''rsswidget'' href=''http://feedproxy.google.com/~r/WordpressTavern/~3/lry_PYfjwNk/docs-team-needs-your-help-for-wordpress-3-5'' title=''As we near the release of WordPress 3.5, the docs team is looking for your help to insure that the Codex has all of the necessary information pertaining to the new release. So far, there is a hefty list of items that need to be added or amended in the Codex, especially as it pertains to media. You are encouraged to add to the list or if you�re a member of th [&hellip;]''>WPTavern: Docs Team Needs Your Help For WordPress 3.5</a></li></ul></div>', 'no'),
(285, 0, '_transient_timeout_feed_a5420c83891a9c88ad2a4f04584a5efc', '1354553571', 'no'),
(286, 0, '_transient_feed_a5420c83891a9c88ad2a4f04584a5efc', 'a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n	\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:72:"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:39:"WordPress Plugins � View: Most Popular";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://wordpress.org/extend/plugins/browse/popular/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:39:"WordPress Plugins � View: Most Popular";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"en-US";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 03 Dec 2012 04:24:20 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:25:"http://bbpress.org/?v=1.1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"item";a:15:{i:0;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:24:"Jetpack by WordPress.com";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:55:"http://wordpress.org/extend/plugins/jetpack/#post-23862";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 20 Jan 2011 02:21:38 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"23862@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:104:"Supercharge your WordPress site with powerful features previously only available to WordPress.com users.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:24:"Michael Adams (mdawaffe)";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"Contact Form 7";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:61:"http://wordpress.org/extend/plugins/contact-form-7/#post-2141";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 02 Aug 2007 12:45:03 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:41:"2141@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:54:"Just another contact form plugin. Simple but flexible.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:16:"Takayuki Miyoshi";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:15:"NextGEN Gallery";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:62:"http://wordpress.org/extend/plugins/nextgen-gallery/#post-1169";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 23 Apr 2007 20:08:06 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:41:"1169@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:93:"The most popular WordPress gallery plugin with tons of features and over 6 million downloads.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:9:"Alex Rabe";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:19:"All in One SEO Pack";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:65:"http://wordpress.org/extend/plugins/all-in-one-seo-pack/#post-753";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 30 Mar 2007 20:08:18 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:40:"753@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:86:"WordPress SEO plugin to automatically optimize your Wordpress blog for Search Engines.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:8:"uberdose";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:18:"WordPress Importer";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:66:"http://wordpress.org/extend/plugins/wordpress-importer/#post-18101";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 20 May 2010 17:42:45 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"18101@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:101:"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Brian Colinger";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:19:"Google XML Sitemaps";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:70:"http://wordpress.org/extend/plugins/google-sitemap-generator/#post-132";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 09 Mar 2007 22:31:32 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:40:"132@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:105:"This plugin will generate a special XML sitemap which will help search engines to better index your blog.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Arne";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:6:"gtrans";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:54:"http://wordpress.org/extend/plugins/gtrans/#post-30417";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 22 Sep 2011 11:48:04 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"30417@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:63:"Make your website available to the world using Google Translate";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"kikadev";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:7:"Akismet";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:52:"http://wordpress.org/extend/plugins/akismet/#post-15";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 09 Mar 2007 22:11:30 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:39:"15@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:98:"Akismet checks your comments against the Akismet web service to see if they look like spam or not.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Matt Mullenweg";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:22:"WordPress SEO by Yoast";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:60:"http://wordpress.org/extend/plugins/wordpress-seo/#post-8321";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 01 Jan 2009 20:34:44 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:41:"8321@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:131:"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using the WordPress SEO plugin by Yoast.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:13:"Joost de Valk";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:19:"Google Analyticator";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:65:"http://wordpress.org/extend/plugins/google-analyticator/#post-130";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 09 Mar 2007 22:31:18 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:40:"130@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:107:"Adds the necessary JavaScript code to enable Google Analytics. Includes widgets for Analytics data display.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"cavemonkey50";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:10;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:8:"Facebook";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:56:"http://wordpress.org/extend/plugins/facebook/#post-37351";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 02 May 2012 19:36:35 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"37351@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:75:"Make your WordPress site social in a couple of clicks, powered by Facebook.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:18:"Samuel Wood (Otto)";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:11;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"WP Super Cache";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:61:"http://wordpress.org/extend/plugins/wp-super-cache/#post-2572";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 05 Nov 2007 11:40:04 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:41:"2572@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:73:"A very fast caching engine for WordPress that produces static html files.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:16:"Donncha O Caoimh";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:12;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:30:"Google Analytics for WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:77:"http://wordpress.org/extend/plugins/google-analytics-for-wordpress/#post-2316";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 14 Sep 2007 12:15:27 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:41:"2316@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:145:"Track your WordPress site easily and with lots of metadata: views per author &#38; category, automatic tracking of outbound clicks and pageviews.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:13:"Joost de Valk";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:13;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:12:"WP-PostViews";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:58:"http://wordpress.org/extend/plugins/wp-postviews/#post-370";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 09 Mar 2007 23:18:37 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:40:"370@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:66:"Enables you to display how many times a post/page had been viewed.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:11:"Lester Chan";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:14;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:13:"WP e-Commerce";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:59:"http://wordpress.org/extend/plugins/wp-e-commerce/#post-739";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 30 Mar 2007 06:08:41 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:40:"739@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:132:"WP e-Commerce is a free WordPress Shopping Cart Plugin that lets customers buy your products, services and digital downloads online.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:6:"Mufasa";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:4:"href";s:52:"http://wordpress.org/extend/plugins/rss/view/popular";s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";a:12:{s:3:"via";s:11:"1.1 ARM-005";s:10:"connection";s:5:"close";s:16:"proxy-connection";s:5:"close";s:7:"expires";s:29:"Mon, 03 Dec 2012 04:59:20 GMT";s:4:"date";s:29:"Mon, 03 Dec 2012 04:52:49 GMT";s:12:"content-type";s:23:"text/xml; charset=UTF-8";s:6:"server";s:5:"nginx";s:4:"vary";s:15:"Accept-Encoding";s:13:"cache-control";s:0:"";s:6:"pragma";s:0:"";s:13:"last-modified";s:31:"Mon, 03 Dec 2012 04:24:20 +0000";s:4:"x-nc";s:11:"HIT luv 138";}s:5:"build";s:14:"20090627192103";}', 'no'),
(275, 0, '_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca', '1354553570', 'no'),
(276, 0, '_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca', '1354510370', 'no'),
(277, 0, '_transient_timeout_dash_4077549d03da2e451c8b5f002294ff51', '1354553570', 'no'),
(278, 0, '_transient_dash_4077549d03da2e451c8b5f002294ff51', '<div class="rss-widget"><ul><li><a class=''rsswidget'' href=''http://wordpress.org/news/2012/11/wordpress-3-5-release-candidate-2/'' title=''The second release candidate for WordPress 3.5 is now available for download and testing. We�re still working on about a dozen remaining issues, but we hope to deliver WordPress 3.5 to your hands as early as next week. If you�d like to know what to test, visit the About page ( ? About in the toolbar) and check out [&hellip;]''>WordPress 3.5 Release Candidate 2</a> <span class="rss-date">November 29, 2012</span><div class=''rssSummary''>The second release candidate for WordPress 3.5 is now available for download and testing. We�re still working on about a dozen remaining issues, but we hope to deliver WordPress 3.5 to your hands as early as next week. If you�d like to know what to test, visit the About page ( ? About in the toolbar) and check out [&hellip;]</div></li><li><a class=''rsswidget'' href=''http://wordpress.org/news/2012/11/wordpress-3-5-release-candidate/'' title=''The first release candidate for WordPress 3.5 is now available. We hope to ship WordPress 3.5 in two weeks. But to do that, we need your help! If you haven�t tested 3.5 yet, there�s no time like the present. (The oft-repeated warning: Please, not on a live site, unless you�re adventurous.) Think you�ve found a [&hellip;]''>WordPress 3.5 Release Candidate</a> <span class="rss-date">November 22, 2012</span><div class=''rssSummary''>The first release candidate for WordPress 3.5 is now available. We hope to ship WordPress 3.5 in two weeks. But to do that, we need your help! If you haven�t tested 3.5 yet, there�s no time like the present. (The oft-repeated warning: Please, not on a live site, unless you�re adventurous.) Think you�ve found a [&hellip;]</div></li></ul></div>', 'no'),
(279, 0, '_transient_timeout_feed_867bd5c64f85878d03a060509cd2f92c', '1354553571', 'no');
INSERT INTO `goStores_Vista_wp_options` (`option_id`, `blog_id`, `option_name`, `option_value`, `autoload`) VALUES
(280, 0, '_transient_feed_867bd5c64f85878d03a060509cd2f92c', 'a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n\n\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:61:"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:16:"WordPress Planet";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:28:"http://planet.wordpress.org/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:2:"en";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:47:"WordPress Planet - http://planet.wordpress.org/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"item";a:50:{i:0;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:74:"WordPress.tv: Erick Hitter:  The Power of WordPress Roles and Capabilities";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:28:"http://wordpress.tv/?p=14215";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:77:"http://wordpress.tv/2012/12/02/the-power-of-wordpress-roles-and-capabilities/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:684:"<div id="v-SmyZSeEy-1" class="video-player">\n</div>\n<br />  <a rel="nofollow" href="http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/14215/"><img alt="" border="0" src="http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/14215/" /></a> <img alt="" border="0" src="http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=14215&subd=wptv&ref=&feed=1" width="1" height="1" /><div><a href="http://wordpress.tv/2012/12/02/the-power-of-wordpress-roles-and-capabilities/"><img alt="ErickHitterSync-SD 24 No Gamma Correction 800kbits.mov" src="http://videos.videopress.com/SmyZSeEy/video-b74ff7a5e3_scruberthumbnail_0.jpg" width="160" height="120" /></a></div>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 02 Dec 2012 23:02:57 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"WordPress.tv";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:59:"Lorelle on WP: Check Out the New Media Manager in WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:36:"http://lorelle.wordpress.com/?p=7020";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:85:"http://lorelle.wordpress.com/2012/12/02/check-out-the-new-media-manager-in-wordpress/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:492:"WordPress.com users were greeted with a new Media Manager over the weekend. This is the new media uploader coming in WordPress 3.5 when it releases December 5, 2012. For most of us, this is a long-awaited, dream come true. The clunky WordPress Image Uploader is gone, replaced with one more visual and easy-to-use. The announcement [...]<img alt="" border="0" src="http://stats.wordpress.com/b.gif?host=lorelle.wordpress.com&blog=72&post=7020&subd=lorelle&ref=&feed=1" width="1" height="1" />";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 02 Dec 2012 22:36:32 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:17:"Lorelle VanFossen";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:55:"WordPress.tv: Dan Pastori: Plugin Development Practices";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:28:"http://wordpress.tv/?p=14212";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:72:"http://wordpress.tv/2012/12/02/dan-pastori-plugin-development-practices/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:672:"<div id="v-KVy04vqk-1" class="video-player">\n</div>\n<br />  <a rel="nofollow" href="http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/14212/"><img alt="" border="0" src="http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/14212/" /></a> <img alt="" border="0" src="http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=14212&subd=wptv&ref=&feed=1" width="1" height="1" /><div><a href="http://wordpress.tv/2012/12/02/dan-pastori-plugin-development-practices/"><img alt="DanPastoriSync-SD 24 No Gamma Correction 800kbits.mov" src="http://videos.videopress.com/KVy04vqk/video-e81c42a624_std.original.jpg" width="160" height="120" /></a></div>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 02 Dec 2012 15:58:15 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"WordPress.tv";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:68:"WordPress.tv: Ruth Maude: Moving from WordPress.com to WordPress.org";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:28:"http://wordpress.tv/?p=14437";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:85:"http://wordpress.tv/2012/12/02/ruth-maude-moving-from-wordpress-com-to-wordpress-org/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:674:"<div id="v-f51gmJmv-1" class="video-player">\n</div>\n<br />  <a rel="nofollow" href="http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/14437/"><img alt="" border="0" src="http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/14437/" /></a> <img alt="" border="0" src="http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=14437&subd=wptv&ref=&feed=1" width="1" height="1" /><div><a href="http://wordpress.tv/2012/12/02/ruth-maude-moving-from-wordpress-com-to-wordpress-org/"><img alt="wcto-moving-from-com-to-org-10-29-2012.mp4" src="http://videos.videopress.com/f51gmJmv/video-3d99c4b189_std.original.jpg" width="160" height="120" /></a></div>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 02 Dec 2012 15:37:56 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"WordPress.tv";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:53:"WPTavern: Docs Team Needs Your Help For WordPress 3.5";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:31:"http://www.wptavern.com/?p=6671";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:105:"http://feedproxy.google.com/~r/WordpressTavern/~3/lry_PYfjwNk/docs-team-needs-your-help-for-wordpress-3-5";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1224:"<p>As we near the release of WordPress 3.5, the docs team is <a href="http://make.wordpress.org/docs/2012/11/27/if-all-goes-to-plan-wordpress-3-5-will/">looking for your help</a> to insure that the Codex has all of the necessary information pertaining to the new release. So far, there is a hefty list of items that need to be added or amended in the Codex, especially as it pertains to media. You are encouraged to add to the list or if you&#8217;re a member of the Codex, to begin adding the necessary information. </p>\n<p>Related posts:<ol>\n<li><a href="http://www.wptavern.com/beta-team-being-established-for-wordpress-ios" rel="bookmark" title="Beta Team Being Established For WordPress iOS">Beta Team Being Established For WordPress iOS</a></li>\n<li><a href="http://www.wptavern.com/is-a-plugin-validation-team-a-pipe-dream" rel="bookmark" title="Is A Plugin Validation Team A Pipe Dream?">Is A Plugin Validation Team A Pipe Dream?</a></li>\n<li><a href="http://www.wptavern.com/more-info-on-the-handbook-project" rel="bookmark" title="More Info On The Handbook Project">More Info On The Handbook Project</a></li>\n</ol></p><img src="http://feeds.feedburner.com/~r/WordpressTavern/~4/lry_PYfjwNk" height="1" width="1" />";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 30 Nov 2012 23:48:49 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:6:"Jeffro";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:56:"WordPress.tv: Andy Nathan: Building Serious Blog Traffic";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:28:"http://wordpress.tv/?p=14209";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:73:"http://wordpress.tv/2012/11/30/andy-nathan-building-serious-blog-traffic/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:675:"<div id="v-5D5WX31W-1" class="video-player">\n</div>\n<br />  <a rel="nofollow" href="http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/14209/"><img alt="" border="0" src="http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/14209/" /></a> <img alt="" border="0" src="http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=14209&subd=wptv&ref=&feed=1" width="1" height="1" /><div><a href="http://wordpress.tv/2012/11/30/andy-nathan-building-serious-blog-traffic/"><img alt="AndyNathan-SD 24 No Gamma Correction 800kbits.mov" src="http://videos.videopress.com/5D5WX31W/video-3ce40d7d37_scruberthumbnail_1.jpg" width="160" height="120" /></a></div>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 30 Nov 2012 13:00:11 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"WordPress.tv";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:69:"WordPress.tv: Rachel Baker: Developing WordPress for All Screen Sizes";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:28:"http://wordpress.tv/?p=14225";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:86:"http://wordpress.tv/2012/11/30/rachel-baker-developing-wordpress-for-all-screen-sizes/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:687:"<div id="v-9lRGpJwz-1" class="video-player">\n</div>\n<br />  <a rel="nofollow" href="http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/14225/"><img alt="" border="0" src="http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/14225/" /></a> <img alt="" border="0" src="http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=14225&subd=wptv&ref=&feed=1" width="1" height="1" /><div><a href="http://wordpress.tv/2012/11/30/rachel-baker-developing-wordpress-for-all-screen-sizes/"><img alt="RachelBakerSync-SD 24 No Gamma Correction 800kbits.mov" src="http://videos.videopress.com/9lRGpJwz/video-5d4141650c_std.original.jpg" width="160" height="120" /></a></div>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 30 Nov 2012 13:00:03 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"WordPress.tv";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:53:"WPTavern: Toni Schneider Interviewed On TechCrunch TV";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:31:"http://www.wptavern.com/?p=6661";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:105:"http://feedproxy.google.com/~r/WordpressTavern/~3/6bZa_20Do80/toni-schneider-interviewed-on-techcrunch-tv";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:2321:"<p>Toni Schneider, CEO of Automattic was <a href="http://techcrunch.com/2012/11/28/wordpress-com-restaurant-toni-schneider-interview/">recently interviewed</a> on TechCrunch TV. In the interview, they discussed the new vertical launched on WordPress.com for restaurants. There were a couple of things within this interview that I found fascinating. </p>\n<p>The first is that across the Automattic network which includes sites such as PollDaddy, Gravatar, VaultPress and WordPress.com, Quantcast reports 660,000,000 monthly unique visitors making it the largest network on Quantcast. </p>\n<p>The second is that, WordPress.com operates on the principle of small, incremental changes to the service. Because of this, WordPress.com has gone through about 50,000 versions of WordPress, if every change was a bump in the version number. Even at their current size and scale, they still release multiple batches of code every day. </p>\n<p>Thirdly, I thought it was interesting that Toni Schneider basically said that WordPress.com is following the lead of the overall WordPress community when it comes to features and or verticals on WordPress.com. </p>\n<p>Last but not least, WordPress powers 17.2% of the web, Joomla powers 3% and Drupal has 2%. Everyone else encompasses the rest of the 100%. So while it seems like everyone and their mother as well as their grandpa has a site on WordPress, there is still a huge segment of the market that&#8217;s been untapped by WordPress. </p>\n<p>After watching the interview, is there anything that surprises you or is this all par for the course?</p>\n<div class="aligncenter">\n\n</div>\n<p>Related posts:<ol>\n<li><a href="http://www.wptavern.com/toni-schneider-from-the-freemium-summit" rel="bookmark" title="Toni Schneider From The Freemium Summit">Toni Schneider From The Freemium Summit</a></li>\n<li><a href="http://www.wptavern.com/matt-mullenweg-interviewed-by-kteh" rel="bookmark" title="Matt Mullenweg Interviewed By KTEH">Matt Mullenweg Interviewed By KTEH</a></li>\n<li><a href="http://www.wptavern.com/lester-chan-interviewed-by-singapore-magazine" rel="bookmark" title="Lester Chan Interviewed By Singapore Magazine">Lester Chan Interviewed By Singapore Magazine</a></li>\n</ol></p><img src="http://feeds.feedburner.com/~r/WordpressTavern/~4/6bZa_20Do80" height="1" width="1" />";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 30 Nov 2012 10:17:28 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:6:"Jeffro";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:48:"WordPress.tv: Pippin Williamson: Modular Plugins";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:28:"http://wordpress.tv/?p=14228";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:65:"http://wordpress.tv/2012/11/29/pippin-williamson-modular-plugins/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:668:"<div id="v-RQ8dzgar-1" class="video-player">\n</div>\n<br />  <a rel="nofollow" href="http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/14228/"><img alt="" border="0" src="http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/14228/" /></a> <img alt="" border="0" src="http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=14228&subd=wptv&ref=&feed=1" width="1" height="1" /><div><a href="http://wordpress.tv/2012/11/29/pippin-williamson-modular-plugins/"><img alt="PippinWilliamSync-SD 24 No Gamma Correction 800kbits.mov" src="http://videos.videopress.com/RQ8dzgar/video-3db505271c_std.original.jpg" width="160" height="120" /></a></div>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 30 Nov 2012 04:53:57 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"WordPress.tv";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:52:"Weblog Tools Collection: WordPress 3.5 RC 2 Released";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:41:"http://weblogtoolscollection.com/?p=12290";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:73:"http://feedproxy.google.com/~r/weblogtoolscollection/UXMP/~3/_bM2zqTRp6g/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1550:"<p><a href="http://wordpress.org/">WordPress</a> 3.5 RC 2 <a href="http://wordpress.org/news/2012/11/wordpress-3-5-release-candidate-2/">has been released</a>.</p>\n<p>In <a href="http://weblogtoolscollection.com/archives/2012/11/22/wordpress-3-5-rc-1-released/">the first release candidate</a>, the developers predicted that the final WordPress 3.5 release would be in just two weeks, so I imagine it&#8217;s just about a week away now. Please do try it on a test installation, especially if you are a plugin or theme developer who would rather not have a panic of bug reports on launch day if your product has any incompatibilities with WordPress 3.5. The Media tools have received a rather extensive overhaul, so you might want to try those out if you frequently rely on them, and if you&#8217;re a <a href="http://wordpress.com">WordPress.com</a> blogger, <a href="http://en.blog.wordpress.com/2012/11/29/seamless-media/">the new Media tools are now live on your WordPress.com blog</a>.</p>\n<p>If you run into any bugs, please check the <a href="http://core.trac.wordpress.org/report/6">known</a> and <a href="http://core.trac.wordpress.org/query?status=closed&group=component&milestone=3.5">fixed</a> issues first, <a href="http://codex.wordpress.org/Reporting_Bugs">report them</a> if they have not already been reported, and visit <a href="http://wordpress.org/support/forum/alphabeta">the support forums</a> if you need any help.</p>\n<img src="http://feeds.feedburner.com/~r/weblogtoolscollection/UXMP/~4/_bM2zqTRp6g" height="1" width="1" />";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 29 Nov 2012 21:34:43 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"James";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:10;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:43:"Dev Blog: WordPress 3.5 Release Candidate 2";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"http://wordpress.org/news/?p=2494";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:68:"http://wordpress.org/news/2012/11/wordpress-3-5-release-candidate-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1508:"<p>The second release candidate for WordPress 3.5 is now available for download and testing.</p>\n<p>We&#8217;re still working on about a dozen remaining issues, but we hope to deliver WordPress 3.5 to your hands as early as next week. If you&#8217;d like to know what to test, visit the About page (<strong><img alt="" src="http://wordpress.org/wp-content/themes/twentyten/images/wordpress.png" /> ? About</strong> in the toolbar) and check out the list of features! As usual, this is still development software and we suggest you do not install this on a live site unless you are adventurous.</p>\n<p><strong>Think you&#8217;ve found a bug?</strong> Please post to the <a href="http://wordpress.org/support/forum/alphabeta/">Alpha/Beta area in the support forums</a>.</p>\n<p><strong>Developers,</strong> please continue to test your plugins and themes, so that if there is a compatibility issue, we can figure it out before the final release. You can find our <a href="http://core.trac.wordpress.org/report/6">list of known issues here</a>.</p>\n<p>To test WordPress 3.5, try the <a href="http://wordpress.org/extend/plugins/wordpress-beta-tester/">WordPress Beta Tester</a> plugin (you&#8217;ll want &#8220;bleeding edge nightlies&#8221;). Or you can <a href="http://wordpress.org/wordpress-3.5-RC2.zip">download the release candidate here (zip)</a>.</p>\n<p><em>&#8211;<br />\n</em><em>We are getting close<br />\n</em><em>Should have asked for haiku help<br />\n</em><em>Please test RC2</em></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 29 Nov 2012 19:55:12 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"Andrew Nacin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:11;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:59:"Weblog Tools Collection: WordPress Theme Releases for 11/29";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:41:"http://weblogtoolscollection.com/?p=12283";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:73:"http://feedproxy.google.com/~r/weblogtoolscollection/UXMP/~3/KntRxSxlXUo/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1143:"<p><img class="alignnone  wp-image-12285" title="screenshot" src="http://i0.wp.com/weblogtoolscollection.com/wp-content/uploads/2012/11/screenshot1.png?resize=150%2C113" alt="" /></p>\n<p><a href="http://wordpress.org/extend/themes/d5-design"><strong>D5 Design</strong></a> is an elegant and responsive theme.</p>\n<p><img class="alignnone  wp-image-12284" title="screenshot-1" src="http://i0.wp.com/weblogtoolscollection.com/wp-content/uploads/2012/11/screenshot-1.png?resize=150%2C113" alt="" /></p>\n<p><a href="http://wordpress.org/extend/themes/media-maven"><strong>Media Maven</strong></a> is a simple, clean, and elegant theme.</p>\n<p><img class="alignnone  wp-image-12286" title="DemoBlog" src="http://i0.wp.com/weblogtoolscollection.com/wp-content/uploads/2012/11/DemoBlog1.png?resize=150%2C113" alt="" /></p>\n<p><a href="http://emptynestthemes.com/2012/11/28/sepia-memories-wordpress-website-theme/"><strong>Sepia Memories</strong></a> is a responsive theme inspired by genealogy, history, photography, family, and antiques.</p>\n<img src="http://feeds.feedburner.com/~r/weblogtoolscollection/UXMP/~4/KntRxSxlXUo" height="1" width="1" />";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 29 Nov 2012 15:30:05 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"James";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:12;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:65:"WordPress.tv: Melodie Laylor: Adventures in Non-Profit Web Design";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:28:"http://wordpress.tv/?p=14327";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:82:"http://wordpress.tv/2012/11/29/melodie-laylor-adventures-in-non-profit-web-design/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:683:"<div id="v-BXqEjEaX-1" class="video-player">\n</div>\n<br />  <a rel="nofollow" href="http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/14327/"><img alt="" border="0" src="http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/14327/" /></a> <img alt="" border="0" src="http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=14327&subd=wptv&ref=&feed=1" width="1" height="1" /><div><a href="http://wordpress.tv/2012/11/29/melodie-laylor-adventures-in-non-profit-web-design/"><img alt="Melodie Laylor- Adventures in Nonprofit Web Design.m4v" src="http://videos.videopress.com/BXqEjEaX/video-fc94ed9dd2_std.original.jpg" width="160" height="120" /></a></div>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 29 Nov 2012 14:08:49 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"WordPress.tv";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:13;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:70:"WordPress.tv: Douglas Hanna: The Secrets of Web Hosting without the BS";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:28:"http://wordpress.tv/?p=14323";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:87:"http://wordpress.tv/2012/11/28/douglas-hanna-the-secrets-of-web-hosting-without-the-bs/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:693:"<div id="v-2XMUmT9v-1" class="video-player">\n</div>\n<br />  <a rel="nofollow" href="http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/14323/"><img alt="" border="0" src="http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/14323/" /></a> <img alt="" border="0" src="http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=14323&subd=wptv&ref=&feed=1" width="1" height="1" /><div><a href="http://wordpress.tv/2012/11/28/douglas-hanna-the-secrets-of-web-hosting-without-the-bs/"><img alt="Douglas Hanna-The Secrets of Web Hosting Without the BS.m4v" src="http://videos.videopress.com/2XMUmT9v/video-5baaec237e_std.original.jpg" width="160" height="120" /></a></div>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 29 Nov 2012 06:27:46 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"WordPress.tv";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:14;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:74:"WPTavern: Comparison Spreadsheet For Content Type And Custom Field Plugins";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:31:"http://www.wptavern.com/?p=6642";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:126:"http://feedproxy.google.com/~r/WordpressTavern/~3/7ZX1WEqgUcg/comparison-spreadsheet-for-content-type-and-custom-field-plugins";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1950:"<p>If you&#8217;re looking to use a Content Type or Custom Field plugin, your first stop should be <a href="https://docs.google.com/spreadsheet/ccc?key=0AoY8IFUX301qdFhBaERLUEUwa3U0YjFYTnBmaU1mbmc#gid=3">this large comparison spreadsheet</a> produced by Scott Kingsley Clark, Matt Gibbs and other plugin authors. The comparison spreadsheet shows the differences between the various plugins at a high level. Unfortunately, I can&#8217;t determine when this document was last updated or find an explanation of the various fields represented. For example, one of the fields talks about whether the team contributed back to the WordPress core. It would be interesting to know the qualifications for contributing back to core. </p>\n<p><a href="http://www.wptavern.com/wp-content/uploads/2012/11/plugincomparisonspreadsheet.jpg" rel="thumbnail"><img src="http://www.wptavern.com/wp-content/uploads/2012/11/plugincomparisonspreadsheet.jpg" alt="Plugin Comparison Sheet" title="plugincomparisonspreadsheet" width="586" height="334" class="aligncenter size-full wp-image-6643" /></a></p>\n<p>With so many plugins in existence that aim to serve the same purpose, more informative spreadsheets like these would definitely be beneficial for the community. </p>\n<p>Related posts:<ol>\n<li><a href="http://www.wptavern.com/500-plugins-to-possibly-be-purged-from-the-repository" rel="bookmark" title="500 Plugins To Possibly Be Purged From The Repository">500 Plugins To Possibly Be Purged From The Repository</a></li>\n<li><a href="http://www.wptavern.com/core-plugins-never-gonna-happen" rel="bookmark" title="Core Plugins? Never Gonna Happen!">Core Plugins? Never Gonna Happen!</a></li>\n<li><a href="http://www.wptavern.com/canonical-core-something-plugins" rel="bookmark" title="Canonical, Core, Something Plugins">Canonical, Core, Something Plugins</a></li>\n</ol></p><img src="http://feeds.feedburner.com/~r/WordpressTavern/~4/7ZX1WEqgUcg" height="1" width="1" />";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 28 Nov 2012 20:56:41 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:6:"Jeffro";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:15;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:51:"WordPress.tv: Andy Stratton: 50 Shades of WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:28:"http://wordpress.tv/?p=14325";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:68:"http://wordpress.tv/2012/11/28/andy-stratton-50-shades-of-wordpress/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:656:"<div id="v-Bkzx1cQT-1" class="video-player">\n</div>\n<br />  <a rel="nofollow" href="http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/14325/"><img alt="" border="0" src="http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/14325/" /></a> <img alt="" border="0" src="http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=14325&subd=wptv&ref=&feed=1" width="1" height="1" /><div><a href="http://wordpress.tv/2012/11/28/andy-stratton-50-shades-of-wordpress/"><img alt="Andy Stratton- 50 Shades of WordPress.m4v" src="http://videos.videopress.com/Bkzx1cQT/video-fc08e2cd7f_std.original.jpg" width="160" height="120" /></a></div>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 28 Nov 2012 13:24:06 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"WordPress.tv";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:16;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:60:"Weblog Tools Collection: WordPress Plugin Releases for 11/27";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:41:"http://weblogtoolscollection.com/?p=12277";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:73:"http://feedproxy.google.com/~r/weblogtoolscollection/UXMP/~3/HBA6W9LK5m8/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1082:"<h3>New plugins</h3>\n<p><a href="http://www.knewsplugin.com/"><strong>Knews Multilingual Newsletters</strong></a> allows you to build multilingual professional looking newsletters.</p>\n<p><a href="http://sharp-coders.com/plugins/wp-plugins/wp-subscriber-form"><strong>WP Subscriber Form</strong></a> adds a subscription form to the end of your content.</p>\n<h3>Updated plugins</h3>\n<p><a href="http://wordpress.org/extend/plugins/backwpup/"><strong>BackWPup</strong></a> allows you to backup your WordPress database, files, and more.</p>\n<p><a href="http://wordpress.org/extend/plugins/theme-check/"><strong>Theme-Check</strong></a> allows you to run checks on the current theme before uploading to WordPress. This plugin uses the same API and is kept more or less in sync with the WordPress.org uploader tool.</p>\n<p><a href="http://wordpress.org/extend/plugins/wp-slimstat/"><strong>WP SlimStat</strong></a> is a simple but powerful web analytics plugin for WordPress.</p>\n<img src="http://feeds.feedburner.com/~r/weblogtoolscollection/UXMP/~4/HBA6W9LK5m8" height="1" width="1" />";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 27 Nov 2012 14:00:31 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"James";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:17;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:58:"WPTavern: 300 Free Icons For Web And User Interface Design";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:31:"http://www.wptavern.com/?p=6635";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:110:"http://feedproxy.google.com/~r/WordpressTavern/~3/U_G7_kMCOQA/300-free-icons-for-web-and-user-interface-design";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1939:"<p>Adam Whitcroft has released a 300 icon kit for web and user interface design called <a href="http://adamwhitcroft.com/batch/">Batch</a>. Each icon is a single Photoshop layer making blend modes and scaling a breeze. <del>According to the license, WordPress theme or plugin authors should be able to use these in their works:</del></p>\n<blockquote><p>You are free to use Batch (the &#8220;icon set&#8221;) or any part thereof (the &#8220;icons&#8221;) in any personal, open-source or commercial work without obligation of payment (monetary or otherwise) or attribution. Do not sell the icon set, host the icon set or rent the icon set (either in existing or modified form).</p>\n<p>While attribution is optional, it is always appreciated.</p>\n<p>Intellectual property rights are not transferred with the download of the icons.</p></blockquote>\n<p><a href="http://www.wptavern.com/wp-content/uploads/2012/11/batchiconset.jpg" rel="thumbnail"><img src="http://www.wptavern.com/wp-content/uploads/2012/11/batchiconset.jpg" alt="Batch Icon Set" title="batchiconset" width="467" height="264" class="aligncenter size-full wp-image-6636" /></a></p>\n<p>This icon set previously had a price tag attached to it. Adam <a href="http://adamwhitcroft.com/2012/11/on-batch/">explained</a> why that&#8217;s not the case anymore.</p>\n<p>Related posts:<ol>\n<li><a href="http://www.wptavern.com/studiopress-releases-simple-social-icons-plugin" rel="bookmark" title="StudioPress Releases Simple Social Icons Plugin">StudioPress Releases Simple Social Icons Plugin</a></li>\n<li><a href="http://www.wptavern.com/interview-with-paul-mycroft-on-the-erosion-of-his-web-design-business" rel="bookmark" title="Interview With Paul Mycroft On The Erosion Of His Web Design Business">Interview With Paul Mycroft On The Erosion Of His Web Design Business</a></li>\n</ol></p><img src="http://feeds.feedburner.com/~r/WordpressTavern/~4/U_G7_kMCOQA" height="1" width="1" />";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 27 Nov 2012 09:53:24 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:6:"Jeffro";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:18;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:57:"WPTavern: What Developers Should Know About WordPress 3.5";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:31:"http://www.wptavern.com/?p=6630";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:109:"http://feedproxy.google.com/~r/WordpressTavern/~3/ZPa7lNwpTYA/what-developers-should-know-about-wordpress-3-5";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:2119:"<p><a href="http://www.wptavern.com/wp-content/uploads/2012/11/oneextrapixellogo.jpg" rel="thumbnail"><img src="http://www.wptavern.com/wp-content/uploads/2012/11/oneextrapixellogo-300x63.jpg" alt="One Extra Pixel.com Logo" title="oneextrapixellogo" width="300" height="63" class="alignright size-medium wp-image-6631" /></a>Oneextrapixel.com has a <a href="http://www.onextrapixel.com/2012/11/26/whats-new-in-wordpress-3-5-the-developers-perspective/">list of things</a> that WordPress developers will need to know about concerning WordPress 3.5. However, end users are able to pick up a few things as well, especially the part about settings changes. According to the site, the admin page dedicated to Privacy settings has disappeared. The options on that page have been moved to the Reading Settings area. Also for new installs, the ability to change the Character set has been hidden and will use UTF-8 by default. I think this makes total sense and would like to see similar option UI be removed in the future. Even though the UI will be hidden, you can still access the option via options.php. Going this route seems similar to how FireFox works. While there are things to configure, those who want access to everything can go into <strong>About:config</strong>. </p>\n<p>Over the years, the saying has been, &#8220;<strong>Decisions, not options</strong>&#8220;. I wonder when options.php will be renamed to decisions.php. </p>\n<p>Related posts:<ol>\n<li><a href="http://www.wptavern.com/what-devpress-thinks-wordpress-needs" rel="bookmark" title="What Dev4Press Thinks WordPress Needs">What Dev4Press Thinks WordPress Needs</a></li>\n<li><a href="http://www.wptavern.com/wordpress-developers-that-are-hiring" rel="bookmark" title="WordPress Developers That Are Hiring">WordPress Developers That Are Hiring</a></li>\n<li><a href="http://www.wptavern.com/why-wordpress-has-less-options-not-more" rel="bookmark" title="Why WordPress Has Fewer Options, Not More">Why WordPress Has Fewer Options, Not More</a></li>\n</ol></p><img src="http://feeds.feedburner.com/~r/WordpressTavern/~4/ZPa7lNwpTYA" height="1" width="1" />";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 27 Nov 2012 09:32:17 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:6:"Jeffro";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:19;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:61:"Dougal Campbell: WordPress � ReciPress � WordPress Plugins";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:34:"http://dougal.gunters.org/?p=72177";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:80:"http://dougal.gunters.org/blog/2012/11/26/wordpress-recipress-wordpress-plugins/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:672:"<p><i>I keep meaning to try out Tammy Hart&#8217;s Recipress plugin, which lets you manage recipes using WordPress. My wife and I often share recipes with friends and family, and this could be a fun way to track everything, instead of emailing PDFs around.</i></p>\n<p><a href="http://wordpress.org/extend/plugins/recipress/">WordPress � ReciPress � WordPress Plugins</a></p>\n<p>Original Article: <a href="http://dougal.gunters.org/blog/2012/11/26/wordpress-recipress-wordpress-plugins/">WordPress � ReciPress � WordPress Plugins</a>\n<a href="http://dougal.gunters.org">Dougal Campbell&#039;s geek ramblings - WordPress, web development, and world domination.</a></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 26 Nov 2012 17:17:24 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:15:"Dougal Campbell";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:20;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:66:"Weblog Tools Collection: Updated WordPress Theme Tutorial Complete";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:41:"http://weblogtoolscollection.com/?p=12272";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:73:"http://feedproxy.google.com/~r/weblogtoolscollection/UXMP/~3/0dlGYnWqtiE/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:935:"<p>If you have been desiring to build your own <a href="http://wordpress.org/">WordPress</a> theme, now is certainly the time to do it, as <a href="http://themeshaper.com/">ThemeShaper</a> has completed their updated <a href="http://themeshaper.com/2012/10/22/the-themeshaper-wordpress-theme-tutorial-2nd-edition/">WordPress Theme Tutorial</a>.</p>\n<p>Previously mentioned <a href="http://weblogtoolscollection.com/archives/2012/10/29/updated-wordpress-theme-tutorial-underway/">back in October</a>, this completely free-of-charge tutorial featured new lessons launched every day, with new tool,s and modern up-to-date code examples from <a href="http://underscores.me/">the _s starter theme</a>. Now that the tutorial is complete, you can work at your own pace as you follow it through to your first great WordPress theme.</p>\n<img src="http://feeds.feedburner.com/~r/weblogtoolscollection/UXMP/~4/0dlGYnWqtiE" height="1" width="1" />";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 26 Nov 2012 14:00:57 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"James";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:21;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:44:"WPTavern: Nice Primer On Distributing Themes";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:31:"http://www.wptavern.com/?p=6627";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:96:"http://feedproxy.google.com/~r/WordpressTavern/~3/sa7LLewiliU/nice-primer-on-distributing-themes";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1915:"<p><a href="http://www.wptavern.com/wp-content/uploads/2012/11/themeshaperlogo2.jpg" rel="thumbnail"><img src="http://www.wptavern.com/wp-content/uploads/2012/11/themeshaperlogo2.jpg" alt="Themeshaper.com Logo" title="themeshaperlogo2" width="290" height="93" class="alignright size-full wp-image-6628" /></a> Over on the Automattic Theme team blog, Michelle Langston has published a great <a href="http://themeshaper.com/2012/11/23/distributing-your-wordpress-theme/">primer on distributing themes</a> whether they be free or commercially based. Besides the tips offered for distribution, the tutorial also covers a number of things all theme authors should consider doing before releasing there theme into the wild such as making sure it&#8217;s adaptable, adding a right to left style sheet and avoiding hard coding. I was happy to see that with regards to licensing, there wasn&#8217;t much fluff added. One other thing I noticed that theme authors should find helpful is a <a href="http://codex.wordpress.org/Theme_Review#Bundled_Resources">codex article</a> that lists resources that are GPL-compatible such as Fonts and icon sets. </p>\n<p>Related posts:<ol>\n<li><a href="http://www.wptavern.com/sitepoint-gives-primer-on-parent-child-themes" rel="bookmark" title="SitePoint Gives Primer On Parent Child Themes">SitePoint Gives Primer On Parent Child Themes</a></li>\n<li><a href="http://www.wptavern.com/how-do-i-contribute-to-commercial-gpl-themes" rel="bookmark" title="How Do I Contribute To Commercial GPL Themes?">How Do I Contribute To Commercial GPL Themes?</a></li>\n<li><a href="http://www.wptavern.com/so-many-commercial-themes-so-many-theme-sorters" rel="bookmark" title="So Many Commercial Themes &#8211; So Many Theme Sorters">So Many Commercial Themes &#8211; So Many Theme Sorters</a></li>\n</ol></p><img src="http://feeds.feedburner.com/~r/WordpressTavern/~4/sa7LLewiliU" height="1" width="1" />";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 25 Nov 2012 21:59:36 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:6:"Jeffro";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:22;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:30:"Matt: Sunday Productivity Tips";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:21:"http://ma.tt/?p=42015";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:46:"http://ma.tt/2012/11/sunday-productivity-tips/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:195:"<p><a href="http://thenextweb.com/lifehacks/2012/11/24/start-your-work-week-right-with-these-productive-tips-for-sunday/">Start your work week right with these productive tips for Sunday</a>.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 25 Nov 2012 15:14:14 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:23;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:59:"Weblog Tools Collection: WordPress Theme Releases for 11/25";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:41:"http://weblogtoolscollection.com/?p=12266";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:73:"http://feedproxy.google.com/~r/weblogtoolscollection/UXMP/~3/1gd6Fx9aOH8/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1010:"<p><a href="http://emptynestthemes.com/2012/11/16/in-the-pink-wordpress-theme/"><img class="alignnone size-thumbnail wp-image-12267" title="DemoBlog" src="http://i0.wp.com/weblogtoolscollection.com/wp-content/uploads/2012/11/DemoBlog.png?resize=150%2C150" alt="" /></a></p>\n<p><a href="http://emptynestthemes.com/2012/11/16/in-the-pink-wordpress-theme/"><strong>In The Pink</strong></a> is folksy and crafty, with a feminine look, and uses a blend of different tones of pinks, roses, and grays.</p>\n<p><a href="http://wordpress.org/extend/themes/small-business"><img class="alignnone size-thumbnail wp-image-12268" title="screenshot" src="http://i2.wp.com/weblogtoolscollection.com/wp-content/uploads/2012/11/screenshot.png?resize=150%2C150" alt="" /></a></p>\n<p><a href="http://wordpress.org/extend/themes/small-business"><strong>Small Business</strong></a> is a customizable theme for businesses.</p>\n<img src="http://feeds.feedburner.com/~r/weblogtoolscollection/UXMP/~4/1gd6Fx9aOH8" height="1" width="1" />";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 25 Nov 2012 14:00:05 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"James";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:24;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:65:"WordPress.tv: Tony Matthews: Creating Your Website With WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:28:"http://wordpress.tv/?p=14339";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:82:"http://wordpress.tv/2012/11/24/tony-matthews-creating-your-website-with-wordpress/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:697:"<div id="v-u8LD2qsD-1" class="video-player">\n</div>\n<br />  <a rel="nofollow" href="http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/14339/"><img alt="" border="0" src="http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/14339/" /></a> <img alt="" border="0" src="http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=14339&subd=wptv&ref=&feed=1" width="1" height="1" /><div><a href="http://wordpress.tv/2012/11/24/tony-matthews-creating-your-website-with-wordpress/"><img alt="Tony Matthews &#8211; Creating Your Website With WordPress.m4v" src="http://videos.videopress.com/u8LD2qsD/video-6ce7e0aa2c_scruberthumbnail_0.jpg" width="160" height="120" /></a></div>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 24 Nov 2012 08:48:46 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"WordPress.tv";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:25;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:52:"WordPress.tv: Drew Poland: Freelance Like a Rockstar";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:28:"http://wordpress.tv/?p=14349";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:69:"http://wordpress.tv/2012/11/23/drew-poland-freelance-like-a-rockstar/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:658:"<div id="v-qkvg8Dz8-1" class="video-player">\n</div>\n<br />  <a rel="nofollow" href="http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/14349/"><img alt="" border="0" src="http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/14349/" /></a> <img alt="" border="0" src="http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=14349&subd=wptv&ref=&feed=1" width="1" height="1" /><div><a href="http://wordpress.tv/2012/11/23/drew-poland-freelance-like-a-rockstar/"><img alt="Drew Poland- Freelance Like a Rockstar.m4v" src="http://videos.videopress.com/qkvg8Dz8/video-570bf0f347_std.original.jpg" width="160" height="120" /></a></div>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 23 Nov 2012 16:26:11 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"WordPress.tv";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:26;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:60:"Weblog Tools Collection: WordPress Plugin Releases for 11/23";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:41:"http://weblogtoolscollection.com/?p=12261";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:73:"http://feedproxy.google.com/~r/weblogtoolscollection/UXMP/~3/1HMyz5XYYp4/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:2270:"<h3>New plugins</h3>\n<p><a href="http://wordpress.org/extend/plugins/add-email-signature/"><strong>Add Email Signature</strong></a> adds a configurable signature to every outgoing email that WordPress sends.</p>\n<p><a href="http://wordpress.org/extend/plugins/easy-local-site/"><strong>Easy Local Site</strong></a> aids the development process on a local WordPress site by adding some handy reminders and overriding outgoing emails.</p>\n<p><a href="http://wordpress.org/extend/plugins/force-password-change/"><strong>Force Password Change</strong></a> requires users to change their password on their first login.</p>\n<p><a href="http://wordpress.org/extend/plugins/q2w3-fixed-widget/"><strong>Q2W3 Fixed Widget</strong></a> fixes positioning of the selected widgets when the page is scrolled down.</p>\n<h3>Updated plugins</h3>\n<p><a href="http://bbpress.org/"><strong>bbPress</strong></a> is forum software with a twist from the creators of WordPress, available for the first time ever as a plugin.</p>\n<p><a href="http://wordpress.org/extend/plugins/batcache/"><strong>Batcache</strong></a> uses Memcached to store and serve rendered pages.</p>\n<p><a href="http://wordpress.org/extend/plugins/co-authors-plus/"><strong>Co-Authors Plus</strong></a> allows you to assign multiple bylines to posts, pages, and custom post types via a search-as-you-type input box.</p>\n<p><a href="http://wordpress.org/extend/plugins/custom-javascript-editor/"><strong>Custom Javascript Editor</strong></a> allows you to add custom Javascript to your site from an editor in the WordPress admin.</p>\n<p><a href="http://editflow.org/"><strong>Edit Flow</strong></a> gives you custom statuses, a calendar, editorial comments, and more, all to make it much easier for your team to collaborate within WordPress.</p>\n<p><a href="http://jetpack.me/"><strong>Jetpack</strong></a> allows you to supercharge your WordPress site with powerful features previously only available to WordPress.com users.</p>\n<p><a href="http://wordpress.org/extend/plugins/safe-report-comments/"><strong>Safe Report Comments</strong></a> gives your visitors the ability to report a comment as inappropriate.</p>\n<img src="http://feeds.feedburner.com/~r/weblogtoolscollection/UXMP/~4/1HMyz5XYYp4" height="1" width="1" />";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 23 Nov 2012 14:30:04 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"James";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:27;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:52:"Weblog Tools Collection: WordPress 3.5 RC 1 Released";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:41:"http://weblogtoolscollection.com/?p=12256";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:73:"http://feedproxy.google.com/~r/weblogtoolscollection/UXMP/~3/DjtQ3tV8IsY/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1468:"<p><a href="http://wordpress.org/">WordPress</a> 3.5 RC 1 <a href="http://wordpress.org/news/2012/11/wordpress-3-5-release-candidate/">has been released</a>. Since <a href="http://weblogtoolscollection.com/archives/2012/11/14/wordpress-3-5-beta-3-released/">the third beta</a>, this release candidate has received a bit more polish and is looking closer to a final product.</p>\n<p>The developers are forecasting the final WordPress 3.5 release will be in just two weeks. Though this particular RC is quite polished, it is still is not meant for live sites. However, please do try it on a test installation, especially if you are a plugin or theme developer who would rather not have a panic of bug reports on launch day if your product has any incompatibilities with WordPress 3.5. The Media tools have received a rather extensive overhaul, so you might want to try those out if you frequently rely on them.</p>\n<p>If you run into any bugs, please check the <a href="http://core.trac.wordpress.org/report/6">known</a> and <a href="http://core.trac.wordpress.org/query?status=closed&group=component&milestone=3.5">fixed</a> issues first, <a href="http://codex.wordpress.org/Reporting_Bugs">report them</a> if they have not already been reported, and visit <a href="http://wordpress.org/support/forum/alphabeta">the support forums</a> if you need any help.</p>\n<img src="http://feeds.feedburner.com/~r/weblogtoolscollection/UXMP/~4/DjtQ3tV8IsY" height="1" width="1" />";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 22 Nov 2012 21:45:03 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"James";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:28;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:41:"Dev Blog: WordPress 3.5 Release Candidate";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"http://wordpress.org/news/?p=2479";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:66:"http://wordpress.org/news/2012/11/wordpress-3-5-release-candidate/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1511:"<p>The first release candidate for WordPress 3.5 is now available.</p>\n<p>We hope to ship WordPress 3.5 in <em>two weeks</em>. But to do that, we need your help! If you haven&#8217;t tested 3.5 yet, there&#8217;s no time like the present. (The oft-repeated warning: Please, not on a live site, unless you&#8217;re adventurous.)</p>\n<p><strong>Think you&#8217;ve found a bug?</strong> Please post to the <a href="http://wordpress.org/support/forum/alphabeta/">Alpha/Beta area in the support forums</a>. If any known issues come up, you�ll be able to <a href="http://core.trac.wordpress.org/report/6">find them here</a>. <strong>Developers,</strong> please test your plugins and themes, so that if there is a compatibility issue, we can figure it out before the final release.</p>\n<p>To test WordPress 3.5, try the <a href="http://wordpress.org/extend/plugins/wordpress-beta-tester/">WordPress Beta Tester</a> plugin (you&#8217;ll want &#8220;bleeding edge nightlies&#8221;). Or you can <a href="http://wordpress.org/wordpress-3.5-RC1.zip">download the release candidate here (zip)</a>.</p>\n<p>If you&#8217;d like to know what to <del>break</del> test, visit the About page (<strong><img alt="" src="http://wordpress.org/wp-content/themes/twentyten/images/wordpress.png" /> ? About</strong> in the toolbar) and check out the list of features! Trust me, you want to try out media.</p>\n<p><em>Release candidate</em><br />\n<em>Three point five in two weeks time</em><br />\n<em>Please test all the things</em></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 22 Nov 2012 13:35:09 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"Andrew Nacin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:29;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:20:"Matt: On Microbiomes";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:21:"http://ma.tt/?p=41999";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:36:"http://ma.tt/2012/11/on-microbiomes/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:2865:"<p><img class="alignright  wp-image-42003" alt="" src="http://i0.wp.com/s.ma.tt/files/2012/11/EscherichiaColi_NIAID.jpg?resize=257%2C216" /> Your body has about ten times the number of microbial cells as it does human cells. Collectively this bacteria weighs about three pounds, about the same as your brain. The evolution of our understanding of these bacteria has been evolving rapidly over the past twenty years, and I expect its findings to be the most impactful on our health and wellness in the coming decades.</p>\n<p><a href="http://www.newyorker.com/reporting/2012/10/22/121022fa_fact_specter">The New Yorker has a fantastic article by Michael Specter</a> that starts and ends with our changing perception of <i>heliobacter pylori</i>, linked to gastritis and peptic ulcers, but whose absence in children (it used to be universal, now fewer than 5% of children in the US carry it in their guts) is linked to asthma. It also has consequences for weight:</p>\n<div class="blockquote">\n<blockquote>There is equally convincing evidence that destroying <i>H. pylori</i> could alter metabolism in ways that increase the risk of obesity. Several research groups, including Blaser�s, have found a strong relationship in humans between the bacterium and two stomach hormones, ghrelin and leptin, both of which play central roles in regulating our appetites [...] The more ghrelin you have in your bloodstream, the more likely you are to overeat. Leptin functions in the opposite way, suppressing appetite and increasing energy levels. For people whose stomachs are infected by <i>H. pylori</i>, ghrelin became far less detectable after a meal. For the others, levels of the hormone remained high, and the effects are evident. [...]</p>\n<p>That finding was not a complete surprise. Roughly three-quarters of the antibiotics consumed in the United States are fed to poultry, cows, and pigs, not to treat illness but as dietary supplements to promote faster growth. [...] Until recently, the biochemical reasons for that weight gain, and its unsettling implications or humans, were murky. [...] &#8220;A lot of things are happening at once,&#8221; he said. &#8220;The rise in obesity, celiac disease, asthma, allergy syndromes, and Type 1 diabetes. Bad eating habits are not sufficient to explain the world-wide explosion in obesity.</p></blockquote>\n</div>\n<p>The environment inside our body is as complex and varied as the one outside our body and responds just as unpredictably to wholesale changes to its ecosystem. I&#8217;d recommend reading the entire article, unfortunately it&#8217;s <a href="http://www.newyorker.com/reporting/2012/10/22/121022fa_fact_specter">not available in its entirety</a> on the New Yorker&#8217;s site, however <a href="http://s.ma.tt/files/2012/11/new-yorker-2012-10-22-microbiome.pdf">here&#8217;s a PDF of the entire thing</a>.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 22 Nov 2012 12:25:12 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:30;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:26:"Matt: Living Without Irony";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:21:"http://ma.tt/?p=41997";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:42:"http://ma.tt/2012/11/living-without-irony/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:503:"<div class="blockquote">\n<blockquote>[...] the nostalgia cycles have become so short that we even try to inject the present moment with sentimentality, for example, by using certain digital filters to &#8220;pre-wash&#8221; photos with an aura of historicity. Nostalgia needs time. One cannot accelerate meaningful remembrance.</p></blockquote>\n</div>\n<p>From Christy Wampole&#8217;s <a href="http://opinionator.blogs.nytimes.com/2012/11/17/how-to-live-without-irony/">How to Live Without Irony</a>.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 22 Nov 2012 11:33:12 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:31;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:85:"WordPress.tv: Kathy Drewien: We Admit It! Getting Started with WordPress Can Be Tough";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:28:"http://wordpress.tv/?p=14321";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:101:"http://wordpress.tv/2012/11/20/kathy-drewien-we-admit-it-getting-started-with-wordpress-can-be-tough/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:723:"<div id="v-HoSBW91K-1" class="video-player">\n</div>\n<br />  <a rel="nofollow" href="http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/14321/"><img alt="" border="0" src="http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/14321/" /></a> <img alt="" border="0" src="http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=14321&subd=wptv&ref=&feed=1" width="1" height="1" /><div><a href="http://wordpress.tv/2012/11/20/kathy-drewien-we-admit-it-getting-started-with-wordpress-can-be-tough/"><img alt="Kathy Drewien- We Admit It! Getting Started with WordPress Can Be Tough.m4v" src="http://videos.videopress.com/HoSBW91K/video-b3d9b328fc_std.original.jpg" width="160" height="120" /></a></div>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 21 Nov 2012 05:38:45 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"WordPress.tv";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:32;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:56:"WordPress.tv: Thomas Griffin: Using AJAX in Your Plugins";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:28:"http://wordpress.tv/?p=14318";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:73:"http://wordpress.tv/2012/11/20/thomas-griffin-using-ajax-in-your-plugins/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:665:"<div id="v-ahSd5O62-1" class="video-player">\n</div>\n<br />  <a rel="nofollow" href="http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/14318/"><img alt="" border="0" src="http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/14318/" /></a> <img alt="" border="0" src="http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=14318&subd=wptv&ref=&feed=1" width="1" height="1" /><div><a href="http://wordpress.tv/2012/11/20/thomas-griffin-using-ajax-in-your-plugins/"><img alt="Thomas Griffin-Using AJAX in your plugins.m4v" src="http://videos.videopress.com/ahSd5O62/video-b8024b4da2_std.original.jpg" width="160" height="120" /></a></div>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 21 Nov 2012 04:22:42 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"WordPress.tv";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:33;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:60:"Weblog Tools Collection: WordPress Plugin Releases for 11/19";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:41:"http://weblogtoolscollection.com/?p=12247";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:73:"http://feedproxy.google.com/~r/weblogtoolscollection/UXMP/~3/CjEJuL7Q5X4/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1051:"<h3>New plugins</h3>\n<p><a href="http://wordpress.org/extend/plugins/no-weak-passwords/"><strong>No Weak Passwords</strong></a> forbids the use of any passwords from an included list of the most easily guessable passwords.</p>\n<p><a href="http://wordpress.org/extend/plugins/wp-internal-links-lite/"><strong>WP Internal Links Lite</strong></a> allows you to easily create powerful internal linking structures.</p>\n<h3>Updated plugins</h3>\n<p><a href="http://wordpress.org/extend/plugins/automatic-updater/"><strong>Automatic Updater</strong></a> will automatically download and install plugin, theme, and core updates as soon as they become available.</p>\n<p><a href="http://wordpress.org/extend/plugins/buddypress-media/"><strong>BuddyPress Media</strong></a> allows users to upload and share multimedia files such as pictures, videos, and audio with other members of a <a href="http://buddypress.org">BuddyPress</a> based social network.</p>\n<img src="http://feeds.feedburner.com/~r/weblogtoolscollection/UXMP/~4/CjEJuL7Q5X4" height="1" width="1" />";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 19 Nov 2012 14:45:03 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"James";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:34;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:35:"bbPress: bbPress 2.2 now available!";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:28:"http://bbpress.org/?p=120127";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:58:"http://bbpress.org/blog/2012/11/bbpress-2-2-now-available/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:4438:"<p>Out now is <a href="http://wordpress.org/extend/plugins/bbpress/">bbPress 2.2</a>!</p>\n<p>It comes with <a href="http://bbpress.trac.wordpress.org/milestone/2.2">69</a> individual fixes and enhancements since 2.1, and is a recommended update to any site running bbPress 2.0 or higher.</p>\n<p>bbPress 2.2 is the third major release since becoming a plugin for WordPress back in October, 2011. Also since then, we&#8217;ve continued to work on the things you want the most, like easier integration with your existing WordPress theme, BuddyPress Group Forums, and more comprehensive User Roles. We think bbPress 2.2 is the best release yet, and we really hope you&#8217;ll think so to.</p>\n<p>Here are some of the juicy details about bbPress 2.2:</p>\n<ul>\n<li>Added What&#8217;s New and Credits pages</li>\n<li>WordPress 3.5 and BuddyPress 1.7 ready</li>\n<li>Improved user roles and capabilities</li>\n<li>Improved theme compatibility</li>\n<li>Improved BuddyPress Group Forums integration</li>\n<li>Improved forums convertion tool</li>\n<li>Improved forums tools and settings</li>\n<li>Improved multisite support</li>\n<li>Numerous bug fixes and smaller enhancements</li>\n</ul>\n<p>Many thanks to the following bee-keepers for making bbPress 2.2 awesome: <a href="http://profiles.wordpress.org/alexvorn2">alexvorn2</a>, <a href="http://profiles.wordpress.org/anointed">anointed</a>, <a href="http://profiles.wordpress.org/boonebgorges">boonebgorges</a>, <a href="http://profiles.wordpress.org/chexee">chexee</a>, <a href="http://profiles.wordpress.org/cnorris23">cnorris23</a>, <a href="http://profiles.wordpress.org/DanielJuhl">DanielJuhl</a>, <a href="http://profiles.wordpress.org/DanielJuhl">daveshine</a>, <a href="http://profiles.wordpress.org/dimadin">dimadin</a>, <a href="http://profiles.wordpress.org/DJPaul">DJPaul</a>, <a href="http://profiles.wordpress.org/duck_">duck_</a>, <a href="http://profiles.wordpress.org/gawain">gawain</a>, <a href="http://profiles.wordpress.org/iamzippy">iamzippy</a>, <a href="http://profiles.wordpress.org/isaacchapman">isaacchapman</a>, <a href="http://profiles.wordpress.org/jane">jane</a>, <a href="http://profiles.wordpress.org/jkudish">jkudish</a>, <a href="http://profiles.wordpress.org/mamaduka">mamaduka</a>, <a href="http://profiles.wordpress.org/mercime">mercime</a>, <a href="http://profiles.wordpress.org/mesayre">mesayre</a>, <a href="http://profiles.wordpress.org/MZAWeb">MZAWeb</a>, <a href="http://profiles.wordpress.org/netweb">netweb</a>, <a href="http://profiles.wordpress.org/nexia">nexia</a>, <a href="http://profiles.wordpress.org/Omicron7">Omicron7</a>, <a href="http://profiles.wordpress.org/otto42">otto42</a>, <a href="http://profiles.wordpress.org/pavelevap">pavelevap</a>, <a href="http://profiles.wordpress.org/plescheff">plescheff</a>, <a href="http://profiles.wordpress.org/scribu">scribu</a>, <a href="http://profiles.wordpress.org/sorich87">sorich87</a>, <a href="http://profiles.wordpress.org/SteveAtty">SteveAtty</a>, <a href="http://profiles.wordpress.org/tmoorewp">tmoorewp</a>, <a href="http://profiles.wordpress.org/tott">tott</a>, <a href="http://profiles.wordpress.org/tungdo">tungdo</a>, <a href="http://profiles.wordpress.org/vibol">vibol</a>, <a href="http://profiles.wordpress.org/wonderboymusic">wonderboymusic</a>, <a href="http://profiles.wordpress.org/westi">westi</a>, <a href="http://profiles.wordpress.org/xiosen">xiosen</a></p>\n<p>My personal thanks go out to the following individuals for staying dedicated during the 2.2 release cycle, helping spread the word, and keeping the documentation up to date:</p>\n<h4>Contributing Developers</h4>\n<ul id="wp-people-group-contributing-developers">\n<li id="wp-person-jmdodd"><a href="http://profiles.wordpress.org/jmdodd">Jennifer M. Dodd</a></li>\n<li id="wp-person-jaredatch"><a href="http://profiles.wordpress.org/jaredatch">Jared Atchison</a></li>\n<li><a href="http://profiles.wordpress.org/mordauk">Pippin Williamson</a></li>\n</ul>\n<h4>Codex Rockstars</h4>\n<ul id="wp-people-group-codex-rockstars">\n<li id="wp-person-masonjames"><a href="http://profiles.wordpress.org/masonjames">Mason James</a></li>\n<li id="wp-person-wordsforwp"><a href="http://profiles.wordpress.org/wordsforwp">Siobhan McKeown</a></li>\n<li id="wp-person-JarretC"><a href="http://profiles.wordpress.org/JarretC">Jarret Cade</a></li>\n</ul>\n<p><a href="http://wordpress.org/extend/plugins/bbpress/">Go download bbPress 2.2!</a></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 19 Nov 2012 08:05:01 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:17:"John James Jacoby";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:35;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:59:"Weblog Tools Collection: WordPress Theme Releases for 11/17";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:41:"http://weblogtoolscollection.com/?p=12241";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:73:"http://feedproxy.google.com/~r/weblogtoolscollection/UXMP/~3/e6wc7rF_VCo/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1623:"<p><img class="alignnone size-full wp-image-12242" title="cogitate" src="http://i2.wp.com/weblogtoolscollection.com/wp-content/uploads/2012/11/cogitate.jpg?resize=150%2C100" alt="" /></p>\n<p><a href="http://evansolomon.me/notes/cogitate-simple-readable-wordpress-theme/"><strong>Cogitate</strong></a> is a more minimalist and readable <a href="http://wordpress.org/extend/themes/twentytwelve">Twenty Twelve</a> child theme.</p>\n<p><img class="alignnone size-full wp-image-12243" title="leaf" src="http://i2.wp.com/weblogtoolscollection.com/wp-content/uploads/2012/11/leaf.jpg?resize=150%2C113" alt="" /></p>\n<p><a href="http://wordpress.org/extend/themes/leaf"><strong>Leaf</strong></a> is a stylish and customizable theme.</p>\n<p><img class="alignnone size-full wp-image-12245" title="mosaic" src="http://i0.wp.com/weblogtoolscollection.com/wp-content/uploads/2012/11/mosaic.jpg?resize=150%2C113" alt="" /></p>\n<p><a href="http://wordpress.org/extend/themes/mosaic"><strong>Mosaic</strong></a> is a clean, lightweight and fully responsive theme.</p>\n<p><img class="alignnone size-full wp-image-12244" title="twentypluslite" src="http://i1.wp.com/weblogtoolscollection.com/wp-content/uploads/2012/11/twentypluslite.jpg?resize=150%2C113" alt="" /></p>\n<p><a href="http://zeaks.org/general/twenty-plus-lite-twenty-twelve-child-theme/"><strong>Twenty Plus Lite</strong></a> is a child theme for <a href="http://wordpress.org/extend/themes/twentytwelve">Twenty Twelve</a> with several features, layouts and schemes.</p>\n<img src="http://feeds.feedburner.com/~r/weblogtoolscollection/UXMP/~4/e6wc7rF_VCo" height="1" width="1" />";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 17 Nov 2012 15:00:04 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"James";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:36;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:30:"Matt: Bitcoin on WordPress.com";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:21:"http://ma.tt/?p=41995";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:46:"http://ma.tt/2012/11/bitcoin-on-wordpress-com/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:903:"<p><a href="http://en.blog.wordpress.com/2012/11/15/pay-another-way-bitcoin/">WordPress.com now accepts payments via Bitcoin</a>, possibly the largest internet service yet to adopt it. I find Bitcoin intrinsically interesting <a href="http://www.newyorker.com/reporting/2011/10/10/111010fa_fact_davis">as a crypto-currency</a>, but it also might open up our premium services to folks who couldn&#8217;t use them before. It&#8217;s been fun to watch the store engine of WP.com evolve behind the scenes. In other WordPress.com news, there are now verticals for <a href="http://en.blog.wordpress.com/2012/11/14/wordpress-for-cities/">municipalities</a> and <a href="http://en.blog.wordpress.com/2012/10/30/make-your-bands-site-sing/">bands</a>, and we compiled <a href="http://en.blog.wordpress.com/2012/11/05/the-wordpress-bestseller-list/">an incomplete list of best-selling authors on WordPress</a>.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 16 Nov 2012 07:45:48 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:37;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:60:"Weblog Tools Collection: WordPress Plugin Releases for 11/15";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:41:"http://weblogtoolscollection.com/?p=12235";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:73:"http://feedproxy.google.com/~r/weblogtoolscollection/UXMP/~3/fJJyQSGXRGU/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1315:"<h3>New plugins</h3>\n<p><a href="http://wordpress.org/extend/plugins/auto-upload-images/"><strong>Auto Upload Images</strong></a> automatically uploads external images within posts to your WordPress site&#8217;s Media library.</p>\n<p><a href="http://wordpress.org/extend/plugins/safe-report-comments/"><strong>Safe Report Comments</strong></a> gives your visitors the ability to report a comment as inappropriate.</p>\n<h3>Updated plugins</h3>\n<p><a href="http://wordpress.org/extend/plugins/co-authors-plus/"><strong>Co-Authors Plus</strong></a> allows you to assign multiple bylines to posts, pages, and custom post types via a search-as-you-type input box.</p>\n<p><a href="http://wordpress.org/extend/plugins/facebook/"><strong>Facebook</strong></a> makes your site deeply social by integrating functionality from Facebook.</p>\n<p><a href="http://slingpic.com/get/index.html"><strong>Slingpic</strong></a> is an image sharing tool that allows your users to share images from your site quickly and easily.</p>\n<p><a href="http://wordpress.org/extend/plugins/wp-email-login/"><strong>WP Email Login</strong></a> allows you to use your email address instead of a username to log into your WordPress site.</p>\n<img src="http://feeds.feedburner.com/~r/weblogtoolscollection/UXMP/~4/fJJyQSGXRGU" height="1" width="1" />";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 15 Nov 2012 14:45:07 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"James";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:38;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:31:"Alex King: Take RAMP for a Spin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:28:"http://alexking.org/?p=14450";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:52:"http://alexking.org/blog/2012/11/14/ramp-online-demo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:2127:"<p>We recently added the ability to take RAMP for a test drive before you buy. On the RAMP page, click that &#8220;Demo&#8221; button to sign up and we&#8217;ll set up both a staging and production WordPress site for you &#8211; with RAMP installed and configured on both sites. You can log in, create and upload content, etc. Use the Quick Send feature to send a single change over immediately or make a bunch of change, add them to a batch, and send them all at once.</p>\n<p><a href="http://crowdfavorite.com/wordpress/ramp/"><img src="http://alexking.org/wp-content/uploads/2012/11/Screen-Shot-2012-11-13-at-3.11.30-PM-510x345.png" alt="" title="RAMP demo" width="480" height="324" class="alignnone size-medium-img wp-image-15141" /></a></p>\n<p><a href="http://crowdfavorite.com/wordpress/ramp/">RAMP</a> is a commercial GPL WordPress plugin for migrating content between your staging server and your production server. Maybe you need to create a few new pages, update a few others, stage it for internal review and critique and then push it all live at once. Maybe you need to tweak a few existing pages and want to make sure they look right before you make the changes on your live site. This is the job RAMP does. It&#8217;s a pretty hard job and RAMP does it in an elegant manner.</p>\n<p>To answer a question I get with some regularity, I see RAMP as primarily a business tool for website maintenance and updates rather than a developer tool for moving a side from a local development environment to a production server.<sup id="fnref:1"><a href="http://alexking.org/blog/topic/wordpress/feed#fn:1" rel="footnote">1</a></sup> I <a href="http://shoptalkshow.com/episodes/033-with-alex-king/">talk about this in some depth</a> on the ShopTalk podcast.</p>\n<p><a href="http://crowdfavorite.com/wordpress/ramp/">Give it a try</a> and see how it works!</p>\n<div class="footnotes">\n<hr />\n<ol>\n<li id="fn:1">\nThere isn&#8217;t a technical limit here, it&#8217;s just the workflow I believe makes the most sense.&#160;<a href="http://alexking.org/blog/topic/wordpress/feed#fnref:1" rev="footnote">&#8617;</a>\n</li>\n</ol>\n</div>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 14 Nov 2012 22:31:41 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Alex";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:39;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:54:"Weblog Tools Collection: WordPress 3.5 Beta 3 Released";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:41:"http://weblogtoolscollection.com/?p=12228";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:73:"http://feedproxy.google.com/~r/weblogtoolscollection/UXMP/~3/cJ4VgmXEFQQ/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1290:"<p><a href="http://wordpress.org/">WordPress</a> 3.5 Beta 3 <a href="http://wordpress.org/news/2012/11/wordpress-3-5-beta-3/">has been released</a>. Since <a href="http://weblogtoolscollection.com/archives/2012/10/13/wordpress-3-5-beta-2-released/">the second beta</a>, this beta has added <a href="http://core.trac.wordpress.org/log/trunk?action=stop_on_copy&mode=stop_on_copy&rev=22557&stop_rev=22224&limit=400">more than 300 changes</a>, including a new Add Media dialog.</p>\n<p>The developers are forecasting the final WordPress 3.5 release to be in a few short weeks. This particular beta is still is not meant for live sites, but please do try it on a test installation, especially if you are a plugin or theme developer. If you run into any bugs, please check the <a href="http://core.trac.wordpress.org/report/5">known</a> and <a href="http://core.trac.wordpress.org/query?status=closed&group=component&milestone=3.5">fixed</a> issues first, <a href="http://codex.wordpress.org/Reporting_Bugs">report them</a> if they have not already been reported or fixed, and visit <a href="http://wordpress.org/support/forum/alphabeta">the support forums</a> if you need any help.</p>\n<img src="http://feeds.feedburner.com/~r/weblogtoolscollection/UXMP/~4/cJ4VgmXEFQQ" height="1" width="1" />";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 14 Nov 2012 15:15:04 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"James";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:40;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:13:"Matt: WP Maze";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:21:"http://ma.tt/?p=41989";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:29:"http://ma.tt/2012/11/wp-maze/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:132:"<p>Erick Jeckert has made a <a href="http://ericjeckert.com/mazes/matt-mullenweg/">maze with my face and the WordPress logo</a>.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 14 Nov 2012 14:54:09 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:41;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:42:"WordPress.tv: Build Conference: Developers";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:28:"http://wordpress.tv/?p=14284";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:37:"http://wordpress.tv/2012/11/14/build/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:613:"<div id="v-vnvvUnml-1" class="video-player">\n</div>\n<br />  <a rel="nofollow" href="http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/14284/"><img alt="" border="0" src="http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/14284/" /></a> <img alt="" border="0" src="http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=14284&subd=wptv&ref=&feed=1" width="1" height="1" /><div><a href="http://wordpress.tv/2012/11/14/build/"><img alt="Build Conference: Developers" src="http://videos.videopress.com/vnvvUnml/build2012dev_high_std.original.jpg" width="160" height="120" /></a></div>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 14 Nov 2012 09:47:13 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"Michael Pick";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:42;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:27:"Alex King: Pressnomics 2012";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:28:"http://alexking.org/?p=15112";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:52:"http://alexking.org/blog/2012/11/13/pressnomics-2012";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:2734:"<p>The inaugural <a href="http://pressnomics.com">Pressnomics</a> conference was a definitive success. It was a conference dedicated to the WordCamp hallway conversations I enjoy having with 5-10 people at each (non-San Francisco) WordCamp. A &#8220;birds of a feather&#8221; conference for those of us who make our living in the WordPress economy.</p>\n<p>I was honored to be asked to speak, and I gave a presentation titled &#8220;Great Expectations&#8221;. I believe using expectations as a tool for working collaboratively with clients, customers and colleagues is great way to find success. I&#8217;ve been taking notes on the topic for over a year, and enjoyed the opportunity to present them.</p>\n<p>This was a very different presentation than I normally give. I&#8217;m typically walking through code and other technical issues, systematically showing how to do things better in WordPress development. This was a much less concrete topic.</p>\n<p>The free-form presentation style I used resulted in each section running longer than it had in my rehearsal. I wasn&#8217;t prepared to cut sections on the fly, and regret some of the choices I made there (I wish I&#8217;d talked about expectations with free and commercial WordPress plugins). Next time I&#8217;ll be better prepared and will have planned in advance what can be cut if time runs short.</p>\n<p>I re-worked the presentation three different times, ultimately choosing to tell a series of stories with each illustrating a core element or lesson to consider. I got a good deal of validation about the concepts from other folks at the event.</p>\n<p>The slides aren&#8217;t that helpful without the commentary, but I&#8217;m including them here for the sake of completeness. What may be more interesting would be to post write-ups of the content here as a series (and maybe compile it into an ebook). I may well do this.</p>\n<p> </p>\n<p><a href="http://www.slideshare.net/alexkingorg/great-expectations-15140151" title="Great expectations" target="_blank">View on SlideShare</a></p>\n<p>Check out <a href="http://www.aztechbeat.com/2012/11/pressnomics-2012-day-1/">Zachary Burruel&#8217;s recap of day 1</a>, including some notes from my presentation.</p>\n<hr />\n<p>I think many of us at the event were pretty well cooked by the end. There was a ton of great content, which sparked a lot of great debate and <a href="http://pressnomics.com/2012/11/cory-miller-asks-the-question-we-all-should-help-answer/">ideas for follow-through</a>.</p>\n<p>Kudos to <a href="http://twitter.com/strebel">Joshua</a> and <a href="http://twitter.com/bizgirl">Sally</a> of <a href="http://page.ly">Page.ly</a> for putting on a terrific event. I look forward to attending again next year.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 13 Nov 2012 22:01:57 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Alex";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:43;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:59:"Weblog Tools Collection: WordPress Theme Releases for 11/13";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:41:"http://weblogtoolscollection.com/?p=12223";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:73:"http://feedproxy.google.com/~r/weblogtoolscollection/UXMP/~3/cPmA6AsfaHw/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1187:"<p><img class="alignnone size-full wp-image-12224" title="asteroid" src="http://i0.wp.com/weblogtoolscollection.com/wp-content/uploads/2012/11/asteroid.jpg?resize=150%2C113" alt="" /></p>\n<p><a href="http://wordpress.org/extend/themes/asteroid"><strong>Asteroid</strong></a> is a simple, clean, and responsive theme.</p>\n<p><img class="alignnone size-full wp-image-12225" title="celestial" src="http://i2.wp.com/weblogtoolscollection.com/wp-content/uploads/2012/11/celestial.jpg?resize=150%2C112" alt="" /></p>\n<p><a href="http://emptynestthemes.com/2012/11/12/celestial-wordpress-website-theme/"><strong>Celestial</strong></a> is a responsive, mystical, ethereal theme with a beautiful misty image of a silver lit full moon against the night sky.</p>\n<p><img class="alignnone size-full wp-image-12226" title="localbusiness" src="http://i1.wp.com/weblogtoolscollection.com/wp-content/uploads/2012/11/localbusiness.jpg?resize=150%2C113" alt="" /></p>\n<p><a href="http://wordpress.org/extend/themes/local-business"><strong>Local Business</strong></a> is a clean business theme.</p>\n<img src="http://feeds.feedburner.com/~r/weblogtoolscollection/UXMP/~4/cPmA6AsfaHw" height="1" width="1" />";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 13 Nov 2012 15:00:04 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"James";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:44;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:60:"WordPress.tv: Levi Neuland: Making Social Media I/O Painless";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:28:"http://wordpress.tv/?p=14173";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:76:"http://wordpress.tv/2012/11/13/levi-neuland-making-social-media-io-painless/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:679:"<div id="v-0AqWFOP6-1" class="video-player">\n</div>\n<br />  <a rel="nofollow" href="http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/14173/"><img alt="" border="0" src="http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/14173/" /></a> <img alt="" border="0" src="http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=14173&subd=wptv&ref=&feed=1" width="1" height="1" /><div><a href="http://wordpress.tv/2012/11/13/levi-neuland-making-social-media-io-painless/"><img alt="Levi Neuland &#8211; Making Social Media IO Painless.mp4" src="http://videos.videopress.com/0AqWFOP6/video-13c948ed95_std.original.jpg" width="160" height="120" /></a></div>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 13 Nov 2012 13:15:59 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"WordPress.tv";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:45;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:30:"Dev Blog: WordPress 3.5 Beta 3";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"http://wordpress.org/news/?p=2467";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:55:"http://wordpress.org/news/2012/11/wordpress-3-5-beta-3/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:2626:"<p>The third beta release of WordPress 3.5 is now available for download and testing.</p>\n<p><strong>Hey, developers!</strong> We expect to WordPress 3.5 to be ready in just a few short weeks. <em>Please, please</em> test your plugins and themes against beta 3. Media management has been rewritten, and we&#8217;ve taken great pains to ensure most plugins will work the same as before, but we&#8217;re not perfect. We would like to hear about any incompatibilities we&#8217;ve caused so we can work with you to address them <em>before</em> release, rather than after. I think you&#8217;ll agree it&#8217;s much better that way. <img src="http://wordpress.org/news/wp-includes/images/smilies/icon_smile.gif" alt=":-)" class="wp-smiley" /> </p>\n<p>To test WordPress 3.5, try the <a href="http://wordpress.org/extend/plugins/wordpress-beta-tester/">WordPress Beta Tester</a> plugin (you�ll want �bleeding edge nightlies�). Or you can <a href="http://wordpress.org/wordpress-3.5-beta3.zip">download the beta here</a> (zip). For more on 3.5, <a title="WordPress 3.5 Beta 1" href="http://wordpress.org/news/2012/09/wordpress-3-5-beta-1/">check out the extensive Beta 1 blog post</a>, which covers what�s new in version 3.5 and how you can help. We made <a href="http://core.trac.wordpress.org/log/trunk?action=stop_on_copy&mode=stop_on_copy&rev=22557&stop_rev=22224&limit=400">more than 300 changes</a> since <a href="http://wordpress.org/news/2012/10/wordpress-3-5-beta-2/">beta 2</a>. <span>At this point, the Add Media dialog is complete, and we&#8217;re now just working on fixing up inserting images into the editor. We&#8217;ve also u</span>pdated to jQuery UI 1.9.1, SimplePie 1.3.1, and TinyMCE 3.5.7.</p>\n<p>The usual warnings apply: We can see the light at the end of the tunnel, but this is software still in development, so we don�t recommend that you run it on a production site. Set up a test site to play with the new version.</p>\n<p>As always, if you think you�ve found a bug, you can post to the <a href="http://wordpress.org/support/forum/alphabeta">Alpha/Beta area</a> in the support forums. Or, if you�re comfortable writing a reproducible bug report, <a href="http://core.trac.wordpress.org/">file one on the WordPress Trac</a>. There, you can also find <a href="http://core.trac.wordpress.org/report/5">a list of known bugs</a> and <a href="http://core.trac.wordpress.org/query?status=closed&group=component&milestone=3.5">everything we�ve fixed</a> so far.</p>\n<p><em>Beta three is out</em><br />\n<em>Soon, a release candidate</em><br />\n<em>Three point five is near</em></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 13 Nov 2012 04:26:23 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"Andrew Nacin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:46;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:61:"WordPress.tv: Dennis Gaebel: Building for the Theme Directory";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:28:"http://wordpress.tv/?p=14167";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:78:"http://wordpress.tv/2012/11/12/dennis-gaebel-building-for-the-theme-directory/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:683:"<div id="v-GWTjA0ls-1" class="video-player">\n</div>\n<br />  <a rel="nofollow" href="http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/14167/"><img alt="" border="0" src="http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/14167/" /></a> <img alt="" border="0" src="http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=14167&subd=wptv&ref=&feed=1" width="1" height="1" /><div><a href="http://wordpress.tv/2012/11/12/dennis-gaebel-building-for-the-theme-directory/"><img alt="Dennis Gaebel &#8211; Building for the Theme Directory.mp4" src="http://videos.videopress.com/GWTjA0ls/video-05620dd2d3_std.original.jpg" width="160" height="120" /></a></div>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 13 Nov 2012 03:15:11 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"WordPress.tv";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:47;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:29:"Matt: Rolling Jubilee of Debt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:21:"http://ma.tt/?p=41987";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:45:"http://ma.tt/2012/11/rolling-jubilee-of-debt/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:322:"<p><a href="http://rollingjubilee.org/">Rolling Jubilee</a> is a non-profit that takes donations to buy distressed debt for pennies on the dollar, and then abolishes it. Donate $100 and they can take $2,000 off someone&#8217;s back. Seems like an amazing random act of kindness, you&#8217;ll never know who you helped.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 12 Nov 2012 23:03:13 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:48;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:46:"WordPress.tv: Adrian Roselli: Content Strategy";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:28:"http://wordpress.tv/?p=14163";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:63:"http://wordpress.tv/2012/11/12/adrian-roselli-content-strategy/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:654:"<div id="v-B5lbCkdx-1" class="video-player">\n</div>\n<br />  <a rel="nofollow" href="http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/14163/"><img alt="" border="0" src="http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/14163/" /></a> <img alt="" border="0" src="http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=14163&subd=wptv&ref=&feed=1" width="1" height="1" /><div><a href="http://wordpress.tv/2012/11/12/adrian-roselli-content-strategy/"><img alt="Adrian Rosellli &#8211; Content Strategy.mp4" src="http://videos.videopress.com/B5lbCkdx/video-6d54b476b8_std.original.jpg" width="160" height="120" /></a></div>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 12 Nov 2012 19:14:11 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"WordPress.tv";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:49;a:6:{s:4:"data";s:13:"\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:76:"WordPress.tv: Lachan MacPherson: There�s More than One Way to Skin a Theme";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:28:"http://wordpress.tv/?p=14182";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:90:"http://wordpress.tv/2012/11/11/lachan-macpherson-theres-more-than-one-way-to-skin-a-theme/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:659:"<div id="v-GM0zpq7h-1" class="video-player">\n</div>\n<br />  <a rel="nofollow" href="http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/14182/"><img alt="" border="0" src="http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/14182/" /></a> <img alt="" border="0" src="http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=14182&subd=wptv&ref=&feed=1" width="1" height="1" /><div><a href="http://wordpress.tv/2012/11/11/lachan-macpherson-theres-more-than-one-way-to-skin-a-theme/"><img alt="Lachlan-Macpherson.mov" src="http://videos.videopress.com/GM0zpq7h/video-913bd06f4c_std.original.jpg" width="160" height="120" /></a></div>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 12 Nov 2012 03:11:51 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"WordPress.tv";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";a:11:{s:3:"via";s:11:"1.1 ARM-005";s:10:"connection";s:5:"close";s:16:"proxy-connection";s:5:"close";s:14:"content-length";s:5:"92435";s:4:"date";s:29:"Mon, 03 Dec 2012 04:52:49 GMT";s:12:"content-type";s:8:"text/xml";s:6:"server";s:5:"nginx";s:4:"vary";s:15:"Accept-Encoding";s:13:"last-modified";s:29:"Mon, 03 Dec 2012 04:45:11 GMT";s:4:"x-nc";s:11:"HIT luv 139";s:13:"accept-ranges";s:5:"bytes";}s:5:"build";s:14:"20090627192103";}', 'no');
INSERT INTO `goStores_Vista_wp_options` (`option_id`, `blog_id`, `option_name`, `option_value`, `autoload`) VALUES
(297, 0, '_transient_timeout_plugin_slugs', '1354596774', 'no'),
(298, 0, '_transient_plugin_slugs', 'a:2:{i:0;s:58:"add_custom_link_to_wordpress_admin_bar/add_custom_link.php";i:1;s:9:"hello.php";}', 'no'),
(155, 0, 'recently_activated', 'a:0:{}', 'yes'),
(159, 0, 'category_children', 'a:0:{}', 'yes'),
(156, 0, 'add_custom_link_db_version', '1.0', 'yes'),
(293, 0, '_transient_timeout_feed_1a5f760f2e2b48827d4974a60857e7c2', '1354553574', 'no'),
(294, 0, '_transient_feed_1a5f760f2e2b48827d4974a60857e7c2', 'a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n	\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:72:"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:43:"WordPress Plugins � View: Recently Updated";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://wordpress.org/extend/plugins/browse/updated/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:43:"WordPress Plugins � View: Recently Updated";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"en-US";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 03 Dec 2012 04:22:01 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:25:"http://bbpress.org/?v=1.1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"item";a:15:{i:0;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:12:"FAQs Manager";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:60:"http://wordpress.org/extend/plugins/faqs-manager/#post-40772";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 20 Jul 2012 05:03:04 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"40772@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:54:"Managing Frequently Asked Questions was Never So Easy.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:8:"IndiaNIC";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:11:"Testimonial";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:68:"http://wordpress.org/extend/plugins/indianic-testimonial/#post-39546";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 22 Jun 2012 06:06:59 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"39546@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:35:"Add testimonial to your blog posts.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"laki_patel";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:15:"WP Easy Gallery";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:63:"http://wordpress.org/extend/plugins/wp-easy-gallery/#post-31481";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 25 Oct 2011 01:23:18 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"31481@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:59:"WP Easy Gallery is an easy to use WordPress Gallery Plugin.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:9:"hahncgdev";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:13:"Post Template";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:64:"http://wordpress.org/extend/plugins/wp-post-template/#post-46397";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 30 Nov 2012 07:21:28 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"46397@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:50:"Get the Beauty of Your Webpages  in Your Posts Too";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:8:"IndiaNIC";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:8:"Isotopes";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:56:"http://wordpress.org/extend/plugins/isotopes/#post-46415";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 30 Nov 2012 19:24:27 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"46415@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:71:"This plugin give you a template tag that uses isotope js functionality.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"johnstonphilip";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:7:"Cockpit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:55:"http://wordpress.org/extend/plugins/cockpit/#post-45743";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 14 Nov 2012 08:42:54 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"45743@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:109:"Track your WordPress site&#039;s traffic, and automatically posts to Twitter when you publish a post or page.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:11:"justsystems";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:13:"hpb Dashboard";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:55:"http://wordpress.org/extend/plugins/hpbtool/#post-43953";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 03 Oct 2012 23:57:25 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"43953@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:88:"&#34;hpb Dashboard&#34; plug-in is the data importer for &#34;Home Page Builder 17&#34;.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:11:"justsystems";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:24:"8tracks Shortcode Plugin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:65:"http://wordpress.org/extend/plugins/8tracks-shortcode/#post-30019";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 10 Sep 2011 03:20:11 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"30019@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:62:"Allows you to embed mixtapes from 8tracks.com via a shortcode.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"songsthatsaved";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:22:"012 Ps Multi Languages";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:70:"http://wordpress.org/extend/plugins/012-ps-multi-languages/#post-39010";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 12 Jun 2012 02:59:27 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"39010@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:30:"wordpress multilingualization.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:8:"Wang Bin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:15:"Post PDF Export";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:63:"http://wordpress.org/extend/plugins/post-pdf-export/#post-46411";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 30 Nov 2012 16:00:28 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"46411@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:72:"PDF plugin that gives instant post download( PDF format ) functionality.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:15:"Cristopher Dino";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:10;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:13:"wpStoreCart 3";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:59:"http://wordpress.org/extend/plugins/wpstorecart/#post-20952";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 16 Sep 2010 17:09:13 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"20952@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:121:"Ajax enhanced Wordpress ecommerce.  Easy to use &#38; fully customizable, it&#039;s the store front of the future; today.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:9:"jquindlen";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:11;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:25:"Facebook AWD SEO Comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:73:"http://wordpress.org/extend/plugins/facebook-awd-seo-comments/#post-35902";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 19 Mar 2012 02:46:53 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"35902@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:74:"This plugin merge Facebook Comments with native Wordpress Comments System.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:8:"AHWEBDEV";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:12;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:15:"Social Contests";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:73:"http://wordpress.org/extend/plugins/wishpond-social-campaigns/#post-40319";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 10 Jul 2012 01:53:05 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"40319@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:150:"Use this plugin to run promotional campaigns on your WordPress site that spread quickly on Facebook and Twitter. Promotions allows you to run contests";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:6:"alitaj";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:13;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:22:"AdSense Privacy Policy";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:70:"http://wordpress.org/extend/plugins/adsense-privacy-policy/#post-45778";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 15 Nov 2012 12:09:11 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:42:"45778@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:22:"AdSense Privacy Policy";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:9:"hotvanrod";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:14;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:32:"Yet Another Related Posts Plugin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:79:"http://wordpress.org/extend/plugins/yet-another-related-posts-plugin/#post-2769";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 02 Jan 2008 13:05:03 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:41:"2769@http://wordpress.org/extend/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:122:"Display a list of related entries on your site and feeds based on a unique algorithm. Now with thumbnail support built-in!";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:35:"mitcho (Michael Yoshitaka Erlewine)";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:4:"href";s:52:"http://wordpress.org/extend/plugins/rss/view/updated";s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";a:12:{s:3:"via";s:11:"1.1 ARM-005";s:10:"connection";s:5:"close";s:16:"proxy-connection";s:5:"close";s:7:"expires";s:29:"Mon, 03 Dec 2012 04:57:01 GMT";s:4:"date";s:29:"Mon, 03 Dec 2012 04:52:54 GMT";s:12:"content-type";s:23:"text/xml; charset=UTF-8";s:6:"server";s:5:"nginx";s:4:"vary";s:15:"Accept-Encoding";s:13:"cache-control";s:0:"";s:6:"pragma";s:0:"";s:13:"last-modified";s:31:"Mon, 03 Dec 2012 04:22:01 +0000";s:4:"x-nc";s:11:"HIT luv 138";}s:5:"build";s:14:"20090627192103";}', 'no'),
(265, 0, '_site_transient_timeout_browser_0535bb7737bc5fa6da26da0deb17ef74', '1355115166', 'yes'),
(266, 0, '_site_transient_browser_0535bb7737bc5fa6da26da0deb17ef74', 'a:9:{s:8:"platform";s:7:"Windows";s:4:"name";s:7:"Firefox";s:7:"version";s:4:"17.0";s:10:"update_url";s:23:"http://www.firefox.com/";s:7:"img_src";s:50:"http://s.wordpress.org/images/browsers/firefox.png";s:11:"img_src_ssl";s:49:"https://wordpress.org/images/browsers/firefox.png";s:15:"current_version";s:2:"16";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'),
(287, 0, '_transient_timeout_feed_mod_a5420c83891a9c88ad2a4f04584a5efc', '1354553571', 'no'),
(288, 0, '_transient_feed_mod_a5420c83891a9c88ad2a4f04584a5efc', '1354510371', 'no');

INSERT INTO `goStores_Vista_wp_postmeta` (`meta_id`, `post_id`, `meta_key`, `meta_value`) VALUES
(1, 2, '_wp_page_template', 'default');
INSERT INTO `goStores_Vista_wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(1, 1, '2012-11-08 06:27:09', '2012-11-08 06:27:09', 'Welcome to WordPress. This is your first post. Edit or delete it, then start blogging!', 'Hello world!', '', 'publish', 'open', 'open', '', 'hello-world', '', '', '2012-11-08 06:27:09', '2012-11-08 06:27:09', '', 0, 'http://localhost/vistacart/app/webroot/blog/?p=1', 0, 'post', '', 1),
(2, 1, '2012-11-08 06:27:09', '2012-11-08 06:27:09', 'This is an example page. It''s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:\n\n<blockquote>Hi there! I''m a bike messenger by day, aspiring actor by night, and this is my blog. I live in Los Angeles, have a great dog named Jack, and I like pi&#241;a coladas. (And gettin'' caught in the rain.)</blockquote>\n\n...or something like this:\n\n<blockquote>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickies to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</blockquote>\n\nAs a new WordPress user, you should go to <a href="http://localhost/vistacart/app/webroot/blog/wp-admin/">your dashboard</a> to delete this page and create new pages for your content. Have fun!', 'Sample Page', '', 'publish', 'open', 'open', '', 'sample-page', '', '', '2012-11-08 06:27:09', '2012-11-08 06:27:09', '', 0, 'http://localhost/vistacart/app/webroot/blog/?page_id=2', 0, 'page', '', 0),
(3, 1, '2012-11-08 06:27:19', '0000-00-00 00:00:00', '', 'Auto Draft', '', 'auto-draft', 'open', 'open', '', '', '', '', '2012-11-08 06:27:19', '0000-00-00 00:00:00', '', 0, 'http://localhost/vistacart/app/webroot/blog/?p=3', 0, 'post', '', 0);
INSERT INTO `goStores_Vista_wp_terms` (`term_id`, `name`, `slug`, `term_group`) VALUES
(1, 'Uncategorized', 'uncategorized', 0),
(2, 'Blogroll', 'blogroll', 0);
INSERT INTO `goStores_Vista_wp_term_relationships` (`object_id`, `term_taxonomy_id`, `term_order`) VALUES
(1, 2, 0),
(2, 2, 0),
(3, 2, 0),
(4, 2, 0),
(5, 2, 0),
(6, 2, 0),
(7, 2, 0),
(1, 1, 0);
INSERT INTO `goStores_Vista_wp_term_taxonomy` (`term_taxonomy_id`, `term_id`, `taxonomy`, `description`, `parent`, `count`) VALUES
(1, 1, 'category', '', 0, 1),
(2, 2, 'link_category', '', 0, 7);

INSERT INTO `goStores_Vista_wp_usermeta` (`umeta_id`, `user_id`, `meta_key`, `meta_value`) VALUES
(1, 1, 'first_name', ''),
(2, 1, 'last_name', ''),
(3, 1, 'nickname', 'admin'),
(4, 1, 'description', ''),
(5, 1, 'rich_editing', 'true'),
(6, 1, 'comment_shortcuts', 'false'),
(7, 1, 'admin_color', 'fresh'),
(8, 1, 'use_ssl', '0'),
(9, 1, 'show_admin_bar_front', 'true'),
(10, 1, 'wp_capabilities', 'a:1:{s:13:"administrator";s:1:"1";}'),
(11, 1, 'wp_user_level', '10'),
(12, 1, 'dismissed_wp_pointers', 'wp330_toolbar,wp330_media_uploader,wp330_saving_widgets'),
(13, 1, 'show_welcome_panel', '1'),
(14, 1, 'wp_dashboard_quick_press_last_post_id', '3');
INSERT INTO `goStores_Vista_wp_users` (`ID`, `user_login`, `user_pass`, `user_nicename`, `user_email`, `user_url`, `user_registered`, `user_activation_key`, `user_status`, `display_name`) VALUES
(1, 'admin', '$P$BgRq1DV/Y74En4Cf7dThW1Vu18ujXl0', 'admin', 'jamessmith121212@gmail.com', '', '2012-11-08 06:27:09', '', 0, 'admin');


INSERT INTO `goStores_ProductServices` (`nServiceId`, `vServiceName`, `vServiceDescription`, `nSCatId`, `nPId`, `price`, `nQty`, `vType`, `vBillingInterval`, `nBillingDuration`, `nStatus`, `dLastUpdated`) VALUES
(1, 'Free Trial', 'Free Trial', 1, 1, 0.00, 100, 'free', 'M', 14, 0, '2012-12-19 15:50:09');

INSERT INTO `goStores_Banners` (`nBannerId`, `vBannerText`, `vBannerUrl`, `vBannerImageId`, `vActive`, `showcount`, `clickcount`, `eType`) VALUES
(9, 'GoStores', '', 776, '1', '', '', 'Home Page Sliding Banner'),
(10, 'GoStores', '', 780, '1', '', '', 'Home Page Sliding Banner'),
(11, 'GoStores', '', 781, '0', '', '', 'Home Page Sliding Banner'),
(13, 'GoStores', '', 824, '1', '', '', 'Home Page Sliding Banner');

INSERT INTO `goStores_files` (`file_id`, `file_orig_name`, `file_extension`, `file_mime_type`, `file_type`, `file_width`, `file_height`, `file_play_time`, `file_size`, `file_path`, `file_status`, `file_title`, `file_caption`, `file_tmp_name`, `created_on`, `created_by`) VALUES
(776, 'banner1315847750.jpg', 'jpg', 'image/jpeg', '', 988, 337, 0, 102557, 'me91hb3xfh0.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(780, 'banner1315856405.jpg', 'jpg', 'image/jpeg', '', 988, 337, 0, 139726, 'meacd2x9hpq.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(781, 'banner1315850451.jpg', 'jpg', 'image/jpeg', '', 988, 337, 0, 137194, 'meaclpwk0on.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(824, 'banner.jpg', 'jpg', 'image/jpeg', '', 1250, 400, 0, 326193, 'mf4d5362byd.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(846, 'screen5.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 92656, 'mgt5uqvtpbd.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(847, 'screen2.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 49011, 'mgt5ylasmyr.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(848, 'screen3.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 41185, 'mgt62bcr2b6.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(849, 'screen4.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 37790, 'mgt7ao0kecp.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(850, 'screen1.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 34610, 'mgt7azc4209.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(851, 'screen6.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 34063, 'mgt7bbctolm.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(852, 'screen7.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 49721, 'mgt7cut79wl.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(853, 'screen8.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 57425, 'mgt7ddhjn0s.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(854, 'screen9.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 50962, 'mgt7dqpo0d8.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(855, 'screen10.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 42304, 'mgt7ek4w45m.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(856, 'screen11.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 51930, 'mgt7exu4ops.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(857, 'screen12.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 42350, 'mgt7fev1i3a.jpg', NULL, NULL, NULL, NULL, NULL, 0);


INSERT INTO `goStores_DemoScreenshots` (`nScreenId`, `vScreenImageId`, `vActive`, `eType`) VALUES
(1, 846, '1', 'User'),
(2, 847, '1', 'User'),
(3, 848, '1', 'User'),
(4, 849, '1', 'User'),
(5, 850, '1', 'User'),
(6, 851, '1', 'User'),
(7, 852, '1', 'Admin'),
(8, 853, '1', 'Admin'),
(9, 854, '1', 'Admin'),
(10, 855, '1', 'Admin'),
(11, 856, '1', 'Admin'),
(12, 857, '1', 'Admin');

INSERT INTO `goStores_tld_godaddy` (`nId`, `nDuration`, `eType`, `vProductid`, `vTld`) VALUES
	(1, 1, 'Registration', '350001', 'com'),
	(2, 2, 'Registration', '350002', 'com'),
	(3, 3, 'Registration', '350003', 'com'),
	(4, 4, 'Registration', '350004', 'com'),
	(5, 5, 'Registration', '350005', 'com'),
	(6, 6, 'Registration', '350006', 'com'),
	(7, 7, 'Registration', '350007', 'com'),
	(8, 8, 'Registration', '350008', 'com'),
	(9, 9, 'Registration', '350009', 'com'),
	(10, 10, 'Registration', '350010', 'com'),
	(11, 1, 'Renewal', '15212', 'bz'),
	(12, 1, 'Renewal', '19140', 'me'),
	(13, 1, 'Renewal', '19850', 'in'),
	(14, 1, 'Renewal', '50801', 'mobi'),
	(15, 1, 'Renewal', '51000', 'co.in'),
	(16, 1, 'Renewal', '51100', 'firm.in'),
	(17, 1, 'Renewal', '51200', 'gen.in'),
	(18, 1, 'Renewal', '51300', 'ind.in'),
	(19, 1, 'Renewal', '51400', 'net.in'),
	(20, 1, 'Renewal', '350012', 'com'),
	(21, 2, 'Renewal', '350013', 'com'),
	(22, 3, 'Renewal', '350014', 'com'),
	(23, 4, 'Renewal', '350015', 'com'),
	(24, 5, 'Renewal', '350016', 'com'),
	(25, 6, 'Renewal', '350017', 'com'),
	(26, 7, 'Renewal', '350018', 'com'),
	(27, 8, 'Renewal', '350019', 'com'),
	(28, 9, 'Renewal', '350020', 'com'),
	(29, 10, 'Renewal', '350021', 'com'),
	(30, 1, 'Transfer', '350011', 'com'),
	(31, 1, 'Registration', '350076', 'BIZ'),
	(32, 2, 'Registration', '350077', 'BIZ'),
	(33, 3, 'Registration', '350078', 'BIZ'),
	(34, 4, 'Registration', '350079', 'BIZ'),
	(35, 5, 'Registration', '350080', 'BIZ'),
	(36, 6, 'Registration', '350081', 'BIZ'),
	(37, 7, 'Registration', '350082', 'BIZ'),
	(38, 8, 'Registration', '350083', 'BIZ'),
	(39, 9, 'Registration', '350084', 'BIZ'),
	(40, 10, 'Registration', '350085', 'BIZ'),
	(41, 1, 'Transfer', '350086', 'BIZ'),
	(42, 1, 'Renewal', '350087', 'BIZ'),
	(43, 2, 'Renewal', '350088', 'BIZ'),
	(44, 3, 'Renewal', '350089', 'BIZ'),
	(45, 4, 'Renewal', '350090', 'BIZ'),
	(46, 5, 'Renewal', '350091', 'BIZ'),
	(47, 6, 'Renewal', '350092', 'BIZ'),
	(48, 7, 'Renewal', '350093', 'BIZ'),
	(49, 8, 'Renewal', '350094', 'BIZ'),
	(50, 9, 'Renewal', '350095', 'BIZ'),
	(51, 10, 'Renewal', '350096', 'BIZ'),
	(52, 1, 'Registration', '9850', 'IN'),
	(53, 2, 'Registration', '9851', 'IN'),
	(54, 3, 'Registration', '9852', 'IN'),
	(55, 4, 'Registration', '9853', 'IN'),
	(56, 5, 'Registration', '9854', 'IN'),
	(57, 6, 'Registration', '9855', 'IN'),
	(58, 7, 'Registration', '9856', 'IN'),
	(59, 8, 'Registration', '9857', 'IN'),
	(60, 9, 'Registration', '9858', 'IN'),
	(61, 10, 'Registration', '9859', 'IN'),
	(62, 1, 'Transfer', '9860', 'IN'),
	(63, 1, 'Renewal', '19850', 'IN'),
	(64, 2, 'Renewal', '19851', 'IN'),
	(65, 3, 'Renewal', '19852', 'IN'),
	(66, 4, 'Renewal', '19853', 'IN'),
	(67, 5, 'Renewal', '19854', 'IN'),
	(68, 6, 'Renewal', '19855', 'IN'),
	(69, 7, 'Renewal', '19856', 'IN'),
	(70, 8, 'Renewal', '19857', 'IN'),
	(71, 9, 'Renewal', '19858', 'IN'),
	(72, 10, 'Renewal', '19859', 'IN'),
	(73, 1, 'Registration', '350051', 'INFO'),
	(74, 2, 'Registration', '350052', 'INFO'),
	(75, 3, 'Registration', '350053', 'INFO'),
	(76, 4, 'Registration', '350054', 'INFO'),
	(77, 5, 'Registration', '350055', 'INFO'),
	(78, 6, 'Registration', '350056', 'INFO'),
	(79, 7, 'Registration', '350057', 'INFO'),
	(80, 8, 'Registration', '350058', 'INFO'),
	(81, 9, 'Registration', '350059', 'INFO'),
	(82, 10, 'Registration', '350060', 'INFO'),
	(83, 1, 'Transfer', '350061', 'INFO'),
	(84, 1, 'Renewal', '350062', 'INFO'),
	(85, 2, 'Renewal', '350063', 'INFO'),
	(86, 3, 'Renewal', '350064', 'INFO'),
	(87, 4, 'Renewal', '350065', 'INFO'),
	(88, 5, 'Renewal', '350066', 'INFO'),
	(89, 6, 'Renewal', '350067', 'INFO'),
	(90, 7, 'Renewal', '350068', 'INFO'),
	(91, 8, 'Renewal', '350069', 'INFO'),
	(92, 9, 'Renewal', '350070', 'INFO'),
	(93, 10, 'Renewal', '350071', 'INFO'),
	(94, 1, 'Registration', '40801', 'MOBI'),
	(95, 2, 'Registration', '40802', 'MOBI'),
	(96, 3, 'Registration', '40803', 'MOBI'),
	(97, 4, 'Registration', '40804', 'MOBI'),
	(98, 5, 'Registration', '40805', 'MOBI'),
	(99, 6, 'Registration', '40806', 'MOBI'),
	(100, 7, 'Registration', '40807', 'MOBI'),
	(101, 8, 'Registration', '40808', 'MOBI'),
	(102, 9, 'Registration', '40809', 'MOBI'),
	(103, 10, 'Registration', '40810', 'MOBI'),
	(104, 1, 'Transfer', '40811', 'MOBI'),
	(105, 1, 'Renewal', '50801', 'MOBI'),
	(106, 2, 'Renewal', '50802', 'MOBI'),
	(107, 3, 'Renewal', '50803', 'MOBI'),
	(108, 4, 'Renewal', '50804', 'MOBI'),
	(109, 5, 'Renewal', '50805', 'MOBI'),
	(110, 6, 'Renewal', '50806', 'MOBI'),
	(111, 7, 'Renewal', '50807', 'MOBI'),
	(112, 8, 'Renewal', '50808', 'MOBI'),
	(113, 9, 'Renewal', '50809', 'MOBI'),
	(114, 10, 'Renewal', '50810', 'MOBI'),
	(115, 1, 'Registration', '350030', 'NET '),
	(116, 2, 'Registration', '350031', 'NET '),
	(117, 3, 'Registration', '350032', 'NET '),
	(118, 4, 'Registration', '350033', 'NET '),
	(119, 5, 'Registration', '350034', 'NET '),
	(120, 6, 'Registration', '350035', 'NET '),
	(121, 7, 'Registration', '350036', 'NET '),
	(122, 8, 'Registration', '350037', 'NET '),
	(123, 9, 'Registration', '350038', 'NET '),
	(124, 10, 'Registration', '350039', 'NET '),
	(125, 1, 'Transfer', '350040', 'NET '),
	(126, 1, 'Renewal', '350041', 'NET '),
	(127, 2, 'Renewal', '350042', 'NET '),
	(128, 3, 'Renewal', '350043', 'NET '),
	(129, 4, 'Renewal', '350044', 'NET '),
	(130, 5, 'Renewal', '350045', 'NET '),
	(131, 6, 'Renewal', '350046', 'NET '),
	(132, 7, 'Renewal', '350047', 'NET '),
	(133, 8, 'Renewal', '350048', 'NET '),
	(134, 9, 'Renewal', '350049', 'NET '),
	(135, 10, 'Renewal', '350050', 'NET '),
	(136, 1, 'Registration', '350150', 'ORG'),
	(137, 2, 'Registration', '350151', 'ORG'),
	(138, 3, 'Registration', '350152', 'ORG'),
	(139, 4, 'Registration', '350153', 'ORG'),
	(140, 5, 'Registration', '350154', 'ORG'),
	(141, 6, 'Registration', '350155', 'ORG'),
	(142, 7, 'Registration', '350156', 'ORG'),
	(143, 8, 'Registration', '350157', 'ORG'),
	(144, 9, 'Registration', '350158', 'ORG'),
	(145, 10, 'Registration', '350159', 'ORG'),
	(146, 1, 'Transfer', '350160', 'ORG'),
	(147, 1, 'Renewal', '350161', 'ORG'),
	(148, 2, 'Renewal', '350162', 'ORG'),
	(149, 3, 'Renewal', '350163', 'ORG'),
	(150, 4, 'Renewal', '350164', 'ORG'),
	(151, 5, 'Renewal', '350165', 'ORG'),
	(152, 6, 'Renewal', '350166', 'ORG'),
	(153, 7, 'Renewal', '350167', 'ORG'),
	(154, 8, 'Renewal', '350168', 'ORG'),
	(155, 9, 'Renewal', '350169', 'ORG'),
	(156, 10, 'Renewal', '350170', 'ORG'),
	(157, 1, 'Registration', '350126', 'US'),
	(158, 2, 'Registration', '350127', 'US'),
	(159, 3, 'Registration', '350128', 'US'),
	(160, 4, 'Registration', '350129', 'US'),
	(161, 5, 'Registration', '350130', 'US'),
	(162, 6, 'Registration', '350131', 'US'),
	(163, 7, 'Registration', '350132', 'US'),
	(164, 8, 'Registration', '350133', 'US'),
	(165, 9, 'Registration', '350134', 'US'),
	(166, 10, 'Registration', '350135', 'US'),
	(167, 1, 'Transfer', '350136', 'US'),
	(168, 1, 'Renewal', '350137', 'US'),
	(169, 2, 'Renewal', '350138', 'US'),
	(170, 3, 'Renewal', '350139', 'US'),
	(171, 4, 'Renewal', '350140', 'US'),
	(172, 5, 'Renewal', '350141', 'US'),
	(173, 6, 'Renewal', '350142', 'US'),
	(174, 7, 'Renewal', '350143', 'US'),
	(175, 8, 'Renewal', '350144', 'US'),
	(176, 9, 'Renewal', '350145', 'US'),
	(177, 10, 'Renewal', '350146', 'US'),
	(178, 1, 'Registration', '350101', 'WS'),
	(179, 2, 'Registration', '350102', 'WS'),
	(180, 3, 'Registration', '350103', 'WS'),
	(181, 4, 'Registration', '350104', 'WS'),
	(182, 5, 'Registration', '350105', 'WS'),
	(183, 6, 'Registration', '350106', 'WS'),
	(184, 7, 'Registration', '350107', 'WS'),
	(185, 8, 'Registration', '350108', 'WS'),
	(186, 9, 'Registration', '350109', 'WS'),
	(187, 10, 'Registration', '350110', 'WS'),
	(188, 1, 'Renewal', '350112', 'WS'),
	(189, 2, 'Renewal', '350113', 'WS'),
	(190, 3, 'Renewal', '350114', 'WS'),
	(191, 4, 'Renewal', '350115', 'WS'),
	(192, 5, 'Renewal', '350116', 'WS'),
	(193, 6, 'Renewal', '350117', 'WS'),
	(194, 7, 'Renewal', '350118', 'WS'),
	(195, 8, 'Renewal', '350119', 'WS'),
	(196, 9, 'Renewal', '350120', 'WS'),
	(197, 10, 'Renewal', '350121', 'WS'),
	(198, 1, 'Transfer', '350811', 'WS');

INSERT INTO `goStores_Settings` (`settingfield`, `settinglabel`, `value`, `groupLabel`, `type`, `fieldOrder`, `helpText`) VALUES ('paypal_bn_code', 'Paypal BN Code', NULL, 'Payment', '', '', 'Build Notation ID Code is a unique identifier that tells PayPal how much volume comes in through merchants who use your integrated Paypal solution');

INSERT INTO `goStores_Settings` (`settingfield`, `settinglabel`, `value`, `groupLabel`, `type`, `fieldOrder`, `helpText`) VALUES ('paypaladvanced_bn_code', 'Paypal Advanced BN Code', NULL, 'Payment', '', '', 'Build Notation ID Code is a unique identifier that tells PayPal how much volume comes in through merchants who use your integrated Paypal solution');

INSERT INTO `goStores_Settings` (`settingfield`, `settinglabel`, `value`, `groupLabel`, `type`, `fieldOrder`, `helpText`) VALUES ('paypalpro_bn_code', 'Paypalpro BN Code', NULL, 'Payment', '', '', 'Build Notation ID Code is a unique identifier that tells PayPal how much volume comes in through merchants who use your integrated Paypal solution');

INSERT INTO `goStores_Settings` (`settingfield`, `settinglabel`, `value`, `groupLabel`, `type`, `helpText`) VALUES ('site_operation_mode', 'Site Operation Mode', 'S', 'Server Settings', 'radio', 'Choose the option \'single server\' if your website and store installations are in same server else \'multiple server\'');

INSERT INTO `goStores_Settings` (`settingfield`, `settinglabel`, `value`, `groupLabel`, `type`, `helpText`) VALUES ('site_operation_park_domain', 'Temporary URLs', 'N', 'Server Settings', 'radio', 'If you have chosen \'Yes\', please configure your server setings to \'Allow users to park subdomains/domains of the server\'s hostname\'');

INSERT INTO `goStores_Settings` (`settingfield`, `settinglabel`, `value`, `groupLabel`, `type`, `fieldOrder`, `helpText`) VALUES ('enableDomiainRegistration', 'Enable Domain Registration', 'N', 'Domain Registrar', 'checkbox', 0, 'Enable Domain Registration');

INSERT INTO `goStores_Vista_cmspages` (`id`, `title`, `content`, `type`, `status`) VALUES 
(13, 'Registration confirm mail to admin user', '<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p><em><span style="font-size: larger;">Hi Dear [User_Name],<br />\r\n</span></em></p>\r\n<p><em><span style="font-size: larger;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; You are  Registered as admin user  with&nbsp; [SITE_NAME] is completed......<br />\r\n</span></em></p>\r\n<p><em><span style="font-size: larger;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Your User Name is&nbsp; : [User_Name]</span></em> </p>\r\n<p>&nbsp;&nbsp;<em><span style="font-size: larger;">&nbsp;&nbsp;&nbsp; Your Password is&nbsp;&nbsp;&nbsp;&nbsp; :&nbsp; [PASSWORD]</span></em></p>\r\n<p><em><span style="font-size: larger;">&nbsp; [LOGIN_URL]<br />\r\n</span></em></p>\r\n<p><em><span style="font-size: larger;">Thanks and Regards,<br />\r\n</span></em></p>\r\n<p><em><span style="font-size: larger;">Administrator [SITE_NAME]<br />\r\n</span></em></p>', 'email', 'Y'),
(14, 'Contact us mail for admin', '<p>&nbsp;</p>\r\n<p>Dear Administrator,</p>\r\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; A new contact us request has been received at [SITE_NAME]. Please find the details below</p>\r\n<p>Name: [name]</p>\r\n<p>Email: [email]</p>\r\n<p>Message:- [message]</p>', 'email', 'Y');

INSERT INTO `goStores_Vista_users` (`id`, `uname`, `password`, `email`, `reg_date`, `usertype`, `reg_status`, `user_credit`) VALUES
(1, 'user', '1a1dc91c907325c69271ddf0c944bc72', 'jamessmith121212@gmail.com', '0000-00-00 00:00:00', 'R', '', 0);


UPDATE `goStores_Vista_users` SET `usertype`='Retail', `reg_status`='R' WHERE  `id`=1 LIMIT 1;

UPDATE `goStores_Settings` SET `helpText`='Would you like your site linked to LinkedIn?' WHERE  `settingfield`='enable_ln' AND `settinglabel`='Enable LinkedIn' AND `groupLabel`='Social Settings' AND `type`='checkbox' AND `fieldOrder`=0  LIMIT 1;

UPDATE `goStores_ProductPermission` SET `vPermissions` = 'app/webroot/img/,app/webroot/img/products/,app/webroot/img/csv/,app/tmp/,app/tmp/logs/,app/tmp/sessions/,app/tmp/cache/,app/tmp/cache/models/,app/tmp/cache/views/,app/tmp/cache/persistent/,app/webroot/files/,app/webroot/files/File,app/webroot/files/Flash,app/webroot/files/Image,app/webroot/files/Media,app/webroot/files/Graph,app/config/database.php,app/webroot/config.php,app/webroot/img/SiteLogo.gif,app/webroot/img/SiteLogo_disp.gif,app/webroot/blog/wp-content/,app/webroot/blog/wp-config.php,app/controllers/components/pple.xml,app/webroot/configxml.xml,app/webroot/moneybooker.txt,' WHERE `goStores_ProductPermission`.`nId` = 1;

INSERT INTO `sptbl_lookup` (`vLookUpName`,`vLookUpValue`) VALUES ('HomeFooterContent','How can we help you?');
UPDATE sptbl_lookup set vLookUpValue='en' where vLookUpName='DefaultLang';
UPDATE sptbl_lookup set vLookUpValue='1' where vLookUpName='LangChoice';
UPDATE sptbl_lookup set vLookUpValue='1' where vLookUpName='AutoLock';
UPDATE sptbl_lookup set vLookUpValue='1' where vLookUpName='VerifyTemplate';
UPDATE sptbl_lookup set vLookUpValue='1' where vLookUpName='VerifyKB';
UPDATE `sptbl_lookup` set `vLookUpValue`=4.3 where `vLookUpName`='Version';
INSERT INTO `sptbl_lookup` (`vLookUpName`) VALUES ('SMTPUsername');
INSERT INTO `sptbl_lookup` (`vLookUpName`) VALUES ('SMTPPassword');
INSERT INTO `sptbl_lookup` (`vLookUpName`) VALUES ('SMTPEnableSSL'); 

INSERT INTO `sptbl_templates` (`nTemplateId`, `dDate`, `vTemplateTitle`, `tTemplateDesc`, `nStaffId`, `vStatus`) VALUES ('1', '2013-07-26 00:00:00', 'installer_mail', '<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<title></title>
<table width="600" cellspacing="0" cellpadding="0" border="0" style="border:1px solid #ccc; background-color:#FDFDFD; ">
    <tbody>
        <tr>
            <td height="5" colspan="3"></td>
        </tr>
        <tr>
            <td width="5"></td>
            <td width="586"><table width="100%" cellspacing="0" cellpadding="0" border="0">
    <tbody>
        <tr>
            <td height="56" style="background-color:#324148; ">;
                <table width="100%" cellspacing="0" cellpadding="0" border="0">
                    <tbody>
                        <tr>
                            <td width="2%" height="80">&#160;</td>
                            <td width="37%">{SITE_LOGO}</td>
                            <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>
                        </tr>
                    </tbody>
                </table></td>
        </tr>
        <tr>
            <td height="10">&#160;</td>
        </tr>
        <tr>
            <td>&#160;</td>
        </tr>
        <tr>
            <td><table width="100%" cellspacing="0" cellpadding="0" border="0">
                    <tbody>
                        <tr>
                            <td width="2%">&#160;</td>
                            <td width="28%">{MAIL_CONTENT}</td>
                            <td width="2%">&#160;</td>
                        </tr>
                        <tr>
                            <td>&#160;</td>
                            <td>&#160;</td>
                            <td>&#160;</td>
                        </tr>
                        <tr>
                            <td>&#160;</td>
                            <td>&#160;</td>
                            <td>&#160;</td>
                        </tr>
                        <tr>
                            <td>&#160;</td>
                            <td>&#160;</td>
                            <td>&#160;</td>
                        </tr>
                    </tbody>
                </table></td>
        </tr>
        <tr>
            <td><table width="100%" cellspacing="0" cellpadding="0" border="0">
                    <tbody>
                        <tr>
                            <td height="30" style="background-color:#324148; "><p style="color:#FFFFFF; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>
                        </tr>
                    </tbody>
                </table></td>
        </tr>
    </tbody>
                </table></td>
                <td width="4">&#160;</td>
        </tr>
        <tr>
            <td height="10" colspan="3">&#160;</td>
        </tr>     </tbody> </table> <p>&#160;</p></meta>', '0', '0');