INSERT INTO `cms_groups` (`id`, `group_name`, `position`, `published`, `user_privilege`) VALUES
(1, 'General', 1, 1, 'all'),
(3, 'Configuration', 5, 1, 's'),
(9, 'Setup', 2, 1, 'all'),
(10, 'Contents', 2, 1, 'all');

INSERT INTO `dummy` (`num`) VALUES(0);
INSERT INTO `dummy` (`num`) VALUES(1);
INSERT INTO `dummy` (`num`) VALUES(2);
INSERT INTO `dummy` (`num`) VALUES(3);

INSERT INTO `cms_sections` (`id`, `group_id`, `section_name`, `section_alias`, `table_name`, `section_config`, `visibilty`, `display_order`, `user_privilege`) VALUES
	(6, 1, 'Plans', 'plans', 'goStores_ProductServices', '{"customAction":"true","controller":"products","method":"listplans","module":"admin"}\r\n', '1', 8, 'all'),
	(1, 3, 'Manage Groups', 'groups', 'cms_groups', '{\r\n"keyColumn":"id",\r\n"orderBy":{"id":"ASC"},\r\n"publishColumn":"published",\r\n"listColumns":["group_name","user_privilege"],\r\n"showColumns":["id","group_name","position","user_privilege"],\r\n"detailColumns":["id","group_name","position","user_privilege"],\r\n"detailHeaderColumns":["group_name"],\r\n"columns":{\r\n    "id":{"name":"ID","sortable":"true","editoptions":{"type":"hidden"}},\r\n    "group_name":{"name":"Group Name","sortable":"true","searchable":"searchable","editoptions":{"type":"textbox","label":"Group Name","class":"textbox"}},\r\n    "position":{"name":"Display Order","sortable":"true","editoptions":{"type":"textbox","label":"Display Order","class":"textbox"}},\r\n    "user_privilege":{"name":"Privilege","sortable":"true","searchable":"searchable","editoptions":{"type":"select","source":{"all":"All","s":"Superadmin"},"source_type":"array","label":"Privilege","class":"select","enumvalues":{"all":"All","s":"Superadmin"}}}\r\n    },\r\n"opertations":["add","edit","delete","view","publish"]\r\n}', '1', 2, 'all'),
	(2, 3, 'Manage Sections', 'sections', 'cms_sections', '{\r\n"keyColumn":"id",\r\n"orderBy":{"id":"ASC"},\r\n"listColumns":["group_id","section_name","section_alias","visibilty","display_order"],\r\n"showColumns":["id","group_id","section_name","section_alias","table_name","section_config","visibilty","display_order"],\r\n"detailColumns":["id","group_id","section_name","section_alias","table_name","section_config","visibilty","display_order"],\r\n"detailHeaderColumns":["section_name"],\r\n"columns":{\r\n    "id":{"name":"ID","sortable":"true","editoptions":{"type":"hidden"}},\r\n    "group_id":{"name":"Group ID","sortable":"true","searchable":"searchable","editoptions":{"validations":["required"],"type":"select","source":"Cms::getAllGroups","source_type":"function","label":"Group Name","class":"select"},"external":"true","externalOptions":{"externalTable":"cms_groups","externalColumn":"id","externalShowColumn":"group_name"}},\r\n    "section_name":{"name":"Section Name","sortable":"true","searchable":"searchable","editoptions":{"validations":["required"],"type":"textbox","label":"Section Name","class":"textbox"}},\r\n    "section_alias":{"name":"Section Alias","sortable":"true","searchable":"searchable","editoptions":{"validations":["required"],"type":"textbox","label":"Section Alias","class":"textbox"}},\r\n    "table_name":{"name":"Table Name","editoptions":{"validations":["required"],"type":"textbox","label":"Table Name","class":"textbox"}},\r\n    "section_config":{"name":"Section Config","editoptions":{"validations":["required"],"type":"textarea","label":"Section Config","class":"textarea"}},\r\n    "visibilty":{"name":"Make Visible","sortable":"true","searchable":"searchable","editoptions":{"type":"checkbox","label":"Make Visible","class":"inline","default":"yes","enumvalues":{"1":"Visible","0":"Invisible"}}},\r\n    "display_order":{"name":"Display Order","sortable":"true","searchable":"searchable","editoptions":{"type":"textbox","label":"Display Order","class":"textbox"}}\r\n    },\r\n"opertations":["add","edit","delete","view","publish"]\r\n}', '1', 3, 'all'),
	(3, 3, 'Manage Settings', 'manage_settings', 'goStores_cms_settings', '{\r\n"keyColumn":"id",\r\n"listColumns":["cms_set_name","cms_set_value"],\r\n"showColumns":["cms_set_name","cms_set_value"],\r\n"detailColumns":["id","cms_set_name","cms_set_value"],\r\n"detailHeaderColumns":["cms_set_name"],\r\n"columns":{\r\n    "id":{"name":"ID","sortable":"true","editoptions":{"type":"hidden"}},\r\n    "cms_set_name":{"name":"Name","sortable":"true","searchable":"searchable","editoptions":{"type":"disabled","label":"Name"}},\r\n    "cms_set_value":{"name":"Value","sortable":"true","searchable":"searchable","editoptions":{"type":"textbox","label":"Value","class":"textbox"}}\r\n},\r\n"opertations":["edit","view"]\r\n}', '1', 1, 'all'),
	(17, 10, 'Admin Help', 'adminHelp', 'goStores_Help', '{\r\n    "keyColumn": "nId",\r\n"detailHeaderColumns":["vTitle"],\r\n    "orderBy": {\r\n        "vTitle": "ASC"\r\n    },\r\n    "where": "goStores_Help.eType=\'Admin\'",\r\n    "listColumns": [\r\n        "vTitle",\r\n        "eStatus"\r\n    ],\r\n    "showColumns": [\r\n        "nId",\r\n        "vTitle",\r\n        "tDescription",\r\n        "eType",\r\n        "eStatus"\r\n    ],\r\n    "detailColumns": [\r\n        "nId",\r\n        "vTitle",\r\n        "tDescription",\r\n        "eStatus",\r\n        "eType"\r\n    ],\r\n    "columns": {\r\n        "nId": {\r\n            "name": "ID"\r\n        },\r\n        "vTitle": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "tDescription": {\r\n            "name": "Description",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "htmlEditor",\r\n                "label": "Description"\r\n            }\r\n        },\r\n        "eType": {\r\n            "name": "Help Category",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "Admin": "Admin",\r\n                    "User": "User"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Category",\r\n                "enumvalues": {\r\n                    "Admin": "Admin",\r\n                    "User": "User"\r\n                }\r\n            }\r\n        },\r\n        "eStatus": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "Active": "Active",\r\n                    "Disabled": "Disabled"\r\n                },\r\n                "label": "Status",\r\n                "enumvalues": {\r\n                    "Active": "Active",\r\n                    "Disabled": "Disabled"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "edit",\r\n        "delete",\r\n        "view"\r\n    ]\r\n}', '1', 10, 'all'),
	(7, 9, 'Settings', 'settings', ' goStores_Settings', '{"customAction":"true","controller":"module","method":"settingsdisplay","module":"admin"}\r\n', '1', 1, 'all'),
	(8, 1, 'Users', 'user', 'goStores_User', '{\r\n    "keyColumn": "nUId",\r\n    "detailHeaderColumns": [\r\n        "vFirstName",\r\n        "vLastName"\r\n    ],\r\n    "detailHeaderColumnPrefix": "User: ",\r\n    "orderBy": {\r\n        "vFirstName": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "vFirstName",\r\n        "vLastName",\r\n        "vEmail",\r\n        "nStatus",\r\n        "plans"\r\n    ],\r\n    "detailColumns": [\r\n        "nUId",\r\n        "vFirstName",\r\n        "vLastName",\r\n        "vEmail",\r\n        "vInvoiceEmail",\r\n        "vAddress",\r\n        "vCity",\r\n        "vState",\r\n        "vCountry",\r\n        "vZipcode",\r\n        "vPhoneNumber",\r\n        "vFax",\r\n        "nStatus",\r\n        "plans"\r\n    ],\r\n    "showColumns": [\r\n        "nUId",\r\n        "vFirstName",\r\n        "vLastName",\r\n        "vEmail",\r\n        "vInvoiceEmail",\r\n        "vAddress",\r\n        "vCity",\r\n        "vState",\r\n        "vCountry",\r\n        "vZipcode",\r\n        "vPhoneNumber",\r\n        "vFax",\r\n        "nStatus"\r\n    ],\r\n    "columns": {\r\n        "nUId": {\r\n            "name": "ID"\r\n        },\r\n        "vFirstName": {\r\n            "name": "First Name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "First Name",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vLastName": {\r\n            "name": "Last Name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Last Name",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vEmail": {\r\n            "name": "Contact Email",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Contact Email",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vInvoiceEmail": {\r\n            "name": "Invoice Email",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Invoice Email",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vAddress": {\r\n            "name": "Address",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Address",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vCity": {\r\n            "name": "City",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "City",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vState": {\r\n            "name": "State",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "State",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vCountry": {\r\n            "name": "Country",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Country",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vZipcode": {\r\n            "name": "Zip Code",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Zip Code",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vPhoneNumber": {\r\n            "name": "Phone",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Phone",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vFax": {\r\n            "name": "Fax",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Fax",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "nStatus": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "2": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "2": "Inactive"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::changeUserStatus",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "2": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "1": "green",\r\n                    "2": "red"\r\n                }\r\n            }\r\n        },\r\n        "plans": {\r\n            "name": "Plans",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getCmsUserPlanDetails"\r\n        }\r\n    },\r\n    "customOperations": {\r\n        "login": {\r\n            "options": {\r\n                "target": "newtab",\r\n                "name": "Login",\r\n                "linkSource": "Admin::getuserLogInUrl"\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "add",\r\n        "delete"\r\n    ]\r\n}', '1', 7, 'all'),
	(9, 1, 'Dashboard', 'dashboard', 'goStores_ProductLookup', '{\r\n    "dashboardPanel": "true",\r\n    "graphPanel": "true",\r\n    "graphpanelRow": "2",\r\n    "graphPanel1": {\r\n        "columns": "2",\r\n        "graph1": {\r\n            "type": "MSColumn3D",\r\n            "caption":"Total Domain Registrations",\r\n            "xAxisName":"Last 7 Days",\r\n             "yAxisName":"Domain Registaration Count",\r\n            "width":"480",\r\n             "height":"300",\r\n             "dataSetsCount":"2",\r\n             "dataSets":{"dataset1":{"name":"","color":"#D3AC4F","fetchValue":"Admin::getRegistredDomainCount"}}\r\n\r\n        },\r\n        "graph2": {\r\n            "type": "MSLine",\r\n             "caption":"Total Users",\r\n             "xAxisName":"Last 7 Days",\r\n             "yAxisName":"User Count",\r\n            "width":"480",\r\n             "height":"300",\r\n               "dataSetsCount":"1",\r\n              "dataSets":{"dataset1":{"name":"","color":"#D3AC4F","fetchValue":"Admin::getUsersCount"}}\r\n\r\n        }\r\n    },\r\n    "graphPanel2": {\r\n        "columns": "2",\r\n        "graph1": {\r\n            "type": "MSColumn3D",\r\n             "caption":"Total Stores Created",\r\n             "xAxisName":"Last 7 Days",\r\n             "yAxisName":"Store Count",\r\n            "width":"480",\r\n             "height":"300",\r\n               "dataSetsCount":"1",\r\n              "dataSets":{"dataset1":{"name":"","color":"#D3AC4F","fetchValue":"Admin::getStoresCount"}}\r\n        },\r\n        "graph2": {\r\n            "type": "MSColumn3D",\r\n             "caption":"Free Trials By Month",\r\n             "xAxisName":"Last 7 Days",\r\n             "yAxisName":"Free Trails Count",\r\n            "width":"480",\r\n             "height":"300",\r\n               "dataSetsCount":"1",\r\n              "dataSets":{"dataset1":{"name":"","color":"#D3AC4F","fetchValue":"Admin::getFreeTrialsCount"}}\r\n\r\n        }\r\n    }\r\n}', '1', 0, 'all'),
	(10, 1, 'Invoices', 'invoice', 'goStores_Invoice', '{\r\n    "keyColumn": "nInvId",\r\n    "orderBy": {\r\n        "dGeneratedDate": "DESC"\r\n    },\r\n    "detailHeaderColumns": ["vInvNo"],\r\n    "detailHeaderColumnPrefix": "Invoice: ",\r\n    "listColumns": [\r\n        "vInvNo",\r\n        "vSubscriptionType",\r\n        "nUId",		\r\n        "dGeneratedDate",\r\n        "dDueDate",\r\n        "dPayment",\r\n        "pStatus",\r\n        "nTotal"\r\n    ],\r\n    "detailColumns": [\r\n        "nInvId",\r\n        "vInvNo",\r\n        "vSubscriptionType",\r\n        "vTxnId",\r\n        "nUId",\r\n        "dGeneratedDate",\r\n        "dDueDate",\r\n        "dPayment",\r\n        "pStatus",\r\n        "nTotal"\r\n    ],\r\n    "columns": {\r\n        "nInvId": {\r\n            "name": "ID"\r\n        },\r\n        "vInvNo": {\r\n            "name": "Invoice Number",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getCmsInvoiceDetails"\r\n        },\r\n        "pStatus": {\r\n            "name": "Payment Status",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getPaymentStatus"\r\n        },\r\n		\r\n        "vSubscriptionType": {\r\n            "name": "Subscription",\r\n            "searchable": "searchable",\r\n            "sortable": "true"\r\n        },\r\n        "vTxnId": {\r\n            "name": "Transaction ID"\r\n        },\r\n        "nUId": {\r\n            "name": "User",\r\n            "sortable": "true",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getUsernameFromInvoice"\r\n        },		\r\n        "dGeneratedDate": {\r\n            "name": "Generated On",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "dbFormat": "timestamp",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n        "dDueDate": {\r\n            "name": "Due On",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "dbFormat": "timestamp",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n        "dPayment": {\r\n            "name": "Paid On",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getInvoicePaidDateForCMS"\r\n        },\r\n        "nTotal": {\r\n            "name": "Total Amount",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "listHeaderPostfix": "Admincomponents::getCurrencySymbolForCms",\r\n"lsHeaderPostfixCustom": "true",\r\n"decimalPoint":"2"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view"\r\n    ],\r\n    "report": {\r\n        "reportTitle": "Invoices",\r\n        "columns": [\r\n            "vInvNo",\r\n            "vSubscriptionType",\r\n            "vTxnId",\r\n            "nUId",\r\n            "dGeneratedDate",\r\n            "dDueDate",\r\n            "dPayment",\r\n            "pStatus",\r\n            "nTotal"\r\n        ],\r\n        "dateColumn": "dGeneratedDate"\r\n    }\r\n}', '1', 3, 'all'),
	(40, 9, 'Screenshots', 'screenshots', 'goStores_DemoScreenshots', '{\r\n    "keyColumn": "nScreenId",\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "nScreenId": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "eType",       \r\n        "vScreenImageId",\r\n        "vActive"       \r\n    ],\r\n    "showColumns": [\r\n        "nScreenId",\r\n        "eType",        \r\n        "vScreenImageId",\r\n        "vActive"       \r\n    ],\r\n    "detailColumns": [\r\n        "nScreenId",\r\n        "eType",       \r\n        "vScreenImageId",\r\n        "vActive"        \r\n    ],\r\n    "columns": {\r\n        "eType": {\r\n            "name": "Screen Type",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "source": {\r\n                    "User": "User Panel Screen",\r\n                    "Admin": "Admin Panel Screen"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Screen Type",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "User": "User Panel Screen",\r\n                    "Admin": "Admin Panel Screen"\r\n                }\r\n            }\r\n        },               \r\n        "vScreenImageId": {\r\n            "name": "Screen Image",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Screen Image",\r\n                "class": "file",\r\n                "hint": "User Panel Screen : Ideal Width & Height - 400px X 231px <br> Admin Panel Screen : Ideal Width & Height - 400px X 231px"\r\n            },\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getCmsScreenImage"\r\n        },        \r\n        "vActive": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "checkbox",\r\n                "label": "Enable Screen",\r\n                "default": "yes",\r\n                "enumvalues": {\r\n                    "0": "Inactive",\r\n                    "1": "Active"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::changeScreenStatus",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "1": "green",\r\n                    "0": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "edit",\r\n        "delete",\r\n        "publish"\r\n    ]\r\n}', '1', 7, 'all'),
	(12, 1, 'Feedback', 'feedback', 'goStores_contacts', '{\r\n    "keyColumn": "id",\r\n    "orderBy": {\r\n        "cdate": "ASC"\r\n    },\r\n    "detailHeaderColumns": ["cname"],\r\n    "detailHeaderColumnPrefix": "Feedback: ",\r\n    "listColumns": [\r\n        "cname",\r\n        "cemail",\r\n        "cdescr",\r\n        "cdate"\r\n    ],\r\n    "detailColumns": [\r\n        "id",\r\n        "cname",\r\n        "cemail",\r\n        "cdescr",\r\n        "cdate"\r\n    ],\r\n    "columns": {\r\n    "id":{"name":"ID"},\r\n        "cname": {\r\n            "name": "Customer",\r\n            "searchable": "searchable",\r\n            "sortable": "true"\r\n        },\r\n        "cemail": {\r\n            "name": "Email",\r\n            "searchable": "searchable",\r\n            "sortable": "true"\r\n        },\r\n        "cdescr": {\r\n            "name": "Feedbacks",\r\n            "sortable": "true"\r\n        },\r\n        "cdate": {\r\n            "name": "Date",\r\n            "sortable": "true",\r\n            "dbFormat":"datetime",\r\n            "displayFormat":"m/d/Y"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "delete"\r\n    ]\r\n}', '1', 6, 'all'),
	(13, 9, 'Server Info', 'serverinfo', 'goStores_ServerInfo', '{\r\n    "keyColumn": "nserver_id",\r\n    "orderBy": {\r\n        "vserver_name": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "vserver_name",\r\n        "vmakethisserver_default",\r\n        "whm_port",\r\n        "cpanel_port"\r\n    ],\r\n    "showColumns": [\r\n        "nserver_id",\r\n        "vserver_name",\r\n        "whmuser",\r\n        "whmpass",\r\n        "whmip",\r\n        "vserver_hosting_plan",\r\n        "vserver_configfilename",\r\n        "vserver_configfilepath",\r\n\r\n        "whm_port",\r\n        "cpanel_port",\r\n\r\n        "vmakethisserver_default"\r\n    ],\r\n    "detailColumns": [\r\n        "nserver_id",\r\n        "vserver_name",\r\n        "whmuser",\r\n        "whmpass",\r\n        "whmip",\r\n        "vserver_hosting_plan",\r\n        "vserver_configfilename",\r\n        "vserver_configfilepath",\r\n\r\n        "whm_port",\r\n        "cpanel_port",\r\n\r\n        "vmakethisserver_default"\r\n    ],\r\n    "detailHeaderColumns": [\r\n        "vserver_name"\r\n    ],\r\n    "detailHeaderColumnPrefix": "Server Info: ",\r\n    "columns": {\r\n        "nserver_id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vserver_name": {\r\n            "name": "Server",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Server Name",\r\n                "class": "textbox",\r\n                "hint": "Enter your Host name eg: yoursitename.com"\r\n            }\r\n        },\r\n        "whmuser": {\r\n            "name": "WHM User",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "WHM User",\r\n                "class": "textbox",\r\n                 "hint": "Enter the WHM user name"\r\n            }\r\n        },\r\n        "whmpass": {\r\n            "name": "WHM Password",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "WHM Password",\r\n                "class": "textbox",\r\n                 "hint": "Enter the WHM password"\r\n            }\r\n        },\r\n        "whmip": {\r\n            "name": "WHM IP",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "WHM IP",\r\n                "class": "textbox",\r\n                 "hint": "Enter WHM IP"\r\n            }\r\n        },\r\n        "vserver_hosting_plan": {\r\n            "name": "Server Package Name",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Server Package Name",\r\n                "class": "textbox",\r\n                 "hint": "Enter the server package name/ hosting package name"\r\n            }\r\n        },\r\n        "vserver_configfilename": {\r\n            "name": "Product Pack Location",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Product Pack Location",\r\n                "class": "textbox",\r\n                 "hint": "Enter the product pack locaton eg: /home/yourWHMusername/public_html/project/products/"\r\n            }\r\n        },\r\n        "vserver_configfilepath": {\r\n            "name": "Setup Landing Location",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Setup Landing Location",\r\n                "class": "textbox",\r\n                 "hint": "Enter the setup landing location eg: /public_html/"\r\n            }\r\n        },\r\n\r\n\r\n         "whm_port": {\r\n            "name": "WHM Port",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "WHM Port",\r\n                "class": "textbox",\r\n                 "hint": "Enter the WHM Port eg: 2086 / 2087(secure)"\r\n            }\r\n        },\r\n         "cpanel_port": {\r\n            "name": "CPanel Port",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "CPanel Port",\r\n                "class": "textbox",\r\n                 "hint": "Enter the CPanel Port eg : 2082 / 2083(secure)"\r\n            }\r\n        },\r\n\r\n\r\n\r\n\r\n        "vmakethisserver_default": {\r\n            "name": "Default Server",\r\n            "editoptions": {\r\n                "type": "checkbox",\r\n                "label": "Make Default Server",\r\n                "class": "inline",\r\n                 "hint": "Check this to enable this as default server",\r\n                "default": "NO",\r\n                "enumvalues": {\r\n                    "1": "YES",\r\n                    "0": "NO"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::getServerDefaultUrl",\r\n                "enumvalues": {\r\n                    "1": "YES",\r\n                    "0": "NO"\r\n                },\r\n                "buttonColors": {\r\n                    "1": "green",\r\n                    "0": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "customActions": {\r\n        "afterEditRecord": "Admincomponents::updateDomainStatus",\r\n        "afterAddRecord": "Admincomponents::updateDomainStatus"\r\n    },\r\n    "opertations": [\r\n        "add",\r\n      "edit",\r\n"delete"\r\n\r\n    ]\r\n}', '1', 5, 'all'),
	(14, 1, 'Plan Features', 'product_service_features', 'goStores_ServiceFeatures', '{\r\n"keyColumn": "nFeatureId",\r\n"orderBy": {\r\n    "nFeatureId": "DESC"\r\n},\r\n"detailHeaderColumns": ["tFeatureName"],\r\n"detailHeaderColumnPrefix": "Plan Feature: ",\r\n"listColumns": [\r\n    "tFeatureName",\r\n    "tValue",\r\n    "eStatus"\r\n],\r\n"showColumns": [\r\n    "nFeatureId",\r\n    "tFeatureName",\r\n    "tValue",\r\n    "eStatus"\r\n],\r\n"detailColumns": [\r\n    "nFeatureId",\r\n    "tFeatureName",\r\n    "tValue",\r\n    "eStatus"\r\n],\r\n"columns": {\r\n    "nFeatureId": {\r\n        "name": "ID",\r\n        "editoptions": {\r\n            "type": "hidden"\r\n        }\r\n    },\r\n    "tFeatureName": {\r\n        "name": "Name",\r\n        "sortable": "true",\r\n        "editoptions": {\r\n            "validations": [\r\n                    "required"\r\n                ],\r\n            "type": "textbox",\r\n            "label": "Name"\r\n        }\r\n    },\r\n    "tValue": {\r\n        "name": "Value",\r\n        "sortable": "true",\r\n        "editoptions": {\r\n            "validations": [\r\n                    "required"\r\n                ],\r\n            "type": "textbox",\r\n            "label": "Value"\r\n        }\r\n    },\r\n    "eStatus": {\r\n        "name": "Status",\r\n        "editoptions": {\r\n            "validations": [\r\n                    "required"\r\n                ],\r\n            "type": "select",\r\n            "source": {\r\n            "Active": "Active",\r\n            "Disabled": "Inactive"\r\n            },\r\n            "source_type": "array",\r\n            "label": "Status",\r\n            "class": "select",\r\n            "enumvalues": {\r\n                "Active": "Active",\r\n                "Disabled": "Inactive"\r\n            }\r\n        },\r\n        "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::changeServiceFeatureStatus",\r\n                "enumvalues": {\r\n                    "Active": "Active",\r\n                    "Disabled": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "Active": "green",\r\n                    "Disabled": "red"\r\n                }\r\n            }\r\n\r\n    }\r\n},\r\n"opertations": [\r\n    "view",\r\n    "edit",\r\n    "add"\r\n    ]\r\n}', '0', 0, 'all'),
	(16, 10, 'User Help ', 'userHelp', 'goStores_Help', '{\r\n    "keyColumn": "nId",\r\n"detailHeaderColumns":["vTitle"],\r\n    "orderBy": {\r\n        "vTitle": "ASC"\r\n    },\r\n    "where": "goStores_Help.eType=\'User\'",\r\n    "listColumns": [\r\n        "vTitle",\r\n        "eStatus"\r\n    ],\r\n    "showColumns": [\r\n        "nId",\r\n        "vTitle",\r\n        "tDescription",\r\n        "eType",\r\n        "eStatus"\r\n    ],\r\n    "detailColumns": [\r\n        "nId",\r\n        "vTitle",\r\n        "tDescription",\r\n        "eStatus",\r\n        "eType"\r\n    ],\r\n    "columns": {\r\n        "nId": {\r\n            "name": "ID"\r\n        },\r\n        "vTitle": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "tDescription": {\r\n            "name": "Description",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "htmlEditor",\r\n                "label": "Description"\r\n            }\r\n        },\r\n        "eType": {\r\n            "name": "Help Category",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "Admin": "Admin",\r\n                    "User": "User"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Category",\r\n                "enumvalues": {\r\n                    "Admin": "Admin",\r\n                    "User": "User"\r\n                }\r\n            }\r\n        },\r\n        "eStatus": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "Active": "Active",\r\n                    "Disabled": "Disabled"\r\n                },\r\n                "label": "Status",\r\n                "enumvalues": {\r\n                    "Active": "Active",\r\n                    "Disabled": "Disabled"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "edit",\r\n        "delete",\r\n        "view"\r\n    ]\r\n}', '1', 9, 'all'),
	(15, 1, 'Domains', 'domains', 'goStores_ProductLookup', '{\r\n    "keyColumn": "nPLId",\r\n    "dataSource": "external",\r\n    "dataSourceFunction": "Admincomponents::fetchDomaindata",\r\n    "dataSourceCountFunction": "Admincomponents::fetchDomaindataCount",\r\n    "detailHeaderColumns": [\r\n        "vDomain"\r\n    ],\r\n    "detailHeaderColumnPrefix": "Domain: ",\r\n    "listColumns": [\r\n        "vDomain",\r\n        "nUId",\r\n        "dDateStop",\r\n        "account_operations"\r\n    ],\r\n    "detailColumns": [\r\n        "nPLId",\r\n        "vDomain",\r\n        "nUId",\r\n       "dDateStop",\r\n        "account_operations"\r\n    ],\r\n    "columns": {\r\n        "nPLId": {\r\n            "name": "ID"\r\n        },\r\n        "vDomain": {\r\n            "name": "Domain",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getStoreHostWithAdminNav"\r\n        },\r\n        "nUId": {\r\n            "name": "User",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getUsername"\r\n        },\r\n        "dDateStop": {\r\n            "name": "Plan Expiry Date",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getPlanExpiryCms"\r\n        },\r\n         "account_operations": {\r\n            "name": "Account",\r\n"disableDetailedView":"false",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getAccountSuspendLink"\r\n            }\r\n    },\r\n    "opertations": [\r\n        "view"\r\n    ],\r\n    "includeJsFiles":["cmshelper.js"]\r\n\r\n}', '1', 5, 'all'),
	(18, 1, 'Service History', 'orders', 'goStores_Invoice ', '{"customAction":"true","controller":"service","method":"index","module":"admin"}', '1', 2, 'all'),
	(19, 10, 'Email Template', 'emailtemplates', 'goStores_Cms', '{\r\n"keyColumn": "cms_id",\r\n    "orderBy": {\r\n        "cms_id": "ASC"\r\n    },\r\n"where":"goStores_Cms.cms_type=\'email_settings\'",\r\n\r\n    "listColumns": [\r\n        "cms_name",\r\n        "cms_status"\r\n    ],\r\n    "showColumns": [\r\n        "cms_id",\r\n        "cms_name",\r\n        "cms_title",\r\n        "cms_desc",\r\n        "cms_status"\r\n    ],\r\n    "detailColumns": [\r\n        "cms_id",\r\n        "cms_name",\r\n        "cms_title",\r\n        "cms_desc",\r\n        "cms_status"\r\n    ],\r\n    "detailHeaderColumns": [\r\n        "cms_title"\r\n    ],\r\n    "columns": {\r\n        "cms_id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "cms_name": {\r\n            "name": "Name",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "cms_title": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "cms_desc": {\r\n            "name": "Content",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "htmlEditor",\r\n                "label": "Content",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "cms_status": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "edit"\r\n    ]\r\n}', '1', 5, 'all'),
	(20, 9, 'Banner Management', 'bannerManagement', 'goStores_Banners', '{\r\n    "keyColumn": "nBannerId",\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "nBannerId": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "eType",\r\n        "vBannerUrl",\r\n        "vBannerText",\r\n        "vBannerImageId",\r\n        "vActive",\r\n        "showcount",\r\n        "clickcount",\r\n        "displayOrder"\r\n    ],\r\n    "showColumns": [\r\n        "nBannerId",\r\n        "eType",\r\n        "vBannerText",\r\n        "vBannerUrl",\r\n        "vBannerImageId",\r\n        "vActive",\r\n        "showcount",\r\n        "clickcount",\r\n        "displayOrder"\r\n    ],\r\n    "detailColumns": [\r\n        "nBannerId",\r\n        "eType",\r\n        "vBannerUrl",\r\n        "vBannerText",\r\n        "vBannerImageId",\r\n        "vActive",\r\n        "showcount",\r\n        "clickcount",\r\n        "displayOrder"\r\n    ],\r\n    "columns": {\r\n        "eType": {\r\n            "name": "Banner Type",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "source": {\r\n                    "Header": "Home Page Sliding Banner",\r\n                    "Footer": "Footer"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Banner Type",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "Header": "Home Page Sliding Banner",\r\n                    "Footer": "Footer"\r\n                }\r\n            }\r\n        },\r\n        "vBannerUrl": {\r\n            "name": "Banner Url",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Banner Url"\r\n            }\r\n        },\r\n        "vBannerText": {\r\n            "name": "Banner Text",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Banner Text"\r\n            }\r\n        },\r\n        "vBannerImageId": {\r\n            "name": "Banner Image",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],             \r\n                "type": "file",\r\n                "label": "Banner Image",\r\n                "class": "file",\r\n                "hint": "Home Page Sliding Banner should be with : Width & Height - 1250px X 400px <br> Footer should be with: Width & Height - 468px X 60px"\r\n            },\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getCmsBannerImage"\r\n        },\r\n        "showcount": {\r\n            "name": "Impressions",\r\n            "sortable": "true"\r\n        },\r\n        "clickcount": {\r\n            "name": "Click  Count",\r\n            "sortable": "true"\r\n        },\r\n        "displayOrder": {\r\n            "name": "Display  Order",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Display Order"\r\n            }\r\n        },\r\n        "vActive": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "checkbox",\r\n                "label": "Enable Banner",\r\n                "default": "yes",\r\n                "enumvalues": {\r\n                    "0": "Inactive",\r\n                    "1": "Active"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::changeBannerStatus",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "1": "green",\r\n                    "0": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "edit",\r\n        "delete",\r\n        "publish"\r\n    ]\r\n}', '1', 3, 'all'),
	(21, 10, 'Email Scheduler', 'emailscheduler', 'goStores_EmailTemplatesMails', '{\r\n    "keyColumn": "nETMId",\r\n    "detailHeaderColumns": [\r\n        "vMailName"\r\n    ],\r\n    "detailHeaderColumnPrefix": "Email Scheduler: ",\r\n    "orderBy": {\r\n        "nETMId": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vMailName",\r\n        "nETID",\r\n        "tScheduleTime",\r\n        "eStatus",\r\n        "nMailMode"\r\n    ],\r\n    "detailColumns": [\r\n        "nETMId",\r\n        "vMailName",\r\n        "nETID",\r\n        "tScheduleTime",\r\n        "eStatus",\r\n        "nMailMode"\r\n    ],\r\n    "showColumns": [\r\n        "nETMId",\r\n        "vMailName",\r\n        "nETID",\r\n        "tScheduleTime",\r\n        "eStatus",\r\n        "nMailMode"\r\n    ],\r\n    "columns": {\r\n        "nETMId": {\r\n            "name": "ID",\r\n            "sortable": "true"\r\n        },\r\n        "vMailName": {\r\n            "name": "Mail Name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Mail Name",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "nETID": {\r\n            "name": "Email Template Name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": "Streamsendlogic::getemailTemplateList",\r\n                "source_type": "function",\r\n                "label": "EmailTemplate Name",\r\n                "class": "select"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "goStores_EmailTemplates",\r\n                "externalColumn": "nETID",\r\n                "externalShowColumn": "vemailTemplateName"\r\n            }\r\n        },\r\n        "tScheduleTime": {\r\n            "name": "Schedule Time",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "datepicker",\r\n                "label": "Schedule Time",\r\n                "class": "datepicker",\r\n                "dbFormat": "datetime",\r\n                "displayFormat": "m/d/Y"\r\n            }\r\n        },\r\n        "eStatus": {\r\n            "name": "Status",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "hidden",\r\n                "class": "hidden",\r\n                "value": "Active"\r\n                \r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::changeEmailSchedulerStatus",\r\n                "enumvalues": {\r\n                    "Active": "Active",\r\n                    "Deactive": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "Active": "green",\r\n                    "Deactive": "red"\r\n                }\r\n            }\r\n        },\r\n        "nMailMode": {\r\n            "name": "Mail Mode",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden",\r\n                "class": "hidden",\r\n                "value": "Streamsend"\r\n            }\r\n        }\r\n    },\r\n    "customActions": {\r\n        "afterAddRecord": "Streamsendlogic::setScheduleMail",\r\n        "afterEditRecord": "Streamsendlogic::setScheduleMailEdit"\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "add",\r\n        "delete"\r\n    ]\r\n}', '1', 2, 'all'),
	(22, 1, 'Billing', 'billing', 'goStores_User', '{\r\n    "keyColumn": "nUId",\r\n    "orderBy": { "vFirstName": "ASC"},\r\n    "listColumns": ["vName","vEmail","vInvoiceEmail","vPlan","vStatus"],\r\n    "detailColumns": ["nUId","vName","vEmail","vInvoiceEmail","vPlan","vStatus"],\r\n    "columns": {\r\n        "nUId": {},\r\n        "vName": { "name": "Name","customColumn": "true","customaction": "User::getNameById"},\r\n        "vEmail": {"name": "Email","searchable": "searchable","sortable": "true"},\r\n        "vInvoiceEmail": {"name": "Invoice Email","searchable": "searchable","sortable": "true"},\r\n        "vPlan": {"name": "Plans","customColumn": "true","customaction": "Admincomponents::getUserPlansForCmsListing"},\r\n        "vStatus": {"name": "User Status","customColumn": "true","customaction": "User::getUserStatusById"}\r\n    },\r\n    "opertations": ["view"]\r\n}', '0', 4, 'all'),
	(23, 1, 'User Plans', 'user_plans', 'goStores_ProductServices', '{"customAction":"true","controller":"products","method":"listuserplans","module":"admin"}', '0', 0, 'all'),
	(24, 9, 'Paid Templates', 'paid_templates', 'goStores_PaidTemplates', '{\r\n    "keyColumn": "nTemplateId",\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "vTemplateName": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "vTemplateName",\r\n        "vTemplateZipId",\r\n        "vHomeScreenshotId",\r\n        "vInnerScreenshot1Id",\r\n        "vInnerScreenshot2Id",\r\n        "nCost",\r\n        "vActive"\r\n    ],\r\n    "showColumns": [\r\n        "nTemplateId",\r\n        "vTemplateName",\r\n        "vDescription",\r\n        "vTemplateZipId",\r\n        "vHomeScreenshotId",\r\n        "vInnerScreenshot1Id",\r\n        "vInnerScreenshot2Id",\r\n        "nCost",\r\n        "vActive"\r\n    ],\r\n    "detailColumns": [\r\n        "nTemplateId",\r\n        "vTemplateName",\r\n        "vDescription",\r\n        "vTemplateZipId",\r\n        "vHomeScreenshotId",\r\n        "vInnerScreenshot1Id",\r\n        "vInnerScreenshot2Id",\r\n        "nCost",\r\n        "vActive"\r\n    ],\r\n    "columns": {\r\n        "vTemplateName": {\r\n            "name": "Template Name",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Template Name"\r\n            }\r\n        },\r\n        "vDescription": {\r\n            "name": "Description",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Description"\r\n            }\r\n        },\r\n        "vTemplateZipId": {\r\n            "name": "Template Zip",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::downloadTemplateZip",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Template Zip",\r\n                "class": "file",\r\n                "hint": "Upload type : .zip file with folders img/TemplateName/ with images and css/ with TemplateName.css file"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "goStores_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n         "vHomeScreenshotId": {\r\n            "name": "Home Page Screenshot",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Home Page Screenshot",\r\n                "class": "file",\r\n                "hint": "Ideal size 295x235"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "goStores_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n         "vInnerScreenshot1Id": {\r\n            "name": "Inner Page Screenshot 1",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Inner Page Screenshot1",\r\n                "class": "file",\r\n                "hint": "Ideal size 295x235"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "goStores_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n         "vInnerScreenshot2Id": {\r\n            "name": "Inner Page Screenshot 2",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Inner Page Screenshot 2",\r\n                "class": "file",\r\n                "hint": "Ideal size 295x235"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "goStores_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "nCost": {\r\n            "name": "Price",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "listHeaderPostfix": "Admincomponents::getCurrencySymbolForCms",\r\n            "lsHeaderPostfixCustom": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Price",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n                \r\n            }\r\n            \r\n        },\r\n        "vActive": {\r\n            "name": "Publish",\r\n            "editoptions": {\r\n                "type": "checkbox",\r\n                "label": "Enable Template",\r\n                "default": "yes",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "edit",\r\n        "delete",\r\n        "publish"\r\n    ]\r\n}', '1', 5, 'all'),
	(25, 9, 'Themes', 'themes', 'goStores_themes', '{\r\n    "keyColumn": "theme_id",\r\n    "orderBy": {\r\n        "theme_id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "theme_title",\r\n        "theme_name",\r\n        "theme_status",\r\n        "theme_thumbnail"\r\n    ],\r\n    "showColumns": [\r\n        "theme_id",\r\n        "theme_title",\r\n        "theme_name",\r\n        "theme_status"\r\n    ],\r\n    "detailColumns": [\r\n        "theme_id",\r\n        "theme_title",\r\n        "theme_name",\r\n        "theme_status",\r\n        "theme_thumbnail"\r\n    ],\r\n    "columns": {\r\n        "theme_id": {},\r\n        "theme_title": {\r\n            "name": "Theme Title",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "disabled",\r\n                "label": "Theme Title"\r\n            }\r\n        },\r\n        "theme_name": {\r\n            "name": "Theme Name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "disabled",\r\n                "label": "Theme Name"\r\n            }\r\n            \r\n        },\r\n        "theme_status": {\r\n            "name": "Theme Status",\r\n            "editoptions": {\r\n                "type": "checkbox",\r\n                "label": "Enable Theme",\r\n                "enumvalues": {\r\n                    "0": "Inactive",\r\n                    "1": "Active"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::changeThemeStatus",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "1": "green",\r\n                    "0": "red"\r\n                }\r\n            }\r\n        },\r\n        "theme_thumbnail": {\r\n            "name": "Thumbnail",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::showthumbnail"\r\n        }\r\n    },\r\n    "customActions": {\r\n        "afterEditRecord": "Admincomponents::statusUpdate"\r\n    },\r\n    "opertations": [\r\n        "edit"\r\n    ]\r\n}', '1', 6, 'all'),
	(26, 1, 'Settlements', 'settlements', 'goStores_BillingSettlement', '{\r\n    "keyColumn": "nId",\r\n    "orderBy": {\r\n        "dCreatedOn": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "nUId",\r\n        "nRequestedAmount",\r\n        "tUserComments",\r\n        "dCreatedOn",\r\n        "eStatus"\r\n    ],\r\n    "showColumns": [\r\n        "nId",\r\n        "nSettledAmount",\r\n        "tAdminComments",\r\n        "eStatus"\r\n    ],\r\n    "detailColumns": [\r\n        "nId",\r\n        "nUId",\r\n        "nRequestedAmount",\r\n        "tUserComments",\r\n        "nSettledAmount",\r\n        "tAdminComments",\r\n        "dCreatedOn",\r\n        "eStatus"\r\n    ],\r\n    "columns": {\r\n        "nId": {\r\n            "name": "Settlement Id",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "nUId": {\r\n            "name": "User",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "goStores_User",\r\n                "externalColumn": "nUId",\r\n                "externalShowColumn": "vUsername"\r\n            }\r\n        },\r\n        "nRequestedAmount": {\r\n            "name": "Requested Amount"\r\n        },\r\n        "tUserComments": {\r\n            "name": "Comments"\r\n        },\r\n        "dCreatedOn": {\r\n            "name": "Sent On",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n        "eStatus": {\r\n            "name": "Status",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "source_type": "array",\r\n                "source": {\r\n                    "Pending": "Pending",\r\n                    "Approved": "Approved",\r\n                    "Rejected": "Rejected"\r\n                },\r\n                "type": "select",\r\n                "label": "Status",\r\n                "class": "select"\r\n            }\r\n        },\r\n        "nSettledAmount": {\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Settled Amount",\r\n                "class": "textbox"\r\n            },\r\n            "name": "Settled Amount"\r\n        },\r\n        "tAdminComments": {\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textarea",\r\n                "label": "Comments",\r\n                "class": "textarea"\r\n            },\r\n            "name": "Admin Comments"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit"\r\n    ],\r\n    "report": {\r\n        "reportTitle": "Settlements",\r\n        "columns": [\r\n            "nUId",\r\n            "nRequestedAmount",\r\n            "tUserComments",\r\n            "nSettledAmount",\r\n            "tAdminComments",\r\n            "dCreatedOn",\r\n            "eStatus"\r\n        ],\r\n        "dateColumn": "dCreatedOn"\r\n    }\r\n}', '0', 4, 'all'),
	(27, 9, 'Support', 'support', 'goStores_BillingSettlement', '{"customAction":"true","controller":"index","method":"gotosupport","module":"admin"}', '1', 8, 'all'),
	(28, 1, 'Service Details', 'service_details', 'goStores_ProductServices', '{"customAction":"true","controller":"service","method":"servicedetails","module":"admin"}', '0', 6, 'all'),
	(29, 1, 'User', 'domain_user_tag', 'goStores_User', '{\r\n    "keyColumn": "nUId",\r\n    "orderBy": {\r\n        "vFirstName": "ASC"\r\n    },\r\n    "reference": {\r\n        "referenceTable": "goStores_ProductLookup",\r\n        "referenceColumn": "nUId",\r\n        "referenceTableForiegnKey": "nUId"\r\n    },\r\n    "listColumns": [\r\n        "vFirstName",\r\n        "vLastName",\r\n        "vEmail"\r\n    ],\r\n    "detailColumns": [\r\n        "nUId",\r\n        "vFirstName",\r\n        "vLastName",\r\n        "vEmail"\r\n    ],\r\n    "showColumns": [\r\n        "nUId",\r\n        "vFirstName",\r\n        "vLastName",\r\n        "vEmail"\r\n    ],\r\n    "columns": {\r\n        "nUId": {\r\n            "name": "ID"\r\n        },\r\n        "vFirstName": {\r\n            "name": "First name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "First Name",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vLastName": {\r\n            "name": "Last name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Last Name",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vEmail": {\r\n            "name": "Email",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Email",\r\n                "class": "textbox"\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view"\r\n    ]\r\n}', '0', 0, 'all'),
	(30, 1, 'Invoice Details', 'invoice_details', 'goStores_Invoice', '{"customAction":"true","controller":"service","method":"invoicedetails","module":"admin"}', '0', 0, 'all'),
	(31, 10, 'Contents', 'static_content', 'goStores_Cms', '{\r\n"keyColumn": "cms_id",\r\n    "orderBy": {\r\n        "cms_id": "ASC"\r\n    },\r\n"where":"goStores_Cms.cms_type=\'cms\'",\r\n\r\n    "listColumns": [\r\n        "cms_name",\r\n        "cms_title",\r\n        "cms_status"\r\n    ],\r\n    "showColumns": [\r\n        "cms_id",\r\n        "cms_name",\r\n        "cms_title",\r\n        "cms_desc",\r\n        "cms_status"\r\n    ],\r\n    "detailColumns": [\r\n        "cms_id",\r\n        "cms_name",\r\n        "cms_title",\r\n        "cms_desc",\r\n        "cms_status"\r\n    ],\r\n    "detailHeaderColumns": [\r\n        "cms_title"\r\n    ],\r\n    "detailHeaderColumnPrefix": "Content: ",\r\n    "columns": {\r\n        "cms_id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "cms_name": {\r\n            "name": "Page Name",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "cms_title": {\r\n            "name": "Display Title",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "cms_desc": {\r\n            "name": "Content",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "htmlEditor",\r\n                "label": "Content",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "cms_status": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::changeContentStatus",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "1": "green",\r\n                    "0": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "edit",\r\n        "view"\r\n    ]\r\n}', '1', 2, 'all'),
	(33, 1, 'Coupons', 'coupons', ' goStores_Coupon', '{\r\n    "keyColumn": "nCouponId",\r\n    "orderBy": {\r\n        "dCreatedOn": "DESC"\r\n    },\r\n    "detailHeaderColumns": ["vCouponCode"],\r\n    "detailHeaderColumnPrefix": "Coupon: ",\r\n    "listColumns": [\r\n        "vCouponCode",\r\n        "vPricingMode",\r\n        "nCouponValue",\r\n        "dExpireOn",\r\n        "nCouponCount",\r\n        "nCouponUsed"\r\n    ],\r\n    "showColumns": [\r\n        "nCouponId",\r\n        "vCouponCode",\r\n        "nCouponCount",\r\n        "vPricingMode",\r\n        "nCouponValue",\r\n        "dCreatedOn",\r\n        "dExpireOn",\r\n        "vCouponDescription"\r\n    ],\r\n    "detailColumns": [\r\n        "nCouponId",\r\n        "vCouponCode",\r\n        "vCouponDescription",\r\n        "vPricingMode",\r\n        "nCouponValue",\r\n        "dCreatedOn",\r\n        "dExpireOn",\r\n        "nCouponCount",\r\n        "nCouponUsed"\r\n    ],\r\n    "columns": {\r\n        "nCouponId": {\r\n            "name": "ID",\r\n            "editoptions":{"type":"hidden"}\r\n        },\r\n        "nCouponUsed": {\r\n            "name": "Number Of Coupons Used"\r\n        },\r\n        "vCouponCode": {\r\n            "name": "Coupon Name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions":{"validations":["required"],"type":"textbox","label":"Coupon Name","class":"textbox"}\r\n        },\r\n        "nCouponCount": {\r\n            "name": "Number Of Coupons",\r\n            "sortable": "true",\r\n            "editoptions":{"validations":["required"],"type":"textbox","label":"Number of Coupons","class":"textbox"}\r\n        },\r\n        "dCreatedOn": {\r\n            "name": "Created Date",\r\n            "editoptions":{"validations":["required"],"type":"datepicker","label":"Created Date","class":"textbox","dbFormat":"date","displayFormat":"m/d/Y"}\r\n        },\r\n        "dExpireOn": {\r\n            "name": "Expiry Date",\r\n            "sortable": "true",\r\n            "editoptions":{"validations":["required"],"type":"datepicker","label":"Expiry Date","class":"textbox","dbFormat":"date","displayFormat":"m/d/Y"}\r\n        },\r\n        "vPricingMode": {\r\n            "name": "Pricing Mode",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions":{\r\n                "validations":["required"],\r\n                "type":"select",\r\n                "label":"Pricing Mode",\r\n                "class":"select",\r\n                "source":{"percentage":"Percentage","rate":"Rate"},\r\n                "source_type":"array",\r\n                "enumvalues":{"percentage":"Percentage","rate":"Rate"}\r\n            }\r\n        },\r\n        "nCouponValue": {\r\n            "name": "Coupon Value",\r\n            "sortable": "true",\r\n            "editoptions":{"validations":["required"],"type":"textbox","label":"Coupon Value","class":"textbox"}\r\n        },\r\n        "vCouponDescription": {\r\n            "name": "Description",\r\n            "sortable": "true",\r\n            "editoptions":{"type":"textbox","label":"Description","class":"textbox"}\r\n        }\r\n\r\n    },\r\n    "opertations": [\r\n        "add","edit","delete","view"\r\n    ],\r\n    "report": {\r\n        "reportTitle": "Coupons",\r\n        "columns": [\r\n            "vCouponCode",\r\n            "vPricingMode",\r\n            "nCouponValue",\r\n            "dCreatedOn",\r\n            "dExpireOn",\r\n            "nCouponCount",\r\n            "nCouponUsed",\r\n            "vCouponDescription"\r\n        ],\r\n        "dateColumn": "dCreatedOn"\r\n    }\r\n}', '1', 9, 'all'),
	(34, 10, 'Email Content', 'email_content', 'goStores_Cms', '{\r\n"keyColumn": "cms_id",\r\n    "orderBy": {\r\n        "cms_id": "ASC"\r\n    },\r\n"where":"goStores_Cms.cms_type=\'email\'",\r\n\r\n    "listColumns": [\r\n        "cms_name",\r\n        "cms_title",\r\n        "cms_status"\r\n    ],\r\n    "showColumns": [\r\n        "cms_id",\r\n        "cms_name",\r\n        "cms_title",\r\n        "cms_desc",\r\n        "cms_status"\r\n    ],\r\n    "detailColumns": [\r\n        "cms_id",\r\n        "cms_name",\r\n        "cms_title",\r\n        "cms_desc",\r\n        "cms_status"\r\n    ],\r\n    "detailHeaderColumns": [\r\n        "cms_title"\r\n    ],\r\n    "columns": {\r\n        "cms_id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "cms_name": {\r\n            "name": "Name",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "cms_title": {\r\n            "name": "Subject",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Subject",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "cms_desc": {\r\n            "name": "Content",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "htmlEditor",\r\n                "label": "Content",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "cms_status": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "edit",\r\n        "view",\r\n        "add"\r\n    ]\r\n}\r\n\r\n', '1', 6, 'all'),
	(35, 1, 'Settlement Request', 'settlement_request', 'goStores_BillingSettlement', '{\r\n    "keyColumn": "nId",\r\n    "orderBy": {\r\n        "dCreatedOn": "DESC"\r\n    },\r\n    "detailHeaderColumns": ["nUId"],\r\n    "detailHeaderColumnPrefix": "Request From: ",\r\n    "listColumns": [\r\n        "nUId",\r\n        "nRequestedAmount",\r\n        "tUserComments",\r\n        "eStatus",\r\n		"dCreatedOn"\r\n    ],\r\n    "detailColumns": [\r\n        "nId",\r\n        "nUId",\r\n        "nRequestedAmount",\r\n        "tUserComments",\r\n        "eStatus",\r\n		"dCreatedOn"\r\n    ],\r\n    "columns": {\r\n    "nId":{"name":"ID"},\r\n        "nUId": {\r\n            "name": "Customer",\r\n            "sortable": "true",\r\n			"customColumn": "true",\r\n			"customaction": "Admincomponents::getUsernameOfSettledRequest"\r\n        },\r\n        "nRequestedAmount": {\r\n            "name": "Request Amount",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n"listHeaderPostfix": "Admincomponents::getCurrencySymbolForCms",\r\n"lsHeaderPostfixCustom": "true"\r\n        },\r\n        "tUserComments": {\r\n            "name": "Comment",\r\n            "sortable": "true"\r\n        },\r\n        "eStatus": {\r\n            "name": "Status",\r\n            "sortable": "true"\r\n        },\r\n		"dCreatedOn": {\r\n            "name": "Requested On",\r\n            "sortable": "true",\r\n			"dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "delete"\r\n    ]\r\n}', '1', 9, 'all'),
	(39, 10, 'Meta Tags', 'meta_tags', 'fw_metadata', '{\r\n "keyColumn": "id",\r\n "detailHeaderColumnPrefix": "Meta Tag : ",\r\n    "detailHeaderColumns": [\r\n        "url"\r\n    ],\r\n    "orderBy": {\r\n        "id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "url",\r\n        "title",\r\n        "keyword"\r\n    ],\r\n    "showColumns": [\r\n        "id",\r\n        "url",\r\n        "title",\r\n        "keyword",\r\n        "description"\r\n    ],\r\n    "detailColumns": [\r\n        "id",\r\n        "url",\r\n        "title",\r\n        "keyword",\r\n        "description"\r\n    ],\r\n    "columns": {\r\n        "id": {\r\n            "name": "ID",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "title": {\r\n            "name": "Meta Title",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Meta Title",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "keyword": {\r\n            "name": "Meta Keywords",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Meta Keywords",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "description": {\r\n            "name": "Meta Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Meta Description",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "url": {\r\n            "name": "Page Url",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "label": "Page Url",\r\n                "type": "textbox",\r\n                "class": "textbox",\r\n                "hint":"<b>Url combinations can be : </b><br/><b style=\'color:red\'> /abc/</b> [exact location abc after your domain name] eg : www.domainname.com/abc/ ,<br/> <b style=\'color:red\'>/abc/* </b> [any combination after location abc after your domain name] eg : www.domainname.com/abc/test1,<br/> <b style=\'color:red\'>* </b>[default value] ",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '1', 2, 'all'),
	(37, 10, 'Newsletter Template', 'newsletter_template', 'goStores_EmailTemplates', '{\r\n"keyColumn": "nETId",\r\n"detailHeaderColumns":["vemailTemplateName"],\r\n"detailHeaderColumnPrefix": "Newsletter Template: ",\r\n    "orderBy": {\r\n        "nETId": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vemailTemplateName",\r\n        "estatus"\r\n    ],\r\n    "detailColumns": [\r\n        "nETId",\r\n        "vemailTemplateName",\r\n        "temailTemplate",\r\n        "estatus"\r\n    ],\r\n    "showColumns": [\r\n        "nETId",\r\n        "vemailTemplateName",\r\n        "temailTemplate",\r\n        "estatus"\r\n    ],\r\n    "columns": {\r\n        "nETId": {\r\n            "name": "ID",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vemailTemplateName": {\r\n            "name": "Template Name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Template Name",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "temailTemplate": {\r\n            "name": "Template",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "htmlEditor",\r\n                "label": "Template",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "estatus": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "validations": [\r\n                        "required"\r\n                    ],\r\n                "type": "select",\r\n                "source": {\r\n                    "Active": "Active",\r\n                    "Inactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "Active": "Active",\r\n                    "Inactive": "Inactive"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                    "type": "button",\r\n                    "customaction": "Admin::changeNewsletterScheduleStatus",\r\n                    "enumvalues": {\r\n                        "Active": "Active",\r\n                        "Inactive": "Inactive"\r\n                    },\r\n                    "buttonColors": {\r\n                        "Active": "green",\r\n                        "Inactive": "red"\r\n                    }\r\n                }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "add",\r\n        "delete"\r\n    ]\r\n}', '1', 3, 'all'),
	(38, 1, 'godaddycertify', 'godaddycertify', 'test', '{"customAction":"true","controller":"module","method":"godaddycertify","module":"admin"}\r\n', '0', 1, 'all'),
	(41, 1, 'Domain Renewal Log', 'domain_renewal_log', 'goStores_DomainRenewalLog', '{\r\n    "keyColumn": "id",\r\n     "orderBy": {\r\n                "createdOn": "DESC"\r\n                },\r\n    "detailHeaderColumns": ["vDomain"],\r\n    "detailHeaderColumnPrefix": "Domain Renewal Log for : ",\r\n\r\n    "listColumns": [\r\n        "vDomain",\r\n                    "nUId",\r\n                    "comments",\r\n                    "expireOn",\r\n                    "createdOn",\r\n                    "lastModified",\r\n                    "actionRenew"\r\n    ],\r\n    "detailColumns": [\r\n        "vDomain",\r\n                    "nUId",\r\n                    "comments",\r\n                    "expireOn",\r\n                    "createdOn",\r\n                    "lastModified",\r\n                    "actionRenew"\r\n    ],\r\n    "columns": {\r\n   "vDomain":{\r\n                "name":"Domain",\r\n                "sortable": "true",\r\n                "searchable": "searchable"\r\n                },\r\n       "nUId": {\r\n                "name": "Customer",\r\n                "sortable": "true",\r\n                "customColumn": "true",\r\n                "customaction": "Admincomponents::getUsernameOfSettledRequest",\r\n                "sortable": "true",\r\n                "searchable": "searchable"\r\n            },\r\n       "comments": {\r\n            "name": "Status",\r\n            "sortable": "true",\r\n            "searchable": "searchable"\r\n        },\r\n "expireOn": {\r\n            "name": "Domain Expiry Date",\r\n            "sortable": "true",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y",\r\n            "sortable": "true",\r\n            "searchable": "searchable"\r\n        },\r\n         "createdOn": {\r\n            "name": "Log Created On",\r\n            "sortable": "true",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y",\r\n            "sortable": "true",\r\n            "searchable": "searchable"\r\n        },\r\n       "lastModified": {\r\n            "name": "Log Modified On",\r\n            "sortable": "true",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y",\r\n            "sortable": "true",\r\n            "searchable": "searchable"\r\n        },\r\n            "actionRenew": {\r\n            "name": "Action",\r\n            "disableDetailedView":"false",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getDomainRenewalLink"\r\n            }\r\n    },\r\n    "opertations": [\r\n        "view"\r\n    ],\r\n    "includeJsFiles":["cmshelper.js"]\r\n}', '1', 10, 'all'),
	(42, 1, 'Sold Template History', 'sold_templates', 'goStores_PaidTemplatePurchase', '{\r\n    "keyColumn": "id",\r\n    "orderBy": {\r\n        "paidOn": "DESC"\r\n    },\r\n    "listColumns": [\r\n\r\n        "nTemplateId",\r\n        "nUId",\r\n        "nPLId",\r\n        "amount",\r\n        "paymentMethod",\r\n        "transactionId",\r\n        "comments",\r\n        "paidOn"\r\n    ],\r\n    "showColumns": [\r\n\r\n        "nTemplateId",\r\n        "nUId",\r\n        "nPLId",\r\n        "amount",\r\n        "paymentMethod",\r\n        "transactionId",\r\n        "comments",\r\n        "paidOn"\r\n    ],\r\n    "detailHeaderContent": "Sold Template",\r\n    "detailColumns": [\r\n\r\n        "nTemplateId",\r\n        "nUId",\r\n        "nPLId",\r\n        "amount",\r\n        "paymentMethod",\r\n        "transactionId",\r\n        "comments",        \r\n        "paidOn"\r\n    ],\r\n    "columns": {\r\n        "nTemplateId": {\r\n            "name": "Template Name",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "external": "true",\r\n            "externalOptions": {\r\n            "externalTable": "goStores_PaidTemplates",\r\n            "externalColumn": "nTemplateId",\r\n            "externalShowColumn": "vTemplateName"}\r\n        },\r\n        "nUId": {\r\n            "name": "User",\r\n            "sortable": "true",\r\n            "customColumn": "true",\r\n	    "customaction": "Admincomponents::getUsernameOfSoldTemplateCMS"\r\n        },\r\n        "nPLId": {\r\n            "name": "Store",\r\n            "sortable": "true",\r\n            "customColumn": "true",\r\n	    "customaction": "Admincomponents::getStoreHostForSoldTemplatePurchaseCms"\r\n        },\r\n        "amount": {\r\n            "name": "Amount",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "listHeaderPostfix": "($)"\r\n        },\r\n        "paymentMethod": {\r\n            "name": "Payment Method",\r\n            "sortable": "true",\r\n            "searchable": "true"\r\n        },\r\n         "transactionId": {\r\n            "name": "Transaction Id",\r\n            "sortable": "true",\r\n            "searchable": "true"\r\n        },\r\n        "comments": {\r\n            "name": "Status",\r\n            "sortable": "true",\r\n            "searchable": "true"\r\n        },\r\n        "paidOn": {\r\n            "name": "Purchase Date",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getSoldTemplatePurchaseDateCms"\r\n        }\r\n\r\n\r\n\r\n    },"opertations": [\r\n        "view"]\r\n\r\n}', '1', 10, 'all');

INSERT INTO `cms_users` (`id`, `type`, `username`, `password`, `status`) VALUES
(1, 'sadmin', 'sadmin', 'c5edac1b8c1d58bad90a246d8f08f53b ', 'active'),
(2, 'admin', 'admin', '21232f297a57a5a743894a0e4a801fc3 ', 'active');

INSERT INTO `goStores_Cms` (`cms_id`, `cms_name`, `cms_ref_title`, `cms_type`, `cms_title`, `cms_desc`, `cms_shortdesc`, `cms_status`) VALUES
	(2, 'aboutus', '', 'cms', 'About Us', '', '', 1),
	(3, 'USER_REGISTRATION', '', 'email', 'User Registration', '<p>Hi {USERNAME},</p> <p>Your {SITE_NAME} account setup completed. Please find your details below</p> <p>Login&#160; Address: {USEREMAIL}</p> <p>Password : {USERPASSWORD}</p> <p>&#160;</p> <p>Thanks</p> <p>{SITE_NAME} Team</p>', '', 1),
	(5, 'LOGIN_CREDENTIALS_CHANGE', '', 'email', 'Changed Login Credentials {SITE_NAME}', '<p>\r\n	Dear {MEMBER_NAME},</p>\r\n<br />\r\n<br />\r\n<table border="0" cellpadding="4" cellspacing="1" width="100%">\r\n	<tbody>\r\n		<tr bgcolor="#ffffff">\r\n			<td align="left" colspan="2">\r\n				Welcome to {SITE_NAME}.<br />\r\n				<b><u>Your changed account details as follows :</u></b></td>\r\n		</tr>\r\n		<tr bgcolor="#ffffff">\r\n			<td align="left" width="14%">\r\n				User Name</td>\r\n			<td width="86%">\r\n				{USER_NAME}</td>\r\n		</tr>\r\n		<tr bgcolor="#ffffff">\r\n			<td align="left">\r\n				Password</td>\r\n			<td>\r\n				{PASSWORD}</td>\r\n		</tr>\r\n		<tr bgcolor="#ffffff">\r\n			<td align="left" colspan="2">\r\n				<b><u>Click the following link to login to your account :</u></b></td>\r\n		</tr>\r\n		<tr bgcolor="#ffffff">\r\n			<td align="left" colspan="2">\r\n				{LOGIN_LINK}</td>\r\n		</tr>\r\n		<tr bgcolor="#ffffff">\r\n			<td align="left" colspan="2">\r\n				Thank You,</td>\r\n		</tr>\r\n		<tr bgcolor="#ffffff">\r\n			<td align="left" colspan="2">\r\n				{SITE_URL}</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', '', 1),
	(6, 'forgotpassword', '', 'email', 'Changed Login Credentials {SITE_NAME}', '<p>\r\n	Dear {MEMBER_NAME},</p>\r\n<br />\r\n<br />\r\n<table border=\\"0\\" cellpadding=\\"4\\" cellspacing=\\"1\\" width=\\"100%\\">\r\n	<tbody>\r\n		<tr bgcolor=\\"#ffffff\\">\r\n			<td align=\\"left\\" colspan=\\"2\\">\r\n				Welcome to {SITE_NAME}.<br />\r\n				<b><u>Your changed account details as follows :</u></b></td>\r\n		</tr>\r\n		<tr bgcolor=\\"#ffffff\\">\r\n			<td align=\\"left\\" width=\\"14%\\">\r\n				User Name</td>\r\n			<td width=\\"86%\\">\r\n				{USER_NAME}</td>\r\n		</tr>\r\n		<tr bgcolor=\\"#ffffff\\">\r\n			<td align=\\"left\\">\r\n				Password</td>\r\n			<td>\r\n				{PASSWORD}</td>\r\n		</tr>\r\n		<tr bgcolor=\\"#ffffff\\">\r\n			<td align=\\"left\\" colspan=\\"2\\">\r\n				<b><u>Click the following link to login to your account :</u></b></td>\r\n		</tr>\r\n		<tr bgcolor=\\"#ffffff\\">\r\n			<td align=\\"left\\" colspan=\\"2\\">\r\n				{ACTIVATION_LINK}</td>\r\n		</tr>\r\n		<tr bgcolor=\\"#ffffff\\">\r\n			<td align=\\"left\\" colspan=\\"2\\">\r\n				Thank You,</td>\r\n		</tr>\r\n		<tr bgcolor=\\"#ffffff\\">\r\n			<td align=\\"left\\" colspan=\\"2\\">\r\n				{SITE_URL}</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', '', 1),
	(8, 'contactus', '', 'cms', 'Contact Us', '\r\n', '', 1),
	(10, 'forgotpasswordemail', '', 'email', 'Forgot Password', '<p>Hi {USERNAME},</p> <p>We have received  your password reset request.</p><p>{PASSWORDLINK}</p>  <p>Thanks</p>  <p>{SITE_NAME} Team</p>', '', 1),
	(14, 'invoice', '', 'email', 'Purchase Details {SITE_NAME}', '<p>Dear {MEMBER_NAME},<br> 	<br> 	Thank you for the interest shown in {COMPANY_NAME}.<br> 	The following is the invoice details, not receipt in regard to the purchase with {COMPANY_NAME}.</p>', '', 1),
	(13, 'disclaimernotice', '', 'cms', 'Disclaimer Notice', '', '', 1),
	(15, 'free_trial_expiry_notification', '', 'email', 'Your {SITE_NAME} {PRODUCT_NAME} Free Trial will expire on {EXPIRY_DATE}', '<p>\r\n	Dear {MEMBER_NAME},<br />\r\n	<br />\r\n	Your {SITE_NAME} {PRODUCT_NAME} Free Trial will expire on {EXPIRY_DATE}.<br />\r\n	Hurry up! login to your account and upgrade the service to avail the site in {SITE_NAME} environment.</p>\r\n<p>\r\n	{SITE_NAME} Team</p>', '', 1),
	(16, 'free_trial_expired_notification', '', 'email', 'Your {SITE_NAME} {PRODUCT_NAME} Free Trial  expired', '<p>\r\n	Dear {MEMBER_NAME},<br />\r\n	<br />\r\n	Your {SITE_NAME} {PRODUCT_NAME} Free Trial has expired on {EXPIRY_DATE}.<br />\r\n	Hurry up! login to your account and upgrade the service immediately to avail the site in {SITE_NAME} environment.</p>\r\n<p>\r\n	{SITE_NAME} Team</p>', '', 1),
	(19, 'email_template', '', 'email_settings', 'Email Template', '<table width="600" cellspacing="0" cellpadding="0" border="0" style="border:1px solid #ccc;background-color:#fdfdfd">      <tbody>         <tr>             <td height="5" colspan="3">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table width="100%" cellspacing="0" cellpadding="0" border="0">                     <tbody>                         <tr>                             <td height="56"><table width="100%" cellspacing="0" cellpadding="0" border="0">                                     <tbody>                                         <tr>                                             <td width="2%" height="80">&#160;</td>                                             <td width="37%"><img height="40" src="{SITE_LOGO}" alt=""></td>                                             <td width="61%"><p style="font-family:Arial,Helvetica,sans-serif;font-size:12px;color:#cccccc;text-align:right;padding:0 15px 0 0">{DATE}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table width="100%" cellspacing="0" cellpadding="0" border="0">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%">{MAIL_CONTENT}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                                                             </tbody>                                 </table></td>                         </tr>                                             </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td height="10" colspan="3">&#160;</td>         </tr>     </tbody> </table>', '', 1),
	(20, 'bill_notification', '', 'email', 'Your {SITE_NAME} {PRODUCT_NAME} Service bill is due for payment on {PAYMENT_DATE}', '<p>\r\n	Dear {MEMBER_NAME},<br />\r\n	<br />\r\n	Your {SITE_NAME} {PRODUCT_NAME} Service bill is due for payment of {AMOUNT} on {PAYMENT_DATE}. Auto payment will be made in regard to the billing information you provided. Please make the changes if any, by logging in to your account prior to the payment date.<br />\r\n	Thank you for the interest shown in {COMPANY_NAME}.</p>\r\n<p>\r\n	{SITE_NAME} Team</p>', '', 1),
	(23, 'features', '', 'cms', 'Features', '<h3></h3><h5><span style="font-size: medium;"><span style="font-family: Arial, serif; color: rgb(102, 102, 102); line-height: 100%;">Your store will be equipped with similar features to Volusion.com and Shopify.com.</span></span></h5><h5><span style="font-size: medium;"><span style="font-family: Arial, serif; color: rgb(102, 102, 102); line-height: 100%;">Edit this page to let visitors know why they should use your site to build an online store. Sample:</span></span><font color="#666666"><font face="Arial, serif"><br></font></font></h5><br> 	<p></p><ul> 	<li><p style="margin-top: 0.05cm; margin-bottom: 0.05cm;"><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">No 	programming required. We believe you shouldnâ€™t have to know coding 	or pay a lot for a website to get your online business started.</font></font></span></p></li><li><p style="margin-top: 0.05cm; margin-bottom: 0.05cm;"><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Integrated 	help desk system for supporting store owners</font></font></span></p></li>    <li><p style="margin-top: 0.05cm; margin-bottom: 0.05cm;"><span style="font-size: small;">                 <font face="Arial, serif" color="#666666">Multiple payment gateways</font>             </span></p></li>     </ul>    <h3><font color="#666666">                 <font face="Arial, serif">                     <b>                         <br>                     </b>                 </font>             </font>             <font color="#666666" face="Arial, serif">Store Features</font></h3><br>                    <ul>         <li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">SEO 	friendly shopping cart. Give users an easy-to-remember URL and rank 	above your competition in search engines.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Multiple 	photo options per product to improve the conversion rate.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Automatic 	photo resizing, eliminating the need to use other photo editing 	programs.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	custom form fields for products and categories.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	digital products like eBooks, pictures, videos, software, and 	templates in addition to physical products.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Optional 	affiliate program to increase your new customers without breaking 	the bank.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	promo codes for tracking the effectiveness of marketing campaigns.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	an efficient and simple Return Merchandize Authorization process 	(RMA) to turn refunds and returns into a positive experience for 	your clients.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	bulk import of products and images.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	export users, orders, products and other reports into .csv format.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	multiple administrator logins with different privileges for staff.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Built-in 	content management system for static pages like Terms, About Us, and 	Refund Policy. Edit the website without knowing html.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	unlimited products, categories, and subcategories.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Includes 	multiple themes to fit the type of store you want to create. You can 	select a theme with a click and change the appearance of the entire 	online store.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	payment gateways like Paypal, Google Checkout, World Pay, Your Pay 	and Authorize.net.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	offline credit card payments so that you can process payments using 	your existing POS.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	order notification and package slip through fax.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Supports 	UPS, USPS, FEDEX, Canada Post and Australia Post Shipping Methods 	for real-time shipping calculations. For simple shipping it supports 	multiple flat rate shipping.</font></font></span></li><li><span style="font-size: small;"><font color="#666666"><font face="Arial, serif">Administrator 	can change the home page layout by drag and drop in a browser. You 	can configure the site without any html or FTP.<br></font></font></span><span style="font-size: small;"><font color="#666666"><font face="Arial, serif"><br></font></font></span><span style="font-size: small;"><font color="#666666"><font face="Arial, serif"><br><br></font></font></span></li></ul>', '', 1),
	(26, 'account_cancellation_notification', '', 'email', 'Your {SITE_NAME} Account : {ACCOUNT} has been cancelled', '<p>Dear {MEMBER_NAME},<br> 	<br> 	Your {SITE_NAME} &#160;Account :{ACCOUNT} has been cancelled.<br><br>Thank you for doing business with us! .</p> <p>{SITE_NAME} Team</p>', '', 1),
	(25, 'failed_invoce_alert', '', 'email', 'Failed Invoice Alert {SITE_NAME}', 'Hi {USER},<br><br>The payment for your invoice no. {INVOICENO} dated {INVOICEDATE} could not be captured. Please contact {ADMIN_CONTACT_EMAIL} to keep your service active. Thank you for using {SITE_NAME}  services.<br><br><p>Thanks</p>  <p>{SITE_NAME} Team</p>', '', 1);

INSERT INTO `goStores_Help` (`nId`, `vTitle`, `tDescription`, `eType`, `eStatus`) VALUES
(6, 'Features', 'Features\r\n	Previous  Next\r\nFew features of this site are listed below\r\n\r\n\r\n    Automated Recurring Billing\r\n\r\n    Simple Web-Based Interface\r\n\r\n    Automated Scheduled Invoicing\r\n\r\n    Access to Billing Records\r\n\r\n    Integrated Help Desk\r\n\r\n    Integrated Store Builder\r\n\r\n    Hosting Support', 'User', 'Active'),
(5, 'Introduction', 'GoStores gives you an instant online store with a new domain name or a subdomain name or to your existing domain as you opt.', 'User', 'Active'),
(7, 'Registration', 'The registration section contains minimal user details. Please enter your Login name, Password, and Email. All the fields marked with a red star are mandatory. Your Log in Name must contain (a-z, A-Z) and digits (0-9). Now your account is activated and you can login to your site immediately. Make sure to completely fill out your profile under the ''Edit Profile'' link.\r\n', 'User', 'Active'),
(8, 'Introduction', 'GoStores gives you an instant online store with a new domain name or a subdomain name or to your existing domain as you opt.', 'Admin', 'Active'),
(9, 'Settings', '<table width="576" cellspacing="0" cellpadding="3" border="1" style="border-collapse: collapse; border: none">\r\n    <tbody><tr>\r\n    <td width="15" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">01</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">ENOM Reseller User Name:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Reseller account user name with ENOM.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">02</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">ENOM Reseller Password:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Reseller account password.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">03</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">ENOM User IP:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">IP allowed for the Reseller account with ENOM.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">04</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">ENOM Mode:&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Test/Live mode of ENOM Reseller account.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">05</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Administrator Name:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Name of the administrator of the site.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">06</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Administrator Signature:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Signature of the administrator of the site.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">07</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Administrator Password:&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Password of the administrator of the site.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">08</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Adminstrator Mail:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Mail address of the administrator of the site.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">09</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Company Name:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Name of the company.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">10</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Name of the Site:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Name of the Site.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">11</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Invoice From:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Invoice from details, which are used with invoices.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">12</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Site URL:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">URL of the site, it gets displayed automatically.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">13</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Sub Domain Hosting URL:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Domain name where you allow your customers to \r\n    create </span></font><font color="#010101"></font></div>\r\n    <div align="left"><br>\r\n    </div>\r\n    <font color="#010101">\r\n    </font><div align="left"><font color="#010101"></font><font face="Arial" color="#010101"><span style="font-size:10pt">their store as a subdomain.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">14</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Subdomain Sever CPanel</span></font><font color="#010101"></font></div>\r\n    <div align="left"><br>\r\n    </div>\r\n    <font color="#010101">\r\n    </font><div align="left"><font color="#010101"></font><font face="Arial" color="#010101"><span style="font-size:10pt"> User Name:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">CPANEL Username of the above Subdomain Sever</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">15</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Subdomain Sever CPanel</span></font><font color="#010101"></font></div>\r\n    <div align="left"><br>\r\n    </div>\r\n    <font color="#010101">\r\n    </font><div align="left"><font color="#010101"></font><font face="Arial" color="#010101"><span style="font-size:10pt"> Password:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">CPANEL Password of the above Subdomain Sever</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">16</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Subdomain Sever CPanel</span></font><font color="#010101"></font></div>\r\n    <div align="left"><br>\r\n    </div>\r\n    <font color="#010101">\r\n    </font><div align="left"><font color="#010101"></font><font face="Arial" color="#010101"><span style="font-size:10pt"> Skin</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">CPANEL Skin of the above Subdomain Sever</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">17</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Control Panel Type </span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">The type of the Control Panel of the server, where \r\n    your</span></font><font color="#010101"></font></div>\r\n    <div align="left"><br>\r\n    </div>\r\n    <font color="#010101">\r\n    </font><div align="left"><font color="#010101"></font><font face="Arial" color="#010101"><span style="font-size:10pt"> site is hosted.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">18</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Control Panel Scripts Path:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Path to the folder where the Control Panel Scripts \r\n    resides. It needs to be entered only when the Control \r\n    Panel is of "CPANEL" type.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">19</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Site URL of Secure Server:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">URL of the secure version of this site. By default it will \r\n    take ''Site URL'' as ''Secure Server URL'' and you can \r\n    change this.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">20</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Support creating cart in a</span></font><font color="#010101"></font></div>\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt"> subdomain : &nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Option to support create store as subdomain</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">21</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Support creating cart in an </span></font><font color="#010101"></font></div>\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">existing domain:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Option to support create store with an existing domain \r\n    name.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">22</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Support creating cart in a new \r\n    domain&nbsp; :</span></font><font color="#010101"></font></div>\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">&nbsp;&nbsp;&nbsp;&nbsp;</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Option to support create store by registering a new \r\n    domain name.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">23</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Enable PayPal:&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Decide wheather to enable paypal or not.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">24</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Paypal Email Address:&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Paypal Login ID.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">25</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Paypal Identity Token:&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Identity Token issued from Paypal.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">26</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Payment Gateway:&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="33" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Decide which payment gateway needed.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">27</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Authorize.net Login Id:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Your Login ID with the authorize.net payment \r\n    gateway.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">28</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Authorize.net Password:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Authorize.net account''s password.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">29</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Authorize.net Transaction Key:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="32" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Your transaction key with the Authorize.net account.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">30</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Authorize.net Merchant Email:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Your email address with the Authorize.net account.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">31</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Site Logo:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Logo of your site, it will be better if you upload a \r\n    transparent background logo.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">32</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Center HTML Part of User</span></font><font color="#010101"></font></div>\r\n    <div align="left"><br>\r\n    </div>\r\n    <font color="#010101">\r\n    </font><div align="left"><font color="#010101"></font><font face="Arial" color="#010101"><span style="font-size:10pt"> Side of the Site </span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="30" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Content for the home page of your website.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">33</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Enable About Us </span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="29" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Option to show or hide about us page in your site.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">34</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">About Us Page</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Content For the about us page.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">35</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Price of Domain Registration Plan:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="34" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Price for domain registration</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="39" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">36</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="39" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Price of Domain Renewal Plan:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="39" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Cost for renewing a domain in the site.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">37</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Name Server 1 - 4:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Name servers, if you enable hosting service. If you \r\n    enable hosting service, there name servers will get \r\n    added to all domains that are registered, transfered \r\n    and renewed in the site.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">38</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Administrator Password Settings:</span></font><font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="31" style="border: solid #010101 1px;">\r\n    <div align="left"><font face="Arial" color="#010101"><span style="font-size:10pt">Gives the option to change the password of \r\n    administrator of the site.</span></font><font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left">&nbsp;<font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left">&nbsp;<font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="35" style="border: solid #010101 1px;">\r\n    <div align="left">&nbsp;<font color="#010101"></font></div>\r\n    </td></tr>\r\n    <tr>\r\n    <td width="15" valign="top" height="36" style="border: solid #010101 1px;">\r\n    <div align="left">&nbsp;<font color="#010101"></font></div>\r\n    </td>\r\n    <td width="213" valign="top" height="36" style="border: solid #010101 1px;">\r\n    <div align="left">&nbsp;<font color="#010101"></font></div>\r\n    </td>\r\n    <td width="321" valign="top" height="36" style="border: solid #010101 1px;">\r\n    <div align="left">&nbsp;<font color="#010101"></font></div>\r\n    </td></tr></tbody></table>', 'Admin', 'Active');


INSERT INTO `goStores_PlanPackages` (`nPPId`, `nPlanId`, `vDescription`, `nPlanAmount`, `dCreatedOn`, `nStatus`, `nDeleteStatus`) VALUES
(1, 1, 'Free Trial for Product', 50, '2012-09-06 17:29:34', 0, 0),
(2, 2, 'Discount Pack', 30, '2012-09-11 16:05:12', 1, 0);

INSERT INTO `goStores_ProductPermission` (`nId`, `nPId`, `vPermissions`) VALUES
(1, 1, 'app/webroot/img/,app/webroot/img/products/,app/webroot/img/csv/,app/tmp/,app/tmp/logs/,app/tmp/sessions/,app/tmp/cache/,app/tmp/cache/models/,app/tmp/cache/views/,app/tmp/cache/persistent/,app/webroot/files/,app/webroot/files/File,app/webroot/files/Flash,app/webroot/files/Image,app/webroot/files/Media,app/webroot/files/Graph,app/config/database.php,app/webroot/config.php,app/webroot/img/SiteLogo.gif,app/webroot/img/SiteLogo_disp.gif,app/webroot/blog/wp-content/,app/webroot/blog/wp-config.php,app/controllers/components/pple.xml,app/webroot/configxml.xml,');


INSERT INTO `goStores_Products` (`nPId`, `vPName`, `vProductCaption`, `vProductPack`, `vProductlogoSmall`, `vProductlogo`, `vProductDescription`, `vProductScreens`, `dLastUpdated`, `nPRId`, `nStatus`) VALUES
(1, 'VistaCart', 'Online shopping Cart', 'vistacart.zip', 'Socialware_small_disp.gif', 'Socialware_main_disp.gif', 'Social Networking Sites', 'Socialware_small_disp.gif', '2012-12-11 20:06:13', 4, 1);

INSERT INTO `goStores_ServiceCategories` (`nSCatId`, `vCategory`, `vDescription`, `vInputType`, `vOrderofDisplay`, `dCreatedOn`, `nStatus`) VALUES
(1, 'Domain Registration', 'Domain Registration', 'C', NULL, '2012-09-14', 1),
(2, 'License Plans', 'License Plans', 'C', NULL, '2012-09-14', 1),
(3, 'Professional Installation Service', 'Professional Installation Service', 'C', NULL, '2012-09-14', 1),
(4, 'Support Options', 'Support Options', 'C', NULL, '2012-09-14', 1),
(5, 'Copyright Removal License', 'Copyright Removal License', 'C', NULL, '2012-09-14', 0),
(6, 'Product Purchase', 'Product Purchase', 'C', NULL, '2012-09-14', 1),
(7, 'Graphic Design Service', 'Graphic Design Service', 'R', NULL, '2012-09-14', 1),
(8, 'Support Upgrade', 'Support Upgrade', 'C', NULL, '2012-09-14', 1),
(9, 'Product Upgrade', 'Product Upgrade', 'C', NULL, '2012-09-14', 1),
(10, 'Free Product Upgrade', 'Free Product Upgrade', 'C', NULL, '2012-09-14', 1),
(12, 'Product Upgrade1', 'hh\\''g', 'C', NULL, '2012-09-18', 1);

INSERT INTO `goStores_themes` (`theme_id`, `theme_title`, `theme_name`, `theme_status`, `theme_thumbnail`) VALUES
(1, 'Clean Grey', 'theme1', 1, '<img style="width:60px; height:60px; " src="http://localhost/gostores/project/styles/themes/theme1/preview.jpg">'),
(2, 'Aqua Blue', 'theme2', 0, ' <img style="width:60px; height:60px; " src="http://localhost/gostores/project/styles/themes/theme2/preview.jpg">'),
(3, 'Elegent Red', 'theme3', 0, '<img style="width:60px; height:60px; " src="http://localhost/gostores/project/styles/themes/theme3/preview.jpg">'),
(4, 'Emerald Green', 'theme4', 0, '<img style="width:60px; height:60px; " src="http://localhost/gostores/project/styles/themes/theme4/preview.jpg">'),
(5, 'Lifestyle', 'theme5', 0, '<img style="width:60px; height:60px; " src="http://localhost/gostores/project/styles/themes/theme5/preview.jpg">');

INSERT INTO `goStores_tld` (`id`, `registrar`, `tld`, `register_fee`, `renewal_fee`, `transfer_fee`, `tocidreg`, `tocidren`, `tocidtra`) VALUES
(11, 'ENOM', 'biz', 10.00, 10.00, 10.00, '', '', ''),
(12, 'ENOM', 'com', 10.00, 10.00, 10.00, '', '', ''),
(13, 'ENOM', 'info', 10.00, 10.00, 10.00, '', '', ''),
(14, 'ENOM', 'mobi', 10.00, 10.00, 10.00, '', '', ''),
(15, 'ENOM', 'name', 10.00, 10.00, 10.00, '', '', ''),
(16, 'ENOM', 'net', 10.00, 10.00, 10.00, '', '', ''),
(17, 'ENOM', 'org', 10.00, 10.00, 10.00, '', '', ''),
(20, 'ENOM', 'ca', 10.00, 10.00, 10.00, '', '', '');

INSERT INTO `goStores_cms_settings` (`id`, `cms_set_name`, `cms_set_value`, `created_on`) VALUES
(1, 'admin_logo', 'project/styles/themes/theme1/images/gostores_logo.jpg', '2012-11-16 19:01:30'),
(2, 'admin_copyright', 'Powered by <a rel="nofollow" href="http://iscripts.com/gostores" target="_blank" class="cms_list_operation">iScripts GoStores</a>. A premium product from <a rel="nofollow" href="http://iscripts.com" target="_blank" class="cms_list_operation">iScripts.com</a>', '2012-12-18 16:21:13'),
(4, 'admin_page_count', '8', '2012-10-03 16:33:33'),
(5, 'site_logo', 'Admincomponents::bindSiteLogoCms', '2012-12-19 20:24:53');

INSERT INTO `goStores_ProductServices` (`nServiceId`, `vServiceName`, `vServiceDescription`, `nSCatId`, `nPId`, `price`, `nQty`, `vType`, `vBillingInterval`, `nBillingDuration`, `nStatus`, `dLastUpdated`) VALUES
(1, 'Free Trial', 'Free Trial', 1, 1, 0.00, 100, 'free', 'M', 14, 0, '2012-12-19 15:50:09');

INSERT INTO `goStores_Settings` (`settingfield`, `settinglabel`, `value`, `groupLabel`, `type`, `fieldOrder`) VALUES ('priceDomiainRegistration', 'Price of Domain Registration Plan', '12', 'Domain Registrar', '', '');

INSERT INTO `goStores_Banners` (`nBannerId`, `vBannerText`, `vBannerUrl`, `vBannerImageId`, `vActive`, `showcount`, `clickcount`, `eType`) VALUES
(9, 'GoStores', '', 776, '1', '', '', 'Header'),
(10, 'GoStores', '', 780, '1', '', '', 'Header'),
(11, 'GoStores', '', 781, '0', '', '', 'Header'),
(13, 'GoStores', '', 824, '1', '', '', 'Header');

INSERT INTO `tbl_files` (`file_id`, `file_orig_name`, `file_extension`, `file_mime_type`, `file_type`, `file_width`, `file_height`, `file_play_time`, `file_size`, `file_path`, `file_status`, `file_title`, `file_caption`, `file_tmp_name`, `created_on`, `created_by`) VALUES
(776, 'banner1315847750.jpg', 'jpg', 'image/jpeg', '', 988, 337, 0, 102557, 'me91hb3xfh0.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(780, 'banner1315856405.jpg', 'jpg', 'image/jpeg', '', 988, 337, 0, 139726, 'meacd2x9hpq.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(781, 'banner1315850451.jpg', 'jpg', 'image/jpeg', '', 988, 337, 0, 137194, 'meaclpwk0on.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(824, 'banner.jpg', 'jpg', 'image/jpeg', '', 1250, 400, 0, 326193, 'mf4d5362byd.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(846, 'screen5.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 92656, 'mgt5uqvtpbd.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(847, 'screen2.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 49011, 'mgt5ylasmyr.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(848, 'screen3.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 41185, 'mgt62bcr2b6.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(849, 'screen4.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 37790, 'mgt7ao0kecp.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(850, 'screen1.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 34610, 'mgt7azc4209.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(851, 'screen6.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 34063, 'mgt7bbctolm.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(852, 'screen7.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 49721, 'mgt7cut79wl.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(853, 'screen8.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 57425, 'mgt7ddhjn0s.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(854, 'screen9.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 50962, 'mgt7dqpo0d8.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(855, 'screen10.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 42304, 'mgt7ek4w45m.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(856, 'screen11.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 51930, 'mgt7exu4ops.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(857, 'screen12.jpg', 'jpg', 'image/jpeg', '', 400, 231, 0, 42350, 'mgt7fev1i3a.jpg', NULL, NULL, NULL, NULL, NULL, 0);


INSERT INTO `goStores_DemoScreenshots` (`nScreenId`, `vScreenImageId`, `vActive`, `eType`) VALUES
(1, 846, '1', 'User'),
(2, 847, '1', 'User'),
(3, 848, '1', 'User'),
(4, 849, '1', 'User'),
(5, 850, '1', 'User'),
(6, 851, '1', 'User'),
(7, 852, '1', 'Admin'),
(8, 853, '1', 'Admin'),
(9, 854, '1', 'Admin'),
(10, 855, '1', 'Admin'),
(11, 856, '1', 'Admin'),
(12, 857, '1', 'Admin');

INSERT INTO `goStores_tld_godaddy` (`nId`, `nDuration`, `eType`, `vProductid`, `vTld`) VALUES
	(1, 1, 'Registration', '350001', 'com'),
	(2, 2, 'Registration', '350002', 'com'),
	(3, 3, 'Registration', '350003', 'com'),
	(4, 4, 'Registration', '350004', 'com'),
	(5, 5, 'Registration', '350005', 'com'),
	(6, 6, 'Registration', '350006', 'com'),
	(7, 7, 'Registration', '350007', 'com'),
	(8, 8, 'Registration', '350008', 'com'),
	(9, 9, 'Registration', '350009', 'com'),
	(10, 10, 'Registration', '350010', 'com'),
	(11, 1, 'Renewal', '15212', 'bz'),
	(12, 1, 'Renewal', '19140', 'me'),
	(13, 1, 'Renewal', '19850', 'in'),
	(14, 1, 'Renewal', '50801', 'mobi'),
	(15, 1, 'Renewal', '51000', 'co.in'),
	(16, 1, 'Renewal', '51100', 'firm.in'),
	(17, 1, 'Renewal', '51200', 'gen.in'),
	(18, 1, 'Renewal', '51300', 'ind.in'),
	(19, 1, 'Renewal', '51400', 'net.in'),
	(20, 1, 'Renewal', '350012', 'com'),
	(21, 2, 'Renewal', '350013', 'com'),
	(22, 3, 'Renewal', '350014', 'com'),
	(23, 4, 'Renewal', '350015', 'com'),
	(24, 5, 'Renewal', '350016', 'com'),
	(25, 6, 'Renewal', '350017', 'com'),
	(26, 7, 'Renewal', '350018', 'com'),
	(27, 8, 'Renewal', '350019', 'com'),
	(28, 9, 'Renewal', '350020', 'com'),
	(29, 10, 'Renewal', '350021', 'com'),
	(30, 1, 'Transfer', '350011', 'com'),
	(31, 1, 'Registration', '350076', 'BIZ'),
	(32, 2, 'Registration', '350077', 'BIZ'),
	(33, 3, 'Registration', '350078', 'BIZ'),
	(34, 4, 'Registration', '350079', 'BIZ'),
	(35, 5, 'Registration', '350080', 'BIZ'),
	(36, 6, 'Registration', '350081', 'BIZ'),
	(37, 7, 'Registration', '350082', 'BIZ'),
	(38, 8, 'Registration', '350083', 'BIZ'),
	(39, 9, 'Registration', '350084', 'BIZ'),
	(40, 10, 'Registration', '350085', 'BIZ'),
	(41, 1, 'Transfer', '350086', 'BIZ'),
	(42, 1, 'Renewal', '350087', 'BIZ'),
	(43, 2, 'Renewal', '350088', 'BIZ'),
	(44, 3, 'Renewal', '350089', 'BIZ'),
	(45, 4, 'Renewal', '350090', 'BIZ'),
	(46, 5, 'Renewal', '350091', 'BIZ'),
	(47, 6, 'Renewal', '350092', 'BIZ'),
	(48, 7, 'Renewal', '350093', 'BIZ'),
	(49, 8, 'Renewal', '350094', 'BIZ'),
	(50, 9, 'Renewal', '350095', 'BIZ'),
	(51, 10, 'Renewal', '350096', 'BIZ'),
	(52, 1, 'Registration', '9850', 'IN'),
	(53, 2, 'Registration', '9851', 'IN'),
	(54, 3, 'Registration', '9852', 'IN'),
	(55, 4, 'Registration', '9853', 'IN'),
	(56, 5, 'Registration', '9854', 'IN'),
	(57, 6, 'Registration', '9855', 'IN'),
	(58, 7, 'Registration', '9856', 'IN'),
	(59, 8, 'Registration', '9857', 'IN'),
	(60, 9, 'Registration', '9858', 'IN'),
	(61, 10, 'Registration', '9859', 'IN'),
	(62, 1, 'Transfer', '9860', 'IN'),
	(63, 1, 'Renewal', '19850', 'IN'),
	(64, 2, 'Renewal', '19851', 'IN'),
	(65, 3, 'Renewal', '19852', 'IN'),
	(66, 4, 'Renewal', '19853', 'IN'),
	(67, 5, 'Renewal', '19854', 'IN'),
	(68, 6, 'Renewal', '19855', 'IN'),
	(69, 7, 'Renewal', '19856', 'IN'),
	(70, 8, 'Renewal', '19857', 'IN'),
	(71, 9, 'Renewal', '19858', 'IN'),
	(72, 10, 'Renewal', '19859', 'IN'),
	(73, 1, 'Registration', '350051', 'INFO'),
	(74, 2, 'Registration', '350052', 'INFO'),
	(75, 3, 'Registration', '350053', 'INFO'),
	(76, 4, 'Registration', '350054', 'INFO'),
	(77, 5, 'Registration', '350055', 'INFO'),
	(78, 6, 'Registration', '350056', 'INFO'),
	(79, 7, 'Registration', '350057', 'INFO'),
	(80, 8, 'Registration', '350058', 'INFO'),
	(81, 9, 'Registration', '350059', 'INFO'),
	(82, 10, 'Registration', '350060', 'INFO'),
	(83, 1, 'Transfer', '350061', 'INFO'),
	(84, 1, 'Renewal', '350062', 'INFO'),
	(85, 2, 'Renewal', '350063', 'INFO'),
	(86, 3, 'Renewal', '350064', 'INFO'),
	(87, 4, 'Renewal', '350065', 'INFO'),
	(88, 5, 'Renewal', '350066', 'INFO'),
	(89, 6, 'Renewal', '350067', 'INFO'),
	(90, 7, 'Renewal', '350068', 'INFO'),
	(91, 8, 'Renewal', '350069', 'INFO'),
	(92, 9, 'Renewal', '350070', 'INFO'),
	(93, 10, 'Renewal', '350071', 'INFO'),
	(94, 1, 'Registration', '40801', 'MOBI'),
	(95, 2, 'Registration', '40802', 'MOBI'),
	(96, 3, 'Registration', '40803', 'MOBI'),
	(97, 4, 'Registration', '40804', 'MOBI'),
	(98, 5, 'Registration', '40805', 'MOBI'),
	(99, 6, 'Registration', '40806', 'MOBI'),
	(100, 7, 'Registration', '40807', 'MOBI'),
	(101, 8, 'Registration', '40808', 'MOBI'),
	(102, 9, 'Registration', '40809', 'MOBI'),
	(103, 10, 'Registration', '40810', 'MOBI'),
	(104, 1, 'Transfer', '40811', 'MOBI'),
	(105, 1, 'Renewal', '50801', 'MOBI'),
	(106, 2, 'Renewal', '50802', 'MOBI'),
	(107, 3, 'Renewal', '50803', 'MOBI'),
	(108, 4, 'Renewal', '50804', 'MOBI'),
	(109, 5, 'Renewal', '50805', 'MOBI'),
	(110, 6, 'Renewal', '50806', 'MOBI'),
	(111, 7, 'Renewal', '50807', 'MOBI'),
	(112, 8, 'Renewal', '50808', 'MOBI'),
	(113, 9, 'Renewal', '50809', 'MOBI'),
	(114, 10, 'Renewal', '50810', 'MOBI'),
	(115, 1, 'Registration', '350030', 'NET '),
	(116, 2, 'Registration', '350031', 'NET '),
	(117, 3, 'Registration', '350032', 'NET '),
	(118, 4, 'Registration', '350033', 'NET '),
	(119, 5, 'Registration', '350034', 'NET '),
	(120, 6, 'Registration', '350035', 'NET '),
	(121, 7, 'Registration', '350036', 'NET '),
	(122, 8, 'Registration', '350037', 'NET '),
	(123, 9, 'Registration', '350038', 'NET '),
	(124, 10, 'Registration', '350039', 'NET '),
	(125, 1, 'Transfer', '350040', 'NET '),
	(126, 1, 'Renewal', '350041', 'NET '),
	(127, 2, 'Renewal', '350042', 'NET '),
	(128, 3, 'Renewal', '350043', 'NET '),
	(129, 4, 'Renewal', '350044', 'NET '),
	(130, 5, 'Renewal', '350045', 'NET '),
	(131, 6, 'Renewal', '350046', 'NET '),
	(132, 7, 'Renewal', '350047', 'NET '),
	(133, 8, 'Renewal', '350048', 'NET '),
	(134, 9, 'Renewal', '350049', 'NET '),
	(135, 10, 'Renewal', '350050', 'NET '),
	(136, 1, 'Registration', '350150', 'ORG'),
	(137, 2, 'Registration', '350151', 'ORG'),
	(138, 3, 'Registration', '350152', 'ORG'),
	(139, 4, 'Registration', '350153', 'ORG'),
	(140, 5, 'Registration', '350154', 'ORG'),
	(141, 6, 'Registration', '350155', 'ORG'),
	(142, 7, 'Registration', '350156', 'ORG'),
	(143, 8, 'Registration', '350157', 'ORG'),
	(144, 9, 'Registration', '350158', 'ORG'),
	(145, 10, 'Registration', '350159', 'ORG'),
	(146, 1, 'Transfer', '350160', 'ORG'),
	(147, 1, 'Renewal', '350161', 'ORG'),
	(148, 2, 'Renewal', '350162', 'ORG'),
	(149, 3, 'Renewal', '350163', 'ORG'),
	(150, 4, 'Renewal', '350164', 'ORG'),
	(151, 5, 'Renewal', '350165', 'ORG'),
	(152, 6, 'Renewal', '350166', 'ORG'),
	(153, 7, 'Renewal', '350167', 'ORG'),
	(154, 8, 'Renewal', '350168', 'ORG'),
	(155, 9, 'Renewal', '350169', 'ORG'),
	(156, 10, 'Renewal', '350170', 'ORG'),
	(157, 1, 'Registration', '350126', 'US'),
	(158, 2, 'Registration', '350127', 'US'),
	(159, 3, 'Registration', '350128', 'US'),
	(160, 4, 'Registration', '350129', 'US'),
	(161, 5, 'Registration', '350130', 'US'),
	(162, 6, 'Registration', '350131', 'US'),
	(163, 7, 'Registration', '350132', 'US'),
	(164, 8, 'Registration', '350133', 'US'),
	(165, 9, 'Registration', '350134', 'US'),
	(166, 10, 'Registration', '350135', 'US'),
	(167, 1, 'Transfer', '350136', 'US'),
	(168, 1, 'Renewal', '350137', 'US'),
	(169, 2, 'Renewal', '350138', 'US'),
	(170, 3, 'Renewal', '350139', 'US'),
	(171, 4, 'Renewal', '350140', 'US'),
	(172, 5, 'Renewal', '350141', 'US'),
	(173, 6, 'Renewal', '350142', 'US'),
	(174, 7, 'Renewal', '350143', 'US'),
	(175, 8, 'Renewal', '350144', 'US'),
	(176, 9, 'Renewal', '350145', 'US'),
	(177, 10, 'Renewal', '350146', 'US'),
	(178, 1, 'Registration', '350101', 'WS'),
	(179, 2, 'Registration', '350102', 'WS'),
	(180, 3, 'Registration', '350103', 'WS'),
	(181, 4, 'Registration', '350104', 'WS'),
	(182, 5, 'Registration', '350105', 'WS'),
	(183, 6, 'Registration', '350106', 'WS'),
	(184, 7, 'Registration', '350107', 'WS'),
	(185, 8, 'Registration', '350108', 'WS'),
	(186, 9, 'Registration', '350109', 'WS'),
	(187, 10, 'Registration', '350110', 'WS'),
	(188, 1, 'Renewal', '350112', 'WS'),
	(189, 2, 'Renewal', '350113', 'WS'),
	(190, 3, 'Renewal', '350114', 'WS'),
	(191, 4, 'Renewal', '350115', 'WS'),
	(192, 5, 'Renewal', '350116', 'WS'),
	(193, 6, 'Renewal', '350117', 'WS'),
	(194, 7, 'Renewal', '350118', 'WS'),
	(195, 8, 'Renewal', '350119', 'WS'),
	(196, 9, 'Renewal', '350120', 'WS'),
	(197, 10, 'Renewal', '350121', 'WS'),
	(198, 1, 'Transfer', '350811', 'WS');

INSERT INTO `goStores_Settings` (`settingfield`, `settinglabel`, `value`, `groupLabel`, `type`, `fieldOrder`, `helpText`) VALUES ('paypal_bn_code', 'Paypal BN Code', NULL, 'Payment', '', '', 'Build Notation ID Code is a unique identifier that tells PayPal how much volume comes in through merchants who use your integrated Paypal solution');

INSERT INTO `goStores_Settings` (`settingfield`, `settinglabel`, `value`, `groupLabel`, `type`, `fieldOrder`, `helpText`) VALUES ('paypaladvanced_bn_code', 'Paypal Advanced BN Code', NULL, 'Payment', '', '', 'Build Notation ID Code is a unique identifier that tells PayPal how much volume comes in through merchants who use your integrated Paypal solution');

INSERT INTO `goStores_Settings` (`settingfield`, `settinglabel`, `value`, `groupLabel`, `type`, `fieldOrder`, `helpText`) VALUES ('paypalpro_bn_code', 'Paypalpro BN Code', NULL, 'Payment', '', '', 'Build Notation ID Code is a unique identifier that tells PayPal how much volume comes in through merchants who use your integrated Paypal solution');

INSERT INTO `goStores_Settings` (`settingfield`, `settinglabel`, `value`, `groupLabel`, `type`, `fieldOrder`, `helpText`) VALUES ('recaptcha_enable', 'Enable Recaptcha', 'N', 'General', '', 0, 'You can enable / disable recaptcha in site.'),
('recaptcha_public_key', 'Recaptcha Public Key', '', 'General', '', 0, 'Enter Recaptcha Public Key'),
('recaptcha_private_key', 'Recaptcha Private Key', '', 'General', '', 0, 'Enter Recaptcha Private Key');


INSERT INTO `goStores_Vista_settings` VALUES ('paypal_bn_code', '');

INSERT INTO `goStores_Vista_settings` VALUES ('paypaladvanced_bn_code', '');

INSERT INTO `goStores_Vista_settings` VALUES ('paypalpro_bn_code', '');

INSERT INTO `goStores_Settings` (`settingfield`, `settinglabel`, `value`, `groupLabel`, `type`, `helpText`) VALUES ('site_operation_mode', 'Site Operation Mode', 'S', 'Server Settings', 'radio', 'Choose the option \'single server\' if your website and store installations are in same server else \'multiple server\'');

INSERT INTO `goStores_Settings` (`settingfield`, `settinglabel`, `value`, `groupLabel`, `type`, `helpText`) VALUES ('site_operation_park_domain', 'Temporary URLs', 'N', 'Server Settings', 'radio', 'If you have chosen \'Yes\', please configure your server setings to \'Allow users to park subdomains/domains of the server\'s hostname\'');

INSERT INTO `goStores_Settings` (`settingfield`, `settinglabel`, `value`, `groupLabel`, `type`, `fieldOrder`, `helpText`) VALUES ('enableDomiainRegistration', 'Enable Domain Registration', 'N', 'Domain Registrar', 'checkbox', 0, 'Enable Domain Registration');
