<?php
/**
 * TestLink Open Source Project - http://testlink.sourceforge.net/
 * This script is distributed under the GNU General Public License 2 or later.
 *
 * Constants and configuration parameters used throughout TestLink
 *
 * There are included extra files:
 * - your customized settings - custom_config.inc.php
 * - DB access - config_db.inc.php
 * - constants - const.inc.php
 * - basic checking - configCheck.php
 *
 * IMPORTANT:
 * To adapt values to your needs DO NOT EDIT THIS FILE but use custom_config.inc.php and
 * replace values of TestLink configuration variables.
 * It saves your changes for the next upgrade in one extra file.
 *
 * @package 	TestLink
 * @copyright 	2005-2009, TestLink community
 * @version    	CVS: $Id: config.inc.php,v 1.333.2.1 2010/11/09 11:11:09 asimon83 Exp $
 * @link 		http://www.teamst.org/index.php
 *
 * @internal Revisions:
 *  20101109 - asimon - added $tlCfg->custom_fields->show_custom_fields_without_value
 *	20101030 - franciscom - bullet image config removed
 *  20101028 - Julian - BUGID 3950 - added $tlCfg->gui->dynamic_quick_tcase_search_input_size
 *  20101014 - Julian - BUGID 3893 - added $tlCfg->metrics_dashboard->show_test_plan_status
 *	20101010 - franciscom - BUGID 3872 - Admin should be able to set a new password for users - $tlCfg->password_reset_send_method
 *  20100924 - asimon - added $tlCfg->enableTableExportButton
 *  20100915 - amitkhullar - BUGID 3639 - added $tlcfg->testcase_reorder_by for Reorder Test Cases
 *  20100915 - Julian - BUGID 3777 - added $tlCfg->req_cfg->allow_insertion_of_last_doc_id
 *  20100901 - asimon - re-enabled filter for assigned user when assigning testcases
 *	20100814 - franciscom - BUGID 3681 - new BTS youtrack (www.jetbrains.com)	
 *  20100810 - asimon - BUGID 3317 - added $tlCfg->req_cfg->external_req_management
 *  20100810 - asimon - added TC ID filter for Test Cases to $tlCfg->tree_filter_cfg
 *  20100809 - asimon - BUGID 3662 - disabled advanced filter mode choice for TC editing mode
 *  20100808 - asimon - added requirement filtering options to $tlCfg->tree_filter_cfg
 *  20100625 - asimon - added $tlCfg->tree_filter_cfg for configuration of available filters on JS tree
 *                      and $tlCfg->exec_cfg->testcases_colouring_by_selected_build for BUGID 3450
 *	20100620 - franciscom - fix strict messages after usign PHPDesigner.
 *	20100619 - franciscom - define always $g_bugInterfaceOn = false,$g_bugInterface = null;
 *	20100617 - franciscom - $tlCfg->req_cfg->importDocBook - new configuration for importing req in docbook format
 *  20100616 - eloff - BUGID 3255 - Cleaned up bts configuration
 *  20100527 - Julian - added $tlCfg->exec_cfg->expand_collapse->platform_description
 *  20100504 - franciscom - BUGID 3424 Custom CSS path is being overwritten by config.inc.php value 
 *  20100311 - asimon - BUGID 1748 - $tlCfg->req_cfg->relations
 *	20100313 - franciscom - BUGID 0003275
 *  20100112 - asimon - BUGID 2976 - $tlCfg->req_cfg->search
 *  20100110 - eloff - BUGID 2036 - changed $tlCfg->gui->checkNotSaved to true
 *  20100106 - franciscom - added $tlCfg->diffEngine - diff for test case and req (Contribution)
 *  20091227 - franciscom - REMOVED - $tlCfg->req_cfg->reqdoc_id->is_system_wide
 *  20091217 - franciscom - $tlCfg->testcase_cfg->duplicated_name_algorithm
 *  20091205 - franciscom - BUGID 0002469: $tlCfg->exec_cfg->expand_collapse
 *  20091129 - franciscom - BUGID 2554 - gui->usersAssignGlobalRoleColoring
 *  20091126 - franciscom - added contribution req internal links
 * 	20091125 - franciscom - req_cfg->expected_coverage_management added
 *	20091121 - franciscom - added contribution by Julian - BUGID 0002968,0002961,0002962,0002963
 *                         (refactored)
 *
 *  20091018 - franciscom - added contribution LDAP with TLS
 *  20090926 - franciscom - new default for $tlCfg->req_cfg->child_requirements_mgmt
 *  20090912 - franciscom - BUGID 2796 - contribution reportsCfg->start_time
 *  20090901 - franciscom - new option exec_cfg->steps_results_layout
 *  20090823 - franciscom - new option custom_field_max_length
 *	20090815 - franciscom - new option exec_cfg->show_history_all_platforms
 *  20090804 - franciscom - moved report config here
 *  20090304 - franciscom - BUGID 2171
 *  20090211 - franciscom - added $tlCfg->exec_cfg->enable_tree_testcases_colouring
 *                                $tlCfg->exec_cfg->enable_tree_counters_colouring
 *
 *  20090126 - franciscom - show_config_check_warning -> config_check_warning_mode
 *  20090103 - franciscom - $tlCfg->req_cfg->coverageStatusAlgorithm
 *  20090103 - franciscom - BUGID 651 - $tlCfg->testcase_cfg->can_remove_executed
 *  20090101 - franciscom - changes in regex used to validate an email address
 *  20081228 - franciscom - gui->layoutMainPageLeft,gui->layoutMainPageRight
 *  20081217 - franciscom - exec_cfg->simple_tester_roles
 *  20081213 - franciscom - more remove of old $g_* config parameters.
 *  20081122 - franciscom - removed some old $g_* config parameters.
 *  20081115 - franciscom - $tlCfg->testcase_cfg->search
 *  20081104 - franciscom - Added FOGBUGZ as BTS type
 *  20081103 - franciscom - Added GFORGE as BTS type
 *  20081006 - franciscom - config for rounding via nifty corners
 *  20080925 - franciscom - refactoring of urgencyImportance config
 *                          $tlCfg->req_cfg->child_requirements_mgmt
 *
 *  20080805 - franciscom - api configuration refactoring
 *  20080805 - franciscom - BUGID 1660 - extjs tree is default
 *  20080504 - franciscom - removed gui->enable_custom_fields
 * 	20080419 - havlatm - documentation update; minor refactorization
 *  20080326 - franciscom - restored configuration parameters removed without reasons.
 *
 * 	20080423 - havlatm - added $tlCfg as standard configuration holder
 *  20080322 - franciscom - $g_exec_cfg->edit_notes
 *  20080308 - franciscom - changed initial values for email settings
 *  20080304 - franciscom - $g_exec_cfg->show_testsuite_contents
 *  20080208 - franciscom - added contribution seapine BTS (BUGID 1371)
 *  20071112 - franciscom - config changes due to upgrade of Smarty
 *  20071106 - franciscom - BUGID 1165 - $g_testcase_template
 *
 *  20071104 - franciscom - $g_exec_cfg->enable_test_automation
 *                          $g_gui->tprojects_combo_order_by (BUGID 498)
 *  20070930 - franciscom - BUGID 1086 - configure order by in attachment
 *  20070910 - franciscom - removed MAIN_PAGE_METRICS_ENABLED
 *  20070505 - franciscom - following mantis bug tracking style, if file
 *                          custom_config.inc.php exists, il will be included
 *                          allowing users to customize TL configurations
 *                          managed using global variables, without need
 *                          of changing this file.
 *
 *  20070429 - franciscom - added contribution by Seweryn Plywaczyk
 *                          text area custom field
 *
 *  20070415 - franciscom -  added config for drag and drop feature
 *  20070301 - franciscom - #695 - $g_user_self_signup (fawel contribute)
 *
 **/

// ----------------------------------------------------------------------------
/* [INITIALIZATION] - DO NOT CHANGE THE SECTION */

/** @global array Global configuration class */
$tlCfg = new stdClass();
$tlCfg->api = new stdClass();
$tlCfg->document_generator = new stdClass();

$tlCfg->spec_cfg = new stdClass();

$tlCfg->exec_cfg = new stdClass();
$tlCfg->exec_cfg->view_mode = new stdClass();
$tlCfg->exec_cfg->exec_mode = new stdClass();

$tlCfg->gui = new stdClass();
$tlCfg->gui->custom_fields = new stdClass();
$tlCfg->testcase_cfg = new stdClass();
$tlCfg->req_cfg = new stdClass();
$tlCfg->validation_cfg = new stdClass();
$tlCfg->custom_fields = new stdClass();
$tlCfg->req_spec_cfg = new stdClass();
$tlCfg->diffEngine = new stdClass();

/** @uses database access definition (generated automatically by TL installer) */

/** @uses database access definition (generated automatically by TL installer) */ 
@include_once('config_db.inc.php');

if( !defined('DB_TABLE_PREFIX') )
{
    define('DB_TABLE_PREFIX','' );
}

/** The root dir for the testlink installation with trailing slash */
define('TL_ABS_PATH', dirname(__FILE__) . DIRECTORY_SEPARATOR);

/** Include constants and magic numbers (users should not change it)*/
require_once(TL_ABS_PATH . 'cfg' . DIRECTORY_SEPARATOR . 'const.inc.php');


// ----------------------------------------------------------------------------
/* [LOCALIZATION] */

/** @var string Default localization for users */
// The value must be available in $g_locales (see cfg/const.inc.php).
// Note: An attempt will be done to establish the default locale
// automatically using $_SERVER['HTTP_ACCEPT_LANGUAGE']
$tlCfg->default_language = 'en_GB';

/**
 * @var string Charset 'UTF-8' is only officially supported charset (Require
 * MySQL version >= 4.1) 'ISO-8859-1' or another Charset could be set for
 * backward compatability by experienced users. However we have not resources
 * to support such patches.
 **/
$tlCfg->charset = 'UTF-8';

/**
 * @var string characters used to surround a description in the user interface
 * (for example role)
 **/
$tlCfg->gui_separator_open =  '[';
$tlCfg->gui_separator_close = ']';

/** @var string Title separators are used when componing an title using several strings */
$tlCfg->gui_title_separator_1 = ' : '; // object : name (Test Specification : My best product)
$tlCfg->gui_title_separator_2 = ' - '; // parent - child

/**
 * @var string delimiter used to create DOC ID in this way:
 * <test_project_Prefix> . g_testcase_cfg->glue_character . <doc_id>
 * Could not be empty
 */
$tlCfg->testcase_cfg->glue_character = '-';

/**
 * fonts set used to draw charts
 **/
$tlCfg->charts_font_path = TL_ABS_PATH . "third_party/pchart/Fonts/tahoma.ttf";
/**
 * font size used to draw charts
 **/
$tlCfg->charts_font_size = 8;


// ----------------------------------------------------------------------------
/* [SERVER ENVIRONMENT] */

/**
 * @var integer Set the session timeout for inactivity [minutes].
 * Default high value disables this feature.
 */
$tlCfg->sessionInactivityTimeout = 9900;

/**
 * Set the session timeout value (in minutes).
 * This will prevent sessions timing out after very short periods of time
 * Warning: your server could block this settings
 **/
//ini_set('session.cache_expire',900);

/**
 * Set the session garbage collection timeout value (in seconds)
 * The default session garbage collection in php is set to 1440 seconds (24 minutes)
 * If you want sessions to last longer this must be set to a higher value.
 * You may need to set this in your global php.ini if the settings don't take effect.
 */
//ini_set('session.gc_maxlifetime', 54000);


// ----------------------------------------------------------------------------
/* [LOGGING] */

/** Error reporting - do we want php errors to show up for users */
error_reporting(E_ALL);

/** @var string Default level of logging (NONE, ERROR, INFO, DEBUG, EXTENDED) */
$tlCfg->log_level = 'ERROR';

/** @var boolean show smarty debug window */
$tlCfg->smarty_debug = false;

/** @var string Path to store logs */
$tlCfg->log_path = TL_ABS_PATH . 'logs' . DIRECTORY_SEPARATOR ;


/**
 * @var string How to warning user when security weak points exists.
 *
 * 'SCREEN': messages will displayed on login screen, and tl desktop (default)
 * 'FILE': a file with a list is created but users are not notified via GUI
 *         user will receive a message on screen.
 * 'SILENT': same that FILE, but user will not receive message on screen.
 */
$tlCfg->config_check_warning_mode = 'SILENT';

/**
 * Configure if individual logging data stores are enabled of disabled
 * Possibile values to identify loggers: 'db','file'
 *		$g_loggerCfg=null; all loggers enabled (default)
 * 		$g_loggerCfg['db']['enable']=true/false;
 * 		$g_loggerCfg['file']['enable']=true/false;
 */
$g_loggerCfg = null;

/**  @var integer All events older this value [days] are removed from the db, during login */
$g_removeEventsOlderThan = 30;


// ----------------------------------------------------------------------------
/* [Bug Tracking systems] */
/**
 * TestLink collaborates with bug tracking systems to check if displayed bugs resolved,
 * verified, and closed reports.
 *
 * Note: Use this option to check if a bug interface is enabled, if so every
 * page using bug tracking MUST include int_bugtracking.php to make the
 * connection. The variable bugInterfaceOn is only set when a connection is made
 *
 * @var string $g_interface_bugs = [
 * 'NO'        : no bug tracking system integration (DEFAULT)
 * 'BUGZILLA'  : edit configuration in TL_ABS_PATH/cfg/bugzilla.cfg.php
 * 'MANTIS'    : edit configuration in TL_ABS_PATH/cfg/mantis.cfg.php
 * 'JIRA'      : edit configuration in TL_ABS_PATH/cfg/jira.cfg.php
 * 'JIRASOAP'  : edit configuration in TL_ABS_PATH/cfg/jira.cfg.php
 * 'TRACKPLUS' : edit configuration in TL_ABS_PATH/cfg/trackplus.cfg.php
 * 'EVENTUM'   : edit configuration in TL_ABS_PATH/cfg/eventum.cfg.php
 * 'SEAPINE'   : edit configuration in TL_ABS_PATH/cfg/seapine.cfg.php
 * 'GFORGE'    : edit configuration in TL_ABS_PATH/cfg/gforge.cfg.php
 * 'FOGBUGZ'   : edit configuration in TL_ABS_PATH/cfg/fogbugz.cfg.php
 * 'YOUTRACK' : edit configuration in TL_ABS_PATH/cfg/youtrack.cfg.php
 * ]
 */
$g_interface_bugs = 'NO';

// do not change this
$g_bugInterfaceOn = false;
$g_bugInterface = null;


// ----------------------------------------------------------------------------
/* [SMTP] */

/**
 * @var string SMTP server name or IP address ("localhost" should work in the most cases)
 * Configure using custom_config.inc.php
 * @uses lib/functions/email_api.php
 */
$g_smtp_host        = '[smtp_host_not_configured]';  # SMTP server MUST BE configured

# Configure using custom_config.inc.php
$g_tl_admin_email     = '[testlink_sysadmin_email_not_configured]'; # for problem/error notification
$g_from_email         = '[from_email_not_configured]';  # email sender
$g_return_path_email  = '[return_path_email_not_configured]';

/**
 * Email notification priority (low by default)
 * Urgent = 1, Not Urgent = 5, Disable = 0
 **/
$g_mail_priority = 5;

# Taken from mantis for phpmailer config
define ("SMTP_SEND",2);
$g_phpMailer_method = SMTP_SEND;

/** Configure only if SMTP server requires authentication */
$g_smtp_username    = '';  # user
$g_smtp_password    = '';  # password


// ----------------------------------------------------------------------------
/* [User Authentication] */

/**
 * Login authentication method:
 * 	'MD5' => use password stored on db
 *	'LDAP' => use password from LDAP Server
 */
$tlCfg->authentication['method'] = 'MD5';

/** LDAP authentication credentials */
$tlCfg->authentication['ldap_server'] = 'localhost';
$tlCfg->authentication['ldap_port'] = '389';
$tlCfg->authentication['ldap_version'] = '3'; // could be '2' in some cases
$tlCfg->authentication['ldap_root_dn'] = 'dc=mycompany,dc=com';
$tlCfg->authentication['ldap_organization']	= '';    // e.g. '(organizationname=*Traffic)'
$tlCfg->authentication['ldap_uid_field'] = 'uid'; // Use 'sAMAccountName' for Active Directory
$tlCfg->authentication['ldap_bind_dn'] = ''; // Left empty for anonymous LDAP binding
$tlCfg->authentication['ldap_bind_passwd'] = ''; // Left empty for anonymous LDAP binding
$tlCfg->authentication['ldap_tls'] = false; // true -> use tls

/** Enable/disable Users to create accounts on login page */
$tlCfg->user_self_signup = TRUE;

/** What happens when Administrator push the Reset Password Button 
	'send_password_by_mail'
	'display_on_screen'
*/
$tlCfg->password_reset_send_method = 'send_password_by_mail';

/** Validating new user login names */
$tlCfg->validation_cfg->user_login_valid_regex='/^[\w \- .]+$/';

/**
 * Validating user email addresses
 * Example of other possibilities:
 * <code>
 * $regex = "/^[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*" .
 * 		 "@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i";
 * $regex = "/^([\w]+)(.[\w]+)*@([\w-]+\.){1,5}([A-Za-z]){2,4}$/";
 * </code>
 **/
$tlCfg->validation_cfg->user_email_valid_regex_js =  "/^(\w+)([-+.][\w]+)*@(\w[-\w]*\.){1,5}([A-Za-z]){2,4}$/";
$tlCfg->validation_cfg->user_email_valid_regex_php = "/^([\w]+)(.[\w]+)*@([\w-]+\.){1,5}([A-Za-z]){2,4}$/U";


// --------------------------------------------------------------------------------------
/* [API] */

/** XML-RPC API availability (disabled by default) */
$tlCfg->api->enabled = FALSE;

// used to display API ID info in the *View pages
$tlCfg->api->id_format = "[ID: %s ]";


// --------------------------------------------------------------------------------------
/* [GUI LAYOUT] */

/** GUI themes (base for CSS and images)- modify if you create own one */
$tlCfg->theme_dir = 'gui/themes/default/';

/** Dir for compiled templates */
$tlCfg->temp_dir = TL_ABS_PATH . 'gui' . DIRECTORY_SEPARATOR . 'templates_c' . DIRECTORY_SEPARATOR;

/** Company logo (used by navigation bar and login page page) */
//$tlCfg->company_logo = '<img alt="TestLink" title="TestLink" style="width: 115px; height: 53px;" src="' .
//                          $tlCfg->theme_dir . 'images/company_logo.png" />';
$tlCfg->company_logo = 'company_logo.png';

/** Login page could show an informational text */
$tlCfg->login_info = ''; // Empty by default

/**
 * @var string Availability of Test Project specific background colour
 * 'background'  -> standard behaviour for 1.6.x you can have a different
 *                  background colour for every test project.
 * 'none'        -> new behaviour no background color change
 */
$tlCfg->gui->testproject_coloring = 'none'; // I'm sorry default is not coloring using coloring is a pain
                                            // and useless
/** @TODO havlatm4francisco Ok, then merge these two attributes into one */
/** default background color */
$tlCfg->gui->background_color = '#9BD';

// ENABLED: on features that assign user role to test projects and test plan, colour user name
//          according GLOBAL role
// DISABLED: do not color [STANDARD BEHAVIOUR]
$tlCfg->gui->usersAssignGlobalRoleColoring = DISABLED;


// Enable/disable rounded corners via javascript
$tlCfg->gui->round_corners = new stdClass();
$tlCfg->gui->round_corners->exec_history = ENABLED;
$tlCfg->gui->round_corners->tc_title = ENABLED;
$tlCfg->gui->round_corners->tc_spec = ENABLED;

/**
 * Display name definition (used to build a human readable display name for users)
 * Example of values:
 * 		'%first% %last%'          -> John Cook
 * 		'%last%, %first%'          -> Cook John
 * 		'%first% %last% %login%'    -> John Cook [ux555]
 **/
$tlCfg->username_format = '%login%';

/** Configure the frame frmWorkArea navigator width */
$tlCfg->frame_workarea_default_width = "30%";

/** true => icon edit will be added into <a href> as indication an edit features */
$tlCfg->gui->show_icon_edit = false;

/**
 * Order to use when building a testproject combobox (value must be SQL compliant)
 * For example:
 * 		'ORDER BY name'
 * 		'ORDER_BY nodes_hierarchy.id DESC' -> similar effect to order last created firts
 **/
$tlCfg->gui->tprojects_combo_order_by = 'ORDER BY nodes_hierarchy.id DESC';

/** Configure the input size of test case search by id on navigation bar.
 *  This value will be added to the length of the prefix to dynamically set input size.
 *  Example: prefix is "projectA-" -> length of prefix is 9
 *  Now the here defined value (default: 6) will be added to the prefix length
 *  -> Input field will have an input size of 15
 **/
$tlCfg->gui->dynamic_quick_tcase_search_input_size = 6;

// used to round percentages on metricsDashboard.php
$tlCfg->dashboard_precision = 2;

/**
 * Choose what kind of webeditor you want to use in every TL area. This configuration
 * will be used if no element with search key (area) is found on this structure.
 * Every element is a mp with this configuration keys:
 *
 * 'type':
 *        'fckeditor'
 *        'tinymce'
 *        'none' -> use plain text area input field
 * 'toolbar': only applicable for type = 'fckeditor'
 *			name of ToolbarSet  (See: http://docs.fckeditor.net/ for more information about ToolbarSets)
 * 			TestLink stores own definitions in <testlink_dir>/cfg/tl_fckeditor_config.js
 * 'configFile': only applicable for type = 'fckeditor'
 * 			See: http://docs.fckeditor.net/ for more information about CustomConfigurationsPath
 * 'height': the height in px for FCKEditor
 * 'width': the width in px for FCKEditor
 * 'cols': the number of cols for tinymce and none
 * 'rows': the number of rows for tinymce and none
 *
 * The next keys/areas are supported:
 * 		'all' (default setting),
 * 		'design', 'steps_design', 'testplan', 'build', 'testproject', 'role', 'requirement', 'requirement_spec'.
 *
 * Examples:
 * <code>
 * // Copy this to custom_config.inc.php if you want use 'tinymce' as default.
 * $tlCfg->gui->text_editor['all'] = array( 'type' => 'tinymce');
 * // Copy this to custom_config.inc.php if you want use 'nome' as default.
 * $tlCfg->gui->text_editor['all'] = array( 'type' => 'none');
 * //This configuration is useful only if default type is set to 'fckeditor'
 * $tlCfg->gui->text_editor['design'] = array('toolbar' => 'tl_mini');
 *
 * $tlCfg->gui->text_editor['testplan'] = array( 'type' => 'none');
 * $tlCfg->gui->text_editor['build'] = array( 'type' => 'fckeditor','toolbar' => 'tl_mini');
 * $tlCfg->gui->text_editor['testproject'] = array( 'type' => 'tinymce');
 * $tlCfg->gui->text_editor['role'] = array( 'type' => 'tinymce');
 * $tlCfg->gui->text_editor['requirement'] = array( 'type' => 'none');
 * $tlCfg->gui->text_editor['requirement_spec'] = array( 'type' => 'none');
 * </code>
 *
 * Hint: After doing configuration changes, clean you Browser's cookies and cache
 */
$tlCfg->gui->text_editor = array();
$tlCfg->gui->text_editor['all'] = array('type' => 'fckeditor',
                                    	'toolbar' => 'tl_default',
                                    	'configFile' => 'cfg/tl_fckeditor_config.js',);
$tlCfg->gui->text_editor['execution'] = array( 'type' => 'none');

/** User can choose order of menu areas */
$tlCfg->gui->layoutMainPageLeft = array( 'testProject' => 1, 'userAdministration' => 2 ,
                                         'requirements' => 3, 'testSpecification' => 4,
                                         'general' => 5);
$tlCfg->gui->layoutMainPageRight = array( 'testPlan' => 1, 'testExecution' => 2 ,
                                          'testPlanContents' => 3);

/**
 * Enable warning on a changed content before an user leave a page.
 *
 * Tested in:
 * - IE8        OK
 * - Firefox 3  OK
 * - Chrome     FAIL
 *
 * Does not work in Webkit browsers (Chrome, Safari) when using frames.
 * Bug in webkit: https://bugs.webkit.org/show_bug.cgi?id=19418
 */

// franciscom -
// BUGID 0003275 + post on forum: // http://www.teamst.org/phpBB2/viewtopic.php?t=3075
// seems that with config options that will be used on javascript via smarty template variables
// we are having problems using FALSE/TRUE => use 0/1 (or our CONSTANT DISABLED/ENABLED)
$tlCfg->gui->checkNotSaved = ENABLED;


// ----------------------------------------------------------------------------
/* [GUI: TREE] */

/** Default ordering value for new Test Suites and Test Cases to separate them */
$tlCfg->treemenu_default_testsuite_order = 1;
$tlCfg->treemenu_default_testcase_order = 100;

/** show/hide testcase id on tree menu */
$tlCfg->treemenu_show_testcase_id = TRUE;

/** Reorder test cases based on TC Name or External ID in tree on
 *  test suite level using reorder button 
 */
// 'EXTERNAL_ID' -> Sort on Test Case External ID field displayed on tree.(Default)
// 'NAME' -> Sort on Test Case Name field

$tlCfg->testcase_reorder_by = 'EXTERNAL_ID';
// $tlCfg->testcase_reorder_by = 'NAME';

// ----------------------------------------------------------------------------
/* [GUI: Javascript libraries] */

// May be in future another table sort engine will be better
// kryogenix.org -> Stuart Langridge sortTable
// '' (empty string) -> disable table sorting feature
$g_sort_table_engine='kryogenix.org';


// --------------------------------------------------------------------------------------
/* [Reports] */
$tlCfg->reportsCfg=new stdClass();

/** @TODO unfinished changes by Francisco? */
//Displayed execution statuses to use on reports (ordered). */
$tlCfg->reportsCfg->exec_status = $tlCfg->results['status_label_for_exec_ui'];

/**
 * Default Offset in seconds for reporting start date (reports with date range)
 * @uses lib/results/resultsMoreBuilds.php
 */
$tlCfg->reportsCfg->start_date_offset = (7*24*60*60); // one week

// minutes part is ignored but must be configured.
// Hint: set always to :00
$tlCfg->reportsCfg->start_time = '00:00';

// Result matrix (resultsTC.php)
// Shows an extra column which gives the status of the last executed build
$tlCfg->resultMatrixReport->buildColumns['showStatusLastExecuted'] = true;

// Show build columns in revers order. The latest build is to the left
$tlCfg->resultMatrixReport->buildColumns['latestBuildOnLeft'] = false;

// Show all available status details for test plans on metrics dashboard 
$tlCfg->metrics_dashboard = new stdClass();
$tlCfg->metrics_dashboard->show_test_plan_status = false;


// ----------------------------------------------------------------------------
/* [GENERATED DOCUMENTATION] */

/**
 * Texts and settings for printed documents
 * Image is expected in directory <testlink_root>/gui/themes/<your_theme>/images/
 * Leave text values empty if you would like to hide parameters.
 */
$tlCfg->document_generator->company_name = 'TestLink Community [configure $tlCfg->document_generator->company_name]';
$tlCfg->document_generator->company_copyright = '2009 &copy; TestLink Community';
$tlCfg->document_generator->confidential_msg = '';

/** CSS used in printed html documents */

// BUGID 3424
// $tlCfg->document_generator->css_template = $tlCfg->theme_dir . 'css/tl_documents.css';
$tlCfg->document_generator->css_template = 'css/tl_documents.css';

/** Misc settings */
// Display test case version when creating test spec document
$tlCfg->document_generator->tc_version_enabled = FALSE;



// ----------------------------------------------------------------------------
/* [Test Executions] */

// ENABLED -> enable XML-RPC calls to external test automation server
//            new buttons will be displayed on execution pages
// DISABLED -> disable
$tlCfg->exec_cfg->enable_test_automation = DISABLED;

// 1 -> user can edit execution notes, on old executions (Attention: user must have test case execution right)
// DISABLED -> no edit allowed [STANDARD BEHAVIOUR]
$tlCfg->exec_cfg->edit_notes = DISABLED;

// ASCending   -> last execution at bottom
// DESCending  -> last execution on top      [STANDARD BEHAVIOUR]
$tlCfg->exec_cfg->history_order = 'DESC';

// TRUE  -> the whole execution history for the choosen build will be showed
// FALSE -> just last execution for the choosen build will be showed [STANDARD BEHAVIOUR]
$tlCfg->exec_cfg->history_on = FALSE;

// TRUE  ->  test case VERY LAST (i.e. in any build) execution status will be displayed [STANDARD BEHAVIOUR]
// FALSE -> only last result on current build.
$tlCfg->exec_cfg->show_last_exec_any_build = TRUE;

// TRUE  ->  History for all builds will be shown
// FALSE ->  Only history of the current build will be shown  [STANDARD BEHAVIOUR]
$tlCfg->exec_cfg->show_history_all_builds = FALSE;

// TRUE  ->  History for all platforms (if any exists for test plan) will be shown
// FALSE ->  Only history of the current platform will be shown  [STANDARD BEHAVIOUR]
$tlCfg->exec_cfg->show_history_all_platforms = FALSE;

// different models for the attachments management on execution page
// $att_model_m1 ->  shows upload button and title
// $att_model_m2 ->  hides upload button and title
$tlCfg->exec_cfg->att_model = $att_model_m2;   //defined in const.inc.php

// ENABLED -> User can delete an execution result
// DISABLED -> User can not.  [STANDARD BEHAVIOUR]
$tlCfg->exec_cfg->can_delete_execution = DISABLED;

// ENABLED -> test cases will be coloured according to test case status
$tlCfg->exec_cfg->enable_tree_testcases_colouring = ENABLED;

// ENABLED -> test cases will be coloured according to execution status on build selected for execution
// DISABLED -> test cases will be coloured according status on latest execution regardless of selected build
// see http://mantis.testlink.org/view.php?id=3450 for more details 
$tlCfg->exec_cfg->testcases_colouring_by_selected_build = ENABLED;

// ENABLED -> test case counters will be coloured according to test case status
$tlCfg->exec_cfg->enable_tree_counters_colouring = ENABLED;


// 20080303 - franciscom
// This can help to avoid performance problems.
// Controls what happens on right frame when user clicks on a testsuite on tree.
// ENABLED -> show all test cases presents on test suite and children test suite.
// DISABLED -> nothing happens, to execute a test case you need to click on test case
$tlCfg->exec_cfg->show_testsuite_contents = DISABLED;

// ENABLED -> enable testcase counters by status on tree
$tlCfg->exec_cfg->enable_tree_testcase_counters = ENABLED;


// Define list of roles that are affected by:
// $tlCfg->exec_cfg->view_mode and $tlCfg->exec_cfg->exec_mode
// User must reconfigure if define other simple tester roles
//
// In addition (till code changes) also roles that verify this condition:
// $effective_role->hasRight('testplan_execute') and !$effective_role->hasRight('testplan_planning')
// Will be affected by:
// $tlCfg->exec_cfg->view_mode and $tlCfg->exec_cfg->exec_mode
//
$tlCfg->exec_cfg->simple_tester_roles=array(TL_ROLES_TESTER);

// Filter Test cases a user with tester role can VIEW depending on
// test execution assignment.
// all: all test cases.
// assigned_to_me: test cases assigned to logged user.
// assigned_to_me_or_free: test cases assigned to logged user or not assigned
$tlCfg->exec_cfg->view_mode->tester='assigned_to_me';

// Filter Test cases a user with tester role can EXECUTE depending on
// test execution assignment.
// all: all test cases.
// assigned_to_me: test cases assigned to logged user.
// assigned_to_me_or_free: test cases assigned to logged user or not assigned
$tlCfg->exec_cfg->exec_mode->tester='assigned_to_me';

/** User filter in Test Execution navigator - default value */
// logged_user -> combo will be set to logged user
// none        -> no filter applied by default
$tlCfg->exec_cfg->user_filter_default='none';


// 'horizontal' ->  step and results on the same row
// 'vertical'   ->  steps on one row, results in the row bellow
$tlCfg->exec_cfg->steps_results_layout = 'horizontal';


// Parameters to show notes/details when entering test execution feature
// EXPAND: show expanded/open
// COLLAPSE: show collapsed/closede
// LAST_USER_CHOICE: get status from cookie that holds last user choice.[STANDARD BEHAVIOUR]
$tlCfg->exec_cfg->expand_collapse = new stdClass();
$tlCfg->exec_cfg->expand_collapse->testplan_notes = LAST_USER_CHOICE;
$tlCfg->exec_cfg->expand_collapse->platform_description = LAST_USER_CHOICE;
$tlCfg->exec_cfg->expand_collapse->build_description = LAST_USER_CHOICE;
$tlCfg->exec_cfg->expand_collapse->testsuite_details = LAST_USER_CHOICE;


// ----------------------------------------------------------------------------
/* [Test Specification] */
// $g_spec_cfg = new stdClass();

// 'horizontal' ->  step and results on the same row
// 'vertical'   ->  steps on one row, results in the row bellow
// $g_spec_cfg->steps_results_layout = 'vertical';
$tlCfg->spec_cfg->steps_results_layout = 'horizontal';


// ENABLED -> User will see a test suite filter while creating test specification
// DISABLED -> no filter available
// $g_spec_cfg->show_tsuite_filter = ENABLED;
$tlCfg->spec_cfg->show_tsuite_filter = ENABLED;

// ENABLED -> every time user do some operation on test specification
//            tree is updated on screen.
// DISABLED -> tree will not be updated, user can update it manually.
// Anyway on user interface user will be able to change this choice
// $g_spec_cfg->automatic_tree_refresh = ENABLED;
$tlCfg->spec_cfg->automatic_tree_refresh = ENABLED;


// ENABLED -> user can edit executed tc versions
// DISABLED -> editing of executed tc versions is blocked.  [STANDARD BEHAVIOUR]
$tlCfg->testcase_cfg->can_edit_executed = DISABLED;

// ENABLED -> user can removed from a testplan executed tc versions. [STANDARD BEHAVIOUR]
// DISABLED -> user can NOT remove from a testplan executed tc versions.
$tlCfg->testcase_cfg->can_remove_executed = ENABLED;


// To avoid perfomance problems on search test case feature,
// we can decide when to inform user that results can not be displayed
// due to too many results.
$tlCfg->testcase_cfg->search=new stdClass();
$tlCfg->testcase_cfg->search->max_qty_for_display=200;


$tlCfg->testcase_cfg->duplicated_name_algorithm = new stdClass();
// 'stringPrefix' => use duplicated_name_algorithm->text
// 'counterSuffix' => creare name as :
//                    test case title  + (number of existent test cases +1)
//                    example: My Test Title 2
//                    duplicated_name_algorithm->text is used as sprintf format mask
$tlCfg->testcase_cfg->duplicated_name_algorithm->type = 'stringPrefix';
$tlCfg->testcase_cfg->duplicated_name_algorithm->text = strftime("%Y%m%d-%H:%M:%S", time());
// $tlCfg->testcase_cfg->duplicated_name_algorithm->type = 'counterSuffix';
// $tlCfg->testcase_cfg->duplicated_name_algorithm->text = " (%s)";


/** text template for a new items:
    Test Case: summary, steps, expected_results, preconditions

*/
// object members has SAME NAME that FCK editor objects.
// the logic present on tcEdit.php is dependent of this rule.
// every text object contains an object with following members: type and value
//
// Possible values for type member:
// none: template will not be used, default will be a clean editor screen.
//
// string: value of value member is assigned to FCK object
// string_id: value member is used in a lang_get() call, and return value
//       is assigned to FCK object. Configure string_id on custom_strings.txt
// file: value member is used as file name.
//       file is readed and it's contains assigned to FCK object
//
// any other value for type, results on '' assigned to FCK object

$tlCfg->testcase_template = new stdClass();

$tlCfg->testcase_template->summary = new stdClass();
$tlCfg->testcase_template->summary->type = 'none';
$tlCfg->testcase_template->summary->value = '';

$tlCfg->testcase_template->steps = new stdClass();
$tlCfg->testcase_template->steps->type = 'none';
$tlCfg->testcase_template->steps->value = '';

$tlCfg->testcase_template->expected_results = new stdClass();
$tlCfg->testcase_template->expected_results->type = 'none';
$tlCfg->testcase_template->expected_results->value = '';

$tlCfg->testcase_template->preconditions = new stdClass();
$tlCfg->testcase_template->preconditions->type = 'none';
$tlCfg->testcase_template->preconditions->value = '';


/** text template for a new Test Suite description */
$tlCfg->testsuite_template = new stdClass();
$tlCfg->testsuite_template->details = new stdClass();
$tlCfg->testsuite_template->details->type = 'none';
$tlCfg->testsuite_template->details->value = '';


// Contribution - Julian (Refactore)
// BUGID 0002968,0002961,0002962,0002963
$tlCfg->project_template = new stdClass();
$tlCfg->project_template->notes  = new stdClass();
$tlCfg->project_template->notes->type = 'none';
$tlCfg->project_template->notes->value = '';

$tlCfg->testplan_template = new stdClass();
$tlCfg->testplan_template->notes = new stdClass();
$tlCfg->testplan_template->notes->type = 'none';
$tlCfg->testplan_template->notes->value = '';

$tlCfg->execution_template = new stdClass();
$tlCfg->execution_template->bulk_exec_notes = new stdClass();
$tlCfg->execution_template->bulk_exec_notes->type = 'none';
$tlCfg->execution_template->bulk_exec_notes->value = '';

$tlCfg->execution_template->notes = new stdClass();
$tlCfg->execution_template->notes->type = 'none';
$tlCfg->execution_template->notes->value = '';

$tlCfg->build_template = new stdClass();
$tlCfg->build_template->notes = new stdClass();
$tlCfg->build_template->notes->type = 'none';
$tlCfg->build_template->notes->value = '';

$tlCfg->requirement_template = new stdClass();
$tlCfg->requirement_template->scope = new stdClass();
$tlCfg->requirement_template->scope->type = 'none';
$tlCfg->requirement_template->scope->value = '';

$tlCfg->req_spec_template = new stdClass();
$tlCfg->req_spec_template->scope = new stdClass();
$tlCfg->req_spec_template->scope->type = 'none';
$tlCfg->req_spec_template->scope->value = '';

$tlCfg->role_template = new stdClass();
$tlCfg->role_template->notes = new stdClass();
$tlCfg->role_template->notes->type = 'none';
$tlCfg->role_template->notes->value = '';


// ----------------------------------------------------------------------------
/* [ATTACHMENTS] */

/** Attachment feature availability */
$g_attachments = new stdClass();
$g_attachments->enabled = TRUE;

/** the type of the repository can be database or filesystem
 * TL_REPOSITORY_TYPE_DB => database
 * TL_REPOSITORY_TYPE_FS => filesystem
 **/
$g_repositoryType = TL_REPOSITORY_TYPE_FS;

/**
 * TL_REPOSITORY_TYPE_FS: the where the filesystem repository should be located
 * We recommend to change the directory for security reason.
 **/
$g_repositoryPath = TL_ABS_PATH . "upload_area" . DIRECTORY_SEPARATOR;

/**
 * compression used within the repository
 * TL_REPOSITORY_COMPRESSIONTYPE_NONE => no compression
 * TL_REPOSITORY_COMPRESSIONTYPE_GZIP => gzip compression
 */
$g_repositoryCompressionType = TL_REPOSITORY_COMPRESSIONTYPE_NONE;

// the maximum allowed file size for each repository entry, default 1MB.
// Also check your PHP settings (default is usually 2MBs)
$tlCfg->repository_max_filesize = 1; //MB

// TRUE -> when you upload a file you can give no title
$g_attachments->allow_empty_title = TRUE;

// $g_attachments->allow_empty_title == TRUE, you can ask the system
// to do something
//
// 'none'         -> just write on db an empty title
// 'use_filename' -> use filename as title
//$g_attachments->action_on_save_empty_title='use_filename';
//
$g_attachments->action_on_save_empty_title = 'none';

// Remember that title is used as link description for download
// then if title is empty, what the system has to do when displaying ?
// 'show_icon'  -> the $g_attachments->access_icon will be used.
// 'show_label' -> the value of $g_attachments->access_string will be used .
$g_attachments->action_on_display_empty_title = 'show_icon';

// martin: @TODO use an image file only

// BUGID 3424  - need to be moved AFTER include of custom_config
//
// $g_attachments->access_icon = '<img src="' . $tlCfg->theme_dir . 'images/new_f2_16.png" style="border:none" />';
$g_attachments->access_string = "[*]";

// Set display order of uploaded files - BUGID 1086
$g_attachments->order_by = " ORDER BY date_added DESC ";



// ----------------------------------------------------------------------------
/* [Requirements] */

// HAS TO BE REMOVED - > req_doc_id UNIQUE INSIDE test project
// true : you want req_doc_id UNIQUE IN THE WHOLE DB (system_wide)
// false: you want req_doc_id UNIQUE INSIDE a SRS
// $tlCfg->req_cfg->reqdoc_id->is_system_wide = FALSE;

/**
 * Test Case generation from Requirements - use_req_spec_as_testsuite_name
 *	FALSE => test cases are created and assigned to a test suite
 * 	         with name $tlCfg->req_cfg->default_testsuite_name
 * 	TRUE  => REQuirement Specification Title is used as testsuite name
 */
$tlCfg->req_cfg->use_req_spec_as_testsuite_name = TRUE;
$tlCfg->req_cfg->default_testsuite_name = "Auto-created Test cases";
$tlCfg->req_cfg->testsuite_details = "Test Cases in the Test Suite are generated from Requirements. " .
		                            "A refinement of test scenario is highly recommended.";
$tlCfg->req_cfg->testcase_summary_prefix = "<b>The Test Case was generated from the assigned requirement.</b><br />";


// To avoid perfomance problems on search Requirements feature,
// we can decide when to inform user that results can not be displayed
// due to too many results.
$tlCfg->req_cfg->search=new stdClass();
$tlCfg->req_cfg->search->max_qty_for_display=200;


// ENABLED: allow N level depth tree
// DISABLED: just one level
$tlCfg->req_cfg->child_requirements_mgmt = ENABLED;


// ENABLED: ask for this value on user interface and use on several features
// DISABLED: do not ask, do not use
$tlCfg->req_cfg->expected_coverage_management = ENABLED;

// 20090111 - franciscom
// Order of test cases status in this array, is used to undestand
// to what status set requirement in the requirements report.
// Standard algorithm, present in getReqCoverage(), is:
//
//
// if at least one of Test Cases linked to Requirement has status FAILED
//    Requirement Coverage Status = FAILED
// else if at least one of Test Cases linked to Requirement has status BLOCKED
//    Requirement Coverage Status = BLOCKED
// else if ALL Test Cases linked to Requirement has status NOT RUN
//    Requirement Coverage Status = NOT RUN
// else if ALL Test Cases linked to Requirement has status PASSED
//    Requirement Coverage Status = PASSED
// else
//    Requirement Coverage Status = Partially Passed
//
// This logic is implemented using following config parameter
$tlCfg->req_cfg->coverageStatusAlgorithm['checkOrder']=array('atLeastOne','all');
$tlCfg->req_cfg->coverageStatusAlgorithm['checkType']['atLeastOne']=array('failed','blocked');
$tlCfg->req_cfg->coverageStatusAlgorithm['checkType']['all']=array('not_run','passed');

// Configure here what status has to get requirement when check of type 'all' fails like
// in following situation (BUGID 2171)
// If particular requirement has assigned more than one test cases, and:
// - at least one of assigned test cases was not yet executed
// - the rest of assigned test cases was executed and passed
// then on the "Requirements based report" this particular requirement is not shown at all (in any section).
//
// $tlCfg->req_cfg->coverageStatusAlgorithm['checkFail']['all']='partially_passed';
// $tlCfg->req_cfg->coverageStatusAlgorithm['displayOrder']=array('passed','failed',
//                                                                'blocked','not_run','partially_passed');
// 20100819 - asimon - fix not needed anymore after rewrite of req based report
//$tlCfg->req_cfg->coverageStatusAlgorithm['checkFail']['all']='failed';
//$tlCfg->req_cfg->coverageStatusAlgorithm['displayOrder']=array('passed','failed','blocked','not_run');


// Linking between requirements/requirement specifications
//
$tlCfg->internal_links =  new stdClass();

//
// TRUE: links to other requirements/requirement specifications are
//       automatically generated from the corresponding Document ID, enclosed by tags (like BBCode).
//
// Usage:
// link to requirements: [req]req_doc_id[/req]
// link to requirement specifications: [req_spec]req_spec_doc_id[/req_spec]
//
// The test project of the requirement / requirement specification and an anchor
// to jump to can also be specified:
// [req tproj=<tproj_prefix> anchor=<anchor_name>]req_doc_id[/req]
// This syntax also works for requirement specifications.
//
// FALSE: no links are automatically created. 
//
$tlCfg->internal_links->enable =  TRUE;

// how a linked document (requirement/requirement specification) should be displayed.
// posible values:
//                'window': new window/tab will be used (depending on browser configuration)
//                'frame' : same frame as the clicked link
//                'popup' (default): popup window  (ATTENTION to browser pop-up block).
//
$tlCfg->internal_links->target = 'popup';

// title for automatically created link
// possible values:
//                 'string': lang_get() will be used to localize
//                 'none': no title will be generated, only link with ID
//                 'item' (default): localized type of item (e.g. "Requirement: ",  "Req Spec")
//                                   will be used as title for the generated link
//
$tlCfg->internal_links->req_link_title = new stdClass();
$tlCfg->internal_links->req_link_title->type = 'item';
$tlCfg->internal_links->req_link_title->value = '';

$tlCfg->internal_links->req_spec_link_title = new stdClass();
$tlCfg->internal_links->req_spec_link_title->type = 'item';
$tlCfg->internal_links->req_spec_link_title->value = '';


// Relations between requirement documents:
//
// The relation types have to be configured in cfg/const.inc.php
// and their respective localization values in locale strings.txt.

// There are some preconfigured standard types which you can use,
// additionally you can configure your own types.
$tlCfg->req_cfg->relations = new stdClass();
$tlCfg->req_cfg->relations->enable = TRUE;
$tlCfg->req_cfg->relations->interproject_linking = FALSE;

// Requirement/testcase diff
// default value of lines to show before and after each difference
$tlCfg->diffEngine->context = 5;


// Configuration for Requirement Import using DOCBOOK format
$tlCfg->req_cfg->importDocBook = new stdClass();
$tlCfg->req_cfg->importDocBook->requirement= "sect3";
$tlCfg->req_cfg->importDocBook->title= "title";
$tlCfg->req_cfg->importDocBook->paragraph= "para";
$tlCfg->req_cfg->importDocBook->ordered_list="orderedlist";
$tlCfg->req_cfg->importDocBook->list_item="listitem";
$tlCfg->req_cfg->importDocBook->table="informaltable";
$tlCfg->req_cfg->importDocBook->table_group="tgroup";
$tlCfg->req_cfg->importDocBook->table_head="thead";
$tlCfg->req_cfg->importDocBook->table_body="tbody";
$tlCfg->req_cfg->importDocBook->table_row="row";
$tlCfg->req_cfg->importDocBook->table_entry="entry";
$tlCfg->req_cfg->importDocBook->list_item_children = array('para','title');
$tlCfg->req_cfg->importDocBook->table_entry_children = array('para');


// If an external tool is used for requirement management, enable this setting.
// You will get an additional field on requirement specifications where you
// can enter the total count of requirements so that external requirements
// are also counted for metrics/statistics. 
$tlCfg->req_cfg->external_req_management = DISABLED;


//If enabled an icon next to Document ID field will show up that allows
//to insert the last defined Requirement Document ID within the same Project
//into Document ID field
$tlCfg->req_cfg->allow_insertion_of_last_doc_id = DISABLED;


// ----------------------------------------------------------------------------
/* [TREE FILTER CONFIGURATION] */

/* In the following section, you can configure which filters shall be used
 * in combination with the tree view for testcases and requirements.
 * There are five available filter modes (four for the testcase tree,
 * one for requirement documents), which are used for the different features
 * as listed here:
 *
 * For Test Cases:
 * --> execution_mode
 * 		execution of testcases
 * --> edit_mode
 * 		create and edit testcases
 * 		assign keywords to testcases
 * 		assign requirements to testcases
 * --> plan_mode
 * 		assign testcase execution to users
 * 		update linked versions for testplan
 * 		set urgent testcases
 * --> plan_add_mode
 * 		add/remove testcases to/from testplan
 *
 * For Requirements:
 * There are no modes defined, there is only one filter configuration.
 * The filters configured here will be used for requirement editing.
 */
$tlCfg->tree_filter_cfg = new stdClass();
$tlCfg->tree_filter_cfg->testcases = new stdClass();
$tlCfg->tree_filter_cfg->requirements = new stdClass();

// These are the available filter modes for testcases:
$tlCfg->tree_filter_cfg->testcases->execution_mode = new stdClass();
$tlCfg->tree_filter_cfg->testcases->edit_mode = new stdClass();
$tlCfg->tree_filter_cfg->testcases->plan_mode = new stdClass();
$tlCfg->tree_filter_cfg->testcases->plan_add_mode = new stdClass();

// If you disable one of these items here, you switch
// the complete filter panel off for a specific mode/feature.
// You should rather do this here instead of individually disabling all the filters,
// if you don't want to have any filters at all for a given feature.
$tlCfg->tree_filter_cfg->testcases->execution_mode->show_filters = ENABLED;
$tlCfg->tree_filter_cfg->testcases->edit_mode->show_filters = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_mode->show_filters = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_add_mode->show_filters = ENABLED;
$tlCfg->tree_filter_cfg->requirements->show_filters = ENABLED;

// Detailed settings for each mode.
// Here, the single filter fields can be disabled if not wanted.
// Also, the choice of advanced filter mode can be disabled.
$tlCfg->tree_filter_cfg->testcases->execution_mode->filter_tc_id = ENABLED;
$tlCfg->tree_filter_cfg->testcases->execution_mode->filter_testcase_name = ENABLED;
$tlCfg->tree_filter_cfg->testcases->execution_mode->filter_toplevel_testsuite = ENABLED;
$tlCfg->tree_filter_cfg->testcases->execution_mode->filter_keywords = ENABLED;
$tlCfg->tree_filter_cfg->testcases->execution_mode->filter_priority = ENABLED;
$tlCfg->tree_filter_cfg->testcases->execution_mode->filter_execution_type = ENABLED;
$tlCfg->tree_filter_cfg->testcases->execution_mode->filter_assigned_user = ENABLED;
$tlCfg->tree_filter_cfg->testcases->execution_mode->filter_custom_fields = ENABLED;
$tlCfg->tree_filter_cfg->testcases->execution_mode->filter_result = ENABLED;
$tlCfg->tree_filter_cfg->testcases->execution_mode->advanced_filter_mode_choice = ENABLED;

$tlCfg->tree_filter_cfg->testcases->edit_mode->filter_tc_id = ENABLED;
$tlCfg->tree_filter_cfg->testcases->edit_mode->filter_testcase_name = ENABLED;
$tlCfg->tree_filter_cfg->testcases->edit_mode->filter_toplevel_testsuite = ENABLED;
$tlCfg->tree_filter_cfg->testcases->edit_mode->filter_keywords = ENABLED;
$tlCfg->tree_filter_cfg->testcases->edit_mode->filter_execution_type = ENABLED;
$tlCfg->tree_filter_cfg->testcases->edit_mode->filter_custom_fields = ENABLED;
// filter mode choice disabled for this mode because there are no filters benefiting from it
$tlCfg->tree_filter_cfg->testcases->edit_mode->advanced_filter_mode_choice = DISABLED;

$tlCfg->tree_filter_cfg->testcases->plan_mode->filter_tc_id = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_mode->filter_testcase_name = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_mode->filter_toplevel_testsuite = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_mode->filter_keywords = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_mode->filter_priority = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_mode->filter_execution_type = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_mode->filter_assigned_user = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_mode->filter_custom_fields = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_mode->filter_result = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_mode->advanced_filter_mode_choice = ENABLED;

$tlCfg->tree_filter_cfg->testcases->plan_add_mode->filter_tc_id = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_add_mode->filter_testcase_name = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_add_mode->filter_toplevel_testsuite = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_add_mode->filter_keywords = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_add_mode->filter_priority = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_add_mode->filter_execution_type = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_add_mode->filter_custom_fields = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_add_mode->advanced_filter_mode_choice = ENABLED;

$tlCfg->tree_filter_cfg->requirements->filter_doc_id = ENABLED;
$tlCfg->tree_filter_cfg->requirements->filter_title = ENABLED;
$tlCfg->tree_filter_cfg->requirements->filter_status = ENABLED;
$tlCfg->tree_filter_cfg->requirements->filter_type = ENABLED;
$tlCfg->tree_filter_cfg->requirements->filter_spec_type = ENABLED;
$tlCfg->tree_filter_cfg->requirements->filter_coverage = ENABLED;
$tlCfg->tree_filter_cfg->requirements->filter_relation = ENABLED;
$tlCfg->tree_filter_cfg->requirements->filter_tc_id = ENABLED;
$tlCfg->tree_filter_cfg->requirements->filter_custom_fields = ENABLED;
$tlCfg->tree_filter_cfg->requirements->advanced_filter_mode_choice = ENABLED;

// ENABLED -> Every time the user does some operation on requirement spec,
//            the tree will be updated on screen. [DEFAULT]
// DISABLED -> The tree will not be updated automatically, but  the user can update it manually.
//             On graphical user interface any user will is able to change this setting.
$tlCfg->tree_filter_cfg->requirements->automatic_tree_refresh = ENABLED;

// ----------------------------------------------------------------------------
/* [MISC FUNCTIONALITY] */

/** Maximum uploadfile size to importing stuff in TL */
// Also check your PHP settings (default is usually 2MBs)
// unit BYTES is required by MAX_FILE_SIZE HTML option
$tlCfg->import_file_max_size_bytes = '409600';

/** Maximum line size of the imported file */
$tlCfg->import_max_row = '10000'; // in chars

/** Set the default role used for new users */
// - created from the login page.
// - created using user management features
$tlCfg->default_roleid = TL_ROLES_GUEST;

// only show custom fields if their value isn't empty
$tlCfg->custom_fields->show_custom_fields_without_value = true;

/** used to check size in char for TEXT AREA type custom fields */
// can not be greater that column definition on DB
// 0 => do not check.
$tlCfg->custom_fields->max_length = 255;

// sizes for HTML INPUTS
// for list, multiselection list => number of items
// for checkbox,radio is useless
// Hint: more than 120 produce weird effects on user interface
//
$tlCfg->custom_fields->sizes = array('string' => 100,
                                     'numeric' => 10,
                                     'float' => 10,
                                     'email' => 100,
                                     'list' => 5,
                                     'multiselection list' => 5,
		  					         'text area' => array('rows' => 6, 'cols' => 80),
							         'script' => 100,
							         'server' => 100);

// Use this variable (on custom_config.inc.php) to define new Custom Field types.
// IMPORTANT:
//           check $custom_field_types property on cfield_mgr.class.php
//           to avoid overwrite of standard types.
//
$tlCfg->gui->custom_fields->types = null;

// Use this variable (on custom_config.inc.php)
// to define possible values behaviour for new Custom Field types.
//
// IMPORTANT:
//           check $possible_values_cfg property on cfield_mgr.class.php
//           to avoid overwrite of standard values.
//
$tlCfg->gui->custom_fields->possible_values_cfg = null;


/**
 * Check unique titles of Test Project, Test Suite and Test Case
 *  ENABLED  => Check              [STANDARD BEHAVIOUR]
 *  DISABLED => don't check
 **/
$tlCfg->check_names_for_duplicates = ENABLED;

/**
 * Action for duplication check (only if check_names_for_duplicates=ENABLED)
 * 'allow_repeat' => allow the name to be repeated (backward compatibility)
 * 'generate_new' => generate a new name using $g_prefix_name_for_copy
 * 'block'        => return with an error
 **/
$tlCfg->action_on_duplicate_name = 'generate_new';

/**
 * String checking and conversions
 * Allow automatically convert www URLs and email adresses into clickable links
 * used by function string_display_links() for example by custom fields.
 * Valid values = ENABLED/DISABLED.
 **/
$tlCfg->html_make_links = ENABLED;

/**
 * Define the valid html tags for "content driven" single-line and multi-line fields.
 * Do NOT include tags with parameters (eg. <font face="arial">), img and href.
 * It's used by function string_display_links() for example by custom fields.
 */
$tlCfg->html_valid_tags = 'p, li, ul, ol, br, pre, i, b, u, em';
$tlCfg->html_valid_tags_single_line = 'i, b, u, em';

/**
 * Defines the threshold values for filtering TC by a priority according to the formula
 *  ui 		=>	(urgency*importance)
 *  LOW 	=> all Tc's with ui < LOW_Threshold
 *  HIGH 	=> all Tc's with ui >= HIGH_Threshold
 *  MEDIUM  => all Tc's with ui >= LOW_Threshold AND ui < HIGH_Threshold
 */
$tlCfg->urgencyImportance = new stdClass();
$tlCfg->urgencyImportance->threshold['low'] = 3;
$tlCfg->urgencyImportance->threshold['high'] = 6;

/**
 * @var boolean Demo mode disables some functionality
 * @TODO list with feature are disabled.
 */
$tlCfg->demoMode = OFF;

/**
 * If enabled, every Ext JS table in TestLink will offer an export button,
 * which generates a file with the contents of the table.
 * ATTENTION: This feature is fully experimental. Enable at your own risk!
 *            Enabling it can cause broken tables.
 */
$tlCfg->enableTableExportButton = DISABLED;


// ----- End of Config ------------------------------------------------------------------
// --------------------------------------------------------------------------------------
// DO NOT CHANGE NOTHING BELOW
// --------------------------------------------------------------------------------------

// havlatm: @TODO move the next code out of config - configCheck.php -> included via common.php
/** Functions for check request status */
require_once('configCheck.php');

/** root of testlink directory location seen through the web server */
// @TODO: basehref should be defined by installation script or stored from login in $_SESSION
/*  20070106 - franciscom - this statement it's not 100% right
    better use $_SESSION['basehref'] in the scripts. */
define('TL_BASE_HREF', get_home_url());


clearstatcache();
if ( file_exists( TL_ABS_PATH . 'custom_config.inc.php' ) )
{
  require_once( TL_ABS_PATH . 'custom_config.inc.php' );
}

// BUGID 3424
if( !isset($g_attachments->access_icon) )
{
	$g_attachments->access_icon = '<img src="' . $tlCfg->theme_dir . 'images/new_f2_16.png" style="border:none" />';
}

// BUGID 2914
// Important to do this only after custom_* to use (if exists) redefinition of
// $tlCfg->results['status_label_for_exec_ui']
$tlCfg->reportsCfg->exec_status = $tlCfg->results['status_label_for_exec_ui'];


/** Support for localization */
//	@TODO schlundus, move the code out of config and do it only once and not always in any include!
//	@TODO schlundus, a better parsing function should be include
$serverLanguage = false;
if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE']))
{
	@list($code) = explode(",",$_SERVER['HTTP_ACCEPT_LANGUAGE']);
	@list($a,$b) = explode("-",$code);
	if ($a && $b)
	{
		$a = strtolower($a);
		$b = strtoupper($a);
		$serverLanguage = $a."_".$b;
	}
}

if(false !== $serverLanguage)
{
	if (array_key_exists($serverLanguage,$g_locales))
		$tlCfg->default_language = $serverLanguage;
}
define ('TL_DEFAULT_LOCALE', $tlCfg->default_language);

// Reverted execution status is used for two applications.
// 1. To map code to CSS, Please if you add an status you need to add a corresponding CSS Class
//    in the CSS files (see the gui directory)
// 2. to decode from code to some more human oriented to use in code
//
/** Revered list of Test Case execution results */
$tlCfg->results['code_status'] = array_flip($tlCfg->results['status_code']);

// --------------------------------------------------------------------------------------
/** Converted and derived variables (Users should not modify this section) */
define('REFRESH_SPEC_TREE',$tlCfg->spec_cfg->automatic_tree_refresh ? 1 : 0);
define('TL_SORT_TABLE_ENGINE',$g_sort_table_engine);
define("TL_REPOSITORY_MAXFILESIZE", 1024*1024*$tlCfg->repository_max_filesize);

define('TL_XMLEXPORT_HEADER', "<?xml version=\"1.0\" encoding=\"" . $tlCfg->charset . "\"?>\n");

define('TL_THEME_BASE_DIR', $tlCfg->theme_dir);
define('TL_THEME_IMG_DIR', $tlCfg->theme_dir . 'images/');
define('TL_THEME_CSS_DIR', $tlCfg->theme_dir . 'css/');
define('TL_TESTLINK_CSS', TL_THEME_CSS_DIR . TL_CSS_MAIN);
define('TL_PRINT_CSS', TL_THEME_CSS_DIR . TL_CSS_PRINT);
define('TL_TREEMENU_CSS', TL_THEME_CSS_DIR . TL_CSS_TREEMENU);

// --------------------------------------------------------------------------------------
// when a role is deleted, a new role must be assigned to all users
// having role to be deleted
// A right choice seems to be using $g_default_roleid.
// You can change this adding a config line in custom_config.inc.php
// @TODO martin: remove - use directly $tlCfg->default_roleid;
$g_role_replace_for_deleted_roles = $tlCfg->default_roleid;


/**
BUGID 0000086: Using "|" in the testsuite name causes malformed URLs
regexp used to check for chars not allowed in:
test project, test suite and testcase names.
@TODO martin: encode harm characters @see http://cz.php.net/urlencode (and remove the parameter)
*/
// now is preg pattern
$g_ereg_forbidden = "/[|]/i";


/** @TODO martin: remove from configuration and use a number in brackets after name ("My Test Title(2)")
 * Used when creating a Test Suite using copy
   and you have choose  $g_action_on_duplicate_name = 'generate_new'
   if the name exist.
 */
$g_prefix_name_for_copy = strftime("%Y%m%d-%H:%M:%S", time());


/**
 * @TODO remove from TL - unfinished refactorization;
 * use $tlCfg instead of old variables and constants
 */
define('TL_IMPORT_ROW_MAX', $tlCfg->import_max_row);
// define('TL_ITEM_BULLET_IMG', TL_THEME_IMG_DIR . $tlCfg->bullet_image);
define('TL_TPL_CHARSET', $tlCfg->charset);
define('TITLE_SEP',$tlCfg->gui_title_separator_1);
define('TITLE_SEP_TYPE2',$tlCfg->gui_title_separator_2);
define('TITLE_SEP_TYPE3',$tlCfg->gui_title_separator_2); // obsolete: use type 1,2
define('TL_FRMWORKAREA_LEFT_FRAME_WIDTH', $tlCfg->frame_workarea_default_width);
define('TL_TEMP_PATH', $tlCfg->temp_dir);


$tlCfg->document_generator->company_logo = $tlCfg->company_logo;

$tlCfg->gui->title_separator_1 =  $tlCfg->gui_title_separator_1;
$tlCfg->gui->title_separator_2 =  $tlCfg->gui_title_separator_2;
$tlCfg->gui->role_separator_open =  $tlCfg->gui_separator_open;
$tlCfg->gui->role_separator_close = $tlCfg->gui_separator_close;
// ----- END OF FILE --------------------------------------------------------------------
?>
