<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2010 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts VistaCart                     |
// +----------------------------------------------------------------------+
// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |
// +----------------------------------------------------------------------+

App::import('Sanitize');
class CustomfieldsController extends AppController
{
    var $name = "Customfield";
    var $helpers = array('Html', 'Form','Pagination');   
    var $components = array ('Pagination','Catmenu','History','Email');
    var $uses = array('Customfield','Customfieldvalue','Productcustomfield','Currency','Setting','Cart');
    var $paginate = array('limit' => 25,'order' => array('Customfield.custom_name' => 'asc'));


	function index()
	{
        $this->__validateLoginStatus();
        $cnfg 				=	Configure::read('Neutrino');
        $style				=	$cnfg["style"];
        $this->set('style', "admin/".$style);
		$admsess	=	$this->Session->read('Admin');
		if($admsess["custom"] <> 1){
		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 
			exit();
		}
		$cmbSearchType	=	"";
		$txtSearch		=	"";
		if(isset($_GET["cmbSearchType"]) && isset($_GET["txtSearch"])){
			$cmbSearchType	=	$_GET["cmbSearchType"];
			$txtSearch		=	$_GET["txtSearch"];
			if($cmbSearchType == "name"){
				$data = $this->paginate('Customfield', array('Customfield.custom_name LIKE ' => "%".mysql_real_escape_string($txtSearch)."%"));
			}else{
				$data = $this->paginate('Customfield');
			}
		}

		else if(isset($this->passedArgs["cmbSearchType"]) && isset($this->passedArgs["txtSearch"]) && 
		 $this->passedArgs["txtSearch"] <> '')
		{
		    $cmbSearchType	=	$this->passedArgs["cmbSearchType"];
			$txtSearch		=	$this->passedArgs["txtSearch"];
			if($cmbSearchType == "name"){
				$data = $this->paginate('Customfield', array('Customfield.custom_name LIKE ' => "%".mysql_real_escape_string($txtSearch)."%"));
			}else{
				$data = $this->paginate('Customfield');
			}
		}
		else{
			$data = $this->paginate('Customfield');
		}
		$this->set('cmbSearchType', $cmbSearchType);
		$this->set('txtSearch', $txtSearch);
		$this->passedArgs['limit']=$this->paginate["limit"];
         $this->set('passedarg',$this->passedArgs);
		$this->set('customfield', $data);

		//For Edit in Place
		$this->set('totrows', 25);
		//For Edit in Place
		$this->layout = 'adm';	
	} 



	function add() {
		 $this->__validateLoginStatus();	
                  $cnfg 				=	Configure::read('Neutrino');
        $style				=	$cnfg["style"];
        $this->set('style', "admin/".$style);
		 $admsess	=	$this->Session->read('Admin');
		if($admsess["custom"] <> 1){
		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 
			exit();
		}
		if (!empty($this->data)) 
		{
			//checking for duplicates starts here...
			 $dups=$this->Customfield->findByCustomName(trim($this->data["Customfield"]["custom_name"]));			
			 if(isset($dups["Customfield"]["id"]) && $dups["Customfield"]["id"] <> '')
		     {
		         $this->Session->setFlash(__('CustomField Already exists.', '/customfields'));
		         $this->redirect('/customfields');
		         exit();
		      } 

			 //checking for duplicates ends here...
			 $this->Customfield->save($this->data);
			 $this->Session->setFlash(__('CustomField has been saved.', '/customfields'));
			 $this->redirect(array('controller' => 'customfields','action'=>'index'));		
		}		
		$this->layout = 'adm';
	} 



	function edit() 
	{
		$this->__validateLoginStatus();	
                 $cnfg 				=	Configure::read('Neutrino');
        $style				=	$cnfg["style"];
        $this->set('style', "admin/".$style);
		$admsess	=	$this->Session->read('Admin');
		if($admsess["custom"] <> 1){
		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 
			exit();
		}


		$editindex=$_POST["editindex"];
		$editid=$_POST["editid"];
		$customname=trim($_POST["edit_cname$editindex"]);			
		//checking for duplicates starts here...

		 $dups=$this->Customfield->checkEditDups($customname,$editid);			
		 if(isset($dups) && $dups > 0)
		     {
		         $this->Session->setFlash(__('CustomField Already exists.', '/customfields'));
		         $this->redirect('/customfields');
		         exit();
		      } 
		//checking for duplicates ends here...

		//Fetching the old custom name
		$this->Customfield->id = $editid; 
		$custom	=	$this->Customfield->findById($editid);
		$cname	=	$custom["Customfield"]["custom_name"];	
		//Fetching the old custom name		

		if ($customname!='') 
		{
	        $this->Customfield->updatecusval($customname,$editid); 
			$this->Session->setFlash(__('The CustomField '.$cname.' has been Edited Successfully.', '/customfields'));
			$this->redirect('/customfields');
		}
	}	




	function delete($id){
		$this->__validateLoginStatus();
		$admsess	=	$this->Session->read('Admin');
		if($admsess["custom"] <> 1){
		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 
			exit();
		}		

		//Fetching the old custom name
		$this->Customfield->id = $id; 
		$custom	=	$this->Customfield->findById($id);
		$cname	=	$custom["Customfield"]["custom_name"];	
		//Fetching the old custom name			
		$child=$this->Customfieldvalue->findByCustomfieldId($id);
		if(isset($child["Customfieldvalue"]["id"]) && $child["Customfieldvalue"]["id"] <> '')
		{
		  $this->Session->setFlash(__('The CustomField '.$cname.' Cannot be been deleted as Custom Values exists under this.', '/customfields'));
		  $this->redirect('/customfields');
		  exit();
		} 
		$this->Customfield->delcusval($id);
		$this->Session->setFlash(__('The CustomField '.$cname.' has been deleted Successfully.', '/customfields'));
		$this->redirect('/customfields');
	}


	function delcusnam($pid,$nam){
		$this->__validateLoginStatus();
		$admsess	=	$this->Session->read('Admin');
		if($admsess["custom"] <> 1){
		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 
			exit();
		}

		$this->Customfield->delcusnam($nam);
		$this->flash('CustomField Removed .', '/customfield');
		$this->redirect(array('controller' => 'products','action'=>'edit/'.$pid.'/cust'));
	}

    function beforeFilter()
    {
		if (isset($this->Setting) && !empty($this->Setting->table))  
        {  
             $this->Setting->load();  
        } 

		global $sitefolder; 
		global $meta_description;
		global $meta_keywords;
		global $page_title;
		$cnfg 				=	Configure::read('Neutrino');
		$sitefolder			=	$cnfg["sitebasefolder"];
		$meta_description	=	$cnfg["meta_description"];
		$meta_keywords		=	$cnfg["meta_keywords"];
		$page_title			=	$cnfg["page_title"];
		global $style; 
		$style				=	$cnfg["style"];
		$this->set('style', $style);
		$this->set('meta_description', $meta_description);
		$this->set('meta_keywords', $meta_keywords);
		$this->set('sitefolder', $sitefolder);
		$this->pageTitle = $page_title	; 
		$this->set('cnfg',$cnfg);
		$this->paginate["limit"]=$cnfg["items_perpage"]; //Setting pagination limit per page.
		$httpHost	=	$_SERVER['HTTP_HOST'];
		$this->set('sitebase','http://'.$httpHost);
                //get cart count
                 $sus = $this->Session->read();
                if ($this->Session->check('Userlog') === true) {
                    $userid = $sus["Userlog"]["id"];
                    $cartCount = $this->Cart->getCartCount($userid,'user');
                }else {
                    $sessid = $this->Session->id();
                    $cartCount = $this->Cart->getCartCount($sessid,'G');
                }
                $this->set('cartcount',$cartCount);
    }



	function beforeRender(){
				$lst	=	$this->Catmenu->getCatList(1);
				$this->set('catmenu', $lst);
				$this->layout = 'adm'; 
	}



    function __validateLoginStatus($typ='A')
    {
          if($typ == 'A'){
				if($this->Session->check('Admin') == false)
				{
					$this->redirect(array('controller' => 'admins', 'action' => 'login')); 
					$this->Session->setFlash('The URL you\'ve followed requires you login.');
				}
			}else{
				if($this->Session->check('Userlog') == false)
				{
					$this->redirect(array('controller' => 'users', 'action' => 'login')); 
					$this->Session->setFlash('The URL you\'ve followed requires you login.');
				}
			}
    } 
}
?>