<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/

// +----------------------------------------------------------------------+

// | PHP version 4/5                                                      |

// +----------------------------------------------------------------------+

// | Copyright (c) 2004-2010 ARMIA INC                                    |

// +----------------------------------------------------------------------+

// | This source file is a part of iScripts VistaCart                     |

// +----------------------------------------------------------------------+

// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |

// +----------------------------------------------------------------------+

App::import('Sanitize');

class StatesController extends AppController

{

    var $name = "State";

    var $helpers = array('Html', 'Form','Pagination');   

	var $components = array ('Pagination','Catmenu','History','Email'); // Added

	var $uses = array('State',  'Country','Currency','Setting','Statecode'); 

	var $paginate = array('limit' => 25,'order' => array('State.country_id' => 'asc'));

    function index($tab='')

    {

      	$this->__validateLoginStatus();
        $cnfg 				=	Configure::read('Neutrino');
        $style				=	$cnfg["style"];
        $this->set('style', "admin/".$style);

		$admsess	=	$this->Session->read('Admin');

		if($admsess["settings"] <> 1){

			$this->redirect(array('controller' => 'admins', 'action' => 'index')); 

			exit();

		}

		$criteria=NULL;

		$cmbSearchType	=	"";

		if(isset($_GET["cmbSearchType"]) ){

			$cmbSearchType	=	$_GET["cmbSearchType"];	

			$data = $this->paginate('State', array('State.country_id  LIKE ' => "%".mysql_real_escape_string($cmbSearchType)."%"));

			$this->set('tab', 'domain');
		

		}
		else if(isset($this->passedArgs["cmbSearchType"]))

		{

		    $cmbSearchType	=	$this->passedArgs["cmbSearchType"];

			$data = $this->paginate('State', array('State.country_id  LIKE ' => "%".mysql_real_escape_string($cmbSearchType)."%"));

			$this->set('tab', 'domain');
		

			}else{

			$data = $this->paginate('State');

		}

		$i =0;

		foreach($data as  $dy){

			 $cdet	=	$this->Country->findByCountryIsoCode_2($dy['State']['country_id']);

			 $data[$i]['State']["country_name"] =	$cdet["Country"]["country_name"];

			 $i++;

		}

		$this->set('cmbSearchType', $cmbSearchType);

		$this->set('data', $data);

		$countrylist	=	$this->Country->find('list',array('fields'=>array('Country.country_iso_code_2','Country.country_name'))); 

		$this->set('countrylist', $countrylist);

		if($_SERVER['REQUEST_METHOD'] == "POST"){

			foreach($_POST as $fieldname => $value){

				$this->Setting->update($fieldname,$value);

			}

			$this->Session->setFlash(__('Settings Updated Successfully!', true));

		}

		$gendata	=	$this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value'))); 

		$this->set('gendata', $gendata);
		
		$this->passedArgs['limit']=$this->paginate["limit"];
	    $this->set('passedarg',$this->passedArgs);  
		if($tab <> '')
		$this->set('tab',$tab);
		else if(isset($this->passedArgs["tab"]))
        $this->set('tab',$this->passedArgs["tab"]);	
    } 

	function add(){

		$this->__validateLoginStatus(); 
                $cnfg 				=	Configure::read('Neutrino');
        $style				=	$cnfg["style"];
        $this->set('style', "admin/".$style);

		$admsess	=	$this->Session->read('Admin');

		if($admsess["settings"] <> 1){

			$this->redirect(array('controller' => 'admins', 'action' => 'index')); 

			exit();

		}

		if (!empty($this->data)) {
		
		
		 if($this->data["State"]["country_id"] == 'US')	
		 {
			  if(isset($_POST["us_state"]) && $_POST["us_state"] == 'All')
			  {
			    $res=$this->State->updateAllTax($this->data["State"]["country_id"],$this->data["State"]["tax_name"],$this->data["State"]["tax_rate"]);		
			  }
			  else
			  {
			    $res=$this->State->updateTax($this->data["State"]["country_id"],$_POST["us_state"],$this->data["State"]["tax_name"],$this->data["State"]["tax_rate"]);		
			  }
			  $this->Session->setFlash(__('Tax details added Successfully!', true));
			  $this->redirect(array('controller' => 'states', 'action' => 'index/2')); 
			  exit();
		 }  
		 else if($this->data["State"]["country_id"] <> 'US')
		 {
			$chk	= $this->State->findByCode($this->data["State"]["code"]);
            if (!empty($chk['State']['id']) && $chk['State']['country_id'] == $this->data["State"]["country_id"])
			{
				$this->Session->setFlash(__('Tax has been already set for the selected state/states!', true));
            }
			else
			{
				if($this->State->save($this->data))
				{
					
					$this->Session->setFlash(__('Tax details Added Successfully!', true));
				    $this->redirect(array('controller' => 'states', 'action' => 'index/2')); 
			        exit();
				}
			//	$id	=	$this->State->id;            
			}
			
		}
		}

		$countrylist	=	$this->Country->find('list',array('fields'=>array('Country.country_iso_code_2','Country.country_name'))); 

		$this->set('countrylist', $countrylist);
		
		//Setting the US States dtails
		$us_cntrydet = $this->Country->find("Country.country_iso_code_2 ='US'");	
		if(isset($us_cntrydet["Country"]["country_id"]))
		{
		 $us_states	=	$this->Statecode->findAll("Statecode.country_id ='".$us_cntrydet["Country"]["country_id"]."'");	
		 $this->set('us_states', $us_states);	
		} 
        //Setting the US States dtails
	}

	function edit($id){

		$this->__validateLoginStatus();
                $cnfg 				=	Configure::read('Neutrino');
        $style				=	$cnfg["style"];
        $this->set('style', "admin/".$style);

		$admsess	=	$this->Session->read('Admin');

		if($admsess["settings"] <> 1){

			$this->redirect(array('controller' => 'admins', 'action' => 'index')); 

			exit();

		}

		$this->State->id = $id; 

		if (!empty($this->data)) {


          if($this->data["State"]["country_id"] == 'US')	
		 {
			  if(isset($_POST["us_state"]) && $_POST["us_state"] == 'All')
			  {
			    $res=$this->State->updateAllTax($this->data["State"]["country_id"],$this->data["State"]["tax_name"],$this->data["State"]["tax_rate"]);		
			  }
			  else
			  {
			    $res=$this->State->updateTax($this->data["State"]["country_id"],$_POST["us_state"],$this->data["State"]["tax_name"],$this->data["State"]["tax_rate"]);		
			  }
			  $this->Session->setFlash(__('Tax details updated Successfully!', true));
			  $this->redirect(array('controller' => 'states', 'action' => 'index/2')); 
			  exit();
		 }  

			$chk	= $this->State->findByCode($this->data["State"]["code"]);

            if (!empty($chk['State']['id']) && $chk['State']['country_id'] == $this->data["State"]["country_id"] && $chk['State']['id'] <> $id){

				$this->Session->setFlash(__('The State Code Already Exist!', true));

            }else{

				if($this->State->save($this->data)){
					$this->Session->setFlash(__('Tax details updated Successfully!', true));
			       $this->redirect(array('controller' => 'states', 'action' => 'index/2')); 
			       exit();
				}

			}

			$countrylist	=	$this->Country->find('list',array('fields'=>array('Country.country_iso_code_2','Country.country_name'))); 

			$this->set('countrylist', $countrylist);

		}else{

			$this->data = $this->State->read(); 

			$this->set('stdet', $this->data );

			$countrylist	=	$this->Country->find('list',array('fields'=>array('Country.country_iso_code_2','Country.country_name'))); 

			$this->set('countrylist', $countrylist);
				//Setting the US States dtails
				$us_cntrydet = $this->Country->find("Country.country_iso_code_2 ='US'");	
				if(isset($us_cntrydet["Country"]["country_id"]))
				{
				 $us_states	=	$this->Statecode->findAll("Statecode.country_id ='".$us_cntrydet["Country"]["country_id"]."'");	
				 $this->set('us_states', $us_states);	
				} 
				//Setting the US States dtails

		}

	}

	function delete($id){

		 $this->__validateLoginStatus();

		 $admsess	=	$this->Session->read('Admin');

		if($admsess["settings"] <> 1){

			$this->redirect(array('controller' => 'admins', 'action' => 'index')); 

			exit();

		}

		$this->State->del($id);

		//$this->flash(' State Removed from Database.', '/states');

		//$this->redirect('index');
		$this->Session->setFlash(__('Tax details Deleted Successfully!', true));
	 $this->redirect(array('controller' => 'states', 'action' => 'index/2')); 
	  exit();

	}

    function beforeFilter()

    {

		if (isset($this->Setting) && !empty($this->Setting->table))  

        {  

             $this->Setting->load();  

        } 

		global $sitefolder; 

		global $meta_description;

		global $meta_keywords;

		global $page_title;

		$cnfg 				=	Configure::read('Neutrino');

		$sitefolder			=	$cnfg["sitebasefolder"];

		$meta_description	=	$cnfg["meta_description"];

		$meta_keywords		=	$cnfg["meta_keywords"];

		$page_title			=	$cnfg["page_title"];

		global $style; 

		$style				=	$cnfg["style"];

		$this->set('style', $style);

		$this->set('meta_description', $meta_description);

		$this->set('meta_keywords', $meta_keywords);

		$this->pageTitle = $page_title	; 

		$this->set('cnfg',$cnfg);
		$this->set('sitefolder', $sitefolder);

		$httpHost	=	$_SERVER['HTTP_HOST'];

		$this->set('sitebase','http://'.$httpHost);

		$this->paginate["limit"]=$cnfg["items_perpage"]; //Setting pagination limit per page.

    }

	function beforeRender(){

				$lst	=	$this->Catmenu->getCatList(1);

				$this->set('catmenu', $lst);

				$this->layout = 'adm'; 

	}

    function __validateLoginStatus($typ='A')

    {

           if($typ == 'A'){

				if($this->Session->check('Admin') == false)

				{

					$this->redirect(array('controller' => 'admins', 'action' => 'login')); 

					$this->Session->setFlash('The URL you\'ve followed requires you login.');

				}

			}else{

				if($this->Session->check('Userlog') == false)

				{

					$this->redirect(array('controller' => 'users', 'action' => 'login')); 

					$this->Session->setFlash('The URL you\'ve followed requires you login.');

				}

			}

    } 

}

?>