<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts VistaCart                    |
// +----------------------------------------------------------------------+
// | Authors: Jipson Thomas<jipson.thomas@armiasystems.com>               |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com ï¿½ 2011                |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php
$imagefolder = "../img";
$stylesfolder = "../css";
$sitestyle = "Car.css";
$logoimage = "SiteLogo.jpg";
$productname = " ";

session_start();

function isValidUsername($str) {
    if (trim($str) != "") {
        if (preg_match("/[^0-9a-zA-Z+_]/", $str)) {
            return false;
        } else {
            return true;
        }
    } else {
        return false;
    }
}

function splitsqlfile($sql, $delimiter) {
    // Split up our string into "possible" SQL statements.
    $tokens = explode($delimiter, $sql);
    // try to save mem.
    $sql = "";
    $output = array();
    // we don't actually care about the matches preg gives us.
    $matches = array();
    // this is faster than calling count($oktens) every time thru the loop.
    $token_count = count($tokens);
    for ($i = 0; $i < $token_count; $i++) {
        // Don't wanna add an empty string as the last thing in the array.
        if (($i != ($token_count - 1)) || (strlen($tokens[$i] > 0))) {
            // This is the total number of single quotes in the token.
            $total_quotes = preg_match_all("/'/", $tokens[$i], $matches);
            // Counts single quotes that are preceded by an odd number of backslashes,
            // which means they're escaped quotes.
            $escaped_quotes = preg_match_all("/(?<!\\\\)(\\\\\\\\)*\\\\'/", $tokens[$i], $matches);

            $unescaped_quotes = $total_quotes - $escaped_quotes;
            // If the number of unescaped quotes is even, then the delimiter did NOT occur inside a string literal.
            if (($unescaped_quotes % 2) == 0) {
                // It's a complete sql statement.
                $output[] = $tokens[$i];
                // save memory.
                $tokens[$i] = "";
            } else {
                // incomplete sql statement. keep adding tokens until we have a complete one.
                // $temp will hold what we have so far.
                $temp = $tokens[$i] . $delimiter;
                // save memory..
                $tokens[$i] = "";
                // Do we have a complete statement yet?
                $complete_stmt = false;

                for ($j = $i + 1; (!$complete_stmt && ($j < $token_count)); $j++) {
                    // This is the total number of single quotes in the token.
                    $total_quotes = preg_match_all("/'/", $tokens[$j], $matches);
                    // Counts single quotes that are preceded by an odd number of backslashes,
                    // which means they're escaped quotes.
                    $escaped_quotes = preg_match_all("/(?<!\\\\)(\\\\\\\\)*\\\\'/", $tokens[$j], $matches);

                    $unescaped_quotes = $total_quotes - $escaped_quotes;

                    if (($unescaped_quotes % 2) == 1) {
                        // odd number of unescaped quotes. In combination with the previous incomplete
                        // statement(s), we now have a complete statement. (2 odds always make an even)
                        $output[] = $temp . $tokens[$j];
                        // save memory.
                        $tokens[$j] = "";
                        $temp = "";
                        // exit the loop.
                        $complete_stmt = true;
                        // make sure the outer loop continues at the right point.
                        $i = $j;
                    } else {
                        // even number of unescaped quotes. We still don't have a complete statement.
                        // (1 odd and 1 even always make an odd)
                        $temp .= $tokens[$j] . $delimiter;
                        // save memory.
                        $tokens[$j] = "";
                    }
                } // for..
            } // else
        }
    }
    return $output;
}

function isValidTableName($str) {
    if (trim($str) != "") {
        if (preg_match("/[^a-zA-Z+_]/", $str)) {
            return false;
        } else {
            return true;
        }
    } else {
        return false;
    }
}

function isValidEmail($email) {
    $email = trim($email);
    if ($email == "")
        return false;
    if (!preg_match("/^" . "[a-z0-9]+([_\\.-][a-z0-9]+)*" . // user
                    "@" . "([a-z0-9]+([\.-][a-z0-9]+)*)+" . // domain
                    "\\.[a-z]{2,}" . // sld, tld
                    "$/", $email, $regs)
    ) {
        return false;
    } else {
        return true;
    }
}

function isNotNull($value) {
    if (is_array($value)) {
        if (sizeof($value) > 0) {
            return true;
        } else {
            return false;
        }
    } else {
        if (($value != '') && (strtolower($value) != 'null') && (strlen(trim($value)) > 0)) {
            return true;
        } else {
            return false;
        }
    }
}

function isValidWebImageType($mimetype, $filename, $tempname) {
    $blacklist = array("php", "phtml", "php3", "php4", "js", "shtml", "pl", "py", "exe");
    foreach ($blacklist as $file) {
        if (preg_match("/\.$file\$/i", "$filename")) {
            return false;
        }
    }
    //check if its image file
    if (!getimagesize($tempname)) {
        return false;
    }

    if (($mimetype == "image/pjpeg") || ($mimetype == "image/jpeg") || ($mimetype == "image/x-png") || ($mimetype == "image/png") || ($mimetype == "image/gif") ||
            ($mimetype == "image/x-windows-bmp") || ($mimetype == "image/bmp")) {
        return true;
    } else {
        return false;
    }
}

function isValidWMImageType($mimetype, $filename, $tempname) {
    /* if (($mimetype == "image/pjpeg") || ($mimetype == "image/jpeg") || ($mimetype == "image/gif")) {
      return true;
      } else {
      return false;
      } */
    $blacklist = array("php", "phtml", "php3", "php4", "js", "shtml", "pl", "py", "exe");
    foreach ($blacklist as $file) {
        if (preg_match("/\.$file\$/i", "$filename")) {
            return false;
        }
    }
    //check if its image file
    if (!getimagesize($tempname)) {
        return false;
    }
    if ($mimetype == "image/gif") {
        return true;
    } else {
        return false;
    }
}

function getFilePermission($file) {
    $perm = fileperms($file);
    if ($perm === false) {
        return "0000";
    } else {
        return substr(sprintf('%o', $perm), -4);
    }
}

function stripslashes_deep($value) {
    $value = is_array($value) ? array_map('stripslashes_deep', $value) : stripslashes($value);
    return $value;
}

function getServerOS() {
    return strtoupper(substr(PHP_OS, 0, 3));
}

//deprecated in php 5.3
//@set_magic_quotes_runtime(0);

if (get_magic_quotes_gpc()) {
    $_POST = array_map('stripslashes_deep', $_POST);
    $_GET = array_map('stripslashes_deep', $_GET);
    $_COOKIE = array_map('stripslashes_deep', $_COOKIE);
}

function file_writable($file) {
    $permission = substr(sprintf('%o', fileperms($file)), -4);
    if ($permission == '0777' || $permission == '0666') {
        return true;
    } else {
        return false;
    }
}

$schemafile = "schema.sql";
$datafile = "data.sql";
$configfile = "../config.php";


$configcontents = @fread(@fopen($configfile, 'r'), @filesize($configfile));
$pos = strpos($configcontents, "INSTALLED");
if ($pos === false) {
;
} else {
    header("Location:../index.php");
}

$fullurl = $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']);
if ($_SERVER['HTTPS'] == 'on') {
    $http = "https://";
} else {
    $http = "http://";
}
$pos = strrpos($fullurl, "/");
if ($pos === false) { // note: three equal signs
    // not found...
} else {
    $fullurl = substr($fullurl, 0, $pos);
}

$installed = false;
$txtDBServerName = "localhost";
$txtTablePrefix = "VistaCart_";
$mystring = dirname(dirname(__FILE__));
$findme = '/webroot';
$ps = strpos($mystring, $findme);
$dr = substr($mystring, 0, $ps);

$dbconfigfile = $dr . "/config/database.php";
$configfile = $dr . "/webroot/config.php";
$wpconfigfile = $dr . "/webroot/blog/wp-config.php";

$txtSiteURL = "http://" . $fullurl;
$txtSecureSiteURL = "https://" . $fullurl;
$txtSiteURLt = "http://" . $fullurl;
$txtSecureSiteURLt = "https://" . $fullurl;
$txtSiteBaseFolderfull = dirname($_SERVER['PHP_SELF']);
$findu = '/app/webroot';
$murl = strpos($txtSiteURL, $findu);
$txtSiteURL = substr($txtSiteURL, 0, $murl);
$len = strpos($txtSiteBaseFolderfull, $findu);
$txtSiteBaseFolder = substr($txtSiteBaseFolderfull, 0, $len);
//print_r($txtSiteBaseFolder);exit;

$murs = strpos($txtSecureSiteURL, $findu);
$txtSecureSiteURL = substr($txtSecureSiteURL, 0, $murs);
/* * ********************************check server configuration **************************************************** */

$server_flag = true;

$val1 = ini_get("safe_mode");
$val3 = ini_get("file_uploads");

$gd = function_exists('gd_info');
$curl = function_exists('curl_init');
$mysql = function_exists('mysql_connect');

if (!empty($val1) || $val1 == 1) {
    $server_flag = false;
} elseif (empty($val3) || $val3 != 1) {
    $server_flag = false;
} elseif (!$gd) {
    $server_flag = false;
} elseif (!$curl) {
    $server_flag = false;
} elseif (!$mysql) {
    $server_flag = false;
}

$mysqlsupport = true;
if (!function_exists('mysql_connect')) {

    $mysqlsupport = false;
}

if (!$server_flag) {
    $serverconfiguration = "FAILURE";
} else {
    $serverconfiguration = "OK";
}

/* --------------------Check server PHP configuration--------------------------- */
$sapi_type = php_sapi_name();
$chmodstatus = '000';
if (substr($sapi_type, 0, 3) == 'cgi') {
    $chmodstatus = '755';
    $write = 'WRITABLE';
} else {
    if (substr(@php_uname(s), 0, 7) == "Windows") {
        $chmodstatus = '000';
    } else {
        $chmodstatus = '777';
    }
    $write = 'UNWRITABLE';
}

$directories = array("/webroot/img/products/",
    "/webroot/img/csv/",
    "/webroot/Fax/", 
    "/webroot/files/",
    "/webroot/files/File/",
    "/webroot/files/Flash/",
    "/webroot/files/Image/",
    "/webroot/files/Media/",
    "/webroot/files/Graph/",
    "/webroot/img/SiteLogo_disp.gif",
    "/webroot/img/SiteLogo.jpg",
    "/tmp/cache/",
    "/tmp/cache/models/",
    "/tmp/cache/views/",
    "/tmp/cache/persistent/",
    "/tmp/",
    "/tmp/logs/",
    "/tmp/sessions/",
    "/webroot/img/",
    "/webroot/css/",
    "/webroot/Fedex/shipping_label/",
    "/webroot/Fedex/",
    "/webroot/blog/wp-content/",
    "/webroot/blog/wp-config.php",
    "/controllers/components/pple.xml",
    "/config/database.php",
    "/webroot/config.php");

$perm_msg = '';
$perm_flag = true;
$host_name = parse_url($_SERVER['HTTP_HOST']);

if ($chmodstatus == '777') {
    if (isset($_POST["btnContinue"]) && !isset($_POST["auto_set"])) {
        $txtFTPusername = $_POST['FTPusername'];
        $txtFTPpassword = $_POST['FTPpassword'];

        if (trim($txtFTPusername) == '') {
            $perm_msg .= '* Please enter FTP username <br/>';
        }
        if (trim($txtFTPpassword) == '') {
            $perm_msg .= '* Please enter FTP password <br/>';
        } else {
            $conn_id = @ftp_connect($host_name["path"]);
            $login_result = @ftp_login($conn_id, $txtFTPusername, $txtFTPpassword);
            if ($login_result) {
                $mode = 777;
                $np = '0' . $mode;

                $user_install = str_replace('/webroot/install', '', getcwd());

                //get the path staring from public_html
                $path_parts = explode('/public_html', $user_install);
                $user_install = '/public_html' . $path_parts[1];

                foreach ($directories as $directory) {
                    $edited_path = str_replace('..', '', $directory);
                    $directory = $user_install . $edited_path;
                    if ($directory[strlen($directory) - 1] == '/') {
                        $directory = substr($directory, 0, strlen($directory) - 1);
                    }
                    if (!@ftp_chmod($conn_id, eval("return({$np});"), $directory)) {
                        $perm_flag = false;
                    }
                }

                if (!$perm_flag) {
                    $perm_msg .= '* Sorry, an error occurred. Please try again or set the permissions manually <br/>';
                } else {
                    $perm_msg = '<b>* File permissions successfuly set </b><br/>';
                }
            } else {
                $perm_msg .= '* Sorry, could not connect to the server. Please check the credentials <br/>';
            }
        }
    }
} elseif ($chmodstatus == '755') {
    //cgi handler requires 755 so no file permission change needed
} elseif ($chmodstatus == '000') {
    //ftp_chmod wont work on windows
}

/* ----------------------------------------------------------------------------- */

if ($write == 'UNWRITABLE') {
    $productsdir = "../img/products/";
    $csvdir = "../img/csv/";
    $faxdir = "../Fax/";
    $flsdir = "../files/";
    $fledir = "../files/File/";
    $flashdir = "../files/Flash/";
    $imagedir = "../files/Image/";
    $mediadir = "../files/Media/";
    $graphdir = "../files/Graph/";
    $sitelogo1 = "../img/SiteLogo_disp.gif";
    $sitelogo2 = "../img/SiteLogo.jpg";
    $cashdir = "../../tmp/cache/";
    $cashmodeldir = "../../tmp/cache/models/";
    $cashviewdir = "../../tmp/cache/views/";
    $cashpersistentdir = "../../tmp/cache/persistent/";
    $tmpdir = "../../tmp/";
    $tmplogs = "../../tmp/logs/";
    $sessdir = "../../tmp/sessions/";
    $imgdir = "../img/";
    $styledir = "../css/";
    $fedexshipdir = "../Fedex/shipping_label/";
    $fedexdir = "../Fedex/";
    $wp_dir = "../blog/wp-content/";
    $wp_config = "../blog/wp-config.php";
    $pple = "../../controllers/components/pple.xml";
    $dbconfig_file = "../../config/database.php";
    $config_file = "../config.php";
}//end if

$error = false;
$error_message = '';

//show alert only for non-cgi servers
if ($chmodstatus == '777' || $chmodstatus == '000') {
    if (!file_writable($productsdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/img/products' folder to 777 <br>";
    }//end if

    if (!file_writable($csvdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/img/csv' folder to 777 <br>";
    }//end if

    if (!file_writable($faxdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/Fax' folder to 777 <br>";
    }//end if

    if (!file_writable($flsdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/files' folder to 777 <br>";
    }//end if

    if (!file_writable($fledir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/files/File' folder to 777 <br>";
    }//end if

    if (!file_writable($flashdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/files/Flash' folder to 777 <br>";
    }//end if

    if (!file_writable($imagedir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/files/Image' folder to 777 <br>";
    }//end if

    if (!file_writable($mediadir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/files/Media' folder to 777 <br>";
    }//end if

    if (!file_writable($graphdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/files/Graph' folder to 777 <br>";
    }//end if

    if (!file_writable($sitelogo1)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/img/SiteLogo_disp.gif' to 777 <br>";
    }//end if

    if (!file_writable($sitelogo2)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/img/SiteLogo.jpg' to 777 <br>";
    }//end if

    if (!file_writable($cashdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/tmp/cache' folder to 777 <br>";
    }//end if

    if (!file_writable($cashmodeldir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/tmp/cache/models' folder to 777 <br>";
    }//end if

    if (!file_writable($cashviewdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/tmp/cache/views' folder to 777 <br>";
    }//end if

    if (!file_writable($cashpersistentdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/tmp/cache/persistent' folder to 777 <br>";
    }//end if

    if (!file_writable($tmpdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/tmp' folder to 777 <br>";
    }//end if

    if (!file_writable($tmplogs)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/tmp/logs' folder to 777 <br>";
    }//end if

    if (!file_writable($sessdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/tmp/sessions' folder to 777 <br>";
    }//end if

    if (!file_writable($tmplogs)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/tmp/logs' folder to 777 <br>";
    }//end if

    if (!file_writable($imgdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/img' folder to 777 <br>";
    }//end if

    if (!file_writable($styledir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/css' folder to 777 <br>";
    }//end if

    if (!file_writable($fedexshipdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/Fedex/shipping_label' folder to 777 <br>";
    }//end if

    if (!file_writable($fedexdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/Fedex' folder to 777 <br>";
    }//end if

    if (!file_writable($wp_dir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/blog/wp-content' folder to 777 <br>";
    }//end if

    if (!file_writable($wp_config)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/blog/wp-config.php' to 777 <br>";
    }//end if
    
    if (!file_writable($pple)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/controllers/components/pple.xml' to 777 <br>";
    }//end if
    
    if (!file_writable($dbconfig_file)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/config/database.php' to 777 <br>";
    }//end if

    if (!file_writable($config_file)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/config.php' to 777 <br>";
    }//end if
}

/* ---------------------------------------------------------------------------------------------------------------- */
$post_flag = false;

if ($_POST["btnContinue"] == "Continue") {
    $txtDBServerName = $_POST["txtDBServerName"];
    $txtDBName = $_POST["txtDBName"];
    $txtDBUserName = $_POST["txtDBUserName"];
    $txtDBPassword = $_POST["txtDBPassword"];
    $txtSiteName = $_POST["txtSiteName"];
    $txtAdminName = $_POST["txtAdminName"];
    $txtAdminPassword = $_POST["txtAdminPassword"];
    $txtConfirmAdminPassword = $_POST["txtConfirmAdminPassword"];
    $txtLicenseKey = $_POST["txtLicenseKey"];
    $txtAdminEmail = $_POST["txtAdminEmail"];
    $txtTablePrefix = $_POST["txtTablePrefix"];


    $post_flag = true;
    $message = "";

    if (!isNotNull($txtDBServerName)) {
        $message .= " * Database Server Name is empty!" . "<br>";
        $error = true;
    }
    if (!isNotNull($txtDBName)) {
        $message .= " * Database Name is empty!" . "<br>";
        $error = true;
    }
    if (!isNotNull($txtDBUserName)) {
        $message .= " * Database User Name is empty!" . "<br>";
        $error = true;
    }
    if (!isNotNull($txtSiteName)) {
        $message .= " * Site Name is empty!" . "<br>";
        $error = true;
    }
    if (!isNotNull($txtAdminEmail)) {
        $message .= " * Admin Email is empty!" . "<br>";
        $error = true;
    } else {
        if (!isValidEmail($txtAdminEmail)) {
            $message .= " * Invalid Admin Email!" . "<br>";
            $error = true;
        }
    }

    $connection = @mysql_connect($txtDBServerName, $txtDBUserName, $txtDBPassword);
    if ($connection === false) {
        $error = true;
        $message .= " * Connection Not Successful! Please verify your database details!<br>";
    } else {
        $dbselected = @mysql_select_db($txtDBName, $connection);
        if (!$dbselected) {
            $error = true;
            $message .= " * Database could not be selected! Please verify your database details!<br>";
        }
    }

    //exit;

    if ($error) {
        $message = "<u><b>Please correct the following errors to continue:</b></u>" . "<br><br>" . $message;
        // echo $message;
    } else {

        //-------------------------UPDATE CONFIG FILE---------------------------//
        $uniqueid = time() . mt_rand() . session_id();
        if (strlen($uniqueid) > 15) {
            $uniqueid = substr($uniqueid, 0, 15);
            $uniqueid = md5($uniqueid);
        }
        $fp = fopen($configfile, "w+");
        $configcontent = "<?php\n";
        $configcontent .= "define('INSTALLED', true); \n\n";
        $configcontent .= "define('VERSION', '2.0'); \n\n";
        $configcontent .= "\n?>";
        fwrite($fp, $configcontent);

        //---------------------------UPDATE THE DB CONNECTOR--------------------//
        $default = '$default';
        $fpp = fopen($dbconfigfile, "w+");
        $dbconfigcontent = "<?php\n";
        $dbconfigcontent .= "class DATABASE_CONFIG { \n\n";
        $dbconfigcontent .= "var $default = array( \n\n";
        $dbconfigcontent .= "'driver' => 'mysql', \n\n";
        $dbconfigcontent .= "'persistent' => false,\n\n";
        $dbconfigcontent .= "'host' => '" . $txtDBServerName . "',\n\n";
        $dbconfigcontent .= "'login' => '" . $txtDBUserName . "',\n\n";
        $dbconfigcontent .= "'password' => '" . $txtDBPassword . "',\n\n";
        $dbconfigcontent .= "'database' => '" . $txtDBName . "',\n\n";
        $dbconfigcontent .= "'prefix' => '" . $txtTablePrefix . "', \n\n";
        $dbconfigcontent .= "); \n\n";
        $dbconfigcontent .= "}\n\n";
        $dbconfigcontent .= "\n?>";
        fwrite($fpp, $dbconfigcontent);        
        
        //-------------------------UPDATE WP DB CONNECTOR-----------------------//
        $handle = fopen($wpconfigfile, "rb");
        $contents = fread($handle, filesize($wpconfigfile));
        fclose($handle);
        
        $contents = str_replace('CON_DB_NAME', $txtDBName, $contents);
        $contents = str_replace('CON_DB_USER', $txtDBUserName, $contents);
        $contents = str_replace('CON_DB_PASS', $txtDBPassword, $contents);
        $contents = str_replace('CON_DB_HOST', $txtDBServerName, $contents);
        $contents = str_replace('CON_DB_PREFIX', $txtTablePrefix . 'wp_', $contents);
        
        $fp = fopen($wpconfigfile, 'w');
        fwrite($fp, $contents);
        fclose($fp);

        //------------------------UPDATE THE DB---------------------------------//
        $sqlquery = @fread(@fopen($schemafile, 'r'), @filesize($schemafile));
        $sqlquery = preg_replace('/Vista_/', $txtTablePrefix, $sqlquery);
        $sqlquery = splitsqlfile($sqlquery, ";");
        
        for ($i = 0; $i < sizeof($sqlquery); $i++) {
            mysql_query($sqlquery[$i], $connection);
        }

        $dataquery = @fread(@fopen($datafile, 'r'), @filesize($datafile));
        $dataquery = preg_replace('/Vista_/', $txtTablePrefix, $dataquery);
        $dataquery = splitsqlfile($dataquery, ";");
        
        for ($i = 0; $i < sizeof($dataquery); $i++) {
            mysql_query($dataquery[$i], $connection);
        }


        //-------------------UPDATE INITIAL CONFIG VALUES-----------------------//
        $adminusername = mysql_real_escape_string($txtAdminName);
        $adminpassword = md5($txtAdminPassword);
        $adminmailpword = $txtAdminPassword;
        $adminblogpword = $txtAdminPassword . '_' . time();
        
        include_once( $dr . "/webroot/blog/wp-includes/class-phpass.php" );
        $wp_hasher = new PasswordHash( 8, TRUE );
        $hashed_wp_password = $wp_hasher->HashPassword( $adminblogpword );
        
        $sqladminsettings = "UPDATE " . $txtTablePrefix . "admins SET admin_name = '" . $adminusername . "',admin_pword ='" . $adminpassword . "', blog_pword = '" . $adminblogpword . "', email = '" . mysql_real_escape_string($txtAdminEmail) . "' WHERE admin_name = 'admin'";
        mysql_query($sqladminsettings) or die(mysql_error());
        
        $sqlsettings = "UPDATE " . $txtTablePrefix . "settings SET value = '" . mysql_real_escape_string($txtSiteName) . "' WHERE fieldname ='site_name'";
        mysql_query($sqlsettings) or die(mysql_error());
        
        $sqlsettings = "UPDATE " . $txtTablePrefix . "settings SET value = '" . mysql_real_escape_string($txtSiteBaseFolder) . "' WHERE fieldname ='sitebasefolder'";
        mysql_query($sqlsettings) or die(mysql_error());
        
        $sqlsettings1 = "UPDATE " . $txtTablePrefix . "settings SET value = '" . mysql_real_escape_string($txtAdminEmail) . "' WHERE fieldname ='admin_email'";
        mysql_query($sqlsettings1) or die(mysql_error());
        
        $sqlsettings1 = "UPDATE " . $txtTablePrefix . "settings SET value = '" . mysql_real_escape_string($txtLicenseKey) . "' WHERE fieldname ='vLicenceKey'";
        mysql_query($sqlsettings1) or die(mysql_error());
        
        $sqlsettings1 = "UPDATE " . $txtTablePrefix . "settings SET value = '" . mysql_real_escape_string($txtSecureSiteURL) . "' WHERE fieldname ='secureURL'";
        mysql_query($sqlsettings1) or die(mysql_error());
        
        $sqlsettings1 = "UPDATE " . $txtTablePrefix . "wp_users SET user_pass = '" . mysql_real_escape_string($hashed_wp_password) . "', user_email = '" . mysql_real_escape_string($txtAdminEmail) . "' WHERE ID = 1";
        mysql_query($sqlsettings1) or die(mysql_error());
        
        $admin_link = $txtSiteURL . '/admins';
        $blog_link = $txtSiteURL . '/app/webroot/blog';

        $sqlsettings1 = "UPDATE " . $txtTablePrefix . "wp_add_custom_link SET href = '" . mysql_real_escape_string($admin_link) . "' WHERE custom_link_id = 2";
        mysql_query($sqlsettings1) or die(mysql_error());
        
        $sqlsettings1 = "UPDATE " . $txtTablePrefix . "wp_options SET option_value = '" . mysql_real_escape_string($blog_link) . "' WHERE option_id IN(3, 39)";
        mysql_query($sqlsettings1) or die(mysql_error());
        
        $sqlsettings1 = mysql_query("SELECT option_value, option_id FROM " . $txtTablePrefix . "wp_options WHERE option_id IN(116, 268)");
        if($sqlsettings1){
            while($sqlres = mysql_fetch_array($sqlsettings1)){
                $text_val = $sqlres['option_value'];
                $text_val = str_replace('http://localhost/vistacart', $txtSiteURL, $text_val);
                
                mysql_query("UPDATE " . $txtTablePrefix . "wp_options SET option_value = '" . mysql_real_escape_string($text_val) . "' WHERE option_id = " . $sqlres['option_id']);
            }
        }        
        
        $sqlsettings1 = "UPDATE " . $txtTablePrefix . "wp_usermeta SET meta_key = '" . $txtTablePrefix . "wp_capabilities' WHERE umeta_id IN(10)";
        mysql_query($sqlsettings1) or die(mysql_error());
        
        $sqlsettings1 = "UPDATE " . $txtTablePrefix . "wp_usermeta SET meta_key = '" . $txtTablePrefix . "wp_user_level' WHERE umeta_id IN(11)";
        mysql_query($sqlsettings1) or die(mysql_error());
        
        $sqlsettings1 = "UPDATE " . $txtTablePrefix . "wp_options SET option_name = '" . $txtTablePrefix . "wp_user_roles' WHERE option_id IN(99)";
        mysql_query($sqlsettings1) or die(mysql_error());
        
        $installed = true;
        
        // section to send details to admin...............................
        $pos = strpos($_SERVER['SCRIPT_NAME'], '/webroot');
        $ck = substr($_SERVER['SCRIPT_NAME'], 0, $pos);

        $s = null;
        if ($_SERVER['HTTPS']) {
            $s = 's';
        }
        $httpHost = $_SERVER['HTTP_HOST'];
        if (isset($httpHost)) {
            $ser = 'http' . $s . '://' . $httpHost;
        }
        unset($httpHost, $s);
        $ft = '';
        $ft = @file_get_contents($ser . "/" . $ck . "/config/rewtest/link2.html");
        if (php_sapi_name() == 'apache2handler') {
            $apach = true;
        } else {
            $apach = false;
        }
        if ($apach != true || $ft == '') {
            $admurl = $txtSiteURL . "/admins/";
            $sturl = $txtSiteURL;
        } else {
            $admurl = $txtSiteURL . "/admins/";
            $sturl = $txtSiteURL;
        }
        /* -------------- /
          New code for install tracker, added by girish
          /------------------ */
        $string = "";
        $pro = urlencode("VistaCart 2.0");
        $dom = urlencode($txtSiteURL);
        $ipv = urlencode($_SERVER['REMOTE_ADDR']);
        $mai = urlencode($txtAdminEmail);
        $string = "pro=$pro&dom=$dom&ipv=$ipv&mai=$mai";
        $contents = "no";
        $file = @fopen("http://www.iscripts.com/installtracker.php?$string", 'r');
        if ($file) {
            $contents = @fread($file, 8192);
        }
        /* -------------- /
          New code for install tracker, added by girish
          /------------------ */
        $subject = "Script Installed at " . $txtSiteName;
        $headers = "From: " . $txtSiteName . "<" . $txtAdminEmail . ">\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=iso-8859-1\r\n";
        $path = "SiteLogo_disp.gif";
        $mcont = "<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>
<tr><td><a href='" . $sturl . "' target='_blank'><img src='" . $sturl . "/img/" . $path . "' border='0'></a></td></tr></table>";
        $mailcontent = $mcont . "Hello , <br>";
        $mailcontent .= "Your Store is successfully installed.<br> <a href='" . $sturl . "' target='_blank'>Click Here to Access your Store</a>";
        $mailcontent .= "<br><a href='" . $admurl . "' target='_blank'>Click Here to Access your Store Administration Control Panel</a> <br>";
        $mailcontent .= "Your Admin Username   :  " . $adminusername;
        $mailcontent .= "<br>Your Admin Password   :  " . $adminmailpword;
        $mailcontent .= "<br> Thanks and regards,<br> " . $txtSiteName . " Team";
        $mailsent = mail(mysql_real_escape_string($txtAdminEmail), $subject, $mailcontent, $headers);
        // section to send details to admin...............................
    }
}

function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "") {
    $theValue = (!get_magic_quotes_gpc()) ? mysql_real_escape_string($theValue) : $theValue;

    switch ($theType) {
        case "text":
            $theValue = ($theValue != "") ? "'" . $theValue . "'" : "''";
            break;
        case "long":
        case "int":
            $theValue = ($theValue != "") ? intval($theValue) : "''";
            break;
        case "double":
            $theValue = ($theValue != "") ? "'" . doubleval($theValue) . "'" : "''";
            break;
        case "date":
            $theValue = ($theValue != "") ? "'" . $theValue . "'" : "''";
            break;
        case "defined":
            $theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue;
            break;
    }
    return $theValue;
}
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
    "http://www.w3.org/TR/html4/loose.dtd">
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
        <title>iScripts VistaCart Installer</title>
        <link href="<?php echo $stylesfolder.'/'.$sitestyle ?>" rel="stylesheet" type="text/css">
    </head>
    <script type="text/javascript" src="../js/jquery.js"></script>
    <script type="text/javascript">
        function divToggle(elem)
        {
            if($(elem).attr('checked')){
                $('#err_div').slideDown('slow');
            }
            else{
                $('#err_div').slideUp('slow');
            }
        }
    </script>
    <style type="text/css">
        .install_option {  font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9pt; color: #333333}
        .install_value_ok { font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9pt; font-weight: bold; color: #009900 }
        .install_value_fail { font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 7pt; font-weight: bold; color: #CC0000}
        .block_class{
            color:#F4700E;
            font-family: Verdana, Arial, Helvetica, sans-serif;
            font-weight: bold;}	

    </style>
    <body class="bodyinstaller">
        <div class="header_row" >
            <div class="header_container  sitewidth">
                <table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
                    <tr>
                        <td width="23%" align="left" ></td>
                        <td width="77%" align="right">
						<h4>iScripts VistaCart Installer</h4>
						<?php
						if (php_sapi_name() != 'apache2handler' || $ft == '') {
    ?>
                                    <div align="center" id="items_top_area">
                                        &nbsp;&nbsp;
                                        <a title="OnlineInstallationManual" href="#" onClick="window.open('<?php echo htmlentities($txtSiteURLt); ?>/Installation_Manual.pdf','OnlineInstallationManual','top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd');"><strong>Installation manual</strong></a>
                                        | <a title="Readme" href="#" onClick="window.open('<?php echo htmlentities($txtSiteURLt); ?>/Readme.txt','Readme','top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd');"><strong>Readme</strong></a> | 
                                        <a title="If you have any difficulty, submit a ticket to the support department" href="#" onClick="window.open('http://www.iscripts.com/support/postticketbeforeregister.php','','top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd,resizable=yes');">														
                                            <strong>Get Support</strong></a>
                                    </div>
                                <?php } else { ?>
                                    <div align="center" id="items_top_area">
                                        &nbsp;&nbsp;
                                        <a title="OnlineInstallationManual" href="#" onClick="window.open('<?php echo htmlentities($txtSiteURL); ?>/Installation_Manual.pdf','OnlineInstallationManual','top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd');"><strong>Installation manual</strong></a>
                                        | <a title="Readme" href="#" onClick="window.open('<?php echo htmlentities($txtSiteURL); ?>/Readme.txt','Readme','top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd');"><strong>Readme</strong></a> | 
                                        <a title="If you have any difficulty, submit a ticket to the support department" href="#" onClick="window.open('http://www.iscripts.com/support/postticketbeforeregister.php','','top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd,resizable=yes');">														
                                            <strong>Get Support</strong></a>
                                    </div>
                                <?php } ?>
						
                        </td>
                    </tr>
                </table>
				</div>
        </div>

        <table width="100%"  border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td><img src="../img/spacer.gif" width="1" height="5"></td>
            </tr>
        </table>
        <table width="100%"  border="0" cellspacing="0" cellpadding="0">
            <tr>

                <td width="76%" valign="top" height ="400">
                    <!-- Here's where I want my views to be displayed -->
                    <table width="80%" border="0" cellpadding="0" cellspacing="0" align="center">
                        <tr>
                            <td>
                                <!--------Installer starts------------------------->

                                <!--items display area start -->
<?php
$pos = strpos($_SERVER['SCRIPT_NAME'], '/webroot');
$ck = substr($_SERVER['SCRIPT_NAME'], 0, $pos);

$s = null;
if ($_SERVER['HTTPS']) {
    $s = 's';
}
$httpHost = $_SERVER['HTTP_HOST'];
if (isset($httpHost)) {
    $ser = 'http' . $s . '://' . $httpHost;
}
unset($httpHost, $s);
$ft = '';
$ft = @file_get_contents($ser . "/" . $ck . "/config/rewtest/link2.html");
//print_r($txtSiteURLt);exit;


                             
                                if ($serverconfiguration == "FAILURE") {
                                    ?>
                                    <table width="80%" border=0 align="center">
    <?php
    $ivo = "<span class='install_value_ok'>";
    $ivf = "<span class='install_value_fail'>";
    $sc = "</span>";
    echo "<tr><td class=maintext><b></b><br><br></td></tr>";
    echo "<tr><td class=maintext>Checking PHP Version... " . $ivo . PHP_VERSION . $sc . " ";
    if (version_compare(PHP_VERSION, "4.2.0") >= 0)
        echo $ivo . "" . $sc; else {
        echo $ivf . "(4.2.0 or higher required)" . $sc;
        $fatal = true;
    }
    echo "</td></tr>";
    echo "<tr><td class=maintext>Checking System Information... " . $ivo . PHP_OS . $sc . "</td></tr>";
    echo "<tr><td class=maintext>Checking PHP Server API... " . $ivo . php_sapi_name() . $sc . "</td></tr>";
    echo "<tr><td class=maintext>Checking Path to 'php.ini'... " . $ivo . PHP_CONFIG_FILE_PATH . $sc . "</td></tr>";
    $mysqlsupport = true;
    if (!function_exists('mysql_connect')) {
        $mysqlsupport = false;
    }
    echo "<tr><td class=maintext>Checking Mysql support... ";
    echo $ivo . (( $mysqlsupport) ? "On" : " $ivf This program requires MYSQL support. Please recompile your PHP with MYSQL Support.") . $sc;
    echo "</td></tr>";
    echo "<tr><td class=maintext>Checking safe_mode... ";
    $val1 = ini_get("safe_mode");
    echo ((!empty($val1) || $val1 == 1) ? $ivf . "On-Please turn off safe_mode in the php.ini" : $ivo . "Off") . $sc;
    echo "</td></tr>";
    
    echo "<tr><td class=maintext>Checking file_uploads...";
    $val3 = ini_get("file_uploads");
    echo ((!empty($val3) || $val3 == 1) ? $ivo . "On" : $ivf . "Off - Please turn on file_uplaods in the php.ini file") . $sc;
    echo "</td></tr>";
    
    echo "<tr><td class=maintext>Checking CURL support... ";
    $val5 = function_exists('curl_init');
    if ($val5) {
        echo $ivo . "On";
    } else {
        echo $ivf . "Off-Please re-compile php with CURL support" . $sc;
    }
    echo "</td></tr>";
    echo "<tr><td class=maintext>Checking GD support... ";
    $val6 = function_exists('gd_info');
    if ($val6) {
        echo $ivo . "On";
    } else {
        echo $ivf . "Off-Please re-compile php with GD support" . $sc;
    }
    echo "</td></tr>";

    echo "<tr><td class=maintext>" . $ivf . "Fatal errors detected.  Please correct the above red items and reload.</td></tr>";
    ?>
                                    </table>

                                        <?php
                                    } else if (!$installed) {
                                        ?>
                                    <table width="80%" border="0" align="center">
                                        <tr>
                                            <td align="center" ><b><font size="1">
                                                    <div align="justify" >
                                                        <br>
                                                        <font color="#F4700E" size="+1">Thank you for choosing iScripts VistaCart&nbsp;</font> <br><br>
                                                        <font color="#000000" size="2"><img src="../img/dot.jpg">&nbsp;To complete this installation please enter the details below.</font>
                                                    </div>

                                                    </font></b>
                                            </td>
                                        </tr>
                                        <?php if ($post_flag) { ?>
                                            <tr>
                                                <td align=center class="message" >
                                                    <div align="left" class="text_information">
                                                        <br>
                                                        <font color="#FF0000"><?php echo $message; ?></font><br>
                                                        <font color="#FF0000"><?php echo $error_message; ?></font><br>
                                                    </div>
                                                </td>
                                            </tr>
                                    <?php } ?>
                                        <tr>
                                            <td class=maintext align="left" >
                                                Note: All Fields Are Mandatory.
                                                <br>
                                                <form name="frmInstall" method="post" action="<?php echo $_SERVER["PHP_SELF"]; ?>" enctype="multipart/form-data">
                                                    <br>

                                                    <FIELDSET>
                                                        <LEGEND class='block_class'>File Permissions</LEGEND>
                                                        <table width=85% border="0" cellpadding="2" cellspacing="2" class=maintext>
                                                            <tr>
                                                                <td colspan="2" align="left">
                                                                    <b>
                                        <?php if ($chmodstatus == '777') { ?>
                                                                            iScripts VistaCart requires that some of the folders have write permission. You can provide an FTP login so that this process is done automatically.<br/><br/>
                                                                            For security reasons, it is best to create a separate FTP user account with access to the iScripts VistaCart installation only and not the entire web server. Your host can assist you with this.
                                                                            If you have difficulties completing installation without these credentials, please click "I would provide permissions manually" to do it yourself.<br/><br/>
    <?php } elseif ($chmodstatus == '000') { ?>
                                                                            iScripts VistaCart requires that some of the folders have write permission. Please provide write permission for the following files :-<br/><br/>
    <?php } elseif ($chmodstatus == '755') { ?>
                                                                            iScripts VistaCart requires that some of the folders have write permission.<br/><br/>
    <?php } ?>
                                                                    </b>
                                                                </td>
                                                            </tr>
    <?php if ($write == 'UNWRITABLE') { ?>
                                                                <tr>
                                                                    <td class=maintext align="left">FTP username</td>
                                                                    <td width="61%" align=left>
                                                                        <input name="FTPusername"  id="FTPusername" type="text" size="50" value="<?php echo htmlentities($txtFTPusername); ?>">								
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td class=maintext align="left">FTP password</td>
                                                                    <td width="61%" align=left>
                                                                        <input name="FTPpassword"  id="FTPpassword" type="password" size="50" value="<?php echo htmlentities($txtFTPpassword); ?>">
                                                                    </td>
                                                                </tr>
        <?php if ($chmodstatus == '777') { ?>
                                                                    <tr>
                                                                        <td colspan="2" align="left">
                                                                            <input type="checkbox" name="auto_set" id="auto_set" onclick="divToggle(this)" /> &nbsp; I would provide permissions manually
                                                                        </td>
                                                                    </tr>                                                
                                                                                <?php
                                                                            }
                                                                        } else {
                                                                            ?>
                                                                <tr>
                                                                    <td colspan="2" align="left">
                                                                        <b>File permissions are OK.</b>
                                                                    </td>
                                                                </tr>
    <?php } ?>
                                                        </table>
    <?php if ($write == 'UNWRITABLE') { ?>
                                                            <div id="err_div" style="<?php if ($chmodstatus == '777') { ?>display:none<?php } ?>">
                                                                <fieldset>
                                                                    <legend>Directories/Files List</legend>
        <?php echo $error_message; ?>
                                                                </fieldset>
                                                            </div>
                                                            <?php } ?>
                                                    </FIELDSET>
                                                    <br>
                                                    <br>

                                                    <FIELDSET>
                                                        <LEGEND class='block_class'>Database Details</LEGEND>
                                                        <table width=85% border=0 cellpadding="2" cellspacing="2" class=maintext>
                                                            <tr>
                                                                <td colspan="2" class=maintext align="left">Database Server</td>
                                                                <td width="61%" align=left>
                                                                    <input type="text" name="txtDBServerName" id="txtDBServerName" value="<?php echo htmlentities($txtDBServerName); ?>">
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" class=maintext align="left">Database Name</td>
                                                                <td width="61%" align=left>
                                                                    <input name="txtDBName"  id="txtDBName" type="text"   class="textbox"  maxlength="100" size="50" value="<?php echo htmlentities($txtDBName); ?>" >								
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" class=maintext align="left">Database User Name</td>
                                                                <td width="61%" align=left>
                                                                    <input name="txtDBUserName"  id="txtDBUserName" type="text" maxlength="100" size="50" value="<?php echo htmlentities($txtDBUserName); ?>">
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" class=maintext align="left">Database Password</td>
                                                                <td width="61%" align=left>
                                                                    <input name="txtDBPassword"  id="txtDBPassword" type="text"  maxlength="100" size="50" value="<?php echo htmlentities($txtDBPassword); ?>">
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" class=maintext align="left">Table Prefix</td>
                                                                <td width="61%" align=left>
                                                                    <input name="txtTablePrefix"  id="txtTablePrefix" type="text"  maxlength="100" size="50" value="<?php echo htmlentities($txtTablePrefix); ?>">
                                                                </td>
                                                            </tr>

                                                        </table>
                                                    </FIELDSET><br><br>
                                                    <FIELDSET>
                                                        <LEGEND class='block_class'>Site Details</LEGEND>
                                                        <table width=85% border=0 cellpadding="2" cellspacing="2" class=maintext>
                                                            <tr>
                                                                <td colspan="2" class=maintext align="left">Site Name</td>
                                                                <td width="61%" align=left>
                                                                    <input name="txtSiteName"  id="txtSiteName" type="text" maxlength="100" size="50" value="<?php echo htmlentities($txtSiteName); ?>">
                                                                    <input name="txtSiteURL"  id="txtSiteURL" type="hidden" maxlength="100" value="<?php echo htmlentities($txtSiteURL); ?>" readonly >
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" class=maintext align="left">License Key</td>
                                                                <td width="61%" align=left>
                                                                    <input name="txtLicenseKey"  id="txtLicenseKey" type="text" maxlength="100" size="50" value="<?php echo htmlentities($txtLicenseKey); ?>">
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </FIELDSET>
                                                    <br>
                                                    <br>
                                                    <FIELDSET>
                                                        <LEGEND class="block_class">Administration Details</LEGEND>
                                                        <table width=85% border=0 cellpadding="2" cellspacing="2" class=maintext>							
                                                            <tr>
                                                                <td colspan="2" class=maintext  align="left">Admin Email</td>
                                                                <td width="61%" align=left>
                                                                    <input name="txtAdminName"  id="txtAdminName" type="hidden" maxlength="100" size="50" value="admin">

                                                                    <input name="txtAdminPassword"  id="txtAdminPassword" type="hidden" maxlength="100" size="50" value="admin">

                                                                    <input name="txtConfirmAdminPassword"  id="txtConfirmAdminPassword" type="hidden" maxlength="100" size="50" value="admin">

                                                                    <input name="txtAdminEmail"  id="txtAdminEmail" type="text"  maxlength="100" size="50" value="<?php echo htmlentities($txtAdminEmail); ?>">
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </FIELDSET>
                                                    <br>
                                                    <table width=100% border=0 cellpadding="2" cellspacing="2" class=maintext>
                                                       
                                                        <tr>
                                                            <td align="center">
                                                                <input type="submit" name="btnContinue" value="Continue" class="buttn_admin">
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </form>	
                                            </td>
                                        </tr>
                                    </table>
    <?php
} else {
    ?>
                                    <table width="80%" border="0" align="center">
                                        <tr>
                                            <td>
                                                <table width=85% border=0 cellpadding="2" cellspacing="2" class=maintext align="center">
                                                    <br>
                                                    <tr>
                                                        <td align="center" class="maintext" >
                                                            <font color="#F4700E" size="+1">Congratulations! The Installation Process was completed successfully!</font>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td align="center" class="maintext" height="20" >&nbsp;</td>
                                                    </tr>
                                                    <br>
                                                    <br>
                                                    <br>
                                                    <tr>
                                                        <td align="center"><span class="required">*</span><b>
                                                                All Payment Gateways are disabled by default,Please enable at least one payment gateway !!</b>
                                                        </td>
                                                    </tr>


                                                    <br>
                                    <?php
                                    $request_uri = explode('/', $_SERVER['REQUEST_URI']);

                                    $script_filename = explode('/', $_SERVER['SCRIPT_FILENAME']);
                                    $build_path = "http://" . $_SERVER['HTTP_HOST'] . "/" . $request_uri[1] . "/admin/login.php";
                                    $build_path_home = "http://" . $_SERVER['HTTP_HOST'] . "/" . $request_uri[1] . "/index.php";
                                    ?> 						
                                                    <tr>
                                                        <td align="center">
                                                            <br>
                                                            <fieldset>
                                                                <legend class="block_class">Site Login Details</legend>
                                                                <table cellpadding="0" cellspacing="0" width="95%" class="maintext" align="center">
                                                                    <tr>
                                                                        <td colspan="2">&nbsp;</td>
                                                                    </tr>
    <?php
    $pos = strpos($_SERVER['SCRIPT_NAME'], '/webroot');
    $ck = substr($_SERVER['SCRIPT_NAME'], 0, $pos);

    $s = null;
    if ($_SERVER['HTTPS']) {
        $s = 's';
    }
    $httpHost = $_SERVER['HTTP_HOST'];
    if (isset($httpHost)) {
        $ser = 'http' . $s . '://' . $httpHost;
    }
    unset($httpHost, $s);
    $ft = '';
    $ft = @file_get_contents($ser . "/" . $ck . "/config/rewtest/link2.html");
    if (php_sapi_name() == 'apache2handler') {
        $apach = true;
    } else {
        $apach = false;
    }
    ?>
                                                                    <tr>
                                                                        <td width="26%"><b><font size="-1">Admin URL&nbsp;:</font></b></td>
                                                                        <td width="74%"><a style="cursor:pointer" href="<?php echo $txtSiteURL . "/admins/" ?>"><img src="../img/admin_login_install.jpg" border="0" height="25" align="absmiddle">&nbsp; &nbsp; <?php echo $txtSiteURL . "/admins/"; ?></a></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td colspan="2">&nbsp;</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td  valign="top"><b><font size="-1">Admin Credentials&nbsp;:</font></b></td>
                                                                        <td  valign="top">
																			<div class="adm_cred">
                                                                            <font size="-1">Username&nbsp;:&nbsp;admin</font><br/><br/>
                                                                            <font size="-1">Password&nbsp;:&nbsp;admin</font>
																			</div>
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td colspan="2">&nbsp;</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td ><b><font size="-1">Home URL&nbsp;:</font></b></td>
                                                                        <td ><a style="cursor:pointer" href="<?php echo $txtSiteURL; ?>/"><img src="../img/home_page.jpg" border="0" height="25" align="absmiddle">&nbsp; &nbsp;<?php echo $txtSiteURL; ?>/</a></td>
                                                                    </tr>
                                                                </table>
                                                            </fieldset>	
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td align="center" class="maintext" height="20" >&nbsp;</td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
    <?php
}
?>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <div class="installr_footer"></div>
    </body>
</html>