<?php
function getfedexShippingLabel($sender, $recipient ,$fedexSettings, $wsdlpath = ""){

if($wsdlpath != "")
    $path_to_wsdl = $wsdlpath;
else
    $path_to_wsdl = "../shippingclient/fedex_label/wsdl/ShipService_v12.wsdl";


// Seller /admin
if(count($sender) > 0){
    $senderName = $sender["first"]." ".$sender["last"];
    $senderPhone = $sender["phone"];
    $senderStreet = $sender["street"];
    $senderLine2 = $sender["line2"];
    $senderCity = $sender["city"];
    $senderState = $sender["state"];
    $senderZip = $sender["zip"];
    $senderCountry = $sender['country'];

}
//// buyer
//
if(count($recipient) > 0){
    $recipientName = $recipient["first"]." ".$recipient["last"];
    $recipientPhone = $recipient["phone"];
    $recipientStreet = $recipient["street"];
    $recipientLine2 = $recipient["line2"];
    $recipientCity = $recipient["city"];
    $recipientState = $recipient["state"];
    $recipientZip = $recipient["zip"];
    $recipientCountry = $recipient['country'];
}

$billaccount = $fedexSettings['billaccount'];


define('SHIP_LABEL', 'shipexpresslabel.png');  // PNG label file. Change to file-extension .pdf for creating a PDF label (e.g. shiplabel.pdf)
define('SHIP_CODLABEL', 'CODexpressreturnlabel.png');  // PNG label file. Change to file-extension .pdf for creating a PDF label (e.g. CODexpressreturnlabel.pdf)

ini_set("soap.wsdl_cache_enabled", "0");

$client = new SoapClient($path_to_wsdl, array('trace' => 1)); // Refer to http://us3.php.net/manual/en/ref.soap.php for more information


$request['WebAuthenticationDetail'] = array(
	'UserCredential' => array(
		'Key' => $fedexSettings['key'], 
		'Password' => $fedexSettings['password']
	)
);
$request['ClientDetail'] = array(
	'AccountNumber' => $fedexSettings['shipaccount'],
	'MeterNumber' => $fedexSettings['meter']
);
$request['TransactionDetail'] = array('CustomerTransactionId' => '*** Express Domestic Shipping Request v12 using PHP ***');
$request['Version'] = array(
	'ServiceId' => 'ship', 
	'Major' => '12', 
	'Intermediate' => '1', 
	'Minor' => '0'
);

$request['RequestedShipment'] = array(
	'ShipTimestamp' => date('c'),
	'DropoffType' => 'REGULAR_PICKUP', // valid values REGULAR_PICKUP, REQUEST_COURIER, DROP_BOX, BUSINESS_SERVICE_CENTER and STATION
	'ServiceType' => 'PRIORITY_OVERNIGHT', // valid values STANDARD_OVERNIGHT, PRIORITY_OVERNIGHT, FEDEX_GROUND, ...
	'PackagingType' => 'YOUR_PACKAGING', // valid values FEDEX_BOX, FEDEX_PAK, FEDEX_TUBE, YOUR_PACKAGING, ...
	'TotalWeight' => array('Value' => 50.0, 'Units' => 'LB'), // valid values LB and KG
	'Shipper' => addShipper($senderName,$senderPhone,$senderStreet,$senderLine2,$senderCity,$senderState,$senderZip,$senderCountry),
	'Recipient' => addRecipient($recipientName,$recipientPhone,$recipientStreet,$recipientLine2,$recipientCity,$recipientState,$recipientZip,$recipientCountry),
	'ShippingChargesPayment' => addShippingChargesPayment($billaccount),
	'SpecialServicesRequested' => addSpecialServices(),
	'LabelSpecification' => addLabelSpecification(), 
	'RateRequestTypes' => array('ACCOUNT'), // valid values ACCOUNT and LIST
	'PackageCount' => 1,
	'RequestedPackageLineItems' => array(
		'0' => addPackageLineItem1()
	)
);


try 
{
	if(setEndpoint('changeEndpoint'))
	{
		$newLocation = $client->__setLocation(setEndpoint('endpoint'));
	}
          
	$response = $client->processShipment($request);  // FedEx web service invocation

    if ($response->HighestSeverity != 'FAILURE' && $response->HighestSeverity != 'ERROR')
    {    	
    	printSuccess($client, $response);
        
        $fp = fopen("./img/".SHIP_CODLABEL, 'wb');
        fwrite($fp, $response->CompletedShipmentDetail->AssociatedShipments->Label->Parts->Image); //Create COD Return PNG or PDF file
        fclose($fp);
        return SHIP_CODLABEL;
      /* echo '<a href="./'.SHIP_CODLABEL.'">'.SHIP_CODLABEL.'</a> was generated.'.Newline;

        // Create PNG or PDF label
        // Set LabelSpecification.ImageType to 'PDF' or 'PNG for generating a PDF or a PNG label       
        $fp = fopen(SHIP_LABEL, 'wb');   
        fwrite($fp, $response->CompletedShipmentDetail->CompletedPackageDetails->Label->Parts->Image); //Create PNG or PDF file
        fclose($fp);
        echo '<a href="./'.SHIP_LABEL.'">'.SHIP_LABEL.'</a> was generated.';exit;*/
    }
    else
    {
        printError($client, $response);
    }

    writeToLog($client);    // Write to log file
    
} catch (SoapFault $exception) {
    printFault($exception, $client);
}
}
function addShipper($senderName,$senderPhone,$senderStreet,$senderLine2,$senderCity,$senderState,$senderZip,$senderCountry){
	$shipper = array(
		'Contact' => array(
			'PersonName' => $senderName,
			'CompanyName' => 'Sender Company Name',
			'PhoneNumber' => $senderPhone),
		'Address' => array(
			'StreetLines' => array($senderStreet),
			'City' => $senderCity,
			'StateOrProvinceCode' => $senderState,
			'PostalCode' => $senderZip,
			'CountryCode' => $senderCountry)
	);
	return $shipper;
}
function addRecipient($recipientName,$recipientPhone,$recipientStreet,$recipientLine2,$recipientCity,$recipientState,$recipientZip,$recipientCountry){
	$recipient = array(
		'Contact' => array(
			'PersonName' => $recipientName,
			'CompanyName' => 'Recipient Company Name',
			'PhoneNumber' => $recipientPhone),
		'Address' => array(
			'StreetLines' => array($recipientStreet),
			'City' => $recipientCity,
			'StateOrProvinceCode' => $recipientState,
			'PostalCode' => $recipientZip,
			'CountryCode' => $recipientCountry,
			'Residential' => true)
	);
	return $recipient;	                                    
}
function addShippingChargesPayment($billaccount){
	$shippingChargesPayment = array('PaymentType' => 'SENDER',
        'Payor' => array(
		'ResponsibleParty' => array(
			'AccountNumber' => $billaccount,
			'Contact' => null,
			'Address' => array('CountryCode' => 'US'))));
	return $shippingChargesPayment;
}
function addLabelSpecification(){
	$labelSpecification = array(
		'LabelFormatType' => 'COMMON2D', // valid values COMMON2D, LABEL_DATA_ONLY
		'ImageType' => 'PNG',  // valid values DPL, EPL2, PDF, ZPLII and PNG
		'LabelStockType' => 'PAPER_7X4.75');
	return $labelSpecification;
}
function addSpecialServices(){
	$specialServices = array(
		'SpecialServiceTypes' => array('COD'),
		'CodDetail' => array(
			'CodCollectionAmount' => array('Currency' => 'USD', 'Amount' => 150),
			'CollectionType' => 'ANY')// ANY, GUARANTEED_FUNDS
	);
	return $specialServices; 
}
function addPackageLineItem1(){
	$packageLineItem = array(
		'SequenceNumber'=>1,
		'GroupPackageCount'=>1,
		'Weight' => array(
			'Value' => 5.0,
			'Units' => 'LB'),
		'Dimensions' => array(
			'Length' => 20,
			'Width' => 20,
			'Height' => 10,
			'Units' => 'IN')
	);
	return $packageLineItem;




}
?>
