<?php 
/*
##################################################################
#                       PHP 4&5 MySQL 4&5                        #
##################################################################
#           Copyright (c) 2004-2008 Armia Systems Inc            #
##################################################################
#               This file is part of Cybermatch site             #
##################################################################
#    Developed By: simi (simi@armia.com)                         #

##################################################################
#               Developed On:   03-04-2008                       #
##################################################################
#               Modified By:                                     #
##################################################################
#               Modified On:                                     #
##################################################################
# This script may not be distributed, sold, given away for free  #
# to third party, or used as a part of any internet services 	 #
# such as webdesign etc.                                         #
##################################################################
*/

require_once ("config.inc.php");
require_once ("includes/userlogincheck.inc.php");
require_once ("includes/mysql.inc.php");
require_once ("includes/arrays.inc.php");
require_once ("classes/misc.class.php");
require_once ("classes/userside.class.php");

$message	= "";
$script		= "";
$product	= isset($_REQUEST['product'])	?	trim($_REQUEST['product'])	:	"0";

if (!$objDB) {
	$message	= "Unable to Locate Database Server.";
} else {
	$objM		= new misc($objDB);
	$objU		= new userside($objDB);	
	
	if (isset($_POST['CNP'])) {
		$message	= $objU->backgroundcheck_form_check($_POST);
		if ($message == "") {
			header("Location:".$objU->SecureUrl()."/pay_now.php?product=$product&showmsgtype2=bckchek");
			exit();
		}
	} else {
		$array	= $objU->select($_SESSION['user_id']);
		$objU->set_values($array);
	}
	
	$script		= $objU->get_script($message);
	$message	= $objU->remove_script($message);
}

include_once ("title.inc.php");
include_once ("tophtml.inc.php");
?>
<script language="javascript" type="text/javascript">
function changeCSS(obj, type)
{
	
}
function validate1()
{
	var frm	= document.frmTell;
	
	if (frm.vFirstName.value == "") {
		alert("Please enter your first name.");
		frm.vFirstName.focus();
		frm.vFirstName.className ='textbox txt-bx01';
		return false;
	}
	if (frm.vLastName.value == "") {
		alert("Please enter your last name.");
		frm.vLastName.focus();
		frm.vLastName.className ='textbox txt-bx01';
		return false;
	}
	/*if (frm.vSSN.value == "") {
		alert("Please enter your SSN number.");
		frm.vSSN.focus();
		frm.vSSN.className ='textbox txt-bx01';
		return false;
	}*/
	if (frm.vDD.value == "") {
		alert("Please enter day of your date of birth.");
		frm.vDD.focus();
	
		return false;
	}
	if (frm.vMM.value == "") {
		alert("Please enter month of your date of birth.");
		frm.vMM.focus();
		
		return false;
	}
	if (frm.vYYYY.value == "") {
		alert("Please enter year of your date of birth.");
		frm.vYYYY.focus();
		
		return false;
	}
	
	if (frm.vStreet.value == "") {
		alert("Please enter your street address.");
		frm.vStreet.focus();
		frm.vStreet.className ='textbox txt-bx01';
		return false;
	}
	if (frm.vCity.value == "") {
		alert("Please enter your city address.");
		frm.vCity.focus();
		frm.vCity.className ='textbox txt-bx01';
		return false;
	}
	if (frm.vState.value == "") {
		alert("Please enter your state address.");
		frm.vState.focus();
		frm.vState.className ='textbox txt-bx01';
		return false;
	}
	if (frm.vPostCode.value == "") {
		alert("Please enter your postal code address.");
		frm.vPostCode.focus();
		frm.vPostCode.className ='textbox txt-bx01';
		return false;
	}
	if (frm.vPhone.value == "") {
		alert("Please enter your phone number.");
		frm.vPhone.focus();
		frm.vPhone.className ='textbox txt-bx01';
		return false;
	}

	return true;
}
function isNumberKey(evt)
{
   var charCode = (evt.which) ? evt.which : event.keyCode;
   if (charCode != 46 && charCode > 31 
     && (charCode < 48 || charCode > 57))
      return false;

   return true;
}
</script>

<div class="row">
	<div class="eight columns">
		<div class="search-rslts">
			<div class="row"><div class="inenr-hd"><h2>Make Your Profile Backgroundcheck Verified</h2></div></div>
			<div class="row">
				<h2 class="headings2">Make your profile as 'Backgroundcheck Verified' by paying an amount of $ <?php echo $objU->get_amount(4)?>.</h2>
			</div>
			<div class="row">
				<form name="frmTell" method="post" action="<?php echo $_SERVER['PHP_SELF']?>" onSubmit="return validate1();">
					<div class="newdesignforinput maintext1">
						<?php if(isset($message) && trim($message)!='')
							  {
						?>
						<div class="full_row">
							<div class="maintext1 warning"><?php echo $message;?></div>
						</div>
						<?php }//end if?>
						
						<div class="full_row">
							<div class="three columns">First Name <span class="warning">*</span></div>
							<div class="five columns margin_R_200">
								<input name="vFirstName" type="text" class="textbox txt-bx01" onKeyDown="changeCSS(this, 'text');" value="<?php echo htmlspecialchars($objU->vFirstName)?>" size="30" maxlength="200">
							</div>
						</div>
						
						<div class="full_row">
							<div class="three columns">Middle Name</div>
							<div class="five columns margin_R_200">
								<input name="vMiddleName" type="text" class="textbox txt-bx01" value="<?php echo htmlspecialchars($objU->vMiddleName)?>" size="30" maxlength="100">
							</div>
						</div>
						
						<div class="full_row">
							<div class="three columns">Last Name</div>
							<div class="five columns margin_R_200">
								<input name="vLastName" type="text" class="textbox txt-bx01"  onKeyDown="changeCSS(this, 'text');" value="<?php echo htmlspecialchars($objU->vLastName)?>" size="30" maxlength="200">
							</div>
						</div>
						
						<div class="full_row">
							<div class="three columns">SSN <?php /* <span class="warning">*</span> */ ?></div>
							<div class="five columns margin_R_200">
								<input name="vSSN" type="text" class="textbox txt-bx01"  onKeyDown="changeCSS(this, 'text');" value="<?php echo htmlspecialchars($objU->vSSN)?>" size="30" maxlength="200">
							</div>
						</div>
						
						<div class="full_row">
							<div class="three columns">DOB <span class="warning">*</span></div>
							<div class="five columns margin_R_200">
								<div class="two columns" align="center"><b>Day</b></div>
								<div class="two columns">
									<input name="vDD" type="text" class="textbox2"  value="<?php echo addslashes($objU->vDD)?>" size="2" maxlength="2" onkeypress="return isNumberKey(event)" >
								</div>
								<div class="two columns" align="center"><b>Month</b></div>
								<div class="two columns">
									<input name="vMM" type="text" class="textbox2"  value="<?php echo addslashes($objU->vMM)?>" size="2" maxlength="2" onkeypress="return isNumberKey(event)" >
								</div>
								<div class="two columns" align="center"><b>Year</b></div>
								<div class="two columns">
									<input name="vYYYY" type="text" class="textbox2" value="<?php echo addslashes($objU->vYYYY)?>" size="6" maxlength="4" onkeypress="return isNumberKey(event)" >
								</div>
							</div>
						</div>
						
						<div class="full_row">
							<div class="three columns">Street <span class="warning">*</span></div>
							<div class="five columns margin_R_200">
								<input name="vStreet" type="text" class="textbox txt-bx01" onKeyDown="changeCSS(this, 'text');" value="<?php echo htmlspecialchars($objU->vStreet)?>" size="30" maxlength="100">
							</div>
						</div>
						
						<div class="full_row">
							<div class="three columns">City <span class="warning">*</span></div>
							<div class="five columns margin_R_200">
								<input name="vCity" type="text" class="textbox txt-bx01" onKeyDown="changeCSS(this, 'text');" value="<?php echo htmlspecialchars($objU->vCity)?>" size="30" maxlength="100">
							</div>
						</div>
						
						<div class="full_row">
							<div class="three columns">State <span class="warning">*</span></div>
							<div class="five columns margin_R_200">
								<select name="vState" class="textbox txt-bx01">
                                    <?php foreach ($arrState as $key => $value) { ?>
                                    <option value="<?php echo $key?>" <?php echo $objU->vState == $key ? "selected" : ""?>>
                                    <?php echo $value?>
                                    </option>
                                    <?php } ?>
                                  </select>
							</div>
						</div>
						
						<div class="full_row">
							<div class="three columns">Postal Code <span class="warning">*</span></div>
							<div class="five columns margin_R_200">
								<input name="vPostCode" type="text" class="textbox txt-bx01" onKeyDown="changeCSS(this, 'text');" value="<?php echo htmlspecialchars($objU->vPostCode)?>" size="30" maxlength="100">
							</div>
						</div>
						
						<div class="full_row">
							<div class="three columns">Telephone Number <span class="warning">*</span></div>
							<div class="five columns margin_R_200">
								<input name="vPhone" type="text" class="textbox txt-bx01" onKeyDown="changeCSS(this, 'text');" value="<?php echo htmlspecialchars($objU->vPhone)?>" size="30" maxlength="100">
							</div>
						</div>
						
						<div class="full_row">
							<div class="three columns">&nbsp;</div>
							<div class="five columns margin_R_200">
								<input name="CNP" type="submit" class="loginbutton" value="Make As Background Check Verified">
								<input type="hidden" name="step" value="3">
								<input type="hidden" name="product" value="4">
							</div>
						</div>
					</div>
				</form>
			</div>
			<div id="hide"><?php echo $script?></div>
		</div>
	</div>
	<div class="four columns right search_result_R">
		<?php include_once ("left.inc.php");?>
	</div>
</div>

<?php include_once('bottomhtml.inc.php');?>
