<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2008 Armia Systems, Inc                           |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Cybermatch                    |
// +----------------------------------------------------------------------+
// | Authors: simi<simi@armia.com>             		                      |
// |          										                      |
// +----------------------------------------------------------------------+

session_start();
include_once('../config.inc.php'); 
$productName ='Cybermatch';

function splitsqlfile($sql, $delimiter) {
    // Split up our string into "possible" SQL statements.
    $tokens = explode($delimiter, $sql);
    // try to save mem.
    $sql = "";
    $output = array();
    // we don't actually care about the matches preg gives us.
    $matches = array();
    // this is faster than calling count($oktens) every time thru the loop.
    $token_count = count($tokens);
    for ($i = 0; $i < $token_count; $i++) {
        // Don't wanna add an empty string as the last thing in the array.
        if (($i != ($token_count - 1)) || (strlen($tokens[$i] > 0))) {
            // This is the total number of single quotes in the token.
            $total_quotes = preg_match_all("/'/", $tokens[$i], $matches);
            // Counts single quotes that are preceded by an odd number of backslashes,
            // which means they're escaped quotes.
            $escaped_quotes = preg_match_all("/(?<!\\\\)(\\\\\\\\)*\\\\'/", $tokens[$i], $matches);

            $unescaped_quotes = $total_quotes - $escaped_quotes;
            // If the number of unescaped quotes is even, then the delimiter did NOT occur inside a string literal.
            if (($unescaped_quotes % 2) == 0) {
                // It's a complete sql statement.
                $output[] = $tokens[$i];
                // save memory.
                $tokens[$i] = "";
            } else {
                // incomplete sql statement. keep adding tokens until we have a complete one.
                // $temp will hold what we have so far.
                $temp = $tokens[$i] . $delimiter;
                // save memory..
                $tokens[$i] = "";
                // Do we have a complete statement yet?
                $complete_stmt = false;

                for ($j = $i + 1; (!$complete_stmt && ($j < $token_count)); $j++) {
                    // This is the total number of single quotes in the token.
                    $total_quotes = preg_match_all("/'/", $tokens[$j], $matches);
                    // Counts single quotes that are preceded by an odd number of backslashes,
                    // which means they're escaped quotes.
                    $escaped_quotes = preg_match_all("/(?<!\\\\)(\\\\\\\\)*\\\\'/", $tokens[$j], $matches);

                    $unescaped_quotes = $total_quotes - $escaped_quotes;

                    if (($unescaped_quotes % 2) == 1) {
                        // odd number of unescaped quotes. In combination with the previous incomplete
                        // statement(s), we now have a complete statement. (2 odds always make an even)
                        $output[] = $temp . $tokens[$j];
                        // save memory.
                        $tokens[$j] = "";
                        $temp = "";
                        // exit the loop.
                        $complete_stmt = true;
                        // make sure the outer loop continues at the right point.
                        $i = $j;
                    } else {
                        // even number of unescaped quotes. We still don't have a complete statement.
                        // (1 odd and 1 even always make an odd)
                        $temp .= $tokens[$j] . $delimiter;
                        // save memory.
                        $tokens[$j] = "";
                    }
                } // for..
            } // else
        }
    }
    return $output;
}





function isNotNull($value) {
    if (is_array($value)) {
        if (sizeof($value) > 0) {
            return true;
        } else {
            return false;
        }
    } else {
        if (($value != '') && (strtolower($value) != 'null') && (strlen(trim($value)) > 0)) {
            return true;
        } else {
            return false;
        }
    }
}



function getFilePermission($file) {
    $perm = fileperms($file);
    if ($perm === false) {
        return "0000";
    } else {
        return substr(sprintf('%o', $perm), -4);
    }
}

function stripslashes_deep($value) {
    $value = is_array($value) ? array_map('stripslashes_deep', $value) : stripslashes($value);
    return $value;
}

function getServerOS() {
    return strtoupper(substr(PHP_OS, 0, 3));
}

//deprecated in php 5.3
//@set_magic_quotes_runtime(0);

if (get_magic_quotes_gpc()) {
    $_POST = array_map('stripslashes_deep', $_POST);
    $_GET = array_map('stripslashes_deep', $_GET);
    $_COOKIE = array_map('stripslashes_deep', $_COOKIE);
}

function file_writable($file) {
    $permission = substr(sprintf('%o', fileperms($file)), -4);
    if ($permission == '0777' || $permission == '0666') {
        return true;
    } else {
        return false;
    }
}


//$schemafile = "schema.sql";
$datafile = "upgrade.sql";
$configfile = "../config.inc.php";

//$configcontents = @fread(@fopen($configfile, 'r'), @filesize($configfile));
//$pos = strpos($configcontents, "INSTALLED");
//if ($pos === false) {
//    ;
//} else {
//    header("location:../index.php");
//}

$fullurl = $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']);
if($_SERVER['HTTPS']=='on') {
    $http = "https://";
}else {
    $http = "http://";
}
$pos = strrpos($fullurl, "/");
if ($pos === false) { // note: three equal signs
    // not found...
} else {
    $fullurl = substr($fullurl, 0, $pos);
}

$txtSiteSecureURL   = "https://".$fullurl;
//$fullurl            = $http . $fullurl;

$installed = false;
$txtDBServerName = "localhost";
$txtTablePrefix = "tbl_";
$txtSiteURL = "http://" . $fullurl;
$txtSecureSiteURL = "https://" . $fullurl;


/* * ********************************check server configuration **************************************************** */

$server_flag = true;

$val1 = ini_get("safe_mode");
$val3 = ini_get("file_uploads");

$gd = function_exists('gd_info');
$curl = function_exists('curl_init');
$mysql = function_exists('mysql_connect');

if (!empty($val1) || $val1 == 1) {
    $server_flag = false;
} elseif (empty($val3) || $val3 != 1) {
    $server_flag = false;
} elseif (!$gd) {
    $server_flag = false;
} elseif (!$curl) {
    $server_flag = false;
} elseif (!$mysql) {
    $server_flag = false;
}

$mysqlsupport = true;
if (!function_exists('mysql_connect')) {

    $mysqlsupport = false;
}

if (!$server_flag) {
    $serverconfiguration = "FAILURE";
} else {
    $serverconfiguration = "OK";
}

/* --------------------Check server PHP configuration--------------------------- */
$sapi_type = php_sapi_name();
$chmodstatus = '000';
if (substr($sapi_type, 0, 3) == 'cgi') {
    $chmodstatus = '755';
    $write = 'WRITABLE';
} else {
    if (substr(@php_uname(s), 0, 7) == "Windows") {
        $chmodstatus = '000';
    } else {
        $chmodstatus = '777';
    }
    $write = 'UNWRITABLE';
}

$directories = array(
        "../images/",
        "../images/profiles/",
        "../images/success_stories/",
        "../userfiles/",
        "../help/",
        "../images/spam/",
        "../banners/",
        "../pem/",
        "../config.inc.php");

$perm_msg = '';
$perm_flag = true;
$host_name = parse_url($_SERVER['HTTP_HOST']);

if ($chmodstatus == '777') {
    if (isset($_POST["btnContinue"]) && !isset($_POST["auto_set"])) {
        $post_flag = true;
        $txtFTPusername = $_POST['FTPusername'];
        $txtFTPpassword = $_POST['FTPpassword'];

        $user_data['FTPusername'] = $_POST["FTPusername"];
            $user_data['FTPpassword'] = $_POST["FTPpassword"];
        if (trim($txtFTPusername) == '') {
            $perm_msg .= '* Please enter FTP username <br/>';
        }
        if (trim($txtFTPpassword) == '') {
            $perm_msg .= '* Please enter FTP password <br/>';
        } else {
            $conn_id = @ftp_connect($host_name["path"]);
            $login_result = @ftp_login($conn_id, $txtFTPusername, $txtFTPpassword);
            if ($login_result) {
                $mode = 777;
                $np = '0' . $mode;

                $user_install = str_replace('/upgrade1.2.1', '', getcwd());

                //get the path staring from public_html
                $path_parts = explode('/public_html', $user_install);
                $user_install = '/public_html' . $path_parts[1];

                foreach ($directories as $directory) {
                    $edited_path = str_replace('..', '', $directory);
                    $directory = $user_install . $edited_path;
                    if ($directory[strlen($directory) - 1] == '/') {
                        $directory = substr($directory, 0, strlen($directory) - 1);
                    }
                    if (!@ftp_chmod($conn_id, eval("return({$np});"), $directory)) {
                        $perm_flag = false;
                    }
                }

                if (!$perm_flag) {
                    $perm_msg .= '* Sorry, an error occurred. Please try again or set the permissions manually <br/>';
                } else {
                    $perm_msg = '<b>* File permissions successfuly set </b><br/>';
                }
            } else {
                $perm_msg .= '* Sorry, could not connect to the server. Please check the credentials <br/>';
            }
        }
    }
} elseif ($chmodstatus == '755') {
    //cgi handler requires 755 so no file permission change needed
} elseif ($chmodstatus == '000') {
    //ftp_chmod wont work on windows
}

/* ----------------------------------------------------------------------------- */

if ($write == 'UNWRITABLE') {
    $imgdir = "../images/";
    $profiledir = "../images/profiles/";
    $storydir ="../images/success_stories/";
    $userfilesdir = "../userfiles/";
    $helpdir = "../help/";
    $spamdir = "../images/spam/";
    $bannerdir = "../banners/";
    $pemdir = "../pem/";
    $config_file = "../config.inc.php";
}//end if

$error = false;
$error_message = '';

//show alert only for non-cgi servers
if ($chmodstatus == '777' || $chmodstatus == '000') {
    if (!file_writable($imgdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'images' in the root folder to 777 <br>";
    }//end if

    if (!file_writable($profiledir)) {
        $error = true;
        $error_message .= " * Change the permission of 'images/profiles' in the root folder to 777 <br>";
    }//end if

    if (!file_writable($storydir)) {
        $error = true;
        $error_message .= " * Change the permission of 'images/success_stories' in the root folder to 777 <br>";
    }//end if

    if (!file_writable($userfilesdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'userfiles' in the root folder to 777 <br>";
    }//end if

    if (!file_writable($helpdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'help' in the root folder to 777 <br>";
    }//end if

    if (!file_writable($spamdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'images/spam' in the root folder to 777 <br>";
    }//end if

    if (!file_writable($bannerdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'banners' in the root folder to 777 <br>";
    }//end if

    if (!file_writable($pemdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'pem' in the root folder to 777 <br>";
    }//end if

    if (!file_writable($config_file)) {
        $error = true;
        $error_message .= " * Change the permission of 'config.inc.php' in the root folder to 777 <br>";
    }//end if
}

/* ---------------------------------------------------------------------------------------------------------------- */
$post_flag = false;

if ($_POST["btnContinue"] == "Continue") {
    $post_flag = true;
    $txtDBServerName = DB_HOST;
    $txtDBName = DB_DATABASE;
    $txtDBUserName = DB_USER;
    $txtDBPassword = DB_PASSWORD;
    

    $connection = mysql_connect($txtDBServerName, $txtDBUserName, $txtDBPassword) or die(mysql_error());
   
    if ($connection === false) {
        $error = true;
        $message .= " * Connection Not Successful! Please verify your database details!<br>";
    } else {
        $dbselected = @mysql_select_db($txtDBName, $connection);
        if (!$dbselected) {
            $error = true;
            $message .= " * Database could not be selected! Please verify your database details!<br>";
        }
    }

    //exit;
    $version = '1.2.1';
    
    if (!$error) {

        //-------------------------UPDATE CONFIG FILE---------------------------//
        $uniqueid = time() . mt_rand() . session_id();
        if (strlen($uniqueid) > 15) {
            $uniqueid = substr($uniqueid, 0, 15);
            $uniqueid = md5($uniqueid);
        }//end if

        //retreving directory name
        $documentroot=str_replace("/upgrade1.2.1","",dirname($_SERVER['PHP_SELF']));
       
        $fp = fopen($configfile, "a");
        $configcontent = "<?php\n";
        $configcontent .= "define('VERSION', '$version'); \n\n";
        if($_POST['cldpack']==1)
        {
        	$configcontent .= "define('ISCRIPTSCLOUD', true);"."\n";
        }
        else
        {
        	$configcontent .= "define('ISCRIPTSCLOUD', false);"."\n";
        }
        $configcontent .= "\n?>";
        fwrite($fp, $configcontent);

                
        $dataquery = @fread(@fopen($datafile, 'r'), @filesize($datafile));
        $txtTablePrefix = TABLEPREFIX;
        $dataquery = preg_replace('/cyber_/', $txtTablePrefix, $dataquery);
        $dataquery = splitsqlfile($dataquery, ";");

        // populating the tables with initial data......................................
        for($i = 0; $i < sizeof($dataquery); $i++) {
            mysql_query($dataquery[$i], $connection);
        }//end for loop

            
        // not needed
        

        /* -------------- /
        New code for install tracker
        /------------------*/
//        $documentroot	= $_SERVER['DOCUMENT_ROOT'];
//        $realpath		= realpath("../");
//        $replacedpath	= str_replace($documentroot,"",$realpath);
//        $rootserver		= "http://".$_SERVER['SERVER_NAME'].$replacedpath;
//
//        $string		= "";
//        $pro		= urlencode("Cybermatch 1.2");
//        $dom		= urlencode($rootserver);
//        $ipv		= urlencode($_SERVER['REMOTE_ADDR']);
//        $mai		= urlencode($txtAdminEmail);
//        $string		= "pro=$pro&dom=$dom&ipv=$ipv&mai=$mai";
//        $contents	= "no";
//        $file		= @fopen("http://www.iscripts.com/installtracker.php?$string", 'r');
//        if ($file) {
//            $contents = @fread($file, 8192);
//        }
        /* -------------- /
        New code for install tracker
        /------------------*/
// not needed
        
        $sqlAdminQuery = "SELECT * FROM " . $sqlPrefix . "lookup WHERE vLookUp_Name='adminmail'";
        $sqlAdminRes = mysql_query($sqlAdminQuery);
        if($sqlAdminRes){
            $sqlAdminVal = mysql_fetch_assoc($sqlAdminRes);
            $txtAdminEmail      = $sqlAdminVal['vLookUp_Value'];
        }

        $subject = "Script Installed at " . $txtSiteName;
        $headers = "From: " . $txtSiteName . "<" . $txtAdminEmail . ">\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=iso-8859-1\r\n";
        $path = "installer_logo.png";
        $mcont = "<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>
                    <tr><td><a href='" . $txtSiteURL . "' target='_blank'><img src='" . $txtSiteURL . "/images/" . $path . "' border='0'></a></td></tr></table>";
        $mailcontent = $mcont . "Hello , <br>";
        $mailcontent .= "Your Site is successfully installed.<br> <a href='" . $txtSiteURL . "' target='_blank'>Click Here to Access your Site</a>";
        $mailcontent .= "<br><a href='" . $txtSiteURL.'/admin/' . "' target='_blank'>Click Here to Access your Store Administration Control Panel</a> <br>";
        $mailcontent .= "<br> Thanks and regards,<br> " . $txtSiteName . " Team";
        $mailsent = mail(addslashes($txtAdminEmail), $subject, $mailcontent, $headers);
        
        $installed = true;
        
                
        // section to send details to admin...............................
    }
}

$productTitle = 'Cybermatch';
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
    "http://www.w3.org/TR/html4/loose.dtd">
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
        <title>iScripts Cybermatch Upgrader 1.2.1</title>
    </head>
   <script type="text/javascript" src="../js/jquery.js"></script>
    <script type="text/javascript" src="../js/install.js"></script>
     <link href="../styles/installer.css" rel="stylesheet" type="text/css">
    <body>
        <div class="header_row">
            <div class="header_container  sitewidth">
                <table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
                    <tr>
                        <td width="23%" align="left" ><img src="../images/installer_logo.png" alt="Logo"></td>
                        <td width="77%" align="right">
                            <h4>iScripts Cybermatch Upgrader 1.2.1</h4>
                            <div align="center" id="items_top_area">
                                &nbsp;&nbsp;
                                <a title="OnlineInstallationManual" href="#" onClick="window.open('<?php echo htmlentities($txtSiteURL);?>/docs/Insatallation_Manual.pdf','OnlineInstallationManual','top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd');"><strong>Installation Manual</strong></a> |
                                <a title="Readme" href="#" onClick="window.open('<?php echo htmlentities($txtSiteURL);?>/docs/Readme.txt','Readme','top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd');"><strong>Readme</strong></a> |
                                <a title="If you have any difficulty, submit a ticket to the support department" href="#" onClick="window.open('http://www.iscripts.com/support/postticketbeforeregister.php','','top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd,resizable=yes');"><strong>Get Support</strong></a>
                            </div>
                        </td>
                    </tr>
                </table>
            </div>
        </div>

        <table width="100%"  border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td><img src="css/spacer.gif" width="1" height="5"></td>
            </tr>
        </table>
        <table width="100%"  border="0" cellspacing="0" cellpadding="0">
            <tr>

                <td width="76%" valign="top" height ="400">
                    <!-- Here's where I want my views to be displayed -->
                    <table width="80%" border="0" cellpadding="0" cellspacing="0" align="center">
                        <tr>
                            <td>
                                <!--------Installer starts------------------------->

                                <!--items display area start -->
                                <?php
                                if ($serverSettings == "FAILURE") {
                                    ?>
                                    <table width="100%" border=0 align="center">
                                        <?php
                                        foreach ($serverCurrentSettings as $settings) {
                                            $span_class = $settings['flag'] ? "install_value_ok" : "install_value_fail";
                                            ?>
                                            <tr>
                                                <td>
                                                    <?php echo $settings['feature']; ?> <span class="<?php echo $span_class; ?>"><?php echo $settings['setting']; ?></span>
                                                </td>
                                            </tr>
                                            <?php
                                        }
                                        ?>
                                        <tr>
                                            <td>
                                                <span class="install_value_fail">Fatal errors detected.  Please correct the above red items and reload.</span>
                                            </td>
                                        </tr>
                                    </table>

                                    <?php
                                } else if (!$installed) {
                                    ?>
                                    <table width="80%" border="0" align="center">
                                        <tr>
                                            <td align="center" ><b><font size="1">
                                                    <div align="justify" >
                                                        <br>
                                                        <font color="#F4700E" size="+1">Thank you for choosing Cybermatch&nbsp;</font> <br><br>
                                                        <font color="#000000" size="2">To complete this upgradation process, please enter the details below.</font>
                                                    </div>

                                                    </font></b>
                                            </td>
                                        </tr>
                                        <?php if ($post_flag) { ?>
                                            <tr>
                                                <td align=center class="message" >
                                                    <div align="left" class="text_information">
                                                        <br>
                                                        <font color="#FF0000"><?php echo $perm_msg; ?></font><br>
                                                        <font color="#FF0000"><?php echo $error_message . '<br/>' . $message; ?></font><br>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                        <tr>
                                            <td class=maintext align="left" >
                                                Note: All Fields Are Mandatory.
                                                <br>
                                                <form name="frmInstall" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                                                    <br>

                                                    <FIELDSET>
                                                        <LEGEND class='block_class'>File Permissions</LEGEND>
                                                        <table width=85% border="0" cellpadding="2" cellspacing="2" class=maintext>
                                                            <tr>
                                                                <td colspan="2" align="left">
                                                                    <b>
                                                                        <?php if ($chmodstatus == '777') { ?>
                                                                            <?php echo $productName;?> requires that some of the folders have write permission. You can provide an FTP login so that this process is done automatically.<br/><br/>
                                                                            For security reasons, it is best to create a separate FTP user account with access to the <?php echo $productName;?> upgradation only and not the entire web server. Your host can assist you with this.
                                                                            If you have difficulties completing upgradation without these credentials, please click "I would provide permissions manually" to do it yourself.<br/><br/>
                                                                        <?php } elseif ($chmodstatus == '000') { ?>
                                                                            <?php echo $productName;?> requires that some of the folders have write permission. Please provide write permission for the following files :-<br/><br/>
                                                                        <?php } elseif ($chmodstatus == '755') { ?>
                                                                            <?php echo $productName;?> requires that some of the folders have write permission.<br/><br/>
                                                                        <?php } ?>
                                                                    </b>
                                                                </td>
                                                            </tr>
                                                            <?php if ($write == 'UNWRITABLE') { ?>
                                                                <tr>
                                                                    <td class=maintext align="left">FTP username</td>
                                                                    <td width="61%" align=left>
                                                                        <input name="FTPusername"  id="FTPusername" type="text" size="50" value="<?php echo htmlentities($user_data['FTPusername']); ?>">								
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td class=maintext align="left">FTP password</td>
                                                                    <td width="61%" align=left>
                                                                        <input name="FTPpassword"  id="FTPpassword" type="password" size="50" value="<?php echo htmlentities($user_data['FTPpassword']); ?>">
                                                                    </td>
                                                                </tr>
                                                                <?php if ($chmodstatus == '777') { ?>
                                                                    <tr>
                                                                        <td colspan="2" align="left">
                                                                            <input type="checkbox" name="auto_set" id="auto_set" onclick="divToggle(this)" /> &nbsp; I would provide permissions manually
                                                                        </td>
                                                                    </tr>                                                
                                                                    <?php
                                                                }
                                                            } else {
                                                                ?>
                                                                <tr>
                                                                    <td colspan="2" align="left">
                                                                        <b>File permissions are ok.</b>
                                                                    </td>
                                                                </tr>
                                                            <?php } ?>
                                                        </table>
                                                        <?php if ($write== 'UNWRITABLE') { ?>
                                                            <div id="err_div" style="<?php if ($chmodstatus == '777') { ?>display:none<?php } ?>">
                                                                <fieldset>
                                                                    <legend>Directories/Files List</legend>
                                                                    <?php echo $error_message; ?>
                                                                </fieldset>
                                                            </div>
                                                        <?php } ?>
                                                    </FIELDSET>
                                                    <br>
                                                    <br>
                                                    <table width=85% border=0 cellpadding="2" cellspacing="2" class=maintext>
                                                        <tr><td>&nbsp;</td></tr>
                                                        <tr>
                                                            <td align="center">
                                                                <input type="submit" name="btnContinue" value="Continue" class="buttn_admin">
                                                            </td>
                                                        </tr>
                                                    </table>

                                                    <!-- DO NOT REMOVE -->
                                                    <input type="hidden" name="upgraderCheck" id="upgraderCheck" value="1" />
                                                    <!-- ------------- -->
                                                </form>	
                                            </td>
                                        </tr>
                                    </table>
                              
                                 <?php
                                } else { 
                                    ?>
                                <table width="80%" border="0" align="center">
                                    <tr>
                                        <td>
                                            <table width=85% border=0 cellpadding="2" cellspacing="2" class=maintext align="center">
                                                <br>
                                                <tr>
                                                    <td align="center" class="maintext" >
                                                        <font color="#F4700E" size="+1">Congratulations! The upgradation  process was completed successfully!</font>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td align="center" class="maintext" height="20" >&nbsp;</td>
                                                </tr>
                                                <br>
                                                <br>
                                                <br>
                                                
                                                <br>
                                                    <?php
                                                    $request_uri = explode('/', $_SERVER['REQUEST_URI']);

                                                    $script_filename = explode('/', $_SERVER['SCRIPT_FILENAME']);
                                                    $build_path = "http://" . $_SERVER['HTTP_HOST'] . "/" . $request_uri[1] . "/admin/login.php";
                                                    $build_path_home = "http://" . $_SERVER['HTTP_HOST'] . "/" . $request_uri[1] . "/index.php";
                                                    ?>
                                                <tr>
                                                    <td align="center">
                                                        <br>
                                                        <fieldset>
                                                            <legend class="block_class">Site Login Details</legend>
                                                            <table cellpadding="0" cellspacing="0" width="95%" class="maintext" align="center">
                                                                <tr>
                                                                    <td colspan="2">&nbsp;</td>
                                                                </tr>
                                                                <tr>
                                                                    <td width="26%"><b><font size="-1">Admin URL&nbsp;:</font></b></td>
                                                                    <td width="74%"><a style="cursor:pointer; text-decoration: none; font-weight: bold;" href="<?php echo $txtSiteURL . "/admin/" ?>"><img src="../install/admin_login_install.jpg" border="0" height="25" align="absmiddle">&nbsp; &nbsp; <?php echo $txtSiteURL . "/admin/"; ?></a></td>
                                                                </tr>
                                                                <tr>
                                                                    <td colspan="2">&nbsp;</td>
                                                                </tr>
                                                                
                                                               
                                                                <tr>
                                                                    <td ><b><font size="-1">Home URL&nbsp;:</font></b></td>
                                                                    <td ><a style="cursor:pointer; text-decoration: none;font-weight: bold;" href="<?php echo $txtSiteURL; ?>/"><img src="../install/home_page.jpg" border="0" height="25" align="absmiddle">&nbsp; &nbsp;<?php echo $txtSiteURL; ?>/</a></td>
                                                                </tr>
                                                            </table>
                                                        </fieldset>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td align="center" class="maintext" height="20" >&nbsp;</td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                                    <?php
                                }
                                ?>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <div class="installr_footer"></div>
    </body>
</html>