<?php



/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/



// +----------------------------------------------------------------------+



// | PHP version 4/5                                                      |



// +----------------------------------------------------------------------+



// | Copyright (c) 2004-2011 ARMIA INC                                    |



// +----------------------------------------------------------------------+



// | This source file is a part of iScripts PrintLogic                     |



// +----------------------------------------------------------------------+



// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |



// +----------------------------------------------------------------------+



App::import('Sanitize');



class FeedbacksController extends AppController



{



    var $name = "Feedback";



	var $helpers = array('Html', 'Form','Pagination','Javascript');   



	var $components = array ('Pagination','Catmenu');



	var $uses = array('Feedback','Order','Admin','Product','Category','User','Cmspage','Dynamicpage');  



	var $paginate = array('limit' => 25,'order' => array('Feedback.type' => 'desc'));



    



    function beforeFilter()



    {



		if (isset($this->Setting) && !empty($this->Setting->table))  



        {  



             $this->Setting->load();  



        } 



		global $sitefolder; 



		global $meta_description;



		global $meta_keywords;



		global $page_title;



		$cnfg 				=	Configure::read('Neutrino');



		$sitefolder			=	$cnfg["sitebasefolder"];



		$meta_description	=	$cnfg["meta_description"];



		$meta_keywords		=	$cnfg["meta_keywords"];



		$page_title			=	$cnfg["page_title"];



		global $style; 



		$style				=	$cnfg["style"];



		$this->set('style', $style);



		$this->set('meta_description', $meta_description);



		$this->set('meta_keywords', $meta_keywords);



		$this->pageTitle = $page_title	; 



		$this->set('cnfg',$cnfg);



		$this->paginate["limit"]=$cnfg["items_perpage"]; //Setting pagination limit per page.
		
		
		$this->set('sitefolder', $sitefolder);

		$httpHost	=	$_SERVER['HTTP_HOST'];

		$this->set('sitebase','http://'.$httpHost);




    }



	function beforeRender(){
				//$lst	=	$this->Catmenu->getCatList(1);
				//$this->set('catmenu', $lst);
						//Code Added By shyam for Category Menu Listing starts here..
		 $lst	=	$this->Category->find('all',array('order' => array('position' => 'ASC')));			
		 if(empty($lst)===false)
		 {
		   foreach($lst as $det)
		   $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"]);
		   $this->set('menu_array', $menu_array);		
		 }  
		//Code Added By shyam for Category Menu Listing ends here..
		$footer_links = $this->Cmspage->find('list',array('conditions' => array('Cmspage.type' => 'content','Cmspage.status' => 'Y')));	
		$this->set('footerlinks', $footer_links);	
		$pages =    $this->Dynamicpage->getpages();
		//echo "hello<pre>";print_r($pages);
		$this->set('pagesdynamic', $pages);
	}


   	function index(){



		$this->__validateLoginStatus(); 



		$admsess	=	$this->Session->read('Admin');



		if($admsess["feedback"] <> 1){



		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 



			exit();



		}



		$criteria=NULL;
		$cmbSearchType	=	"";
		$txtSearch		=	"";

       
       
		if(isset($_GET["cmbSearchType"]) && isset($_GET["txtSearch"])){
			$cmbSearchType	=	$_GET["cmbSearchType"];
			$txtSearch		=	$_GET["txtSearch"];
			if($cmbSearchType == "uname"){			
				$data = $this->paginate('Feedback', array('User.uname LIKE ' => "%".addslashes($txtSearch)."%"));			
			}elseif($cmbSearchType == "type"){
				$data = $this->paginate('Feedback', array('Feedback.type LIKE ' => "%".addslashes($txtSearch)."%"));
			}elseif($cmbSearchType == "pname"){
				$criteria="Product.pname  LIKE '%".addslashes($txtSearch)."%'";
				$data = $this->paginate('Feedback', array('Product.pname LIKE ' => "%".addslashes($txtSearch)."%"));
			}elseif($cmbSearchType == "date"){
				$criteria="Feedback.date  LIKE '%".addslashes($txtSearch)."%'";
				$dt ='';
				if($txtSearch!='')
				{
				list ($month, $day, $year) = explode ("-", $txtSearch); //08-12-2010
				if(strlen($day)==1) $day = '0'.$day;
				if(strlen($month)==1) $month = '0'.$month;
				$dt = $year."-".$month."-".$day; //2010-08-13
				}
				$data = $this->paginate('Feedback', array('Feedback.date LIKE ' => "%".addslashes($dt)."%"));	
			}elseif($cmbSearchType == "comment"){
				$data = $this->paginate('Feedback', array('Feedback.comment LIKE ' => "%".addslashes($txtSearch)."%"));
			}else{
				$data = $this->paginate('Feedback');
			}
		}
		
		else if(isset($this->passedArgs["cmbSearchType"]) && isset($this->passedArgs["txtSearch"]) && 
		 $this->passedArgs["txtSearch"] <> '')
		{
			$cmbSearchType	=	$this->passedArgs["cmbSearchType"];
			$txtSearch		=	$this->passedArgs["txtSearch"];
			if($cmbSearchType == "uname"){			
				$data = $this->paginate('Feedback', array('User.uname LIKE ' => "%".addslashes($txtSearch)."%"));			
			}elseif($cmbSearchType == "type"){
				$data = $this->paginate('Feedback', array('Feedback.type LIKE ' => "%".addslashes($txtSearch)."%"));
			}elseif($cmbSearchType == "pname"){
				$criteria="Product.pname  LIKE '%".addslashes($txtSearch)."%'";
				$data = $this->paginate('Feedback', array('Product.pname LIKE ' => "%".addslashes($txtSearch)."%"));
			}elseif($cmbSearchType == "date"){
				$criteria="Feedback.date  LIKE '%".addslashes($txtSearch)."%'";
				$dt ='';
				if($txtSearch!='')
				{
				list ($month, $day, $year) = explode ("-", $txtSearch); //08-12-2010
				if(strlen($day)==1) $day = '0'.$day;
				if(strlen($month)==1) $month = '0'.$month;
				$dt = $year."-".$month."-".$day; //2010-08-13
				}
				$data = $this->paginate('Feedback', array('Feedback.date LIKE ' => "%".addslashes($dt)."%"));	
			}elseif($cmbSearchType == "comment"){
				$data = $this->paginate('Feedback', array('Feedback.comment LIKE ' => "%".addslashes($txtSearch)."%"));
			}else{
				$data = $this->paginate('Feedback');
			}
		}
		
		else
		{
			$data = $this->paginate('Feedback');
		}
       


		$this->set('cmbSearchType', $cmbSearchType);
		$this->set('txtSearch', $txtSearch);
		$this->passedArgs['limit']=$this->paginate["limit"];
        $this->set('passedarg',$this->passedArgs);
		$this->set('feeds', $data);
		$this->layout = 'adm'; 



	}



    function __validateLoginStatus($typ='A')
    {
           if($typ == 'A'){
				if($this->Session->check('Admin') == false)
				{
					$this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
					$this->redirect(array('controller' => 'admins', 'action' => 'login')); 
				}
		}else{
				if($this->Session->check('Userlog') == false)
				{
					$this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
					$this->redirect(array('controller' => 'users', 'action' => 'login')); 
				}
			}
    } 



	function add($ppid = 0){



		if($ppid == 0){



			$this->Session->setFlash('Can not find the product.', 'default',array('class'=> 'failure'));



			$this->redirect(array('controller'=>'pages','action'=>'display'));



			exit;



		}



		$pid	=	$ppid;



		$this->__validateLoginStatus('U');



		//$lst	=	$this->Catmenu->getCatList(1);



		//$this->set('catmenu', $lst);



		//Code Added By shyam for Category Menu Listing starts here..





		$sus	=	$this->Session->read('Userlog');



		if(!empty($sus)===true){



			$uid	=	$sus["id"];



			$flag	=	false;



			$chk	=	$this->Order->findAll('Order.user_id = '.$uid);



			foreach($chk as $ord){



				foreach($ord["OrderDetail"] as $det){



					if($det["product_id"] == $pid){



						$flag	=	true;



					}



				}



			}



			if($flag == true){



				########### Section to store feedbacks............



				$opt					=	array();



				$opt["positive"]		=	"positive";



				$opt["negative"]		=	"negative";



				$opt["neutral"]			=	"neutral";



				$pdet					=	$this->Product->findById($pid);



				if(isset($pdet["Product"]["pname"])){



					$this->set('pname',$pdet["Product"]["pname"]);



				}else{



					$this->Session->setFlash('Can not find the product.', 'default',array('class'=> 'failure'));



					$this->redirect(array('controller'=>'pages','action'=>'display'));



					exit;



				}



				$this->set('opt',$opt);



				$this->set('pid',$pid);



				if (!empty($this->data)) {



					$tm										=	date("Y-m-d H:i:s" );



					$this->data["Feedback"]["product_id"]	=	$pid;



					$this->data["Feedback"]["user_id"]		=	$uid;



					$this->data["Feedback"]["date"]			=	$tm;



					if ($this->Feedback->save($this->data)) {



						$this->Session->setFlash('Your Feedback has been saved.', 'default',array('class'=> 'success'));



						$this->redirect(array('controller'=>'products','action'=>'show/'.$pid));



						exit;



					}



				}



				########### Section to store feedbacks............



			}else{



				$this->Session->setFlash('You need to purchase the product inorder to give feedback!', 'default',array('class'=> 'failure'));



				$this->redirect(array('controller'=>'products','action'=>'show/'.$pid));



				exit;



			}



		}else{



			$this->__validateLoginStatus('U');



		}



	}



	function show($pid){



		//$lst						=	$this->Catmenu->getCatList(1);



		//Code Added By shyam for Category Menu Listing starts here..



		 $lst	=	$this->Category->findAll();			 



		 foreach($lst as $det)



		 $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"]);



		 $this->set('menu_array', $menu_array);		



		//Code Added By shyam for Category Menu Listing ends here..



		//$criteria					=	'Feedback.product_id = '.$pid;



		//list($order,$limit,$page) 	= 	$this->Pagination->init($criteria); 



        //$feeds 						=	$this->Feedback->findAll($criteria, NULL, 'Feedback.date DESC', $limit, $page);



		//$feeds = $this->paginate('Feedback');

    

		$pdet						=	$this->Product->findById($pid);



		$this->set('pname', $pdet["Product"]["pname"]);

        $feeds = $this->paginate('Feedback', array('Product.id '=> $pid));

		$this->set('feeds', $feeds);



		//$this->set('catmenu', $lst);



	}

    
	
	function edit($id=0)
		 {

		$this->__validateLoginStatus();
		$admsess	=	$this->Session->read('Admin');
		if($admsess["feedback"] <> 1){
		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 
			exit();
		}
		if($id == 0){
			$this->redirect(array('controller' => 'contacts','action'=>'index'));
			exit();
		}

		$this->Feedback->id	=	$id;
		if (!empty($this->data)) {		
		    $fdate=explode('-', $this->data["Feedback"]["date"]);    
            if(isset($fdate[0]))
			$this->data["Feedback"]["date"]	=	$fdate[2].'-'.$fdate[0].'-'.$fdate[1];		
			
		if ($this->Feedback->save($this->data)) {
				$this->Session->setFlash('Feedback has been edited Successfully.', 'default',array('class'=> 'success'));
				$this->redirect(array('controller' => 'feedbacks', 'action' => 'index')); 	
			}		
			
		}
		$this->data 					= 	$this->Feedback->read();
		$prod = $this->Product->find('list', array('fields' => array('Product.id', 'Product.pname'),'recursive' => 0));
		$users = $this->User->find('list', array('fields' => array('User.id', 'User.uname'),'recursive' => 0));
		$this->set('prod', $prod);
        $this->set('users', $users);			
		$opt					=	array();
		$opt["positive"]		=	"positive";
        $opt["negative"]		=	"negative";
        $opt["neutral"]			=	"neutral";
		$this->set('opt', $opt);	
		$this->set('feedback', $this->data);				
		$this->layout = 'adm';
	} 
	



	function delete($id){



		$this->__validateLoginStatus();



		$admsess	=	$this->Session->read('Admin');



		if($admsess["feedback"] <> 1){



		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 



			exit();



		}



		$this->Feedback->del($id);



		$this->Session->setFlash('Comment Removed from Database.', 'default',array('class'=> 'success'));



		$this->redirect('index');



	}



	



}



?>