<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 	   		 */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2011 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts PrintLogic                     | 
// +----------------------------------------------------------------------+
// | Authors: Aswin<aswin.j@armiasystems.com>             		          |
// +----------------------------------------------------------------------+

App::import('Sanitize');
class VendorsController extends AppController
{

	var $name = "Vendor";
	var $uses = array('Vendor', 'Vendororder', 'Setting', 'Country', 'Cmspage', 'Category', 'OrderDetail', 'Statecode', 'Order', 'Palette','Dynamicpage');
	var $helpers = array('Html', 'Form', 'Pagination', 'Javascript', 'Ajax', 'Csv', 'xls');   
	var $components = array('Pagination', 'Email');
	
	
	function index()
	{
		$this->__validateLoginStatus(); 
		
		$criteria=NULL;
		$cmbSearchType	=	"";
		$txtSearch		=	"";
		$paginate = array('limit' => 25,'order' => array('Vendor.name' => 'asc'));

		if(isset($_GET["cmbSearchType"]) && isset($_GET["txtSearch"]))
		{
			$cmbSearchType	=	$_GET["cmbSearchType"];
			$txtSearch		=	$_GET["txtSearch"];			
			$data = $this->paginate('Vendor', array('Vendor.'.$cmbSearchType.' LIKE ' => "%".addslashes($txtSearch)."%"));
		}

		else if(isset($this->passedArgs["cmbSearchType"]) && isset($this->passedArgs["txtSearch"]) && $this->passedArgs["txtSearch"] <> '')
		{
		    $cmbSearchType	=	$this->passedArgs["cmbSearchType"];
			$txtSearch		=	$this->passedArgs["txtSearch"];
			$data = $this->paginate('Vendor', array('Vendor.'.$cmbSearchType.' LIKE ' => "%".addslashes($txtSearch)."%"));
		}

		else
		{
			$data = $this->paginate('Vendor');
		}

		$this->set('cmbSearchType', $cmbSearchType);
		$this->set('txtSearch', $txtSearch);
		$this->passedArgs['limit']=$this->paginate["limit"];
        $this->set('passedarg',$this->passedArgs);
		$this->set('vendor', $data);

		$this->layout = 'adm';
	}
	
	function add()
	{
		if(!empty($this->data))
		{
			//print_r($this->data);
			if($this->data['country'] <> 'US') $this->data['state'] = $this->data['nonstate'];
			$this->Vendor->save($this->data);
			$cnfg 			=	Configure::read('Neutrino');
			
			
			$subject 		= "You have been added as a vendor at ".$cnfg["site_name"];
			
			$headers 		= "MIME-Version: 1.0\r\n";
			
			$headers        .= "Reply-To: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";
			
			$headers        .= "Return-Path: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";
			
			$headers 		.= "From: ".$cnfg["site_name"]."<".$cnfg["admin_email"].">\r\n";
			
			$headers        .= "Organization: ".$cnfg["site_name"]."\r\n";
			
			$headers 		.= "Content-type: text/html; charset=iso-8859-1\r\n";
			
			//  $pdt 			= 	$this->Cmspage->findByTitle('Registration confirm mail');
			
			$path			=	"SiteLogo_disp.gif";
			
			$mcont			=	"<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>
			
		  <tr><td><a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'><img src='".FULL_BASE_URL. $cnfg["sitebasefolder"]."/app/webroot/".IMAGES_URL.$path."' border='0' width='300'></a></td></tr></table>";
			
			$cnfg["site_name"]	= "<a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'>".$cnfg["site_name"]."</a>";
			 
			
			$mailcontent	= $mcont.'<p><span style="font-size: 12;font-family:Arial, Helvetica, sans-serif">Hi '.$this->data['name'].',<br />
</span></p>
<p><span style="font-size: 12; font-family:Arial, Helvetica, sans-serif">You have been added as a vendor at '.$cnfg["site_name"].'.<br />
</span></p>
<p>&nbsp;</p>
<p><span style="font-size: 12; font-family:Arial, Helvetica, sans-serif">Regards,<br />
</span></p>
<p><span style="font-size: 12; font-family:Arial, Helvetica, sans-serif">'.$cnfg["site_name"].'&nbsp;Team.<br />
</span></p>';
			$mailsent 		= mail($this->data['email'],$subject,$mailcontent,$headers);
			
			$this->Session->setFlash('Vendor successfully added.', 'default',array('class'=> 'success'));
			$this->redirect("index");
			exit;
		}
		
		$countrylist	=	$this->Country->find('list',array('fields'=>array('Country.country_iso_code_2','Country.country_name'))); 
		$this->set('countrylist', $countrylist);
		
		$us_cntrydet = $this->Country->find("Country.country_iso_code_2 ='US'");	
		if(isset($us_cntrydet["Country"]["country_id"]))
		{
		 $us_states	=	$this->Statecode->find('list',array('fields'=>array('Statecode.code','Statecode.name'), 'conditions'=>array('Statecode.country_id' => $us_cntrydet["Country"]["country_id"])));		
		 $this->set('us_states', $us_states);	
		} 		
		
		$this->layout = 'adm'; 
	}
	
	function delete($vid = 0)
	{
		$this->__validateLoginStatus();

		$this->Vendor->delete_vendor($vid);
		$this->Session->setFlash('Vendor successfully deleted.', 'default',array('class'=> 'success'));
		$this->redirect('index');
	}
	
	function edit($vid)
	{
		if(!empty($this->data))
		{
			//print_r($this->data);
			if($this->data['country'] <> 'US') $this->data['state'] = $this->data['nonstate'];
			$this->Vendor->save($this->data);
			$this->Session->setFlash('Vendor successfully updated.', 'default',array('class'=> 'success'));
			$this->redirect("index");
			exit;
		}
		
		$countrylist	=	$this->Country->find('list',array('fields'=>array('Country.country_iso_code_2','Country.country_name'))); 
		$this->set('countrylist', $countrylist);
		
		$us_cntrydet = $this->Country->find("Country.country_iso_code_2 ='US'");	
		if(isset($us_cntrydet["Country"]["country_id"]))
		{
		 $us_states	=	$this->Statecode->find('list',array('fields'=>array('Statecode.code','Statecode.name'), 'conditions'=>array('Statecode.country_id' => $us_cntrydet["Country"]["country_id"])));		
		 $this->set('us_states', $us_states);	
		} 		
		$vendor = $this->Vendor->findById($vid);
		$this->set('vendor', $vendor);
		
		$this->layout = 'adm'; 
	}
	
	function vendororders($orderdetailid = 0)
	{
		$this->__validateLoginStatus(); 
		if(!empty($this->data))
		{
			$this->data['ordered_date'] = date('Y-m-d');
			//print_r($this->data);
			$ids = $this->Vendororder->find('first',array('fields'=>array('Vendororder.id', 'Vendororder.quantity'), 'conditions' => array('Vendororder.order_detail_id' => $this->data['order_detail_id'],'Vendororder.vendor_id' => $this->data['vendor_id'])));
			if($ids)
			{
				$this->data['id'] = $ids['Vendororder']['id'];
				$this->data['quantity'] += $ids['Vendororder']['quantity'];
			}
			$this->Vendororder->save($this->data);
			$this->Session->setFlash('Order successfully assigned to vendor.', 'default',array('class'=> 'success'));
		}
		
		$placedorders = $this->Vendor->findorder($orderdetailid); 
		
		$quantity = $this->OrderDetail->find('list',array('fields'=>array('OrderDetail.quantity'), 'conditions'=>array('OrderDetail.id' => $orderdetailid)));
		$assigned = $this->Vendororder->find('first',array('fields'=>array('SUM(Vendororder.quantity) AS assigned'), 'conditions'=>array('Vendororder.order_detail_id' => $orderdetailid)));
		
		if($assigned) $newQty = $quantity[$orderdetailid] - $assigned[0]['assigned'];
		else $newQty = $quantity[$orderdetailid];
		
		if($newQty >= 1){
			for($i = $newQty; $i >= 1; $i--){
				$qty[$i] = $i;
			}
		}
		else $qty[1] = 0;
		
		$vendors = $this->Vendor->find('list',array('fields'=>array('Vendor.id','Vendor.name')));
		
		$this->set('vendors', $vendors);
		$this->set('placedorders', $placedorders);
		$this->set('quantity', $qty);
		
		$details = $this->Vendor->getDetails($orderdetailid);
		$this->set('details', $details);
		$this->set('orderdetailid', $orderdetailid);
		
		$this->layout = 'ajax'; 
	}
	
	function deleteorder($id, $orderid)
	{
		$this->__validateLoginStatus(); 
		$this->Vendor->deletevorder($id);
		$this->Session->setFlash('Order successfully removed.', 'default',array('class'=> 'success'));
		
		$this->redirect(array('controller' => 'Vendors', 'action' => "vendororders/$orderid"));
		exit;
	}
	
	function updateorders()
	{
		$this->__validateLoginStatus(); 
		if($_POST)
		{
			extract($_POST);
			foreach($order as $key=>$val)
			{
				$update['id'] = $orderhid[$key];
				$update['quantity'] = $val;
				
				$this->Vendororder->save($update);
			}
			$this->Session->setFlash('Orders successfully updated.', 'default',array('class'=> 'success'));
		
			$this->redirect(array('controller' => 'Vendors', 'action' => "vendororders/$orderdetailid"));
			exit;
		}
	}
	
	function sendmail($id, $orderdetailid, $type = 'mail')
	{
		$product_details = $this->Vendor->getDetails($orderdetailid);
		$vendor_details = $this->Vendor->vendordetails($id);
		
		//-----------------------------------------Email Section-----------------------------------------//
		$cnfg 			=	Configure::read('Neutrino');
		$subject 		= "Product enquiry from ".$cnfg["site_name"];

		$headers 		= "MIME-Version: 1.0\r\n";
		$headers        .= "Reply-To: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";
		$headers        .= "Return-Path: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";
		$headers 		.= "From: ".$cnfg["site_name"]."<".$cnfg["admin_email"].">\r\n";
		$headers        .= "Organization: ".$cnfg["site_name"]."\r\n";
		$headers 		.= "Content-type: text/html; charset=iso-8859-1\r\n";

		$pdt 			= 	$this->Cmspage->findByTitle('Vendor Email');

		$path			=	"SiteLogo_disp.gif";

		$mcont			=	"<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>
							<tr><td><a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'><img src='".FULL_BASE_URL. $cnfg["sitebasefolder"]."/app/webroot/".IMAGES_URL.$path."' border='0' width='300' ></a></td></tr>
							</table>";
							
		$order_table    =  "<table width='100%' border='0' cellspacing='2' cellpadding='2' align='center' id='items_display_area_admin_table'>
							<tr bgcolor='#CCCCCC' id='list_admin_top'><td>Product Details</td><td>Quantity</td><td>Date</td></tr>
							<tr id='list_admin'><td>$product_details</td><td>{$vendor_details[0]['O']['quantity']}</td><td>".date('m-d-Y',strtotime($vendor_details[0]['O']['ordered_date']))."</td></tr></table>";

		$cnfg["site_name"]	=	"<a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'>".$cnfg["site_name"]."</a>";

		$mailcontent	=	$mcont.$pdt["Cmspage"]["content"];
		$mailcontent 	= str_replace("[ORDER_DETAILS]", $order_table, $mailcontent);
		$mailcontent 	= str_replace("[VENDOR_NAME]", $vendor_details[0]['V']['name'], $mailcontent);
		$mailcontent 	= str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent);
		$mailcontent 	= str_replace("[PRODUCT_TYPE]", $product_details, $mailcontent);
		$mailcontent 	= str_replace("[QUANTITY]", $vendor_details[0]['O']['quantity'], $mailcontent);

		//echo $mailcontent; exit;

		if($type == 'mail')
		{
			$mailsent 		= mail($vendor_details[0]['V']['email'],$subject,$mailcontent,$headers);
			if($mailsent)
			{
				 $this->Session->setFlash('An email with the order details has been sent to the vendor.', 'default',array('class'=> 'success'));
				 $data['id'] = $id;
				 $data['email'] = 'SENT';
				 $this->Vendororder->save($data);
			}
			else $this->Session->setFlash('Sorry, an error occurred, please try later.', 'default',array('class'=> 'failure'));
			$this->redirect(array('controller' => 'Vendors', 'action' => "vendororders/$orderdetailid"));
			exit;
		}
		else
		{
			$this->set('mailcontent',$mailcontent);
			$this->set('orderdetailid',$orderdetailid);
			$this->layout = 'ajax';
		}
	}
	
	function vendorcsv()
	{
		$data = $this->Vendor->find("all");
		$this->set('data',$data);
		$this->layout = 'csvexp';
	}
	
	function vendorxls()
	{
		$data = $this->Vendor->find("all");
		$this->set('data',$data);
		$this->layout = 'csvexp';
	}
	
	function __validateLoginStatus($typ='A')
    {
           if($typ == 'A'){
				if($this->Session->check('Admin') == false)
				{
					$this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
					$this->redirect(array('controller' => 'admins', 'action' => 'login')); 
				}
		}else{
				if($this->Session->check('Userlog') == false)
				{
					$this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
					$this->redirect(array('controller' => 'users', 'action' => 'login')); 
				}
			}
    }

	
	function uniqueuser()
	{
		extract($_POST);
		if($uid == 0) $user = $this->Vendor->find('first',array('conditions' => array('Vendor.name' => $uname)));
		else $user = $this->Vendor->find('first',array('conditions' => array('Vendor.name' => $uname, 'Vendor.id <>' => $uid)));
		if(empty($user)) echo 0;
		else echo 1;
		
		//----------ajax--------------//
		Configure::write('debug', 0); 
		$this->autoRender = false;
		exit;
	}
	
	function uniqueemail()
	{
		extract($_POST);
		if($uid == 0) $emailID = $this->Vendor->find('first',array('conditions' => array('Vendor.email' => $email)));
		else $emailID = $this->Vendor->find('first',array('conditions' => array('Vendor.email' => $email, 'Vendor.id <>' => $uid)));
		if(empty($emailID)) echo 0;
		else echo 1;
		
		//----------ajax--------------//
		Configure::write('debug', 0); 
		$this->autoRender = false;
		exit;
	}
	
	function reports()
	{
		$this->__validateLoginStatus(); 
		$start = 1;
		
		if($_POST || count($_GET) <> 1)
		{
			if($_POST) extract($_POST);
			else extract($_GET);
			
			$maxdate = $vendor_tdate;
			$mindate = $vendor_fdate;
			if($_POST) $selected = $this->data['vendor_id'];
			else $selected = $vendor;
			$ispost = true;
			
			$pageLim = $this->Vendor->vendordercount($selected, $mindate, $maxdate);
			$offset = 25;
			$page = ($start-1)*$offset;
			$totpage = ceil($pageLim/$offset);
			
			$placedorders = $this->Vendor->vendorder($selected, $mindate, $maxdate, $page, $offset);//print_r($placedorders);
			
			$vendordetails = $this->Vendor->findById($selected);
			
			$this->set('placedorders',$placedorders);
			$this->set('vendordetails',$vendordetails);
			$this->set('totpage',$totpage);
			$this->set('start',$start);
		}
		else
		{
			$maxdate = date('m-d-Y');
			$mindate = date('m-d-Y',strtotime("-1 month",time()));
			$ispost = false;
			$selected = 0;
		}
		
		$vendors = $this->Vendor->find('list',array('fields'=>array('Vendor.id','Vendor.name')));
		$vendors[0] = 'Select';
		ksort($vendors);
		
		$this->set('mindate',$mindate);
		$this->set('maxdate',$maxdate);
		$this->set('ispost',$ispost);
		$this->set('selected',$selected);
		$this->set('vendors',$vendors);
		
		$this->layout = 'adm';
	}
	
	function vendorreportcsv()
	{
		extract($_GET);
		$maxdate = $vendor_tdate;
		$mindate = $vendor_fdate;
		$selected = $vendor;
			
		$data = $this->Vendor->vendorder($selected, $mindate, $maxdate, 0, 0, $nopage = true);
		$this->set('data',$data);
		$this->layout = 'csvexp';
	}
	
	function vendorreportxls()
	{
		extract($_GET);
		$maxdate = $vendor_tdate;
		$mindate = $vendor_fdate;
		$selected = $vendor;
			
		$data = $this->Vendor->vendorder($selected, $mindate, $maxdate, 0, 0, $nopage = true);
		$this->set('data',$data);
		$this->layout = 'csvexp';
	}

        function palette()
        {
            $this->__validateLoginStatus();

            if(isset($_POST['updatePalette']) && !empty($_POST['palette_color'])){
                //reset all colors to disabled
                $this->Palette->updateAll(array('Palette.status' => '0'));
                foreach($_POST['palette_color'] as $paletteColor){
                    //activate the selected colors
                    $this->Palette->id = $paletteColor;
                    $this->Palette->saveField('status', '1');
                }
                $this->Session->setFlash('Your preferences have been updated.', 'default', array('class'=> 'success'));
            }

           if(isset($_POST['delete']) && !empty($_POST['palette_color'])){
               
             foreach($_POST['palette_color'] as $paletteColor){
                    //activate the selected colors
                  
                    $this->Palette->deleteAll("id = ".$paletteColor, $cascade = true);

                }
                $this->Session->setFlash('Palette Colors  have been deleted.', 'default', array('class'=> 'success'));
               
           }  
            
            $palette = $this->Palette->find('all');
            $this->set('palette',$palette);
            $this->layout = 'adm';
        }

        function addColor()
        {
            if(isset($_POST['addPalette'])){
                $palette_color = explode("#", $_POST['color_txt']);

                $palette['Palette']['color']  = $palette_color[1];
                $palette['Palette']['status'] = 1;

                $this->Palette->save($palette);
                
                $color = '<span style="background-color:'.$_POST['color_txt'].';">&nbsp;&nbsp;&nbsp;&nbsp;</span>';
                $this->Session->setFlash("Color $color has been successfully added.", 'default',array('class'=> 'success'));

                $this->redirect(array('controller' => 'Vendors', 'action' => 'palette')); 
                exit;
            }
        }
	
	function beforeFilter()
        {
		if (isset($this->Setting) && !empty($this->Setting->table)){  
			 $this->Setting->load();  
		} 
		global $sitefolder; 
		global $meta_description;
		global $meta_keywords;
		global $page_title;
		$cnfg 				=	Configure::read('Neutrino');
		$sitefolder			=	$cnfg["sitebasefolder"];
		$meta_description	=	$cnfg["meta_description"];
		$meta_keywords		=	$cnfg["meta_keywords"];
		$page_title			=	$cnfg["page_title"];
		global $style; 
		$style				=	$cnfg["style"];
		$this->set('style', $style);
		$this->set('meta_description', $meta_description);
		$this->set('meta_keywords', $meta_keywords);
		$this->pageTitle = $page_title	; 
		$this->set('cnfg',$cnfg);
		$this->paginate["limit"]=$cnfg["items_perpage"]; //Setting pagination limit per page.		
		$this->set('sitefolder', $sitefolder);
		$httpHost	=	$_SERVER['HTTP_HOST'];
		$this->set('sitebase','http://'.$httpHost);
        }
	
	function beforeRender()
	{
		 $lst	=	$this->Category->findAll();			
		 if(empty($lst)===false)
		 {
		   foreach($lst as $det)
		   $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"]);
		   $this->set('menu_array', $menu_array);			   
		 }  		
		 $footer_links = $this->Cmspage->find('list',array('conditions' => array('Cmspage.type' => 'content','Cmspage.status' => 'Y')));	
		$this->set('footerlinks', $footer_links);	
		$pages =    $this->Dynamicpage->getpages();
		//echo "hello<pre>";print_r($pages);
		$this->set('pagesdynamic', $pages);
	}
}