<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2011 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts PrintLogic                    |
// +----------------------------------------------------------------------+
// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |
// +----------------------------------------------------------------------+

class CartsController extends AppController

{
    var $name = "Cart";

    var $helpers = array('Html', 'Form','Pagination');   

	var $components = array ('Pagination','Catmenu','Upsshipping','Authorizepayment','Yourpay','Usps','Xmlparser','Australiapost','Canadapost','Fedex','Googlecart','Googleitem','Bluepay'); // Added

	var $uses = array('Product', 'Productdetail','Category','Cart','UserAddress','Country','Order','OrderDetail','Currency','Cmspage','State','User','Setting','Coupon','Giftcard','Giftcarduser','GiftcardDetail','Newsletteruser','Savedimage','Itemcoordinate','Productpricetier','Dynamicpage'); 

    function index()
    {

		print_r($this->Session->id());exit;

    } 

     function beforeFilter()
		{

		   if (isset($this->Setting) && !empty($this->Setting->table))  
			{  

				 $this->Setting->load();  

			} 

			global $sitefolder; 

			global $meta_description;

			global $meta_keywords;

			global $page_title;

			global $currency;

			global $allow_giftcoupon;

			$cnfg 				=	Configure::read('Neutrino');

			$sitefolder			=	$cnfg["sitebasefolder"];

			$meta_description	=	$cnfg["meta_description"];

			$meta_keywords		=	$cnfg["meta_keywords"];

			$page_title			=	$cnfg["page_title"];

			$currency			=	$cnfg["currency"];

			$allow_giftcoupon	=	$cnfg["allow_giftcoupon"];

			global $style; 

			$style				=	$cnfg["style"];

			$this->set('base_url', FULL_BASE_URL );

			$this->set('allow_giftcoupon', $allow_giftcoupon);

			$this->set('style', $style);

			$this->set('meta_description', $meta_description);

			$this->set('meta_keywords', $meta_keywords);

			$this->pageTitle = $page_title	; 

			$this->set('cnfg',$cnfg);

		}

function beforeRender(){
				//$lst	=	$this->Catmenu->getCatList(1);
				//$this->set('catmenu', $lst);
						//Code Added By shyam for Category Menu Listing starts here..
		 $lst	=	$this->Category->find('all',array('order' => array('position' => 'ASC')));			
		 if(empty($lst)===false)
		 {
		   foreach($lst as $det)
		   $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"], 'position' => $det["Category"]["position"]);
		   $this->set('menu_array', $menu_array);		
		 }  
		//Code Added By shyam for Category Menu Listing ends here..
		$footer_links = $this->Cmspage->find('list',array('conditions' => array('Cmspage.type' => 'content','Cmspage.status' => 'Y')));	
		$this->set('footerlinks', $footer_links);
		$pages =    $this->Dynamicpage->getpages();
		//echo "hello<pre>";print_r($pages);
		$this->set('pagesdynamic', $pages);
	}
    function __validateLoginStatus($typ='U')

    {

           if($typ == 'A'){

				if($this->Session->check('Admin') == false)

				{
					$this->Session->setFlash('The URL you have followed requires you login', 'default',array('class'=> 'failure'));
					$this->redirect(array('controller' => 'admins', 'action' => 'login')); 
				}

			}else{

				if($this->Session->check('Userlog') == false)
				{
					$this->Session->setFlash('The URL you have followed requires you login', 'default',array('class'=> 'failure'));
					$this->Session->write('logurl', $_SERVER['REQUEST_URI']);
                                        $this->redirect(array('controller' => 'users', 'action' => 'login')); 
				}

			}

    } 
	
	//------------------------Added by aswin------------------------------//
	function files($path,&$files = array())
{
    $dir = opendir($path."/.");
    while($item = readdir($dir))
        if(is_file($sub = $path."/".$item))
            $files[] = $item;else
            if($item != "." and $item != "..")
                $this->files($sub,$files); 
    return($files);
}
    function calculateAmt($custID) {
        $addtionalCost = 0;
        if($custID == '') {
            return 0;
            exit;
        }

        // STEP 1: Find the front & read id's of the saved image
        $imgArr = $this->Savedimage->findById($custID);
        $images = $this->Savedimage->findAllByRefName($imgArr['Savedimage']['ref_name']);
        foreach($images as $val) {
            $img[] = $val['Savedimage']['id'];
        }

        // STEP 2: Get the entries from the settings table
        $first_imagecost = $this->Setting->findByFieldname('first_image');
        $addn_imagecost = $this->Setting->findByFieldname('addn_image');
        $first_textcost = $this->Setting->findByFieldname('first_text');
        $addn_textcost = $this->Setting->findByFieldname('addn_text');

        // STEP 3: Find the entries in coordinates tbl for each id
        $imgCount = $txtCount = 0;
        foreach($img as $imgkey => $imgval) {
            $coords = $this->Itemcoordinate->findAllBySavedimagesId($imgval);
            if($coords) {
                foreach($coords as $cval) {
                    switch($cval['Itemcoordinate']['content_type']) {
                        case "Image":
                            $customArray[$imgkey]['Image'][] = $cval['Itemcoordinate']['content'];
                            break;
                        case "Text":
                            $customArray[$imgkey]['Text'][] = $cval['Itemcoordinate']['font_color'];
                            break;
                    }
                }
            }
            if(!empty($customArray[$imgkey]['Text'])) {
                $chkArray = array('Default');
                foreach($customArray[$imgkey]['Text'] as $tk => $tv) {
                    if(!in_array($tv, $chkArray)) {
                        array_push($chkArray, $tv);
                        if($txtCount == 0) $addtionalCost += intval($first_textcost['Setting']['value']);
                        else $addtionalCost += intval($addn_textcost['Setting']['value']);
                        $txtCount++;
                    }
                }
            }

            if(!empty($customArray[$imgkey]['Image'])) {
                $sus = $this->Session->read('Userlog');
                foreach($customArray[$imgkey]['Image'] as $ik => $iv) { 
                    $imgPath = explode('/', $iv);
                    $imgNamepatr = explode('_',$imgPath[1]);
                    $imgpatr = explode('.', $imgNamepatr[1]);
                  
                    $image_file_user_path = WWW_ROOT.IMAGES_URL.'editorimages/'.$sus['uname'].'/';
                    $files = implode('-',$this->files($image_file_user_path));
                   
                    $image_file_admin_path = WWW_ROOT.IMAGES_URL.'editorimages/admin/';
                    $admin_files = implode('-',$this->files($image_file_admin_path));
                    
                    $image_file_temp_path = WWW_ROOT.IMAGES_URL.'editorimages/temp/';
                    $temp_files = implode('-',$this->files($image_file_temp_path));
                    
                     if(!stristr($iv, $sus['uname']) && !stristr($files,$imgpatr[0]) && !stristr($admin_files,$imgpatr[0]) && !stristr($temp_files,$imgpatr[0]) && !stristr($iv, 'temp')) {

                    }
                    else {
                        if($imgCount == 0) $addtionalCost += intval($first_imagecost['Setting']['value']);
                        else $addtionalCost += intval($addn_imagecost['Setting']['value']);
                        $imgCount++;
                    }
                }
            }

        }

        return $addtionalCost;
        exit;
    }

	//--------------------------------------------------------------------//

	function add($pid='',$cid='',$optid='',$custid = '')
	 {
		$sus			=	$this->Session->read('Userlog');
		$this->set('sus', $sus);
		$dat["user_id"]		=	0;
		if(!empty($sus)===true)
		{
			$dat["user_id"]		=	$sus["id"];
		}
		$sessid	=	$this->Session->id();
		if($optid <>'' && $optid <> 0)
		 {		
		  $chk	=	$this->Cart->find("product_id=".$pid." AND user_id=".$dat["user_id"]." AND option_id = '".$optid."' AND sess_id='".$sessid."' AND savedimages_id = $custid AND type='P'");
		}

		else 
		{	
			$chk	=	$this->Cart->find("product_id=".$pid." AND user_id=".$dat["user_id"]." AND sess_id='".$sessid."' AND savedimages_id = $custid AND type='P'");
		}

		if(!empty($chk["Cart"]))
		{
			$this->Session->setFlash('This customization has already been added to your cart, you can update the quantity in the cart.', 'default',array('class'=> 'failure'));
			$this->redirect(array('controller' => 'carts','action'=>'show'));
			exit;
		}

		else
		{
			$dat["sess_id"]			=	$this->Session->id();
			$dat["product_id"]		=	$pid;
			$pdet		            =	$this->Product->findById($pid);			
	
			//----------------Get the customization cost---------------------//
			$addnCost = $this->calculateAmt($custid);
			
			$TieredPrice = $this->getTieredPrice($pid,1);
			//Setting the prices for whole sale and retail users..
			if(isset($sus) && empty($sus)===false)
	        {
				if($sus["usertype"]=='wholesale')
				{	
				  if($pdet["Product"]["wholesale_price"] > 0) 
				  {
				  	$dat["product_price"]	=	$pdet["Product"]["wholesale_price"]; 
				  }
				  else 
				  {
					  $dat["product_price"]	=	$pdet["Product"]["price"]; }
					  $dat["price_type"]	=	'W';
				  }

				if($sus["usertype"]=='retail')
				{	
				  $dat["product_price"]	=	$pdet["Product"]["price"];
				  $dat["price_type"]	=	'R';
				}
		    }

			else 
			{
			 $dat["product_price"]	=	$pdet["Product"]["price"];
			}			

			if(isset($TieredPrice))   // set tiered price
				$dat["product_price"] = $TieredPrice;
			//Setting the prices for whole sale and retail users..

			$dat["discount_type"]	 =	$pdet["Product"]["discount_type"];

			$dat["discount"]	    =	$pdet["Product"]["discount"];

			$dat["shipping_charge"]	=	$pdet["Product"]["shipping_price"];

			$dat["quantity"]		=	1;

			$dat["prodtype"]		=	$pdet["Product"]["prodtype"];

			$dat["type"]		    =	'P';

			$dat["savedimages_id"]		=	$custid;
			
			//------------------Apply the customization cost--------------------//
			$dat["extra_price"]	= $addnCost;

			if($optid<>'' && $optid<>0) 

			{

				$dat["option_id"]=	$optid;

				$pcmdet=$this->Productdetail->findById($dat["option_id"]);

				$dat["extra_price"] += $pcmdet["Productdetail"]["extraprice"];

		   }

			else

			$optid='';

			$tpflag					=	true;

			$citem					=	$this->Cart->findAllByUserId($dat["user_id"]);

					if(!empty($citem))
					{
						foreach($citem as $it)
						{
							if($it["Cart"]["prodtype"] <> $dat["prodtype"]){

								$tpflag					=	false;

							}
						}
					}

					if($tpflag <> true)
					{
						$this->Session->setFlash('Sorry, digital and non-digital products can\'t buy together!', 'default',array('class'=> 'failure'));
					}

					else
					{

						if($pdet["Product"]["stock"] < $dat["quantity"])
						{
							$this->Session->setFlash('Sorry,There is not enough stock available for the product you requested!', 'default',array('class'=> 'failure'));

						}else
						{
							//print_r($dat); exit;

							$this->Cart->save($dat);

						}
					}		

			//$this->redirect('/carts/show');
			$this->redirect(array('controller' => 'carts','action'=>'show'));

			exit;

		}		

	} 

	######## Function to show cart.......................................

	

	######## Function to add gift card tocart.......................................

	function giftcard($cid='')

	 {

		//$this->__validateLoginStatus();

		$sus			=	$this->Session->read('Userlog');

		$this->set('sus', $sus);

		$dat["user_id"]		=	0;

		if(!empty($sus)===true)

		{

			$dat["user_id"]		=	$sus["id"];

		}

		$sessid	=	$this->Session->id();

        $chk	=	$this->Cart->find("product_id=".$cid." AND user_id=".$dat["user_id"]." AND sess_id='".$sessid."' AND type='G'");

		if(!empty($chk["Cart"]))

		{

			$this->Session->setFlash('This Gift card has been already added to cart, you can update the quantity in the cart.', 'default',array('class'=> 'failure'));
			//$this->redirect('/carts/show');
			$this->redirect(array('controller' => 'carts','action'=>'show'));

			exit;

		}			

		else

		{    		

			$gdet=$this->Giftcard->findById($cid);

			if(isset($gdet) && empty($gdet)===false)

			{

			  $avail_stock=$gdet["Giftcard"]["stock"];

			}

			if($avail_stock < 1) 

			{

			  $this->Session->setFlash('Sorry,There is not enough stock available for the gift card you requested!', 'default',array('class'=> 'failure'));
			  //$this->redirect('/carts/show');
			  $this->redirect(array('controller' => 'carts','action'=>'show'));

			  exit;

		    }	

			$dat["sess_id"]			=	$this->Session->id();

			$dat["product_id"]		=	$cid;

			$dat["prodtype"]		=	'Digital';

			$cdet		            =	$this->Giftcard->findById($cid);

			$dat["product_price"]	=	$cdet["Giftcard"]["gift_amnt"];

			$dat["quantity"]		=	1;			

            $dat["type"]	        =   'G';

			$dat["price_type"]	=	'C';

			

			$tpflag					=	true;

			$citem					=	$this->Cart->findAllByUserId($dat["user_id"]);

			

			if(!empty($citem))

			{

				foreach($citem as $it)

				{

					if($it["Cart"]["prodtype"] <> $dat["prodtype"]){

						$tpflag					=	false;

					}

				}

			}

	

			if($tpflag <> true)

			{
				$this->Session->setFlash('Sorry, digital and non-digital products can\'t buy together!', 'default',array('class'=> 'failure'));
			}

			else

			{					

			 $this->Cart->save($dat);					

			} 	

			$this->redirect('/carts/show');

			exit;

		}		

	} 

	######## Function to show cart.......................................

	

	

	

function show($orderId=''){

		
            
           
            $this->__validateLoginStatus('U');
            
		$cnfg 			=	Configure::read('Neutrino');
	
		$tieredprice	=	$cnfg['tiered_price'];
	
		$this->set('allowtieredprice', $tieredprice);
            
		$sus	=	$this->Session->read('Userlog'); 
		if(isset($sus) && empty($sus)===false){		
		  $this->set('sus', $sus);
		  $citem	=	$this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','user_id' => $sus['id'])));	
		}  
		else {
		  $this->set('sus', ''); 
		  $sessid	=	$this->Session->id();
		  $citem	=	$this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','sess_id' => $sessid)));	
		}
 		$this->set('cartcount', count($citem));

		if($this->Session->check('Coupon') == true){

			$coup	=	$this->Session->read('Coupon');

			$this->set('couparray', $coup);

		}		

		

		$sus		=	$this->Session->read();

		

	   if($this->Session->check('Userlog') === true){

			$userid=$sus["Userlog"]["id"];

			$sessid	=	$this->Session->id();

			$cupdate	=	$this->Cart->updatesessuser($sessid,$userid);
			
			
			 if($orderId)
            {
                
                $ord = $this->Order->findById($orderId);
                foreach ($ord['OrderDetail'] as $key=>$val){
                    $val['option_id'] = $val['combination_id'];
                    $val['user_id'] = $userid;
                    $val['sess_id'] = $sessid;
                    $this->Cart->save($val);

                }
                
              $this->redirect('/carts/show');
            }
			
			$citem1	=	$this->Cart->findAllByUserId($userid);				
			//$maxid = $this->Cart->findAllByUserId($userid);		
			
			//Finding the product type of the lastly added product type and deleting the product with the other types
			$cart_tbl=$this->Cart->getTableName('carts');
			$max_rowid= $this->Cart->find('first', array(
				  'fields' => 'MAX(Cart.id) as maxid',
				  'conditions' => array('Cart.user_id ' => $userid)
			   ));
			 
			 $last_prodtype='Non-Digital';
			 if(isset($max_rowid[0]["maxid"]) && $max_rowid[0]["maxid"] <> 0)
			 {
			    $last_ptype=$this->Cart->findById($max_rowid[0]["maxid"]); 	
				if(isset($last_ptype) && empty($last_ptype)===false)
				{
				   $last_prodtype=trim($last_ptype["Cart"]["prodtype"]);
				}  
			 }
			 
			 $del_parray=array();
			 $citem2	=	$this->Cart->find('all', array('conditions' => array('user_id' => $userid)));		
             foreach($citem2 as $cvals2)
			 {
			    $ptype=$cvals2['Cart']['prodtype'];	
				if(trim($last_prodtype) <> trim($ptype))
				$del_parray[] = $cvals2['Cart']['id'];				
			 }			
			 if(isset($del_parray) && empty($del_parray)===false)
			 {
			  $this->Cart->query("delete FROM $cart_tbl where id IN (".implode(',',$del_parray).")");
			 }  	
			//Finding the product type of the lastly added product 
			
			$del_array=array();
			$chk_array=array();			
			foreach($citem1 as $cvals1)
			{
			   $chk_rowid=$cvals1['Cart']['id'];			
			   $chk_prodid=$cvals1['Cart']['product_id'];
			   $chk_userid=$cvals1['Cart']['user_id'];
			   $chk_optid=$cvals1['Cart']['option_id'];	
			   $chk_type=$cvals1['Cart']['type'];		   
			
			   $chk_str=$chk_prodid.'-'.$chk_optid.'-'.$chk_type;
			  
			   
			   if(in_array($chk_str,$chk_array))
			   {			   
			     $upid=explode('-',$chk_str);				
				 $upqty=$cvals1['Cart']['quantity'];
				 $this->Cart->query("update $cart_tbl set quantity=(quantity +".$upqty.") where id='".$upid[0]."'");				
				 $del_array[]=$chk_rowid;
			   }			
			   $chk_array[]=$chk_str;
			}
			if(isset($del_array) && empty($del_array)===false)
			{
			  //------------------------commented by aswin------------------------------//
			  //$this->Cart->query("delete FROM $cart_tbl where id IN (".implode(',',$del_array).")");
			}  			
			

			//$citem	=	$this->Cart->findAllByUserId($userid);

			$citem	=	$this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','user_id' => $userid)));		
			$gitem	=	$this->Cart->find('all', array('conditions' => array('Cart.type' => 'G','user_id' => $userid)));		

		}

		else{

		    $sessid	=	$this->Session->id();

			//$citem	=	$this->Cart->findAllBySessId($sessid);		

			$citem	=	$this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','sess_id' => $sessid)));	
			$gitem	=	$this->Cart->find('all', array('conditions' => array('Cart.type' => 'G','sess_id' => $sessid)));					

		}  

//echo "<pre>";print_r($citem);exit;

				

	//Code to get the cart item along with the combination values of products if any starts here...			        

		for($i=0;$i<count($citem);$i++)

		{		

				  if($citem[$i]["Cart"]["option_id"]<>0 && $citem[$i]["Cart"]["option_id"]<>'')

				  {

					$pcombndet	=	$this->Productdetail->findAllById($citem[$i]["Cart"]["option_id"]);				
//echo "<pre>";print_r($pcombndet);exit;
                                        $citem[$i]["Productdetail"]["stock"]= @$pcombndet[0]["Productdetail"]["stock"];
                                         /**************/
                                        //check if reorder level has been breached
                                        $reorder_breached = $this->Product->threshold_breached($citem[$i]["Cart"]["product_id"]);
                                        if ($reorder_breached <> 0) {

                                            $this->sendMailReorderAlert($citem[$i]["Cart"]["product_id"]);
                                        }
                                        /****************/
					$pcmbnid=explode(',',@$pcombndet[0]["Productdetail"]["customvalue_id"]);

						 foreach($pcmbnid as $key => $val)

						 {

						   if($val!='')

						   {				 

							 $combnstr[]=$this->Product->getpdctcmbn($val);

							 $combinations=implode(" ,",$combnstr);

							 $citem[$i]["Cart"]["combn_values"]= $combinations;			

							}

						 }					 								 

				  }

		     unset($combnstr);unset($combinations);		

		}
               
		
		//Setting the combination flag
		 $cmbtype_flag='no'; 
		 if(count($citem)>0)
            {       
		        foreach($citem as $itm)
				{ 				  
				   if($itm["Product"]["combination"] <> '')
				   $cmbtype_flag='yes';
				}
			}	
		$this->set('cmbtype_flag', $cmbtype_flag);

		//echo "<pre>";print_r($citem);

		

		$this->set('itemlist', $citem);	

		 //Code to get the cart item along with the combination values of products if any starts here...	

		$gftbl=$this->Cart->getTableName("giftcards");

		if(isset($gitem) && empty($gitem)===false)

		{		        

			for($i=0;$i<count($gitem);$i++)

			{	

			  $gdet=$this->Giftcard->query("select gift_code,stock from ".$gftbl." where id='".$gitem[$i]["Cart"]["product_id"]."'");

			  $gitem[$i]["Cart"]["gift_code"]=$gdet[0][$gftbl]["gift_code"];		

			  $gitem[$i]["Product"]["stock"]=$gdet[0][$gftbl]["stock"];				

			} 

			$this->set('giftcard', $gitem);		

		}	

		//Code to get the cart item along with the combination values of products if any ends here...		



		global $currency;

		$curr		=	$this->Currency->findByCode($currency);

		$this->set('curlogo',$curr["Currency"]["logo"]);

	}
	
	######## Function to show cart At Admin side.......................................

	

	function showadmincart($uid){

		$this->__validateLoginStatus('A');

		$user_id	=	$uid;

		$citem		=	$this->Cart->findAllByUserId($user_id);

		//print_r($citem);exit;
		//echo "<pre>";print_r($citem);exit;
		$this->set('itemlist', $citem);
		
		global $currency;

		$curr		=	$this->Currency->findByCode($currency);

		$this->set('curlogo',$curr["Currency"]["logo"]);

	}
	######### Function to update quantity in the cart.......................
	
function update(){			
      //  echo "<pre>";print_r($_POST);
        // Edited for customization printingiscool  //
        $totqty =0 ;
        $cnfg 				=	Configure::read('Neutrino');
        
        $tieredprice	=	$cnfg['tiered_price'];
        $this->set('allowtieredprice', $tieredprice);
        for($i=0;$i < sizeof($_POST["id"]);$i++)
	{
             if($_POST["id"][$i]==$_POST["updatecartid"]){
                 
                 $cdet					=	$this->Cart->findById($_POST["id"][$i]);

		 $pid					=	$cdet["Cart"]["product_id"];

		 $pdet					=	$this->Product->findById($pid);

		 $arrcartDtl                            =       $this->Cart->findAllByProduct_id($pid);
                 //echo "<pre>";print_r($arrcartDtl);
                 //echo "we".$_POST["id"][$i];
                    foreach ($arrcartDtl as $key => $value) {
                        $prodID   = $value['Cart']['product_id'];                         

                          if($value['Cart']['id']==$_POST["id"][$i])
                           $totqty = $totqty + $_POST["qty"][$i];
                          else
                           $totqty = $totqty + $value['Cart']['quantity'];                        
                        
                      
                     if($totqty<$pdet["Product"]["min_qty"])
                     { 
                        $this->Session->setFlash('Minimium quantity to be purchase for '.$pdet["Product"]["pname"].' is '.$pdet["Product"]["min_qty"], 'default',array('class'=> 'failure'));                      
                        $this->redirect('/carts/show');
                        exit();
                     }
                     //echo "total qty".$totqty;
                     if($tieredprice ==1){
                   $price = $this->getTieredPrice($prodID, $totqty);
                     }
                      if($price==NULL){
                          $price = $pdet["Product"]["price"];
                          $discountAmount = $pdet["Product"]["discount"];
                          $discountType  = $pdet["Product"]["discount_type"];
                      }else
                      {
                          $discountAmount = 0;
                          $discountType  = '';
                      }    
                      
                    } 
                   //  echo $price;
                      /*************/
                      if($pdet["Product"]["combination"]=='Y')

                        {

                          $stockcnt = $this->Productdetail->findById($_POST["optionid"][$i]); 

                          if($stockcnt["Productdetail"]["stock"] < $_POST["qty"][$i])

                           {
                                $this->Session->setFlash('Sorry,The stock is not enough for the product you requested!', 'default',array('class'=> 'failure'));
                           }

                           else

                           {

                                $this->Cart->update($_POST["id"][$i],$_POST["qty"][$i]);

                           }			

                        }

                        else 

                        if($pdet["Product"]["combination"]=='' || $pdet["Product"]["combination"]=='N')

                        {

                                if($pdet["Product"]["stock"] < $_POST["qty"][$i])

                                    {
                                            $this->Session->setFlash('Sorry,The stock is not enough for the product you requested!', 'default',array('class'=> 'failure'));
                                    }

                                    else

                               {

                                    $this->Cart->update($_POST["id"][$i],$_POST["qty"][$i]);

                               }		

                         }
                         $sess_arr = $this->Session->read('Userlog');
                         $loggedinUserId = $sess_arr['id'];
                         //echo "price".$price;
                         $this->Cart->updateByProductIdAndUser($prodID,$loggedinUserId,$price,$discountType,$discountAmount);
                      /**************/
                    //} //end for each       
             }//end if update cart
        }// end foreach	
		
         // Edited for customization screen Dream productions  //
        
		$this->redirect('/carts/show');

		exit;

	}
	######### Function to update quantity in the cart.......................

	/*function update(){

	

			//Checking For Valid Coupon Code starts here...			

				if(isset($_POST["code"]) && trim($_POST["code"]) <> '')

				{

					$coup	=	$this->Coupon->findByCode($_POST["code"]);

					if(isset($coup)&& !empty($coup))

					{

						$this->Session->write('Coupon', $coup);

					}else{
						$this->Session->setFlash('Sorry,Invalid coupon code!', 'default',array('class'=> 'failure'));
					}

				}

				else{

					//$this->Session->setFlash(' ');

				}				

			//Checking For Valid Coupon Code ends here..

			

			

				

		for($i=0;$i < sizeof($_POST["id"]);$i++)

		{			

			if($_POST["ptype"][$i] <> 'G')

			{

						$cdet					=	$this->Cart->findById($_POST["id"][$i]);

						$pid					=	$cdet["Cart"]["product_id"];

						$pdet					=	$this->Product->findById($pid);

						

						#################(Added by Shyam) #################

						if($pdet["Product"]["combination"]=='Y')

						{

						  $stockcnt = $this->Productdetail->findById($_POST["optionid"][$i]); 

						  if($stockcnt["Productdetail"]["stock"] < $_POST["qty"][$i])

						   {
							$this->Session->setFlash('Sorry,The stock is not enough for the product you requested!', 'default',array('class'=> 'failure'));
						   }

						   else

						   {

							$this->Cart->update($_POST["id"][$i],$_POST["qty"][$i]);

						   }			

						}

						else 

						if($pdet["Product"]["combination"]=='' || $pdet["Product"]["combination"]=='N')

						{

							if($pdet["Product"]["stock"] < $_POST["qty"][$i])

							{
								$this->Session->setFlash('Sorry,The stock is not enough for the product you requested!', 'default',array('class'=> 'failure'));
							}

							else

						   {

							$this->Cart->update($_POST["id"][$i],$_POST["qty"][$i]);

						   }		

					   }

		   }

		   else if($_POST["ptype"][$i] == 'G')

		   {

		     $this->Cart->update($_POST["id"][$i],$_POST["qty"][$i]);		   

		   }

		   #################(Added by Shyam) #################				

		}

		$this->redirect('/carts/show');

		exit;

	}*/

	####### Function to delete from cart........................................

	function delete($id){

		$sus	=	$this->Session->read('Userlog');
		$this->set('sus', $sus);			
		$this->Cart->del($id);

		if(!empty($sus)===true) {
			$userid	=	$sus["id"];
			$citem	=	$this->Cart->find('all', array('conditions' => array('user_id' => $userid)));		

			if(count($citem) < 1) {
				if($this->Session->check('Coupon') == true){
					$this->Session->delete('Coupon');		
				}	
			}		
		}	
		$this->Session->setFlash('Selected item deleted successfully!', 'default',array('class'=> 'failure'));	
		$this->redirect('/carts/show');
		exit;

	}

	

####### Function to Send Fax to Admin Starts here (code added by shyam - April 9,2010)........................................	

	function _sendFax($fax_email='',$fax_number='',$fax_content='',$msg_opt='')

	{

	   if($msg_opt==1) {

	   $cnfg 			=	Configure::read('Neutrino');

		$content="Hi Admin,<br /><br />A New Order has been placed at ".$cnfg["site_name"].". The order details are as follows:-";

		$towrite=$content.$fax_content;

		}

		else {

		$towrite=$fax_content;

		}

		//--------------------Fax Email----------------------------

		$to=$fax_number."@rcfax.com";

		$from=$fax_email;

		$subject="Hi Admin,<br />A New Order has been  placed at Food Court.";

		//--------------------------------------------------------

		

		 /* What we'll write to the file */

		$thefile=WWW_ROOT."Fax/order.html";

		$openedfile = fopen($thefile, "w");

		fwrite($openedfile, $towrite);

		fclose($openedfile);

				

		$type=filetype($thefile);

		$mime_boundary='text/html';

		$name="order.html";

		

		$message='';

		   if (file_exists($thefile))

		   {

				 // open the file for a binary read

				 $file = fopen($thefile,'rb');

				 // read the file content into a variable

				 $data = fread($file,filesize($thefile));

				 // close the file

				 fclose($file);

				 // now we encode it and split it into acceptable length lines

				 $data = chunk_split(base64_encode($data));

			 // now we'll build the message headers

			  $headers = "From: $from\r\n" .

				 "MIME-Version: 1.0\r\n" .

				 "Content-Type: multipart/mixed;\r\n" .

				 " boundary=\"{$mime_boundary}\"";

		 

			  // next, we'll build the message body

			  // note that we insert two dashes in front of the

			  // MIME boundary when we use it

			  $message = "This is a multi-part message in MIME format.\n\n" .

				 "--{$mime_boundary}\n" .

				 "Content-Type: text/plain; charset=\"iso-8859-1\"\n" .

				 "Content-Transfer-Encoding: 7bit\n\n" .

				 $message . "\n\n";

		 

			  // now we'll insert a boundary to indicate we're starting the attachment

			  // we have to specify the content type, file name, and disposition as

			  // an attachment, then add the file content and set another boundary to

			  // indicate that the end of the file has been reached

			  $message .= "--{$mime_boundary}\n" .

				 "Content-Type: {$type};\n" .

				 " name=\"{$name}\"\n" .

				 //"Content-Disposition: attachment;\n" .

				 //" filename=\"{$fileatt_name}\"\n" .

				 "Content-Transfer-Encoding: base64\n\n" .

				 $data . "\n\n" .

				 "--{$mime_boundary}--\n";

			  // now we just send the message

				@mail($to, $subject, $message, $headers);

			 }

		}

		

	

	

	

		###### Function to checkout.................................................

	function checkout(){



        $this->__validateLoginStatus();

		$sus			=	$this->Session->read('Userlog');		
		if(isset($sus) && empty($sus)===false){		
		  $this->set('sus', $sus);
		  $citem	=	$this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','user_id' => $sus['id'])));	
		}  
		else {
		  $this->set('sus', ''); 
		  $sessid	=	$this->Session->id();
		  $citem	=	$this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','sess_id' => $sessid)));	
		}
 		$this->set('cartcount', count($citem));

		$cnfg 		= Configure::read('Neutrino'); 
     	$user_id		=	$sus["id"];

 		$data	=	$this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value')));
            $curr			=	$this->Currency->findByCode($data["currency"] );
            $this->set('pcurr', $curr["Currency"]["logo"]);

 //Saving the Billing and shipping addresses starts here



	if($_SERVER['REQUEST_METHOD']=='POST'){		

	

				//updating Email Address for Guest in users table...

				if($sus["reg_status"]=='G')

				{

				    //Sending login details mail to the Guest User starts here..	
						$email_dups = $this->User->find('count', array('conditions' => array('User.email' => trim($_POST["bemail"]))));		
						if($email_dups  < 1) 
						{

							$subject 		= "New login details at ".$cnfg["site_name"];
							$headers 		= "MIME-Version: 1.0\r\n";
					
							$headers        .= "Reply-To: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";
							
							$headers        .= "Return-Path: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";
							
							$headers 		.= "From: ".$cnfg["site_name"]."<".$cnfg["admin_email"].">\r\n";
							
							$headers        .= "Organization: ".$cnfg["site_name"]."\r\n";
		
							$headers 		.= "Content-type: text/html; charset=iso-8859-1\r\n";
							$mailcontent='<table width="27%" border="0" align="center">
									<tr><td colspan="3" align="center"><font color="#CC6600"><strong>Vista cart Login Details</strong></font></td></td></tr>					
									<tr><td width="27%"><strong>Username</strong></td><td><strong>:</strong></td><td width="73%">'.$this->Session->read('guestuser').'</td></tr>
									<tr><td><strong>Password</strong></td><td><strong>:</strong></td><td width="73%">'.$this->Session->read('guestpswd').'</td></tr>
									</table>';				
							$mailsent 		= mail($_POST["bemail"],$subject,$mailcontent,$headers);
							$this->Session->delete('guestuser');$this->Session->delete('guestpswd');

					  }			
					//Sending login details mail to the Guest User ends here..	
				  $this->Cart->updateGuestEmail($user_id,trim($_POST["bemail"]));

				  $sus["email"]=$_POST["bemail"];

				  $this->Session->write('Userlog', $sus);		

				

					   $this->Newsletteruser->create($newsletteruser = array());

					   $newsletteruser["id"]	=	$this->User->id;

					   $newsletteruser["uname"]	=	$sus["uname"];

			           $newsletteruser["email"]	=	$_POST["bemail"];

					   $newsletteruser["sub_date"]	=	date('Y-m-d h:i:s');

					   $newsletteruser["status"]	=	'N';

					   $dups = $this->Newsletteruser->findByEmail($_POST["bemail"]);

					   if (empty($dups['Newsletteruser']['email'])=== true)

					   $this->Newsletteruser->save($newsletteruser);

					   unset($newsletteruser);

				}		

               //Finding the product type in the cart

			   $cart_item			=	$this->Cart->findAllByUserId($user_id);

			   $ptype='Non-Digital';

				if(!empty($cart_item)){

					foreach($cart_item as $item){

						if(trim($item["Cart"]["prodtype"]) == "Digital"){

							$ptype= 'Digital';

						}

					}

				}

				

			$bill["email"]		=	$_POST["bemail"];

			$bill["fname"]		=	$_POST["bfname"];

			$bill["lname"]		=	$_POST["blname"];

			$bill["address"]	=	$_POST["baddress"];			

			$bill["state"]		=	$_POST["bstate"];

			$bill["country"]	=	$_POST["data"]["bcountry"];			

			if($_POST["data"]["bcountry"] == 'US')	{

			  $bill["state"] = $_POST["us_bstate"];	}  

			else {

			  $bill["state"]		=	$_POST["bstate"];

			  unset($_POST["us_bstate"]);	} 			

            $bill["city"]		=	$_POST["bcity"];

			$bill["zip"]		=	$_POST["bzip"];

			$bill["phone"]		=	$_POST["bphone"];

			$bill["fax"]		=	$_POST["bfax"];

			$bill["mobile"]		=	$_POST["bmobile"];

			$bill["user_id"]	=	$user_id;

			$bill["addr_type"]	=	"Billing";

			$this->UserAddress->deleteAll("UserAddress.user_id = ".$user_id." AND UserAddress.addr_type = 'Billing'");

			$this->UserAddress->create($data = array());

			$data				=	$bill;

			$this->UserAddress->save($data);

			

			if($ptype <> 'Digital') 

				{
                                                $ship["email"]		=	$_POST["semail"];
                                                
						$ship["fname"]		=	$_POST["sfname"];		

						$ship["lname"]		=	$_POST["slname"];		

						$ship["address"]	=	$_POST["saddress"];					

						$ship["country"]	=	$_POST["data"]["scountry"];					

						if($_POST["data"]["scountry"] == 'US')	{

						  $ship["state"] = $_POST["us_sstate"];

						}  

						else {

						  $ship["state"]		=	$_POST["sstate"];

						  unset($_POST["us_sstate"]);	} 		

						$ship["city"]		=	$_POST["scity"];					

						$ship["zip"]		=	$_POST["szip"];		

						$ship["phone"]		=	$_POST["sphone"];		

						$ship["fax"]		=	$_POST["sfax"];		

						$ship["mobile"]		=	$_POST["smobile"];		

						$ship["user_id"]	=	$user_id;		

						$ship["addr_type"]	=	"Shipping";		

						$this->UserAddress->deleteAll("UserAddress.user_id = ".$user_id." AND UserAddress.addr_type = 'Shipping'");		

						$this->UserAddress->create($data = array());

						$data				=	$ship;		

						$this->UserAddress->save($data);			

				}	

				else

				 {

				   $this->redirect('/carts/payment/');

				   exit; 

				  }

		}

 //Saving the Billing and shipping addresses ends here		



		//Code Added By shyam for Category Menu Listing starts here..

		 $lst	=	$this->Category->findAll();			 

		 foreach($lst as $det)

		 $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"]);

		 $this->set('menu_array', $menu_array);		

		//Code Added By shyam for Category Menu Listing ends here..

        //Code Added By shyam for Category Menu Listing ends here..

        $shipmeth='';        
$this->set('shipMethodss',$_POST["shipmeth"]);
        if(isset($_POST["shipmeth"]) && $_POST["shipmeth"] <> '') {

		$shipmeth	=	str_replace("%20"," ",$_POST["shipmeth"]); }

		$shipadd	=	$this->UserAddress->find("UserAddress.user_id =".$user_id." AND UserAddress.addr_type ='Shipping'");

		$cntdet		=	$this->Country->findByCountryIsoCode_2($shipadd["UserAddress"]["country"]);

		//print_r($cntdet);exit;

		

		$shipadd["UserAddress"]["country_name"]	=	$cntdet["Country"]["country_name"];

		$citem			=	$this->Cart->findAllByUserId($user_id);

		$shipweight		=	0;

		$shipchrge		=	0;

		$shipchrgeadd           =	0;

		$qty			=	0;

                $shipflag               =       'yes';

		$prodtype 		= 	"Non-Digital";
                
                $prevlength = $prevwidth = $prevgrith = 0;

		foreach($citem as $item){//echo "<br>";echo $item["Product"]["prod_dimensions"];
                    
			$shipweight	+= $item["Product"]["weight"] * $item["Cart"]["quantity"];

			$shipchrge	+= $item["Cart"]["shipping_charge"] * $item["Cart"]["quantity"];

			$qty		=	$qty + $item["Cart"]["quantity"];
                        
                        $productDimensions[]= explode(',', $item["Product"]["prod_dimensions"]); 
                       
                        //Dimensions are stored as length,width,height,grith in field 'prod_dimensions'
                        $productLength = ($productDimensions[0][0])!=0?$productDimensions[0][0]:'';
                        $productWidth  = ($productDimensions[0][1])!=0?$productDimensions[0][1]:'';
                        $productHeight = ($productDimensions[0][2])!=0?$productDimensions[0][2]:'';
                        $productGrith  =($productDimensions[0][3])!=0?$productDimensions[0][3]:'';
                        
                        $shipitemlength	= $productLength * $item["Cart"]["quantity"];
                        $shipitemwidth	= $productWidth * $item["Cart"]["quantity"];
                        $shipitemHeight	+= $productHeight * $item["Cart"]["quantity"]; //Add up only height for more than one product
                        $shipitemgrith	= $productGrith * $item["Cart"]["quantity"];

			if($item["Product"]["prodtype"] == "Digital"){

				$prodtype = 	"Digital";

			}
                        unset($productDimensions);
                        //--to get product with maximum dimentions--//
                        $prevlength = ($shipitemlength > $prevlength)? $shipitemlength: $prevlength;
                        $prevwidth = ($shipitemwidth > $prevwidth)? $shipitemwidth: $prevwidth;
                        $prevgrith = ($shipitemgrith > $prevgrith)? $shipitemgrith: $prevgrith;
		}
                $shipitemlength = $prevlength;
                $shipitemwidth = $prevwidth;
                $shipitemgrith = $prevgrith;

		if($prodtype =="Digital")

		{		

		    $this->redirect('/carts/payment/');

		    exit;		

		}

		

		

		if($qty > 0 && $prodtype !="Digital"){

			$shipchrge		=	$cnfg["flat_shipping_first"];

			$shipchrgeadd	=	$cnfg["flat_shipping_additional"] * ($qty - 1);

			$shipchrge		=	$shipchrge + $shipchrgeadd;

		}else{

			$shipchrge		=	0;

		}



		$bxno	=	1;

		$shipweight2	=	$shipweight/$bxno;

		while($shipweight2 > 149){

			$bxno++;

			$shipweight2	=	$shipweight/$bxno;

		}

		//echo $shipweight2."<br>".$bxno; exit;

		if($shipweight2	==	0)

			$shipweight2	=	0.1;

		$module_shipping_ups_types	=	'1DM, 1DML, 1DA, 1DAL, 1DAPI, 1DP, 1DPL, 2DM, 2DML, 2DA, 2DAL, 3DS, GND, STD, XPR, XPRL, XDM, XDML, XPD';

		$origin_country				=	$cnfg["shipping_origin_country"];

		$origin_postal				=	$cnfg["shipping_origin_zip"];

		$destination_country		=	$shipadd["UserAddress"]["country"];

		$destination_postal			=	$shipadd["UserAddress"]["zip"];

		if($destination_country == 'CA')

		{

		  $prod = 'STD';

		 

		}

		else

		{

		  $prod = 'GNDRES';

		}

		$this->set('shipadd', $shipadd);

			

		if($shipmeth == 'UPS'){

                                        
                    
                   /************************ New ups Shipping   *******************/
                    $Packagetype=array("YOURPACKAGING"=>"YOURPACKAGING",
						"FEDEXBOX"=>"FEDEXBOX",
						"FEDEXPAK"=>"FEDEXPAK",
						"FEDEXTUBE"=>"FEDEXTUBE"
						);

						
		$fedexService['PRIORITYOVERNIGHT']     = 'FedEx Priority Overnight';
		$fedexService['STANDARDOVERNIGHT']     = 'FedEx Standard Overnight';
		$fedexService['FIRSTOVERNIGHT']        = 'FedEx First Overnight';
		$fedexService['FEDEX2DAY']             = 'FedEx 2 Day';
		$fedexService['FEDEXEXPRESSSAVER']     = 'FedEx Express Saver';
		$fedexService['INTERNATIONALPRIORITY'] = 'FedEx International Priority';
		$fedexService['INTERNATIONALECONOMY']  = 'FedEx International Economy';
		$fedexService['INTERNATIONALFIRST']    = 'FedEx International First';
		$fedexService['FEDEX1DAYFREIGHT']      = 'FedEx Overnight Freight';
		$fedexService['FEDEX2DAYFREIGHT']      = 'FedEx 2 day Freight';
		$fedexService['FEDEX3DAYFREIGHT']      = 'FedEx 3 day Freight';
		
		$fedexGroundService['FEDEXGROUND']           = 'FedEx Ground';
		$fedexGroundService['GROUNDHOMEDELIVERY']    = 'FedEx Home Delivery';				
		
		
		$dropOfftype=array("REGULARPICKUP"=>"Regular Pickup",
							"DROPBOX"=>"Drop Box",
							"BUSINESSSERVICECENTER"=>"Drop at Business Service Center",
							"REQUESTCOURIER"=>"Request Courier",
							"STATION"=>"Drop at Station");
							
	$StylewArray=array("livingwell.css"=>"Livingwell Furnishings",
						"myfurnituredepot.css"=>"My Furniture Depot",
						"designfurniture.css"=>"Design Furnishings",
						"furniturewholesaledepot.css"=>"Furniture Wholesale",
						"usfurniture.css"=>"US Furniture");
						
		$reasonArray=array("Did not like the item","Damaged During Shipping","Manufacturer Defect");
		$OrderCancelArray=array("Can't make it work","Damaged during shipping","Dead on arrival","Manufacturer defect",
							"Out of Warranty","Wrong item ordered","Wrong description online","Wrong item delivered",
							"Other");
							
	$ups_types=array('1DM' => 'Next Day Air Early AM',
				 '1DA' => 'Next Day Air',
				 '1DP' => 'Next Day Air Saver',
				 '2DM' => '2nd Day Air Early AM',
				 '2DA' => '2nd Day Air',
				 '3DS' => '3 Day Select',
				 'GND' => 'UPS Ground',
				 'STD' => 'Canada Standard',
				 'XPR' => 'Worldwide Express',
				 'XDM' => 'Worldwide Express Plus',
				 'XPD' => 'Worldwide Expedited');
        
        $ups_types_global = array('EP'=>'Express Plus or Worldwide Express Plus',
            'ES'=>'Express or Worldwide Express',
            '1DP'=>'Express Saver or Worldwide Saver',
            'EX'=>'Expedited or Worldwide Expedited',
            'ST'=>'Standard',
            '3DS'=>'3 Day Select to the United States',
            'ND'=>'UPS Express (NA1)');
				 
	$rate_array=array("RDP"=>"Regular+Daily+Pickup",
					  "OCA"=>"On+Call+Air",
					   "OTP"=>"One+Time+Pickup",
					   "LC"=>"Letter+Center",
					   "CC"=>"Customer+Counter");
	$container_type=array("CP"=>"Customer Packaging",
						  "ULE"=>"UPS Letter Envelope",	
						  "UT"=>"UPS Tube",
						  "UEB"=>"UPS Express Box",
						  "UW25"=>"UPS Worldwide 25 kilo",	
						  "UW10"=>"UPS Worldwide 10 kilo");   
	$res_type=array("RES"=>"Residential",
					"COM"=>"Commercial");			
					
   $usps_typesArray=array("0"=>"Express Mail to PO Addressee","1"=>"Priority Mail","2"=>"Parcel Post");		 
   $stamps_services_array =array("US-FC" 	=> "USPS First-Class Mail",
						  "US-MM" 	=> "USPS Media Mail",
						  "US-PP" 	=> "USPS Parcel Post",
						  "US-PM" 	=> "USPS Priority Mail",
						  "US-XM" 	=> "USPS Express Mail",
						  "US-EMI" 	=> "USPS Express Mail International",
						  "US-PMI" 	=> "USPS Priority Mail International",
						  "US-FCI" 	=> "USPS First Class Mail International");				
	$stamps_allowed_array = array("0"=>"US-XM","1"=>"US-PM");
        
         $usServiceCodes = array(
    "01"=>"UPS Next Day Air® Shipments Originating in United States",
    "02"=>"UPS Second Day Air® Shipments Originating in United States" ,
    "03"=>"UPS Ground Shipments Originating in United States", 
    "07"=>"UPS Worldwide ExpressSM Shipments Originating in United States" , 
    "08"=>"UPS Worldwide ExpeditedSM Shipments Originating in United States" , 
    "11"=>"UPS Standard Shipments Originating in United States" , 
    "12"=>"UPS Three-Day Select® Shipments Originating in United States" , 
    "14"=>"UPS Next Day Air® Early A.M. SM Shipments Originating in United States" , 
    "54"=>"UPS Worldwide Express PlusSM Shipments Originating in United States" , 
    "59"=>"UPS Second Day Air A.M.® Shipments Originating in United States" , 
    "65"=>"UPS Saver Shipments Originating in United States" );
    
     $canadaServiceCodes = array(
    "01"=>"UPS Express",
    "02"=>"UPS Worldwide ExpeditedSM",
    "11"=>"UPS Standard",
   "12"=>"UPS Three-Day Select®",
    "13"=>"UPS Saver SM",
    "14"=>"UPS Express Early A.M. SM"
        );
        
    $anyCountryServiceCodes = array(
        "96"=>"UPS Worldwide Express Freight",
        "07"=>"UPS Express",
        "08"=>"UPS Worldwide ExpeditedSM",
        "11"=>"UPS Standard",
        "54"=>"UPS Worldwide Express PlusSM",
        "65"=>"UPS Saver");
   
     $canadaToUsServiceCodes = array(
        "01"=>"UPS Express"

    );
                    
                    
                   
			$ups_weight=$cnfg['ups_nweight'];
			$ups_rate=$cnfg['ups_rate'];
			$ups_container=$cnfg['ups_container_type'];
			$ups_type=$cnfg['ups_res_type'];
                        $upsUserId = $cnfg['ups_user_id'];
                        $upsAccessLicenseNumber =$cnfg['ups_license'];
                        $upsPassword =$cnfg['ups_password'];
                        $upsShipperNumber = $cnfg['ups_shipper_number'];
                        $upsConvesrionRate = $cnfg['ups_conversion_rate'];
                 
                    $cnt=$i; 
                    $charges =array();
                     $shipopt = array();
                    $shippedpacketweight = $shipweight2;
						$count=0;
						$err_cnt = 0;
// 						echopre($cnfg);
						$origin_country_code = $cnfg['shipping_origin_country'];
                                                 if($origin_country_code == 'US')
                                                    $ups_types = $usServiceCodes;
                                                 else if($origin_country_code == 'CA' && $destination_country !='US')
                                                    $ups_types = $canadaServiceCodes;
                                                else if($origin_country_code == 'CA' && $destination_country =='US')
                                                    $ups_types = $canadaToUsServiceCodes;
                                                else
                                                    $ups_types = $anyCountryServiceCodes;
                                                $this->Upsshipping->credentials($upsUserId, $upsAccessLicenseNumber,$upsPassword, $upsShipperNumber);
                                                $this->Upsshipping->conversionrate($upsConvesrionRate);
                                                
                                                
						$sarry_cnt = count($ups_types);
						foreach($ups_types as $types=>$ups){
							if($cnt==$i){
								$check='checked';
							} else {
								$check='';
							}//end else
                                                        
                                                     
                                                        
							$this->Upsshipping->upsProduct($types); // See upsProduct() function for codes 
							$this->Upsshipping->origin($origin_postal,$origin_country); // Use ISO country codes! 
							$this->Upsshipping->dest($destination_postal,$destination_country); // Use ISO country codes! 
							$this->Upsshipping->rate($ups_rate); // See the rate() function for codes 
							$this->Upsshipping->container($ups_container); // See the container() function for codes 
							$this->Upsshipping->weight(number_format($shipweight2,2,".","")); 
							$this->Upsshipping->rescom($ups_type); // See the rescom() function for codes 
							$quote = $this->Upsshipping->getQuote(); 
							
                                                    //   echo $shipweight2; exit; 
                                                        
							if(($quote!="error") && ($msgflag!=1))	{
							
								 $upscharge = number_format(($quote),2 ,".","" );
								// Calculate Shipping cost of products with out free shipping -- Modified ON 09-06-2010
								if($shippedpacketweight>=0)
								 {
									$originalshiprate=(($quote/$shipweight2)*$shippedpacketweight);
									$upschargedisplay=number_format(($originalshiprate),2 ,".","" );
								}
								else{
									$upschargedisplay=$upscharge;
								}
								// End Check for Free ship charge deduction calculation
								
								$servicename=$ups."-".$upscharge;
								//Catwalk Coding 
								//echo '<input type="radio" name="packet_'.$key.'" value="'.$servicename.'" checked >'.$ups.' &nbsp;&nbsp;&nbsp;&nbsp;('.$currency_attributes[0].'&nbsp;'.$upschargedisplay.')<br>';
								//End Catwalk
								
                                                              $charges['title'] =   $ups;
                                                                $charges['cost'] =   $upschargedisplay;
                                                                
                                                                 $shipopt[] = $charges;
                                                                $cnt++;
								$count++;
							} else {
								$err_cnt++;
							}	
						} // end for each 	
						if($err_cnt==$sarry_cnt){
							$errorflag=1;
							//echo "<br><span class='required'> As shipping service is not available for the selected region,Please request a quote so that we can get back to you with the actual shipping cost.   </span><br><br>";
											/*echo "<br><span class='required'>If no shipping service is available for the selected region default shipping charge  will be considered . </span><br><br>";
											$servicename="Shipping Charge";
											$shipmethod="Free Shipping";
											$shipmethodname=$shipmethod."-".$freeshippingprice[$i]*$fedexqty[$i];
											//Catwalk Coding 
											echo '<input type="radio" name="'.ReplaceArray($poptid['product_option_id'][$i]).'" value="'.$shipmethodname.'" '.$check.'>'.$servicename.' &nbsp;&nbsp;&nbsp;&nbsp;('.$currency_attributes[0].'&nbsp;'.$freeshippingprice[$i]*$fedexqty[$i].')<br>';
											 */
											//End Catwalk
						}
                    
                    
                    /*********************** End New Ups shippig ********************/
                    
                    
                    
                    
//			$ups_action_code = '4';
//
//			$text_shipping_weight = '&nbsp;lbs';
//
//			############# These parts has to make dynamic from dbtable###################3333
//
//			$rate_chart 					=	'Letter+Center';//$shipping_settings_row['vvalue'];
//
//			$container_code 				=	'00' ;//$shipping_settings_row['vvalue'];
//
//			$res_code 						= 	'1';//$shipping_settings_row['vvalue'];
//
//			$shipping_box_weight_display 	=	'3'; //$shipping_settings_row['vvalue'];
//
//			$shipping_num_boxes 			=	$bxno;//$shipping_settings_row['vvalue'];
//
//			$module_shipping_handling		=	'';
//
//			####################################################################################
//
//			$shipopt	=	$this->Upsshipping->passValues($module_shipping_handling,$shipping_num_boxes,$shipping_box_weight_display,$res_code,$container_code,$rate_chart,$ups_action_code,$text_shipping_weight,$prod,$shipweight2,$origin_country,$origin_postal,$destination_country,$destination_postal,$module_shipping_ups_types);

			//$this->set('pshipchrg',$shipchrge);

		   //$this->set('shipopt', $shipopt);

             if(isset($shipopt) && empty($shipopt) === false)  {                  

             $this->set('shipopt', $shipopt); $this->set('shipflag','yes'); }

			 else    

            {

               $this->__setFlateRate($qty) ; 

			   $this->set('shipflag','no');

			}    

			

		}elseif($shipmeth == 'USPS'){

		

		################## Portion for USPS Shipping Starts.........................................

		

		     /* Correct working details

			    $usps->setServer("http://testing.shippingapis.com/ShippingAPITest.dll");

				$usps->setUserName("599ARMIA0450");

				$usps->setPass("");

				$usps->setService("All");

				$usps->setDestZip("20008");

				$usps->setOrigZip("10022");

				$usps->setWeight(10, 5);

				$usps->setContainer("Flat Rate Box");

				$usps->setCountry("USA");

				$usps->setMachinable("true");

				$usps->setSize("LARGE");

			*/	

			############# These parts has to make dynamic from dbtable###################3333

			//$this->Usps->setServer("http://testing.shippingapis.com/ShippingAPITest.dll");
			
			$this->Usps->setServer("http://production.shippingapis.com/ShippingAPI.dll");

			$this->Usps->setUserName($cnfg["USPS_Username"]);

			$this->Usps->setService("All");

			#$this->Usps->setDestZip("20008");

			#$usps->setOrigZip("10022");

			$this->Usps->setDestZip($destination_postal);

			$this->Usps->setOrigZip($origin_postal);

			############# These parts has to make dynamic from dbtable###################3333

			
			$Weight = $shipweight;

			$this->Usps->setWeight($Weight , 0);

			//$this->Usps->setWeight(10, 5);
                        
                        //------ check Dimensions -------//
                        if($shipitemlength<12 || $shipitemwidth<12 || $shipitemHeight<12 || $shipitemgrith<12){
                            //echo "small";exit;
                            $this->Usps->setLength('');
                            $this->Usps->setWidth('');
                            $this->Usps->setHeight('');
                            $this->Usps->setGrith('');
                            $this->Usps->setContainer('');
                            $this->Usps->setSize('REGULAR');
                            
                        }else{
                            //echo "large";exit; 
                            $this->Usps->setLength($shipitemlength);
                            $this->Usps->setWidth($shipitemwidth);
                            $this->Usps->setHeight($shipitemHeight);
                            $this->Usps->setGrith($shipitemgrith);
                            $this->Usps->setContainer('NONRECTANGULAR');
                            $this->Usps->setSize('LARGE');
                            
                        }
                        
                        //------ check Dimensions -------//

			//$this->Usps->setContainer("Flat Rate Box");
                        
                        //$this->Usps->setSize("LARGE");

			//$this->Usps->setCountry($destination_country);

			$this->Usps->setCountry('USA');

			$this->Usps->setMachinable("true");

			

			$price = $this->Usps->getPrice();

			$MailArray=array();

			if($price){

				foreach ($price as $key=>$value)

				{

					if($key=='list')

					{	

						for($it=0;$it<count($value);$it++)

						{

							$MailArray[$it]['title']	=	$this->CheckValue($value[$it]);

							$MailArray[$it]['cost']=	$this->CheckValuePrice($value[$it]);

						}//end for loop

					}//end if

				}//end foreach

			}

		//	$this->set('shipopt', $MailArray);

             if(isset($MailArray) && empty($MailArray) === false)  {                  

             $this->set('shipopt', $MailArray); $this->set('shipflag','yes');}

			 else    

            {

               $this->__setFlateRate($qty) ; 

			    $this->set('shipflag','no');

			}    





		}elseif($shipmeth == 'Australiapost'){

		################## Portion for USPS Shipping Starts.........................................

		################## Portion for Australiapost Shipping.......................................

		

			$Pickup_Postcode 		= $origin_postal;

			$Destination_Postcode 	= $destination_postal;

			$Country 				= $destination_country;

			$Weight 				= $shipweight;

			$Service_Type			= "STANDARD";

			$Length					= "100";

			$Width					= "100";

			$Height					= "40";

			$Quantity 				= "1";

			

			$this->Australiapost->set_Pickup_Postcode($Pickup_Postcode);

			$this->Australiapost->set_Destination_Postcode($Destination_Postcode);

			$this->Australiapost->set_Country($Country);

			$this->Australiapost->set_Weight($Weight);

			$this->Australiapost->set_Service_Type($Service_Type);

			$this->Australiapost->set_Length($Length);

			$this->Australiapost->set_Width($Width);

			$this->Australiapost->set_Height($Height);

			$this->Australiapost->set_Quantity($Quantity);

			$auspost	=	$this->Australiapost->getRate();

			//$this->set('shipopt', $auspost);



             if(isset($auspost) && empty($auspost) === false)  {                  

             $this->set('shipopt', $auspost); $this->set('shipflag','yes');}

			 else    

            {

               $this->__setFlateRate($qty) ; 

			    $this->set('shipflag','no');

			}    

	

		}elseif($shipmeth == 'Canadapost'){

		################## Portion for Canadapost Shipping Starts...................................

				$this->Canadapost->setval($cnfg["canadamerchantid"],$cnfg["shipping_origin_zip"]);

				$this->Canadapost->setCustomer( array( 

					'city' => $shipadd["UserAddress"]["city"],

					'provOrState' => $shipadd["UserAddress"]["state"],

					'country' =>$shipadd["UserAddress"]["country"],

					'postalCode' => $shipadd["UserAddress"]["zip"]

				 ) 

			);

			 

			$this->Canadapost->addProduct ( array (

					'quantity' =>'1',

					'weight' => $shipweight,

					'length' => '1',

					'width' => '1',

					'height' => '1',

					'description' => ' '

				)

			); 

			 

			$assoc_Array = $this->Canadapost->getRates('array');

			if(!empty($assoc_Array["product"])){

				$i	=	0;

				foreach($assoc_Array["product"] as $sv){

					$capost[$i]["title"]	=	$sv["name"];

					$capost[$i]["cost"]	=	$sv["rate"];

					$i++;

				}

			}

		//	if(isset($capost) && empty($capost)===false)

		//	$this->set('shipopt', $capost);

              if(isset($capost) && empty($capost) === false)  {                  

             $this->set('shipopt', $capost); $this->set('shipflag','yes');}

			 else    

            {

                $this->__setFlateRate($qty) ; 

			    $this->set('shipflag','no');

			}    



		}elseif($shipmeth == 'FEDEX'){

		################## Portion for Fedex Shipping..........................................

			/*if($shipadd["UserAddress"]["country"]=="United States" || $shipadd["UserAddress"]["country"]=="US" )

			{			

			$fedexService['PRIORITYOVERNIGHT']     = 'FedEx Priority Overnight';

			$fedexService['STANDARDOVERNIGHT']     = 'FedEx Standard Overnight';

			$fedexService['FIRSTOVERNIGHT']        = 'FedEx First Overnight';

			$fedexService['FEDEX2DAY']             = 'FedEx 2 Day';

			$fedexService['FEDEXEXPRESSSAVER']     = 'FedEx Express Saver';

			$fedexService['FEDEX1DAYFREIGHT']      = 'FedEx Overnight Freight';

			$fedexService['FEDEX2DAYFREIGHT']      = 'FedEx 2 day Freight';

			$fedexService['FEDEX3DAYFREIGHT']      = 'FedEx 3 day Freight';

			$fedexService['FEDEXGROUND']           = 'FedEx Ground';

			$fedexService['GROUNDHOMEDELIVERY']    = 'FedEx Home Delivery';

			} else{

			$fedexService['INTERNATIONALPRIORITY'] = 'FedEx International Priority';

			$fedexService['INTERNATIONALECONOMY']  = 'FedEx International Economy';

			$fedexService['INTERNATIONALFIRST']    = 'FedEx International First';

			}

			

			$fedexaccno	=	trim($cnfg["fedexbillaccno"]);

			$fedexmeterno	=	trim($cnfg["fedexmeterno"]);

			$weightunits='LBS';

			$server='test';

			$dropoff='REGULARPICKUP';

			$packageTypes='YOURPACKAGING';

			$currency='USD';

			switch($server)

					{

						case "test":

						$fedexserver="https://gatewaybeta.fedex.com/GatewayDC";

						break;

						case "production":

						// change this to actual server when go on live 

						$fedexserver="https://gatewaybeta.fedex.com/GatewayDC";

						break;

						default:

						$fedexserver="https://gatewaybeta.fedex.com/GatewayDC";

						break;

					}	 // end switch 

					

		    $jt=0;

		    foreach($fedexService as $service => $serviceName)

			{

								

								set_time_limit(0);								

								$this->Fedex->setServer($fedexserver);

								$this->Fedex->setAccountNumber($fedexaccno); //Get your own - this will not work...

								$this->Fedex->setMeterNumber($fedexmeterno);    //Get your own - this will not work...								

								$this->Fedex->setCarrierCode('FDXE'); //Arguement recived from the JS Function.

								$this->Fedex->setDropoffType($dropoff);

								$this->Fedex->setService($service, $serviceName);

								$this->Fedex->setPackaging($packageTypes);

								$this->Fedex->setWeightUnits($weightunits);

								$this->Fedex->setWeight($shipweight);

								$this->Fedex->setOriginStateOrProvinceCode($cnfg["shipping_origin_state"]); 

								$this->Fedex->setOriginPostalCode($cnfg["shipping_origin_zip"]);

								$this->Fedex->setOriginCountryCode($cnfg["shipping_origin_country"]);
								

								$this->Fedex->setDestStateOrProvinceCode($shipadd["UserAddress"]["state"]); //Arguement recived from the JS Function.

								$this->Fedex->setDestPostalCode($shipadd["UserAddress"]["zip"]); //Arguement recived from the JS Function.

								$this->Fedex->setDestCountryCode($shipadd["UserAddress"]["country"]); //Arguement recived from the JS Function.
								

								$this->Fedex->setPayorType("SENDER");

								$fedexprice = $this->Fedex->getPrice();								//print_r($fedexprice);

								if(!empty($fedexprice))
								{ 

									   foreach($fedexprice as $key => $val){
										   if($val['code'] <> 'ERROR'){
											   $fed[$jt]["title"]		=	$val['service']; 
		
											   $fed[$jt]["cost"]		=	$val['rate'];			
		
											   $jt++;	
										   }
									   }	                 				

								} 

							} // end of if stmt

		

            if(isset($fed) && empty($fed) === false)  {                  

             $this->set('shipopt', $fed); $this->set('shipflag','yes');}

			 else    

            {

               $this->__setFlateRate($qty) ; 
               $shipmeth ='Flat Rate Shipping';
			   $this->set('shipflag','no');

			}       

		################## Portion for Fedex Shipping..........................................

		}else

		{

			######@@@@@@@@@@@@@@@ Section for Flat rate shippings;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

			$shipme	=	$this->Setting->findByValue($shipmeth);

		    $this->__getFlateRate($shipmeth,$qty);     

            $this->set('shipflag','yes');

			######@@@@@@@@@@@@@@@ Section for Flat rate shippings;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		}*/
/********************************/
                    
                 if ($shipadd["UserAddress"]["country"] == "United States" || $shipadd["UserAddress"]["country"] == "US") {

                $fedexService['PRIORITYOVERNIGHT'] = 'FedEx Priority Overnight';

                $fedexService['STANDARDOVERNIGHT'] = 'FedEx Standard Overnight';

                $fedexService['FIRSTOVERNIGHT'] = 'FedEx First Overnight';

                $fedexService['FEDEX2DAY'] = 'FedEx 2 Day';

                $fedexService['FEDEXEXPRESSSAVER'] = 'FedEx Express Saver';

                $fedexService['FEDEX1DAYFREIGHT'] = 'FedEx Overnight Freight';

                $fedexService['FEDEX2DAYFREIGHT'] = 'FedEx 2 day Freight';

                $fedexService['FEDEX3DAYFREIGHT'] = 'FedEx 3 day Freight';

                $fedexService['FEDEXGROUND'] = 'FedEx Ground';

                $fedexService['GROUNDHOMEDELIVERY'] = 'FedEx Home Delivery';
            } else {

                $fedexService['INTERNATIONALPRIORITY'] = 'FedEx International Priority';

                $fedexService['INTERNATIONALECONOMY'] = 'FedEx International Economy';

                $fedexService['INTERNATIONALFIRST'] = 'FedEx International First';
            }





            

              /*$fedexaccno='510088000';

              $fedexmeterno='100022250';*/

            

            $fedexaccno = trim($cnfg["fedexbillaccno"]);

            $fedexmeterno = trim($cnfg["fedexmeterno"]);
           

            $weightunits = 'LBS';

            $server = 'production';

            $dropoff = 'REGULARPICKUP';

            $packageTypes = 'YOURPACKAGING';

            $currency = 'USD';

            switch ($server) {

                case "test":

                    $fedexserver = "https://gatewaybeta.fedex.com/GatewayDC";

                    break;

                case "production":

                // change this to actual server when go on live

                    $fedexserver = "https://gatewaybeta.fedex.com/GatewayDC";
                   // $fedexserver = "https://gateway.fedex.com/web-services";

                    break;

                default: 

                    $fedexserver = "https://gatewaybeta.fedex.com/GatewayDC";

                    break;
            }  // end switch



            $jt = 0;

            foreach ($fedexService as $service => $serviceName) {


//echo $dropoff;exit;
                set_time_limit(0);

                $this->Fedex->setServer($fedexserver);

                $this->Fedex->setAccountNumber($fedexaccno); //Get your own - this will not work...

                $this->Fedex->setMeterNumber($fedexmeterno);    //Get your own - this will not work...

                $this->Fedex->setCarrierCode('FDXG'); //Arguement recived from the JS Function.

                $this->Fedex->setDropoffType($dropoff);

                $this->Fedex->setService($service, $serviceName);

                $this->Fedex->setPackaging($packageTypes);

                $this->Fedex->setWeightUnits($weightunits);

                $this->Fedex->setWeight($shipweight);








                //to check
                 /* $this->Fedex->setOriginStateOrProvinceCode('AL');

                  $this->Fedex->setOriginPostalCode('35005');

                  $this->Fedex->setOriginCountryCode('US');

                  $this->Fedex->setDestStateOrProvinceCode('AL'); //Arguement recived from the JS Function.

                  $this->Fedex->setDestPostalCode('35060'); //Arguement recived from the JS Function.

                  $this->Fedex->setDestCountryCode('US'); //Arguement recived from the JS Function.

                  echo '<br>'.$shipadd["UserAddress"]["state"];
                  echo '<br>'.$shipadd["UserAddress"]["zip"];
                  echo '<br>'.$shipadd["UserAddress"]["country"];

                  exit();*/
                   //to check


                $this->Fedex->setOriginStateOrProvinceCode($cnfg["shipping_origin_state"]);

                $this->Fedex->setOriginPostalCode($cnfg["shipping_origin_zip"]);

                $this->Fedex->setOriginCountryCode($cnfg["shipping_origin_country"]);


                $this->Fedex->setDestStateOrProvinceCode($shipadd["UserAddress"]["state"]); //Arguement recived from the JS Function.

                $this->Fedex->setDestPostalCode($shipadd["UserAddress"]["zip"]); //Arguement recived from the JS Function.

                $this->Fedex->setDestCountryCode($shipadd["UserAddress"]["country"]); //Arguement recived from the JS Function.




                $this->Fedex->setPayorType("SENDER");

                $fedexprice = $this->Fedex->getPrice();
               /*print_r($fedexprice);
               echo $fedexprice->error->description;
               exit;*/

                if (empty($fedexprice->error->description) && !empty($fedexprice->price->rate)) {

                    $fed[$jt]["title"] = $fedexprice->serviceName;

                    $fed[$jt]["cost"] = $fedexprice->price->rate;

                    $jt++;
                }
            } // end of if stmt





            if (isset($fed) && empty($fed) === false) {

                $this->set('shipopt', $fed);
                $this->set('shipflag', 'yes');
            } else {

                $this->__setFlateRate($qty);
                $shipmeth = 'Flat Rate Shipping';
                $this->set('shipflag', 'no');
            }

            ################## Portion for Fedex Shipping..........................................
        } else {

            ######@@@@@@@@@@@@@@@ Section for Flat rate shippings;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

            $shipme = $this->Setting->findByValue($shipmeth);

            $this->__getFlateRate($shipmeth, $qty);

            $this->set('shipflag', 'yes');

            ######@@@@@@@@@@@@@@@ Section for Flat rate shippings;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        }
/*****************************/



		$citem			=	$this->Cart->findAllByUserId($user_id);

		$this->set('prodtype', "Non-digital");

		if(!empty($citem)){

			foreach($citem as $it){

				if($it["Product"]["prodtype"] == "Digital"){

					$this->set('prodtype', "Digital");

				}

			}

		}

		$this->set('shippingmethod', $shipmeth);

		

	}





   function __setFlateRate($qty=0)   

   {  

	        $cnfg 		= Configure::read('Neutrino');         

	        $ship_method='';    

		   	if($cnfg["fflat_shipping_require"]	==	"Y"){

			$ship_method=	$cnfg["flat_ship_name"];

			}

			else if($cnfg["sflat_shipping_require"]	==	"Y"){

				$ship_method=	$cnfg["secflat_ship_name"];			

			}

			else if($cnfg["tflat_shipping_require"]	==	"Y"){

				$ship_method=	$cnfg["thirdflat_ship_name"];

			}

			if($cnfg["foflat_shipping_require"]	==	"Y"){

				$ship_method=	$cnfg["forthflat_ship_name"];

			}      

			$this->__getFlateRate($ship_method,$qty);             

    }    



   function __getFlateRate($ship_method='',$qty=0)  

   {  

            $cnfg 		= Configure::read('Neutrino');         

			$shipme	=	$this->Setting->findByValue($ship_method);

        	if($shipme["Setting"]["fieldname"]	==	"flat_ship_name"){

				$shipchrge		=	$cnfg["flat_shipping_first"];

				$shipchrgeadd	=	$cnfg["flat_shipping_additional"] * ($qty - 1);

				$shipchrge		=	$shipchrge + $shipchrgeadd;

				$shiph[0]["title"]		=	$ship_method;

				$shiph[0]["cost"]		=	$shipchrge;

                $this->set('first_item', $cnfg["flat_shipping_first"]);               

 	            $this->set('additional_item', $cnfg["flat_shipping_additional"]);

				$this->set('shipopt', $shiph);

				$this->set('pshipchrg',$shipchrge);

			}elseif($shipme["Setting"]["fieldname"]	==	"secflat_ship_name"){

				$shipchrge		=	$cnfg["secflat_shipping_first"];

				$shipchrgeadd	=	$cnfg["secflat_shipping_additional"] * ($qty - 1);

				$shipchrge		=	$shipchrge + $shipchrgeadd;

				$shiph[0]["title"]		=	$ship_method;

				$shiph[0]["cost"]		=	$shipchrge;

                $this->set('first_item', $cnfg["secflat_shipping_first"]);               

 	            $this->set('additional_item', $cnfg["secflat_shipping_additional"]);

				$this->set('shipopt', $shiph);

				$this->set('pshipchrg',$shipchrge);

			}elseif($shipme["Setting"]["fieldname"]	==	"thirdflat_ship_name"){

				$shipchrge		=	$cnfg["thirdflat_shipping_first"];

				$shipchrgeadd	=	$cnfg["thirdflat_shipping_additional"] * ($qty - 1);

				$shipchrge		=	$shipchrge + $shipchrgeadd;

				$shiph[0]["title"]		=	$ship_method;

				$shiph[0]["cost"]		=	$shipchrge;

                $this->set('first_item', $cnfg["thirdflat_shipping_first"]);               

 	            $this->set('additional_item', $cnfg["thirdflat_shipping_additional"]);

				$this->set('shipopt', $shiph);

				$this->set('pshipchrg',$shipchrge);

			}elseif($shipme["Setting"]["fieldname"]	==	"forthflat_ship_name"){

				$shipchrge		=	$cnfg["forthflat_shipping_first"];

				$shipchrgeadd	=	$cnfg["forthflat_shipping_additional"] * ($qty - 1);

				$shipchrge		=	$shipchrge + $shipchrgeadd;

				$shiph[0]["title"]		=	$ship_method;

				$shiph[0]["cost"]		=	$shipchrge;

             	$this->set('first_item', $cnfg["forthflat_shipping_first"]);               

 	            $this->set('additional_item', $cnfg["forthflat_shipping_additional"]);

				$this->set('shipopt', $shiph);

				$this->set('pshipchrg',$shipchrge);

			} else {

                $this->set('first_item', 0);               

 	            $this->set('additional_item',0);

                $this->set('shipopt', '');

				$this->set('pshipchrg',0);} 

   }

   

   

   

		function payment(){

	    $ship="";

		$cnfg 	= 	Configure::read('Neutrino');		

		$this->set('cnfg', $cnfg);

        if($this->Session->check('SESS_SHIPMENT'))

		{

			$this->Session->delete('SESS_SHIPMENT');

		}

		$this->__validateLoginStatus();

		$sus			=	$this->Session->read('Userlog');		

		$this->set('sus', $sus);

		$user_id	=	$sus["id"];

		$cnfg 					= 	Configure::read('Neutrino'); 

		$curr		=	$this->Currency->findByCode($cnfg["currency"]);

		$this->set('curlogo',$curr["Currency"]["logo"]);

		//Code Added By shyam for Category Menu Listing starts here..

		 $lst	=	$this->Category->findAll();			 

		 foreach($lst as $det)

		 $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"]);

		 $this->set('menu_array', $menu_array);		

		//Code Added By shyam for Category Menu Listing ends here..

		

		if(isset($_POST["ship_method"]))

		{

			$ship				=	$_POST["ship_method"];			

			if($ship <> ''){

				$shipp				=	explode('|~@~|',$ship);

				$shippingMethod		=	$shipp[0];

				$shippingServ		=	$shipp[1];

				$shipping_cost		=	$shipp[2];

                $this->Session->write('SESS_SHIPMENT',$ship);

			}

			else

			{

			    $ship	            =   '';

				$shippingMethod		=	'';

				$shippingServ		=	'';

				$shipping_cost		=	0;

		   }					

		}

		else

		{

		        $ship	            =   '';

				$shippingMethod		=	'';

				$shippingServ		=	'';

				$shipping_cost		=	0;

                $this->Session->write('SESS_SHIPMENT',$ship);				

		}

		

   ########################## Getting total price from cart ******************************************

		$citem		=	$this->Cart->findAllByUserId($user_id);
		
		if(count($citem	) < 1)
		{
		 $this->redirect(array('controller' => 'pages', 'action' => 'display')); 
		 exit();
		}

		$tot_price	=	0;

		$final_price = 0;
		
		//Getting the product type in the cart
		$prod_type = 	"Non-Digital";
			if(!empty($citem)){
				foreach($citem as $it){
					if(trim($it["Cart"]["prodtype"]) == "Digital"){
						$prod_type = 	"Digital";
					}
				}
			}
        //Getting the product type in the cart
		
		
		foreach($citem as $item)

		   { 		

			$combined_price=($item["Cart"]["product_price"] + $item["Cart"]["extra_price"]);			

			 if(isset($item["Cart"]["discount_type"]) && $item["Cart"]["discount_type"] <> '')

			  { 

				if($item["Cart"]["discount_type"]=='per')

				 {

				    if(isset($item["Cart"]["discount"]) && $item["Cart"]["discount"] <> '' && $item["Cart"]["discount"] > 0)

					{

					 $discounted_price=($item["Cart"]["product_price"] -(($item["Cart"]["product_price"] * $item["Cart"]["discount"])/100));

					 $final_price=($discounted_price + $item["Cart"]["extra_price"])*$item["Cart"]["quantity"];

					}	

					else

					$final_price=($combined_price)*$item["Cart"]["quantity"];											 

				 }

				 else if($item["Cart"]["discount_type"]=='amnt')

				 {	 

				    if(isset($item["Cart"]["discount"]) && $item["Cart"]["discount"] <> '' && $item["Cart"]["discount"] > 0)

					 {

						$discounted_price=(($item["Cart"]["product_price"])-$item["Cart"]["discount"]);

                                                $final_price=($discounted_price + $item["Cart"]["extra_price"])*$item["Cart"]["quantity"];

					 }	

					 else

					$final_price=($combined_price)*$item["Cart"]["quantity"];			

				}

			  }

			 else

			 {

			  $final_price=($item["Cart"]["product_price"] + $item["Cart"]["extra_price"])*$item["Cart"]["quantity"];			 	

			 }	

			 $tot_price = $tot_price +  $final_price; 			

		 }	

		 $this->set('totaltopay', number_format($tot_price,2,".",""));			

		

         ########################## Getting total price from cart ******************************************

		 

        



		

		######################### Section to find and add tax amount.............................		

		$taxamt	=0;

		if($cnfg["taxto"]	==	"gtotal"){

			$taxableamt		=	$tot_price + $shipping_cost;

		}else{

			$taxableamt		=	$tot_price ;

		}



		if($cnfg["tax_option"] == "notax"){

			$taxperc	=	0;

			$taxname	=	"No Tax is applicable";

		}elseif($cnfg["tax_option"] == "fixedtax"){

			$taxperc	= 	$cnfg["fixedtax_rate"];

			$taxname	=	$cnfg["fixedtax_name"];

		}else{

						
			if($cnfg["taxable_address"] == "shipping")
			{
				if(trim($prod_type) == 'Digital')
				$billadd	=	$this->UserAddress->find('UserAddress.user_id = '.$user_id.' AND UserAddress.addr_type = "Billing"');
				else
				$billadd	=	$this->UserAddress->find('UserAddress.user_id = '.$user_id.' AND UserAddress.addr_type = "Shipping"');
			}
			else
			{
				$billadd	=	$this->UserAddress->find('UserAddress.user_id = '.$user_id.' AND UserAddress.addr_type = "Billing"');				
			}
         
			$stdetal		=	$this->State->find('State.country_id = "'.$billadd["UserAddress"]["country"].'" AND State.code = "All"');

			if(!empty($stdetal["State"])){

				$taxperc	=	$stdetal["State"]["tax_rate"];

				$taxname	=	$stdetal["State"]["tax_name"];

			}else{

				$stdetal	=	$this->State->find('State.country_id = "'.$billadd["UserAddress"]["country"].'" AND State.code ="'.$billadd["UserAddress"]["state"].'"');

				if(!empty($stdetal["State"])){

					$taxperc	=	$stdetal["State"]["tax_rate"];

					$taxname	=	$stdetal["State"]["tax_name"];

				}else{

					$stdetal	=	$this->State->find('State.country_id = "'.$billadd["UserAddress"]["country"].'" AND State.name ="'.$billadd["UserAddress"]["state"].'"');

					if(!empty($stdetal["State"])){

						$taxperc	=	$stdetal["State"]["tax_rate"];

						$taxname	=	$stdetal["State"]["tax_name"];

					}else{

						$taxperc	=	0;

						$taxname	=	"No Tax is applicable";

					}

				}

			}

		}



		

		if($tot_price > 0)

		{

		$taxamt		=	($taxableamt * $taxperc) / 100;

		$taxamt		=	number_format($taxamt,2,".","")	;			

		$tot_price	=	$tot_price;					
		}

		

	

		########################## Coupon code section ******************************************

		$discamt	=	0;

		if($this->Session->check('Coupon') == true){

			$couparray	=	$this->Session->read('Coupon');			

			$tdat	=	date("Y-m-d");			

			if(strtotime($tdat) >= strtotime($couparray["Coupon"]["from_date"]) && strtotime($tdat) <= strtotime($couparray["Coupon"]["to_date"]) && $tot_price >= $couparray["Coupon"]["minamt"] ){

				if($couparray["Coupon"]["type"] == "Amt"){

					//$discamt	=	$couparray["Coupon"]["giftvalue"];

					 if($couparray["Coupon"]["giftvalue"] >= $tot_price)

					 $discamt	=	$tot_price;

					 else

					 $discamt	=	$couparray["Coupon"]["giftvalue"];

				}else{

					$discamt	=	$tot_price * ($couparray["Coupon"]["giftvalue"] / 100);

				}

			}					

			$tot_price	=	number_format(($tot_price - $discamt),2,".","");				

			$order["coupon_id"]		=	$couparray["Coupon"]["id"];

			$order["discount"]		=	$discamt;

		}					

		//exit();

		########################## Coupon code section ******************************************		



		

		######################### End of Section to find and add tax amount......................

		//$totaltopay = 	number_format($tot_price,2,".","");

		if($tot_price > 0)

		$gtotal		=	number_format(($tot_price + $shipping_cost),2,".","");

		else

		$gtotal		=	number_format(0.00 + $shipping_cost,2,".","");

		$paymentMethod = "CC";			

	

		

		$giftcard_cnt = $this->GiftcardDetail->find('count', array('conditions' => array('GiftcardDetail.user_id' => $user_id)));

		$this->set('giftcard_cnt', $giftcard_cnt);

		  $data1	=	$this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value')));
        
   
       

		/*************** Section for Placing Order without payment Starts**********************************************/
		/************** Added By Jipson Thomas on 3rdJanuary 2011**********************************************/
		$shipadd						=	$this->UserAddress->find("UserAddress.user_id =".$user_id." AND UserAddress.addr_type ='Shipping'");
			$cntdet							=	$this->Country->findByCountryIsoCode_2($shipadd["UserAddress"]["country"]);
			$shipadd["UserAddress"]["country_name"]	=	$cntdet["Country"]["country_name"];
			$citem							=	$this->Cart->findAllByUserId($user_id);
			$prodtype = 	"Non-Digital";
			$order["date"]					=	date("Y-m-d H:i:s");
			$order["user_id"]				=	$user_id;
			$order["shipping_method"]		=	$shippingMethod;
			$order["shipping_service"]		=	$shippingServ;
			$order["shipping_price"]		=	$shipping_cost;
			$order["tax_price"]				=	$taxamt	;
			$order["tax_name"]				=	$taxname	;
			$order["total_price"]			=	$gtotal;
			$order["order_status_id"]		=	1;
			$order["ship_fname"]			=	$shipadd["UserAddress"]["fname"];
			$order["ship_lname"]			=	$shipadd["UserAddress"]["lname"];
			$order["ship_address"]			=	$shipadd["UserAddress"]["address"];
			$order["ship_city"]				=	$shipadd["UserAddress"]["city"];
			$order["ship_state"]			=	$shipadd["UserAddress"]["state"];
			$order["ship_country"]			=	$shipadd["UserAddress"]["country_name"];
			$order["ship_zip"]				=	$shipadd["UserAddress"]["zip"];
			$order["ship_phone"]			=	$shipadd["UserAddress"]["phone"];
			$order["ship_mobile"]			=	$shipadd["UserAddress"]["mobile"];
			$order["ship_fax"]				=	$shipadd["UserAddress"]["fax"];
			$billadd						=	$this->UserAddress->find("UserAddress.user_id =".$user_id." AND UserAddress.addr_type ='Billing'");
			$bcntdet						=	$this->Country->findByCountryIsoCode_2($billadd["UserAddress"]["country"]);
			$billadd["UserAddress"]["country_name"]	=	$bcntdet["Country"]["country_name"];
			$order["bill_fname"]			=	$billadd["UserAddress"]["fname"];
			$order["bill_lname"]			=	$billadd["UserAddress"]["lname"];
			$order["bill_address"]			=	$billadd["UserAddress"]["address"];
			$order["bill_city"]				=	$billadd["UserAddress"]["city"];
			$order["bill_state"]			=	$billadd["UserAddress"]["state"];
			$order["bill_country"]			=	$billadd["UserAddress"]["country_name"];
			$order["bill_zip"]				=	$billadd["UserAddress"]["zip"];
			$order["bill_phone"]			=	$billadd["UserAddress"]["phone"];
			$order["bill_mobile"]			=	$billadd["UserAddress"]["mobile"];
			$order["bill_fax"]				=	$billadd["UserAddress"]["fax"];
		
			$order["currency_type"]			=	 $data1["currency"]; 
			
		
			if($_POST["pymnttype"]=="paynow"){
				//$this->Session->delete('orderforpayment');
					$this->Session->write('orderforpayment', $order);
				
				$this->Session->write('orderdetailsforpayment',$citem);
				$this->redirect(array('controller' => 'orders','action'=>'paynow/'));
				exit;
			}
			$this->Session->delete('orderforpayment');
			$this->Session->delete('orderdetailsforpayment');
			
			$this->Order->save($order); 
			$order_id						=	$this->Order->id;
			foreach($citem as $item){
				$this->OrderDetail->create($odet = array());				
				$odet["order_id"]			=	$order_id;
				$odet["product_id"]			=	$item["Cart"]["product_id"];
				$odet["product_price"]		=	$item["Cart"]["product_price"];
				$odet["prodtype"]		    =	$item["Cart"]["prodtype"];
				$odet["discount_type"]		=	$item["Cart"]["discount_type"];
				$odet["discount"]			=	$item["Cart"]["discount"];				
				$odet["extra_price"]		=	$item["Cart"]["extra_price"];
				$odet["quantity"]			=	$item["Cart"]["quantity"];
				$odet["savedimages_id"]		=	$item["Cart"]["savedimages_id"];
				if($item["Cart"]["option_id"]>0 && $item["Cart"]["type"] <> 'G') {							
				$odet["combination_id"]		=	$item["Cart"]["option_id"]; }
				$odet["type"]			    =	$item["Cart"]["type"];
				$odet["price_type"]			=	$item["Cart"]["price_type"];
                                $odet["custom_information"] =  $item["Cart"]["custom_information"];
                                
				$this->OrderDetail->save($odet);
				######## ( Code Added by Shyam)	########
				if($item["Cart"]["option_id"]>0)
				 {
				 $this->Product->updatecombnstock($item["Cart"]["product_id"],$item["Cart"]["option_id"],$item["Cart"]["quantity"]);
				 $prodid[]=$item["Cart"]["product_id"];										 
				 }
				else if($item["Cart"]["option_id"]==0 || $item["Cart"]["option_id"]=='') {
				$this->Product->updatestock($item["Cart"]["product_id"],$item["Cart"]["quantity"]); }				
				if($item["Cart"]["type"] == 'G')
				{
				  $this->Giftcard->updateCardStock($item["Cart"]["product_id"],$item["Cart"]["quantity"]);	
				}
				######## ( Code Added by Shyam)	########
			}
			if(!empty($prodid))
			{	
				$prodid=array_unique($prodid);
				foreach($prodid as $val){	
				 $this->Product->updateTotalStock($val);
				}
			}
			$this->delcart($user_id);
			
			################################## Section to send order confirmation mail................................
			$this->Order->id = $order_id; 
			$data = $this->Order->read();
                        
                        
                            $data1	=	$this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value')));
            $curr			=	$this->Currency->findByCode($data1["currency"]);
            $currlogo1 = $curr["Currency"]["logo"];
            $currCode1 = $curr["Currency"]["code"];  
			for($j=0;$j < sizeof($data["OrderDetail"]);$j++){
			  if($data["OrderDetail"][$j]["type"]=='P')
			  {
				$pdet	=	$this->Product->findById($data["OrderDetail"][$j]["product_id"]);				  	
				$data["OrderDetail"][$j]["Product"]	=	$pdet["Product"]["pname"];
			  }
			  else if($data["OrderDetail"][$j]["type"]=='G')
			  {
				$gdet	=	$this->Giftcard->findById($data["OrderDetail"][$j]["product_id"]);								
				$data["OrderDetail"][$j]["Product"]	=	$gdet["Giftcard"]["gift_code"].'(Gift Card)';
				$data["OrderDetail"][$j]["product_price"]	=	$gdet["Giftcard"]["gift_amnt"];
			  }
			}		
			$shipadd	=	$this->UserAddress->findAll("UserAddress.user_id=".$data["User"]["id"]." AND UserAddress.addr_type='Shipping'");
			$billadd	=	$this->UserAddress->findAll("UserAddress.user_id=".$data["User"]["id"]." AND UserAddress.addr_type='Billing'");
			$bill_email=$billadd[0]["UserAddress"]["email"];
			$odr	=	$data;
			if($prodtype <> "Digital"){
			$ship	=	$shipadd[0]["UserAddress"]; }
			$bill	=	$billadd[0]["UserAddress"];
			
			 $content = "<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>
	  <tr>

		<td colspan='2' align='center'>

		<h2>Quote Details</h2>

		</td>

	  </tr>

	  <tr>

		<td colspan='2' align='center'>

			<table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'>

			 <tr>

				<td><strong>Order Number</strong></td>
				
				<td><strong>Order Status</strong></td>

				<td><strong>Order Date</strong></td>

				<td><strong>User Name</strong></td>

				<td><strong>Currency</strong></td>

			  </tr>

			  <tr>

				<td>&nbsp;</td>
				
				<td>&nbsp;</td>

				<td>&nbsp;</td>

				<td>&nbsp;</td>

				<td>&nbsp;</td>

			  </tr>

			  <tr>

                <td> ".$order_id."</td>
				<td>".

				$odr['OrderStatus']['name']."

				</td>

				<td>";
				

				$dt	= strtotime($odr['Order']['date']);

				$edt	= strtotime($odr['Order']['exp_time']);

				$content .= date('m-d-Y',$dt );

				$content .= "</td>

				<td> ".$odr['User']['uname']."</td>

				<td>". $currCode1."</td>

			  </tr>

			</table>

		</td>

	  </tr>

	  <tr>

		<td colspan='2' align='center'><h3>Item Details</h3></td>

	   

	  </tr>

	  <tr>

		<td colspan='2'><table width='90%' border='0' cellpadding='2' cellspacing='2' class='manage_table' align='center'>

	  <tr>

		<td colspan='2' width='24%' valign='top'><strong>Product Name</strong></td>

		<td width='12%' valign='top'><strong>Quantity</strong></td>

		<td width='15%' valign='top'><strong>Unit Price</strong></td>

		<td width='15%' valign='top'><strong>Additional Cost</strong></td>

		<td width='14%' valign='top'><strong>Discount</strong></td>

		<td colspan='2' valign='top'><strong>Price</strong></td>		

		<td valign='top'></td>


	  </tr>

	  <tr>

		<td colspan='3'>&nbsp;</td>

		<td>&nbsp;</td>

		<td>&nbsp;</td>

		<td>&nbsp;</td>

		<td>&nbsp;</td>

		<td>&nbsp;</td>

		<td>&nbsp;</td>

	  </tr>";

	  

	  $amt=0;

	  //print_r($odr);exit;

	  foreach($odr['OrderDetail'] as $det)

	  { 

	      $price=0;

		  $combined_price=0;

		  $dis_amnt=0;	

		  if($det["discount_type"]=='per' && $det["discount"] > 0)

		  //$dis_amnt=(($det["product_price"] + $det["extra_price"])*$det["discount"])/100;
                    $dis_amnt= $det["product_price"] * $det["discount"] / 100;

		  else if($det["discount_type"]=='amnt' && $det["discount"] > 0)

		  $dis_amnt=$det["discount"];		

		  $dis_amnt=number_format($dis_amnt,2,'.','');

		   

			$combined_price=($det["product_price"] + $det["extra_price"]);


			 if(isset($det["discount_type"]) && $det["discount_type"] <> '')

			  { 

				if($det["discount_type"]=='per')

				 {

				  if(isset($det["discount"]) && $det["discount"] <> '' && $det["discount"] > 0)

					{					 

					    $discounted_price=($det["product_price"]-(($det["product_price"] * $det['discount'])/100));

						$price=($discounted_price + $det["extra_price"]) * $det['quantity'];

						$amt += $price;

					}			

					else

					$amt+=($combined_price)*($det['quantity']);										 

				 }

				 else if($det["discount_type"]=='amnt')

				 {	 

				     if(isset($det["discount"]) && $det["discount"] <> '' && $det["discount"] > 0)

					 {
						$discounted_price=($det["product_price"]-$det['discount']);

						$price=($discounted_price + $det["extra_price"]) * ($det['quantity']);

						$amt+= $price;									

					 }		

					 else

					$amt+=($combined_price)*($det['quantity']);			

				}

			  }

			 else

			 {			 	

			    $price = ($combined_price)*($det['quantity']);

				$amt+= $price;		 	

			 }				

			 $price=number_format($price,2,".","");  

			 $amt=number_format($amt,2,".",""); 

			   /******************* to get Combination name *************/
                         
                          $combnstr = array();
        $combinations = array();
       $combinationanme = '';
         $prod1 = $this->Productdetail->findById($det['combination_id']);
               
       
          
              
               if($prod1){ 
                  $pcmbnids=$prod1["Productdetail"]["customvalue_id"];

                  $pcmbnid=explode(',',$pcmbnids);

                    foreach($pcmbnid as $key => $val) {

                       if($val!='') { 
                           $combnstr[]=$this->Product->getpdctcmbn($val);
          
                           $combinations=implode(", ",$combnstr);
                           
                           
                           $combinationanme = $combinations;
                        }else{
                            $combinationanme = '';
                        }

                    }

                  
               }
                
		  /******************* to get Combination name *************/

		

			 $content .= " <tr>

			<td colspan='2' valign='top'>".$det['Product'].' '.$combinationanme."</td>

			<td valign='top'> ".$det['quantity']." </td>

			<td valign='top'> ".$currlogo1. " ".$det['product_price']." </td>

			<td valign='top'> ".$currlogo1. " ".$det['extra_price']." </td>

			<td valign='top'> ".$currlogo1. " ".$dis_amnt." </td>

			<td valign='top'>".$currlogo1. " ".$price." </td>			

			<td valign='top'>&nbsp;</td>

		  </tr>

		  <tr>

			<td colspan='3' height='15'>&nbsp;</td>

			<td>&nbsp;</td>

			<td>&nbsp;</td>

			<td>&nbsp;</td>

			<td>&nbsp;</td>
			<td>&nbsp;</td>

			<td>&nbsp;</td>

		  </tr>";
	  } 

	  

	     if($odr["Order"]["discount"] > $amt)				

		 $discamt=number_format($amt,2,'.','');

		 else

		 $discamt=number_format($odr["Order"]["discount"],2,'.',''); 

	$content .= "</table>

	</td>

	  </tr>

	  <tr>

		<td width='50%'>";

		  if($det['prodtype'] <> "Digital"){

			 $content .="<table width='100%'border='0' cellpadding='0' cellspacing='0'>

		<tr><td>

		<table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'>

			  <tr>

				<td width='50%'><strong>Shipping Method</strong></td>

				<td  width='5%'>:</td>

				<td width='45%'>".$odr['Order']['shipping_method']."</td>

			  </tr>

			  <tr>

				<td><strong>Shipping Service</strong></td>

				<td>:</td>

				<td>". $odr['Order']['shipping_service']." </td>

			  </tr>

			</table>

		</td></tr>

		<tr><td>

		
		</td></tr>

		</table>";

		}

		

	 $content .="</td>

		<td width='50%'><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'>

			  <tr>

				<td><strong>Total Price</strong></td>

				<td>:</td>

				<td>".$amt."</td>

			  </tr>";

			  if($det['prodtype'] <> "Digital"){  

			   $content .="<tr>

				<td><strong>Shipping</strong></td>

				<td>:</td>

				<td> ".$odr['Order']['shipping_price']." </td>

			  </tr>";

			  }

			   $content .="<tr>

				<td><strong>Tax Name</strong></td>

				<td>:</td>

				<td> ".$odr['Order']['tax_name'] ."</td>

			  </tr>

			   <tr>

				<td><strong>Tax</strong></td>

				<td>:</td>

				<td> ".$odr['Order']['tax_price'] ."</td>

			  </tr>

			   <tr>

				<td><strong>Discount </strong></td>

				<td>:</td>

				<td> ".$discamt." </td>

			  </tr>

			   <tr>

				<td><strong>Promo Code Discount</strong></td>

				<td>:</td>

				<td> ".$odr['Order']['reduced_amt'] ."</td>

			  </tr>
                          
			   <tr>

				<td><strong>Grand Total</strong></td>

				<td>:</td>

				<td><b> ".number_format($odr['Order']['total_price']+$odr['Order']['tax_price']-$odr['Order']['reduced_amt'],2)." </b></td>

			  </tr>

			</table></td>

	  </tr>

	   <tr height='15'>

		<td colspan='2' align='center'>&nbsp;

		</td>

	  </tr>

	  <tr>

	  <td>";

	  

	  if($det['prodtype'] <> "Digital"){

			 $content .="<table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'>

	  <tr>

		<td><h3>Shipping Address</h3></td>

	  </tr>

	  <tr>

		<td> ".$odr['Order']['ship_fname'] ."&nbsp;&nbsp;  ".$odr['Order']['ship_lname']." </td>

	  </tr>

	  <tr>

		<td> ".$odr['Order']['ship_address']." </td>

	  </tr>

	  <tr>

		<td> ".$odr['Order']['ship_city'] ."&nbsp;&nbsp;&nbsp;".$odr['Order']['ship_state']."&nbsp;&nbsp;&nbsp;".  $odr['Order']['ship_zip']." </td>

	  </tr>

	  <tr>

		<td> ".$odr['Order']['ship_country']." </td>

	  </tr>

	  <tr>

		<td>Phone &nbsp; : &nbsp; ".$odr['Order']['ship_phone']." </td>

	  </tr>

	  <tr>

		<td>Mobile &nbsp; : &nbsp;". $odr['Order']['ship_mobile'] ."</td>

	  </tr>

	  <tr>

		<td>Fax &nbsp; : &nbsp; ".$odr['Order']['ship_fax']." </td>

	  </tr>

	  <tr>

		<td>&nbsp;</td>

	  </tr>

	</table>";

	} 

	

	$content .=" </td>

	   <td><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'>

	  <tr>

		<td><h3> Billing Address</h3></td>

	  </tr>

	  <tr>

		<td> ".$odr['Order']['bill_fname'] ."&nbsp;&nbsp; ".$odr['Order']['bill_lname']." </td>

	  </tr>

	  <tr>

		<td> ".$odr['Order']['bill_address'] ."</td>

	  </tr>

	  <tr>

		<td>". $odr['Order']['bill_city']."&nbsp;&nbsp;&nbsp;". $odr['Order']['bill_state'] ."&nbsp;&nbsp;&nbsp;". $odr['Order']['bill_zip'] ."</td>

	  </tr>

	  <tr>

		<td>". $odr['Order']['bill_country'] ." </td>

	  </tr>

	  <tr>



		<td>Phone &nbsp; : &nbsp; ".$odr['Order']['bill_phone'] ."</td>

	  </tr>

	  <tr>

		<td>Mobile &nbsp; : &nbsp; ".$odr['Order']['bill_mobile']." </td>

	  </tr>

	  <tr>

		<td>Fax &nbsp; : &nbsp; ".$odr['Order']['bill_fax'] ."</td>

	  </tr>

	  <tr>

		<td>&nbsp;</td>

	  </tr>

	</table></td>

	  </tr>";
		$content .="<tr>

			<td>&nbsp;</td>

		  </tr>

		</table>

	  </td>

	   <td>&nbsp;</td>

	  </tr>

	</table>";

$cnfg 			=	Configure::read('Neutrino');
$subject 		= "Quote request placed at ".$cnfg["site_name"];

					$headers 		= "MIME-Version: 1.0\r\n";
					
					$headers        .= "Reply-To: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";
					
					$headers        .= "Return-Path: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";
					
					$headers 		.= "From: ".$cnfg["site_name"]."<".$cnfg["admin_email"].">\r\n";
					
					$headers        .= "Organization: ".$cnfg["site_name"]."\r\n";

					$headers 		.= "Content-type: text/html; charset=iso-8859-1\r\n";

					$pdt 			= 	$this->Cmspage->findByTitle('Quote confirm mail');

					$path			=	"SiteLogo_disp.gif";

					$mcont			=	"<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>

		  <tr><td><a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'><img src='".FULL_BASE_URL. $cnfg["sitebasefolder"]."/app/webroot/".IMAGES_URL.$path."' border='0' width='300' ></a></td></tr></table>";

					$cnfg["site_name"]	=	"<a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'>".$cnfg["site_name"]."</a>";

					//Mail for User

						$pdt 			= 	$this->Cmspage->findByTitle('Quote confirm mail');

						$mailcontent	=	$mcont.$pdt["Cmspage"]["content"];

						$mailcontent = str_replace("[ORDER_DETAILS]", $content, $mailcontent);

						$mailcontent = str_replace("[User_Name]", $odr['User']['uname'], $mailcontent);

						$mailcontent = str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent);		

						
						
						if(strcmp($bill_email, $odr['User']['email'])==0)
						{
							$odr['User']['email']=$odr['User']['email'];
						}
						else
						{
							$odr['User']['email']=$bill_email.",".$odr['User']['email'];
						}
						
						$mailsent 		= mail($odr['User']['email'],$subject,$mailcontent,$headers);	

						

						//Mail for Admin

						$pdt1 			= 	$this->Cmspage->findByTitle('Admin quote confirm mail');

						$mailcontent1	=	$mcont.$pdt1["Cmspage"]["content"];

						$mailcontent1 = str_replace("[ORDER_DETAILS]", $content, $mailcontent1);

						$mailcontent1 = str_replace("[User_Name]", $odr['User']['uname'], $mailcontent1);

						$mailcontent1 = str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent1);		

						$mailsent1 		= mail($cnfg["admin_email"],$subject,$mailcontent1,$headers);	
						

			###################################

			 

				 ################################### Sending Fax to Admin ###################################

						$cnfg=Configure::read('Neutrino');

						$fax_allow	=	$cnfg["allow_fax"];

						if($fax_allow=='Y')

						{

		               		$fax_email	=	$cnfg["fax_email"]; 

							$fax_number	=	$cnfg["fax_number"]; 

							$fax_content=$content;	

							$fax_content = str_replace("[User_Name]", $odr['User']['uname'], $fax_content);

							$fax_content = str_replace("[SITE_NAME]", $cnfg["site_name"], $fax_content);					

							$this->_sendFax($fax_email,$fax_number,$fax_content,1);

						}						

				 ################################### Sending Fax Ends here ###################################

				 

			$this->Session->setFlash('Your Quote has been successfully placed for approval from site administrator and an e-mail with order details has sent to your e-mail ID!', 'default',array('class'=> 'success'));
        	$this->redirect('/users/myaccount');

		  	exit;
	

		  
		/*************** Section for Placing Order without payment Ends**********************************************/
		/************** Added By Jipson Thomas on 3rdJanuary 2011**********************************************/
		
	}

	function delcart($uid){

		$this->Cart->deleteAll("Cart.user_id = ".$uid, $cascade = true);

		return true;

	}

	function CheckValue($Array)

	{

		foreach($Array as $key=>$val)

		{

			if($key=='mailservice')

			{

				return ($val);

			}//end if

		}//end foreach

	}//end funciton

	

	function CheckValuePrice($Array)

	{

		foreach($Array as $key=>$val)

		{

			if($key=='rate')

			{

				return ($val);

			}//end if

		}//end foreach

	}//end funciton

	

	

	

	##################### Ajax Functions for validate Giftcard starts here #####################

	function cleargiftsession()

	{

	  $this->layout = null; 

	  $this->Session->delete('Giftcard');

	}	

	##################### Ajax Function for validate Giftcard ens here#####################
	
	//------------------------------------admin add to cart------------------------------------------//
	function adminadd($custid = '')
	 {
		//---------------------------------------------------------------------------//
		$details = $this->Cart->findparents($custid);
		$pid = $details['product_id'];
		$cid = $details['category_id'];
		$optid = $details['id'];
		//---------------------------------------------------------------------------//
		$sus			=	$this->Session->read('tempUser'); 
		$this->set('sus', $sus);
		$dat["user_id"]		=	0;
		if(!$sus)
		{
			$dat["user_id"]		=	$sus;
		}
		$sessid	=	$this->Session->id();
		if($optid <>'' && $optid <> 0)
		{		
		  $chk	=	$this->Cart->find("product_id=".$pid." AND user_id=".$dat["user_id"]." AND option_id = '".$optid."' AND sess_id='".$sessid."' AND savedimages_id = $custid AND type='P'");
		}

		if(!empty($chk["Cart"]))
		{
			$this->Session->setFlash('This customization has already been added to your cart, you can update the quantity in the cart.', 'default',array('class'=> 'failure'));
			$this->redirect(array('controller' => 'carts','action'=>'adminshow'));
			exit;
		}

		else
		{
			$dat["sess_id"]			=	$this->Session->id();
			$dat["product_id"]		=	$pid;
			$pdet		            =	$this->Product->findById($pid);			
	
			 $dat["product_price"]	=	$pdet["Product"]["price"];
			 
			 //----------------Get the customization cost---------------------//
			 $addnCost = $this->calculateAmt($custid);
			 
			 //------------------Apply the customization cost--------------------//
			 $dat["extra_price"]	= $addnCost;

			$dat["discount_type"]	 =	$pdet["Product"]["discount_type"];

			$dat["discount"]	    =	$pdet["Product"]["discount"];

			$dat["shipping_charge"]	=	$pdet["Product"]["shipping_price"];

			$dat["quantity"]		=	1;

			$dat["prodtype"]		=	$pdet["Product"]["prodtype"];

			$dat["type"]		    =	'P';

			$dat["savedimages_id"]		=	$custid;

			if($optid<>'' && $optid<>0) 

			{

				$dat["option_id"]=	$optid;

				$pcmdet=$this->Productdetail->findById($dat["option_id"]);

				$dat["extra_price"] += $pcmdet["Productdetail"]["extraprice"];

		   }

			else

			$optid='';

			$tpflag					=	true;

			$citem					=	$this->Cart->findAllByUserId($dat["user_id"]);

					/*if(!empty($citem))
					{
						foreach($citem as $it)
						{
							if($it["Cart"]["prodtype"] <> $dat["prodtype"]){

								$tpflag					=	false;

							}
						}
					}*/

					if($tpflag <> true)
					{
						$this->Session->setFlash('Sorry, digital and non-digital products can\'t buy together!', 'default',array('class'=> 'failure'));
					}

					else
					{

						if($pdet["Product"]["stock"] < $dat["quantity"])
						{
							$this->Session->setFlash('Sorry,There is not enough stock available for the product you requested!', 'default',array('class'=> 'failure'));
						}else
						{

							$this->Cart->save($dat);

						}
					}		

			//$this->redirect('/carts/show');
			$this->redirect(array('controller' => 'carts','action'=>'adminshow'));

			exit;

		}		

	} 
	
	function adminshow(){

		$sus			=	$this->Session->read('tempUser'); 

		$this->set('sus', $sus);

		if($this->Session->check('Coupon') == true){

			$coup	=	$this->Session->read('Coupon');

			$this->set('couparray', $coup);

		}		

	   if($this->Session->check('tempUser') === true){

			$userid=$sus;

			$sessid	=	$this->Session->id();

			$cupdate	=	$this->Cart->updatesessuser($sessid,$userid);
			
			$citem1	=	$this->Cart->findAllByUserId($userid);				
			//$maxid = $this->Cart->findAllByUserId($userid);		
			
			//Finding the product type of the lastly added product type and deleting the product with the other types
			$cart_tbl=$this->Cart->getTableName('carts');
			$max_rowid= $this->Cart->find('first', array(
				  'fields' => 'MAX(Cart.id) as maxid',
				  'conditions' => array('Cart.user_id ' => $userid)
			   ));
			 
			 $last_prodtype='Non-Digital';
			 if(isset($max_rowid[0]["maxid"]) && $max_rowid[0]["maxid"] <> 0)
			 {
			    $last_ptype=$this->Cart->findById($max_rowid[0]["maxid"]); 	
				if(isset($last_ptype) && empty($last_ptype)===false)
				{
				   $last_prodtype=trim($last_ptype["Cart"]["prodtype"]);
				}  
			 }
			 
			 $del_parray=array();
			 $citem2	=	$this->Cart->find('all', array('conditions' => array('user_id' => $userid)));		
             foreach($citem2 as $cvals2)
			 {
			    $ptype=$cvals2['Cart']['prodtype'];	
				if(trim($last_prodtype) <> trim($ptype))
				$del_parray[] = $cvals2['Cart']['id'];				
			 }			
			 if(isset($del_parray) && empty($del_parray)===false)
			 {
			  $this->Cart->query("delete FROM $cart_tbl where id IN (".implode(',',$del_parray).")");
			 }  	
			//Finding the product type of the lastly added product 
			
			$del_array=array();
			$chk_array=array();			
			foreach($citem1 as $cvals1)
			{
			   $chk_rowid=$cvals1['Cart']['id'];			
			   $chk_prodid=$cvals1['Cart']['product_id'];
			   $chk_userid=$cvals1['Cart']['user_id'];
			   $chk_optid=$cvals1['Cart']['option_id'];	
			   $chk_type=$cvals1['Cart']['type'];		   
			
			   $chk_str=$chk_prodid.'-'.$chk_optid.'-'.$chk_type;
			  
			   
			   if(in_array($chk_str,$chk_array))
			   {			   
			     $upid=explode('-',$chk_str);				
				 $upqty=$cvals1['Cart']['quantity'];
				 $this->Cart->query("update $cart_tbl set quantity=(quantity +".$upqty.") where id='".$upid[0]."'");				
				 $del_array[]=$chk_rowid;
			   }			
			   $chk_array[]=$chk_str;
			}
			if(isset($del_array) && empty($del_array)===false)
			{
			  //------------------------commented by aswin------------------------------//
			  //$this->Cart->query("delete FROM $cart_tbl where id IN (".implode(',',$del_array).")");
			}  			
			

			//$citem	=	$this->Cart->findAllByUserId($userid);

			$citem	=	$this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','user_id' => $userid)));		

			$gitem	=	$this->Cart->find('all', array('conditions' => array('Cart.type' => 'G','user_id' => $userid)));		



		}

		else{

		    $sessid	=	$this->Session->id();

			//$citem	=	$this->Cart->findAllBySessId($sessid);		

			$citem	=	$this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','sess_id' => $sessid)));	

			$gitem	=	$this->Cart->find('all', array('conditions' => array('Cart.type' => 'G','sess_id' => $sessid)));					

		}  

				

				

	//Code to get the cart item along with the combination values of products if any starts here...			        

		for($i=0;$i<count($citem);$i++)

		{		

				  if($citem[$i]["Cart"]["option_id"]<>0 && $citem[$i]["Cart"]["option_id"]<>'')

				  {

					$pcombndet	=	$this->Productdetail->findAllById($citem[$i]["Cart"]["option_id"]);				

					$pcmbnid=explode(',',$pcombndet[0]["Productdetail"]["customvalue_id"]);

						 foreach($pcmbnid as $key => $val)

						 {

						   if($val!='')

						   {				 

							 $combnstr[]=$this->Product->getpdctcmbn($val);

							 $combinations=implode(" ,",$combnstr);

							 $citem[$i]["Cart"]["combn_values"]= $combinations;			

							}

						 }					 								 

				  }

		     unset($combnstr);unset($combinations);		

		}

		
		//Setting the combination flag
		 $cmbtype_flag='no';
		 if(count($citem)>0)
            {       
		        foreach($citem as $itm)
				{ 				  
				   if($itm["Product"]["combination"] <> '')
				   $cmbtype_flag='yes';
				}
			}	
		$this->set('cmbtype_flag', $cmbtype_flag);

		

		

		$this->set('itemlist', $citem);	

		 //Code to get the cart item along with the combination values of products if any starts here...	

		$gftbl=$this->Cart->getTableName("giftcards");

		if(isset($gitem) && empty($gitem)===false)

		{		        

			for($i=0;$i<count($gitem);$i++)

			{	

			  $gdet=$this->Giftcard->query("select gift_code,stock from ".$gftbl." where id='".$gitem[$i]["Cart"]["product_id"]."'");

			  $gitem[$i]["Cart"]["gift_code"]=$gdet[0][$gftbl]["gift_code"];		

			  $gitem[$i]["Product"]["stock"]=$gdet[0][$gftbl]["stock"];				

			} 

			$this->set('giftcard', $gitem);		

		}	

		//Code to get the cart item along with the combination values of products if any ends here...		



		global $currency;

		$curr		=	$this->Currency->findByCode($currency);

		$this->set('curlogo',$curr["Currency"]["logo"]);
		$this->layout = 'adm';

	}
	
	function adminupdate(){
				if(isset($_POST["code"]) && trim($_POST["code"]) <> '')
				{
					$coup	=	$this->Coupon->findByCode($_POST["code"]);
					if(isset($coup)&& !empty($coup))
					{
						$this->Session->write('Coupon', $coup);
					}else{
						$this->Session->setFlash('Sorry,Invalid coupon code!', 'default',array('class'=> 'failure'));	
					}
				}

		for($i=0;$i < sizeof($_POST["id"]);$i++)
		{			
			if($_POST["ptype"][$i] <> 'G')
			{

						$cdet					=	$this->Cart->findById($_POST["id"][$i]);
						$pid					=	$cdet["Cart"]["product_id"];
						$pdet					=	$this->Product->findById($pid);

						#################(Added by Shyam) #################

						if($pdet["Product"]["combination"]=='Y')
						{
						  $stockcnt = $this->Productdetail->findById($_POST["optionid"][$i]); 

						  if($stockcnt["Productdetail"]["stock"] < $_POST["qty"][$i])
						   {
							$this->Session->setFlash('Sorry,The stock is not enough for the product you requested!', 'default',array('class'=> 'failure'));	
						   }
						   else
						   {

							$this->Cart->update($_POST["id"][$i],$_POST["qty"][$i]);

						   }			

						}

						else 
						if($pdet["Product"]["combination"]=='' || $pdet["Product"]["combination"]=='N')
						{

							if($pdet["Product"]["stock"] < $_POST["qty"][$i])
							{
								$this->Session->setFlash('Sorry,The stock is not enough for the product you requested!', 'default',array('class'=> 'failure'));	
							}

							else
						   {
							$this->Cart->update($_POST["id"][$i],$_POST["qty"][$i]);
						   }		
					   }

		   }

		   else if($_POST["ptype"][$i] == 'G')
		   {

		     $this->Cart->update($_POST["id"][$i],$_POST["qty"][$i]);		   

		   }

		   #################(Added by Shyam) #################				

		}

		$this->redirect('/carts/adminshow');

		exit;

	}
	
	
	//------------------------------------------------Admin checkout------------------------------------------------//
	function admin_checkout(){

		$this->layout = 'adm';
		
        $this->__validateLoginStatus('A');

		$sus			=	$this->Session->read('tempUser');		

		$this->set('sus', $sus);

		$cnfg 		= Configure::read('Neutrino'); 

     	$user_id		=	$sus;



 //Saving the Billing and shipping addresses starts here



	if($_SERVER['REQUEST_METHOD']=='POST'){		

			$ptype='Non-Digital';

			$bill["email"]		=	$_POST["bemail"];

			$bill["fname"]		=	$_POST["bfname"];

			$bill["lname"]		=	$_POST["blname"];

			$bill["address"]	=	$_POST["baddress"];			

			$bill["state"]		=	$_POST["bstate"];

			$bill["country"]	=	$_POST["data"]["bcountry"];			

			if($_POST["data"]["bcountry"] == 'US')	{

			  $bill["state"] = $_POST["us_bstate"];	}  

			else {

			  $bill["state"]		=	$_POST["bstate"];

			  unset($_POST["us_bstate"]);	} 			

            $bill["city"]		=	$_POST["bcity"];

			$bill["zip"]		=	$_POST["bzip"];

			$bill["phone"]		=	$_POST["bphone"];

			$bill["fax"]		=	$_POST["bfax"];

			$bill["mobile"]		=	$_POST["bmobile"];

			$bill["user_id"]	=	$user_id;

			$bill["addr_type"]	=	"Billing";

			$this->UserAddress->deleteAll("UserAddress.user_id = ".$user_id." AND UserAddress.addr_type = 'Billing'");

			$this->UserAddress->create($data = array());

			$data				=	$bill;

			$this->UserAddress->save($data);

			

			if($ptype <> 'Digital') 

				{

						$ship["fname"]		=	$_POST["sfname"];		

						$ship["lname"]		=	$_POST["slname"];		

						$ship["address"]	=	$_POST["saddress"];					

						$ship["country"]	=	$_POST["data"]["scountry"];					

						if($_POST["data"]["scountry"] == 'US')	{

						  $ship["state"] = $_POST["us_sstate"];

						}  

						else {

						  $ship["state"]		=	$_POST["sstate"];

						  unset($_POST["us_sstate"]);	} 		

						$ship["city"]		=	$_POST["scity"];					

						$ship["zip"]		=	$_POST["szip"];		

						$ship["phone"]		=	$_POST["sphone"];		

						$ship["fax"]		=	$_POST["sfax"];		

						$ship["mobile"]		=	$_POST["smobile"];		

						$ship["user_id"]	=	$user_id;		

						$ship["addr_type"]	=	"Shipping";		

						$this->UserAddress->deleteAll("UserAddress.user_id = ".$user_id." AND UserAddress.addr_type = 'Shipping'");		

						$this->UserAddress->create($data = array());

						$data				=	$ship;		

						$this->UserAddress->save($data);			

				}	

				else

				 {

				   $this->redirect('/carts/adminpayment/');

				   exit; 

				  }

		}

 //Saving the Billing and shipping addresses ends here		



		//Code Added By shyam for Category Menu Listing starts here..

		 $lst	=	$this->Category->findAll();			 

		 foreach($lst as $det)

		 $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"]);

		 $this->set('menu_array', $menu_array);		

		//Code Added By shyam for Category Menu Listing ends here..

        //Code Added By shyam for Category Menu Listing ends here..

        $shipmeth='';        

        if(isset($_POST["shipmeth"]) && $_POST["shipmeth"] <> '') {

		$shipmeth	=	str_replace("%20"," ",$_POST["shipmeth"]); }

		$shipadd	=	$this->UserAddress->find("UserAddress.user_id =".$user_id." AND UserAddress.addr_type ='Shipping'");

		$cntdet		=	$this->Country->findByCountryIsoCode_2($shipadd["UserAddress"]["country"]);

		//print_r($cntdet);exit;

		

		$shipadd["UserAddress"]["country_name"]	=	$cntdet["Country"]["country_name"];

		$citem			=	$this->Cart->findAllByUserId($user_id);

		$shipweight		=	0;

		$shipchrge		=	0;

		$shipchrgeadd	=	0;

		$qty			=	0;

        $shipflag       =   'yes';

		$prodtype 		= 	"Non-Digital";

		foreach($citem as $item){

			$shipweight	+= $item["Product"]["weight"] * $item["Cart"]["quantity"];

			$shipchrge	+= $item["Cart"]["shipping_charge"] * $item["Cart"]["quantity"];

			$qty		=	$qty + $item["Cart"]["quantity"];

			if($item["Product"]["prodtype"] == "Digital"){

				$prodtype = 	"Digital";

			}

		}

		

		

		if($prodtype =="Digital")

		{		

		    $this->redirect('/carts/adminpayment/');

		    exit;		

		}

		

		

		if($qty > 0 && $prodtype !="Digital"){

			$shipchrge		=	$cnfg["flat_shipping_first"];

			$shipchrgeadd	=	$cnfg["flat_shipping_additional"] * ($qty - 1);

			$shipchrge		=	$shipchrge + $shipchrgeadd;

		}else{

			$shipchrge		=	0;

		}



		$bxno	=	1;

		$shipweight2	=	$shipweight/$bxno;

		while($shipweight2 > 149){

			$bxno++;

			$shipweight2	=	$shipweight/$bxno;

		}

		//echo $shipweight2."<br>".$bxno; exit;

		if($shipweight2	==	0)

			$shipweight2	=	0.1;

		$module_shipping_ups_types	=	'1DM, 1DML, 1DA, 1DAL, 1DAPI, 1DP, 1DPL, 2DM, 2DML, 2DA, 2DAL, 3DS, GND, STD, XPR, XPRL, XDM, XDML, XPD';

		$origin_country				=	$cnfg["shipping_origin_country"];

		$origin_postal				=	$cnfg["shipping_origin_zip"];

		$destination_country		=	$shipadd["UserAddress"]["country"];

		$destination_postal			=	$shipadd["UserAddress"]["zip"];

		if($destination_country == 'CA')

		{

		  $prod = 'STD';

		 

		}

		else

		{

		  $prod = 'GNDRES';

		}

		$this->set('shipadd', $shipadd);

			

		if($shipmeth == 'UPS'){

			$ups_action_code = '4';

			$text_shipping_weight = '&nbsp;lbs';

			############# These parts has to make dynamic from dbtable###################3333

			$rate_chart 					=	'Letter+Center';//$shipping_settings_row['vvalue'];

			$container_code 				=	'00' ;//$shipping_settings_row['vvalue'];

			$res_code 						= 	'1';//$shipping_settings_row['vvalue'];

			$shipping_box_weight_display 	=	'3'; //$shipping_settings_row['vvalue'];

			$shipping_num_boxes 			=	$bxno;//$shipping_settings_row['vvalue'];

			$module_shipping_handling		=	'';

			####################################################################################

			$shipopt	=	$this->Upsshipping->passValues($module_shipping_handling,$shipping_num_boxes,$shipping_box_weight_display,$res_code,$container_code,$rate_chart,$ups_action_code,$text_shipping_weight,$prod,$shipweight2,$origin_country,$origin_postal,$destination_country,$destination_postal,$module_shipping_ups_types);

			//$this->set('pshipchrg',$shipchrge);

		   //$this->set('shipopt', $shipopt);

             if(isset($shipopt) && empty($shipopt) === false)  {                  

             $this->set('shipopt', $shipopt); $this->set('shipflag','yes'); }

			 else    

            {

               $this->__setFlateRate($qty) ; 

			   $this->set('shipflag','no');

			}    

			

		}elseif($shipmeth == 'USPS'){

		
			$this->Usps->setServer("http://testing.shippingapis.com/ShippingAPITest.dll");

			$this->Usps->setUserName($cnfg["USPS_Username"]);
                        
			$this->Usps->setService("All");

			#$this->Usps->setDestZip("20008");

			#$usps->setOrigZip("10022");

			$this->Usps->setDestZip($destination_postal);

			$this->Usps->setOrigZip($origin_postal);

			############# These parts has to make dynamic from dbtable###################3333

			

			//$Weight = $shipweight;

			//$this->Usps->setWeight($Weight , 0);

			$this->Usps->setWeight(10, 5);

			$this->Usps->setContainer("Flat Rate Box");

			//$this->Usps->setCountry($destination_country);

			$this->Usps->setCountry('USA');

			$this->Usps->setMachinable("true");

			$this->Usps->setSize("LARGE");

			$price = $this->Usps->getPrice();

			$MailArray=array();

			if($price){

				foreach ($price as $key=>$value)

				{

					if($key=='list')

					{	

						for($it=0;$it<count($value);$it++)

						{

							$MailArray[$it]['title']	=	$this->CheckValue($value[$it]);

							$MailArray[$it]['cost']=	$this->CheckValuePrice($value[$it]);

						}//end for loop

					}//end if

				}//end foreach

			}

		//	$this->set('shipopt', $MailArray);

             if(isset($MailArray) && empty($MailArray) === false)  {                  

             $this->set('shipopt', $MailArray); $this->set('shipflag','yes');}

			 else    

            {

               $this->__setFlateRate($qty) ; 

			    $this->set('shipflag','no');

			}    





		}elseif($shipmeth == 'Australiapost'){

		################## Portion for USPS Shipping Starts.........................................

		################## Portion for Australiapost Shipping.......................................

		

			$Pickup_Postcode 		= $origin_postal;

			$Destination_Postcode 	= $destination_postal;

			$Country 				= $destination_country;

			$Weight 				= $shipweight;

			$Service_Type			= "STANDARD";

			$Length					= "100";

			$Width					= "100";

			$Height					= "40";

			$Quantity 				= "1";

			

			$this->Australiapost->set_Pickup_Postcode($Pickup_Postcode);

			$this->Australiapost->set_Destination_Postcode($Destination_Postcode);

			$this->Australiapost->set_Country($Country);

			$this->Australiapost->set_Weight($Weight);

			$this->Australiapost->set_Service_Type($Service_Type);

			$this->Australiapost->set_Length($Length);

			$this->Australiapost->set_Width($Width);

			$this->Australiapost->set_Height($Height);

			$this->Australiapost->set_Quantity($Quantity);

			$auspost	=	$this->Australiapost->getRate();

			//$this->set('shipopt', $auspost);



             if(isset($auspost) && empty($auspost) === false)  {                  

             $this->set('shipopt', $auspost); $this->set('shipflag','yes');}

			 else    

            {

               $this->__setFlateRate($qty) ; 

			    $this->set('shipflag','no');

			}    

	

		}elseif($shipmeth == 'Canadapost'){

		################## Portion for Ausrtaliapost Shipping.......................................

		################## Portion for Canadapost Shipping Starts...................................

				$this->Canadapost->setval($cnfg["canadamerchantid"],$cnfg["shipping_origin_zip"]);

			$this->Canadapost->setCustomer( array( 

					'city' => $shipadd["UserAddress"]["city"],

					'provOrState' => $shipadd["UserAddress"]["state"],

					'country' =>$shipadd["UserAddress"]["country"],

					'postalCode' => $shipadd["UserAddress"]["zip"]

				 ) 

			);

			 

			$this->Canadapost->addProduct ( array (

					'quantity' =>'1',

					'weight' => $shipweight,

					'length' => '1',

					'width' => '1',

					'height' => '1',

					'description' => ' '

				)

			); 

			 

			$assoc_Array = $this->Canadapost->getRates('array');

			if(!empty($assoc_Array["product"])){

				$i	=	0;

				foreach($assoc_Array["product"] as $sv){

					$capost[$i]["title"]	=	$sv["name"];

					$capost[$i]["cost"]		=	$sv["rate"];

					$i++;

				}

			}

		//	if(isset($capost) && empty($capost)===false)

		//	$this->set('shipopt', $capost);

              if(isset($capost) && empty($capost) === false)  {                  

             $this->set('shipopt', $capost); $this->set('shipflag','yes');}

			 else    

            {

                $this->__setFlateRate($qty) ; 

			    $this->set('shipflag','no');

			}    



		}elseif($shipmeth == 'FEDEX'){

		//print_r($capost);exit;

		################## Portion for Canadapost Shipping..........................................


			/*if($shipadd["UserAddress"]["country"]=="United States" || $shipadd["UserAddress"]["country"]=="US" )

			{			

			$fedexService['PRIORITYOVERNIGHT']     = 'FedEx Priority Overnight';

			$fedexService['STANDARDOVERNIGHT']     = 'FedEx Standard Overnight';

			$fedexService['FIRSTOVERNIGHT']        = 'FedEx First Overnight';

			$fedexService['FEDEX2DAY']             = 'FedEx 2 Day';

			$fedexService['FEDEXEXPRESSSAVER']     = 'FedEx Express Saver';

			$fedexService['FEDEX1DAYFREIGHT']      = 'FedEx Overnight Freight';

			$fedexService['FEDEX2DAYFREIGHT']      = 'FedEx 2 day Freight';

			$fedexService['FEDEX3DAYFREIGHT']      = 'FedEx 3 day Freight';

			$fedexService['FEDEXGROUND']           = 'FedEx Ground';

			$fedexService['GROUNDHOMEDELIVERY']    = 'FedEx Home Delivery';

			} else{

			$fedexService['INTERNATIONALPRIORITY'] = 'FedEx International Priority';

			$fedexService['INTERNATIONALECONOMY']  = 'FedEx International Economy';

			$fedexService['INTERNATIONALFIRST']    = 'FedEx International First';

			}


			$fedexaccno	=	trim($cnfg["fedexbillaccno"]);

			$fedexmeterno	=	trim($cnfg["fedexmeterno"]);

			$weightunits='LBS';

			$server='test';

			$dropoff='REGULARPICKUP';

			$packageTypes='YOURPACKAGING';

			$currency='USD';

			switch($server)

					{

						case "test":

						$fedexserver="https://gatewaybeta.fedex.com/GatewayDC";

						break;

						case "production":

						// change this to actual server when go on live 

						$fedexserver="https://gatewaybeta.fedex.com/GatewayDC";

						break;

						default:

						$fedexserver="https://gatewaybeta.fedex.com/GatewayDC";

						break;

					}	 // end switch 

					

		    $jt=0;

		    foreach($fedexService as $service => $serviceName)

			{

								

								set_time_limit(0);								

								$this->Fedex->setServer($fedexserver);

								$this->Fedex->setAccountNumber($fedexaccno); //Get your own - this will not work...

								$this->Fedex->setMeterNumber($fedexmeterno);    //Get your own - this will not work...								

								$this->Fedex->setCarrierCode('FDXE'); //Arguement recived from the JS Function.

								$this->Fedex->setDropoffType($dropoff);

								$this->Fedex->setService($service, $serviceName);

								$this->Fedex->setPackaging($packageTypes);

								$this->Fedex->setWeightUnits($weightunits);

								$this->Fedex->setWeight($shipweight);

								$this->Fedex->setOriginStateOrProvinceCode($cnfg["shipping_origin_state"]); 

								$this->Fedex->setOriginPostalCode($cnfg["shipping_origin_zip"]);

								$this->Fedex->setOriginCountryCode($cnfg["shipping_origin_country"]);
								

								$this->Fedex->setDestStateOrProvinceCode($shipadd["UserAddress"]["state"]); //Arguement recived from the JS Function.

								$this->Fedex->setDestPostalCode($shipadd["UserAddress"]["zip"]); //Arguement recived from the JS Function.

								$this->Fedex->setDestCountryCode($shipadd["UserAddress"]["country"]); //Arguement recived from the JS Function.

								

								

								$this->Fedex->setPayorType("SENDER");

								$fedexprice = $this->Fedex->getPrice();								//print_r($fedexprice);

								if(!empty($fedexprice))
								{ 

									   foreach($fedexprice as $key => $val){
										   if($val['code'] <> 'ERROR'){
											   $fed[$jt]["title"]		=	$val['service']; 
		
											   $fed[$jt]["cost"]		=	$val['rate'];			
		
											   $jt++;	
										   }
									   }	                 				

								} 

							} // end of if stmt

		

		

            if(isset($fed) && empty($fed) === false)  {                  

             $this->set('shipopt', $fed); $this->set('shipflag','yes');}

			 else    

            {

               $this->__setFlateRate($qty) ; 
               $shipmeth ='Flat Rate Shipping';
			   $this->set('shipflag','no');

			}       

		################## Portion for Fedex Shipping..........................................

		}*/
                    /************************************/
                    
                 if ($shipadd["UserAddress"]["country"] == "United States" || $shipadd["UserAddress"]["country"] == "US") {

                $fedexService['PRIORITYOVERNIGHT'] = 'FedEx Priority Overnight';

                $fedexService['STANDARDOVERNIGHT'] = 'FedEx Standard Overnight';

                $fedexService['FIRSTOVERNIGHT'] = 'FedEx First Overnight';

                $fedexService['FEDEX2DAY'] = 'FedEx 2 Day';

                $fedexService['FEDEXEXPRESSSAVER'] = 'FedEx Express Saver';

                $fedexService['FEDEX1DAYFREIGHT'] = 'FedEx Overnight Freight';

                $fedexService['FEDEX2DAYFREIGHT'] = 'FedEx 2 day Freight';

                $fedexService['FEDEX3DAYFREIGHT'] = 'FedEx 3 day Freight';

                $fedexService['FEDEXGROUND'] = 'FedEx Ground';

                $fedexService['GROUNDHOMEDELIVERY'] = 'FedEx Home Delivery';
            } else {

                $fedexService['INTERNATIONALPRIORITY'] = 'FedEx International Priority';

                $fedexService['INTERNATIONALECONOMY'] = 'FedEx International Economy';

                $fedexService['INTERNATIONALFIRST'] = 'FedEx International First';
            }





            /*

              $fedexaccno='510088000';

              $fedexmeterno='100022250';

            */

            $fedexaccno = trim($cnfg["fedexbillaccno"]);

            $fedexmeterno = trim($cnfg["fedexmeterno"]);

            $weightunits = 'LBS';

            $server = 'test';

            $dropoff = 'REGULARPICKUP';

            $packageTypes = 'YOURPACKAGING';

            $currency = 'USD';

            switch ($server) {

                case "test":

                    $fedexserver = "https://gatewaybeta.fedex.com/GatewayDC";

                    break;

                case "production":

                // change this to actual server when go on live

                    $fedexserver = "https://gatewaybeta.fedex.com/GatewayDC";

                    break;

                default:

                    $fedexserver = "https://gatewaybeta.fedex.com/GatewayDC";

                    break;
            }  // end switch



            $jt = 0;

            foreach ($fedexService as $service => $serviceName) {



                set_time_limit(0);

                $this->Fedex->setServer($fedexserver);

                $this->Fedex->setAccountNumber($fedexaccno); //Get your own - this will not work...

                $this->Fedex->setMeterNumber($fedexmeterno);    //Get your own - this will not work...

                $this->Fedex->setCarrierCode('FDXE'); //Arguement recived from the JS Function.

                $this->Fedex->setDropoffType($dropoff);

                $this->Fedex->setService($service, $serviceName);

                $this->Fedex->setPackaging($packageTypes);

                $this->Fedex->setWeightUnits($weightunits);

                $this->Fedex->setWeight($shipweight);








                /*
                  $this->Fedex->setOriginStateOrProvinceCode('AL');

                  $this->Fedex->setOriginPostalCode('35005');

                  $this->Fedex->setOriginCountryCode('US');

                  $this->Fedex->setDestStateOrProvinceCode('AL'); //Arguement recived from the JS Function.

                  $this->Fedex->setDestPostalCode('35060'); //Arguement recived from the JS Function.

                  $this->Fedex->setDestCountryCode('US'); //Arguement recived from the JS Function.

                  echo '<br>'.$shipadd["UserAddress"]["state"];
                  echo '<br>'.$shipadd["UserAddress"]["zip"];
                  echo '<br>'.$shipadd["UserAddress"]["country"];

                  exit();
                */


                $this->Fedex->setOriginStateOrProvinceCode($cnfg["shipping_origin_state"]);

                $this->Fedex->setOriginPostalCode($cnfg["shipping_origin_zip"]);

                $this->Fedex->setOriginCountryCode($cnfg["shipping_origin_country"]);


                $this->Fedex->setDestStateOrProvinceCode($shipadd["UserAddress"]["state"]); //Arguement recived from the JS Function.

                $this->Fedex->setDestPostalCode($shipadd["UserAddress"]["zip"]); //Arguement recived from the JS Function.

                $this->Fedex->setDestCountryCode($shipadd["UserAddress"]["country"]); //Arguement recived from the JS Function.





                $this->Fedex->setPayorType("SENDER");

                $fedexprice = $this->Fedex->getPrice();

                if (empty($fedexprice->error->description) && !empty($fedexprice->price->rate)) {

                    $fed[$jt]["title"] = $fedexprice->serviceName;

                    $fed[$jt]["cost"] = $fedexprice->price->rate;

                    $jt++;
                }
            } // end of if stmt





            if (isset($fed) && empty($fed) === false) {

                $this->set('shipopt', $fed);
                $this->set('shipflag', 'yes');
            } else {

                $this->__setFlateRate($qty);
                $shipmeth = 'Flat Rate Shipping';
                $this->set('shipflag', 'no');
            }
            
            }
                    /**********************************/
                    else

		{

			######@@@@@@@@@@@@@@@ Section for Flat rate shippings;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

			$shipme	=	$this->Setting->findByValue($shipmeth);

		    $this->__getFlateRate($shipmeth,$qty);     

            $this->set('shipflag','yes');

			######@@@@@@@@@@@@@@@ Section for Flat rate shippings;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		}

		



		$citem			=	$this->Cart->findAllByUserId($user_id);

		$this->set('prodtype', "Non-digital");

		if(!empty($citem)){

			foreach($citem as $it){

				if($it["Product"]["prodtype"] == "Digital"){

					$this->set('prodtype', "Digital");

				}

			}

		}

		$this->set('shippingmethod', $shipmeth);
	}
        
        /***********************/
        function sendMailReorderAlert($prd_id) {
        $cnfg = Configure::read('Neutrino');

        $combnstr = array();
        $combinations = array();
       
         $prod1 = $this->Productdetail->findById($prd_id);
               
            $product_details = $this->Product->findById($prod1['Productdetail']['product_id']);    
          
              
               if($prod1){ 
                  $pcmbnids=$prod1["Productdetail"]["customvalue_id"];

                  $pcmbnid=explode(',',$pcmbnids);

                    foreach($pcmbnid as $key => $val) {

                       if($val!='') { 
                           $combnstr[]=$this->Product->getpdctcmbn($val);
          
                           $combinations=implode(", ",$combnstr);
                           
                           
                           $combinationanme = $combinations;
                        }else{
                            $combinationanme = '';
                        }

                    }

                  
               }
                
                
      //  echo "<pre>";print_r($pcombndet); exit;        
                
        $prd_name = $product_details['Product']['pname'].' '.$combinationanme;

        //$pdt1 = $this->Cmspage->findByTitle('Admin order confirm mail');
        $headers 		= "MIME-Version: 1.0\r\n";         
        $headers .= "From: " . $cnfg["site_name"] . "<" . $cnfg["admin_email"] . ">\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=iso-8859-1\r\n";

    

                $path			=	"SiteLogo_disp.gif";

                $mcont			=	"<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>

		  		<tr><td><a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'><img src='".FULL_BASE_URL. $cnfg["sitebasefolder"]."/app/webroot/".IMAGES_URL.$path."' border='0' width='300' ></a></td></tr></table>";

                $logurl		= "Click <a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."/users/login' target='_blank'>here </a>to login";

                $mailcontent1	=	$mcont;
        
        
        $mailcontent1 .= "<p>&nbsp;</p>
                         <p>Dear Administrator,</p>
                         <p>&nbsp;&nbsp;&nbsp;&nbsp; The stocks for <strong>" . $prd_name . " </strong>is running low.</p><br>
                          Thanks<br> 
                          Printlogic Site";


        mail($cnfg["admin_email"], 'Product Stock Alert - ' . $cnfg["site_name"], $mailcontent1, $headers);

        //Configure::write('debug', 0);
        //$this->autoRender = false;
    }
        /**********************/
	
	function adminpayment(){
		
		
		
	    $ship="";

		$cnfg 	= 	Configure::read('Neutrino');		

		$this->set('cnfg', $cnfg);

        if($this->Session->check('SESS_SHIPMENT'))

		{

			$this->Session->delete('SESS_SHIPMENT');

		}

		$this->__validateLoginStatus('A');

		$sus			=	$this->Session->read('tempUser');		

		$this->set('sus', $sus);

		$user_id	=	$sus;

		$cnfg 					= 	Configure::read('Neutrino'); 

		$curr		=	$this->Currency->findByCode($cnfg["currency"]);

		$this->set('curlogo',$curr["Currency"]["logo"]);

		//Code Added By shyam for Category Menu Listing starts here..

		 $lst	=	$this->Category->findAll();			 

		 foreach($lst as $det)

		 $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"]);

		 $this->set('menu_array', $menu_array);		

		//Code Added By shyam for Category Menu Listing ends here..

		

		if(isset($_POST["ship_method"]))

		{

			$ship				=	$_POST["ship_method"];			

			if($ship <> ''){

				$shipp				=	explode('|~@~|',$ship);

				$shippingMethod		=	$shipp[0];

				$shippingServ		=	$shipp[1];

				$shipping_cost		=	$shipp[2];

                $this->Session->write('SESS_SHIPMENT',$ship);

			}

			else

			{

			    $ship	            =   '';

				$shippingMethod		=	'';

				$shippingServ		=	'';

				$shipping_cost		=	0;

		   }					

		}

		else

		{

		        $ship	            =   '';

				$shippingMethod		=	'';

				$shippingServ		=	'';

				$shipping_cost		=	0;

                $this->Session->write('SESS_SHIPMENT',$ship);				

		}

		

   ########################## Getting total price from cart ******************************************

		$citem		=	$this->Cart->findAllByUserId($user_id);
		
		if(count($citem	) < 1)
		{
		 $this->redirect(array('controller' => 'pages', 'action' => 'display')); 
		 exit();
		}

		$tot_price	=	0;

		$final_price = 0;
		
		//Getting the product type in the cart
		$prod_type = 	"Non-Digital";
			if(!empty($citem)){
				foreach($citem as $it){
					if(trim($it["Cart"]["prodtype"]) == "Digital"){
						$prod_type = 	"Digital";
					}
				}
			}
        //Getting the product type in the cart
		
		
		foreach($citem as $item)

		   { 		

			$combined_price=($item["Cart"]["product_price"] + $item["Cart"]["extra_price"]);			

			 if(isset($item["Cart"]["discount_type"]) && $item["Cart"]["discount_type"] <> '')

			  { 

				if($item["Cart"]["discount_type"]=='per')

				 {

				    if(isset($item["Cart"]["discount"]) && $item["Cart"]["discount"] <> '' && $item["Cart"]["discount"] > 0)

					{

					 $discounted_price=($combined_price-(($combined_price * $item["Cart"]["discount"])/100));

					 $final_price=($discounted_price)*$item["Cart"]["quantity"];

					}	

					else

					$final_price=($combined_price)*$item["Cart"]["quantity"];											 

				 }

				 else if($item["Cart"]["discount_type"]=='amnt')

				 {	 

				    if(isset($item["Cart"]["discount"]) && $item["Cart"]["discount"] <> '' && $item["Cart"]["discount"] > 0)

					 {

						$final_price=(($combined_price)-$item["Cart"]["discount"])*$item["Cart"]["quantity"];						

					 }	

					 else

					$final_price=($combined_price)*$item["Cart"]["quantity"];			

				}

			  }

			 else

			 {

			  $final_price=($item["Cart"]["product_price"] + $item["Cart"]["extra_price"])*$item["Cart"]["quantity"];			 	

			 }	

			 $tot_price = $tot_price +  $final_price; 			

		 }	

		 $this->set('totaltopay', number_format($tot_price,2,".",""));			

		

         ########################## Getting total price from cart ******************************************

		######################### Section to find and add tax amount.............................		

		$taxamt	=0;

		if($cnfg["taxto"]	==	"gtotal"){

			$taxableamt		=	$tot_price + $shipping_cost;

		}else{

			$taxableamt		=	$tot_price ;

		}



		if($cnfg["tax_option"] == "notax"){

			$taxperc	=	0;

			$taxname	=	"No Tax is applicable";

		}elseif($cnfg["tax_option"] == "fixedtax"){

			$taxperc	= 	$cnfg["fixedtax_rate"];

			$taxname	=	$cnfg["fixedtax_name"];

		}else{

						
			if($cnfg["taxable_address"] == "shipping")
			{
				if(trim($prod_type) == 'Digital')
				$billadd	=	$this->UserAddress->find('UserAddress.user_id = '.$user_id.' AND UserAddress.addr_type = "Billing"');
				else
				$billadd	=	$this->UserAddress->find('UserAddress.user_id = '.$user_id.' AND UserAddress.addr_type = "Shipping"');
			}
			else
			{
				$billadd	=	$this->UserAddress->find('UserAddress.user_id = '.$user_id.' AND UserAddress.addr_type = "Billing"');				
			}
         
			$stdetal		=	$this->State->find('State.country_id = "'.$billadd["UserAddress"]["country"].'" AND State.code = "All"');

			if(!empty($stdetal["State"])){

				$taxperc	=	$stdetal["State"]["tax_rate"];

				$taxname	=	$stdetal["State"]["tax_name"];

			}else{

				$stdetal	=	$this->State->find('State.country_id = "'.$billadd["UserAddress"]["country"].'" AND State.code ="'.$billadd["UserAddress"]["state"].'"');

				if(!empty($stdetal["State"])){

					$taxperc	=	$stdetal["State"]["tax_rate"];

					$taxname	=	$stdetal["State"]["tax_name"];

				}else{

					$stdetal	=	$this->State->find('State.country_id = "'.$billadd["UserAddress"]["country"].'" AND State.name ="'.$billadd["UserAddress"]["state"].'"');

					if(!empty($stdetal["State"])){

						$taxperc	=	$stdetal["State"]["tax_rate"];

						$taxname	=	$stdetal["State"]["tax_name"];

					}else{

						$taxperc	=	0;

						$taxname	=	"No Tax is applicable";

					}

				}

			}

		}



		

		if($tot_price > 0)

		{

		$taxamt		=	($taxableamt * $taxperc) / 100;

		$taxamt		=	number_format($taxamt,2,".","")	;			

		$tot_price	=	$tot_price + $taxamt;					

		}

		########################## Coupon code section ******************************************

		$discamt	=	0;

		if($this->Session->check('Coupon') == true){

			$couparray	=	$this->Session->read('Coupon');			

			$tdat	=	date("Y-m-d");			

			if(strtotime($tdat) >= strtotime($couparray["Coupon"]["from_date"]) && strtotime($tdat) <= strtotime($couparray["Coupon"]["to_date"]) && $tot_price >= $couparray["Coupon"]["minamt"] ){

				if($couparray["Coupon"]["type"] == "Amt"){

					//$discamt	=	$couparray["Coupon"]["giftvalue"];

					 if($couparray["Coupon"]["giftvalue"] >= $tot_price)

					 $discamt	=	$tot_price;

					 else

					 $discamt	=	$couparray["Coupon"]["giftvalue"];

				}else{

					$discamt	=	$tot_price * ($couparray["Coupon"]["giftvalue"] / 100);

				}

			}					

			$tot_price	=	number_format(($tot_price - $discamt),2,".","");				

			$order["coupon_id"]		=	$couparray["Coupon"]["id"];

			$order["discount"]		=	$discamt;

		}					

		if($tot_price > 0)

		$gtotal		=	number_format(($tot_price + $shipping_cost),2,".","");

		else

		$gtotal		=	number_format(0.00 + $shipping_cost,2,".","");

		$paymentMethod = "CC";			

	
		$giftcard_cnt = $this->GiftcardDetail->find('count', array('conditions' => array('GiftcardDetail.user_id' => $user_id)));

		$this->set('giftcard_cnt', $giftcard_cnt);

		

		/*************** Section for Placing Order without payment Starts**********************************************/
		/************** Added By Jipson Thomas on 3rdJanuary 2011**********************************************/
		$shipadd						=	$this->UserAddress->find("UserAddress.user_id =".$user_id." AND UserAddress.addr_type ='Shipping'");
			$cntdet							=	$this->Country->findByCountryIsoCode_2($shipadd["UserAddress"]["country"]);
			$shipadd["UserAddress"]["country_name"]	=	$cntdet["Country"]["country_name"];
			$citem							=	$this->Cart->findAllByUserId($user_id);
			$prodtype = 	"Non-Digital";
			$order["date"]					=	date("Y-m-d H:i:s");
			$order["user_id"]				=	$user_id;
			$order["shipping_method"]		=	$shippingMethod;
			$order["shipping_service"]		=	$shippingServ;
			$order["shipping_price"]		=	$shipping_cost;
			$order["tax_price"]				=	$taxamt	;
			$order["tax_name"]				=	$taxname	;
			$order["total_price"]			=	$gtotal;
			$order["order_status_id"]		=	2;
			$order["ship_fname"]			=	$shipadd["UserAddress"]["fname"];
			$order["ship_lname"]			=	$shipadd["UserAddress"]["lname"];
			$order["ship_address"]			=	$shipadd["UserAddress"]["address"];
			$order["ship_city"]				=	$shipadd["UserAddress"]["city"];
			$order["ship_state"]			=	$shipadd["UserAddress"]["state"];
			$order["ship_country"]			=	$shipadd["UserAddress"]["country_name"];
			$order["ship_zip"]				=	$shipadd["UserAddress"]["zip"];
			$order["ship_phone"]			=	$shipadd["UserAddress"]["phone"];
			$order["ship_mobile"]			=	$shipadd["UserAddress"]["mobile"];
			$order["ship_fax"]				=	$shipadd["UserAddress"]["fax"];
			$billadd						=	$this->UserAddress->find("UserAddress.user_id =".$user_id." AND UserAddress.addr_type ='Billing'");
			$bcntdet						=	$this->Country->findByCountryIsoCode_2($billadd["UserAddress"]["country"]);
			$billadd["UserAddress"]["country_name"]	=	$bcntdet["Country"]["country_name"];
			$order["bill_fname"]			=	$billadd["UserAddress"]["fname"];
			$order["bill_lname"]			=	$billadd["UserAddress"]["lname"];
			$order["bill_address"]			=	$billadd["UserAddress"]["address"];
			$order["bill_city"]				=	$billadd["UserAddress"]["city"];
			$order["bill_state"]			=	$billadd["UserAddress"]["state"];
			$order["bill_country"]			=	$billadd["UserAddress"]["country_name"];
			$order["bill_zip"]				=	$billadd["UserAddress"]["zip"];
			$order["bill_phone"]			=	$billadd["UserAddress"]["phone"];
			$order["bill_mobile"]			=	$billadd["UserAddress"]["mobile"];
			$order["bill_fax"]				=	$billadd["UserAddress"]["fax"];
			$order["currency_type"]			=	$cnfg["currency"]; 
			$this->Order->save($order); 
			$order_id						=	$this->Order->id;
			foreach($citem as $item){
				$this->OrderDetail->create($odet = array());				
				$odet["order_id"]			=	$order_id;
				$odet["product_id"]			=	$item["Cart"]["product_id"];
				$odet["product_price"]		=	$item["Cart"]["product_price"];
				$odet["prodtype"]		    =	$item["Cart"]["prodtype"];
				$odet["discount_type"]		=	$item["Cart"]["discount_type"];
				$odet["discount"]			=	$item["Cart"]["discount"];				
				$odet["extra_price"]		=	$item["Cart"]["extra_price"];
				$odet["quantity"]			=	$item["Cart"]["quantity"];
				$odet["savedimages_id"]		=	$item["Cart"]["savedimages_id"];
				if($item["Cart"]["option_id"]>0 && $item["Cart"]["type"] <> 'G') {							
				$odet["combination_id"]		=	$item["Cart"]["option_id"]; }
				$odet["type"]			    =	$item["Cart"]["type"];
				$odet["price_type"]			=	$item["Cart"]["price_type"];
				$this->OrderDetail->save($odet);
				######## ( Code Added by Shyam)	########
				if($item["Cart"]["option_id"]>0)
				 {
				 $this->Product->updatecombnstock($item["Cart"]["product_id"],$item["Cart"]["option_id"],$item["Cart"]["quantity"]);
				 $prodid[]=$item["Cart"]["product_id"];										 
				 }
				else if($item["Cart"]["option_id"]==0 || $item["Cart"]["option_id"]=='') {
				$this->Product->updatestock($item["Cart"]["product_id"],$item["Cart"]["quantity"]); }				
				if($item["Cart"]["type"] == 'G')
				{
				  $this->Giftcard->updateCardStock($item["Cart"]["product_id"],$item["Cart"]["quantity"]);	
				}
				######## ( Code Added by Shyam)	########
			}
			if(!empty($prodid))
			{	
				$prodid=array_unique($prodid);
				foreach($prodid as $val){	
				 $this->Product->updateTotalStock($val);
				}
			}
			$this->delcart($user_id);
			################################## Section to send order confirmation mail................................
			$this->Order->id = $order_id; 
			$data = $this->Order->read();
			for($j=0;$j < sizeof($data["OrderDetail"]);$j++){
			  if($data["OrderDetail"][$j]["type"]=='P')
			  {
				$pdet	=	$this->Product->findById($data["OrderDetail"][$j]["product_id"]);				  	
				$data["OrderDetail"][$j]["Product"]	=	$pdet["Product"]["pname"];
			  }
			  else if($data["OrderDetail"][$j]["type"]=='G')
			  {
				$gdet	=	$this->Giftcard->findById($data["OrderDetail"][$j]["product_id"]);								
				$data["OrderDetail"][$j]["Product"]	=	$gdet["Giftcard"]["gift_code"].'(Gift Card)';
				$data["OrderDetail"][$j]["product_price"]	=	$gdet["Giftcard"]["gift_amnt"];
			  }
			}		
			$shipadd	=	$this->UserAddress->findAll("UserAddress.user_id=".$data["User"]["id"]." AND UserAddress.addr_type='Shipping'");
			$billadd	=	$this->UserAddress->findAll("UserAddress.user_id=".$data["User"]["id"]." AND UserAddress.addr_type='Billing'");
			$odr	=	$data;
			if($prodtype <> "Digital"){
			$ship	=	$shipadd[0]["UserAddress"]; }
			$bill	=	$billadd[0]["UserAddress"];
			 $content = "<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>
	  <tr>

		<td colspan='2' align='center'>

		<h2>Order Details</h2>

		</td>

	  </tr>

	  <tr>

		<td colspan='2' align='center'>

			<table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'>

			 <tr>

				<td><strong>Order Number</strong></td>
				
				<td><strong>Order Status</strong></td>

				<td><strong>Order Date</strong></td>

				<td><strong>User Name</strong></td>

				<td><strong>Currency</strong></td>

			  </tr>

			  <tr>

				<td>&nbsp;</td>
				
				<td>&nbsp;</td>

				<td>&nbsp;</td>

				<td>&nbsp;</td>

				<td>&nbsp;</td>

			  </tr>

			  <tr>

                <td> ".$order_id."</td>
				<td>".

				$odr['OrderStatus']['name']."

				</td>

				<td>";
				

				$dt	= strtotime($odr['Order']['date']);

				$edt	= strtotime($odr['Order']['exp_time']);

				$content .= date('m-d-Y',$dt );

				$content .= "</td>

				<td> ".$odr['User']['uname']."</td>

				<td>". $odr["Order"]["currency_type"]."</td>

			  </tr>

			</table>

		</td>

	  </tr>

	  <tr>

		<td colspan='2' align='center'><h3>Item Details</h3></td>

	   

	  </tr>

	  <tr>

		<td colspan='2'><table width='90%' border='0' cellpadding='2' cellspacing='2' class='manage_table' align='center'>

	  <tr>

		<td colspan='2'><strong>Product Name</strong></td>

		<td><strong>Quantity</strong></td>

		<td><strong>Unit Price</strong></td>

		<td><strong>Additional Cost</strong></td>

		<td><strong>Discount</strong></td>

		<td><strong>Price</strong></td>

		<td><strong>Expiry Date</strong></td>

		<td><strong></strong></td>

	  </tr>

	  <tr>

		<td colspan='3'>&nbsp;</td>

		<td>&nbsp;</td>

		<td>&nbsp;</td>

		<td>&nbsp;</td>

		<td>&nbsp;</td>

		<td>&nbsp;</td>

		<td>&nbsp;</td>

	  </tr>";

	  

	  $amt=0;

	  //print_r($odr);exit;

	  foreach($odr['OrderDetail'] as $det)

	  { 

	      $price=0;

		  $combined_price=0;

		  $dis_amnt=0;	

		  if($det["discount_type"]=='per' && $det["discount"] > 0)

		  $dis_amnt=(($det["product_price"] + $det["extra_price"])*$det["discount"])/100;

		  else if($det["discount_type"]=='amnt' && $det["discount"] > 0)

		  $dis_amnt=$det["discount"];		

		  $dis_amnt=number_format($dis_amnt,2,'.','');

		   

			$combined_price=($det["product_price"] + $det["extra_price"]);			

			 if(isset($det["discount_type"]) && $det["discount_type"] <> '')

			  { 

				if($det["discount_type"]=='per')

				 {

				  if(isset($det["discount"]) && $det["discount"] <> '' && $det["discount"] > 0)

					{					 

					    $discounted_price=($combined_price-(($combined_price * $det['discount'])/100));

						$price=($discounted_price)*($det['quantity']);							

						$amt+= $price;						  

					}			

					else

					$amt+=($combined_price)*($det['quantity']);										 

				 }

				 else if($det["discount_type"]=='amnt')

				 {	 

				     if(isset($det["discount"]) && $det["discount"] <> '' && $det["discount"] > 0)

					 {

						$discounted_price=($combined_price-$det['discount']);

						$price=($discounted_price)*($det['quantity']);	

						$amt+= $price;									

					 }		

					 else

					$amt+=($combined_price)*($det['quantity']);			

				}

			  }

			 else

			 {			 	

			    $price = ($combined_price)*($det['quantity']);

				$amt+= $price;		 	

			 }				

			 $price=number_format($price,2,".","");  

			 $amt=number_format($amt,2,".",""); 

			   /******************* to get Combination name *************/
                         
                          $combnstr = array();
        $combinations = array();
       $combinationanme = '';
         $prod1 = $this->Productdetail->findById($det['combination_id']);
               
       
          
              
               if($prod1){ 
                  $pcmbnids=$prod1["Productdetail"]["customvalue_id"];

                  $pcmbnid=explode(',',$pcmbnids);

                    foreach($pcmbnid as $key => $val) {

                       if($val!='') { 
                           $combnstr[]=$this->Product->getpdctcmbn($val);
          
                           $combinations=implode(", ",$combnstr);
                           
                           
                           $combinationanme = $combinations;
                        }else{
                            $combinationanme = '';
                        }

                    }

                  
               }
                
		  /******************* to get Combination name *************/

		

			 $content .= " <tr>

			<td colspan='2'>".$det['Product'].' '.$combinationanme."</td>

			<td> ".$det['quantity']." </td>

			<td> ".$det['product_price']." </td>

			<td> ".$det['extra_price']." </td>

			<td> ".$dis_amnt." </td>

			<td>".$price." </td>

			<td>Non-Digital</td>

			<td>&nbsp;</td>

		  </tr>

		  <tr>

			<td colspan='3' height='15'>&nbsp;</td>

			<td>&nbsp;</td>

			<td>&nbsp;</td>

			<td>&nbsp;</td>

			<td>&nbsp;</td>
			<td>&nbsp;</td>

			<td>&nbsp;</td>

		  </tr>";
	  } 

	  

	     if($odr["Order"]["discount"] > $amt)				

		 $discamt=number_format($amt,2,'.','');

		 else

		 $discamt=number_format($odr["Order"]["discount"],2,'.',''); 

	$content .= "</table>

	</td>

	  </tr>

	  <tr>

		<td width='50%'>";

		  if($det['prodtype'] <> "Digital"){

			 $content .="<table width='100%'border='0' cellpadding='0' cellspacing='0'>

		<tr><td>

		<table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'>

			  <tr>

				<td width='50%'><strong>Shipping Method</strong></td>

				<td  width='5%'>:</td>

				<td width='45%'>".$odr['Order']['shipping_method']."</td>

			  </tr>

			  <tr>

				<td><strong>Shipping Service</strong></td>

				<td>:</td>

				<td>". $odr['Order']['shipping_service']." </td>

			  </tr>

			</table>

		</td></tr>

		<tr><td>

		
		</td></tr>

		</table>";

		}

		

	 $content .="</td>

		<td width='50%'><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'>

			  <tr>

				<td><strong>Total Price</strong></td>

				<td>:</td>

				<td>".$amt."</td>

			  </tr>";

			  if($det['prodtype'] <> "Digital"){  

			   $content .="<tr>

				<td><strong>Shipping</strong></td>

				<td>:</td>

				<td> ".$odr['Order']['shipping_price']." </td>

			  </tr>";

			  }

			   $content .="<tr>

				<td><strong>Tax Name</strong></td>

				<td>:</td>

				<td> ".$odr['Order']['tax_name'] ."</td>

			  </tr>

			   <tr>

				<td><strong>Tax</strong></td>

				<td>:</td>

				<td> ".$odr['Order']['tax_price'] ."</td>

			  </tr>

			   <tr>

				<td><strong>Discount </strong></td>

				<td>:</td>

				<td> ".$discamt." </td>

			  </tr>
                          

			   <tr>

				<td><strong>Coupon Code Discount</strong></td>

				<td>:</td>

				<td> ".$odr['Order']['reduced_amt'] ."</td>

			  </tr>";
                          


                        $mailGrantTotal = $odr['Order']['total_price'];
                         if($odr['Order']['reduced_amt'] > 0){				
                                //echo number_format($odr["Order"]["reduced_amt"],2,'.',''); 
                                $mailGrantTotal -= $odr["Order"]["reduced_amt"]; 
                         }

			   $content .="<tr>

				<td><strong>Grand Total</strong></td>

				<td>:</td>

				<td><b> ".$mailGrantTotal." </b></td>

			  </tr>

			</table></td>

	  </tr>

	   <tr height='15'>

		<td colspan='2' align='center'>&nbsp;

		</td>

	  </tr>

	  <tr>

	  <td>";

	  

	  if($det['prodtype'] <> "Digital"){

			 $content .="<table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'>

	  <tr>

		<td><h3>Shipping Address</h3></td>

	  </tr>

	  <tr>

		<td> ".$odr['Order']['ship_fname'] ."&nbsp;&nbsp;  ".$odr['Order']['ship_lname']." </td>

	  </tr>

	  <tr>

		<td> ".$odr['Order']['ship_address']." </td>

	  </tr>

	  <tr>

		<td> ".$odr['Order']['ship_city'] ."&nbsp;&nbsp;&nbsp;".$odr['Order']['ship_state']."&nbsp;&nbsp;&nbsp;".  $odr['Order']['ship_zip']." </td>

	  </tr>

	  <tr>

		<td> ".$odr['Order']['ship_country']." </td>

	  </tr>

	  <tr>

		<td>Phone &nbsp; : &nbsp; ".$odr['Order']['ship_phone']." </td>

	  </tr>

	  <tr>

		<td>Mobile &nbsp; : &nbsp;". $odr['Order']['ship_mobile'] ."</td>

	  </tr>

	  <tr>

		<td>Fax &nbsp; : &nbsp; ".$odr['Order']['ship_fax']." </td>

	  </tr>

	  <tr>

		<td>&nbsp;</td>

	  </tr>

	</table>";

	} 

	

	$content .=" </td>

	   <td><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'>

	  <tr>

		<td><h3> Billing Address</h3></td>

	  </tr>

	  <tr>

		<td> ".$odr['Order']['bill_fname'] ."&nbsp;&nbsp; ".$odr['Order']['bill_lname']." </td>

	  </tr>

	  <tr>

		<td> ".$odr['Order']['bill_address'] ."</td>

	  </tr>

	  <tr>

		<td>". $odr['Order']['bill_city']."&nbsp;&nbsp;&nbsp;". $odr['Order']['bill_state'] ."&nbsp;&nbsp;&nbsp;". $odr['Order']['bill_zip'] ."</td>

	  </tr>

	  <tr>

		<td>". $odr['Order']['bill_country'] ." </td>

	  </tr>

	  <tr>



		<td>Phone &nbsp; : &nbsp; ".$odr['Order']['bill_phone'] ."</td>

	  </tr>

	  <tr>

		<td>Mobile &nbsp; : &nbsp; ".$odr['Order']['bill_mobile']." </td>

	  </tr>

	  <tr>

		<td>Fax &nbsp; : &nbsp; ".$odr['Order']['bill_fax'] ."</td>

	  </tr>

	  <tr>

		<td>&nbsp;</td>

	  </tr>

	</table></td>

	  </tr>";
		$content .="<tr>

			<td>&nbsp;</td>

		  </tr>

		</table>

	  </td>

	   <td>&nbsp;</td>

	  </tr>

	</table>";

$cnfg 			=	Configure::read('Neutrino');
$subject 		= "Tshirt design placed for you at ".$cnfg["site_name"];

					$headers 		= "MIME-Version: 1.0\r\n";
					
					$headers        .= "Reply-To: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";
					
					$headers        .= "Return-Path: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";
					
					$headers 		.= "From: ".$cnfg["site_name"]."<".$cnfg["admin_email"].">\r\n";
					
					$headers        .= "Organization: ".$cnfg["site_name"]."\r\n";

					$headers 		.= "Content-type: text/html; charset=iso-8859-1\r\n";

					$pdt 			= 	$this->Cmspage->findByTitle('Order confirm mail');

					$path			=	"SiteLogo_disp.gif";

					$mcont			=	"<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>

		  <tr><td><a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'><img src='".FULL_BASE_URL. $cnfg["sitebasefolder"]."/app/webroot/".IMAGES_URL.$path."' border='0' width='300'></a></td></tr></table>";

					$cnfg["site_name"]	=	"<a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'>".$cnfg["site_name"]."</a>";

					//Mail for User

						$pdt 			= 	$this->Cmspage->findByTitle('Order confirm mail');

						$mailcontent	=	$mcont.$pdt["Cmspage"]["content"];

						$mailcontent = str_replace("[ORDER_DETAILS]", $content, $mailcontent);

						$mailcontent = str_replace("[User_Name]", $odr['User']['uname'], $mailcontent);

						$mailcontent = str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent);		

						$mailsent 		= mail($odr['User']['email'],$subject,$mailcontent,$headers);	

						

						//Mail for Admin

						$pdt1 			= 	$this->Cmspage->findByTitle('Admin order confirm mail');

						$mailcontent1	=	$mcont.$pdt1["Cmspage"]["content"];

						$mailcontent1 = str_replace("[ORDER_DETAILS]", $content, $mailcontent1);

						$mailcontent1 = str_replace("[User_Name]", $odr['User']['uname'], $mailcontent1);

						$mailcontent1 = str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent1);		

						$mailsent1 		= mail($cnfg["admin_email"],$subject,$mailcontent1,$headers);	

						

			###################################

			 

				 ################################### Sending Fax to Admin ###################################

						$cnfg=Configure::read('Neutrino');

						$fax_allow	=	$cnfg["allow_fax"];

						if($fax_allow=='Y')

						{

		               		$fax_email	=	$cnfg["fax_email"]; 

							$fax_number	=	$cnfg["fax_number"]; 

							$fax_content=$content;	

							$fax_content = str_replace("[User_Name]", $odr['User']['uname'], $fax_content);

							$fax_content = str_replace("[SITE_NAME]", $cnfg["site_name"], $fax_content);					

							$this->_sendFax($fax_email,$fax_number,$fax_content,1);

						}						

				 ################################### Sending Fax Ends here ###################################

				 

			$this->Session->setFlash('An order has been successfully placed and an e-mail with order details has sent to the customer\'s e-mail ID!', 'default',array('class'=> 'success'));	
        	$this->redirect(array('controller' =>'Products','action'=>'seluser'));

		  	exit;
	

		  
		/*************** Section for Placing Order without payment Ends**********************************************/
		/************** Added By Jipson Thomas on 3rdJanuary 2011**********************************************/
			
	
	}
	
	/************ Function to calculate price baised on Price Tier ************/
	function getTieredPrice($pid,$totqty){
		//echo "id".$pid." Quantity".$totqty;
		$priceTier       =       $this->Productpricetier->select_product_pricetier($pid); // get price tier
		//echo " pricetier<pre>";print_r($priceTier);
		foreach ($priceTier as $key => $value) {
			 
			if($value['pricerates']['type']=="Between")
			{
				$arrqtyrange= explode(",", $value['pricerates']['quantity']);
				$closestQty[] = abs($arrqtyrange[1]-$totqty);
				$betweenRange = range($arrqtyrange[0],$arrqtyrange[1]);
				if(in_array($totqty, $betweenRange)){
					$dat["product_price"]=$value['pricerates']['rate'];}
			}
			if($value['pricerates']['type']=="Above")
			{
				$closestQty[] = abs($value['pricerates']['quantity']-$totqty);
				if($totqty > $value['pricerates']['quantity'])
					$dat["product_price"]=$value['pricerates']['rate'];
			}
		}
		//////////// case Quantity not in any range take the price of nearest range //////
		/* if($dat["product_price"]==''){
		$closeQty = min($closestQty);
		foreach ($priceTier as $key => $value){
		if($value['pricerates']['type']=="Between")
		{
		$arrqtyrange= explode(",", $value['pricerates']['quantity']);
		$nearval=abs($arrqtyrange[1]-$totqty);
		if($closeQty==$nearval)
		{
		$dat["product_price"]=$value['pricerates']['rate'];
		break;
		}
		}
		else
		{
		$nearval=abs($value['pricerates']['quantity']-$totqty);
		if($closeQty==$nearval)
		{
		$dat["product_price"]=$value['pricerates']['rate'];
		break;
		}
		}
		}
		}*/
		// echo "tier ".$dat["product_price"];exit;
		return $dat["product_price"];
		 
		///// nearest range price for missing range  //////
		}
}

?>
