<?php 
class DownloadComponent extends Object
{
	private $WEBDIR;
	
	function __construct(){
		parent::__construct();
		$this->WEBDIR = WWW_ROOT;
	}
	
	function downloadFile($path){
		// place this code inside a php file and call it f.e. "download.php"
		$fullPath = WWW_ROOT.$path; // change the path to fit your websites document structure
		 
		if ($fd = fopen ($fullPath, "r")) {
			$fsize = filesize($fullPath);
			$path_parts = pathinfo($fullPath);
			$ext = strtolower($path_parts["extension"]);
			
			switch ($ext) {
				case "pdf":
					header("Content-type: application/pdf"); // add here more headers for diff. extensions
					header("Content-Disposition: attachment; filename=\"".$path_parts["basename"]."\""); // use 'attachment' to force a download
					break;
				case "svg":
					header("Content-type: image/svg+xml"); // add here more headers for diff. extensions
					header("Content-Disposition: attachment; filename=\"".$path_parts["basename"]."\""); // use 'attachment' to force a download
					break;
				default;
					header("Content-type: application/octet-stream");
					header("Content-Disposition: attachment; filename=\"".$path_parts["basename"]."\"");
			}
			header("Content-length: $fsize");
			header("Cache-control: private"); //use this to open files directly
			while(!feof($fd)) {
				$buffer = fread($fd, 2048);
				echo $buffer;
			}
		}
		fclose ($fd);
		exit;
	}
	// example: place this kind of link into the document where the file download is offered:
	// <a href="download.php?download_file=some_file.pdf">Download here</a>
}