<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2011 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts PrintLogic                     |
// +----------------------------------------------------------------------+
// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |
// +----------------------------------------------------------------------+

App::import('Sanitize');

class CustomfieldvaluesController extends AppController {

    var $name = "Customfieldvalue";
    var $helpers = array('Html', 'Form','Pagination');   
    var $components = array ('Pagination','Catmenu','History','Email');
    var $uses = array('Customfieldvalue','Customfield','Currency','Setting');
    var $paginate = array('limit' => 25,'order' => array('Customfield.custom_name' => 'asc'));

    function index() {

        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');

        if($admsess["custom"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }

        $cmbSearchType	=	"";
        $txtSearch		=	"";

        if(isset($_GET["cmbSearchType"]) && isset($_GET["txtSearch"])) {

            $cmbSearchType	=	$_GET["cmbSearchType"];
            $txtSearch		=	$_GET["txtSearch"];
            if($cmbSearchType == "name") {
                $data = $this->paginate('Customfieldvalue', array('Customfieldvalue.custom_value LIKE ' => "%".addslashes($txtSearch)."%"));
            }else {
                $data = $this->paginate('Customfieldvalue');
            }
        }

        else if(isset($this->passedArgs["cmbSearchType"]) && isset($this->passedArgs["txtSearch"]) &&
            $this->passedArgs["txtSearch"] <> '') {
            $cmbSearchType	=	$this->passedArgs["cmbSearchType"];
            $txtSearch		=	$this->passedArgs["txtSearch"];

            if($cmbSearchType == "name") {
                $data = $this->paginate('Customfieldvalue', array('Customfieldvalue.custom_value LIKE ' => "%".addslashes($txtSearch)."%"));
            }else {
                $data = $this->paginate('Customfieldvalue');
            }
        }else {
            $data = $this->paginate('Customfieldvalue');
        }

        $this->set('cmbSearchType', $cmbSearchType);
        $this->set('txtSearch', $txtSearch);
        $this->passedArgs['limit']=$this->paginate["limit"];
        $this->set('passedarg',$this->passedArgs);

        $fields=$this->Customfield->findAll("Customfield.custom_name <> 'Default'",'','Customfield.custom_name ASC');

        foreach($fields as $values)
            $customfields[$values['Customfield']['id']]=$values['Customfield']['custom_name'];

        if(isset($customfields))
            $this->set('customfields', $customfields);

        $this->set('customfieldvalue', $data);

        //For Edit in Place
        $this->set('totrows', 25);
        //For Edit in Place
        $this->layout = 'adm';

    }


    function add() {

    $this->__validateLoginStatus();
    $admsess	=	$this->Session->read('Admin');

    if($admsess["custom"] <> 1) {
        $this->redirect(array('controller' => 'admins', 'action' => 'index'));
        exit();
    }

    if (!empty($this->data)) {

        $customid=$_POST["hidcstmid"];
        //checking for duplicates starts here...
        $dups=$this->Customfieldvalue->checkAddDups(trim($this->data["Customfieldvalue"]["custom_value"]),$customid);
        if(isset($dups) && $dups > 0) {

            $this->Session->setFlash('CustomField Value Already exists.', 'default',array('class'=> 'failure'));
            $this->redirect('/customfieldvalues');
            exit();
        }

        //checking for duplicates ends here...

        $this->Customfieldvalue->save($this->data);
        $this->Session->setFlash('CustomField value has been saved.', 'default',array('class'=> 'success'));
        $this->redirect(array('controller' => 'customfieldvalues','action'=>'index'));
    }
    $this->layout = 'adm';

}



	



	function edit() 



	{



		$this->__validateLoginStatus();		



		$admsess	=	$this->Session->read('Admin');



		if($admsess["custom"] <> 1){



		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 



			exit();



		}



		$customid=$_POST["hidcustomid"];



		$editindex=$_POST["editindex"];



		$editid=$_POST["editid"];



		$customvalue=trim($_POST["edit_cname$editindex"]);		



		



		//checking for duplicates starts here...



		$dups=$this->Customfieldvalue->checkEditDups($customvalue,$customid,$editid);			



		 if(isset($dups) && $dups > 0)



		     {



				  $this->Session->setFlash('CustomField Value Already exists.', 'default',array('class'=> 'failure'));



		         $this->redirect('/customfieldvalues');



		         exit();



		      } 



		//checking for duplicates ends here...



		



		



		//Fetching the old custom name



		$this->Customfieldvalue->id = $editid; 



		$custom	=	$this->Customfieldvalue->findById($editid);



		$cvalue	=	$custom["Customfieldvalue"]["custom_value"];	



		//Fetching the old custom name		



		if ($customvalue!='') 



		{



	        $this->Customfieldvalue->updatecusfieldval($customvalue,$editid); 



			$this->Session->setFlash('The CustomField value '.$cvalue.' has been Edited Successfully.', 'default',array('class'=> 'success'));



			$this->redirect('/customfieldvalues');



		}



	}	



		



	function delete($id){



		$this->__validateLoginStatus();



		$admsess	=	$this->Session->read('Admin');



		if($admsess["custom"] <> 1){



		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 



			exit();



		}



		$child_exists=$this->Customfieldvalue->checkChildExits($id); 



		if($child_exists==1)



		  {



		       $this->Session->setFlash('CustomField Value Cannot be deleted as product category exists under this.', 'default',array('class'=> 'failure'));


		       $this->redirect('/customfieldvalues');



		       exit();



		  }		 



		



		



		//Fetching the old custom name



		$this->Customfieldvalue->id = $id; 



		$custom	=	$this->Customfieldvalue->findById($id);



		$cvalue	=	$custom["Customfieldvalue"]["custom_value"];	



		//Fetching the old custom name	



		$this->Customfieldvalue->delcusfieldval($id);



		$this->Session->setFlash('The CustomField value '.$cvalue.' has been deleted Successfully.', 'default',array('class'=> 'success'));



		$this->redirect('/customfieldvalues');



	}



	



	function delcusnam($pid,$nam){



		$this->__validateLoginStatus();



		$admsess	=	$this->Session->read('Admin');



		if($admsess["custom"] <> 1){



		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 



			exit();



		}



		$this->Customfield->delcusnam($nam);



		$this->flash('CustomField value Removed .', '/customfield');



		$this->redirect(array('controller' => 'products','action'=>'edit/'.$pid.'/cust'));



	}



	



    function beforeFilter()



    {



		if (isset($this->Setting) && !empty($this->Setting->table))  



        {  



             $this->Setting->load();  



        } 



		global $sitefolder; 



		global $meta_description;



		global $meta_keywords;



		global $page_title;



		$cnfg 				=	Configure::read('Neutrino');



		$sitefolder			=	$cnfg["sitebasefolder"];



		$meta_description	=	$cnfg["meta_description"];



		$meta_keywords		=	$cnfg["meta_keywords"];



		$page_title			=	$cnfg["page_title"];



		global $style; 



		$style				=	$cnfg["style"];



		$this->set('style', $style);



		$this->set('meta_description', $meta_description);



		$this->set('meta_keywords', $meta_keywords);



		$this->pageTitle = $page_title	; 



		$this->set('cnfg',$cnfg);



		$this->paginate["limit"]=$cnfg["items_perpage"]; //Setting pagination limit per page.

		

		$this->set('sitefolder', $sitefolder);

        $httpHost	=	$_SERVER['HTTP_HOST'];

        $this->set('sitebase','http://'.$httpHost);



    }



	function beforeRender(){



				$lst	=	$this->Catmenu->getCatList(1);



				$this->set('catmenu', $lst);



				//$this->layout = 'adm';



	}



    function __validateLoginStatus($typ='A')
    {
           if($typ == 'A'){
				if($this->Session->check('Admin') == false)
				{
					$this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
					$this->redirect(array('controller' => 'admins', 'action' => 'login')); 
				}
		}else{
				if($this->Session->check('Userlog') == false)
				{
					$this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
					$this->redirect(array('controller' => 'users', 'action' => 'login')); 
				}
			}
    }



    function addcustomvalues($customFieldId) { 

        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');

        if($admsess["custom"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }
        $customData	=	$this->Customfield->findById($customFieldId); 
        $this->set('customFieldId', $customFieldId);
        $this->set('customFieldName', $customData['Customfield']['custom_name']);

        if (!empty($this->data)) { //echopre($this->data);

            $customFieldId    = $this->data['Customfieldvalue']['customFieldId'];
            $customFieldValue = $this->data['Customfieldvalue']['customFieldValue'];
            
            //checking for duplicates starts here...
            $dups=$this->Customfieldvalue->checkAddDups(trim($customFieldValue),$customFieldId); 
            if(isset($dups) && $dups > 0) {
                $this->Session->setFlash('Custom Field Value Already exists.', 'default',array('class'=> 'failure'));
            }else{
            //checking for duplicates ends here...
            $this->data['Customfieldvalue']['customfield_id'] = $customFieldId;
            $this->data['Customfieldvalue']['custom_value']   = $customFieldValue;
            $this->Customfieldvalue->save($this->data);
            $this->Session->setFlash('Custom Field value has been saved.', 'default',array('class'=> 'success'));
            }
        } 
        $this->layout = 'ajax';
    }


}



?>