<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 		     */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2011 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts PrintLogic                    |
// +----------------------------------------------------------------------+
// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |
// +----------------------------------------------------------------------+

App::import('Sanitize');

class UsersController extends AppController {
    var $name = "User";

    var $helpers = array('Html', 'Form','Pagination','Javascript','Ajax','Csv','xls');

    var $components = array ('Pagination','Catmenu','History','Email','Twitter'); // Added

    var $uses = array('User','Setting','Country','Cart','Cmspage','Category','Newsletter','Newsletteruser','Statecode','Order','Products','Dynamicpage');

    var $paginate = array('limit' => 25,'order' => array('User.uname' => 'asc'));

    function index() {

         if($this->Session->check('Userlog') != false) {
                $this->Session->setFlash('The URL you have followed requires you to login.', 'default',array('class'=> 'failure'));
                $this->redirect(array('controller' => 'users', 'action' => 'login'));
                } 
                
        $this->__validateLoginStatus();

        $admsess	=	$this->Session->read('Admin');

        if($admsess["users"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();
        }     

        $criteria=NULL;

        $cmbSearchType	=	"";

        $txtSearch		=	"";

        if(isset($_GET["cmbSearchType"]) && isset($_GET["txtSearch"])) {

            $cmbSearchType	=	$_GET["cmbSearchType"];

            $txtSearch		=	$_GET["txtSearch"];

            $data = $this->paginate('User', array('User.'.$cmbSearchType.' LIKE ' => "%".addslashes($txtSearch)."%", 'User.id <>' => 0));

        }

        else if(isset($this->passedArgs["cmbSearchType"]) && isset($this->passedArgs["txtSearch"]) &&

                $this->passedArgs["txtSearch"] <> '') {

            $cmbSearchType	=	$this->passedArgs["cmbSearchType"];

            $txtSearch		=	$this->passedArgs["txtSearch"];

            $data = $this->paginate('User', array('User.'.$cmbSearchType.' LIKE ' => "%".addslashes($txtSearch)."%", 'User.id <>' => 0));

        }

        else {

            $data = $this->paginate('User', array('User.id <>' => 0));

        }

        $this->set('cmbSearchType', $cmbSearchType);

        $this->set('txtSearch', $txtSearch);

        $this->passedArgs['limit']=$this->paginate["limit"];

        $this->set('passedarg',$this->passedArgs);

        $this->set('usr', $data);

        $this->layout = 'adm';

    }

    function beforeFilter() {

        if (isset($this->Setting) && !empty($this->Setting->table)) {

            $this->Setting->load();

        }

        global $sitefolder;

        global $meta_description;

        global $meta_keywords;

        global $page_title;

        $cnfg 				=	Configure::read('Neutrino');

        $sitefolder			=	$cnfg["sitebasefolder"];

        $meta_description	=	$cnfg["meta_description"];

        $meta_keywords		=	$cnfg["meta_keywords"];

        $page_title			=	$cnfg["page_title"];

        global $style;

        $style				=	$cnfg["style"];

        $this->set('style', $style);

        $this->set('meta_description', $meta_description);

        $this->set('meta_keywords', $meta_keywords);

        $this->pageTitle = $page_title	;

        $this->set('cnfg',$cnfg);

        $this->paginate["limit"]=$cnfg["items_perpage"]; //Setting pagination limit per page.

        $this->set('sitefolder', $sitefolder);

        $httpHost	=	$_SERVER['HTTP_HOST'];

        $this->set('sitebase','http://'.$httpHost);

    }

    function beforeRender() {

        //$lst	=	$this->Catmenu->getCatList(1);

        //$this->set('catmenu', $lst);

        //Code Added By shyam for Category Menu Listing starts here..

        $lst	=	$this->Category->find('all',array('order' => array('position' => 'ASC')));

        $productsList = $this->Products->findAll("status='A'",NULL,NULL,10);
      // print_r($productsList);
        
        if(empty($lst)===false) {

            foreach($lst as $det)

                $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"], 'position' => $det["Category"]["position"]);

            $this->set('menu_array', $menu_array);
            $pages =    $this->Dynamicpage->getpages();
            //echo "hello<pre>";print_r($pages);
            $this->set('pagesdynamic', $pages);

        }

        //Code Added By shyam for Category Menu Listing ends here..
        $footer_links = $this->Cmspage->find('list',array('conditions' => array('Cmspage.type' => 'content','Cmspage.status' => 'Y')));
        $this->set('footerlinks', $footer_links);
         $this->set('productsList', $productsList);

    }

    function __validateLoginStatus($typ='A') {
        if($typ == 'A') {
            if($this->Session->check('Admin') == false) {
                $this->Session->setFlash('The URL you have followed requires you to login.', 'default',array('class'=> 'failure'));
                $this->redirect(array('controller' => 'admins', 'action' => 'login'));
            }
        }else {
            if($this->Session->check('Userlog') == false) {
                $this->Session->setFlash('The URL you have followed requires you to login.', 'default',array('class'=> 'failure'));
                $this->Session->write('logurl', $_SERVER['REQUEST_URI']);
                $this->redirect(array('controller' => 'users', 'action' => 'login'));
            }
        }
    }

    function add($redirflag='') {
        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');
        $this->set('redirflag',$redirflag);
        if($admsess["users"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }
        if (!empty($this->data)) {

            if($this->data["User"]["password"] <> $this->data["User"]["conpassword"]) {
                $this->Session->setFlash('Password Mismatch!', 'default',array('class'=> 'failure'));
                $this->redirect(array('controller'=>'users','action'=>'add'));
            }else {
                $user["password"]		=	md5($this->data["User"]["password"]);
            }
            $user["email"]		=	$this->data["User"]["email"];
            $user["uname"]		=	$this->data["User"]["uname"];
            $user["usertype"]		=	$this->data["User"]["usertype"];
            $user["reg_date"]           =	date('Y-m-d h:i:s');
            $user["reg_status"]		=	'R';
            $usse = $this->User->findByEmail($user["email"]);
            $ussn = $this->User->findByUname($user["uname"]);
            if (!empty($ussn['User']['uname'])) {
                $this->Session->setFlash('The Username Already Exist!', 'default',array('class'=> 'failure'));
                $this->redirect(array('controller'=>'users','action'=>'add'));
                exit;
            }elseif (!empty($usse['User']['uname'])) {
                $this->Session->setFlash('The Email Address Already Exist!', 'default',array('class'=> 'failure'));
                $this->redirect(array('controller'=>'users','action'=>'add'));
                exit;
            }else {
                $this->User->save($user);
                $id	=	$this->User->id;
               if($id)
               {
                     $cnfg 			=	Configure::read('Neutrino');

                    $this->Session->setFlash('Your registration has been completed successfully', 'default',array('class'=> 'success'));

                    $subject 		= "Registration complete at ".$cnfg["site_name"];

                    $headers 		= "MIME-Version: 1.0\r\n";

                    $headers        .= "Reply-To: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";

                    $headers        .= "Return-Path: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";

                    $headers 		.= "From: ".$cnfg["site_name"]."<".$cnfg["admin_email"].">\r\n";

                    $headers        .= "Organization: ".$cnfg["site_name"]."\r\n";

                    $headers 		.= "Content-type: text/html; charset=iso-8859-1\r\n";

                    $pdt 			= 	$this->Cmspage->findByTitle('Registration confirm mail');

                    $path			=	"SiteLogo_disp.gif";

                    $mcont			=	"<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>

		  <tr><td><a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'><img src='".FULL_BASE_URL. $cnfg["sitebasefolder"]."/app/webroot/".IMAGES_URL.$path."' border='0' width='300'></a></td></tr></table>";

                    $cnfg["site_name"]	= "<a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'>".$cnfg["site_name"]."</a>";

                    $logurl		= "Click <a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."/users/login' target='_blank'>here </a>to login";

                    $mailcontent	= $mcont.$pdt["Cmspage"]["content"];

                    $mailcontent 	= str_replace("[User_Name]", $user['uname'], $mailcontent);

                    $mailcontent 	= str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent);

                    $mailcontent 	= str_replace("[PASSWORD]", $this->data["User"]["password"], $mailcontent);

                    $mailcontent 	= str_replace("[LOGIN_URL]", $logurl, $mailcontent);

                    $pdtad 		= $this->Cmspage->findByTitle('Registration intimation mail to admin');

                    $mailcontentad	=	$mcont.$pdtad["Cmspage"]["content"];

                    $mailcontentad 	= str_replace("[User_Name]", $user['uname'], $mailcontentad);

                    $mailcontentad 	= str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontentad);
                    $mailsent 		= mail($user['email'],$subject,$mailcontent,$headers);

                    $mailsent1 		= mail($cnfg["admin_email"],$subject,$mailcontentad,$headers);
                   
                   
               }
                $this->Newsletteruser->create($newsletteruser = array());
                $newsletteruser["id"]	=	$id;
                $newsletteruser["uname"]	=	$user["uname"];
                $newsletteruser["email"]	=	$user["email"];
                $newsletteruser["sub_date"]	=	date('Y-m-d h:i:s');
                $newsletteruser["status"]	=	'N';
                $dups = $this->Newsletteruser->findByEmail(trim($user["email"]));
                if (empty($dups['Newsletteruser']['email'])=== true)
                    $this->Newsletteruser->save($newsletteruser);
                unset($newsletteruser);
            }
            if(!empty($id)) {
                $ship["fname"]		=	$this->data["User"]["sfname"];
                $ship["lname"]		=	$this->data["User"]["slname"];
                $ship["address"]	=	$this->data["User"]["saddress"];
                $ship["country"]	=	$this->data["User"]["scountry"];
                $ship["city"]		=	$this->data["User"]["scity"];

                //$ship["state"]		=	$this->data["User"]["sstate"];
                if($this->data["User"]["scountry"] == 'US') {
                    $ship["state"] = $this->data["User"]["us_sstate"];
                }
                else {
                    $ship["state"]		=	$this->data["User"]["sstate"];
                    unset($this->data["User"]["sstate"]);
                }


                $ship["zip"]		=	$this->data["User"]["szip"];
                $ship["phone"]		=	$this->data["User"]["sphone"];
                $ship["fax"]		=	$this->data["User"]["sfax"];
                $ship["mobile"]		=	$this->data["User"]["smobile"];
                $ship["user_id"]	=	$id;
                $ship["addr_type"]	=	"Shipping";
                $this->User->save_address($ship);


                $bill["fname"]		=	$this->data["User"]["bfname"];
                $bill["lname"]		=	$this->data["User"]["blname"];
                $bill["address"]	=	$this->data["User"]["baddress"];
                $bill["country"]	=	$this->data["User"]["bcountry"];
                $bill["city"]		=	$this->data["User"]["bcity"];

                //$bill["state"]		=	$this->data["User"]["bstate"];
                if($this->data["User"]["bcountry"] == 'US') {
                    $bill["state"] = $this->data["User"]["us_bstate"];
                }
                else {
                    $bill["state"]		=	$this->data["User"]["bstate"];
                    unset($this->data["User"]["bstate"]);
                }

                $bill["zip"]		=	$this->data["User"]["bzip"];
                $bill["phone"]		=	$this->data["User"]["bphone"];
                $bill["fax"]		=	$this->data["User"]["bfax"];
                $bill["mobile"]		=	$this->data["User"]["bmobile"];
                $bill["user_id"]	=	$id;
                $bill["addr_type"]	=	"Billing";
                $this->User->save_address($bill);
                $this->Session->setFlash('The User has been Added!', 'default',array('class'=> 'success'));
               
                if($_POST["redirflag"]=='')
                $this->redirect(array('action'=>'index'));
                else
                $this->redirect(array('action'=>'../products/seluser'));  
            }

        }
        $this->layout = 'adm';
        $countrylist	=	$this->Country->find('list',array('fields'=>array('Country.country_iso_code_2','Country.country_name')));
        $this->set('countrylist', $countrylist);

        //Setting the US States dtails
        $us_cntrydet = $this->Country->find("Country.country_iso_code_2 ='US'");
        if(isset($us_cntrydet["Country"]["country_id"])) {
            $us_states	=	$this->Statecode->findAll("Statecode.country_id ='".$us_cntrydet["Country"]["country_id"]."'");
            $this->set('us_states', $us_states);
        }
        //Setting the US States dtails
    }

    // Add user by admin
     function adduser(){ 
            $this->__validateLoginStatus();
            $admsess	=	$this->Session->read('Admin');
            if($admsess["products"] <> 1){
                $this->redirect(array('controller' => 'admins', 'action' => 'index'));
                exit();
            }
            if (!empty($this->data)) {
                $password                         = $this->data["User"]["password"];
                $this->data["User"]["password"]   = md5($this->data["User"]["password"]);
                $this->data["User"]["usertype"]   = 'retail';
                $this->data["User"]["reg_status"] = 'R';
                $this->data["User"]["reg_date"]   = date('Y-m-d h:i:s');

                $this->User->save($this->data["User"]);
                $id	=	$this->User->id;

                if($id) {
                    $cnfg  =	Configure::read('Neutrino');
                    $this->Session->setFlash('User has been created successfully', 'default',array('class'=> 'success'));

                    
                    $subject 	= "Phone Order Registration Completed at ".$cnfg["site_name"];

                    $headers 	= "MIME-Version: 1.0\r\n";
                    $headers   .= "Reply-To: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";
                    $headers   .= "Return-Path: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";
                    $headers   .= "From: ".$cnfg["site_name"]."<".$cnfg["admin_email"].">\r\n";
                    $headers   .= "Organization: ".$cnfg["site_name"]."\r\n";
                    $headers   .= "Content-type: text/html; charset=iso-8859-1\r\n";

                    $pdt 	= 	$this->Cmspage->findByTitle('Registration confirm mail');
                    $path	=	"SiteLogo_disp.gif";
                    $mcont	=	"<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>
                                        <tr><td><a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'><img src='".FULL_BASE_URL. $cnfg["sitebasefolder"]."/app/webroot/".IMAGES_URL.$path."' border='0' width='300'></a></td></tr></table>";

                    $cnfg["site_name"]	= "<a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'>".$cnfg["site_name"]."</a>";

                    $logurl		= "Click <a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."/users/login' target='_blank'>here </a>to login";

                    $mailcontent	= $mcont.$pdt["Cmspage"]["content"];

                    $mailcontent 	= str_replace("[User_Name]", $this->data["User"]['uname'], $mailcontent);

                    $mailcontent 	= str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent);

                    $mailcontent 	= str_replace("[PASSWORD]", $password, $mailcontent);

                    $mailcontent 	= str_replace("[LOGIN_URL]", $logurl, $mailcontent);

                    $pdtad 		= $this->Cmspage->findByTitle('Registration intimation mail to admin');

                    $mailcontentad	=	$mcont.$pdtad["Cmspage"]["content"];

                    $mailcontentad 	= str_replace("[User_Name]", $this->data["User"]['uname'], $mailcontentad);

                    $mailcontentad 	= str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontentad);
                    $mailsent 		= mail($this->data["User"]['email'],$subject,$mailcontent,$headers);

                    $mailsent1 		= mail($cnfg["admin_email"],$subject,$mailcontentad,$headers); 
                }
                
            }

            $this->layout = 'ajax';
            
     }

    function register() {



        if (!empty($this->data)) {

            if($this->data["User"]["password"] <> $this->data["User"]["conpassword"]) {

                $this->Session->setFlash('Password Mismatch!', 'default',array('class'=> 'failure'));
                $this->redirect(array('controller'=>'users','action'=>'register'));

            } else {

                $user["password"]		=	md5($this->data["User"]["password"]);
            }

            //print_r($user["password"]);exit;

            $user["email"]		=	$this->data["User"]["email"];

            $user["uname"]		=	$this->data["User"]["uname"];

            $user["usertype"]   =   'retail';

            $user["reg_status"]	=   'R';

            $user["reg_date"]	=	date('Y-m-d h:i:s');

            //See if a user with that username exists

            $usse = $this->User->findByEmail($user["email"]);

            $ussn = $this->User->findByUname($user["uname"]);

            // Invalidate the field to trigger the HTML Helper's error messages

            if (!empty($ussn['User']['uname'])) {

                $this->Session->setFlash('Username Already Exists!', 'default',array('class'=> 'failure'));
                //$this->redirect(array('controller'=>'users','action'=>'register'));

                //exit;

            } elseif (!empty($usse['User']['uname'])) {

                $this->Session->setFlash('EmailAddress Already Exists!', 'default',array('class'=> 'failure'));

                //$this->redirect(array('controller'=>'users','action'=>'register'));

                //exit;

            }else {

                if($id = $this->User->save($user)) {

                    $cnfg 			=	Configure::read('Neutrino');

                    $this->Session->setFlash('Your registration has been completed successfully', 'default',array('class'=> 'success'));

                    $subject 		= "Registration complete at ".$cnfg["site_name"];

                    $headers 		= "MIME-Version: 1.0\r\n";

                    $headers        .= "Reply-To: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";

                    $headers        .= "Return-Path: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";

                    $headers 		.= "From: ".$cnfg["site_name"]."<".$cnfg["admin_email"].">\r\n";

                    $headers        .= "Organization: ".$cnfg["site_name"]."\r\n";

                    $headers 		.= "Content-type: text/html; charset=iso-8859-1\r\n";

                    $pdt 			= 	$this->Cmspage->findByTitle('Registration confirm mail');

                    $path			=	"SiteLogo_disp.gif";

                    $mcont			=	"<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>

		  <tr><td><a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'><img src='".FULL_BASE_URL. $cnfg["sitebasefolder"]."/app/webroot/".IMAGES_URL.$path."' border='0' width='300'></a></td></tr></table>";

                    $cnfg["site_name"]	= "<a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'>".$cnfg["site_name"]."</a>";

                    $logurl		= "Click <a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."/users/login' target='_blank'>here </a>to login";

                    $mailcontent	= $mcont.$pdt["Cmspage"]["content"];

                    $mailcontent 	= str_replace("[User_Name]", $user['uname'], $mailcontent);

                    $mailcontent 	= str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent);

                    $mailcontent 	= str_replace("[PASSWORD]", $this->data["User"]["password"], $mailcontent);

                    $mailcontent 	= str_replace("[LOGIN_URL]", $logurl, $mailcontent);

                    $pdtad 		= $this->Cmspage->findByTitle('Registration intimation mail to admin');

                    $mailcontentad	=	$mcont.$pdtad["Cmspage"]["content"];

                    $mailcontentad 	= str_replace("[User_Name]", $user['uname'], $mailcontentad);

                    $mailcontentad 	= str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontentad);

                    $mailsent 		= mail($user['email'],$subject,$mailcontent,$headers);

                    $mailsent1 		= mail($cnfg["admin_email"],$subject,$mailcontentad,$headers);

                }


                if($this->data["User"]["news_letter"]==1) {

                    $this->Newsletteruser->create($newsletteruser = array());

                    $newsletteruser["id"]	=	$this->User->id;

                    $newsletteruser["uname"]	=	$user["uname"];

                    $newsletteruser["email"]	=	$user["email"];

                    $newsletteruser["sub_date"]	=	date('Y-m-d h:i:s');

                    $newsletteruser["status "]	=	'Y';

                    $dups = $this->Newsletteruser->findByEmail(trim($user["email"]));

                    if(empty($dups['Newsletteruser']['email'])=== true)

                        $this->Newsletteruser->save($newsletteruser);

                    unset($newsletteruser);


                }
                else {

                    $this->Newsletteruser->create($newsletteruser = array());

                    $newsletteruser["id"]	=	$this->User->id;

                    $newsletteruser["uname"]	=	$user["uname"];

                    $newsletteruser["email"]	=	$user["email"];

                    $newsletteruser["sub_date"]	=	date('Y-m-d h:i:s');

                    $newsletteruser["status"]	=	'N';

                    $dups = $this->Newsletteruser->findByEmail(trim($user["email"]));

                    if (empty($dups['Newsletteruser']['email'])=== true)

                        $this->Newsletteruser->save($newsletteruser);

                    unset($newsletteruser);

                }
                $user['username']	=	$user['uname'];

                $user['password']	=	$this->data["User"]["conpassword"];

                unset($user['email'],$user['uname']);

                if(($user = $this->User->validateLogin($user)) == true) {
                    $this->Session->write('Userlog', $user);
                    $this->redirect(array('controller' =>'users','action'=>'myaccount'));
                }
            }
        }
      //  echo "<pre>";
      //  print_r($_SESSION);
        $countrylist	=	$this->Country->find('list',array('fields'=>array('Country.country_iso_code_2','Country.country_name')));
        $this->set('countrylist', $countrylist);
        $this->layout = 'default';

    }

    function edit($id=0) {

        if($id == 0) {

            $this->redirect(array('controller' => 'users','action'=>'index'));

            exit();

        }

        $this->__validateLoginStatus();

        $admsess	=	$this->Session->read('Admin');

        if($admsess["users"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();

        }

        $this->User->id = $id;

        $ship	=	array();

        $bill	=	array();

        if (!empty($this->data)) {

            $user["email"]		=	$this->data["User"]["email"];

            $user["uname"]		=	$this->data["User"]["uname"];

            $this->data["User"]["reg_date"]	=	date('Y-m-d h:i:s');

            if(isset($this->data["User"]["password"]) && !empty($this->data["User"]["password"])) {

                $new_pswd=$this->data["User"]["password"];

                $pswd_dups = $this->User->find('count', array('conditions' => array('User.id' => $id ,'User.password' =>  md5($this->data["User"]["password"]))));

                if($pswd_dups  > 0) {

                    $this->Session->setFlash('Password entered is same as existing password.Please provide a different password.', 'default',array('class'=> 'failure'));

                    $this->redirect(array('controller' => 'users','action'=>'edit/'.$id));

                    exit();

                } else {

                    $this->data["User"]["password"]=md5($this->data["User"]["password"]);

                    if(isset($_POST["notify"]) &&  !empty($_POST["notify"])) {

                        $cnfg 			=	Configure::read('Neutrino');

                        $subject 		= "Password reset at ".$cnfg["site_name"];

                        $headers 		= "From: ".$cnfg["site_name"]."<".$cnfg["admin_email"].">\r\n";

                        $headers 		.= "MIME-Version: 1.0\r\n";

                        $headers 		.= "Content-type: text/html; charset=iso-8859-1\r\n";

                        $pdt 			= 	$this->Cmspage->findByTitle('Forgot password mail');

                        $path			=	"SiteLogo_disp.gif";

                        $mcont			=	"<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>

					  <tr><td><a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'><img src='".FULL_BASE_URL. $cnfg["sitebasefolder"]."/app/webroot/".IMAGES_URL.$path."' border='0' width='300'></a></td></tr></table>";

                        $cnfg["site_name"]	=	"<a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'>".$cnfg["site_name"]."</a>";

                        $mailcontent	=	$mcont.$pdt["Cmspage"]["content"];

                        $mailcontent 	= str_replace("[User_Name]", $user["uname"], $mailcontent);

                        $mailcontent 	= str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent);

                        $mailcontent 	= str_replace("[PASSWORD]", $new_pswd, $mailcontent);

                        $mailsent 		= mail($user["email"],$subject,$mailcontent,$headers);

                    }

                }

            } else {

                $usr_pswd = $this->User->findById($id);

                $this->data["User"]["password"]= trim($usr_pswd["User"]["password"]);

            }

            //See if a user with that username exists

            $ussr = $this->User->findByEmail($user["email"]);

            // Invalidate the field to trigger the HTML Helper's error messages

            if (!empty($ussr['User']['uname']) && $ussr['User']['id'] <> $id) {

                $this->Session->setFlash('The Email Address Already exists.', 'default',array('class'=> 'failure'));

            }else {



                if($this->User->save($this->data)) {

                    $ship["fname"]		=	$this->data["User"]["sfname"];

                    $ship["fname"]		=	$this->data["User"]["sfname"];

                    $ship["lname"]		=	$this->data["User"]["slname"];

                    $ship["address"]	=	$this->data["User"]["saddress"];

                    $ship["country"]	=	$this->data["User"]["scountry"];

                    //$ship["state"]		=	$this->data["User"]["sstate"];

                    //echo "<pre>";
                    //print_r($this->data);
                    //echo "</pre>";
                    //exit();


                    if($this->data["User"]["scountry"] == 'US') {
                        $ship["state"] = $this->data["User"]["us_sstate"];
                    }
                    else {
                        $ship["state"]		=	$this->data["User"]["sstate"];
                        unset($this->data["User"]["us_sstate"]);
                    }

                    $ship["city"]		=	$this->data["User"]["scity"];

                    $ship["zip"]		=	$this->data["User"]["szip"];

                    $ship["phone"]		=	$this->data["User"]["sphone"];

                    $ship["fax"]		=	$this->data["User"]["sfax"];

                    $ship["mobile"]		=	$this->data["User"]["smobile"];

                    $ship["user_id"]	=	$id;

                    $ship["addr_type"]	=	"Shipping";

                    $this->User->save_address($ship);

                    $bill["fname"]		=	$this->data["User"]["bfname"];

                    $bill["lname"]		=	$this->data["User"]["blname"];

                    $bill["address"]	=	$this->data["User"]["baddress"];

                    $bill["country"]	=	$this->data["User"]["bcountry"];

                    //$bill["state"]		=	$this->data["User"]["bstate"];
                    if($this->data["User"]["bcountry"] == 'US') {
                        $bill["state"] = $this->data["User"]["us_bstate"];
                    }
                    else {
                        $bill["state"]		=	$this->data["User"]["bstate"];
                        unset($this->data["User"]["us_bstate"]);
                    }

                    $bill["city"]		=	$this->data["User"]["bcity"];

                    $bill["zip"]		=	$this->data["User"]["bzip"];

                    $bill["phone"]		=	$this->data["User"]["bphone"];

                    $bill["fax"]		=	$this->data["User"]["bfax"];

                    $bill["mobile"]		=	$this->data["User"]["bmobile"];

                    $bill["user_id"]	=	$id;

                    $bill["addr_type"]	=	"Billing";

                    $this->User->save_address($bill);

                    $this->Session->setFlash('User details has been edited Successfully.', 'default',array('class'=> 'success'));

                    $this->redirect(array('action'=>'index'));

                }

            }

        }else {

            $this->data = $this->User->read();

            $this->set('usrdet', $this->data );

            foreach($this->data ["UserAddress"] as $add) {

                if($add["addr_type"] 	== 	"Billing") {

                    $bill["fname"]		=	$add["fname"];

                    $bill["lname"]		=	$add["lname"];

                    $bill["address"]	=	$add["address"];

                    $bill["city"]		=	$add["city"];

                    $bill["state"]		=	$add["state"];

                    $bill["country"]	=	$add["country"];

                    $bill["zip"]		=	$add["zip"];

                    $bill["phone"]		=	$add["phone"];

                    $bill["fax"]		=	$add["fax"];

                    $bill["mobile"]		=	$add["mobile"];

                }

                if($add["addr_type"] 	== 	"Shipping") {

                    $ship["fname"]		=	$add["fname"];

                    $ship["lname"]		=	$add["lname"];

                    $ship["address"]	=	$add["address"];

                    $ship["city"]		=	$add["city"];

                    $ship["state"]		=	$add["state"];

                    $ship["country"]	=	$add["country"];

                    $ship["zip"]		=	$add["zip"];

                    $ship["phone"]		=	$add["phone"];

                    $ship["fax"]		=	$add["fax"];

                    $ship["mobile"]		=	$add["mobile"];

                }

            }

            $this->set('shipp', $ship);

            $this->set('bill', $bill);

        }

        $countrylist	=	$this->Country->find('list',array('fields'=>array('Country.country_iso_code_2','Country.country_name')));

        $this->set('countrylist', $countrylist);

        //Setting the US States dtails
        $us_cntrydet = $this->Country->find("Country.country_iso_code_2 ='US'");
        if(isset($us_cntrydet["Country"]["country_id"])) {
            $us_states	=	$this->Statecode->findAll("Statecode.country_id ='".$us_cntrydet["Country"]["country_id"]."'");
            $this->set('us_states', $us_states);
        }
        //Setting the US States dtails

        $this->layout = 'adm';

    }

    function delete($id) {

        $this->__validateLoginStatus();

        $admsess	=	$this->Session->read('Admin');

        if($admsess["users"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();

        }

        $this->User->delete_user($id);

        $this->Session->setFlash('User has been deleted Successfully.', 'default',array('class'=> 'success'));

        $this->redirect('index');

    }

    public function fblogin()
    {
        $this->autoRender = false;
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }
        FacebookSession::setDefaultApplication(FACEBOOK_APP_ID, FACEBOOK_APP_SECRET);
        $helper = new FacebookRedirectLoginHelper(FACEBOOK_REDIRECT_URI);
        $url = $helper->getLoginUrl(array('email'));
        $this->redirect($url);
    }
    
    public function fb_login()
    {
        $this->layout = 'ajax'; 
        FacebookSession::setDefaultApplication(FACEBOOK_APP_ID, FACEBOOK_APP_SECRET);
        $helper = new FacebookRedirectLoginHelper(FACEBOOK_REDIRECT_URI);
        $session = $helper->getSessionFromRedirect();
    
        if(isset($_SESSION['token'])){
            $session = new FacebookSession($_SESSION['token']);
            try{
                $session->validate(FACEBOOK_APP_ID, FACEBOOK_APP_SECRET);
            }catch(FacebookAuthorizationException $e){
                echo $e->getMessage();
            }
        }
    
        $data = array();
        $fb_data = array();
    
        if(isset($session)){
            $_SESSION['token'] = $session->getToken();
            $request = new FacebookRequest($session, 'GET', '/me');
            $response = $request->execute();
            $graph = $response->getGraphObject(GraphUser::className());
    
            $fb_data = $graph->asArray();
            $id = $graph->getId();
            $image = "https://graph.facebook.com/".$id."/picture?width=100";
                
            if( !empty( $fb_data )){
                $result = $this->User->findByEmail( $fb_data['email'] );
                if(!empty( $result )){
                    if($this->Auth->login($result['User'])){
                        $this->Session->setFlash(FACEBOOK_LOGIN_SUCCESS, 'default', array( 'class' => 'message success'), 'success' );
                        $this->redirect(BASE_PATH);
                    }else{
                        $this->Session->setFlash(FACEBOOK_LOGIN_FAILURE, 'default', array( 'class' => 'message error'), 'error' );
                        $this->redirect(BASE_PATH.'login');
                    }
                        
                }else{
                    $data['email'] = $fb_data['email'];
                    $data['name'] = $fb_data['first_name'];
                    $data['social_id'] = $fb_data['id'];
                    $data['picture'] = $image;
                    $data['uuid'] = String::uuid ();
                    $this->User->save( $data );
                    if($this->User->save( $data )){
                        $data['id'] = $this->User->getLastInsertID();
                        if($this->Auth->login($data)){
                            $this->Session->setFlash(FACEBOOK_LOGIN_SUCCESS, 'default', array( 'class' => 'message success'), 'success' );
                            $this->redirect(BASE_PATH);
                        }else{
                            $this->Session->setFlash(FACEBOOK_LOGIN_FAILURE, 'default', array( 'class' => 'message error'), 'error' );
                            $this->redirect(BASE_PATH.'index');
                        }
    
                    }else{
                        $this->Session->setFlash(FACEBOOK_LOGIN_FAILURE, 'default', array( 'class' => 'message error'), 'error' );
                        $this->redirect(BASE_PATH.'index');
                    }
                }
    
    
    
    
            }else{
                $this->Session->setFlash(FACEBOOK_LOGIN_FAILURE, 'default', array( 'class' => 'message error'), 'error' );
                $this->redirect(BASE_PATH.'index');
            }
                
                
        }
    }


    function login($ulg='n') {
        //Facebook Setting
        $facebookKeys='';
        if($this->Session->check('facebookKey')) {
            $facebookKeys=$this->Session->read('facebookKey');
           
        }
        $this->set('facebookKey', $facebookKeys);
        $this->set('fbLogin','Y');

        App::import('Vendor', 'facebook/facebook.php');
//print_r( $facebookKeys);
        $appId = $facebookKeys['facebook_app_id']; //Facebook App ID
        $appSecret =$facebookKeys['facebook_app_secret']; // Facebook App Secret
        $homeurl = 'http://localhost/printlogic/users/login';  //return to home
        $fbPermissions = 'email';

        $config = array(
          'Facebook' => array(
                'appId' => $appId,
                'secret' => $appSecret,
           )
        );

        /*$facebook = new Facebook(array(
          'appId'  => $appId,
          'secret' => $appSecret
        ));
        $fbuser = $facebook->getUser();
        print_r($fbuser);*/

        // $fb = new Facebook\Facebook([
        //       'app_id' => $facebookKey['facebook_app_id'], // Replace {app-id} with your app id
        //       'app_secret' => $facebookKey['facebook_app_secret'],
        //       'default_graph_version' => 'v2.2',
        //       ]);

        //     $helper = $fb->getRedirectLoginHelper();

        // $permissions = ['email']; // Optional permissions
        // $loginUrl = $helper->getLoginUrl('https://example.com/fb-callback.php', $permissions);

        // $icon =  '<a href="' . htmlspecialchars($loginUrl) . '">Log in with Facebook!</a>';
        //Facebook Setting Ends
        
        //Twitter Setting
        $twitterKeys='';
        if($this->Session->check('twitterKey')) {
            $twitterKeys=$this->Session->read('twitterKey');
            
        }
        
        $this->set('twitterKey', $twitterKeys);
        //Twitter Setting Ends
        
        //print_r($facebookKeys); 
        $this->data['Users']	=	$_POST;

        if(empty($this->data['Users']) == false) {

            if(($user = $this->User->validateLogin($this->data['Users'])) == true) {

                if($this->Session->check('Coupon') == true) {
                    $this->Session->delete('Coupon');
                }

                $this->Session->write('Userlog', $user);

                //  $this->Session->setFlash('You\'ve successfully logged in.');
                //$this->History->goBack(4);

              if($this->Session->read('logurl')!=''){
                  $url = $this->Session->read('logurl');
                  $this->Session->write('logurl','');
                  header('location:'.$url);
                  exit;
              }
                
                $this->redirect(array('controller' => 'pages', 'action' => 'display'));

                exit();

            }

            else {

                $this->Session->setFlash('Sorry, Invalid Username / Password.', 'default',array('class'=> 'failure'));

            }

        }else {

            if($this->Session->check('Userlog') == true) {

                $this->redirect(array('controller' => 'pages', 'action' => 'display'));

                exit();

            }

        }

        $this->set('ulog',$ulg);

        //$this->layout = 'user_log';

    }



    function fbregister() { // Login with FB

        //print_r($_GET); exit;
      
        $this->data['Users']	=	$_GET;
        if(empty($this->data['Users']) == false) {
            // User Facebook Id
            $data['user_id'] = $this->data['Users']['user_fbid'];
            if(($user = $this->User->validateSocialLogin($data))) {  //  if user exist make him login
                $this->Session->write('Userlog', $user);

                echo '1';
            } else {
                //register
                $userData["id"]  = '';
                
                $userData["email"]  = $this->data["Users"]["user_email"];

                $username = $this->data["Users"]["user_fname"];

                $username .= (!empty($this->data["Users"]["user_middle_name"]) && $this->data["Users"]["user_middle_name"]!='undefined') ? ' '.$this->data["Users"]["user_middle_name"] : '';

                $username .= (!empty($this->data["Users"]["user_lname"]) && $this->data["Users"]["user_lname"]!='undefined') ? ' '.$this->data["Users"]["user_lname"] : '';

                $userData["uname"]  = $username;

                $userData["usertype"]   = 'retail';

                $userData["reg_status"] = 'R';

                $userData["reg_date"]= date('Y-m-d h:i:s');

                $userData["social_user_id"]	= $this->data["Users"]["user_fbid"];
                $id = $this->User->save_userSocial($userData);

                if(($user = $this->User->validateSocialLogin($data))) {  //  if user exist make him login

                    $this->Session->write('Userlog', $user);

                    echo '1';

                } else {
                    echo '0';
                }
                 
                
            }
        } else {
            echo '0';
        }

    
    
    //----------ajax--------------//
    Configure::write('debug', 0);
    $this->autoRender = false;
    exit;
    
    } // End Function

    function twitregister() { // Login with Twitter - callback
        $oauth_token = $this->params['url']['oauth_token'];
        $oauth_vertifier = $this->params['url']['oauth_verifier'];
        $this->Twitter->authorizeTwitterUser($oauth_token, $oauth_vertifier);
        $user = $this->Twitter->getTwitterUser(true);
        $this->Twitter->logoutTwitterUser();
        //echo '<pre>'; print_r($user['profile']); echo '</pre>';
        
        $this->data['Users']	=	$user['profile'];

        if(empty($this->data['Users']) == false) {
            // User Facebook Id
            $data['user_id'] = $this->data['Users']['id'];
            if(($user = $this->User->validateSocialLogin($data))) {  //  if user exist make him login
                $this->Session->write('Userlog', $user);

                
            } else {
                //register
                $userData["id"]  = '';

                $userData["email"]  = $this->data["Users"]["user_email"];

                $username = $this->data["Users"]["screen_name"];

                $userData["uname"]  = $username;

                $userData["usertype"]   = 'retail';

                $userData["reg_status"] = 'R';

                $userData["reg_date"]= date('Y-m-d h:i:s');

                $userData["social_user_id"]	= $this->data["Users"]["id"];

                $id = $this->User->save_userSocial($userData);

                if(($user = $this->User->validateSocialLogin($data))) {  //  if user exist make him login
                    $this->Session->write('Userlog', $user);
                }
            }
        } 

        if($this->Session->check('Userlog') == true) {
            $this->redirect(array('controller' => 'pages', 'action' => 'display'));
         exit();

         } else {
             $this->Session->setFlash('Sorry, unexpected error. Please try again later.', 'default',array('class'=> 'failure'));
             $this->redirect(array('controller' => 'users', 'action' => 'login'));
             exit();
         }

    //----------ajax--------------//
    Configure::write('debug', 0);
    $this->autoRender = false;
    exit;
        
        

    } // End Function



    function twitterSignIn() { // Login with Twitter
        $cnfg 				=	Configure::read('Neutrino');        
        $callbackUrl='http://'.$_SERVER['HTTP_HOST'].$cnfg["sitebasefolder"].'/users/twitregister';

       if($this->Session->check('twitterKey')) {
            $twitterKeys=$this->Session->read('twitterKey');

        }
       //$this->Twitter->setup($twitterKeys['twitter_consumer_key'], $twitterKeys['twitter_consumer_secret'], true);
       $this->Twitter->setupApp($twitterKeys['twitter_consumer_key'], $twitterKeys['twitter_consumer_secret']);
       $this->Twitter->connectApp($callbackUrl);
     //  $this->Twitter->signIn($callbackUrl);

    //----------ajax--------------//
    Configure::write('debug', 0);
    $this->autoRender = false;
    exit;

    } // End Function

    function logout() {
        
        $this->Session->destroy('userlog');
        $facebookKeys['facebook_app_id'] = '';
        $facebookKeys['facebook_app_secret'] = '';
        // $this->Session->setFlash(__('You\'ve successfully logged out.'));

        //	$this->redirect(array('controller' => 'users', 'action' => 'login'));

        $this->redirect(array('controller' => 'pages', 'action' => 'display'));

        exit();

    }



    ############# Function to forgot password.....................................

    function forgotpword() {

        $this->Setting->load();

        $cnfg 		= Configure::read('Neutrino');

        //print_r($cnfg);exit;

        if($_SERVER['REQUEST_METHOD']=="POST") {

            $chk	=	$this->User->findAll("uname='".$_POST["username"]."' AND email='".$_POST["email"]."'");

            if(empty($chk)==false) {

                $pword	=	time().$_POST["username"];

                $this->User->pwordset($_POST["username"],$pword);

                /*$this->Email->template = 'email/confirm';

				// You can use customised thmls or the default ones you setup at the start 

				$data["password"]	=	$pword;

				$this->set('data', $data); 

				$this->Email->to 		=	$_POST["email"]; 

				$this->Email->subject 	=	'your new password';

				$this->Email->from		=	$cnfg['admin_email']; 

				$this->Email->fromName	=	$cnfg['site_name']; 

				$this->Email->smtpUserName	=	$cnfg['smtpUserName']; 

				$this->Email->smtpPassword	=	$cnfg['smtpPassword']; 

				$this->Email->smtpHostNames	=	$cnfg['smtpHostNames']; 

		   //     $this->Email->attach($fully_qualified_filename, optionally $new_name_when_attached); 

				// You can attach as many files as you like. 

				$result = $this->Email->send(); */

                $cnfg 			=	Configure::read('Neutrino');

                $subject 		= "New Password at ".$cnfg["site_name"];

                $headers 		= "MIME-Version: 1.0\r\n";

                $headers        .= "Reply-To: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";

                $headers        .= "Return-Path: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";

                $headers 		.= "From: ".$cnfg["site_name"]."<".$cnfg["admin_email"].">\r\n";

                $headers        .= "Organization: ".$cnfg["site_name"]."\r\n";

                $headers 		.= "Content-type: text/html; charset=iso-8859-1\r\n";

                $pdt 			= 	$this->Cmspage->findByTitle('Forgot password mail');

                $path			=	"SiteLogo_disp.gif";

                $mcont			=	"<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>

	  <tr><td><a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'><img src='".FULL_BASE_URL. $cnfg["sitebasefolder"]."/app/webroot/".IMAGES_URL.$path."' border='0' width='300'></a></td></tr></table>";

                $cnfg["site_name"]	=	"<a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'>".$cnfg["site_name"]."</a>";

                $mailcontent	=	$mcont.$pdt["Cmspage"]["content"];

                $mailcontent 	= str_replace("[User_Name]", $_POST["username"], $mailcontent);

                $mailcontent 	= str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent);

                $mailcontent 	= str_replace("[PASSWORD]", $pword, $mailcontent);

                //echo $mailcontent; exit;

                $mailsent 		= mail($_POST["email"],$subject,$mailcontent,$headers);

                if($mailsent	==	true) {

                    $this->Session->setFlash('Your Password has been reset and sent to your email address.', 'default',array('class'=> 'success'));

                }

                $this->redirect('/index.php');

                exit;

            }else {

                $this->Session->setFlash('You have entered an invalid username or email address!', 'default',array('class'=> 'failure'));

            }

        }

        //exit;

    }

    ##################### My Account Page###########################

    function myaccount() {

        $this->__validateLoginStatus('U');

        $sus	=	$this->Session->read('Userlog');
        if(isset($sus) && empty($sus)===false){     
          $this->set('sus', $sus);
          $user_id     =   $sus["id"];
          $citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','user_id' => $sus['id'])));  
        }  
        else {
          $this->set('sus', ''); 
          $sessid   =   $this->Session->id();
          $citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','sess_id' => $sessid))); 
        }
        $this->set('cartcount', count($citem));

        $this->set('userid', $user_id);
        $curr_email=$this->User->findById($user_id);

        $newsletter = $this->Newsletteruser->find('first', array('conditions' => array('Newsletteruser.email' => trim($curr_email['User']['email']))));

        if(isset($newsletter) && empty($newsletter)===false) {

            $this->set('status',$newsletter["Newsletteruser"]["status"]);

            $this->set('newsid',$newsletter["Newsletteruser"]["id"]);

        }

        if($_SERVER['REQUEST_METHOD']=='POST') {



            $this->Newsletteruser->id = $_POST['hidnewsid'];

            $this->Newsletteruser->saveField('status',$_POST['hidnews']);

            if($_POST['hidnews']=='Y')

                $msg='You have Successfully Subscribed for Newsletters!';

            else  if($_POST['hidnews']=='N')

                $msg='You have Successfully Unsubscribed for Newsletters!';

            $this->Session->setFlash($msg, 'default',array('class'=> 'success'));


            $this->redirect(array('controller' => 'users', 'action' => 'myaccount'));

            exit();

        }

    }

    ##################### Function to change password##################



    function chngpword($uid,$back='') {

        $this->__validateLoginStatus('U');

        $sus		=	$this->Session->read('Userlog');
        if(isset($sus) && empty($sus)===false){     
          $this->set('sus', $sus);
          $citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','user_id' => $sus['id'])));  
        }  
        else {
          $this->set('sus', ''); 
          $sessid   =   $this->Session->id();
          $citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','sess_id' => $sessid))); 
        }
        $this->set('cartcount', count($citem));
        $user_id	=	$sus["id"];

        if($_SERVER['REQUEST_METHOD']=="POST") {

            $flag		=	true;
            $udet		=	$this->User->findById($user_id);
            $orpword	=	$udet["User"]["password"];
            $msg ='';

            if($_POST["email"] <> '' ) {

                $flag=true;
                $msg = " Your Profile has been updated Successfully! <br>";
                $ussr = $this->User->findById($user_id);               

                $this->User->editemail($user_id,$_POST["email"],$ussr['User']['uname'],$_POST["uphone"]);

                if($ussr['User']['email'] != $_POST["email"]) {
                    $msg = " Your Profile has been updated Successfully! <br>";
                    $this->Session->write('Userlog.email', $_POST["email"]);
                                   
                    $this->Newsletteruser->create($newsletteruser = array());
                    $newsletteruser["id"]       =       $user_id;
                    $newsletteruser["uname"]	=	$ussr["User"]["uname"];
                    $newsletteruser["email"]	=	$_POST["email"];
                    $newsletteruser["sub_date"]	=	date("Y-m-d h:i:s");
                    $newsletteruser["status "]	=	"Y";                   

                    $dups = $this->Newsletteruser->findByEmail($ussr["User"]["email"]);

                    if(empty($dups['Newsletteruser']['email'])=== true)
                        $this->Newsletteruser->save($newsletteruser);
                    unset($newsletteruser);

                    if($back == 'back') {
                        $this->redirect(array('controller' => 'userAddresses', 'action' => 'show_bill_ship'));
                        exit;
                    } 
                }
                
                
                if($_POST["npword"] <> '') {
                
                	if(md5($_POST["cpword"]) <> $orpword) {
                
                		$msg	=	'<font color=red>The current password you entered is wrong!</font><br>';
                
                		$flag	=	false;
                
                	}
              

                    if($flag === true) {

                        if($this->User->chngpword($user_id,$_POST["npword"])) {

                            $msg  =	'Your password has been changed successfully!';

                        }

                    }
                }


                if($msg) $this->Session->setFlash($msg, 'default',array('class'=> 'success'));

                $this->redirect(array('controller' => 'users', 'action' => 'chngpword/'.$user_id));

                exit;

            }

        }

        $usdet		=	$this->User->findById($user_id);

        $this->set('email',$usdet["User"]["email"]);
        $this->set('uphone',$usdet["User"]["uphone"]);
        $this->set('uname',$usdet["User"]["uname"]);

        /*if($back == 'back') {
            $this->redirect(array('controller' => 'userAddresses', 'action' => 'show_bill_ship'));
            exit;
        } 
*/
    }





    function checkoutlogin() {

        $this->data['Users']	=	$_POST;

        if(empty($this->data['Users']) == false) {

            if(($user = $this->User->validateLogin($this->data['Users'])) == true) {

                $this->Session->write('Userlog', $user);

                //  $this->Session->setFlash('You\'ve successfully logged in.');

                // $this->redirect(array('controller' => 'userAddresses', 'action' => 'show_bill_ship'));

                $this->redirect(array('controller' => 'carts', 'action' => 'show'));

                exit();

            }

            else {

                $this->Session->setFlash('Sorry, Invalid Username / Password.', 'default',array('class'=> 'failure'));

            }

        }else {

            if($this->Session->check('Userlog') == true) {

                $this->redirect(array('controller' => 'userAddresses', 'action' => 'show_bill_ship'));

                exit();

            }

        }



    }

    function guestuser() {

        $guest_username=$this->User->getGuestUsername();

        $guest_password=md5($guest_username);

        $this->Session->write('guestuser', $guest_username);

        $this->Session->write('guestpswd', $guest_password);

        $user['uname']	=	$guest_username;

        $user['password']	=	$guest_password;

        $user["reg_date"]	=	date('Y-m-d h:i:s');

        $user['usertype']	=	'retail';

        $user['reg_status'] =	'G';

        $this->User->save($user);

        if(($user = $this->User->validateGuestLogin($user)) == true) {

            $this->Session->write('Userlog', $user);

            $this->redirect(array('controller' => 'userAddresses', 'action' => 'show_bill_ship'));

            exit();

        }

    }



    function reports() {


        $this->__validateLoginStatus();
        $user_min_date=explode(" ",$this->User->getDates_reg("min"));

        $user_max_date=explode(" ",$this->User->getDates_reg("max"));

        $this->set('dflt_mindate', $user_min_date[0]); //Setting the max date for the calendar...

        $this->set('dflt_maxdate', $user_max_date[0]); //Setting the max date for the calendar...



        if(isset($_POST["user_fdate"]) &&  isset($_POST["user_tdate"]) && $_POST["user_fdate"]<>'' && $_POST["user_tdate"]<>'') {

            $frmdate=$_POST["user_fdate"];

            $todate=$_POST["user_tdate"];

        }

        else if(isset($this->passedArgs["frmdate"]) && isset($this->passedArgs["todate"]) &&

                $this->passedArgs["frmdate"] <> '' &&  $this->passedArgs["todate"] <> '') {

            $frmdate=$this->passedArgs["frmdate"];

            $todate= $this->passedArgs["todate"];

        }

        else {

            $frmdate=$user_min_date[0];

            $todate=$user_max_date[0];

        }

        //-----------------If no data is present---------------//
        if($frmdate == '' && $todate == '') {
            $frmdate=date("m-d-Y");
            $todate=date("m-d-Y",strtotime("+1 month",time()));
        }

        //$cttbl=$this->Report->getTableName("users");

        $sdate=explode('-',$frmdate);

        $srch_fdate=$sdate[2].'-'.$sdate[0].'-'.$sdate[1];

        $tdate=explode('-',$todate);

        $srch_tdate=$tdate[2].'-'.$tdate[0].'-'.$tdate[1];



        $cttb2=$this->User->getTableName("user_addresses");
        $cttb3=$this->User->getTableName("orders");

        $this->paginate = array(

                'conditions' => array("DATE_FORMAT(User.reg_date,'%Y-%m-%d') >= '".$srch_fdate."' AND  DATE_FORMAT(User.reg_date,'%Y-%m-%d') <= '".$srch_tdate."' AND User.id <> 0"),

                'fields' => array("User.uname,User.email,DATE_FORMAT(User.reg_date,'%m-%d-%Y')as reg_date, uadd.addr_type, uadd.fname, uadd.lname, uadd.address, uadd.city, uadd.state, uadd.country, uadd.zip, uadd.phone, uadd.fax, uadd.mobile, COUNT(uordr.id) AS ordercount, SUM(uordr.total_price) AS totprice"),

                'order' => '',

                'limit' => $this->paginate["limit"],

                'joins' => array(

                        array(

                                'table' => $cttb2,

                                'alias' => 'uadd',

                                'type' => 'LEFT',

                                'conditions'=> array("User.id = uadd.user_id AND uadd.addr_type LIKE 'Billing'")

                        ),

                        array(

                                'table' => $cttb3,

                                'alias' => 'uordr',

                                'type' => 'LEFT',

                                'conditions'=> array('User.id = uordr.user_id AND uordr.order_status_id >= 6')

                        )

                ),

                'group' => 'User.id',

                'passit' => $this->passedArgs

        );


        $reportdet = $this->paginate('User');
        $this->passedArgs['limit']=$this->paginate["limit"];
        $this->set('passedarg',$this->passedArgs);
        $this->set('reportdet',$reportdet);



        //echo "<pre>";

        //print_r($reportdet);

        //echo "<pre>";

        //exit();





        $this->set('mindate', $frmdate);

        $this->set('maxdate', $todate);



        $this->layout = 'adm';



    }



    function userxls($frmdate='',$todate='') {

        /*

		$cttbl=$this->Report->getTableName("users");

		    $sdate=explode('-',$frmdate);

			$srch_fdate=$sdate[2].'-'.$sdate[0].'-'.$sdate[1];

			$tdate=explode('-',$todate);

			$srch_tdate=$tdate[2].'-'.$tdate[0].'-'.$tdate[1];

        */



        $cttb2=$this->User->getTableName("user_addresses");

        $cttb3=$this->User->getTableName("orders");

		    $sdate=explode('-',$frmdate);
			$srch_fdate=$sdate[2].'-'.$sdate[0].'-'.$sdate[1];
			$tdate=explode('-',$todate);
			$srch_tdate=$tdate[2].'-'.$tdate[0].'-'.$tdate[1];
                        
        $qry = array(

                'conditions' => array("DATE_FORMAT(User.reg_date,'%Y-%m-%d')>= '".$srch_fdate."' AND  
			DATE_FORMAT(User.reg_date,'%Y-%m-%d') <= '".$srch_tdate."'"),

                'fields' => array("User.uname,User.email,DATE_FORMAT(User.reg_date,'%m-%d-%Y')as reg_date, uadd.addr_type, uadd.fname, uadd.lname, uadd.address, uadd.city, uadd.state, uadd.country, uadd.zip, uadd.phone, uadd.fax, uadd.mobile, COUNT(uordr.id) AS ordercount, SUM(uordr.total_price) AS totprice"),

                'order' => '',

                'limit' => '',

                'joins' => array(

                        array(

                                'table' => $cttb2,

                                'alias' => 'uadd',

                                'type' => 'LEFT',

                                'conditions'=> array("User.id = uadd.user_id AND uadd.addr_type LIKE 'Billing'")

                        ),

                        array(

                                'table' => $cttb3,

                                'alias' => 'uordr',

                                'type' => 'LEFT',

                                'conditions'=> array('User.id = uordr.user_id AND uordr.order_status_id >= 6')

                        )

                ),

                'group' => 'User.id',

                'passit' => ''

        );

        $tot_cnt=count($this->User->find('all', $qry));







        $this->paginate = array(

                'conditions' => array("DATE_FORMAT(User.reg_date,'%Y-%m-%d')>= '".$srch_fdate."' AND  
			DATE_FORMAT(User.reg_date,'%Y-%m-%d') <= '".$srch_tdate."'"),

                'fields' => array("User.uname,User.email,DATE_FORMAT(User.reg_date,'%m-%d-%Y')as reg_date, uadd.addr_type, uadd.fname, uadd.lname, uadd.address, uadd.city, uadd.state, uadd.country, uadd.zip, uadd.phone, uadd.fax, uadd.mobile, COUNT(uordr.id) AS ordercount, SUM(uordr.total_price) AS totprice"),

                'order' => '',

                'limit' => $tot_cnt,

                'joins' => array(

                        array(

                                'table' => $cttb2,

                                'alias' => 'uadd',

                                'type' => 'LEFT',

                                'conditions'=> array("User.id = uadd.user_id AND uadd.addr_type LIKE 'Billing'")

                        ),

                        array(

                                'table' => $cttb3,

                                'alias' => 'uordr',

                                'type' => 'LEFT',

                                'conditions'=> array('User.id = uordr.user_id AND uordr.order_status_id >= 6')

                        )

                ),

                'group' => 'User.id',

                'passit' => ''

        );





        $data = $this->paginate('User');
        
        $this->set('data', $data);

        $this->layout = 'csvexp';

    }





    function usercsv($frmdate='',$todate='') {

        //$cttbl=$this->Report->getTableName("users");

        /*

		    $sdate=explode('-',$frmdate);

			$srch_fdate=$sdate[2].'-'.$sdate[0].'-'.$sdate[1];

			$tdate=explode('-',$todate);

			$srch_tdate=$tdate[2].'-'.$tdate[0].'-'.$tdate[1];

						

			

        */

        $cttb2=$this->User->getTableName("user_addresses");

        $cttb3=$this->User->getTableName("orders");

		    $sdate=explode('-',$frmdate);
			$srch_fdate=$sdate[2].'-'.$sdate[0].'-'.$sdate[1];
			$tdate=explode('-',$todate);
			$srch_tdate=$tdate[2].'-'.$tdate[0].'-'.$tdate[1];
                        
        $qry = array(

                'conditions' => array("DATE_FORMAT(User.reg_date,'%Y-%m-%d')>= '".$srch_fdate."' AND  
			DATE_FORMAT(User.reg_date,'%Y-%m-%d') <= '".$srch_tdate."'"),

                'fields' => array("User.uname,User.email,DATE_FORMAT(User.reg_date,'%m-%d-%Y')as reg_date, uadd.addr_type, uadd.fname, uadd.lname, uadd.address, uadd.city, uadd.state, uadd.country, uadd.zip, uadd.phone, uadd.fax, uadd.mobile, COUNT(uordr.id) AS ordercount, SUM(uordr.total_price) AS totprice"),

                'order' => '',

                'limit' => '',

                'joins' => array(

                        array(

                                'table' => $cttb2,

                                'alias' => 'uadd',

                                'type' => 'LEFT',

                                'conditions'=> array("User.id = uadd.user_id AND uadd.addr_type LIKE 'Billing'")

                        ),

                        array(

                                'table' => $cttb3,

                                'alias' => 'uordr',

                                'type' => 'LEFT',

                                'conditions'=> array('User.id = uordr.user_id AND uordr.order_status_id >= 6')

                        )

                ),


                'group' => 'User.id',

                'passit' => ''

        );

        $tot_cnt=count($this->User->find('all', $qry));







        $this->paginate = array(

                'conditions' => array("DATE_FORMAT(User.reg_date,'%Y-%m-%d')>= '".$srch_fdate."' AND  
			DATE_FORMAT(User.reg_date,'%Y-%m-%d') <= '".$srch_tdate."'"),

                'fields' => array("User.uname,User.email,DATE_FORMAT(User.reg_date,'%m-%d-%Y')as reg_date, uadd.addr_type, uadd.fname, uadd.lname, uadd.address, uadd.city, uadd.state, uadd.country, uadd.zip, uadd.phone, uadd.fax, uadd.mobile, COUNT(uordr.id) AS ordercount, SUM(uordr.total_price) AS totprice"),

                'order' => '',

                'limit' => $tot_cnt,

                'joins' => array(

                        array(

                                'table' => $cttb2,

                                'alias' => 'uadd',

                                'type' => 'LEFT',

                                'conditions'=> array("User.id = uadd.user_id AND uadd.addr_type LIKE 'Billing'")

                        ),

                        array(

                                'table' => $cttb3,

                                'alias' => 'uordr',

                                'type' => 'LEFT',

                                'conditions'=> array('User.id = uordr.user_id AND uordr.order_status_id >= 6')

                        )

                ),

                'group' => 'User.id',

                'passit' => ''

        );



        $data = $this->paginate('User');


        $this->set('data', $data);

        $this->layout = 'csvexp';
    }

    //-----------------------------Ajax email validation------------------//
    function ajaxemail() {
        extract($_POST);
        $useremail = $this->User->findByEmail($email);
        $username = $this->User->findByuname($uname);
        if($useremail && !$username) echo 1;
        elseif(!$useremail && $username) echo 2;
        elseif($useremail && $username) echo 3;
        elseif(!$useremail && !$username) echo 4;
        //-----------ajax features--------------//
        Configure::write('debug', 0);
        $this->autoRender = false;
        exit;
    }

    function checkcaptcha(){
        
        
        $code = $this->Session->read('captchcode');
        
        if(isset($_REQUEST["captcha"])&&$_REQUEST["captcha"]!=""&&$code==$_REQUEST["captcha"])
        {
           echo 'success';
        }
        else
        {
            echo "failure";
        }
        exit();
    }

    function createcaptcha(){
        session_start();
        $code=rand(1000,9999);
       // $_SESSION["code"]=$code;
        $this->Session->write('captchcode', $code);
        $this->set('captchcode',$code);
       
        $im = imagecreatetruecolor(50, 24);
        $bg = imagecolorallocate($im, 22, 86, 165);
        $fg = imagecolorallocate($im, 255, 255, 255);
        imagefill($im, 0, 0, $bg);
        imagestring($im, 5, 5, 5,  $code, $fg);
        header("Cache-Control: no-cache, must-revalidate");
        header('Content-type: image/png');
        imagepng($im);
        imagedestroy($im);
        exit;
    }

}

?>