<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2011 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts PrintLogic                    |
// +----------------------------------------------------------------------+
// | Authors: Aswin<aswin.j@armiasystems.com>             		          |
// +----------------------------------------------------------------------+ 

class Customimage extends AppModel
{
	var $Db;
	var $name 	= 'Customimage';
	var $uses  	= array('Coordinate','Imageregion','Savedimage','Productimage', 'Productdetail', 'Category', 'Itemcoordinate', 'User', 'ItemcoordinateSession','Customimagetypes'); 
	
	function __construct(){
		parent::__construct();
		$this->Db = ConnectionManager::getDataSource($this->useDbConfig);
	}
	
	function getTableName($tablename){
		$tblnme = $this->Db->fullTableName($tablename);			

		$tblnme=trim(str_replace('`','',$tblnme));		

		return $tblnme;
	}
	
	function updateProduct($productdetailID, $imgType, $fileName){
		$prodimgTbl = $this->getTableName('productimages');
		$proddetailTbl = $this->getTableName('productdetails');
		
		$imgType == "Front" ? $front = "Y" : $front = "N";
		$prod = $this->query("SELECT product_id FROM $proddetailTbl WHERE id = $productdetailID");
		
		$this->query("INSERT INTO $prodimgTbl(product_id,imagename,default_img) VALUES({$prod[0][$proddetailTbl]['product_id']},'$fileName','$front')");
		
		if($front == "Y") $this->query("UPDATE $proddetailTbl SET pdctfile = '$fileName' WHERE id = $productdetailID");
	}
	
        function getImages($product_id,$type)
        {
            $coord = $this->getTableName('customimages');
            $op = $this->query("SELECT CRD.* FROM $coord AS CRD WHERE CRD.type = '$type' AND CRD.productdetails_id = $product_id" );
	
            return $op;
        }






        function getData($imgType,$productdetailID){
		$coord = $this->getTableName('coordinates');
		$region = $this->getTableName('imageregions');
		$options['joins'] = array(
								array(
									'table' => $region,
									'alias' => 'Imageregion',
									'type' => 'LEFT',
									'conditions' => array(
										'Imageregion.customimages_id = Customimage.id',
									)
								),
								array(
									'table' => $coord,
									'alias' => 'Coordinate',
									'type' => 'LEFT',
									'conditions' => array(
										'Coordinate.id = Imageregion.coordinates_id',
									)
								)
							);

		$op = $this->find('first',array('conditions' => array("type" => "$imgType", "productdetails_id" => "$productdetailID"),'fields' => array('Customimage.*', 'Coordinate.*'),"joins" => $options['joins']));
		//print_r($op);exit;
		return $op;
	}
	
	function updatecoords($editID,$top,$left){
		$coords1 = explode(',',$top);
		$coords2 = explode(',',$left);
		
		$coord = $this->getTableName('coordinates');
		$region = $this->getTableName('imageregions');
		
		$this->query("UPDATE $coord,$region SET $coord.x1_axis = {$coords1[0]}, $coord.y1_axis = {$coords1[1]}, $coord.x2_axis = {$coords2[0]}, $coord.y2_axis = {$coords2[1]} WHERE $region.customimages_id = $editID AND $coord.id = $region.coordinates_id");
	}
	
	function delcombination($combID){
		$img = $this->findAllByProductdetailsId($combID);
		if(is_array($img)){
			foreach($img as $key=>$val){
				unlink(WWW_ROOT.IMAGES_URL.$img[$key]['Customimage']['image']); // delete the images
			}
		}
		
		$imgtbl = $this->getTableName('customimages');
		$coord = $this->getTableName('coordinates');
		$region = $this->getTableName('imageregions');
		$this->query("DELETE IMG, RGN, CRD FROM 
					  $imgtbl IMG LEFT JOIN $region RGN ON RGN.customimages_id = IMG.id 
					  LEFT JOIN $coord CRD ON RGN.coordinates_id = CRD.id 
					  WHERE IMG.productdetails_id = $combID");
	}
	
	function getcoords($combID, $type){
		$coord = $this->getTableName('coordinates');
		$imgtbl = $this->getTableName('customimages');
		$region = $this->getTableName('imageregions');
		$op = $this->query("SELECT CRD.* FROM $coord AS CRD, $region, $imgtbl WHERE $region.customimages_id = $imgtbl.id AND $region.coordinates_id = CRD.id AND $imgtbl.productdetails_id = $combID AND $imgtbl.type = '$type'");
		return $op;
	}
	
	function saveCustomization($paramsArray, $editedImg, $uid,$template_name=''){
		$savedtbl = $this->getTableName('savedimages');
		$imgtbl = $this->getTableName('customimages');
		
		$date = date('Y-m-d H:i:s');
		$ref_name = "Customization_".$paramsArray['Customimage']['hid_timestamp'];
		
		
		$this->query("INSERT INTO $savedtbl(ref_name,productdetails_id,users_id,type,image,saved_date,template_name) VALUES('$ref_name',{$paramsArray['Customimage']['productdetail_id']},'$uid','{$paramsArray['Customimage']['front_rear']}','$editedImg','$date','$template_name')");
		$lastid = mysql_insert_id();
		
		
		$imagetype=$this->query("SELECT type from $imgtbl Where productdetails_id={$paramsArray['Customimage']['productdetail_id']}");

//Temp image saving for all sides
		foreach ($imagetype as $type)
		{
				
			if($type[$imgtbl]['type']!=$paramsArray['Customimage']['front_rear'])
			{
					
				$imgtype=$type[$imgtbl]['type'];
		    	$this->query("INSERT INTO $savedtbl(ref_name,productdetails_id,users_id,type,image,saved_date,template_name) VALUES('$ref_name',{$paramsArray['Customimage']['productdetail_id']},'$uid','{$imgtype}','$editedImg','$date','$template_name')");
		
		
			}
		}
		
		
                
		return $lastid;
	}
	
        function addTemplate($lastID,$templateName,$temaplateCombId,$uid,$published,$product_id)
        {
            $savedtbl = $this->getTableName('templates');
            $this->query("INSERT INTO $savedtbl(template_name,productdetail_id,saveimage_id,user_id,published,product_id) VALUES('$templateName',$temaplateCombId,$lastID,$uid,$published,$product_id)");
	
        }
        
        function editTemplate($lastId,$templateName,$published)
        {
            $savedtbl = $this->getTableName('templates');
            $this->query("UPDATE  $savedtbl SET template_name = '$templateName',published = $published WHERE saveimage_id = $lastId");
		
        }




        function updateCustomization($paramsArray, $editedImg, $editId , $prodId,$template_name=''){
		$savedtbl = $this->getTableName('savedimages');
		$date = date('Y-m-d H:i:s');
		
		$refarry=$this->query("SELECT ref_name FROM $savedtbl WHERE id = $editId");
		$refname=$refarry[0][$savedtbl]['ref_name'];
		$this->query("UPDATE $savedtbl SET saved_date = '$date' WHERE ref_name = '$refname'");
		
		
		$this->query("UPDATE $savedtbl SET image = '$editedImg', saved_date = '$date' , productdetails_id = $prodId,template_name='$template_name' WHERE id = $editId");              
		
		
       }
        
        function updateNote($paramsArray){
       
                $note = addslashes($paramsArray['note']);
                $edit_id = $paramsArray['savId'];
		$savedtbl = $this->getTableName('savedimages');
		   
		$this->query("UPDATE $savedtbl SET note = '$note'  WHERE id = $edit_id");              
	}
	
	function ifExists($refName, $frontRear){
		$savedtbl = $this->getTableName('savedimages');
		
		$qry = $this->query("SELECT image FROM $savedtbl WHERE ref_name = 'Customization_{$refName}' AND type = '$frontRear'");
		if($qry) return $qry[0][$savedtbl]['image'];
		else return 'noimage';
	}
	
        
        function getProductDetails_customVal($cutomVal, $prodId){
		$savedtbl = $this->getTableName('productdetails');
		
		$qry = $this->query("SELECT * FROM $savedtbl WHERE product_id = $prodId AND customvalue_id = '$cutomVal'");
		if($qry) return $qry[0][$savedtbl];
		else return '';
	}
        
        
	function userImages($uid, $perPage, $cur){
		$savedtbl = $this->getTableName('savedimages');
		$proddetailTbl = $this->getTableName('productdetails');
		$categoryTbl = $this->getTableName('categories');
		$imagetypeTbl=$this->getTableName('customimagetypes');
		
		$from = $cur*$perPage*2;
		$limit = $perPage*2;
		
		$qry = $this->query("SELECT $savedtbl.*, $proddetailTbl.product_id,  $proddetailTbl.doublesided ,$proddetailTbl.stock,$categoryTbl.id FROM $savedtbl, $proddetailTbl, $categoryTbl 
							 WHERE $savedtbl.users_id = $uid AND $savedtbl.productdetails_id = $proddetailTbl.id AND $proddetailTbl.category_id = $categoryTbl.id ORDER BY $savedtbl.saved_date DESC LIMIT $from, $limit");
		
		if($qry){

			foreach($qry as $key => $val){
				$k = $val[$savedtbl]['ref_name'];
				$user[$k]['id'] = $val[$savedtbl]['ref_name'];
				$user[$k]['uid'] = $val[$savedtbl]['users_id'];
				$user[$k]['cid'] = $val[$categoryTbl]['id'];
				$user[$k]['template_name'] = $val[$savedtbl]['template_name'];
				$user[$k]['pid'] = $val[$proddetailTbl]['product_id'];
                $user[$k]['stock'] = $val[$proddetailTbl]['stock'];
				$user[$k]['did'] = $val[$savedtbl]['productdetails_id'];
				$user[$k]['date'] = $val[$savedtbl]['saved_date'];
				
				$productid= $user[$k]['pid'];
				if(($val[$proddetailTbl]['doublesided'])=='X' || ($val[$proddetailTbl]['doublesided'])=='Y')
				{
					$producttypecount=$this->query("Select count(*) as c from $imagetypeTbl where $imagetypeTbl.productid = $productid");
					$user[$k]['imagesides']=$producttypecount[0][0][c]; 
					
				}
				else 
				{
					//$producttypecount=$this->query("Select count(*) as c from $imagetypeTbl where $imagetypeTbl.productid = $productid");
					$user[$k]['imagesides']=0;
				}
				
				$imagetype=$val[$savedtbl]['type'];
				if(empty($user[$k]["imagetype"]) )
				{
					$j=1;
				}
				else
				{
					$j=count($user[$k]["imagetype"])+1;
				}
				if(!in_array($val[$savedtbl]['type'],$user[$k]["imagetype"]) && $val[$savedtbl]['type']!="Front")
				{
						$user[$k]["imagetype"][$j-1]=$val[$savedtbl]['type'];
				}
				$user[$k][$imagetype] = $val[$savedtbl]['image'];
//				$user[$k]['fid'] = $val[$savedtbl]['id'];
				
 				if($val[$savedtbl]['type'] == 'Front'){
 					$user[$k]['Front'] = $val[$savedtbl]['image'];
					$user[$k]['fid'] = $val[$savedtbl]['id'];
				}
// 				if($val[$savedtbl]['type'] == 'Rear'){
// 					$user[$k]['Rear'] = $val[$savedtbl]['image'];
// 					$user[$k]['rid'] = $val[$savedtbl]['id'];
// 				}
			}
			$users=$user;
			foreach ($users as $key=>$usernew)
			{
				/*
					$user[$key]=$usernew;
					if($usernew['doublesided']=='N')
					{
						unset($user[$key]['Rear']);
						unset($user[$key]['imagetype']);
						unset($user[$key]['imagesides']);
						$user[$key]['imagesides']=0;
					}
					if($usernew['doublesided']=='Y')
					{
						unset($user[$key]['imagesides']);
						$user[$key]['imagesides']=$user[$key]['imagesides']+1;
					}
				*/
				
			}
			return $user;
		}
		else return false;
	}
        
        function adminuserImages($uid, $perPage, $cur){
		$savedtbl = $this->getTableName('savedimages');
		$proddetailTbl = $this->getTableName('productdetails');
		$categoryTbl = $this->getTableName('categories');
		$imagetypeTbl=$this->getTableName('customimagetypes');
		
		$from = $cur*$perPage*2;
		$limit = $perPage*2;
		
		$qry = $this->query("SELECT $savedtbl.*, $proddetailTbl.product_id,  $proddetailTbl.doublesided ,$proddetailTbl.stock,$categoryTbl.id FROM $savedtbl, $proddetailTbl, $categoryTbl 
							 WHERE $savedtbl.users_id = $uid AND $savedtbl.template_name!='' AND $savedtbl.productdetails_id = $proddetailTbl.id AND $proddetailTbl.category_id = $categoryTbl.id ORDER BY $savedtbl.id DESC LIMIT $from, $limit");
		
		if($qry){

			foreach($qry as $key => $val){
				$k = $val[$savedtbl]['ref_name'];
				$user[$k]['id'] = $val[$savedtbl]['ref_name'];
				$user[$k]['uid'] = $val[$savedtbl]['users_id'];
				$user[$k]['cid'] = $val[$categoryTbl]['id'];
				$user[$k]['template_name'] = $val[$savedtbl]['template_name'];
				$user[$k]['pid'] = $val[$proddetailTbl]['product_id'];
                $user[$k]['stock'] = $val[$proddetailTbl]['stock'];
				$user[$k]['did'] = $val[$savedtbl]['productdetails_id'];
				$user[$k]['date'] = $val[$savedtbl]['saved_date'];
				
				$productid= $user[$k]['pid'];
				if(($val[$proddetailTbl]['doublesided'])=='X' || ($val[$proddetailTbl]['doublesided'])=='Y')
				{
					$producttypecount=$this->query("Select count(*) as c from $imagetypeTbl where $imagetypeTbl.productid = $productid");
					$user[$k]['imagesides']=$producttypecount[0][0][c]; 
					
				}
				else 
				{
					//$producttypecount=$this->query("Select count(*) as c from $imagetypeTbl where $imagetypeTbl.productid = $productid");
					$user[$k]['imagesides']=0;
				}
				
				$imagetype=$val[$savedtbl]['type'];
				if(empty($user[$k]["imagetype"]) )
				{
					$j=1;
				}
				else
				{
					$j=count($user[$k]["imagetype"])+1;
				}
				if(!in_array($val[$savedtbl]['type'],$user[$k]["imagetype"]) && $val[$savedtbl]['type']!="Front")
				{
						$user[$k]["imagetype"][$j-1]=$val[$savedtbl]['type'];
				}
				$user[$k][$imagetype] = $val[$savedtbl]['image'];
				$user[$k]['fid'] = $val[$savedtbl]['id'];
				
// 				if($val[$savedtbl]['type'] == 'Front'){
// 					$user[$k]['Front'] = $val[$savedtbl]['image'];
// 					$user[$k]['fid'] = $val[$savedtbl]['id'];
// 				}
// 				if($val[$savedtbl]['type'] == 'Rear'){
// 					$user[$k]['Rear'] = $val[$savedtbl]['image'];
// 					$user[$k]['rid'] = $val[$savedtbl]['id'];
// 				}
			}
			$users=$user;
			foreach ($users as $key=>$usernew)
			{
				/*
					$user[$key]=$usernew;
					if($usernew['doublesided']=='N')
					{
						unset($user[$key]['Rear']);
						unset($user[$key]['imagetype']);
						unset($user[$key]['imagesides']);
						$user[$key]['imagesides']=0;
					}
					if($usernew['doublesided']=='Y')
					{
						unset($user[$key]['imagesides']);
						$user[$key]['imagesides']=$user[$key]['imagesides']+1;
					}
				*/
				
			}
			return $user;
		}
		else return false;
	}
        
        
        function adminuserImages_userpage($uid, $perPage, $cur){
            $savedtbl = $this->getTableName('savedimages');
		$proddetailTbl = $this->getTableName('productdetails');
		$categoryTbl = $this->getTableName('categories');
                $templates = $this->getTableName('templates');
		$imagetypeTbl=$this->getTableName('customimagetypes');
		$prodTbl=$this->getTableName('products');
		
		$from = $cur*$perPage;
		$limit = $perPage;
		
		$qry = $this->query("SELECT * FROM $templates as templ  INNER JOIN $savedtbl as savimg ON templ.saveimage_id = savimg.id INNER JOIN $prodTbl as prdtbl ON templ.product_id = prdtbl.id WHERE templ.published = 1 AND prdtbl.status='A' ORDER BY templ.template_id DESC LIMIT $from, $limit");
		
		if($qry){

			
			return $qry;
		}
		else return false;
            
        }
         function adminuserImages_userpage_count($uid){
            $savedtbl = $this->getTableName('savedimages');
		$proddetailTbl = $this->getTableName('productdetails');
		$categoryTbl = $this->getTableName('categories');
                $templates = $this->getTableName('templates');
		$imagetypeTbl=$this->getTableName('customimagetypes');
		$prodTbl=$this->getTableName('products');
		
		$qry = $this->query("SELECT * FROM $templates as templ  INNER JOIN $savedtbl as savimg ON templ.saveimage_id = savimg.id INNER JOIN $prodTbl as prdtbl ON templ.product_id = prdtbl.id WHERE templ.published = 1 AND prdtbl.status='A' ORDER BY templ.template_id DESC");
		
		if($qry){

			
			return count($qry);
		}
		else return false;
            
        }
        
		function templateuserImages($uid, $perPage, $cur){
		$savedtbl = $this->getTableName('savedimages');
		$proddetailTbl = $this->getTableName('productdetails');
		$categoryTbl = $this->getTableName('categories');
		$imagetypeTbl=$this->getTableName('customimagetypes');
                $template=$this->getTableName('templates');
		
		$from = $cur*$perPage*2;
		$limit = $perPage*2;
		
		$qry = $this->query("SELECT $savedtbl.*, $proddetailTbl.product_id,  $proddetailTbl.doublesided ,$proddetailTbl.stock,$categoryTbl.id FROM $savedtbl, $proddetailTbl, $categoryTbl 
							 WHERE $savedtbl.users_id = $uid AND $savedtbl.productdetails_id = $proddetailTbl.id AND $proddetailTbl.category_id = $categoryTbl.id ORDER BY $savedtbl.id DESC");
		//echo "SELECT $savedtbl.*, $proddetailTbl.product_id,  $proddetailTbl.doublesided ,$proddetailTbl.stock,$categoryTbl.id FROM $savedtbl, $proddetailTbl, $categoryTbl 
		//echopre1($qry);					// WHERE $savedtbl.users_id = $uid AND $savedtbl.productdetails_id = $proddetailTbl.id AND $proddetailTbl.category_id = $categoryTbl.id ORDER BY $savedtbl.id DESC LIMIT $from, $limit";
		if($qry){

			foreach($qry as $key => $val){ 
                         
				$k = $val[$savedtbl]['ref_name'];
				$user[$k]['id'] = $val[$savedtbl]['ref_name'];
				$user[$k]['uid'] = $val[$savedtbl]['users_id'];
				$user[$k]['cid'] = $val[$categoryTbl]['id'];
				$user[$k]['template_name'] = $val[$savedtbl]['template_name'];
				$user[$k]['pid'] = $val[$proddetailTbl]['product_id'];
                                $user[$k]['stock'] = $val[$proddetailTbl]['stock'];
				$user[$k]['did'] = $val[$savedtbl]['productdetails_id'];
				$user[$k]['date'] = $val[$savedtbl]['saved_date'];
				
				$productid= $user[$k]['pid'];
				if(($val[$proddetailTbl]['doublesided'])=='X' || ($val[$proddetailTbl]['doublesided'])=='Y')
				{
					$producttypecount=$this->query("Select count(*) as c from $imagetypeTbl where $imagetypeTbl.productid = $productid");
					$user[$k]['imagesides']=$producttypecount[0][0][c]; 
					
				}
				else 
				{
					//$producttypecount=$this->query("Select count(*) as c from $imagetypeTbl where $imagetypeTbl.productid = $productid");
					$user[$k]['imagesides']=0;
				}
				
				$imagetype=$val[$savedtbl]['type'];
				if(empty($user[$k]["imagetype"]) )
				{
					$j=1;
				}
				else
				{
					$j=count($user[$k]["imagetype"])+1;
				}
				if(!in_array($val[$savedtbl]['type'],$user[$k]["imagetype"]) && $val[$savedtbl]['type']!="Front")
				{
						$user[$k]["imagetype"][$j-1]=$val[$savedtbl]['type'];
				}
				$user[$k][$imagetype] = $val[$savedtbl]['image'];
				$user[$k]['fid'] = $val[$savedtbl]['id'];
                            			 /*$fid = $user[$k]['fid'];    
                              $templQry = $this->query("SELECT * FROM $template WHERE saveimage_id = $fid AND published = 1"); 
                              echo "SELECT * FROM $template WHERE saveimage_id = $fid AND published = 1";*/
// 				if($val[$savedtbl]['type'] == 'Front'){
// 					$user[$k]['Front'] = $val[$savedtbl]['image'];
// 					$user[$k]['fid'] = $val[$savedtbl]['id'];
// 				}
// 				if($val[$savedtbl]['type'] == 'Rear'){
// 					$user[$k]['Rear'] = $val[$savedtbl]['image'];
// 					$user[$k]['rid'] = $val[$savedtbl]['id'];
// 				}
			}
			$users=$user;
			foreach ($users as $key=>$usernew)
			{               $fid = $usernew['fid'];    
                              $templQry = $this->query("SELECT * FROM $template WHERE saveimage_id = $fid AND published = 1");
                        
                              //  echo "SELECT * FROM $template WHERE saveimage_id = $fid AND published = 1";
                              //echo "SELECT * FROM $template WHERE saveimage_id = $fid AND published = 1";
                            if(!$templQry)
                            {
                                unset($user[$key]); 
                            }else{
                               
                            }
				/*
					$user[$key]=$usernew;
					if($usernew['doublesided']=='N')
					{
						unset($user[$key]['Rear']);
						unset($user[$key]['imagetype']);
						unset($user[$key]['imagesides']);
						$user[$key]['imagesides']=0;
					}
					if($usernew['doublesided']=='Y')
					{
						unset($user[$key]['imagesides']);
						$user[$key]['imagesides']=$user[$key]['imagesides']+1;
					}
				*/
				
			} 
			return $user;
		}
		else return false;
	}
	function userImagesCount($uid){
		$savedtbl = $this->getTableName('savedimages');
		$proddetailTbl = $this->getTableName('productdetails');
		$categoryTbl = $this->getTableName('categories');
		
		$qry = $this->query("SELECT COUNT($savedtbl.id) AS totalCount FROM $savedtbl, $proddetailTbl, $categoryTbl 
							 WHERE $savedtbl.users_id = $uid AND $savedtbl.productdetails_id = $proddetailTbl.id AND $proddetailTbl.category_id = $categoryTbl.id ORDER BY $savedtbl.id DESC");
		
		return ($qry[0][0]['totalCount']/2);
	}
        
        function userDesignImagesCount($uid){
		$savedtbl = $this->getTableName('savedimages');
		$proddetailTbl = $this->getTableName('productdetails');
		$categoryTbl = $this->getTableName('categories');
		
		$qry = $this->query("SELECT  $savedtbl.ref_name  FROM $savedtbl
							 WHERE $savedtbl.users_id = $uid GROUP BY $savedtbl.ref_name");
	
		return count($qry);
	}
        
        function adminuserImagesCount($uid){
		$savedtbl = $this->getTableName('savedimages');
		$proddetailTbl = $this->getTableName('productdetails');
		$categoryTbl = $this->getTableName('categories');
		
		$qry = $this->query("SELECT COUNT($savedtbl.id) AS totalCount FROM $savedtbl, $proddetailTbl, $categoryTbl 
							 WHERE $savedtbl.users_id = $uid AND $savedtbl.template_name!='' AND $savedtbl.productdetails_id = $proddetailTbl.id AND $proddetailTbl.category_id = $categoryTbl.id ORDER BY $savedtbl.id DESC");
		
		return ($qry[0][0]['totalCount']/2);
	}
        
	function templateuserImagesCount($uid){
		$savedtbl = $this->getTableName('savedimages');
		$proddetailTbl = $this->getTableName('productdetails');
		$categoryTbl = $this->getTableName('categories');
		
		$qry = $this->query("SELECT COUNT($savedtbl.id) AS totalCount FROM $savedtbl, $proddetailTbl, $categoryTbl 
							 WHERE $savedtbl.users_id = $uid AND $savedtbl.productdetails_id = $proddetailTbl.id AND $proddetailTbl.category_id = $categoryTbl.id ORDER BY $savedtbl.id DESC");
		
		return ($qry[0][0]['totalCount']/2);
	}
	function itemCoordinates($text, $image, $id, $prodid){
		$textArray = explode('{~#~}',$text);
		$imageArray = explode('#',$image);
		$itemcoordinatestbl = $this->getTableName('itemcoordinates');
		
         
		foreach($textArray as $txtVal){
			if($txtVal != ''){
				$temp = explode('|',$txtVal);
				
				$fontClr = $temp[3];
                                $curve = $temp[6];
				$fontWeight = $temp[4];
				$fontType = $temp[5];
				$left = $temp[1];
				$top = $temp[0];
				$text = mysql_real_escape_string($temp[2]);
                                $align = $temp[7];
                                $shape = $temp[8];
                                $shapesettings = $temp[9];
                                $zindex = $temp[10];
                                
				
				$this->query("INSERT INTO $itemcoordinatestbl(savedimages_id,productdetails_id,x_axis,y_axis,content_type,content,font_color,font_size,font_type,curve,shape,align,shape_settings,zindex)
							  VALUES($id,$prodid,'$left','$top','Text','$text','$fontClr',$fontWeight,'$fontType','$curve','$shape','$align','$shapesettings','$zindex')");
			}
		}
		
		foreach($imageArray as $imgVal){
			if($imgVal != ''){
				$temp2 = explode('|',$imgVal);
				
				$left = $temp2[1];
				$top = $temp2[0];
				$imgtemp = explode("/",$temp2[2]);
				$imgPath = $imgtemp[count($imgtemp)-2]."/".$imgtemp[count($imgtemp)-1];
                                $fontClr = $temp2[3];
                                $flip = $temp2[4];
                                $flop = $temp2[5];
                                $zindex = $temp2[6];
                                $curve =  $temp2[7];
				
				$this->query("INSERT INTO $itemcoordinatestbl(savedimages_id,productdetails_id,x_axis,y_axis,content_type,content,font_color,font_size,font_type,curve,zindex,flip_count,flop_count)
							  VALUES($id,$prodid,'$left','$top','Image','$imgPath','$fontClr',0,'',$curve,'$zindex','$flip','$flop')");
			}
		}
	}
	
	function resetTable($uid,$Productdetailid=null){
		$savedtbl = $this->getTableName('savedimages');
		$imgtbl = $this->getTableName('customimages');
		
		$qry = $this->query("SELECT *, COUNT(id) as idcount FROM $savedtbl WHERE users_id = $uid GROUP BY ref_name");
		$imagetype=$this->query("SELECT type from $imgtbl Where productdetails_id=$Productdetailid");
		
		
		foreach($qry as $key => $val){
			
			if($val[0]['idcount'] == 1){
				
				//$val[$savedtbl]['type'] == "Front" ? $imgtype = "Rear" : $imgtype = "Front";
				foreach ($imagetype as $type)
				{
					
				if($type[$imgtbl]['type']!="Front")
				{	
			
				$val[$savedtbl]['type']=$type['PrintLogic_customimages']['type'];
				$imgtype=$val[$savedtbl]['type'];
				$prodID = $val[$savedtbl]['productdetails_id'];
				$imgName = explode("_",$val[$savedtbl]['ref_name']);
				
				$img = $this->query("SELECT image FROM $imgtbl WHERE productdetails_id = $prodID AND type = '$imgtype'");
				$ext = explode(".",$img[0][$imgtbl]['image']);
				$imgExt = strtolower(end($ext));
				
				$customImage = "customized_tshirts/img_".$imgName[1].str_replace("tshirts/","",$ext[0]).".".$imgExt;
				copy(WWW_ROOT.IMAGES_URL.$img[0][$imgtbl]['image'],WWW_ROOT.IMAGES_URL.$customImage);
				
				$this->query("INSERT INTO $savedtbl(ref_name,productdetails_id,users_id,type,image,saved_date) VALUES('{$val[$savedtbl]['ref_name']}',$prodID,$uid,'$imgtype','$customImage','{$val[$savedtbl]['saved_date']}')");
				}
				}		
			}
		}
	}
	
	function findUserItems($savID){
		$itemcoordinatestbl = $this->getTableName('itemcoordinates');
		
		$qry = $this->query("SELECT * FROM $itemcoordinatestbl WHERE savedimages_id = $savID");
		return $qry;
	}
	
	function deleteItemCoordinates($savID){
		$itemcoordinatestbl = $this->getTableName('itemcoordinates');
		
		$qry = $this->query("DELETE FROM $itemcoordinatestbl WHERE savedimages_id = $savID");
	}
	
	function selEditID($tStamp, $imgType){
		$savedtbl = $this->getTableName('savedimages');
		$qry = $this->query("SELECT id FROM $savedtbl WHERE ref_name = 'Customization_$tStamp' AND type = '$imgType'");
		
		return $qry[0][$savedtbl]['id'];
	}
	
	function removeTemp($uid){
		$savedtbl = $this->getTableName('savedimages');
		$itemcoordinatestbl = $this->getTableName('itemcoordinates');
		$imgtbl = $this->getTableName('customimages');
		$imgOp = $txtOp = $op = '';
                
                $arr_count = 0;
		
		$refQry = $this->query("SELECT $savedtbl.*, $imgtbl.image AS custimage FROM $savedtbl, $imgtbl WHERE $savedtbl.image = 'temp' AND $savedtbl.users_id = '$uid' AND $savedtbl.productdetails_id = $imgtbl.productdetails_id AND $savedtbl.type = $imgtbl.type");
		foreach($refQry as $refVal){
		
			$refName = $refVal[$savedtbl]['ref_name'];
			$refCnt = $this->query("SELECT COUNT(ref_name) AS refCount FROM $savedtbl WHERE ref_name = '$refName' AND image = 'temp'");
			$refCnt2 = $this->query("SELECT COUNT(ref_name) AS refCount FROM $savedtbl WHERE ref_name = '$refName'");
			
// 			//if($refCnt[0][0]['refCount'] == 2 || $refCnt2[0][0]['refCount'] == 1){
// 			if($refCnt2[0][0]['refCount'] == 1){
// 				$this->query("DELETE CRD FROM 
// 							  $savedtbl IMG LEFT JOIN $itemcoordinatestbl CRD ON IMG.id = CRD.savedimages_id 
// 							  WHERE IMG.ref_name = '$refName'");
// 				$this->query("DELETE FROM $savedtbl WHERE ref_name = '$refName'");
// 			}
// 			else
{
                            //elseif($refCnt[0][0]['refCount'] == 1){
                            $itemArray = array();
                            $itemQry = $this->query("SELECT * FROM $itemcoordinatestbl WHERE savedimages_id = {$refVal[$savedtbl]['id']} ORDER BY zindex");
                            $arr_item_count = 0;
                            
                            if(!empty($itemQry)){
                                
                                foreach($itemQry as $itemVal){
                                    
                                    if($itemVal[$itemcoordinatestbl]['content_type'] == 'Image'){
                                        
                                        $itemArray[$arr_item_count]['type']  = 'image';
                                        $itemArray[$arr_item_count]['top']   = $itemVal[$itemcoordinatestbl]['y_axis'];
                                        $itemArray[$arr_item_count]['left']  = $itemVal[$itemcoordinatestbl]['x_axis'];
                                        $itemArray[$arr_item_count]['image'] = $itemVal[$itemcoordinatestbl]['content'];
                                        
                                    }
                                    else{
                                        
                                        $fontcolors = explode('{}', $itemVal[$itemcoordinatestbl]['font_color']);
                                        $txtRotate  = explode('{}', $itemVal[$itemcoordinatestbl]['font_type']);
                                        
                                        $itemArray[$arr_item_count]['type']             = 'text';
                                        $itemArray[$arr_item_count]['top']              = $itemVal[$itemcoordinatestbl]['y_axis'];
                                        $itemArray[$arr_item_count]['left']             = $itemVal[$itemcoordinatestbl]['x_axis'];
                                        $itemArray[$arr_item_count]['msg']              = $itemVal[$itemcoordinatestbl]['content'];
                                        $itemArray[$arr_item_count]['align']            = $itemVal[$itemcoordinatestbl]['align'];
                                        $itemArray[$arr_item_count]['shape']            = $itemVal[$itemcoordinatestbl]['shape'];
                                        $itemArray[$arr_item_count]['shapeSettings']    = $itemVal[$itemcoordinatestbl]['shape_settings'];
                                        $itemArray[$arr_item_count]['foreColor']        = $fontcolors[0];
                                        $itemArray[$arr_item_count]['outlineColor']     = $fontcolors[1];
                                        $itemArray[$arr_item_count]['font']             = $txtRotate[0];
                                        $itemArray[$arr_item_count]['outline']          = end($txtRotate);
                                        $itemArray[$arr_item_count]['rotation']         = $txtRotate[1];
                                        $itemArray[$arr_item_count]['foreSize']         = $itemVal[$itemcoordinatestbl]['font_size'];                                       
                                        
                                    }
                                    $arr_item_count++;
                                        
                                }
                                
                                $returnArr[$arr_count]['image_path']    = $refVal[$imgtbl]['custimage'];
                                $returnArr[$arr_count]['id']            = $refVal[$savedtbl]['id'];
                                $returnArr[$arr_count]['design_items']  = $itemArray;
                                
                            }
                            else{
                                
                                $returnArr[$arr_count]['image_path']    = $refVal[$imgtbl]['custimage'];
                                $returnArr[$arr_count]['id']            = $refVal[$savedtbl]['id'];
                                $returnArr[$arr_count]['design_items']  = $itemArray;
                                
                            }
                            
                            unset($itemArray);
                            $arr_count++;
			}
			
		}
		return $returnArr;
	}
	
	function updateSavedimage($saveID,$prodId){
		$savedtbl = $this->getTableName('savedimages');
		$this->query("UPDATE $savedtbl S1, $savedtbl S2 SET S1.image = 'temp',S1.productdetails_id = $prodId WHERE S1.ref_name = S2.ref_name AND S2.id = $saveID");
	}
	
	function updateSaveImage($imgPath, $forePath, $sid){
		$savedtbl = $this->getTableName('savedimages');
		$qry = $this->query("UPDATE $savedtbl SET image = '$imgPath', foreground_image = '$forePath' WHERE id = $sid");
	}
	
	function validateLogin($uname, $pass, $uid){
		$usertbl = $this->getTableName('users');
		$user = $this->query("SELECT * FROM $usertbl WHERE uname = '$uname' AND password = '$pass'");
                
		if($user){
			$savedtbl = $this->getTableName('savedimages');
			$refName = $this->query("UPDATE $savedtbl SET users_id = {$user[0][$usertbl]['id']} WHERE users_id = '$uid'");
                        
			$userArr['User']['id'] = $user[0][$usertbl]['id'];
			$userArr['User']['uname'] = $user[0][$usertbl]['uname'];
			$userArr['User']['email'] = $user[0][$usertbl]['email'];
			$userArr['User']['usertype'] = $user[0][$usertbl]['usertype'];
			$userArr['User']['reg_status'] = $user[0][$usertbl]['reg_status'];
			
			return $userArr['User'];
		}
		else return false;
	}
	
	function customSave($userArr){
		$usertbl = $this->getTableName('users');
		$pass = md5($userArr['Customimage']['password']);
		$qry = $this->query("INSERT INTO $usertbl(uname,password,email,reg_date,usertype,reg_status) VALUES('{$userArr['Customimage']['uname']}', '$pass', '{$userArr['Customimage']['email']}', '{$userArr['Customimage']['reg_date']}', '{$userArr['Customimage']['usertype']}', '{$userArr['Customimage']['reg_status']}')");
		
		return $qry;
	}
        
      
        
        
        function toAdminSave($userArr){
		$usertbl = $this->getTableName('users');
		$pass = md5($userArr['Customimage']['password']);
		$qry = $this->query("INSERT INTO $usertbl(uname,password,email,reg_date,usertype,reg_status,uphone) VALUES('{$userArr['Customimage']['uname']}', '$pass', '{$userArr['Customimage']['email']}', '{$userArr['Customimage']['reg_date']}', '{$userArr['Customimage']['usertype']}', '{$userArr['Customimage']['reg_status']}', '{$userArr['Customimage']['uphone']}')");
		
		return $qry;
	}
        function UpdateUserDetail($userArr){
             
		$usertbl = $this->getTableName('users'); 		
		$qry = $this->query("UPDATE $usertbl  SET uphone=  '{$userArr['Customimage']['uphone']}' WHERE id = '{$userArr['Customimage']['userid']}'");
		
	}
	
	function deleteCoordinates($imgID){
		$savedtbl = $this->getTableName('savedimages');
		$this->query("DELETE FROM $savedtbl WHERE id = $imgID");
		
		$itemcoordinatestbl = $this->getTableName('itemcoordinates');
		$this->query("DELETE FROM $itemcoordinatestbl WHERE savedimages_id = $imgID");
	}
	function deleteTemplates($imgID){
		$savedtbl = $this->getTableName('templates');
		$this->query("DELETE FROM $savedtbl WHERE saveimage_id = $imgID");
		
		
	}
	function pendingorders($uid){
		$savedtbl = $this->getTableName('savedimages');
		$ordertbl = $this->getTableName('orders');
		$orderdetailstbl = $this->getTableName('order_details');
                $carttbl = $this->getTableName('carts');
		
		$op = $this->query("SELECT SAV.id
					  FROM $ordertbl ODR, $orderdetailstbl ODT, $savedtbl SAV
					  WHERE ODT.order_id = ODR.id AND ODT.savedimages_id = SAV.id 
					  AND SAV.users_id = $uid AND ODR.order_status_id IN (2, 4, 6, 7)");
            
         /* $op = $this->query("(SELECT SAV.id
					  FROM $ordertbl ODR, $orderdetailstbl ODT, $savedtbl SAV
					  WHERE ODT.order_id = ODR.id AND ODT.savedimages_id = SAV.id 
					  AND SAV.users_id = $uid AND ODR.order_status_id IN (2, 4, 6, 7))
                                          UNION (SELECT SAV.id FROM $savedtbl SAV,$carttbl CAR WHERE SAV.users_id = $uid AND
                       CAR.savedimages_id = SAV.id)
                        
                        "); */      
                
                
		return $op;
	}
        
        function designsincart($uid){
		
		$cartstbl = $this->getTableName('carts');      
               
		$op = $this->query("SELECT savedimages_id
					  FROM $cartstbl 
					  WHERE user_id = $uid");      
                
                return $op;
	}
	
         function designOrder($uid){
		
		$ordertbl = $this->getTableName('orders');      
                $ordertdtbl = $this->getTableName('order_details');
		$op = $this->query("SELECT odt.savedimages_id
					  FROM $ordertbl AS od INNER JOIN $ordertdtbl AS odt ON od.id = odt.order_id
					  WHERE od.user_id = $uid");    
               // echo "SELECT odt.savedimages_id
		//			  FROM $ordertbl AS od INNNER JOIN $ordertdtbl AS odt ON od.id = odt.order_id
			//		  WHERE od.user_id = $uid";
              
                return $op;
	}
        
	function findcombinationqty($cid, $except){
		$csttbl = $this->getTableName('customfieldvalues');
		
		$op = $this->query("SELECT CFV.custom_value,CFV.id
					  FROM $csttbl CFV
					  WHERE CFV.id IN ($cid) AND CFV.id != $except");
		return $op;
	}
	
	function delEntry($sid, $time){
		$tbl = $this->getTableName('itemcoordinate_sessions');
		
		$this->query("DELETE FROM $tbl WHERE created_time = '$time' AND session_id = '$sid'");
	}
	
	function findEntry($sid, $frontRear){
		$tbl = $this->getTableName('itemcoordinate_sessions');
		
		$qry = $this->query("SELECT * FROM $tbl WHERE session_id = '$sid' AND frontrear = '$frontRear'");
               
           
		return $qry;
	}
	
	function delEntries($sid, $frontRear){
		$tbl = $this->getTableName('itemcoordinate_sessions');
		
		$this->query("DELETE FROM $tbl WHERE session_id = '$sid' AND frontrear = '$frontRear'");
	}
        function delEntries1($sid){
		$tbl = $this->getTableName('itemcoordinate_sessions');
		
		$this->query("DELETE FROM $tbl WHERE session_id = '$sid' ");
	}
        
        function getTemplateName($frontId)
        {
            $savedtbl = $this->getTableName('savedimages');
             $templates = $this->getTableName('templates');
             $qry = $this->query("SELECT savt.*,templ.published  FROM $savedtbl as savt INNER JOIN $templates as templ ON templ.saveimage_id = savt.id WHERE savt.id = $frontId");
           
            return $qry[0];
        }
        function updateProductimages ($pid){
		/*$savedtbl = $this->getTableName('productimages');               
		$qry = $this->query("UPDATE $savedtbl SET imagename = '$imgPath' WHERE product_id = $pid AND id = '$editid'");*/
            
		$savedtbl         = $this->getTableName('productimages');   
                $productDetailTbl = $this->getTableName('productdetails');  
                $customImageTbl   = $this->getTableName('customimages');  
		$qry = $this->query("DELETE FROM $savedtbl WHERE product_id = $pid");
                $qry = $this->query("SELECT CIMG.image,CIMG.type FROM $customImageTbl CIMG LEFT JOIN $productDetailTbl PRJDTL ON PRJDTL.id = CIMG.productdetails_id 					  
					  WHERE PRJDTL.product_id = $pid");
                if($qry<>NULL)
                {
                    foreach ($qry as $key => $value) {
                      $imgName = explode("/",$value['CIMG']['image']);
                      $imageName= end($imgName); 
                      $defaultImg=$value['CIMG']['type']=="Front"?"Y":"N";
                      $this->query("INSERT INTO $savedtbl(product_id,imagename,default_img)
							  VALUES($pid,'$imageName','$defaultImg')");
                    }
                    
                }
	}
         function updateCustomimages ($imgPath, $editid){
		$savedtbl = $this->getTableName('customimages'); 
		$qry = $this->query("UPDATE $savedtbl SET image = '$imgPath' WHERE id = '$editid'");
	}
        function updateProductDetails ($imgPath, $editid, $pid){

		$savedtbl = $this->getTableName('productdetails');                
		$qry = $this->query("UPDATE $savedtbl SET pdctfile = '$imgPath' WHERE product_id = $pid AND id = '$editid'");
	}
        
        function customizationsdone($sessionid){
		
		$itemcordinatesessiontbl = $this->getTableName('itemcoordinate_sessions');      
               
		$op = $this->query("SELECT * FROM $itemcordinatesessiontbl WHERE session_id = '$sessionid'");      
                
                return $op;
	}
        
	function savedimageidfororder($customid)
	{
		$savedtbl = $this->getTableName('savedimages');
	//	SELECT `id` FROM `PrintLogic_savedimages` WHERE `ref_name`=(SELECT ``ref_name`` FROM `PrintLogic_savedimages` WHERE `id`=2653) ORDER BY `id` DESC;
		$saveimageid=$this->query("SELECT id FROM $savedtbl WHERE ref_name= (SELECT ref_name FROM $savedtbl WHERE id=$customid) ORDER BY id ASC");
		return $saveimageid[0][$savedtbl][id];
		
	}
        function duplicateTblEntries($productdetails_id, $lastID){
            $savedtbl = $this->getTableName('savedimages');
            $itemcoordinatestbl = $this->getTableName('itemcoordinates');
            $savedId = array();
            $savedImagesQry = $this->query("SELECT ref_name FROM $savedtbl WHERE id = " . $lastID);
            $refNameQry = $this->query("SELECT id FROM $savedtbl WHERE ref_name = '" . $savedImagesQry[0][$savedtbl]['ref_name'] . "'");
    
            $ref_name = "Customization_" . time() . rand(0,999);
            if($refNameQry){
                foreach($refNameQry as $savedImages){
                    $savedID = $savedImages[$savedtbl]['id'];                    
                    
                    $this->query("INSERT INTO $savedtbl(ref_name, productdetails_id, users_id, type, image, saved_date, foreground_image) SELECT '$ref_name', $productdetails_id, users_id, type, 'temp', saved_date, 'temp' FROM $savedtbl WHERE id = '{$savedID}'");
                    
                    $insertedID = mysql_insert_id();
                    $savedId[] = $insertedID; 
                  
                    
                    $this->query("INSERT INTO $itemcoordinatestbl(savedimages_id, productdetails_id, x_axis, y_axis, content_type, content, font_color, font_size, font_type, curve, shape, align, shape_settings, zindex, flip_count, flop_count) SELECT $insertedID, $productdetails_id, x_axis, y_axis, content_type, content, font_color, font_size, font_type, curve, shape, align, shape_settings, zindex, flip_count, flop_count FROM $itemcoordinatestbl WHERE savedimages_id IN (" . $savedID . ")"); 
  //$this->query("UPDATE $itemcoordinatestbl SET content = '$names' WHERE savedimages_id = '{$insertedID}' ");
                }
                return $savedId[0];
            }
            else{
                return 0;
            }            
        }
        
        
        function getFrontDetails($fid)
        {
             $savedtbl = $this->getTableName('savedimages');
             $savedImagesQry = $this->query("SELECT * FROM $savedtbl WHERE id = " . $fid);
             return $savedImagesQry[0][$savedtbl];
        }
        
        
        
        function makeCustomizationUs($productdetails_id, $lastID,$uid){
            $savedtbl = $this->getTableName('savedimages');
            $itemcoordinatestbl = $this->getTableName('itemcoordinates');
            $savedId = array();
            $savedImagesQry = $this->query("SELECT ref_name FROM $savedtbl WHERE id = " . $lastID ."");
            $refNameQry = $this->query("SELECT id FROM $savedtbl WHERE ref_name = '" . $savedImagesQry[0][$savedtbl]['ref_name'] . "' order by id ASC");
            $ref_name = "Customization_" . time() . rand(0,999); 
            if($refNameQry){
                foreach($refNameQry as $savedImages){
                    $savedID = $savedImages[$savedtbl]['id'];                    
                  
                    $this->query("INSERT INTO $savedtbl(ref_name, productdetails_id, users_id, type, image, saved_date, foreground_image) SELECT '$ref_name', $productdetails_id, '$uid', type, 'temp', saved_date, 'temp' FROM $savedtbl WHERE id = '{$savedID}'");
                  //  echo "INSERT INTO $savedtbl(ref_name, productdetails_id, users_id, type, image, saved_date, foreground_image) SELECT '$ref_name', $productdetails_id, $uid, type, 'temp', saved_date, 'temp' FROM $savedtbl WHERE id = '{$savedID}'";
                    $insertedID = mysql_insert_id();
                  //  echo $insertedID.'<br>';
                    $savedId[] = $insertedID; 
                  
                    
                    $this->query("INSERT INTO $itemcoordinatestbl(savedimages_id, productdetails_id, x_axis, y_axis, content_type, content, font_color, font_size, font_type, curve, shape, align, shape_settings, zindex, flip_count, flop_count) SELECT $insertedID, $productdetails_id, x_axis, y_axis, content_type, content, font_color, font_size, font_type, curve, shape, align, shape_settings, zindex, flip_count, flop_count FROM $itemcoordinatestbl WHERE savedimages_id IN (" . $savedID . ")"); 
  //$this->query("UPDATE $itemcoordinatestbl SET content = '$names' WHERE savedimages_id = '{$insertedID}' ");
                }
                return $savedId[0];
            }
            else{
                return 0;
            }            
        }
        function getCustomizedImages($productdetails_id, $lastID){
            $savedtbl = $this->getTableName('savedimages');
            $itemcoordinatestbl = $this->getTableName('itemcoordinates');
            $savedId = array();
            $savedImagesQry = $this->query("SELECT ref_name FROM $savedtbl WHERE id = " . $lastID ."");
            $refNameQry = $this->query("SELECT * FROM $savedtbl WHERE ref_name = '" . $savedImagesQry[0][$savedtbl]['ref_name'] . "' order by id ASC");
           $imgArray = array();
           foreach ($refNameQry as $v)
           {
               
               $imgArray[] = $v[$savedtbl];
           }
          return $imgArray;
        }
        function changeNamePlaceholder($savId,$name)
        {     $itemcoordinatestbl = $this->getTableName('itemcoordinates');
            $this->query("UPDATE $itemcoordinatestbl SET content = '$name' WHERE savedimages_id = '{$savId}' ");
            
        }
        

        function swapcomp($combID)
        {
        	$producttbl = $this->getTableName('productdetails');
        	$swapcomp=$this->query("SELECT c.id,c.pdctfile,c.customvalue_id from $producttbl c where  product_id=(select x.product_id from $producttbl x where id =$combID) ");
        	return $swapcomp;
        	
        }        
        
        
        function getFrontRearID($lastID, $imgSide){
            $savedtbl = $this->getTableName('savedimages');
            //echo "SELECT id FROM $savedtbl WHERE type = '$imgSide' AND ref_name LIKE (SELECT ref_name FROM $savedtbl WHERE id = $lastID)";
            $savedImage = $this->query("SELECT id FROM $savedtbl WHERE type = '$imgSide' AND ref_name LIKE (SELECT ref_name FROM $savedtbl WHERE id = $lastID)");//print_r($savedImage);
            if($savedImage){
                return $savedImage[0][$savedtbl]['id'];
            }
            else{
                return 0;
            }
        }


        function getCustomImagesType($productId){
            $tblName = $this->getTableName('customimagetypes');  
            $pSideTypes = $this->query("SELECT * FROM $tblName WHERE productid=".$productId);
            foreach($pSideTypes as $pSideType){
                $pSideTypesArray[] = $pSideType[$tblName];
            }
            return $pSideTypesArray;
        }

        function deleteCustomImagesType($productId){
            $tblName = $this->getTableName('customimagetypes');  
            $pSideTypes = $this->query("DELETE FROM $tblName WHERE productid=".$productId);
            return 1;
        }

        function prdCustomimagetypes($productId, $type){
            $tblName = $this->getTableName('customimagetypes');
            $pSideTypes = $this->query("SELECT * FROM $tblName WHERE productid=".$productId." AND type='".$type."'");
            return $pSideTypes;
        }
        
        function getCustomImagesByType($productId,$sideType){
            $tblName = $this->getTableName('customimagestemp');
            $pSideImages = $this->query("SELECT * FROM $tblName WHERE product_id=".$productId." AND type='".$sideType."'"); 
            foreach($pSideImages as $pSideImage){
                $pSideImagesArray[] = $pSideImage[$tblName];
            }
            return $pSideImagesArray;
        }
        
        function getCustomImageData($id){
            $tblName = $this->getTableName('customimagestemp');
            $pImageData = $this->query("SELECT * FROM $tblName WHERE id=".$id);
            return $pImageData[0][$tblName];
        }

        function saveCustomImageDetails($productDetailId,$imageData) {

        $tblCustomImage = $this->getTableName('customimages');
        $this->query("INSERT into $tblCustomImage(productdetails_id,type,image) values('".$productDetailId."','".$imageData['type']."','".$imageData['image']."')");
        $customImageId = mysql_insert_id();

        $tblCustomCoordinates = $this->getTableName('coordinates');
        $this->query("INSERT into $tblCustomCoordinates(x1_axis,y1_axis,x2_axis,y2_axis) values('".$imageData['x1_axis']."','".$imageData['y1_axis']."','".$imageData['x2_axis']."','".$imageData['y2_axis']."')");
        $customCoordinatesId = mysql_insert_id();

        $tblCustomImageRegions = $this->getTableName('imageregions');
        $this->query("INSERT into $tblCustomImageRegions(customimages_id,coordinates_id) values('".$customImageId."','".$customCoordinatesId."')");

        return true;
    }

    function getProductSideImage($productDetailId,$pSideType){
            $tblName = $this->getTableName('customimages'); 
            $pImageData = $this->query("SELECT * FROM $tblName WHERE productdetails_id=".$productDetailId." AND type='".$pSideType."'");
            return $pImageData[0][$tblName];
    }

    function updateCustomImageTableWithSideName($productDetailId,$sideName,$prevSideName) {
        $customImagetbl = $this->getTableName('customimages');
        $savedImagetbl = $this->getTableName('savedimages');
        $this->query("UPDATE $customImagetbl SET type = '$sideName' WHERE productdetails_id = '{$productDetailId}' AND type='".$prevSideName."'");
        $this->query("UPDATE $savedImagetbl SET type = '$sideName' WHERE productdetails_id = '{$productDetailId}' AND type='".$prevSideName."'");
    }

    function updateCustomSideImages ($imgPath, $editid, $sideType){
        $savedtbl = $this->getTableName('customimages');
        $qry = $this->query("UPDATE $savedtbl SET image = '$imgPath' WHERE productdetails_id = '$editid' AND type='".$sideType."'");
    }

    function getCustomSideNameBySideId($customSideId){
            $tblName   = $this->getTableName('customimagetypes');
            $pSideName = $this->query("SELECT * FROM $tblName WHERE id=".$customSideId);
            return $pSideName[0][$tblName];
        }

        
  function saveTemplate($name,$status,$edit_id,$timestamp)
        {
            $savedtbl = $this->getTableName('templates');
            $custom = $this->getTableName('savedimages');
            $ref_name = "Customization_$timestamp";
            
            $qry = $this->query("UPDATE $savedtbl SET template_name = '$name',published = $status WHERE saveimage_id = '$edit_id' ");
            $qry1 = $this->query("UPDATE $custom SET template_name = '$name' WHERE ref_name = '$ref_name' ");
          // echo "UPDATE $custom SET template_name = '$name' WHERE ref_name = '$ref_name' "; exit;
        }

}

