<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/

// +----------------------------------------------------------------------+

// | PHP version 4/5                                                      |

// +----------------------------------------------------------------------+

// | Copyright (c) 2004-2011 ARMIA INC                                    |

// +----------------------------------------------------------------------+

// | This source file is a part of iScripts PrintLogic                     |

// +----------------------------------------------------------------------+

// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |

// +----------------------------------------------------------------------+

class Order extends AppModel

{

  	var $name 		= 'Order';

	//var $hasMany 	= 'OrderDetail';

	var $hasMany 	= array('OrderDetail');

	var $belongsTo 	= array('User','OrderStatus','Coupon');

	function changeStatus($id,$oid){

		$Db = ConnectionManager::getDataSource($this->useDbConfig);

		$odtbl = $Db->fullTableName('orders');

		$this->query("UPDATE $odtbl SET order_status_id = ".$oid." WHERE id = ".$id);

		return true;

	}

	function delete_order($id){

		$Db = ConnectionManager::getDataSource($this->useDbConfig);

		$odtbl = $Db->fullTableName('orders');

		$odttbl = $Db->fullTableName('order_details');

		$this->query("DELETE o.*, d.* FROM $odtbl o LEFT JOIN $odttbl d ON o.id = d.order_id WHERE o.id = ".$id);

		return  true;

	}

	function getNewinvid(){

		$Db = ConnectionManager::getDataSource($this->useDbConfig);

		$odtbl = $Db->fullTableName('orders');

		$val	=	$this->query("select max(id)+1 as ordid from $odtbl");

		return  $val[0][0]["ordid"];

	}

	function resetexpdate($id,$exptm){

		$Db = ConnectionManager::getDataSource($this->useDbConfig);

		$odtbl = $Db->fullTableName('orders');

		$this->query("UPDATE $odtbl SET exp_time = '".$exptm."' WHERE id = ".$id);

		return true;

	}

	function addnote($id,$not){

		$Db = ConnectionManager::getDataSource($this->useDbConfig);

		$odtbl = $Db->fullTableName('orders');

		$this->query("UPDATE $odtbl SET note = '".$not."' WHERE id = ".$id);

		return true;

	}

	function addcomment($id,$cmnt){

		$Db = ConnectionManager::getDataSource($this->useDbConfig);

		$odtbl = $Db->fullTableName('orders');

		$this->query("UPDATE $odtbl SET comments = '".$cmnt."' WHERE id = ".$id);

		return true;

	}



	function fetchgraphgata(){

		$Db = ConnectionManager::getDataSource($this->useDbConfig);

		$odtbl = $Db->fullTableName('orders');

		$dataArray= $this->query("SELECT coalesce( sum( o.total_price ) , 0 ) AS total_amount, lpad( EXTRACT(MONTH FROM date ) , 2, '0' ) AS MONTH , EXTRACT( YEAR FROM date ) AS year FROM ".$odtbl." o WHERE date >= DATE_SUB( CURDATE( ) , INTERVAL 1 YEAR ) GROUP BY MONTH , year");	

		return $dataArray;

	}	

	

	  

	  function getTableName($tablename)

	 {

		$Db = ConnectionManager::getDataSource($this->useDbConfig);

		$tblnme = $Db->fullTableName($tablename);			

		$tblnme=trim(str_replace('`','',$tblnme));		

		return $tblnme;

	  }

	  

	  

	  

	  

	

	  //Overriding Pagination starts here...

	
      function paginate($conditions, $fields, $order, $limit, $page = 1, $recursive = null, $extra = array())

	  {										

					

					if(!isset($extra['passit']['sort']))

					{

						$extra['passit']['page']= 1;

						$extra['passit']['sort']='Order.id';

						$extra['passit']['direction'] ='DESC';

						$order = array($extra['passit']['sort'] => $extra['passit']['direction']);						

					}					

					else

					{

					  $order = array($extra['passit']['sort'] => $extra['passit']['direction']);		

					}						

					$group='';	$joins = '';

					if(isset($extra['group']))$group = $extra['group'];

					if(isset($extra['joins']))$joins = $extra['joins'];					

					$params = array(

					  'conditions' => $conditions,	

					  'fields' => $fields, 

					  'order' => $order,

					  'limit' => $limit,

					  'joins' => $joins,

					  'page' => $page,

					  'group' => $group,		  	 

					);		

					return $this->find('all', $params);		

         }



			function paginateCount($conditions = null, $recursive = 0, $extra = array()) 

			{

				    $group='';	$joins = '';

					if(isset($extra['group']))$group = $extra['group'];

					if(isset($extra['joins']))$joins = $extra['joins'];		

				    $params = array(

					  'conditions' => $conditions,	

					  'fields' => '',		

					  'joins' => $joins,					 

					  'group' => $group,		  	 

					);		

					return count($this->find('all', $params));	

			}


        //Overriding Pagination starts here...

		

				 

		function getSalesDates($opt='')

		 {

			$Db = ConnectionManager::getDataSource($this->useDbConfig);

			$ordtbl = $Db->fullTableName('orders');

			if($opt=='max')
			{

			 $maxdate	=	$this->query("SELECT DATE_FORMAT(DATE_ADD(max(date),INTERVAL 1 DAY),'%m-%d-%Y') AS maxdate FROM $ordtbl");

			 $gdate= $maxdate[0][0]["maxdate"];			

			}

			else if($opt=='min')
			{

			 $mindate	=	$this->query("SELECT DATE_FORMAT(DATE_SUB(min(date),INTERVAL 1 DAY),'%m-%d-%Y') AS mindate FROM $ordtbl");

			 $gdate= $mindate[0][0]["mindate"];			

			}
			
			else if($opt=='paymin')
			{

			 $mindate	=	$this->query("SELECT DATE_FORMAT(DATE_SUB(min(pay_date),INTERVAL 1 DAY),'%m-%d-%Y') AS mindate FROM $ordtbl WHERE order_status_id >= 6");

			 $gdate= $mindate[0][0]["mindate"];			

			}
			
			else if($opt=='paymax')
			{

			 $maxdate	=	$this->query("SELECT DATE_FORMAT(DATE_ADD(max(pay_date),INTERVAL 1 DAY),'%m-%d-%Y') AS maxdate FROM $ordtbl WHERE order_status_id >= 6");

			 $gdate= $maxdate[0][0]["maxdate"];			

			}

			return $gdate;

		}
		function payorder($id,$gtway,$txnid){
			$Db = ConnectionManager::getDataSource($this->useDbConfig);
			$ordtbl = $Db->fullTableName('orders');
			$this->query("UPDATE $ordtbl SET payment_method = '".$gtway."', transaction_id = '".$txnid."',order_status_id=6, pay_date = now() WHERE id = ".$id);
		}
		
		function getOrderTotal($id){
			$Db = ConnectionManager::getDataSource($this->useDbConfig);
			$ordtbl = $Db->fullTableName('order_details');
			
			$op = $this->query("SELECT SUM(quantity*(product_price+extra_price)) AS grandtotal FROM $ordtbl WHERE order_id = $id");
			return $op[0][0]['grandtotal'];
		}
                
                function savetoAdmin($paramsArray){
		$savedtbl = $this->getTableName('orders');	
		
		$this->query("INSERT INTO $savedtbl(date,user_id,order_status_id,total_price,currency_type) VALUES('{$paramsArray['date']}',{$paramsArray['user_id']},{$paramsArray['order_status_id']},{$paramsArray['total_price']},'{$paramsArray['currency_type']}')");
                $lastid = mysql_insert_id();               
                
		return $lastid;
                }
         function updatePrice($paramsArray,$orderId){
		$savedtbl = $this->getTableName('orders');	
		$price = $paramsArray['total_price'];
		$this->query("UPDATE  $savedtbl SET total_price =  total_price+$price WHERE id = $orderId");
             //   echo "UPDATE  $savedtbl SET total_price =  total_price+$price WHERE id = $orderId"; 
             
                }
                
               
}

?>