<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Printlogic                    |
// +----------------------------------------------------------------------+
// | Authors: Aswin John<aswin.j@armiasystems.com>                        |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com ï¿½ 2011                |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php

$imagefolder =  "../img";
$stylesfolder = "../css";
$sitestyle="Eyewears.css";
$logoimage="SiteLogo.jpg";
$productname=" ";
session_start();

function isValidUsername($str) {
    if (trim($str) !="" ) {
        if ( eregi ( "[^0-9a-zA-Z+_]", $str ) ) {
            return false;
        }else {
            return true;
        }
    }else {
        return false;
    }

}

function splitsqlfile($sql, $delimiter) {
    // Split up our string into "possible" SQL statements.
    $tokens = explode($delimiter, $sql);
    // try to save mem.
    $sql = "";
    $output = array();
    // we don't actually care about the matches preg gives us.
    $matches = array();
    // this is faster than calling count($oktens) every time thru the loop.
    $token_count = count($tokens);
    for ($i = 0; $i < $token_count; $i++) {
        // Don't wanna add an empty string as the last thing in the array.
        if (($i != ($token_count - 1)) || (strlen($tokens[$i] > 0))) {
            // This is the total number of single quotes in the token.
            $total_quotes = preg_match_all("/'/", $tokens[$i], $matches);
            // Counts single quotes that are preceded by an odd number of backslashes,
            // which means they're escaped quotes.
            $escaped_quotes = preg_match_all("/(?<!\\\\)(\\\\\\\\)*\\\\'/", $tokens[$i], $matches);

            $unescaped_quotes = $total_quotes - $escaped_quotes;
            // If the number of unescaped quotes is even, then the delimiter did NOT occur inside a string literal.
            if (($unescaped_quotes % 2) == 0) {
                // It's a complete sql statement.
                $output[] = $tokens[$i];
                // save memory.
                $tokens[$i] = "";
            } else {
                // incomplete sql statement. keep adding tokens until we have a complete one.
                // $temp will hold what we have so far.
                $temp = $tokens[$i] . $delimiter;
                // save memory..
                $tokens[$i] = "";
                // Do we have a complete statement yet?
                $complete_stmt = false;

                for ($j = $i + 1; (!$complete_stmt && ($j < $token_count)); $j++) {
                    // This is the total number of single quotes in the token.
                    $total_quotes = preg_match_all("/'/", $tokens[$j], $matches);
                    // Counts single quotes that are preceded by an odd number of backslashes,
                    // which means they're escaped quotes.
                    $escaped_quotes = preg_match_all("/(?<!\\\\)(\\\\\\\\)*\\\\'/", $tokens[$j], $matches);

                    $unescaped_quotes = $total_quotes - $escaped_quotes;

                    if (($unescaped_quotes % 2) == 1) {
                        // odd number of unescaped quotes. In combination with the previous incomplete
                        // statement(s), we now have a complete statement. (2 odds always make an even)
                        $output[] = $temp . $tokens[$j];
                        // save memory.
                        $tokens[$j] = "";
                        $temp = "";
                        // exit the loop.
                        $complete_stmt = true;
                        // make sure the outer loop continues at the right point.
                        $i = $j;
                    } else {
                        // even number of unescaped quotes. We still don't have a complete statement.
                        // (1 odd and 1 even always make an odd)
                        $temp .= $tokens[$j] . $delimiter;
                        // save memory.
                        $tokens[$j] = "";
                    }
                } // for..
            } // else
        }
    }
    return $output;
}

function isValidTableName($str) {
    if (trim($str) != "") {
        if (eregi ("[^a-zA-Z+_]", $str)) {
            return false;
        } else {
            return true;
        }
    } else {
        return false;
    }
}

function isNotNull($value) {
    if (is_array($value)) {
        if (sizeof($value) > 0) {
            return true;
        } else {
            return false;
        }
    } else {
        if (($value != '') && (strtolower($value) != 'null') && (strlen(trim($value)) > 0)) {
            return true;
        } else {
            return false;
        }
    }
}

function getFilePermission($file) {
    $perm = fileperms($file);
    if($perm === false) {
        return "0000";
    }else {
        return substr(sprintf('%o', $perm), -4);
    }

}
function stripslashes_deep($value) {
    $value = is_array($value) ? array_map('stripslashes_deep', $value) : stripslashes($value);
    return $value;
}

function getServerOS() {
    return strtoupper(substr(PHP_OS, 0, 3));
}

//deprecated in php 5.3
@set_magic_quotes_runtime(0);

if (get_magic_quotes_gpc()) {
    $_POST = array_map('stripslashes_deep', $_POST);
    $_GET = array_map('stripslashes_deep', $_GET);
    $_COOKIE = array_map('stripslashes_deep', $_COOKIE);
}

function file_writable($file) {
    $permission = substr(sprintf('%o', fileperms($file)), -4);
    if($permission == '0777' || $permission == '0666') {
        return true;
    }
    else {
        return false;
    }
}

$schemafile = "schema.sql";
$datafile = "data.sql";
$configfile = "../config.php";

$configcontents = @fread(@fopen($configfile, 'r'), @filesize($configfile));
$pos = strpos($configcontents, "define('VERSION', '1.6');");
if ($pos === false) {
    ;
} else {
    header("Location:../index.php");
}

$fullurl = $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']);
if($_SERVER['HTTPS']=='on') {
    $http = "https://";
}else {
    $http = "http://";
}
$pos = strrpos($fullurl, "/");
if ($pos === false) { // note: three equal signs
    // not found...
} else {
    $fullurl = substr($fullurl, 0, $pos);
}

$installed = false;
$txtDBServerName="localhost";
$txtTablePrefix		=	"PrintLogic_";
$mystring 	=	dirname(dirname(__FILE__));
$findme 	=	'webroot';
$ps 		=	strpos($mystring, $findme);
$dr			=	substr($mystring,0,$ps);
$dbconfigfile =$dr."/config/database.php";
$configfile = $dr."/webroot/config.php";

$txtSiteURL ="http://".$fullurl;
$txtSecureSiteURL="https://" . $fullurl;
$txtSiteURLt ="http://".$fullurl;
$txtSecureSiteURLt="https://" . $fullurl;
$txtSiteBaseFolderfull	=	dirname($_SERVER['PHP_SELF']);
$findu 		=	'/app/webroot';
$murl		=	strpos($txtSiteURL,$findu);
$txtSiteURL	=	substr($txtSiteURL,0,$murl);
$len		=	strpos($txtSiteBaseFolderfull,$findu);
$txtSiteBaseFolder	=	substr($txtSiteBaseFolderfull,0,$len);
//print_r($txtSiteBaseFolder);exit;

$murs		=	strpos($txtSecureSiteURL,$findu);
$txtSecureSiteURL	=	substr($txtSecureSiteURL,0,$murs);
/* *********************************check server configuration *****************************************************/

$server_flag = true;

$val1 = ini_get("safe_mode");
$val2 = ini_get("short_open_tag");
$val3 = ini_get("file_uploads");
$val4 = ini_get("open_basedir");
$val_mb  = function_exists('mb_strlen');
$val_fread  = function_exists('fread');
$gd           = function_exists('gd_info');
$curl         = function_exists('curl_init');
$mysql        = function_exists('mysql_connect');
$system       = strpos(ini_get("disable_functions"), "system");
$imagick      = class_exists("Imagick");

ob_start();
$cmd = 'convert -version';
$imgVal = system($cmd,$out);
$variable = ob_get_clean();
$variable = explode(' ', $variable);
//$composite = exec('composite -version',$var);

ob_start();
$cmd1 = 'composite -version';
$imgVal1 = system($cmd1,$out1);
$variable1 = ob_get_clean();

$imgversions = explode('-',$variable[2]);
$imgversioned = explode('.', $imgversions[0]);


ob_start();
$cmd3 = 'autotrace -v';
$imgVal3 = system($cmd1,$out1);
$variable3 = ob_get_clean();




if(!empty($val1) || $val1==1) {
    $server_flag = false;
}
//elseif((empty($val2) || $val2 !=1)) {
//    $server_flag = false;
//}
elseif(empty($val3) || $val3 !=1) {
    $server_flag = false;
}
elseif(empty($val_mb) || $val_mb !=1)
{
    $server_flag = false;
}
elseif(empty($val_fread) || $val_fread !=1)
{
    $server_flag = false;
}
/*elseif((!empty($val4) || $val4==1)) {
    $server_flag = false;
}*/
elseif(!$gd) {
    $server_flag = false;
}
elseif(!$curl) {
    $server_flag = false;
}
elseif(!$mysql) {
    $server_flag = false;
}
elseif($system) {
    $server_flag = false;
}
elseif(!$imagick) {
    $server_flag = false;
}

if($imgversioned[0]<6){
    $server_flag = false;
}elseif($imgversioned[0]==6){
    if($imgversioned[1]<7)
    {
        $server_flag = false;
    }elseif ($imgversioned[1]==7) {
        if($imgversioned[2]<3)
        {
             $server_flag = false;
        }
    }
}

if(empty($variable1))
{
    $server_flag = false;
}


$openbasedircheck =   "0" ;
if($_POST["submittest"] == "Upload") {
    $uploadpath=substr($_FILES['testupload']['tmp_name'],0,strlen($_FILES['testupload']['tmp_name'])-strlen(basename($_FILES['testupload']['tmp_name']))-1);

    $val4=$val4.":"."  ";
    $openbasedirarray=explode(":",$val4);

    if(in_array($uploadpath,$openbasedirarray)) {
        $openbasedircheck="1";
    }
    $_SESSION['sess_openbasedircheck']=$openbasedircheck;
}


$mysqlsupport=true;
if (!function_exists('mysql_connect')) {

    $mysqlsupport = false;
}

if(!$server_flag) {
    $serverconfiguration =   "FAILURE";
}else {
    $serverconfiguration =   "OK";
}

/*--------------------Check server PHP configuration---------------------------*/
$sapi_type = php_sapi_name();
$chmodstatus = '000';
if (substr($sapi_type, 0, 3) == 'cgi') {
    $chmodstatus = '755';
    $write = 'WRITABLE';
}else {
    if(substr(@php_uname(s),0,7) == "Windows") {
        $chmodstatus = '000';
    }
    else {
        $chmodstatus = '777';
    }
    $write = 'UNWRITABLE';
}

$directories = array("/webroot/img/products/", 
                    "/webroot/img/csv/", 
                    "/webroot/Fax/", 
                    "/webroot/files/", 
                    "/webroot/files/File/", 
                    "/webroot/files/Flash/", 
                    "/webroot/files/Image/", 
                    "/webroot/files/Media/",
                    "/webroot/files/Graph/", 
                    "/webroot/img/SiteLogo_disp.gif", 
                    "/webroot/img/SiteLogo.jpg", 
                    "/tmp/cache/", 
                    "/tmp/cache/models/", 
                    "/tmp/cache/views/",
                    "/tmp/cache/persistent/", 
                    "/tmp/", 
                    "/tmp/logs/", 
                    "/tmp/sessions/", 
                    "/webroot/img/", 
                    "/webroot/css/", 
                    "/webroot/Fedex/shipping_label/",
                    "/webroot/Fedex/", 
                    "/webroot/img/customized_tshirts/", 
                    "/webroot/img/customized_tshirts_foreground/", 
                    "/webroot/img/editorimages/", 
                    "/webroot/img/editorimages/default/",
                    "/webroot/img/editorimages/temp/", 
                    "/webroot/img/editorimages/cropimages/", 
                    "/webroot/img/editorimages/customized/", 
                    "/webroot/img/editorfonts/", 
                    "/webroot/img/TIFF/", 
                    "/webroot/img/tshirts/", 
                    "/webroot/img/categoryimages/", 
                    "/webroot/img/fontpreview/",
                    "/config/database.php", 
                    "/webroot/config.php",
                    "/webroot/img/editorimages/Animals/",     
                    "/webroot/img/editorimages/Cartoon/",
                    "/webroot/img/editorimages/Events/",
                    "/webroot/img/editorimages/Food/",
                    "/webroot/img/editorimages/Holidays/",
                    "/webroot/img/editorimages/Military/",
                    "/webroot/img/editorimages/Music/",
                    "/webroot/img/editorimages/Nature/",
                    "/webroot/img/editorimages/Occupations/",
                    "/webroot/img/editorimages/People/",
                    "/webroot/img/editorimages/Religion/",
                    "/webroot/img/editorimages/School/",
                    "/webroot/img/editorimages/Sports/",
                    "/webroot/img/editorimages/Symbols/",
                    "/webroot/img/editorimages/Transportation/",
                    "/webroot/img/editorimages/admin/"  
                    );

$perm_msg  = '';
$perm_flag = true;
$host_name = parse_url($_SERVER['HTTP_HOST']);

if($chmodstatus == '777') {
    if(isset($_POST["btnContinue"]) && !isset($_POST["auto_set"])) {
        $txtFTPusername = $_POST['FTPusername'];
        $txtFTPpassword = $_POST['FTPpassword'];

        if(trim($txtFTPusername) == '') {
            $perm_msg .= '* Please enter FTP username <br/>';
        }
        if(trim($txtFTPpassword) == '') {
            $perm_msg .= '* Please enter FTP password <br/>';
        }
        else {
            $conn_id = @ftp_connect($host_name["path"]);
            $login_result = @ftp_login($conn_id, $txtFTPusername, $txtFTPpassword);
            if($login_result) {
                $mode = 777;
                $np = '0'.$mode;

                $user_install = str_replace('/webroot/upgrade1.6', '', getcwd());

                //get the path staring from public_html
                $path_parts = explode('/public_html', $user_install);
                $user_install = '/public_html'.$path_parts[1];

                foreach($directories as $directory) {
                    $edited_path = str_replace('..', '', $directory);
                    $directory = $user_install.$edited_path;
                    if($directory[strlen($directory) - 1] == '/') {
                        $directory  = substr($directory, 0, strlen($directory) - 1);
                    }
                    if(!@ftp_chmod($conn_id, eval("return({$np});"), $directory)) {
                        $perm_flag = false;
                    }
                }

                if(!$perm_flag) {
                    $perm_msg .= '* Sorry, an error occurred. Please try again or set the permissions manually <br/>';
                }
                else {
                    $perm_msg  = '<b>* File permissions successfuly set </b><br/>';
                }
            }
            else {
                $perm_msg .= '* Sorry, could not connect to the server. Please check the credentials <br/>';
            }
        }
    }
}
elseif($chmodstatus == '755') {
    //cgi handler requires 755 so no file permission change needed
}
elseif($chmodstatus == '000') {
    //ftp_chmod wont work on windows
}

/*-----------------------------------------------------------------------------*/

if($write == 'UNWRITABLE') {
    $productsdir                             = "../img/products/";
    $csvdir                                  = "../img/csv/";
    $faxdir                                  = "../Fax/";
    $flsdir                                  = "../files/";
    $fledir                                  = "../files/File/";
    $flashdir                                = "../files/Flash/";
    $imagedir                                = "../files/Image/";
    $mediadir                                = "../files/Media/";
    $graphdir                                = "../files/Graph/";
    $sitelogo1                               = "../img/SiteLogo_disp.gif";
    $sitelogo2                               = "../img/SiteLogo.jpg";
    $cashdir                                 = "../../tmp/cache/";
    $cashmodeldir                            = "../../tmp/cache/models/";
    $cashviewdir                             = "../../tmp/cache/views/";
    $cashpersistentdir                       = "../../tmp/cache/persistent/";
    $tmpdir                                  = "../../tmp/";
    $tmplogs                                 = "../../tmp/logs/";
    $sessdir                                 = "../../tmp/sessions/";
    $imgdir                                  = "../img/";
    $styledir                                = "../css/";
    $fedexshipdir                            = "../Fedex/shipping_label/";
    $fedexdir                                = "../Fedex/";
    $customized_tshirts                      = "../img/customized_tshirts/";
    $customized_tshirts_foreground           = "../img/customized_tshirts_foreground/";
    $editorimages                            = "../img/editorimages/";
    $editorimages_default                    = "../img/editorimages/default/";
    $editorimages_temp                       = "../img/editorimages/temp/";
    $editorimages_custom                     = "../img/editorimages/customized/";
    $editorimages_crop                       = "../img/editorimages/cropimages/";
    $fontdir                                 = "../img/editorfonts/";
    $TIFF                                    = "../img/TIFF/";
    $tshirts                                 = "../img/tshirts/";
    $categoryimages                          = "../img/categoryimages/";
    $fontpreview                             = "../img/fontpreview/";
    $dbconfig_file                           = "../../config/database.php";
    $config_file                             = "../config.php";
}//end if

$error = false;
$error_message = '';

//show alert only for non-cgi servers
if($chmodstatus == '777' || $chmodstatus == '000') {
    if(!file_writable($productsdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/img/products' folder to 777 <br>";
    }//end if

    if(!file_writable($csvdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/img/csv' folder to 777 <br>";
    }//end if

    if(!file_writable($faxdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/Fax' folder to 777 <br>";
    }//end if

    if(!file_writable($flsdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/files' folder to 777 <br>";
    }//end if

    if(!file_writable($fledir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/files/File' folder to 777 <br>";
    }//end if

    if(!file_writable($flashdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/files/Flash' folder to 777 <br>";
    }//end if

    if(!file_writable($imagedir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/files/Image' folder to 777 <br>";
    }//end if

    if(!file_writable($mediadir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/files/Media' folder to 777 <br>";
    }//end if

    if(!file_writable($graphdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/files/Graph' folder to 777 <br>";
    }//end if

    if(!file_writable($sitelogo1)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/img/SiteLogo_disp.gif' to 777 <br>";
    }//end if

    if(!file_writable($sitelogo2)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/img/SiteLogo.jpg' to 777 <br>";
    }//end if

    if(!file_writable($cashdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/tmp/cache' folder to 777 <br>";
    }//end if

    if(!file_writable($cashmodeldir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/tmp/cache/models' folder to 777 <br>";
    }//end if

    if(!file_writable($cashviewdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/tmp/cache/views' folder to 777 <br>";
    }//end if

    if(!file_writable($cashpersistentdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/tmp/cache/persistent' folder to 777 <br>";
    }//end if

    if(!file_writable($tmpdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/tmp' folder to 777 <br>";
    }//end if

    if(!file_writable($tmplogs)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/tmp/logs' folder to 777 <br>";
    }//end if

    if(!file_writable($sessdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/tmp/sessions' folder to 777 <br>";
    }//end if

    if(!file_writable($tmplogs)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/tmp/logs' folder to 777 <br>";
    }//end if

    if(!file_writable($imgdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/img' folder to 777 <br>";
    }//end if

    if(!file_writable($styledir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/css' folder to 777 <br>";
    }//end if

    if(!file_writable($fedexshipdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/Fedex/shipping_label' folder to 777 <br>";
    }//end if

    if(!file_writable($fedexdir)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/Fedex' folder to 777 <br>";
    }//end if

    if(!file_writable($customized_tshirts)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/img/customized_tshirts' folder to 777 <br>";
    }//end if

    if(!file_writable($customized_tshirts_foreground)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/img/customized_tshirts_foreground' folder to 777 <br>";
    }//end if

    if(!file_writable($editorimages)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/img/editorimages' folder to 777 <br>";
    }//end if

    if(!file_writable($editorimages_default)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/img/editorimages/default' folder to 777 <br>";
    }//end if

    if(!file_writable($editorimages_temp)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/img/editorimages/temp' folder to 777 <br>";
    }//end if

    if(!file_writable($editorimages_custom)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/img/editorimages/customized' folder to 777 <br>";
    }//end if
    
    if(!file_writable($editorimages_crop)){
            $error = true;
            $error_message .= " * Change the permission of 'app/webroot/img/editorimages/cropimages' folder to 777 <br>";
    }//end if
    
    if(!file_writable($fontdir)){
            $error = true;
            $error_message .= " * Change the permission of 'app/webroot/img/editorfonts' folder to 777 <br>";
    }//end if

    if(!file_writable($TIFF)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/img/TIFF' folder to 777 <br>";
    }//end if

    if(!file_writable($tshirts)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/img/tshirts' folder to 777 <br>";
    }//end if

    if(!file_writable($categoryimages)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/img/categoryimages' folder to 777 <br>";
    }//end if

    if(!file_writable($fontpreview)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/img/fontpreview' folder to 777 <br>";
    }//end if

    if(!file_writable($dbconfig_file)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/config/database.php' to 777 <br>";
    }//end if

    if(!file_writable($config_file)) {
        $error = true;
        $error_message .= " * Change the permission of 'app/webroot/config.php' to 777 <br>";
    }//end if
}

/*----------------------------------------------------------------------------------------------------------------*/

$post_flag = false;

if ($_POST["btnContinue"] == "Upgrade" ) {
    $post_flag = true;
    $message = "";

    include_once('../../config/database.php');
    $sqlObj     = new DATABASE_CONFIG();
    $sqlUser    = $sqlObj->default['login'];
    $sqlPass    = $sqlObj->default['password'];
    $sqlHost    = $sqlObj->default['host'];
    $sqlDB      = $sqlObj->default['database'];
    $sqlPrefix  = $sqlObj->default['prefix'];

    $connection = @mysql_connect($sqlHost, $sqlUser, $sqlPass);
    if ($connection === false) {
        $error = true;
        $message .= " * Connection Not Successful! Please verify your database details!<br>";
    } else {
        $dbselected = @mysql_select_db($sqlDB, $connection);
        if (!$dbselected) {
            $error = true;
            $message .= " * Database could not be selected! Please verify your database details!<br>";
        }
    }

    //check if defaultattribute field is present
    $col_flag = false;
    $col_qry = mysql_query("DESCRIBE {$sqlPrefix}products");
    while($col_res = mysql_fetch_assoc($col_qry)){
          if($col_res['Field'] == 'defaultattribute'){
              $col_flag = true;
          }
    }
    if(!$col_flag){
        mysql_query("ALTER TABLE {$sqlPrefix}products ADD `defaultattribute` BIGINT( 20 ) NOT NULL;");
    }

    if ($error) {
        $message = "<u><b>Please correct the following errors to continue:</b></u>" . "<br><br>" . $message;
        // echo $message;
    }
    else{
        $fp = fopen($configfile, "w+");
        $configcontent = "<?php\n";
        $configcontent .= "define('INSTALLED', true); \n\n";
        $configcontent .= "define('VERSION', '1.6'); \n\n";
        $configcontent .= "\n?>";
        fwrite($fp, $configcontent);

        $sqlquery = @fread(@fopen($schemafile, 'r'), @filesize($schemafile));
       	$sqlquery = preg_replace('/PrintLogic_/', $sqlPrefix, $sqlquery);
        $sqlquery = splitsqlfile($sqlquery, ";");
        // creating the tables......................................
        for($i = 0; $i < sizeof($sqlquery); $i++) {
            mysql_query($sqlquery[$i], $connection);
        }

        $dataquery = @fread(@fopen($datafile, 'r'), @filesize($datafile));
        $dataquery = preg_replace('/PrintLogic_/', $sqlPrefix, $dataquery);
        $dataquery = splitsqlfile($dataquery, ";");
        // populating the tables with initial data......................................
        for($i = 0; $i < sizeof($dataquery); $i++) {
            mysql_query($dataquery[$i], $connection);
        }

        $installed = true;
    }
    
    
    $prdSql = mysql_query("SELECT * FROM {$sqlPrefix}products WHERE status = 'A'"); 
    while($row = mysql_fetch_assoc($prdSql))
    {
        
        $prodId = $row['id'];
        
      $doubside = mysql_query("SELECT count(*) FROM {$sqlPrefix}productdetails WHERE product_id = $prodId AND doublesided='Y'");
        
     $count = mysql_result($doubside, 0); 
     if($count>0)
     {   $side = mysql_query("SELECT count(*) FROM {$sqlPrefix}customimagetypes WHERE product_id = $prodId");
        
     $countside = mysql_result($side, 0); 
     if($countside==0)
     { 
         $insert = mysql_query("INSERT INTO {$sqlPrefix}customimagetypes (productid,type) VALUES ($prodId,'Rear')");
     }
     
     }
     
    }
    
    if(!empty($variable3))
    {
        $autoSql = mysql_query("UPDATE {$sqlPrefix}settings SET value = 'YES' WHERE fieldname = 'autotracing'"); 
        
    }
    
}

function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "")
{
  $theValue = (!get_magic_quotes_gpc()) ? addslashes($theValue) : $theValue;

  switch ($theType) {
	case "text":
	  $theValue = ($theValue != "") ? "'" . $theValue . "'" : "''";
	  break;
	case "long":
	case "int":
	  $theValue = ($theValue != "") ? intval($theValue) : "''";
	  break;
	case "double":
	  $theValue = ($theValue != "") ? "'" . doubleval($theValue) . "'" : "''";
	  break;
	case "date":
	  $theValue = ($theValue != "") ? "'" . $theValue . "'" : "''";
	  break;
	case "defined":
	  $theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue;
	  break;
  }
  return $theValue;
}
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
"http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<title>PrintLogic Upgrader</title>
<link href="../css/GoldenYellow.css" rel="stylesheet" type="text/css">
</head>
<script type="text/javascript" src="../js/jquery.js"></script>
<script type="text/javascript">
    function divToggle(elem)
    {
        if($(elem).is(":checked")){
            $('#err_div').slideDown('slow');
        }
        else{
            $('#err_div').slideUp('slow');
        }
    }
</script>
<style type="text/css">
    .install_option {  font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9pt; color: #333333}
    .install_value_ok { font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9pt; font-weight: bold; color: #009900 }
    .install_value_fail { font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 7pt; font-weight: bold; color: #CC0000}
    .block_class{
        color:#F4700E;
        font-family: Verdana, Arial, Helvetica, sans-serif;
        font-weight: bold;}	

</style>
<body topmargin="0">
    <div class="header_row">
        <div class="header_container wrapper">
            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr>
                    <td width="23%" align="center" ><h2><span class="">PrintLogic Upgrader</span></h2></td>
                    <td width="77%"><table width="100%"  border="0" cellspacing="0" cellpadding="0">
                            <tr>
                                <td width="75%" align="center">&nbsp;</td>
                                <td width="25%"></td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table></div>
    </div>

    <table width="100%"  border="0" cellspacing="0" cellpadding="0">
        <tr>
            <td><img src="../img/spacer.gif" width="1" height="5"></td>
        </tr>
    </table>
    <table width="100%"  border="0" cellspacing="0" cellpadding="0">
        <tr>

            <td width="76%" valign="top" height ="400">
                <!-- Here's where I want my views to be displayed -->
                <table width="80%" border="0" cellpadding="0" cellspacing="0" align="center">
                    <tr>
                        <td>
                            <?php
                            $pos	=	strpos($_SERVER['SCRIPT_NAME'],'/webroot');
                            $ck		=	substr($_SERVER['SCRIPT_NAME'],0,$pos);

                            $s = null;
                            if ($_SERVER['HTTPS']) {
                            $s ='s';
                            }
                            $httpHost = $_SERVER['HTTP_HOST'];
                            if (isset($httpHost)) {
                            $ser	= 'http'.$s.'://'.$httpHost;
                            }
                            unset($httpHost, $s);
                            $ft = '';
                            $ft =@file_get_contents($ser."/".$ck."/config/rewtest/link2.html");
                            //print_r($txtSiteURLt);exit;

                            if(php_sapi_name() != 'apache2handler' || $ft == ''){ ?>
                            <div align="center" id="items_top_area">
                            &nbsp;&nbsp;
                            <a title="OnlineInstallationManual" href="#" onClick="window.open('<?php echo htmlentities($txtSiteURLt);?>/Installation_Manual.pdf','OnlineInstallationManual','top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd');"><strong>Installation manual</strong></a>
                            | <a title="Readme" href="#" onClick="window.open('<?php echo htmlentities($txtSiteURLt);?>/Readme.txt','Readme','top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd');"><strong>Readme</strong></a> |
                            <a title="If you have any difficulty, submit a ticket to the support department" href="#" onClick="window.open('http://www.iscripts.com/support/postticketbeforeregister.php','','top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd,resizable=yes');">
                            <strong>Get Support</strong></a>
                            </div>
                            <?php }else{ ?>
                            <div align="center" id="items_top_area">
                            &nbsp;&nbsp;
                            <a title="OnlineInstallationManual" href="#" onClick="window.open('<?php echo htmlentities($txtSiteURL);?>/Installation_Manual.pdf','OnlineInstallationManual','top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd');"><strong>Installation manual</strong></a>
                            | <a title="Readme" href="#" onClick="window.open('<?php echo htmlentities($txtSiteURL);?>/Readme.txt','Readme','top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd');"><strong>Readme</strong></a> |
                            <a title="If you have any difficulty, submit a ticket to the support department" href="#" onClick="window.open('http://www.iscripts.com/support/postticketbeforeregister.php','','top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd,resizable=yes');">
                            <strong>Get Support</strong></a>
                            </div>
                            <?php } ?>
                            <?php
                            if ($serverconfiguration=="FAILURE")
                            {
                            ?>
                                    <table width="80%" border=0 align="center">
                                    <?php
                                    $ivo = "<span class='install_value_ok'>";
                                    $ivf = "<span class='install_value_fail'>";
                                    $sc = "</span>";
                                    echo "<tr><td class=maintext><b></b><br><br></td></tr>";
                                    echo "<tr><td class=maintext>Checking PHP Version... " . $ivo.PHP_VERSION.$sc . " ";
                                    if(version_compare(PHP_VERSION,"4.2.0") >=0 ) echo $ivo."".$sc; else {echo $ivf."(4.2.0 or higher required)".$sc; $fatal = true;}
                                    echo "</td></tr>";
                                    echo "<tr><td class=maintext>Checking System Information... " .$ivo. PHP_OS .$sc. "</td></tr>";
                                    echo "<tr><td class=maintext>Checking PHP Server API... " . $ivo. php_sapi_name().$sc . "</td></tr>";
                                    echo "<tr><td class=maintext>Checking Path to 'php.ini'... " . $ivo.PHP_CONFIG_FILE_PATH.$sc . "</td></tr>";
                                    $mysqlsupport=true;
                                    if (!function_exists('mysql_connect')) {
                                            $mysqlsupport = false;
                                    }
                                    echo "<tr><td class=maintext>Checking Mysql support... ";
                                    echo $ivo . (( $mysqlsupport) ? "On" : " $ivf This program requires MYSQL support. Please recompile your PHP with MYSQL Support.") . $sc;
                                    echo "</td></tr>";
                                    echo "<tr><td class=maintext>Checking safe_mode... ";
                                    $val1 = ini_get("safe_mode");
                                    echo  ((!empty($val1) || $val1==1) ? $ivf ."On-Please turn off safe_mode in the php.ini" : $ivo ."Off") . $sc;
                                    echo "</td></tr>";
//                                    echo "<tr><td class=maintext>Checking short_tags... ";
//                                    $val2 = ini_get("short_open_tag");
//                                    echo  ((!empty($val2) || $val2==1) ?$ivo."On" : $ivf."Off-Please turn on short_tags in the php.ini") . $sc;
//                                    echo "</td></tr>";
                                    echo "<tr><td class=maintext>Checking file_uploads...";
                                    $val3 = ini_get("file_uploads");
                                    echo ((!empty($val3) || $val3==1) ? $ivo . "On" : $ivf . "Off - Please turn on file_uplaods in the php.ini file").$sc;
                                    echo "</td></tr>";
                                  /*  echo "<tr><td class=maintext>Checking open base directory...";
                                    $val4 = ini_get("open_basedir");
                                    echo ((!empty($val4) || $val4==1) ? $ivf . "On - $ivf Please upload a test file " : $ivo . "Off ") . $sc."</td></tr>";

                                    if((!empty($val4) || $val4==1)  and  (!empty($val3) || $val3==1) ){
                                        echo "<tr><td class=maintext>";
                                            if($_POST["submittest"] == "Upload"){
                                                    $uploadpath=substr($_FILES['testupload']['tmp_name'],0,strlen($_FILES['testupload']['tmp_name'])-strlen(basename($_FILES['testupload']['tmp_name']))-1);
                                                    $uploadpatharray=explode("/",$uploadpath);
                                                    $openbasedirarray=explode(":",$val4);
                                                    $existflag=0;
                                                    $checkitem="";
                                                    for($i=1;$i<count($uploadpatharray);$i++){
                                                            $checkitem=$checkitem."/".$uploadpatharray[$i];
                                                            if(! in_array($checkitem,$openbasedirarray)  and ! in_array($checkitem."/",$openbasedirarray) ){
                                                                    ;
                                                            }else{
                                                                    $existflag=1;
                                                                    break;
                                                            }
                                                    }
                                                    if($existflag==1){
                                                            $openbasedircheck="1";
                                                    }else{
                                                            echo "<br>&nbsp;&nbsp;".$ivf."Please add '$uploadpath' in openbase directory entry of your configuration file.[contact your hosting provider]";
                                                    }
                                                    $_SESSION['sess_openbasedircheck']=$openbasedircheck;
                                            }
                                            if($openbasedircheck !="1"){
                                            ?>
                                                    <form name=frmInstall method=post action="" enctype="multipart/form-data">
                                                            file :&nbsp;
                                                    <input type=file name=testupload class=textbox>
                                                    <INPUT type="submit" name="submittest" value="Upload" class=button>
                                                    </form>
                                    <?php }
                                    echo "</td></tr>";
                                    }*/
                                    echo "<tr><td class=maintext>Checking CURL support... ";
                                    $val5 = function_exists('curl_init');
                                    if($val5){
                                        echo $ivo."On";
                                    }
                                    else{
                                        echo $ivf."Off-Please re-compile php with CURL support" . $sc;
                                    }
                                    echo "</td></tr>";
                                    
                                     
                                                                echo "<tr><td class=maintext>Checking  mbstring support... ";
								$val_mb = function_exists('mb_strlen');
								if($val_mb){
									echo $ivo."On";
								}
								else{
									echo $ivf."Off-Please re-compile php with mbstring support" . $sc;
								}
								echo "</td></tr>";
                                                                
                                                                echo "<tr><td class=maintext>Checking  File Read/Write - fread() support... ";
								$val_fread = function_exists('fread');
								if($val_fread){
									echo $ivo."On";
								}
								else{
									echo $ivf."Off-Please re-compile php with File Read/Write - fread() support" . $sc;
								}
								echo "</td></tr>";
                                                                
                                    
                                    
                                    
                                    echo "<tr><td class=maintext>Checking GD support... ";
                                    $val6 = function_exists('gd_info');
                                    if($val6){
                                        echo $ivo."On";
                                    }
                                    else{
                                        echo $ivf."Off-Please re-compile php with GD support" . $sc;
                                    }
                                    echo "</td></tr>";
                                    echo "<tr><td class=maintext>Checking SYSTEM function... ";
                                    $val7 = strpos(ini_get("disable_functions"), "system");
                                    if(!$val7){
                                        echo $ivo."On";
                                          if (empty($variable1)) {
            echo $ivf . " but composite command is not enabled" . $sc;
        }
                                    }
                                    else{
                                        echo $ivf."Off-Please enable SYSTEM funtion the php.ini" . $sc;
                                    }
                                    echo "</td></tr>";
                                    echo "<tr><td class=maintext>Checking IMAGICK support... ";
                                    $val8 = class_exists("Imagick");
                                    if($val8){
                                        echo $ivo."On";
                                         if ($imgversioned[0] < 6) {

            echo $ivf . "Requires IMAGEMAGICK version 6.7.3 or above, current version is " . $variable[2] . ' ' . $sc;
        } elseif ($imgversioned[0] == 6) {
            if ($imgversioned[1] < 7) {

                echo $ivf . "Requires IMAGEMAGICK version 6.7.3 or above, current version is " . $variable[2] . ' ' . $sc;
            } elseif ($imgversioned[1] == 7) {
                if ($imgversioned[2] < 3) {

                    echo $ivf . "Requires IMAGEMAGICK version 6.7.3 or above, current version is " . $variable[2] . ' ' . $sc;
                }
            }
        } else {
            
        }
                                    }
                                    else{
                                        echo $ivf."Off-Please re-compile php with IMAGICK support" . $sc;
                                    }
                                    echo "</td></tr>";

                                    echo "<tr><td class=maintext>".$ivf."Fatal errors detected.  Please correct the above red items and reload.</td></tr>";
                                    ?>
                            </table>

                    <?php
                    } else if (!$installed ) {
                    ?>
                            <table width="80%" border="0" align="center">
                                <tr>
                                        <td align="center" ><b><font size="1">
                                                <div align="justify" >
                                                <br>
                                                <font color="#F4700E" size="+1">Thank you for choosing PrintLogic&nbsp;</font> <br><br>
                                                <font color="#000000" size="2"><img src="../img/dot.jpg">&nbsp;To complete this installation please enter the details below.</font>
                                                </div>

                                        </font></b>
                                        </td>
                                </tr>
                                <?php if($post_flag){ ?>
                                <tr>
                                        <td align=center class="message" >
                                                <div align="left" class="text_information">
                                                <br>
                                                <font color="#FF0000"><?php echo $message;?></font><br>
                                                <font color="#FF0000"><?php echo $error_message; ?></font><br>
                                                </div>
                                        </td>
                                </tr>
                                <?php } ?>
                                <tr>
                                        <td class=maintext align="left" >
                                        <br>
                                        <form name="frmInstall" method="post" action="<?php echo $_SERVER["PHP_SELF"];?>" enctype="multipart/form-data">
                                            <br>
                                            <FIELDSET>
                                            <LEGEND class='block_class'>File Permissions</LEGEND>
                                            <table width=85% border="0" cellpadding="2" cellspacing="2" class=maintext>
                                                    <tr>
                                                        <td colspan="2" align="left">
                                                            <b>
                                                            <?php if($chmodstatus == '777'){ ?>
                                                               Printlogic requires that some of the folders have write permission. You can provide an FTP login so that this process is done automatically.<br/><br/>
                                                               For security reasons, it is best to create a separate FTP user account with access to the Printlogic installation only and not the entire web server. Your host can assist you with this.
                                                               If you have difficulties completing installation without these credentials, please click "I would provide permissions manually" to do it yourself.<br/><br/>
                                                            <?php }elseif($chmodstatus == '000'){ ?>
                                                                Printlogic requires that some of the folders have write permission. Please provide write permission for the following files :-<br/><br/>
                                                            <?php } elseif($chmodstatus == '755'){ ?>
                                                                Printlogic requires that some of the folders have write permission.<br/><br/>
                                                            <?php } ?>
                                                            </b>
                                                        </td>
                                                    </tr>
                                                    <?php if($write == 'UNWRITABLE'){ ?>
                                                    <tr>
                                                            <td class=maintext align="left">FTP username</td>
                                                            <td width="61%" align=left>
                                                                    <input name="FTPusername"  id="FTPusername" type="text" size="50" value="<?php echo htmlentities($txtFTPusername);?>">
                                                            </td>
                                                    </tr>
                                                    <tr>
                                                            <td class=maintext align="left">FTP password</td>
                                                            <td width="61%" align=left>
                                                                    <input name="FTPpassword"  id="FTPpassword" type="password" size="50" value="<?php echo htmlentities($txtFTPpassword);?>">
                                                            </td>
                                                    </tr>
                                                    <?php if($chmodstatus == '777'){ ?>
                                                    <tr>
                                                        <td colspan="2" align="left">
                                                            <input type="checkbox" name="auto_set" id="auto_set" onclick="divToggle(this)" /> &nbsp; I would provide permissions manually
                                                        </td>
                                                    </tr>
                                                    <?php
                                                        }
                                                    }else{
                                                    ?>
                                                    <tr>
                                                        <td colspan="2" align="left">
                                                            <b>File permissions are OK.</b>
                                                        </td>
                                                    </tr>
                                                    <?php } ?>
                                            </table>
                                            <?php if($write == 'UNWRITABLE'){ ?>
                                            <div id="err_div" style="<?php if($chmodstatus == '777'){ ?>display:none<?php } ?>">
                                                        <fieldset>
                                                            <legend>Directories/Files List</legend>
                                                            <?php echo $error_message; ?>
                                                        </fieldset>
                                            </div>
                                            <?php } ?>
                                            </FIELDSET>
                                            <br>
                                            <table width=85% border=0 cellpadding="2" cellspacing="2" class=maintext>
                                                    <tr><td>&nbsp;</td></tr>
                                                    <tr>
                                                            <td align="center">
                                                                    <input type="submit" name="btnContinue" value="Upgrade" class="buttn_admin">
                                                            </td>
                                                    </tr>
                                            </table>
                                        </form>
                        </td>
                    </tr>
                </table>
                <?php
                }else{
                ?>
                <table width="80%" border="0" align="center">
                        <tr>
                                <td>
                                        <table width=85% border=0 cellpadding="2" cellspacing="2" class=maintext align="center">
                                                <br>
                                                <tr>
                                                        <td align="center" class="maintext" >
                                                                <font color="#F4700E" size="+1">Congratulations! The Upgradation Process was completed successfully!</font>
                                                        </td>
                                                </tr>
                                                <tr>
                                                        <td align="center" class="maintext" height="20" >&nbsp;</td>
                                                </tr>
                                                <?php
                                                $request_uri = explode('/',$_SERVER['REQUEST_URI']);

                                                $script_filename = explode('/',$_SERVER['SCRIPT_FILENAME']);
                                                $build_path = "http://".$_SERVER['HTTP_HOST']."/".$request_uri[1]."/admin/login.php";
                                                $build_path_home = "http://".$_SERVER['HTTP_HOST']."/".$request_uri[1]."/index.php";
                                                ?>
                                                <tr>
                                                        <td align="center">
                                                        <br>
                                                        <fieldset>
                                                        <legend class="block_class">Site Login Details</legend>
                                                                <table cellpadding="0" cellspacing="0" width="80%" class="maintext" align="center">
                                                                        <tr>
                                                                                <td colspan="2">&nbsp;</td>
                                                                        </tr>
                                                                        <?php
                                                                        $pos	=	strpos($_SERVER['SCRIPT_NAME'],'/webroot');
                                                                        $ck		=	substr($_SERVER['SCRIPT_NAME'],0,$pos);

                                                                        $s = null;
                                                                        if ($_SERVER['HTTPS']) {
                                                                        $s ='s';
                                                                        }
                                                                        $httpHost = $_SERVER['HTTP_HOST'];
                                                                        if (isset($httpHost)) {
                                                                        $ser	= 'http'.$s.'://'.$httpHost;
                                                                        }
                                                                        unset($httpHost, $s);
                                                                        $ft = '';
                                                                        $ft =@file_get_contents($ser."/".$ck."/config/rewtest/link2.html");
                                                                        if(php_sapi_name() == 'apache2handler'){
                                                                                $apach	=	true;
                                                                        }else{
                                                                                $apach	=	false;
                                                                        }
                                                                        ?>
                                                                                <tr>
                                                                                        <td width="24%"><b><font size="-1">Admin URL&nbsp;:</font></b></td>
                                                                                        <td width="76%"><a style="cursor:pointer" href="<?php echo $txtSiteURL."/admins/"?>"><?php echo $txtSiteURL."/admins/";?><img src="../img/admin_login_install.jpg" border="0" height="25"></a></td>
                                                                                </tr>
                                                                                <tr>
                                                                                        <td colspan="2">&nbsp;</td>
                                                                                </tr>
                                                                                <tr>
                                                                                        <td width="24%"><b><font size="-1">Home URL&nbsp;:</font></b></td>
                                                                                        <td width="76%"><a style="cursor:pointer" href="<?php echo $txtSiteURL;?>/"><?php echo $txtSiteURL;?>/<img src="../img/home_page.jpg" border="0" height="25"></a></td>
                                                                                </tr>
                                                                                                                                </table>
                                                        </fieldset>
                                                        </td>
                                                </tr>
                                                <tr>
                                                        <td align="center" class="maintext" height="20" >&nbsp;</td>
                                                </tr>
                                        </table>
                                </td>
                        </tr>
                </table>
                <?php
                }
                ?>
            </td>
        </tr>
    </table>
    <table width="100%"  border="0" cellspacing="0" cellpadding="0">
        <tr>
            <td valign="top"><table width="100%"  border="0" cellspacing="0" cellpadding="10">
                    <tr>
                        <td><table width="100%"  border="0" cellspacing="0" cellpadding="0">
                                <tr>
                                    <td valign="top"><table width="100%"  border="0" cellspacing="0" cellpadding="3">
                                            <tr>
                                                <td height="43" class="bigfont1" align="center"><div align="center" class="copyright"><!-- footr links comes here --></div></td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table></td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>