DROP TABLE IF EXISTS `cms_groups`;
CREATE TABLE IF NOT EXISTS `cms_groups` (
  `id` int(11) NOT NULL auto_increment,
  `group_name` varchar(50) default NULL,
  `position` int(3) default '0',
  `published` tinyint(1) default '1',
  `user_privilege` varchar(256) NOT NULL default 'all',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `cms_privileges`;
CREATE TABLE IF NOT EXISTS `cms_privileges` (
  `privilege_id` int(11) NOT NULL auto_increment,
  `entity_type` enum('group','section') NOT NULL,
  `entity_id` int(11) NOT NULL,
  `view_role_id` int(11) NOT NULL,
  `add_role_id` int(11) NOT NULL,
  `edit_role_id` int(11) NOT NULL,
  `delete_role_id` int(11) NOT NULL,
  `publish_role_id` int(11) NOT NULL,
  PRIMARY KEY  (`privilege_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `cms_roles`;
CREATE TABLE IF NOT EXISTS `cms_roles` (
  `role_id` int(11) NOT NULL auto_increment,
  `role_name` varchar(256) NOT NULL,
  `parent_role_id` int(11) NOT NULL,
  PRIMARY KEY  (`role_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `cms_sections`;
CREATE TABLE IF NOT EXISTS `cms_sections` (
  `id` int(8) NOT NULL auto_increment,
  `group_id` int(8) default NULL,
  `section_name` varchar(200) default NULL,
  `section_alias` varchar(200) default NULL,
  `table_name` varchar(100) default NULL,
  `section_config` text,
  `visibilty` enum('0','1') NOT NULL,
  `display_order` int(11) NOT NULL,
  `user_privilege` varchar(256) NOT NULL default 'all',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `cms_users`;
CREATE TABLE IF NOT EXISTS `cms_users` (
  `id` int(11) NOT NULL auto_increment,
  `type` enum('sadmin','admin') NOT NULL,
  `username` varchar(256) NOT NULL,
  `password` varchar(256) NOT NULL,
  `email` varchar(256) NOT NULL,
  `role_id` int(11) NOT NULL,
  `status` enum('active','deleted') NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sessions`;
CREATE TABLE IF NOT EXISTS `sessions` (
  `session_id` varchar(100) NOT NULL default '',
  `session_data` text NOT NULL,
  `expires` int(11) NOT NULL default '0',
  PRIMARY KEY  (`session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `tbl_accomodation_types`;
CREATE TABLE IF NOT EXISTS `tbl_accomodation_types` (
  `nAt_Id` bigint(20) NOT NULL auto_increment,
  `vAt_Name` varchar(100) default NULL,
  `vAt_Description` varchar(250) default NULL,
  `vActive` varchar(10) NOT NULL default 'active',
  PRIMARY KEY  (`nAt_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_affiliates`;
CREATE TABLE IF NOT EXISTS `tbl_affiliates` (
  `aff_id` int(11) NOT NULL auto_increment,
  `aff_email` varchar(100) NOT NULL,
  `aff_pwd` varchar(255) NOT NULL,
  `aff_activation_key` varchar(100) NOT NULL,
  `aff_fname` varchar(100) NOT NULL,
  `aff_lname` varchar(100) NOT NULL,
  `aff_address1` text NOT NULL,
  `aff_address2` text NOT NULL,
  `aff_city` varchar(100) NOT NULL,
  `aff_country` varchar(100) NOT NULL,
  `aff_state` varchar(100) NOT NULL,
  `aff_zip` varchar(10) NOT NULL,
  `aff_phone` varchar(15) NOT NULL,
  `aff_fax` varchar(10) NOT NULL,
  `aff_regdate` varchar(30) NOT NULL,
  `aff_status` tinyint(1) NOT NULL,
  PRIMARY KEY  (`aff_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_affiliates_links`;
CREATE TABLE IF NOT EXISTS `tbl_affiliates_links` (
  `link_id` int(11) NOT NULL auto_increment,
  `link_name` varchar(255) NOT NULL,
  `link_image` varchar(255) NOT NULL,
  `link_status` tinyint(1) NOT NULL COMMENT '1-> active; 0 -> disabled',
  `link_type` tinyint(1) NOT NULL COMMENT '0-> image link,  1-> text link',
  PRIMARY KEY  (`link_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_affiliate_useraction`;
CREATE TABLE IF NOT EXISTS `tbl_affiliate_useraction` (
  `ua_id` int(11) NOT NULL auto_increment,
  `ua_aff_id` int(11) NOT NULL,
  `ua_userid` int(11) NOT NULL,
  `ua_actiontype` tinyint(1) NOT NULL COMMENT '1-> registration, 2-> booking',
  `ua_booking_id` int(11) NOT NULL,
  `ua_actiondate` varchar(30) NOT NULL,
  `ua_payment` decimal(10,0) NOT NULL,
  `ua_referalcharge` decimal(10,0) NOT NULL,
  `ua_paystatus` tinyint(1) NOT NULL COMMENT '1-> Un paid, 2 ->paid, 3->rejected',
  `ua_displaystatus` tinyint(1) NOT NULL COMMENT '1->show; 2->hide',
  `ua_date_settled` datetime NOT NULL,
  `ua_settled_ref` varchar(100) NOT NULL,
  `ua_settled_type` tinyint(1) NOT NULL COMMENT '1=>Cheque,2=>DD',
  PRIMARY KEY  (`ua_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_allotment`;
CREATE TABLE IF NOT EXISTS `tbl_allotment` (
  `nAllotment_Id` bigint(20) NOT NULL auto_increment,
  `nBooking_Id` bigint(20) NOT NULL default '0',
  `nAat_Id` bigint(20) NOT NULL default '0',
  `dDate` date NOT NULL default '0000-00-00',
  `nAdults` int(10) unsigned default NULL,
  `nChildren` int(10) unsigned default NULL,
  `vStatus` varchar(10) NOT NULL default 'booked',
  `nDays` int(11) NOT NULL default '0',
  `dNewDate` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`nAllotment_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_audit`;
CREATE TABLE IF NOT EXISTS `tbl_audit` (
  `id` int(11) NOT NULL auto_increment,
  `audit_table` varchar(255) default NULL,
  `audit_data` longtext,
  `where_condition` text,
  `audit_type` enum('insert','update','delete') default NULL,
  `created_by` int(11) default NULL,
  `created_on` datetime default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_available_acco_type`;
CREATE TABLE IF NOT EXISTS `tbl_available_acco_type` (
  `nAat_Id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	`nLocation_Id` BIGINT(20) NULL DEFAULT NULL,
	`nAt_Id` BIGINT(20) NULL DEFAULT NULL,
	`vCode` VARCHAR(100) NULL DEFAULT NULL,
	`vImage` VARCHAR(250) NULL DEFAULT NULL,
	`nAdults` INT(10) UNSIGNED NULL DEFAULT NULL,
	`nChildren` INT(10) UNSIGNED NULL DEFAULT NULL,
	`additional_guest_allowed` INT(10) UNSIGNED NULL DEFAULT NULL,
	`additional_guest_rate` FLOAT UNSIGNED NULL DEFAULT NULL,
	`vActive` VARCHAR(10) NULL DEFAULT 'active',
	`nAmount` VARCHAR(200) NULL DEFAULT NULL,
	`nRoom` BIGINT(20) NOT NULL DEFAULT '1',
	`file_id` INT(11) NOT NULL,
	`created_on` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`nAat_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `tbl_bank_details`;
CREATE TABLE IF NOT EXISTS `tbl_bank_details` (
  `bid` int(10) unsigned NOT NULL auto_increment,
  `paymentId` int(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `bank` varchar(255) NOT NULL,
  `reference_no` varchar(255) NOT NULL,
  `payment_mode` varchar(50) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY  (`bid`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_Banners`;
CREATE TABLE IF NOT EXISTS `tbl_Banners` (
  `nBId` int(11) NOT NULL auto_increment,
  `vName` varchar(200) default NULL,
  `vlocUrl` varchar(200) default NULL,
  `vImg` varchar(200) default NULL,
  `nDate` date NOT NULL default '0000-00-00',
  `vWidth` varchar(100) default NULL,
  `vHeight` varchar(100) default NULL,
  `nPosition` int(11) default NULL,
  `vActive` enum('1','0') default '0',
  `vLocation` varchar(10) default NULL,
  `nCount` int(11) default '0',
  `nType` varchar(6) default 'Normal',
  `vOpenxDes` text,
  `file_id` int(11) NOT NULL,
  PRIMARY KEY  (`nBId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_booking`;
CREATE TABLE IF NOT EXISTS `tbl_booking` (
  `nBooking_Id` bigint(20) NOT NULL auto_increment,
  `nCust_Id` bigint(20) default NULL,
  `dArrival_Date` datetime default NULL,
  `dBooking_Date` datetime default NULL,
  `vBooking_Details` text,
  `nNights_Stay` int(10) unsigned default NULL,
  `nAdults` int(10) unsigned default NULL,
  `nChildren` int(10) unsigned default NULL,
  `nRooms` int(11) NOT NULL,
  `nAmount` double(20,2) default NULL,
  `nReserveModeAmount` double(20,2) default NULL COMMENT 'Reservemode amount set by admin at the booking time',
  `vStatus` varchar(20) default 'pending',
  `dCancelDate` date NOT NULL default '0000-00-00',
  `vBookedBy` enum('USERS','ADMIN') NOT NULL default 'USERS',
  `cancellationStatus` varchar(50) NOT NULL,
  `api_flag` enum('Y','N') NOT NULL default 'N' COMMENT 'flag to know whether this booking is done through any third part api',
  PRIMARY KEY  (`nBooking_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_cms_settings`;
CREATE TABLE IF NOT EXISTS `tbl_cms_settings` (
  `id` int(11) NOT NULL auto_increment,
  `cms_set_name` varchar(100) NOT NULL,
  `cms_set_value` varchar(255) NOT NULL,
  `created_on` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_content`;
CREATE TABLE IF NOT EXISTS `tbl_content` (
  `nContent_Id` bigint(20) NOT NULL auto_increment,
  `vPage` varchar(100) NOT NULL default '',
  `vLocation` varchar(100) NOT NULL default '',
  `vContent` text NOT NULL,
  PRIMARY KEY  (`nContent_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_country`;
CREATE TABLE IF NOT EXISTS `tbl_country` (
  `tc_id` bigint(20) NOT NULL auto_increment,
  `tc_code` varchar(20) default NULL,
  `tc_name` varchar(250) default NULL,
  `tc_status` char(1) default 'A',
  PRIMARY KEY  (`tc_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_customers`;
CREATE TABLE IF NOT EXISTS `tbl_customers` (
  `nCust_Id` bigint(20) NOT NULL auto_increment,
  `vLogin` varchar(100) NOT NULL default '',
  `vPassword` varchar(100) NOT NULL default '',
  `vFirstname` varchar(150) NOT NULL default '',
  `vLastname` varchar(150) NOT NULL default '',
  `vEmail` varchar(100) NOT NULL default '',
  `vAddress1` varchar(250) NOT NULL default '',
  `vAddress2` varchar(250) NOT NULL default '',
  `vCity` varchar(150) NOT NULL default '',
  `vState` varchar(100) NOT NULL default '',
  `vCountry` varchar(100) NOT NULL default '',
  `vZip` varchar(20) NOT NULL default '',
  `vMobile` varchar(25) default NULL,
  `vTelephone` varchar(20) NOT NULL default '',
  `vFax` varchar(25) NOT NULL default '',
  `activation_key` varchar(255) default '',
  `dDatejoin` date NOT NULL default '0000-00-00',
  `vActive` varchar(10) NOT NULL default 'active',
  PRIMARY KEY  (`nCust_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COMMENT='main actors in the system' AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_destination`;
CREATE TABLE IF NOT EXISTS `tbl_destination` (
  `nDestination_Id` bigint(20) NOT NULL auto_increment,
  `vDestination_Name` varchar(150) NOT NULL default '',
  `nDestination_Price` float NOT NULL default '0',
  `tDestination_Description` text NOT NULL,
  `tPromotional_Offers` text NOT NULL,
  `vDest_Header_Image` varchar(250) NOT NULL default '',
  `vImage` varchar(250) default NULL,
  `file_id` int(11) NOT NULL,
  `vStatus` varchar(10) NOT NULL default 'active',
  PRIMARY KEY  (`nDestination_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_enquiry`;
CREATE TABLE IF NOT EXISTS `tbl_enquiry` (
  `nEnq_Id` bigint(20) NOT NULL auto_increment,
  `vName` varchar(150) NOT NULL default '',
  `vPhone` varchar(50) NOT NULL default '',
  `vEmail` varchar(100) NOT NULL default '',
  `vAddress` varchar(150) NOT NULL default '',
  `tComments` text NOT NULL,
  `dPasted_Date` date NOT NULL default '0000-00-00',
  `status` int(11) NOT NULL COMMENT '0 for received and 1 for replied',
  PRIMARY KEY  (`nEnq_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_featured`;
CREATE TABLE IF NOT EXISTS `tbl_featured` (
  `nFeatured_Id` bigint(20) NOT NULL auto_increment,
  `nDestination_Id` bigint(20) NOT NULL default '0',
  `vFeatured_Package` text NOT NULL,
  PRIMARY KEY  (`nFeatured_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_feedbacks`;
CREATE TABLE IF NOT EXISTS `tbl_feedbacks` (
  `nFeedback_Id` bigint(20) NOT NULL auto_increment,
  `vName` varchar(150) NOT NULL default '',
  `vPhone` varchar(50) NOT NULL default '',
  `vEmail` varchar(100) NOT NULL default '',
  `vAddress` varchar(150) NOT NULL default '',
  `vDestination` varchar(150) NOT NULL default '',
  `tComments` text NOT NULL,
  `dPasted_Date` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`nFeedback_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=24 ;


DROP TABLE IF EXISTS `tbl_files`;
CREATE TABLE IF NOT EXISTS `tbl_files` (
  `file_id` int(11) NOT NULL auto_increment,
  `file_orig_name` varchar(255) default NULL,
  `file_extension` varchar(10) default NULL,
  `file_mime_type` varchar(50) default NULL,
  `file_type` varchar(50) default NULL COMMENT 'video/photo',
  `file_width` int(4) default NULL,
  `file_height` int(4) default NULL,
  `file_play_time` int(11) default NULL,
  `file_size` int(11) default NULL,
  `file_path` text,
  `file_status` int(11) default NULL,
  `file_title` varchar(255) default NULL,
  `file_caption` text,
  `file_tmp_name` varchar(255) default NULL,
  `created_on` datetime default NULL,
  `created_by` int(11) default NULL,
  PRIMARY KEY  (`file_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_gallery`;
CREATE TABLE IF NOT EXISTS `tbl_gallery` (
  `nGallery_Id` bigint(20) NOT NULL auto_increment,
  `nLocation_Id` bigint(20) default NULL,
  `nDestination_id` bigint(20) default NULL,
  `vTitle` varchar(250) default NULL,
  `vURL` varchar(250) default NULL,
  `vType` varchar(50) NOT NULL default 'destination',
  `file_id` int(11) NOT NULL,
  PRIMARY KEY  (`nGallery_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_group_discounts`;
CREATE TABLE IF NOT EXISTS `tbl_group_discounts` (
  `discount_id` int(10) NOT NULL auto_increment,
  `nAat_id` int(10) default NULL,
  `group_size` int(10) default NULL,
  `group_size_range` int(10) default NULL,
  `discount_percentage` float default NULL,
  PRIMARY KEY  (`discount_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_Help`;
CREATE TABLE IF NOT EXISTS `tbl_Help` (
  `hid` int(11) NOT NULL auto_increment,
  `hcid` int(11) default NULL,
  `htitle` varchar(100) default NULL,
  `hdescription` text,
  `hposition` int(11) default NULL,
  `active` enum('0','1') default NULL,
  `himage` varchar(100) default NULL,
  `file_id` int(11) NOT NULL,
  PRIMARY KEY  (`hid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_HelpCategory`;
CREATE TABLE IF NOT EXISTS `tbl_HelpCategory` (
  `hcid` int(11) NOT NULL auto_increment,
  `htype` varchar(6) default NULL,
  `hctitle` varchar(100) default NULL,
  `hcposition` int(11) default NULL,
  `active` enum('0','1') default NULL,
  PRIMARY KEY  (`hcid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_language`;
CREATE TABLE IF NOT EXISTS `tbl_language` (
  `id` int(8) NOT NULL,
  `lang_id` char(50) NOT NULL default 'en',
  `lang_key` varchar(100) default NULL,
  `lang_value` text character set utf8 collate utf8_unicode_ci,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `tbl_locations`;
CREATE TABLE IF NOT EXISTS `tbl_locations` (
  `nLocation_Id` bigint(20) NOT NULL auto_increment,
  `nDestination_Id` bigint(20) NOT NULL default '0',
  `vLocation_Name` varchar(250) NOT NULL default '',
  `vLocation_Description` text,
  `vAmenities` longtext NOT NULL,
  `vAddress` varchar(250) default NULL,
  `vCity` varchar(25) default NULL,
  `vState` varchar(25) default NULL,
  `vZip` varchar(10) default NULL,
  `vCountry` varchar(50) default NULL,
  `vLatitude` varchar(50) default NULL,
  `vLongtitude` varchar(50) default NULL,
  `nStartingPrice` double NOT NULL default '0',
  `vFeatured` varchar(5) NOT NULL default 'No',
  `vActive` varchar(10) default 'active',
  PRIMARY KEY  (`nLocation_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_lookup`;
CREATE TABLE IF NOT EXISTS `tbl_lookup` (
  `nLookUp_Id` bigint(20) NOT NULL auto_increment,
  `vLookUp_Name` varchar(100) NOT NULL default '',
  `vLookUp_Value` text NOT NULL,
  `settinglabel` varchar(250) NOT NULL,
  `groupLabel` varchar(50) NOT NULL,
  `type` varchar(256) NOT NULL,
  PRIMARY KEY  (`nLookUp_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_mail_template`;
CREATE TABLE IF NOT EXISTS `tbl_mail_template` (
  `id` int(5) unsigned NOT NULL auto_increment,
  `mail_template_name` varchar(255) collate latin1_general_ci NOT NULL,
  `mail_template_sub` varchar(255) collate latin1_general_ci NOT NULL,
  `mail_template_body` text collate latin1_general_ci NOT NULL,
  `mail_template_status` smallint(1) NOT NULL,
  `created_on` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  KEY `test` (`id`),
  FULLTEXT KEY `mail_template_title` (`mail_template_sub`,`mail_template_body`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci COMMENT='templates for all emails sent out from system' AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_MetaTags`;
CREATE TABLE IF NOT EXISTS `tbl_MetaTags` (
  `nId` int(11) NOT NULL auto_increment,
  `vTitle` varchar(200) default NULL,
  `vKeywords` text,
  `vDescription` text,
  `vPageName` varchar(225) default NULL,
  PRIMARY KEY  (`nId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_News`;
CREATE TABLE IF NOT EXISTS `tbl_News` (
  `nid` int(11) NOT NULL auto_increment,
  `ntitle` varchar(100) default NULL,
  `ndescription` text,
  `nthumb_image` varchar(250) default NULL,
  `nimage` varchar(250) default NULL,
  `nposition` int(11) default NULL,
  `active` enum('0','1') default '0',
  `cur_date` date default '0000-00-00',
  `exp_date` date default '0000-00-00',
  `file_id` int(11) NOT NULL,
  PRIMARY KEY  (`nid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_offer_price`;
CREATE TABLE IF NOT EXISTS `tbl_offer_price` (
  `offer_price_id` int(10) NOT NULL auto_increment,
  `nAat_Id` int(10) NOT NULL default '0',
  `offer_start_date` date NOT NULL,
  `offer_end_date` date NOT NULL,
  `price` float NOT NULL,
  `published` tinyint(1) NOT NULL default '0',
  `created_on` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`offer_price_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_packages`;
CREATE TABLE IF NOT EXISTS `tbl_packages` (
  `nPackage_Id` bigint(20) NOT NULL auto_increment,
  `nDestination_Id` bigint(20) NOT NULL default '0',
  `vPackage_Title` varchar(250) NOT NULL default '',
  `vSpecial_Offer` varchar(200) NOT NULL default '',
  `vPackage_Description` text NOT NULL,
  `vPackage_photo_below_Description` text NOT NULL,
  `vPackage_Right_Description` text NOT NULL,
  `vPackage_Bottom_Description` text NOT NULL,
  `nAmount` double NOT NULL default '0',
  `vFeatured` varchar(4) NOT NULL default 'No',
  `vPackage_Image` varchar(200) NOT NULL default '',
  `vPackage_Status` varchar(20) NOT NULL default 'active',
  `file_id` int(11) NOT NULL,
  PRIMARY KEY  (`nPackage_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_payment`;
CREATE TABLE IF NOT EXISTS `tbl_payment` (
  `nPayment_Id` bigint(20) NOT NULL auto_increment,
  `nBooking_Id` bigint(20) default NULL,
  `vTxn_Id` varchar(250) default NULL,
  `dDate_Settled` datetime default '0000-00-00 00:00:00',
  `vPayment_Type` varchar(100) default NULL,
  `vStatus` varchar(10) default 'No',
  `vCapture` enum('Y','N') NOT NULL default 'Y',
  `vType` enum('O','C') NOT NULL default 'O',
  `nCancelAmt` double NOT NULL default '0',
  `transactionType` enum('BOOKING','CANCEL') NOT NULL default 'BOOKING',
  PRIMARY KEY  (`nPayment_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_Range`;
CREATE TABLE IF NOT EXISTS `tbl_Range` (
  `nRId` int(11) NOT NULL auto_increment,
  `day_start_range` int(11) NOT NULL default '0',
  `day_end_range` int(11) NOT NULL,
  `vType` char(3) NOT NULL default '',
  `nAmount` float NOT NULL default '0',
  `vActive` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`nRId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_rating`;
CREATE TABLE IF NOT EXISTS `tbl_rating` (
  `nRatingId` bigint(20) NOT NULL auto_increment,
  `nCust_Id` bigint(20) NOT NULL,
  `nLocation_Id` bigint(20) NOT NULL,
  `nDestination_Id` bigint(20) NOT NULL,
  `nMarks` bigint(20) NOT NULL,
  `vFeedbackTitle` varchar(250) NOT NULL,
  `vFeedback` TEXT NULL,
  `dPosted_Date` datetime NOT NULL,
  `vRate_Status` varchar(20) NOT NULL default 'deactive',
  `vFeedback_Status` varchar(20) NOT NULL,
  PRIMARY KEY  (`nRatingId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_referrals`;
CREATE TABLE IF NOT EXISTS `tbl_referrals` (
  `nReferral_Id` bigint(20) NOT NULL auto_increment,
  `nCust_Id` bigint(20) default NULL,
  `nReffered_Customers` bigint(20) default NULL,
  `nAmount` float(5,2) default NULL,
  `dDate_Join` datetime default NULL,
  `vStatus` varchar(10) default 'No',
  `vPaidStatus` varchar(10) default 'Yes',
  `dDate_Settled` datetime default NULL,
  `vSettled_Ref` varchar(50) default NULL,
  `vSettled_Type` varchar(50) default NULL,
  PRIMARY KEY  (`nReferral_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_reviews`;
CREATE TABLE IF NOT EXISTS `tbl_reviews` (
  `review_id` int(10) NOT NULL auto_increment,
  `reviewType` enum('Dst','Loc','Usr') NOT NULL,
  `reviewTitle` varchar(200) NOT NULL,
  `reviewed_entity_id` int(10) NOT NULL,
  `reviewDescription` text NOT NULL,
  `createdBy` int(10) NOT NULL,
  `createdOn` datetime NOT NULL,
  `isApproved` tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (`review_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;


DROP TABLE IF EXISTS `tbl_special_offers`;
CREATE TABLE IF NOT EXISTS `tbl_special_offers` (
  `nSp_Id` bigint(20) NOT NULL auto_increment,
  `nLocation_Id` int(11) NOT NULL default '0',
  `vTitle` varchar(200) NOT NULL default '',
  `tDescription` text NOT NULL,
  `nRate` double NOT NULL default '0',
  `dStartDate` date NOT NULL default '0000-00-00',
  `dEndDate` date NOT NULL default '0000-00-00',
  `vActive` enum('0','1') NOT NULL default '0',
  `file_id` int(11) NOT NULL,
  PRIMARY KEY  (`nSp_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_state`;
CREATE TABLE IF NOT EXISTS `tbl_state` (
  `ts_id` bigint(20) NOT NULL auto_increment,
  `tc_id` bigint(20) default '0',
  `ts_code` varchar(20) default NULL,
  `ts_name` varchar(250) default NULL,
  `ts_status` char(1) default 'A',
  PRIMARY KEY  (`ts_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `tbl_tickets`;
CREATE TABLE IF NOT EXISTS `tbl_tickets` (
  `nTicket_Id` bigint(20) NOT NULL auto_increment,
  `vTitle` varchar(250) NOT NULL default '',
  `vDescription` text NOT NULL,
  `nAmount` bigint(20) NOT NULL default '0',
  `vType` varchar(150) NOT NULL default '',
  `vTicket_Image` varchar(100) NOT NULL default '',
  `vTicketStatus` varchar(10) NOT NULL default 'active',
  PRIMARY KEY  (`nTicket_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tbl_expedia_location_details`;
CREATE TABLE IF NOT EXISTS `tbl_expedia_location_details` (
  `ex_id` int(11) NOT NULL auto_increment,
  `booking_id` int(11) NOT NULL,
  `locationid` int(11) NOT NULL,
  `location_name` varchar(255) NOT NULL,
  `destination_name` varchar(255) NOT NULL,
  `accomadation_name` varchar(255) NOT NULL,
  PRIMARY KEY  (`ex_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `fw_metadata`;
CREATE TABLE IF NOT EXISTS `fw_metadata` (
  `id` int(11) NOT NULL auto_increment,
  `url` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `keyword` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `tbl_navigation`;
CREATE TABLE `tbl_navigation` (
  `id` int(11) NOT NULL auto_increment,
  `navigation` varchar(45) default NULL,
  `label` varchar(45) default NULL,
  `url` varchar(45) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `tbl_currency_master`;
CREATE TABLE IF NOT EXISTS `tbl_currency_master`(`currency_id` int(11) NOT NULL auto_increment,`currency_name` varchar(250) NOT NULL ,`currency_code` varchar(10) NOT NULL,`currency_symbol` varchar(10) NOT NULL,`status` varchar(50) default NULL,PRIMARY KEY(`currency_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS `tbl_accomodation_seasonal_rates`;
CREATE TABLE IF NOT EXISTS `tbl_accomodation_seasonal_rates` (
 `seasonal_id` int(10) NOT NULL auto_increment,
 `accomodationId` int(10) default NULL,
 `rates` varchar(200) default NULL,
 `created_on` timestamp NULL default CURRENT_TIMESTAMP,
 `start_date` date default NULL,
 `end_date` date default NULL,
 PRIMARY KEY  (`seasonal_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


ALTER TABLE `tbl_destination` ADD COLUMN `destination_alias` VARCHAR(150) NOT NULL DEFAULT '' AFTER `vDestination_Name`;
ALTER TABLE `tbl_packages` ADD COLUMN `package_alias` VARCHAR(250) NOT NULL DEFAULT '' AFTER `vPackage_Title`;
ALTER TABLE `tbl_special_offers` ADD COLUMN `vAlias` VARCHAR(500) NOT NULL AFTER `tDescription`;
ALTER TABLE `tbl_locations` ADD COLUMN `location_alias` VARCHAR(250) NOT NULL DEFAULT '' AFTER `vLocation_Name`;

ALTER TABLE `tbl_allotment`
	ADD COLUMN `NoOfRooms` INT(10) UNSIGNED NULL DEFAULT NULL AFTER `nChildren`;
