/* generalized maps logics */
var count;
var plottedTitles = new Array();
var plottedLats = new Array();
var plottedLongs = new Array();
var plottedMarkerTags = new Array();
var Maps = {
    objMap: null,
    mapRadius:10,
    zoom:9,     
    mapCenter:[40.7143528, -74.0059731],
    markerCoordinates:[],
    markerData:[],
    infoBox:null,    
    objectsOnmap: [],
    animationEffect : false,
    addBounceListeners : false,
    bounceListenerElementIdPrefix : null,
    
    loadMap:function(container_id){

        

        var mapOptions = {
            center: new google.maps.LatLng(Maps.mapCenter[0], Maps.mapCenter[1]), //default center
            zoom: Maps.zoom,
            mapTypeId: google.maps.MapTypeId.ROADMAP,
            streetViewControl: false,
            mapTypeControl: false,
            scaleControl:true,
            panControl:true
            

        };

        Maps.objMap = new google.maps.Map(document.getElementById(container_id), mapOptions);
        Maps.drawRadius();
         
        
        var infoBoxOptions = {
            pixelOffset: new google.maps.Size(-87, -106),
            boxStyle: {
                //background: "url('"+MAIN_URL+"/project/images/map/map-info-box.png') no-repeat",
                background: "#fff",
                border: "1px solid #0099FF",
                width: "250px",
                opacity: 0.85,
                padding: "3px"

            }
        };
         
        Maps.infoBox = new InfoBox(infoBoxOptions);

       

    },

    addMarkerTag:function(lat,lng,title,infoData,markerImage,URL){

        var  markerObjectSet = false;
        var myHtml  = infoData;

        var myLatlng = new google.maps.LatLng(lat, lng);
        var marker = new google.maps.Marker({
            position: myLatlng,
            title :  title ,
            icon: markerImage
            
        });
        
        
        var checkTitleIndex = jQuery.inArray(title,plottedTitles);
        
        var setMarker = false;
        if(checkTitleIndex == -1){
           setMarker = true;
        }else{
            if(plottedLats[checkTitleIndex] == lat || plottedLongs[checkTitleIndex] ==lng)
                setMarker = false;
            else
                setMarker = true;
        }
       
        if(setMarker){
            marker.setMap(Maps.objMap);
            Maps.objectsOnmap.push(marker);
            markerObjectSet = true;

            plottedTitles.push(title);
            plottedLats.push(lat);
            plottedLongs.push(lng);
            plottedMarkerTags.push(marker);
           
        }else{
            marker = plottedMarkerTags[checkTitleIndex];
            markerObjectSet = true;
       }
      
     
        if(markerObjectSet)
            Maps.setMarkerClickHandler(marker,lat,lng,myHtml,markerImage,URL);
    },

    setMarkerClickHandler: function(marker_obj, lat,lng,infoData,markerImage,URL) {
  
        /*
        var myHtml  = '<div class="results_text_content"><h4>';
            myHtml += title;
            myHtml += '</h4>'+venueName+'</div>';
        */
        google.maps.event.addListener(marker_obj, 'click', function() {
            //Maps.infoBox.setContent(infoData);
            //Maps.infoBox.open(Maps.objMap, marker_obj);

            
            document.location.href=URL;

             marker_obj.setAnimation(null);

        });

        google.maps.event.addListener(marker_obj,"mouseover",function() {  
          //marker_obj.setIcon(JQdefaultLocationToolTip_Active);
          if(Maps.animationEffect){
            marker_obj.setAnimation(google.maps.Animation.BOUNCE);
            setTimeout(function(){marker_obj.setAnimation(null);}, 750);
          }

        });

        google.maps.event.addListener(marker_obj,"mouseup",function() { 
            marker_obj.setAnimation(null);


        });

        google.maps.event.addListener(marker_obj,"mousedown",function() {
            marker_obj.setAnimation(null);


        });

        google.maps.event.addListener(marker_obj,"mouseout",function() {
          //marker_obj.setIcon(markerImage);
          

        });

        if(Maps.addBounceListeners){
           
             google.maps.event.addDomListener(document.getElementById(Maps.bounceListenerElementIdPrefix+count), 'mouseover', function() {
                
                marker_obj.setAnimation(google.maps.Animation.BOUNCE);
                setTimeout(function(){marker_obj.setAnimation(null);}, 780);
            });
            google.maps.event.addDomListener(document.getElementById(Maps.bounceListenerElementIdPrefix+count), 'mouseout', function() {
                marker_obj.setAnimation(null);
              
            });
            count++;
        }
       


        //'mouseup'
        // 'mousedown'

    },

    redrawMarkers:function(){
        Maps.clearOverlays();
        Maps.drawRadius();
    },

    //draw the radius currently defaulted to 10
    drawRadius:function(){

        var circle = new google.maps.Circle({
            map: Maps.objMap,
            center: new google.maps.LatLng(Maps.mapCenter[0], Maps.mapCenter[1]),
            radius: 1.609344 * (Maps.mapRadius) * 1000,
            strokeOpacity: 0,
            fillColor: "#CC0000",
            fillOpacity: 0.15

        });
        Maps.objectsOnmap.push(circle);
    },

    //clear all the overlays in the map
    clearOverlays:function() {
        if (Maps.objectsOnmap) {
            for (i in Maps.objectsOnmap) {
                Maps.objectsOnmap[i].setMap(null);

            }
        }
    }

}

/*
$(function() {
    Maps.mapCenter = new Array(40.73586, -73.99108);
    Maps.loadMap("map_canvas");
    //Maps.drawRadius();
    Maps.addMarkerTag();
}); */

/*
setMarkerClickHandler: function(marker_obj, index) {
	var isSearchResults = $("body").hasClass("search-results-new");
	var myHtml = '<div class="info-window-content"><h1>';
	if (isSearchResults) myHtml += '<a href ="'+ Search.locations[index].url + '">';
	myHtml += Search.locations[index].name;
	if (isSearchResults) myHtml += '</a>';
	myHtml += '</h1><h2>' + Search.locations[index].address + '</h2></div>';

	google.maps.event.addListener(marker_obj, 'click', function() {
		Search.infoBox.setContent(myHtml);
		Search.infoBox.open(Search.map, marker_obj);

		// Set the icon on all the other markers that are on the map to the
		// default marker. This is quite a bad hack.
		for (var i = 0; i < Search.objectsOnMap.length; i++) {
			Search.objectsOnMap[i].setIcon('/img/map/map-pin-default.png');
		}
		marker_obj.setIcon('/img/map/map-pin-hover.png');

		google.maps.event.addListener(Search.infoBox, 'closeclick', function() {
			marker_obj.setIcon('/img/map/map-pin-default.png');
		});
	});
}*/


