<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
class Apputils{

    //Fetches file name from files table
    public static function fetchFileName($fileId){
        $dbh = new Db();
       return $dbh->selectRow("files", "file_path", " file_id=$fileId ");
    }

    //Fetches settings data
    public static function fetchSettings($lookupName){
       $dbh = new Db();
       $lookupName = $dbh->selectRow("lookup", "vLookUp_Value", " vLookUp_Name='$lookupName' ");
       return $lookupName;
        
    }

    //Formats date
    public static function formatDate($date, $time = FALSE)
    {
        $newDate = '--';
        
        if(!empty($date) && $date != '0000-00-00' && $date != '0000-00-00 00:00:00')
        {
            $newDate = ($time) ? date('d M Y H:i',strtotime($date)) : date('jS M, Y',strtotime($date));
        }
        return $newDate;
    }
    
    //Calculate extra amount
 public static function calculateExtraAmount($numberOfPeople,$arrivalDate,$departureDate,$startingPrice,$amountArray,$offerRateDetails=array(),$specialOfferDetails=array(),$seasonalCostArray=null,$accomadationAvailabilityId=null,$numberOfRooms=null) {
    $arrivalDate   = Utils::dateFormat($arrivalDate, 'm-d-Y', 'Y-m-d');
    $departureDate = Utils::dateFormat($departureDate, 'm-d-Y', 'Y-m-d');
    $diff          = abs(strtotime($arrivalDate) - strtotime($departureDate));
    $years         = floor($diff / (365*60*60*24));
    $months        = floor(($diff - $years * 365*60*60*24) / (30*60*60*24));
    $totalDays     = floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24)/ (60*60*24));
	if($totalDays > 0)
	{
        $startDate    = $arrivalDate;

        while($totalDays > 0) {
            $newdate           = explode("-",Apputils::datetimetomysql($arrivalDate));
            $filterdate        = explode(" ",$newdate[2]);
            $arr_date          = $newdate[0]."-".$newdate[1]."-".$filterdate[0];
            $iniTime           = strtotime($arr_date);
            $day	         = $totalDays - 1;
            $specialOfferPercentage = Apputils::checkForSpecialOffer(date('Y-m-d',strtotime($startDate)),$specialOfferDetails);
            if($offerPrice>0)
            {
                $extraAmount      += $offerPrice; 
            }
            else {
                $tempAmount        = $amountArray[Apputils::dayAmount(date('l',strtotime($startDate)))];
                foreach ($seasonalCostArray as $key => $value) {
                    if($startDate >= $value->start_date && $startDate <= $value->end_date) {
                        $rates = $value->rates;
                        if($rates != null && $rates != "" && $rates != 0) {
                            $seasonalRateArray = explode(',', $rates);
                            $tempAmount1       = $seasonalRateArray[Apputils::dayAmount(date('l',strtotime($startDate)))];
                            if($tempAmount1 != null && $tempAmount1 != "" && $tempAmount1 != 0) {
                                $tempAmount       = $tempAmount1;
                                break;
                            }
                        }
                    }
                }
                if($accomadationAvailabilityId) { //echo $numberOfPeople;die;
                    $details   = Booking::isNumberOfPeopleAllowed($accomadationAvailabilityId,$numberOfPeople);
                    if(($details[0]->nAdults*$numberOfRooms) < $numberOfPeople) {
                        $additionalAmount   = ($numberOfPeople - ($details[0]->nAdults*$numberOfRooms)) * ($details[0]->additional_guest_rate/$numberOfRooms);
                        $tempAmount         = $tempAmount + $additionalAmount;
                    }
                }
                //$tempAmount $numberOfPeople
                /*echo $extraAmount.'*';
                echo $tempAmount;*/

                if($specialOfferPercentage>0 && $tempAmount>0)
                $tempAmount        = $tempAmount - ($tempAmount * $specialOfferPercentage / 100);        
                //echo '+++'.$tempAmount.'***';      
		        $extraAmount      += $tempAmount;
            }
            $startDate	   = Apputils::addDay($startDate,1);                        
	        $totalDays--;
	    }
	}
    //echo $extraAmount;die;
	//return round($extraAmount,0);
        return $extraAmount;
 }


                        

public static function calculateMonthlyPrices($locationId,$accomadationId,$arrivalDate,$departureDate,$amountArray,$roomCount,$groupDiscountAmount,$specialOfferDetails=array()) {
        $priceArray             = array();
        $arrivalDate            = Utils::dateFormat($arrivalDate, 'm-d-Y', 'Y-m-d');
        $departureDate          = Utils::dateFormat($departureDate, 'm-d-Y', 'Y-m-d');
        $totalDays              = 31;

	if($totalDays > 0)
	{
          $startDate            = $arrivalDate;

	  while($totalDays > 0)
	  {

	      $newdate           = explode("-",Apputils::datetimetomysql($arrivalDate));
	      $filterdate        = explode(" ",$newdate[2]);
	      $arr_date          = $newdate[0]."-".$newdate[1]."-".$filterdate[0];

              //************* check for booked dates  *****************//


               $tempDate         = Utils::dateFormat($startDate, 'Y-m-d', 'm/d/Y');
               $tempDate2        = Utils::dateFormat($startDate, 'Y-m-d', 'm-d-Y');
               
               $resultArray      = Booking::isAccomadationAvailable($locationId,$accomadationId,$tempDate2,$tempDate2,$roomCount,false);

               if(count($resultArray)>0)
               {
                  $bookedStatus  = 0;
               }
               else
               {
                  $bookedStatus  = 1;
               }

               //************* end of check for booked dates **********//


              $dayNumber         = $filterdate[0];
	      $iniTime           = strtotime($arr_date);
	      $day	         = $totalDays - 1;
               
              $specialOfferPercentage = Apputils::checkForSpecialOffer(date('Y-m-d',strtotime($startDate)),$specialOfferDetails);

              if($offerPrice>0)
              {

                  if($offerPrice>0 && $groupDiscountAmount>0)
                  $offerPrice     = $offerPrice - ($offerPrice * $groupDiscountAmount / 100);

                  $priceArray[$tempDate]['price']           = $offerPrice;
                  $priceArray[$tempDate]['status']          = $bookedStatus;
              }
              else
              {

                  
                  
                  $tempAmount        = $amountArray[Apputils::dayAmount(date('l',strtotime($startDate)))];                 

                  if($specialOfferPercentage>0 && $tempAmount>0)
                  $tempAmount        = $tempAmount - ($tempAmount * $specialOfferPercentage / 100);

                  if($tempAmount>0 && $groupDiscountAmount>0)
                  $tempAmount = $tempAmount - ($tempAmount * $groupDiscountAmount / 100);

                  $priceArray[$tempDate]['price']            = $tempAmount;
                  $priceArray[$tempDate]['status']           = $bookedStatus;
                  
              }


              $startDate	   = Apputils::addDay($startDate,1);
	      $totalDays--;

	   }
	}
	return $priceArray;
 }

public static function checkForOffer($date,$offerRateDetails) {

    if(is_array($offerRateDetails))
    {

        foreach($offerRateDetails as $tempKey =>$tempValue)
        {
            if(in_array($date,$tempValue))
            {
                return $tempKey;
            }
        }
    }
    return 0;
}

public static function checkForSpecialOffer($date,$specialOfferDetails) {   
    if(is_array($specialOfferDetails))
    {
        foreach($specialOfferDetails as $tempKey =>$tempValue)
        {
            if(in_array($date,$tempValue)) {
                return $tempKey;
            }
        }
    }
    return 0;
}
public static function  datetimetomysql($vdate){
    $vdate_ar=explode(" ",$vdate);
    $split_date=explode("-",$vdate_ar[0]);
        $split_time=explode(":",$vdate_ar[1]);
    $day=$split_date[1];
    $mnth=$split_date[0];
    $year=$split_date[2];
    $hour=$split_time[0];
    $minute=$split_time[1];
    $second=$split_time[2];
    if($second=="")
        $second="59";
    return $year."-".$mnth."-".$day." ".$hour.":".$minute.":".$second;
}

//function to check particular day amount key
public static function dayAmount($chkDay)
{
	switch($chkDay)
	{
		case "Sunday":
			$AmountIndx='0';
		break;

		case "Monday":
			$AmountIndx='1';
		break;

		case "Tuesday":
			$AmountIndx='2';
		break;

		case "Wednesday":
			$AmountIndx='3';
		break;

		case "Thursday":
			$AmountIndx='4';
		break;

		case "Friday":
			$AmountIndx='5';
		break;

		case "Saturday":
			$AmountIndx='6';
		break;
	}//end switch
	return ($AmountIndx);
}//end function


public static function addTime()
    {
        $rtnTime = date('Y-m-d',time());
        return $rtnTime;
    }

    public static function addDay($date , $numberOfDays)
    {

       $todayDate = date("Y-m-d");
       $date = strtotime($date . " +".$numberOfDays." day");
       $date = date("Y-m-d",$date);

        return $date;
    }


     public static function removeTime()
    {

        $rtnTime = date('Y-m-d',time());
        return $rtnTime;
    }


    //Function to load google map configurations
    public static function loadGoogleMapConfigurations(){
        $googleMapKey = self::fetchSettings('GoogleMapValue');
        PageContext::addScript("http://maps.googleapis.com/maps/api/js?key=".$googleMapKey."&sensor=true");
        PageContext::addScript('infobox_packed.js');
        PageContext::addJsVar("JQ_enable_google_map_center_point", 'yes');
        PageContext::addScript('map_logics.js');        
        PageContext::addScript('custom_map.js');
        PageContext::addJsVar("JQ_SimilarLocationCounter", 0);
        PageContext::addJsVar('JQcenterLocationToolTip',BASE_URL."project/styles/images/blue_1.png");
        PageContext::addJsVar('JQdefaultLocationToolTip',BASE_URL."project/styles/images/green_1.png");
        PageContext::addJsVar('JQdefaultLocationToolTip_Active',BASE_URL."project/styles/images/red_1.png");

    }


    public static function getSiteLogoUrl()
    {

        $siteLogo = Apputils::fetchSettings('sitelogo');
        return '<img src="'.BASE_URL.'project/styles/images/'.$siteLogo.'"  width=165>';
    }
    
    public static function generateListingExcelReport($dataArray, $reportHeading, $reportFileName ){
        
        $reportColumnCount = count($dataArray['data']);
        $columns = $dataArray['columns'];
        $listDataResults = $dataArray['data'];
        
        $excelData  .=  "<table border='1'><tr>";
        $excelData  .=  "<td colspan=$reportColumnCount>".$reportHeading."</td>";
        $excelData  .=  "</tr></table>";
        $excelData  .=  "<table border='1'><tr>";
        foreach($columns as $column) {
            $excelData  .=   "<td>".$column."</td>";
         }
         
         $excelData  .=  "</tr></table>";
         $excelData  .=   "<table border='1'><tr>";
         
         
            foreach($listDataResults  as $record) {
                $excelData  .=   "<tr>";
                foreach($record as $key =>  $val) {
                    $excelData  .=   "<td width='100px'>".$val."</td>";
                }
                $excelData  .=   "</tr>";
          }
            header("Content-type: application/ms-excel");
            header("Content-Transfer-Encoding: binary");
            header("Content-Disposition: attachment; filename=\"".$reportFileName.".xls\"");
            echo $excelData  .=   "</tr></table>";
    }
    
    public static function sendCustomisedUserMail($customerName, $userMailId, $mailSubject, $mailBodyContent){

 
        PageContext::includePath('phpmailer');
        Logger::info("Entering email functionality");
        $model                = new Db();
        
        $adfromemail          = $model->selectRow("lookup","vLookUp_Value","vLookUp_Name='addressfromemail'");
        $adfromemailname      = $model->selectRow("lookup","vLookUp_Value","vLookUp_Name='addressfromemailname'");
        $adreplyemail         = $model->selectRow("lookup","vLookUp_Value","vLookUp_Name='addressreplyemail'");
        $adreplyemailname     = $model->selectRow("lookup","vLookUp_Value","vLookUp_Name='addressreplyemailname'");
        $settings = Apputils::loadSettings();
       
        
        $mailBodyTemplate = '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">
        <tbody>
        <tr>
            <td colspan="3" height="5">&nbsp;</td>
        </tr>
        <tr>
            <td width="5">&nbsp;</td>
            <td width="586">
                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                    <tbody>
                        <tr>
                            <td height="56">
                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <tbody>
                                        <tr>
                                            <td height="80" width="2%">&nbsp;</td>
                                            <td width="37%">
                                                <img height="33" src="{LOGO_URL}" width="165" />
                                            </td>
                                            <td width="61%">
                                                <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td height="10">&nbsp;</td>
                        </tr>
                        <tr>
                            <td>&nbsp;</td>
                        </tr>
                        <tr>
                            <td>
                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <tbody>
                                        <tr>
                                            <td width="2%">&nbsp;</td>
                                            <td width="97%">
                                                <h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear {NAME},</h3>
                                                <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">
                                                
                                                </p>
                                                {MAIL_BODY}
                                            </td>
                                            <td width="2%">&nbsp;</td>
                                        </tr>
                                        <tr>
                                            <td>&nbsp;</td>
                                            <td>&nbsp;</td>
                                            <td>&nbsp;</td>
                                        </tr>
                                        <tr>
                                            <td>&nbsp;</td>
                                            <td>&nbsp;</td>
                                            <td>&nbsp;</td>
                                        </tr>
                                        <tr>
                                            <td>&nbsp;</td>
                                            <td>
                                            Thank You<br />
                                            Team {SITE_NAME} </td>
                                            <td>&nbsp;</td>
                                        </tr>
                                        <tr>
                                            <td>&nbsp;</td>
                                            <td>&nbsp;</td>
                                            <td>&nbsp;</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <tbody>
                                        <tr>
                                            <td height="30" >
                                                <p style="color:#FFFFFF; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">
                                                    copyright 2012 {SITE_NAME}. All rights reserved</p>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </td>
            <td width="4">&nbsp;</td>
        </tr>
        <tr>
            <td colspan="3" height="10">&nbsp;</td>
        </tr>
        </tbody>
        </table>
        <p>&nbsp;</p>';

        $mailBody             = str_replace('{LOGO_URL}', BASE_URL.'project/styles/images/'.$settings['sitelogo'], $mailBodyTemplate);
        $mailBody             = str_replace('{MAIL_BODY}',$mailBodyContent, $mailBody);
        $mailBody             = str_replace('{SITE_NAME}',$settings['companyName'], $mailBody);
        $mailBody             = str_replace('{Date}',date('m/d/Y'), $mailBody);
        $mailBody             = str_replace('{NAME}',$customerName, $mailBody);
            
        $mail                = new PHPMailer();
        $mail->AddReplyTo($adreplyemail,$adreplyemailname);
        $mail->SetFrom($adfromemail, $adfromemailname);
        $mail->AddAddress($userMailId, "");
        $mail->Subject       = $mailSubject;
        $mail->AltBody       = ''; // optional, comment out and test




        if(Apputils::fetchSettings('email_type') == 'html' )
           $mail->MsgHTML($mailBody); // Send mail as html.
        else
        {

           PageContext::includePath('html2text');
           $h2t           = new html2text($mailBody);

           //$h2t->set_allowed_tags('<table><tr></tr><th></th><td></td></table>');
           
           $mailBody      = $h2t->get_text();
           $mail->MsgPlaintext($mailBody); // Send mail as html.

           //$mail->MsgHTML($mailBody);        // Send mail as html.

        }

        if(ENVIRONMENT != 'LOCAL')
        $mailsent            = $mail->Send();           
        return true;
       
    }


 public static function getCurrnetPageURL($url)
 {

    $pageURL = 'http';

    if($_SERVER["HTTPS"] == "on")
    {
        $pageURL .= "s";
    }
    $pageURL .= "://";

    if($_SERVER["SERVER_PORT"] != "80")
    {
       $pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
    }
    else
    {
       $pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
    }

    return $pageURL;
    
    
}


    //Function to load look up values
    public static function loadSettings(){
        $dbh = new Db();
        $settings = $dbh->selectResult("lookup","vLookUp_Name, vLookUp_Value");
        $settingsArray = array();
        foreach ($settings as $data) {
            $settingsArray[ $data->vLookUp_Name] = $data->vLookUp_Value;
        }
        
        return $settingsArray;
    }
    
    //Fucntion used to calculate paging details for cms section
    public static function calculateResultPageCount($sectionData, $adminPageCount , $page){
        $numRowsListData = count($sectionData);
        $totalResulPages = ceil($numRowsListData/$adminPageCount);
        
        if($page=="")
            $page = 1;

        $startPage = ($page-1)*$adminPageCount;
        $limit = "LIMIT $startPage,$adminPageCount";
        
        return array($totalResulPages, $limit, $numRowsListData);
    }
    
    //Function used to create editor instance for cms section
    public static function createEditorInstance($editorName){
        include_once "public/fckeditor/fckeditor.php" ;
        $sBasePath                              = "public/fckeditor/";
        $oFCKeditor 				= new FCKeditor($editorName) ;
        $oFCKeditor->Id				= $editorName;
        $oFCKeditor->BasePath			=  $sBasePath;
        $oFCKeditor->Width  			= '565' ;
        $oFCKeditor->Height			= '400' ;
        
        return $oFCKeditor;
    }
    
    
    //Function to load site logo
    public static function loadSiteLogo()
    {       
        $siteLogo     = Apputils::fetchSettings('sitelogo');
        
        $physicalPath = './project/styles/images/'.$siteLogo;

        if(file_exists($physicalPath))
           return BASE_URL.'project/styles/images/'.$siteLogo;
        else
           return BASE_URL.'project/styles/images/nologo.png';

        
    }

     public static function loadSiteLogoFooter(){
        return BASE_URL.'project/styles/images/mainbannerlogo-footer.gif';
     }
}

class MkTimer
{
    public $day = 0;
    public $month = 0;
    public $year = 0;
    public $hour = 0;
    public $minute = 0;
    public $sec = 0;
    public $iniTime = '';
    public $returnFormat = "Y-m-d";

    

   
}

?>
