<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
*/
class Cmshelper {

    const INQUIRY_REPLIED_STATUS_STRING = 'Replied';
    const INQUIRY_POST_REPLY_STATUS_STRING = 'Post Reply';

    //Fetches Help Categories
    public static function getAllHelpCategories() {
        $db	    = new Db();
        $getAllHelpCategories = $db->selectResult('HelpCategory','hcid,hctitle'," active='1'");
        $var=0;
        foreach($getAllHelpCategories as $catgory) {
            $result[$var]->value = $catgory->hcid;
            $result[$var]->text = $catgory->hctitle;
            $var++;
        }
        return $result;
    }

    //Fetches Destinations
    public static function getAllDestinations() {
        $db	    = new Db();
        $getAllDestinations = $db->selectResult('destination','nDestination_Id,vDestination_Name'," vStatus='active'");
        $var=0;
        foreach($getAllDestinations as $destination) {
            $result[$var]->value = $destination->nDestination_Id;
            $result[$var]->text = $destination->vDestination_Name;
            $var++;
        }
        return $result;
    }

    //Fetches Locations
    public static function getAllLocations() {
        $db	    = new Db();
        $getAllLocations = $db->selectResult('locations','nLocation_Id,vLocation_Name'," vActive='active' ");
        $var=0;
        foreach($getAllLocations as $location) {
            $result[$var]->value = $location->nLocation_Id;
            $result[$var]->text = $location->vLocation_Name;
            $var++;
        }
        return $result;
    }
    //Fetches Destinations
    public static function getDestinationsHavingAccomodation() {
        $db	    = new Db();
        $getAllDestinations = $db->selectResult('destination D INNER JOIN '.$db->tablePrefix.'locations L ON(L.nDestination_Id = D.nDestination_Id) INNER JOIN '.$db->tablePrefix.'available_acco_type
           AAT ON (L.nLocation_Id = AAT.nLocation_Id) ','DISTINCT(D.nDestination_Id),vDestination_Name'," D.vStatus='active' and L.vActive = 'active'");
       
        $var=0;
        foreach($getAllDestinations as $destination) {
            $result[$var]->value = $destination->nDestination_Id;
            $result[$var]->text = $destination->vDestination_Name;
            $var++;
        }
        return $result;
    }

    //Fetches Locations having accomodation
    public static function getLocationsHavingAccomodation() {
        $db	    = new Db();
        $getAllLocations = $db->selectResult('locations L INNER JOIN '.$db->tablePrefix.'available_acco_type
           AAT ON (L.nLocation_Id = AAT.nLocation_Id) ','DISTINCT(L.nLocation_Id),vLocation_Name'," L.vActive='active' ");
        $var=0;
        foreach($getAllLocations as $location) {
            $result[$var]->value = $location->nLocation_Id;
            $result[$var]->text = $location->vLocation_Name;
            $var++;
        }
        return $result;
    }

    //Fetches Locations by destination
    public static function fetchLocationsByDestination($destinationId) {
        $db	    = new Db();
        $getAllLocations = $db->selectResult('locations L INNER JOIN '.$db->tablePrefix.'available_acco_type AAT
           ON (L.nLocation_Id = AAT.nLocation_Id) ','DISTINCT(L.nLocation_Id),vLocation_Name'," L.vActive='active' AND nDestination_Id=".intval($destinationId));



        return $getAllLocations;
    }

    //Fetches Countries
    public static function getAllCountries() {
        $db	    = new Db();
        $getAllCountries = $db->selectResult('country',"tc_code,tc_name"," tc_status='A'");
        $var=0;
        foreach($getAllCountries as $country) {
            $result[$var]->value = $country->tc_code;
            $result[$var]->text = $country->tc_name;
            $var++;
        }
        return $result;
    }

    //Fetches States
    public static function getAllStates() {
        $db	    = new Db();
        $getAllStates = $db->selectResult('state',"ts_code,ts_name"," ts_status='A'");
        $var=0;
        foreach($getAllStates as $state) {
            $result[$var]->value = $state->ts_code;
            $result[$var]->text = $state->ts_name;
            $var++;
        }
        return $result;
    }


    //Fetches Customer Count
    public static function getCustomerCount($startDate,$endDate) {
        $db     = new Db();
        $count  = $db->getDataCount("customers","nCust_Id"," where vActive='active' AND DATE_FORMAT(dDatejoin,'%Y-%m-%d')>= '".date("Y-m-d",$startDate)."' AND DATE_FORMAT(dDatejoin,'%Y-%m-%d')< '".date("Y-m-d",$endDate)."'");
        return $count;
    }

    //Fetches Accomodation Types
    public static function getAllAccomodationTypes() {
        $db	    = new Db();
        $allAccomodationTypes = $db->selectResult('accomodation_types','nAt_Id,vAt_Name',"  vActive='active'");
        $var=0;
        foreach($allAccomodationTypes as $accomodation) {
            $result[$var]->value = $accomodation->nAt_Id;
            $result[$var]->text = $accomodation->vAt_Name;
            $var++;
        }
        return $result;
    }

    //Fetches accomodation types that does not exist in a location
    public static function getAccomodationTypesNotInLocation($locationId) {
        $db	    = new Db();
        $allAccomodationTypes = $db->selectResult('accomodation_types AT LEFT JOIN '.$db->tablePrefix.'available_acco_type AAT ON(AAT.nAt_Id = AT.nAt_Id AND nLocation_Id='.  intval($locationId).')'
                ,'AT.nAt_Id,AT.vAt_Name',"  AT.vActive='active'  AND AAT.nAt_Id IS NULL");
        $var=0;
        foreach($allAccomodationTypes as $accomodation) {
            $result[$var]->value = $accomodation->nAt_Id;
            $result[$var]->text = $accomodation->vAt_Name;
            $var++;
        }
        return $result;
    }
    //Fetches Accomodation Types
    public static function getAccomodationTypesByLocation($locationId) {
        $db	    = new Db();
        $allAccomodationTypes = $db->selectResult('accomodation_types AT INNER JOIN '.$db->tablePrefix.'available_acco_type AAT ON (AT.nAt_Id = AAT.nAt_Id)','DISTINCT(AT.nAt_Id),AT.vAt_Name',
                "  AT.vActive='active' AND nLocation_Id=".  intval($locationId));
        $var=0;
        foreach($allAccomodationTypes as $accomodation) {
            $result[$var]->value = $accomodation->nAt_Id;
            $result[$var]->text = $accomodation->vAt_Name;
            $var++;
        }
        return $result;
    }
    
    //Fetches Accomodation Types
    public static function getAvailRoomsByAccomodation($accoId,$locationId) {
        $db	    = new Db();
        $rooms = $db->selectRecord('accomodation_types AT INNER JOIN '.$db->tablePrefix.'available_acco_type AAT ON (AT.nAt_Id = AAT.nAt_Id)','AAT.nRoom',
                " AAT.nAt_Id=".intval($accoId)." AND  AT.vActive='active' AND AAT.nLocation_Id=".  intval($locationId));
        if($rooms->nRoom)
            return ($rooms->nRoom);
        else 
           return 0;
        
    }
    
    

    //Fetches Enquiry Count
    public static function getEnquiryCount($startDate,$endDate) {
        $db     = new Db();
        $count  = $db->getDataCount("enquiry","nEnq_Id"," where  DATE_FORMAT(dPasted_Date,'%Y-%m-%d')>= '".$startDate."' AND DATE_FORMAT(dPasted_Date,'%Y-%m-%d')< '".$endDate."'");
        return $count;
    }



    //Fetches Booking Count
    public static function getBookingCount($startDate,$endDate) {

        $db     = new Db();
        $count  = $db->getDataCount("booking","nBooking_Id"," where vStatus='confirmed' AND DATE_FORMAT(dBooking_Date,'%Y-%m-%d')>= '".$startDate."' AND DATE_FORMAT(dBooking_Date,'%Y-%m-%d')< '".$endDate."'");
        return $count;
    }

    //Fetches Customer Regsitartion Count
    public static function getCustomerRegistrationCount($startDate,$endDate) {

        $db     = new Db();
        $count  = $db->getDataCount("customers","nCust_Id"," where vActive='active' AND DATE_FORMAT(dDatejoin,'%Y-%m-%d')>= '".$startDate."' AND DATE_FORMAT(dDatejoin,'%Y-%m-%d')< '".$endDate."'");
        return $count;
    }

    //Fetches Customer Regsitartion Count
    public static function getCancellations($startDate,$endDate) {
        $db     = new Db();
        $bookings  = $db->selectResult("booking B INNER JOIN ".$db->tablePrefix."customers C ON (C.nCust_Id = B.nCust_Id) LEFT JOIN ".$db->tablePrefix."payment P ON(P.nBooking_Id = B.nBooking_Id AND P.transactionType = 'CANCEL')","C.vFirstname,B.nAmount,B.vStatus,B.dBooking_Date,B.dCancelDate, P.nCancelAmt"," (B.vStatus='canceled' OR B.vStatus='cancelPending') ORDER BY B.nBooking_Id DESC LIMIT 5");

        foreach($bookings as $booking) {

            $bookingDetails             =   new stdClass();
            $bookingDetails->vFirstname  =   $booking->vFirstname;
            $bookingDetails->nAmount      =   $booking->nCancelAmt? number_format($booking->nCancelAmt,2) : '0.00';

            $bookingDetails->nAmount 		='<span style="float:right">'.$bookingDetails->nAmount.'</span>';
            
            if($booking->vStatus == 'canceled')
                $bookingDetails->vStatus     =   'Cancelled';
            else if($booking->vStatus == 'cancelPending')
                $bookingDetails->vStatus     =   'Request Pending';
            else
                $bookingDetails->vStatus     =   $booking->vStatus;


            if($booking->dCancelDate != '' && $booking->dCancelDate != '0000-00-00')
            $bookingDetails->dCancelDate =   date("m/d/Y",strtotime($booking->dCancelDate));
            else
            $bookingDetails->dCancelDate =   'N/A' ;



            $recentBookingList[$loopCount]   =   $bookingDetails;
            $loopCount++;
        }


       

        return $recentBookingList;
    }

    //Fetches available accomodation counts
    public static function getAvailableRoomCount($startDate,$endDate) {


        $db     = new Db();
        $allottedRoomCount = $db->getDataCount("booking","nBooking_Id"," where vStatus IN ('confirmed','blocked') AND DATE_FORMAT(dBooking_Date,'%Y-%m-%d')>= '".$startDate."' AND DATE_FORMAT(dBooking_Date,'%Y-%m-%d')< '".$endDate."'");
        $totalRoomcount  = $db->getDataCount("available_acco_type","nAat_Id"," where vActive='active' ");
        if($totalRoomcount-$allottedRoomCount >0)
            return $totalRoomcount-$allottedRoomCount;
        else
            return 0;
    }

    //Fetches Help Categories
    public static function getCheckoutDate($bookingId) {
        $db	    = new Db();
        $bookingDetails = $db->selectRecord('booking',"dArrival_Date,  nNights_Stay"," nBooking_Id=".$bookingId);

        return date('m/d/Y',strtotime($bookingDetails->dArrival_Date."+".$bookingDetails->nNights_Stay." days"));
    }

    //Fetches Customer name for transaction Section
    public static function  fetchCustomerNameByTrnasaction($transactionId) {

        $db	    = new Db();
        $bookingDetails = $db->selectRecord('payment P INNER JOIN  '.$db->tablePrefix.'booking B ON (P.nBooking_Id = B.nBooking_Id)
           INNER JOIN  '.$db->tablePrefix.'customers C ON(B.nCust_Id= C.nCust_Id)',"vFirstname"," vTxn_Id=".$transactionId);

        if(count($bookingDetails)>0)
            return $bookingDetails->vFirstname;
    }


    //Fetches paid amount for cms(Payments)
    public static function  fetchPaidAmount($transactionId) {

        $db	    = new Db();
        $bookingDetails = $db->selectRecord('payment P INNER JOIN  '.$db->tablePrefix.'booking B ON (P.nBooking_Id = B.nBooking_Id)
           ',"B.nAmount "," nPayment_Id=".$transactionId);

        if(count($bookingDetails)>0)
            return $bookingDetails->nAmount ;
    }

    // save location images to accociated location folders
    public static function moveDestinationImagefiles($locationId) {
        global $imageConfig;

        $db	    = new Db();


        $tempLocationImages    = array();
        $locationImages        = array();
        $db                    = new Db();

        $limitString           = ($limit>0) ? ' LIMIT 0,'.$limit : '';
        $tempQuery             = "
                                   SELECT F.`file_orig_name`,F.`file_width`,F.`file_height`,F.`file_path`,G.`vTitle`,G.`nGallery_Id`
                                   FROM `".MYSQL_TABLE_PREFIX."locations` L
                                   INNER JOIN `".MYSQL_TABLE_PREFIX."gallery` G ON L.`nLocation_Id` = G.`nLocation_Id`
                                   INNER JOIN `".MYSQL_TABLE_PREFIX."files` F ON F.`file_id` = G.`file_id`
                                   WHERE L.`nLocation_Id` ='".mysql_real_escape_string($locationId)."'
                                   
                                 ";

        $locationImages        = $db->selectQuery($tempQuery);


        if(is_array($locationImages) && count($locationImages)>0) {
            foreach($locationImages as $tempKey => $tempValue) {
                @copy(FILE_UPLOAD_DIR.'/'.$tempValue->file_path, FILE_UPLOAD_DIR.'/destination/'.$tempValue->file_path );
            }
        }
        $getDestination         = $db->selectResult('destination','vDestination_Name'," nDestination_Id='$locationId'");
        $destinationName          = $getDestination[0]->vDestination_Name;
        Cmshelper::generateDestinationAlias('destination',$destinationName,$locationId);
    }

    public static function updateAliasName($packageId) {
        $table = 'packages';
        $db                     = new Db();
        $getPackage             = $db->selectResult('packages','vPackage_Title'," nPackage_Id='$packageId'");
        $destinationName        = $getPackage[0]->vPackage_Title;
        $alias                  = Utils::generateAlias(MYSQL_TABLE_PREFIX. $table, $destinationName, "nPackage_Id", $packageId, "package_alias");
        $updateArray            = array("package_alias"=>$alias);
        $condition              = " nPackage_Id = ".$packageId;
        $db->updateFields($table,$updateArray,$condition);
    }

    public static function generateDestinationAlias($table,$destinationName,$locationId)
    {
        $db                     = new Db();
        $alias                  = Utils::generateAlias(MYSQL_TABLE_PREFIX. $table, $destinationName, "nDestination_Id", $locationId, "destination_alias");
        $updateArray            = array("destination_alias"=>$alias);
        $condition              = " nDestination_Id = ".$locationId;
        $db->updateFields($table,$updateArray,$condition);
    }

    // save location images to accociated destination folders
    public static function moveLocationGalleryImagefiles($galleryId) {

        global $imageConfig;

        $db	    = new Db();


        $tempLocationImages    = array();
        $locationImages        = array();
        $db                    = new Db();

        $limitString           = ($limit>0) ? ' LIMIT 0,'.$limit : '';
        $tempQuery             = "
                                   SELECT F.`file_orig_name`,F.`file_width`,F.`file_height`,F.`file_path`,G.`vTitle`,G.`nGallery_Id`
                                   FROM  `".MYSQL_TABLE_PREFIX."gallery` G
                                   INNER JOIN `".MYSQL_TABLE_PREFIX."files` F ON F.`file_id` = G.`file_id`
                                   WHERE G.`nGallery_Id` ='".mysql_real_escape_string($galleryId)."'

                                 ";

        $locationImages        = $db->selectQuery($tempQuery);


        if(is_array($locationImages) && count($locationImages)>0) {
            foreach($locationImages as $tempKey => $tempValue) {

              //  @copy(FILE_UPLOAD_DIR.'/'.$tempValue->file_path, FILE_UPLOAD_DIR.'/location/'.$tempValue->file_path );

            }
        }

    }

    // save location images to accociated destination folders
    public static function moveDestinationGalleryImagefiles($galleryId) {

        global $imageConfig;

        $db	    = new Db();


        $tempLocationImages    = array();
        $locationImages        = array();
        $db                    = new Db();

        $limitString           = ($limit>0) ? ' LIMIT 0,'.$limit : '';
        $tempQuery             = "
                                   SELECT F.`file_orig_name`,F.`file_width`,F.`file_height`,F.`file_path`,G.`vTitle`,G.`nGallery_Id`
                                   FROM  `".MYSQL_TABLE_PREFIX."gallery` G
                                   INNER JOIN `".MYSQL_TABLE_PREFIX."files` F ON F.`file_id` = G.`file_id`
                                   WHERE G.`nGallery_Id` ='".mysql_real_escape_string($galleryId)."'

                                 ";

        $locationImages        = $db->selectQuery($tempQuery);


        if(is_array($locationImages) && count($locationImages)>0) {
            foreach($locationImages as $tempKey => $tempValue) {

                @copy(FILE_UPLOAD_DIR.'/'.$tempValue->file_path, FILE_UPLOAD_DIR.'/destination/'.$tempValue->file_path );

            }
        }

    }



    //Function to update banner added date [will be executed after add banner operation]
    public static function updateBannerAddedDate($bannerId) {
        $dbh = new Db();
        $dbh->update($dbh->tablePrefix."Banners", array("nDate" =>date("Y-m-d")), " nBId=".$bannerId);
        return true;
    }


    //Function to fetch inquiries
    public static function fetchRecentEnquiries() {

        $db     = new Db();
        $loopCount = 0;
        $enquiries  = $db->selectResult("enquiry","nEnq_Id,vName,vEmail,tComments,dPasted_Date"," status = 0   ORDER BY nEnq_Id DESC LIMIT 5");
        foreach($enquiries as $enquiry) {
            $enquiryDetails             =   new stdClass();
            
            // <button value="http://localhost/reservelogic/cmshelper/inquiryuserdetailspopup?id=50" class="jqPopupLink btn btn-link" id="link_50">erwe</button>
            $enquiryDetails->tComments  =   $enquiry->tComments;
            $enquiryDetails->vName      =   '<button value="'.BASE_URL.'cmshelper/inquiryuserdetailspopup?id='.$enquiry->nEnq_Id.'" class="jqPopupLink btn btn-link" id="link_50">'.$enquiry->vName.'</button>';
            $enquiryDetails->vEmail     =   $enquiry->vEmail;
            $enquiryDetails->dPasted_Date =   date("m/d/Y",strtotime($enquiry->dPasted_Date));
            $recentEnquiryList[$loopCount]   =   $enquiryDetails;
            $loopCount++;
        }

        return $recentEnquiryList;
    }

    //Function to fetch Orders
    public static function fetchRecentOrders() {
        $db     = new Db();
        $bookings  = $db->selectResult("booking B INNER JOIN ".$db->tablePrefix."customers C ON (C.nCust_Id = B.nCust_Id)","C.nCust_Id,C.vFirstname,B.nAmount,B.vStatus,B.dBooking_Date"," B.vStatus != 'canceled' AND B.vStatus != 'cancelPending' ORDER BY nBooking_Id DESC LIMIT 5");

        foreach($bookings as $booking) {
            $bookingDetails             =   new stdClass();
        	$bookingDetails->vFirstname 	= '<button value="'.BASE_URL.'cmshelper/userdetailspopup?id='.$booking->nCust_Id.'" class="jqPopupLink btn btn-link" id="link_98">'.$booking->vFirstname.'</button>';
            $bookingDetails->nAmount      =   '<span style="float:right">'.$booking->nAmount.'</span>';
            $bookingDetails->vStatus     =   $booking->vStatus;
            $bookingDetails->dBooking_Date =   date("m/d/Y",strtotime($booking->dBooking_Date));
            $recentBookingList[$loopCount]   =   $bookingDetails;
            $loopCount++;
        }

        return $recentBookingList;
    }

    //Function to display promote location link
    public static function displayPromoteLink($locationId) {

        $db = new Db();
        $locationName = $db->selectRow("locations", "vLocation_Name", " nLocation_Id = ".$locationId);
        return '<a href="javascript:void(0)" class="jqPromoteLocation" id=location_'.$locationId.'><input class="submitButton btn" type="button" value="Publish" ></a>';
    }

    //Function used to load data needed for social widgets
    public static function fetchLocationDetails($locationId) {
        $db = new Db();
        return $db->selectRecord("locations L LEFT JOIN ".MYSQL_TABLE_PREFIX."gallery G on (L.nLocation_Id=G.nLocation_Id)", "L.*,G.file_id", " L.nLocation_Id = ".$locationId);
    }

    public static function fetchReservedRooms($searchCriteria, $limit) {
        $db = new Db();


        if(!empty($searchCriteria['searchField']) && !empty($searchCriteria['searchText'])) {
            switch($searchCriteria['searchField']) {
                case 'vAt_Name':
                    $searchCriteriaQuery = "AT.vAt_Name LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
                    break;

                case 'vFirstname':
                    $searchCriteriaQuery = "C.vFirstname LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
                    break;

                case 'vEmail':
                    $searchCriteriaQuery = "C.vEmail LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
                    break;

                case 'vStatus':
                    $searchCriteriaQuery = "B.vStatus LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
                    break;

                default :
                    $searchCriteriaQuery = " 1";
                    BREAK;
            }

        }else {
            $searchCriteriaQuery = " 1 ";
        }


        if(!empty($searchCriteria['location']))
            $searchCriteriaQuery2 = " L.nLocation_Id = ".$searchCriteria['location'];
        else
            $searchCriteriaQuery2 = " 1 ";

        if(!empty($searchCriteria['date']))
            $searchCriteriaQuery3 .="  DATE(B.dArrival_Date) = '".date("Y-m-d",strtotime($searchCriteria['date']))."'";
        else
            $searchCriteriaQuery3 = " 1 ";


        $reservedRoomDetails = $db->selectResult("allotment A
        INNER JOIN ".$db->tablePrefix."available_acco_type AAT ON A.nAat_Id = AAT.nAat_Id
	INNER JOIN ".$db->tablePrefix."accomodation_types AT ON AT.nAt_Id = AAT.nAt_Id
	INNER JOIN ".$db->tablePrefix."locations L ON L.nLocation_Id = AAT.nLocation_Id
        INNER JOIN ".$db->tablePrefix."destination D ON D.nDestination_Id = L.nDestination_Id
	INNER JOIN ".$db->tablePrefix."booking B ON B.nBooking_Id = A.nBooking_Id
        LEFT JOIN  ".$db->tablePrefix."payment P ON P.nBooking_Id = B.nBooking_Id   
	LEFT JOIN ".$db->tablePrefix."customers C ON C.nCust_Id = B.nCust_Id",
                "D.vDestination_Name,A.nAllotment_Id,L.vLocation_Name,AT.vAt_Name,A.vStatus,C.vFirstname,C.vEmail,AAT.nAdults as adults,AAT.nChildren as children,AAT.nAat_id as Aat_Id,
            A.dDate, A.nDays,B.nRooms,B.nNights_Stay, B.dArrival_Date,B.vBookedBy,P.vPayment_Type", " $searchCriteriaQuery  AND $searchCriteriaQuery2 AND $searchCriteriaQuery3 AND B.vStatus !='canceled' AND A.vStatus !='canceled' GROUP BY B.nBooking_Id ORDER BY B.nBooking_Id DESC  $limit");





        return $reservedRoomDetails;
    }

    public static  function fetcBlockedRooms($searchCriteria, $limit) {
        $db = new Db();

        if(!empty($searchCriteria['searchField']) && !empty($searchCriteria['searchText'])) {
            switch($searchCriteria['searchField']) {
                case 'vLocation_Name':
                    $searchCriteriaQuery = "vLocation_Name LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
                    break;
                case 'vAt_Name':
                    $searchCriteriaQuery = "vAt_Name LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
                    break;

                case 'dDate':
                    $searchCriteriaQuery = "'".date("Y-m-d",strtotime($searchCriteria['searchText']))."' BETWEEN A.dDate AND DATE_ADD( A.dDate, INTERVAL A.nDays DAY )";
                    break;
                default :
                    $searchCriteriaQuery = " 1";
                    BREAK;
            }

        }else {
            $searchCriteriaQuery = " 1 ";
        }

        $blockedRoomDetails = $db->selectResult("allotment A
        LEFT JOIN ".$db->tablePrefix."available_acco_type AAT ON A.nAat_Id = AAT.nAat_Id
	INNER JOIN ".$db->tablePrefix."accomodation_types AT ON AT.nAt_Id = AAT.nAt_Id
	INNER JOIN ".$db->tablePrefix."locations L ON L.nLocation_Id = AAT.nLocation_Id
        INNER JOIN ".$db->tablePrefix."destination D ON D.nDestination_Id = L.nDestination_Id
	LEFT JOIN ".$db->tablePrefix."booking B ON B.nBooking_Id = A.nBooking_Id
	", 
                "AT.nAt_Id, D.vDestination_Name,L.nLocation_Id, A.nAllotment_Id,L.vLocation_Name,AT.vAt_Name,A.vStatus,AAT.nAdults as adults,AAT.nChildren as children,AAT.nAat_id as Aat_Id,
            A.dDate, A.nDays,A.NoOfRooms", " A.vStatus='blocked' AND $searchCriteriaQuery GROUP BY nLocation_Id,AT.nAt_Id,dDate,nDays ORDER BY dDate DESC  $limit");

        return $blockedRoomDetails;
    }


    //Function to block rooms
    public static function blockRooms($requestArray) {
        $dbh = new Db();
        $array = explode(',', $requestArray['selectedRoomCounts']);
        $query = " INSERT INTO `".$dbh->tablePrefix."allotment` (`nAat_Id`,`dDate`,`nAdults`,`nChildren`,`vStatus`,`nDays`)
        SELECT AAT.nAat_Id,'".date('Y-m-d',strtotime($requestArray ['date']))."',AAT.nAdults,AAT.nChildren,'blocked',".intval($requestArray ['numberofdays'])." 
        FROM ".$dbh->tablePrefix."available_acco_type AAT where nLocation_Id = ".$requestArray ['location']." and AAT.nAt_Id IN(".$requestArray['selectedAccomodationTypes'].")";
        

        Logger::info($query);
        $dbh->execute($query);
        $lastId = $dbh->lastInsertId();
        for($i=0;$i<count($array);$i++)
        {
            $query = "update ".$dbh->tablePrefix."allotment set  NoOfRooms = ".$array[$i]." where nAllotment_Id =".$lastId;
            $dbh->execute($query);
            $lastId++;
        }
        return $dbh->lastInsertId();
    }
    
  

    //Function to add offer price to rooms
    public static function unblockRooms($requestArray) {
        $dbh = new Db();
        $fetchIdQuery = "SELECT GROUP_CONCAT(AAT.nAat_Id) as ids FROM ".$dbh->tablePrefix."available_acco_type AAT where nLocation_Id = ".$requestArray ['location']." and AAT.nAt_Id =  ".$requestArray['selectedAccomodationType'];
        $idResult = $dbh->execute($fetchIdQuery);
        $ids = $dbh->fetchOne($idResult);

        $query = " DELETE FROM `".$dbh->tablePrefix."allotment` WHERE `nAat_Id` IN($ids)";
        Logger::info($query);
        $dbh->execute($query);
    }

    public static  function fetcAccomodationOffers($searchCriteria, $limit) {
        $db = new Db();

        if(!empty($searchCriteria['searchField']) && !empty($searchCriteria['searchText'])) {
            switch($searchCriteria['searchField']) {
                case 'vLocation_Name':
                    $searchCriteriaQuery = "vLocation_Name LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
                    break;

                case 'vFirstname':
                    $searchCriteriaQuery = "vFirstname LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
                    break;

                default :
                    $searchCriteriaQuery = " 1";
                    BREAK;
            }

        }else {
            $searchCriteriaQuery = " 1 ";
        }

        $offerDetails = $db->selectResult("offer_price O
        INNER JOIN ".$db->tablePrefix."available_acco_type AAT ON O.nAat_Id = AAT.nAat_Id
	INNER JOIN ".$db->tablePrefix."accomodation_types AT ON AT.nAt_Id = AAT.nAt_Id
	INNER JOIN ".$db->tablePrefix."locations L ON L.nLocation_Id = AAT.nLocation_Id
        INNER JOIN ".$db->tablePrefix."destination D ON D.nDestination_Id = L.nDestination_Id
	", 
                "AT.nAt_Id, D.vDestination_Name,L.nLocation_Id, L.vLocation_Name,AT.vAt_Name,AAT.nAdults as adults,AAT.nChildren as children,AAT.nAat_id as Aat_Id,
            O.offer_start_date,O.offer_end_date, O.price", "  $searchCriteriaQuery GROUP BY AAT.nAt_Id ORDER BY offer_start_date,offer_end_date DESC  $limit");

        return $offerDetails;
    }

    //Function to add offer price to rooms
    public static function addAccomodationOffers($requestArray) {
        $dbh = new Db();
        $query = " INSERT INTO `".$dbh->tablePrefix."offer_price` (`nAat_Id`,`offer_start_date`,`offer_end_date`,`price`)
        SELECT AAT.nAat_Id,'".date('Y-m-d',strtotime($requestArray ['startDate']))."','".date('Y-m-d',strtotime($requestArray ['endDate']))."',".intval($requestArray ['price'])." 
        FROM ".$dbh->tablePrefix."available_acco_type AAT where nLocation_Id = ".$requestArray ['location']." and AAT.nAt_Id IN(".$requestArray['selectedAccomodationTypes'].")";
        Logger::info($query);
        $dbh->execute($query);
    }

    //Function to add offer price to rooms
    public static function removeAccomodationOffers($requestArray) {
        $dbh = new Db();
        $fetchIdQuery = "SELECT GROUP_CONCAT(AAT.nAat_Id) as ids FROM ".$dbh->tablePrefix."available_acco_type AAT where nLocation_Id = ".$requestArray ['location']." and AAT.nAt_Id =  ".$requestArray['selectedAccomodationType'];
        $idResult = $dbh->execute($fetchIdQuery);
        $ids = $dbh->fetchOne($idResult);

        $query = " DELETE FROM `".$dbh->tablePrefix."offer_price` WHERE `nAat_Id` IN($ids)";
        Logger::info($query);
        $dbh->execute($query);
    }


    //Fucntion to fetch group discount
    public static  function fetchGroupDiscount($searchCriteria, $limit) {
        $db = new Db();

        if(!empty($searchCriteria['searchField']) && !empty($searchCriteria['searchText'])) {
            switch($searchCriteria['searchField']) {
                case 'vLocation_Name':
                    $searchCriteriaQuery = "vLocation_Name LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
                    break;


                default :
                    $searchCriteriaQuery = " 1";
                    BREAK;
            }

        }else {
            $searchCriteriaQuery = " 1 ";
        }

        $offerDetails = $db->selectResult("group_discounts GD
        INNER JOIN ".$db->tablePrefix."available_acco_type AAT ON GD.nAat_Id = AAT.nAat_Id
	INNER JOIN ".$db->tablePrefix."accomodation_types AT ON AT.nAt_Id = AAT.nAt_Id
	INNER JOIN ".$db->tablePrefix."locations L ON L.nLocation_Id = AAT.nLocation_Id
        INNER JOIN ".$db->tablePrefix."destination D ON D.nDestination_Id = L.nDestination_Id
	", 
                "GD.discount_id,AT.nAt_Id, D.vDestination_Name,L.nLocation_Id, L.vLocation_Name,AT.vAt_Name,AAT.nAdults as adults,AAT.nChildren as children,AAT.nAat_id as Aat_Id,
            GD.group_size, GD.group_size_range,GD.discount_percentage  ", "  $searchCriteriaQuery  ORDER BY GD.discount_id DESC  $limit");

        return $offerDetails;
    }

    //Function to add  group discount
    public static function addGroupDiscount($requestArray) {
        $dbh = new Db();
        $query = " INSERT INTO `".$dbh->tablePrefix."group_discounts` (`nAat_Id`,`group_size`,`group_size_range`,`discount_percentage`)
        SELECT AAT.nAat_Id,'".$requestArray ['startRange']."','".$requestArray ['endRange']."',".$requestArray ['discountPercentage']." 
        FROM ".$dbh->tablePrefix."available_acco_type AAT where nLocation_Id = ".$requestArray ['location']." and AAT.nAt_Id IN(".$requestArray['selectedAccomodationTypes'].")";
        Logger::info($query);
        $dbh->execute($query);
    }

    //Function to remove group discount
    public static function removeGroupDiscount($requestArray) {

        $dbh = new Db();
        $fetchIdQuery = "SELECT GROUP_CONCAT(AAT.nAat_Id) as ids FROM ".$dbh->tablePrefix."available_acco_type AAT where nLocation_Id = ".$requestArray ['location']." and AAT.nAt_Id =  ".$requestArray['selectedAccomodationType'];
        $idResult = $dbh->execute($fetchIdQuery);
        $ids = $dbh->fetchOne($idResult);

        $query = " DELETE FROM ".$dbh->tablePrefix."group_discounts WHERE discount_id = ".$requestArray['discount_id']." and nAat_id  IN($ids)";

        Logger::info($query);
        $dbh->execute($query);
    }





    /*
     * Function : getListItem
     * Input : @table <table name to select>
     * Input : @fieldArr <field names as an array to select, eg : array('a', 'b', 'c')>
     * Input : @filterArr <field names as an array to supply in WHERE clause, eg : array('a', 'b', 'c')>
     * Input : @orderArr <array input 1 : sort order, array input 2: sort fields as an array eg : array('sort' => 'ASC', 'fields' => array('a', 'b', 'c'))>
     * Input : @limit <base,indent eg : 0,5 -> generate the query as LIMIT 0,5))>
    */
    public static function getListItem($table = NULL, $fieldArr = NULL, $filterArr = NULL, $orderArr = NULL, $limit = NULL, $searchArr = NULL, $join = NULL) {
        $dbObj = new Db();
        $filter = $fieldList = $order = $searchCode = $searchList = NULL;

        $data = array();
        // FIELD LIST generation like a, b, c
        if(!empty($fieldArr)) {
            foreach($fieldArr as $field) {
                $fieldList .= (!empty($fieldList)) ? ', ' : '';
                $fieldList .= (!empty($field)) ? $field : '';
            }

            // FILTER fields for where condition generation like a='xx' AND b='xx' AND c='xx'
            if(!empty($filterArr)) {
                foreach($filterArr as $filterItem) {
                    $filterCondition = (isset($filterItem['condition'])) ? $filterItem['condition'] : '=';
                    $filterInputQuotes = (isset($filterItem['inputQuotes']) && $filterItem['inputQuotes']=='N') ? $filterItem['value'] : "'".$filterItem['value']."'";
                    $filter .= (!empty($filter)) ? ' AND ' : '';
                    $filter .= (!empty($filterItem)) ? $filterItem['field']." ".$filterCondition." ".$filterInputQuotes : NULL;
                } // End Foreach
            } // End If

            // FILTER fields for where condition generation like a LIKE 'xx%' AND b LIKE 'xx%' AND c LIKE 'xx%' generally for search cases
            if(!empty($searchArr)) {
                $filter .= (!empty($filter)) ? ' AND (' : ' (';
                foreach($searchArr as $searchItem) {
                    $searchList .= (!empty($searchList)) ? ' OR ' : '';
                    $searchList .= (!empty($searchItem)) ? $searchItem['field']." LIKE '".addslashes($searchItem['value'])."%'" : NULL;
                } // End Foreach
                $filter .= $searchList;
                $filter .= (!empty($filter)) ? ' )' : '';
            } // End If

            // FILTER WITH WHERE 1 for blank entries
            $filter .= (!empty($filter)) ? "" : " 1";

            // FILTER WITH ORDER BY
            if(!empty($orderArr)) {
                $sortBy = (!empty($orderArr['sort'])) ? $orderArr['sort'] : 'ASC';
                foreach($orderArr['fields'] as $orderItem) {
                    $order .= (!empty($order)) ? ', ' : '';
                    $order .= (!empty($orderItem)) ? $orderItem : '';
                } // End Foreach
                $filter .= (!empty($order)) ? " ORDER BY ".$order." ".$sortBy : NULL;
            } // End If

            // FILTER WITH LIMIT WHERE 1
            $filter .= (!empty($limit)) ? " LIMIT ".$limit : NULL;

            $data = $dbObj->selectResult($table,$fieldList,$filter);

        } // End FieldArr


        return $data;
    } // End Function




    public static function updateSettings($data, $enabled= NULL) {

        /*
     	 echo "<pre>";
     	 print_r($data);
     	 exit();
        */
        $db = new Db();
        if (is_array($data) && !empty($data)) {
            foreach ($data as $field => $val) {
                $db->updateFields("lookup", array('vLookUp_Value' => $val), "vLookUp_Name = '$field'");
            }
        }
       
        if($enabled)
                 $db->updateFields("lookup", array('vLookUp_Value' => $enabled), "vLookUp_Name = 'payment_gateway'");
        return true;
    }


    public static function updateAdminPassword($userName, $postValues) {
        $db = new Db();

         

        $current_pass = $db->selectQuery("SELECT password FROM cms_users WHERE username ='$userName' ");



        

        if (trim($current_pass[0]->password) == MD5(trim($postValues['current_password']))) {
            if ($postValues['new_password'] == $postValues['retype_password']) {

                 $password = $postValues['new_password'];

                $db->customQuery("UPDATE `cms_users` SET `password` = MD5('" . mysql_real_escape_string($password) . "') WHERE `username` = '" . $userName . "'");
                $message = "success";
            } else {
                $message = "New Password and Re-Type Password do not match!";
            }
        } else {  
            $message = "Incorrect Current Password!";
        }
        return $message;
    }



    //Fucntion to fetch payments
    public static  function fetchPayments($searchCriteria, $limit)
    {
        $db = new Db();

        if(!empty($searchCriteria['searchField']) && !empty($searchCriteria['searchText']))
        {
            switch($searchCriteria['searchField'])
            {
                case 'vTxn_Id':
                    $searchCriteriaQuery = "vTxn_Id LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
                    break;

                case 'vFirstname':
                    $searchCriteriaQuery = "vFirstname LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
                    break;

                case 'dBooking_Date':

                    $searchCriteria['searchText'] = date('m/d/Y',strtotime($searchCriteria['searchText']));

                    $searchCriteriaQuery = "DATE_FORMAT(B.dBooking_Date,'%m/%d/%Y') = '".mysql_real_escape_string(trim($searchCriteria['searchText']))."'";
                    break;

                case 'dDate_Settled':

                    $searchCriteria['searchText'] = date('m/d/Y',strtotime($searchCriteria['searchText']));
                
                    $searchCriteriaQuery = "DATE_FORMAT(P.dDate_Settled,'%m/%d/%Y') = '".mysql_real_escape_string(trim($searchCriteria['searchText']))."'";
                    break;


                case 'vStatus':
                    $searchCriteriaQuery = "P.vStatus LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
                    break;


                case 'vPayment_Type':
                    $searchCriteriaQuery = "P.vPayment_Type LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
                    break;

                default :
                    $searchCriteriaQuery = " 1";
                    break;
            }

        }
        else
        {
            $searchCriteriaQuery = " 1 ";
        }


       

        $payments = $db->selectResult("payment P
        INNER JOIN ".$db->tablePrefix."booking B ON(P.nBooking_Id =B.nBooking_Id)
        LEFT JOIN ".$db->tablePrefix."customers C ON C.nCust_Id = B.nCust_Id
        ",  
                "C.*,C.nCust_Id, P.nPayment_Id, B.nAmount,B.vBookedBy,P.vPayment_Type, P.vTxn_Id,P.dDate_Settled,P.vPayment_Type,P.vStatus, C.vFirstname, P.nCancelAmt , P.vCapture",
                "  $searchCriteriaQuery AND B.vStatus != 'canceled' and B.vStatus != 'cancelPending'  ORDER BY P.nPayment_Id DESC $limit");

        return $payments;
    }

    //Fucntion to fetch cancelled payments
    public static  function fetchCancelledPayments($searchCriteria, $limit) {
        $db = new Db();

        if(!empty($searchCriteria['searchField']) && !empty($searchCriteria['searchText'])) {
            switch($searchCriteria['searchField']) {
                case 'vTxn_Id':
                    $searchCriteriaQuery = "vTxn_Id LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
                    break;

                case 'vFirstname':
                    $searchCriteriaQuery = "vFirstname LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
                    break;

                default :
                    $searchCriteriaQuery = " 1";
                    BREAK;
            }

        }else {
            $searchCriteriaQuery = " 1 ";
        }

        $payments = $db->selectResult("booking B
        LEFT JOIN ".$db->tablePrefix."payment P ON(P.nBooking_Id =B.nBooking_Id AND transactionType = 'CANCEL')
        LEFT JOIN ".$db->tablePrefix."customers C ON C.nCust_Id = B.nCust_Id",  
                "C.*,C.nCust_Id, P.nPayment_Id, B.nAmount,B.vBookedBy, P.vTxn_Id,P.dDate_Settled,P.vPayment_Type,P.vStatus, C.vFirstname, P.nCancelAmt , P.vCapture, B.vStatus AS cancellationStatus, B.nBooking_Id, B.dCancelDate",
                "  $searchCriteriaQuery AND ((B.vStatus = 'canceled' OR B.vStatus = 'cancelPending') OR P.transactionType = 'CANCEL')  ORDER BY B.nBooking_Id DESC ,B.dCancelDate DESC $limit");

        return $payments;
    }

    //Function to fetch referrals/affiliates
    public static  function fetchReferrals($searchCriteria, $limit) {
        $db = new Db();

        if(!empty($searchCriteria['searchField']) && !empty($searchCriteria['searchText'])) {
            switch($searchCriteria['searchField']) {
                case 'Affiliate':
                    $searchCriteriaQuery = "A.aff_fname LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%' OR A.aff_lname LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
                    break;

                case 'Customer':
                    $searchCriteriaQuery = "C.vFirstname LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
                    break;

                /*
               case 'vPaidStatus':
                   $searchCriteriaQuery = "vPaidStatus LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
               break;
                */
                default :
                    $searchCriteriaQuery = " 1";
                    BREAK;
            }

        }else {
            $searchCriteriaQuery = " 1 ";
        }

        $payments = $db->selectResult("affiliates A
	LEFT JOIN ".$db->tablePrefix."affiliate_useraction AU ON A.aff_id = AU.ua_aff_id
	LEFT JOIN ".$db->tablePrefix."customers C ON C.nCust_Id = AU.ua_userid",
                "C.*,AU.*,A.aff_id,CASE AU.ua_paystatus WHEN 1 THEN 'Unpaid' WHEN 2 THEN 'Paid' WHEN 3 THEN 'Rejected' END as status,concat(A.aff_fname,' ',A.aff_lname) as affiliate,CASE AU.ua_actiontype WHEN 1 THEN 'Registration' WHEN 2 THEN 'Booking' END as actionType,CASE AU.ua_settled_type WHEN 1 THEN 'Cheque' WHEN 2 THEN 'DD' END as paymentType,
        date_format(FROM_UNIXTIME(A.aff_regdate),'%m/%d/%Y') as affiliateRegDate,date_format(AU.ua_date_settled,'%m/%d/%Y') as settledDate,C.vFirstname as Referredname ", " A.aff_status = '1' AND  $searchCriteriaQuery   $limit");
        /*
       $payments = $db->selectResult("referrals R 
	LEFT JOIN ".$db->tablePrefix."customers C ON R.nCust_Id = C.nCust_Id 
	LEFT JOIN ".$db->tablePrefix."customers TC ON TC.nCust_Id = R.nReffered_Customers",  
        "C.*,R.*,TC.vFirstname as Referredname ", " vPaidStatus = 'Yes' AND  $searchCriteriaQuery   $limit");
        */
        return $payments;
    }

    public static  function getUserAfiliateData($affiliateId,$userId) {
        $db = new Db();
        $userAffiliateData = $db->fetchSingleRow("SELECT * FROM ".$db->tablePrefix."affiliate_useraction WHERE ua_aff_id='".$affiliateId."' AND ua_userid='".$userId."'");
        return $userAffiliateData;
    }

    //Function to settle payments for referrals
    public function settlePayments($requestArray) { //echopre1($requestArray);
        $dbh = new Db;
        $sqlUpdate = "UPDATE ".$dbh->tablePrefix."affiliate_useraction
        SET ua_paystatus='1',ua_date_settled='"	. date('Y-m-d H:m:s')."',
	ua_settled_type='". addslashes(mysql_real_escape_string($requestArray['payType']))."'
        WHERE ua_aff_id='" . $requestArray ['referId'] . "' AND ua_userid='". $requestArray ['userId']."'";

        $dbh->execute($sqlUpdate);
    }

    public static function updateOfferAliasName($offerId) {
        $table                  = 'special_offers';
        $db                     = new Db();
        $getPackage             = $db->selectResult($table,'vTitle'," nSp_Id='$offerId'");
        $destinationName        = $getPackage[0]->vTitle;
        $alias                  = Utils::generateAlias(MYSQL_TABLE_PREFIX. $table, $destinationName, "nSp_Id", $offerId, "vAlias");
        $updateArray            = array("vAlias"=>$alias);
        $condition              = " nSp_Id = ".$offerId;
        $db->updateFields($table,$updateArray,$condition);
    }

    //function to map lattitude and longitude based on address [after location add/edit - cms]
    public static function mapLatLong($locationId) {
        $dbh = new Db();
        $address = $dbh->selectRow("locations L", "CONCAT(L.vAddress,', ',L.vCity,', ',L.vState,', ',L.vZip,', ',L.vCountry) AS Address", " nLocation_Id=".intval($locationId));
        $address = urlencode(stripslashes($address));

        $fullurl = "http://maps.googleapis.com/maps/api/geocode/json?address=".$address."&sensor=true";
        $string = file_get_contents($fullurl); // get json content
        $jsonOutput = json_decode($string, true); //json decoder

        if($jsonOutput['status'] <> 'ZERO_RESULTS') {
            $lattitude = $jsonOutput['results'][0]['geometry']['location']['lat']; // get lat for json
            $longitude = $jsonOutput['results'][0]['geometry']['location']['lng']; // get ing for json
            $dbh->update($dbh->tablePrefix."locations", array("vLatitude"=>$lattitude,"vLongtitude"=>$longitude), " nLocation_Id=".intval($locationId));
        }

        $table                  = 'locations';
        $db                     = new Db();
        $getPackage             = $db->selectResult($table,'vLocation_Name'," nLocation_Id='$locationId'");
        $destinationName        = $getPackage[0]->vLocation_Name;
        $alias                  = Utils::generateAlias(MYSQL_TABLE_PREFIX. $table, $destinationName, "nLocation_Id", $locationId, "location_alias");
        $updateArray            = array("location_alias"=>$alias);
        $condition              = " nLocation_Id = ".$locationId;
        $db->updateFields($table,$updateArray,$condition);
    }


    public static function ShowTemplates($style) {

        $StylewArray=array();
        //create array
        foreach (self::showThemes() as $key=>$val) {
            $StylewArray[$key]=$val;
        }//end foreach


        asort($StylewArray);
        $selBox = '<select name="sitestyle" class="float-left">';
        foreach($StylewArray as $key=>$value) {

            $selBox .= '<option value="'.$value.'" '.(($style==$value)?'selected="selected"':'').' >'.$value.'</option>';

        }//end foreach
        $selBox .= '</select>';
        return $selBox;
    }//end function






    //fuction for listing themes from themes folder
    public static function showThemes() {
        $theme_root='project/themes';
        $themes_dir = @ opendir($theme_root);
        while ( ($theme_dir = readdir($themes_dir)) !== false ) {
            if ($theme_dir != "." && $theme_dir != "..")
                $theme_files[$theme_dir] =  $theme_dir ;
        }//end whil loop
        if ( is_dir( $theme_dir ) )
            @closedir( $theme_dir );
        return $theme_files;
    }//end function

    //Function to fetch Accomodation Types
    public static function fetchLocationBasedAccomodations($locationId, $searchCriteria, $limit) {
        $dbh = new Db();
        if(!empty($searchCriteria['searchField']) && !empty($searchCriteria['searchText'])) {
            switch($searchCriteria['searchField']) {
                case 'vCode':
                    $searchCriteriaQuery = "vCode LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
                    break;

                case 'vFirstname':
                    $searchCriteriaQuery = "vFirstname LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
                    break;

                default :
                    $searchCriteriaQuery = " 1";
                    BREAK;
            }

        }else {
            $searchCriteriaQuery = " 1 ";
        }

        return $dbh->selectResult("available_acco_type AAT INNER JOIN ".$dbh->tablePrefix."accomodation_types AT ON (AT.nAt_Id = AAT.nAt_Id )
            LEFT JOIN ".$dbh->tablePrefix."files F ON (F.file_id = AAT.file_id)",
                "AT.nAt_Id,AAT.additional_guest_allowed,AAT.additional_guest_rate, AAT.nAat_Id, AT.vAt_Name, AAT.vCode , AAT.nRoom, AAT.nAmount, AAT.vActive, AAT.nAdults,  AAT.nChildren, F.file_path, AAT.file_id",
                "AAT.nLocation_Id = ".$locationId." AND $searchCriteriaQuery $limit");

    }

    //Function to remove accomodation from a location
    public static function removeAccomodationFromLocation($requestArray) {
        $dbh = new Db();
        $query = " DELETE FROM `".$dbh->tablePrefix."available_acco_type` WHERE `nAat_Id`=".$requestArray['selectedAccomodationType'];
        Logger::info($query);
        $dbh->execute($query);
    }

    //Function to remove accomodation from a location
    public static function removeSeasonalRate($requestArray) {
        $dbh = new Db();
        $query = " DELETE FROM `".$dbh->tablePrefix."accomodation_seasonal_rates` WHERE `seasonal_id`=".$requestArray['seasonal_id'];
        Logger::info($query);
        $dbh->execute($query);
    }

    //Function to add accomodation to a location
    public static function addAccomodationToLocation($requestArray) {
        $dbh = new Db();

        $dbh->insert($dbh->tablePrefix."available_acco_type", $requestArray);
    }

    //Function to add accomodation to a location
    public static function addseasonalRate($requestArray) {
        //print_r($requestArray);die;
        $dbh = new Db();
        $dbh->insert($dbh->tablePrefix."accomodation_seasonal_rates", $requestArray);
    }

    //Function to add accomodation to a location
    public static function updateAccomodation($requestArray, $accomodationTypeId) {

        //var_dump(intval($accomodationTypeId));
        //print_r($requestArray);die('---');
        $dbh = new Db();

        $dbh->update($dbh->tablePrefix."available_acco_type", $requestArray,
                "  nAat_Id =".intval($accomodationTypeId));
    }

    //Function to add accomodation to a location
    public static function updateseasonalRate($requestArray, $seasonalId) {
        $dbh = new Db();

        $dbh->update($dbh->tablePrefix."accomodation_seasonal_rates", $requestArray,
                "  seasonal_id =".intval($seasonalId));
    }


    //Function to settle payments for booking
    public function settleBookingPayments($requestArray) {
        $dbh = new Db;
        $sqlUpdate = "UPDATE ".$dbh->tablePrefix."payment
        SET	vStatus='Yes',dDate_Settled='"	. date('Y-m-d H:m:s')	."',
	vTxn_Id='". addslashes(mysql_real_escape_string($requestArray['refNumber']))."',
	vPayment_Type='". addslashes(mysql_real_escape_string($requestArray['payType']))."'
        WHERE  	nPayment_Id ='" 	. $requestArray ['payId'] . "'";


        $dbh->execute($sqlUpdate);
    }

    //Fucntion to fetch report data
    public static  function fetchSalesReportExcelData($searchCriteria, $limit) {
        $db = new Db();

        if(!empty($searchCriteria['startDate']) && !empty($searchCriteria['endDate'])) {

            $fromDate 	= date('Y-m-d',strtotime($searchCriteria['startDate']));
            $toDate 	= date('Y-m-d',strtotime($searchCriteria['endDate']));

            $searchCriteriaQuery = "AND B.dBooking_Date>='".addslashes($fromDate)."'
               AND B.dBooking_Date<='".addslashes($toDate)."'";


        }else {
            $searchCriteriaQuery = " 1 ";
        }

        $payments = $db->selectResult("payment P
        INNER JOIN ".$db->tablePrefix."booking B ON(P.nBooking_Id =B.nBooking_Id)
        INNER JOIN ".$db->tablePrefix."customers C ON C.nCust_Id = B.nCust_Id",  
                "C.vFirstname, B.dBooking_Date,B.nAmount,P.vTxn_Id,P.dDate_Settled,P.vPayment_Type,P.vStatus ", " P.vType!='C' AND P.vStatus='Yes'  $searchCriteriaQuery   $limit");

        return $payments;
    }

    //Fucntion to fetch report data
    public static  function fetchSalesReportData($searchCriteria, $limit, $formatData = FALSE) {
        $db = new Db();

        if(!empty($searchCriteria['startDate']) && !empty($searchCriteria['endDate'])) {

            $fromDate 	= date('Y-m-d',strtotime($searchCriteria['startDate']));
            $toDate 	= date('Y-m-d',strtotime($searchCriteria['endDate']));

            $searchCriteriaQuery = "AND DATE(B.dBooking_Date)>='".addslashes($fromDate)."'
               AND DATE(B.dBooking_Date)<='".addslashes($toDate)."'";


        }else {
            $searchCriteriaQuery = " 1 ";
        }

        $payments = $db->selectResult("payment P
        INNER JOIN ".$db->tablePrefix."booking B ON(P.nBooking_Id =B.nBooking_Id)
        INNER JOIN ".$db->tablePrefix."customers C ON C.nCust_Id = B.nCust_Id",  
                "P.nPayment_Id,C.vFirstname, B.dBooking_Date,B.nAmount,P.vTxn_Id,P.dDate_Settled,P.vPayment_Type,P.vStatus, nPayment_Id as id ", " P.vType!='C' AND P.vStatus='Yes'  $searchCriteriaQuery   $limit");
    //  if($formatData) {
            $resultsArray = array();
            foreach($payments as $record) {
                $results = new stdClass();
                $results->nPayment_Id = $record->nPayment_Id;
                $results->vFirstname = $record->vFirstname;
                $results->dBooking_Date = date("m/d/Y",strtotime($record->dBooking_Date));
                $results->nAmount = $record->nAmount;
                $results->vTxn_Id = $record->vTxn_Id;
                $results->dDate_Settled = date("m/d/Y",strtotime($record->dDate_Settled));
                $results->vPayment_Type = $record->vPayment_Type;
                $results->vStatus = $record->vStatus;
                $resultsArray [] = $results;
            }
            return $resultsArray;
       // }
        return $payments;
    }

    //Fucntion to fetch report data
    public static  function fetchBookingReportData($searchCriteria, $limit, $formatData = FALSE) {
        $db = new Db();

        if(!empty($searchCriteria['startDate']) && !empty($searchCriteria['endDate'])) {

            $fromDate 	= date('Y-m-d',strtotime($searchCriteria['startDate']));
            $toDate 	= date('Y-m-d',strtotime($searchCriteria['endDate']));

            $searchCriteriaQuery = " B.dBooking_Date>='".addslashes($fromDate)."'
               AND B.dBooking_Date<='".addslashes($toDate)."'";


        }else {
            $searchCriteriaQuery = " 1 ";
        }

        $payments = $db->selectResult("booking B
	LEFT JOIN ".$db->tablePrefix."customers C ON C.nCust_Id = B.nCust_Id",  
                "B.nBooking_Id, B.dBooking_Date, B.dArrival_Date, B.nNights_Stay, B.nAmount , C.vFirstname, B.vBooking_Details, B.vStatus", "  $searchCriteriaQuery   $limit");

        if($formatData) {
            $resultsArray = array();
            foreach($payments as $record) {
                $results = new stdClass();
                $results->nBooking_Id = $record->nBooking_Id;
                $results->vFirstname = $record->vFirstname;
                $results->dBooking_Date = date("m/d/Y",strtotime($record->dBooking_Date));
                $results->checkin_Date = date("m/d/Y",strtotime($record->dArrival_Date)) ;
                $results->checkout_Date = date("m/d/Y",strtotime($record->dArrival_Date."+".$record->nNights_Stay." days"));
                $results->nAmount = $record->nAmount;
                $results->vBooking_Details = $record->vBooking_Details;
                $results->vStatus = $record->vStatus;
                $resultsArray [] = $results;
            }
            return $resultsArray;
        }
        return $payments;
    }

    //Function to fetc customer report data
    public static  function fetchCustomerReportData($searchCriteria, $limit, $formatData = FALSE) {
        $db = new Db();

        if(!empty($searchCriteria['startDate']) && !empty($searchCriteria['endDate'])) {

            $fromDate 	= date('Y-m-d',strtotime($searchCriteria['startDate']));
            $toDate 	= date('Y-m-d',strtotime($searchCriteria['endDate']));

            $searchCriteriaQuery = " C.dDatejoin>='".addslashes($fromDate)."'
               AND C.dDatejoin<='".addslashes($toDate)."'";


        }else {
            $searchCriteriaQuery = " 1 ";
        }

        $payments = $db->selectResult("customers C ",
                "C.*", "  $searchCriteriaQuery   $limit");

        if($formatData) {
            $resultsArray = array();
            foreach($payments as $record) {
                $results = new stdClass();
                $results->vLogin = $record->vLogin;
                $results->vFirstname = $record->vFirstname;
                $results->vLastname = $record->vLastname;
                $results->vEmail = $record->vEmail;
                $results->vAddress1 = $record->vAddress1;
                $results->vCity = $record->vCity;
                $results->vState = $record->vState;
                $results->vCountry = $record->vCountry;
                $results->vZip = $record->vZip;
                $results->vMobile = $record->vMobile;
                $results->vTelephone = $record->vTelephone;
                $results->vFax = $record->vFax;
                $results->vActive = $record->vActive;
                $results->dDatejoin = date("m/d/Y",strtotime($record->dDatejoin));
                $resultsArray [] = $results;
            }
            return $resultsArray;
        }
        return $payments;
    }

    //Function to fetc customer report data
    public static  function fetchInventoryReportData($searchCriteria, $startLimit = NULL, $endLimit=NULL) {
        $db = new Db();



        if(!empty($searchCriteria['startDate']) && !empty($searchCriteria['endDate']) && $searchCriteria['selectedAccomodationType']) {

            $fetchIdQuery = "SELECT GROUP_CONCAT(AAT.nAat_Id) as ids FROM ".$db->tablePrefix."available_acco_type AAT
                where nLocation_Id = ".$searchCriteria ['location']." and AAT.nAt_Id =  ".$searchCriteria['selectedAccomodationType'];

            $idResult = $db->execute($fetchIdQuery);
            $ids = $db->fetchOne($idResult);

            $searchCriteriaQuery = "  nAat_Id IN ($ids)";




            $availableRoomCount = $db->selectRow("available_acco_type AAT ",
                    "AAT.nRoom", "   $searchCriteriaQuery  ");

            $daysBetween = ceil(abs(strtotime($searchCriteria['startDate']) - strtotime($searchCriteria['endDate'])) / 86400);
            for($j = 0;$j<= $daysBetween;$j++) {

                $result = new stdClass();
                $date = date('Y-m-d', strtotime($searchCriteria['startDate']. ' + '.$j.' day'));
                $query  = "SELECT SUM(nRooms) as reservedRooms, GROUP_CONCAT(DISTINCT(`vFirstname`)) as bookedBy
                 FROM ".MYSQL_TABLE_PREFIX."allotment A
                LEFT JOIN ".MYSQL_TABLE_PREFIX."booking B ON ( B.`nBooking_Id` = A.`nBooking_Id` )
                INNER JOIN ".MYSQL_TABLE_PREFIX."customers C ON(B.nCust_Id = C.nCust_Id)
                WHERE A.nAat_Id IN($ids)
                AND A.vStatus != 'blocked'
                AND '".date("Y-m-d",strtotime($date))."'   BETWEEN A.dDate AND DATE_ADD( A.dDate, INTERVAL A.nDays DAY )
                OR '".date("Y-m-d",strtotime($date))."'  BETWEEN A.dDate AND DATE_ADD( A.dDate, INTERVAL A.nDays DAY )  ";


                $reservedRoom = $db->fetchSingleRow($query);
                $result->id = $j;
                $result->date = $date;
                $result->reservedRoomCount = $reservedRoom->reservedRooms?$reservedRoom->reservedRooms:0;
                $result->availableRoomCount  = $availableRoomCount;
                if($availableRoomCount>$reservedRoom->reservedRooms)
                    $result->status = 'Available';
                else
                    $result->status = 'Booked';
                $result->bookedBy = $reservedRoom->bookedBy?$reservedRoom->bookedBy:'';
                $finalResult[] = $result;

            }

            if( $endLimit!= NULL) {
                $finalResult = array_splice($finalResult, $startLimit, $endLimit);
            }
            return $finalResult;
        }
    }

    //Function to check room availability
    public static function checkRoomAvailability($requestArray) {
        $db = new Db();
        $fetchIdQuery = "SELECT GROUP_CONCAT(AAT.nAat_Id) as ids FROM ".$db->tablePrefix."available_acco_type AAT
                where nLocation_Id = ".$requestArray ['location']." and AAT.nAt_Id =  ".$requestArray['accomodation'];

        $idResult = $db->execute($fetchIdQuery);
        $ids = $db->fetchOne($idResult);

        $searchCriteriaQuery = "  nAat_Id IN ($ids)";

        $availableRoomDetails = $db->selectRecord("available_acco_type AAT ",  "AAT.nRoom, nAdults, nChildren,AAT.additional_guest_allowed as guest",$searchCriteriaQuery);



        

        $query  = "SELECT SUM(nRooms) as reservedRooms
                 FROM ".MYSQL_TABLE_PREFIX."allotment A
                LEFT JOIN ".$db->tablePrefix."booking B ON ( B.`nBooking_Id` = A.`nBooking_Id` )
                INNER JOIN ".$db->tablePrefix."customers C ON(B.nCust_Id = C.nCust_Id)
                WHERE A.nAat_Id IN($ids)
                and A.vStatus = 'booked'
                AND A.dDate between '".Utils::dateFormat($requestArray['startDate'], 'm/d/Y', 'Y-m-d')."'   and  '".Utils::dateFormat($requestArray['endDate'], 'm/d/Y', 'Y-m-d')."' ";



         



        $reservedRoom = $db->fetchSingleRow($query);

        if($requestArray['roomCount'] <= ($availableRoomDetails->nRoom -$reservedRoom->reservedRooms ) ) {
            $startingPrice = Booking::getStartingPrice($requestArray ['location'],$requestArray['accomodation'],Utils::dateFormat($requestArray['startDate'], 'm/d/Y', 'm-d-Y'),Utils::dateFormat($requestArray['endDate'], 'm/d/Y', 'm-d-Y'));

            $bookingAmount = Booking::getExtraAmount($requestArray ['location'], $requestArray['accomodation'], $requestArray['adults'], Utils::dateFormat($requestArray['startDate'], 'm/d/Y', 'm-d-Y'), Utils::dateFormat($requestArray['endDate'], 'm/d/Y', 'm-d-Y'), $startingPrice, $requestArray['roomCount']);


            if(strstr($bookingAmount,'blocked-')) {
                $tempArray = explode('blocked-',$bookingAmount);

                if($tempArray[1] != '') {
                    $message = $tempArray[1]; // Room has been blocked by administrator.
                }

                return array('availability'=>FALSE,'adults'=>0,"children"=>0,'status'=>'blocked','message'=>$message);
            }
            else if(strstr($bookingAmount ,'ER002-')){
                  $tempArray = explode('ER002-',$bookingAmount);
                  $message = 'Allowed adult number exceeded<br>Maximum allowed is '.$tempArray[1];
                  return array('availability'=>FALSE,'adults'=>0,"children"=>0,'status'=>'blocked','message'=>$message);
            }

            return array('availability'=>TRUE,'adults'=>$availableRoomDetails->nAdults,"children"=>$availableRoomDetails->nChildren,"guest"=>$availableRoomDetails->guest,'booking_amount'=>$bookingAmount,'accomodationAvailabilityId'=>$ids,'startingPrice'=>$startingPrice);
        }
        else {
            return array('availability'=>FALSE,'adults'=>0,"children"=>0);
        }

    }


    public static function changeUserStatus($values) {
        $id     =  $values['id'];
        $value  =  $values['value'];
        $userStatusUrl = BASE_URL.'cmshelper/ajaxUserStatusChange?id='.$id.'&value='.$value;
        return $userStatusUrl;
    }

    // Function to update User status
    public static function updateUserStatus($id,$value) {
        $db = new Db();
        $defaultVal = ($value == 'inactive')?'active':'inactive';

        $db->customQuery("UPDATE ".$db->tablePrefix."customers SET vActive = '" . $defaultVal . "' WHERE nCust_Id = '" . $id . "'");
    }
    public static function updatePenalityStatus($id,$value) {
        $db = new Db();
        $defaultVal = ($value == 'Inactive')?'1':'0';

        $db->customQuery("UPDATE ".$db->tablePrefix."Range SET vActive = '" . $defaultVal . "' WHERE nRId = '" . $id . "'");
    }

    public static function changeBannerStatus($values) {
        $id     =  $values['id'];
        $value  =  $values['value'];
        $userStatusUrl = BASE_URL.'cmshelper/ajaxBannerStatusChange?id='.$id.'&value='.$value;
        return $userStatusUrl;
    }



    public static function changeAffiliateLinkStatus($values) {
        $id     =  $values['id'];
        $value  =  $values['value'];
        $userStatusUrl = BASE_URL.'cmshelper/ajaxAffiliateLinkStatusChange?id='.$id.'&value='.$value;
        return $userStatusUrl;
        exit();
    }


    // Function to update User status
    public static function updateAffiliateLinkStatus($id,$value) {
        $defaultVal = ($value == '1')?'0':'1';
        //echo "UPDATE ".MYSQL_TABLE_PREFIX."affiliates_links SET link_status = '" . $defaultVal . "' WHERE link_id = '" . $id . "'";
        $db = new Db();
        $db->customQuery("UPDATE ".MYSQL_TABLE_PREFIX."affiliates_links SET link_status = '" . $defaultVal . "' WHERE link_id = '" . $id . "'");


    }





    // Function to update User status
    public static function updateBannerStatus($id,$value) {
        $db = new Db();
        $defaultVal = ($value == 1)?0:1;

        $db->customQuery("UPDATE ".$db->tablePrefix."Banners SET vActive = '" . $defaultVal . "' WHERE nBId = '" . $id . "'");
    }

    public static function changeLocationStatus($values) {
        $id     =  $values['id'];
        $value  =  $values['value'];
        $userStatusUrl = BASE_URL.'cmshelper/ajaxLocationStatusChange?id='.$id.'&value='.$value;
        return $userStatusUrl;
    }

    // Function to update User status
    public static function updateLocationStatus($id,$value) {
        $db = new Db();
        $defaultVal = ($value == 'deactive')?'active':'deactive';
        $db->customQuery("UPDATE ".$db->tablePrefix."locations SET vActive = '" . $defaultVal . "' WHERE nLocation_Id = '" . $id . "'");
    }

    public static function changeDestinationStatus($values) {
        $id     =  $values['id'];
        $value  =  $values['value'];
        $userStatusUrl = BASE_URL.'cmshelper/ajaxDestinationStatusChange?id='.$id.'&value='.$value;
        return $userStatusUrl;
    }

    // Function to update User status
    public static function updateDestinationStatus($id,$value) {
        $db = new Db();
        $defaultVal = ($value == 'deactive')?'active':'deactive';
        $db->customQuery("UPDATE ".$db->tablePrefix."destination SET  	vStatus = '" . $defaultVal . "' WHERE nDestination_Id = '" . $id . "'");
    }

    public static function changeLocationFeaturedStatus($values) {
        $id     =  $values['id'];
        $value  =  $values['value'];
        $userStatusUrl = BASE_URL.'cmshelper/ajaxLocationFeaturedStatusChange?id='.$id.'&value='.$value;
        return $userStatusUrl;
    }

    // Function to update User status
    public static function updateLocationFeaturedStatus($id,$value) {
        $db = new Db();
        $defaultVal = ($value == 'Yes')?'No':'Yes';
        $db->customQuery("UPDATE ".$db->tablePrefix."locations SET  	vFeatured = '" . $defaultVal . "' WHERE nLocation_Id = '" . $id . "'");
    }


    public static function changeAccomodationStatus($values) {
        $id     =  $values['id'];
        $value  =  $values['value'];
        $userStatusUrl = BASE_URL.'cmshelper/ajaxAccomodationStatusChange?id='.$id.'&value='.$value;
        return $userStatusUrl;
    }

    // Function to update User status
    public static function updateAccomodationStatus($id,$value) {
        $db = new Db();
        $defaultVal = ($value == 'deactive')?'active':'deactive';
        $db->customQuery("UPDATE ".$db->tablePrefix."accomodation_types SET vActive = '" . $defaultVal . "' WHERE nAt_Id  = '" . $id . "'");
    }


    // Function to update User status
    public static function updateAccomodationAvailabilityStatus($id,$value) {
        $db = new Db();
        $defaultVal = (strtolower($value) == 'inactive') ? 'active' : 'inactive';
        $db->customQuery("UPDATE ".$db->tablePrefix."available_acco_type SET vActive = '" . $defaultVal . "' WHERE nAat_Id  = '" . $id . "'");
    }

    public static function changeMailTemplateStatus($values) {
        $id     =  $values['id'];
        $value  =  $values['value'];
        $userStatusUrl = BASE_URL.'cmshelper/ajaxMailTemplateStatusChange?id='.$id.'&value='.$value;
        return $userStatusUrl;
    }

    // Function to update User status
    public static function updateMailTemplateStatus($id,$value) {
        $db = new Db();
        $defaultVal = ($value == 1)?0:1;
        $db->customQuery("UPDATE ".$db->tablePrefix."mail_template SET mail_template_status = '" . $defaultVal . "' WHERE id  = '" . $id . "'");
    }

    //Function used for encoding user password -- invoked from cms after user addition
    public function encodePassword($userId) {
        $dbh = new Db();

        $password = $dbh->selectRow("customers", "vPassword", "nCust_Id =".  intval($userId));
        $password = md5($password);
        $query = " UPDATE ".$dbh->tablePrefix."customers SET vPassword = '$password' WHERE nCust_Id =".  intval($userId);
        $dbh->customQuery($query);
    }

    //Function used for encoding user password -- invoked from cms after user addition
    public static function unsetPassword($postArray) {
        $db =  new Db();

        $userDet = $db->fetchSingleRow("Select * from  ".$db->tablePrefix."customers where nCust_Id =".$postArray['nCust_Id']);

        if($userDet->vPassword == $postArray['vPassword']) {
            unset($postArray['vPassword']);
        }else {
            self::encodeUserPassword($postArray['nCust_Id'],trim(urldecode($postArray['vPassword'])));
            unset($postArray['vPassword']);
        }

        unset($postArray['dDatejoin']);
        return $postArray;
    }

    //Function used for encoding user password -- invoked from cms after user addition
    public static function encodeUserPassword($userId,$password) {
        $dbh = new Db();
        $password = md5($password);
        $query = " UPDATE ".$dbh->tablePrefix."customers SET vPassword ='$password' WHERE nCust_Id =".  intval($userId);
        $dbh->customQuery($query);
        echo $query;

    }

    public static function getuserLoggedInUrl($userid) {
        $userUrl = BASE_URL.'customer/getUserLoggedInSession/'.$userid;
        return $userUrl ;
    }


    //Fucntion to fetch feedbacks
    public static  function fetchInquiries($searchCriteria, $limit) {
        $db = new Db();

        if(!empty($searchCriteria['searchField']) && !empty($searchCriteria['searchText'])) {
            switch($searchCriteria['searchField']) {
                case 'vEmail':
                    $searchCriteriaQuery = "vEmail LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
                    break;

                case 'vName':
                    $searchCriteriaQuery = "vName LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
                    break;

                default :
                    $searchCriteriaQuery = " 1";
                    BREAK;
            }

        }else {
            $searchCriteriaQuery = " 1 ";
        }

        $payments = $db->selectResult("enquiry","*", "  $searchCriteriaQuery   $limit");

        return $payments;
    }

    public static function updateInquiry($enqId) {
        $dbh = new Db();
        $dbh->update($dbh->tablePrefix."enquiry", array('status'=>1), " nEnq_Id =".$enqId);
    }

    // Cms Invoice details
    public static function getInvoicePopupUrl($params) {
        PageContext::addStyle("invoice.css");
        $orderId = $params['id'];
        $dbh = new Db();
        $invoicePopupUrl =  BASE_URL.'cmshelper/invoicedetailspopup?id='.$orderId;
        return $invoicePopupUrl;
    }

    public static function getOrderId($orderId) {
        $dbh = new Db();
        return $orderId;
    }

    public static function getUserPopupUrl($params) {
        $customerId = Cmshelper::getCustomerIdFromOrder($params['id']);

        // $userId = $params['id'];
        $dbh = new Db();
        $userPopupUrl =  BASE_URL.'cmshelper/userdetailspopup?id='.$customerId;
        return $userPopupUrl;
    }

    public static function getUserPopupUrlForCustomersLink($customerId) {
        $customerData = Customer::getCustomerDetails($customerId); 
        $dbh = new Db();
        //$userPopupUrl =  BASE_URL.'cmshelper/userdetailspopup?id='.$customerId;
        $userPopupUrl = '<a href="#'.$customerId.'" data-toggle="modal">'.$customerData[0]->vFirstname.'</a>';
        return $userPopupUrl;
    }

    public static function getLocationPopupUrlLocationLink($params) {

        $locationId = $params['id'];

        $userPopupUrl =  BASE_URL.'cmshelper/locationdetailspopup?id='.$locationId;
        return $userPopupUrl;
    }

    public static function getDestinationPopupUrlDestinationLink($params) {
        $destinationId = $params['id'];

        // $userId = $params['id'];
        $dbh = new Db();
        $userPopupUrl =  BASE_URL.'cmshelper/destinationdetailspopup?id='.$destinationId;
        return $userPopupUrl;
    }

    public static function getDestinationPopupUrlLocationLink($params) {
        $locationId = $params['id'];

        $destinationId = self::getDestinationFromLocation($locationId);
        $dbh = new Db();
        $userPopupUrl =  BASE_URL.'cmshelper/destinationdetailspopup?id='.$destinationId;
        return $userPopupUrl;
    }

    public static function getAccomodationPopupUrl($params) {
        $accomodatonId = $params['id'];


        $dbh = new Db();
        $userPopupUrl =  BASE_URL.'cmshelper/accomodationdetailspopup?id='.$accomodatonId;
        return $userPopupUrl;
    }

    public static function getInquiry() {

        $url =  BASE_URL.'cms?section=enquiries';
        return $url;
    }

    public static function getOrders() {

        $url =  BASE_URL.'cms?section=booking_orders';
        return $url;
    }


    public static function getCancelledOrders() {

        $url =  BASE_URL.'cms?section=cancelled_orders';
        return $url;
    }
    public static function getCustomerIdFromOrder($bookingId) {
        $dbh = new Db();
        return $dbh->selectRow("booking", " 	nCust_Id", " nBooking_Id=".$bookingId);
    }

    public function getBookingDetails($bookingId) {
        $dbh = new Db();
        return $dbh->selectRecord("booking B LEFT JOIN ".$dbh->tablePrefix."allotment A ON (A.nBooking_Id  = B.nBooking_Id )
             LEFT JOIN ".$dbh->tablePrefix."available_acco_type AAT ON (AAT.nAat_Id = A.nAat_Id )
             LEFT JOIN ".$dbh->tablePrefix."accomodation_types AT ON (AT.nAt_Id = AAT.nAt_Id )
             LEFT JOIN ".$dbh->tablePrefix."locations L ON (L.nLocation_Id = AAT.nLocation_Id )
             LEFT JOIN ".$dbh->tablePrefix."destination D ON (L.nDestination_Id = D.nDestination_Id )
             LEFT JOIN ".$dbh->tablePrefix."customers C ON (C.nCust_Id = B.nCust_Id )", " B.*,L.vLocation_Name ,D.vDestination_Name ,AT.vAt_Name,
                 C.*,CONCAT(C.vAddress1,', ',C.vAddress2,', ',C.vCity,', ',C.vState,', ',C.vZip,', ',C.vCountry) AS Address, CONCAT(C.vFirstname,', ',C.vLastname) AS fullName ", " B.nBooking_Id=".$bookingId);
    }

    public static function getDestinationFromLocation($locationId) {
        $dbh = new Db();
        return $dbh->selectRow("locations", " 	nDestination_Id", " nLocation_Id=".$locationId);
    }

    public static function fetchDestinationDetails($destinationId) {
        $dbh = new Db();
        return $dbh->selectRecord("destination D INNER JOIN ".$dbh->tablePrefix."files F ON (F.file_id = D.file_id) ", " D.*,F.file_path", " nDestination_Id=".$destinationId);
    }

    public static function fetchLocationdestinationDetails($locationId) {
        $dbh = new Db();
        return $dbh->selectRecord("locations L INNER JOIN ".$dbh->tablePrefix."destination D ON (L.nDestination_Id = D.nDestination_Id) ", " L.*,D.vDestination_Name", " nLocation_Id=".$locationId);
    }

    public static function fetchAccomodationDetails($accomoId) {
        $dbh = new Db();
        return $dbh->selectRecord("accomodation_types  ", " *", " nAt_Id=".$accomoId);
    }

    public static function getOrderStatusChangeLink($orderId) {



        $dbh = new Db();
        $orderDetails = $dbh->selectRecord("booking", "*", "nBooking_Id =".$orderId );

        if(strtotime($orderDetails->dArrival_Date) >=time() && strtolower($orderDetails->vStatus) != 'canceled') {
            // return '<button  class="jqOrderPupUp btn btn-link" value='.$orderId.'>'.$orderDetails->vStatus.'</button>';
            return '<button id="link_'.$orderId.'" class="jqPopupLink btn btn-link" value='.BASE_URL.'cmshelper/orderstatuschangepopup?id='.$orderId.'>'.$orderDetails->vStatus.'</button>';
        }else if(strtotime($orderDetails->dArrival_Date) >= strtotime(date('Y-m-d')) && strtolower($orderDetails->vStatus) == 'pending') {
            // return '<button  class="jqOrderPupUp btn btn-link" value='.$orderId.'>'.$orderDetails->vStatus.'</button>';
            return '<button id="link_'.$orderId.'" class="jqPopupLink btn btn-link" value='.BASE_URL.'cmshelper/orderstatuschangepopup?id='.$orderId.'>'.$orderDetails->vStatus.'</button>';
        }else {
            return '&nbsp;&nbsp;&nbsp;&nbsp;'.$orderDetails->vStatus;
        }
    }

    public static function getOrderDetails($orderId) {

        $dbh = new Db();
        return $dbh->selectRecord("booking", "*", "nBooking_Id =".$orderId );
    }

    public static function updateOrderStatus($orderId, $status) {
        $status = mysql_real_escape_string($status);
        $dbh = new Db();
        if($status == 'canceled')
            self::deallocateRooms($orderId);
        $dbh->update($dbh->tablePrefix."booking",array('vStatus'=>$status), "nBooking_Id =".$orderId );

        if($status == 'confirmed') {
            $bookingDetails = Cancel::getBookingDetails($orderId);
            $replaceParameters['mailBody']  .= '<table border="0">';
            $replaceParameters['mailBody']  .= '<tr><th colspan="2" align="left">'.BOOKING_CONFIRMATION_MAIL_ORDER_DETAIL_HEADING.'</th></tr>';

            $replaceParameters['mailBody']  .= '<tr><td>'.BOOKING_CONFIRMATION_MAIL_LABEL_DESTINATION_NAME.':</td><td>'.stripslashes($bookingDetails[0]->vDestination_Name).'</td></tr>';
            $replaceParameters['mailBody']  .= '<tr><td>'.BOOKING_CONFIRMATION_MAIL_LABEL_LOCATION_NAME.':</td><td>'.stripslashes($bookingDetails[0]->vLocation_Name).'</td></tr>';
            $replaceParameters['mailBody']  .= '<tr><td>'.BOOKING_CONFIRMATION_MAIL_LABEL_ACCOMMODATION_NAME.':</td><td>'.stripslashes($bookingDetails[0]->vAt_Name).'</td></tr>';
            $replaceParameters['mailBody']  .= '<tr><td>'.BOOKING_CONFIRMATION_MAIL_LABEL_NO_OF_ROOMS.':</td><td>'.$bookingDetails[0]->nRooms.'</td></tr>';
            $replaceParameters['mailBody']  .= '<tr><td>'.BOOKING_CONFIRMATION_MAIL_LABEL_CHECK_IN.':</td><td>'.date('m/d/Y',  strtotime($bookingDetails[0]->dArrival_Date)).'</td></tr>';
            $replaceParameters['mailBody']  .= '<tr><td>'.BOOKING_CONFIRMATION_MAIL_LABEL_CHECK_OUT.':</td><td>'.date('m/d/Y',  strtotime($bookingDetails[0]->dArrival_Date.'+'.$bookingDetails[0]->nNights_Stay.'days')).'</td></tr>';
            $replaceParameters['mailBody']  .= '<tr><td>'.BOOKING_CONFIRMATION_MAIL_LABEL_NO_OF_ADULTS.':</td><td>'.$bookingDetails[0]->nAdults.'</td></tr>';
            $replaceParameters['mailBody']  .= '<tr><td>'.BOOKING_CONFIRMATION_MAIL_LABEL_NO_OF_CHILDREN.':</td><td>'.$bookingDetails[0]->nChildren .'</td></tr>';
            $replaceParameters['mailBody']    .= '</table>';


            $replaceParameters['name'] = $bookingDetails[0]->vFirstname;

            Utils::sendUserMail($bookingDetails[0]->vEmail, "PendingBookingConfirmation", $replaceParameters);
        }
        return true;

    }

    public static function getFeedbackUserPopupUrl($params) {
        $feedbackId = $params['id'];
        $dbh = new Db();
        $userPopupUrl =  BASE_URL.'cmshelper/feedbackuserdetailspopup?id='.$feedbackId;
        return $userPopupUrl;
    }

    public static function getFeedbackDetails($feebbackId) {

        $dbh = new Db();
        return $dbh->selectRecord("feedbacks", "*", "nFeedback_Id =".$feebbackId );
    }

    public static function getCustomerFromOrder($bookingId) {

        $dbh = new Db();
        $bookingDetails = $dbh->selectRecord("booking B LEFT JOIN ".$dbh->tablePrefix."customers C ON(B.nCust_Id = C.nCust_Id) ", "B.nCust_Id, C.vFirstname,C.vEmail, B.vBookedBy", " nBooking_Id=".$bookingId );
        if($bookingDetails->vBookedBy == 'ADMIN') {
            return 'Admin[Offline Booking]';
        }else {
            return $bookingDetails->vEmail;
        }

    }

    public static function getInquiryReplyPopupUrl($enqId) {

        $enqDetails = self::getInquiryDetails($enqId);
        if($enqDetails->status == 0) {
            // return '<button  class="jqOrderPupUp btn btn-link" value='.$orderId.'>'.$orderDetails->vStatus.'</button>';
            return '<button id="link_'.$enqDetails->nEnq_Id.'" class="jqPopupLink btn btn-link" value='.BASE_URL.'cmshelper/replyinquirypopup?id='.$enqDetails->nEnq_Id.'>'.self::INQUIRY_POST_REPLY_STATUS_STRING.'</button>';
        }else {
            return '&nbsp;&nbsp;&nbsp;&nbsp;'.self::INQUIRY_REPLIED_STATUS_STRING;
        }

    }

    public static function getInquiryUserPopupUrl($params) {
        $enqId = $params['id'];
        $dbh = new Db();
        $userPopupUrl =  BASE_URL.'cmshelper/inquiryuserdetailspopup?id='.$enqId;
        return $userPopupUrl;
    }


    //Quick Start Popup Guide Url
    public static function getQuickStartGuidePopupUrl() {
        return BASE_URL.'cmshelper/quickstartguidepopup';

    }

    //Quick admin help listing
    public static function getAdminHelpListingPopupUrl() {
        $url =  BASE_URL.'cms?section=admin_help_listings';
        return $url;

    }

    public static function getInquiryDetails($enqId) {

        $dbh = new Db();
        return $dbh->selectRecord("enquiry", "*", "nEnq_Id =".$enqId );
    }

    //Function to add penalty
    public static function addPenalty($requestArray) {
        $dbh = new Db();
        $dbh->addFields("Range", $requestArray);
    }
    
    //Function to add navigation
    public static function addNavigation($requestArray) {
        $dbh = new Db();
        $dbh->addFields("navigation", $requestArray);
    }

    //Fucntion to update penalty
    public static function updatePenalty($requestArray, $penaltyId) {
        $dbh = new Db();
        $dbh->updateFields("Range", $requestArray," nRId=".$penaltyId);
    }
    
     //Fucntion to update navigation
    public static function updateNavigation($requestArray, $navigationId) {
        $dbh = new Db();
        $dbh->updateFields("navigation", $requestArray," id=".$navigationId);
    }

    //Fucntion to fetch penalties
    public static function fetchPenalties($limit) {
        $dbh = new Db();
        return $dbh->selectResult("Range", "*"," 1 $limit");
    }
    
    //Fucntion to fetch navigation
    public static function fetchNavigation($limit) {
        $dbh = new Db();
        return $dbh->selectResult("navigation", "*"," 1 $limit");
    }

    //Fucntion to fetch penalty details
    public static function fetchPenaltyDetails($penaltyId) {
        $dbh = new Db();
        return $dbh->selectResult("Range", "*"," nRId=".$penaltyId);
    }
    
    //Fucntion to fetch navigation details
    public static function fetchNavigationDetails($navigationId) {
        $dbh = new Db();
        return $dbh->selectResult("navigation", "*"," id=".$navigationId);
    }

    //Function to check penalty exists for selected number of days
    public static function checkPenaltyDetails($numberOfDays, $penaltyId) {
        $dbh = new Db();

        if($penaltyId)
            $filterQuery =" nRId!=".intval($penaltyId);
        else
            $filterQuery = " 1";

        return $dbh->selectResult("Range", "*","  vTitle=".$numberOfDays." AND $filterQuery");
    }

    //Fucntion to remove penalty
    public static function removePenalty($penaltyId) {
        $dbh = new Db();
        $dbh->deleteRecord("Range", " nRId=".$penaltyId);
    }
    
    //Fucntion to remove navigation
    public static function removeNavigation($navigationId) {
        $dbh = new Db();
        $dbh->deleteRecord("navigation", " id=".$navigationId);
    }

    public static function unsetDateField($postArray) {
        unset($postArray['nDate']);
        return $postArray;
    }

    public static function fetchDestinationFromOrder($orderId) {
        $dbh = new Db();
        return $dbh->selectRow("booking B INNER JOIN ".$dbh->tablePrefix."allotment A ON(B.nBooking_Id = A.nBooking_Id)
             INNER JOIN ".$dbh->tablePrefix."available_acco_type AAT ON (A.nAat_Id = AAT.nAat_Id)
             INNER JOIN ".$dbh->tablePrefix."locations L ON (L.nLocation_Id = AAT.nLocation_Id)
             INNER JOIN ".$dbh->tablePrefix."destination D ON (L.nDestination_Id = D.nDestination_Id)", "vDestination_Name", " B.nBooking_Id=".$orderId);
    }

    public static function fetchLocationFromOrder($orderId) {
        $dbh = new Db();
        return $dbh->selectRow("booking B INNER JOIN ".$dbh->tablePrefix."allotment A ON(B.nBooking_Id = A.nBooking_Id)
             INNER JOIN ".$dbh->tablePrefix."available_acco_type AAT ON (A.nAat_Id = AAT.nAat_Id)
             INNER JOIN ".$dbh->tablePrefix."locations L ON (L.nLocation_Id = AAT.nLocation_Id)
             ", " vLocation_Name", " B.nBooking_Id=".$orderId);
    }

    //Function to execute before ading customer [cms]
    public static function sendUserMail($postedArray) {
        Customer::sendLoginInfoForFreshUser($postedArray['vEmail'],$postedArray['vLogin'],$postedArray['vPassword']);
        return $postedArray;
    }

    public static function fetchHelpContents($htype,$searchCriteria, $limit) {
        $dbh = new Db();
        if(!empty($searchCriteria['searchField']) && !empty($searchCriteria['searchText'])) {
            switch($searchCriteria['searchField']) {
                case 'hctitle':
                    $searchCriteriaQuery = "hctitle LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
                    break;

                case 'htitle':
                    $searchCriteriaQuery = "htitle LIKE '%".mysql_real_escape_string(trim($searchCriteria['searchText']))."%'";
                    break;

                default :
                    $searchCriteriaQuery = " 1";
                    BREAK;
            }

        }else {
            $searchCriteriaQuery = " 1 ";
        }


        return $dbh->selectResult("Help H INNER JOIN ".$dbh->tablePrefix."HelpCategory HC ON (H.hcid = HC.hcid  )
              LEFT JOIN ".$dbh->tablePrefix."files F ON (F.file_id = H.file_id)", " H.*,HC.hctitle,F.file_path", " HC.htype='$htype' AND $searchCriteriaQuery $limit");
    }
    //Fetches Help Categories
    public static function getHelpCategoriesByType($htype = 'admin') {
        $db	    = new Db();
        $getAllHelpCategories = $db->selectResult('HelpCategory','hcid,hctitle'," active='1' and  htype = '$htype'");
        $var=0;
        foreach($getAllHelpCategories as $catgory) {
            $result[$var]->value = $catgory->hcid;
            $result[$var]->text = $catgory->hctitle;
            $var++;
        }
        return $result;
    }
    //Function to remove help content
    public static function removeHelpContent($id) {
        $dbh = new Db();
        $dbh->deleteRecord("Help", " hid =".$id);

    }

    //Function to remove help content
    public static function addHelpContent($requestArray) {
        $dbh = new Db();
        $dbh->addFields("Help", $requestArray);

    }

    //Function to remove help content
    public static function updateHelpContent($requestArray, $id) {
        $dbh = new Db();
        $dbh->updateFields("Help", $requestArray," hid =".$id);

    }

    //Fucntion to update capture status
    public static function updateCaptureStatus($paymentId) {
        $dbh = new Db();
        $query = "UPDATE ".$dbh->tablePrefix."payment SET vCapture='Y' WHERE
				 		AND nPayment_Id='".$paymentId."'";
        $dbh->customQuery($query) ;
    }

    public static function updateFooterLogo($footerLogoName) {
        $dbh = new Db();
        $dbh->update($dbh->tablePrefix."lookup", array('vLookUp_Value'=>$footerLogoName), " vLookUp_Name = 'logoFooter'");
    }

    private static function deallocateRooms($orderId) {
        $dbh = new Db();
        $dbh->update($dbh->tablePrefix."allotment",array("vStatus"=>'canceled'), " 	nBooking_Id=".$orderId);
    }

    public static function deleteDestination($destinationId) {

        $dbh = new Db();
        $status = $dbh->checkExists("locations","*", " nDestination_Id=".$destinationId);

        if(!$status) {
            $dbh->deleteRecord("destination", " nDestination_Id=".$destinationId);
            return array('status'=>'success');
        }else {
            $dbh->updateFields("destination",array('vStatus'=>'deactive') ," nDestination_Id=".$destinationId);
            $array['status'] = "error";
            $array['message'] = "Location exists under destination.";
            return $array;
            // return array('status'=>'error'),"Location exists under destination.");
        }
    }

    public static function fetchAdminHelpListings( $limit) {
        $dbh = new Db();

        $results = $dbh->selectResult("Help H INNER JOIN ".$dbh->tablePrefix."HelpCategory HC ON (H.hcid = HC.hcid  )
              LEFT JOIN ".$dbh->tablePrefix."files F ON (F.file_id = H.file_id)", " H.*,HC.hctitle,HC.hcid,F.file_path", " HC.htype='admin'   ORDER BY  hcposition, hposition desc $limit");

        $helpCategoryId = null;
        $loopVal = 1;
        foreach ($results as $data) {

            if( !empty($helpCategoryId) && ($loopVal == count($results) || $helpCategoryId != $data->hcid)) {

                $dataObject = new stdClass();
                $dataObject->hctitle = $helpCatgeoryTitle;
                $dataObject->hcid = $helpCategoryId;
                $dataObject->helpids = $helpIds;
                $dataObject->helpTitles = $helpTitles;
                $dataObject->helpImages = $helpTitleImages;
                $dataObject->helpDescriptions = $helpDescriptions;
                $resultArray[] = $dataObject;
                unset($helpTitles);
                unset($helpTitleImages);
                unset($helpIds);
            }


            if(empty($helpCategoryId) || $helpCategoryId != $data->hcid) {
                unset($helpTitles);
                unset($helpTitleImages);
                unset($helpIds);

                $helpCategoryId = $data->hcid;
                $helpTitles[]= $data->htitle;
                $helpTitleImages[]= $data->file_path;
                $helpIds[] = $data->hid;
                $helpDescriptions[] = $data->hdescription;
                $helpCatgeoryTitle = $data->hctitle;
            }else if($helpCategoryId == $data->hcid) {

                $helpTitles[]= $data->htitle;
                $helpTitleImages[]= $data->file_path;
                $helpIds[] = $data->hid;
                $helpDescriptions[] = $data->hdescription;
            }


            $loopVal ++;

        }


        return array('data'=>$resultArray,'count'=>count($results));
    }

    public static function fetchBankDetails($paymentId) {
        $dbh = new Db();
        return $dbh->selectRecord("bank_details", "*","  	paymentId=".$paymentId);
    }

    //Function to settle payments for booking
    public static function settleCancelletionPayments($requestArray) {
        $dbh = new Db;
        $sqlUpdate = "UPDATE ".$dbh->tablePrefix."payment
        SET	vStatus='Yes',dDate_Settled='"	. date('Y-m-d H:m:s')	."',
	vTxn_Id='". addslashes(mysql_real_escape_string($requestArray['refNumber']))."',
	vPayment_Type='". addslashes(mysql_real_escape_string($requestArray['payType']))."'
        WHERE  	nPayment_Id ='" 	. $requestArray ['payId'] . "'";


        $dbh->execute($sqlUpdate);

        $bookingId = $dbh->selectRow("payment", "nBooking_Id", " nPayment_Id =". $requestArray ['payId'] );
        $dbh->update($dbh->tablePrefix."booking",array('vStatus'=>'canceled'), "nBooking_Id =".$bookingId );
        $dbh->update($dbh->tablePrefix."allotment",array("vStatus"=>'canceled'), " 	nBooking_Id=".$bookingId);

        $bookingDetails = Cancel::getBookingDetails($bookingId);
        $replaceParameters['mailBody']  .= '<table border="0">';
        $replaceParameters['mailBody']  .= '<tr><th colspan="2" align="left">'.CANCELLATION_MAIL_DETAIL_HEADING.'</th></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_DESTINATION_NAME.':</td><td>'.stripslashes($bookingDetails[0]->vDestination_Name).'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_LOCATION_NAME.':</td><td>'.stripslashes($bookingDetails[0]->vLocation_Name).'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_ACCOMMODATION_NAME.':</td><td>'.stripslashes($bookingDetails[0]->vAt_Name).'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_NO_OF_ROOMS.':</td><td>'.$bookingDetails[0]->nRooms.'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_CHECK_IN.':</td><td>'.date('m/d/Y',  strtotime($bookingDetails[0]->dArrival_Date)).'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_CHECK_OUT.':</td><td>'.date('m/d/Y',  strtotime($bookingDetails[0]->dArrival_Date.'+'.intval($bookingDetails[0]->nNights_Stay).'days')).'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_NO_OF_ADULTS.':</td><td>'.$bookingDetails[0]->nAdults.'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_NO_OF_CHILDREN.':</td><td>'.$bookingDetails[0]->nChildren .'</td></tr>';
        $replaceParameters['mailBody']    .= '</table>';
        $replaceParameters['name'] = $bookingDetails[0]->vFirstname;
        $userMailId = $dbh->selectRow("customers C INNER JOIN ".$dbh->tablePrefix."booking B ON(C.nCust_Id = B.nCust_Id)" , "vEmail", " 	nBooking_Id=".$bookingId);
        Utils::sendUserMail($userMailId, "AdminPanelPendingCancelConfirmation", $replaceParameters);
    }
    public static function getaffiliatelinks($link_id) {
        $dbh = new Db();
       
        $linkDetails= $dbh->selectRecord("affiliates_links", "link_type,link_image"," link_id=".$link_id);
        //print_r($linkDetails);die();
        if($linkDetails->link_type == 0 && $linkDetails->link_image != NULL) {
            $linkImage= $dbh->selectRecord("files", "file_path"," file_id=".$linkDetails->link_image);
            $imgPath = '<img src="'.USER_IMAGE_URL.$linkImage->file_path.'">';
            return $imgPath;
        }
        
    }
    public static function bindSiteLogo() {
        $content = '<img alt="'.SITE_NAME.'" src="'.Cmshelper::getSiteLogo().'" />';
        return $content;
    }
    public static function getSiteLogo() {
        $dbh = new Db();
        $logoDetails= $dbh->selectRecord("lookup", "vLookUp_Value"," vLookUp_Name='sitelogo'");

        $siteLogo =  BASE_URL.'project/styles/images/'.$logoDetails->vLookUp_Value;
        return $siteLogo;
    } // End Function
    public static function fetchOrderData($request,$perPageSize='8')
    {        

        $dbh                     = new db();
        $tablePrefix             = $dbh->tablePrefix;

        $perPageSize             = $request['perPageSize'];
        $page                    = $request['page'];

        if($page == '')  $page   = 1;

        $startPage               = ($page-1)*$perPageSize;
        $limit                   = " LIMIT $startPage,$perPageSize";


        if(trim($request['orderField']) != '')
        {

            if($request['orderField'] == 'nCust_Id')
                 $order = " ORDER BY ".$tablePrefix."customers.vFirstname " . $request['orderType'] ;
            else
                 $order = " ORDER BY ".$tablePrefix."booking.".$request['orderField'].' ' . $request['orderType'] ;
        }
        else
        {
            $order = " ORDER BY ".$tablePrefix."booking.nBooking_Id DESC ";
        }



        if($request['searchField'] == 'dArrival_Date' || $request['searchField'] == 'dBooking_Date')
            $request['searchText'] = Utils::dateFormat($request['searchText'], 'm/d/Y', 'Y-m-d');



         if(trim($request['searchText']) != '' )
         {

            if($request['searchField'] == 'nCust_Id')
               $where = " and ".$tablePrefix."customers.vFirstname LIKE '%" . $request['searchText']."%'" ;

            else if($request['searchField'] == 'dArrival_Date' || $request['searchField'] == 'dBooking_Date')
               $where = " and  DATE_FORMAT(".$tablePrefix."booking.".$request['searchField'].",'%Y-%m-%d') = '" . $request['searchText']."'" ;

            else
               $where = " and ".$tablePrefix."booking.".$request['searchField']." = '" . $request['searchText']."'" ;

         }


        $query = "SELECT ".$tablePrefix."booking.dArrival_Date,".$tablePrefix."booking.dBooking_Date,".$tablePrefix."booking.vBooking_Details,".$tablePrefix."booking.nNights_Stay,".$tablePrefix."booking.nRooms,".$tablePrefix."booking.nAmount,".$tablePrefix."booking.nAdults,".$tablePrefix."booking.nChildren, ".$tablePrefix."booking.nBooking_Id FROM ".$tablePrefix."booking
                  LEFT JOIN ".$tablePrefix."customers ON ".$tablePrefix."booking.nCust_Id=".$tablePrefix."customers.nCust_Id  WHERE 1 AND ".$tablePrefix."booking.vStatus!='canceled' and ".$tablePrefix."booking.vStatus!='cancelPending' $where $order  $limit";


        $res                     = $dbh->execute($query);
        return  $dbh->fetchAll($res);

    }
    public static function fetchOrderDataCount()
    {
        
        $dbh                     = new db();
        $tablePrefix             = $dbh->tablePrefix;



        if($request['searchField'] == 'dArrival_Date' || $request['searchField'] == 'dBooking_Date')
            $request['searchText'] = Utils::dateFormat($request['searchText'], 'm/d/Y', 'Y-m-d');



         if(trim($request['searchText']) != '' )
         {

            if($request['searchField'] == 'nCust_Id')
               $where = " and ".$tablePrefix."customers.vFirstname LIKE '%" . $request['searchText']."%'" ;

            else if($request['searchField'] == 'dArrival_Date' || $request['searchField'] == 'dBooking_Date')
               $where = " and  DATE_FORMAT(".$tablePrefix."booking.".$request['searchField'].",'%Y-%m-%d') = '" . $request['searchText']."'" ;

            else
               $where = " and ".$tablePrefix."booking.".$request['searchField']." = '" . $request['searchText']."'" ;

         }


        $query = "SELECT ".$tablePrefix."booking.dArrival_Date,".$tablePrefix."booking.dBooking_Date,".$tablePrefix."booking.vBooking_Details,".$tablePrefix."booking.nNights_Stay,".$tablePrefix."booking.nRooms,".$tablePrefix."booking.nAmount,".$tablePrefix."booking.nAdults,".$tablePrefix."booking.nChildren, ".$tablePrefix."booking.nBooking_Id FROM ".$tablePrefix."booking
                  LEFT JOIN ".$tablePrefix."customers ON ".$tablePrefix."booking.nCust_Id=".$tablePrefix."customers.nCust_Id  WHERE 1 AND ".$tablePrefix."booking.vStatus!='canceled' and ".$tablePrefix."booking.vStatus!='cancelPending' $where";




        $res                     = $dbh->execute($query);
        $listData                = $dbh->fetchAll($res);
        return count($listData);
    }

    public static function deleteCustomer($customerId)
    {


        $dbh                     = new db();
        $tablePrefix             = $dbh->tablePrefix;

        $query = " DELETE FROM `".$dbh->tablePrefix."customers` WHERE `nCust_Id` = $customerId";
        Logger::info($query);
        $dbh->execute($query);

        $query = " SELECT `nBooking_Id` FROM `".$dbh->tablePrefix."booking` WHERE `nCust_Id` = $customerId";
        $result = $dbh->selectQuery($query);



        foreach($result as $key => $value)
        {
            
            $tempBookingId =  $value->nBooking_Id;

            $query = " DELETE FROM `".$dbh->tablePrefix."allotment` WHERE `nBooking_Id` = $tempBookingId";
            $dbh->execute($query);


            $query = " DELETE FROM `".$dbh->tablePrefix."payment` WHERE `nBooking_Id` = $tempBookingId";
            $dbh->execute($query);


            $query = " DELETE FROM `".$dbh->tablePrefix."affiliate_useraction` WHERE `ua_booking_id` = $tempBookingId";
            $dbh->execute($query);
            
            
            $query = " DELETE FROM `".$dbh->tablePrefix."booking` WHERE `nBooking_Id` = $tempBookingId";
            $dbh->execute($query);





            
        }



        $query = " DELETE FROM `".$dbh->tablePrefix."affiliate_useraction` WHERE `ua_userid` = $customerId";
        $dbh->execute($query);

        $query = " DELETE FROM `".$dbh->tablePrefix."rating` WHERE `nCust_Id` = $customerId";
        $dbh->execute($query);


      return array("status"=>"success");
    }



     public static function updateNewsDate($newsId)
    {
        $db                             = new Db();
        $table                          = 'News';
        $dataArray                      = array();


        $dataArray['cur_date']         = date('Y-m-d');

        $db->update(MYSQL_TABLE_PREFIX.$table, $dataArray,'nid="'.mysql_real_escape_string($newsId).'"');


    }

    public function createThumbnail($photoName,$imagePrefix,$crop=true,$width,$height,$uploadUrl) {

        $model 			= new Db();
        $sourceFile = $uploadUrl. $photoName;
        $destFile  = $uploadUrl.$imagePrefix. $photoName;
        $ih = new Gdimagehandler($sourceFile);
        $ih->generateThumbnail($destFile,$width,$height,$crop);

    }

    public static function getAffiliateCustomerCount($affiliateId) { 
        $dbh = new Db();

        $join = " INNER JOIN ".MYSQL_TABLE_PREFIX."affiliates a ON au.ua_aff_id = a.aff_id  ";
        $where = " WHERE au.ua_aff_id =".$affiliateId;
        $afilateCustomerCount= $dbh->getDataCount("affiliate_useraction au $join", "ua_id",$where);
        
        return $afilateCustomerCount;
    }


    public static function getTotalAffilateAmount($affiliateId) {
        $dbh = new Db();

        $join = " INNER JOIN ".MYSQL_TABLE_PREFIX."affiliates a ON au.ua_aff_id = a.aff_id  ";
        $where = " au.ua_aff_id ='".$affiliateId ."' AND au.ua_paystatus='1'";
        $afilateAmount = $dbh->selectRecord("affiliate_useraction au $join", "SUM(ua_referalcharge) as amount",$where);
        $amount = ($afilateAmount->amount)?$afilateAmount->amount:0;
        return number_format($amount,2);
    }

    public static function getSettledStatus($affiliateId) {
        $dbh = new Db();

        $join = " INNER JOIN ".MYSQL_TABLE_PREFIX."affiliates a ON au.ua_aff_id = a.aff_id  ";
        $where = " au.ua_aff_id =".$affiliateId ." AND au.ua_paystatus='1' AND a.aff_status='1'";
        $settledData = $dbh->selectResult("affiliate_useraction au $join", "a.aff_id,au.ua_paystatus",$where);
        //echopre($settledData);
        $flagStatus = 0;
        foreach($settledData as $data){
            if($data->ua_paystatus ==1) $flagStatus = 1;
        }
        $aff_id = $settledData[0]->aff_id;
        $settledStatus = ($flagStatus ==1)?'Settle':'-';
        $settledRes = '<button value="'.BASE_URL.'cmshelper/affiliatesettlepopup?id='.$aff_id.'" class="jqPopupLink btn btn-link" id="link_50">'.$settledStatus.'</button>';
        //echopre($settledData);
     
        return $settledRes;
    }


    //Function to settle payments for affiliates
    public function settleAffiliatePayment($affliateId,$paymentType) { //echopre1($requestArray);
        $dbh = new Db;

        $join = " INNER JOIN ".MYSQL_TABLE_PREFIX."affiliates a ON au.ua_aff_id = a.aff_id  ";
        $where = " au.ua_aff_id =".$affliateId ." AND au.ua_paystatus='1'";
        $settledData = $dbh->selectResult("affiliate_useraction au $join", "ua_aff_id,ua_userid",$where);

        foreach($settledData as $sData){
            $sqlUpdate = "UPDATE ".$dbh->tablePrefix."affiliate_useraction
            SET ua_paystatus='2',ua_date_settled='". date('Y-m-d H:m:s')."',
            ua_settled_type='". mysql_real_escape_string($paymentType)."'
            WHERE ua_aff_id='" . $sData->ua_aff_id . "' AND ua_userid='". $sData->ua_userid."'";

            $dbh->execute($sqlUpdate);
        }
        return true;
    }

     public static  function checkBlockedPropertyExists($requestArray) {
        $dbh = new Db();
        $startDate = date('Y-m-d',strtotime($requestArray['date']."+0 days"));
        $endDate = date('Y-m-d',strtotime($requestArray['date']."+".$requestArray['numberofdays']." days"));

        $query = " SELECT GROUP_CONCAT(DISTINCT AAT.nAat_Id) as accoTypeIds FROM ".MYSQL_TABLE_PREFIX."available_acco_type AAT
                   WHERE nLocation_Id = ".$requestArray['location']." and AAT.nAt_Id IN(".$requestArray['selectedAccomodationTypes'].")";
        $res   = $dbh->execute($query);
        $val   = $dbh->fetchRow($res);
        $accoTypeIds = $val->accoTypeIds;

        $queryExists  = "SELECT count(nAllotment_Id) as allotCount
                   FROM ".MYSQL_TABLE_PREFIX."allotment
                   WHERE nAat_Id IN($accoTypeIds)
                   AND vStatus = 'booked'
                   AND '".$startDate."' BETWEEN dDate AND DATE_ADD( dDate, INTERVAL nDays DAY )";

        $resExists   = $dbh->execute($queryExists);
        $valExists   = $dbh->fetchRow($resExists);

        return $valExists;
    }

    public static function deleteBlockedRooms($allotmentId) {

        $db             = new Db();
        $allotmentId    = (int) $allotmentId;

        $tempQuery     = 'DELETE FROM '.MYSQL_TABLE_PREFIX.'allotment
                          WHERE nAllotment_Id = "'.mysql_real_escape_string($allotmentId).'"';
        $delStatus     =  $db->execute($tempQuery);
    }
    
    public static function fetchCurrencyCodes() {

        $db             = new Db();
       

      
        $data = $db->selectResult('currency_master',"*","status='active'");
       
        $selBox = '<select name="currency" class="float-left">';
        foreach($data as $item) {
             if (PageContext::$response->paySettings['currency']->vLookUp_Value == $item->currency_id) $selected= "selected='selected'";
             else $selected = '';
            $selBox .= '<option value="'.$item->currency_id.'" '.$selected.'>'.$item->currency_name .' ('.$item->currency_symbol.')</option>';

        }
        $selBox .= '</select>';
        return $selBox;
       
    }
    
   
}

?>
