<?php
/*
 * Implementation of Coin Changing Algoritham 
 * - To find all possibilities of numbers that result in a particular sum
 *
 *  Used in Search (for the allocation of rooms according to availability)
 */
Class Coinchange{
    /**
   * Find all possible solutions recursively
   * $tsoln - The current solution string
   * $startIx - The start index in the denomination array.
   * $remainingTarget - The remaining target amount to be satisfied.
   * $answer - The final answer object.
   */
    private static function findAllCombinationsRecursive($tsoln, $startIx, $remainingTarget, Coinchangeanswer $answer) {
   
        for($i = $startIx; $i<count($answer->denoms) ;$i++) {
            $temp = $remainingTarget - $answer->denoms[$i];
            $tempSoln = $tsoln . "" . $answer->denoms[$i]. ",";
           
            if($temp < 0) {
                break;
            }
            if($temp == 0) {
              
                $tempSoln = substr($tempSoln,0,strlen($tempSoln)-1);
                $answer->allPossibleChanges[]= $tempSoln;// reached the answer hence quit from the loop
                break;
            }else {
                self::findAllCombinationsRecursive($tempSoln, $i, $temp, $answer);
            }
        }
    }
/*
 * $target -- The amount to be satisfied
 * $denom -- Denominations allowed(supposed to be a unique array)
 */
    public static function  findAllPossibleCombinations($target, $denom) {
        $soln = new CoinChangeAnswer();
        $soln->target =  $target;
        $soln->denoms = $denom;
	self::findAllCombinationsRecursive($tempSoln, 0, $target, $soln);
        return $soln->allPossibleChanges;
	
    }
}
 Class Coinchangeanswer {
	/**
	 * List of all possible solutions for the target
	 */
	public  $allPossibleChanges = array() ;

	/**
	 * The target amount.
	 */
	public  $target;

	/**
	 * Copy of the denominations that was used to generate this solution
	 */
	public  $denoms ;
}


?>