<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | This page is for user section management. Login checking , new user registration, user listing etc.                                      |
// | File name : index.php                                                  |
// | PHP version >= 5.2                                                   |
// | Created On	: 	Nov 17 2011                                               |
// +----------------------------------------------------------------------+
 // +----------------------------------------------------------------------+
// | Copyrights Armia Systems ? 2010                                      |
// | All rights reserved                                                  |
// +------------------------------------------------------


class ControllerIndex extends BaseController
{
	/*
		construction function. we can initialize the models here
	*/
     public function init(){
        parent::init();
      
        PageContext::addScript("login.js");
 
		$this->_common	 		= new ModelCommon();
                $this->_session         = new LibSession();
                 
     }

    /*
    function to load the index template
    */
    public function index()
    {
       
		
    }
    
    /* Function to load static content*/
    public function staticcontent($section){ 
        
        PageContext::registerPostAction("center-main", "staticcontent","index","default");
        $staticSection = Home::fetchStaticContent($section);

        // Meta Data
        Utils::getMetaContents($section);
        
        PageContext::$response->staticPageTitle = $staticSection->vLocation;
        PageContext::$response->staticPageContent = $staticSection->vContent;
     
       
    }

    
    
    
    /*
     * error handling
     */
    
    public function error()
    {
    	PageContext::registerPostAction("center-main", "error","index","default");
  
    	PageContext::$response->staticPageTitle = 'Error';
        PageContext::$response->staticPageContent = 'Some unexpected error occured.';
 
    }
    
    
    
    
    /* Function to load News */
     public function news($section){

        // Meta Data
        Utils::getMetaContents('news');
        PageContext::registerPostAction("center-main", "news","index","default");
        PageContext::$response->news = Home::fetchNews();
    }
    
    public function headerpanel(){
    	
    }
    
    public function footerpanel(){
    	
    }

    /*Post Action*/

       
     public function popup(){ 

         PageContext::addScript('rating.js');
         PageContext::addJsVar("IMAGE_URL",IMAGE_MAIN_URL);


         PageContext::$response->loginStatus = true;

         if(Customer::customerLoginCheck()== false)
         {
                 PageContext::$response->loginStatus = false;
         }
 


     }


     public function customPopup($locationId=0)
     {

         PageContext::$full_layout_rendering = false;
         $this->view->disableLayout();
         PageContext::addScript('rating.js');
         PageContext::addJsVar("IMAGE_URL",IMAGE_MAIN_URL);
         
         PageContext::$response->loginStatus = true;

         if(Customer::customerLoginCheck()==false)
         {
                 PageContext::$response->loginStatus = false;
         }
         else
         {
             $customerDetails                                     = json_decode($this->_session->get('customer'));
             
             if($customerDetails->nCust_Id>0)
             {
                  $tempRatingStatus                               = Customer::hasRated($locationId,'location',$customerDetails->nCust_Id);
                  PageContext::$response->customerRatingDetails   = $tempRatingStatus;
             }

              
         }        



     }

     
     /*
      * feed generator
      */

     public function feed()
     { 
         
        $feeds 		= Utils::getFeedData();
        $outPut .= Utils::feedGenerator($feeds);
        header ("Content-Type: text/xml;charset=UTF-8"); 
        echo $outPut;
        exit();
     }


     public function hackForPIE()
     {
         print file_get_contents('PIE.htc');
         exit();

     }



    /* public function insertRatings()
     {





         $array = array(

                        'customerId' => '' ,
                        'locationId' => '',
                        'marks'      => '',
                        'feedbackTitle' => '',
                        'feedbackDescription' => '',
                        'data'  => '',



                       );


     } */

     //Funntion to load state based on country [ajax]
    public function ajaxLoadState() {

        $countryCode = PageContext::$request['country_code'];
        $states    = Utils::getStatesByCountry($countryCode);  //echopre1(count($states));
        if(count($states)>0) {
            $stateStr = '<select class="JQ_country" name="txtState" id="txtState" validate="required:true" class="{required:true}">';
            foreach($states as $state) {
                $stateStr .= '<option value="'.$state->ts_code.'">'.$state->ts_name.'</option>';
            }
            $stateStr .='</select>';
        }else {
            $stateStr ='<input name="txtState" id="txtState" validate="required:true"  placeholder="State"  type="text"  value="" class="{required:true}" >';
        }
        echo $stateStr;
        exit;

    }
    
     
   
    

}

?>