<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | This page is for user section management. Login checking , new user registration, user listing etc.                                      |
// | File name : index.php                                                  |
// | PHP version >= 5.2                                                   |
// | Created On	: 	Nov 17 2011                                               |
// +----------------------------------------------------------------------+
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems ? 2010                                      |
// | All rights reserved                                                  |
// +------------------------------------------------------


class ControllerPayments extends BaseController {

    public function init() {
        parent::init();
        $this->_session = new LibSession();
        PageContext::$response->paypalCurrencies = array('AUD','BRL','CAD','CZK','DKK','EUR','HKD','HUF','ILS',
                                                         'JPY','MYR','MXN','NOK','NZD','PHP','PLN','GBP','RUB',
                                                         'SGD','SEK','CHF','TWD','THB','TRY','USD');
        PageContext::$response->paypalCreditCurrencies = array('AUD','CAD','CZK','DKK','EUR','HKD','HUF','JPY',
                                                               'NOK','NZD','PLN','GBP','SGD','SEK','CHF','USD');
    }

    /*
  * Sample function for booking payment using the payment gateway Authorize.net.
    */
    public function makePayment() {

        if(PageContext::$request['paymentGateway'] == 'authorize.net') {

            $customerDetails                  = json_decode($this->_session->get('customer'));
            $objSession                       = new LibSession();
            $tempLastBookingDetails           = json_decode($objSession->get('last_booking_details'));


            $authorizePaymentDetails =  array(

                    'desc' 	=> 'Payment for location reservation',
                    'amount' 	=> PageContext::$request['amount'],
                    'expMonth'     => PageContext::$request['expMonth'],
                    'expYear' 	=> PageContext::$request['expYear'],
                    'cvv' 	        => PageContext::$request['cvv'],
                    'ccno' 	=> PageContext::$request['ccno'],
                    'fName' 	=> PageContext::$request['firstName'],
                    'lName' 	=> PageContext::$request['lastName'],
                    'add1' 	=> PageContext::$request['address'],
                    'city' 	=> PageContext::$request['city'],
                    'state' 	=> PageContext::$request['state'],
                    'country' 	=> PageContext::$request['country'],
                    'zip'   	=> PageContext::$request['zip']

            );

            if($tempLastBookingDetails->apiType == 'Expedia')  // Payment for expedia hotels via authorize.net.
            {


                // hotel booking parameters
                $bookingInfo                            = array();
                $bookingInfo['hotelId'] 		= $tempLastBookingDetails->locationId;
                $bookingInfo['arrivalDate'] 	        = $tempLastBookingDetails->arrivalDate;
                $bookingInfo['departureDate'] 	        = $tempLastBookingDetails->departureDate;
                $bookingInfo['room1'] 			= $tempLastBookingDetails->numberOfRooms;
                $bookingInfo['smoking'] 		= 'NS';	// No Smoking rooms
                $bookingInfo['bedTypeID'] 		= '';
                $bookingInfo['chargeableRate'] 	        = PageContext::$request['amount'];
                $bookingInfo['Adults'] 			= '';
                $bookingInfo['Children'] 		= '';
                $bookingInfo['firstName'] 		= PageContext::$request['firstName'];
                $bookingInfo['lastName'] 		= PageContext::$request['lastName'];
                $bookingInfo['eMail'] 			= $customerDetails->vEmail;
                $bookingInfo['address1'] 		= PageContext::$request['address'];
                $bookingInfo['city'] 			= PageContext::$request['city'];
                $bookingInfo['state'] 			= PageContext::$request['state'];
                $bookingInfo['countryCode'] 	        = PageContext::$request['country'];
                $bookingInfo['postCode'] 		= PageContext::$request['zip'];
                $bookingInfo['homePhone'] 		= $customerDetails->vMobile;
                //$bookingInfo['workPhone'] 		= $customerDetails->vTelephone;


                // user card details
                $bookingInfo['ccType'] 			= 'CA';
                $bookingInfo['ccNumber'] 		= PageContext::$request['ccno'];
                $bookingInfo['expiryMonth'] 	        = PageContext::$request['expMonth'];
                $bookingInfo['expiryYear'] 		= PageContext::$request['expYear'];
                $bookingInfo['ccIdentifier'] 	        = PageContext::$request['cvv'];


                $bookingInfo['rateKey'] 		= $tempLastBookingDetails->expediaRatekey;
                $bookingInfo['roomType'] 		= $tempLastBookingDetails->expediaRoomtype;
                $bookingInfo['rateCode'] 		= $tempLastBookingDetails->expediaRatecode;

                $status                                 = Apisearch::doExpediapayment($bookingInfo);


            }
            else

                $status = Payments::authorize($authorizePaymentDetails);


            $transactionId                        = $status['TransactionId'];

            if($status['success'] == 1) {

                // Order updation and invoice mailing section.

                $tempLastBookingDetails         = json_decode($this->_session->get('last_booking_details'));
                $customerDetails                = json_decode($this->_session->get('customer'));
                $customerId                     = $customerDetails->nCust_Id;

                $accomadationType               = $tempLastBookingDetails->accomadationType;
                $accomadationAvailabilityId     = $tempLastBookingDetails->accomadationAvailabilityId;
                $numberOfAdults                 = $tempLastBookingDetails->numberOfPeople;
                //$numberOfChildren               = ''; // dont know why it is assigned null (re-assigned with the real value)
                $numberOfChildren               = $tempLastBookingDetails->numberOfChildren;

                $arrivalDate                    = Utils::dateFormat($tempLastBookingDetails->arrivalDate,'m-d-Y','Y-m-d');
                $departureDate                  = Utils::dateFormat($tempLastBookingDetails->departureDate,'m-d-Y','Y-m-d');
                $extraAmount                    = $tempLastBookingDetails->extraPrice;
                $numberOfRooms                  = $tempLastBookingDetails->numberOfRooms;

                $amountToPay                    = Apputils::fetchSettings('ReserveModeAmount');

                $bookingPaymentMode          = Apputils::fetchSettings('ReservePayMode'); // Per => percentage of booking amount else a fixed amount from booking amount
                $reservationModeAmount       = $amountToPay;

                if($reservationModeAmount>0) {

                    if($bookingPaymentMode == DB_BOOKING_PAYMENT_MODE_AMOUNT_TEXT)
                        $amountToPayForBooking  = $reservationModeAmount;

                    else
                        $amountToPayForBooking = ($extraAmount * $reservationModeAmount / 100);
                }
                else  // When site is in offline payment mode...
                    $amountToPayForBooking = LOCATION_NO_AMOUNT_TO_PAY_FOR_BOOKING;


                if($tempLastBookingDetails->apiType == 'Expedia') {
                    $amountToPayForBooking = $extraAmount;
                }




                $lastBookingId = Booking::recordOrder($customerId,$accomadationType,$accomadationAvailabilityId,$numberOfAdults,$numberOfChildren,$arrivalDate,$departureDate,$extraAmount,$tempLastBookingDetails->siteBookingMode,$amountToPayForBooking,'Authorize.net',$numberOfRooms);

                if($lastBookingId>0) {

                    Booking::updateBookingStatus($lastBookingId,$transactionId);
                    Booking::updateRefferalStatus($lastBookingId,$extraAmount);

                    $customerDetails                             = json_decode($this->_session->get('customer'));
                    $tempLastBookingDetails                      = json_decode($this->_session->get('last_booking_details'));

                    $bookingDetails                              = array();

                    $bookingDetails['arrivalDate']               = Utils::dateFormat($tempLastBookingDetails->arrivalDate,'m-d-Y','m/d/Y');
                    $bookingDetails['departureDate']             = Utils::dateFormat($tempLastBookingDetails->departureDate,'m-d-Y','m/d/Y');
                    $bookingDetails['nAdults']                   = $tempLastBookingDetails->numberOfPeople;
                    $bookingDetails['numberOfChildren']          = $tempLastBookingDetails->numberOfChildren;
                    $bookingDetails['amountToPayForBooking']     = $tempLastBookingDetails->amountToPayForBooking;
                    $bookingDetails['groupDiscountPrice']        = $tempLastBookingDetails->groupDiscountPrice;
                    $bookingDetails['specialOfferPrice']         = $tempLastBookingDetails->specialOfferPrice;
                    $bookingDetails['siteBookingMode']           = $tempLastBookingDetails->siteBookingMode;
                    $bookingDetails['accomadationType']          = $tempLastBookingDetails->accomadationType;
                    $bookingDetails['numberOfRooms']             = $tempLastBookingDetails->numberOfRooms;

                    $bookingDetails['firstName']                 = $customerDetails->vFirstname;
                    $bookingDetails['lastName']                  = $customerDetails->vLastname;

                    $customerDetails                             = Booking::getCustomerDetails($lastBookingId);
                    $bookingDetails['name']                      = $customerDetails->vFirstname. ' '. $customerDetails->vLastname;
                    $bookingDetails['locationName']              = Booking::getLocationName($lastBookingId);
                    $bookingDetails['extraPrice']                = $tempLastBookingDetails->extraPrice;
                    $bookingDetails['destinationName']           = Booking::getDestinationName($lastBookingId);

                    $bookingDetails['address']                   = Booking::getLocationAddress($lastBookingId);



                    if($tempLastBookingDetails->apiType == 'Expedia') {
                        // Store expedia details for showing on the user order listing pages.
                        $insertedExpediaDetails = Booking::saveExpediaLocationDetails($lastBookingId,$tempLastBookingDetails);

                        $bookingDetails['locationName']             = $insertedExpediaDetails['location_name'];
                        $bookingDetails['destinationName']          = $insertedExpediaDetails['destination_name'];
                        $bookingDetails['accomadationName']         = $insertedExpediaDetails['accomadation_name'];


                    }




                    Booking::sendInvoice($customerDetails->vEmail,$bookingDetails,'User');
                    Booking::sendInvoice($customerDetails->vEmail,$bookingDetails,'Admin');

                    print $status['success'];

                }
                else
                    print 'Error';



            }
            else {
                print trim($status['Message']);
            }

            exit();
        }

    }

    public function makeCancellationPayment() {

        if(PageContext::$request['paymentGateway'] == 'authorize.net') {

            $authorizePaymentDetails =  array(

                    'desc' 	=> 'Payment for cancellation',
                    'amount' 	=> PageContext::$request['amount'],
                    'expMonth'     => PageContext::$request['expMonth'],
                    'expYear' 	=> PageContext::$request['expYear'],
                    'cvv' 	        => PageContext::$request['cvv'],
                    'ccno' 	=> PageContext::$request['ccno'],
                    'fName' 	=> PageContext::$request['firstName'],
                    'lName' 	=> PageContext::$request['lastName'],
                    'add1' 	=> PageContext::$request['address'],
                    'city' 	=> PageContext::$request['city'],
                    'state' 	=> PageContext::$request['state'],
                    'country' 	=> PageContext::$request['country'],
                    'zip'   	=> PageContext::$request['zip']

            );

            $status = Payments::authorize($authorizePaymentDetails, TRUE);
            $objSession = NEW LibSession();

            $transactionId = $status['TransactionId'];

            if($status['success'] == 1) {

                $requestArray['nBooking_Id']             = $objSession->get("cancel_booking_id");
                $requestArray['vTxn_Id']                 = $transactionId;
                $requestArray['dDate_Settled']           = date('Y-m-d H:i:s');
                $requestArray['vPayment_Type']           = DB_BOOKING_PAY_METHOD_AUTHORIZE_NET;
                $requestArray['vStatus']                 = 'Yes';
                $requestArray['vCapture']                = 'Y';
                $requestArray['vType']                   = DB_BOOKING_SITE_BOOOKING_MODE_WITH_PAYMENT_TEXT;
                $requestArray['nCancelAmt']              = $objSession->get("penalty");

                Cancel::cancelBooking($requestArray);

                // Mail send to user/admin while a user cancel a booking
                Cancel::sendCancelConfirmationMail($requestArray['nBooking_Id'], $requestArray['nCancelAmt'],'User');
                Cancel::sendCancelConfirmationMail($requestArray['nBooking_Id'], $requestArray['nCancelAmt'],'Admin');

                print $status['success'];

            }
            else
                print 'Error';



        }
        else {
            print trim($status['Message']);
        }

        exit();
    }



    public function loadPaypalInterface() {
        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();
    }


    public function loadworldpayinterface() {
        $objSession                        = new LibSession();
        $customerDetails                   = json_decode($objSession->get('customer'));
        $tempLastBookingDetails            = json_decode($objSession->get('last_booking_details'));

        $arrWorldPay = array();

        $worldPayTestMode                  = Apputils::fetchSettings('worldpaydemo');
        $worldPayInstallationId            = Apputils::fetchSettings('worldpayid');


        //$arrWorldPay['instId']   	      = '211616';

        $arrWorldPay['instId']   	      = $worldPayInstallationId;




        // installation Id . Your WorldPay Installation ID.
        //  If you are not sure what this is. Login into the WorldPay Administration Server.
        //  You can find the Installation ID in the lower right hand corner of the screen.

        $arrWorldPay['cartId']   	= ''. SITENAME;  // Merchant's reference.
        $arrWorldPay['currency']   	= DEFAULT_CURRENCY_CODE;

        $arrWorldPay['name']   	= $customerDetails->vFirstname.' '.$customerDetails->vLastname;
        $arrWorldPay['address']   	= $customerDetails->vAddress1;
        $arrWorldPay['email']   	= $customerDetails->vEmail;
        $arrWorldPay['postcode']   	= $customerDetails->vZip;
        $arrWorldPay['country']  	= $customerDetails->vCountry;
        $arrWorldPay['fax']   	= $customerDetails->vFax;
        $arrWorldPay['tel']   	= $customerDetails->vTelephone;
        $arrWorldPay['amount']   	= $tempLastBookingDetails->amountToPayForBooking;
        $arrWorldPay['desc']   	= 'Payment for booking';


        if(strtoupper($worldPayTestMode) == 'Y' || strtoupper($worldPayTestMode) == 'YES')
            $arrWorldPay['testMode']   	= '100';
        else
            $arrWorldPay['testMode']   	= '0';

        // 0 => live (Sets the service Live. All transactions will be sent to bank for the standard authorisation process with resultant funds transfers if successful.)
        // 100 or 101 =>Sets the service to Test Mode.
//  The result will depend upon the value specified in the shopper name field in the Payment Page. But funds will NOT be transferred, regardless of the result.

        $arrWorldPay['MC_ORDERID']   = 'ORD12'; // booking id
        //$arrWorldPay['authMode']   	= '123';
        $arrWorldPay['authMode']   	= '123';  //The values are "A" for a full auth, or "E" for a pre-auth.

        $arrWorldPay['MC_callback']  = 'http://clients.iscripts.com/testspace/ipncall.php';

        //$arrWorldPay['MC_callback']  = BASE_URL."payments/worldPayIpnCall";

        $arrPayment['fields'] 	= $arrWorldPay;
        $worldpayserver		= "https://secure-test.worldpay.com/wcc/purchase";
        $arrPayment['payurl'] 	= $worldpayserver;
        echo $resPayment 		= Payments::doworldpay($arrPayment);

        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();
    }



    public function loadGooleCheckoutInterface() {
        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();
    }

    public function loadAuthorizeInterface() {

        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();

        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();

        $currentYear  = (int) date('Y');
        $yearArray    = array();

        PageContext::$response->monthArray   = array('01'=>"January", '02'=>"February", '03'=>"March", '04'=>"April", '05'=>"May", '06'=>"June", '07'=>"July", '08'=>"August", '09'=>"September", '10'=>"October", '11'=>"November", '12'=>"December");
        $currentYear = $currentYear-1;

        for($i=0; $i<10; $i++) {
            $yearArray[] = $currentYear = $currentYear+1;
        }

        PageContext::$response->yearArray = $yearArray;
    }



    public function loadYourpayInterface() {
        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();

        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();

        $currentYear  = (int) date('Y');
        $yearArray    = array();

        PageContext::$response->monthArray   = array('01'=>"January", '02'=>"February", '03'=>"March", '04'=>"April", '05'=>"May", '06'=>"June", '07'=>"July", '08'=>"August", '09'=>"September", '10'=>"October", '11'=>"November", '12'=>"December");
        $currentYear = $currentYear-1;

        for($i=0; $i<10; $i++) {
            $yearArray[] = $currentYear = $currentYear+1;
        }

        PageContext::$response->yearArray = $yearArray;
    }


    public function yourpay($module = 'booking') {

        // user information

        $objSession = new LibSession();
        $userInfo               = array();
        $userInfo['fName']      = PageContext::$request['firstName'];
        $userInfo['lName']      = PageContext::$request['lastName'];
        $userInfo['add1']       = PageContext::$request['address'];
        $userInfo['city']       = PageContext::$request['city'];
        $userInfo['state']      = PageContext::$request['state'];
        $userInfo['country']    = PageContext::$request['country'];
        $userInfo['company']    = '';
        $userInfo['zip']        = PageContext::$request['zip'];
        $userInfo['phone']      = '';
        $userInfo['email']      = '';
        if($module=='booking')
            $userInfo['amount']     = PageContext::$request['amount'];
        else
            $userInfo['amount']     = $objSession->get("cancel_penalty");

        // get the yourpay settings


        $YourPaySettings 	        = Payments::getYourPaySettings();
        $arrYourPay['yourpay_storeid'] 	= $YourPaySettings['yourpay_storeid'];
        $arrYourPay['yourpay_demo'] 	= $YourPaySettings['yourpay_demo'];
        $arrYourPay['keyfile'] 		= BASE_URL."project/lib/paymentgateways/yourpay/pem/".$YourPaySettings['yourpay_pemfile'];


        $arrYourPay['userinfo'] 		= $userInfo;

        // add card settings

        $arrYourPay['ordertype'] 		= "SALE";
        $arrYourPay['yp_cardno'] 		= PageContext::$request['ccno'];
        $arrYourPay['yp_expm'] 			= PageContext::$request['expMonth'];
        $arrYourPay['yp_expy'] 			= PageContext::$request['expYear'];
        $arrYourPay['yp_cvno'] 			= PageContext::$request['cvv'];


        $resPayment 				= Payments::doYourPay($arrYourPay);
        // $file = fopen(FILE_UPLOAD_DIR."/test.txt","w");
        // fwrite($file, print_r($resPayment,true));
        // fclose($file);
        // test result can see at http://clients.iscripts.com/testspace/yourpay/



        if($module=='booking' && $resPayment == 'SUCCESS') {
            // Order updation and invoice mailing section.

            $tempLastBookingDetails         = json_decode($this->_session->get('last_booking_details'));
            $customerDetails                = json_decode($this->_session->get('customer'));
            $customerId                     = $customerDetails->nCust_Id;

            $accomadationType               = $tempLastBookingDetails->accomadationType;
            $accomadationAvailabilityId     = $tempLastBookingDetails->accomadationAvailabilityId;
            $numberOfAdults                 = $tempLastBookingDetails->numberOfPeople;
            //$numberOfChildren               = ''; // dont know why it is assigned null (re-assigned with the real value)
            $numberOfChildren               = $tempLastBookingDetails->numberOfChildren;

            $arrivalDate                    = Utils::dateFormat($tempLastBookingDetails->arrivalDate,'m-d-Y','Y-m-d');
            $departureDate                  = Utils::dateFormat($tempLastBookingDetails->departureDate,'m-d-Y','Y-m-d');
            $extraAmount                    = $tempLastBookingDetails->extraPrice;
            $numberOfRooms                  = $tempLastBookingDetails->numberOfRooms;

            $amountToPay                    = Apputils::fetchSettings('ReserveModeAmount');
            $reserveMode                    = Apputils::fetchSettings('ReserveMode');


            $bookingPaymentMode             = Apputils::fetchSettings('ReservePayMode'); // Per => percentage of booking amount else a fixed amount from booking amount
            $reservationModeAmount          = $amountToPay;

            if($reservationModeAmount>0) {
                if($bookingPaymentMode == DB_BOOKING_PAYMENT_MODE_AMOUNT_TEXT)
                    $amountToPayForBooking  = $reservationModeAmount;

                else
                    $amountToPayForBooking = ($extraAmount * $reservationModeAmount / 100);
            }
            else  // When site is in offline payment mode...
                $amountToPayForBooking = LOCATION_NO_AMOUNT_TO_PAY_FOR_BOOKING;

            $lastBookingId = Booking::recordOrder($customerId,$accomadationType,$accomadationAvailabilityId,$numberOfAdults,$numberOfChildren,$arrivalDate,$departureDate,$extraAmount,$tempLastBookingDetails->siteBookingMode,$amountToPayForBooking,'Yourpay',$numberOfRooms);

            if($lastBookingId>0) {

                Booking::updateBookingStatus($lastBookingId,$transactionId);
                Booking::updateRefferalStatus($lastBookingId,$extraAmount);

                $customerDetails                             = json_decode($this->_session->get('customer'));
                $tempLastBookingDetails                      = json_decode($this->_session->get('last_booking_details'));

                $bookingDetails                              = array();

                $bookingDetails['arrivalDate']               = Utils::dateFormat($tempLastBookingDetails->arrivalDate,'m-d-Y','m/d/Y');
                $bookingDetails['departureDate']             = Utils::dateFormat($tempLastBookingDetails->departureDate,'m-d-Y','m/d/Y');
                $bookingDetails['nAdults']                   = $tempLastBookingDetails->numberOfPeople;
                $bookingDetails['numberOfChildren']          = $tempLastBookingDetails->numberOfChildren;
                $bookingDetails['amountToPayForBooking']     = $tempLastBookingDetails->amountToPayForBooking;
                $bookingDetails['groupDiscountPrice']        = $tempLastBookingDetails->groupDiscountPrice;
                $bookingDetails['specialOfferPrice']         = $tempLastBookingDetails->specialOfferPrice;
                $bookingDetails['siteBookingMode']           = $tempLastBookingDetails->siteBookingMode;
                $bookingDetails['accomadationType']          = $tempLastBookingDetails->accomadationType;
                $bookingDetails['numberOfRooms']             = $tempLastBookingDetails->numberOfRooms;

                $customerDetails                             = Booking::getCustomerDetails($lastBookingId);
                $bookingDetails['name']                      = $customerDetails->vFirstname. ' '. $customerDetails->vLastname;
                $bookingDetails['locationName']              = Booking::getLocationName($lastBookingId);
                $bookingDetails['extraPrice']                = $tempLastBookingDetails->extraPrice;
                $bookingDetails['destinationName']           = Booking::getDestinationName($lastBookingId);


                $bookingDetails['firstName']                 = $customerDetails->vFirstname;
                $bookingDetails['lastName']                  = $customerDetails->vLastname;


                $bookingDetails['address']                   = Booking::getLocationAddress($lastBookingId);

                Booking::sendInvoice($customerDetails->vEmail,$bookingDetails,'User');
                Booking::sendInvoice($customerDetails->vEmail,$bookingDetails,'Admin');

                print 1;

            }
            else
                print 'Error';




        }else if($module=='cancel' && $resPayment == 'SUCCESS') {
            $requestArray['vTxn_Id'] = $transactionId;
            $requestArray['dDate_Settled'] =  date('Y-m-d H:i:s');
            $requestArray['vPayment_Type'] =  DB_BOOKING_PAY_METHOD_YOUR_PAY;
            $requestArray['vStatus'] =  'Yes';
            $requestArray['vCapture'] =  'Y';
            $requestArray['vType'] =  DB_BOOKING_SITE_BOOOKING_MODE_WITH_PAYMENT_TEXT;
            $requestArray['nCancelAmt'] =  $objSession->get("cancel_penalty");
            $requestArray['nBooking_Id'] = $objSession->get("cancel_booking_id");

            Cancel::cancelBooking($requestArray);

            // Mail send to user/admin/property owner while a user cancel a booking
            Cancel::sendCancelConfirmationMail($requestArray['nBooking_Id'], $requestArray['nCancelAmt'],'User');
            Cancel::sendCancelConfirmationMail($requestArray['nBooking_Id'], $requestArray['nCancelAmt'],'Admin');
            
        }
        else
            print_r($resPayment);

        exit();
    }
    
     public function loadPaypalproInterface() {
        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();

        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();

        $currentYear  = (int) date('Y');
        $yearArray    = array();

        PageContext::$response->monthArray   = array('01'=>"January", '02'=>"February", '03'=>"March", '04'=>"April", '05'=>"May", '06'=>"June", '07'=>"July", '08'=>"August", '09'=>"September", '10'=>"October", '11'=>"November", '12'=>"December");
        $currentYear = $currentYear-1;

        for($i=0; $i<10; $i++) {
            $yearArray[] = $currentYear = $currentYear+1;
        }

        PageContext::$response->yearArray = $yearArray;
    }
    public function loadBluepayInterface() {
        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();

        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();

        $currentYear  = (int) date('Y');
        $yearArray    = array();

        PageContext::$response->monthArray   = array('01'=>"January", '02'=>"February", '03'=>"March", '04'=>"April", '05'=>"May", '06'=>"June", '07'=>"July", '08'=>"August", '09'=>"September", '10'=>"October", '11'=>"November", '12'=>"December");
        $currentYear = $currentYear-1;

        for($i=0; $i<10; $i++) {
            $yearArray[] = $currentYear = $currentYear+1;
        }

        PageContext::$response->yearArray = $yearArray;
    }
     public function paypalpro($module = 'booking') {

       // user information
         
        $objSession = new LibSession();
        $userInfo               = array();
        $userInfo['fName']      = PageContext::$request['firstName'];
        $userInfo['lName']      = PageContext::$request['lastName'];
        $userInfo['add1']       = PageContext::$request['address'];
        $userInfo['city']       = PageContext::$request['city'];
        $userInfo['state']      = PageContext::$request['state'];
        $userInfo['country']    = PageContext::$request['country'];
        $userInfo['company']    = '';
        $userInfo['zip']        = PageContext::$request['zip'];
        $userInfo['phone']      = '';
        $userInfo['email']      = '';
        if($module=='booking')
            $userInfo['amount']     = PageContext::$request['amount'];
        else
            $userInfo['amount']     = $objSession->get("cancel_penalty");

        // get the paypal pro settings

        $PaypalproSettings 	        = Payments::getPaypalproSettings();
        $arrPaypalPro['API_UserName'] 	= $PaypalproSettings['username'];
        $arrPaypalPro['API_Password'] 	= $PaypalproSettings['password'];
        $arrPaypalPro['API_Signature']    = $PaypalproSettings['signature'];
        $arrPaypalPro['testMode']         = $PaypalproSettings['testMode'];
       
        $arrPaypalPro['userinfo'] 		= $userInfo;

        // add card settings

        $arrPaypalPro['ordertype'] 		= "SALE";
        $arrPaypalPro['pp_cardno'] 		= PageContext::$request['ccno'];
        $arrPaypalPro['pp_expm'] 			= PageContext::$request['expMonth'];
        $arrPaypalPro['pp_expy'] 			= PageContext::$request['expYear'];
        $arrPaypalPro['pp_cvno'] 			= PageContext::$request['cvv'];
        //$arrPaypalPro['amount'] 			= PageContext::$request['amount'];
        $arrPaypalPro['card_type'] 			= PageContext::$request['cardType'];


        $resPayment 				= Payments::doPaypalpro($arrPaypalPro);
            // Specify payment action eg: Sales

           if(count($resPayment) > 0) {
               //die('success');
                if($paymnetResult['ACK'] == 'Success' && $paymnetResult['AMT'] == $gtotal) {
                }
                }
                else{
                    //die('error');
                }

               
        
        if($module=='booking' && $resPayment['ACK'] == 'Success') {
            // Order updation and invoice mailing section.
            $transactionId = $resPayment['TRANSACTIONID'];
            $tempLastBookingDetails         = json_decode($this->_session->get('last_booking_details'));
            $customerDetails                = json_decode($this->_session->get('customer'));
            $customerId                     = $customerDetails->nCust_Id;

            $accomadationType               = $tempLastBookingDetails->accomadationType;
            $accomadationAvailabilityId     = $tempLastBookingDetails->accomadationAvailabilityId;
            $numberOfAdults                 = $tempLastBookingDetails->numberOfPeople;
            //$numberOfChildren               = ''; // dont know why it is assigned null (re-assigned with the real value)
            $numberOfChildren               = $tempLastBookingDetails->numberOfChildren;

            $arrivalDate                    = Utils::dateFormat($tempLastBookingDetails->arrivalDate,'m-d-Y','Y-m-d');
            $departureDate                  = Utils::dateFormat($tempLastBookingDetails->departureDate,'m-d-Y','Y-m-d');
            $extraAmount                    = $tempLastBookingDetails->extraPrice;
            $numberOfRooms                  = $tempLastBookingDetails->numberOfRooms;

            $amountToPay                    = Apputils::fetchSettings('ReserveModeAmount');
            $reserveMode                    = Apputils::fetchSettings('ReserveMode');


            $bookingPaymentMode             = Apputils::fetchSettings('ReservePayMode'); // Per => percentage of booking amount else a fixed amount from booking amount
            $reservationModeAmount          = $amountToPay;

            if($reservationModeAmount>0) {
                if($bookingPaymentMode == DB_BOOKING_PAYMENT_MODE_AMOUNT_TEXT)
                    $amountToPayForBooking  = $reservationModeAmount;

                else
                    $amountToPayForBooking = ($extraAmount * $reservationModeAmount / 100);
            }
            else  // When site is in offline payment mode...
                $amountToPayForBooking = LOCATION_NO_AMOUNT_TO_PAY_FOR_BOOKING;

            $lastBookingId = Booking::recordOrder($customerId,$accomadationType,$accomadationAvailabilityId,$numberOfAdults,$numberOfChildren,$arrivalDate,$departureDate,$extraAmount,$tempLastBookingDetails->siteBookingMode,$amountToPayForBooking,'paypalpro',$numberOfRooms);

            if($lastBookingId>0) {

                Booking::updateBookingStatus($lastBookingId,$transactionId);
                Booking::updateRefferalStatus($lastBookingId,$extraAmount);

                $customerDetails                             = json_decode($this->_session->get('customer'));
                $tempLastBookingDetails                      = json_decode($this->_session->get('last_booking_details'));

                $bookingDetails                              = array();

                $bookingDetails['arrivalDate']               = Utils::dateFormat($tempLastBookingDetails->arrivalDate,'m-d-Y','m/d/Y');
                $bookingDetails['departureDate']             = Utils::dateFormat($tempLastBookingDetails->departureDate,'m-d-Y','m/d/Y');
                $bookingDetails['nAdults']                   = $tempLastBookingDetails->numberOfPeople;
                $bookingDetails['numberOfChildren']          = $tempLastBookingDetails->numberOfChildren;
                $bookingDetails['amountToPayForBooking']     = $tempLastBookingDetails->amountToPayForBooking;
                $bookingDetails['groupDiscountPrice']        = $tempLastBookingDetails->groupDiscountPrice;
                $bookingDetails['specialOfferPrice']         = $tempLastBookingDetails->specialOfferPrice;
                $bookingDetails['siteBookingMode']           = $tempLastBookingDetails->siteBookingMode;
                $bookingDetails['accomadationType']          = $tempLastBookingDetails->accomadationType;
                $bookingDetails['numberOfRooms']             = $tempLastBookingDetails->numberOfRooms;

                $customerDetails                             = Booking::getCustomerDetails($lastBookingId);
                $bookingDetails['name']                      = $customerDetails->vFirstname. ' '. $customerDetails->vLastname;
                $bookingDetails['locationName']              = Booking::getLocationName($lastBookingId);
                $bookingDetails['extraPrice']                = $tempLastBookingDetails->extraPrice;
                $bookingDetails['destinationName']           = Booking::getDestinationName($lastBookingId);


                $bookingDetails['firstName']                 = $customerDetails->vFirstname;
                $bookingDetails['lastName']                  = $customerDetails->vLastname;


                $bookingDetails['address']                   = Booking::getLocationAddress($lastBookingId);

                Booking::sendInvoice($customerDetails->vEmail,$bookingDetails,'User');
                Booking::sendInvoice($customerDetails->vEmail,$bookingDetails,'Admin');

                print 1;

            }
            else
                print 'Error';




        }else if($module=='cancel' && $resPayment['ACK'] == 'Success') {
            $requestArray['vTxn_Id'] =  $resPayment['TRANSACTIONID'];
            $requestArray['dDate_Settled'] =  date('Y-m-d H:i:s');
            $requestArray['vPayment_Type'] =  DB_BOOKING_PAY_METHOD_YOUR_PAY;
            $requestArray['vStatus'] =  'Yes';
            $requestArray['vCapture'] =  'Y';
            $requestArray['vType'] =  DB_BOOKING_SITE_BOOOKING_MODE_WITH_PAYMENT_TEXT;
            $requestArray['nCancelAmt'] =  $objSession->get("cancel_penalty");
            $requestArray['nBooking_Id'] = $objSession->get("cancel_booking_id");

            Cancel::cancelBooking($requestArray);

            // Mail send to user/admin/property owner while a user cancel a booking
            Cancel::sendCancelConfirmationMail($requestArray['nBooking_Id'], $requestArray['nCancelAmt'],'User');
            Cancel::sendCancelConfirmationMail($requestArray['nBooking_Id'], $requestArray['nCancelAmt'],'Admin');
            
        }
        else
            print_r($resPayment);

        exit();
    }



     public function bluepay($module = 'booking') {

       // user information
         
        $objSession = new LibSession();
        $userInfo               = array();
        $userInfo['fName']      = PageContext::$request['firstName'];
        $userInfo['lName']      = PageContext::$request['lastName'];
        $userInfo['add1']       = PageContext::$request['address'];
        $userInfo['city']       = PageContext::$request['city'];
        $userInfo['state']      = PageContext::$request['state'];
        $userInfo['country']    = PageContext::$request['country'];
        $userInfo['company']    = '';
        $userInfo['zip']        = PageContext::$request['zip'];
        $userInfo['phone']      = '';
        $userInfo['email']      = '';
        if($module=='booking')
            $userInfo['amount']     = PageContext::$request['amount'];
        else
            $userInfo['amount']     = $objSession->get("cancel_penalty");

        // get the paypal pro settings

        $BluepaySettings 	        = Payments::getBluepaySettings();
        $arrBluePay['payid']            = $BluepaySettings['payid'];
        $arrBluePay['secretkey'] 	= $BluepaySettings['secretkey'];
        $arrBluePay['demo']             = $BluepaySettings['demo'];
        
       
        $arrBluePay['userinfo'] 		= $userInfo;

        // add card settings

        $arrBluePay['ordertype'] 		= "SALE";
        $arrBluePay['bp_cardno'] 		= PageContext::$request['ccno'];
        $arrBluePay['bp_expm'] 			= PageContext::$request['expMonth'];
        $arrBluePay['bp_expy'] 			= PageContext::$request['expYear'];
        $arrBluePay['bp_cvno'] 			= PageContext::$request['cvv'];
        //$arrBluePay['amount'] 			= PageContext::$request['amount'];
        $arrBluePay['card_type'] 		= PageContext::$request['cardType'];


        $resPayment 				= Payments::dobluepay($arrBluePay);
            // Specify payment action eg: Sales

           if(count($resPayment) > 0) {
               //die('success');
                if($paymnetResult['ACK'] == 'Success' && $paymnetResult['AMT'] == $gtotal) {
                }
                }
                else{
                    //die('error');
                }


       
        if($module=='booking' && $resPayment['TRANS_ID']) {
            // Order updation and invoice mailing section.
            if ($resPayment['MODE'] == 'TEST' && ($resPayment['AMOUNT']%2)== 0)
                 print 'Error';
            else 
            {
            $transactionId = $resPayment['TRANS_ID'];
            $tempLastBookingDetails         = json_decode($this->_session->get('last_booking_details'));
            $customerDetails                = json_decode($this->_session->get('customer'));
            $customerId                     = $customerDetails->nCust_Id;

            $accomadationType               = $tempLastBookingDetails->accomadationType;
            $accomadationAvailabilityId     = $tempLastBookingDetails->accomadationAvailabilityId;
            $numberOfAdults                 = $tempLastBookingDetails->numberOfPeople;
            //$numberOfChildren               = ''; // dont know why it is assigned null (re-assigned with the real value)
            $numberOfChildren               = $tempLastBookingDetails->numberOfChildren;

            $arrivalDate                    = Utils::dateFormat($tempLastBookingDetails->arrivalDate,'m-d-Y','Y-m-d');
            $departureDate                  = Utils::dateFormat($tempLastBookingDetails->departureDate,'m-d-Y','Y-m-d');
            $extraAmount                    = $tempLastBookingDetails->extraPrice;
            $numberOfRooms                  = $tempLastBookingDetails->numberOfRooms;

            $amountToPay                    = Apputils::fetchSettings('ReserveModeAmount');
            $reserveMode                    = Apputils::fetchSettings('ReserveMode');


            $bookingPaymentMode             = Apputils::fetchSettings('ReservePayMode'); // Per => percentage of booking amount else a fixed amount from booking amount
            $reservationModeAmount          = $amountToPay;

            if($reservationModeAmount>0) {
                if($bookingPaymentMode == DB_BOOKING_PAYMENT_MODE_AMOUNT_TEXT)
                    $amountToPayForBooking  = $reservationModeAmount;

                else
                    $amountToPayForBooking = ($extraAmount * $reservationModeAmount / 100);
            }
            else  // When site is in offline payment mode...
                $amountToPayForBooking = LOCATION_NO_AMOUNT_TO_PAY_FOR_BOOKING;

            $lastBookingId = Booking::recordOrder($customerId,$accomadationType,$accomadationAvailabilityId,$numberOfAdults,$numberOfChildren,$arrivalDate,$departureDate,$extraAmount,$tempLastBookingDetails->siteBookingMode,$amountToPayForBooking,'bluepay',$numberOfRooms);

            if($lastBookingId>0) {

                Booking::updateBookingStatus($lastBookingId,$transactionId);
                Booking::updateRefferalStatus($lastBookingId,$extraAmount);

                $customerDetails                             = json_decode($this->_session->get('customer'));
                $tempLastBookingDetails                      = json_decode($this->_session->get('last_booking_details'));

                $bookingDetails                              = array();

                $bookingDetails['arrivalDate']               = Utils::dateFormat($tempLastBookingDetails->arrivalDate,'m-d-Y','m/d/Y');
                $bookingDetails['departureDate']             = Utils::dateFormat($tempLastBookingDetails->departureDate,'m-d-Y','m/d/Y');
                $bookingDetails['nAdults']                   = $tempLastBookingDetails->numberOfPeople;
                $bookingDetails['numberOfChildren']          = $tempLastBookingDetails->numberOfChildren;
                $bookingDetails['amountToPayForBooking']     = $tempLastBookingDetails->amountToPayForBooking;
                $bookingDetails['groupDiscountPrice']        = $tempLastBookingDetails->groupDiscountPrice;
                $bookingDetails['specialOfferPrice']         = $tempLastBookingDetails->specialOfferPrice;
                $bookingDetails['siteBookingMode']           = $tempLastBookingDetails->siteBookingMode;
                $bookingDetails['accomadationType']          = $tempLastBookingDetails->accomadationType;
                $bookingDetails['numberOfRooms']             = $tempLastBookingDetails->numberOfRooms;

                $customerDetails                             = Booking::getCustomerDetails($lastBookingId);
                $bookingDetails['name']                      = $customerDetails->vFirstname. ' '. $customerDetails->vLastname;
                $bookingDetails['locationName']              = Booking::getLocationName($lastBookingId);
                $bookingDetails['extraPrice']                = $tempLastBookingDetails->extraPrice;
                $bookingDetails['destinationName']           = Booking::getDestinationName($lastBookingId);


                $bookingDetails['firstName']                 = $customerDetails->vFirstname;
                $bookingDetails['lastName']                  = $customerDetails->vLastname;


                $bookingDetails['address']                   = Booking::getLocationAddress($lastBookingId);

                Booking::sendInvoice($customerDetails->vEmail,$bookingDetails,'User');
                Booking::sendInvoice($customerDetails->vEmail,$bookingDetails,'Admin');

                print 1;

            }
                
            
            
           }      


        }else if($module=='cancel' && $resPayment['TRANS_ID']) {
            if ($resPayment['MODE'] == 'TEST' && ($resPayment['AMOUNT']%2)== 0)
                 print 'Error';
            else 
            {
            $requestArray['vTxn_Id'] = $resPayment['TRANS_ID'];
            $requestArray['dDate_Settled'] =  date('Y-m-d H:i:s');
            $requestArray['vPayment_Type'] =  DB_BOOKING_PAY_METHOD_YOUR_PAY;
            $requestArray['vStatus'] =  'Yes';
            $requestArray['vCapture'] =  'Y';
            $requestArray['vType'] =  DB_BOOKING_SITE_BOOOKING_MODE_WITH_PAYMENT_TEXT;
            //$requestArray['nCancelAmt'] =  $objSession->get("cancel_penalty");
            $requestArray['nCancelAmt'] = $resPayment['AMOUNT'];
            $requestArray['nBooking_Id'] = $objSession->get("cancel_booking_id");

            Cancel::cancelBooking($requestArray);

            // Mail send to user/admin/property owner while a user cancel a booking
            Cancel::sendCancelConfirmationMail($requestArray['nBooking_Id'], $requestArray['nCancelAmt'],'User');
            Cancel::sendCancelConfirmationMail($requestArray['nBooking_Id'], $requestArray['nCancelAmt'],'Admin');
            print 1;
        }
            
 
        }
        else
            print_r($resPayment);
        
        exit();
    }
    public function loadOtherPaymentInterface() {
        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();
    }



    /*
  * function for paypal payment gateway
    */
    public function paypal($module = 'booking') {

        PageContext::addStyle('order.css',true);
        PageContext::addStyle('signup.css',true);
        PageContext::addScript('paypal_payment.js');

        $objSession                            = new LibSession();
        $paypalSettings                        = Payments::getPaypalSettings();
        $arrtwoPaySettings['Paypalemail']      = $paypalSettings['Paypalemail'];//;'mahiat_1228735154_biz@yahoo.com';
        $arrtwoPaySettings['Currency']    = DEFAULT_CURRENCY_CODE;
        if($module == 'booking') {
            $arrtwoPaySettings['notifyURL']        = BASE_URL . "payments/paypalIpnCall"; //PAYPAL_NOTIFY_URL;
            $lastBookingId                         = $objSession->get('last_booking_id');
            $tempLastBookingDetails                = json_decode($this->_session->get('last_booking_details'));
            $arrtwoPaySettings['resultURL']        = BASE_URL . "booknow/complete";
            $arrtwoPaySettings['cancelURL']        = BASE_URL . "payments/cancel";
            $arrtwoPaySettings['Itemname'] 	  = SITENAME;
            $arrtwoPaySettings['BookingId']        = $lastBookingId;
            $arrtwoPaySettings['Grandtotal']       = $tempLastBookingDetails->amountToPayForBooking;

        }else {
            $arrtwoPaySettings['notifyURL']        = BASE_URL . "payments/paypalIpnCall"; //PAYPAL_CANCEL_NOTIFY_URL;
            $arrtwoPaySettings['resultURL']        = BASE_URL . "cancel/complete";
            $arrtwoPaySettings['cancelURL']        = BASE_URL . "payments/cancel";
            $arrtwoPaySettings['Itemname']          = 'Cancel-'.$objSession->get("cancel_booking_id");
            $arrtwoPaySettings['BookingId']        = $objSession->get("cancel_booking_id");
            $arrtwoPaySettings['Grandtotal']       = $objSession->get("cancel_penalty");
            ;
        }
        if($paypalSettings['Paypaltestmode'] == "Y")
            $arrtwoPaySettings['Testmode']      = 'Y';

        $frmPayment= Payments::paypal($arrtwoPaySettings);


        PageContext::$response->paypalForm = $frmPayment;

        //Utils::echopre($frmPayment);

        PageContext::registerPostAction('center-main', 'paypal','payments');

    }


    /*
 * sample function for google checkout payement 
    */
    public function googlecheckout($module = 'booking') {


        PageContext::addStyle('order.css',true);
        PageContext::addStyle('signup.css',true);
        PageContext::addScript('google_payment.js');

        $objSession                                  = new LibSession();

        if($module == 'booking') {
            $lastBookingId                               = $objSession->get('last_booking_id');
            $tempLastBookingDetails                      = json_decode($this->_session->get('last_booking_details'));
            $arrGCheckDetails['items']['amount'] 	= $tempLastBookingDetails->amountToPayForBooking;
            //TODO: need to set the ipn call url in the merchant account of google account
            $arrGCheckDetails['url_edit_cart'] 	        = BASE_URL."payments/googlecheckout";
            $arrGCheckDetails['url_continue_shopping']   = BASE_URL."booknow/complete";
            $arrGCheckDetails['items']['item_desc']      = SITENAME.' description';
            $arrGCheckDetails['items']['item_name']      = $lastBookingId;

        }else if($module == 'cancel') {

            $arrGCheckDetails['items']['amount'] 	= $_SESSION['penalty'];
            $arrGCheckDetails['url_continue_shopping']   = BASE_URL."cancel/complete";
            $arrGCheckDetails['items']['cancelFlag'] 	        = TRUE;
            $arrGCheckDetails['items']['item_desc']      = SITENAME.'- Booking cancellation ';
            $arrGCheckDetails['items']['item_name']      = 'cancel-'.$objSession->get("cancel_booking_id");
        }

        // assign the product informations


        $arrGCheckDetails['items']['count'] 	        = 1;




        // load the payement form
        $frmpage= Payments::doGoogleCheckOut($arrGCheckDetails);

        PageContext::$response->googleCheckoutForm = $frmpage;

        //Showing the payment form

        //Utils::echopre($frmpage);
        PageContext::registerPostAction('center-main', 'googlecheckout','payments');

    }



    /*
  * function to show the payment result
    */



    public function cancel($result='') {
        echo $result;
        exit();
    }


    /*
  * function to make the IPN call
    */
    public function ipncall($paymentgateway) {
        echopre($_REQUEST);
    }

    public function paypalIpnCall() {

        $lastBookingId  = trim(PageContext::$request['custom']);

        if($lastBookingId>0 && Booking::checkForConfirmedBooking($lastBookingId)==false) {

            $tempLastBookingDetails = Booking::getBookingDetails($lastBookingId);

            $bookingDetails = array();
            $bookingDetails['arrivalDate']               = $tempLastBookingDetails->checkin_Date;
            $bookingDetails['departureDate']             = $tempLastBookingDetails->checkout_Date;
            $bookingDetails['nAdults']                   = $tempLastBookingDetails->nAdults;
            $bookingDetails['numberOfChildren']          = $tempLastBookingDetails->nChildren;
            $bookingDetails['amountToPayForBooking']     = $tempLastBookingDetails->nReserveModeAmount;
            $bookingDetails['siteBookingMode']           = Apputils::fetchSettings('ReserveMode');
            $bookingDetails['locationName']              = Booking::getLocationName($lastBookingId);

            $accomodationDetails                         =  Booking::getAccommadationDetails($lastBookingId);
            $bookingDetails['accomadationType']          = $accomodationDetails->nAt_Id;

            $customerDetails                             = Booking::getCustomerDetails($lastBookingId);

            $bookingDetails['firstName']                 = $customerDetails->vFirstname;
            $bookingDetails['lastName']                  = $customerDetails->vLastname;

            $bookingDetails['name']                      = $customerDetails->vFirstname. ' '. $customerDetails->vLastname;
            $bookingDetails['extraPrice']                = $tempLastBookingDetails->nAmount;
            $bookingDetails['destinationName']           = Booking::getDestinationName($lastBookingId);
            $bookingDetails['numberOfRooms']             = $tempLastBookingDetails->nRooms;


            Booking::updateBookingStatus($lastBookingId);
            Booking::updateRefferalStatus($lastBookingId,$tempLastBookingDetails->nAmount);

            $bookingDetails['address']                   = Booking::getLocationAddress($lastBookingId);


            Booking::sendInvoice($customerDetails->vEmail,$bookingDetails,'User');
            Booking::sendInvoice($customerDetails->vEmail,$bookingDetails,'Admin');
        }

    }

    public function paypalCancelIpnCall() {

        $bookingId  = trim(PageContext::$request['custom']);


        if($bookingId>0) {
            $requestArray['vTxn_Id'] = $_REQUEST['txn_id'];
            $requestArray['dDate_Settled'] =  date('Y-m-d H:i:s');
            $requestArray['vPayment_Type'] =  DB_BOOKING_PAY_METHOD_PAYPAL;
            $requestArray['vStatus'] =  'Yes';
            $requestArray['vCapture'] =  'Y';
            $requestArray['vType'] =  DB_BOOKING_SITE_BOOOKING_MODE_WITH_PAYMENT_TEXT;
            $requestArray['nCancelAmt'] =  1000;
            $requestArray['nBooking_Id'] = $bookingId;

            Cancel::cancelBooking($requestArray);

            // Mail send to user/admin/property owner while a user cancel a booking
            Cancel::sendCancelConfirmationMail($requestArray['nBooking_Id'], $requestArray['nCancelAmt'],'User');
            Cancel::sendCancelConfirmationMail($requestArray['nBooking_Id'], $requestArray['nCancelAmt'],'Admin');

        }

    }


    public function worldPayIpnCall() {

        /*foreach($_REQUEST as $key=>$items){
	$stringData .= $key.':'.$items.'==';
}*/
//mail('jayakrishnan.p@armiasystems.com','IPN call',$stringData);


        $lastBookingId  = trim(PageContext::$request['MC_ORDERID']);

        $transactionId = trim(PageContext::$request['transId']);

        if($lastBookingId>0 && Booking::checkForConfirmedBooking($lastBookingId)==false) {

            $tempLastBookingDetails = Booking::getBookingDetails($lastBookingId);

            $bookingDetails = array();
            $bookingDetails['arrivalDate']               = $tempLastBookingDetails->checkin_Date;
            $bookingDetails['departureDate']             = $tempLastBookingDetails->checkout_Date;
            $bookingDetails['nAdults']                   = $tempLastBookingDetails->nAdults;
            $bookingDetails['numberOfChildren']          = $tempLastBookingDetails->nChildren;
            $bookingDetails['amountToPayForBooking']     = $tempLastBookingDetails->nReserveModeAmount;
            $bookingDetails['siteBookingMode']           = Apputils::fetchSettings('ReserveMode');
            $bookingDetails['locationName']              = Booking::getLocationName($lastBookingId);

            $accomodationDetails                         =  Booking::getAccommadationDetails($lastBookingId);
            $bookingDetails['accomadationType']          = $accomodationDetails->nAt_Id;

            $customerDetails                             = Booking::getCustomerDetails($lastBookingId);

            $bookingDetails['firstName']                 = $customerDetails->vFirstname;
            $bookingDetails['lastName']                  = $customerDetails->vLastname;

            $bookingDetails['name']                      = $customerDetails->vFirstname. ' '. $customerDetails->vLastname;
            $bookingDetails['extraPrice']                = $tempLastBookingDetails->nAmount;
            $bookingDetails['destinationName']           = Booking::getDestinationName($lastBookingId);
            $bookingDetails['numberOfRooms']             = $tempLastBookingDetails->nRooms;


            Booking::updateBookingStatus($lastBookingId,$transactionId);
            Booking::updateRefferalStatus($lastBookingId,$tempLastBookingDetails->nAmount);

            $bookingDetails['address']                   = Booking::getLocationAddress($lastBookingId);


            Booking::sendInvoice($customerDetails->vEmail,$bookingDetails,'User');
            Booking::sendInvoice($customerDetails->vEmail,$bookingDetails,'Admin');
        }


        exit();

    }


//Function to be called as ipn result.this will have data as asscosciative array if resposne is set as html
    public function googleCheckoutIpnCall() {
        $responseArray = $_REQUEST;
        $file = fopen(FILE_UPLOAD_DIR."/test.txt", "w");
        fwrite($file, print_r($responseArray,true));
        fclose($file);
        $transactionId = $responseArray['txn_id'];
        //If payment is process by cancellation
        if(strpos($responseArray['shopping-cart_items_item-1_item-name'],'cancel') !== FALSE) {
            $objSession = new LibSession();
            $requestArray['vTxn_Id'] = $transactionId;
            $requestArray['dDate_Settled'] =  date('Y-m-d H:i:s');
            $requestArray['vPayment_Type'] =  DB_BOOKING_PAY_METHOD_GOOGLECHECKOUT;
            $requestArray['vStatus'] =  'Yes';
            $requestArray['vCapture'] =  'Y';
            $requestArray['vType'] =  DB_BOOKING_SITE_BOOOKING_MODE_WITH_PAYMENT_TEXT;
            $requestArray['nCancelAmt'] =  $responseArray['shopping-cart_items_item-1_unit-price'];
            $sections = explode("-",$responseArray['shopping-cart_items_item-1_item-name']);
            $requestArray['nBooking_Id'] = $sections[count($sections)-1];

            Cancel::cancelBooking($requestArray);

            // Mail send to user/admin/property owner while a user cancel a booking
            Cancel::sendCancelConfirmationMail($requestArray['nBooking_Id'], $requestArray['nCancelAmt'],'User');
            Cancel::sendCancelConfirmationMail($requestArray['nBooking_Id'], $requestArray['nCancelAmt'],'Admin');

        }
        else  // Booking section .....
        {

            $objSession                        = new LibSession();
            $lastBookingId                     = $this->_session->get('last_booking_id');

            /*$sql = 'select max(nBooking_Id) as bookid from '.MYSQL_TABLE_PREFIX.'booking ';
        $res= mysql_query($sql);
        $row = mysql_fetch_array($res);
        $lastBookingId = $row['bookid'];*/


            $sections                           = explode("-",$responseArray['shopping-cart_items_item-1_item-name']);
            $lastBookingId                      = $sections[count($sections)-1];



            if($lastBookingId>0 && Booking::checkForConfirmedBooking($lastBookingId)==false) {

                Booking::updateBookingStatus($lastBookingId);

                $bookingDetails                              = array();
                $tempLastBookingDetails                      = Booking::getBookingDetails($lastBookingId);

                $bookingDetails['arrivalDate']               = $tempLastBookingDetails->checkin_Date;
                $bookingDetails['departureDate']             = $tempLastBookingDetails->checkout_Date;
                $bookingDetails['nAdults']                   = $tempLastBookingDetails->nAdults;
                $bookingDetails['numberOfChildren']          = $tempLastBookingDetails->nChildren;
                $bookingDetails['amountToPayForBooking']     = $tempLastBookingDetails->nReserveModeAmount;
                $bookingDetails['siteBookingMode']           = Apputils::fetchSettings('ReserveMode');
                $bookingDetails['locationName']              = Booking::getLocationName($lastBookingId);



                $accomodationDetails                         =  Booking::getAccommadationDetails($lastBookingId);
                $bookingDetails['accomadationType']          = $accomodationDetails->nAt_Id;

                $customerDetails                             = Booking::getCustomerDetails($lastBookingId);

                $bookingDetails['firstName']                 = $customerDetails->vFirstname;
                $bookingDetails['lastName']                  = $customerDetails->vLastname;


                $bookingDetails['name']                      = $customerDetails->vFirstname. ' '. $customerDetails->vLastname;
                $bookingDetails['extraPrice']                = $tempLastBookingDetails->nAmount;
                $bookingDetails['destinationName']           = Booking::getDestinationName($lastBookingId);
                $bookingDetails['numberOfRooms']             = $tempLastBookingDetails->nRooms;


                Booking::updateBookingStatus($lastBookingId);
                Booking::updateRefferalStatus($lastBookingId,$tempLastBookingDetails->nAmount);

                $bookingDetails['address']                   = Booking::getLocationAddress($lastBookingId);


                Booking::sendInvoice($customerDetails->vEmail,$bookingDetails,'User');
                Booking::sendInvoice($customerDetails->vEmail,$bookingDetails,'Admin');


            }
        }

    }

    public function googlecheckoutcancelipncall($xmldata) {

        $xmldata = $_REQUEST[0];
        $Data = Payments::xml2array($xmldata);
        $file = fopen(FILE_UPLOAD_DIR."/test.txt", "w");
        fwrite($file,print_r($Data,true));

        fclose($file);
        $objSession                                  = new LibSession();
    }

    public function xml2array($contents, $get_attributes=1, $priority = 'tag') {

        if(!$contents) return array();

        if(!function_exists('xml_parser_create')) {
            //print "'xml_parser_create()' function not found!";
            return array();
        }

        //Get the XML parser of PHP - PHP must have this module for the parser to work
        $parser = xml_parser_create('');
        xml_parser_set_option($parser, XML_OPTION_TARGET_ENCODING, "UTF-8"); # http://minutillo.com/steve/weblog/2004/6/17/php-xml-and-character-encodings-a-tale-of-sadness-rage-and-data-loss
        xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
        xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
        xml_parse_into_struct($parser, trim($contents), $xml_values);
        xml_parser_free($parser);

        if(!$xml_values) return;//Hmm...

        //Initializations
        $xml_array = array();
        $parents = array();
        $opened_tags = array();
        $arr = array();

        $current = &$xml_array; //Refference

        //Go through the tags.
        $repeated_tag_index = array();//Multiple tags with same name will be turned into an array
        foreach($xml_values as $data) {
            unset($attributes,$value);//Remove existing values, or there will be trouble

            //This command will extract these variables into the foreach scope
            // tag(string), type(string), level(int), attributes(array).
            extract($data);//We could use the array by itself, but this cooler.

            $result = array();
            $attributes_data = array();

            if(isset($value)) {
                if($priority == 'tag') $result = $value;
                else $result['value'] = $value; //Put the value in a assoc array if we are in the 'Attribute' mode
            }

            //Set the attributes too.
            if(isset($attributes) and $get_attributes) {
                foreach($attributes as $attr => $val) {
                    if($priority == 'tag') $attributes_data[$attr] = $val;
                    else $result['attr'][$attr] = $val; //Set all the attributes in a array called 'attr'
                }
            }

            //See tag status and do the needed.
            if($type == "open") {//The starting of the tag '<tag>'
                $parent[$level-1] = &$current;
                if(!is_array($current) or (!in_array($tag, array_keys($current)))) { //Insert New tag
                    $current[$tag] = $result;
                    if($attributes_data) $current[$tag. '_attr'] = $attributes_data;
                    $repeated_tag_index[$tag.'_'.$level] = 1;

                    $current = &$current[$tag];

                } else { //There was another element with the same tag name

                    if(isset($current[$tag][0])) {//If there is a 0th element it is already an array
                        $current[$tag][$repeated_tag_index[$tag.'_'.$level]] = $result;
                        $repeated_tag_index[$tag.'_'.$level]++;
                    } else {//This section will make the value an array if multiple tags with the same name appear together
                        $current[$tag] = array($current[$tag],$result);//This will combine the existing item and the new item together to make an array
                        $repeated_tag_index[$tag.'_'.$level] = 2;

                        if(isset($current[$tag.'_attr'])) { //The attribute of the last(0th) tag must be moved as well
                            $current[$tag]['0_attr'] = $current[$tag.'_attr'];
                            unset($current[$tag.'_attr']);
                        }

                    }
                    $last_item_index = $repeated_tag_index[$tag.'_'.$level]-1;
                    $current = &$current[$tag][$last_item_index];
                }

            } elseif($type == "complete") { //Tags that ends in 1 line '<tag />'
                //See if the key is already taken.
                if(!isset($current[$tag])) { //New Key
                    $current[$tag] = $result;
                    $repeated_tag_index[$tag.'_'.$level] = 1;
                    if($priority == 'tag' and $attributes_data) $current[$tag. '_attr'] = $attributes_data;

                } else { //If taken, put all things inside a list(array)
                    if(isset($current[$tag][0]) and is_array($current[$tag])) {//If it is already an array...

                        // ...push the new element into that array.
                        $current[$tag][$repeated_tag_index[$tag.'_'.$level]] = $result;

                        if($priority == 'tag' and $get_attributes and $attributes_data) {
                            $current[$tag][$repeated_tag_index[$tag.'_'.$level] . '_attr'] = $attributes_data;
                        }
                        $repeated_tag_index[$tag.'_'.$level]++;

                    } else { //If it is not an array...
                        $current[$tag] = array($current[$tag],$result); //...Make it an array using using the existing value and the new value
                        $repeated_tag_index[$tag.'_'.$level] = 1;
                        if($priority == 'tag' and $get_attributes) {
                            if(isset($current[$tag.'_attr'])) { //The attribute of the last(0th) tag must be moved as well

                                $current[$tag]['0_attr'] = $current[$tag.'_attr'];
                                unset($current[$tag.'_attr']);
                            }

                            if($attributes_data) {
                                $current[$tag][$repeated_tag_index[$tag.'_'.$level] . '_attr'] = $attributes_data;
                            }
                        }
                        $repeated_tag_index[$tag.'_'.$level]++; //0 and 1 index is already taken
                    }
                }

            } elseif($type == 'close') { //End of tag '</tag>'
                $current = &$parent[$level-1];
            }
        }

        return($xml_array);
    }


}

?>