UPDATE `cms_sections` SET `section_config`='{\r\n\"keyColumn\": \"cms_id\",\r\n    \"orderBy\": {\r\n        \"cms_id\": \"ASC\"\r\n    },\r\n\"where\":\"tbl_Cms.cms_type=\'email\'\",\r\n\r\n    \"listColumns\": [\r\n        \"cms_name\",\r\n        \"cms_title\",\r\n        \"cms_status\"\r\n    ],\r\n    \"showColumns\": [\r\n        \"cms_id\",\r\n        \"cms_name\",\r\n        \"cms_title\",\r\n        \"cms_desc\",\r\n        \"cms_status\"\r\n    ],\r\n    \"detailColumns\": [\r\n        \"cms_id\",\r\n        \"cms_name\",\r\n        \"cms_title\",\r\n        \"cms_desc\",\r\n        \"cms_status\"\r\n    ],\r\n    \"detailHeaderColumns\": [\r\n        \"cms_title\"\r\n    ],\r\n    \"columns\": {\r\n        \"cms_id\": {\r\n            \"name\": \"ID\",\r\n            \"sortable\": \"true\",\r\n            \"editoptions\": {\r\n                \"type\": \"hidden\"\r\n            }\r\n        },\r\n        \"cms_name\": {\r\n            \"name\": \"Name\",\r\n            \"sortable\": \"true\",\r\n            \"searchable\": \"searchable\",\r\n            \"editoptions\": {\r\n                \"type\": \"hidden\"\r\n            }\r\n        },\r\n        \"cms_title\": {\r\n            \"name\": \"Subject\",\r\n            \"sortable\": \"true\",\r\n            \"searchable\": \"searchable\",\r\n            \"editoptions\": {\r\n                \"validations\": [\r\n                    \"required\"\r\n                ],\r\n                \"type\": \"textbox\",\r\n                \"label\": \"Subject\",\r\n                \"class\": \"textbox\"\r\n            }\r\n        },\r\n        \"cms_desc\": {\r\n            \"name\": \"Content\",\r\n            \"sortable\": \"true\",\r\n            \"editoptions\": {\r\n                \"validations\": [\r\n                    \"required\"\r\n                ],\r\n                \"type\": \"htmlEditor\",\r\n                \"label\": \"Content\",\r\n                \"class\": \"textarea\"\r\n            }\r\n        },\r\n        \"cms_status\": {\r\n            \"name\": \"Status\",\r\n            \"editoptions\": {\r\n                \"type\": \"select\",\r\n                \"source\": {\r\n                    \"1\": \"Active\",\r\n                    \"0\": \"Inactive\"\r\n                },\r\n                \"source_type\": \"array\",\r\n                \"label\": \"Status\",\r\n                \"class\": \"select\",\r\n                \"enumvalues\": {\r\n                    \"1\": \"Active\",\r\n                    \"0\": \"Inactive\"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    \"opertations\": [\r\n        \"edit\",\r\n        \"view\"      \r\n    ]\r\n}' WHERE `section_alias`='email_content';

UPDATE `cms_sections` SET `section_config`='{\r\n    \"keyColumn\": \"nETMId\",\r\n    \"detailHeaderColumns\": [\r\n        \"vMailName\"\r\n    ],\r\n    \"detailHeaderColumnPrefix\": \"Email Scheduler: \",\r\n    \"orderBy\": {\r\n        \"nETMId\": \"DESC\"\r\n    },\r\n    \"listColumns\": [\r\n        \"vMailName\",\r\n        \"nETID\",\r\n        \"tScheduleTime\",\r\n        \"eStatus\",\r\n        \"nMailMode\"\r\n    ],\r\n    \"detailColumns\": [\r\n        \"nETMId\",\r\n        \"vMailName\",\r\n        \"nETID\",\r\n        \"tScheduleTime\",\r\n        \"eStatus\",\r\n        \"nMailMode\"\r\n    ],\r\n    \"showColumns\": [\r\n        \"nETMId\",\r\n        \"vMailName\",\r\n        \"nETID\",\r\n        \"tScheduleTime\",\r\n        \"eStatus\",\r\n        \"nMailMode\"\r\n    ],\r\n    \"columns\": {\r\n        \"nETMId\": {\r\n            \"name\": \"ID\",\r\n            \"sortable\": \"true\"\r\n        },\r\n        \"vMailName\": {\r\n            \"name\": \"Mail Name\",\r\n            \"searchable\": \"searchable\",\r\n            \"sortable\": \"true\",\r\n            \"editoptions\": {\r\n                \"validations\": [\r\n                    \"required\"\r\n                ],\r\n                \"type\": \"textbox\",\r\n                \"label\": \"Mail Name\",\r\n                \"class\": \"textbox\"\r\n            }\r\n        },\r\n        \"nETID\": {\r\n            \"name\": \"Email Template Name\",\r\n            \"searchable\": \"searchable\",\r\n            \"sortable\": \"true\",\r\n            \"editoptions\": {\r\n                \"validations\": [\r\n                    \"required\"\r\n                ],\r\n                \"type\": \"select\",\r\n                \"source\": \"Streamsendlogic::getemailTemplateList\",\r\n                \"source_type\": \"function\",\r\n                \"label\": \"Email Template Name\",\r\n                \"class\": \"select\"\r\n            },\r\n            \"external\": \"true\",\r\n            \"externalOptions\": {\r\n                \"externalTable\": \"tbl_EmailTemplates\",\r\n                \"externalColumn\": \"nETID\",\r\n                \"externalShowColumn\": \"vemailTemplateName\"\r\n            }\r\n        },\r\n        \"tScheduleTime\": {\r\n            \"name\": \"Schedule Time\",\r\n            \"searchable\": \"searchable\",\r\n            \"sortable\": \"true\",\r\n            \"editoptions\": {\r\n                \"validations\": [\r\n                    \"required\"\r\n                ],\r\n                \"type\": \"datepicker\",\r\n                \"label\": \"Schedule Time\",\r\n                \"class\": \"datepicker\",\r\n                \"dbFormat\": \"datetime\",\r\n                \"displayFormat\": \"m/d/Y\"\r\n            }\r\n        },\r\n        \"eStatus\": {\r\n            \"name\": \"Status\",\r\n            \"searchable\": \"searchable\",\r\n            \"editoptions\": {\r\n                \"type\": \"hidden\",\r\n                \"class\": \"hidden\",\r\n                \"value\": \"Active\"\r\n                \r\n            },\r\n            \"listoptions\": {\r\n                \"type\": \"button\",\r\n                \"customaction\": \"Admin::changeEmailSchedulerStatus\",\r\n                \"enumvalues\": {\r\n                    \"Active\": \"Active\",\r\n                    \"Deactive\": \"Inactive\"\r\n                },\r\n                \"buttonColors\": {\r\n                    \"Active\": \"green\",\r\n                    \"Deactive\": \"red\"\r\n                }\r\n            }\r\n        },\r\n        \"nMailMode\": {\r\n            \"name\": \"Mail Mode\",\r\n            \"searchable\": \"searchable\",\r\n            \"sortable\": \"true\",\r\n            \"editoptions\": {\r\n                \"type\": \"hidden\",\r\n                \"class\": \"hidden\",\r\n                \"value\": \"Streamsend\"\r\n            }\r\n        }\r\n    },\r\n    \"customActions\": {\r\n        \"afterAddRecord\": \"Streamsendlogic::setScheduleMail\",\r\n        \"afterEditRecord\": \"Streamsendlogic::setScheduleMailEdit\"\r\n    },\r\n    \"opertations\": [\r\n        \"view\",\r\n        \"edit\",\r\n        \"add\",\r\n        \"delete\"\r\n    ]\r\n}' WHERE `section_alias`='emailscheduler';

UPDATE `cms_sections` SET `section_config`='{\r\n    \"keyColumn\": \"nId\",\r\n\"detailHeaderColumns\":[\"vTitle\"],\r\n    \"orderBy\": {\r\n        \"vTitle\": \"ASC\"\r\n    },\r\n    \"where\": \"tbl_Help.eType=\'User\'\",\r\n    \"listColumns\": [\r\n        \"vTitle\",\r\n        \"eStatus\"\r\n    ],\r\n    \"showColumns\": [\r\n        \"nId\",\r\n        \"vTitle\",\r\n        \"tDescription\",\r\n        \"eType\",\r\n        \"eStatus\"\r\n    ],\r\n    \"detailColumns\": [\r\n        \"nId\",\r\n        \"vTitle\",\r\n        \"tDescription\",\r\n        \"eStatus\",\r\n        \"eType\"\r\n    ],\r\n    \"columns\": {\r\n        \"nId\": {\r\n            \"name\": \"ID\"\r\n        },\r\n        \"vTitle\": {\r\n            \"name\": \"Title\",\r\n            \"sortable\": \"true\",\r\n            \"searchable\": \"searchable\",\r\n            \"editoptions\": {\r\n                \"validations\": [\r\n                    \"required\"\r\n                ],\r\n                \"type\": \"textbox\",\r\n                \"label\": \"Title\",\r\n                \"class\": \"textbox\"\r\n            }\r\n        },\r\n        \"tDescription\": {\r\n            \"name\": \"Description\",\r\n            \"editoptions\": {\r\n                \"validations\": [\r\n                    \"required\"\r\n                ],\r\n                \"type\": \"htmlEditor\",\r\n                \"label\": \"Description\"\r\n            }\r\n        },\r\n        \"eType\": {\r\n            \"name\": \"Help Category\",\r\n            \"sortable\": \"true\",\r\n            \"editoptions\": {\r\n                \"type\": \"select\",\r\n                \"source\": {\r\n                    \"Admin\": \"Admin\",\r\n                    \"User\": \"User\"\r\n                },\r\n                \"source_type\": \"array\",\r\n                \"label\": \"Category\",\r\n                \"enumvalues\": {\r\n                    \"Admin\": \"Admin\",\r\n                    \"User\": \"User\"\r\n                }\r\n            }\r\n        },\r\n        \"eStatus\": {\r\n            \"name\": \"Status\",\r\n            \"editoptions\": {\r\n                \"type\": \"select\",\r\n                \"source\": {\r\n                    \"Active\": \"Active\",\r\n                    \"Disabled\": \"Disabled\"\r\n                },\r\n                \"label\": \"Status\",\r\n                \"enumvalues\": {\r\n                    \"Active\": \"Active\",\r\n                    \"Disabled\": \"Disabled\"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    \"opertations\": [\r\n        \"add\",\r\n        \"edit\",\r\n        \"delete\",\r\n        \"view\"\r\n    ]\r\n}' WHERE `section_alias`='userHelp';

UPDATE `cms_sections` SET `section_config`='{\n    \"keyColumn\": \"cms_id\",\n    \"orderBy\": {\n        \"cms_id\": \"ASC\"\n    },\n    \"where\": \"tbl_Cms.cms_type=\'email_settings\'\",\n    \"listColumns\": [\n        \"cms_name\",\n        \"cms_status\"\n    ],\n    \"showColumns\": [\n        \"cms_id\",\n        \"cms_name\",\n        \"cms_title\",\n        \"cms_desc\",\n        \"cms_status\"\n    ],\n    \"detailColumns\": [\n        \"cms_id\",\n        \"cms_name\",\n        \"cms_title\",\n        \"cms_desc\",\n        \"cms_status\"\n    ],\n    \"detailHeaderColumns\": [\n        \"cms_title\"\n    ],\n    \"columns\": {\n        \"cms_id\": {\n            \"name\": \"ID\",\n            \"sortable\": \"true\",\n            \"editoptions\": {\n                \"type\": \"hidden\"\n            }\n        },\n        \"cms_name\": {\n            \"name\": \"Name\",\n            \"sortable\": \"true\",\n            \"editoptions\": {\n                \"type\": \"hidden\"\n            }\n        },\n        \"cms_title\": {\n            \"name\": \"Title\",\n            \"sortable\": \"true\",\n            \"editoptions\": {\n                \"validations\": [\n                    \"required\"\n                ],\n                \"type\": \"textbox\",\n                \"label\": \"Title\",\n                \"class\": \"textbox\"\n            }\n        },\n        \"cms_desc\": {\n            \"name\": \"Content\",\n            \"sortable\": \"true\",\n            \"editoptions\": {\n                \"validations\": [\n                    \"required\"\n                ],\n                \"type\": \"htmlEditor\",\n                \"label\": \"Content\",\n                \"class\": \"textarea\"\n            }\n        },\n        \"cms_status\": {\n            \"name\": \"Status\",\n            \"editoptions\": {\n                \"type\": \"select\",\n                \"source\": {\n                    \"0\": \"Inactive\",\n                    \"1\": \"Active\"\n                },\n                \"source_type\": \"array\",\n                \"label\": \"Status\",\n                \"class\": \"select\",\n                \"enumvalues\": {\n                    \"0\": \"Inactive\",\n                    \"1\": \"Active\"\n                }\n            }\n        }\n    },\n    \"opertations\": [\n        \"edit\"\n    ]\n}' WHERE `section_alias`='emailtemplates';

UPDATE `cms_sections` SET `section_config`='{\r\n    \"keyColumn\": \"nInvId\",\r\n    \"orderBy\": {\r\n        \"dGeneratedDate\": \"DESC\"\r\n    },\r\n    \"detailHeaderColumns\": [\"vInvNo\"],\r\n    \"detailHeaderColumnPrefix\": \"Invoice: \",\r\n    \"listColumns\": [\r\n        \"vInvNo\",\r\n        \"vSubscriptionType\",\r\n        \"nUId\",\r\n        \"dGeneratedDate\",\r\n        \"dDueDate\",\r\n        \"dPayment\",\r\n        \"pStatus\",\r\n        \"nTotal\"\r\n    ],\r\n    \"detailColumns\": [\r\n        \"nInvId\",\r\n        \"vInvNo\",\r\n        \"vSubscriptionType\",\r\n        \"vTxnId\",\r\n        \"nUId\",\r\n        \"dGeneratedDate\",\r\n        \"dDueDate\",\r\n        \"dPayment\",\r\n        \"pStatus\",\r\n        \"nTotal\"\r\n    ],\r\n    \"columns\": {\r\n        \"nInvId\": {\r\n            \"name\": \"ID\"\r\n        },\r\n        \"vInvNo\": {\r\n            \"name\": \"Invoice Number\",\r\n            \"sortable\": \"true\",\r\n            \"customColumn\": \"true\",\r\n            \"customaction\": \"Admincomponents::getCmsInvoiceDetails\"\r\n        },\r\n        \"pStatus\": {\r\n            \"name\": \"Payment Status\",\r\n            \"customColumn\": \"true\",\r\n            \"customaction\": \"Admincomponents::getPaymentStatus\"\r\n        },\r\n\r\n        \"vSubscriptionType\": {\r\n            \"name\": \"Subscription\",\r\n            \"searchable\": \"searchable\",\r\n            \"sortable\": \"true\"\r\n        },\r\n        \"vTxnId\": {\r\n            \"name\": \"Transaction ID\"\r\n        },\r\n        \"nUId\": {\r\n            \"name\": \"User\",\r\n            \"sortable\": \"true\",\r\n            \"customColumn\": \"true\",\r\n            \"customaction\": \"Admincomponents::getUsernameFromInvoice\"\r\n        },\r\n        \"dGeneratedDate\": {\r\n            \"name\": \"Generated On\",\r\n            \"searchable\": \"searchable\",\r\n            \"sortable\": \"true\",\r\n            \"dbFormat\": \"timestamp\",\r\n            \"displayFormat\": \"m/d/Y\"\r\n        },\r\n        \"dDueDate\": {\r\n            \"name\": \"Due On\",\r\n            \"searchable\": \"searchable\",\r\n            \"sortable\": \"true\",\r\n            \"dbFormat\": \"timestamp\",\r\n            \"displayFormat\": \"m/d/Y\"\r\n        },\r\n        \"dPayment\": {\r\n            \"name\": \"Paid On\",\r\n            \"searchable\": \"searchable\",\r\n            \"sortable\": \"true\",\r\n            \"customColumn\": \"true\",\r\n            \"customaction\": \"Admincomponents::getInvoicePaidDateForCMS\"\r\n        },\r\n        \"nTotal\": {\r\n            \"name\": \"Total Amount\",\r\n            \"searchable\": \"searchable\",\r\n            \"sortable\": \"true\",\r\n            \"listHeaderPostfix\": \"($)\",\r\n\"lsHeaderPostfixCustom\": \"true\"\r\n        }\r\n    },\r\n    \"opertations\": [\r\n        \"view\"\r\n    ],\r\n    \"report\": {\r\n        \"reportTitle\": \"Invoices\",\r\n        \"columns\": [\r\n            \"vInvNo\",\r\n            \"vSubscriptionType\",\r\n            \"vTxnId\",\r\n            \"nUId\",\r\n            \"dGeneratedDate\",\r\n            \"dDueDate\",\r\n            \"dPayment\",\r\n            \"pStatus\",\r\n            \"nTotal\"\r\n        ],\r\n        \"dateColumn\": \"dGeneratedDate\"\r\n    }\r\n}' WHERE `section_alias`='invoice';

UPDATE `cms_sections` SET `section_config`='{\r\n    \"keyColumn\": \"nETMId\",\r\n    \"detailHeaderColumns\": [\r\n        \"vMailName\"\r\n    ],\r\n    \"detailHeaderColumnPrefix\": \"Email Scheduler: \",\r\n    \"orderBy\": {\r\n        \"nETMId\": \"DESC\"\r\n    },\r\n    \"listColumns\": [\r\n        \"vMailName\",\r\n        \"nETID\",\r\n        \"tScheduleTime\",\r\n        \"eStatus\",\r\n        \"nMailMode\"\r\n    ],\r\n    \"detailColumns\": [\r\n        \"nETMId\",\r\n        \"vMailName\",\r\n        \"nETID\",\r\n        \"tScheduleTime\",\r\n        \"eStatus\",\r\n        \"nMailMode\"\r\n    ],\r\n    \"showColumns\": [\r\n        \"nETMId\",\r\n        \"vMailName\",\r\n        \"nETID\",\r\n        \"tScheduleTime\",\r\n        \"eStatus\",\r\n        \"nMailMode\"\r\n    ],\r\n    \"columns\": {\r\n        \"nETMId\": {\r\n            \"name\": \"ID\",\r\n            \"sortable\": \"true\"\r\n        },\r\n        \"vMailName\": {\r\n            \"name\": \"Mail Name\",\r\n            \"searchable\": \"searchable\",\r\n            \"sortable\": \"true\",\r\n            \"editoptions\": {\r\n                \"validations\": [\r\n                    \"required\"\r\n                ],\r\n                \"type\": \"textbox\",\r\n                \"label\": \"Mail Name\",\r\n                \"class\": \"textbox\"\r\n            }\r\n        },\r\n        \"nETID\": {\r\n            \"name\": \"Email Template Name\",\r\n            \"searchable\": \"searchable\",\r\n            \"sortable\": \"true\",\r\n            \"editoptions\": {\r\n                \"validations\": [\r\n                    \"required\"\r\n                ],\r\n                \"type\": \"select\",\r\n                \"source\": \"Streamsendlogic::getemailTemplateList\",\r\n                \"source_type\": \"function\",\r\n                \"label\": \"Email Template Name\",\r\n                \"class\": \"select\"\r\n            },\r\n            \"external\": \"true\",\r\n            \"externalOptions\": {\r\n                \"externalTable\": \"tbl_EmailTemplates\",\r\n                \"externalColumn\": \"nETID\",\r\n                \"externalShowColumn\": \"vemailTemplateName\"\r\n            }\r\n        },\r\n        \"tScheduleTime\": {\r\n            \"name\": \"Schedule Time\",\r\n            \"searchable\": \"searchable\",\r\n            \"sortable\": \"true\",\r\n            \"editoptions\": {\r\n                \"validations\": [\r\n                    \"required\"\r\n                ],\r\n                \"type\": \"datepicker\",\r\n                \"label\": \"Schedule Time\",\r\n                \"class\": \"datepicker\",\n                \"dbFormat\": \"datetime\",\n                \"displayFormat\": \"m/d/Y\"\r\n            },\n                \"dbFormat\": \"datetime\",\n                \"displayFormat\": \"m/d/Y\"\r\n        },\r\n        \"eStatus\": {\r\n            \"name\": \"Status\",\r\n            \"searchable\": \"searchable\",\r\n            \"editoptions\": {\r\n                \"type\": \"hidden\",\r\n                \"class\": \"hidden\",\r\n                \"value\": \"Active\"\r\n                \r\n            },\r\n            \"listoptions\": {\r\n                \"type\": \"button\",\r\n                \"customaction\": \"Admin::changeEmailSchedulerStatus\",\r\n                \"enumvalues\": {\r\n                    \"Active\": \"Active\",\r\n                    \"Deactive\": \"Inactive\"\r\n                },\r\n                \"buttonColors\": {\r\n                    \"Active\": \"green\",\r\n                    \"Deactive\": \"red\"\r\n                }\r\n            }\r\n        },\r\n        \"nMailMode\": {\r\n            \"name\": \"Mail Mode\",\r\n            \"searchable\": \"searchable\",\r\n            \"sortable\": \"true\",\r\n            \"editoptions\": {\r\n                \"type\": \"hidden\",\r\n                \"class\": \"hidden\",\r\n                \"value\": \"Streamsend\"\r\n            }\r\n        }\r\n    },\r\n    \"customActions\": {\r\n        \"afterAddRecord\": \"Streamsendlogic::setScheduleMail\",\r\n        \"afterEditRecord\": \"Streamsendlogic::setScheduleMailEdit\"\r\n    },\r\n    \"opertations\": [\r\n        \"view\",\r\n        \"edit\",\r\n        \"add\",\r\n        \"delete\"\r\n    ]\r\n}' WHERE `section_alias`='emailscheduler';

UPDATE `cms_sections` SET `section_config`='{\r\n    \"keyColumn\": \"nCouponId\",\r\n    \"orderBy\": {\r\n        \"dCreatedOn\": \"DESC\"\r\n    },\r\n    \"detailHeaderColumns\": [\"vCouponCode\"],\r\n    \"detailHeaderColumnPrefix\": \"Coupon: \",\r\n    \"listColumns\": [\r\n        \"vCouponCode\",\r\n        \"vPricingMode\",\r\n        \"nCouponValue\",\r\n        \"dExpireOn\",\r\n        \"nCouponCount\",\r\n        \"nCouponUsed\"\r\n    ],\r\n    \"showColumns\": [\r\n        \"nCouponId\",\r\n        \"vCouponCode\",\r\n        \"nCouponCount\",\r\n        \"vPricingMode\",\r\n        \"nCouponValue\",\r\n        \"dCreatedOn\",\r\n        \"dExpireOn\",\r\n        \"vCouponDescription\"\r\n    ],\r\n    \"detailColumns\": [\r\n        \"nCouponId\",\r\n        \"vCouponCode\",\r\n        \"vCouponDescription\",\r\n        \"vPricingMode\",\r\n        \"nCouponValue\",\r\n        \"dCreatedOn\",\r\n        \"dExpireOn\",\r\n        \"nCouponCount\",\r\n        \"nCouponUsed\"\r\n    ],\r\n    \"columns\": {\r\n        \"nCouponId\": {\r\n            \"name\": \"ID\",\r\n            \"editoptions\":{\"type\":\"hidden\"}\r\n        },\r\n        \"nCouponUsed\": {\r\n            \"name\": \"Number Of Coupons Used\"\r\n        },\r\n        \"vCouponCode\": {\r\n            \"name\": \"Coupon Code\",\r\n            \"searchable\": \"searchable\",\r\n            \"sortable\": \"true\",\r\n            \"editoptions\":{\n                \"validations\":[\"required\"],\n                \"type\":\"textbox\",\n                \"label\":\"Coupon Code\",\n                \"class\":\"textbox\"\n            }\r\n        },\r\n        \"nCouponCount\": {\r\n            \"name\": \"Number Of Coupons\",\r\n            \"sortable\": \"true\",\r\n            \"editoptions\":{\n                  \"validations\":[\"required\"],\n                  \"type\":\"textbox\",\n                  \"label\":\"Number of Coupons\",\n                  \"class\":\"textbox\"\n            }\r\n        },\r\n        \"dCreatedOn\": {\r\n            \"name\": \"Created Date\",\r\n            \"editoptions\":{\n                \"validations\":[\"required\"],\n                \"type\":\"datepicker\",\n                \"label\":\"Created Date\",\n                \"class\":\"textbox\",\n            \"dbFormat\":\"date\",\n            \"displayFormat\":\"m/d/Y\"\n            },\n            \"dbFormat\":\"date\",\n            \"displayFormat\":\"m/d/Y\"\r\n        },\r\n        \"dExpireOn\": {\r\n            \"name\": \"Expiry Date\",\r\n            \"sortable\": \"true\",\r\n            \"editoptions\":{\n                \"validations\":[\"required\"],\n                \"type\":\"datepicker\",\n                \"label\":\"Expiry Date\",\n                \"class\":\"textbox\",\n            \"dbFormat\":\"date\",\n            \"displayFormat\":\"m/d/Y\"\n            },\n            \"dbFormat\":\"date\",\n            \"displayFormat\":\"m/d/Y\"\r\n        },\r\n        \"vPricingMode\": {\r\n            \"name\": \"Pricing Mode\",\r\n            \"sortable\": \"true\",\r\n            \"searchable\": \"searchable\",\r\n            \"editoptions\":{\r\n                \"validations\":[\"required\"],\r\n                \"type\":\"select\",\r\n                \"label\":\"Pricing Mode\",\r\n                \"class\":\"select\",\r\n                \"source\":{\"percentage\":\"Percentage\",\"rate\":\"Rate\"},\r\n                \"source_type\":\"array\",\r\n                \"enumvalues\":{\"percentage\":\"Percentage\",\"rate\":\"Rate\"}\r\n            }\r\n        },\r\n        \"nCouponValue\": {\r\n            \"name\": \"Coupon Value\",\r\n            \"sortable\": \"true\",\r\n            \"editoptions\":{\n                \"validations\":[\"required\"],\n                \"type\":\"textbox\",\n                \"label\":\"Coupon Value\",\n                \"class\":\"textbox\"\n            }\r\n        },\r\n        \"vCouponDescription\": {\r\n            \"name\": \"Description\",\r\n            \"sortable\": \"true\",\r\n            \"editoptions\":{\"type\":\"textbox\",\"label\":\"Description\",\"class\":\"textbox\"}\r\n        }\r\n\r\n    },\r\n    \"opertations\": [\r\n        \"add\",\"edit\",\"delete\",\"view\"\r\n    ],\r\n    \"report\": {\r\n        \"reportTitle\": \"Coupons\",\r\n        \"columns\": [\r\n            \"vCouponCode\",\r\n            \"vPricingMode\",\r\n            \"nCouponValue\",\r\n            \"dCreatedOn\",\r\n            \"dExpireOn\",\r\n            \"nCouponCount\",\r\n            \"nCouponUsed\",\r\n            \"vCouponDescription\"\r\n        ],\r\n        \"dateColumn\": \"dCreatedOn\"\r\n    }\r\n}' WHERE `section_alias`='coupons';

UPDATE `goStores_Settings` SET `helpText`='Would you like your site linked to LinkedIn?' WHERE  `settingfield`='enable_ln' AND `settinglabel`='Enable LinkedIn' AND `groupLabel`='Social Settings' AND `type`='checkbox' AND `fieldOrder`=0  LIMIT 1;

UPDATE `goStores_ProductPermission` SET `vPermissions` = 'app/webroot/img/,app/webroot/img/products/,app/webroot/img/csv/,app/tmp/,app/tmp/logs/,app/tmp/sessions/,app/tmp/cache/,app/tmp/cache/models/,app/tmp/cache/views/,app/tmp/cache/persistent/,app/webroot/files/,app/webroot/files/File,app/webroot/files/Flash,app/webroot/files/Image,app/webroot/files/Media,app/webroot/files/Graph,app/config/database.php,app/webroot/config.php,app/webroot/img/SiteLogo.gif,app/webroot/img/SiteLogo_disp.gif,app/webroot/blog/wp-content/,app/webroot/blog/wp-config.php,app/controllers/components/pple.xml,app/webroot/configxml.xml,app/webroot/moneybooker.txt,' WHERE `goStores_ProductPermission`.`nId` = 1;