/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.server;

import java.awt.AWTException;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import jrdesktop.HostProperties;
import jrdesktop.server.rmi.Server;
import jrdesktop.utilities.ImageUtility;
import jrdesktop.viewer.ViewerData;

public class robot {
    private Robot rt;
    private Rectangle defaultScreenRect = null;
    private Rectangle oldScreenRect = null;
    private Toolkit tk = Toolkit.getDefaultToolkit();

    public robot() {
        this.defaultScreenRect = new Rectangle(this.tk.getScreenSize());
        try {
            this.rt = new Robot();
        }
        catch (AWTException awte) {
            awte.getStackTrace();
        }
    }

    public BufferedImage captureScreen(ViewerData viewerData) {
        this.updateScreenRect(viewerData);
        Rectangle screenRect = new Rectangle(viewerData.getScreenRect());
        BufferedImage screen = this.rt.createScreenCapture(screenRect);
        float screenScale = viewerData.getScreenScale();
        screenRect.width = (int)((float)screenRect.width * screenScale);
        screenRect.height = (int)((float)screenRect.height * screenScale);
        BufferedImage bimage = new BufferedImage(screenRect.width, screenRect.height, viewerData.getColorQuality());
        Graphics2D g2d = bimage.createGraphics();
        g2d.drawImage(screen, 0, 0, screenRect.width, screenRect.height, null);
        g2d.dispose();
        return bimage;
    }

    public byte[] CaptureScreenByteArray(ViewerData viewerData) {
        return ImageUtility.toByteArray(this.captureScreen(viewerData), viewerData.getImageQuality());
    }

    public Rectangle getCustomScreenRect(Rectangle rect) {
        this.defaultScreenRect = new Rectangle(this.tk.getScreenSize());
        if (rect.equals(new Rectangle(0, 0, 0, 0))) {
            return this.defaultScreenRect;
        }
        return rect;
    }

    public void updateScreenRect(ViewerData viewerData) {
        this.oldScreenRect = this.defaultScreenRect;
        this.defaultScreenRect = new Rectangle(this.tk.getScreenSize());
        if (viewerData.getScreenRect().equals(this.oldScreenRect) || !this.defaultScreenRect.equals(this.oldScreenRect)) {
            viewerData.setScreenRect(this.defaultScreenRect);
        }
    }

    public void updateData(Object object, ViewerData viewerData) {
        ArrayList Objects = (ArrayList)object;
        for (int i = 0; i < Objects.size(); ++i) {
            Object obj = Objects.get(i);
            if (obj instanceof MouseEvent) {
                this.applyMouseEvent((MouseEvent)obj, viewerData);
                continue;
            }
            if (obj instanceof KeyEvent) {
                this.applyKeyEvent((KeyEvent)obj);
                continue;
            }
            if (obj instanceof String) {
                this.setTextToClipboard((String)obj);
                continue;
            }
            if (obj instanceof ImageIcon) {
                this.setImageToClipboard((ImageIcon)obj);
                continue;
            }
            if (obj instanceof File) {
                this.getFilesFromClipboard((File)obj);
                continue;
            }
            if (!(obj instanceof Hashtable)) continue;
            this.setgetProperties((Hashtable)obj, viewerData);
        }
    }

    public void applyMouseEvent(MouseEvent evt, ViewerData viewerData) {
        int x = viewerData.getScreenRect().x + (int)((float)evt.getX() / viewerData.getScreenScale());
        int y = viewerData.getScreenRect().y + (int)((float)evt.getY() / viewerData.getScreenScale());
        this.rt.mouseMove(x, y);
        int buttonMask = 0;
        int buttons = evt.getButton();
        if (buttons == 1) {
            buttonMask = 16;
        }
        if (buttons == 2) {
            buttonMask |= 8;
        }
        if (buttons == 3) {
            buttonMask |= 4;
        }
        switch (evt.getID()) {
            case 501: {
                this.rt.mousePress(buttonMask);
                break;
            }
            case 502: {
                this.rt.mouseRelease(buttonMask);
                break;
            }
            case 507: {
                this.rt.mouseWheel(((MouseWheelEvent)evt).getUnitsToScroll());
            }
        }
    }

    public void applyKeyEvent(KeyEvent evt) {
        switch (evt.getID()) {
            case 401: {
                this.rt.keyPress(evt.getKeyCode());
                break;
            }
            case 402: {
                this.rt.keyRelease(evt.getKeyCode());
            }
        }
    }

    public void setTextToClipboard(String string) {
        Server.clipbrdUtility.setTextToClipboard(string);
    }

    public void setImageToClipboard(ImageIcon image) {
        Server.clipbrdUtility.setImageToClipboard(image);
    }

    public void getFilesFromClipboard(File file) {
        if (file.equals(new File("."))) {
            Server.setUploadingFolder();
        } else {
            Server.SendClipboardFileList();
        }
    }

    public void setgetProperties(Hashtable props, ViewerData viewerData) {
        if (props.isEmpty()) {
            Server.AddObject(HostProperties.getLocalProperties());
        } else {
            Server.setViewerProperties(viewerData.getInetAddress(), props);
        }
    }
}

