/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.viewer.FileMng;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.List;
import javax.swing.JLabel;
import jrdesktop.viewer.Recorder;

public class FilesDropTargetListener
implements DropTargetListener {
    private Recorder recorder;
    private JLabel label;

    public FilesDropTargetListener(JLabel label, Recorder recorder) {
        this.label = label;
        this.recorder = recorder;
    }

    public void dragEnter(DropTargetDragEvent event) {
        if (!this.isDragAcceptable(event)) {
            event.rejectDrag();
            return;
        }
    }

    public void dragExit(DropTargetEvent event) {
    }

    public void dragOver(DropTargetDragEvent event) {
    }

    public void dropActionChanged(DropTargetDragEvent event) {
        if (!this.isDragAcceptable(event)) {
            event.rejectDrag();
            return;
        }
    }

    public void drop(DropTargetDropEvent event) {
        if (!this.isDropAcceptable(event)) {
            event.rejectDrop();
            return;
        }
        event.acceptDrop(1);
        Transferable content = event.getTransferable();
        if (content == null) {
            return;
        }
        if (this.recorder.isRecording()) {
            try {
                if (content.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List list = (List)content.getTransferData(DataFlavor.javaFileListFlavor);
                    File[] files = (File[])list.toArray().clone();
                    if (files == null) {
                        return;
                    }
                    this.recorder.fileManager.setFiles(files);
                    this.recorder.viewer.AddObject(new File("."));
                }
            }
            catch (Exception e) {
                e.getStackTrace();
            }
        }
        event.dropComplete(true);
    }

    public boolean isDragAcceptable(DropTargetDragEvent event) {
        return (event.getDropAction() & 3) != 0;
    }

    public boolean isDropAcceptable(DropTargetDropEvent event) {
        return (event.getDropAction() & 3) != 0;
    }
}

