/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop;

import javax.swing.JOptionPane;

public class ConnectionInfos {
    public static final String[] BYTES = new String[]{" B", " kB", " MB", " GB", " TB", " PB", " EB", " ZB", " YB"};
    public static final String[] BYTES_PER_SECOND = new String[]{" B/s", " kB/s", " MB/s", " GB/s", " TB/s", " PB/s", " EB/s", " ZB/s", " YB/s"};
    private long previous = 0L;
    private long startedAt = 0L;
    private long duration = 0L;
    private long dataSize = 0L;
    private long sentData = 0L;
    private long receivedData = 0L;
    private long transferSpeed = 0L;

    public ConnectionInfos(boolean start) {
        if (start) {
            this.init();
        }
    }

    public void init() {
        this.startedAt = System.currentTimeMillis();
        this.duration = 0L;
        this.dataSize = 0L;
        this.sentData = 0L;
        this.receivedData = 0L;
        this.transferSpeed = 0L;
    }

    public void display() {
        this.refresh();
        JOptionPane.showMessageDialog(null, "Duration: \t" + this.getDuration() + "\n\n" + "Sent data: \t" + this.getSize(this.sentData) + "\n" + "Received data: \t" + this.getSize(this.receivedData) + "\n\n" + "Total data size: \t" + this.getSize(this.dataSize) + "\n\n" + "Transfer speed: \t" + this.getSpeed(), "Connection infos", 1);
    }

    public void incSentData(long size) {
        this.sentData += size;
    }

    public void incReceivedData(long size) {
        this.receivedData += size;
    }

    public void refresh() {
        this.duration = this.previous + System.currentTimeMillis() - this.startedAt;
        this.dataSize = this.sentData + this.receivedData;
        this.transferSpeed = this.dataSize * 1000L / this.duration;
    }

    public String getDuration() {
        long h = this.duration / 3600000L;
        long m = this.duration % 3600000L / 60000L;
        long s = this.duration % 60000L / 1000L;
        return h + ":" + m + ":" + s;
    }

    public String getSize(long size) {
        return this.getHumanFormat(size, BYTES);
    }

    public String getSpeed() {
        return this.getHumanFormat(this.transferSpeed, BYTES_PER_SECOND);
    }

    public void resetStartTime() {
        this.previous = System.currentTimeMillis() - this.startedAt;
        this.startedAt = 0L;
    }

    public String getHumanFormat(long size, String[] measureUnits) {
        int measureQuantity = 1024;
        if (size <= 0L) {
            return null;
        }
        if (size < (long)measureQuantity) {
            return size + measureUnits[0];
        }
        int i = 1;
        double d = size;
        while (true) {
            double d2;
            d /= (double)measureQuantity;
            if (!(d2 > (double)(measureQuantity - 1))) break;
            ++i;
        }
        long l = (long)(d * 100.0);
        d = (double)l / 100.0;
        if (i < measureUnits.length) {
            return d + measureUnits[i];
        }
        return String.valueOf(size);
    }
}

