<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2010 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts VistaCart                     |
// +----------------------------------------------------------------------+
// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |
// +----------------------------------------------------------------------+
	class UpsshippingComponent extends Object
	{
		var $components = array('Httpclient');

		function passValues($module_shipping_handling,$shipping_num_boxes,$shipping_box_weight_display,$res_code,$container_code,$rate_chart,$ups_action_code,$text_shipping_weight,$prod,$ups_shipping_weight,$origin_country,$origin_postal,$destination_country,$destination_postal,$module_shipping_ups_types,$calculate_shipping="")
		{
			$ups_types = array('1DM' => 'Next Day Air Early AM',
								'1DML' => 'Next Day Air Early AM Letter',
								'1DA' => 'Next Day Air',
								'1DAL' => 'Next Day Air Letter',
								'1DAPI' => 'Next Day Air Intra (Puerto Rico)',
								'1DP' => 'Next Day Air Saver',
								'1DPL' => 'Next Day Air Saver Letter',
								'2DM' => '2nd Day Air AM',
								'2DML' => '2nd Day Air AM Letter',
								'2DA' => '2nd Day Air',
								'2DAL' => '2nd Day Air Letter',
								'3DS' => '3 Day Select',
								'GND' => 'Ground',
								'GNDCOM' => 'Ground Commercial',
								'GNDRES' => 'Ground Residential',
								'STD' => 'Canada Standard',
								'XPR' => 'Worldwide Express',
								'XPRL' => 'worldwide Express Letter',
								'XDM' => 'Worldwide Express Plus',
								'XDML' => 'Worldwide Express Plus Letter',
								'XPD' => 'Worldwide Expedited');

			//define(TEXT_SHIPPING_WEIGHT,'lbs');
			define('TEXT_SHIPPING_BOXES','boxes');
			//define(MODULE_SHIPPING_UPS_HANDLING,'5');
			//define(MODULE_SHIPPING_UPS_TYPES,'1DM, 1DML, 1DA, 1DAL, 1DAPI, 1DP, 1DPL, 2DM, 2DML, 2DA, 2DAL, 3DS, GND, STD, XPR, XPRL, XDM, XDML, XPD');

			$upsQuote =$this->getUpsDetails($ups_action_code,$prod,$origin_country,$origin_postal
			,$destination_postal,$destination_country,$ups_shipping_weight,$rate_chart,$container_code,$res_code);
			//print_r($upsQuote);exit;
			if((is_array($upsQuote)) && (sizeof($upsQuote) > 0))
			{
				switch ($shipping_box_weight_display)
				{
					case (0):
						$show_box_weight = '';
					break;
					case (1):
						$show_box_weight = ' (' . $shipping_num_boxes . ' ' . TEXT_SHIPPING_BOXES . ')';
					break;
					case (2):
						$show_box_weight = ' (' . number_format($ups_shipping_weight * $shipping_num_boxes,2) . $text_shipping_weight . ')';
					break;
					default:
						$show_box_weight = ' (' . $shipping_num_boxes . ' x ' . number_format($ups_shipping_weight,2) . $text_shipping_weight . ')';
					break;
				}
				$methods = array();
				$allowed_methods = explode(", ", $module_shipping_ups_types);
				$qsize = sizeof($upsQuote);
				for ($i=0; $i<$qsize; $i++)
				{
					list($type, $cost) = each($upsQuote[$i]);
					// BOF: UPS USPS
					if ($type=='STD')
					{
						if ($std_rcd) continue;
						else $std_rcd = true;
					}
					if (!in_array($type, $allowed_methods)) continue;
					// EOF: UPS USPS
					$methods[] = array('id' => $type,
					'title' => $ups_types[$type],
					'cost' => ($cost + $module_shipping_handling) * $shipping_num_boxes);
				}
				//print_r($methods);exit;
				/*}
				$array_count = count($methods);
				payment calculation based on currency type
				//$currency_attributes = displayCurrencyType();
				//$totaltopay = number_format(($currency_attributes[1] * getCartTotal($userid)),2,".","");
				if($_SESSION['SESS_SHIPPING'] == 1)
				{
				
				$output = "<br>
				<fieldset>
				<table cellpadding='0' cellspacing='0' width='100%'>
				<tr>
				<td><b>United Parcel Service&nbsp;".$show_box_weight."</b></td>
				</tr>
				<tr>
				<td>&nbsp;</td>
				</tr>
				<tr>
				<td><b>Product Name&nbsp;:&nbsp;".$product_name."</b></td>
				</tr>
				<tr>
				<td>&nbsp;</td>
				</tr>";
				
				
				}
				else
				{
				
				$output = "";
				
				}				
				
				
				for($i=0;$i<=$array_count-1;$i++)
				{
				
				if($_SESSION['SESS_SHIPPING'] == 1)
				{
				
				
				if($i<=0)
				{
				
				$shipping_checked = "checked";
				(isset($_SESSION['SESS_ShippingProduct']))?session_unregister('SESS_ShippingProduct'):session_register('SESS_ShippingProduct');
				(isset($_SESSION['SESS_ShippingType']))?session_unregister('SESS_ShippingType'):session_register('SESS_ShippingType');
				(isset($_SESSION['SESS_ShippingCost']))?session_unregister('SESS_ShippingCost'):session_register('SESS_ShippingCost');
				(isset($_SESSION['SESS_ShippingWeight']))?session_unregister('SESS_ShippingWeight'):session_register('SESS_ShippingWeight');
				$_SESSION['SESS_ShippingProduct'] = $product_id;
				$_SESSION['SESS_ShippingType'] 	  = $methods[$i][title];
				$_SESSION['SESS_ShippingCost']    = $methods[$i][cost];
				$_SESSION['SESS_ShippingWeight']  = number_format($ups_shipping_weight,2);
				
				}
				else
				{
				$shipping_checked = "";
				
				
				}
				
				if($calculate_shipping == 1)
				{
				
				$output .= "<tr>
				<td>".$methods[$i][title]."&nbsp;:&nbsp;".$methods[$i][cost]."</td>
				</tr>";
				
				}
				else
				{
				
				$output .= "<tr>
				<td><input type='radio' ".$shipping_checked." onclick=storeValue('".str_replace(' ','',$methods[$i][title])."','".$methods[$i][cost]."','".number_format($ups_shipping_weight,2)."','".$product_id."'); name='shipping_type_pick_".$product_id."' value ='".$methods[$i][title]."'>".$methods[$i][title]."&nbsp;:&nbsp;".$methods[$i][cost]."</td>
				</tr>";
				}			
				
				
				}
				else
				{
				
				$output .= "United Parcel Service&nbsp;".$show_box_weight."
				&nbsp;(".$methods[$i][title].")&nbsp;:&nbsp;".$methods[$i][cost]."<br>";
				
				}								
				
				//echo "United Parcel Service&nbsp;(".$shipping_num_boxes ."&nbsp;*&nbsp;". $ups_shipping_weight."&nbsp;".$text_shipping_weight.")&nbsp;(".$methods[$i][title].")&nbsp;:-&nbsp;";
				//echo $methods[$i][cost]."<br>";
				
				}
				
				if($_SESSION['SESS_SHIPPING'] == 1)
				{
				
				$output .= "<input type='hidden' name='shipping_count_".$product_id."' id='shipping_count_".$product_id."' value='$array_count'></table></fieldset>";
				
				}
				
				
				if($show_box_weight == "")
				{
				$output = "1";	/*----------return 1 if no shipping cost available------
				}*/
			}
			if(!empty($methods))
				return $methods;
			else
				return false;
		}

/*function used to connect to ups server and fetch the details*/

	function getUpsDetails($ups_action_code,$prod,$origin_country,$origin_postal,$destination_postal,
	$destination_country,$ups_shipping_weight,$rate_chart,$container_code,$res_code)
	{
		/*global $ups_shipping_weight,$ups_action_code,$prod,$origin_country,$origin_postal,$destination_postal,
		$destination_country,$ups_shipping_weight,$rate_chart,$container_code,$res_code;*/
		
		
		
		$request = join('&',array('accept_UPS_license_agreement=yes',
		'10_action='.$ups_action_code,
		'13_product='.$prod,
		'14_origCountry='.$origin_country,
		'15_origPostal='.$origin_postal,
		'19_destPostal='.$destination_postal,
		'22_destCountry='.$destination_country,
		'23_weight='.$ups_shipping_weight,
		'47_rate_chart='.$rate_chart,
		'48_container='.$container_code,
		'49_residential='.$res_code));								
		
		//$http = new httpClient();
		
		if ($this->Httpclient->Connect('www.ups.com', 80))
		{
			$this->Httpclient->addHeader('Host', 'www.ups.com');
			$this->Httpclient->addHeader('User-Agent', 'Multicart');
			$this->Httpclient->addHeader('Connection', 'Close');
		
			if ($this->Httpclient->Get('/using/services/rave/qcostcgi.cgi?' . $request))
				$body = $this->Httpclient->getBody();
				$this->Httpclient->Disconnect();
			}
			else
			{
				return 'error';
			}
		
			$body_array = explode("\n", $body);
			$returnval = array();
			$errorret = 'error'; // only return 'error' if NO rates returned
		
			$n = sizeof($body_array);
			for ($i=0; $i<$n; $i++) {
				$result = explode('%', $body_array[$i]);
				$errcode = substr($result[0], -1);
		
				switch ($errcode)
				{
					case 3:
						if (is_array($returnval)) 
							$returnval[] = array($result[1] => $result[10]);
					break;
					case 4:
						if (is_array($returnval))
							$returnval[] = array($result[1] => $result[10]);
					break;
					case 5:
						$errorret = $result[1];
					break;
					case 6:
						if (is_array($returnval))
							$returnval[] = array($result[3] => $result[10]);
					break;
				}
		}
		if (empty($returnval)) 
			$returnval = $errorret;
		return $returnval;
	}
}
?>