<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/

// +----------------------------------------------------------------------+

// | PHP version 4/5                                                      |

// +----------------------------------------------------------------------+

// | Copyright (c) 2004-2010 ARMIA INC                                    |

// +----------------------------------------------------------------------+

// | This source file is a part of iScripts VistaCart                     |

// +----------------------------------------------------------------------+

// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |

// +----------------------------------------------------------------------+

App::import('Sanitize');

class SentnewslettersController extends AppController

{

    var $name = "Sentnewsletter";

    var $helpers = array('Html', 'Form','Pagination');   

	var $components = array ('Pagination','Catmenu','History','Email'); // Added

	var $uses = array('SentNewsletter','Newsletter','Newsletteruser'); 

	var $paginate = array('limit' => 25,'order' => array('SentNewsletter.newsletter_id' => 'asc'));

	

    function show($id='')

    {

       $this->__validateLoginStatus(); 

	   $admsess	=	$this->Session->read('Admin');

		if($admsess["sentnewsletters"] <> 1){

			$this->redirect(array('controller' => 'admins', 'action' => 'index')); 

			exit();

		}

		$cmbSearchType	=	"";

		$txtSearch		=	"";

		if(isset($_GET["cmbSearchType"]) && isset($_GET["txtSearch"])){

			$cmbSearchType	=	$_GET["cmbSearchType"];

			$txtSearch		=	$_GET["txtSearch"];

			if($cmbSearchType == "date"){

				$data = $this->paginate('SentNewsletter', array('SentNewsletter.date LIKE ' => "%".mysql_real_escape_string($txtSearch)."%"));

			}else{

				$data = $this->paginate('SentNewsletter', array('SentNewsletter.newsletter_id='.$id));

			}

		}else{

			$data = $this->paginate('SentNewsletter', array('SentNewsletter.newsletter_id='.$id));

		}

		$this->set('cmbSearchType', $cmbSearchType);

		$this->set('txtSearch', $txtSearch);

		

		$ndet=$this->Newsletter->findById($id);

		$this->set('letter_title', $ndet["Newsletter"]["title"]);	

		$this->set('letter_content', $ndet["Newsletter"]["content"]);				

		foreach($data as $key => $val)

		{		

		  $udet=$this->Newsletteruser->findById($val["SentNewsletter"]["user_id"]);				

		  $data[$key]["SentNewsletter"]["username"]=$udet["Newsletteruser"]["uname"];

		  $data[$key]["SentNewsletter"]["email"]=$udet["Newsletteruser"]["email"];

		} 

		$this->set('data', $data);		

		$this->set('id',$id);

		$this->layout = 'adm'; 

    } 

    function beforeFilter()

    {

        if (isset($this->Setting) && !empty($this->Setting->table))  

        {  

             $this->Setting->load();  

        } 

		global $sitefolder; 

		global $meta_description;

		global $meta_keywords;

		global $page_title;

		$cnfg 				=	Configure::read('Neutrino');

		$sitefolder			=	$cnfg["sitebasefolder"];

		$meta_description	=	$cnfg["meta_description"];

		$meta_keywords		=	$cnfg["meta_keywords"];

		$page_title			=	$cnfg["page_title"];

		global $style; 

		$style				=	$cnfg["style"];

		$this->set('style', $style);

		$this->set('meta_description', $meta_description);

		$this->set('meta_keywords', $meta_keywords);

		$this->pageTitle = $page_title	; 

		$this->set('cnfg',$cnfg);

		$this->paginate["limit"]=$cnfg["items_perpage"]; //Setting pagination limit per page.

    }

	function beforeRender(){				

		

	}

	

	function add() {

		$this->__validateLoginStatus();

		$admsess	=	$this->Session->read('Admin');

		if($admsess["newsletterusers"] <> 1){

		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 

			exit();

		}

		if (!empty($this->data)) {

		        $this->data["Newsletteruser"]["sub_date"]= date('Y-m-d h:i:s');

				if ($this->Newsletteruser->save($this->data)) {

					$this->Session->setFlash(__('Subscriber has been saved successfully!', true));

			        $this->redirect(array('controller' => 'newsletterusers','action'=>'index'));

					exit;

				}

		}

		$this->layout = 'adm';

	}

	

		function edit($id=0) {

		if($id == 0){

			$this->redirect(array('controller' => 'newsletterusers','action'=>'index'));

			exit();

		}

		$this->__validateLoginStatus();

		$admsess	=	$this->Session->read('Admin');

		if($admsess["newsletterusers"] <> 1){

		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 

			exit();

		}

		$this->Newsletteruser->id = $id; 

		if (!empty($this->data)) {

			$this->data["Newsletteruser"]["sub_date"]= date('Y-m-d h:i:s');

				if ($this->Newsletteruser->save($this->data)) {

					$this->Session->setFlash(__('Subscriber details has been updated successfully!', true));

			        $this->redirect(array('controller' => 'newsletterusers','action'=>'index'));

					exit;

				}

		}else{

			$this->data = $this->Newsletteruser->read();			

		}

		$this->layout = 'adm';

	} 

	

	function setStatus($uid='',$status='')

	{

	    $this->Newsletteruser->id = $uid;

		$this->Newsletteruser->saveField('status',$status);

	    $this->Session->setFlash(__('Subscriber status has been updated successfully!', true));

	    $this->redirect(array('controller' => 'newsletterusers','action'=>'index'));

	}

	

	function delete($delid='')

	{

	  if($delid==''){

			$this->redirect(array('controller' => 'newsletterusers','action'=>'index'));

			exit();

		}

	  if($this->Newsletteruser->del($delid)){

			$this->Session->setFlash(__('Subscriber has been deleted Successfully.', true));

			$this->redirect(array('controller' => 'newsletterusers','action'=>'index'));

			exit;

		   }

	}	   

	

	

    function __validateLoginStatus($typ='A')

    {

           if($typ == 'A'){

				if($this->Session->check('Admin') == false)

				{

					$this->redirect(array('controller' => 'admins', 'action' => 'login')); 

					 $this->Session->setFlash(__('The URL you\'ve followed requires you login.'));

				}

			}else{

				if($this->Session->check('Userlog') == false)

				{

					$this->redirect(array('controller' => 'users', 'action' => 'login')); 

					 $this->Session->setFlash(__('The URL you\'ve followed requires you login.'));

				}

			}

    } 	

}

?>