<?php
/* SVN FILE: $Id: pages_controller.php 7118 2008-06-04 20:49:29Z gwoo $ */
/**
 * Static content controller.
 *
 * This file will render views from views/pages/
 *
 * PHP versions 4 and 5
 *
 * CakePHP(tm) :  Rapid Development Framework <http://www.cakephp.org/>
 * Copyright 2005-2008, Cake Software Foundation, Inc.
 *								1785 E. Sahara Avenue, Suite 490-204
 *								Las Vegas, Nevada 89104
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @copyright		Copyright 2005-2008, Cake Software Foundation, Inc.
 * @link				http://www.cakefoundation.org/projects/info/cakephp CakePHP(tm) Project
 * @package			cake
 * @subpackage		cake.cake.libs.controller
 * @since			CakePHP(tm) v 0.2.9
 * @version			$Revision: 7118 $
 * @modifiedby		$LastChangedBy: gwoo $
 * @lastmodified	$Date: 2008-06-04 13:49:29 -0700 (Wed, 04 Jun 2008) $
 * @license			http://www.opensource.org/licenses/mit-license.php The MIT License
 */
/**
 * Static content controller
 *
 * Override this controller by placing a copy in controllers directory of an application
 *
 * @package		cake
 * @subpackage	cake.cake.libs.controller
 */
class PagesController extends AppController {
/**
 * Controller name
 *
 * @var string
 * @access public
 */
	var $name = 'Pages';
/**
 * Default helper
 *
 * @var array
 * @access public
 */
	var $helpers = array('Html');
/**
 * This controller does not use a model
 *
 * @var array
 * @access public
 */
	var $uses = array('Product','Category','Cmspage','Rating','Currency','Customfield','Homelayout','Giftcard','Cart');
/**
 * Displays a view
 *
 * @param mixed What page to display
 * @access public
 */
 var $components = array ('Catmenu');
	function beforeRender(){
				//$lst	=	$this->Catmenu->getCatList(1);
				//$this->set('catmenu', $lst);
						//Code Added By shyam for Category Menu Listing starts here..
		// $lst	=	$this->Category->findAll();
                 $lst	=	$this->Category->findAll(null, NULL, 'Category.cname ASC', null, null);
               
		 if(empty($lst)===false)
		 {
		   foreach($lst as $det)
		   $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"]);
		   $this->set('menu_array', $menu_array);		
		 }  
		//Code Added By shyam for Category Menu Listing ends here..
		$footer_links = $this->Cmspage->find('list',array('conditions' => array('Cmspage.type' => 'content','Cmspage.status' => 'Y')));	
		$this->set('footerlinks', $footer_links);


                
	}
	 function beforeFilter()
    {
       if (isset($this->Setting) && !empty($this->Setting->table))  
        {  
             $this->Setting->load();  
        } 
		global $sitefolder; 
		global $meta_description;
		global $meta_keywords;
		global $page_title;
		global $currency;
		$cnfg 				=	Configure::read('Neutrino');
		$sitefolder			=	$cnfg["sitebasefolder"];
		$meta_description	=	$cnfg["meta_description"];
		$meta_keywords		=	$cnfg["meta_keywords"];
		$page_title			=	$cnfg["page_title"];
		$currency			=	$cnfg["currency"];
		global $style; 
		$style				=	$cnfg["style"];
		$this->set('style', $style);
		$this->set('meta_description', $meta_description);
		$this->set('meta_keywords', $meta_keywords);
		$this->pageTitle = $page_title	; 
		$this->set('cnfg',$cnfg);

                //get cart count

        $sus = $this->Session->read();



       //get cart count
        if ($this->Session->check('Userlog') === true) {
            $userid = $sus["Userlog"]["id"];
            $cartCount = $this->Cart->getCartCount($userid,'user');
        }else {
            $sessid = $this->Session->id();
            $cartCount = $this->Cart->getCartCount($sessid,'G');
        }
        $this->set('cartcount',$cartCount);

                //cart count ends
    }
	function display() {
		$path = func_get_args();

		if (!count($path)) {
			$this->redirect('/');
		}
		$count = count($path);
		$page = $subpage = $title = null;

		if (!empty($path[0])) {
			$page = $path[0];
		}
		if (!empty($path[1])) {
			$subpage = $path[1];
		}
		if (!empty($path[$count - 1])) {
			$title = Inflector::humanize($path[$count - 1]);
		}
		
		
		
		//Featured Products
		$criteriaf ="Product.status = 'A' AND Product.featured = '1' AND Product.stock > 0";
		$feat	=	$this->Product->findAll($criteriaf, NULL, 'order by rand() ',6, 1);
		for($c=0; $c < sizeof($feat); $c++){
			if(isset($feat[$c]["Productimages"][0]["imagename"])){
				$defimg	=	$feat[$c]["Productimages"][0]["imagename"];
				for($m=0; $m < sizeof($feat[$c]["Productimages"]); $m++){
					if($feat[$c]["Productimages"][$m]["default_img"] == "Y"){
						$defimg	=	$feat[$c]["Productimages"][$m]["imagename"];
					}
				}
				$feat[$c]["Productimages"]	=	$defimg;
			}else{
				$feat[$c]["Productimages"]	= '';
			}
			
		}
		$featpo	=	$this->Homelayout->findByProdType("featured");
                
		if($featpo["Homelayout"]["status"] == "Y"){
			$this->set($featpo["Homelayout"]["section"].$featpo["Homelayout"]["ordering"],$feat);
			$this->set($featpo["Homelayout"]["section"].$featpo["Homelayout"]["ordering"].'title','Featured Products');
		}
		
		
		
		//Latest Products
		$criteria="Product.status = 'A' AND Product.stock > 0 ";
		$latest = $this->Product->findAll($criteria, NULL, 'Product.id DESC',6, 1); // Extra parameters added 
		for($c=0; $c < sizeof($latest); $c++){
				if(isset($latest[$c]["Productimages"][0]["imagename"])){
				$defimg	=	$latest[$c]["Productimages"][0]["imagename"];
				for($m=0; $m < sizeof($latest[$c]["Productimages"]); $m++){
					if($latest[$c]["Productimages"][$m]["default_img"] == "Y"){
						$defimg	=	$latest[$c]["Productimages"][$m]["imagename"];
					}
				}
				$latest[$c]["Productimages"]	=	$defimg;
			}else{
				$latest[$c]["Productimages"]	= '';
			}
			
		}
                
		$latestpo	=	$this->Homelayout->findByProdType("latest");
		if($latestpo["Homelayout"]["status"] == "Y"){
			$this->set($latestpo["Homelayout"]["section"].$latestpo["Homelayout"]["ordering"],$latest);
			$this->set($latestpo["Homelayout"]["section"].$latestpo["Homelayout"]["ordering"].'title','Latest Products');
		}
		
		
		
		//Top rated Products
		$toprate	=	$this->Rating->toprated();               
		$toppo	=	$this->Homelayout->findByProdType("toprated");
                
               
		if($toppo["Homelayout"]["status"] == "Y"){
			$this->set($toppo["Homelayout"]["section"].$toppo["Homelayout"]["ordering"],$toprate);
			$this->set($toppo["Homelayout"]["section"].$toppo["Homelayout"]["ordering"].'title','Top Rated');
		}
		
		
		
		//Onsale Products
		$criteria="Product.status = 'A' and Product.discount > 0 AND Product.stock > 0";
		$onsale = $this->Product->findAll($criteria, NULL, 'Product.id DESC',6, 1); // Extra parameters added 
		for($c=0; $c < sizeof($onsale); $c++){
				if(isset($onsale[$c]["Productimages"][0]["imagename"])){
				$defimg	=	$onsale[$c]["Productimages"][0]["imagename"];
				for($m=0; $m < sizeof($onsale[$c]["Productimages"]); $m++){
					if($onsale[$c]["Productimages"][$m]["default_img"] == "Y"){
						$defimg	=	$onsale[$c]["Productimages"][$m]["imagename"];
					}
				}
				$onsale[$c]["Productimages"]	=	$defimg;
			}else{
				$onsale[$c]["Productimages"]	= '';
			}
			
		}
               
		$onsalepo	=	$this->Homelayout->findByProdType("onsale");
                
		if($onsalepo["Homelayout"]["status"] == "Y"){
			$this->set($onsalepo["Homelayout"]["section"].$onsalepo["Homelayout"]["ordering"],$onsale);
			$this->set($onsalepo["Homelayout"]["section"].$onsalepo["Homelayout"]["ordering"].'title','Products on Sale');
		}
		
		
		//Setting Gift Cards
		$giftcard= $this->Giftcard->findAll();	
		$this->set('giftcard',$giftcard);
		//Setting Gift Cards

        $sus	=	$this->Session->read('Userlog');		
		if(isset($sus) && empty($sus)===false)
		{		
		  $this->set('sus', $sus);
		}  
		
		
		global $currency;
		$curr		=	$this->Currency->findByCode($currency);
		$this->set('curlogo',$curr["Currency"]["logo"]);
		$this->set(compact('page', 'subpage', 'title'));
		global $page_title;
		$this->pageTitle = $page_title;
		$this->layout = 'default_home';
		$this->render(join('/', $path));		
	}
}

?>