DROP TABLE IF EXISTS `cms_groups`;
CREATE TABLE IF NOT EXISTS `cms_groups` (
  `id` int(11) NOT NULL auto_increment,
  `group_name` varchar(50) default NULL,
  `position` int(3) default '0',
  `published` tinyint(1) default '1',
  `user_privilege` varchar(256) NOT NULL default 'all',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `cms_sections`;
CREATE TABLE IF NOT EXISTS `cms_sections` (
  `id` int(8) NOT NULL auto_increment,
  `group_id` int(8) default NULL,
  `section_name` varchar(200) default NULL,
  `section_alias` varchar(200) default NULL,
  `table_name` varchar(100) default NULL,
  `section_config` text,
  `visibilty` enum('0','1') NOT NULL,
  `display_order` int(11) NOT NULL,
  `user_privilege` varchar(256) NOT NULL default 'all',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `cms_users`;
CREATE TABLE IF NOT EXISTS `cms_users` (
  `id` int(11) NOT NULL auto_increment,
  `type` enum('sadmin','admin') NOT NULL,
  `username` varchar(256) NOT NULL,
  `password` varchar(256) NOT NULL,
  `status` enum('active','deleted') NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;


DROP TABLE IF EXISTS `goStores_sessions`;
CREATE TABLE IF NOT EXISTS `sessions` (
  `session_id` varchar(100) NOT NULL default '',
  `session_data` text NOT NULL,
  `expires` int(11) NOT NULL default '0',
  PRIMARY KEY  (`session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `dummy`;
CREATE TABLE IF NOT EXISTS `dummy` (
  `num` int(11) NOT NULL default '0',
  PRIMARY KEY  (`num`),
  KEY `dnumindex` (`num`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `sptbl_actionlog`;
CREATE TABLE IF NOT EXISTS `sptbl_actionlog` (
  `nALId` bigint(20) NOT NULL auto_increment,
  `nStaffId` bigint(20) default '0',
  `nUserId` bigint(20) default '0',
  `vAction` varchar(100) NOT NULL default '',
  `vArea` varchar(100) NOT NULL default '',
  `nRespId` varchar(100) NOT NULL default '0',
  `dDate` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`nALId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_attachments`;
CREATE TABLE IF NOT EXISTS `sptbl_attachments` (
  `nAttachId` bigint(20) NOT NULL auto_increment,
  `nTicketId` bigint(20) default NULL,
  `nReplyId` bigint(20) default NULL,
  `vAttachReference` varchar(100) NOT NULL default '',
  `vAttachUrl` text NOT NULL,
  PRIMARY KEY  (`nAttachId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_cannedmessages`;
CREATE TABLE IF NOT EXISTS `sptbl_cannedmessages` (
  `nMsgId` int(11) NOT NULL auto_increment,
  `dDate` date default '0000-00-00',
  `vTitle` varchar(100) default NULL,
  `vDescription` varchar(250) default NULL,
  `nStaffId` bigint(20) default NULL,
  `vStatus` char(1) default '0',
  PRIMARY KEY  (`nMsgId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_categories`;
CREATE TABLE IF NOT EXISTS `sptbl_categories` (
  `nCatId` bigint(20) NOT NULL auto_increment,
  `nDeptId` bigint(20) NOT NULL default '0',
  `vCatDesc` varchar(100) NOT NULL default '',
  `nParentId` bigint(20) NOT NULL default '0',
  `vRoute` varchar(100) NOT NULL default '',
  `nCount` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`nCatId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_chat`;
CREATE TABLE IF NOT EXISTS `sptbl_chat` (
  `nChatId` bigint(20) NOT NULL auto_increment,
  `dTimeStart` datetime default '0000-00-00 00:00:00',
  `nUserId` bigint(20) default '0',
  `vUserName` varchar(100) default NULL,
  `nStaffId` bigint(20) NOT NULL default '0',
  `tMatter` text,
  `dTimeEnd` datetime NOT NULL default '0000-00-00 00:00:00',
  `vStatus` varchar(10) default NULL,
  `vNewMsg` char(1) NOT NULL default '1',
  `nDeptId` bigint(20) default NULL,
  PRIMARY KEY  (`nChatId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_chattransfer`;
CREATE TABLE IF NOT EXISTS `sptbl_chattransfer` (
  `nTransferId` bigint(20) NOT NULL auto_increment,
  `nChatId` bigint(20) NOT NULL default '0',
  `nFirstStaff` bigint(20) NOT NULL default '0',
  `nSecondStaff` bigint(20) NOT NULL default '0',
  `vStatus` varchar(10) default NULL,
  PRIMARY KEY  (`nTransferId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_companies`;
CREATE TABLE IF NOT EXISTS `sptbl_companies` (
  `nCompId` bigint(20) NOT NULL auto_increment,
  `vCompName` varchar(100) default NULL,
  `vCompAddress1` varchar(100) default NULL,
  `vCompAddress2` varchar(100) default NULL,
  `vCompCity` varchar(100) default NULL,
  `vCompState` varchar(100) default NULL,
  `nCompZip` varchar(25) default NULL,
  `vCompCountry` varchar(100) default NULL,
  `vCompPhone` varchar(20) default NULL,
  `vCompFax` varchar(20) default NULL,
  `vCompMail` varchar(100) default NULL,
  `vCompContact` varchar(100) NOT NULL default '',
  `vDelStatus` char(1) default '0',
  `vChatWelcomeMessage` varchar(128) default 'Welcome',
  `vChatIcon` char(1) default '1',
  `vChatOperatorRating` char(1) default '0',
  PRIMARY KEY  (`nCompId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;


DROP TABLE IF EXISTS `sptbl_css`;
CREATE TABLE IF NOT EXISTS `sptbl_css` (
  `nCSSId` bigint(20) NOT NULL auto_increment,
  `vCSSName` varchar(50) default NULL,
  `vCSSURL` text NOT NULL,
  `dDate` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`nCSSId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=11 ;


DROP TABLE IF EXISTS `sptbl_depts`;
CREATE TABLE IF NOT EXISTS `sptbl_depts` (
  `nDeptId` bigint(20) NOT NULL auto_increment,
  `nCompId` bigint(20) NOT NULL default '0',
  `vDeptDesc` varchar(100) NOT NULL default '',
  `nDeptParent` bigint(20) NOT NULL default '0',
  `vDeptMail` varchar(100) default NULL,
  `vDeptCode` varchar(6) NOT NULL default '',
  `nResponseTime` int(11) default '0',
  PRIMARY KEY  (`nDeptId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;


DROP TABLE IF EXISTS `sptbl_desktop_share`;
CREATE TABLE IF NOT EXISTS `sptbl_desktop_share` (
  `nShareId` bigint(20) NOT NULL auto_increment,
  `nChatId` bigint(20) default NULL,
  `vClientIp` varchar(25) default NULL,
  `vStatus` varchar(15) default NULL,
  `Screenshot` text,
  PRIMARY KEY  (`nShareId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_downloads`;
CREATE TABLE IF NOT EXISTS `sptbl_downloads` (
  `nDLId` bigint(20) NOT NULL auto_increment,
  `vDescription` varchar(100) NOT NULL default '',
  `vURL` text NOT NULL,
  `dPostdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `vType` char(1) NOT NULL default '2',
  PRIMARY KEY  (`nDLId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_escalationrules`;
CREATE TABLE IF NOT EXISTS `sptbl_escalationrules` (
  `nERId` int(11) NOT NULL auto_increment,
  `vRuleName` varchar(256) NOT NULL,
  `nCompId` int(11) NOT NULL,
  `nDeptId` int(11) NOT NULL,
  `eRespTimeSetting` enum('Y','N') NOT NULL default 'N',
  `eRespCountSetting` enum('Y','N') NOT NULL default 'N',
  `nResponseTime` int(11) NOT NULL,
  `nResponseCount` int(11) NOT NULL,
  `nStaffId` int(11) NOT NULL,
  `nStatus` int(11) NOT NULL COMMENT '0=>Active, 1=>Inactive',
  PRIMARY KEY  (`nERId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_feedback`;
CREATE TABLE IF NOT EXISTS `sptbl_feedback` (
  `nFBId` bigint(20) NOT NULL auto_increment,
  `nTicketId` bigint(20) NOT NULL default '0',
  `vFBTitle` varchar(100) NOT NULL default '',
  `tFBDesc` text NOT NULL,
  `dDate` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`nFBId`),
  KEY `fddateindex` (`dDate`),
  KEY `fdticketidindex` (`nTicketId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_fields`;
CREATE TABLE IF NOT EXISTS `sptbl_fields` (
  `nFieldId` bigint(20) NOT NULL auto_increment,
  `vFieldName` varchar(100) NOT NULL default '',
  `vFieldDesc` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`nFieldId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=9 ;


DROP TABLE IF EXISTS `sptbl_follow_tickets`;
CREATE TABLE IF NOT EXISTS `sptbl_follow_tickets` (
  `nFollowId` int(11) NOT NULL auto_increment,
  `nTicketId` int(11) NOT NULL,
  `nStaffId` int(11) NOT NULL,
  `vStaffType` char(1) NOT NULL default 'U',
  PRIMARY KEY  (`nFollowId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_kb`;
CREATE TABLE IF NOT EXISTS `sptbl_kb` (
  `nKBID` bigint(20) NOT NULL auto_increment,
  `nCatId` bigint(20) NOT NULL default '0',
  `nStaffId` bigint(20) NOT NULL default '0',
  `vKBTitle` varchar(250) NOT NULL default '',
  `tKBDesc` mediumtext NOT NULL,
  `dDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `vStatus` char(1) NOT NULL default 'A',
  `vMetaTage_keyword` text NOT NULL,
  `vMetaTage_desc` text NOT NULL,
  PRIMARY KEY  (`nKBID`),
  FULLTEXT KEY `vKBTitle` (`vKBTitle`,`tKBDesc`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_kb_rating`;
CREATE TABLE IF NOT EXISTS `sptbl_kb_rating` (
  `sKBRId` bigint(20) NOT NULL auto_increment,
  `nKBID` bigint(20) NOT NULL,
  `nUserId` bigint(20) NOT NULL,
  `nMarks` bigint(20) NOT NULL,
  PRIMARY KEY  (`sKBRId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_labels`;
CREATE TABLE IF NOT EXISTS `sptbl_labels` (
  `nLabelId` bigint(20) NOT NULL auto_increment,
  `vLabelname` varchar(100) default NULL,
  `nStaffId` bigint(20) default NULL,
  PRIMARY KEY  (`nLabelId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_lang`;
CREATE TABLE IF NOT EXISTS `sptbl_lang` (
  `vLangCode` varchar(10) NOT NULL default '',
  `VLangDesc` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`vLangCode`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `sptbl_lookup`;
CREATE TABLE IF NOT EXISTS `sptbl_lookup` (
  `nLookUpId` bigint(20) NOT NULL auto_increment,
  `vLookUpName` varchar(100) NOT NULL default '',
  `vLookUpValue` text NOT NULL,
  PRIMARY KEY  (`nLookUpId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=128 ;


DROP TABLE IF EXISTS `sptbl_news`;
CREATE TABLE IF NOT EXISTS `sptbl_news` (
  `nNewsId` bigint(20) NOT NULL auto_increment,
  `vTitle` varchar(100) NOT NULL default '',
  `tNews` text NOT NULL,
  `dPostdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `dVaildDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `vType` char(1) NOT NULL default 'S',
  PRIMARY KEY  (`nNewsId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_operatorchat`;
CREATE TABLE IF NOT EXISTS `sptbl_operatorchat` (
  `nChatId` bigint(20) NOT NULL auto_increment,
  `dTimeStart` datetime default '0000-00-00 00:00:00',
  `nFirstStaffId` bigint(20) default '0',
  `nSecondStaffId` bigint(20) NOT NULL default '0',
  `tMatter` text,
  `dTimeEnd` datetime NOT NULL default '0000-00-00 00:00:00',
  `vStatus` varchar(10) default NULL,
  `vNewMsg` char(1) NOT NULL default '1',
  `vChatSts` char(1) default NULL,
  PRIMARY KEY  (`nChatId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_personalnotes`;
CREATE TABLE IF NOT EXISTS `sptbl_personalnotes` (
  `nPNId` bigint(20) NOT NULL auto_increment,
  `nStaffId` bigint(20) NOT NULL default '0',
  `nTicketId` bigint(20) NOT NULL default '0',
  `vStaffLogin` varchar(100) default NULL,
  `vPNTitle` varchar(100) NOT NULL default '',
  `tPNDesc` text NOT NULL,
  `dDate` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`nPNId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_pop3settings`;
CREATE TABLE IF NOT EXISTS `sptbl_pop3settings` (
  `nPop3Id` bigint(20) NOT NULL auto_increment,
  `nDeptId` bigint(20) NOT NULL default '0',
  `vDeptEmail` varchar(100) NOT NULL default '',
  `vServerName` varchar(200) NOT NULL default '',
  `vUserName` varchar(100) NOT NULL default '',
  `vPassword` varchar(100) NOT NULL default '',
  `nPortNo` bigint(10) NOT NULL default '0',
  PRIMARY KEY  (`nPop3Id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_priorities`;
CREATE TABLE IF NOT EXISTS `sptbl_priorities` (
  `nPriorityId` bigint(20) NOT NULL auto_increment,
  `nPriorityValue` bigint(20) NOT NULL default '0',
  `vPriorityDesc` varchar(100) NOT NULL default '0',
  `vTicketColor` varchar(10) NOT NULL default '#FFFFFF',
  `vPrioritie_icon` varchar(255) NOT NULL,
  PRIMARY KEY  (`nPriorityId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=10 ;


DROP TABLE IF EXISTS `sptbl_pvtmessages`;
CREATE TABLE IF NOT EXISTS `sptbl_pvtmessages` (
  `nPMId` bigint(20) NOT NULL auto_increment,
  `vPMTitle` varchar(100) NOT NULL default '',
  `tPMDesc` text NOT NULL,
  `nFrmStaffId` bigint(20) NOT NULL default '0',
  `nToStaffId` bigint(20) NOT NULL default '0',
  `dDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `vStatus` char(1) NOT NULL default 'o',
  PRIMARY KEY  (`nPMId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_reminders`;
CREATE TABLE IF NOT EXISTS `sptbl_reminders` (
  `nRemId` bigint(20) NOT NULL auto_increment,
  `nStaffId` bigint(20) default '0',
  `vRemTitle` varchar(100) NOT NULL default '',
  `tRemDesc` text NOT NULL,
  `dRemAlert` datetime NOT NULL default '0000-00-00 00:00:00',
  `dRemPost` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`nRemId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_replies`;
CREATE TABLE IF NOT EXISTS `sptbl_replies` (
  `nReplyId` bigint(20) NOT NULL auto_increment,
  `nTicketId` bigint(20) NOT NULL default '0',
  `nStaffId` bigint(20) default NULL,
  `nUserId` bigint(20) default NULL,
  `vStaffLogin` varchar(100) default NULL,
  `dDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `tReply` mediumtext NOT NULL,
  `tPvtMessage` text,
  `vReplyTime` bigint(20) NOT NULL default '0',
  `vDelStatus` char(1) NOT NULL default '0',
  `vMachineIP` varchar(20) default '0.0.0.0',
  `nHold` tinyint(4) default '0',
  `nReplyStatus` varchar(50) default NULL,
  PRIMARY KEY  (`nReplyId`),
  KEY `ddateindex` (`dDate`),
  KEY `rnuserindex` (`nUserId`),
  KEY `rnstaffindex` (`nStaffId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_rules`;
CREATE TABLE IF NOT EXISTS `sptbl_rules` (
  `nRuleId` bigint(20) NOT NULL auto_increment,
  `vRuleName` varchar(100) NOT NULL default '',
  `nSearchTitle` tinyint(4) NOT NULL default '0',
  `nSearchBody` tinyint(4) NOT NULL default '0',
  `vSearchWords` text NOT NULL,
  `nStaffId` bigint(20) NOT NULL default '0',
  `nDeptId` bigint(20) NOT NULL default '0',
  `dDateCreated` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`nRuleId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_spam_categories`;
CREATE TABLE IF NOT EXISTS `sptbl_spam_categories` (
  `category_id` varchar(250) NOT NULL default '',
  `probability` double NOT NULL default '0',
  `word_count` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `sptbl_spam_references`;
CREATE TABLE IF NOT EXISTS `sptbl_spam_references` (
  `id` varchar(250) NOT NULL default '',
  `category_id` varchar(250) NOT NULL default '',
  `content` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `category_id` (`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `sptbl_spam_tickets`;
CREATE TABLE IF NOT EXISTS `sptbl_spam_tickets` (
  `nSpamTicketId` bigint(20) NOT NULL auto_increment,
  `vuseremail` varchar(100) default NULL,
  `nDeptId` bigint(20) NOT NULL default '0',
  `vTitle` varchar(100) NOT NULL default '0',
  `tQuestion` mediumtext NOT NULL,
  `dPostDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `vMachineIP` varchar(20) default '0.0.0.0',
  `tcontent` text,
  PRIMARY KEY  (`nSpamTicketId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_spam_wordfreqs`;
CREATE TABLE IF NOT EXISTS `sptbl_spam_wordfreqs` (
  `word` varchar(250) NOT NULL default '',
  `category_id` varchar(250) NOT NULL default '',
  `count` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`word`,`category_id`),
  KEY `categoryindex` (`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `sptbl_staffdept`;
CREATE TABLE IF NOT EXISTS `sptbl_staffdept` (
  `nStaffId` bigint(20) NOT NULL default '0',
  `nDeptId` bigint(20) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `sptbl_stafffields`;
CREATE TABLE IF NOT EXISTS `sptbl_stafffields` (
  `nStaffId` bigint(20) NOT NULL default '0',
  `nFieldId` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`nStaffId`,`nFieldId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `sptbl_staffratings`;
CREATE TABLE IF NOT EXISTS `sptbl_staffratings` (
  `nSRId` bigint(20) NOT NULL auto_increment,
  `nUserId` bigint(20) NOT NULL default '0',
  `nStaffId` bigint(20) NOT NULL default '0',
  `nTicketId` bigint(20) default '0',
  `tComments` text NOT NULL,
  `nMarks` tinyint(4) NOT NULL default '0',
  `vType` char(1) default 'T',
  PRIMARY KEY  (`nSRId`),
  KEY `suseridindex` (`nUserId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_staffs`;
CREATE TABLE IF NOT EXISTS `sptbl_staffs` (
  `nStaffId` bigint(20) NOT NULL auto_increment,
  `vStaffname` varchar(100) NOT NULL default '',
  `vLogin` varchar(100) NOT NULL default '',
  `vPassword` varchar(100) NOT NULL default '',
  `vOnline` char(1) NOT NULL default '0',
  `vMail` varchar(100) NOT NULL default '',
  `vYIM` varchar(100) default NULL,
  `vSMSMail` varchar(100) default NULL,
  `vMobileNo` varchar(20) default NULL,
  `nCSSId` tinyint(4) NOT NULL default '1',
  `nRefreshRate` tinyint(4) NOT NULL default '1',
  `nNotifyAssign` tinyint(4) NOT NULL default '0',
  `nNotifyPvtMsg` tinyint(4) NOT NULL default '0',
  `nNotifyKB` tinyint(4) NOT NULL default '0',
  `nNotifyArrival` tinyint(4) default '0',
  `vType` char(1) NOT NULL default 'U',
  `vDelStatus` char(1) NOT NULL default '0',
  `tSignature` tinytext,
  `nWatcher` tinyint(4) NOT NULL default '0',
  `vStaffImg` varchar(128) default NULL,
  PRIMARY KEY  (`nStaffId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;


DROP TABLE IF EXISTS `sptbl_templates`;
CREATE TABLE IF NOT EXISTS `sptbl_templates` (
  `nTemplateId` bigint(20) NOT NULL auto_increment,
  `dDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `vTemplateTitle` varchar(100) NOT NULL default '',
  `tTemplateDesc` text NOT NULL,
  `nStaffId` bigint(20) NOT NULL default '0',
  `vStatus` char(1) NOT NULL default '0',
  PRIMARY KEY  (`nTemplateId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_temp_tickets`;
CREATE TABLE IF NOT EXISTS `sptbl_temp_tickets` (
  `nTpTicketId` bigint(20) NOT NULL auto_increment,
  `nTpUserId` bigint(20) NOT NULL default '0',
  `nTDeptId` bigint(20) NOT NULL default '0',
  `vTpTitle` varchar(100) NOT NULL default '0',
  `tTpQuestion` mediumtext NOT NULL,
  `vTpPriority` bigint(20) NOT NULL default '0',
  `dTpPostDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `vAtt` text,
  `vStatus` char(2) default NULL,
  PRIMARY KEY  (`nTpTicketId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_tickets`;
CREATE TABLE IF NOT EXISTS `sptbl_tickets` (
  `nTicketId` bigint(20) NOT NULL auto_increment,
  `nDeptId` bigint(20) NOT NULL default '0',
  `vRefNo` varchar(50) NOT NULL default '',
  `nUserId` bigint(20) NOT NULL default '0',
  `vUserName` varchar(100) default NULL,
  `vStaffLogin` varchar(100) default NULL,
  `vTitle` varchar(100) NOT NULL default '0',
  `tQuestion` mediumtext NOT NULL,
  `vPriority` bigint(20) NOT NULL default '0',
  `dPostDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `vStatus` varchar(50) default 'open',
  `nOwner` bigint(20) NOT NULL default '0',
  `nLockStatus` bigint(20) default '0',
  `vDelStatus` char(1) NOT NULL default '0',
  `vMachineIP` varchar(20) default '0.0.0.0',
  `dLastAttempted` datetime default NULL,
  `nLabelId` bigint(20) NOT NULL default '0',
  `vViewers` varchar(256) NOT NULL,
  PRIMARY KEY  (`nTicketId`),
  KEY `tdateindex` (`dLastAttempted`),
  KEY `tdelindex` (`vDelStatus`),
  KEY `tnuserindex` (`nUserId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_useremail`;
CREATE TABLE IF NOT EXISTS `sptbl_useremail` (
  `nUseremailId` int(11) NOT NULL auto_increment,
  `nUserId` bigint(20) NOT NULL,
  `vEmail` varchar(255) NOT NULL,
  `vStatus` char(1) NOT NULL default 'Y',
  PRIMARY KEY  (`nUseremailId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sptbl_users`;
CREATE TABLE IF NOT EXISTS `sptbl_users` (
  `nUserId` bigint(20) NOT NULL auto_increment,
  `nCompId` bigint(20) NOT NULL default '0',
  `vUserName` varchar(100) NOT NULL default '',
  `vEmail` varchar(100) NOT NULL default '',
  `vLogin` varchar(100) NOT NULL default '',
  `vPassword` varchar(100) NOT NULL default '',
  `dDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `vOnline` char(1) NOT NULL default '0',
  `vCodeForPass` varchar(10) default NULL,
  `vBanned` char(1) NOT NULL default '0',
  `vDelStatus` char(1) NOT NULL default '0',
  `nCSSId` tinyint(4) NOT NULL default '3',
  PRIMARY KEY  (`nUserId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=754 ;


DROP TABLE IF EXISTS `sptbl_visitors`;
CREATE TABLE IF NOT EXISTS `sptbl_visitors` (
  `nVisitingId` bigint(20) NOT NULL auto_increment,
  `nCompId` bigint(20) default NULL,
  `vIpAddr` varchar(25) default NULL,
  `vPage` varchar(128) default NULL,
  `vStatus` varchar(10) default NULL,
  `dVisitTime` datetime default NULL,
  `dLastUpdTime` datetime default NULL,
  PRIMARY KEY  (`nVisitingId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=129 ;


DROP TABLE IF EXISTS `sptbl_xtrastatus`;
CREATE TABLE IF NOT EXISTS `sptbl_xtrastatus` (
  `nXtraId` bigint(20) NOT NULL auto_increment,
  `vXtraDesc` varchar(100) NOT NULL default '',
  `vXtraLang` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`nXtraId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `goStores_AffiliateRefTxns`;
CREATE TABLE IF NOT EXISTS `goStores_AffiliateRefTxns` (
  `nid` int(11) NOT NULL auto_increment,
  `n_aff_id` int(11) default NULL,
  `n_ref_id` int(11) default NULL,
  `nuser_id` int(11) default NULL,
  `ddate` date default NULL,
  `namount` float default NULL,
  `vsettled_status` varchar(5) collate latin1_general_ci default '0',
  `vsettled_type` varchar(20) collate latin1_general_ci default NULL,
  `vsettled_ref_no` varchar(50) collate latin1_general_ci default NULL,
  `dsettled_date` datetime default NULL,
  PRIMARY KEY  (`nid`),
  KEY `n_aff_id` (`n_aff_id`),
  KEY `n_ref_id` (`n_ref_id`),
  KEY `nuser_id` (`nuser_id`),
  KEY `vsettled_status` (`vsettled_status`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `goStores_Affiliates`;
CREATE TABLE IF NOT EXISTS `goStores_Affiliates` (
  `naff_id` int(11) NOT NULL auto_increment,
  `vaff_name` varchar(100) collate latin1_general_ci default NULL,
  `vaff_login` varchar(100) collate latin1_general_ci default NULL,
  `vaff_pass` varchar(100) collate latin1_general_ci default NULL,
  `vaff_mail` varchar(100) collate latin1_general_ci default NULL,
  `vaff_address` varchar(100) collate latin1_general_ci default NULL,
  `vaff_city` varchar(100) collate latin1_general_ci default NULL,
  `vaff_state` varchar(100) collate latin1_general_ci default NULL,
  `vaff_country` varchar(100) collate latin1_general_ci default NULL,
  `vaff_zip` varchar(20) collate latin1_general_ci default NULL,
  `vaff_phone` varchar(20) collate latin1_general_ci default NULL,
  `vdelstatus` char(1) collate latin1_general_ci NOT NULL default '0',
  `ddate_reg` date default '0000-00-00',
  PRIMARY KEY  (`naff_id`),
  KEY `vdelstatus` (`vdelstatus`),
  KEY `vaff_login` (`vaff_login`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `goStores_Banners`;
CREATE TABLE IF NOT EXISTS `goStores_Banners` (
  `nBannerId` int(11) NOT NULL auto_increment,
  `vBannerText` varchar(255) NOT NULL,
  `vBannerUrl` varchar(255) NOT NULL,
  `vBannerImageId` int(11) NOT NULL,
  `vActive` enum('1','0') NOT NULL default '1',
  `showcount` int(11) NOT NULL default '0',
  `clickcount` int(11) NOT NULL default '0',
  PRIMARY KEY  (`nBannerId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=13 ;


DROP TABLE IF EXISTS `goStores_BillingMain`;
CREATE TABLE IF NOT EXISTS `goStores_BillingMain` (
  `nBmId` bigint(20) NOT NULL auto_increment,
  `nUId` bigint(20) NOT NULL,
  `nServiceId` int(11) NOT NULL,
  `vInvNo` int(11) NOT NULL,
  `nSCatId` int(11) NOT NULL,
  `vDomain` varchar(250) default NULL,
  `nDiscount` double(10,2) default NULL,
  `nAmount` double(10,2) default NULL,
  `nSpecialCost` double(10,2) default NULL,
  `vSpecials` text,
  `vType` varchar(250) default NULL,
  `vBillingInterval` varchar(250) default NULL,
  `nBillingDuration` int(11) default NULL,
  `dDateStart` date default NULL,
  `dDateStop` date default NULL,
  `dDateNextBill` date default NULL,
  `dDatePurchase` date default NULL,
  `cronAttempt` int(1) default NULL,
  `vDelStatus` int(1) default NULL,
  PRIMARY KEY  (`nBmId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;


DROP TABLE IF EXISTS `goStores_BillingSettlement`;
CREATE TABLE IF NOT EXISTS `goStores_BillingSettlement` (
  `nId` int(11) NOT NULL auto_increment,
  `nUId` int(11) NOT NULL,
  `nRequestedAmount` double NOT NULL,
  `tUserComments` text NOT NULL,
  `nSettledAmount` double NOT NULL,
  `tAdminComments` text NOT NULL,
  `dCreatedOn` date NOT NULL,
  `eStatus` enum('Pending','Approved','Rejected') NOT NULL default 'Pending',
  PRIMARY KEY  (`nId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=25 ;


DROP TABLE IF EXISTS `goStores_BillingSettlementHistory`;
CREATE TABLE IF NOT EXISTS `goStores_BillingSettlementHistory` (
  `nId` int(11) NOT NULL auto_increment,
  `nBillingSettlementId` int(11) NOT NULL,
  `nUId` int(11) NOT NULL,
  `nAmountWithdrawn` int(11) NOT NULL,
  `dCreatedOn` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`nId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `goStores_Cms`;
CREATE TABLE IF NOT EXISTS `goStores_Cms` (
  `cms_id` int(5) NOT NULL auto_increment,
  `cms_name` varchar(255) collate latin1_general_ci NOT NULL,
  `cms_ref_title` varchar(255) collate latin1_general_ci NOT NULL,
  `cms_type` varchar(255) collate latin1_general_ci NOT NULL,
  `cms_title` varchar(255) collate latin1_general_ci NOT NULL,
  `cms_desc` text collate latin1_general_ci NOT NULL,
  `cms_shortdesc` text collate latin1_general_ci NOT NULL,
  `cms_status` smallint(1) NOT NULL,
  PRIMARY KEY  (`cms_id`),
  KEY `test` (`cms_id`),
  FULLTEXT KEY `cms_title` (`cms_title`,`cms_desc`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=25 ;


DROP TABLE IF EXISTS `goStores_cms_settings`;
CREATE TABLE IF NOT EXISTS `goStores_cms_settings` (
  `id` int(11) NOT NULL auto_increment,
  `cms_set_name` varchar(100) NOT NULL,
  `cms_set_value` varchar(255) NOT NULL,
  `created_on` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=5 ;


DROP TABLE IF EXISTS `goStores_contacts`;
CREATE TABLE IF NOT EXISTS `goStores_contacts` (
  `id` bigint(20) NOT NULL auto_increment,
  `cname` varchar(50) collate latin1_general_ci NOT NULL default '',
  `cemail` varchar(200) collate latin1_general_ci NOT NULL default '',
  `cdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `cdescr` text collate latin1_general_ci NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=3 ;


DROP TABLE IF EXISTS `goStores_Coupon`;
CREATE TABLE IF NOT EXISTS `goStores_Coupon` (
  `nCouponId` bigint(20) NOT NULL auto_increment,
  `vCouponCode` varchar(255) default NULL,
  `vCouponDescription` text,
  `vPricingMode` enum('percentage','rate') default NULL COMMENT 'Percentage or Rate',
  `nCouponValue` double(10,2) default NULL,
  `dCreatedOn` date default NULL,
  `dExpireOn` date default NULL,
  `nCouponCount` int(11) NOT NULL default '0',
  `nCouponUsed` int(11) NOT NULL default '0',
  PRIMARY KEY  (`nCouponId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=39 ;


DROP TABLE IF EXISTS `goStores_EmailTemplates`;
CREATE TABLE IF NOT EXISTS `goStores_EmailTemplates` (
  `nETId` bigint(20) NOT NULL auto_increment,
  `vemailTemplateName` varchar(255) NOT NULL,
  `temailTemplate` text NOT NULL,
  `estatus` enum('Active','Inactive') NOT NULL default 'Active',
  PRIMARY KEY  (`nETId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=4 ;


DROP TABLE IF EXISTS `goStores_EmailTemplatesMails`;
CREATE TABLE IF NOT EXISTS `goStores_EmailTemplatesMails` (
  `nETMId` bigint(20) NOT NULL auto_increment,
  `vMailName` varchar(400) NOT NULL,
  `nETID` bigint(20) NOT NULL,
  `tScheduleTime` datetime NOT NULL,
  `eStatus` enum('Active','Deactive','Delete','Send') NOT NULL default 'Active',
  `nMailMode` enum('Mail','Streamsend') NOT NULL default 'Streamsend' COMMENT '1->Phpmail , 2-> Streamsend',
  PRIMARY KEY  (`nETMId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=44 ;


DROP TABLE IF EXISTS `goStores_files`;
CREATE TABLE IF NOT EXISTS `goStores_files` (
  `file_id` int(11) NOT NULL auto_increment,
  `file_orig_name` varchar(255) default NULL,
  `file_extension` varchar(10) default NULL,
  `file_mime_type` varchar(50) default NULL,
  `file_type` varchar(50) default NULL COMMENT 'video/photo',
  `file_width` int(4) default NULL,
  `file_height` int(4) default NULL,
  `file_play_time` int(11) default NULL,
  `file_size` int(11) default NULL,
  `file_path` text,
  `file_status` int(11) default NULL,
  `file_title` varchar(255) default NULL,
  `file_caption` text,
  `file_tmp_name` varchar(255) default NULL,
  `created_on` datetime default NULL,
  `created_by` int(11) default NULL,
  PRIMARY KEY  (`file_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `goStores_general`;
CREATE TABLE IF NOT EXISTS `goStores_general` (
  `nGId` int(11) NOT NULL auto_increment,
  `nUserId` int(11) default '0',
  `vFirstName` varchar(255) NOT NULL,
  `vLastName` varchar(255) NOT NULL,
  `vNumber` varchar(100) default NULL,
  `vCode` varchar(100) default NULL,
  `vMonth` varchar(100) default NULL,
  `vYear` varchar(100) default NULL,
  `vAddress` varchar(255) NOT NULL,
  `vCity` varchar(255) NOT NULL,
  `vState` varchar(255) NOT NULL,
  `vZipcode` varchar(100) NOT NULL,
  `vCountry` varchar(255) NOT NULL,
  `vEmail` varchar(255) NOT NULL,
  `vUserIp` varchar(15) default NULL,
  `dUpdated` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`nGId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=19 ;


DROP TABLE IF EXISTS `goStores_Help`;
CREATE TABLE IF NOT EXISTS `goStores_Help` (
  `nId` int(11) NOT NULL auto_increment,
  `vTitle` varchar(250) NOT NULL,
  `tDescription` text NOT NULL,
  `eType` enum('Admin','User') NOT NULL default 'User',
  `eStatus` enum('Active','Disabled') NOT NULL,
  PRIMARY KEY  (`nId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=10 ;


DROP TABLE IF EXISTS `goStores_Invoice`;
CREATE TABLE IF NOT EXISTS `goStores_Invoice` (
  `nInvId` int(11) NOT NULL auto_increment,
  `vInvNo` varchar(250) default NULL,
  `nUId` int(11) NOT NULL,
  `nPLId` bigint(20) default NULL,
  `dGeneratedDate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `dDueDate` timestamp NOT NULL default '0000-00-00 00:00:00',
  `nAmount` double NOT NULL,
  `nDiscount` int(11) NOT NULL,
  `nTotal` double NOT NULL,
  `vCouponNumber` varchar(100) default NULL,
  `vTerms` text NOT NULL,
  `vNotes` text NOT NULL,
  `vMethod` varchar(250) default NULL,
  `vSubscriptionType` enum('FREE','PAID') NOT NULL,
  `upgraded` tinyint(1) NOT NULL default '0' COMMENT '1 in the case where user changes from free to paid/lower plan to higher plan',
  `previousDomain` text COMMENT 'In case of upgrade, fill up previous domain here ',
  `vTxnId` varchar(250) default NULL,
  `dPayment` timestamp NULL default NULL,
  PRIMARY KEY  (`nInvId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=4 ;


DROP TABLE IF EXISTS `goStores_InvoiceDomain`;
CREATE TABLE IF NOT EXISTS `goStores_InvoiceDomain` (
  `nIDId` int(11) NOT NULL auto_increment,
  `nUId` int(11) NOT NULL,
  `nInvId` int(11) NOT NULL,
  `nSCatId` int(11) default NULL,
  `nPLId` bigint(20) default NULL,
  `vDescription` text,
  `nAmount` double NOT NULL,
  `nAmtNext` varchar(250) default NULL,
  `vType` enum('one time','recurring') NOT NULL,
  `vBillingInterval` varchar(11) default NULL,
  `nBillingDuration` int(11) default NULL,
  `nDiscount` double NOT NULL,
  `dDateStart` date default NULL,
  `dDateStop` date default NULL,
  `dDateNextBill` date default NULL,
  `dCreatedOn` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `nPlanStatus` int(11) default '1',
  PRIMARY KEY  (`nIDId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;


DROP TABLE IF EXISTS `goStores_InvoicePlan`;
CREATE TABLE IF NOT EXISTS `goStores_InvoicePlan` (
  `nIPId` int(11) NOT NULL auto_increment,
  `nUId` int(11) NOT NULL,
  `nInvId` int(11) NOT NULL,
  `nServiceId` int(11) default NULL,
  `nSCatId` int(11) default NULL,
  `nSpecialCost` double(10,2) default NULL,
  `vSpecials` text,
  `nAmount` double NOT NULL,
  `nAmtNext` varchar(250) default NULL,
  `vType` enum('one time','recurring') NOT NULL,
  `vBillingInterval` varchar(11) default NULL,
  `nBillingDuration` int(11) default NULL,
  `nDiscount` double NOT NULL,
  `dDateStart` date default NULL,
  `dDateStop` date default NULL,
  `dDateNextBill` date default NULL,
  `dCreatedOn` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `nPlanStatus` int(11) default '1',
  PRIMARY KEY  (`nIPId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=4 ;


DROP TABLE IF EXISTS `goStores_NewsLetters`;
CREATE TABLE IF NOT EXISTS `goStores_NewsLetters` (
  `nNLId` int(11) NOT NULL auto_increment,
  `vName` varchar(100) NOT NULL,
  `vEmail` varchar(255) NOT NULL,
  `dDateofSubscription` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `dLastSent` timestamp NOT NULL default '0000-00-00 00:00:00',
  `nSubscriptionStatus` int(11) NOT NULL,
  PRIMARY KEY  (`nNLId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=20 ;


DROP TABLE IF EXISTS `goStores_PaidTemplatePurchase`;
CREATE TABLE IF NOT EXISTS `goStores_PaidTemplatePurchase` (
`id` bigint(20) NOT NULL auto_increment,
`nTemplateId` bigint(20) default NULL,
`nUId` bigint(20) default NULL,
`amount` double(10,2) default NULL,
`paymentMethod` varchar(255) default NULL,
`transactionId` varchar(255) default NULL,
`comments` text NOT NULL,
PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `goStores_PaidTemplates`;
CREATE TABLE IF NOT EXISTS `goStores_PaidTemplates` (
  `nTemplateId` int(11) NOT NULL auto_increment,
  `vTemplateName` varchar(255) NOT NULL,
  `vDescription` text,
  `nCost` double(10,2) default NULL,
  `vTemplateZipId` int(11) default NULL,
  `vHomeScreenshotId` int(11) default NULL,
  `vInnerScreenshot1Id` int(11) default NULL,
  `vInnerScreenshot2Id` int(11) default NULL,
  `vActive` enum('1','0') NOT NULL default '1',
  PRIMARY KEY  (`nTemplateId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=8 ;


DROP TABLE IF EXISTS `goStores_Payments`;
CREATE TABLE IF NOT EXISTS `goStores_Payments` (
  `nPaymentId` int(11) NOT NULL auto_increment,
  `nPPId` int(11) NOT NULL,
  `nPId` int(11) NOT NULL,
  `nUId` int(11) NOT NULL,
  `nAmount` double NOT NULL,
  `vPlanDescription` text NOT NULL,
  `dPaymentDate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `vPaymentMethod` varchar(255) NOT NULL,
  `vTransactionId` varchar(50) NOT NULL,
  PRIMARY KEY  (`nPaymentId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=79 ;


DROP TABLE IF EXISTS `goStores_Permission`;
CREATE TABLE IF NOT EXISTS `goStores_Permission` (
  `nId` int(11) NOT NULL auto_increment,
  `nRid` int(11) default NULL,
  `vPermission` varchar(255) NOT NULL,
  `dCreatedOn` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `dLastUpdated` timestamp NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`nId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=12 ;


DROP TABLE IF EXISTS `goStores_PlanPackages`;
CREATE TABLE IF NOT EXISTS `goStores_PlanPackages` (
  `nPPId` int(11) NOT NULL auto_increment,
  `nPlanId` int(11) NOT NULL,
  `vDescription` text NOT NULL,
  `nPlanAmount` double NOT NULL,
  `dCreatedOn` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `nStatus` int(11) NOT NULL,
  `nDeleteStatus` int(1) default '0',
  PRIMARY KEY  (`nPPId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;


DROP TABLE IF EXISTS `goStores_PlanPurchaseCategories`;
CREATE TABLE IF NOT EXISTS `goStores_PlanPurchaseCategories` (
  `nId` int(11) NOT NULL auto_increment,
  `vCategory` varchar(255) NOT NULL,
  `vDescription` text NOT NULL,
  `vOrderofDisplay` int(11) default NULL,
  `dCreatedOn` date default NULL,
  `nStatus` int(11) NOT NULL,
  PRIMARY KEY  (`nId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;


DROP TABLE IF EXISTS `goStores_PlanPurchaseCategoryDetails`;
CREATE TABLE IF NOT EXISTS `goStores_PlanPurchaseCategoryDetails` (
  `nId` int(11) NOT NULL auto_increment,
  `nPlanPurchaseCategoryId` int(11) NOT NULL,
  `vDescription` text NOT NULL,
  `nAmount` double NOT NULL,
  `nIsMandatory` int(11) NOT NULL,
  `dCreatedOn` date NOT NULL,
  `nStatus` int(11) NOT NULL,
  PRIMARY KEY  (`nId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;


DROP TABLE IF EXISTS `goStores_Plans`;
CREATE TABLE IF NOT EXISTS `goStores_Plans` (
  `nPlanId` int(11) NOT NULL auto_increment,
  `vPlanName` varchar(255) NOT NULL,
  `vDescription` text NOT NULL,
  `dCreatedOn` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `nStatus` int(11) NOT NULL,
  `nDeleteStatus` int(1) default '0',
  PRIMARY KEY  (`nPlanId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=7 ;


DROP TABLE IF EXISTS `goStores_ProductLookup`;
CREATE TABLE IF NOT EXISTS `goStores_ProductLookup` (
  `nPLId` int(11) NOT NULL auto_increment,
  `nUId` int(11) NOT NULL,
  `nPPId` int(11) NOT NULL,
  `nPId` int(11) NOT NULL,
  `nPRId` int(11) NOT NULL,
  `vSubDomain` varchar(255) NOT NULL,
  `nSubDomainStatus` int(11) NOT NULL,
  `vDomain` varchar(255) NOT NULL,
  `nDomainStatus` int(11) NOT NULL,
  `dLastUpdated` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `nCustomized` int(11) NOT NULL,
  `nStatus` int(11) NOT NULL,
  `dStatusUpdatedOn` timestamp NOT NULL default '0000-00-00 00:00:00',
  `dPlanExpiryDate` timestamp NOT NULL default '0000-00-00 00:00:00',
  `vAccountDetails` text NOT NULL,
  PRIMARY KEY  (`nPLId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=254 ;


DROP TABLE IF EXISTS `goStores_ProductPermission`;
CREATE TABLE IF NOT EXISTS `goStores_ProductPermission` (
  `nId` int(11) NOT NULL auto_increment,
  `nPId` int(11) NOT NULL,
  `vPermissions` text NOT NULL,
  PRIMARY KEY  (`nId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=43 ;


DROP TABLE IF EXISTS `goStores_ProductReleases`;
CREATE TABLE IF NOT EXISTS `goStores_ProductReleases` (
  `nPRId` int(11) NOT NULL auto_increment,
  `nPId` int(11) NOT NULL,
  `vVersion` varchar(255) NOT NULL,
  `dLastUpdated` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`nPRId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=44 ;


DROP TABLE IF EXISTS `goStores_Products`;
CREATE TABLE IF NOT EXISTS `goStores_Products` (
  `nPId` int(11) NOT NULL auto_increment,
  `vPName` varchar(255) NOT NULL,
  `vProductCaption` text,
  `vProductPack` varchar(250) default NULL,
  `vProductlogoSmall` varchar(250) default NULL,
  `vProductlogo` varchar(250) default NULL,
  `vProductDescription` text,
  `vProductScreens` varchar(250) default NULL,
  `dLastUpdated` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `nPRId` int(5) default NULL,
  `nStatus` int(1) NOT NULL,
  PRIMARY KEY  (`nPId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=45 ;


DROP TABLE IF EXISTS `goStores_ProductServiceFeatures`;
CREATE TABLE IF NOT EXISTS `goStores_ProductServiceFeatures` (
  `nProductServiceId` int(11) NOT NULL,
  `nServiceFeatureId` int(11) NOT NULL,
  `vFeatureValue` varchar(25) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `goStores_ProductServices`;
CREATE TABLE IF NOT EXISTS `goStores_ProductServices` (
  `nServiceId` int(11) NOT NULL auto_increment,
  `vServiceName` varchar(255) NOT NULL,
  `vServiceDescription` text NOT NULL,
  `nSCatId` int(11) NOT NULL,
  `nPId` int(11) NOT NULL,
  `price` double(10,2) default NULL,
  `nQty` int(11) NOT NULL,
  `vBillingInterval` varchar(3) default NULL,
  `nBillingDuration` int(11) default NULL,
  `nStatus` int(11) NOT NULL,
  `dLastUpdated` timestamp NOT NULL default '0000-00-00 00:00:00' on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`nServiceId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `goStores_serverHistory`;
CREATE TABLE IF NOT EXISTS `goStores_serverHistory` (
  `id` bigint(20) NOT NULL auto_increment,
  `nPLId` bigint(20) default NULL COMMENT 'product lookup id',
  `nserver_id` bigint(20) NOT NULL COMMENT 'server mapped with productlookup for a store',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=30 ;


DROP TABLE IF EXISTS `goStores_ServerInfo`;
CREATE TABLE IF NOT EXISTS `goStores_ServerInfo` (
  `nserver_id` bigint(20) NOT NULL auto_increment,
  `vserver_configfilename` varchar(100) collate latin1_general_ci default NULL,
  `vserver_configfilepath` varchar(250) collate latin1_general_ci default NULL,
  `vserver_name` varchar(100) collate latin1_general_ci default NULL,
  `vmakethisserver_default` varchar(10) collate latin1_general_ci default 'NO',
  `vserver_type` varchar(100) collate latin1_general_ci NOT NULL default 'CPANEL',
  `vserver_status` char(1) collate latin1_general_ci NOT NULL default 'M',
  `vserver_hosting_plan` varchar(100) collate latin1_general_ci NOT NULL default '',
  `vserver_cpanel_skin` varchar(10) collate latin1_general_ci NOT NULL default '',
  `whmuser` varchar(200) collate latin1_general_ci default NULL,
  `whmpass` varchar(200) collate latin1_general_ci default NULL,
  PRIMARY KEY  (`nserver_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=6 ;


DROP TABLE IF EXISTS `goStores_ServiceCategories`;
CREATE TABLE IF NOT EXISTS `goStores_ServiceCategories` (
  `nSCatId` int(11) NOT NULL auto_increment,
  `vCategory` varchar(255) NOT NULL,
  `vDescription` text NOT NULL,
  `vInputType` varchar(1) default 'C',
  `vOrderofDisplay` int(11) default NULL,
  `dCreatedOn` date default NULL,
  `nStatus` int(11) NOT NULL,
  PRIMARY KEY  (`nSCatId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=18 ;


DROP TABLE IF EXISTS `goStores_ServiceFeatures`;
CREATE TABLE IF NOT EXISTS `goStores_ServiceFeatures` (
  `nFeatureId` int(11) NOT NULL auto_increment,
  `tFeatureName` varchar(250) NOT NULL,
  `tValue` text NOT NULL,
  `eStatus` enum('Active','Disabled') NOT NULL default 'Active',
  PRIMARY KEY  (`nFeatureId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=6 ;


DROP TABLE IF EXISTS `goStores_Settings`;
CREATE TABLE IF NOT EXISTS `goStores_Settings` (
  `settingfield` varchar(250) NOT NULL,
  `settinglabel` varchar(250) NOT NULL,
  `value` text,
  `groupLabel` varchar(50) NOT NULL,
  `type` varchar(256) NOT NULL,
  `fieldOrder` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `goStores_SiteAnalytics`;
CREATE TABLE IF NOT EXISTS `goStores_SiteAnalytics` (
  `nId` int(11) NOT NULL auto_increment,
  `nCount` text,
  `dTrackingDate` timestamp NULL default NULL,
  PRIMARY KEY  (`nId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=10 ;


DROP TABLE IF EXISTS `goStores_Templates`;
CREATE TABLE IF NOT EXISTS `goStores_Templates` (
  `nId` int(11) NOT NULL auto_increment,
  `vName` varchar(100) NOT NULL,
  `vDisplayName` varchar(100) NOT NULL,
  `tImagePath` text NOT NULL,
  PRIMARY KEY  (`nId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `goStores_themes`;
CREATE TABLE IF NOT EXISTS `goStores_themes` (
  `theme_id` int(5) NOT NULL auto_increment,
  `theme_title` varchar(100) NOT NULL,
  `theme_name` varchar(100) NOT NULL,
  `theme_status` int(1) NOT NULL COMMENT '1 -> active theme',
  `theme_thumbnail` varchar(255) default NULL,
  PRIMARY KEY  (`theme_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=6 ;


DROP TABLE IF EXISTS `goStores_tld`;
CREATE TABLE IF NOT EXISTS `goStores_tld` (
  `id` bigint(20) NOT NULL auto_increment,
  `registrar` varchar(50) NOT NULL default '',
  `tld` varchar(25) NOT NULL default '',
  `register_fee` decimal(10,2) NOT NULL default '0.00',
  `renewal_fee` decimal(10,2) NOT NULL default '0.00',
  `transfer_fee` decimal(10,2) NOT NULL default '0.00',
  `tocidreg` varchar(20) default NULL,
  `tocidren` varchar(20) default NULL,
  `tocidtra` varchar(20) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=21 ;


DROP TABLE IF EXISTS `goStores_User`;
CREATE TABLE IF NOT EXISTS `goStores_User` (
  `nUId` int(11) NOT NULL auto_increment,
  `vUsername` varchar(250) default NULL,
  `vPassword` varchar(250) default NULL,
  `vFirstName` varchar(255) NOT NULL,
  `vLastName` varchar(255) NOT NULL,
  `dLastLogin` datetime NOT NULL,
  `dLastUpdated` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `vEmail` varchar(255) NOT NULL,
  `vInvoiceEmail` varchar(255) NOT NULL,
  `vAddress` varchar(255) NOT NULL,
  `vCountry` varchar(255) NOT NULL,
  `vState` varchar(255) NOT NULL,
  `vCity` varchar(255) NOT NULL,
  `vZipcode` varchar(5) NOT NULL,
  `vPhoneNumber` varchar(25) NOT NULL,
  `vFax` varchar(25) NOT NULL,
  `vActivationKey` varchar(255) default NULL,
  `nStatus` enum('0','1','2') NOT NULL COMMENT '0-> pending; 1-> active; 2 -> deactivated',
  `nAffId` int(11) NOT NULL,
  `vAffType` varchar(10) NOT NULL,
  `nRefId` int(11) NOT NULL,
  PRIMARY KEY  (`nUId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=261 ;


DROP TABLE IF EXISTS `goStores_Wallet`;
CREATE TABLE IF NOT EXISTS `goStores_Wallet` (
  `nWId` int(11) NOT NULL auto_increment,
  `nUId` int(11) NOT NULL,
  `nBalanceAmount` int(11) NOT NULL,
  `vType` enum('1','2') NOT NULL COMMENT '1-> Credit by Admin;2 -> Amount Settlement',
  `dCreatedOn` datetime NOT NULL,
  `dLastUpdated` datetime NOT NULL,
  PRIMARY KEY  (`nWId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=9 ;



DROP TABLE IF EXISTS `goStores_Vista_admins`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_admins` (
  `id` int(11) NOT NULL auto_increment,
  `admin_name` varchar(100) NOT NULL default '',
  `admin_pword` varchar(100) NOT NULL default '',
  `settings` char(1) default NULL,
  `custom` char(1) default NULL,
  `category` char(1) default NULL,
  `products` char(1) default NULL,
  `feedback` char(1) default NULL,
  `users` char(1) default NULL,
  `orders` char(1) default NULL,
  `refund` char(1) default NULL,
  `promocodes` char(1) default NULL,
  `websitecontent` char(1) default NULL,
  `reports` char(1) default NULL,
  `homepage` char(1) default NULL,
  `help` char(1) default NULL,
  `adminusers` char(1) default NULL,
  `newsletter` char(1) NOT NULL default '',
  `newsletterusers` char(1) NOT NULL default '',
  `sentnewsletters` char(1) NOT NULL default '',
  `giftcards` char(1) NOT NULL default '',
  `giftcardusers` char(1) NOT NULL default '',
  `email` varchar(200) default NULL,
  `blog_pword` varchar(100) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=4 ;


DROP TABLE IF EXISTS `goStores_Vista_carts`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_carts` (
  `id` int(11) NOT NULL auto_increment,
  `sess_id` varchar(100) NOT NULL default '',
  `product_id` int(11) NOT NULL default '0',
  `product_price` decimal(10,2) NOT NULL default '0.00',
  `prodtype` varchar(20) NOT NULL default '',
  `extra_price` decimal(10,2) default '0.00',
  `discount_type` varchar(5) default NULL,
  `discount` decimal(10,2) default '0.00',
  `quantity` int(11) NOT NULL default '0',
  `user_id` int(11) NOT NULL default '0',
  `shipping_charge` decimal(10,2) NOT NULL default '0.00',
  `customvalue` text,
  `customfields_id` int(11) default NULL,
  `option_id` bigint(20) NOT NULL default '0',
  `type` varchar(150) NOT NULL default '',
  `price_type` char(1) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `goStores_Vista_categories`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_categories` (
  `id` int(11) NOT NULL auto_increment,
  `cname` varchar(100) NOT NULL default '',
  `parent_id` int(11) NOT NULL default '0',
  `custom_combination` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `goStores_Vista_cmspages`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_cmspages` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  `content` text,
  `type` varchar(100) NOT NULL default 'email',
  `status` enum('Y','N') NOT NULL default 'N',
  PRIMARY KEY  (`id`),
  KEY `type` (`type`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=13 ;


DROP TABLE IF EXISTS `goStores_Vista_contacts`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_contacts` (
  `id` bigint(20) NOT NULL auto_increment,
  `cname` varchar(50) NOT NULL default '',
  `cemail` varchar(200) NOT NULL default '',
  `cdate` varchar(25) NOT NULL default '',
  `cdescr` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `goStores_Vista_countries`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_countries` (
  `country_id` int(11) NOT NULL auto_increment,
  `country_name` varchar(64) NOT NULL default '',
  `country_iso_code_2` char(2) NOT NULL default '',
  PRIMARY KEY  (`country_id`),
  KEY `IDX_COUNTRY_NAME` (`country_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `goStores_Vista_coupons`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_coupons` (
  `id` bigint(20) NOT NULL auto_increment,
  `code` varchar(100) NOT NULL default '',
  `type` enum('Perc','Amt') NOT NULL default 'Perc',
  `giftvalue` decimal(10,2) NOT NULL default '0.00',
  `from_date` date NOT NULL default '0000-00-00',
  `to_date` date NOT NULL default '0000-00-00',
  `status` char(1) NOT NULL default 'A',
  `descr` text,
  `minamt` decimal(10,2) NOT NULL default '0.00',
  PRIMARY KEY  (`id`),
  KEY `code` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `goStores_Vista_currencies`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_currencies` (
  `id` int(11) NOT NULL auto_increment,
  `code` varchar(10) NOT NULL default '',
  `name` varchar(100) default NULL,
  `logo` varchar(100) character set utf8 collate utf8_unicode_ci default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_customcombinations`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_customcombinations` (
  `id` bigint(20) NOT NULL auto_increment,
  `category_id` bigint(20) NOT NULL default '0',
  `customfield_id` bigint(20) NOT NULL default '0',
  `customvalue_id` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_customfields`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_customfields` (
  `id` bigint(20) NOT NULL auto_increment,
  `custom_name` varchar(200) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `custom_id` (`custom_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_customfieldvalues`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_customfieldvalues` (
  `id` bigint(20) NOT NULL auto_increment,
  `customfield_id` bigint(20) NOT NULL default '0',
  `custom_value` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_feedbacks`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_feedbacks` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) NOT NULL default '0',
  `product_id` int(11) NOT NULL default '0',
  `date` varchar(25) NOT NULL default '',
  `type` varchar(100) NOT NULL default '',
  `comment` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_giftcards`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_giftcards` (
  `id` bigint(20) NOT NULL auto_increment,
  `gift_code` varchar(255) NOT NULL default '',
  `gift_amnt` decimal(10,2) NOT NULL default '0.00',
  `from` date default '0000-00-00',
  `to` date default '0000-00-00',
  `stock` bigint(20) NOT NULL default '0',
  `status` char(1) NOT NULL default 'A',
  `descr` text,
  `gift_img` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `code` (`gift_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_giftcardusers`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_giftcardusers` (
  `id` bigint(20) NOT NULL auto_increment,
  `user_id` bigint(20) NOT NULL default '0',
  `order_id` bigint(20) NOT NULL default '0',
  `card_id` bigint(20) NOT NULL default '0',
  `usercard_id` bigint(20) NOT NULL default '0',
  `date` varchar(20) NOT NULL default '',
  `amnt_used` decimal(10,2) NOT NULL default '0.00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_giftcard_details`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_giftcard_details` (
  `id` bigint(20) NOT NULL auto_increment,
  `user_id` bigint(20) NOT NULL default '0',
  `order_id` bigint(20) NOT NULL default '0',
  `card_id` bigint(20) NOT NULL default '0',
  `card_code` text NOT NULL,
  `amount` decimal(10,2) NOT NULL default '0.00',
  `balance` decimal(10,2) NOT NULL default '0.00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_helps`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_helps` (
  `id` bigint(20) NOT NULL auto_increment,
  `title` varchar(255) NOT NULL default '',
  `content` longtext NOT NULL,
  `type` enum('A','U') NOT NULL default 'A',
  `order` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_homelayouts`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_homelayouts` (
  `id` int(11) NOT NULL auto_increment,
  `prod_type` char(50) default NULL,
  `section` char(15) default NULL,
  `status` enum('Y','N') NOT NULL default 'Y',
  `ordering` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_newsletters`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_newsletters` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(255) NOT NULL default '',
  `content` longtext NOT NULL,
  `news_date` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_newsletterusers`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_newsletterusers` (
  `id` int(11) NOT NULL auto_increment,
  `uname` varchar(255) NOT NULL default '',
  `email` varchar(255) NOT NULL default '',
  `sub_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `status` enum('N','Y') NOT NULL default 'Y',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_orders`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_orders` (
  `id` int(11) NOT NULL auto_increment,
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `exp_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `user_id` int(11) NOT NULL default '0',
  `shipping_method` varchar(100) NOT NULL default '',
  `shipping_service` varchar(100) NOT NULL default '',
  `shipping_price` decimal(10,2) NOT NULL default '0.00',
  `tax_price` decimal(10,2) NOT NULL default '0.00',
  `total_price` decimal(10,2) NOT NULL default '0.00',
  `order_status_id` int(10) NOT NULL default '1',
  `ship_fname` varchar(50) NOT NULL default '',
  `ship_lname` varchar(50) NOT NULL default '',
  `ship_address` varchar(50) NOT NULL default '',
  `ship_city` varchar(50) NOT NULL default '',
  `ship_state` varchar(50) NOT NULL default '',
  `ship_country` varchar(50) NOT NULL default '',
  `ship_zip` varchar(50) NOT NULL default '',
  `ship_phone` varchar(50) NOT NULL default '',
  `ship_mobile` varchar(50) NOT NULL default '',
  `ship_fax` varchar(50) NOT NULL default '',
  `transaction_id` varchar(50) default NULL,
  `bill_fname` varchar(50) NOT NULL default '',
  `bill_lname` varchar(50) NOT NULL default '',
  `bill_address` varchar(50) NOT NULL default '',
  `bill_city` varchar(50) NOT NULL default '',
  `bill_state` varchar(50) NOT NULL default '',
  `bill_country` varchar(50) NOT NULL default '',
  `bill_zip` varchar(50) NOT NULL default '',
  `bill_phone` varchar(50) NOT NULL default '',
  `bill_mobile` varchar(50) NOT NULL default '',
  `bill_fax` varchar(50) NOT NULL default '',
  `payment_method` varchar(100) NOT NULL default '',
  `currency_type` varchar(10) NOT NULL default 'USD',
  `note` text,
  `comments` longtext NOT NULL,
  `tax_name` varchar(100) default NULL,
  `coupon_id` int(11) default '0',
  `discount` decimal(10,2) NOT NULL default '0.00',
  `tracking_no` text,
  `label_pdf` text,
  `specials` text,
  `special_price` decimal(10,2) default NULL,
  `order_type` varchar(2) default NULL,
  PRIMARY KEY  (`id`),
  KEY `users_id` (`user_id`,`order_status_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_order_details`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_order_details` (
  `id` int(11) NOT NULL auto_increment,
  `order_id` int(11) NOT NULL default '0',
  `product_id` int(11) NOT NULL default '0',
  `product_price` decimal(10,2) NOT NULL default '0.00',
  `prodtype` varchar(20) default NULL,
  `discount_type` varchar(5) default 'amnt',
  `discount` decimal(10,2) default '0.00',
  `quantity` int(11) NOT NULL default '0',
  `extra_price` decimal(10,2) NOT NULL default '0.00',
  `customfields_id` int(11) default NULL,
  `combination_id` bigint(20) NOT NULL default '0',
  `type` char(1) NOT NULL default '',
  `price_type` char(1) default NULL,
  PRIMARY KEY  (`id`),
  KEY `orders_id` (`order_id`,`product_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_order_statuses`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_order_statuses` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_productcustomfields`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_productcustomfields` (
  `id` bigint(20) NOT NULL auto_increment,
  `product_id` bigint(20) NOT NULL default '0',
  `customfield_id` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `product_id` (`product_id`,`customfield_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_productdetails`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_productdetails` (
  `id` bigint(20) NOT NULL auto_increment,
  `category_id` bigint(20) NOT NULL default '0',
  `product_id` bigint(20) NOT NULL default '0',
  `customvalue_id` varchar(255) NOT NULL default '',
  `stock` bigint(20) NOT NULL default '0',
  `reorderlevel` bigint(20) NOT NULL default '0',
  `skuno` varchar(100) NOT NULL default '',
  `extraprice` bigint(20) NOT NULL default '0',
  `pdctfile` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_productimages`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_productimages` (
  `id` bigint(20) NOT NULL auto_increment,
  `product_id` bigint(20) NOT NULL default '0',
  `imagename` varchar(200) NOT NULL default '',
  `default_img` enum('Y','N') NOT NULL default 'N',
  PRIMARY KEY  (`id`),
  KEY `product_id` (`product_id`,`imagename`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_products`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_products` (
  `id` int(11) NOT NULL auto_increment,
  `pname` varchar(100) NOT NULL default '',
  `category_id` int(11) NOT NULL default '0',
  `descr` text NOT NULL,
  `price` decimal(10,2) NOT NULL default '0.00',
  `wholesale_price` decimal(10,2) NOT NULL default '0.00',
  `discount_type` varchar(5) NOT NULL default '',
  `discount` decimal(10,2) default '0.00',
  `image1` varchar(100) default NULL,
  `image2` varchar(100) default NULL,
  `featured` enum('0','1') NOT NULL default '1',
  `stock` int(11) default '0',
  `skuno` varchar(100) default NULL,
  `reorderlevel` int(11) default '0',
  `weight` decimal(10,2) NOT NULL default '0.00',
  `shipping_price` decimal(10,2) NOT NULL default '0.00',
  `status` varchar(10) NOT NULL default 'A',
  `pdctfile` varchar(250) NOT NULL default '',
  `prodtype` varchar(100) NOT NULL default 'Non-Digital',
  `combination` char(1) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_randoms`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_randoms` (
  `id` bigint(20) NOT NULL auto_increment,
  `rand_id` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_ratings`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_ratings` (
  `id` int(11) NOT NULL auto_increment,
  `product_id` int(11) NOT NULL default '0',
  `user_id` int(11) NOT NULL default '0',
  `rate` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_refundoptions`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_refundoptions` (
  `id` bigint(20) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_refundproducts`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_refundproducts` (
  `id` bigint(20) NOT NULL auto_increment,
  `refund_id` bigint(20) NOT NULL default '0',
  `product_id` bigint(20) NOT NULL default '0',
  `combination_id` bigint(20) NOT NULL default '0',
  `quantity` bigint(20) default NULL,
  `return_reason` text NOT NULL,
  `extra_price` decimal(10,2) NOT NULL default '0.00',
  `product_price` decimal(10,2) NOT NULL default '0.00',
  `discount` int(11) default '0',
  `discount_type` varchar(5) default NULL,
  `type` char(1) default NULL,
  `price_type` char(1) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_refundreasons`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_refundreasons` (
  `id` bigint(20) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_refunds`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_refunds` (
  `id` bigint(20) NOT NULL auto_increment,
  `user_id` bigint(20) NOT NULL default '0',
  `order_id` bigint(20) NOT NULL default '0',
  `customer_feedback` text,
  `status` varchar(255) default NULL,
  `additional_info` text,
  `date` date NOT NULL default '0000-00-00',
  `refund_mode` varchar(255) default NULL,
  `reference_number` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_refundstatuses`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_refundstatuses` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_reports`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_reports` (
  `id` int(11) NOT NULL default '0',
  `reports` varchar(255) NOT NULL default ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS `goStores_Vista_sent_newsletters`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_sent_newsletters` (
  `id` bigint(20) NOT NULL auto_increment,
  `newsletter_id` bigint(20) NOT NULL default '0',
  `user_id` bigint(20) NOT NULL default '0',
  `send_date` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_settings`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_settings` (
  `fieldname` varchar(100) NOT NULL default '',
  `value` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS `goStores_Vista_statecodes`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_statecodes` (
  `id` int(11) NOT NULL auto_increment,
  `code` varchar(10) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  `country_id` varchar(10) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `country_id` (`country_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_states`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_states` (
  `id` int(11) NOT NULL auto_increment,
  `code` varchar(10) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  `country_id` varchar(10) NOT NULL default '',
  `tax_rate` decimal(10,2) NOT NULL default '0.00',
  `tax_name` varchar(100) default NULL,
  PRIMARY KEY  (`id`),
  KEY `country_id` (`country_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_users`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_users` (
  `id` int(11) NOT NULL auto_increment,
  `uname` varchar(50) NOT NULL default '',
  `password` varchar(50) NOT NULL default '',
  `email` varchar(100) NOT NULL default '',
  `reg_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `usertype` varchar(20) NOT NULL default 'R',
  `reg_status` varchar(50) NOT NULL default '',
  `user_credit` float NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `goStores_Vista_user_addresses`;
CREATE TABLE IF NOT EXISTS `goStores_Vista_user_addresses` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) NOT NULL default '0',
  `addr_type` enum('Billing','Shipping') NOT NULL default 'Billing',
  `fname` varchar(50) NOT NULL default '',
  `lname` varchar(50) NOT NULL default '',
  `address` text NOT NULL,
  `city` varchar(100) NOT NULL default '',
  `state` varchar(100) NOT NULL default '',
  `country` varchar(100) NOT NULL default '',
  `zip` varchar(20) NOT NULL default '',
  `phone` varchar(25) NOT NULL default '',
  `fax` varchar(25) NOT NULL default '',
  `mobile` varchar(25) NOT NULL default '',
  `email` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `users_id` (`user_id`,`addr_type`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS goStores_Vista_wp_commentmeta;
CREATE TABLE IF NOT EXISTS `goStores_Vista_wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS goStores_Vista_wp_comments;
CREATE TABLE IF NOT EXISTS `goStores_Vista_wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

DROP TABLE IF EXISTS goStores_Vista_wp_links;
CREATE TABLE IF NOT EXISTS `goStores_Vista_wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS goStores_Vista_wp_options;
CREATE TABLE IF NOT EXISTS `goStores_Vista_wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=160 ;

DROP TABLE IF EXISTS goStores_Vista_wp_postmeta;
CREATE TABLE IF NOT EXISTS `goStores_Vista_wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

DROP TABLE IF EXISTS goStores_Vista_wp_posts;
CREATE TABLE IF NOT EXISTS `goStores_Vista_wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(20) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

DROP TABLE IF EXISTS goStores_Vista_wp_terms;
CREATE TABLE IF NOT EXISTS `goStores_Vista_wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  UNIQUE KEY `slug` (`slug`),
  KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

DROP TABLE IF EXISTS goStores_Vista_wp_term_relationships;
CREATE TABLE IF NOT EXISTS `goStores_Vista_wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS goStores_Vista_wp_term_taxonomy;
CREATE TABLE IF NOT EXISTS `goStores_Vista_wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

DROP TABLE IF EXISTS goStores_Vista_wp_usermeta;
CREATE TABLE IF NOT EXISTS `goStores_Vista_wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

DROP TABLE IF EXISTS goStores_Vista_wp_users;
CREATE TABLE IF NOT EXISTS `goStores_Vista_wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(64) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(60) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

ALTER TABLE `goStores_ServerInfo` ADD `whmip` VARCHAR( 25 ) NULL;
ALTER TABLE `goStores_Settings` ADD INDEX ( `settingfield` );
ALTER TABLE `goStores_Banners` ADD `eType` ENUM( 'Home Page Sliding Banner', 'Footer' ) NOT NULL DEFAULT 'Footer';
ALTER TABLE `goStores_ProductServices` ADD `vType` ENUM( 'paid', 'free' ) NULL AFTER `nQty`;
ALTER TABLE `goStores_Invoice` CHANGE `nDiscount` `nDiscount` DOUBLE( 10, 2 ) NULL;
ALTER TABLE `goStores_InvoicePlan` CHANGE `nAmtNext` `nAmtNext` DOUBLE( 10, 2 ) NULL DEFAULT NULL;
ALTER TABLE `goStores_InvoiceDomain` CHANGE `nAmtNext` `nAmtNext` DOUBLE( 10, 2 ) NULL DEFAULT NULL;
ALTER TABLE `goStores_Settings` ADD `helpText` TEXT NULL ;
ALTER TABLE `goStores_ServerInfo` ADD `whm_port` VARCHAR( 250 ) NULL , ADD `cpanel_port` VARCHAR( 250 ) NULL;
ALTER TABLE `cms_users` ADD  `role_id` INT( 11 ) NULL AFTER  `password`;

DROP TABLE IF EXISTS `fw_metadata`;
CREATE TABLE IF NOT EXISTS `fw_metadata` (
  `id` int(11) NOT NULL auto_increment,
  `url` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `keyword` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `goStores_DemoScreenshots`;
CREATE TABLE IF NOT EXISTS `goStores_DemoScreenshots` (
  `nScreenId` int(11) NOT NULL auto_increment,
  `vScreenImageId` int(11) NOT NULL,
  `vActive` enum('1','0') NOT NULL default '1',
  `eType` enum('Admin','User') NOT NULL default 'User',
  PRIMARY KEY  (`nScreenId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `goStores_DomainRenewalLog`;
CREATE TABLE `goStores_DomainRenewalLog` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	`nPLId` BIGINT(20) NULL DEFAULT NULL,
	`nUId` BIGINT(20) NULL DEFAULT NULL,
	`vDomain` VARCHAR(250) NULL DEFAULT NULL,
	`status` INT(1) NULL DEFAULT NULL COMMENT '1=> Domain renewed, 0 => Domain Renewal Failed',
	`comments` VARCHAR(255) NULL DEFAULT NULL,
	`expireOn` DATE NULL,
	`createdOn` DATE NULL,
	`lastModified` DATE NULL,
	`cronAttempt` INT(11) NULL DEFAULT NULL,
	PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `goStores_tld_godaddy`;
CREATE TABLE IF NOT EXISTS `goStores_tld_godaddy` (
  `nId` int(11) NOT NULL auto_increment,
  `nDuration` smallint(2) NOT NULL,
  `eType` enum('Registration','Renewal','Transfer') NOT NULL,
  `vProductid` varchar(50) NOT NULL,
  `vTld` varchar(10) NOT NULL,
  PRIMARY KEY  (`nId`)
) ENGINE=MyISAM AUTO_INCREMENT=199 DEFAULT CHARSET=latin1;


ALTER TABLE `goStores_Banners` CHANGE `clickcount` `clickcount` INT( 11 ) NULL DEFAULT NULL ;
ALTER TABLE `goStores_InvoiceDomain` ADD  `nRate` DOUBLE( 10, 2 ) NULL AFTER `vDescription`;
ALTER TABLE `goStores_BillingMain` CHANGE `nServiceId` `nServiceId` INT( 11 ) NULL;
ALTER TABLE `goStores_ProductLookup` ADD COLUMN `nTransactionSession` BIGINT NULL DEFAULT NULL AFTER `vAccountDetails`;
ALTER TABLE `goStores_Banners` ADD COLUMN `displayOrder` INT(11) NULL DEFAULT NULL AFTER `eType`;
ALTER TABLE `goStores_BillingMain` ADD COLUMN `vPaymentMethod` VARCHAR(200) NULL DEFAULT NULL AFTER `dDatePurchase`;
ALTER TABLE `goStores_PaidTemplatePurchase` ADD COLUMN `paidOn` DATE NULL AFTER `comments`;
ALTER TABLE `goStores_PaidTemplatePurchase` CHANGE COLUMN `paidOn` `paidOn` TIMESTAMP NULL DEFAULT NULL AFTER `comments`;
ALTER TABLE `goStores_PaidTemplatePurchase` ADD COLUMN `nPLId` BIGINT(20) NULL DEFAULT NULL AFTER `nUId`;
ALTER TABLE  `goStores_ProductLookup` CHANGE  `vSubDomain`  `vSubDomain` VARCHAR( 255 ) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL;
ALTER TABLE  `goStores_ProductLookup` CHANGE  `vDomain`  `vDomain` VARCHAR( 255 ) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL;
ALTER TABLE  `goStores_ProductLookup` CHANGE  `vAccountDetails`  `vAccountDetails` TEXT CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL;
ALTER TABLE `goStores_ServerInfo` CHANGE COLUMN `whmpass` `whmpass` TEXT NULL DEFAULT NULL COLLATE 'utf8_general_ci' AFTER `whmuser`;

CREATE TABLE IF NOT EXISTS `sptbl_ticket_mail_replies` (`replyId` int(10) NOT NULL auto_increment,`toMail` varchar(250) collate latin1_general_ci NOT NULL,`fromMail` varchar(250) collate latin1_general_ci NOT NULL,`mailHeader` varchar(250) collate latin1_general_ci NOT NULL,`subject` text collate latin1_general_ci NOT NULL,`mailBody` longtext collate latin1_general_ci NOT NULL,`sendAt` timestamp NULL default NULL,`addedDate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,`actionLogId` int(11) NOT NULL,`personalNotesSubj` text collate latin1_general_ci NOT NULL,`personalNotesMatter` text collate latin1_general_ci NOT NULL,`attachment` text collate latin1_general_ci NOT NULL,`replyPId` int(10) default NULL,PRIMARY KEY  (`replyId`));
CREATE TABLE IF NOT EXISTS `sptbl_ticketlog` (`nTLId` bigint(20) NOT NULL auto_increment,`nStaffId` bigint(20) default '0',`vAction` varchar(100) collate latin1_general_ci NOT NULL default '',`nTLSId` bigint(20) NOT NULL default '0',`nTicketId` bigint(20) NOT NULL default '0',`vRefNo` bigint(20) NOT NULL default '0',`dDate` datetime NOT NULL default '0000-00-00 00:00:00',`nCurDeptId` int(20) NOT NULL,`nPrevDeptId` int(11) NOT NULL,PRIMARY KEY  (`nTLId`));
CREATE TABLE IF NOT EXISTS `sptbl_ticketlogstatus` (`nTLSId` bigint(20) NOT NULL auto_increment,`vLogName` varchar(100) collate latin1_general_ci NOT NULL default '',PRIMARY KEY  (`nTLSId`));
ALTER TABLE `sptbl_actionlog` ADD  `logStatus` ENUM(  'Y',  'N' ) NULL DEFAULT NULL;
ALTER TABLE `sptbl_replies` ADD  `eReplySentstatus` ENUM(  'Y',  'N' ) NOT NULL DEFAULT  'Y';
ALTER TABLE `sptbl_tickets` ADD  `nClosedStaff` INT( 11 ) NOT NULL DEFAULT  '0';
ALTER TABLE `sptbl_kb_rating` ADD COLUMN `vIP` VARCHAR(50) NOT NULL AFTER `nMarks`;
ALTER TABLE `sptbl_depts` ADD COLUMN `nDeptVisibility` INT(11) NULL DEFAULT '1' COMMENT '0=>Not visible to user,1=> Visible to user' AFTER `nResponseTime`;
ALTER TABLE `sptbl_tickets` ADD COLUMN `merged_from` VARCHAR(255) NOT NULL DEFAULT '0' AFTER `nClosedStaff`,ADD COLUMN `merged_to` VARCHAR(255) NOT NULL DEFAULT '0' AFTER `merged_from`;
ALTER TABLE `sptbl_tickets`ADD COLUMN `merged_by` BIGINT NOT NULL DEFAULT '0' AFTER `merged_to`;
CREATE TABLE IF NOT EXISTS `sptbl_ticket_statistics` (`statistics_id` INT(10) NOT NULL AUTO_INCREMENT,`ticket_id` INT(10) NULL DEFAULT NULL,`reply_time` FLOAT NULL DEFAULT '0',`closing_time` FLOAT NULL DEFAULT '0',`posted_date` DATETIME NULL DEFAULT NULL,PRIMARY KEY (`statistics_id`)) COLLATE='latin1_swedish_ci' ENGINE=MyISAM AUTO_INCREMENT=1;
