
$(function() {

$("#firstName").focus();

$("#frmSignUp").validate({
        rules: {
            firstName: {
                required: true
            },
            lastName: {
                required: true
            },
            emailAddress: {
                required: true,
                email: true
            },
            password: {
                required: true,
                minlength: 6
            } ,
            confirmPassword: {
                required: true,
                minlength: 6,
                equalTo: '#password'
            }

        },
        messages: {
            firstName: {
                required: "Please enter first name"
            },
            lastName: {
                required: "Please enter last name"
            },
            emailAddress: {
                required: "Please enter email",
                email:"Please enter a valid email"
            }	,
            password: {
                required: "Please enter password",
                minlength: "Your password must be at least 6 characters long"
            },
            confirmPassword: {
                required: "Please re-type password",
                minlength: "Your password must be at least 6 characters long",
                equalTo: "Please enter the same password as above"
            }

        },
        submitHandler: function(form) {
        //$('#div-loading').show();
        //$('#div-submit').hide();
        //alert('Here comes the control');
        // do : ajax call for user duplication check with email
         var rootUrl = BASE_URL+'index/checkduplicateuser';
         var emailId = $('#emailAddress').val();
         $('#emailAddress_err').html('');
         $.ajax({
                        type: "POST",
                        url: rootUrl,
                        data: {email: emailId}
                    }).success(function( msg ) {
                        //alert(msg);
                        if(msg==1){                           
                            $('#emailAddress_err').html('Email address already exists');
                        } else {
                            form.submit();
                        } // End If
                    });
        
        }
    });

});

