<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts VistaCart                    |
// +----------------------------------------------------------------------+
// | Authors: Jipson Thomas<jipson.thomas@armiasystems.com>               |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com � 2011                |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php
error_reporting(0);
$imagefolder = "../img";
$stylesfolder = "../css";
$sitestyle = "Eyewears.css";
$logoimage = "SiteLogo.jpg";
$productname = " ";

session_start();

function isValidUsername($str) {
    if (trim($str) != "") {
        if (eregi("[^0-9a-zA-Z+_]", $str)) {
            return false;
        } else {
            return true;
        }
    } else {
        return false;
    }
}

function splitsqlfile($sql, $delimiter) {
    // Split up our string into "possible" SQL statements.
    $tokens = explode($delimiter, $sql);
    // try to save mem.
    $sql = "";
    $output = array();
    // we don't actually care about the matches preg gives us.
    $matches = array();
    // this is faster than calling count($oktens) every time thru the loop.
    $token_count = count($tokens);
    for ($i = 0; $i < $token_count; $i++) {
        // Don't wanna add an empty string as the last thing in the array.
        if (($i != ($token_count - 1)) || (strlen($tokens[$i] > 0))) {
            // This is the total number of single quotes in the token.
            $total_quotes = preg_match_all("/'/", $tokens[$i], $matches);
            // Counts single quotes that are preceded by an odd number of backslashes,
            // which means they're escaped quotes.
            $escaped_quotes = preg_match_all("/(?<!\\\\)(\\\\\\\\)*\\\\'/", $tokens[$i], $matches);

            $unescaped_quotes = $total_quotes - $escaped_quotes;
            // If the number of unescaped quotes is even, then the delimiter did NOT occur inside a string literal.
            if (($unescaped_quotes % 2) == 0) {
                // It's a complete sql statement.
                $output[] = $tokens[$i];
                // save memory.
                $tokens[$i] = "";
            } else {
                // incomplete sql statement. keep adding tokens until we have a complete one.
                // $temp will hold what we have so far.
                $temp = $tokens[$i] . $delimiter;
                // save memory..
                $tokens[$i] = "";
                // Do we have a complete statement yet?
                $complete_stmt = false;

                for ($j = $i + 1; (!$complete_stmt && ($j < $token_count)); $j++) {
                    // This is the total number of single quotes in the token.
                    $total_quotes = preg_match_all("/'/", $tokens[$j], $matches);
                    // Counts single quotes that are preceded by an odd number of backslashes,
                    // which means they're escaped quotes.
                    $escaped_quotes = preg_match_all("/(?<!\\\\)(\\\\\\\\)*\\\\'/", $tokens[$j], $matches);

                    $unescaped_quotes = $total_quotes - $escaped_quotes;

                    if (($unescaped_quotes % 2) == 1) {
                        // odd number of unescaped quotes. In combination with the previous incomplete
                        // statement(s), we now have a complete statement. (2 odds always make an even)
                        $output[] = $temp . $tokens[$j];
                        // save memory.
                        $tokens[$j] = "";
                        $temp = "";
                        // exit the loop.
                        $complete_stmt = true;
                        // make sure the outer loop continues at the right point.
                        $i = $j;
                    } else {
                        // even number of unescaped quotes. We still don't have a complete statement.
                        // (1 odd and 1 even always make an odd)
                        $temp .= $tokens[$j] . $delimiter;
                        // save memory.
                        $tokens[$j] = "";
                    }
                } // for..
            } // else
        }
    }
    return $output;
}

function isValidTableName($str) {
    if (trim($str) != "") {
        if (eregi("[^a-zA-Z+_]", $str)) {
            return false;
        } else {
            return true;
        }
    } else {
        return false;
    }
}

function isValidEmail($email) {
    $email = trim($email);
    if ($email == "")
        return false;
    if (!eregi("^" . "[a-z0-9]+([_\\.-][a-z0-9]+)*" . // user
                    "@" . "([a-z0-9]+([\.-][a-z0-9]+)*)+" . // domain
                    "\\.[a-z]{2,}" . // sld, tld
                    "$", $email, $regs)
    ) {
        return false;
    } else {
        return true;
    }
}

function isNotNull($value) {
    if (is_array($value)) {
        if (sizeof($value) > 0) {
            return true;
        } else {
            return false;
        }
    } else {
        if (($value != '') && (strtolower($value) != 'null') && (strlen(trim($value)) > 0)) {
            return true;
        } else {
            return false;
        }
    }
}

function isValidWebImageType($mimetype, $filename, $tempname) {
    $blacklist = array("php", "phtml", "php3", "php4", "js", "shtml", "pl", "py", "exe");
    foreach ($blacklist as $file) {
        if (preg_match("/\.$file\$/i", "$filename")) {
            return false;
        }
    }
    //check if its image file
    if (!getimagesize($tempname)) {
        return false;
    }

    if (($mimetype == "image/pjpeg") || ($mimetype == "image/jpeg") || ($mimetype == "image/x-png") || ($mimetype == "image/png") || ($mimetype == "image/gif") ||
            ($mimetype == "image/x-windows-bmp") || ($mimetype == "image/bmp")) {
        return true;
    } else {
        return false;
    }
}

function isValidWMImageType($mimetype, $filename, $tempname) {
    /* if (($mimetype == "image/pjpeg") || ($mimetype == "image/jpeg") || ($mimetype == "image/gif")) {
      return true;
      } else {
      return false;
      } */
    $blacklist = array("php", "phtml", "php3", "php4", "js", "shtml", "pl", "py", "exe");
    foreach ($blacklist as $file) {
        if (preg_match("/\.$file\$/i", "$filename")) {
            return false;
        }
    }
    //check if its image file
    if (!getimagesize($tempname)) {
        return false;
    }
    if ($mimetype == "image/gif") {
        return true;
    } else {
        return false;
    }
}

function getFilePermission($file) {
    $perm = fileperms($file);
    if ($perm === false) {
        return "0000";
    } else {
        return substr(sprintf('%o', $perm), -4);
    }
}

function stripslashes_deep($value) {
    $value = is_array($value) ? array_map('stripslashes_deep', $value) : stripslashes($value);
    return $value;
}

function getServerOS() {
    return strtoupper(substr(PHP_OS, 0, 3));
}

function installScript($dbArray,$installPath)
{
set_time_limit(0);
@set_magic_quotes_runtime(0);

if (get_magic_quotes_gpc()) {
    $_POST = array_map('stripslashes_deep', $_POST);
    $_GET = array_map('stripslashes_deep', $_GET);
    $_COOKIE = array_map('stripslashes_deep', $_COOKIE);
}


$schemafile = $installPath."app/webroot/install/schema.sql";
$datafile = $installPath."app/webroot/install/data.sql";
$configfile = $installPath."/app/webroot/config.php";


$configcontents = @fread(@fopen($configfile, 'r'), @filesize($configfile));
$pos = strpos($configcontents, "INSTALLED");
if ($pos === false) {
;
} else {
    header("Location:../index.php");
}

$fullurl = $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']);
if ($_SERVER['HTTPS'] == 'on') {
    $http = "https://";
} else {
    $http = "http://";
}
$fullurl = $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']);
$fullurl=str_replace('/index.php', '', $fullurl);

$installed = false;
$txtDBServerName = "localhost";
$txtTablePrefix = "VistaCart_";
$mystring = dirname(dirname(__FILE__));
$findme = '/webroot';
$ps = strpos($mystring, $findme);
$dr = substr($mystring, 0, $ps);
$dbconfigfile = $installPath."/app/config/database.php";
$configfile = $installPath."/app/webroot/config.php";
$wpconfigfile = $installPath."/app/webroot/blog/wp-config.php";

$txtSiteURL = "http://" . $fullurl;
$txtSecureSiteURL = "https://" . $fullurl;
$txtSiteURLt = "http://" . $fullurl;
$txtSecureSiteURLt = "https://" . $fullurl;
$txtSiteBaseFolderfull = dirname($_SERVER['PHP_SELF']);
$findu = '/app/webroot';
$murl = strpos($txtSiteURL, $findu);
$txtSiteURL = substr($txtSiteURL, 0, $murl);
$len = strpos($txtSiteBaseFolderfull, $findu);
$txtSiteBaseFolder = substr($txtSiteBaseFolderfull, 0, $len);
//print_r($txtSiteBaseFolder);exit;

$murs = strpos($txtSecureSiteURL, $findu);
$txtSecureSiteURL = substr($txtSecureSiteURL, 0, $murs);
/* * ********************************check server configuration **************************************************** */

$server_flag = true;

$val1 = ini_get("safe_mode");
$val3 = ini_get("file_uploads");

$gd = function_exists('gd_info');
$curl = function_exists('curl_init');
$mysql = function_exists('mysql_connect');

if (!empty($val1) || $val1 == 1) {
    $server_flag = false;
} elseif (empty($val3) || $val3 != 1) {
    $server_flag = false;
} elseif (!$gd) {
    $server_flag = false;
} elseif (!$curl) {
    $server_flag = false;
} elseif (!$mysql) {
    $server_flag = false;
}

$mysqlsupport = true;
if (!function_exists('mysql_connect')) {

    $mysqlsupport = false;
}

if (!$server_flag) {
    $serverconfiguration = "FAILURE";
} else {
    $serverconfiguration = "OK";
}

/* --------------------Check server PHP configuration--------------------------- */


$error = false;
$error_message = '';


/* ---------------------------------------------------------------------------------------------------------------- */
$post_flag = false;
$dbconfigfile =$installPath."app/config/database.php";
    $txtDBServerName = "localhost";
    $txtDBName = $dbArray['db_name'];
    $txtDBUserName = $dbArray['db_user'];
    $txtDBPassword = $dbArray['db_password'];
    $txtSiteName = $dbArray['store_name'];
    $txtAdminName = 'admin';
    $txtAdminPassword = 'admin';
    $txtConfirmAdminPassword = 'admin';
	$txtLicenseKey = '140CSI270101000011399221112STP';
    $txtAdminEmail = $dbArray['user_email'];
	$txtTablePrefix		= 'tbl_';


    $post_flag = true;
    $message = "";

    /*
    if (!isNotNull($txtDBServerName)) {
        $message .= " * Database Server Name is empty!" . "<br>";
        $error = true;
    }
    if (!isNotNull($txtDBName)) {
        $message .= " * Database Name is empty!" . "<br>";
        $error = true;
    }
    if (!isNotNull($txtDBUserName)) {
        $message .= " * Database User Name is empty!" . "<br>";
        $error = true;
    }
    if (!isNotNull($txtSiteName)) {
        $message .= " * Site Name is empty!" . "<br>";
        $error = true;
    }
    if (!isNotNull($txtAdminEmail)) {
        $message .= " * Admin Email is empty!" . "<br>";
        $error = true;
    } else {
        if (!isValidEmail($txtAdminEmail)) {
            $message .= " * Invalid Admin Email!" . "<br>";
            $error = true;
        }
    }
     */

    $connection = @mysql_connect($txtDBServerName, $txtDBUserName, $txtDBPassword);
    if ($connection === false) {
        $error = true;
        $message .= " * Connection Not Successful! Please verify your database details!<br>";
    } else {
        $dbselected = @mysql_select_db($txtDBName, $connection);
        if (!$dbselected) {
            $error = true;
            $message .= " * Database could not be selected! Please verify your database details!<br>";
        }
    }

    //exit;

    if ($error) {
        $message = "<u><b>Please correct the following errors to continue:</b></u>" . "<br><br>" . $message;
        // echo $message;
    } else {

        //-------------------------UPDATE CONFIG FILE---------------------------//
        $uniqueid = time() . mt_rand() . session_id();
        if (strlen($uniqueid) > 15) {
            $uniqueid = substr($uniqueid, 0, 15);
            $uniqueid = md5($uniqueid);
        }
        $fp = fopen($configfile, "w+");
        $configcontent = "<?php\n";
        $configcontent .= "define('INSTALLED', true); \n\n";
        $configcontent .= "define('VERSION', '2.0'); \n\n";
        $configcontent .= "\n?>";
        fwrite($fp, $configcontent);

        //---------------------------UPDATE THE DB CONNECTOR--------------------//
        $default = '$default';
        $fpp = fopen($dbconfigfile, "w+");
        $dbconfigcontent = "<?php\n";
        $dbconfigcontent .= "class DATABASE_CONFIG { \n\n";
        $dbconfigcontent .= "var $default = array( \n\n";
        $dbconfigcontent .= "'driver' => 'mysql', \n\n";
        $dbconfigcontent .= "'persistent' => false,\n\n";
        $dbconfigcontent .= "'host' => '" . $txtDBServerName . "',\n\n";
        $dbconfigcontent .= "'login' => '" . $txtDBUserName . "',\n\n";
        $dbconfigcontent .= "'password' => '" . $txtDBPassword . "',\n\n";
        $dbconfigcontent .= "'database' => '" . $txtDBName . "',\n\n";
        $dbconfigcontent .= "'prefix' => '" . $txtTablePrefix . "', \n\n";
        $dbconfigcontent .= "); \n\n";
        $dbconfigcontent .= "}\n\n";
        $dbconfigcontent .= "\n?>";
        fwrite($fpp, $dbconfigcontent);

        //-------------------------UPDATE WP DB CONNECTOR-----------------------//
        $handle = fopen($wpconfigfile, "rb");
        $contents = fread($handle, filesize($wpconfigfile));
        fclose($handle);

        $contents = str_replace('CON_DB_NAME', $txtDBName, $contents);
        $contents = str_replace('CON_DB_USER', $txtDBUserName, $contents);
        $contents = str_replace('CON_DB_PASS', $txtDBPassword, $contents);
        $contents = str_replace('CON_DB_HOST', $txtDBServerName, $contents);
        $contents = str_replace('CON_DB_PREFIX', $txtTablePrefix . 'wp_', $contents);

        $fp = fopen($wpconfigfile, 'w');
        fwrite($fp, $contents);
        fclose($fp);

        //------------------------UPDATE THE DB---------------------------------//
        $sqlquery = @fread(@fopen($schemafile, 'r'), @filesize($schemafile));
        $sqlquery = preg_replace('/Vista_/', $txtTablePrefix, $sqlquery);
        $sqlquery = splitsqlfile($sqlquery, ";");

        for ($i = 0; $i < sizeof($sqlquery); $i++) {
            mysql_query($sqlquery[$i], $connection);
        }

        $dataquery = @fread(@fopen($datafile, 'r'), @filesize($datafile));
        $dataquery = preg_replace('/Vista_/', $txtTablePrefix, $dataquery);
        $dataquery = splitsqlfile($dataquery, ";");

        for ($i = 0; $i < sizeof($dataquery); $i++) {
            mysql_query($dataquery[$i], $connection);
        }


        //-------------------UPDATE INITIAL CONFIG VALUES-----------------------//
        $adminusername = addslashes($txtAdminName);
        $adminpassword = md5($txtAdminPassword);
        $adminmailpword = $txtAdminPassword;
        $adminblogpword = $txtAdminPassword . '_' . time();

        include_once( $dr . "/webroot/blog/wp-includes/class-phpass.php" );
        $wp_hasher = new PasswordHash( 8, TRUE );
        $hashed_wp_password = $wp_hasher->HashPassword( $adminblogpword );

        $sqladminsettings = "UPDATE " . $txtTablePrefix . "admins SET admin_name = '" . $adminusername . "',admin_pword ='" . $adminpassword . "', blog_pword = '" . $adminblogpword . "', email = '" . addslashes($txtAdminEmail) . "' WHERE admin_name = 'admin'";
        mysql_query($sqladminsettings) or die(mysql_error());

        $sqlsettings = "UPDATE " . $txtTablePrefix . "settings SET value = '" . addslashes($txtSiteName) . "' WHERE fieldname ='site_name'";
        mysql_query($sqlsettings) or die(mysql_error());

        $sqlsettings = "UPDATE " . $txtTablePrefix . "settings SET value = '" . addslashes($txtSiteBaseFolder) . "' WHERE fieldname ='sitebasefolder'";
        mysql_query($sqlsettings) or die(mysql_error());

        $sqlsettings1 = "UPDATE " . $txtTablePrefix . "settings SET value = '" . addslashes($txtAdminEmail) . "' WHERE fieldname ='admin_email'";
        mysql_query($sqlsettings1) or die(mysql_error());

        $sqlsettings1 = "UPDATE " . $txtTablePrefix . "settings SET value = '" . addslashes($txtLicenseKey) . "' WHERE fieldname ='vLicenceKey'";
        mysql_query($sqlsettings1) or die(mysql_error());
        
        //WP configuration section
        
        $sqlsettings1 = "UPDATE " . $txtTablePrefix . "wp_users SET user_pass = '" . addslashes($hashed_wp_password) . "', user_email = '" . addslashes($txtAdminEmail) . "' WHERE ID = 1";
        mysql_query($sqlsettings1) or die(mysql_error());
        
        $admin_link = $txtSiteURL . '/admins';
        $blog_link = $txtSiteURL . '/app/webroot/blog';
        
        $sqlsettings1 = "UPDATE " . $txtTablePrefix . "wp_options SET option_value = '" . addslashes($blog_link) . "' WHERE option_id IN(1, 36)";
        mysql_query($sqlsettings1) or die(mysql_error());
        
        $wp_admin_menu_links = array('enabled' => 1, 'title' => 'Back To Main Store', 'title_link' => $admin_link, 'links' => array(), 'disabled_menus' => '');
        $sqlsettings1 = "UPDATE " . $txtTablePrefix . "wp_options SET option_value = '" . serialize($wp_admin_menu_links) . "' WHERE option_id IN(159)";
        mysql_query($sqlsettings1) or die(mysql_error());
        
        $sqlsettings2 = mysql_query("SELECT ID, guid FROM " . $txtTablePrefix . "wp_posts");
        if($sqlsettings2){
            while($sqlres = mysql_fetch_array($sqlsettings2)){
                $text_val = $sqlres['guid'];
                $text_val = str_replace('http://localhost/vistacart', $txtSiteURL, $text_val);
                
                mysql_query("UPDATE " . $txtTablePrefix . "wp_posts SET guid = '" . addslashes($text_val) . "' WHERE ID = " . $sqlres['ID']);
            }
        }
        
        $sqlsettings1 = "UPDATE " . $txtTablePrefix . "wp_usermeta SET meta_key = '" . $txtTablePrefix . "wp_capabilities' WHERE umeta_id IN(10)";
        mysql_query($sqlsettings1) or die(mysql_error());
        
        $sqlsettings1 = "UPDATE " . $txtTablePrefix . "wp_usermeta SET meta_key = '" . $txtTablePrefix . "wp_user_level' WHERE umeta_id IN(11)";
        mysql_query($sqlsettings1) or die(mysql_error());
        
        $sqlsettings1 = "UPDATE " . $txtTablePrefix . "wp_usermeta SET meta_key = '" . $txtTablePrefix . "wp_dashboard_quick_press_last_post_id' WHERE umeta_id IN(14)";
        mysql_query($sqlsettings1) or die(mysql_error());
        
        $sqlsettings1 = "UPDATE " . $txtTablePrefix . "wp_options SET option_name = '" . $txtTablePrefix . "wp_user_roles' WHERE option_id IN(92)";
        mysql_query($sqlsettings1) or die(mysql_error());

        $installed = true;

        // section to send details to admin...............................
        $pos = strpos($_SERVER['SCRIPT_NAME'], '/webroot');
        $ck = substr($_SERVER['SCRIPT_NAME'], 0, $pos);

        $s = null;
        if ($_SERVER['HTTPS']) {
            $s = 's';
        }
        $httpHost = $_SERVER['HTTP_HOST'];
        if (isset($httpHost)) {
            $ser = 'http' . $s . '://' . $httpHost;
        }
        unset($httpHost, $s);
        $ft = '';
        $ft = @file_get_contents($ser . "/" . $ck . "/config/rewtest/link2.html");
        if (php_sapi_name() == 'apache2handler') {
            $apach = true;
        } else {
            $apach = false;
        }
        if ($apach != true || $ft == '') {
            $admurl = $txtSiteURL . "/admins/";
            $sturl = $txtSiteURL;
        } else {
            $admurl = $txtSiteURL . "/admins/";
            $sturl = $txtSiteURL;
        }
        /* -------------- /
          New code for install tracker, added by girish
          /------------------ */
        $string = "";
        $pro = urlencode("VistaCart 2.0");
        $dom = urlencode($txtSiteURL);
        $ipv = urlencode($_SERVER['REMOTE_ADDR']);
        $mai = urlencode($txtAdminEmail);
        $string = "pro=$pro&dom=$dom&ipv=$ipv&mai=$mai";
        $contents = "no";
        $file = @fopen("http://www.iscripts.com/installtracker.php?$string", 'r');
        if ($file) {
            $contents = @fread($file, 8192);
        }
        /* -------------- /
          New code for install tracker, added by girish
          /------------------ */
        $subject = "Script Installed at " . $txtSiteName;
        $headers = "From: " . $txtSiteName . "<" . $txtAdminEmail . ">\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=iso-8859-1\r\n";
        $path = "SiteLogo_disp.gif";
        $mcont = "<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>
<tr><td><a href='" . $sturl . "' target='_blank'><img src='" . $sturl . "/img/" . $path . "' border='0'></a></td></tr></table>";
        $mailcontent = $mcont . "Hello , <br>";
        $mailcontent .= "Your Store is successfully installed.<br> <a href='" . $sturl . "' target='_blank'>Click Here to Access your Store</a>";
        $mailcontent .= "<br><a href='" . $admurl . "' target='_blank'>Click Here to Access your Store Administration Control Panel</a> <br>";
        $mailcontent .= "Your Admin Username   :  " . $adminusername;
        $mailcontent .= "<br>Your Admin Password   :  " . $adminmailpword;
        $mailcontent .= "<br> Thanks and regards,<br> " . $txtSiteName . " Team";
		//$mailsent 		= mail(addslashes($txtAdminEmail),$subject,$mailcontent,$headers);
        // section to send details to admin...............................
        return true;
    }
}
function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "") {
    $theValue = (!get_magic_quotes_gpc()) ? addslashes($theValue) : $theValue;

    switch ($theType) {
        case "text":
            $theValue = ($theValue != "") ? "'" . $theValue . "'" : "''";
            break;
        case "long":
        case "int":
            $theValue = ($theValue != "") ? intval($theValue) : "''";
            break;
        case "double":
            $theValue = ($theValue != "") ? "'" . doubleval($theValue) . "'" : "''";
            break;
        case "date":
            $theValue = ($theValue != "") ? "'" . $theValue . "'" : "''";
            break;
        case "defined":
            $theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue;
            break;
    }
    return $theValue;
}
