/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.utilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class ZipUtility {
    public static byte[] compress(byte[] input, int level) {
        Deflater compressor = new Deflater();
        compressor.setLevel(level);
        compressor.setInput(input);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        try {
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            e.getStackTrace();
        }
        return bos.toByteArray();
    }

    public static byte[] decompress(byte[] compressedData) {
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressedData);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(compressedData.length);
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            catch (DataFormatException e) {
                e.getStackTrace();
            }
        }
        try {
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            e.getStackTrace();
        }
        return bos.toByteArray();
    }

    public static byte[] compressObject(Object object, int level) throws IOException {
        return ZipUtility.compress(ZipUtility.objecttoByteArray(object), level);
    }

    public static Object decompressObject(byte[] data) throws Exception {
        return ZipUtility.byteArraytoObject(ZipUtility.decompress(data));
    }

    public static Object byteArraytoObject(byte[] data) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        ObjectInputStream ois = new ObjectInputStream(bais);
        ois.close();
        bais.close();
        return ois.readObject();
    }

    public static byte[] objecttoByteArray(Object obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(obj);
        oos.flush();
        oos.close();
        bos.close();
        return bos.toByteArray();
    }
}

