<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/

// +----------------------------------------------------------------------+

// | PHP version 4/5                                                      |

// +----------------------------------------------------------------------+

// | Copyright (c) 2004-2010 ARMIA INC                                    |

// +----------------------------------------------------------------------+

// | This source file is a part of iScripts VistaCart                     |

// +----------------------------------------------------------------------+

// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |

// +----------------------------------------------------------------------+

App::import('Sanitize');

class CmspagesController extends AppController {

    var $name = "Cmspage";

    var $helpers = array('Html', 'Form','Pagination','Javascript','Fck');

    var $components = array ('Pagination','Catmenu'); // Added

    var $uses = array('Cmspage','Category','Cart');

    var $paginate = array('limit' => 25,'order' => array('Cmspage.title' => 'asc'));

    function index() {

        $this->__validateLoginStatus();

        $admsess	=	$this->Session->read('Admin');

        if($admsess["websitecontent"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();

        }

        $cmbSearchType	=	"";

        $txtSearch		=	"";

        if(isset($_GET["cmbSearchType"]) && isset($_GET["txtSearch"])) {
            $cmbSearchType	=	$_GET["cmbSearchType"];
            $txtSearch		=	$_GET["txtSearch"];
            if($cmbSearchType == "title") {
                $data = $this->paginate('Cmspage', array('Cmspage.type = ' => "content",'Cmspage.title LIKE ' => "%".mysql_real_escape_string($txtSearch)."%"));
            }elseif($cmbSearchType == "content") {
                $data = $this->paginate('Cmspage', array('Cmspage.type = ' => "content",'Cmspage.content LIKE ' => "%".mysql_real_escape_string($txtSearch)."%"));
            }else {
                $data = $this->paginate('Cmspage', array('Cmspage.type = ' => "content"));
            }
        }
        else if(isset($this->passedArgs["cmbSearchType"]) && isset($this->passedArgs["txtSearch"]) &&
                $this->passedArgs["txtSearch"] <> '') {
            $cmbSearchType	=	$this->passedArgs["cmbSearchType"];
            $txtSearch		=	$this->passedArgs["txtSearch"];
            if($cmbSearchType == "title") {
                $data = $this->paginate('Cmspage', array('Cmspage.type = ' => "content",'Cmspage.title LIKE ' => "%".mysql_real_escape_string($txtSearch)."%"));
            }elseif($cmbSearchType == "content") {
                $data = $this->paginate('Cmspage', array('Cmspage.type = ' => "content",'Cmspage.content LIKE ' => "%".mysql_real_escape_string($txtSearch)."%"));
            }else {
                $data = $this->paginate('Cmspage', array('Cmspage.type = ' => "content"));
            }
        }
        else {
            $data = $this->paginate('Cmspage', array('Cmspage.type = ' => "content"));
        }

        $this->set('cmbSearchType', $cmbSearchType);

        $this->set('txtSearch', $txtSearch);

        $this->passedArgs['limit']=$this->paginate["limit"];
        $this->set('passedarg',$this->passedArgs);

        $this->set('pages', $data);

        $this->layout = 'adm';

    }

    function indexmail() {
        
        $this->__validateLoginStatus();

        $admsess	=	$this->Session->read('Admin');

        if($admsess["websitecontent"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();

        }

        $cmbSearchType	=	"";
        $txtSearch		=	"";

        if(isset($_GET["cmbSearchType"]) && isset($_GET["txtSearch"])) {
            $cmbSearchType	=	$_GET["cmbSearchType"];
            $txtSearch		=	$_GET["txtSearch"];
            if($cmbSearchType == "title") {
                $data = $this->paginate('Cmspage', array('Cmspage.type = ' => "email",'Cmspage.title LIKE ' => "%".mysql_real_escape_string($txtSearch)."%"));
            }elseif($cmbSearchType == "content") {
                $data = $this->paginate('Cmspage', array('Cmspage.type = ' => "email",'Cmspage.content LIKE ' => "%".mysql_real_escape_string($txtSearch)."%"));
            }else {
                $data = $this->paginate('Cmspage', array('Cmspage.type = ' => "email"));
            }
        }
        else if(isset($this->passedArgs["cmbSearchType"]) && isset($this->passedArgs["txtSearch"]) &&
                $this->passedArgs["txtSearch"] <> '') {
            $cmbSearchType	=	$this->passedArgs["cmbSearchType"];
            $txtSearch		=	$this->passedArgs["txtSearch"];
            if($cmbSearchType == "title") {
                $data = $this->paginate('Cmspage', array('Cmspage.type = ' => "email",'Cmspage.title LIKE ' => "%".mysql_real_escape_string($txtSearch)."%"));
            }elseif($cmbSearchType == "content") {
                $data = $this->paginate('Cmspage', array('Cmspage.type = ' => "email",'Cmspage.content LIKE ' => "%".mysql_real_escape_string($txtSearch)."%"));
            }else {
                $data = $this->paginate('Cmspage', array('Cmspage.type = ' => "email"));
            }
        }else {

            $data = $this->paginate('Cmspage', array('Cmspage.type = ' => "email"));

        }

        $this->set('cmbSearchType', $cmbSearchType);

        $this->set('txtSearch', $txtSearch);
        $this->passedArgs['limit']=$this->paginate["limit"];
        $this->set('passedarg',$this->passedArgs);

        $this->set('pages', $data);

        $this->layout = 'adm';

    }

    function beforeFilter() {

        if (isset($this->Setting) && !empty($this->Setting->table)) {

            $this->Setting->load();

        }

        global $sitefolder;

        global $meta_description;

        global $meta_keywords;

        global $page_title;

        $cnfg 				=	Configure::read('Neutrino');

        $sitefolder			=	$cnfg["sitebasefolder"];

        $meta_description	=	$cnfg["meta_description"];

        $meta_keywords		=	$cnfg["meta_keywords"];

        $page_title			=	$cnfg["page_title"];

        global $style;

        $style				=	$cnfg["style"];

        $this->set('style', $style);

        $this->set('meta_description', $meta_description);

        $this->set('meta_keywords', $meta_keywords);


        $this->pageTitle = $page_title	;

        $this->set('cnfg',$cnfg);

        $this->paginate["limit"]=$cnfg["items_perpage"]; //Setting pagination limit per page.

        $this->set('sitefolder', $sitefolder);
        $httpHost	=	$_SERVER['HTTP_HOST'];
        $this->set('sitebase','http://'.$httpHost);
        //get cart count
         $sus = $this->Session->read();
        if ($this->Session->check('Userlog') === true) {
            $userid = $sus["Userlog"]["id"];
            $cartCount = $this->Cart->getCartCount($userid,'user');
        }else {
            $sessid = $this->Session->id();
            $cartCount = $this->Cart->getCartCount($sessid,'G');
        }
        $this->set('cartcount',$cartCount);

    }

    function beforeRender() {
        $footer_links = $this->Cmspage->find('list',array('conditions' => array('Cmspage.type' => 'content','Cmspage.status' => 'Y')));
        $this->set('footerlinks', $footer_links);


    }

    function __validateLoginStatus() {

        if($this->Session->check('Admin') == false) {

            $this->redirect(array('controller' => 'admins', 'action' => 'login'));

            $this->Session->setFlash(__('The URL you\'ve followed requires you login.'));

        }

    }

    function add() {

        $this->__validateLoginStatus();

        $admsess	=	$this->Session->read('Admin');

        if($admsess["websitecontent"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();

        }

        if (!empty($this->data)) {

            $pdt = $this->Cmspage->findByTitle($this->data["Cmspage"]["title"]);

            if (!empty($pdt['Cmspage']['id'])) {

                $this->Session->setFlash(__('The Page Title Already Exist!', true));

                $this->redirect(array('controller'=>'cmspages','action'=>'add'));

                exit;

            }else {

                if ($this->Cmspage->save($this->data)) {

                    $this->Session->setFlash(__('Your Page has been saved.', '/Cmspage'));

                    $this->redirect('index');

                    exit;

                }

            }

        }

        $this->layout = 'adm';

    }

    function edit($id=0,$contentType = NULL) {
        
        
        
        if($id == 0) {

            $this->redirect(array('controller' => 'cmspages','action'=>'index'));

            exit();

        }

        $this->__validateLoginStatus();

        $admsess	=	$this->Session->read('Admin');

        if($admsess["websitecontent"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();

        }

        $this->Cmspage->id = $id;

        if (!empty($this->data)) {
            
            // Content Type whether emial / website content
            $contentType = (!empty($this->data["Cmspage"]["contentType"])) ? $this->data["Cmspage"]["contentType"] : $contentType;
            
            $pdt = $this->Cmspage->findByTitle($this->data["Cmspage"]["title"]);

            if (!empty($pdt['Cmspage']['id']) && $pdt['Cmspage']['id'] <> $id) {

                $this->Session->setFlash(__('The Page Title Already Exist!', true));

                $this->data = $this->Cmspage->read();

                $this->set('pagedet', $this->data);

            }else {

                if ($this->Cmspage->save($this->data)) {

                    $this->Session->setFlash(__('The Contents has been Edited Successfully.', '/Cmspage'));

                    if($contentType=='email') { // If Content is email content redirect to Email content area
                        $this->redirect('indexmail');
                    } else { // redirect to web content
                        $this->redirect('index');
                    }
                    

                    exit;

                }

                $this->data = $this->Cmspage->read();

                $this->set('pagedet', $this->data);

            }

        }else {

            $this->data = $this->Cmspage->read();

            $this->set('pagedet', $this->data);

        }

        $this->set('contentType',$contentType);

        $this->layout = 'adm';

    }

    function delete($id) {

        $this->__validateLoginStatus();

        $admsess	=	$this->Session->read('Admin');

        if($admsess["websitecontent"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();

        }

        $this->Cmspage->del($id,true);

        $this->Session->setFlash(__(' Page Removed from Database.', '/categories'));

        $this->redirect('index');

        exit;

    }

    function aboutus() {

        //Code Added By shyam for Category Menu Listing starts here..
        $sus	=	$this->Session->read('Userlog');
        $this->set('sus', $sus);

        //$lst	=	$this->Category->findAll();
         $lst	=	$this->Category->findAll(null, NULL, 'Category.cname ASC', null, null);
        foreach($lst as $det)

            $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"]);

        $this->set('menu_array', $menu_array);

        //Code Added By shyam for Category Menu Listing ends here..

        $dat	=	$this->Cmspage->findByTitle('AboutUS');

        
        $this->set('abtus',$dat["Cmspage"]["content"]);

        $this->layout = 'default';

    }

    function faq() {

        //Code Added By shyam for Category Menu Listing starts here..

        $lst	=	$this->Category->findAll();

        foreach($lst as $det)

            $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"]);

        $this->set('menu_array', $menu_array);

        //Code Added By shyam for Category Menu Listing ends here..

        $dat	=	$this->Cmspage->findByTitle('FAQ');

        $this->set('abtus',$dat["Cmspage"]["content"]);

        $this->layout = 'default';

    }

    function terms() {

        //Code Added By shyam for Category Menu Listing starts here..

        $lst	=	$this->Category->findAll();

        foreach($lst as $det)

            $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"]);

        $this->set('menu_array', $menu_array);

        //Code Added By shyam for Category Menu Listing ends here..

        $dat	=	$this->Cmspage->findByTitle('Terms');

        $this->set('terms',$dat["Cmspage"]["content"]);

        $this->layout = 'default';

    }

    function contactus() {
        $sus	=	$this->Session->read('Userlog');
        $this->set('sus', $sus);

        //Code Added By shyam for Category Menu Listing starts here..

        $lst	=	$this->Category->findAll();

        foreach($lst as $det)

            $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"]);

        $this->set('menu_array', $menu_array);

        //Code Added By shyam for Category Menu Listing ends here..

        $dat	=	$this->Cmspage->findByTitle('ContactUS');

        $this->set('cntctus',$dat["Cmspage"]["content"]);

        $this->layout = 'default';

    }

    function testimonials() {
        $sus	=	$this->Session->read('Userlog');
        $this->set('sus', $sus);
        $lst	=	$this->Category->findAll();
        foreach($lst as $det)
            $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"]);
        $this->set('menu_array', $menu_array);
        $dat	=	$this->Cmspage->findByTitle('Testimonials');
        $this->set('testimonial',$dat["Cmspage"]["content"]);
        $this->layout = 'default';
    }
    function community() {
        $sus	=	$this->Session->read('Userlog');
        $this->set('sus', $sus);
        $lst	=	$this->Category->findAll();
        foreach($lst as $det)
            $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"]);
        $this->set('menu_array', $menu_array);
        $dat	=	$this->Cmspage->findByTitle('Community');
        $this->set('community',$dat["Cmspage"]["content"]);
        $this->layout = 'default';
    }

    function setStatus($uid='',$status='') {

        $this->Cmspage->id = $uid;

        $this->Cmspage->saveField('status',$status);

        $this->Session->setFlash(__('Status has been updated successfully!', true));

        $this->redirect(array('controller' => 'cmspages','action'=>'index'));

    }


}

?>