<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/

// +----------------------------------------------------------------------+

// | PHP version 4/5                                                      |

// +----------------------------------------------------------------------+

// | Copyright (c) 2004-2010 ARMIA INC                                    |

// +----------------------------------------------------------------------+

// | This source file is a part of iScripts VistaCart                     |

// +----------------------------------------------------------------------+

// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |

// +----------------------------------------------------------------------+

class UspsComponent extends Object{

	var $components = array('Xmlparser', 'Uspsintprice', 'Uspsprice','Uspserror');

    var $server = "";

    var $user = "";

    var $pass = "";

    var $service = "";

    var $dest_zip;

    var $orig_zip;

    var $pounds;

    var $ounces;

    var $container = "None";

    var $size = "REGULAR";

    var $machinable;

    var $country = "USA";

    

    function setServer($server) {

        $this->server = $server;

    }



    function setUserName($user) {

        $this->user = $user;

    }



    function setPass($pass) {

        $this->pass = $pass;

    }



    function setService($service) {

        /* Must be: Express, Priority, or Parcel */

        $this->service = $service;

    }

    

    function setDestZip($sending_zip) {

        /* Must be 5 digit zip (No extension) */

        $this->dest_zip = $sending_zip;

    }



    function setOrigZip($orig_zip) {

        $this->orig_zip = $orig_zip;

    }



    function setWeight($pounds, $ounces=0) {

        /* Must weight less than 70 lbs. */

        $this->pounds = $pounds;

        $this->ounces = $ounces;

    }



    function setContainer($cont) {

        $this->container = $cont;

    }



    function setSize($size) {

        $this->size = $size;

    }



    function setMachinable($mach) {

        /* Required for Parcel Post only, set to True or False */

        $this->machinable = $mach;

    }

    

    function setCountry($country) {

        $this->country = $country;

    }

    

    function getPrice() {

        if($this->country=="USA"){

            // may need to urlencode xml portion

            $str = $this->server. "?API=RateV3&XML=<RateV3Request%20USERID=\"";

            $str .= $this->user . "\"%20PASSWORD=\"" . $this->pass . "\"><Package%20ID=\"0\"><Service>";

            $str .= $this->service . "</Service><ZipOrigination>" . $this->orig_zip . "</ZipOrigination>";

            $str .= "<ZipDestination>" . $this->dest_zip . "</ZipDestination>";

            $str .= "<Pounds>" . $this->pounds . "</Pounds><Ounces>" . $this->ounces . "</Ounces>";

            $str .= "<Container>" . urlencode($this->container) . "</Container><Size>" . $this->size . "</Size>";

            $str .= "<Machinable>" . $this->machinable . "</Machinable></Package></RateV3Request>";

        }else {

            $str = $this->server. "?API=IntlRate&XML=<IntlRateRequest%20USERID=\"";

            $str .= $this->user . "\"%20PASSWORD=\"" . $this->pass . "\"><Package%20ID=\"0\">";

            $str .= "<Pounds>" . $this->pounds . "</Pounds><Ounces>" . $this->ounces . "</Ounces>";

            $str .= "<MailType>Package</MailType><Country>".urlencode($this->country)."</Country></Package></IntlRateRequest>";

        }

        

        $ch = curl_init();
         //echo $str;exit;
        // set URL and other appropriate options

        curl_setopt($ch, CURLOPT_URL, $str);

        curl_setopt($ch, CURLOPT_HEADER, 0);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);



        // grab URL and pass it to the browser

        $ats = curl_exec($ch);

        //echo $ats;exit;

        // close curl resource, and free up system resources

         curl_close($ch);
    
         //echo $ats;exit;

        $array = $this->Xmlparser->GetXMLTree($ats);

        if(isset($array['ERROR']) && count($array['ERROR'])) { // If it is error

            $this->Uspserror->number = $array['ERROR'][0]['NUMBER'][0]['VALUE'];

            $this->Uspserror->source = $array['ERROR'][0]['SOURCE'][0]['VALUE'];

            $this->Uspserror->description = $array['ERROR'][0]['DESCRIPTION'][0]['VALUE'];

            $this->Uspserror->helpcontext = $array['ERROR'][0]['HELPCONTEXT'][0]['VALUE'];

            $this->Uspserror->helpfile = $array['ERROR'][0]['HELPFILE'][0]['VALUE'];

            $this->error = $this->Uspserror;

        } else if(isset($array['RATEV3RESPONSE'][0]['PACKAGE'][0]['ERROR']) && count($array['RATEV3RESPONSE'][0]['PACKAGE'][0]['ERROR'])) {

            $this->Uspserror->number = $array['RATEV3RESPONSE'][0]['PACKAGE'][0]['ERROR'][0]['NUMBER'][0]['VALUE'];

            $this->Uspserror->source = $array['RATEV3RESPONSE'][0]['PACKAGE'][0]['ERROR'][0]['SOURCE'][0]['VALUE'];

            $this->Uspserror->description = $array['RATEV3RESPONSE'][0]['PACKAGE'][0]['ERROR'][0]['DESCRIPTION'][0]['VALUE'];

            $this->Uspserror->helpcontext = $array['RATEV3RESPONSE'][0]['PACKAGE'][0]['ERROR'][0]['HELPCONTEXT'][0]['VALUE'];

            $this->Uspserror->helpfile = $array['RATEV3RESPONSE'][0]['PACKAGE'][0]['ERROR'][0]['HELPFILE'][0]['VALUE'];

            $this->error = $this->Uspserror;        

        } else if(isset($array['INTLRATERESPONSE'][0]['PACKAGE'][0]['ERROR']) && count($array['INTLRATERESPONSE'][0]['PACKAGE'][0]['ERROR'])){ //if it is international shipping error

            $this->Uspserror->number = $array['INTLRATERESPONSE'][0]['PACKAGE'][0]['ERROR'][0]['NUMBER'][0]['VALUE'];

            $this->Uspserror->source = $array['INTLRATERESPONSE'][0]['PACKAGE'][0]['ERROR'][0]['SOURCE'][0]['VALUE'];

            $this->Uspserror->description = $array['INTLRATERESPONSE'][0]['PACKAGE'][0]['ERROR'][0]['DESCRIPTION'][0]['VALUE'];

            $this->Uspserror->helpcontext = $array['INTLRATERESPONSE'][0]['PACKAGE'][0]['ERROR'][0]['HELPCONTEXT'][0]['VALUE'];

            $this->Uspserror->helpfile = $array['INTLRATERESPONSE'][0]['PACKAGE'][0]['ERROR'][0]['HELPFILE'][0]['VALUE'];

            $this->error = $this->Uspserror;

        } else 
		  if(isset($array['RATEV3RESPONSE']) && empty($array['RATEV3RESPONSE'])===false){ // if everything OK
 
             if(count($array['RATEV3RESPONSE'])){ // 
            $this->zone = $array['RATEV3RESPONSE'][0]['PACKAGE'][0]['ZONE'][0]['VALUE'];

			$i=0;

            foreach ($array['RATEV3RESPONSE'][0]['PACKAGE'][0]['POSTAGE'] as $value)

			{

			    $this->Uspsprice->$i->mailservice = $value['MAILSERVICE'][0]['VALUE'];

                $this->Uspsprice->$i->rate = $value['RATE'][0]['VALUE'];

                $this->list[$i] = $this->Uspsprice->$i;

				$i++;

            }
			}

        }
		
		 else if (isset($array['INTLRATERESPONSE'][0]['PACKAGE'][0]['SERVICE'])) 
		 
		 {
		  if (count($array['INTLRATERESPONSE'][0]['PACKAGE'][0]['SERVICE'])) { // if it is international shipping and it is OK

            foreach($array['INTLRATERESPONSE'][0]['PACKAGE'][0]['SERVICE'] as $value) {

                $this->Uspsprice->id = $value['ATTRIBUTES']['ID'];

                $this->Uspsprice->pounds = $value['POUNDS'][0]['VALUE'];

                $this->Uspsprice->ounces = $value['OUNCES'][0]['VALUE'];

                $this->Uspsprice->mailtype = $value['MAILTYPE'][0]['VALUE'];

                $this->Uspsprice->country = $value['COUNTRY'][0]['VALUE'];

                $this->Uspsprice->rate = $value['POSTAGE'][0]['VALUE'];

                $this->Uspsprice->svccommitments = $value['SVCCOMMITMENTS'][0]['VALUE'];

                $this->Uspsprice->svcdescription = $value['SVCDESCRIPTION'][0]['VALUE'];

                $this->Uspsprice->maxdimensions = $value['MAXDIMENSIONS'][0]['VALUE'];

                $this->Uspsprice->maxweight = $value['MAXWEIGHT'][0]['VALUE'];

                $this->list[] = $this->Uspsprice;

            }

        }

        }

        return $this;

    }

}

?>