<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | This page is for user section management. Login checking , new user registration, user listing etc.                                      |
// | File name : index.php                                                  |
// | PHP version >= 5.2                                                   |
// | Created On	: 	Nov 17 2011                                               |
// +----------------------------------------------------------------------+
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems ? 2010                                      |
// | All rights reserved                                                  |
// +------------------------------------------------------


class ControllerUser extends BaseController {
    /*
		construction function. we can initialize the models here
    */
    public function init() {
        parent::init();
        PageContext::$body_class="home";

        PageContext::addScript("login.js");
        PageContext::addScript("hoverIntent.js");
        //PageContext::addScript("jquery-1.2.6.min.js");
        PageContext::addScript("superfish.js");
        //Tool Tip
        PageContext::addScript("jquery.tooltipster.min.js");
        PageContext::addScript("banner.js");

        User::googleAnalytics();
        PageContext::addPostAction('cloudfooterpage','index');

    }

    /*
    function to load the index template
    */
    public function index() { 
         if(LibSession::get('userID')){
            PageContext::addStyle("http://fonts.googleapis.com/css?family=Lato");
            PageContext::addStyle("global.css");
            PageContext::addStyle("home.css");
            PageContext::addStyle("product_details.css");
            PageContext::addScript("jquery.form.js");
            User::siteAnalytics();
            Logger::info("hello world");
        }else{
            $this->redirect('index');
        }
        $this->view->setLayout("home");
    }
    
    public function products($page = NULL,$action = NULL,$id = NULL) {
        PageContext::addStyle("http://fonts.googleapis.com/css?family=Lato");
        PageContext::addStyle("global.css");
        PageContext::addStyle("home.css");
        PageContext::addStyle("product_details.css");
        PageContext::addScript("userlogin.js");
        PageContext::addScript("jquery.form.js");
        PageContext::addPostAction('cloudtopmenu');
        PageContext::addPostAction('cloudfooter');
//        User::siteAnalytics();
        $pageFullContent    = User::getUserProducts();
        $pageFullCount      = count($pageFullContent);
        // PAGINATION AREA
        $pageInfoArr = Utils::pageInfo($page, $pageFullCount, PAGE_LIST_COUNT); //PAGE_LIST_COUNT

        $limit = $pageInfoArr['limit'];
        $this->view->pageInfo = $pageInfoArr;
        $this->view->txtSearch = $txtSearch;
        $this->view->pageContents = User::getUserProducts($txtSearch, $limit);
        Logger::info("hello world");
        $this->view->setLayout("dashboard");

    }

    public function subscriptions() {
        PageContext::addStyle("http://fonts.googleapis.com/css?family=Lato");
        PageContext::addStyle("global.css");
        PageContext::addStyle("home.css");
        PageContext::addStyle("product_details.css");
        PageContext::addScript("userlogin.js");
        PageContext::addScript("jquery.form.js");
        PageContext::addPostAction('cloudtopmenu');
        PageContext::addPostAction('cloudfooter');
        User::siteAnalytics();
        Logger::info("hello world");
        $this->view->setLayout("home");

    }
    //Profile functionality
    public function profile($activeTab = 'accountdetails') {

        if(LibSession::get('userID')){          
            PageContext::addStyle("http://fonts.googleapis.com/css?family=Lato");
            PageContext::addStyle("global.css");
         //   PageContext::addStyle("home.css");
          //  PageContext::addStyle("product_details.css");
            PageContext::addScript("userlogin.js");
            PageContext::addScript("jquery.form.js");
            PageContext::addScript("jquery.metadata.js");
            PageContext::addScript("jquery.validate.js");
         //   PageContext::addPostAction('cloudtopmenu');
         // PageContext::addPostAction('cloudfooter');
              PageContext::addPostAction('cloudtopmenupage','index');
            User::siteAnalytics();
  		Utils::loadActiveTheme();
  			PageContext::$response->themeUrl = Utils::getThemeUrl();
            $this->view->activeTab = $activeTab;
            switch($activeTab) {
                case 'accountdetails':
                    $this->view->accountDetailsStyle ="selected";
                    $this->view->changePasswordStyle ="";
                    $this->view->changeCreditCardStyle ="";
                    if($this->isPost()) {
                        $status = User::updateUserProfile($_POST);
                    }
                    $this->view->userDetails = User::fetchUserProfile();
                    break;
                case 'changepassword':
                    $this->view->accountDetailsStyle ="";
                    $this->view->changePasswordStyle ="selected";
                    $this->view->changeCreditCardStyle ="";
                    if($this->isPost()) {
                        $status = User::updateUserPassword($_POST);
                    }
                    break;
                case 'changecreditcard':
                    $this->view->accountDetailsStyle ="";
                    $this->view->changePasswordStyle ="";
                    $this->view->changeCreditCardStyle ="selected";
                    if($this->isPost()) {
                        $status = User::updateUserCreditCardDetails($_POST);
                    }
                    $this->view->cardDetails = User::fetchUserCreditCardDetails();
                    break;
            }
            if($status) {
                unset ($_POST);
                $this->view->messageFunction = 'successmessage';
            }else {
                $this->view->messageFunction = 'errormessage';
            }
        }else{
            $this->redirect('index');
        }
        $this->view->setLayout("dashboard");
        
    }

    public function payments($page = NULL,$action = NULL,$id = NULL) {
        //LibSession::set('userID','1');
        if(LibSession::get('userID')){           
            PageContext::addStyle("http://fonts.googleapis.com/css?family=Lato");
            PageContext::addStyle("global.css");
            //PageContext::addStyle("home.css");
            PageContext::addStyle("product_details.css");
            PageContext::addScript("jquery.form.js");
            PageContext::addScript("jquery.addplaceholder.min.js");
            User::siteAnalytics();
            //PageContext::addPostAction('cloudtopmenu');
            PageContext::addPostAction('cloudfooter');
            
            //$pageFullContent    = User::userPayments();
           // $pageFullCount      = count($pageFullContent);
            
            PageContext::addPostAction('cloudtopmenupage','index'); 
            Utils::loadActiveTheme();
            PageContext::$response->themeUrl = Utils::getThemeUrl();
            
            
            // PAGINATION AREA
            $pageInfoArr = Utils::pageInfo($page, $pageFullCount, PAGE_LIST_COUNT); //PAGE_LIST_COUNT
            $limit = $pageInfoArr['limit'];

            if($this->isPost() && $_POST['search']) {
                $txtSearch = trim($_POST['search']);
                $this->view->searchParam = $txtSearch;
                //$searchArr = array(array('field' => 'vPlanDescription', 'value' => $txtSearch), array('field' => 'nAmount', 'value' => $txtSearch), array('field' => 'vTransactionId', 'value' => $txtSearch), array('field' => 'dPaymentDate', 'value' => date('Y-m-d',strtotime($txtSearch))));
            }
       
            $this->view->pageInfo = $pageInfoArr;
            $this->view->txtSearch = $txtSearch;
            $this->view->pageContents = User::userPayments($txtSearch);
            
        }else{
            $this->redirect('index');
        }
        $this->view->setLayout("dashboard");

    }

    /*
    Function to logout the user
    */
    public function logout() {
        session_destroy();
        session_unset($_SESSION['user']);

        header("location:".ConfigUrl::base());
        $this->view->disableView();
        exit();
    }

    public function dashboard($statusFlag) { 
        //LibSession::set('userID','1');
        if(LibSession::get('userID')){            
            PageContext::addStyle("http://fonts.googleapis.com/css?family=Lato");
            PageContext::addStyle("global.css");
          //  PageContext::addStyle("home.css");
           // PageContext::addStyle("product_details.css");
           // PageContext::addScript("jquery.form.js");
           // PageContext::addScript("jquery.metadata.js");
           // PageContext::addScript("jquery.validate.js");
            PageContext::addPostAction('cloudtopmenu');
            PageContext::addPostAction('cloudtopmenupage','index');
            
            //PageContext::addPostAction('cloudfooter');
            
           // PageContext::addPostAction('cloudfooterpage','index');
             

            PageContext::$response->themeUrl = Utils::getThemeUrl();
            
            User::siteAnalytics();
            Utils::loadActiveTheme();
            PageContext::$response->freeTrials = User::fetchFreeTrialsOfLoggedInUser();
            PageContext::$response->subscriptions = User::fetchSubscriptionsOfLoggedInUser();
        }else{
            $this->redirect('index');
        }
        if($statusFlag==1)
        {
            PageContext::$response->success_message = "Successfully removed the account details!";
            PageContext::addPostAction('successmessage');
            $this->view->messageFunction = 'successmessage';
        }
        elseif($statusFlag==2)
        {
            PageContext::$response->error_message = "Account termination failed, please retry after some time";
            PageContext::addPostAction('errormessage');
            $this->view->messageFunction = 'errormessage';
        }
        $this->view->setLayout("dashboard");
    }

    //functionality to load cloud top menu
    public function cloudtopmenu() {

    }
    //functionality to load cloud footer with all contents
    public function cloudfooter() {

    }

    //functionality to load cloud footer with limited contents
    public function cloudlimitedfooter() {

    }

    public function successmessage() {

    }

    public function errormessage() {

    }

    public function unjoin($productLookUpId)
    {                
        $statusArray = Cronhelper::doStoreTermination($productLookUpId);
        $this->view->disableView();
       
        if($statusArray)
        {

            $this->redirect('user/dashboard/1/');
        }
        else
        {
            $this->redirect('user/dashboard/2/');
        }
        die;
    }
   

    // Function for Settlements

    public function settlements($page = NULL,$action = NULL,$id = NULL) {

        if(LibSession::get('userID')){
            
            PageContext::addStyle("http://fonts.googleapis.com/css?family=Lato");
            PageContext::addStyle("global.css");
            //PageContext::addStyle("home.css");
            PageContext::addStyle("product_details.css");
            PageContext::addScript("jquery.form.js");
            PageContext::addScript("jquery.addplaceholder.min.js");
            User::siteAnalytics();
            //PageContext::addPostAction('cloudtopmenu');
            PageContext::addPostAction('cloudfooter');
            
            //$pageFullContent    = User::userPayments();
           // $pageFullCount      = count($pageFullContent);
            
            PageContext::addPostAction('cloudtopmenupage','index'); 
            Utils::loadActiveTheme();
            PageContext::$response->themeUrl = Utils::getThemeUrl();
            
            
            // PAGINATION AREA
            $pageInfoArr = Utils::pageInfo($page, $pageFullCount, PAGE_LIST_COUNT); //PAGE_LIST_COUNT
            $limit = $pageInfoArr['limit'];

            if($this->isPost() && $_POST['search']) {
                $txtSearch = trim($_POST['search']);
                $this->view->searchParam = $txtSearch;
                //$searchArr = array(array('field' => 'vPlanDescription', 'value' => $txtSearch), array('field' => 'nAmount', 'value' => $txtSearch), array('field' => 'vTransactionId', 'value' => $txtSearch), array('field' => 'dPaymentDate', 'value' => date('Y-m-d',strtotime($txtSearch))));
            }
            
            $addFormDisplay = false;
            /*if(isset($_REQUEST['add_request'])){
                $addFormDisplay = true;
            }*/
       
            $this->view->pageInfo = $pageInfoArr;
            $this->view->addFormDisplay = $addFormDisplay;
            $this->view->pageContents = User::userSettlements();
        }else{
            $this->redirect('index');
        }
        $this->view->setLayout("dashboard");

    }
    public function addrequest($page = NULL,$action = NULL,$id = NULL) {
            $objLib = new LibSession;
            $userId = $objLib->get('userID');    
            $editFormDisplay=1;
        if(LibSession::get('userID')){            
            PageContext::addStyle("http://fonts.googleapis.com/css?family=Lato");
            PageContext::addStyle("global.css");
            //PageContext::addStyle("home.css");
            PageContext::addStyle("product_details.css");
            PageContext::addScript("jquery.form.js");
            PageContext::addScript("jquery.addplaceholder.min.js");
            PageContext::addScript("addrequest.js");  
            User::siteAnalytics();
            //PageContext::addPostAction('cloudtopmenu');
            PageContext::addPostAction('cloudfooter');            
                       
            PageContext::addPostAction('cloudtopmenupage','index'); 
            Utils::loadActiveTheme();
            PageContext::$response->themeUrl = Utils::getThemeUrl();            
            
            // PAGINATION AREA
            $pageInfoArr = Utils::pageInfo($page, $pageFullCount, PAGE_LIST_COUNT); //PAGE_LIST_COUNT
            $limit = $pageInfoArr['limit'];
            if($_GET['id']!='')
            {
                $details = User::getSettlements(trim($_GET['id']));

               if($details->eStatus=="Pending")
                {                
                    $this->view->pageInfo = $details;                    
                }
                else
                {
                    PageContext::$response->message = "This request cannot be edited.";
                    $editFormDisplay=0;
                }
            }
                
            if($this->isPost()) {
               $requestdata['nId']=$this->post('nId');
               $requestdata['nUId']=$userId;
               $requestdata['nRequestedAmount']=$this->post('nRequestedAmount');
               $requestdata['tUserComments']=$this->post('tUserComments');
                if (User::saveSettlements($requestdata))
                     $this->redirect('user/settlements');
                else 
                     PageContext::$response->message = "Internal Errors";            

            }             
       
           $this->view->editFormDisplay = $editFormDisplay;
            
            
        }else{
            $this->redirect('index');
        }
        $this->view->setLayout("dashboard");

    }

    public function doUserLogInForCMS($userid=''){
        $this->view->disableView();
        $session = new LibSession();
        $status = 0;
         if($session->get('admin_logged_in','cms') == 1 ){

            $userData = Admincomponents::getUserdetails($userid);           
            $userName = $userData->vEmail;
            $password = $userData->vPassword;
            $status = User::validateLogin($userName,$password);
            
        }
        if($status==1){            
          Admin::setSupportDeskSessions($userName);          
          $this->redirect('user/dashboard');
        } else {
            $this->redirect('index');
        }

        die();
    }
     public function invoiceDetails($page = NULL,$action = NULL,$id = NULL) {
            $objLib = new LibSession;
            $userId = $objLib->get('userID'); 
            $editFormDisplay=1;
        if(LibSession::get('userID')){            
            PageContext::addStyle("http://fonts.googleapis.com/css?family=Lato");
            PageContext::addStyle("global.css");
            //PageContext::addStyle("home.css");
            PageContext::addStyle("product_details.css");
            PageContext::addScript("jquery.form.js");
            PageContext::addScript("jquery.addplaceholder.min.js");
            PageContext::addScript("addrequest.js");  
            User::siteAnalytics();
            //PageContext::addPostAction('cloudtopmenu');
            PageContext::addPostAction('cloudfooter');            
                       
            PageContext::addPostAction('cloudtopmenupage','index'); 
            Utils::loadActiveTheme();
            PageContext::$response->themeUrl = Utils::getThemeUrl();            
            
            // PAGINATION AREA
            $pageInfoArr = Utils::pageInfo($page, $pageFullCount, PAGE_LIST_COUNT); //PAGE_LIST_COUNT
            $limit = $pageInfoArr['limit'];
            if($_GET['id']!='')
            {
                if($_GET['vtype']=='invoice'){
                   //$this->view->pageContents =  User::userInvoiceDetails(trim($_GET['id']));
                   $this->view->dataArr = User::getInvoiceDetails(trim($_GET['id']));
                   $this->view->dataDomArr = User::getInvoiceDomainDetails(trim($_GET['id']));
                }else {
                    $this->view->dataArr = User::getInvoiceTemplateDetails(trim($_GET['id']));
                }
                   
            }
            
            
        }else{
            $this->redirect('index');
        }
        $this->view->setLayout("dashboard");

    }



}

?>