TRUNCATE TABLE `cms_sections`;
INSERT INTO `cms_sections` (`id`, `group_id`, `section_name`, `section_alias`, `table_name`, `section_config`, `visibilty`, `display_order`, `user_privilege`) VALUES
	(6, 1, 'Plans', 'plans', 'tbl_ProductServices', '{"customAction":"true","controller":"products","method":"listplans","module":"admin"}\r\n', '1', 8, 'all'),
	(1, 3, 'Manage Groups', 'groups', 'cms_groups', '{\r\n"keyColumn":"id",\r\n"orderBy":{"id":"ASC"},\r\n"publishColumn":"published",\r\n"listColumns":["group_name","user_privilege"],\r\n"showColumns":["id","group_name","position","user_privilege"],\r\n"detailColumns":["id","group_name","position","user_privilege"],\r\n"detailHeaderColumns":["group_name"],\r\n"columns":{\r\n    "id":{"name":"ID","sortable":"true","editoptions":{"type":"hidden"}},\r\n    "group_name":{"name":"Group Name","sortable":"true","searchable":"searchable","editoptions":{"type":"textbox","label":"Group Name","class":"textbox"}},\r\n    "position":{"name":"Display Order","sortable":"true","editoptions":{"type":"textbox","label":"Display Order","class":"textbox"}},\r\n    "user_privilege":{"name":"Privilege","sortable":"true","searchable":"searchable","editoptions":{"type":"select","source":{"all":"All","s":"Superadmin"},"source_type":"array","label":"Privilege","class":"select","enumvalues":{"all":"All","s":"Superadmin"}}}\r\n    },\r\n"opertations":["add","edit","delete","view","publish"]\r\n}', '1', 2, 'all'),
	(2, 3, 'Manage Sections', 'sections', 'cms_sections', '{\r\n"keyColumn":"id",\r\n"orderBy":{"id":"ASC"},\r\n"listColumns":["group_id","section_name","section_alias","visibilty","display_order"],\r\n"showColumns":["id","group_id","section_name","section_alias","table_name","section_config","visibilty","display_order"],\r\n"detailColumns":["id","group_id","section_name","section_alias","table_name","section_config","visibilty","display_order"],\r\n"detailHeaderColumns":["section_name"],\r\n"columns":{\r\n    "id":{"name":"ID","sortable":"true","editoptions":{"type":"hidden"}},\r\n    "group_id":{"name":"Group ID","sortable":"true","searchable":"searchable","editoptions":{"validations":["required"],"type":"select","source":"Cms::getAllGroups","source_type":"function","label":"Group Name","class":"select"},"external":"true","externalOptions":{"externalTable":"cms_groups","externalColumn":"id","externalShowColumn":"group_name"}},\r\n    "section_name":{"name":"Section Name","sortable":"true","searchable":"searchable","editoptions":{"validations":["required"],"type":"textbox","label":"Section Name","class":"textbox"}},\r\n    "section_alias":{"name":"Section Alias","sortable":"true","searchable":"searchable","editoptions":{"validations":["required"],"type":"textbox","label":"Section Alias","class":"textbox"}},\r\n    "table_name":{"name":"Table Name","editoptions":{"validations":["required"],"type":"textbox","label":"Table Name","class":"textbox"}},\r\n    "section_config":{"name":"Section Config","editoptions":{"validations":["required"],"type":"textarea","label":"Section Config","class":"textarea"}},\r\n    "visibilty":{"name":"Make Visible","sortable":"true","searchable":"searchable","editoptions":{"type":"checkbox","label":"Make Visible","class":"inline","default":"yes","enumvalues":{"1":"Visible","0":"Invisible"}}},\r\n    "display_order":{"name":"Display Order","sortable":"true","searchable":"searchable","editoptions":{"type":"textbox","label":"Display Order","class":"textbox"}}\r\n    },\r\n"opertations":["add","edit","delete","view","publish"]\r\n}', '1', 3, 'all'),
	(3, 3, 'Manage Settings', 'manage_settings', 'tbl_cms_settings', '{\r\n"keyColumn":"id",\r\n"listColumns":["cms_set_name","cms_set_value"],\r\n"showColumns":["cms_set_name","cms_set_value"],\r\n"detailColumns":["id","cms_set_name","cms_set_value"],\r\n"detailHeaderColumns":["cms_set_name"],\r\n"columns":{\r\n    "id":{"name":"ID","sortable":"true","editoptions":{"type":"hidden"}},\r\n    "cms_set_name":{"name":"Name","sortable":"true","searchable":"searchable","editoptions":{"type":"disabled","label":"Name"}},\r\n    "cms_set_value":{"name":"Value","sortable":"true","searchable":"searchable","editoptions":{"type":"textbox","label":"Value","class":"textbox"}}\r\n},\r\n"opertations":["edit","view"]\r\n}', '1', 1, 'all'),
	(17, 10, 'Admin Help', 'adminHelp', 'tbl_Help', '{\r\n    "keyColumn": "nId",\r\n"detailHeaderColumns":["vTitle"],\r\n    "orderBy": {\r\n        "vTitle": "ASC"\r\n    },\r\n    "where": "tbl_Help.eType=\'Admin\'",\r\n    "listColumns": [\r\n        "vTitle",\r\n        "eStatus"\r\n    ],\r\n    "showColumns": [\r\n        "nId",\r\n        "vTitle",\r\n        "tDescription",\r\n        "eType",\r\n        "eStatus"\r\n    ],\r\n    "detailColumns": [\r\n        "nId",\r\n        "vTitle",\r\n        "tDescription",\r\n        "eStatus",\r\n        "eType"\r\n    ],\r\n    "columns": {\r\n        "nId": {\r\n            "name": "ID"\r\n        },\r\n        "vTitle": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "tDescription": {\r\n            "name": "Description",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "htmlEditor",\r\n                "label": "Description"\r\n            }\r\n        },\r\n        "eType": {\r\n            "name": "Help Category",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "Admin": "Admin",\r\n                    "User": "User"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Category",\r\n                "enumvalues": {\r\n                    "Admin": "Admin",\r\n                    "User": "User"\r\n                }\r\n            }\r\n        },\r\n        "eStatus": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "Active": "Active",\r\n                    "Disabled": "Disabled"\r\n                },\r\n                "label": "Status",\r\n                "enumvalues": {\r\n                    "Active": "Active",\r\n                    "Disabled": "Disabled"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "edit",\r\n        "delete",\r\n        "view"\r\n    ]\r\n}', '1', 10, 'all'),
	(7, 9, 'Settings', 'settings', ' tbl_Settings', '{"customAction":"true","controller":"module","method":"settingsdisplay","module":"admin"}\r\n', '1', 1, 'all'),
	(8, 1, 'Users', 'user', 'tbl_User', '{\r\n    "keyColumn": "nUId",\r\n    "detailHeaderColumns": [\r\n        "vFirstName",\r\n        "vLastName"\r\n    ],\r\n    "detailHeaderColumnPrefix": "User: ",\r\n    "orderBy": {\r\n        "vFirstName": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "vFirstName",\r\n        "vLastName",\r\n        "vEmail",\r\n        "nStatus",\r\n        "plans"\r\n    ],\r\n    "detailColumns": [\r\n        "nUId",\r\n        "vFirstName",\r\n        "vLastName",\r\n        "vEmail",\r\n        "vInvoiceEmail",\r\n        "vAddress",\r\n        "vCity",\r\n        "vState",\r\n        "vCountry",\r\n        "vZipcode",\r\n        "vPhoneNumber",\r\n        "vFax",\r\n        "nStatus",\r\n        "plans"\r\n    ],\r\n    "showColumns": [\r\n        "nUId",\r\n        "vFirstName",\r\n        "vLastName",\r\n        "vEmail",\r\n        "vInvoiceEmail",\r\n        "vAddress",\r\n        "vCity",\r\n        "vState",\r\n        "vCountry",\r\n        "vZipcode",\r\n        "vPhoneNumber",\r\n        "vFax",\r\n        "nStatus"\r\n    ],\r\n    "columns": {\r\n        "nUId": {\r\n            "name": "ID"\r\n        },\r\n        "vFirstName": {\r\n            "name": "First Name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "First Name",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vLastName": {\r\n            "name": "Last Name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Last Name",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vEmail": {\r\n            "name": "Contact Email",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Contact Email",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vInvoiceEmail": {\r\n            "name": "Invoice Email",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Invoice Email",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vAddress": {\r\n            "name": "Address",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Address",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vCity": {\r\n            "name": "City",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "City",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vState": {\r\n            "name": "State",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "State",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vCountry": {\r\n            "name": "Country",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Country",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vZipcode": {\r\n            "name": "Zip Code",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Zip Code",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vPhoneNumber": {\r\n            "name": "Phone",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Phone",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vFax": {\r\n            "name": "Fax",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Fax",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "nStatus": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "2": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "2": "Inactive"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::changeUserStatus",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "2": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "1": "green",\r\n                    "2": "red"\r\n                }\r\n            }\r\n        },\r\n        "plans": {\r\n            "name": "Plans",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getCmsUserPlanDetails"\r\n        }\r\n    },\r\n    "customOperations": {\r\n        "login": {\r\n            "options": {\r\n                "target": "newtab",\r\n                "name": "Login",\r\n                "linkSource": "Admin::getuserLogInUrl"\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "add",\r\n        "delete"\r\n    ]\r\n}', '1', 7, 'all'),
	(9, 1, 'Dashboard', 'dashboard', 'tbl_ProductLookup', '{\r\n    "dashboardPanel": "true",\r\n    "graphPanel": "true",\r\n    "graphpanelRow": "2",\r\n    "graphPanel1": {\r\n        "columns": "2",\r\n        "graph1": {\r\n            "type": "MSColumn3D",\r\n            "caption":"Total Domain Registrations",\r\n            "xAxisName":"Last 7 Days",\r\n             "yAxisName":"Domain Registaration Count",\r\n            "width":"480",\r\n             "height":"300",\r\n             "dataSetsCount":"2",\r\n             "dataSets":{"dataset1":{"name":"","color":"#D3AC4F","fetchValue":"Admin::getRegistredDomainCount"}}\r\n\r\n        },\r\n        "graph2": {\r\n            "type": "MSLine",\r\n             "caption":"Total Users",\r\n             "xAxisName":"Last 7 Days",\r\n             "yAxisName":"User Count",\r\n            "width":"480",\r\n             "height":"300",\r\n               "dataSetsCount":"1",\r\n              "dataSets":{"dataset1":{"name":"","color":"#D3AC4F","fetchValue":"Admin::getUsersCount"}}\r\n\r\n        }\r\n    },\r\n    "graphPanel2": {\r\n        "columns": "2",\r\n        "graph1": {\r\n            "type": "MSColumn3D",\r\n             "caption":"Total Stores Created",\r\n             "xAxisName":"Last 7 Days",\r\n             "yAxisName":"Store Count",\r\n            "width":"480",\r\n             "height":"300",\r\n               "dataSetsCount":"1",\r\n              "dataSets":{"dataset1":{"name":"","color":"#D3AC4F","fetchValue":"Admin::getStoresCount"}}\r\n        },\r\n        "graph2": {\r\n            "type": "MSColumn3D",\r\n             "caption":"Free Trials By Month",\r\n             "xAxisName":"Last 7 Days",\r\n             "yAxisName":"Free Trails Count",\r\n            "width":"480",\r\n             "height":"300",\r\n               "dataSetsCount":"1",\r\n              "dataSets":{"dataset1":{"name":"","color":"#D3AC4F","fetchValue":"Admin::getFreeTrialsCount"}}\r\n\r\n        }\r\n    }\r\n}', '1', 0, 'all'),
	(10, 1, 'Invoices', 'invoice', 'tbl_Invoice', '{\r\n    "keyColumn": "nInvId",\r\n    "orderBy": {\r\n        "dGeneratedDate": "DESC"\r\n    },\r\n    "detailHeaderColumns": ["vInvNo"],\r\n    "detailHeaderColumnPrefix": "Invoice: ",\r\n    "listColumns": [\r\n        "vInvNo",\r\n        "vSubscriptionType",\r\n        "nUId",\r\n        "dGeneratedDate",\r\n        "dDueDate",\r\n        "dPayment",\r\n        "pStatus",\r\n        "nTotal"\r\n    ],\r\n    "detailColumns": [\r\n        "nInvId",\r\n        "vInvNo",\r\n        "vSubscriptionType",\r\n        "vTxnId",\r\n        "nUId",\r\n        "dGeneratedDate",\r\n        "dDueDate",\r\n        "dPayment",\r\n        "pStatus",\r\n        "nTotal"\r\n    ],\r\n    "columns": {\r\n        "nInvId": {\r\n            "name": "ID"\r\n        },\r\n        "vInvNo": {\r\n            "name": "Invoice Number",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getCmsInvoiceDetails"\r\n        },\r\n        "pStatus": {\r\n            "name": "Payment Status",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getPaymentStatus"\r\n        },\r\n\r\n        "vSubscriptionType": {\r\n            "name": "Subscription",\r\n            "searchable": "searchable",\r\n            "sortable": "true"\r\n        },\r\n        "vTxnId": {\r\n            "name": "Transaction ID"\r\n        },\r\n        "nUId": {\r\n            "name": "User",\r\n            "sortable": "true",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getUsernameFromInvoice"\r\n        },\r\n        "dGeneratedDate": {\r\n            "name": "Generated On",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "dbFormat": "timestamp",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n        "dDueDate": {\r\n            "name": "Due On",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "dbFormat": "timestamp",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n        "dPayment": {\r\n            "name": "Paid On",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getInvoicePaidDateForCMS"\r\n        },\r\n        "nTotal": {\r\n            "name": "Total Amount",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "listHeaderPostfix": "Admincomponents::getCurrencySymbolForCms",\r\n"lsHeaderPostfixCustom": "true",\r\n"decimalPoint":"2"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view"\r\n    ],\r\n    "report": {\r\n        "reportTitle": "Invoices",\r\n        "columns": [\r\n            "vInvNo",\r\n            "vSubscriptionType",\r\n            "vTxnId",\r\n            "nUId",\r\n            "dGeneratedDate",\r\n            "dDueDate",\r\n            "dPayment",\r\n            "pStatus",\r\n            "nTotal"\r\n        ],\r\n        "dateColumn": "dGeneratedDate"\r\n    }\r\n}', '1', 3, 'all'),
	(40, 9, 'Screenshots', 'screenshots', 'tbl_DemoScreenshots', '{\r\n    "keyColumn": "nScreenId",\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "nScreenId": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "eType",       \r\n        "vScreenImageId",\r\n        "vActive"       \r\n    ],\r\n    "showColumns": [\r\n        "nScreenId",\r\n        "eType",        \r\n        "vScreenImageId",\r\n        "vActive"       \r\n    ],\r\n    "detailColumns": [\r\n        "nScreenId",\r\n        "eType",       \r\n        "vScreenImageId",\r\n        "vActive"        \r\n    ],\r\n    "columns": {\r\n        "eType": {\r\n            "name": "Screen Type",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "source": {\r\n                    "User": "User Panel Screen",\r\n                    "Admin": "Admin Panel Screen"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Screen Type",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "User": "User Panel Screen",\r\n                    "Admin": "Admin Panel Screen"\r\n                }\r\n            }\r\n        },               \r\n        "vScreenImageId": {\r\n            "name": "Screen Image",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Screen Image",\r\n                "class": "file",\r\n                "hint": "User Panel Screen : Ideal Width & Height - 400px X 231px <br> Admin Panel Screen : Ideal Width & Height - 400px X 231px"\r\n            },\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getCmsScreenImage"\r\n        },        \r\n        "vActive": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "checkbox",\r\n                "label": "Enable Screen",\r\n                "default": "yes",\r\n                "enumvalues": {\r\n                    "0": "Inactive",\r\n                    "1": "Active"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::changeScreenStatus",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "1": "green",\r\n                    "0": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "edit",\r\n        "delete",\r\n        "publish"\r\n    ]\r\n}', '1', 7, 'all'),
	(12, 1, 'Feedback', 'feedback', 'tbl_contacts', '{\r\n    "keyColumn": "id",\r\n    "orderBy": {\r\n        "cdate": "ASC"\r\n    },\r\n    "detailHeaderColumns": ["cname"],\r\n    "detailHeaderColumnPrefix": "Feedback: ",\r\n    "listColumns": [\r\n        "cname",\r\n        "cemail",\r\n        "cdescr",\r\n        "cdate"\r\n    ],\r\n    "detailColumns": [\r\n        "id",\r\n        "cname",\r\n        "cemail",\r\n        "cdescr",\r\n        "cdate"\r\n    ],\r\n    "columns": {\r\n    "id":{"name":"ID"},\r\n        "cname": {\r\n            "name": "Customer",\r\n            "searchable": "searchable",\r\n            "sortable": "true"\r\n        },\r\n        "cemail": {\r\n            "name": "Email",\r\n            "searchable": "searchable",\r\n            "sortable": "true"\r\n        },\r\n        "cdescr": {\r\n            "name": "Feedbacks",\r\n            "sortable": "true"\r\n        },\r\n        "cdate": {\r\n            "name": "Date",\r\n            "sortable": "true",\r\n            "dbFormat":"datetime",\r\n            "displayFormat":"m/d/Y"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "delete"\r\n    ]\r\n}', '1', 6, 'all'),
	(13, 9, 'Server Info', 'serverinfo', 'tbl_ServerInfo', '{\r\n    "keyColumn": "nserver_id",\r\n    "orderBy": {\r\n        "vserver_name": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "vserver_name",\r\n        "vmakethisserver_default",\r\n        "whm_port",\r\n        "cpanel_port"\r\n    ],\r\n    "showColumns": [\r\n        "nserver_id",\r\n        "vserver_name",\r\n        "whmuser",\r\n        "whmpass",\r\n        "whmip",\r\n        "vserver_hosting_plan",\r\n        "vserver_configfilename",\r\n        "vserver_configfilepath",\r\n\r\n        "whm_port",\r\n        "cpanel_port",\r\n\r\n        "vmakethisserver_default"\r\n    ],\r\n    "detailColumns": [\r\n        "nserver_id",\r\n        "vserver_name",\r\n        "whmuser",\r\n        "whmpass",\r\n        "whmip",\r\n        "vserver_hosting_plan",\r\n        "vserver_configfilename",\r\n        "vserver_configfilepath",\r\n\r\n        "whm_port",\r\n        "cpanel_port",\r\n\r\n        "vmakethisserver_default"\r\n    ],\r\n    "detailHeaderColumns": [\r\n        "vserver_name"\r\n    ],\r\n    "detailHeaderColumnPrefix": "Server Info: ",\r\n    "columns": {\r\n        "nserver_id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vserver_name": {\r\n            "name": "Server",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Server Name",\r\n                "class": "textbox",\r\n                "hint": "Enter your Host name eg: yoursitename.com"\r\n            }\r\n        },\r\n        "whmuser": {\r\n            "name": "WHM User",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "WHM User",\r\n                "class": "textbox",\r\n                 "hint": "Enter the WHM user name"\r\n            }\r\n        },\r\n        "whmpass": {\r\n            "name": "WHM Password",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "password",\r\n                "label": "WHM Password",\r\n"noEncryption" : "true",\r\n                "source":"Admincomponents::cipherPassword",           \r\n                "source_type":"function",\r\n                "class": "textbox",\r\n                 "hint": "Enter the WHM password"\r\n            }\r\n        },\r\n        "whmip": {\r\n            "name": "WHM IP",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "WHM IP",\r\n                "class": "textbox",\r\n                 "hint": "Enter WHM IP"\r\n            }\r\n        },\r\n        "vserver_hosting_plan": {\r\n            "name": "Server Package Name",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Server Package Name",\r\n                "class": "textbox",\r\n                 "hint": "Enter the server package name/ hosting package name"\r\n            }\r\n        },\r\n        "vserver_configfilename": {\r\n            "name": "Product Pack Location",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Product Pack Location",\r\n                "source":"Admincomponents::getDefaultPackLocation",\r\n                "source_type":"function",\r\n                "class": "textbox",\r\n                 "hint": "Enter the product pack locaton eg: /home/yourWHMusername/public_html/project/products/"\r\n            }\r\n        },\r\n        "vserver_configfilepath": {\r\n            "name": "Setup Landing Location",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Setup Landing Location",\r\n"source":"Admincomponents::getDefaultLandingLocation",\r\n                "source_type":"function",\r\n                "class": "textbox",\r\n                 "hint": "Enter the setup landing location eg: /public_html/"\r\n            }\r\n        },\r\n\r\n\r\n         "whm_port": {\r\n            "name": "WHM Port",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "WHM Port",\r\n                "class": "textbox",\r\n                 "hint": "Enter the WHM Port eg: 2086 / 2087(secure)"\r\n            }\r\n        },\r\n         "cpanel_port": {\r\n            "name": "CPanel Port",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "CPanel Port",\r\n                "class": "textbox",\r\n                 "hint": "Enter the CPanel Port eg : 2082 / 2083(secure)"\r\n            }\r\n        },\r\n\r\n\r\n\r\n\r\n        "vmakethisserver_default": {\r\n            "name": "Default Server",\r\n            "editoptions": {\r\n                "type": "checkbox",\r\n                "label": "Make Default Server",\r\n                "class": "inline",\r\n                 "hint": "Check this to enable this as default server",\r\n                "default": "NO",\r\n                "enumvalues": {\r\n                    "1": "YES",\r\n                    "0": "NO"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::getServerDefaultUrl",\r\n                "enumvalues": {\r\n                    "1": "YES",\r\n                    "0": "NO"\r\n                },\r\n                "buttonColors": {\r\n                    "1": "green",\r\n                    "0": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "customActions": {\r\n        "afterEditRecord": "Admincomponents::updateDomainStatus",\r\n        "afterAddRecord": "Admincomponents::updateDomainStatus"\r\n    },\r\n    "opertations": [\r\n        "add",\r\n      "edit",\r\n"delete"\r\n\r\n    ]\r\n}', '1', 5, 'all'),
	(14, 1, 'Plan Features', 'product_service_features', 'tbl_ServiceFeatures', '{\r\n"keyColumn": "nFeatureId",\r\n"orderBy": {\r\n    "nFeatureId": "DESC"\r\n},\r\n"detailHeaderColumns": ["tFeatureName"],\r\n"detailHeaderColumnPrefix": "Plan Feature: ",\r\n"listColumns": [\r\n    "tFeatureName",\r\n    "tValue",\r\n    "eStatus"\r\n],\r\n"showColumns": [\r\n    "nFeatureId",\r\n    "tFeatureName",\r\n    "tValue",\r\n    "eStatus"\r\n],\r\n"detailColumns": [\r\n    "nFeatureId",\r\n    "tFeatureName",\r\n    "tValue",\r\n    "eStatus"\r\n],\r\n"columns": {\r\n    "nFeatureId": {\r\n        "name": "ID",\r\n        "editoptions": {\r\n            "type": "hidden"\r\n        }\r\n    },\r\n    "tFeatureName": {\r\n        "name": "Name",\r\n        "sortable": "true",\r\n        "editoptions": {\r\n            "validations": [\r\n                    "required"\r\n                ],\r\n            "type": "textbox",\r\n            "label": "Name"\r\n        }\r\n    },\r\n    "tValue": {\r\n        "name": "Value",\r\n        "sortable": "true",\r\n        "editoptions": {\r\n            "validations": [\r\n                    "required"\r\n                ],\r\n            "type": "textbox",\r\n            "label": "Value"\r\n        }\r\n    },\r\n    "eStatus": {\r\n        "name": "Status",\r\n        "editoptions": {\r\n            "validations": [\r\n                    "required"\r\n                ],\r\n            "type": "select",\r\n            "source": {\r\n            "Active": "Active",\r\n            "Disabled": "Inactive"\r\n            },\r\n            "source_type": "array",\r\n            "label": "Status",\r\n            "class": "select",\r\n            "enumvalues": {\r\n                "Active": "Active",\r\n                "Disabled": "Inactive"\r\n            }\r\n        },\r\n        "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::changeServiceFeatureStatus",\r\n                "enumvalues": {\r\n                    "Active": "Active",\r\n                    "Disabled": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "Active": "green",\r\n                    "Disabled": "red"\r\n                }\r\n            }\r\n\r\n    }\r\n},\r\n"opertations": [\r\n    "view",\r\n    "edit",\r\n    "add"\r\n    ]\r\n}', '0', 0, 'all'),
	(16, 10, 'User Help ', 'userHelp', 'tbl_Help', '{\r\n    "keyColumn": "nId",\r\n"detailHeaderColumns":["vTitle"],\r\n    "orderBy": {\r\n        "vTitle": "ASC"\r\n    },\r\n    "where": "tbl_Help.eType=\'User\'",\r\n    "listColumns": [\r\n        "vTitle",\r\n        "eStatus"\r\n    ],\r\n    "showColumns": [\r\n        "nId",\r\n        "vTitle",\r\n        "tDescription",\r\n        "eType",\r\n        "eStatus"\r\n    ],\r\n    "detailColumns": [\r\n        "nId",\r\n        "vTitle",\r\n        "tDescription",\r\n        "eStatus",\r\n        "eType"\r\n    ],\r\n    "columns": {\r\n        "nId": {\r\n            "name": "ID"\r\n        },\r\n        "vTitle": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "tDescription": {\r\n            "name": "Description",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "htmlEditor",\r\n                "label": "Description"\r\n            }\r\n        },\r\n        "eType": {\r\n            "name": "Help Category",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "Admin": "Admin",\r\n                    "User": "User"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Category",\r\n                "enumvalues": {\r\n                    "Admin": "Admin",\r\n                    "User": "User"\r\n                }\r\n            }\r\n        },\r\n        "eStatus": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "Active": "Active",\r\n                    "Disabled": "Disabled"\r\n                },\r\n                "label": "Status",\r\n                "enumvalues": {\r\n                    "Active": "Active",\r\n                    "Disabled": "Disabled"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "edit",\r\n        "delete",\r\n        "view"\r\n    ]\r\n}', '1', 9, 'all'),
	(15, 1, 'Domains', 'domains', 'tbl_ProductLookup', '{\r\n    "keyColumn": "nPLId",\r\n    "dataSource": "external",\r\n    "dataSourceFunction": "Admincomponents::fetchDomaindata",\r\n    "dataSourceCountFunction": "Admincomponents::fetchDomaindataCount",\r\n    "detailHeaderColumns": [\r\n        "vDomain"\r\n    ],\r\n    "detailHeaderColumnPrefix": "Domain: ",\r\n    "listColumns": [\r\n        "vDomain",\r\n        "nUId",\r\n        "dDateStop",\r\n        "account_operations"\r\n    ],\r\n    "detailColumns": [\r\n        "nPLId",\r\n        "vDomain",\r\n        "nUId",\r\n       "dDateStop",\r\n        "account_operations"\r\n    ],\r\n    "columns": {\r\n        "nPLId": {\r\n            "name": "ID"\r\n        },\r\n        "vDomain": {\r\n            "name": "Domain",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getStoreHostWithAdminNav"\r\n        },\r\n        "nUId": {\r\n            "name": "User",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getUsername"\r\n        },\r\n        "dDateStop": {\r\n            "name": "Plan Expiry Date",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getPlanExpiryCms"\r\n        },\r\n         "account_operations": {\r\n            "name": "Account",\r\n"disableDetailedView":"false",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getAccountSuspendLink"\r\n            }\r\n    },\r\n    "opertations": [\r\n        "view"\r\n    ],\r\n    "includeJsFiles":["cmshelper.js"]\r\n\r\n}', '1', 5, 'all'),
	(18, 1, 'Service History', 'orders', 'tbl_Invoice ', '{"customAction":"true","controller":"service","method":"index","module":"admin"}', '1', 2, 'all'),
	(19, 10, 'Email Template', 'emailtemplates', 'tbl_Cms', '{\r\n"keyColumn": "cms_id",\r\n    "orderBy": {\r\n        "cms_id": "ASC"\r\n    },\r\n"where":"tbl_Cms.cms_type=\'email_settings\'",\r\n\r\n    "listColumns": [\r\n        "cms_name",\r\n        "cms_status"\r\n    ],\r\n    "showColumns": [\r\n        "cms_id",\r\n        "cms_name",\r\n        "cms_title",\r\n        "cms_desc",\r\n        "cms_status"\r\n    ],\r\n    "detailColumns": [\r\n        "cms_id",\r\n        "cms_name",\r\n        "cms_title",\r\n        "cms_desc",\r\n        "cms_status"\r\n    ],\r\n    "detailHeaderColumns": [\r\n        "cms_title"\r\n    ],\r\n    "columns": {\r\n        "cms_id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "cms_name": {\r\n            "name": "Name",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "cms_title": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "cms_desc": {\r\n            "name": "Content",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "htmlEditor",\r\n                "label": "Content",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "cms_status": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "edit"\r\n    ]\r\n}', '1', 5, 'all'),
	(20, 9, 'Banner Management', 'bannerManagement', 'tbl_Banners', '{\r\n    "keyColumn": "nBannerId",\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "nBannerId": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "eType",\r\n        "vBannerUrl",\r\n        "vBannerText",\r\n        "vBannerImageId",\r\n        "vActive",\r\n        "showcount",\r\n        "clickcount",\r\n        "displayOrder"\r\n    ],\r\n    "showColumns": [\r\n        "nBannerId",\r\n        "eType",\r\n        "vBannerText",\r\n        "vBannerUrl",\r\n        "vBannerImageId",\r\n        "vActive",\r\n        "showcount",\r\n        "clickcount",\r\n        "displayOrder"\r\n    ],\r\n    "detailColumns": [\r\n        "nBannerId",\r\n        "eType",\r\n        "vBannerUrl",\r\n        "vBannerText",\r\n        "vBannerImageId",\r\n        "vActive",\r\n        "showcount",\r\n        "clickcount",\r\n        "displayOrder"\r\n    ],\r\n    "columns": {\r\n        "eType": {\r\n            "name": "Banner Type",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "source": {\r\n                    "Header": "Home Page Sliding Banner",\r\n                    "Footer": "Footer"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Banner Type",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "Header": "Home Page Sliding Banner",\r\n                    "Footer": "Footer"\r\n                }\r\n            }\r\n        },\r\n        "vBannerUrl": {\r\n            "name": "Banner Url",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Banner Url"\r\n            }\r\n        },\r\n        "vBannerText": {\r\n            "name": "Banner Text",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Banner Text"\r\n            }\r\n        },\r\n        "vBannerImageId": {\r\n            "name": "Banner Image",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],             \r\n                "type": "file",\r\n                "label": "Banner Image",\r\n                "class": "file",\r\n                "hint": "Home Page Sliding Banner should be with : Width & Height - 1250px X 400px <br> Footer should be with: Width & Height - 468px X 60px"\r\n            },\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getCmsBannerImage"\r\n        },\r\n        "showcount": {\r\n            "name": "Impressions",\r\n            "sortable": "true"\r\n        },\r\n        "clickcount": {\r\n            "name": "Click  Count",\r\n            "sortable": "true"\r\n        },\r\n        "displayOrder": {\r\n            "name": "Display  Order",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Display Order"\r\n            }\r\n        },\r\n        "vActive": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "checkbox",\r\n                "label": "Enable Banner",\r\n                "default": "yes",\r\n                "enumvalues": {\r\n                    "0": "Inactive",\r\n                    "1": "Active"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::changeBannerStatus",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "1": "green",\r\n                    "0": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "edit",\r\n        "delete",\r\n        "publish"\r\n    ]\r\n}', '1', 3, 'all'),
	(21, 10, 'Email Scheduler', 'emailscheduler', 'tbl_EmailTemplatesMails', '{\r\n    "keyColumn": "nETMId",\r\n    "detailHeaderColumns": [\r\n        "vMailName"\r\n    ],\r\n    "detailHeaderColumnPrefix": "Email Scheduler: ",\r\n    "orderBy": {\r\n        "nETMId": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vMailName",\r\n        "nETID",\r\n        "tScheduleTime",\r\n        "eStatus",\r\n        "nMailMode"\r\n    ],\r\n    "detailColumns": [\r\n        "nETMId",\r\n        "vMailName",\r\n        "nETID",\r\n        "tScheduleTime",\r\n        "eStatus",\r\n        "nMailMode"\r\n    ],\r\n    "showColumns": [\r\n        "nETMId",\r\n        "vMailName",\r\n        "nETID",\r\n        "tScheduleTime",\r\n        "eStatus",\r\n        "nMailMode"\r\n    ],\r\n    "columns": {\r\n        "nETMId": {\r\n            "name": "ID",\r\n            "sortable": "true"\r\n        },\r\n        "vMailName": {\r\n            "name": "Mail Name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Mail Name",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "nETID": {\r\n            "name": "Email Template Name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": "Streamsendlogic::getemailTemplateList",\r\n                "source_type": "function",\r\n                "label": "EmailTemplate Name",\r\n                "class": "select"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_EmailTemplates",\r\n                "externalColumn": "nETID",\r\n                "externalShowColumn": "vemailTemplateName"\r\n            }\r\n        },\r\n        "tScheduleTime": {\r\n            "name": "Schedule Time",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "datepicker",\r\n                "label": "Schedule Time",\r\n                "class": "datepicker",\r\n                "dbFormat": "datetime",\r\n                "displayFormat": "m/d/Y"\r\n            }\r\n        },\r\n        "eStatus": {\r\n            "name": "Status",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "hidden",\r\n                "class": "hidden",\r\n                "value": "Active"\r\n                \r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::changeEmailSchedulerStatus",\r\n                "enumvalues": {\r\n                    "Active": "Active",\r\n                    "Deactive": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "Active": "green",\r\n                    "Deactive": "red"\r\n                }\r\n            }\r\n        },\r\n        "nMailMode": {\r\n            "name": "Mail Mode",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden",\r\n                "class": "hidden",\r\n                "value": "Streamsend"\r\n            }\r\n        }\r\n    },\r\n    "customActions": {\r\n        "afterAddRecord": "Streamsendlogic::setScheduleMail",\r\n        "afterEditRecord": "Streamsendlogic::setScheduleMailEdit"\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "add",\r\n        "delete"\r\n    ]\r\n}', '1', 2, 'all'),
	(22, 1, 'Billing', 'billing', 'tbl_User', '{\r\n    "keyColumn": "nUId",\r\n    "orderBy": { "vFirstName": "ASC"},\r\n    "listColumns": ["vName","vEmail","vInvoiceEmail","vPlan","vStatus"],\r\n    "detailColumns": ["nUId","vName","vEmail","vInvoiceEmail","vPlan","vStatus"],\r\n    "columns": {\r\n        "nUId": {},\r\n        "vName": { "name": "Name","customColumn": "true","customaction": "User::getNameById"},\r\n        "vEmail": {"name": "Email","searchable": "searchable","sortable": "true"},\r\n        "vInvoiceEmail": {"name": "Invoice Email","searchable": "searchable","sortable": "true"},\r\n        "vPlan": {"name": "Plans","customColumn": "true","customaction": "Admincomponents::getUserPlansForCmsListing"},\r\n        "vStatus": {"name": "User Status","customColumn": "true","customaction": "User::getUserStatusById"}\r\n    },\r\n    "opertations": ["view"]\r\n}', '0', 4, 'all'),
	(23, 1, 'User Plans', 'user_plans', 'tbl_ProductServices', '{"customAction":"true","controller":"products","method":"listuserplans","module":"admin"}', '0', 0, 'all'),
	(24, 9, 'Paid Templates', 'paid_templates', 'tbl_PaidTemplates', '{\r\n    "keyColumn": "nTemplateId",\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "vTemplateName": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "vTemplateName",\r\n        "vTemplateZipId",\r\n        "vHomeScreenshotId",\r\n        "vInnerScreenshot1Id",\r\n        "vInnerScreenshot2Id",\r\n        "nCost",\r\n        "vActive"\r\n    ],\r\n    "showColumns": [\r\n        "nTemplateId",\r\n        "vTemplateName",\r\n        "vDescription",\r\n        "vTemplateZipId",\r\n        "vHomeScreenshotId",\r\n        "vInnerScreenshot1Id",\r\n        "vInnerScreenshot2Id",\r\n        "nCost",\r\n        "vActive"\r\n    ],\r\n    "detailColumns": [\r\n        "nTemplateId",\r\n        "vTemplateName",\r\n        "vDescription",\r\n        "vTemplateZipId",\r\n        "vHomeScreenshotId",\r\n        "vInnerScreenshot1Id",\r\n        "vInnerScreenshot2Id",\r\n        "nCost",\r\n        "vActive"\r\n    ],\r\n    "columns": {\r\n        "vTemplateName": {\r\n            "name": "Template Name",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Template Name"\r\n            }\r\n        },\r\n        "vDescription": {\r\n            "name": "Description",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Description"\r\n            }\r\n        },\r\n        "vTemplateZipId": {\r\n            "name": "Template Zip",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::downloadTemplateZip",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Template Zip",\r\n                "class": "file",\r\n                "hint": "Upload type : .zip file with folders img/TemplateName/ with images and css/ with TemplateName.css file"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n         "vHomeScreenshotId": {\r\n            "name": "Home Page Screenshot",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Home Page Screenshot",\r\n                "class": "file",\r\n                "hint": "Ideal size 295x235"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n         "vInnerScreenshot1Id": {\r\n            "name": "Inner Page Screenshot 1",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Inner Page Screenshot1",\r\n                "class": "file",\r\n                "hint": "Ideal size 295x235"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n         "vInnerScreenshot2Id": {\r\n            "name": "Inner Page Screenshot 2",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Inner Page Screenshot 2",\r\n                "class": "file",\r\n                "hint": "Ideal size 295x235"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "nCost": {\r\n            "name": "Price",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "listHeaderPostfix": "Admincomponents::getCurrencySymbolForCms",\r\n            "lsHeaderPostfixCustom": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Price",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n                \r\n            }\r\n            \r\n        },\r\n        "vActive": {\r\n            "name": "Publish",\r\n            "editoptions": {\r\n                "type": "checkbox",\r\n                "label": "Enable Template",\r\n                "default": "yes",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "edit",\r\n        "delete",\r\n        "publish"\r\n    ]\r\n}', '1', 5, 'all'),
	(25, 9, 'Themes', 'themes', 'tbl_themes', '{\r\n    "keyColumn": "theme_id",\r\n    "orderBy": {\r\n        "theme_id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "theme_title",\r\n        "theme_name",\r\n        "theme_status",\r\n        "theme_thumbnail"\r\n    ],\r\n    "showColumns": [\r\n        "theme_id",\r\n        "theme_title",\r\n        "theme_name",\r\n        "theme_status"\r\n    ],\r\n    "detailColumns": [\r\n        "theme_id",\r\n        "theme_title",\r\n        "theme_name",\r\n        "theme_status",\r\n        "theme_thumbnail"\r\n    ],\r\n    "columns": {\r\n        "theme_id": {},\r\n        "theme_title": {\r\n            "name": "Theme Title",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "disabled",\r\n                "label": "Theme Title"\r\n            }\r\n        },\r\n        "theme_name": {\r\n            "name": "Theme Name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "disabled",\r\n                "label": "Theme Name"\r\n            }\r\n            \r\n        },\r\n        "theme_status": {\r\n            "name": "Theme Status",\r\n            "editoptions": {\r\n                "type": "checkbox",\r\n                "label": "Enable Theme",\r\n                "enumvalues": {\r\n                    "0": "Inactive",\r\n                    "1": "Active"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::changeThemeStatus",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "1": "green",\r\n                    "0": "red"\r\n                }\r\n            }\r\n        },\r\n        "theme_thumbnail": {\r\n            "name": "Thumbnail",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::showthumbnail"\r\n        }\r\n    },\r\n    "customActions": {\r\n        "afterEditRecord": "Admincomponents::statusUpdate"\r\n    },\r\n    "opertations": [\r\n        "edit"\r\n    ]\r\n}', '1', 6, 'all'),
	(26, 1, 'Settlements', 'settlements', 'tbl_BillingSettlement', '{\r\n    "keyColumn": "nId",\r\n    "orderBy": {\r\n        "dCreatedOn": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "nUId",\r\n        "nRequestedAmount",\r\n        "tUserComments",\r\n        "dCreatedOn",\r\n        "eStatus"\r\n    ],\r\n    "showColumns": [\r\n        "nId",\r\n        "nSettledAmount",\r\n        "tAdminComments",\r\n        "eStatus"\r\n    ],\r\n    "detailColumns": [\r\n        "nId",\r\n        "nUId",\r\n        "nRequestedAmount",\r\n        "tUserComments",\r\n        "nSettledAmount",\r\n        "tAdminComments",\r\n        "dCreatedOn",\r\n        "eStatus"\r\n    ],\r\n    "columns": {\r\n        "nId": {\r\n            "name": "Settlement Id",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "nUId": {\r\n            "name": "User",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_User",\r\n                "externalColumn": "nUId",\r\n                "externalShowColumn": "vUsername"\r\n            }\r\n        },\r\n        "nRequestedAmount": {\r\n            "name": "Requested Amount"\r\n        },\r\n        "tUserComments": {\r\n            "name": "Comments"\r\n        },\r\n        "dCreatedOn": {\r\n            "name": "Sent On",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n        "eStatus": {\r\n            "name": "Status",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "source_type": "array",\r\n                "source": {\r\n                    "Pending": "Pending",\r\n                    "Approved": "Approved",\r\n                    "Rejected": "Rejected"\r\n                },\r\n                "type": "select",\r\n                "label": "Status",\r\n                "class": "select"\r\n            }\r\n        },\r\n        "nSettledAmount": {\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Settled Amount",\r\n                "class": "textbox"\r\n            },\r\n            "name": "Settled Amount"\r\n        },\r\n        "tAdminComments": {\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textarea",\r\n                "label": "Comments",\r\n                "class": "textarea"\r\n            },\r\n            "name": "Admin Comments"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit"\r\n    ],\r\n    "report": {\r\n        "reportTitle": "Settlements",\r\n        "columns": [\r\n            "nUId",\r\n            "nRequestedAmount",\r\n            "tUserComments",\r\n            "nSettledAmount",\r\n            "tAdminComments",\r\n            "dCreatedOn",\r\n            "eStatus"\r\n        ],\r\n        "dateColumn": "dCreatedOn"\r\n    }\r\n}', '0', 4, 'all'),
	(27, 9, 'Support', 'support', 'tbl_BillingSettlement', '{"customAction":"true","controller":"index","method":"gotosupport","module":"admin"}', '1', 8, 'all'),
	(28, 1, 'Service Details', 'service_details', 'tbl_ProductServices', '{"customAction":"true","controller":"service","method":"servicedetails","module":"admin"}', '0', 6, 'all'),
	(29, 1, 'User', 'domain_user_tag', 'tbl_User', '{\r\n    "keyColumn": "nUId",\r\n    "orderBy": {\r\n        "vFirstName": "ASC"\r\n    },\r\n    "reference": {\r\n        "referenceTable": "tbl_ProductLookup",\r\n        "referenceColumn": "nUId",\r\n        "referenceTableForiegnKey": "nUId"\r\n    },\r\n    "listColumns": [\r\n        "vFirstName",\r\n        "vLastName",\r\n        "vEmail"\r\n    ],\r\n    "detailColumns": [\r\n        "nUId",\r\n        "vFirstName",\r\n        "vLastName",\r\n        "vEmail"\r\n    ],\r\n    "showColumns": [\r\n        "nUId",\r\n        "vFirstName",\r\n        "vLastName",\r\n        "vEmail"\r\n    ],\r\n    "columns": {\r\n        "nUId": {\r\n            "name": "ID"\r\n        },\r\n        "vFirstName": {\r\n            "name": "First name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "First Name",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vLastName": {\r\n            "name": "Last name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Last Name",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vEmail": {\r\n            "name": "Email",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Email",\r\n                "class": "textbox"\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view"\r\n    ]\r\n}', '0', 0, 'all'),
	(30, 1, 'Invoice Details', 'invoice_details', 'tbl_Invoice', '{"customAction":"true","controller":"service","method":"invoicedetails","module":"admin"}', '0', 0, 'all'),
	(31, 10, 'Contents', 'static_content', 'tbl_Cms', '{\r\n"keyColumn": "cms_id",\r\n    "orderBy": {\r\n        "cms_id": "ASC"\r\n    },\r\n"where":"tbl_Cms.cms_type=\'cms\'",\r\n\r\n    "listColumns": [\r\n        "cms_name",\r\n        "cms_title",\r\n        "cms_status"\r\n    ],\r\n    "showColumns": [\r\n        "cms_id",\r\n        "cms_name",\r\n        "cms_title",\r\n        "cms_desc",\r\n        "cms_status"\r\n    ],\r\n    "detailColumns": [\r\n        "cms_id",\r\n        "cms_name",\r\n        "cms_title",\r\n        "cms_desc",\r\n        "cms_status"\r\n    ],\r\n    "detailHeaderColumns": [\r\n        "cms_title"\r\n    ],\r\n    "detailHeaderColumnPrefix": "Content: ",\r\n    "columns": {\r\n        "cms_id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "cms_name": {\r\n            "name": "Page Name",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "cms_title": {\r\n            "name": "Display Title",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "cms_desc": {\r\n            "name": "Content",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "htmlEditor",\r\n                "label": "Content",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "cms_status": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Admin::changeContentStatus",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "1": "green",\r\n                    "0": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "edit",\r\n        "view"\r\n    ]\r\n}', '1', 2, 'all'),
	(33, 1, 'Coupons', 'coupons', ' tbl_Coupon', '{\r\n    "keyColumn": "nCouponId",\r\n    "orderBy": {\r\n        "dCreatedOn": "DESC"\r\n    },\r\n    "detailHeaderColumns": ["vCouponCode"],\r\n    "detailHeaderColumnPrefix": "Coupon: ",\r\n    "listColumns": [\r\n        "vCouponCode",\r\n        "vPricingMode",\r\n        "nCouponValue",\r\n        "dExpireOn",\r\n        "nCouponCount",\r\n        "nCouponUsed"\r\n    ],\r\n    "showColumns": [\r\n        "nCouponId",\r\n        "vCouponCode",\r\n        "nCouponCount",\r\n        "vPricingMode",\r\n        "nCouponValue",\r\n        "dCreatedOn",\r\n        "dExpireOn",\r\n        "vCouponDescription"\r\n    ],\r\n    "detailColumns": [\r\n        "nCouponId",\r\n        "vCouponCode",\r\n        "vCouponDescription",\r\n        "vPricingMode",\r\n        "nCouponValue",\r\n        "dCreatedOn",\r\n        "dExpireOn",\r\n        "nCouponCount",\r\n        "nCouponUsed"\r\n    ],\r\n    "columns": {\r\n        "nCouponId": {\r\n            "name": "ID",\r\n            "editoptions":{"type":"hidden"}\r\n        },\r\n        "nCouponUsed": {\r\n            "name": "Number Of Coupons Used"\r\n        },\r\n        "vCouponCode": {\r\n            "name": "Coupon Code",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions":{"validations":["required"],"type":"textbox","label":"Coupon Code","class":"textbox"}\r\n        },\r\n        "nCouponCount": {\r\n            "name": "Number Of Coupons",\r\n            "sortable": "true",\r\n            "editoptions":{"validations":["required"],"type":"textbox","label":"Number of Coupons","class":"textbox"}\r\n        },\r\n        "dCreatedOn": {\r\n            "name": "Created Date",\r\n            "editoptions":{"validations":["required"],"type":"datepicker","label":"Created Date","class":"textbox","dbFormat":"date","displayFormat":"m/d/Y"}\r\n        },\r\n        "dExpireOn": {\r\n            "name": "Expiry Date",\r\n            "sortable": "true",\r\n            "editoptions":{"validations":["required"],"type":"datepicker","label":"Expiry Date","class":"textbox","dbFormat":"date","displayFormat":"m/d/Y"}\r\n        },\r\n        "vPricingMode": {\r\n            "name": "Pricing Mode",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions":{\r\n                "validations":["required"],\r\n                "type":"select",\r\n                "label":"Pricing Mode",\r\n                "class":"select",\r\n                "source":{"percentage":"Percentage","rate":"Rate"},\r\n                "source_type":"array",\r\n                "enumvalues":{"percentage":"Percentage","rate":"Rate"}\r\n            }\r\n        },\r\n        "nCouponValue": {\r\n            "name": "Coupon Value",\r\n            "sortable": "true",\r\n            "editoptions":{"validations":["required"],"type":"textbox","label":"Coupon Value","class":"textbox"}\r\n        },\r\n        "vCouponDescription": {\r\n            "name": "Description",\r\n            "sortable": "true",\r\n            "editoptions":{"type":"textbox","label":"Description","class":"textbox"}\r\n        }\r\n\r\n    },\r\n    "opertations": [\r\n        "add","edit","delete","view"\r\n    ],\r\n    "report": {\r\n        "reportTitle": "Coupons",\r\n        "columns": [\r\n            "vCouponCode",\r\n            "vPricingMode",\r\n            "nCouponValue",\r\n            "dCreatedOn",\r\n            "dExpireOn",\r\n            "nCouponCount",\r\n            "nCouponUsed",\r\n            "vCouponDescription"\r\n        ],\r\n        "dateColumn": "dCreatedOn"\r\n    }\r\n}', '1', 9, 'all'),
	(34, 10, 'Email Content', 'email_content', 'tbl_Cms', '{\r\n"keyColumn": "cms_id",\r\n    "orderBy": {\r\n        "cms_id": "ASC"\r\n    },\r\n"where":"tbl_Cms.cms_type=\'email\'",\r\n\r\n    "listColumns": [\r\n        "cms_name",\r\n        "cms_title",\r\n        "cms_status"\r\n    ],\r\n    "showColumns": [\r\n        "cms_id",\r\n        "cms_name",\r\n        "cms_title",\r\n        "cms_desc",\r\n        "cms_status"\r\n    ],\r\n    "detailColumns": [\r\n        "cms_id",\r\n        "cms_name",\r\n        "cms_title",\r\n        "cms_desc",\r\n        "cms_status"\r\n    ],\r\n    "detailHeaderColumns": [\r\n        "cms_title"\r\n    ],\r\n    "columns": {\r\n        "cms_id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "cms_name": {\r\n            "name": "Name",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "cms_title": {\r\n            "name": "Subject",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Subject",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "cms_desc": {\r\n            "name": "Content",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "htmlEditor",\r\n                "label": "Content",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "cms_status": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "edit",\r\n        "view",\r\n        "add"\r\n    ]\r\n}\r\n\r\n', '1', 6, 'all'),
	(35, 1, 'Settlement Request', 'settlement_request', 'tbl_BillingSettlement', '{\r\n    "keyColumn": "nId",\r\n    "orderBy": {\r\n        "dCreatedOn": "DESC"\r\n    },\r\n    "detailHeaderColumns": ["nUId"],\r\n    "detailHeaderColumnPrefix": "Request From: ",\r\n    "listColumns": [\r\n        "nUId",\r\n        "nRequestedAmount",\r\n        "tUserComments",\r\n        "eStatus",\r\n		"dCreatedOn"\r\n    ],\r\n    "detailColumns": [\r\n        "nId",\r\n        "nUId",\r\n        "nRequestedAmount",\r\n        "tUserComments",\r\n        "eStatus",\r\n		"dCreatedOn"\r\n    ],\r\n    "columns": {\r\n    "nId":{"name":"ID"},\r\n        "nUId": {\r\n            "name": "Customer",\r\n            "sortable": "true",\r\n			"customColumn": "true",\r\n			"customaction": "Admincomponents::getUsernameOfSettledRequest"\r\n        },\r\n        "nRequestedAmount": {\r\n            "name": "Request Amount",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n"listHeaderPostfix": "Admincomponents::getCurrencySymbolForCms",\r\n"lsHeaderPostfixCustom": "true"\r\n        },\r\n        "tUserComments": {\r\n            "name": "Comment",\r\n            "sortable": "true"\r\n        },\r\n        "eStatus": {\r\n            "name": "Status",\r\n            "sortable": "true"\r\n        },\r\n		"dCreatedOn": {\r\n            "name": "Requested On",\r\n            "sortable": "true",\r\n			"dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "delete"\r\n    ]\r\n}', '1', 9, 'all'),
	(39, 10, 'Meta Tags', 'meta_tags', 'fw_metadata', '{\r\n "keyColumn": "id",\r\n "detailHeaderColumnPrefix": "Meta Tag : ",\r\n    "detailHeaderColumns": [\r\n        "url"\r\n    ],\r\n    "orderBy": {\r\n        "id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "url",\r\n        "title",\r\n        "keyword"\r\n    ],\r\n    "showColumns": [\r\n        "id",\r\n        "url",\r\n        "title",\r\n        "keyword",\r\n        "description"\r\n    ],\r\n    "detailColumns": [\r\n        "id",\r\n        "url",\r\n        "title",\r\n        "keyword",\r\n        "description"\r\n    ],\r\n    "columns": {\r\n        "id": {\r\n            "name": "ID",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "title": {\r\n            "name": "Meta Title",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Meta Title",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "keyword": {\r\n            "name": "Meta Keywords",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Meta Keywords",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "description": {\r\n            "name": "Meta Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Meta Description",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "url": {\r\n            "name": "Page Url",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "label": "Page Url",\r\n                "type": "textbox",\r\n                "class": "textbox",\r\n                "hint":"<b>Url combinations can be : </b><br/><b style=\'color:red\'> /abc/</b> [exact location abc after your domain name] eg : www.domainname.com/abc/ ,<br/> <b style=\'color:red\'>/abc/* </b> [any combination after location abc after your domain name] eg : www.domainname.com/abc/test1,<br/> <b style=\'color:red\'>* </b>[default value] ",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '1', 2, 'all'),
	(37, 10, 'Newsletter Template', 'newsletter_template', 'tbl_EmailTemplates', '{\r\n"keyColumn": "nETId",\r\n"detailHeaderColumns":["vemailTemplateName"],\r\n"detailHeaderColumnPrefix": "Newsletter Template: ",\r\n    "orderBy": {\r\n        "nETId": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vemailTemplateName",\r\n        "estatus"\r\n    ],\r\n    "detailColumns": [\r\n        "nETId",\r\n        "vemailTemplateName",\r\n        "temailTemplate",\r\n        "estatus"\r\n    ],\r\n    "showColumns": [\r\n        "nETId",\r\n        "vemailTemplateName",\r\n        "temailTemplate",\r\n        "estatus"\r\n    ],\r\n    "columns": {\r\n        "nETId": {\r\n            "name": "ID",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vemailTemplateName": {\r\n            "name": "Template Name",\r\n            "searchable": "searchable",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Template Name",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "temailTemplate": {\r\n            "name": "Template",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "htmlEditor",\r\n                "label": "Template",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "estatus": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "validations": [\r\n                        "required"\r\n                    ],\r\n                "type": "select",\r\n                "source": {\r\n                    "Active": "Active",\r\n                    "Inactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "Active": "Active",\r\n                    "Inactive": "Inactive"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                    "type": "button",\r\n                    "customaction": "Admin::changeNewsletterScheduleStatus",\r\n                    "enumvalues": {\r\n                        "Active": "Active",\r\n                        "Inactive": "Inactive"\r\n                    },\r\n                    "buttonColors": {\r\n                        "Active": "green",\r\n                        "Inactive": "red"\r\n                    }\r\n                }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "add",\r\n        "delete"\r\n    ]\r\n}', '1', 3, 'all'),
	(38, 1, 'godaddycertify', 'godaddycertify', 'test', '{"customAction":"true","controller":"module","method":"godaddycertify","module":"admin"}\r\n', '0', 1, 'all'),
	(41, 1, 'Domain Renewal Log', 'domain_renewal_log', 'tbl_DomainRenewalLog', '{\r\n    "keyColumn": "id",\r\n     "orderBy": {\r\n                "createdOn": "DESC"\r\n                },\r\n    "detailHeaderColumns": ["vDomain"],\r\n    "detailHeaderColumnPrefix": "Domain Renewal Log for : ",\r\n\r\n    "listColumns": [\r\n        "vDomain",\r\n                    "nUId",\r\n                    "comments",\r\n                    "expireOn",\r\n                    "createdOn",\r\n                    "lastModified",\r\n                    "actionRenew"\r\n    ],\r\n    "detailColumns": [\r\n        "vDomain",\r\n                    "nUId",\r\n                    "comments",\r\n                    "expireOn",\r\n                    "createdOn",\r\n                    "lastModified",\r\n                    "actionRenew"\r\n    ],\r\n    "columns": {\r\n   "vDomain":{\r\n                "name":"Domain",\r\n                "sortable": "true",\r\n                "searchable": "searchable"\r\n                },\r\n       "nUId": {\r\n                "name": "Customer",\r\n                "sortable": "true",\r\n                "customColumn": "true",\r\n                "customaction": "Admincomponents::getUsernameOfSettledRequest",\r\n                "sortable": "true",\r\n                "searchable": "searchable"\r\n            },\r\n       "comments": {\r\n            "name": "Status",\r\n            "sortable": "true",\r\n            "searchable": "searchable"\r\n        },\r\n "expireOn": {\r\n            "name": "Domain Expiry Date",\r\n            "sortable": "true",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y",\r\n            "sortable": "true",\r\n            "searchable": "searchable"\r\n        },\r\n         "createdOn": {\r\n            "name": "Log Created On",\r\n            "sortable": "true",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y",\r\n            "sortable": "true",\r\n            "searchable": "searchable"\r\n        },\r\n       "lastModified": {\r\n            "name": "Log Modified On",\r\n            "sortable": "true",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y",\r\n            "sortable": "true",\r\n            "searchable": "searchable"\r\n        },\r\n            "actionRenew": {\r\n            "name": "Action",\r\n            "disableDetailedView":"false",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getDomainRenewalLink"\r\n            }\r\n    },\r\n    "opertations": [\r\n        "view"\r\n    ],\r\n    "includeJsFiles":["cmshelper.js"]\r\n}', '1', 10, 'all'),
	(42, 1, 'Sold Template History', 'sold_templates', 'tbl_PaidTemplatePurchase', '{\r\n    "keyColumn": "id",\r\n    "orderBy": {\r\n        "paidOn": "DESC"\r\n    },\r\n    "listColumns": [\r\n\r\n        "nTemplateId",\r\n        "nUId",\r\n        "nPLId",\r\n        "amount",\r\n        "paymentMethod",\r\n        "transactionId",\r\n        "comments",\r\n        "paidOn"\r\n    ],\r\n    "showColumns": [\r\n\r\n        "nTemplateId",\r\n        "nUId",\r\n        "nPLId",\r\n        "amount",\r\n        "paymentMethod",\r\n        "transactionId",\r\n        "comments",\r\n        "paidOn"\r\n    ],\r\n    "detailHeaderContent": "Sold Template",\r\n    "detailColumns": [\r\n\r\n        "nTemplateId",\r\n        "nUId",\r\n        "nPLId",\r\n        "amount",\r\n        "paymentMethod",\r\n        "transactionId",\r\n        "comments",        \r\n        "paidOn"\r\n    ],\r\n    "columns": {\r\n        "nTemplateId": {\r\n            "name": "Template Name",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "external": "true",\r\n            "externalOptions": {\r\n            "externalTable": "tbl_PaidTemplates",\r\n            "externalColumn": "nTemplateId",\r\n            "externalShowColumn": "vTemplateName"}\r\n        },\r\n        "nUId": {\r\n            "name": "User",\r\n            "sortable": "true",\r\n            "customColumn": "true",\r\n	    "customaction": "Admincomponents::getUsernameOfSoldTemplateCMS"\r\n        },\r\n        "nPLId": {\r\n            "name": "Store",\r\n            "sortable": "true",\r\n            "customColumn": "true",\r\n	    "customaction": "Admincomponents::getStoreHostForSoldTemplatePurchaseCms"\r\n        },\r\n        "amount": {\r\n            "name": "Amount",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "listHeaderPostfix": "($)"\r\n        },\r\n        "paymentMethod": {\r\n            "name": "Payment Method",\r\n            "sortable": "true",\r\n            "searchable": "true"\r\n        },\r\n         "transactionId": {\r\n            "name": "Transaction Id",\r\n            "sortable": "true",\r\n            "searchable": "true"\r\n        },\r\n        "comments": {\r\n            "name": "Status",\r\n            "sortable": "true",\r\n            "searchable": "true"\r\n        },\r\n        "paidOn": {\r\n            "name": "Purchase Date",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "customColumn": "true",\r\n            "customaction": "Admincomponents::getSoldTemplatePurchaseDateCms"\r\n        }\r\n\r\n\r\n\r\n    },"opertations": [\r\n        "view"]\r\n\r\n}', '1', 10, 'all');

