<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2011 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts PrintLogic                     |
// +----------------------------------------------------------------------+
// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |
// +----------------------------------------------------------------------+

App::import('Sanitize');

class CategoriesController extends AppController {

    var $name = "Category";
    var $helpers = array('Html', 'Form','Pagination','Tree');
    var $components = array ('Pagination','Catmenu','RequestHandler','Resize'); // Added
    var $uses = array('Product','Category','Customfield','Customfieldvalue','Currency','Cmspage','Dynamicpage');
    var $paginate = array('limit' => 25,'order' => array('Category.cname' => 'asc'));

    function index() {
        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');

        if($admsess["category"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }

        $criteria="Category.id <> 1";
        $cmbSearchType	=	"";
        $txtSearch		=	"";

        if(isset($_GET["cmbSearchType"]) && isset($_GET["txtSearch"])) {

            $cmbSearchType	=	$_GET["cmbSearchType"];

            $txtSearch		=	$_GET["txtSearch"];

            if($cmbSearchType == "name") {

                //$data = $this->paginate('Category', array('Category.cname  LIKE ' => "%".addslashes($txtSearch)."%",'Category.id <>'=>1));
                $data = $this->Category->find( 'all', array('conditions' => array('Category.cname  LIKE ' => "%".addslashes($txtSearch)."%",'Category.id <>'=>1), 'order' => array('Category.parent_id ASC', 'Category.position ASC')));

            }else {

                //$data = $this->paginate('Category', array('Category.id <>'=>1));
                $data = $this->Category->find( 'all', array('conditions' =>  array('Category.id <>'=>1), 'order' => array('Category.parent_id ASC', 'Category.position ASC')));

            }

        }

        else if(isset($this->passedArgs["cmbSearchType"]) && isset($this->passedArgs["txtSearch"]) && $this->passedArgs["txtSearch"] <> '') {

            $cmbSearchType	=	$this->passedArgs["cmbSearchType"];

            $txtSearch		=	$this->passedArgs["txtSearch"];

            if($cmbSearchType == "name") {
                //$data = $this->paginate('Category', array('Category.cname  LIKE ' => "%".addslashes($txtSearch)."%",'Category.id <>'=>1));
                $data = $this->Category->find( 'all', array('conditions' =>  array('Category.cname  LIKE ' => "%".addslashes($txtSearch)."%",'Category.id <>'=>1), 'order' => array('Category.parent_id ASC', 'Category.position ASC')));
            }else {
                //$data = $this->paginate('Category', array('Category.id <>'=>1));
                $data = $this->Category->find( 'all', array('conditions' =>  array('Category.id <>'=>1), 'order' => array('Category.parent_id ASC','Category.position ASC')));
            }

        }else {

            //$data = $this->paginate('Category', array('Category.id <>'=>1));
            $data = $this->Category->find( 'all', array('conditions' => array('Category.id <>'=>1), 'order' => array('Category.parent_id ASC','Category.position ASC')));

        }

        $this->set('cmbSearchType', $cmbSearchType);

        $this->set('txtSearch', $txtSearch);

        //$this->passedArgs['limit']=$this->paginate["limit"];

        $this->set('passedarg',$this->passedArgs);
//                 echopre1($data);
//                 exit();

        $this->set('category', $data);

        $this->layout = 'adm';

    }



    function beforeFilter() {
        if (isset($this->Setting) && !empty($this->Setting->table)) {



            $this->Setting->load();



        }



        global $sitefolder;



        global $meta_description;



        global $meta_keywords;



        global $page_title;



        global $currency;



        $cnfg 				=	Configure::read('Neutrino');



        $sitefolder			=	$cnfg["sitebasefolder"];



        $currency			=	$cnfg["currency"];



        $meta_description	=	$cnfg["meta_description"];



        $meta_keywords		=	$cnfg["meta_keywords"];



        $page_title			=	$cnfg["page_title"];



        global $style;



        $style				=	$cnfg["style"];



        $this->set('style', $style);



        $this->set('meta_description', $meta_description);



        $this->set('meta_keywords', $meta_keywords);



        $this->pageTitle = $page_title	;



        $this->set('cnfg',$cnfg);



        $curr_action=$this->params['action'];



        if($curr_action=='index')



            $this->paginate["limit"]=$cnfg["items_perpage"]; //Setting pagination limit per page.



        else if($curr_action='show_cat')



            $this->paginate["limit"]=3; //Setting pagination limit per page.



        $this->set('sitefolder', $sitefolder);

        $httpHost	=	$_SERVER['HTTP_HOST'];

        $this->set('sitebase','http://'.$httpHost);



    }



    function beforeRender() {



        // $this->layout = 'adm';



    }



    function __validateLoginStatus($typ='A') {
        if($typ == 'A') {
            if($this->Session->check('Admin') == false) {
                $this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
                $this->redirect(array('controller' => 'admins', 'action' => 'login'));
            }
        }else {
            if($this->Session->check('Userlog') == false) {
                $this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
                $this->redirect(array('controller' => 'users', 'action' => 'login'));
            }
        }
    }



    function add() {

        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');
        if($admsess["category"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }
        $cstfldvlstbl=$this->Category->getFulltablename("customfieldvalues");

        //newly added for category tree listing
        $pcat = $this->Category->find('threaded', array('order' => array('Category.cname' => 'ASC')));
        $this->set('categoriesList', $pcat);
        //newly added

        $cfields = $this->Customfield->find('list', array('fields'=>array('Customfield.id', 'Customfield.custom_name'),'joins' =>
                array(
                        array('table' =>  $cstfldvlstbl,'alias' => 'Customfieldvalue', 'type' => 'inner','conditions'=>
                                array('Customfield.id = Customfieldvalue.customfield_id')))));

        $this->set('pcat', $pcat);
        $this->set('cfields', $cfields);
        if (!empty($this->data)) {
            //checking for duplicates starts here...
            $dups=$this->Category->checkAddDups(trim(addslashes($this->data["Category"]["cname"])),$this->data["Category"]["parent_id"]);

            if(isset($dups) && $dups > 0) {
                $this->Session->setFlash('Category Value Already exists Under this Parent Category.', 'default',array('class'=> 'failure'));
                $this->redirect('/categories');
                exit();
            }

            $imgName = time()."_".$this->data['Category']['image']['name'];
            if(is_uploaded_file($this->data['Category']['image']['tmp_name'])) {
                if(move_uploaded_file($this->data['Category']['image']['tmp_name'], WWW_ROOT.IMAGES_URL."categoryimages/".$imgName)) {
                    $this->Resize->index(WWW_ROOT.IMAGES_URL."categoryimages/".$imgName);
                    $this->Resize->resizeImage(120, 140, 'exact');
                    $this->Resize->saveImage(WWW_ROOT.IMAGES_URL."categoryimages/".$imgName, 100);
                }
            }

            $this->data["Category"]["cimage"]	= $imgName;
            //checking for duplicates ends here...
            $this->data['Category']['custom_combination'] =      ($this->data['Category']['custom_combination']=='')?1:$this->data['Category']['custom_combination'];

            $this->Category->save($this->data);
            $cat_id = $this->Category->getLastInsertId();
            $this->Category->set('position', $cat_id);
            $this->Category->save();
            $this->Session->setFlash('Your Category has been saved.', 'default',array('class'=> 'success'));
            $this->redirect('index');
        }
        $this->layout = 'adm';
    }

################## Ajax Function to List the Product Attributes starts here(Added by Shyam) ######################
    function checkcategory($id='') {
        Configure::write('debug', 0);
        $this->layout = null;
        $pval	=	$this->Product->findByCategoryId($id);
        $this->set('pval', $pval);
    }

    function checksubcat($id='') {
        Configure::write('debug', 0);
        $this->layout = null;
        $cval	=	$this->Category->find('all', array('conditions' => array('Category.parent_id ='.$id)));//print_r($cval);
        $this->set('cval', $cval);
        //  $pval	=	$this->Category->getProductCountAllCatgeory($id);print_r($pval);exit;
        //  $this->set('cval', $pval);

    }


    ################## Ajax Function to List the Product Attributes	Ends here(Added by Shyam) ######################





    ################## Ajax Function to List the Product Attributes starts here(Added by Shyam) ######################



    function showattributes($id, $param = '') {


        // $param = base64_decode($param);

        $this->layout = null;



        $cfield	=	$this->Customfield->findById($id);



        $cfieldname	=	$cfield["Customfield"]["custom_name"];



        $cfvalues	=	$this->Customfieldvalue->find('list',array('fields'=>array('Customfieldvalue.id', 'Customfieldvalue.custom_value'),



                'conditions' =>'Customfieldvalue.customfield_id IN ('.$id.')'));



        $this->set('cfieldid', $id);
        $this->set('param', $param);


        $this->set('cfieldname', $cfieldname);



        $this->set('cfvalues', $cfvalues);



    }

    ################## Ajax Function to List the Product Attributes	Ends here(Added by Shyam) ######################

    function edit($id=0) {

        if($id == 0) {
            $this->redirect(array('controller' => 'categories','action'=>'index'));
            exit();
        }

        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');

        if($admsess["category"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }

        $this->Category->id = $id;

        $cat	=	$this->Category->findById($id);

        $catname	=	$cat["Category"]["cname"];

        $this->set('imagePath', $cat["Category"]["cimage"]); // path of image

        if (!empty($this->data)) {
            //checking for duplicates starts here...

            $dups=$this->Category->checkEditDups(addslashes($this->data["Category"]["cname"]),$this->data["Category"]["parent_id"],$id);

            if(isset($dups) && $dups > 0) {
                $this->Session->setFlash('Category Value Already exists Under this Parent Category.', 'default',array('class'=> 'failure'));
                $this->redirect('/categories');
                exit();
            }

            //checking for duplicates ends here...
            $imgName = time()."_".$this->data['Category']['image']['name'];
            if(is_uploaded_file($this->data['Category']['image']['tmp_name'])) {
                if(move_uploaded_file($this->data['Category']['image']['tmp_name'], WWW_ROOT.IMAGES_URL."categoryimages/".$imgName)) {
                    $this->Resize->index(WWW_ROOT.IMAGES_URL."categoryimages/".$imgName);
                    $this->Resize->resizeImage(120, 140, 'exact');
                    $this->Resize->saveImage(WWW_ROOT.IMAGES_URL."categoryimages/".$imgName, 100);
                }

                if(file_exists(WWW_ROOT.IMAGES_URL."categoryimages/".$this->data["Category"]["hid_imgpath"]) && $this->data["Category"]["hid_imgpath"] != 'noimage.jpg') {
                    unlink(WWW_ROOT.IMAGES_URL."categoryimages/".$this->data["Category"]["hid_imgpath"]);
                }
                $this->data["Category"]["cimage"]	= $imgName;
            }

            if ($this->Category->save($this->data)) {
                $this->Session->setFlash('Category '.$catname.' has been Edited Successfully.', 'default',array('class'=> 'success'));
                $this->redirect('index');
            }
        }else {
            global $categ;
            global $ind;
            $categ		=	array();
            $ind		=	0;
            $arr		=	$this->Category->getchilds($id);
            $narr		=	array();
            $narr		=	$id;
            $i			=	1;

            foreach($arr as $ne) {
                $narr	=	$narr.",".$ne["id"];
            }

            $pcat = $this->Category->find('threaded', array('order' => array('Category.cname' => 'ASC')));

            $this->set('categoriesList', $pcat);

            //newly added
            $this->data = $this->Category->read();

            $this->set('categorydet', $this->data);
            $this->set('editid', $id);

        }


        ####### Code for fetching data to be displayed on Edit Category Page starts here(Added By shyam) ############

        $cstfldvlstbl=$this->Category->getFulltablename("customfieldvalues");

        $cfields = $this->Customfield->find('list', array('fields'=>array('Customfield.id', 'Customfield.custom_name'),'joins' =>
                array(
                        array('table' => $cstfldvlstbl,'alias' => 'Customfieldvalue', 'type' => 'inner','conditions'=>
                                array('Customfield.id = Customfieldvalue.customfield_id')))));

        $combinations=$this->Category->findById($id);
        if($combinations['Category']['custom_combination']!='') {
            $combination=$combinations['Category']['custom_combination'];
            $split_combination=explode(',',$combination);
            foreach($split_combination as $combn) {
                $cparent=$this->Customfieldvalue->findById($combn);
                $cparents[$combn]=$cparent['Customfieldvalue']['customfield_id'];
            }

            $selected_cfields=array_unique(array_values($cparents));

            $selected_cvalues=array_keys($cparents);

            foreach($selected_cfields as $fieldid) {
                $temp_array= $this->Customfield->findById($fieldid);
                $selected_cfieldnames[]=$temp_array['Customfield']['custom_name'];
            }

            unset($temp_array);
            unset($fieldid);
            foreach($selected_cfields as $fieldid) {

                $temp_array= $this->Customfieldvalue->find('list',array('fields'=>array('Customfieldvalue.id', 'Customfieldvalue.custom_value'),'conditions' =>'Customfieldvalue.customfield_id  IN ('.$fieldid.')'));
                $selected_cfieldvalues[$fieldid]=$temp_array;

            }
            $this->set('selected_cfields', $selected_cfields);
            $this->set('selected_cfieldvalues', $selected_cfieldvalues);
            $this->set('selected_cfieldnames', $selected_cfieldnames);
            $this->set('selected_cvalues', $selected_cvalues);
        }

        $this->set('pcat', $pcat);

        $this->set('cfields', $cfields);
        ####### Code for fetching data to be displayed on Edit Category Page Ends here(Added By shyam) ############

        $this->layout = 'adm';

    }

    function delete($id) {

        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');
        if($admsess["category"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();

        }

        $cat	=	$this->Category->findById($id);
        $catname	=	$cat["Category"]["cname"];
        $catimage	=	$cat["Category"]["cimage"];
        if(file_exists(WWW_ROOT.IMAGES_URL."categoryimages/".$catimage) && $catimage != '') {
            unlink(WWW_ROOT.IMAGES_URL."categoryimages/".$catimage);
        }
        
         $arr = $this->Category->find('threaded', array('conditions'=>array('Category.parent_id ='=>$id)),array('order' => array('Category.cname' => 'ASC')));
         $prarr = $this->Product->find('all', array('conditions'=>array('category_id ='=>$id,'Product.status <>'=>'D')));
    

        if(sizeof($arr) > 0) {
            $this->Session->setFlash(' Category '.$catname.' has subcategories . Please remove subcategories.', 'default',array('class'=> 'failure'));
        }
        elseif(sizeof($prarr) > 0) {
            //$this->Session->setFlash(__(' Category '.$catname.' has products under it . Please remove products.', '/categories'));
    
                $this->Session->setFlash(' Category '.$catname.' has products under it . Please remove products.', 'default',array('class'=> 'failure'));
           
        }
        else {   
            $this->Category->del($id,true);
            $this->Session->setFlash(' Category '.$catname.' has been deleted Successfully.', 'default',array('class'=> 'success'));
        }
        $this->redirect('index');
    }

    #### Function to show products and subcategories under a category

    function show_cat($name='',$catid=0) { 

        if (isset($this->Setting) && !empty($this->Setting->table)) {

            $this->Setting->load();
            
        }

        $sus			=	$this->Session->read('Userlog');
        $this->set('sus', $sus);
        $pages =    $this->Dynamicpage->getpages();
        //echo "hello<pre>";print_r($pages);
        $this->set('pagesdynamic', $pages);
        global $page_title;
        $cnfg 				=	Configure::read('Neutrino');
        $page_title			=	$name;
        if($cnfg["page_title"] <> '')
            $page_title.=' - '.$cnfg["page_title"];
        $this->pageTitle = $page_title	;

        global $currency;
        $curr		=	$this->Currency->findByCode($currency);
        $this->set('curlogo',$curr["Currency"]["logo"]);
        //Facebook Setting
        $facebookKeys='';
        if($this->Session->check('facebookKey')) {
            $facebookKeys=$this->Session->read('facebookKey');
        }
        $this->set('facebookKey', $facebookKeys);
        //Facebook Setting Ends
        // Twitter App Setting
        $twitterKeys='';
        if($this->Session->check('twitterKey')) {
            $twitterKeys=$this->Session->read('twitterKey');
        }
        $this->set('twitterKey', $twitterKeys);
        // Twitter App Setting Ends
        //Code Added By shyam for Category Menu Listing starts here..
        $lst	=	$this->Category->findAll(NULL,NULL,'position ASC');

        foreach($lst as $det)
            $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"], 'position' => $det["Category"]["position"]);
        
        $this->set('menu_array', $menu_array);

        $footer_links = $this->Cmspage->find('list',array('conditions' => array('Cmspage.type' => 'content','Cmspage.status' => 'Y')));
        $this->set('footerlinks', $footer_links);

        //Code Added By shyam for Category Menu Listing ends here..

        $cdet = $this->Category->find('first', array('conditions' => array('Category.id' => $catid,'Category.id' => $catid)), array('order' => array('Category.position ASC')));
        //echo '<pre>'; print_r($cdet); echo '</pre>';

        $chldcateg	=	$cdet["Childcategory"];
        $this->set('chldcateg', $chldcateg); 
        //print_r($cdet["Childcategory"]);exit;
        if(isset($cdet["Category"]["id"])) { 
            $id		=	$cdet["Category"]["id"];
            $sub	=	$this->Catmenu->getCatList($id);

            $this->set('catmenu', $lst);
            $this->set('subcat', $sub);

            $ct		=	$this->Category->findById($id);

            $this->set('pcatdet', $ct);

            $criteria="Product.category_id='".$id."' AND Product.status = 'A' AND Product.stock > 0";

            //list($order,$limit,$page) = $this->Pagination->init($criteria); // Added
            //$data = $this->Product->findAll($criteria, NULL, 'Product.id DESC', $limit, $page); // Extra parameters added
            //echopre($data);

            $perPage = 9;
            isset($_GET['page']) ? $cur = $_GET['page'] - 1 : $cur = 0;
            $totalRecs = $this->Category->getProductCountByCategory($id); 
            $max = ceil($totalRecs/$perPage);
            $pagingArray = array('cur' => $cur, 'max' => $max);
            $this->set("pagingArray", $pagingArray);

            $data  = $this->Category->getProductDataByCategory($id,$perPage, $cur);
            
            $pdct	=	$data;
            $this->set('products', $pdct);
            $this->set('name', $name);
            $this->set('catid', $catid);

            /*
            for($c=0; $c < sizeof($pdct); $c++) {

                if(isset($pdct[$c]["Productimages"][0]["imagename"])) {
                    $defimg	=	$pdct[$c]["Productimages"][0]["imagename"];

                    for($m=0; $m < sizeof($pdct[$c]["Productimages"]); $m++) {
                        if($pdct[$c]["Productimages"][$m]["default_img"] == "Y") {
                            $defimg	=	$pdct[$c]["Productimages"][$m]["imagename"];
                        }
                    }
                    $pdct[$c]["Productimages"]	=	$defimg;
                }
                else {
                    $pdct[$c]["Productimages"]	= '';
                }

            } */
            

            $subCategory  = $this->Category->getSubCategory($catid);
            $this->set('subCategory',$subCategory);


        }else {

            $this->redirect(array('controller' => 'pages','action'=>'display'));

        }

    }


    function show_cat_ajax($catid=0) {

        if (isset($this->Setting) && !empty($this->Setting->table)) {
            $this->Setting->load();
        }

        $sus			=	$this->Session->read('Userlog');
        $this->set('sus', $sus);

        //Code Added By shyam for Category Menu Listing starts here..
        $lst	=	$this->Category->findAll();

        foreach($lst as $det)

            $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"]);
        $this->set('menu_array', $menu_array);

        $cdet = $this->Category->find('all', array('conditions' => array('Category.parent_id' => $catid)));

        $chldcateg	=	$cdet;
        $this->set('chldcateg', $chldcateg);

        if(isset($catid)) {
            $id		=	$catid;

            $sub	=	$this->Catmenu->getCatList($id);


            $this->set('catmenu', $lst);

            $this->set('subcat', $sub);

            $ct		=	$this->Category->findById($id);

            $this->set('pcatdet', $ct);

            $criteria="Product.category_id='".$id."' AND Product.status = 'A' AND Product.stock > 0 AND Product.disable_design = 0";

            list($order,$limit,$page) = $this->Pagination->init($criteria); // Added

            $data = $this->Product->findAll($criteria, NULL, 'Product.id DESC', $limit, $page); // Extra parameters added

            $pdct	=	$data;

            for($c=0; $c < sizeof($pdct); $c++) {

                if(isset($pdct[$c]["Productimages"][0]["imagename"])) {
                    $defimg	=	$pdct[$c]["Productimages"][0]["imagename"];

                    for($m=0; $m < sizeof($pdct[$c]["Productimages"]); $m++) {

                        if($pdct[$c]["Productimages"][$m]["default_img"] == "Y") {

                            $defimg	=	$pdct[$c]["Productimages"][$m]["imagename"];

                        }

                    }
                    $pdct[$c]["Productimages"]	=	$defimg;

                }
                else {

                    $pdct[$c]["Productimages"]	= '';

                }

            }
            $this->set('products', $pdct);

        }
        $this->layout = 'ajax';
    }

    function sort() {
        $flag=0;
        if(isset($_GET['listItem'])) {
            foreach ($_GET['listItem'] as $position => $item) {
                $this->Category->id = $item;
                $this->Category->set('position', $position);
                $this->Category->save();
            }

            $flag = 1;

        }

        echo $flag;

        //----------ajax--------------//
        Configure::write('debug', 0);
        $this->autoRender = false;
        exit;

    } // End Function

    function test() {

    }


}
?>