<?php



/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/



// +----------------------------------------------------------------------+



// | PHP version 4/5                                                      |



// +----------------------------------------------------------------------+



// | Copyright (c) 2004-2011 ARMIA INC                                    |



// +----------------------------------------------------------------------+



// | This source file is a part of iScripts PrintLogic                     |



// +----------------------------------------------------------------------+



// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |



// +----------------------------------------------------------------------+



App::import('Sanitize');



class ReportsController extends AppController



{



    var $name = "Reports";



	var $components = array ('Paginator'); // Added



 	var $uses = array('Report','Order','Product', 'Category','Coupon','Giftcard'); 



	var $helpers	=	array('Csv','xls');



	var $limit=5; //Setting the default limit of the records to display per page..



	



		



    function beforeFilter()



    {



        if (isset($this->Setting) && !empty($this->Setting->table))  



        {  



             $this->Setting->load();  



        } 



		global $sitefolder; 



		global $meta_description;



		global $meta_keywords;



		global $page_title;



		$cnfg 				=	Configure::read('Neutrino');



		$sitefolder			=	$cnfg["sitebasefolder"];



		$meta_description	=	$cnfg["meta_description"];



		$meta_keywords		=	$cnfg["meta_keywords"];



		$page_title			=	$cnfg["page_title"];



		global $style; 



		$style				=	$cnfg["style"];



		$this->set('style', $style);



		$this->set('meta_description', $meta_description);



		$this->set('meta_keywords', $meta_keywords);



		$this->pageTitle = $page_title	; 



		$this->set('cnfg',$cnfg);



    }



	function beforeRender()



    {



       // $this->layout = 'adm';



    }







    function index($curr_page='') //Function for Product Report...



    {



      	$this->__validateLoginStatus();



		$admsess	=	$this->Session->read('Admin');



		if($admsess["reports"] <> 1){



		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 



			exit();



		}

		

        $sort_type='DESC';



		$sortval='d';



		



		$min_date=explode(" ",$this->Report->getDates("min"));		



		$max_date=explode(" ",$this->Report->getDates("max"));		



		$this->set('dflt_mindate', $min_date[0]); //Setting the max date for the calendar...



		$this->set('dflt_maxdate', $max_date[0]); //Setting the max date for the calendar...



		



		if(isset($_POST["fdate"]) &&  isset($_POST["tdate"]) && $_POST["fdate"]<>'' && $_POST["tdate"]<>'')



		{		



		   $this->Session->write('frm_date', $_POST["fdate"]);



		   $this->Session->write('to_date', $_POST["tdate"]);



		   $frmdate=$this->Session->read('frm_date');



		   $todate=$this->Session->read('to_date');		



		   if($_POST["filter"]<>'')



		   $limit=$_POST["filter"];



		   $this->Session->write('show',$limit);					  



		}



		else if($this->Session->check('frm_date') == true && $this->Session->check('to_date')===true )



		{



			$frmdate=$this->Session->read('frm_date');



			$todate=$this->Session->read('to_date');					



			$limit=$this->Session->read('show');		



		}		



		else



		{



			if($this->Session->check('show') === true) $this->Session->delete('show');



			$this->Session->write('frm_date', $min_date[0]);



			$this->Session->write('to_date', $max_date[0]);		



			$this->Session->write('rec_limit', $this->limit);		



			$frmdate=$this->Session->read('frm_date');



		    $todate=$this->Session->read('to_date');			



			$limit=$this->limit;



			$this->Session->write('show',$limit);	



		}	



			



			//getting table names...



		$orddtlstbl=$this->Report->getTableName("order_details");



		$ordtbl=$this->Report->getTableName("orders");



		$prodtbl=$this->Report->getTableName("products");



		$proddtltbl=$this->Report->getTableName("productdetails");		



		//getting table names...



		/*

		$qry="SELECT PD.stock, PD.skuno,P.id, P.pname,P.wholesale_price,P.retail_price,P.stock as mainstock,ODT.extra_price,ODT.combination_id, SUM(ODT.product_price) , SUM(ODT.quantity)



			FROM $orddtlstbl ODT  INNER JOIN $ordtbl ORD ON ODT.order_id = ORD.id



			LEFT JOIN $prodtbl P ON ODT.product_id = P.id



			LEFT JOIN $proddtltbl PD ON ODT.combination_id = PD.id WHERE   DATE_FORMAT(ORD.date,'%Y-%m-%d')>='".$frmdate."' AND  DATE_FORMAT(ORD.date,'%Y-%m-%d') <='".$todate."' GROUP BY ODT.combination_id



			ORDER BY P.pname $sort_type";

			*/



			$qry="SELECT ODT.product_id,  SUM( ODT.product_price ) ,  SUM( ODT.extra_price ) , ODT.combination_id, ODT.type, SUM( ODT.quantity ) as tot_qty,SUM((ODT.product_price +ODT.extra_price ) * ODT.quantity ) AS tot_price

					FROM ".$orddtlstbl." ODT

				INNER JOIN ".$ordtbl." ORD ON ODT.order_id = ORD.id WHERE   DATE_FORMAT(ORD.date,'%Y-%m-%d')>='".$frmdate."' AND  DATE_FORMAT(ORD.date,'%Y-%m-%d') <='".$todate."'	GROUP BY ODT.product_id,ODT.type";



			//echo $qry;



			



		//Pagination Starts here...



		$total_pages =$this->Report->getReportDetails($qry,0);



		$start = $this->Paginator->setPageLimit($curr_page,$limit);		



		$data = $this->Report->getReportDetails($qry,1,$start,$limit);		



	    $pagination = $this->Paginator->paginator($curr_page,$limit,$total_pages);		



		//Pagination Starts here...		



		$this->set('mindate', $frmdate);



		$this->set('maxdate', $todate);



	 

	

		for($j=0;$j < sizeof($data);$j++){

				  if($data[$j]["ODT"]["type"]=='P')

				  {

					$pdet	=	$this->Product->findById($data[$j]["ODT"]["product_id"]);				  	

					$data[$j]["Product"]	=	$pdet["Product"]["pname"];

					$data[$j]["Avail_stock"]	=	$pdet["Product"]["stock"];

				  }

				  else if($data[$j]["ODT"]["type"]=='G')

				  {

					$gdet	=	$this->Giftcard->findById($data[$j]["ODT"]["product_id"]);								

					$data[$j]["Product"]	=	$gdet["Giftcard"]["gift_code"].'(Gift Card)';

					$data[$j]["Avail_stock"]	=	$gdet["Giftcard"]["stock"];

				  }

				}		

				

				



		$this->set('reportdet', $data);

		

		//echo "<pre>";

								//print_r($data);

								//echo "</pre>";



		$this->set('totrec', $total_pages);



		$this->set('pageno', $curr_page);



		$this->set('filterval', $limit);		



		$this->set('pagination', $pagination);		



		$this->layout = 'adm';



    } 



	



	



	



   function sales($curr_page='') //Function for Sales Report...



    {



      	$this->__validateLoginStatus();	 



  		$admsess	=	$this->Session->read('Admin');



		if($admsess["reports"] <> 1){



		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 



			exit();



		}



        $sort_type='DESC';



		$sortval='d';



				



		$sales_min_date=explode(" ",$this->Report->getDates("min"));		



		$sales_max_date=explode(" ",$this->Report->getDates("max"));		



		$this->set('dflt_mindate', $sales_min_date[0]); //Setting the max date for the calendar...



		$this->set('dflt_maxdate', $sales_max_date[0]); //Setting the max date for the calendar...



		



		if(isset($_POST["sales_fdate"]) &&  isset($_POST["sales_tdate"]) && $_POST["sales_fdate"]<>'' && $_POST["sales_tdate"]<>'')



		{		



		   $this->Session->write('sales_frm_date', $_POST["sales_fdate"]);



		   $this->Session->write('sales_to_date', $_POST["sales_tdate"]);



		   $frmdate=$this->Session->read('sales_frm_date');



		   $todate=$this->Session->read('sales_to_date');		



		    if($_POST["filter"]<>'')



		   $limit=$_POST["filter"];



		   $this->Session->write('show',$limit);	



		}



		else if($this->Session->check('sales_frm_date') === true && $this->Session->check('sales_to_date')===true )



		{



			$frmdate=$this->Session->read('sales_frm_date');



			$todate=$this->Session->read('sales_to_date');		



			$limit=$this->Session->read('show');					  



		}		



		else



		{



			if($this->Session->check('show') === true) $this->Session->delete('show');



			$this->Session->write('sales_frm_date', $sales_min_date[0]);



			$this->Session->write('sales_to_date', $sales_max_date[0]);		



			$frmdate=$this->Session->read('sales_frm_date');



		    $todate=$this->Session->read('sales_to_date');		



			$limit=$this->limit;



			$this->Session->write('show',$limit);				



		}	



			



        



		//getting table names...



		$ordtbl=$this->Report->getTableName("orders");



		$usrtbl=$this->Report->getTableName("users");



		$cpntbl=$this->Report->getTableName("coupons");		



		$statustbl=$this->Report->getTableName("order_statuses");		



		//getting table names...		



 		



			 



			 $qry="SELECT ORD.id,ORD.date,USR.uname,ORD.total_price, ORD.discount,CPN.code,ORS.name



			FROM ".$ordtbl."  ORD  INNER JOIN  ".$usrtbl."  USR  ON ORD.user_id = USR.id



			LEFT JOIN     ".$cpntbl." CPN         ON  ORD.coupon_id = CPN.id



			LEFT JOIN   ".$statustbl." ORS  ON  ORD.order_status_id = ORS.id WHERE  



			 DATE_FORMAT(ORD.date,'%Y-%m-%d')>= '".$frmdate."' AND  DATE_FORMAT(ORD.date,'%Y-%m-%d') <= '".$todate."' ORDER BY ORD.date DESC";



			



			



								



		$total_pages =$this->Report->getReportDetails($qry,0);		



		$start = $this->Paginator->setPageLimit($curr_page,$limit);



		$data = $this->Report->getReportDetails($qry,1,$start,$limit);		



	    $pagination = $this->Paginator->paginator($curr_page,$limit,$total_pages,$frmdate,$todate);				



		$this->set('mindate', $frmdate);



		$this->set('maxdate', $todate);



	    $this->set('reportdet', $data);



		$this->set('totrec', $total_pages);



		$this->set('pageno', $curr_page);

		

		$this->set('filterval', $limit);		



		$this->set('pagination', $pagination);				



		$this->layout = 'adm';



    } 



	



	 function user($curr_page=1) //Function for Users Report...



    {



		$this->__validateLoginStatus();				



 		$admsess	=	$this->Session->read('Admin');



		if($admsess["reports"] <> 1){



		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 



			exit();



		}



        $user_min_date=explode(" ",$this->Report->getDates_reg("min"));		



		$user_max_date=explode(" ",$this->Report->getDates_reg("max"));		



		$this->set('dflt_mindate', $user_min_date[0]); //Setting the max date for the calendar...



		$this->set('dflt_maxdate', $user_max_date[0]); //Setting the max date for the calendar...



        if(isset($_POST["user_fdate"]) &&  isset($_POST["user_tdate"]) && $_POST["user_fdate"]<>'' && $_POST["user_tdate"]<>'')



		{		



		   if($this->Session->check('user_frm_date') === true) $this->Session->delete('user_frm_date');



		   if($this->Session->check('user_to_date') === true) $this->Session->delete('user_to_date');



		   $this->Session->write('user_frm_date', $_POST["user_fdate"]);



		   $this->Session->write('user_to_date', $_POST["user_tdate"]);



		   $frmdate=$this->Session->read('user_frm_date');



		   $todate=$this->Session->read('user_to_date');		



		    if($_POST["filter"]<>'')



		   $limit=$_POST["filter"];



		   $this->Session->write('show',$limit);	



		}



		else if($this->Session->check('user_frm_date') == true && $this->Session->check('user_to_date')===true )



		{



			$frmdate=$this->Session->read('user_frm_date');



			$todate=$this->Session->read('user_to_date');		



			$limit=$this->Session->read('show');					 



		}		



		else



		{



			if($this->Session->check('show') === true) $this->Session->delete('show');



			$this->Session->write('user_frm_date', $user_min_date[0]);



			$this->Session->write('user_to_date', $user_max_date[0]);		



			$frmdate=$this->Session->read('user_frm_date');



		    $todate=$this->Session->read('user_to_date');		



			$limit=$this->limit;



			$this->Session->write('show',$limit);				



			



		}	



			



			//getting table names...



			$cttbl=$this->Report->getTableName("users");



			$cttb2=$this->Report->getTableName("user_addresses");	



			//getting table names...	



			$qry="SELECT usr.uname,usr.email,DATE_FORMAT(usr.reg_date,'%m-%d-%Y')as reg_date, uadd.addr_type, uadd.fname, uadd.lname, uadd.address, uadd.city, uadd.state, uadd.country, uadd.zip, uadd.phone, uadd.fax, uadd.mobile FROM ".$cttbl." as usr LEFT JOIN ".$cttb2." as uadd ON usr.id= uadd.user_id  WHERE DATE_FORMAT(usr.reg_date,'%Y-%m-%d') >= '".$frmdate."' AND  DATE_FORMAT(usr.reg_date,'%Y-%m-%d') <= '".$todate."' GROUP BY usr.id";



	



			$total_pages =$this->Report->getReportDetails($qry,0);		



			$start = $this->Paginator->setPageLimit($curr_page,$limit);



			$data = $this->Report->getReportDetails($qry,1,$start,$limit);



			$pagination = $this->Paginator->paginator($curr_page,$limit,$total_pages);	



			//$this->set('mindate', $user_min_date[0]);



			//$this->set('maxdate', $user_max_date[0]);

			

			

		       $this->set('mindate', $frmdate);



		   $this->set('maxdate', $todate);

			



			$this->set('reportdet', $data);



			$this->set('totrec', $total_pages);



		    $this->set('pageno', $curr_page);



		    $this->set('filterval', $limit);		



		    $this->set('pagination', $pagination);		



			$this->layout = 'adm';



	}



	



//Creating CSV and XLS for User Reports starts here................



	function usercsv($fdt='',$tdt='')



    {



			$this->__validateLoginStatus();	



			$admsess	=	$this->Session->read('Admin');



			if($admsess["reports"] <> 1){



				$this->redirect(array('controller' => 'admins', 'action' => 'index')); 



				exit();



			}



			$min_date=explode(" ",$this->Report->getDates_reg("min"));		



			$max_date=explode(" ",$this->Report->getDates_reg("max"));		 			



			if( isset($fdt) &&  isset($tdt)&& $fdt <> '' && $tdt <> '')



			{		



			  $frmdate=$fdt;		



			  $todate=$tdt;				



			}



			else



			{



				$frmdate=$min_date[0];



				$todate=$max_date[0];	



			}	



			//getting table names...



			$cttbl=$this->Report->getTableName("users");



			$cttb2=$this->Report->getTableName("user_addresses");



			//getting table names...	



			$qry="SELECT usr.uname,usr.email,DATE_FORMAT(usr.reg_date,'%m-%d-%Y')as reg_date, uadd.addr_type, uadd.fname, uadd.lname, uadd.address, uadd.city, uadd.state, uadd.country, uadd.zip, uadd.phone, uadd.fax, uadd.mobile FROM ".$cttbl." as usr LEFT JOIN ".$cttb2." as uadd ON usr.id= uadd.user_id  WHERE DATE_FORMAT(usr.reg_date,'%Y-%m-%d') >= '".$frmdate."' AND  DATE_FORMAT(usr.reg_date,'%Y-%m-%d') <= '".$todate."' GROUP BY usr.id";



			$data =$this->Report->getReportDetails($qry,2);	



			$this->set('data',$data);	



			$this->layout	=	'csvexp';



	}



	function userxls($fdt='',$tdt='')



    {



			$this->__validateLoginStatus();	



			$admsess	=	$this->Session->read('Admin');



			if($admsess["reports"] <> 1){



				$this->redirect(array('controller' => 'admins', 'action' => 'index')); 



				exit();



			}



			$min_date=explode(" ",$this->Report->getDates_reg("min"));		



			$max_date=explode(" ",$this->Report->getDates_reg("max"));		 			



			if( isset($fdt) &&  isset($tdt)&& $fdt <> '' && $tdt <> '')



			{		



			  $frmdate=$fdt;		



			  $todate=$tdt;				



			}



			else



			{



				$frmdate=$min_date[0];



				$todate=$max_date[0];	



			}	



			//getting table names...



			$cttbl=$this->Report->getTableName("users");



			$cttb2=$this->Report->getTableName("user_addresses");



			//getting table names...	



			$qry="SELECT usr.uname,usr.email,DATE_FORMAT(usr.reg_date,'%m-%d-%Y')as reg_date, uadd.addr_type, uadd.fname, uadd.lname, uadd.address, uadd.city, uadd.state, uadd.country, uadd.zip, uadd.phone, uadd.fax, uadd.mobile FROM ".$cttbl." as usr LEFT JOIN ".$cttb2." as uadd ON usr.id= uadd.user_id  WHERE DATE_FORMAT(usr.reg_date,'%Y-%m-%d') >= '".$frmdate."' AND  DATE_FORMAT(usr.reg_date,'%Y-%m-%d') <= '".$todate."' GROUP BY usr.id";



			$data =$this->Report->getReportDetails($qry,2);	



			$this->set('data',$data);	



			$this->layout	=	'csvexp';



	}



//Creating CSV and XLS for User Reports Ends here................	



	



	 function couponcode($curr_page)



    {



			$this->__validateLoginStatus();	 



			$admsess	=	$this->Session->read('Admin');



			if($admsess["reports"] <> 1){



				$this->redirect(array('controller' => 'admins', 'action' => 'index')); 



				exit();



			}



			/*



			$min_date=explode(" ",$this->Report->getDates_coupons("min"));		



			$max_date=explode(" ",$this->Report->getDates_coupons("max"));		 			



			if( isset($_POST["fdate"]) &&  isset($_POST["tdate"]))



			{		



			  $frmdate=$_POST["fdate"];		



			  $todate=$_POST["tdate"];				



			}



			else



			{



				$frmdate=$min_date[0];



				$todate=$max_date[0];	



			}	*/		



			



		$coupon_min_date=explode(" ",$this->Report->getDates_coupons("min"));		



		$coupon_max_date=explode(" ",$this->Report->getDates_coupons("max"));		



		$this->set('dflt_mindate', $coupon_min_date[0]); //Setting the max date for the calendar...



		$this->set('dflt_maxdate', $coupon_max_date[0]); //Setting the max date for the calendar...







		if(isset($_POST["coupon_fdate"]) &&  isset($_POST["coupon_tdate"]) && $_POST["coupon_fdate"]<>'' && $_POST["coupon_tdate"]<>'')



		{		

		

		   $this->Session->write('coupon_frm_date', $_POST["coupon_fdate"]);



		   $this->Session->write('coupon_to_date', $_POST["coupon_tdate"]);



		   $frmdate=$this->Session->read('coupon_frm_date');



		   $todate=$this->Session->read('coupon_to_date');		



		    if($_POST["filter"]<>'')



		   $limit=$_POST["filter"];



		   $this->Session->write('show',$limit);	



		}



		else if($this->Session->check('coupon_frm_date') === true && $this->Session->check('coupon_to_date')===true )



		{



			$frmdate=$this->Session->read('coupon_frm_date');



			$todate=$this->Session->read('coupon_to_date');		



			$limit=$this->Session->read('show');					  



		}		



		else



		{



			if($this->Session->check('show') === true) $this->Session->delete('show');



			$this->Session->write('coupon_frm_date', $coupon_min_date[0]);



			$this->Session->write('coupon_to_date', $coupon_max_date[0]);		



			$frmdate=$this->Session->read('coupon_frm_date');



		    $todate=$this->Session->read('coupon_to_date');		



			$limit=$this->limit;



			$this->Session->write('show',$limit);				



		}	



						



			//getting table names...



			$cttbl=$this->Report->getTableName("coupons");	

            $cttbl = str_replace('`','',$cttbl)	;		

			//getting table names...	



			//$qry="SELECT *,DATE_FORMAT(`from`,'%m-%d-%Y')as fromDate, DATE_FORMAT(`to`,'%m-%d-%Y') as toDate FROM $cttbl WHERE DATE_FORMAT(`from`,'%Y-%m-%d') >= '".$frmdate."' AND  DATE_FORMAT(`from`,'%Y-%m-%d') <= '".$todate."'" ;



	        $qry="SELECT * FROM $cttbl WHERE `from_date` >= '".$frmdate."' AND `to_date` <= '".$todate."'";



			$total_pages =$this->Report->getReportDetails($qry,0);		



			$start = $this->Paginator->setPageLimit($curr_page,$limit);



			$data = $this->Report->getReportDetails($qry,1,$start,$limit);



			$pagination = $this->Paginator->paginator($curr_page,$limit,$total_pages);				

			

            $this->set('cpntbl',  $cttbl);



			$this->set('reportdet', $data);

			

			//$this->set('mindate', $coupon_min_date[0]);



			//$this->set('maxdate', $coupon_max_date[0]);

			$this->set('mindate', $frmdate);



		    $this->set('maxdate', $todate);



			$this->set('totrec', $total_pages);



		    $this->set('pageno', $curr_page);



		    $this->set('filterval', $limit);		



		    $this->set('pagination', $pagination);	



			$this->set('pagination', $pagination);



			$this->layout = 'adm';



	}	



	



	//Creating CSV and XLS Promocode Reports starts here................



	 function couponcodecsv()



    {



			$this->__validateLoginStatus();	 



			$admsess	=	$this->Session->read('Admin');



			if($admsess["reports"] <> 1){



				$this->redirect(array('controller' => 'admins', 'action' => 'index')); 



				exit();



			}



			$min_date=explode(" ",$this->Report->getDates_coupons("min"));		



			$max_date=explode(" ",$this->Report->getDates_coupons("max"));		 			



			if( isset($fdt) &&  isset($tdt)&& $fdt <> '' && $tdt <> '')



			{		



			  $frmdate=$fdt;		



			  $todate=$tdt;				



			}



			else



			{



				$frmdate=$min_date[0];



				$todate=$max_date[0];	



			}	



			//getting table names...



			$cttbl=$this->Report->getTableName("coupons");

            $cttbl = str_replace('`','',$cttbl)	;		

	



			//getting table names...	



			//$qry="SELECT *,DATE_FORMAT(`from`,'%m-%d-%Y')as fromDate, DATE_FORMAT(`to`,'%m-%d-%Y') as toDate FROM $cttbl WHERE DATE_FORMAT(`from`,'%Y-%m-%d') >= '".$frmdate."' AND  DATE_FORMAT(`from`,'%Y-%m-%d') <= '".$todate."'" ;



			$qry="SELECT * FROM $cttbl";



			$data = $this->Report->getReportDetails($qry,2);



            $this->set('cpntbl',  $cttbl);

			$this->set('data',$data);



			$this->layout = 'csvexp';



	}



	 function couponcodexls()



    {



			$this->__validateLoginStatus();	 



			$admsess	=	$this->Session->read('Admin');



			if($admsess["reports"] <> 1){



				$this->redirect(array('controller' => 'admins', 'action' => 'index')); 



				exit();



			}



			$min_date=explode(" ",$this->Report->getDates_coupons("min"));		



			$max_date=explode(" ",$this->Report->getDates_coupons("max"));		 			



			if( isset($fdt) &&  isset($tdt)&& $fdt <> '' && $tdt <> '')



			{		



			  $frmdate=$fdt;		



			  $todate=$tdt;				



			}



			else



			{



				$frmdate=$min_date[0];



				$todate=$max_date[0];	



			}	



			//getting table names...



			$cttbl=$this->Report->getTableName("coupons");

            $cttbl = str_replace('`','',$cttbl)	;	

	



			//getting table names...	



			//$qry="SELECT *,DATE_FORMAT(`from`,'%m-%d-%Y')as fromDate, DATE_FORMAT(`to`,'%m-%d-%Y') as toDate FROM $cttbl WHERE DATE_FORMAT(`from`,'%Y-%m-%d') >= '".$frmdate."' AND  DATE_FORMAT(`from`,'%Y-%m-%d') <= '".$todate."'" ;



			$qry="SELECT * FROM $cttbl";



			$data = $this->Report->getReportDetails($qry,2);



            $this->set('cpntbl',  $cttbl);

			$this->set('data',$data);



			$this->layout = 'csvexp';



	}



 //Creating CSV and XLS Promocode Reports Ends here................



	







	function productcsv($fdt='',$tdt=''){



		$this->__validateLoginStatus();	 



		$admsess	=	$this->Session->read('Admin');



		if($admsess["reports"] <> 1){



		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 



			exit();



		}



		$min_date=explode(" ",$this->Report->getDates("min"));		



		$max_date=explode(" ",$this->Report->getDates("max"));		 			



		if( isset($fdt) &&  isset($tdt)&& $fdt <> '' && $tdt <> '')



		{		



		  $frmdate=$fdt;		



		  $todate=$tdt;				



		}



		else



		{



			$frmdate=$min_date[0];



			$todate=$max_date[0];	



		}



		



		//getting table names...



		$orddtlstbl=$this->Report->getTableName("order_details");



		$ordtbl=$this->Report->getTableName("orders");



		$prodtbl=$this->Report->getTableName("products");



		$proddtltbl=$this->Report->getTableName("productdetails");		



		//getting table names...



		/*$qry="SELECT PD.stock, PD.skuno,P.id, P.pname,P.price,P.stock as mainstock,ODT.extra_price,ODT.combination_id, SUM(ODT.product_price) , SUM(ODT.quantity)



			FROM $orddtlstbl ODT  INNER JOIN $ordtbl ORD ON ODT.order_id = ORD.id



			LEFT JOIN $prodtbl P ON ODT.product_id = P.id



			LEFT JOIN $proddtltbl PD ON ODT.combination_id = PD.id WHERE   DATE_FORMAT(ORD.date,'%Y-%m-%d')>='".$frmdate."' AND  DATE_FORMAT(ORD.date,'%Y-%m-%d') <='".$todate."' GROUP BY ODT.combination_id



			ORDER BY P.pname ASC";

			*/

			

			

			$qry="SELECT ODT.product_id,  SUM( ODT.product_price ) ,  SUM( ODT.extra_price ) , ODT.combination_id, ODT.type, SUM( ODT.quantity ) as tot_qty,SUM((ODT.product_price +ODT.extra_price ) * ODT.quantity ) AS tot_price

					FROM ".$orddtlstbl."  ODT

				INNER JOIN ".$ordtbl."  ORD ON ODT.order_id = ORD.id WHERE   DATE_FORMAT(ORD.date,'%Y-%m-%d')>='".$frmdate."' AND  DATE_FORMAT(ORD.date,'%Y-%m-%d') <='".$todate."'	GROUP BY ODT.product_id,ODT.type";



		$data = $this->Report->getReportDetails($qry,2);

		

		

		for($j=0;$j < sizeof($data);$j++){

				  if($data[$j]["ODT"]["type"]=='P')

				  {

					$pdet	=	$this->Product->findById($data[$j]["ODT"]["product_id"]);				  	

					$data[$j]["Product"]	=	$pdet["Product"]["pname"];

					$data[$j]["Avail_stock"]	=	$pdet["Product"]["stock"];

				  }

				  else if($data[$j]["ODT"]["type"]=='G')

				  {

					$gdet	=	$this->Giftcard->findById($data[$j]["ODT"]["product_id"]);								

					$data[$j]["Product"]	=	$gdet["Giftcard"]["gift_code"].'(Gift Card)';

					$data[$j]["Avail_stock"]	=	$gdet["Giftcard"]["stock"];

				  }

				}		

				



		$this->set('data', $data);		



		$this->layout = 'csvexp';



	}



	function productxls($fdt='',$tdt=''){



		$this->__validateLoginStatus();	 



		$admsess	=	$this->Session->read('Admin');



		if($admsess["reports"] <> 1){



		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 



			exit();



		}



		$min_date=explode(" ",$this->Report->getDates("min"));		



		$max_date=explode(" ",$this->Report->getDates("max"));		 			



		if( isset($fdt) &&  isset($tdt)&& $fdt <> '' && $tdt <> '')



		{		



		  $frmdate=$fdt;		



		  $todate=$tdt;				



		}



		else



		{



			$frmdate=$min_date[0];



			$todate=$max_date[0];	



		}



		



		//getting table names...



		$orddtlstbl=$this->Report->getTableName("order_details");



		$ordtbl=$this->Report->getTableName("orders");



		$prodtbl=$this->Report->getTableName("products");



		$proddtltbl=$this->Report->getTableName("productdetails");		



		//getting table names...

/*

		$qry="SELECT PD.stock, PD.skuno,P.id, P.pname,P.price,P.stock as mainstock,ODT.extra_price,ODT.combination_id, SUM(ODT.product_price) , SUM(ODT.quantity)



			FROM $orddtlstbl ODT  INNER JOIN $ordtbl ORD ON ODT.order_id = ORD.id



			LEFT JOIN $prodtbl P ON ODT.product_id = P.id



			LEFT JOIN $proddtltbl PD ON ODT.combination_id = PD.id WHERE   DATE_FORMAT(ORD.date,'%Y-%m-%d')>='".$frmdate."' AND  DATE_FORMAT(ORD.date,'%Y-%m-%d') <='".$todate."' GROUP BY ODT.combination_id



			ORDER BY P.pname ASC";

			*/

			

			$qry="SELECT ODT.product_id,  SUM( ODT.product_price ) ,  SUM( ODT.extra_price ) , ODT.combination_id, ODT.type, SUM( ODT.quantity ) as tot_qty,SUM((ODT.product_price +ODT.extra_price ) * ODT.quantity ) AS tot_price

					FROM ".$orddtlstbl." ODT

				INNER JOIN ".$ordtbl." ORD ON ODT.order_id = ORD.id WHERE   DATE_FORMAT(ORD.date,'%Y-%m-%d')>='".$frmdate."' AND  DATE_FORMAT(ORD.date,'%Y-%m-%d') <='".$todate."'	GROUP BY ODT.product_id,ODT.type";





		$data = $this->Report->getReportDetails($qry,2);



       

		for($j=0;$j < sizeof($data);$j++){

				  if($data[$j]["ODT"]["type"]=='P')

				  {

					$pdet	=	$this->Product->findById($data[$j]["ODT"]["product_id"]);				  	

					$data[$j]["Product"]	=	$pdet["Product"]["pname"];

					$data[$j]["Avail_stock"]	=	$pdet["Product"]["stock"];

				  }

				  else if($data[$j]["ODT"]["type"]=='G')

				  {

					$gdet	=	$this->Giftcard->findById($data[$j]["ODT"]["product_id"]);								

					$data[$j]["Product"]	=	$gdet["Giftcard"]["gift_code"].'(Gift Card)';

					$data[$j]["Avail_stock"]	=	$gdet["Giftcard"]["stock"];

				  }

				}		

				



		$this->set('data', $data);		



		$this->layout = 'csvexp';



	}



	function salescsv($fdt='',$tdt=''){ //Function for Sales Report...



      	$this->__validateLoginStatus();	 



		$admsess	=	$this->Session->read('Admin');



		if($admsess["reports"] <> 1){



		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 



			exit();



		}



		$min_date=explode(" ",$this->Report->getDates("min"));		



		$max_date=explode(" ",$this->Report->getDates("max"));		 			



		if( isset($fdt) &&  isset($tdt)&& $fdt <> '' && $tdt <> '')



		{		



		  $frmdate=$fdt;		



		  $todate=$tdt;				



		}



		else



		{



			$frmdate=$min_date[0];



			$todate=$max_date[0];	



		}



		//getting table names...



		$ordtbl=$this->Report->getTableName("orders");



		$usrtbl=$this->Report->getTableName("users");



		$cpntbl=$this->Report->getTableName("coupons");		



		$statustbl=$this->Report->getTableName("order_statuses");		



		//getting table names...		



 					 



			 $qry="SELECT ORD.id,ORD.date,USR.uname,ORD.total_price, ORD.discount,CPN.code,ORS.name



			FROM ".$ordtbl."  ORD  INNER JOIN  ".$usrtbl." USR  ON ORD.user_id = USR.id



			LEFT JOIN   ".$cpntbl." CPN         ON  ORD.coupon_id = CPN.id



			LEFT JOIN   ".$statustbl." ORS  ON  ORD.order_status_id = ORS.id WHERE  



			 DATE_FORMAT(ORD.date,'%Y-%m-%d')>= '".$frmdate."' AND  DATE_FORMAT(ORD.date,'%Y-%m-%d') <= '".$todate."' ORDER BY ORD.date DESC";



			 



		$data = $this->Report->getReportDetails($qry,2);		



		$this->set('data', $data);		



		$this->layout = 'csvexp';



    } 



	function salesxls($fdt='',$tdt=''){ //Function for Sales Report...



      	$this->__validateLoginStatus();	 



		$admsess	=	$this->Session->read('Admin');



		if($admsess["reports"] <> 1){



		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 



			exit();



		}



		$min_date=explode(" ",$this->Report->getDates("min"));		



		$max_date=explode(" ",$this->Report->getDates("max"));		 			



		if( isset($fdt) &&  isset($tdt)&& $fdt <> '' && $tdt <> '')



		{		



		  $frmdate=$fdt;		



		  $todate=$tdt;				



		}



		else



		{



			$frmdate=$min_date[0];



			$todate=$max_date[0];	



		}



		//getting table names...



		$ordtbl=$this->Report->getTableName("orders");



		$usrtbl=$this->Report->getTableName("users");



		$cpntbl=$this->Report->getTableName("coupons");		



		$statustbl=$this->Report->getTableName("order_statuses");		



		//getting table names...		



 		



			 



			  		$qry="SELECT ORD.id,ORD.date,USR.uname,ORD.total_price, ORD.discount,CPN.code,ORS.name



			FROM ".$ordtbl."  ORD  INNER JOIN  ".$usrtbl."  USR  ON ORD.user_id = USR.id



			LEFT JOIN    ".$cpntbl." CPN         ON  ORD.coupon_id = CPN.id



			LEFT JOIN  ".$statustbl." ORS  ON  ORD.order_status_id = ORS.id WHERE  



			 DATE_FORMAT(ORD.date,'%Y-%m-%d')>= '".$frmdate."' AND  DATE_FORMAT(ORD.date,'%Y-%m-%d') <= '".$todate."' ORDER BY ORD.date DESC";







		$data = $this->Report->getReportDetails($qry,2);		



		$this->set('data', $data);		



		$this->layout = 'csvexp';



    } 



	function __validateLoginStatus($typ='A')
    {
           if($typ == 'A'){
				if($this->Session->check('Admin') == false)
				{
					$this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
					$this->redirect(array('controller' => 'admins', 'action' => 'login')); 
				}
		}else{
				if($this->Session->check('Userlog') == false)
				{
					$this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
					$this->redirect(array('controller' => 'users', 'action' => 'login')); 
				}
			}
    }
}
?>