<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2010 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts VistaCart                     |
// +----------------------------------------------------------------------+
// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |
// +----------------------------------------------------------------------+
?>
<div class="steps_blk_top">
	<h3>Run a Campaign</h3>
</div>
<div class="steps_blk">
	<div class="steps_blk_cell">
		<div class="steps_blk_rounds active">1</div>
		<span>Select Product</span>
	</div>
	<div class="steps_blk_cell">
		<div class="steps_blk_rounds">2</div>
		<span>Create Content</span>
	</div>
	<div class="steps_blk_cell">
		<div class="steps_blk_rounds">3</div>
		<span>Set Schedule</span>
	</div>
	<div class="steps_blk_cell">
		<div class="steps_blk_rounds">4</div>
		<span>Select Locations</span>
	</div>
	<div class="steps_blk_cell">
		<div class="steps_blk_rounds">5</div>
		<span>Rollout Campaign</span>
	</div>
</div>
<div class="inner_subhead_container">
    <div class="inner_subhead_content">All Products</div>
    <div class="clear"></div>
    <div class="page_step_title">Select your product</div>
    <div class="clear"></div>
</div> 




<?php  
//print_r($chldcateg);exit;
if(empty($products)==false) { ?>
<div align="left" id="item_details">
    <!--items display area start -->
    <div align="center" id="items_display_area">

        <div class="pr_listing_container">
		<div class="row">
                <?php
                foreach($products as $ft) {
                    ?>
			<div class="four columns">
            <!-- Single item starts here -->
            <div class="home_product_box">

                <div class="list_img">
                    <a href="<?php echo $html->url('/products/show/'.productnamealias($ft["Product"]["pname"]).'/'.$ft["Product"]["id"]); ?>" >
                                <?php
                                $img=explode(".",$ft["Productimages"]);
                                $ext='.'.end(explode(".",$ft["Productimages"]));
                                if(!empty($img[0])== true) {
                                    if(file_exists(WWW_ROOT.IMAGES_URL.'/products/'.$img[0].$ext)) {

                                        echo $html->image('/img/products/'.$img[0].$ext,array('border' => '0', 'class' => 'img_listing','title' => 'View More'));
                                    }
                                    else {
                                        echo $html->image('/img/noimages.gif',array('border' => '0','class' => 'img_listing','title' => 'No Image'));
                                    }
                                }
                                else {
                                    echo $html->image('/img/noimages.gif',array('border' => '0','class' => 'img_listing','title' => 'No Image'));
                                }
                                ?>
                    </a>
                </div>
                             <!--- price hidden as per requirement --->
                             <div class="list_desc" style="display: none;">
                            <?php
                            //Setting the Prices & Discount for Wholesale/Retail Users
                            $prod_price=0;
                            $discnt_type='';
                            $discnt_price=0;
                            if($ft["Product"]["wholesale_price"] > 0 || $ft["Product"]["price"] > 0 ) {
                                if(isset($ft["Product"]["discount"]) && $ft["Product"]["discount"] > 0) {
                                    $discnt_type=$ft["Product"]["discount_type"];
                                    $discnt_price=$ft["Product"]["discount"];
                                }
                            }
                            if(isset($sus) && empty($sus)===false) {
                                if($sus["usertype"]=='wholesale') {
                                    if(isset($ft["Product"]["wholesale_price"]) && $ft["Product"]["wholesale_price"] > 0 ) {
                                        $wholesale_price=$ft["Product"]["wholesale_price"];
                                        $utype='wholesale';
                                        display_price($utype,$wholesale_price,$discnt_type,$discnt_price,$curlogo);
                                    }
                                    else if(isset($ft["Product"]["price"]) && $ft["Product"]["price"] > 0 ) {
                                        $retail_price=$ft["Product"]["price"];
                                        $utype='retail';
                                        display_price($utype,$retail_price,$discnt_type,$discnt_price,$curlogo);
                                    }
                                    else
                                        display_price('',0,'',0,$curlogo);
                                }

                                else if($sus["usertype"]=='retail') {
                                    if(isset($ft["Product"]["price"]) && $ft["Product"]["price"] > 0 ) {
                                        $retail_price=$ft["Product"]["price"];
                                        $utype='retail';
                                        display_price($utype,$retail_price,$discnt_type,$discnt_price,$curlogo);
                                    }
                                    else
                                        display_price('',0,'',0,$curlogo);
                                }
                            }
                            else {
                                if(isset($ft["Product"]["price"]))
                                    $retail_price=$ft["Product"]["price"];
                                $utype='normal';
                                display_price($utype,$retail_price,$discnt_type,$discnt_price,$curlogo);
                            }
                            //Setting the Prices for Wholesale/Retail Users
                            ?>
                </div>
                 <!--- price hidden as per requirement --->
                <div class="list_name">

                            <?php $prodname=$ft["Product"]["pname"];
                            if(strlen($prodname)>20) {
                                $prodname=substr($prodname, 0, 20)."..."; ?>
                    <a href="<?php echo $html->url('/products/show/'.productnamealias($ft["Product"]["pname"]).'/'.$ft["Product"]["id"]); ?>" class="tooltip" title="<?php echo $ft["Product"]["pname"]; ?>"><?php echo $ft["Product"]["pname"]; ?>...</a>
                                <?php
                            }
                            else { ?>
                    <a href="<?php echo $html->url('/products/show/'.productnamealias($ft["Product"]["pname"]).'/'.$ft["Product"]["id"]); ?>"><?php echo $ft["Product"]["pname"]; ?></a>
                                <?php } ?>
                </div>
                <div class="list_link_cat">
                    
                            <?php
                            if(isset($facebookKey['facebook_app_id']) && !empty($facebookKey['facebook_app_id'])) {
                                ?>
                    <div class="fb-like" data-href="<?php echo $html->url('http://'.$_SERVER['HTTP_HOST'].$cnfg["sitebasefolder"].'/products/show/'.productnamealias($ft["Product"]["pname"]).'/'.$ft["Product"]["id"]); ?>" data-send="true" data-layout="button_count" data-width="450" data-show-faces="true"></div>
                                <?php
                            }
                            ?>
                    <?php if(isset($twitterKey['tweet_status']) && $twitterKey['tweet_status']=='Y') { ?>
                    <div class="tweetbutton">
                        <a href="http://twitter.com/share" class="twitter-share-button" data-count="horizontal" data-text="<?php echo cleanspecialchars($ft["Product"]["pname"]); ?>" data-url="<?php echo FULL_BASE_URL.$html->url('/products/show/'.cleanspecialchars($ft["Product"]["pname"]).'/'.$ft["Product"]["id"]); ?>" data-counturl="<?php echo FULL_BASE_URL.$html->url('/products/show/'.cleanspecialchars($ft["Product"]["pname"]).'/'.$ft["Product"]["id"]); ?>" data-via="<?php echo $cnfg['site_name']?>">Tweet</a>
                        <script type="text/javascript" src="http://platform.twitter.com/widgets.js"></script>
                    </div>
                    <?php } ?>
                </div>

			</div>
            </div>
            <!-- Single item ends here -->



                    <?php } ?>

            <div class="clear"></div>
        </div>
        <div>
            <div class="inner_subhead_left"></div>
            <div class="pagination_container">

                <div class="result">

                        <?php
                        if($pagination->setPaging($paging)):
                            $leftArrow = "<";//$html->image("nav/arrowleft.gif", Array('height'=>15));
                            $rightArrow = ">";//$html->image("nav/arrowright.gif", Array('height'=>15));

                            $prev = $pagination->prevPage($leftArrow,false);
                            $prev = $prev?$prev:$leftArrow;
                            $next = $pagination->nextPage($rightArrow,false);
                            $next = $next?$next:$rightArrow;

                            $pages = $pagination->pageNumbers(" | ");

                            echo $pagination->result();
                            echo "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                            echo $prev." ".$pages." ".$next;
                            echo "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                            echo "Results per page : ";
                            echo $pagination->resultsPerPage(NULL, ' ');
                        endif;
                        ?>
                </div>


            </div>
            <div class="inner_subhead_right"></div>
        </div>


        <div  class="clear"></div>
    	</div>
	</div>


        <?php } else { ?>
    <br /><br /><h4 class="productHead" align="center">No Items Found</h4>

        <?php } ?>
    <!--items display area end -->
    <div class="clear"></div>
</div>
<div align="left" class="float_clear"><?php echo $html->image('/img/clear.gif',array('border' =>'0','alt' => '','width' => '1', 'height' => '1'));?></div>
<?php
//Function to display price for Wholesale and Retail Users
function display_price($utype='',$prod_price='',$discnt_type='',$discnt_price='',$curlogo='') {
    if($utype=='wholesale'){
        //echo "<b>Wholesale Price : </b>";
		}
    else if($utype=='retail'){
        //echo "<b>Price : </b>";
		}
    else if($utype=='normal'){
        //echo "<b>Price : </b>";
		}

    if(isset($discnt_type) && $discnt_type <> '') {
        if($discnt_type=='per') {
            if(isset($discnt_price) && $discnt_price <> '' && $discnt_price > 0) {
                $discounted_price=($prod_price-(($prod_price * $discnt_price)/100));
                echo "<strike>".$curlogo.number_format($prod_price,2)."</strike>"."<span>".$curlogo.number_format($discounted_price,2)."</span>";
            }
        }
        else if($discnt_type=='amnt') {
            if(isset($discnt_price) && $discnt_price <> '' && $discnt_price > 0) {
                $discounted_price=($prod_price-$discnt_price);
                echo "<strike>".$curlogo.number_format($prod_price,2)."</strike>"."<span>".$curlogo.number_format($discounted_price,2)."</span>";
            }
        }
    }
    else {
        echo "<span>".$curlogo.number_format($prod_price,2)."</span>";
    }
}

function cleanspecialchars($text) {
    $code_entities_match = array(' ','--','&quot;','!','@','#','$','%','^','&','*','(',')','_','+','{','}','|',':','"','<','>','?','[',']','\\',';',"'",',','.','/','*','+','~','`','=');
    $code_entities_replace =
            array('-','-','','','','','','','','','','','','','','','','','','','','','','','','');
    $text = str_replace($code_entities_match, $code_entities_replace, $text);
    return $text;
}
function productnamealias($text) {

    $code_entities_match = array(' ','/','#','%','?','&','!');
    $code_entities_replace = array('-');
    $text = str_replace($code_entities_match, $code_entities_replace, $text);
    return $text;
}
?>