<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Printlogic                    |
// +----------------------------------------------------------------------+
// | Authors: Jipson Thomas<jipson.thomas@armiasystems.com>               |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com � 2011                |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php
ini_set('display_errors', '0');
error_reporting(0);
$imagefolder =  "../img";
$stylesfolder = "../css";
$sitestyle="Eyewears.css";
$logoimage="SiteLogo.jpg";
$productname=" ";
unset($_SESSION);
session_start();
function isValidUsername($str)
{
	if (trim($str) !="" ) {
		if ( eregi ( "[^0-9a-zA-Z+_]", $str ) ) {
			return false;
		}else{
			return true;
		}
	}else{
		return false;
	}

}
function splitsqlfile($sql, $delimiter)
{
	// Split up our string into "possible" SQL statements.
	$tokens = explode($delimiter, $sql);
	// try to save mem.
	$sql = "";
	$output = array();
	// we don't actually care about the matches preg gives us.
	$matches = array();
	// this is faster than calling count($oktens) every time thru the loop.
	$token_count = count($tokens);
	for ($i = 0; $i < $token_count; $i++) {
		// Don't wanna add an empty string as the last thing in the array.
		if (($i != ($token_count - 1)) || (strlen($tokens[$i] > 0))) {
			// This is the total number of single quotes in the token.
			$total_quotes = preg_match_all("/'/", $tokens[$i], $matches);
			// Counts single quotes that are preceded by an odd number of backslashes,
			// which means they're escaped quotes.
			$escaped_quotes = preg_match_all("/(?<!\\\\)(\\\\\\\\)*\\\\'/", $tokens[$i], $matches);

			$unescaped_quotes = $total_quotes - $escaped_quotes;
			// If the number of unescaped quotes is even, then the delimiter did NOT occur inside a string literal.
			if (($unescaped_quotes % 2) == 0) {
				// It's a complete sql statement.
				$output[] = $tokens[$i];
				// save memory.
				$tokens[$i] = "";
			} else {
				// incomplete sql statement. keep adding tokens until we have a complete one.
				// $temp will hold what we have so far.
				$temp = $tokens[$i] . $delimiter;
				// save memory..
				$tokens[$i] = "";
				// Do we have a complete statement yet?
				$complete_stmt = false;

				for ($j = $i + 1; (!$complete_stmt && ($j < $token_count)); $j++) {
					// This is the total number of single quotes in the token.
					$total_quotes = preg_match_all("/'/", $tokens[$j], $matches);
					// Counts single quotes that are preceded by an odd number of backslashes,
					// which means they're escaped quotes.
					$escaped_quotes = preg_match_all("/(?<!\\\\)(\\\\\\\\)*\\\\'/", $tokens[$j], $matches);

					$unescaped_quotes = $total_quotes - $escaped_quotes;

					if (($unescaped_quotes % 2) == 1) {
						// odd number of unescaped quotes. In combination with the previous incomplete
						// statement(s), we now have a complete statement. (2 odds always make an even)
						$output[] = $temp . $tokens[$j];
						// save memory.
						$tokens[$j] = "";
						$temp = "";
						// exit the loop.
						$complete_stmt = true;
						// make sure the outer loop continues at the right point.
						$i = $j;
					} else {
						// even number of unescaped quotes. We still don't have a complete statement.
						// (1 odd and 1 even always make an odd)
						$temp .= $tokens[$j] . $delimiter;
						// save memory.
						$tokens[$j] = "";
					}
				} // for..
			} // else
		}
	}
	return $output;
}
function isValidTableName($str)
{
	if (trim($str) != "") {
		if (eregi ("[^a-zA-Z+_]", $str)) {
			return false;
		} else {
			return true;
		}
	} else {
		return false;
	}
}
function isValidEmail($email)
{
	$email = trim($email);
	if ($email == "")
		return false;
	if (!eregi("^" . "[a-z0-9]+([_\\.-][a-z0-9]+)*" . // user
			"@" . "([a-z0-9]+([\.-][a-z0-9]+)*)+" . // domain
			"\\.[a-z]{2,}" . // sld, tld
			"$", $email, $regs)
	) {
		return false;
	} else {
		return true;
	}
}
function isNotNull($value)
{
	if (is_array($value)) {
		if (sizeof($value) > 0) {
			return true;
		} else {
			return false;
		}
	} else {
		if (($value != '') && (strtolower($value) != 'null') && (strlen(trim($value)) > 0)) {
			return true;
		} else {
			return false;
		}
	}
}

function isValidWebImageType($mimetype,$filename,$tempname)
{
	$blacklist = array("php", "phtml", "php3", "php4", "js", "shtml", "pl" ,"py", "exe");
	foreach ($blacklist as $file)
	{
		if(preg_match("/\.$file\$/i", "$filename"))
		{
			return false;
		}
	}
	//check if its image file
	if (!getimagesize($tempname))
	{
		return false;
	}

	if (($mimetype == "image/pjpeg") || ($mimetype == "image/jpeg") || ($mimetype == "image/x-png") || ($mimetype == "image/png") || ($mimetype == "image/gif") ||
			($mimetype == "image/x-windows-bmp") || ($mimetype == "image/bmp")) {
		return true;
	} else {
		return false;
	}
}

function isValidWMImageType($mimetype,$filename,$tempname)
{
	/* if (($mimetype == "image/pjpeg") || ($mimetype == "image/jpeg") || ($mimetype == "image/gif")) {
	 return true;
	} else {
	return false;
	}*/
	$blacklist = array("php", "phtml", "php3", "php4", "js", "shtml", "pl" ,"py", "exe");
	foreach ($blacklist as $file)
	{
		if(preg_match("/\.$file\$/i", "$filename"))
		{
			return false;
		}
	}
	//check if its image file
	if (!getimagesize($tempname))
	{
		return false;
	}
	if ($mimetype == "image/gif") {
		return true;
	} else {
		return false;
	}
}

function getFilePermission($file){
	$perm = fileperms($file);
	if($perm === false){
		return "0000";
	}else{
		return substr(sprintf('%o', $perm), -4);
	}

}
function stripslashes_deep($value){
	$value = is_array($value) ? array_map('stripslashes_deep', $value) : stripslashes($value);
	return $value;
}
function getServerOS()
{
	return strtoupper(substr(PHP_OS, 0, 3));
}

//deprecated in php 5.3
@set_magic_quotes_runtime(0);

if (get_magic_quotes_gpc()) {
	$_POST = array_map('stripslashes_deep', $_POST);
	$_GET = array_map('stripslashes_deep', $_GET);
	$_COOKIE = array_map('stripslashes_deep', $_COOKIE);
}

function file_writable($file,$userDisplaypath){
	if(is_writable($file))
				{
				$file_status['status'] = true;
				$file_status['message'] = " * '" . $userDisplaypath . "' is writable";
				}
			else
			{
			$file_status['status'] = false;
            $file_status['message'] = " * Change the permission of '" . $userDisplaypath . "' to 777 <br/>";
        	}
			
		return $file_status;
}





$schemafile = "schema.sql";
$datafile = "data.sql";
$configfile = "../config.php";


		$configcontents = @fread(@fopen($configfile, 'r'), @filesize($configfile));
		$pos = strpos($configcontents, "INSTALLED");
		if ($pos === false) {
							;
			} else {
			header("Location:../index.php");
	}
	$fullurl = $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']);
	if($_SERVER['HTTPS']=='on'){
		$http = "https://";
	}else {
		$http = "http://";
	}
	$pos = strrpos($fullurl, "/");
	if ($pos === false) { // note: three equal signs
	// not found...
	} else 
	{
		$fullurl = substr($fullurl, 0, $pos);
	}

	$installed = false;
	$txtDBServerName="localhost";
	$txtTablePrefix		=	"PrintLogic_";
	$mystring 	=	dirname(dirname(__FILE__));
	$findme 	=	'webroot';
	$ps 		=	strpos($mystring, $findme);
	$dr			=	substr($mystring,0,$ps);
	$dr=rtrim($dr,"\\");
	$dr=rtrim($dr,"/");
	$dbconfigfile =$dr."/config/database.php";
	$configfile = $dr."/webroot/config.php";
	$txtSiteURL ="http://".$fullurl;
	$txtSecureSiteURL="https://" . $fullurl;
	$txtSiteURLt ="http://".$fullurl;
	$txtSecureSiteURLt="https://" . $fullurl;
	$txtSiteBaseFolderfull	=	dirname($_SERVER['PHP_SELF']);
	$findu 		=	'/app/webroot';
	$murl		=	strpos($txtSiteURL,$findu);
	$txtSiteURL	=	substr($txtSiteURL,0,$murl);
	$len		=	strpos($txtSiteBaseFolderfull,$findu);
	$txtSiteBaseFolder	=	substr($txtSiteBaseFolderfull,0,$len);
	//print_r($txtSiteBaseFolder);exit;
	$murs		=	strpos($txtSecureSiteURL,$findu);
	$txtSecureSiteURL	=	substr($txtSecureSiteURL,0,$murs);
	
	
if($_POST['cldpack']!=1)
	{	
/* *********************************check server configuration *****************************************************/

$server_flag = true;

$val1 = ini_get("safe_mode");
$val2 = ini_get("short_open_tag");
$val3 = ini_get("file_uploads");
$val_mb  = function_exists('mb_strlen');
$val_fread  = function_exists('fread');
$gd           = function_exists('gd_info');
$curl         = function_exists('curl_init');
$mysql        = function_exists('mysql_connect');
$system       = strpos(ini_get("disable_functions"), "system");
$imagick      = class_exists("Imagick");

ob_start();
$cmd = 'convert -version';
$imgVal = system($cmd,$out);
$variable = ob_get_clean();
$variable = explode(' ', $variable);
//$composite = exec('composite -version',$var);

ob_start();
$cmd1 = 'composite -version';
$imgVal1 = system($cmd1,$out1);
$variable1 = ob_get_clean();

$imgversions = explode('-',$variable[2]);
$imgversioned = explode('.', $imgversions[0]);

ob_start();
$cmd3 = 'autotrace -v';
$imgVal3 = system($cmd1,$out1);
$variable3 = ob_get_clean();

if(!empty($val1) || $val1==1){
	$server_flag = false;
}
//elseif((empty($val2) || $val2 !=1)){
//	$server_flag = false;
//}
elseif(empty($val3) || $val3 !=1){
	$server_flag = false;
}elseif(empty($val_mb) || $val_mb !=1)
{
    $server_flag = false;
}
elseif(empty($val_fread) || $val_fread !=1)
{
    $server_flag = false;
}
elseif(!$gd){
	$server_flag = false;
}
elseif(!$curl){
	$server_flag = false;
}
elseif(!$mysql){
	$server_flag = false;
}
elseif($system){
	$server_flag = false;
}
elseif(!$imagick){
	$server_flag = true;
}

if($imgversioned[0]<6){
    $server_flag = false;
}elseif($imgversioned[0]==6){
    if($imgversioned[1]<7)
    {
        $server_flag = false;
    }elseif ($imgversioned[1]==7) {
        if($imgversioned[2]<3)
        {
             $server_flag = false;
        }
    }
}

if(empty($variable1))
{
    $server_flag = false;
}


$mysqlsupport=true;
if (!function_exists('mysql_connect')) {

	$mysqlsupport = false;
}

if(!$server_flag){
	$serverconfiguration =   "FAILURE";
}else{
	$serverconfiguration =   "OK";
}

/*--------------------Check server PHP configuration---------------------------*/
$host_name = parse_url($_SERVER['HTTP_HOST']);

$directories = array("/webroot/img/products/", 
                    "/webroot/img/csv/", 
                    "/webroot/Fax/", 
                    "/webroot/files/", 
                    "/webroot/files/File/", 
                    "/webroot/files/Flash/", 
                    "/webroot/files/Image/", 
                    "/webroot/files/Media/",
                    "/webroot/files/Graph/", 
                    "/webroot/img/SiteLogo_disp.gif", 
                    "/webroot/img/SiteLogo.jpg", 
                    "/tmp/cache/", 
                    "/tmp/cache/models/", 
                    "/tmp/cache/views/",
                    "/tmp/cache/persistent/", 
                    "/tmp/", 
                    "/tmp/logs/", 
                    "/tmp/sessions/", 
                    "/webroot/img/", 
                    "/webroot/css/", 
                    "/webroot/Fedex/shipping_label/",
                    "/webroot/Fedex/", 
                    "/webroot/img/customized_tshirts/", 
                    "/webroot/img/customized_tshirts_foreground/", 
                    "/webroot/img/editorimages/", 
                    "/webroot/img/editorimages/default/",
                    "/webroot/img/editorimages/temp/", 
                    "/webroot/img/editorimages/customized/", 
                    "/webroot/img/editorimages/cropimages/", 
                    "/webroot/img/editorfonts/", 
                    "/webroot/img/TIFF/", 
                    "/webroot/img/tshirts/", 
                    "/webroot/img/categoryimages/", 
                    "/webroot/img/fontpreview/",
                    "/config/database.php", 
                    "/webroot/config.php",
                    "/webroot/img/editorimages/Animals/",     
                    "/webroot/img/editorimages/Cartoon/",
                    "/webroot/img/editorimages/Events/",
                    "/webroot/img/editorimages/Food/",
                    "/webroot/img/editorimages/Holidays/",
                    "/webroot/img/editorimages/Military/",
                    "/webroot/img/editorimages/Music/",
                    "/webroot/img/editorimages/Nature/",
                    "/webroot/img/editorimages/Occupations/",
                    "/webroot/img/editorimages/People/",
                    "/webroot/img/editorimages/Religion/",
                    "/webroot/img/editorimages/School/",
                    "/webroot/img/editorimages/Sports/",
                    "/webroot/img/editorimages/Symbols/",
                    "/webroot/img/editorimages/Transportation/",
                    "/webroot/img/editorimages/admin/"    
                    );

$perm_msg  = '';
$perm_flag = true;
$error_dir_pem = false;	
foreach ($directories as $dir)
{
        $permission = file_writable( '../../'.$dir,$dir);
		if (!$permission['status'] && $error_dir_pem == false) {
				$error_dir_pem = true; 
				$serverPermission="true";
	    
        }
        
    }




if($error_dir_pem){
	if(isset($_POST["btnContinue"]) && !isset($_POST["auto_set"])){
		$txtFTPusername = $_POST['FTPusername'];
		$txtFTPpassword = $_POST['FTPpassword'];

		if(trim($txtFTPusername) == ''){
			$perm_msg .= '* Please enter FTP username <br/>';
		}
		if(trim($txtFTPpassword) == ''){
			$perm_msg .= '* Please enter FTP password <br/>';
		}
		else{
			$conn_id = @ftp_connect($host_name["path"]);
			$login_result = @ftp_login($conn_id, $txtFTPusername, $txtFTPpassword);
			if($login_result){
				$mode = 777;
				$np = '0'.$mode;

				$user_install = str_replace('/webroot/install', '', getcwd());

				//get the path staring from public_html
				$path_parts = explode('/public_html', $user_install);
				$user_install = '/public_html'.$path_parts[1];

				foreach($directories as $directory){
					$edited_path = str_replace('..', '', $directory);
					$directory = $user_install.$edited_path;
					if($directory[strlen($directory) - 1] == '/'){
						$directory  = substr($directory, 0, strlen($directory) - 1);
					}
					$directory=ltrim($directory,"/");
					if(!@ftp_chmod($conn_id, eval("return({$np});"), $directory)){
						$perm_flag = false;
					}
				}

				if(!$perm_flag){
					$perm_msg .= '* Sorry, an error occurred. Please try again or set the permissions manually <br/>';
				}
				else{
					$perm_msg  = '<b>* File permissions successfuly set </b><br/>';
				}
			}
			else{
				$perm_msg .= '* Sorry, could not connect to the server. Please check the credentials <br/>';
			}
		}
	}
}

/*-----------------------------------------------------------------------------*/

foreach ($directories as $dir)
{
        $permission = file_writable( '../../'.$dir,"app".$dir);
		
		if (!$permission['status'] && $error_dir_pem == false) {
				$error_dir_pem = true; 
				$serverPermission="true";
	    
        }
		 if (!$permission['status'] ) {
                $error_message=$error_message.$permission['message'];
        }
        
    }


}

/*----------------------------------------------------------------------------------------------------------------*/
$post_flag = false;

if ($_POST["btnContinue"] == "Continue" || $_POST['cldpack']==1) {
	if($_POST['cldpack']==1) {
    $installPath     =  $_POST['returnurl'];
    $txtDBServerName                = 'localhost';
    $txtDBName                      = $_POST["db_name"];
    $txtDBUserName                  = $_POST["db_user"];
    $txtDBPassword                  = $_POST["db_password"];
    $txtSiteName                    = $_POST["store_name"];
    $txtAdminName                   = "admin";//$_POST["txtAdminName"];
    $txtAdminPassword               = "q1w2e3";//$_POST["txtAdminPassword"];
    $txtConfirmAdminPassword        = "q1w2e3";//$_POST["txtConfirmAdminPassword"];
    $txtAdminEmail                  = $_POST['contactemail'];//"rajath.k@armiasystems.com";//$_POST["txtAdminEmail"];
    $txtTablePrefix                 = "PrintLogic_";//$_POST["txtTablePrefix"];
}
else {
	$txtDBServerName         = $_POST["txtDBServerName"];
	$txtDBName               = $_POST["txtDBName"];
	$txtDBUserName           = $_POST["txtDBUserName"];
	$txtDBPassword           = $_POST["txtDBPassword"];
	$txtSiteName             = $_POST["txtSiteName"];
	$txtAdminName            = $_POST["txtAdminName"];
	$txtAdminPassword        = $_POST["txtAdminPassword"];
	$txtConfirmAdminPassword = $_POST["txtConfirmAdminPassword"];
	$txtLicenseKey           = $_POST["txtLicenseKey"];
	$txtAdminEmail           = $_POST["txtAdminEmail"];
	$txtTablePrefix          = $_POST["txtTablePrefix"];
}

	$post_flag = true;
	$message = "";

	if (!isNotNull($txtDBServerName)) {
		$message .= " * Database Server Name is empty!" . "<br>";
		$error = true;
	}
	if (!isNotNull($txtDBName)) {
		$message .= " * Database Name is empty!" . "<br>";
		$error = true;
	}
	if (!isNotNull($txtDBUserName)) {
		$message .= " * Database User Name is empty!" . "<br>";
		$error = true;
	}
	if (!isNotNull($txtSiteName)) {
		$message .= " * Site Name is empty!" . "<br>";
		$error = true;
	}
	if (!isNotNull($txtAdminEmail)) {
		$message .= " * Admin Email is empty!" . "<br>";
		$error = true;
	} else {
		if (!isValidEmail($txtAdminEmail)) {
			$message .= " * Invalid Admin Email!" . "<br>";
			$error = true;
		}
	}

	$connection = @mysql_connect($txtDBServerName, $txtDBUserName, $txtDBPassword);
	if ($connection === false) {
		$error = true;
		$message .= " * Connection Not Successful! Please verify your database details!<br>";
	} else {
		$dbselected = @mysql_select_db($txtDBName, $connection);
		if (!$dbselected) {
			$error = true;
			$message .= " * Database could not be selected! Please verify your database details!<br>";
		}
	}

	//exit;

	if ($error) {
		$message = "<u><b>Please correct the following errors to continue:</b></u>" . "<br><br>" . $message;
		// echo $message;
	} else {

		// writing to the config file....................
		$uniqueid = time() . mt_rand() . session_id();
		if (strlen($uniqueid) > 15) {
			$uniqueid = substr($uniqueid, 0, 15);
			$uniqueid = md5($uniqueid);
		}
		$fp = fopen($configfile, "w+");
		$configcontent = "<?php\n";
		$configcontent .= "define('INSTALLED', true); \n\n";
		$configcontent .= "define('VERSION', '1.7'); \n\n";
		if($_POST['cldpack']==1)
		{
		$configcontent .= "Configure::write('ISCRIPTSCLOUD', true); \n\n";
		}		
		$configcontent .= "ini_set('display_errors', '0'); \n";
		$configcontent .= "error_reporting(0); \n\n";
		$configcontent .= "\n?>";
		fwrite($fp, $configcontent);

		$default		=	'$default';
		$fpp = fopen($dbconfigfile, "w+");
		$dbconfigcontent = "<?php\n";
		$dbconfigcontent .= "class DATABASE_CONFIG { \n\n";
		$dbconfigcontent .= "var $default = array( \n\n";
		$dbconfigcontent .= "'driver' => 'mysql', \n\n";
		$dbconfigcontent .= "'persistent' => false,\n\n";
		$dbconfigcontent .= "'host' => '". $txtDBServerName ."',\n\n";
		$dbconfigcontent .= "'login' => '". $txtDBUserName ."',\n\n";
		$dbconfigcontent .= "'password' => '". $txtDBPassword ."',\n\n";
		$dbconfigcontent .= "'database' => '". $txtDBName ."',\n\n";
		$dbconfigcontent .= "'prefix' => '". $txtTablePrefix ."', \n\n";
		$dbconfigcontent .= "); \n\n";
		$dbconfigcontent .= "}\n\n";
		$dbconfigcontent .= "\n?>";

		fwrite($fpp, $dbconfigcontent);

		$sqlquery = @fread(@fopen($schemafile, 'r'), @filesize($schemafile));
		$sqlquery = preg_replace('/PrintLogic_/', $txtTablePrefix, $sqlquery);
		$sqlquery = splitsqlfile($sqlquery, ";");
		// creating the tables......................................
		for($i = 0; $i < sizeof($sqlquery); $i++) {
			mysql_query($sqlquery[$i], $connection);
		}

		$dataquery = @fread(@fopen($datafile, 'r'), @filesize($datafile));
		$dataquery = preg_replace('/PrintLogic_/', $txtTablePrefix, $dataquery);
		$dataquery = splitsqlfile($dataquery, ";");
		// populating the tables with initial data......................................
		for($i = 0; $i < sizeof($dataquery); $i++) {
			mysql_query($dataquery[$i], $connection);
		}


		$adminusername = addslashes($txtAdminName);
		$adminpassword = md5($txtAdminPassword);
		$adminmailpword = $txtAdminPassword;
		$sqladminsettings	=	"UPDATE ".$txtTablePrefix."admins SET admin_name = '".$adminusername."',admin_pword ='".$adminpassword."' WHERE admin_name ='admin'";
		mysql_query($sqladminsettings) or die(mysql_error());
		$sqlsettings		=	"UPDATE ".$txtTablePrefix."settings SET value = '".addslashes($txtSiteName)."' WHERE fieldname ='site_name'";
		mysql_query($sqlsettings) or die(mysql_error());
		if($_POST['cldpack'] != 1) {
		$sqlsettings		=	"UPDATE ".$txtTablePrefix."settings SET value = '".addslashes($txtSiteBaseFolder)."' WHERE fieldname ='sitebasefolder'";
		mysql_query($sqlsettings) or die(mysql_error());
		}
		$sqlsettings1		=	"UPDATE ".$txtTablePrefix."settings SET value = '".addslashes($txtAdminEmail)."' WHERE fieldname ='admin_email'";
		mysql_query($sqlsettings1) or die(mysql_error());
		$sqlsettings1		=	"UPDATE ".$txtTablePrefix."settings SET value = '".addslashes($txtLicenseKey)."' WHERE fieldname ='vLicenceKey'";
		mysql_query($sqlsettings1) or die(mysql_error());
                
                if (!empty($variable3)) {
            $autoSql = mysql_query("UPDATE {$sqlPrefix}settings SET value = 'YES' WHERE fieldname = 'autotracing'");
        }
        
		$installed = true;

		// section to send details to admin...............................
		$pos	=	strpos($_SERVER['SCRIPT_NAME'],'/webroot');
		$ck		=	substr($_SERVER['SCRIPT_NAME'],0,$pos);

		$s = null;
		if ($_SERVER['HTTPS']) {
			$s ='s';
		}
		$httpHost = $_SERVER['HTTP_HOST'];
		if (isset($httpHost)) {
			$ser	= 'http'.$s.'://'.$httpHost;
		}
		unset($httpHost, $s);
		$ft = '';
		$ft =@file_get_contents($ser."/".$ck."/config/rewtest/link2.html");
		if(php_sapi_name() == 'apache2handler'){
			$apach	=	true;
		}else{
			$apach	=	false;
		}
		if($apach != true || $ft == ''){
			$admurl = $txtSiteURL."/admins/";
			$sturl	= $txtSiteURL;
		}else{
			$admurl = $txtSiteURL."/admins/";
			$sturl	= $txtSiteURL;
		}
		/* -------------- /
		 New code for install tracker, added by girish
		/------------------*/
		$string		= "";
		$pro		= urlencode("PrintLogic 1.6");
		$dom		= urlencode($txtSiteURL);
		$ipv		= urlencode($_SERVER['REMOTE_ADDR']);
		$mai		= urlencode($txtAdminEmail);
		$string		= "pro=$pro&dom=$dom&ipv=$ipv&mai=$mai";
		$contents	= "no";
		$file		= @fopen("http://www.iscripts.com/installtracker.php?$string", 'r');
		if ($file) {
			$contents = @fread($file, 8192);
		}
		/* -------------- /
		 New code for install tracker, added by girish
		/------------------*/
		$subject 		= "Script Installed at ".$txtSiteName;
		$headers 		= "From: ".$txtSiteName."<".$txtAdminEmail.">\r\n";
		$headers 		.= "MIME-Version: 1.0\r\n";
		$headers 		.= "Content-type: text/html; charset=iso-8859-1\r\n";
		$path			=	"SiteLogo_disp.gif";
		$mcont			=	"<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>
		<tr><td><a href='".$sturl."' target='_blank'><img src='".$sturl."/img/".$path."' border='0'></a></td></tr></table>";
		$mailcontent	=	$mcont."Hello , <br>";
		$mailcontent	.=  "Your Store is successfully installed.<br> <a href='".$sturl."' target='_blank'>Click Here to Access your Store</a>";
		$mailcontent	.=  "<br><a href='".$admurl."' target='_blank'>Click Here to Access your Store Administration Control Panel</a> <br>";
		$mailcontent	.=  "Your Admin Username   :  ".$adminusername;
		$mailcontent	.=  "<br>Your Admin Password   :  ".$adminmailpword;
		$mailcontent	.=  "<br> Thanks and regards,<br> ".$txtSiteName." Team";
		   if($_POST['cldpack']!=1) {
                    $mailsent 		= mail(addslashes($txtAdminEmail),$subject,$mailcontent,$headers);
                }	// section to send details to admin...............................
	}
}

function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "")
{
	$theValue = (!get_magic_quotes_gpc()) ? addslashes($theValue) : $theValue;

	switch ($theType) {
		case "text":
	  $theValue = ($theValue != "") ? "'" . $theValue . "'" : "''";
	  break;
		case "long":
		case "int":
	  $theValue = ($theValue != "") ? intval($theValue) : "''";
	  break;
		case "double":
	  $theValue = ($theValue != "") ? "'" . doubleval($theValue) . "'" : "''";
	  break;
		case "date":
	  $theValue = ($theValue != "") ? "'" . $theValue . "'" : "''";
	  break;
		case "defined":
	  $theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue;
	  break;
	}
	return $theValue;
}
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
"http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<title>PrintLogic Installer</title>
<link href="css/install.css" rel="stylesheet" type="text/css">
</head>
<script type="text/javascript" src="../js/jquery.js"></script>
<script type="text/javascript">
    function divToggle(elem)
    {
        if($(elem).is(":checked")){
            $('#err_div').slideDown('slow');
        }
        else{
            $('#err_div').slideUp('slow');
        }
    }
</script>
<style type="text/css">
.install_option {
	font-family: Verdana, Arial, Helvetica, sans-serif;
	font-size: 9pt;
	color: #333333
}

.install_value_ok {
	font-family: Verdana, Arial, Helvetica, sans-serif;
	font-size: 9pt;
	font-weight: bold;
	color: #009900
}

.install_value_fail {
	font-family: Verdana, Arial, Helvetica, sans-serif;
	font-size: 7pt;
	font-weight: bold;
	color: #CC0000
}

.block_class {
	color: #F4700E;
	font-family: Verdana, Arial, Helvetica, sans-serif;
	font-weight: bold;
}
</style>
<body topmargin="0" class="bodyinstaller">
	<div class="header_row">
		<div class="header_container wrapper">
			<table width="100%" border="0" cellspacing="0" cellpadding="0">
				<tr>
					<td width="23%" align="center"><h2>
							<span class=""><img src="css/logo.png" alt="Logo"> </span>
						</h2></td>
					<td width="77%" align="right"><h4>iScripts PrintLogic Installer</h4>
						<?php
						$pos	=	strpos($_SERVER['SCRIPT_NAME'],'/webroot');
						$ck		=	substr($_SERVER['SCRIPT_NAME'],0,$pos);

						$s = null;
						if ($_SERVER['HTTPS']) {
							$s ='s';
						}
						$httpHost = $_SERVER['HTTP_HOST'];
						if (isset($httpHost)) {
							$ser	= 'http'.$s.'://'.$httpHost;
						}
						unset($httpHost, $s);
						$ft = '';
						$ft =@file_get_contents($ser."/".$ck."/config/rewtest/link2.html");
						//print_r($txtSiteURLt);exit;

		if(php_sapi_name() != 'apache2handler' || $ft == ''){ ?>
						<div align="center" id="items_top_area">
							&nbsp;&nbsp; <a title="OnlineInstallationManual" href="#"
								onClick="window.open('<?php echo htmlentities($txtSiteURLt);?>/Installation_Manual.pdf','OnlineInstallationManual','top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd');"><strong>Installation
									manual</strong> </a> | <a title="Readme" href="#"
								onClick="window.open('<?php echo htmlentities($txtSiteURLt);?>/Readme.txt','Readme','top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd');"><strong>Readme</strong>
							</a> | <a
								title="If you have any difficulty, submit a ticket to the support department"
								href="#"
								onClick="window.open('http://www.iscripts.com/support/postticketbeforeregister.php','','top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd,resizable=yes');">
								<strong>Get Support</strong>
							</a>
						</div> <?php }else{ ?>
						<div align="center" id="items_top_area">
							&nbsp;&nbsp; <a title="OnlineInstallationManual" href="#"
								onClick="window.open('<?php echo htmlentities($txtSiteURL);?>/Installation_Manual.pdf','OnlineInstallationManual','top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd');"><strong>Installation
									manual</strong> </a> | <a title="Readme" href="#"
								onClick="window.open('<?php echo htmlentities($txtSiteURL);?>/Readme.txt','Readme','top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd');"><strong>Readme</strong>
							</a> | <a
								title="If you have any difficulty, submit a ticket to the support department"
								href="#"
								onClick="window.open('http://www.iscripts.com/support/postticketbeforeregister.php','','top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd,resizable=yes');">
								<strong>Get Support</strong>
							</a>
						</div> <?php } ?>
					</td>
				</tr>
			</table>
		</div>
	</div>

	<table width="100%" border="0" cellspacing="0" cellpadding="0">
		<tr>
			<td><img src="../img/spacer.gif" width="1" height="5"></td>
		</tr>
	</table>
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
		<tr>

			<td width="76%" valign="top" height="400">
				<!-- Here's where I want my views to be displayed -->
				<table width="80%" border="0" cellpadding="0" cellspacing="0"
					align="center">
					<tr>
						<td>
							<!--------Installer starts-------------------------> <!--items display area start -->

							<?php 
							if ($serverconfiguration=="FAILURE")
							{
								?>
							<table width="80%" border=0 align="center">
								<?php
								$ivo = "<span class='install_value_ok'>";
								$ivf = "<span class='install_value_fail'>";
								$sc = "</span>";
								echo "<tr><td class=maintext><b></b><br><br></td></tr>";
								echo "<tr><td class=maintext>Checking PHP Version... " . $ivo.PHP_VERSION.$sc . " ";
								if(version_compare(PHP_VERSION,"4.2.0") >=0 ) echo $ivo."".$sc; else {echo $ivf."(4.2.0 or higher required)".$sc; $fatal = true;
								}
								echo "</td></tr>";
								echo "<tr><td class=maintext>Checking System Information... " .$ivo. PHP_OS .$sc. "</td></tr>";
								echo "<tr><td class=maintext>Checking PHP Server API... " . $ivo. php_sapi_name().$sc . "</td></tr>";
								echo "<tr><td class=maintext>Checking Path to 'php.ini'... " . $ivo.PHP_CONFIG_FILE_PATH.$sc . "</td></tr>";
								$mysqlsupport=true;
								if (!function_exists('mysql_connect')) {
									$mysqlsupport = false;
								}
								echo "<tr><td class=maintext>Checking Mysql support... ";
								echo $ivo . (( $mysqlsupport) ? "On" : " $ivf This program requires MYSQL support. Please recompile your PHP with MYSQL Support.") . $sc;
								echo "</td></tr>";
								echo "<tr><td class=maintext>Checking safe_mode... ";
								$val1 = ini_get("safe_mode");
								echo  ((!empty($val1) || $val1==1) ? $ivf ."On-Please turn off safe_mode in the php.ini" : $ivo ."Off") . $sc;
								echo "</td></tr>";
//								echo "<tr><td class=maintext>Checking short_tags... ";
//								$val2 = ini_get("short_open_tag");
//								echo  ((!empty($val2) || $val2==1) ?$ivo."On" : $ivf."Off-Please turn on short_tags in the php.ini") . $sc;
//								echo "</td></tr>";
								echo "<tr><td class=maintext>Checking file_uploads...";
								$val3 = ini_get("file_uploads");
								echo ((!empty($val3) || $val3==1) ? $ivo . "On" : $ivf . "Off - Please turn on file_uplaods in the php.ini file").$sc;
													
								if( !empty($val3) || ($val3==1) ){
									echo "<tr><td class=maintext>";
									if($_POST["submittest"] == "Upload"){
										$uploadpath=substr($_FILES['testupload']['tmp_name'],0,strlen($_FILES['testupload']['tmp_name'])-strlen(basename($_FILES['testupload']['tmp_name']))-1);
										$uploadpatharray=explode("/",$uploadpath);
											
										$existflag=0;
										$checkitem="";
										for($i=1;$i<count($uploadpatharray);$i++){
											$checkitem=$checkitem."/".$uploadpatharray[$i];
											$existflag=1;
											break;

										}
											
									}

									echo "</td></tr>";
								}
								echo "<tr><td class=maintext>Checking CURL support... ";
								$val5 = function_exists('curl_init');
								if($val5){
									echo $ivo."On";
								}
								else{
									echo $ivf."Off-Please re-compile php with CURL support" . $sc;
								}
								echo "</td></tr>";
                                                                
                                                                
                                                                echo "<tr><td class=maintext>Checking  mbstring support... ";
								$val_mb = function_exists('mb_strlen');
								if($val_mb){
									echo $ivo."On";
								}
								else{
									echo $ivf."Off-Please re-compile php with mbstring support" . $sc;
								}
								echo "</td></tr>";
                                                                
                                                                echo "<tr><td class=maintext>Checking  File Read/Write - fread() support... ";
								$val_fread = function_exists('fread');
								if($val_fread){
									echo $ivo."On";
								}
								else{
									echo $ivf."Off-Please re-compile php with File Read/Write - fread() support" . $sc;
								}
								echo "</td></tr>";
                                                                
                                                                
                                                                
                                                                
                                                                
								echo "<tr><td class=maintext>Checking GD support... ";
								$val6 = function_exists('gd_info');
								if($val6){
									echo $ivo."On";
								}
								else{
									echo $ivf."Off-Please re-compile php with GD support" . $sc;
								}
								echo "</td></tr>";
								echo "<tr><td class=maintext>Checking SYSTEM function... ";
								$val7 = strpos(ini_get("disable_functions"), "system");
								if(!$val7){
									echo $ivo."On";
                                                                        if(empty($variable1))
                                                                        {
                                                                            echo $ivf." but composite command is not enabled" . $sc;
                                                                        }
								}
								else{
									echo $ivf."Off-Please enable SYSTEM funtion the php.ini" . $sc;
								}
								echo "</td></tr>";
								echo "<tr><td class=maintext>Checking IMAGICK support... ";
								$val8 = class_exists("Imagick");
								if($val8){
									echo $ivo."On ";
                                                                        
                                                                           if($imgversioned[0]<6){
  
      echo $ivf."Requires IMAGEMAGICK version 6.7.3 or above, current version is ".$variable[2] .' '. $sc;
        
}elseif($imgversioned[0]==6){
    if($imgversioned[1]<7)
    {
       
        echo $ivf."Requires IMAGEMAGICK version 6.7.3 or above, current version is ".$variable[2] .' '. $sc;
        
    }elseif ($imgversioned[1]==7) {
        if($imgversioned[2]<3)
        {
            
               echo $ivf."Requires IMAGEMAGICK version 6.7.3 or above, current version is ".$variable[2] .' '. $sc;
        }
    }
}else{
  
}
                                                                        
								}
								else{
									echo $ivf."Off-Please re-compile php with IMAGICK support" . $sc;
								}
								echo "</td></tr>";

								echo "<tr><td class=maintext>".$ivf."Fatal errors detected.  Please correct the above red items and reload.</td></tr>";
								?>
							</table> <?php
							} else if (!$installed ) {

								?>
							<table width="80%" border="0" align="center">
								<tr>
									<td align="center"><b><font size="1">
												<div align="justify">
													<br> <font color="#F4700E" size="+1">Thank you for choosing
														PrintLogic&nbsp;</font> <br> <br> <font color="#000000"
														size="2"><img src="../img/dot.jpg">&nbsp;To complete this
														installation please enter the details below.</font>
												</div>

										</font> </b>
									</td>
								</tr>
								<?php if($post_flag){ ?>
								<tr>
									<td align=center class="message">
										<div align="left" class="text_information">
											<br> <font color="#FF0000"><?php echo $message;?> </font><br>
											<font color="#FF0000"><?php echo $error_message; ?> </font><br>
										</div>
									</td>
								</tr>
								<?php } ?>
								<tr>
									<td class=maintext align="left">Note: All Fields Are Mandatory.
										<br>
										<form name="frmInstall" method="post"
											action="<?php echo $_SERVER["PHP_SELF"];?>"
											enctype="multipart/form-data">
											<br>

											<FIELDSET>
												<LEGEND class='block_class'>File Permissions</LEGEND>
												<table width=85% border="0" cellpadding="2" cellspacing="2"
													class=maintext>
													<tr>
														<td colspan="2" align="left"><b> <?php if($error_dir_pem){ ?>
																Printlogic requires that some of the folders have write
																permission. You can provide an FTP login so that this
																process is done automatically.<br /> <br /> For security
																reasons, it is best to create a separate FTP user
																account with access to the Printlogic installation only
																and not the entire web server. Your host can assist you
																with this. If you have difficulties completing
																installation without these credentials, please click "I
																would provide permissions manually" to do it yourself.<br />
																<br /> <?php } ?>
														</b>
														</td>
													</tr>
													<?php if($error_dir_pem){ ?>
													<tr>
														<td class=maintext align="left">FTP username</td>
														<td width="61%" align=left><input name="FTPusername"
															id="FTPusername" type="text" size="50"
															value="<?php echo htmlentities($txtFTPusername);?>">
														</td>
													</tr>
													<tr>
														<td class=maintext align="left">FTP password</td>
														<td width="61%" align=left><input name="FTPpassword"
															id="FTPpassword" type="password" size="50"
															value="<?php echo htmlentities($txtFTPpassword);?>">
														</td>
													</tr>
													<?php if($error_dir_pem){ ?>
													<tr>
														<td colspan="2" align="left"><input type="checkbox"
															name="auto_set" id="auto_set" onclick="divToggle(this)" />
															&nbsp; I would provide permissions manually</td>
													</tr>
													<?php
								}
								}else{
									?>
													<tr>
														<td colspan="2" align="left"><b>File permissions are OK.</b>
														</td>
													</tr>
													<?php } ?>
												</table>
												<?php if($error_dir_pem){ ?>
												<div id="err_div" style="display:none">
													<fieldset>
														<legend>Directories/Files List</legend>
														<?php echo $error_message; ?>
													</fieldset>
												</div>
												<?php } ?>
											</FIELDSET>
											<br> <br>

											<FIELDSET>
												<LEGEND class='block_class'>Database Details</LEGEND>
												<table width=85% border=0 cellpadding="2" cellspacing="2"
													class=maintext>
													<tr>
														<td colspan="2" class=maintext align="left">Database
															Server</td>
														<td width="61%" align=left><input type="text"
															name="txtDBServerName" id="txtDBServerName"
															value="<?php echo htmlentities($txtDBServerName);?>">
														</td>
													</tr>
													<tr>
														<td colspan="2" class=maintext align="left">Database Name</td>
														<td width="61%" align=left><input name="txtDBName"
															id="txtDBName" type="text" class="textbox"
															maxlength="100" size="50"
															value="<?php echo htmlentities($txtDBName);?>">
														</td>
													</tr>
													<tr>
														<td colspan="2" class=maintext align="left">Database User
															Name</td>
														<td width="61%" align=left><input name="txtDBUserName"
															id="txtDBUserName" type="text" maxlength="100" size="50"
															value="<?php echo htmlentities($txtDBUserName);?>">
														</td>
													</tr>
													<tr>
														<td colspan="2" class=maintext align="left">Database
															Password</td>
														<td width="61%" align=left><input name="txtDBPassword"
															id="txtDBPassword" type="text" maxlength="100" size="50"
															value="<?php echo htmlentities($txtDBPassword);?>">
														</td>
													</tr>
													<tr>
														<td colspan="2" class=maintext align="left">Table Prefix</td>
														<td width="61%" align=left><input name="txtTablePrefix"
															id="txtTablePrefix" type="text" maxlength="100" size="50"
															value="<?php echo htmlentities($txtTablePrefix);?>">
														</td>
													</tr>

												</table>
											</FIELDSET>
											<br> <br>
											<FIELDSET>
												<LEGEND class='block_class'>Site Details</LEGEND>
												<table width=85% border=0 cellpadding="2" cellspacing="2"
													class=maintext>
													<tr>
														<td colspan="2" class=maintext align="left">Site Name</td>
														<td width="61%" align=left><input name="txtSiteName"
															id="txtSiteName" type="text" maxlength="100" size="50"
															value="<?php echo htmlentities($txtSiteName);?>"> <input
															name="txtSiteURL" id="txtSiteURL" type="hidden"
															maxlength="100"
															value="<?php echo htmlentities($txtSiteURL);?>" readonly>
														</td>
													</tr>
													<tr>
														<td colspan="2" class=maintext align="left">License Key</td>
														<td width="61%" align=left><input name="txtLicenseKey"
															id="txtLicenseKey" type="text" maxlength="100" size="50"
															value="<?php echo htmlentities($txtLicenseKey);?>">
														</td>
													</tr>
												</table>
											</FIELDSET>
											<br> <br>
											<FIELDSET>
												<LEGEND class="block_class">Administration Details</LEGEND>
												<table width=85% border=0 cellpadding="2" cellspacing="2"
													class=maintext>
													<tr>
														<td colspan="2" class=maintext align="left">Admin Email</td>
														<td width="61%" align=left><input name="txtAdminName"
															id="txtAdminName" type="hidden" maxlength="100" size="50"
															value="admin"> <input name="txtAdminPassword"
															id="txtAdminPassword" type="hidden" maxlength="100"
															size="50" value="admin"> <input
															name="txtConfirmAdminPassword"
															id="txtConfirmAdminPassword" type="hidden"
															maxlength="100" size="50" value="admin"> <input
															name="txtAdminEmail" id="txtAdminEmail" type="text"
															maxlength="100" size="50"
															value="<?php echo htmlentities($txtAdminEmail);?>">
														</td>
													</tr>
												</table>
											</FIELDSET>
											<br>
											<table width=85% border=0 cellpadding="2" cellspacing="2"
												class=maintext>
												<tr>
													<td>&nbsp;</td>
												</tr>
												<tr>
													<td align="center"><input type="submit" name="btnContinue"
														value="Continue" class="buttn_admin">
													</td>
												</tr>
											</table>
										</form>
									</td>
								</tr>
							</table> <?php
							}
							else
							{
								?>
							<table width="80%" border="0" align="center">
								<tr>
									<td>
										<table width=85% border=0 cellpadding="2" cellspacing="2"
											class=maintext align="center">
											<br>
											<tr>
												<td align="center" class="maintext"><font color="#F4700E"
													size="+1">Congratulations! The Installation Process was
														completed successfully!</font>
												</td>
											</tr>
											<tr>
												<td align="center" class="maintext" height="20">&nbsp;</td>
											</tr>
											<br>
											<br>
											<br>
											<tr>
												<td align="left"><span class="required">*</span><b> All
														Payment Gateways are disabled by default,Please enable at
														least one payment gateway !!</b>
												</td>
											</tr>


											<br>
											<?php 
											$request_uri = explode('/',$_SERVER['REQUEST_URI']);

											$script_filename = explode('/',$_SERVER['SCRIPT_FILENAME']);
											$build_path = "http://".$_SERVER['HTTP_HOST']."/".$request_uri[1]."/admin/login.php";
											$build_path_home = "http://".$_SERVER['HTTP_HOST']."/".$request_uri[1]."/index.php";
											?>
											<tr>
												<td align="center"><br>
													<fieldset>
														<legend class="block_class">Site Login Details</legend>
														<table cellpadding="0" cellspacing="0" width="80%"
															class="maintext" align="center">
															<tr>
																<td colspan="2">&nbsp;</td>
															</tr>
															<?php
															$pos	=	strpos($_SERVER['SCRIPT_NAME'],'/webroot');
															$ck		=	substr($_SERVER['SCRIPT_NAME'],0,$pos);

															$s = null;
															if ($_SERVER['HTTPS']) {
																$s ='s';
															}
															$httpHost = $_SERVER['HTTP_HOST'];
															if (isset($httpHost)) {
																$ser	= 'http'.$s.'://'.$httpHost;
															}
															unset($httpHost, $s);
															$ft = '';
															$ft =@file_get_contents($ser."/".$ck."/config/rewtest/link2.html");
															if(php_sapi_name() == 'apache2handler'){
																$apach	=	true;
															}else{
																$apach	=	false;
															}
															?>
															<tr>
																<td width="24%"><b><font size="-1">Admin URL&nbsp;:</font>
																</b></td>
																<td width="76%"><a style="cursor: pointer"
																	href="<?php echo $txtSiteURL."/admins/"?>"><?php echo $txtSiteURL."/admins/";?><img
																		src="../img/admin_login_install.jpg" border="0"
																		height="25"> </a></td>
															</tr>
															<tr>
																<td colspan="2">&nbsp;</td>
															</tr>
															<tr>
																<td width="24%" valign="top"><b><font size="-1">Admin
																			Credentials&nbsp;:</font> </b></td>
																<td width="76%" valign="top"><font size="-1">Username&nbsp;:&nbsp;admin</font><br />
																	<font size="-1">Password&nbsp;:&nbsp;admin</font>
																</td>
															</tr>
															<tr>
																<td colspan="2">&nbsp;</td>
															</tr>
															<tr>
																<td width="24%"><b><font size="-1">Home URL&nbsp;:</font>
																</b></td>
																<td width="76%"><a style="cursor: pointer"
																	href="<?php echo $txtSiteURL;?>/"><?php echo $txtSiteURL;?>/<img
																		src="../img/home_page.jpg" border="0" height="25"> </a>
																</td>
															</tr>
														</table>
													</fieldset>
												</td>
											</tr>
											<tr>
												<td align="center" class="maintext" height="20">&nbsp;</td>
											</tr>
										</table>
									</td>
								</tr>
							</table> <?php 

							}

							?>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
		<tr>
			<td valign="top"><table width="100%" border="0" cellspacing="0"
					cellpadding="10">
					<tr>
						<td><table width="100%" border="0" cellspacing="0" cellpadding="0">
								<tr>
									<td valign="top"><table width="100%" border="0" cellspacing="0"
											cellpadding="3">
											<tr>
												<td height="43" class="bigfont1" align="center"><div
														align="center" class="copyright">
														<!-- footr links comes here -->
													</div></td>
											</tr>
										</table>
									</td>
								</tr>
							</table></td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
	<div class="installr_footer"></div>
</body>
</html>
