/* generalized maps logics */

var Maps = {
    objMap: null,
    mapRadius:10,
    zoom:9,
    mapCenter:[40.73586, -73.99108],
    markerCoordinates:[],
    markerData:[],
    infoBox:null,
    objectsOnmap: [],
    loadMap:function(container_id){ 
        var mapOptions = {
            center: new google.maps.LatLng(Maps.mapCenter[0], Maps.mapCenter[1]), //default center
            zoom: Maps.zoom,
            mapTypeId: google.maps.MapTypeId.ROADMAP,
            streetViewControl: false,
            mapTypeControl: false
        };

        Maps.objMap = new google.maps.Map(document.getElementById(container_id), mapOptions);
        Maps.drawRadius();
        var infoBoxOptions = {
            pixelOffset: new google.maps.Size(-87, -106),
            boxStyle: {
                //background: "url('"+MAIN_URL+"/project/images/map/map-info-box.png') no-repeat",
                background: "#fff",
                border: "1px solid #0099FF",
                width: "220px",
                padding: "3px"
            }
        };
        Maps.infoBox = new InfoBox(infoBoxOptions);
    },

    addMarkerTag:function(lat,lng,title,infoData,markerImage){ //alert(lat+'**'+lng+'**'+markerImage);
        var myLatlng = new google.maps.LatLng(lat, lng);
        var marker = new google.maps.Marker({
            position: myLatlng,
            title :  title,
            icon: markerImage
        });

        marker.setMap(Maps.objMap);
        Maps.objectsOnmap.push(marker);
        Maps.setMarkerClickHandler(marker,lat,lng,infoData);
    },

    setMarkerClickHandler: function(marker_obj, lat,lng,infoData) {

        /*
        var myHtml  = '<div class="results_text_content"><h4>';
            myHtml += title;
            myHtml += '</h4>'+venueName+'</div>';
        */
        google.maps.event.addListener(marker_obj, 'click', function() {
            Maps.infoBox.setContent(infoData);
            Maps.infoBox.open(Maps.objMap, marker_obj);
        });
    },

    redrawMarkers:function(){
        Maps.clearOverlays();
        Maps.drawRadius();
    },

    //draw the radius currently defaulted to 10
    drawRadius:function(){

        var circle = new google.maps.Circle({
            map: Maps.objMap,
            center: new google.maps.LatLng(Maps.mapCenter[0], Maps.mapCenter[1]),
            radius: 1.609344 * (Maps.mapRadius) * 1000,
            strokeOpacity: 0,
            fillColor: "#CC0000",
            fillOpacity: 0.15

        });
        Maps.objectsOnmap.push(circle);
    },

    //clear all the overlays in the map
    clearOverlays:function() {
        if (Maps.objectsOnmap) {
            for (i in Maps.objectsOnmap) {
                Maps.objectsOnmap[i].setMap(null);

            }
        }
    }

}




