<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of cls_products
 *
 * @author Asha S
 */
class Products {

    //put your code here
    // Check product already added to favourites list
    public static function getProductBasicInfo($productID, $productOptionID) {
        global $tableprefix, $pdo;

        $favourites_count = 0;

        $objResult = new stdClass();

        if (!empty($productOptionID)) {
            $QueryCartItems = "SELECT p.vdigital_product,c.gift_certificate_flag,p.product_artist_id as seller_id, p.product_name
                                        FROM " . $tableprefix . "products p
                                        INNER JOIN " . $tableprefix . "product_options po ON po.product_id = p.product_id
                                        INNER JOIN " . $tableprefix . "categories  c ON c.category_id = p.product_category
                                        WHERE p.product_id=:product_id AND po.product_option_id=:pid ";
            $resSet = $pdo->pdoQuery($QueryCartItems, array("product_id" => $productID, "pid" => $productOptionID))->results();
            $data = $resSet[0];
            if ($data) {
                $objResult->status = SUCCESS;
                $objResult->data = $data;
            } else {
                $objResult->status = ERROR;
            }
        }

        return $objResult;
    }

    // Function to check whether the product is free shipped

    public static function is_free_ship_product($productID) {

        global $pdo, $tableprefix;
        $objResult = new stdClass();
        if (!empty($productID)) {
            $selectCase = array("product_id" => $productID);
            $result = $pdo->select($tableprefix . "products", "allow_free_shipping", $selectCase)->results();
        }
        if (!empty($result)) {
            $objResult->status = SUCCESS;
            $objResult->data = $result[0]['allow_free_shipping']; // Assign user record  to object
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

    public static function check_free_ship_product_text($productID) {
        $freeShipText = '';
        if (!empty($productID)) {
            $freeshipObj = self::is_free_ship_product($productID);
            if ($freeshipObj->status == SUCCESS) {
                $FreeshipFlag = $freeshipObj->data;

                if ($FreeshipFlag == 'Y') {
                    $freeShipText = "( " . FREE_SHIP_TEXT . " )";
                }
            }
            // If user exists then assign user data to result object
        }

        return $freeShipText;
    }

    // Function to check whether the product is subscription
    public static function get_product_subscription_deatils($productID) {
        global $tableprefix, $pdo;
        $objResult = new stdClass();
        if (!empty($productID)) {
            $objResultRow = $pdo->select($tableprefix . 'products', array('allow_subscription', 'subscription_mode', 'product_artist_id'), array('product_id' => $productID))->results();
        }
        if (!empty($objResultRow)) {
            $objResult->status = SUCCESS;
            $objResult->data = $objResultRow; // Assign user record  to object
        } else {
            $objResult->status = ERROR;
        }
        return $objResult;
    }

    // Function get flat rate value

    public static function getFlatrateValue($sellerid) {
        global $tableprefix, $pdo;
        $objResult = new stdClass();

        $objResultRow = $pdo->select($tableprefix . "flat_rate_seller", '', array("seller_id" => $sellerid), "order by first_Item_charge ASC LIMIT 1")->results();
        //Check Cart Details exist for the selected  Cart ID
        if ($objResultRow) {
            $objResult->status = SUCCESS;
            $objResult->data = $objResultRow[0];
        } else {
            $objResultRow = $pdo->select($tableprefix . "flat_rate_default", '', '', 'order by first_Item_charge ASC LIMIT 1')->results();
            if ($objResultRow) {
            // Assign Cart details to object
                $objResult->status = SUCCESS;
                $objResult->data = $objResultRow[0];
            }
        }
        return $objResult;
    }

    // function to check type  is a subscription product
    // Function to check whether the product is subscription
    public static function is_subscription_product($productID) {
        return false;
    }

    // Get product count  per seller / store
    // Function to check whether the product is subscription
    public static function get_product_count_per_seller($sellerID) {
        global $tableprefix, $pdo;
        $objResult = new stdClass();
        //$tableName                      = DbHelper::setTablePrefix('products');
        if (!empty($sellerID)) {
            //$selectCase                     = "product_artist_id =".generalMethods::escapeString($sellerID);
            $objResultRow = $pdo->select($tableprefix . "products", array("COUNT(product_id) as productCount"), array("product_artist_id" => $sellerID))->results();
            //DbHelper::selectRecord($tableName,'COUNT(product_id) as productCount ',$selectCase);
            // If user exists then assign user data to result object
        }
        if (!empty($objResultRow)) {
            $objResult->status = SUCCESS;
            $objResult->data = $objResultRow[0]; // Assign user record  to object
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

    // Function to chek the count of seller products added to favorites
    public static function get_favourites_count_per_seller($sellerID) {
        global $tableprefix, $pdo;
        $objResult = new stdClass();
        //$tableName                      = DbHelper::setTablePrefix('favourites');
        if (!empty($sellerID)) {
            //$selectCase                     = "seller_id =".generalMethods::escapeString($sellerID);
            $objResultRow = $pdo->select($tableprefix . "favourites", array("COUNT(nId) as favritesCount"), array("seller_id" => $sellerID))->results();
            //DbHelper::selectRecord($tableName,'COUNT(nId) as favritesCount ',$selectCase);
            // If user exists then assign user data to result object
        }
        if (!empty($objResultRow)) {
            $objResult->status = SUCCESS;
            $objResult->data = $objResultRow[0]; // Assign user record  to object
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

    // Update seller vacation mode in product table

    public static function updateProduct_Vacation_Mode($productObjVo) {
        $objResult = new stdClass();
        $tableName = DbHelper::setTablePrefix('products');
        $where = "product_artist_id = " . generalMethods::escapeString($productObjVo->seller_id) . " ";
        $sellerId = DbHelper::update($tableName, array('seller_vacation_mode' => generalMethods::escapeString($productObjVo->seller_vacation_mode)), $where);
        if ($sellerId) {
            $objResult->status = SUCCESS;
            $objResult->data = $sellerId;
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

    // Update Favourites Vacation Mode

    public static function updateFavourites_Vacation_Mode($productObjVo) {
        $objResult = new stdClass();
        $tableName = DbHelper::setTablePrefix('favourites');
        $where = "seller_id = " . generalMethods::escapeString($productObjVo->seller_id) . " ";
        $favouriteId = DbHelper::update($tableName, array('status' => generalMethods::escapeString($productObjVo->status)), $where);
        if ($favouriteId) {
            $objResult->status = SUCCESS;
            $objResult->data = $favouriteId;
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

// Update Favourites Vacation Mode for seller

    public static function updateFavourites_Vacation_Mode_Seller($productObjVo) {
        global $tableprefix, $pdo;
        $objResult = new stdClass();
        //$tableName                           =  DbHelper::setTablePrefix('seller_favourites');
        //$where                               =  "nSellerId = ".generalMethods::escapeString($productObjVo->seller_id). " ";

        $favouriteId = $pdo->update($tableprefix . 'seller_favourites', array('status' => $productObjVo->status), array("nSellerId" => $productObjVo->seller_id))->affectedRows();
        //DbHelper::update($tableName,array('status' => generalMethods::escapeString($productObjVo->status)),$where);
        if ($favouriteId) {
            $objResult->status = SUCCESS;
            $objResult->data = $favouriteId;
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

    public static function manageSellerVacationSettingsMode($sellerbjVo) {
        $objResult = new stdClass();
        $sellerid = $sellerbjVo->seller_id;
        $samesellerItemCount = 0;
        $sellerFavItemCount = 0;

        //Remove seller cart items if vacation mode enabeled
        if ($sellerbjVo->seller_vacation_mode == 'Y') {

            $sellerCartItemCount = self::getSellerCartItems($sellerid);
            if ($sellerCartItemCount > 0) {
                $cartItems = self::remove_seller_cart_items($sellerid);
            }
        }
        //Get seller prodcts and set vacation mode
        $sellerCartObj = self::get_product_count_per_seller($sellerid);
        //echopre($sellerCartObj);
        if ($sellerCartObj->status == SUCCESS) {
            $sellerCartObjVal = $sellerCartObj->data;
            $samesellerItemCount = $sellerCartObjVal->productCount;
            if ($samesellerItemCount > 0) {
                $productObjVo = new stdClass();

                $productObjVo->seller_vacation_mode = $sellerbjVo->seller_vacation_mode;
                $productObjVo->seller_id = $sellerid;
                $sellerupdateid = self::updateProduct_Vacation_Mode($productObjVo);
            }
        }
        //get Seller favourite items added and update status
        $favouritesCartObj = self::get_favourites_count_per_seller($sellerid);
        if ($favouritesCartObj->status == SUCCESS) {
            $favouritesCartObjVal = $favouritesCartObj->data;
            $sellerFavItemCount = $favouritesCartObjVal->favritesCount;
            if ($sellerFavItemCount > 0) {
                $favouriteObjVo = new stdClass();
                if ($sellerbjVo->seller_vacation_mode == 'Y') {
                    $favouriteStatus = 'N';   // Inactive
                } else {
                    $favouriteStatus = 'Y';  // Active
                }
                $favouriteObjVo->status = $favouriteStatus;
                $favouriteObjVo->seller_id = $sellerid;
                $favcount = self::updateFavourites_Vacation_Mode($favouriteObjVo);
            }
        }
        //Update seller favorites
        $favouritesSellerCount = self::getFavoritesellerCount($sellerid);
        if ($favouritesSellerCount > 0) {
            $favouriteObjVo = new stdClass();
            if ($sellerbjVo->seller_vacation_mode == 'Y') {
                $favouriteStatus = 'N';   // Inactive
            } else {
                $favouriteStatus = 'Y';  // Active
            }
            $favouriteObjVo->status = $favouriteStatus;
            $favouriteObjVo->seller_id = $sellerid;
            $favcount = self::updateFavourites_Vacation_Mode_Seller($favouriteObjVo);
        }
    }

    public static function getFavoritesellerCount($sellerId) {

        global $tableprefix, $pdo;
        $objResult = new stdClass();
        //$tableName                      = DbHelper::setTablePrefix('seller_favourites');

        if (!empty($sellerId)) {
            //$selectCase                     = " nSellerId = ".generalMethods::escapeString($sellerId);
            $objResultRow = $pdo->select($tableprefix . "seller_favourites", array("COUNT(nId) as seller_fav_count"), array("nSellerId" => $sellerId))->results();
            //DbHelper::selectSingleValue($tableName,'COUNT(nId) as seller_fav_count',$selectCase);
            // If user exists then assign user data to result object
            return $objResultRow[0];
        }
    }

    // Remove Seller items from Cart if vacatioon mode is enabled

    public static function remove_seller_cart_items($sellerId) {
        global $tableprefix, $pdo;
        //clear the seller product from carts table
        //$where                          = "seller_id = ".$sellerId;
        //$tableName                      = DbHelper::setTablePrefix('cart');
        $objResultRow = $pdo->delete($tableprefix . "cart", array("seller_id" => $sellerId))->affectedRows();
        //DbHelper::delete($tableName,$where);
    //
    }

    // Get default option id of the product

    public static function getDefaultProductOptionId($productid) {
        global $tableprefix, $pdo;
        $objResult = new stdClass();
               
        if (!empty($productid)) {
            
            $objResultRow =$pdo->select($tableprefix."product_options",array("product_option_id"),array("product_id"=>$productid, 'default_option' => 'YES'))->result();
            // If user exists then assign user data to result object
            return $objResultRow;
        }
    }

    public static function getProductOptionStock($product_option_id) {
        $objResult = new stdClass();
        global $tableprefix, $pdo;
        if (!empty($product_option_id)) {
            $pdo->select($tableprefix."product_options",array("product_stock"),array("product_option_id"=>$product_option_id))->results();
            return $objResultRow[0]['product_stock'];
        }
    }

    // function to get product seller id
    public static function getProductSellerId($productid) {
        $objResult = new stdClass();
        global $tableprefix, $pdo;
        $productid = strip_tags(trim($productid));
        if (!empty($productid)) {
            $selectCase = " product_id =" . generalMethods::escapeString($productid) . " ";
            $objResultRow = $pdo->select($tableprefix."products",array("product_artist_id"),array("product_id"=>$productid))->results();
            return $objResultRow[0]['product_artist_id'];
        }
    }

    //*********************** Multicart Scalabity Modifications Statrt ****************************************
    //
    //Function to get Product Defalut option Valuses

    public static function getProduct_Default_Option_Values($productid) {
        global $tableprefix, $pdo;
        $objResult = new stdClass();
        $productid = strip_tags(trim($productid));
        if (!empty($productid)) {
            $objResultRow = $pdo->select($tableprefix . "product_options", "", array("product_id" => $productid, "default_option" => 'YES'))->result();
            return (object)$objResultRow;
        }
    }

    //Update Product default option image

    public static function updateProduct_Default_Option_Image($productObjVo) {
        global $tableprefix, $pdo;
        $objResult = new stdClass();
        $tableName = DbHelper::setTablePrefix('products');
        $productStock = self::getAllProductStock($productObjVo->product_id);
        $sellerName = self::getProduct_Seller_UserName($productObjVo->product_id);
        $where = "product_id = " . generalMethods::escapeString($productObjVo->product_id) . " ";
        $productId = DbHelper::update($tableName, array('default_image_small' => generalMethods::escapeString($productObjVo->default_image_small)), $where);

        if ($productId) {
            $objResult->status = SUCCESS;
            $objResult->data = $productId;
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

    //Update Product default option Values

    public static function updateProduct_Default_Option_Value($productObjVo) {
        global $tableprefix, $pdo;
        $objResult = new stdClass();
        $productStock = self::getAllProductStock($productObjVo->product_id);
        $sellerName = self::getProduct_Seller_UserName($productObjVo->product_id);

        //$where                               = "product_id = ".generalMethods::escapeString($productObjVo->product_id)." ";
        $data = array(
            'default_image_small' => ($productObjVo->default_image_small),
            'default_stock' => ($productStock),
            'default_additional_price' => ($productObjVo->default_additional_price),
            'default_shipping_weight' => ($productObjVo->default_shipping_weight),
            'default_discount' => ($productObjVo->default_discount),
            'default_discount_description' => ($productObjVo->default_discount_description),
            'seller_name' => ($sellerName),
            'default_option_id' => ($productObjVo->default_option_id));
        $productId = $pdo->update($tableprefix . 'products', $data, array("product_id" => $productObjVo->product_id))->affectedRows();
        if ($productId) {
            $objResult->status = SUCCESS;
            $objResult->data = $productId;
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

    // Get Sum of product stock
    public static function getAllProductStock($productid) {
        global $tableprefix, $pdo;
        $objResult = new stdClass();
        $productid = strip_tags(trim($productid));
        if (!empty($productid)) {
            $sql = "select sum(product_stock) as productStock from " . $tableprefix . "product_options where product_id=:productid";
            $objResultRow = $pdo->pdoQuery($sql, array("productid" => $productid))->results();
            return $objResultRow[0];
        }
    }

    // Get product seller user name
    public static function getProduct_Seller_UserName($productid) {
        global $tableprefix, $pdo;
        $productid = strip_tags(trim($productid));
        if (!empty($productid)) {
            $QueryCartItems = "SELECT s.artist_name FROM " . $tableprefix . "products p INNER JOIN " . $tableprefix . "artists s ON s.artist_id = p.product_artist_id WHERE p.product_id =:productid ";
            $resSet = $pdo->pdoQuery($QueryCartItems, array("productid" => $productid))->results();
            $data = ($resSet[0]);
            return $data['artist_name'];
        }
    }

    // Function to return the default product listing query

    public static function getProduct_list_Query($featured = '', $order = '') {
        global $tableprefix;

        $productListingFee = getSettingsValue('product_listing_fee');
        $whereCondition = '';
        $sql = "SELECT p.*, (p.product_price + p.default_additional_price) AS product_price, po.product_stock FROM " . $tableprefix . "products p INNER JOIN ".
                $tableprefix . "artists a ON a.artist_id = p.product_artist_id INNER JOIN ".
                $tableprefix . "product_options po ON po.product_id = p.product_id 
                where p.vapproved = 'Y' ";

        $whereCondition.=" AND p.deleted='N' AND a.plan_expired = 'N' ";  // check deleted status
        $whereCondition.=" AND p.publish_status='Y' ";  // check published status
        $whereCondition.=" AND p.seller_vacation_mode='N' ";  // check seller vacation ode settings
        $whereCondition.=" AND p.vSellerStatus='Y' ";  // check seller approved or plan expiry status
        $whereCondition.=" AND po.default_option = 'YES' ";
        if ($productListingFee > 0) {
            $whereCondition .= " AND p.payment_status='COMPLETED' ";  // Check seller payment completed
        }
        if ($featured == 'Y') {
            $whereCondition .= " AND p.featured='Y' ";
        }

        if (!empty($order)) {
            $orderBy = " ORDER BY p." . $order;
        }

        $sql = $sql . $whereCondition . $orderBy;

        return $sql;
    }

    //Update  prodct table stock

    public static function updateProduct_Stock($productid, $quantity, $prefix = NULL) {
        global $tableprefix, $pdo;
        $tableprefix = $tableprefix != '' ? $tableprefix : $prefix;
        $sqlUpdate = "UPDATE  " . $tableprefix . "products SET default_stock = (default_stock -". $quantity.") where product_id='" . $productid . "' ";
        $resSet = $pdo->pdoQuery($sqlUpdate);
        return 1;
    }

    //Update product seller status in product tbale if seller deactivated / deleted / planexpired

    public static function updateProductSellerStatus($productObjVo) {
        $objResult = new stdClass();
        $tableName = DbHelper::setTablePrefix('products');
        $where = "product_artist_id = " . generalMethods::escapeString($productObjVo->seller_id) . " ";
        $productId = DbHelper::update($tableName, array('vSellerStatus' => generalMethods::escapeString($productObjVo->seller_vacation_mode)), $where);
        if ($productId) {
            $objResult->status = SUCCESS;
            $objResult->data = $productId;
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

    //

    public static function getProduct_list_Join_Search_Query() {
        global $tableprefix,$pdo;

        $productListingFee = getSettingsValue('product_listing_fee');
        $whereCondition = '';
        $sql = "SELECT p.*, (p.product_price + p.default_additional_price) AS product_price FROM " . $tableprefix . "products p
                            INNER JOIN " . $tableprefix . "artists s ON s.artist_id =p.product_artist_id where p.vapproved = 'Y' ";
        $whereCondition.=" AND p.deleted='N' AND s.plan_expired ='N' ";  // check deleted status
        $whereCondition.=" AND p.publish_status='Y' ";  // check published status
        $whereCondition.=" AND p.seller_vacation_mode='N' ";  // check seller vacation ode settings
        $whereCondition.=" AND p.vSellerStatus='Y' ";  // check seller approved or plan expiry status
        if ($productListingFee > 0) {
            $whereCondition .= " AND p.payment_status='COMPLETED' ";  // Check seller payment completed
        }
        $sql = $sql . $whereCondition;
        return $sql;
    }

    public static function getProduct_list_Join_Search_Query_Count($featured = '', $order = '') {
        global $tableprefix,$pdo;

        $productListingFee = getSettingsValue('product_listing_fee');
        $whereCondition = '';
        $sql = "SELECT count(p.product_id) as cnt FROM " . $tableprefix . "products p
                            INNER JOIN " . $tableprefix . "artists s ON s.artist_id =p.product_artist_id where p.vapproved = 'Y' ";
        $whereCondition.=" AND p.deleted='N' AND s.plan_expired = 'N' ";  // check deleted status
        $whereCondition.=" AND p.publish_status='Y' ";  // check published status
        $whereCondition.=" AND p.seller_vacation_mode='N' ";  // check seller vacation ode settings
        $whereCondition.=" AND p.vSellerStatus='Y' ";  // check seller approved or plan expiry status
        if ($productListingFee > 0) {
            $whereCondition .= " AND p.payment_status='COMPLETED' ";  // Check seller payment completed
        }
        $sql = $sql . $whereCondition . $orderBy;

        return $sql;
    }

    public static function getProduct_list_Seller($sellerId) {
        global $tableprefix, $pdo;
        $objResult = new stdClass();
        //$tableName = DbHelper::setTablePrefix('products');
        $product_list = '';
        if ($sellerId != '') {
            //$where = "product_artist_id = " . generalMethods::escapeString($sellerId);
            $objResultRow = $pdo->select($tableprefix . "products", array("product_id", "product_name"), array("product_artist_id" => $sellerId))->results();
            //DbHelper::selectResult($tableName, 'product_id,product_name', $where);

            foreach ($objResultRow as $value) {
                $product_list[$value['product_id']] = $value['product_name'];
            }
        }
        return $product_list;
    }

    public static function getCategory_list_Seller($sellerId) {
        global $tableprefix, $pdo;
        $objResult = new stdClass();
        //$productsTable = DbHelper::setTablePrefix('products');
        //$categoryTable = DbHelper::setTablePrefix('categories');
        $category_list = '';
        if ($sellerId != '') {
            //$where = " product_artist_id = " . generalMethods::escapeString($sellerId);
            $objResultRow = $pdo->select($tableprefix . "products", array("DISTINCT(product_category)"), array("product_artist_id" => $sellerId))->results();
            //DbHelper::selectResult($productsTable, 'DISTINCT(product_category)', $where);
            if (!empty($objResultRow)) {
                foreach ($objResultRow as $value) {
                    $categories[] = $value['product_category'];
                }
                $category_ids = implode(",", $categories);
                list($qarr, $qstr) = getInQueryString($category_ids);
                $where2 = "SELECT category_id,category_name FROM ".$tableprefix."categories WHERE category_id IN (" . $qstr . ")";
                $objResult = $pdo->pdoQuery($where2, $qarr)->results();
                if (!empty($objResult)) {
                    foreach ($objResult as $value) {
                        $category_list[$value['category_id']] = $value['category_name'];
                    }
                }
            }
        }
        return $category_list;
    }

    public static function getProduct_list_QueryCount($featured = '') {
        global $tableprefix;

        $productListingFee = getSettingsValue('product_listing_fee');
        $whereCondition = '';
        $sql = "SELECT count(product_id)as productCount FROM " . $tableprefix . "products p where p.vapproved = 'Y' ";
        $whereCondition.=" AND p.deleted='N' ";  // check deleted status
        $whereCondition.=" AND p.publish_status='Y' ";  // check published status
        $whereCondition.=" AND p.seller_vacation_mode='N' ";  // check seller vacation ode settings
        $whereCondition.=" AND p.vSellerStatus='Y' ";  // check seller approved or plan expiry status
        if ($productListingFee > 0) {
            $whereCondition .= " AND p.payment_status='COMPLETED' ";  // Check seller payment completed
        }
        if ($featured == 'Y') {
            $whereCondition .= " AND p.featured='Y' ";
        }


        $sql = $sql . $whereCondition . $orderBy;

        return $sql;
    }

    public static function getSellerCartItems($sellerid) {
        global $tableprefix, $pdo;
        $objResultRow = $pdo->select($tableprefix."cart",array("count(cart_id)as cartCount"),array("seller_id"=>$sellerid))->results();
        if(!empty($objResultRow)) return $objResultRow[0]['cartCount'];
        return 0;
    }

    public static function chekProductOptionsExist($productid) {
        global $tableprefix, $pdo;
        $objResultRow = $pdo->select($tableprefix."product_options",array("product_option_id"),array("product_id"=>$productid,"default_option"=>'YES'))->results();
        if(!empty($objResultRow)) return $objResultRow[0]['product_option_id'];
        return 0;
    }

     public static function removeProductOptions($product_option_id) {
        global $tableprefix, $pdo;
        $objResultRow = $pdo->delete($tableprefix."product_options",'',array("product_option_id"=>$product_option_id));
    }

    public static function getCategoryHierarchy($txtSearch, $categoryid = '', $category_list) {
        global $tableprefix, $pdo;
        if ($categoryid == "")
            $where = array('category_name LIKE'=>"%".$txtSearch."%");
        else
            $where = array('parent_id'=>$categoryid);
        $objResult = new stdClass();
        $objResultRow = $pdo->select($tableprefix."categories",array("category_id"),$where)->results();
        if (empty($objResultRow)) {
            return $category_list;
        }
        foreach ($objResultRow as $val) {   //echo $val->category_id;
            array_push($category_list, $val['category_id']);
            $category_list = Products::getCategoryHierarchy($txtSearch, $val['category_id'], $category_list);                       //print_r($category_list);exit;
        }
        return $category_list;
    }

    public static function getAllParentCategoryList() {
        global $tableprefix, $pdo;
        $objResultRow = $pdo->select($tableprefix."categories",array("category_id,category_name"),array("parent_id"=>0,"gift_certificate_flag !="=>"Y"))->results();

        return $objResultRow;
    }

    public static function getCategoryChild($id) {
        global $tableprefix, $pdo;
        $objResultRow = $pdo->select($tableprefix."categories",array("category_id,category_name"),array("parent_id"=>$id))->results();
        $children = array();
        if (!empty($objResultRow)) {
            foreach ($objResultRow as $row) {
                $children[$row['category_id']]['name'] = $row['category_name'];
                $children[$row['category_id']]['id'] = $row['category_id'];
                $arr = self::getCategoryChild($row['category_id']);
                if (count($arr) > 0) {
                    $children[$row['category_id']]['child'] = self::getCategoryChild($row['category_id']);
                }
            }
        }
        return $children;
    }




    public static function getOptionsCount($product_id) {
        global $tableprefix, $pdo;
        if (!empty($product_id)) {
            $selectCase = array("product_id"=>$product_id,"default_option"=>'NO');
         $objResultRow =  $pdo->select($tableprefix."product_options",array("count(product_option_id) as OptionsCount"),$selectCase)->results();
         if(!empty($objResultRow)) return $objResultRow[0]['OptionsCount'];
        }
        return '';
    }

    public static function getCategoryOptionsValues($categoryId) {
        global $tableprefix, $pdo;
        $objResultRow = $pdo->select($tableprefix."category_options",array("option_id"),array("category_id"=>$categoryId))->results();
        if(!empty($objResultRow))
            return $objResultRow;
        else array();
    }

    public static function updateCancelledQuantityToProductStock($productid, $product_option_id, $quantity, $prefix = NULL) {
        global $tableprefix, $pdo;

        //Check the Option is default option
        $default_option_id = self::getDefaultProductOptionId($productid);

        //Update Products Default Stock
        if ($default_option_id == $product_option_id) {
            self::updateCancelledQuantityToProductDefaultStock($productid, $quantity);
        }
        
        $query = "update ".$tableprefix."product_options set product_stock = product_stock + ".$quantity." where product_option_id = ".$product_option_id;
        $resSet = $pdo->pdoQuery($query);
    }

    public static function updateCancelledQuantityToProductDefaultStock($productid, $quantity, $prefix = NULL) {
        global $tableprefix,$pdo;
        $tableprefix = $tableprefix != '' ? $tableprefix : $prefix;
        $query = "update ".$tableprefix."products set default_stock = default_stock + ".$quantity." where product_id = ".$productid;
        $sqlUpdate = $pdo->pdoQuery($query);
    }

    public static function getProductInfo($productid) {
        global $tableprefix,$pdo;
        $andCase = array();
        if ($productid != '')
            $andCase= array("product_id"=>$productid);
        $objResultRow = $pdo->select($tableprefix."products",'',$andCase)->results();
        if(!empty($objResultRow)) return $objResultRow[0];
        return $objResultRow;
    }

}
